Rem
Rem $Header: audit_tables.sql 10-aug-2007.11:03:05 pshishir Exp $
Rem
Rem audit_tables.sql
Rem
Rem Copyright (c) 2007, Oracle.  All rights reserved.  
Rem
Rem    NAME
Rem      audit_tables.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    pshishir    08/10/07 - Created
Rem

-- MGMT_AUDIT_CUSTOM_ATTRIBS table stores the basic information about the 
-- custom attributes register by end user. It stores attribute_name, 
-- display name, description and mandatory requirement of custom attributes 

CREATE TABLE MGMT_AUDIT_CUSTOM_ATTRIBS
(
    ca_name         VARCHAR2(256)   DEFAULT NULL,
    ca_display_name VARCHAR2(256)   DEFAULT NULL,
    ca_description  VARCHAR2(4000)  DEFAULT NULL,
    ca_required     NUMBER (1)      DEFAULT 0,
    CONSTRAINT MGMT_AUDIT_CUSTOM_ATTRIBS_PK PRIMARY KEY(ca_name)
)
MONITORING;

COMMENT ON TABLE MGMT_AUDIT_CUSTOM_ATTRIBS IS
    'This table stores the audit custom attributes name and its details';

COMMENT ON COLUMN MGMT_AUDIT_CUSTOM_ATTRIBS.ca_name IS
    'Name that uniquely identifies the custom attribute.';

COMMENT ON COLUMN MGMT_AUDIT_CUSTOM_ATTRIBS.ca_display_name IS
    'The display name of custom attributes.';

COMMENT ON COLUMN MGMT_AUDIT_CUSTOM_ATTRIBS.ca_required IS
    'This column is used to check whether the custom attribute 
     is mandatory or not. By default, this is not a mandatory field
     and the Value = 0, Value = 1 if it is mandatory.';

ALTER TABLE mgmt_user_session ADD
( ca_name_1                 VARCHAR2(256)  DEFAULT NULL,
  ca_value_1                VARCHAR2(4000) DEFAULT NULL,
  ca_name_2                 VARCHAR2(256)  DEFAULT NULL,
  ca_value_2                VARCHAR2(4000) DEFAULT NULL,
  ca_name_3                 VARCHAR2(256)  DEFAULT NULL,
  ca_value_3                VARCHAR2(4000) DEFAULT NULL
);

