Rem drv: <migrate type="data_upgrade" version="10.2.0.4"/>
Rem
Rem $Header: emcore/source/oracle/sysman/emdrep/sql/core/10.2.0.4/basic/basic_data_upgrade.sql /st_emcore_10.2.0.4.1db11/1 2008/08/01 11:06:40 edemembe Exp $
Rem
Rem basic_data_upgrade.sql
Rem
Rem Copyright (c) 2007, 2008, Oracle. All rights reserved.
Rem
Rem    NAME
Rem      basic_data_upgrade.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    edemembe    07/30/08 - Bug 7286326
Rem    skini       10/05/07 - Add commit
Rem    skini       10/04/07 - Qualify EM_REPOS_USER
Rem    skini       10/04/07 - Submit DBMS_JOB in data upgrade
Rem    dgiaimo     04/30/07 - Changing 10.2.4.0 to 10.2.0.4
Rem    aptrived    02/26/07 - Bug#5152908
Rem    aptrived    02/26/07 - Created
Rem

-- Add targets_delete table as a delete exception.
DECLARE
 del_exceptions SMP_EMD_STRING_ARRAY := SMP_EMD_STRING_ARRAY();
BEGIN
 -- Add deletion exceptions here
 del_exceptions.extend(1);
 del_exceptions(1) := 'MGMT_METRICS_1DAY';
 MGMT_ADMIN.add_target_deletion_exceptions(del_exceptions);
 COMMIT;
END;
/

-- Compress comp key index online via dbms_job
DECLARE
l_job_num NUMBER;
l_job_name VARCHAR2(200) := '&EM_REPOS_USER' || '.emd_maintenance.compress_index(''MGMT_METRICS_COMP_KEYS_PK'',1,true);';
l_database_role VARCHAR2(32);
BEGIN
    -- Check to see if this database is in logical standby mode.  If it is
    -- we need to exit this script because logical standby doesn't support 
    -- DBMS_JOBS.
    BEGIN   
      SELECT database_role into l_database_role
         from v$database where database_role like '%LOGICAL%';
    EXCEPTION
    WHEN NO_DATA_FOUND THEN
       DBMS_JOB.SUBMIT(l_job_num, l_job_name, SYSDATE+1, NULL);
       COMMIT;
    END;
END; 
/
