Rem No headers
Rem
Rem $Header: fix_inventory_outofbox_job.sql 12-jul-2007.09:56:21 makarapu Exp $
Rem
Rem fix_inventory_outofbox_job.sql
Rem
Rem Copyright (c) 2005, 2006, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      fix_inventory_outofbox_job.sql - <one-line expansion of the name>
Rem
Rem
Rem    DESCRIPTION
Rem      Script to add the 'FixInventoryJob' job in the repository.
Rem
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    makarapu    12/22/06 - Switching EM user context to SYS
Rem    makarapu    09/20/06 - Backport makarapu_bug-5511590 from main
Rem    makarapu    09/04/06 - Making it system job
Rem    makarapu    01/29/06 - Created
Rem

REM This script will add the 'FixInventory' job in the repository.

set define off

declare
p_job_targets MGMT_JOB_TARGET_LIST := MGMT_JOB_TARGET_LIST();
p_job_params MGMT_JOB_PARAM_LIST := MGMT_JOB_PARAM_LIST();
p_purge_criterion_list MGMT_JOB_PURGE_CRITERION_LIST;
p_mgmt_job_vector MGMT_JOB_VECTOR_PARAMS;
p_schedule MGMT_JOB_SCHEDULE_RECORD;
p_bind_var_index NUMBER;
p_execution raw(16);
p_job raw(16);
p_job_name VARCHAR2(64);
p_purge_policy_name VARCHAR2(64);
l_current_user MGMT_CREATED_USERS.user_name%TYPE := MGMT_USER.get_current_em_user;
l_job_id MGMT_JOB.job_id%TYPE;
l_job_owner MGMT_JOB.job_owner%TYPE;

BEGIN
-- Create a schedule to run the job daily.
p_schedule := mgmt_jobs.get_job_schedule_record( MGMT_JOBS.DAILY_FREQUENCY_CODE, null, null, 0, 0, 1, null, null, 1, 0, 0, null);
--p_schedule := mgmt_jobs.get_immediate_schedule_record;
p_job_name := 'FIX INVENTORY';
p_purge_policy_name := 'FixInventoryPurgePolicy';

  BEGIN
      SELECT job_id, job_owner 
      INTO   l_job_id, l_job_owner
      FROM   MGMT_JOB
      WHERE  upper(job_name) = p_job_name;
      
      MGMT_JOB_ENGINE.stop_all_executions_with_id(l_job_id, true);
      
      -- Stopping a system job deletes it too.
      --  just to be safe try to delete it again
      BEGIN
          MGMT_JOBS.delete_job(p_job_name, l_job_owner,1,0);
      EXCEPTION 
         WHEN OTHERS THEN 
         NULL;
      END;
  EXCEPTION
      WHEN NO_DATA_FOUND THEN 
      NULL;
  END;


SETEMUSERCONTEXT(MGMT_USER.GET_REPOSITORY_OWNER, MGMT_USER.OP_SET_IDENTIFIER);

BEGIN
mgmt_jobs.submit_job(p_job_name ,'Out Of The Box Job to  enhance Oracle Inventory Collection Mechanisms (10.2.0.4.0)','FixInventory', p_job_targets,p_job_params,p_schedule,p_job,p_execution,null,MGMT_JOB_ENGINE.SYSTEM_JOB,null,null);
EXCEPTION  WHEN OTHERS  THEN
    dbms_output.put_line('Unable to submit' || p_job_name );
END;


-- We are going to purge the job on job type.
p_mgmt_job_vector := MGMT_JOB_VECTOR_PARAMS('FixInventory');

-- Create a purge criteria to purge the job on Job_type
p_purge_criterion_list := MGMT_JOB_PURGE_CRITERION_LIST(MGMT_JOB_PURGE_CRITERION(2, 0, p_mgmt_job_vector, null));


-- Clean a purge policy if it exists
BEGIN
    MGMT_JOB_ENGINE.drop_purge_policy(p_purge_policy_name);
    EXCEPTION
    WHEN OTHERS  THEN
        NULL;
END;
-- Register the purge policy to purge the job executions which are more than a week old and which
-- satisfy the purge criteria created above.
MGMT_JOB_ENGINE.register_purge_policy(p_purge_policy_name , 7, p_purge_criterion_list);

SETEMUSERCONTEXT(l_current_user, MGMT_USER.OP_SET_IDENTIFIER);

EXCEPTION
    WHEN OTHERS THEN
    SETEMUSERCONTEXT(l_current_user, MGMT_USER.OP_SET_IDENTIFIER);
    RAISE;
END;
/

set define on

commit;
