Rem DO NOT ADD ANY HEADERS TO THIS FILE AS THIS IS BEING CALLED FROM THE UPGRADE / LATEST PATHS
Rem
Rem $Header: license_post_creation.sql 20-sep-2007.01:20:54 ararora Exp $
Rem
Rem license_post_creation.sql
Rem
Rem Copyright (c) 2007, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      license_post_creation.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    xshen       08/28/07 - add data masking pack
Rem    ararora     09/06/07 - New Definitions Bug: 6396626
Rem    ckannusa    07/26/07 - Add Oracel BI License Pack and Exchange Pack
Rem    denath      06/07/07 - Backport Bug 5919144 from Main.
Rem    dgiaimo     04/26/07 - Changing 10.2.4.0 to 10.2.0.4
Rem    dgiaimo     04/30/07 - Backport dgiaimo_bug-6014523 from main
Rem    sradhakr    04/15/07 - RFI BACKPORT OF Bug 5848810 FOR INCLUSION IN
Rem                           10.2.0.4 (RFI #54592).
Rem    vmotamar    03/29/07 - Bug No 5756461
Rem                           Dis-associating oracle_processconnect_domain from Licensing Framework
Rem    smudumba    03/06/07 - Post Creation License Script for 10.2.4.0.0
Rem                           upgrade
Rem    smudumba    03/06/07 - Created
Rem

BEGIN
    -- Dis-associate the target type "oracle_processconnect_domain" from Licensing Framework"
    -- Bug No 5756461
    DELETE mgmt_licensable_target_types
    WHERE target_type='oracle_processconnect_domain';
    
-- Register Packs STARTS
    em_license.add_packs(p_pack_name => 'identity_mgmt');

    em_license.add_packs(p_pack_name => 'db_sadm');    

    em_license.add_packs(p_pack_name => 'mon_bi'); 
-- Register Packs ENDS

-- Register Licensable Target type STARTS
    em_license.add_licensable_target_types
    (
       P_PACK_TARGET_TYPE => 'microsoft_exchange',
       P_TARGET_TYPE => 'microsoft_exchange'
    ); 
    em_license.add_licensable_target_types
    (
       P_PACK_TARGET_TYPE => 'oracle_bi_ans',
       P_TARGET_TYPE => 'oracle_bi_ans'
    );    
    em_license.add_licensable_target_types
    (
       P_PACK_TARGET_TYPE => 'oracle_bi_cc',
       P_TARGET_TYPE => 'oracle_bi_cc'
    ); 
    em_license.add_licensable_target_types
    (
       P_PACK_TARGET_TYPE => 'oracle_bi_ps',
       P_TARGET_TYPE => 'oracle_bi_ps'
    ); 
    em_license.add_licensable_target_types
    (
       P_PACK_TARGET_TYPE => 'oracle_bi_sch',
       P_TARGET_TYPE => 'oracle_bi_sch'
    ); 
    em_license.add_licensable_target_types
    (
       P_PACK_TARGET_TYPE => 'oracle_bi_dac',
       P_TARGET_TYPE => 'oracle_bi_dac'
    ); 
    em_license.add_licensable_target_types
    (
       P_PACK_TARGET_TYPE => 'oracle_bi_suite',
       P_TARGET_TYPE => 'oracle_bi_suite'
    ); 

    em_license.add_licensable_target_types
    (
       P_PACK_TARGET_TYPE => 'coreid_access_sys',
       P_TARGET_TYPE => 'coreid_access_sys'
    );

    em_license.add_licensable_target_types
    (
       P_PACK_TARGET_TYPE => 'oracle_coreid_access_server',
       P_TARGET_TYPE => 'oracle_coreid_access_server'
    );

    em_license.add_licensable_target_types
    (
       P_PACK_TARGET_TYPE => 'oracle_coreid_identity_server',
       P_TARGET_TYPE => 'oracle_coreid_identity_server'
    );

    em_license.add_licensable_target_types
    (
       P_PACK_TARGET_TYPE => 'oracle_idm_system',
       P_TARGET_TYPE => 'oracle_idm_system'
    );

    em_license.add_licensable_target_types
    (
       P_PACK_TARGET_TYPE => 'oracle_idm_repos',
       P_TARGET_TYPE => 'oracle_idm_repos'
    );

    em_license.add_licensable_target_types
    (
       P_PACK_TARGET_TYPE => 'oracle_idm_server',
       P_TARGET_TYPE => 'oracle_idm_server'
    );

    em_license.add_licensable_target_types
    (
       P_PACK_TARGET_TYPE => 'oracle_federation',
       P_TARGET_TYPE => 'oracle_federation'
    );

    em_license.add_licensable_target_types
    (
       P_PACK_TARGET_TYPE => 'oracle_federation_sys',
       P_TARGET_TYPE => 'oracle_federation_sys'
    );

    em_license.add_licensable_target_types
    (
       P_PACK_TARGET_TYPE => 'coreid_identity_sys',
       P_TARGET_TYPE => 'coreid_identity_sys'
    );

-- Register Licensable Target type ENDS

-- Register Pack Definition for as_config
    em_license.add_pack_definitions
    (
        p_pack_label         => 'as_config'  ,
        p_target_type        => 'oracle_ias'  ,
        p_pack_display_label => 'Application Server Configuration Management Pack',
        p_pack_description   => 'Automates the time-consuming and often error prone process of software and hardware configuration and deployments. This pack provides capabilities such as search and compare across all systems, configuration monitoring, policy management, and comprehensive reporting.  The Configuration Management Pack includes:<br><li>Automated discovery of application server configuration and underlying host/OS configuration</li><li>View and analyze application server and underlying host/OS installation/configuration</li><li>Configuration change tracking</li><li>Search configuration</li><li>Compare configuration</li><li>Manage policies and policy notifications</li><li>Critical Patch Advisory</li><li>Security at a Glance</li><li>Configuration reports</li><li>Repository tables/views that store/expose the above data</li>' ,
        p_pack_abbr          => 'AC'  
    );

-- Register Pack Definition for as_diag

    em_license.add_pack_definitions
    (
        p_pack_label         => 'as_diag'  ,
        p_target_type        => 'oracle_ias'  ,
        p_pack_display_label => 'Application Server Diagnostics Pack',
        p_pack_description   => 'Offers a complete, cost-effective, and easy to use solution for managing the performance of Oracle Application Server environments by providing unique functionality such as automatic identification of performance bottlenecks, guided problem resolution, and comprehensive system monitoring.  The Diagnostics Pack includes:<br><li>Root cause diagnostics of Java application performance issues</li><li>Historical performance monitoring and trending (Application Server and Host target)</li><li>Monitoring of JMX/Web Services endpoints hosted on the Oracle Application Server</li><li>Event/Alert Notifications: Notification Methods, Rules and Schedules</li><li>Event/Alert history/metric history (Application Server and Host target)</li><li>User-defined metrics</li><li>Blackouts/Planned Outages</li><li>Monitoring templates</li><li>Corrective actions (including response actions)</li><li>Metric Snapshots</li><li>Real end user performance monitoring</li><li>End to end tracing with middle tier and database drill downs (database SQL level diagnostics requires Diagnostics Pack for Oracle Database)</li><li>Component request diagnostics</li><li>Diagnostic, Performance and Event reports</li><li>Repository tables/views that store/expose the above data</li>' ,
        p_pack_abbr          => 'AD'  
    );

-- Register Pack Definition for db_chgmgt
    em_license.add_pack_definitions
    (
        p_pack_label         => 'db_chgmgt'  ,
        p_target_type        => 'oracle_database'  ,
        p_pack_display_label => 'Database Configuration Management Pack',
        p_pack_description   => '<dl>Gives database administrators the ability to evaluate, plan for and implement database schema changes to support new application requirements without error and data loss while minimizing downtime. The Change Management Pack includes:<dt><li>Capture database and schema definitions (baselines)</dt><dt><li>Compare</dt><dd><li type=\"circle\">Baseline with database</dd><dd><li type=\"circle\">Database with database</dd><dd><li type=\"circle\">Schema with schema</dd><dt><li>Synchronize databases</dt><dt><li>Propagate changes</dt></dl>' ,
        p_pack_abbr          => 'CM'  
    );
    em_license.add_pack_definitions
    (
        p_pack_label         => 'db_chgmgt'  ,
        p_target_type        => 'osm_instance'  ,
        p_pack_display_label => 'Database Configuration Management Pack',
        p_pack_description   => '<dl>Gives database administrators the ability to evaluate, plan for and implement database schema changes to support new application requirements without error and data loss while minimizing downtime. The Change Management Pack includes:<dt><li>Capture database and schema definitions (baselines)</dt><dt><li>Compare</dt><dd><li type=\"circle\">Baseline with database</dd><dd><li type=\"circle\">Database with database</dd><dd><li type=\"circle\">Schema with schema</dd><dt><li>Synchronize databases</dt><dt><li>Propagate changes</dt></dl>' ,
        p_pack_abbr          => 'CM'  
    );
    em_license.add_pack_definitions
    (
        p_pack_label         => 'db_chgmgt'  ,
        p_target_type        => 'rac_database'  ,
        p_pack_display_label => 'Database Configuration Management Pack',
        p_pack_description   => '<dl>Gives database administrators the ability to evaluate, plan for and implement database schema changes to support new application requirements without error and data loss while minimizing downtime. The Change Management Pack includes:<dt><li>Capture database and schema definitions (baselines)</dt><dt><li>Compare</dt><dd><li type=\"circle\">Baseline with database</dd><dd><li type=\"circle\">Database with database</dd><dd><li type=\"circle\">Schema with schema</dd><dt><li>Synchronize databases</dt><dt><li>Propagate changes</dt></dl>' ,
        p_pack_abbr          => 'CM'  
    );

-- Register Pack Definition for db_config
    em_license.add_pack_definitions
    (
        p_pack_label         => 'db_config'  ,
        p_target_type        => 'osm_instance'  ,
        p_pack_display_label => 'Database Configuration Management Pack',
        p_pack_description   => 'Automates the time-consuming and often error prone process of software and hardware configuration and deployments. This pack provides capabilities such as search and compare across all systems, configuration monitoring, policy management and compliance support, security configuration scoring and dashboards, and comprehensive reporting.  The Configuration Management Pack includes:<li>View and analyze database and host configuration</li><li>View and analyze database and host deployments/installations</li><li>Configuration change tracking</li><li>Search configuration</li><li>Compare configuration</li><li>Manage policies and policy notifications</li><li>Compliance Dashboard</li><li>Policy Groups</li><li>Critical Patch Advisory</li><li>Security at a Glance</li><li>Configuration reports</li><li>Repository tables/views that store/expose the above data</li>' ,
        p_pack_abbr          => 'DC'  
    );
    em_license.add_pack_definitions
    (
        p_pack_label         => 'db_config'  ,
        p_target_type        => 'oracle_database'  ,
        p_pack_display_label => 'Database Configuration Management Pack',
        p_pack_description   => 'Automates the time-consuming and often error prone process of software and hardware configuration and deployments. This pack provides capabilities such as search and compare across all systems, configuration monitoring, policy management and compliance support, security configuration scoring and dashboards, and comprehensive reporting.  The Configuration Management Pack includes:<li>View and analyze database and host configuration</li><li>View and analyze database and host deployments/installations</li><li>Configuration change tracking</li><li>Search configuration</li><li>Compare configuration</li><li>Manage policies and policy notifications</li><li>Compliance Dashboard</li><li>Policy Groups</li><li>Critical Patch Advisory</li><li>Security at a Glance</li><li>Configuration reports</li><li>Repository tables/views that store/expose the above data</li>' ,
        p_pack_abbr          => 'DC'  
    );
    em_license.add_pack_definitions
    (
        p_pack_label         => 'db_config'  ,
        p_target_type        => 'rac_database'  ,
        p_pack_display_label => 'Database Configuration Management Pack',
        p_pack_description   => 'Automates the time-consuming and often error prone process of software and hardware configuration and deployments. This pack provides capabilities such as search and compare across all systems, configuration monitoring, policy management and compliance support, security configuration scoring and dashboards, and comprehensive reporting.  The Configuration Management Pack includes:<li>View and analyze database and host configuration</li><li>View and analyze database and host deployments/installations</li><li>Configuration change tracking</li><li>Search configuration</li><li>Compare configuration</li><li>Manage policies and policy notifications</li><li>Compliance Dashboard</li><li>Policy Groups</li><li>Critical Patch Advisory</li><li>Security at a Glance</li><li>Configuration reports</li><li>Repository tables/views that store/expose the above data</li>' ,
        p_pack_abbr          => 'DC'  
    );

-- Register Pack Definition for db_diag
    em_license.add_pack_definitions
    (
        p_pack_label         => 'db_diag'  ,
        p_target_type        => 'osm_instance'  ,
        p_pack_display_label => 'Database Diagnostics Pack',
        p_pack_description   => 'Offers a complete, cost-effective, and easy to use solution for managing the performance of Oracle Database environments by providing unique functionality such as automatic identification of performance bottlenecks, guided problem resolution, and comprehensive system monitoring. The Diagnostics Pack includes:<li>Historical performance monitoring and trending (Database, RAC, Host and Cluster target)</li><li>RAC/Cluster Interconnect monitoring</li><li>ADDM (Automated Database Diagnostic Monitor)</li><li>Automatic Workload Repository</li><li>Event/Alert Notifications: Notification Methods, Rules and Schedules</li><li>Event/Alert history/metric history (Database, RAC, Host and Cluster target)</li><li>User-defined metrics</li><li>Blackouts/Planned Outages</li><li>Monitoring templates</li><li>Corrective actions (including response actions)</li><li>Adaptive metric thresholds</li><li>Metric Baselines</li><li>Memory Access Mode</li><li>Diagnostic, Performance and Event reports</li><li>Database and repository tables/views/apis that store/expose the above data</li>' ,
        p_pack_abbr          => 'DD'  
    );
    em_license.add_pack_definitions
    (
        p_pack_label         => 'db_diag'  ,
        p_target_type        => 'oracle_database'  ,
        p_pack_display_label => 'Database Diagnostics Pack',
        p_pack_description   => 'Offers a complete, cost-effective, and easy to use solution for managing the performance of Oracle Database environments by providing unique functionality such as automatic identification of performance bottlenecks, guided problem resolution, and comprehensive system monitoring. The Diagnostics Pack includes:<li>Historical performance monitoring and trending (Database, RAC, Host and Cluster target)</li><li>RAC/Cluster Interconnect monitoring</li><li>ADDM (Automated Database Diagnostic Monitor)</li><li>Automatic Workload Repository</li><li>Event/Alert Notifications: Notification Methods, Rules and Schedules</li><li>Event/Alert history/metric history (Database, RAC, Host and Cluster target)</li><li>User-defined metrics</li><li>Blackouts/Planned Outages</li><li>Monitoring templates</li><li>Corrective actions (including response actions)</li><li>Adaptive metric thresholds</li><li>Metric Baselines</li><li>Memory Access Mode</li><li>Diagnostic, Performance and Event reports</li><li>Database and repository tables/views/apis that store/expose the above data</li>' ,
        p_pack_abbr          => 'DD'  
    );
    em_license.add_pack_definitions
    (
        p_pack_label         => 'db_diag'  ,
        p_target_type        => 'rac_database'  ,
        p_pack_display_label => 'Database Diagnostics Pack',
        p_pack_description   => 'Offers a complete, cost-effective, and easy to use solution for managing the performance of Oracle Database environments by providing unique functionality such as automatic identification of performance bottlenecks, guided problem resolution, and comprehensive system monitoring. The Diagnostics Pack includes:<li>Historical performance monitoring and trending (Database, RAC, Host and Cluster target)</li><li>RAC/Cluster Interconnect monitoring</li><li>ADDM (Automated Database Diagnostic Monitor)</li><li>Automatic Workload Repository</li><li>Event/Alert Notifications: Notification Methods, Rules and Schedules</li><li>Event/Alert history/metric history (Database, RAC, Host and Cluster target)</li><li>User-defined metrics</li><li>Blackouts/Planned Outages</li><li>Monitoring templates</li><li>Corrective actions (including response actions)</li><li>Adaptive metric thresholds</li><li>Metric Baselines</li><li>Memory Access Mode</li><li>Diagnostic, Performance and Event reports</li><li>Database and repository tables/views/apis that store/expose the above data</li>' ,
        p_pack_abbr          => 'DD'  
    );

-- Register Pack Definition for db_tuning

    em_license.add_pack_definitions
    (
        p_pack_label         => 'db_tuning'  ,
        p_target_type        => 'osm_instance'  ,
        p_pack_display_label => 'Database Tuning Pack',
        p_pack_description   => 'Offers a set of new, groundbreaking technologies that automate the entire application tuning process, thereby significantly lowering database management costs while enhancing performance and reliability.  The Tuning Pack includes:<li>SQL Access Advisor</li><li>SQL Tuning Advisor</li><li>SQL Tuning Sets</li><li>Reorganize Objects</li><br>Note:  Tuning Pack requires license for Diagnostics Pack for Oracle Database.' ,
        p_pack_abbr          => 'DT'  
    );
    em_license.add_pack_definitions
    (
        p_pack_label         => 'db_tuning'  ,
        p_target_type        => 'oracle_database'  ,
        p_pack_display_label => 'Database Tuning Pack',
        p_pack_description   => 'Offers a set of new, groundbreaking technologies that automate the entire application tuning process, thereby significantly lowering database management costs while enhancing performance and reliability.  The Tuning Pack includes:<li>SQL Access Advisor</li><li>SQL Tuning Advisor</li><li>SQL Tuning Sets</li><li>Reorganize Objects</li><br>Note:  Tuning Pack requires license for Diagnostics Pack for Oracle Database.' ,
        p_pack_abbr          => 'DT'  
    );
    em_license.add_pack_definitions
    (
        p_pack_label         => 'db_tuning'  ,
        p_target_type        => 'rac_database'  ,
        p_pack_display_label => 'Database Tuning Pack',
        p_pack_description   => 'Offers a set of new, groundbreaking technologies that automate the entire application tuning process, thereby significantly lowering database management costs while enhancing performance and reliability.  The Tuning Pack includes:<li>SQL Access Advisor</li><li>SQL Tuning Advisor</li><li>SQL Tuning Sets</li><li>Reorganize Objects</li><br>Note:  Tuning Pack requires license for Diagnostics Pack for Oracle Database.' ,
        p_pack_abbr          => 'DT'  
    );

-- Register Pack Definition for identity_mgmt

    em_license.add_pack_definitions
    (
        p_pack_label         => 'identity_mgmt'  ,
        p_target_type        => 'coreid_identity_sys'  ,
        p_pack_display_label => 'Identity Management Pack',
        p_pack_description   => 'Enables enterprises to proactively monitor the availability, performance, load, and security metrics of Identity servers. Administrators can monitor Identity service transaction performance externally from the end-user perspective, define service levels on Identity Services, and track service levels in real time.',
        p_pack_abbr          => 'IDM'
    );

    em_license.add_pack_definitions
    (
        p_pack_label         => 'identity_mgmt'  ,
        p_target_type        => 'coreid_access_sys'  ,
        p_pack_display_label => 'Identity Management Pack',
        p_pack_description   => 'Enables enterprises to proactively monitor the availability, performance, load, and security metrics of Identity servers. Administrators can monitor Identity service transaction performance externally from the end-user perspective, define service levels on Identity Services, and track service levels in real time.',
        p_pack_abbr          => 'IDM'
    );


    em_license.add_pack_definitions
    (
        p_pack_label         => 'identity_mgmt'  ,
        p_target_type        => 'oracle_coreid_access_server'  ,
        p_pack_display_label => 'Identity Management Pack',
        p_pack_description   => 'Enables enterprises to proactively monitor the availability, performance, load, and security metrics of Identity servers. Administrators can monitor Identity service transaction performance externally from the end-user perspective, define service levels on Identity Services, and track service levels in real time.',
        p_pack_abbr          => 'IDM'
    );


    em_license.add_pack_definitions
    (
        p_pack_label         => 'identity_mgmt'  ,
        p_target_type        => 'oracle_coreid_identity_server'  ,
        p_pack_display_label => 'Identity Management Pack',
        p_pack_description   => 'Enables enterprises to proactively monitor the availability, performance, load, and security metrics of Identity servers. Administrators can monitor Identity service transaction performance externally from the end-user perspective, define service levels on Identity Services, and track service levels in real time.',
        p_pack_abbr          => 'IDM'
    );

    em_license.add_pack_definitions
    (
        p_pack_label         => 'identity_mgmt'  ,
        p_target_type        => 'oracle_idm_system'  ,
        p_pack_display_label => 'Identity Management Pack',
        p_pack_description   => 'Enables enterprises to proactively monitor the availability, performance, load, and security metrics of Identity servers. Administrators can monitor Identity service transaction performance externally from the end-user perspective, define service levels on Identity Services, and track service levels in real time.',
        p_pack_abbr          => 'IDM'
    );

    em_license.add_pack_definitions
    (
        p_pack_label         => 'identity_mgmt'  ,
        p_target_type        => 'oracle_idm_repos'  ,
        p_pack_display_label => 'Identity Management Pack',
        p_pack_description   => 'Enables enterprises to proactively monitor the availability, performance, load, and security metrics of Identity servers. Administrators can monitor Identity service transaction performance externally from the end-user perspective, define service levels on Identity Services, and track service levels in real time.',
        p_pack_abbr          => 'IDM'
    );

    em_license.add_pack_definitions
    (
        p_pack_label         => 'identity_mgmt'  ,
        p_target_type        => 'oracle_idm_server'  ,
        p_pack_display_label => 'Identity Management Pack',
        p_pack_description   => 'Enables enterprises to proactively monitor the availability, performance, load, and security metrics of Identity servers. Administrators can monitor Identity service transaction performance externally from the end-user perspective, define service levels on Identity Services, and track service levels in real time.',
        p_pack_abbr          => 'IDM'
    );

    em_license.add_pack_definitions
    (
        p_pack_label         => 'identity_mgmt'  ,
        p_target_type        => 'oracle_federation_sys' ,
        p_pack_display_label => 'Identity Management Pack',
        p_pack_description   => 'Enables enterprises to proactively monitor the availability, performance, load, and security metrics of Identity servers. Administrators can monitor Identity service transaction performance externally from the end-user perspective, define service levels on Identity Services, and track service levels in real time.',
        p_pack_abbr          => 'IDM'
    );

    em_license.add_pack_definitions
    (
        p_pack_label         => 'identity_mgmt'  ,
        p_target_type        => 'oracle_federation' ,
        p_pack_display_label => 'Identity Management Pack',
        p_pack_description   => 'Enables enterprises to proactively monitor the availability, performance, load, and security metrics of Identity servers. Administrators can monitor Identity service transaction performance externally from the end-user perspective, define service levels on Identity Services, and track service levels in real time.',
        p_pack_abbr          => 'IDM'
    );

-- Register Pack Definition for mon_bi

    em_license.add_pack_definitions
    (
        p_pack_label         => 'mon_bi'  ,
        p_target_type        => 'oracle_bi_ans'  ,
        p_pack_display_label => 'Oracle BI Management Pack',
        p_pack_description   => 'Provides monitoring and management of Oracle BI Components (Presentation Server, Cluster Controller, Analytics Server, Scheduler and DAC Server). The Oracle BI Management Pack includes:<li>Availability and monitoring of all components</li><li>Process control</li><li>Dashboard monitoring</li><li>Configuration Management</li>' ,
        p_pack_abbr          => 'OBIM'  
    );

    em_license.add_pack_definitions
    (
        p_pack_label         => 'mon_bi'  ,
        p_target_type        => 'oracle_bi_cc'  ,
        p_pack_display_label => 'Oracle BI Management Pack',
        p_pack_description   => 'Provides monitoring and management of Oracle BI Components (Presentation Server, Cluster Controller, Analytics Server, Scheduler and DAC Server). The Oracle BI Management Pack includes:<li>Availability and monitoring of all components</li><li>Process control</li><li>Dashboard monitoring</li><li>Configuration Management</li>' ,
        p_pack_abbr          => 'OBIM'  
    );

    
    em_license.add_pack_definitions
    (
        p_pack_label         => 'mon_bi'  ,
        p_target_type        => 'oracle_bi_ps'  ,
        p_pack_display_label => 'Oracle BI Management Pack',
        p_pack_description   => 'Provides monitoring and management of Oracle BI Components (Presentation Server, Cluster Controller, Analytics Server, Scheduler and DAC Server). The Oracle BI Management Pack includes:<li>Availability and monitoring of all components</li><li>Process control</li><li>Dashboard monitoring</li><li>Configuration Management</li>' ,
        p_pack_abbr          => 'OBIM'  
    );

    em_license.add_pack_definitions
    (
        p_pack_label         => 'mon_bi'  ,
        p_target_type        => 'oracle_bi_sch'  ,
        p_pack_display_label => 'Oracle BI Management Pack',
        p_pack_description   => 'Provides monitoring and management of Oracle BI Components (Presentation Server, Cluster Controller, Analytics Server, Scheduler and DAC Server). The Oracle BI Management Pack includes:<li>Availability and monitoring of all components</li><li>Process control</li><li>Dashboard monitoring</li><li>Configuration Management</li>' ,
        p_pack_abbr          => 'OBIM'  
    );

    em_license.add_pack_definitions
    (
        p_pack_label         => 'mon_bi'  ,
        p_target_type        => 'oracle_bi_dac'  ,
        p_pack_display_label => 'Oracle BI Management Pack',
        p_pack_description   => 'Provides monitoring and management of Oracle BI Components (Presentation Server, Cluster Controller, Analytics Server, Scheduler and DAC Server). The Oracle BI Management Pack includes:<li>Availability and monitoring of all components</li><li>Process control</li><li>Dashboard monitoring</li><li>Configuration Management</li>' ,
        p_pack_abbr          => 'OBIM'  
    );

    em_license.add_pack_definitions
    (
        p_pack_label         => 'mon_bi'  ,
        p_target_type        => 'oracle_bi_suite'  ,
        p_pack_display_label => 'Oracle BI Management Pack',
        p_pack_description   => 'Provides monitoring and management of Oracle BI Components (Presentation Server, Cluster Controller, Analytics Server, Scheduler and DAC Server). The Oracle BI Management Pack includes:<li>Availability and monitoring of all components</li><li>Process control</li><li>Dashboard monitoring</li><li>Configuration Management</li>' ,
        p_pack_abbr          => 'OBIM'  
    );

 
-- Register Pack Definition for provisioning
    
    em_license.add_pack_definitions
    (
        p_pack_label         => 'provisioning'  ,
        p_target_type        => 'oracle_database'  ,
        p_pack_display_label => 'Provisioning Pack',
        p_pack_description   => 'Automates deployment of software, applications, and patches. This pack provides functionality for bare metal provisioning of operating systems and software images, cloning of existing installations and software images (such as CRS/RAC and AS), and patching. The Provisioning Pack includes:<li>Software Image Library</li><li>Database and Oracle Home cloning</li><li>Database, RAC, Application Server, and Application provisioning</li><li>Extend Cluster and Add Instance</li><li>Single instance-to-RAC conversion</li><li>Bare metal provisioning</li><li>Deployment Procedure Manager</li><li>Automate patching (including staging) for Oracle software, Oracle Homes and operating systems</li><li>Critical Patch Facility</li><li>Enterprise Security Advisories</li><li>Provisioning and deployment reports</li>' ,
        p_pack_abbr          => 'PV'  
    );
    em_license.add_pack_definitions
    (
        p_pack_label         => 'provisioning'  ,
        p_target_type        => 'oracle_ias'  ,
        p_pack_display_label => 'Provisioning Pack',
        p_pack_description   => 'Automates deployment of software, applications, and patches. This pack provides functionality for bare metal provisioning of operating systems and software images, cloning of existing installations and software images (such as CRS/RAC and AS), and patching. The Provisioning Pack includes:<li>Software Image Library</li><li>Database and Oracle Home cloning</li><li>Database, RAC, Application Server, and Application provisioning</li><li>Extend Cluster and Add Instance</li><li>Single instance-to-RAC conversion</li><li>Bare metal provisioning</li><li>Deployment Procedure Manager</li><li>Automate patching (including staging) for Oracle software, Oracle Homes and operating systems</li><li>Critical Patch Facility</li><li>Enterprise Security Advisories</li><li>Provisioning and deployment reports</li>' ,
        p_pack_abbr          => 'PV'  
    );
    em_license.add_pack_definitions
    (
        p_pack_label         => 'provisioning'  ,
        p_target_type        => 'host'  ,
        p_pack_display_label => 'Provisioning Pack',
        p_pack_description   => 'Automates deployment of software, applications, and patches. This pack provides functionality for bare metal provisioning of operating systems and software images, cloning of existing installations and software images (such as CRS/RAC and AS), and patching. The Provisioning Pack includes:<li>Software Image Library</li><li>Database and Oracle Home cloning</li><li>Database, RAC, Application Server, and Application provisioning</li><li>Extend Cluster and Add Instance</li><li>Single instance-to-RAC conversion</li><li>Bare metal provisioning</li><li>Deployment Procedure Manager</li><li>Automate patching (including staging) for Oracle software, Oracle Homes and operating systems</li><li>Critical Patch Facility</li><li>Enterprise Security Advisories</li><li>Provisioning and deployment reports</li>' ,
        p_pack_abbr          => 'PV'  
    );
    em_license.add_pack_definitions
    (
        p_pack_label         => 'provisioning'  ,
        p_target_type        => 'cluster'  ,
        p_pack_display_label => 'Provisioning Pack',
        p_pack_description   => 'Automates deployment of software, applications, and patches. This pack provides functionality for bare metal provisioning of operating systems and software images, cloning of existing installations and software images (such as CRS/RAC and AS), and patching. The Provisioning Pack includes:<li>Software Image Library</li><li>Database and Oracle Home cloning</li><li>Database, RAC, Application Server, and Application provisioning</li><li>Extend Cluster and Add Instance</li><li>Single instance-to-RAC conversion</li><li>Bare metal provisioning</li><li>Deployment Procedure Manager</li><li>Automate patching (including staging) for Oracle software, Oracle Homes and operating systems</li><li>Critical Patch Facility</li><li>Enterprise Security Advisories</li><li>Provisioning and deployment reports</li>' ,
        p_pack_abbr          => 'PV'  
    );
    em_license.add_pack_definitions
    (
        p_pack_label         => 'provisioning'  ,
        p_target_type        => 'rac_database'  ,
        p_pack_display_label => 'Provisioning Pack',
        p_pack_description   => 'Automates deployment of software, applications, and patches. This pack provides functionality for bare metal provisioning of operating systems and software images, cloning of existing installations and software images (such as CRS/RAC and AS), and patching. The Provisioning Pack includes:<li>Software Image Library</li><li>Database and Oracle Home cloning</li><li>Database, RAC, Application Server, and Application provisioning</li><li>Extend Cluster and Add Instance</li><li>Single instance-to-RAC conversion</li><li>Bare metal provisioning</li><li>Deployment Procedure Manager</li><li>Automate patching (including staging) for Oracle software, Oracle Homes and operating systems</li><li>Critical Patch Facility</li><li>Enterprise Security Advisories</li><li>Provisioning and deployment reports</li>' ,
        p_pack_abbr          => 'PV'  
    );
    em_license.add_pack_definitions
    (
        p_pack_label         => 'provisioning'  ,
        p_target_type        => 'osm_instance'  ,
        p_pack_display_label => 'Provisioning Pack',
        p_pack_description   => 'Automates deployment of software, applications, and patches. This pack provides functionality for bare metal provisioning of operating systems and software images, cloning of existing installations and software images (such as CRS/RAC and AS), and patching. The Provisioning Pack includes:<li>Software Image Library</li><li>Database and Oracle Home cloning</li><li>Database, RAC, Application Server, and Application provisioning</li><li>Extend Cluster and Add Instance</li><li>Single instance-to-RAC conversion</li><li>Bare metal provisioning</li><li>Deployment Procedure Manager</li><li>Automate patching (including staging) for Oracle software, Oracle Homes and operating systems</li><li>Critical Patch Facility</li><li>Enterprise Security Advisories</li><li>Provisioning and deployment reports</li>' ,
        p_pack_abbr          => 'PV'  
    );

-- Register Pack Definition for service_level_mgmt

    em_license.add_pack_definitions
    (  
        p_pack_label         => 'service_level_mgmt'  ,
        p_target_type        => 'formsapp'  , 
        p_pack_display_label => 'Service Level Management Pack',
        p_pack_description   => 'Delivers functionality to actively monitor and report on availability and performance of critical applications (services and web applications), sites, and infrastructure components using synthetic transactions executed from remote sites (beacons).  The Service Level Management Pack includes:<li>Automated creation of system and service for deployed applications</li><li>Change tracking history of system membership</li><li>Service availability, performance and usage tests (for all test types)</li><li>Beacons for running tests</li><li>Service Level Rules</li><li>Service Monitoring: Historical performance and Events/Alerts</li><li>Metric Snapshots</li><li>Metric Baselines</li><li>Monitoring Templates</li><li>Monitor Forms application availability, performance, usage, and service level compliance</li><li>Service Level Reports</li><li>Repository tables/views that store/expose the above data</li>' ,
        p_pack_abbr          => 'SLM'
    );

    em_license.add_pack_definitions
    (  
        p_pack_label         => 'service_level_mgmt'  ,
        p_target_type        => 'oracle_forms'  , 
        p_pack_display_label => 'Service Level Management Pack',
        p_pack_description   => 'Delivers functionality to actively monitor and report on availability and performance of critical applications (services and web applications), sites, and infrastructure components using synthetic transactions executed from remote sites (beacons).  The Service Level Management Pack includes:<li>Automated creation of system and service for deployed applications</li><li>Change tracking history of system membership</li><li>Service availability, performance and usage tests (for all test types)</li><li>Beacons for running tests</li><li>Service Level Rules</li><li>Service Monitoring: Historical performance and Events/Alerts</li><li>Metric Snapshots</li><li>Metric Baselines</li><li>Monitoring Templates</li><li>Monitor Forms application availability, performance, usage, and service level compliance</li><li>Service Level Reports</li><li>Repository tables/views that store/expose the above data</li>' ,
        p_pack_abbr          => 'SLM'
    );

    em_license.add_pack_definitions
    (  
        p_pack_label         => 'service_level_mgmt'  ,
        p_target_type        => 'website'  , 
        p_pack_display_label => 'Service Level Management Pack',
        p_pack_description   => 'Delivers functionality to actively monitor and report on availability and performance of critical applications (services and web applications), sites, and infrastructure components using synthetic transactions executed from remote sites (beacons).  The Service Level Management Pack includes:<li>Automated creation of system and service for deployed applications</li><li>Change tracking history of system membership</li><li>Service availability, performance and usage tests (for all test types)</li><li>Beacons for running tests</li><li>Service Level Rules</li><li>Service Monitoring: Historical performance and Events/Alerts</li><li>Metric Snapshots</li><li>Metric Baselines</li><li>Monitoring Templates</li><li>Monitor Forms application availability, performance, usage, and service level compliance</li><li>Service Level Reports</li><li>Repository tables/views that store/expose the above data</li>' ,
        p_pack_abbr          => 'SLM'
    );

    em_license.add_pack_definitions
    (  
        p_pack_label         => 'service_level_mgmt'  ,
        p_target_type        => 'generic_service'  , 
        p_pack_display_label => 'Service Level Management Pack',
        p_pack_description   => 'Delivers functionality to actively monitor and report on availability and performance of critical applications (services and web applications), sites, and infrastructure components using synthetic transactions executed from remote sites (beacons).  The Service Level Management Pack includes:<li>Automated creation of system and service for deployed applications</li><li>Change tracking history of system membership</li><li>Service availability, performance and usage tests (for all test types)</li><li>Beacons for running tests</li><li>Service Level Rules</li><li>Service Monitoring: Historical performance and Events/Alerts</li><li>Metric Snapshots</li><li>Metric Baselines</li><li>Monitoring Templates</li><li>Monitor Forms application availability, performance, usage, and service level compliance</li><li>Service Level Reports</li><li>Repository tables/views that store/expose the above data</li>' ,
        p_pack_abbr          => 'SLM'
    );

    em_license.add_pack_definitions
    (  
        p_pack_label         => 'service_level_mgmt'  ,
        p_target_type        => 'oracle_beacon'  , 
        p_pack_display_label => 'Service Level Management Pack',
        p_pack_description   => 'Delivers functionality to actively monitor and report on availability and performance of critical applications (services and web applications), sites, and infrastructure components using synthetic transactions executed from remote sites (beacons).  The Service Level Management Pack includes:<li>Automated creation of system and service for deployed applications</li><li>Change tracking history of system membership</li><li>Service availability, performance and usage tests (for all test types)</li><li>Beacons for running tests</li><li>Service Level Rules</li><li>Service Monitoring: Historical performance and Events/Alerts</li><li>Metric Snapshots</li><li>Metric Baselines</li><li>Monitoring Templates</li><li>Monitor Forms application availability, performance, usage, and service level compliance</li><li>Service Level Reports</li><li>Repository tables/views that store/expose the above data</li>' ,
        p_pack_abbr          => 'SLM'
    );


-- Register Pack Definition for nd_smp

    em_license.add_pack_definitions
    (   
        p_pack_label         => 'nd_smp'  ,
        p_target_type        => 'juniper_netscreen_firewall'  ,
        p_pack_display_label => 'Enterprise Manager System Monitoring Plug-in for Network Devices',
        p_pack_description   => 'Provides performance and availability data collection, real-time and historical monitoring, event management/monitoring, notifications, and performance reporting for network devices. This plug-in includes:<li>Real-time and historical performance monitoring and trending (Network Device target)</li><li>Event management/monitoring (Network Device target)</li><li>Event/Alert Notifications: Notification Methods, Rules and Schedules</li><li>Event/Alert history/metric history (Network Device target)</li><li>Metric Snapshots</li><li>Blackouts/Planned Outages</li><li>Monitoring templates</li><li>Corrective actions (including response actions)</li><li>Performance and Event reports</li><li>Viewing and comparing configuration data, as well as tracking configuration changes (Network Device target)</li><li>Repository tables/views that store/expose the above data</li><li>Monitoring network devices via remote Management Agent. For remote monitoring, the Management Agent does not need to be on the same machine as the network device.</li>' ,
        p_pack_abbr          => 'SMND'
    );

    em_license.add_pack_definitions
    (   
        p_pack_label         => 'nd_smp'  ,
        p_target_type        => 'f5_bigip_v9plus_loadbalancer'  ,
        p_pack_display_label => 'Enterprise Manager System Monitoring Plug-in for Network Devices',
        p_pack_description   => 'Provides performance and availability data collection, real-time and historical monitoring, event management/monitoring, notifications, and performance reporting for network devices. This plug-in includes:<li>Real-time and historical performance monitoring and trending (Network Device target)</li><li>Event management/monitoring (Network Device target)</li><li>Event/Alert Notifications: Notification Methods, Rules and Schedules</li><li>Event/Alert history/metric history (Network Device target)</li><li>Metric Snapshots</li><li>Blackouts/Planned Outages</li><li>Monitoring templates</li><li>Corrective actions (including response actions)</li><li>Performance and Event reports</li><li>Viewing and comparing configuration data, as well as tracking configuration changes (Network Device target)</li><li>Repository tables/views that store/expose the above data</li><li>Monitoring network devices via remote Management Agent. For remote monitoring, the Management Agent does not need to be on the same machine as the network device.</li>' ,
        p_pack_abbr          => 'SMND'
    );

    em_license.add_pack_definitions
    (   
        p_pack_label         => 'nd_smp'  ,
        p_target_type        => 'slb'  ,
        p_pack_display_label => 'Enterprise Manager System Monitoring Plug-in for Network Devices',
        p_pack_description   => 'Provides performance and availability data collection, real-time and historical monitoring, event management/monitoring, notifications, and performance reporting for network devices. This plug-in includes:<li>Real-time and historical performance monitoring and trending (Network Device target)</li><li>Event management/monitoring (Network Device target)</li><li>Event/Alert Notifications: Notification Methods, Rules and Schedules</li><li>Event/Alert history/metric history (Network Device target)</li><li>Metric Snapshots</li><li>Blackouts/Planned Outages</li><li>Monitoring templates</li><li>Corrective actions (including response actions)</li><li>Performance and Event reports</li><li>Viewing and comparing configuration data, as well as tracking configuration changes (Network Device target)</li><li>Repository tables/views that store/expose the above data</li><li>Monitoring network devices via remote Management Agent. For remote monitoring, the Management Agent does not need to be on the same machine as the network device.</li>' ,
        p_pack_abbr          => 'SMND'
    );

    em_license.add_pack_definitions
    (   
        p_pack_label         => 'nd_smp'  ,
        p_target_type        => 'checkpoint_firewall'  ,
        p_pack_display_label => 'Enterprise Manager System Monitoring Plug-in for Network Devices',
        p_pack_description   => 'Provides performance and availability data collection, real-time and historical monitoring, event management/monitoring, notifications, and performance reporting for network devices. This plug-in includes:<li>Real-time and historical performance monitoring and trending (Network Device target)</li><li>Event management/monitoring (Network Device target)</li><li>Event/Alert Notifications: Notification Methods, Rules and Schedules</li><li>Event/Alert history/metric history (Network Device target)</li><li>Metric Snapshots</li><li>Blackouts/Planned Outages</li><li>Monitoring templates</li><li>Corrective actions (including response actions)</li><li>Performance and Event reports</li><li>Viewing and comparing configuration data, as well as tracking configuration changes (Network Device target)</li><li>Repository tables/views that store/expose the above data</li><li>Monitoring network devices via remote Management Agent. For remote monitoring, the Management Agent does not need to be on the same machine as the network device.</li>' ,
        p_pack_abbr          => 'SMND'
    );

-- Register Pack Definition for nom_smp
    em_license.add_pack_definitions
    (
        p_pack_label         => 'nom_smp'  ,
        p_target_type        => 'microsoft_exchange'  ,
        p_pack_display_label => 'Enterprise Manager System Monitoring Plug-in for Non-Oracle Middleware',
        p_pack_description   => 'Provides performance and availability data collection, real-time and historical monitoring, event management/monitoring, notifications, and performance reporting for non-Oracle middleware.  This plug-in includes:<li>Real-time and historical performance monitoring and trending (Non-Oracle Middleware target)<li>Event management/monitoring (Non-Oracle Middleware target)<li>Event/Alert Notifications: Notification Methods, Rules and Schedules<li>Event/Alert history/metric history (Non-Oracle Middleware target)<li>Metric Snapshots<li>Blackouts/Planned Outages<li>Monitoring templates<li>Corrective actions (including response actions)<li>Performance and Event reports<li>Viewing and comparing configuration data, as well as tracking configuration changes (Microsoft Active Directory and Microsoft Internet Information Services targets)<li>Repository tables/views that store/expose the above data<li>Monitor non-Oracle middleware software via remote Management Agent.  For remote monitoring, the Management Agent does not need to be on the same host as the non-Oracle middleware software.' ,
        p_pack_abbr          => 'SMNOM'
    );

    em_license.add_pack_definitions
    (
        p_pack_label         => 'nom_smp'  ,
        p_target_type        => 'weblogic_j2eeserver'  ,
        p_pack_display_label => 'Enterprise Manager System Monitoring Plug-in for Non-Oracle Middleware',
        p_pack_description   => 'Provides performance and availability data collection, real-time and historical monitoring, event management/monitoring, notifications, and performance reporting for non-Oracle middleware.  This plug-in includes:<li>Real-time and historical performance monitoring and trending (Non-Oracle Middleware target)<li>Event management/monitoring (Non-Oracle Middleware target)<li>Event/Alert Notifications: Notification Methods, Rules and Schedules<li>Event/Alert history/metric history (Non-Oracle Middleware target)<li>Metric Snapshots<li>Blackouts/Planned Outages<li>Monitoring templates<li>Corrective actions (including response actions)<li>Performance and Event reports<li>Viewing and comparing configuration data, as well as tracking configuration changes (Microsoft Active Directory and Microsoft Internet Information Services targets)<li>Repository tables/views that store/expose the above data<li>Monitor non-Oracle middleware software via remote Management Agent.  For remote monitoring, the Management Agent does not need to be on the same host as the non-Oracle middleware software.' ,
        p_pack_abbr          => 'SMNOM'
    );


    em_license.add_pack_definitions
    (
        p_pack_label         => 'nom_smp'  ,
        p_target_type        => 'websphere_j2eeserver'  ,
        p_pack_display_label => 'Enterprise Manager System Monitoring Plug-in for Non-Oracle Middleware',
        p_pack_description   => 'Provides performance and availability data collection, real-time and historical monitoring, event management/monitoring, notifications, and performance reporting for non-Oracle middleware.  This plug-in includes:<li>Real-time and historical performance monitoring and trending (Non-Oracle Middleware target)<li>Event management/monitoring (Non-Oracle Middleware target)<li>Event/Alert Notifications: Notification Methods, Rules and Schedules<li>Event/Alert history/metric history (Non-Oracle Middleware target)<li>Metric Snapshots<li>Blackouts/Planned Outages<li>Monitoring templates<li>Corrective actions (including response actions)<li>Performance and Event reports<li>Viewing and comparing configuration data, as well as tracking configuration changes (Microsoft Active Directory and Microsoft Internet Information Services targets)<li>Repository tables/views that store/expose the above data<li>Monitor non-Oracle middleware software via remote Management Agent.  For remote monitoring, the Management Agent does not need to be on the same host as the non-Oracle middleware software.' ,
        p_pack_abbr          => 'SMNOM'
    );
    
-- Register Pack Definition for nos_config

    em_license.add_pack_definitions
    (
        p_pack_label         => 'nos_config'  ,
        p_target_type        => 'host'  ,
        p_pack_display_label => 'Configuration Management Pack for Non-Oracle Systems',
        p_pack_description   => 'Automates the time-consuming and often error prone process of software and hardware configuration and deployments on systems not running Oracle software. This pack provides capabilities such as search and compare across all systems, configuration monitoring, policy management and compliance support, security configuration scoring and dashboards, and comprehensive reporting.  The Configuration Management Pack includes:<li>View and analyze configuration</li><li>View and analyze deployments/installations</li><li>Search configuration</li><li>Compare configuration</li><li>Client System Analyzer</li><li>Manage policies and policy notifications</li><li>Security at a Glance</li><li>Configuration reports</li><li>Repository tables/views that store/expose the above data</li>' ,
        p_pack_abbr          => 'CMNOS'  
    );

    em_license.add_pack_definitions
    (
        p_pack_label         => 'nos_config'  ,
        p_target_type        => 'cluster'  ,
        p_pack_display_label => 'Configuration Management Pack for Non-Oracle Systems',
        p_pack_description   => 'Automates the time-consuming and often error prone process of software and hardware configuration and deployments on systems not running Oracle software. This pack provides capabilities such as search and compare across all systems, configuration monitoring, policy management and compliance support, security configuration scoring and dashboards, and comprehensive reporting.  The Configuration Management Pack includes:<li>View and analyze configuration</li><li>View and analyze deployments/installations</li><li>Search configuration</li><li>Compare configuration</li><li>Client System Analyzer</li><li>Manage policies and policy notifications</li><li>Security at a Glance</li><li>Configuration reports</li><li>Repository tables/views that store/expose the above data</li>' ,
        p_pack_abbr          => 'CMNOS'
    );

-- Register Pack Definition for host_smp
   
    em_license.add_pack_definitions
    (
        p_pack_label         => 'host_smp'  ,
        p_target_type        => 'host'  ,
        p_pack_display_label => 'Enterprise Manager System Monitoring Plug-in for Hosts',
        p_pack_description   => 'Provides performance and availability data collection, real-time and historical monitoring, event management/monitoring, notifications, and performance reporting for host systems.  This plug-in includes:<li>Real-time and historical performance monitoring and trending (Host target)</li><li>Event management/monitoring (Host target)</li><li>Event/Alert Notifications: Notification Methods, Rules and Schedules</li><li>Event/Alert history/metric history (Host target)</li><li>User-defined metrics</li><li>Metric Snapshots</li><li>Blackouts/Planned Outages</li><li>Monitoring templates</li><li>Corrective actions (including response actions)</li><li>Performance and Event reports</li><li>Repository tables/views that store/expose the above data</li>' ,
        p_pack_abbr          => 'SMH'
    );

    em_license.add_pack_definitions
    (
        p_pack_label         => 'host_smp'  ,
        p_target_type        => 'cluster'  ,
        p_pack_display_label => 'Enterprise Manager System Monitoring Plug-in for Hosts',
        p_pack_description   => 'Provides performance and availability data collection, real-time and historical monitoring, event management/monitoring, notifications, and performance reporting for host systems.  This plug-in includes:<li>Real-time and historical performance monitoring and trending (Host target)</li><li>Event management/monitoring (Host target)</li><li>Event/Alert Notifications: Notification Methods, Rules and Schedules</li><li>Event/Alert history/metric history (Host target)</li><li>User-defined metrics</li><li>Metric Snapshots</li><li>Blackouts/Planned Outages</li><li>Monitoring templates</li><li>Corrective actions (including response actions)</li><li>Performance and Event reports</li><li>Repository tables/views that store/expose the above data</li>' ,
        p_pack_abbr          => 'SMH'
    );

-- Register Pack Definition for nodb_smp
    em_license.add_pack_definitions
    (
        p_pack_label         => 'nodb_smp'  ,
        p_target_type        => 'microsoft_sqlserver_database'  ,
        p_pack_display_label => 'Enterprise Manager System Monitoring Plug-in for Non-Oracle Databases',
        p_pack_description   => 'Provides performance and availability data collection, real-time and historical monitoring, event management/monitoring, notifications, and performance reporting for non-Oracle databases.  This plug-in includes:<li>Real-time and historical performance monitoring and trending (Non-Oracle Database target)<li>Event management/monitoring (Non-Oracle Database target)<li>Event/Alert Notifications: Notification Methods, Rules and Schedules<li>Event/Alert history/metric history (Non-Oracle Database target)<li>Metric Snapshots<li>Blackouts/Planned Outages<li>Monitoring templates<li>Corrective actions (including response actions)<li>Performance and Event reports<li>Viewing and comparing configuration data, as well as tracking configuration changes (Non-Oracle Database target)<li>Repository tables/views that store/expose the above data<li>Monitoring non-Oracle database software via remote Management Agent. For remote monitoring, the Management Agent does not need to be on the same host as the non-Oracle database software.' ,
        p_pack_abbr          => 'SMNOD'
    );
    em_license.add_pack_definitions
    (
        p_pack_label         => 'nodb_smp'  ,
        p_target_type        => 'ibm_db2_database'  ,
        p_pack_display_label => 'Enterprise Manager System Monitoring Plug-in for Non-Oracle Databases',
        p_pack_description   => 'Provides performance and availability data collection, real-time and historical monitoring, event management/monitoring, notifications, and performance reporting for non-Oracle databases.  This plug-in includes:<li>Real-time and historical performance monitoring and trending (Non-Oracle Database target)<li>Event management/monitoring (Non-Oracle Database target)<li>Event/Alert Notifications: Notification Methods, Rules and Schedules<li>Event/Alert history/metric history (Non-Oracle Database target)<li>Metric Snapshots<li>Blackouts/Planned Outages<li>Monitoring templates<li>Corrective actions (including response actions)<li>Performance and Event reports<li>Viewing and comparing configuration data, as well as tracking configuration changes (Non-Oracle Database target)<li>Repository tables/views that store/expose the above data<li>Monitoring non-Oracle database software via remote Management Agent. For remote monitoring, the Management Agent does not need to be on the same host as the non-Oracle database software.' ,
        p_pack_abbr          => 'SMNOD'
    );

-- Register Pack Definition for storage_smp
    em_license.add_pack_definitions
    (
        p_pack_label         => 'storage_smp'  ,
        p_target_type        => 'netapp_filer'  ,
        p_pack_display_label => 'Enterprise Manager System Monitoring Plug-in for Storage',
        p_pack_description   => 'Provides performance and availability data collection, real-time and historical monitoring, event management/monitoring, notifications, and performance reporting for storage devices.  This plug-in includes:<li>Real-time and historical performance monitoring and trending (Storage Device target)<li>Event management/monitoring (Storage Device target)<li>Event/Alert Notifications: Notification Methods, Rules and Schedules<li>Event/Alert history/metric history (Storage Device target)<li>Metric Snapshots<li>Blackouts/Planned Outages<li>Monitoring templates<li>Corrective actions (including response actions)<li>Performance and Event reports<li>Viewing and comparing configuration data, as well as tracking configuration changes (Storage Device target)<li>Repository tables/views that store/expose the above data<li>Monitor storage devices via remote Management Agent. For remote monitoring, the Management Agent does not need to be on the same computer as the storage device.' ,
        p_pack_abbr          => 'SMS'
    );

-- Register Pack Definition for mon_bpel
    em_license.add_pack_definitions
    (
        p_pack_label         => 'mon_bpel'  ,
        p_target_type        => 'oracle_integrationbpm'  ,
        p_pack_display_label => 'SOA Management Pack',
        p_pack_description   => '<dl>Delivers comprehensive management capabilities for a SOA environment.  Enterprise Manager makes it easy for the IT administrator to manage SOA runtime environments by discovering BPEL processes, managing service levels for business processes and partner links, and providing an error management solution for process instances.  The SOA Suite Management Pack includes:<dt><li>Centralized management console</li></dt><dt><li>Discovery and Service modeling</li></dt><dd><li type=\"circle\">BPEL PM Server</dd></li><dd><li type=\"circle\">BPEL Processes</dd></li><dd><li type=\"circle\">Partner Links</dd></li><dt><li>Web Services monitoring</li></dt><dd><li type=\"circle\">End user: SOAP tests</dd></li><dd><li type=\"circle\">Request based monitoring</dd></li><dt><li>BPEL diagnostics and error hospital integration</li></dt><dt><li>Infrastructure management</li></dt><dd><li type=\"circle\">Application Server</dd></li><dd><li type=\"circle\">Dehydration store</dd></li><dt><li>Business-IT alignment</li></dt><dd><li type=\"circle\">BAM-EM integration</dd></li><dt><li>Service Level Management</li></dt><dt><li>Historical analysis and reporting</li></dt><dt><li>Monitoring of BPEL Process Manager</li></dt></dl>' ,
        p_pack_abbr          => 'SOAM'
    );
        
-- Register Pack Definition for linux_host_pack

    em_license.add_pack_definitions
    (
        p_pack_label         => 'linux_host_pack'  ,
        p_target_type        => 'host'  ,
        p_pack_display_label => 'Linux Management Pack',
        p_pack_description   => 'Provides a rich feature set for managing Linux host systems across their lifecycle. The pack includes the following functionality for the listed Linux target types only:<li>Bare metal provisioning and patching of Linux operating systems </li><li>Host configuration monitoring, history, and summary</li><li>Policy management and compliance support</li><li>Real-time and historical monitoring</li><li>Host OS Administration</li><li>Corresponding CLI verbs for above features </li>',
        p_pack_abbr          => 'LM'
    );

    em_license.add_pack_definitions
    (
        p_pack_label         => 'linux_host_pack'  ,
        p_target_type        => 'cluster'  ,
        p_pack_display_label => 'Linux Management Pack',
        p_pack_description   => 'Provides a rich feature set for managing Linux host systems across their lifecycle. The pack includes the following functionality for the listed Linux target types only:<li>Bare metal provisioning and patching of Linux operating systems </li><li>Host configuration monitoring, history, and summary</li><li>Policy management and compliance support</li><li>Real-time and historical monitoring</li><li>Host OS Administration</li><li>Corresponding CLI verbs for above features </li>',
        p_pack_abbr          => 'LM'
    );

-- Register Pack Definition for db_sadm
    em_license.add_pack_definitions
    (
        p_pack_label         => 'db_sadm'  ,
        p_target_type        => 'oracle_database'  ,
        p_pack_display_label => 'Data Masking Pack',
        p_pack_description   => 'Offers the ability to mask regulated or confidential data on test, development systems.  The Data Masking Pack includes:<li>Create or Use Masking Definitions:  Specify which tables and columns are to be masked as well as the formats used to mask columns.</li><li>Define format libraries for reuse of standard formats across targets</li><li>Export or Import applications masking templates</li><li>Export or Import format libraries</li>',
        p_pack_abbr          => 'DM'  
    );
    
    em_license.add_pack_definitions
    (
        p_pack_label         => 'db_sadm'  ,
        p_target_type        => 'rac_database'  ,
        p_pack_display_label => 'Data Masking Pack',
        p_pack_description   => 'Offers the ability to mask regulated or confidential data on test, development systems.  The Data Masking Pack includes:<li>Create or Use Masking Definitions:  Specify which tables and columns are to be masked as well as the formats used to mask columns.</li><li>Define format libraries for reuse of standard formats across targets</li><li>Export or Import applications masking templates</li><li>Export or Import format libraries</li>',
        p_pack_abbr          => 'DM'  
    );

   

    COMMIT;
END;
/
