Rem drv: <migrate type="data_upgrade" version="10.2.0.4"/>
Rem
Rem $Header: notification_data_upgrade.sql 03-jul-2007.03:45:30 tsubrama Exp $
Rem
Rem notification_data_upgrade.sql
Rem
Rem Copyright (c) 2007, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      notification_data_upgrade.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    tsubrama    07/03/07 - fix for 6067675
Rem    neearora    05/15/07 - created
Rem    neearora    05/15/07 - Created
Rem

-- Add default values for global repeat notification settings
BEGIN
  INSERT INTO MGMT_PARAMETERS
    (parameter_name, parameter_value, parameter_comment)
  VALUES
    (EMD_NOTIFICATION.REPEAT_ENABLED_PARAM,
     EMD_NOTIFICATION.REPEAT_ENABLED_DEFAULT,
     'Enable/disable repeat notifications');

  INSERT INTO MGMT_PARAMETERS
    (parameter_name, parameter_value, parameter_comment)
  VALUES
    (EMD_NOTIFICATION.REPEAT_FREQUENCY_PARAM,
     EMD_NOTIFICATION.REPEAT_FREQUENCY_DEFAULT,
     'Frequency of repeat notifications');

  INSERT INTO MGMT_PARAMETERS
    (parameter_name, parameter_value, parameter_comment)
  VALUES
    (EMD_NOTIFICATION.REPEAT_COUNT_PARAM,
     EMD_NOTIFICATION.REPEAT_COUNT_DEFAULT,
     'Max. count of repeat notifications');

  COMMIT;
EXCEPTION WHEN OTHERS THEN
  IF(SQLCODE = -1)
  THEN 
    NULL;
  ELSE
    RAISE; 
  END IF;

END;
/


 --- Making "Notification Delivery" as non dbms job
BEGIN
    UPDATE mgmt_performance_names
      SET is_dbmsjob   = 'N'
     WHERE display_name = 'Notification Delivery'
       AND job_name = EMD_NOTIFICATION.DELIVER_MODULE_NAME
       AND is_dbmsjob   = 'Y' ;

    COMMIT;

   EXCEPTION WHEN OTHERS THEN NULL;

 END;
/


