Rem drv: <migrate type="schema_upgrade" version="10.2.0.4"/>
Rem
Rem $Header: notification_schema_upgrade.sql 29-jul-2007.11:18:13 rmaggarw Exp $
Rem
Rem notification_schema_upgrade.sql
Rem
Rem Copyright (c) 2007, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      notification_schema_upgrade.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    rmaggarw    07/29/07 - explicitly start aq before migration
Rem    neearora    05/03/07 - created
Rem    neearora    05/03/07 - Created
Rem

-- create a temp table to store the notificaion data

CREATE TABLE UNDELIVERED_NOTIF_TEMP
(
  seq_no NUMBER,         
  notification_type NUMBER(2), 
  is_ping NUMBER(1), 
  source_type NUMBER(2),
  source_guid RAW(16),
  device_name VARCHAR2(132),
  device_owner VARCHAR2(256),
  device_type NUMBER(2),
  rule_name VARCHAR2(64),
  rule_owner VARCHAR2(256),
  qname VARCHAR2(30),
  repeat_count NUMBER
);

-- copy all in information of undelivered notifications in to this table
declare
  dq_options      dbms_aq.dequeue_options_t;
  qMsg_properties dbms_aq.message_properties_t;
  notif           MGMT_NOTIFY_NOTIFICATION;
  qmsg_id_out RAW(1000);
  no_more_msg_in_q boolean := false;
  l_seq_no number := 0;
  CURSOR c1
  IS
  SELECT DISTINCT qname
    FROM mgmt_notify_queues;

BEGIN
  -- Explicitly start the queue in case it got stopped
  dbms_aqadm.start_queue(queue_name => '&EM_REPOS_USER' || '.MGMT_NOTIFY_Q');

  FOR r1 in c1
  LOOP
    dq_options.consumer_name := r1.qname;
    dq_options.navigation := DBMS_AQ.FIRST_MESSAGE;
    dq_options.wait := DBMS_AQ.NO_WAIT;

    no_more_msg_in_q := false;
    WHILE NOT no_more_msg_in_q
    LOOP
      BEGIN
        -- Dequeue a notification
        DBMS_AQ.DEQUEUE(queue_name         => '&EM_REPOS_USER'||'.MGMT_NOTIFY_Q',
                        dequeue_options    => dq_options,
                        message_properties => qMsg_properties,
                        payload            => notif,
                        msgid              => qmsg_id_out);
        l_seq_no := l_seq_no + 1;
        INSERT INTO UNDELIVERED_NOTIF_TEMP
          (seq_no, notification_type, is_ping, source_type, source_guid, device_name,
           device_owner, device_type, rule_name, rule_owner, qname, repeat_count)
        VALUES
          (l_seq_no, notif.notification_type, notif.is_ping, notif.source_type, notif.source_guid, notif.device_name,
           notif.device_owner, notif.device_type, notif.rule_name, notif.rule_owner, notif.qname, 0);

        EXCEPTION
        WHEN OTHERS THEN
          IF SQLCODE = -25228 -- ORA-25228: timeout or end-of-fetch during message dequeue.
          THEN
            no_more_msg_in_q := true;
          ELSE
            raise;
          END IF;
        END;
        COMMIT;
    END LOOP;
  END LOOP;
END;
/

BEGIN
  DBMS_AQADM.STOP_QUEUE (queue_name => '&EM_REPOS_USER'||'.MGMT_NOTIFY_Q');
  DBMS_AQADM.DROP_QUEUE(queue_name => '&EM_REPOS_USER'||'.MGMT_NOTIFY_Q');
  DBMS_AQADM.DROP_QUEUE_TABLE (queue_table => '&EM_REPOS_USER'||'.MGMT_NOTIFY_QTABLE');
END;
/

ALTER TABLE MGMT_NOTIFY_RULES ADD
(
  repeat                        NUMBER         DEFAULT 0,
  rule_guid                     RAW(16)        DEFAULT SYS_GUID() NOT NULL                           
);

declare
  l_sql VARCHAR2(1000) := 'DROP TYPE NOTIF_QUEUE_MSGS';
BEGIN
  EXECUTE IMMEDIATE l_sql;
EXCEPTION WHEN OTHERS THEN
  IF(SQLCODE = -4043) THEN
    NULL;
  ELSE
    RAISE;
  END IF;
END;
/

declare
  l_sql VARCHAR2(1000) := 'DROP TYPE NOTIF_QUEUE_MSG';
BEGIN
  EXECUTE IMMEDIATE l_sql;
EXCEPTION WHEN OTHERS THEN
  IF(SQLCODE = -4043) THEN
    NULL;
  ELSE 
    RAISE;
  END IF;
END;
/

declare 
  l_sql VARCHAR2(1000) := 'DROP TYPE MGMT_NOTIFY_NOTIFICATION';
BEGIN
  EXECUTE IMMEDIATE l_sql;
EXCEPTION WHEN OTHERS THEN
  IF(SQLCODE = -4043) THEN
    NULL;
  ELSE
    RAISE;
  END IF; 
END;
/

-- Create the message type for the Advanced Queue
CREATE OR REPLACE TYPE MGMT_NOTIFY_NOTIFICATION IS OBJECT
(
  notification_type NUMBER(2),-- NORMAL, RETRY, REPEAT, ESCALATED  
  is_ping NUMBER(1), -- flag to say if this is this checking the device status
  source_type NUMBER(2), -- SEVERITY, JOB, POLICY
  source_guid RAW(16), -- TARGET_GUID, JOB_GUID, POLICY_GUID
  device_name VARCHAR2(132), -- the notification method
  device_owner VARCHAR2(256), -- the notification method owner
  device_type NUMBER(2), -- the type of the device
  rule_name VARCHAR2(64), -- the rule causing this notification
  rule_owner VARCHAR2(256), -- the owner of the rule
  qname VARCHAR2(30), -- the name of the queue this was placed in
  repeat_count NUMBER -- in casse of reate notificaion, the number of repeat
);
/

CREATE OR REPLACE TYPE NOTIF_QUEUE_MSG IS OBJECT
(
  msgid         VARCHAR2(64),
  notification  MGMT_NOTIFY_NOTIFICATION,
  target_name   VARCHAR2(256),
  target_type   VARCHAR2(256),
  delay         INTEGER,
  enqueue_time  DATE,
  state         INTEGER
);
/

CREATE OR REPLACE TYPE NOTIF_QUEUE_MSGS IS TABLE OF NOTIF_QUEUE_MSG;
/


BEGIN
    DBMS_AQADM.CREATE_QUEUE_TABLE (queue_table => '&EM_REPOS_USER'||'.MGMT_NOTIFY_QTABLE',
                                   queue_payload_type => '&EM_REPOS_USER'||'.MGMT_NOTIFY_NOTIFICATION',
                                   multiple_consumers => TRUE);
    DBMS_AQADM.CREATE_QUEUE (queue_name => '&EM_REPOS_USER'||'.MGMT_NOTIFY_Q',
                             queue_table => '&EM_REPOS_USER'||'.MGMT_NOTIFY_QTABLE');
    DBMS_AQADM.START_QUEUE (queue_name => '&EM_REPOS_USER'||'.MGMT_NOTIFY_Q');
  COMMIT;
END;
/

-- insert the data back into the new queue
declare
  enq_options         dbms_aq.enqueue_options_t;
  qMsg_properties     dbms_aq.message_properties_t;
  qMsg_handle         RAW(16);
  recipient           sys.aq$_agent;
  notif               MGMT_NOTIFY_NOTIFICATION;
  CURSOR c1
  IS
  SELECT * 
    FROM undelivered_notif_temp
   ORDER BY qname, seq_no;
BEGIN
  FOR r1 in c1
  LOOP
    notif := MGMT_NOTIFY_NOTIFICATION(r1.notification_type, 
                                      r1.is_ping,
                                      r1.source_type,
                                      r1.source_guid,
                                      r1.device_name,
                                      r1.device_owner,
                                      r1.device_type,
                                      r1.rule_name,
                                      r1.rule_owner,
                                      r1.qname,
                                      0);

    -- Set up the qname as the recipient name
    recipient := sys.aq$_agent(r1.qname, NULL, 0);
    qMsg_properties.recipient_list(1) := recipient;

    -- Enqueue a notification
    DBMS_AQ.ENQUEUE(queue_name => '&EM_REPOS_USER'||'.MGMT_NOTIFY_Q',
                    enqueue_options => enq_options,
                    message_properties => qMsg_properties,
                    payload => notif,
                    msgid => qMsg_handle);
     
    COMMIT;
  END LOOP;
END;
/ 

DROP TABLE UNDELIVERED_NOTIF_TEMP;
