Rem drv: <migrate type="schema_upgrade" version="10.2.0.4" />
Rem
Rem $Header: notification_types.sql 21-jun-2007.22:32:02 neearora Exp $
Rem
Rem notification_types.sql
Rem
Rem Copyright (c) 2007, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      notification_types.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    neearora    06/20/07 - fixed checking existance of
Rem                           MGMT_NOTIFY_INPUT_QTABLE
Rem    dgiaimo     04/30/07 - Changing 10.2.4.0 to 10.2.0.4
Rem    dgiaimo     04/26/07 - Changing 10.2.4.0 to 10.2.0.4
Rem    dgiaimo     04/30/07 - Backport dgiaimo_bug-6014523 from main
Rem    smalathe    04/23/07 - Bug 5881705: Change MGMT_NOTIFY_JOB_SC.JOB_TYPE
Rem                           and MGMT_NOTIFY_JOB.JOB_TYPE type
Rem    neearora    03/27/07 - created
Rem

-- MGMT_NOTIFY_CORRECTIVE_ACTION type is present from 10.2.0.1 and we
-- expect this type to be present during upgrading to 10.2.0.4 as well. So
-- not handling the exception case when this type isn't found
DROP TYPE MGMT_NOTIFY_CORRECTIVE_ACTION;

-- This contains details of a job state change
-- Bug 5881705: Set job_type type to the type of
-- mgmt_job_type_info.job_type_default, varchar2(256)
CREATE OR REPLACE TYPE MGMT_NOTIFY_JOB UNDER MGMT_NOTIFY_OBJECT
(job_name              VARCHAR2(128),
 job_owner             VARCHAR2(256),
 job_type              VARCHAR2(256),
 job_status            NUMBER,
 occurred              DATE,
 state_change_guid     RAW(16),
 job_guid              RAW(16),
 execution_id          RAW(16),
 targets               SMP_EMD_NVPAIR_ARRAY
) NOT FINAL;
/
show errors

-- This contains details of a corrective action state change for both
-- metric severities and policy violations. For policy violations, the 
-- metric_name stores the policy with metric_column not being used
CREATE OR REPLACE TYPE MGMT_NOTIFY_CORRECTIVE_ACTION UNDER MGMT_NOTIFY_JOB
(metric_name           VARCHAR2(256),
 metric_column         VARCHAR2(64),
 metric_value          VARCHAR2(1024),
 severity_code         NUMBER,
 key_value_name        VARCHAR2(512),
 key_value             VARCHAR2(1290),
 key_value_guid        VARCHAR2(256),
 ctxt_list             MGMT_NOTIFY_COLUMNS
);
/
show errors
 
-- This contains details of a job state changes for either a regular job 
-- or a corrective action
-- Bug 5881705: Set job_type type to the type of
-- mgmt_job_type_info.job_type_default, varchar2(256)
CREATE OR REPLACE TYPE MGMT_NOTIFY_JOB_SC AS OBJECT
(
   job_name VARCHAR2(64),
   job_type VARCHAR2(256),
   job_type_nlsid VARCHAR2(64),
   job_owner VARCHAR2(256),
   target_names MGMT_MEDIUM_STRING_ARRAY,
   target_types MGMT_MEDIUM_STRING_ARRAY,
   target_timezone VARCHAR2(64),
   logged DATE,
   occurred DATE,
   status NUMBER(2),
   job_id RAW(16),
   execution_id RAW(16),
   step_id NUMBER(38),
   label VARCHAR2(256),
   label_nlsid VARCHAR2(256),
   metric_name VARCHAR2(256),
   metric_column VARCHAR2(64),
   metric_value VARCHAR2(1024),
   violation_level NUMBER,
   keys MGMT_NOTIFY_COLUMNS,
   ctxt_list MGMT_NOTIFY_COLUMNS
); 
/  
show errors

DECLARE
l_queue_name VARCHAR2(64);
l_q_table_name VARCHAR2(64);
BEGIN
  BEGIN
    SELECT object_name 
      INTO l_q_table_name 
      FROM all_objects 
     WHERE object_name = 'MGMT_NOTIFY_INPUT_QTABLE'
       AND object_type = 'TABLE' 
       AND owner = '&EM_REPOS_USER';
  EXCEPTION
  WHEN NO_DATA_FOUND
  THEN
    DBMS_AQADM.CREATE_QUEUE_TABLE (queue_table => '&EM_REPOS_USER'||'.MGMT_NOTIFY_INPUT_QTABLE',
                                   queue_payload_type => 'RAW',
                                   multiple_consumers => FALSE);
  END;  

  BEGIN
    SELECT object_name
      INTO l_queue_name
      FROM all_objects
     WHERE object_name = 'MGMT_NOTIFY_INPUT_Q'
       AND object_type = 'QUEUE'
       AND owner = '&EM_REPOS_USER';
  EXCEPTION
  WHEN NO_DATA_FOUND
  THEN
    DBMS_AQADM.CREATE_QUEUE (queue_name => '&EM_REPOS_USER'||'.MGMT_NOTIFY_INPUT_Q',
                             queue_table => '&EM_REPOS_USER'||'.MGMT_NOTIFY_INPUT_QTABLE');
  END;

  DBMS_AQADM.START_QUEUE (queue_name => '&EM_REPOS_USER'||'.MGMT_NOTIFY_INPUT_Q');
  COMMIT;
END;
/

show errors;
