Rem
Rem $Header: admin_check_repos_user.sql 27-mar-2003.17:00:11 rpinnama Exp $
Rem
Rem admin_check_repos_user.sql
Rem
Rem Copyright (c) 2002, 2003, Oracle Corporation.  All rights reserved.  
Rem
Rem    NAME
Rem      admin_check_repos_user.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    rpinnama    03/27/03 - Pass exists/not_exists check type
Rem    rpinnama    02/25/03 - Remove unnecessary exit at the end
Rem    rpinnama    10/17/02 - Use SQL arguments
Rem    rpinnama    06/28/02 - Dont use ECHO_SQL variable
Rem    rpinnama    06/27/02 - Parameterize ECHO_SQL
Rem    rpinnama    06/03/02 - rpinnama_reorg_rep_scripts_3
Rem    rpinnama    05/20/02 - Created
Rem

Rem
Rem  Requires the following arguments
Rem    1 - REPOSITORY USER NAME
Rem    2 - CHECK TYPE (possible values EXISTS, NOT_EXISTS
Rem

DEFINE EM_REPOS_USER=&1
DEFINE EM_CHECK_TYPE=&2

DECLARE
  l_rep_user_cnt INTEGER := 0;
BEGIN
  SELECT count(1) INTO l_rep_user_cnt
    FROM all_users
   WHERE username=UPPER('&EM_REPOS_USER');
   
  IF ( '&EM_CHECK_TYPE' = 'EXISTS') THEN

    IF (l_rep_user_cnt = 0) THEN
      raise_application_error(-20000, '&EM_REPOS_USER does not exists..');
    END IF;

  ELSIF ( '&EM_CHECK_TYPE' = 'NOT_EXISTS' ) THEN

    IF (l_rep_user_cnt > 0) THEN
      raise_application_error(-20001, '&EM_REPOS_USER already exists..');
    END IF;

  ELSE
      raise_application_error(-20002, 'Invalid Check type &EM_CHECK_TYPE');
  END IF;
END;
/


