Rem
Rem $Header: admin_drop_tablespaces.sql 03-jun-2002.15:24:43 rpinnama Exp $
Rem
Rem admin_drop_tablespaces.sql
Rem
Rem Copyright (c) 2002, Oracle Corporation.  All rights reserved.  
Rem
Rem    NAME
Rem      admin_drop_tablespaces.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    rpinnama    06/03/02 - rpinnama_reorg_rep_scripts_3
Rem    rpinnama    05/20/02 - Created
Rem


declare 
  err number;
  c number;
begin
    begin
      for crec in (select tablespace_name 
                     from sys.dba_tablespaces 
		    where tablespace_name like 'MGMT_%')
      loop
        DBMS_OUTPUT.PUT_LINE('DropRep: dropping tablespace ' || crec.tablespace_name);
        execute immediate 'drop tablespace ' || 
                          crec.tablespace_name || 
                          ' including contents';
      end loop;
      exception
        when NO_DATA_FOUND then
          DBMS_OUTPUT.PUT_LINE('DropRep: Tablespaces like MGMT% do not exist');
        WHEN OTHERS THEN
          err := SQLCODE;
          DBMS_OUTPUT.PUT_LINE('DropRep: Error ' || SQLCODE || ' received dropping table');
    end;
    commit;
end;
/
