Rem drv: <create type="pkgdefs" />
Rem
Rem $Header: admin_maint_util_pkgdef.sql 30-may-2007.13:20:16 minfan Exp $
Rem
Rem admin_maint_util_pkgdef.sql
Rem
Rem Copyright (c) 2006, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      admin_maint_util_pkgdef.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem    Maintenance Utility to do the following
Rem    1. Recompile Invalid Objects
Rem    2. Partition Maintenance
Rem    **Note: 
Rem    This Package spec should not depend on any EM related
Rem    Objects
Rem    The package body should not depend on any EM related
Rem    objects other than MGMT_VERSIONS, MGMT_LOG,
Rem    MGMT_PARAMETERS
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    jsadras     05/09/07 - make it invoker rights
Rem    jsadras     05/04/07 - add init raw/hour/day partitions code
Rem    jsadras     04/29/07 - add get max partition name
Rem    jsadras     11/17/06 - Add common partition related functons
Rem    minfan      05/30/07 - Added recreate_synonyms to pkgdef
Rem    jsadras     08/09/06 - Created
Rem

CREATE OR REPLACE PACKAGE EMD_MAINT_UTIL AS 

--
-- mgmt_parameter names
--
RAW_KEEP_PARAM       CONSTANT  VARCHAR(32) := 'mgmt_raw_keep_window';
HOUR_KEEP_PARAM      CONSTANT  VARCHAR(32) := 'mgmt_hour_keep_window';
DAY_KEEP_PARAM       CONSTANT  VARCHAR(32) := 'mgmt_day_keep_window';
--
-- Default windows for keeping data in raw/hour/day
--
-- Duplicated for now with emd_loader
--
DEFAULT_RAW_KEEP     CONSTANT NUMBER := 24;    -- in hours
DEFAULT_HOUR_KEEP    CONSTANT NUMBER := 168;   -- in hours (7 days)
DEFAULT_DAY_KEEP     CONSTANT NUMBER := 31;    -- in days

---    
--- Gets retention period for fetching raw data from repository
---    
FUNCTION GET_RAW_RETENTION_WINDOW RETURN NUMBER;

---    
--- Gets retention period for fetching 1 hour data from repository
---
FUNCTION GET_1HOUR_RETENTION_WINDOW RETURN NUMBER;

---    
--- Gets retention period for fetching 1 day data from repository
---    
FUNCTION GET_1DAY_RETENTION_WINDOW RETURN NUMBER;
--
-- Check if the table has partitioning enabled
--
FUNCTION partitions_enabled(v_table_name IN VARCHAR2) 
RETURN BOOLEAN ;
--
-- Get Central mode
--
FUNCTION is_central_mode(p_comp_name VARCHAR2 DEFAULT 'CORE')
RETURN NUMBER  ;
--
-- Recompile Invalid Objects
--
PROCEDURE recompile_invalid_objects ;
--
-- Recreate synonyms
--
PROCEDURE recreate_synonyms;
--
-- Do Partition Maintenance on the following tables
-- MGMT_METRICS_RAW
-- MGMT_METRICS_1HOUR
-- MGMT_METRICS_1DAY
--
PROCEDURE PARTITION_MAINTENANCE
(
  p_stop_job BOOLEAN DEFAULT TRUE
) ;

END  EMD_MAINT_UTIL ;
/

show errors;

