Rem drv: <create type="pkgdefs" pos="availability/availability_main_pkgdefs.sql+"/>
Rem
Rem $Header: emcore/source/oracle/sysman/emdrep/sql/core/latest/admin/admin_maintenance_pkgdef.sql /st_emcore_10.2.0.4.1db11/1 2008/7/13 00:49:03 lsatyapr Exp $
Rem
Rem admin_maintenance_pkgdef.sql
Rem
Rem Copyright (c) 2002, 2008, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      admin_maintenance_pkgdef.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    lsatyapr    07/10/08 - Bug7214155 Avoid jobtype upg in non-central mode
Rem    edemembe    07/12/07 - Bug 6157164 Removing recompile_invalid_objects
Rem    edemembe    07/17/07 - Backport edemembe_bug-6157164 from main
Rem    pmodi       07/20/06 - Backport pmodi_bug-4465878 from main 
Rem    pmodi       07/11/06 - Bug4465878 - Start/Stop job based on parameter 
Rem                           within dpartition_maintenance 
Rem    scgrover    07/07/05 - add extended sql trace 
Rem    gsbhatia    07/01/05 - New repmgr header impl 
Rem    gsbhatia    03/15/05 - bug 4178702 
Rem    scgrover    01/10/05 - add index compression sql 
Rem    gan         07/07/04 - bump version to 10.2.0.0.0 
Rem    edemembe    04/15/04 - Bug 3227319: Collect histograms for non-idx cols 
Rem    rpinnama    12/12/03 - Fix bug 3296613: Record the outofbox configured 
Rem    jpyang      11/10/03 - change version to 10.1.0.2 
Rem    rzazueta    10/30/03 - Add procedures for detailed logging 
Rem    edemembe    08/25/03 - Partition truncation added 
Rem    rpinnama    07/25/03 - Merge all dbms jobs to one for standalone repository
Rem    rpinnama    07/11/03 - Add get_repos_mode function
Rem    rpinnama    07/01/03 - APIs to start and stop EM jobs
Rem    edemembe    07/01/03 - Adding partition support
Rem    rpinnama    11/19/02 - Add move procedure
Rem    rpinnama    03/17/03 - Provide get/setVersion APIs
Rem    sgrover     01/20/03 - fix analyze
Rem    sgrover     01/10/03 - add rebuild interval stuff
Rem    rpinnama    10/08/02 - Add types
Rem    rpinnama    10/07/02 - Add grant core sdk procedure
Rem    edemembe    07/10/02 - Adding index rebuilds
Rem    rpinnama    05/15/02 - rpinnama_reorg_rep_scripts
Rem    rpinnama    05/15/02 - Created
Rem

create or replace package emd_maintenance as -- package specification


   -- Package constants..
   G_VERSION        CONSTANT VARCHAR2(16) := '10.2.0.0.0';
   G_COMPAT_VERSION CONSTANT VARCHAR2(16) := G_VERSION;

   -- Component modes
   G_COMPONENT_MODE_CENTRAL    CONSTANT VARCHAR2(16) := 'CENTRAL';

   -- component states
   G_STATUS_INITIALIZING         CONSTANT NUMBER(2) := 0;
   G_STATUS_INITIALIZED          CONSTANT NUMBER(2) := 1;
   G_STATUS_UPGRADING            CONSTANT NUMBER(2) := 2;
   G_STATUS_UPGRADED             CONSTANT NUMBER(2) := 3;
   G_STATUS_CONFIGURED_READY     CONSTANT NUMBER(2) := 4;

   DETAILED_MAINT_LOGGING     CONSTANT VARCHAR2(32)  := 'detailed_maintenance_logging';
   DETAILED_MAINT_LOGGING_CMT CONSTANT VARCHAR2(128) := 
     'Property that defines whether the detailed maintenance logging should be enabled or not';

   EST_ANALYZE_NAME              CONSTANT VARCHAR2(32)  := 'EST_ANALYZE';

   RESCHEDULE_ON_NEW_JOBTYPE CONSTANT VARCHAR2(32) := 'mgmt_job_reschd_on_new_jobtype';
   RESCHEDULE_ON_NEW_JOBTYPE_CMT CONSTANT VARCHAR2(128) := 
     'Property that defines whether registration of new job type should reschedule executions or not (default TRUE)';

   --
   -- PURPOSE 
   --   Procedure(s) to enable/disable/verify detailed logging
   -- 
   PROCEDURE enable_detailed_logging;

   PROCEDURE disable_detailed_logging;

   FUNCTION  is_detailed_logging_enabled RETURN INTEGER;


   procedure analyze_emd_schema(emd_schema  VARCHAR2);
 
   PROCEDURE DBMSJOB_EXTENDED_SQL_TRACE_ON(p_value IN BOOLEAN);
 
   procedure analyze_objects_without_stats(emd_schema  VARCHAR2);  
 
   procedure update_stale_stats(emd_schema  VARCHAR2,
                                start_day VARCHAR2 DEFAULT 'SATURDAY',
                                start_hour NUMBER DEFAULT 0,
                                start_minutes NUMBER DEFAULT 0,
                                frequency_in_days NUMBER DEFAULT 1);
   procedure delete_all_stats(emd_schema VARCHAR2,
                              start_day VARCHAR2 DEFAULT 'SATURDAY',
                              start_hour NUMBER DEFAULT 0,
                              start_minutes NUMBER DEFAULT 0);
   procedure pin_plsql;
   procedure monitor_indexes;
   procedure rebuild_indexes;
   procedure rebuild_iot(iot VARCHAR2);
   procedure rebuild_table_indexes(tablename VARCHAR2);
   procedure collect_segment_sizes;

  -- The following procedures are used to start and stop 
  -- EM jobs
  PROCEDURE submit_em_dbms_jobs;
  PROCEDURE remove_em_dbms_jobs;


  PROCEDURE execute_em_dbms_job_procs;

  -- The following procedure is used for moving repository
  -- from one table space to another
  PROCEDURE move_em_tblspc(dest_tbs_in IN VARCHAR2);


  -- Get repository version 
  FUNCTION get_version(p_comp_name VARCHAR2 DEFAULT 'CORE')
    RETURN VARCHAR2;

  FUNCTION get_mode(p_comp_name VARCHAR2 DEFAULT 'CORE')
    RETURN VARCHAR2;

  FUNCTION is_central_mode(p_comp_name VARCHAR2 DEFAULT 'CORE')
    RETURN NUMBER;

  FUNCTION get_comp_status(p_comp_name VARCHAR2 DEFAULT 'CORE')
    RETURN NUMBER;

  -- The following procedure sets the version, compatibility version
  -- and mode of operation for a repository component.
  PROCEDURE set_version(p_comp_name   VARCHAR2 DEFAULT 'CORE',
                        p_version     VARCHAR2 DEFAULT NULL,
			p_compat_ver  VARCHAR2 DEFAULT NULL,
			p_comp_mode   VARCHAR2 DEFAULT NULL,
                        p_comp_status NUMBER   DEFAULT G_STATUS_INITIALIZED);

  PROCEDURE set_comp_status(p_comp_name   VARCHAR2 DEFAULT 'CORE',
                            p_comp_status NUMBER   DEFAULT G_STATUS_INITIALIZED);

  -- This procedure grants the SDK privilege to the specified user
  PROCEDURE create_sdk_synonyms;

  PROCEDURE grant_core_sdk(new_user_name_in VARCHAR2);

  -- The following routines perform partition maintenance
  PROCEDURE add_partitions(v_table_name IN VARCHAR2,
                           v_max_days IN PLS_INTEGER,
                           v_day_partitions IN BOOLEAN DEFAULT FALSE);

  PROCEDURE PARTITION_MAINTENANCE
  (
    p_stop_job BOOLEAN DEFAULT TRUE
  ) ;

  PROCEDURE drop_partitions(v_table_name IN VARCHAR2,
                            v_retention_days IN PLS_INTEGER);
  PROCEDURE truncate_partitions(v_table_name IN VARCHAR2,
                                v_retention_days IN PLS_INTEGER);
  FUNCTION partitions_enabled(v_table_name IN VARCHAR2) RETURN BOOLEAN;

  FUNCTION repository_db_v9 RETURN BOOLEAN;

  p_ErrMsg                 VARCHAR(2048);
  p_Module                 VARCHAR(128);
  p_Action                 VARCHAR(128);

  PROCEDURE compress_index(rebuild_index_name IN VARCHAR2, rebuild_prefix_length IN NUMBER,
                           do_online IN BOOLEAN);

  -- set the reschedule execs on new jobtype flag in MGMT_PARAMETERS
  PROCEDURE set_reschd_on_new_jobtype(p_enable BOOLEAN DEFAULT TRUE);

  -- check if central mode and set reschedule execs on new jobtype flag
  -- accordingly: central -> TRUE, others -> FALSE
  PROCEDURE calc_reschd_on_new_jobtype;

  -- remove the reschedule execs on new jobtype flag
  PROCEDURE clear_reschd_on_new_jobtype;

  -- return whether the reschedule execs on new jobtype flag is set or not
  FUNCTION should_reschd_on_new_jobtype RETURN BOOLEAN;

end  emd_maintenance;
/

show errors;

