Rem
Rem $Header: assoc_pkgdefs.sql 09-aug-2005.08:04:43 pmodi Exp $
Rem
Rem assoc_pkgdefs.sql
Rem
Rem Copyright (c) 2004, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      assoc_pkgdefs.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    pmodi       08/09/05  - New procedure for upgrade to poulate flat table 
Rem    gsbhatia    06/26/05  - New repmgr header impl 
Rem    pmodi       04/15/05  - change in assoc flattening algo 
Rem    ramalhot    04/08/05  - change in assoc flattening algo
Rem    gsbhatia    02/13/05  - updating repmgr header 
Rem    gsbhatia    02/09/05  - updating repmgr header 
Rem    gsbhatia    02/07/05  - updating repmgr header 
Rem    ramalhot    02/02/05  - changed signature for delete_target 
Rem    ktlaw       01/11/05  - add repmgr header 
Rem    ramalhot    12/28/04  - default added to recreate_flat_target_list 
Rem    ramalhot    10/19/04  - bulk apis based on guids added 
Rem    ramalhot    10/08/04 -  new apis fro loader added 
Rem    ramalhot    10/05/04 - bulk apis added 
Rem    ramalhot    08/27/04 - properties support added 
Rem    ramalhot    08/18/04 - column name changed 
Rem    ramalhot    07/31/04 - constant name changed 
Rem    ramalhot    07/26/04 -Global variable g_memberships_added added 
Rem    ramalhot    07/09/04 - sdk APIs added 
Rem    ramalhot    07/07/04 - ramalhot_assoc_object_creation
Rem    ramalhot    07/06/04 - Created 
Rem

CREATE OR REPLACE PACKAGE em_assoc IS

  -- Module name used for logging
  MODULE_NAME CONSTANT VARCHAR2(8)     := 'EM.assoc';
  CREATE_ASSOC_OPER CONSTANT NUMBER(1) := 1;
  DELETE_ASSOC_OPER CONSTANT NUMBER(1) := 0;
  g_loader_assoc_added MGMT_TARGET_ASSOC_LIST;
  LOOP_IN_ASSOC CONSTANT NUMBER(5) := -1436;

  --
  -- PROCEDURE: insert_memberships
  --
  -- PURPOSE
  --   inserts memberships records  in the mgmt_target_assoc,
  --   if someone inserts rows in the mgmt_target_memberships
  -- IN Parameters:
  --   p_memberships : MGMT_MEMBER_ASSOC_LIST
  --      List containing the memberships records
  PROCEDURE insert_memberships
  (
    p_memberships IN MGMT_MEMBER_ASSOC_LIST
  );

  --
  -- PROCEDURE: insert_memberships
  --
  -- PURPOSE
  --   inserts a row in the mgmt_target_assoc,
  --   if someone inserts a row in mgmt_target_memberships view
  -- IN Parameters:
  --   p_source_target_name : VARCHAR2
  --       The name of the source target
  --   p_source_target_type : VARCHAR2
  --       The type of source target
  --   p_source_target_guid : RAW(16)
  --       The GUID for the source target
  --   p_assoc_target_name : VARCHAR2
  --       The name of associated target
  --   p_assoc_target_type : VARCHAR2
  --       The type of associated target
  --   p_assoc_target_guid : RAW(16)
  --       The GUID for the associated target
  -- OUT Parameters:
  --
  -- ERROR CODES:
  --   INVALID_PARAMS_ERR : For invalid parameters

  PROCEDURE insert_memberships
  (
    p_source_target_name IN mgmt_targets.target_name%TYPE,
    p_source_target_type IN mgmt_targets.target_type%TYPE,
    p_source_target_guid IN mgmt_targets.target_guid%TYPE,
    p_assoc_target_name  IN mgmt_targets.target_name%TYPE,
    p_assoc_target_type  IN mgmt_targets.target_type%TYPE,
    p_assoc_target_guid  IN mgmt_targets.target_guid%TYPE
  );

  --
  -- PROCEDURE: delete_memberships
  --
  -- PURPOSE
  --   deletes a row from the mgmt_target_assoc table,
  --   id someone deletes a row from mgmt_target_memberships table
  -- IN Parameters:
  --   p_source_target_name : VARCHAR2
  --       The name of the source target
  --   p_source_target_type : VARCHAR2
  --       The type of source target
  --   p_source_target_guid : RAW(16)
  --       The GUID for the source target
  --   p_assoc_target_name : VARCHAR2
  --       The name of associated target
  --   p_assoc_target_type : VARCHAR2
  --       The type of associated target
  --   p_assoc_target_guid : RAW(16)
  --       The GUID for the associated target
  --   p_association : VARCHAR2
  --       The name of association def
  -- OUT Parameters:
  --
  -- ERROR CODES:
  --   INVALID_PARAMS_ERR : For invalid parameters

  PROCEDURE delete_memberships
  (
    p_source_target_name IN mgmt_targets.target_name%TYPE,
    p_source_target_type IN mgmt_targets.target_type%TYPE,
    p_source_target_guid IN mgmt_targets.target_guid%TYPE,
    p_assoc_target_name  IN mgmt_targets.target_name%TYPE,
    p_assoc_target_type  IN mgmt_targets.target_type%TYPE,
    p_assoc_target_guid  IN mgmt_targets.target_guid%TYPE
  );

  --
  -- PROCEDURE: update_pending_assoc
  --
  -- PURPOSE
  --   Check all the pending associtions with missing targets and converts them to
  --   associations
/*  PROCEDURE update_pending_assoc
  (
    p_emd_url IN mgmt_targets.EMD_URL%TYPE
  );
*/
  --
  -- PROCEDURE: update_pending_assoc
  --
  -- PURPOSE
  --   Check the pending associtions with missing targets and converts them to
  --   associations
  -- IN Parameters:
  --   p_target_name : VARCHAR2
  --       The name of the target added
  --   p_target_type : VARCHAR2
  --       The type of the target added
  --   p_target_guid : RAW(16)
  --       The guid of the target added
  --
  PROCEDURE update_pending_assoc
  (
    p_target_name IN mgmt_targets.target_name%TYPE,
    p_target_type IN mgmt_targets.target_type%TYPE,
    p_target_guid IN mgmt_targets.target_guid%TYPE
  );

  --
  -- PROCEDURE: delete_target
  --
  -- PURPOSE
  --   When a target is deleted, all its associations are automatically deleted.
  -- IN Parameters:
  --   p_target_name : VARCHAR2
  --       The name of the target deleted
  --   p_target_type : VARCHAR2
  --       The type of the target deleted
  --   p_target_guid : VARCHAR2
  --       The guid of the target deleted
  --
  PROCEDURE delete_target
  (
    p_target_name IN mgmt_targets.target_name%TYPE,
    p_target_type IN mgmt_targets.target_type%TYPE,
    p_target_guid IN mgmt_targets.target_guid%TYPE
  );

  --
  -- PROCEDURE: CREATE_TARGET_ASSOC
  --
  -- PURPOSE
  --   Creates an association.
  -- IN Parameters:
  --   p_assoc_name  : VARCHAR2
  --       The name of the association to be added
  --   p_assoc_def_name : VARCHAR2
  --       The name of assoc def
  --   p_source_target_name : VARCHAR2
  --       The name of the source target
  --   p_source_target_type : VARCHAR2
  --       The type of source target
  --   p_assoc_target_name : VARCHAR2
  --       The name of associated target
  --   p_assoc_target_type : VARCHAR2
  --       The type of associated target
  --   p_scope_target_name : VARCHAR2
  --       The name of the target in whose context this Association is valid
  --   p_scope_target_type : VARCHAR2
  --       The type of the target in whose context this Association is valid.
  --       This is required only for non-global associations.
  --   p_is_editable : NUMBER
  --       The property that controls the association ownership
  --           where ASSOC_EDITABLE means end-user can edit this association
  --                 ASSOC_NOT_EDITABLE means end-user can't edit this association
  --   p_created_by : NUMBER
  --
  -- OUT Parameters:
  --
  -- ERROR CODES:
  --   INVALID_PARAMS_ERR : For invalid parameters
  --   ASSOC_DEF_DOES_NOT_EXIST: No such assocaition def was found.

  PROCEDURE create_target_assoc
  (
    p_assoc_guid         IN mgmt_target_assocs.assoc_guid%TYPE,
    p_source_target_guid IN mgmt_target_assocs.source_target_guid%TYPE,
    p_assoc_target_guid  IN mgmt_target_assocs.assoc_target_guid%TYPE,
    p_scope_target_guid  IN mgmt_target_assocs.scope_target_guid%TYPE
                              DEFAULT mgmt_assoc.GLOBAL_SCOPE_TARGET_GUID,
    p_is_editable        IN mgmt_target_assocs.is_editable%TYPE 
                              DEFAULT mgmt_assoc.ASSOC_NOT_EDITABLE,
    p_created_by         IN mgmt_target_assocs.created_by%TYPE
                              DEFAULT mgmt_assoc.CREATED_BY_END_USER
  );
  --
  -- FUNCTION: get_connected_SAPs
  --
  -- PURPOSE
  --   gets all the service access points connected
  --   to source_target otherwise retuns null
  -- IN Parameters:
  --   p_source_target_guid : RAW(16)
  --       The guid of the source target
  --   p_scope_target_guid : RAW(16)
  --       The guid of the scope target
  -- RETURN Parameters:
  --   target_guid_list
  --       The list of all connected Service Access Points
  -- ERROR CODES:
  --   INVALID_PARAMS_ERR : For invalid parameters
/*
  FUNCTION get_connected_SAPs(
    p_source_target_guid IN mgmt_targets.target_guid%TYPE,
    p_scope_target_guid  IN mgmt_targets.target_guid%TYPE
  )
  RETURN MGMT_ASSOC_TARGET_GUID_LIST;

  --
  -- FUNCTION: recreate_inferred_associations
  --
  -- PURPOSE
  --   recreats the inferred association for the service target
  -- IN Parameters:
  --   p_SAP_list  : RAW(16)
  --       The list of Service Access Points
  --
  -- ERROR CODES:
  --
  PROCEDURE recreate_inferred_associations
  (
     p_SAP_list IN MGMT_ASSOC_TARGET_GUID_LIST
  );


  FUNCTION get_infra_group
  (
    p_target_guid IN mgmt_targets.target_guid%TYPE
  )RETURN VARCHAR2;


  --
  -- PROCEDURE: recreate_inferred_associations
  --
  -- PURPOSE
  --   recreats the inferred associations for the infrastructure group type
  -- IN Parameters:
  --   p_service_target_guid  : RAW(16)
  --       The guid of the service target
  --
  -- ERROR CODES:
  --
  PROCEDURE recreate_infa_group_assocs
  (
    p_infra_group_guid   IN mgmt_targets.target_guid%TYPE,
    p_assoc_guid         IN mgmt_targets.target_guid%TYPE,
    p_source_target_guid IN mgmt_targets.target_guid%TYPE,
    p_scopr_target_guid  IN mgmt_targets.target_guid%TYPE
  );
*/
  --
  -- PROCEDURE: change_agent_guid
  --
  -- PURPOSE
  --   replaces an existing agent by another agent in all associations
  -- IN Parameters:
  --   p_old_agent_guid  : RAW(16)
  --       The guid of the old agent
  --
  --   p_new_agent_guid : RAW(16)
  --       The guid of the new agent
  -- ERROR CODES:
  --
  PROCEDURE change_agent_guid
  (
    p_old_agent_guid   IN mgmt_targets.target_guid%TYPE,
    p_new_agent_guid   IN mgmt_targets.target_guid%TYPE
  );

  --
  -- basic record and cursor types for the UI/TOPOLOGY
  --
  TYPE association_rowtype IS RECORD
  (
     association_type   mgmt_target_assoc_defs.association_type%TYPE,
     source_target_guid mgmt_target_assocs.source_target_guid%TYPE,
     source_target_name mgmt_targets.target_name%TYPE,
     source_target_type mgmt_target_assoc_defs.source_target_type%TYPE,
     assoc_target_guid  mgmt_target_assocs.assoc_target_guid%TYPE,
     assoc_target_name  mgmt_targets.target_name%TYPE,
     assoc_target_type  mgmt_target_assoc_defs.assoc_target_type%TYPE,
     scope_target_guid  mgmt_target_assocs.scope_target_guid%TYPE,
     scope_target_name  mgmt_targets.target_name%TYPE,
     scope_target_type  mgmt_targets.target_type%TYPE,
     is_editable        mgmt_target_assocs.is_editable%TYPE
   );

  TYPE target_rowtype IS RECORD
  (
     target_guid mgmt_targets.target_guid%TYPE,
     target_name mgmt_targets.target_name%TYPE,
     target_type mgmt_targets.target_name%TYPE
  );

  TYPE target_cvtype IS REF CURSOR RETURN target_rowtype;

  TYPE association_cvtype IS REF CURSOR RETURN association_rowtype;

  --
  -- PURPOSE
  --   gets the list of all associations
  --   originating from this target
  -- IN PARAMETERS:
  --   p_target_name :VARCHAR2
  --     The name of the specified target
  --   p_target_type : VARCHAR2
  --     The type of the specified target
  --   p_assoc_type : VARCHAR2
  --      The type of associations to be searched.
  --      If not specified, all associations are considered
  -- OUT PARAMETERS
  --   ref_cursor : association_cvtype
  --      Cursor containing all the associations.
  PROCEDURE get_associated_targets
  (
    p_target_name  IN mgmt_targets.target_name%TYPE,
    p_target_type  IN mgmt_targets.target_type%TYPE,
    p_assoc_type   IN mgmt_target_assoc_defs.association_type%TYPE DEFAULT NULL,
    ref_cursor     OUT association_cvtype
  );

  --
  -- PURPOSE
  --    gets the list of all associations
  --    originating to the specified source
  --
  -- IN PARAMETERS:
  --   p_target_name :VARCHAR2
  --     The name of the specified target
  --   p_target_type : VARCHAR2
  --     The type of the specified target
  --   p_assoc_type : VARCHAR2
  --      The type of associations to be searched.
  --      If not specified, all associations are considered
  -- OUT PARAMETERS
  --   ref_cursor : association_cvtype
  --      Cursor containing all the associations.
  PROCEDURE get_source_targets
  (
    p_target_name  IN mgmt_targets.target_name%TYPE,
    p_target_type  IN mgmt_targets.target_type%TYPE,
    p_assoc_type   IN mgmt_target_assoc_defs.association_type%TYPE DEFAULT NULL,
    ref_cursor     OUT association_cvtype
  );


  --
  -- PROCEDURE: CREATE_TARGET_ASSOC_DEF
  --
  -- PURPOSE
  --   Creates a new association def
  -- IN Parameters:
  --   p_assoc_name  : VARCHAR2
  --       The name of the association to be added
  --   p_source_target_type : VARCHAR2
  --       The type of source target
  --   p_assoc_target_type : VARCHAR2
  --       The type of associated target
  --   p_description : VARCHAR2
  --       The display name of the association to be added.
  --       If NULL defaults to association type itself
  --   p_description_nlsid  : VARCHAR2
  --       The NLS ID of the display name of the association to be added.
  --       If NULL, <association>_name is used
  --   p_assoc_type : VARCHAR2
  --       The type of the association
  --   p_scope_target_type : VARCHAR2
  --       The type of the target in whose context this Association is valid.
  --       This is required only for non-global associations.
  --   p_cardinality : NUMBER
  --       The cardinality of the association,
  --           where OPTIONAL_SINGLE_CARDINAL means 0..1 (optional)
  --                 REQUIRED_SINGLE_CARDINAL means "1" (required)
  --                 OPTIONAL_MULTI_CARDINAL  means 0..* (optional, multicardinal)
  --                 REQUIRED_MULTI_CARDINAL  means "1..*" (required, multicardinal)
  -- OUT Parameters:
  --
  -- ERROR CODES:
  --   INVALID_PARAMS_ERR : For invalid parameters
  --   ASSOC_DEF_ALREADY_EXIST : for already existing association
  PROCEDURE create_target_assoc_def
  (
    p_assoc_name           IN mgmt_target_assoc_defs.assoc_def_name%TYPE,
    p_source_target_type   IN mgmt_target_assoc_defs.source_target_type%TYPE,
    p_assoc_target_type    IN mgmt_target_assoc_defs.assoc_target_type%TYPE,
    p_scope_target_type    IN mgmt_target_assoc_defs.scope_target_type%TYPE
                                DEFAULT MGMT_ASSOC.GLOBAL_SCOPE_TARGET_TYPE,
    p_assoc_name_nlsid     IN mgmt_target_assoc_defs.name_nlsid%TYPE DEFAULT NULL,
    p_description          IN mgmt_target_assoc_defs.description%TYPE DEFAULT NULL,
    p_description_nlsid    IN mgmt_target_assoc_defs.description_nlsid%TYPE DEFAULT NULL,
    p_assoc_type           IN mgmt_target_assoc_defs.association_type%TYPE
                                DEFAULT MGMT_ASSOC.ASSOC_TYPE_RELATES_TO,
    p_cardinality          IN mgmt_target_assoc_defs.cardinality%TYPE
                                DEFAULT MGMT_ASSOC.OPTIONAL_MULTI_CARDINAL,
    p_view_prop            IN mgmt_target_assoc_defs.prop_view_priv%TYPE
                                DEFAULT MGMT_ASSOC.NO_VIEW_PROPAGATION
  );


  --
  -- PROCEDURE: DELETE_TARGET_ASSOC_DEF
  --
  -- PURPOSE
  --   deletes an association def.
  -- IN Parameters:
  --   p_assoc_name  : VARCHAR2
  --       The name of the association to be deleted
  --   p_source_target_type : VARCHAR2
  --       The type of source target
  -- OUT Parameters:
  --
  -- ERROR CODES:
  --   INVALID_PARAMS_ERR : For invalid parameters
  --   ASSOC_DOES_NOT_EXIST: No such assocaition type was found.
  --

  PROCEDURE delete_target_assoc_def
  (
    p_assoc_name         IN mgmt_target_assoc_defs.assoc_def_name%TYPE,
    p_source_target_type IN mgmt_target_assoc_defs.source_target_type%TYPE,
    p_scope_target_type  IN mgmt_target_assoc_defs.scope_target_type%TYPE
                              DEFAULT mgmt_assoc.GLOBAL_SCOPE_TARGET_TYPE
  );

  --
  -- PROCEDURE: CREATE_TARGET_ASSOC
  --
  -- PURPOSE
  --   Creates a new association
  -- IN Parameters:
  --   p_assoc_def_name  : VARCHAR2
  --       The name of the association def
  --   p_source_target_name : VARCHAR2
  --       The name of the source target
  --   p_source_target_type : VARCHAR2
  --       The type of source target
  --   p_assoc_target_name : VARCHAR2
  --       The name of associated target
  --       If NULL, it will not be modified
  --   p_assoc_target_type : VARCHAR2
  --       The type of associated target
  --       If NULL, it will not be modified
  --   p_scope_target_name : VARCHAR2
  --       The name of the target in whose context this Association is valid
  --   p_scope_target_type : VARCHAR2
  --       The type of the target in whose context this Association is valid.
  --       This is required only for non-global associations.
  --   p_is_editable : NUMBER
  --       The property that controls the association ownership
  --           where ASSOC_EDITABLE means end user can edit this association
  --                 ASSOC_NOT_EDITABLE means end-user can't edit this association
  -- OUT Parameters:
  --
  -- ERROR CODES:
  --   INVALID_PARAMS_ERR : For invalid parameters
  --   ASSOC_ALREADY_EXIST : for already existing association
  PROCEDURE create_target_assoc
  (
    p_assoc_def_name       IN mgmt_target_assoc_defs.assoc_def_name%TYPE,
    p_source_target_name   IN mgmt_targets.target_name%TYPE,
    p_source_target_type   IN mgmt_target_assoc_defs.source_target_type%TYPE,
    p_assoc_target_name    IN mgmt_targets.target_name%TYPE,
    p_assoc_target_type    IN mgmt_target_assoc_defs.assoc_target_type%TYPE,
    p_scope_target_name    IN mgmt_targets.target_name%TYPE
                                DEFAULT ' ',
    p_scope_target_type    IN mgmt_targets.target_type%TYPE
                                DEFAULT MGMT_ASSOC.GLOBAL_SCOPE_TARGET_TYPE,
    p_is_editable          IN mgmt_target_assocs.is_editable%TYPE
                                DEFAULT MGMT_ASSOC.ASSOC_NOT_EDITABLE
  );

  --
  -- PROCEDURE: DELETE_TARGET_ASSOC
  --
  -- PURPOSE
  --   deletes an association
  -- IN Parameters:
  --   p_assoc_def_name  : VARCHAR2
  --       The name of the association def
  --   p_source_target_name : VARCHAR2
  --       The name of the source target
  --   p_source_target_type : VARCHAR2
  --       The type of source target
  --   p_assoc_target_name : VARCHAR2
  --       The name of associated target
  --   p_assoc_target_type : VARCHAR2
  --       The type of associated target
  --   p_scope_target_name : VARCHAR2
  --       The name of the target in whose context this Association is valid.
  --       This is required only for non-global associations.
  --   p_scope_target_type : VARCHAR2
  --       The type of the target in whose context this Association is valid.
  --       This is required only for non-global associations.
  -- OUT Parameters:
  --
  -- ERROR CODES:
  --   INVALID_PARAMS_ERR : For invalid parameters
  --   ASSOC_DOES_NOT_EXIST: No such assocaition instance type was found.
  PROCEDURE delete_target_assoc
  (
    p_assoc_def_name      IN mgmt_target_assoc_defs.assoc_def_name%TYPE,
    p_source_target_name  IN mgmt_targets.target_name%TYPE,
    p_source_target_type  IN mgmt_target_assoc_defs.source_target_type%TYPE,
    p_assoc_target_name   IN mgmt_targets.target_name%TYPE,
    p_assoc_target_type   IN mgmt_target_assoc_defs.assoc_target_type%TYPE,
    p_scope_target_name   IN mgmt_targets.target_name%TYPE
                               DEFAULT mgmt_assoc.GLOBAL_SCOPE_TARGET_NAME,
    p_scope_target_type   IN mgmt_targets.target_type%TYPE
                               DEFAULT mgmt_assoc.GLOBAL_SCOPE_TARGET_TYPE
  );

  PROCEDURE delete_target_assoc
  (
    p_assoc_guid           IN mgmt_target_assocs.assoc_guid%TYPE,
    p_source_target_guid   IN mgmt_target_assocs.source_target_guid%TYPE,
    p_assoc_target_guid    IN mgmt_target_assocs.assoc_target_guid%TYPE,
    p_scope_target_guid    IN mgmt_target_assocs.scope_target_guid%TYPE
                                DEFAULT mgmt_assoc.GLOBAL_SCOPE_TARGET_GUID
  );

  --
  -- FUNCTION: generate_assoc_def_guid
  --
  -- PURPOSE:
  --   The association defs in the repository are identified by a globally unique
  --   identifier (guid). This function generates the guid for a given association def.
  --
  -- IN Parameters:
  --   p_source_target_type: The type of the source target
  --   p_assoc_name: The name of the assocition
  --
  -- OUT Parameters:
  --   The GUID for the given association def.
  --
  -- ERROR CODES:
  --
  --
  FUNCTION generate_assoc_def_guid
  (
    p_assoc_name         IN mgmt_target_assoc_defs.assoc_def_name%TYPE,
    p_source_target_type IN mgmt_target_assoc_defs.source_target_type%TYPE,
    p_scope_target_type  IN mgmt_targets.target_type%TYPE
                              DEFAULT mgmt_assoc.GLOBAL_SCOPE_TARGET_TYPE
  )
  RETURN mgmt_target_assoc_defs.assoc_guid%TYPE;

  --
  -- FUNCTION: get_assoc_def_guid
  --
  -- PURPOSE:
  --   The association defs in the repository are identified by a globally unique
  --   identifier (guid). This function returns the guid for a given association def.
  --
  -- IN Parameters:
  --   p_source_target_type: The type of the source target
  --   p_assoc_name: The name of the assocition
  --
  -- OUT Parameters:
  --   The GUID for the given association def.
  --
  -- ERROR CODES:
  --   ASSOCIATION_DEF_DOES_NOT_EXIST: No such association def was found.
  --
  FUNCTION get_assoc_def_guid
  (
    p_assoc_name         IN mgmt_target_assoc_defs.assoc_def_name%TYPE,
    p_source_target_type IN mgmt_target_assoc_defs.source_target_type%TYPE,
    p_scope_target_type  IN mgmt_targets.target_type%TYPE
                              DEFAULT mgmt_assoc.GLOBAL_SCOPE_TARGET_TYPE
  )
  RETURN mgmt_target_assoc_defs.assoc_guid%TYPE;

  --
  -- PROCEDURE: relocate_target
  --
  -- PURPOSE
  --   When a target is reloacted from one agent to another one ,
  --   system defined association for that target are redefined.
  -- IN Parameters:
  --   p_target_name : VARCHAR2
  --       The name of the target deleted
  --   p_target_type : VARCHAR2
  --       The type of the target deleted
  --   p_old_agent_url: VARCHAR2
  --       The url of the rarlier agent
  --   p_new_agent_url :VARCHAR2
  --       The url of the new agent
  PROCEDURE handle_relocated_target
  (
    p_target_name   IN mgmt_targets.target_name%TYPE,
    p_target_type   IN mgmt_targets.target_type%TYPE,
    p_old_agent_url IN mgmt_targets.EMD_URL%TYPE,
    p_new_agent_url IN mgmt_targets.EMD_URL%TYPE
  );

  --
  -- PROCEDURE: add_assoc_property
  --
  -- PURPOSE
  --   adds a property to an association instance.
  -- IN Parameters:
  --   p_assoc_name  : VARCHAR2
  --       The name of the association to be added
  --   p_source_target_name : VARCHAR2
  --       The name of the source target
  --   p_source_target_type : VARCHAR2
  --       The type of source target
  --   p_assoc_target_name : VARCHAR2
  --       The name of associated target
  --   p_assoc_target_type : VARCHAR2
  --       The type of associated target
  --   p_scope_target_name : VARCHAR2
  --       The name of the target in whose context this Association is valid.
  --   p_scope_target_type : VARCHAR2
  --       The type of the target in whose context this Association is valid. 
  --   p_property_name : VARCHAR2
  --       the name of the property
  --   p_property_value : VARCHAR2
  --       The value of the property
  -- OUT Parameters:
  --
  -- ERROR CODES:
  --   INVALID_PARAMS_ERR : For invalid parameters
  --   ASSOC_DOES_NOT_EXIST: No such assocaition instance type was found.
  PROCEDURE add_assoc_property
  (
    p_assoc_def_name     IN mgmt_target_assoc_defs.assoc_def_name%TYPE,
    p_source_target_name IN mgmt_targets.target_name%TYPE,
    p_source_target_type IN mgmt_target_assoc_defs.source_target_type%TYPE,
    p_assoc_target_name  IN mgmt_targets.target_name%TYPE,
    p_assoc_target_type  IN mgmt_target_assoc_defs.assoc_target_type%TYPE,
    p_scope_target_name  IN mgmt_targets.target_name%TYPE,
    p_scope_target_type  IN mgmt_target_assoc_defs.scope_target_type%TYPE,
    p_property_name      IN mgmt_target_assoc_prop_defs.property_name%TYPE,
    p_property_value     IN mgmt_target_assoc_prop.property_value%TYPE
  );

  --
  -- PROCEDURE: modify_assoc_property
  --
  -- PURPOSE
  --   modifies a property to an association instance.
  -- IN Parameters:
  --   p_assoc_name  : VARCHAR2
  --       The name of the association to be added
  --   p_source_target_name : VARCHAR2
  --       The name of the source target
  --   p_source_target_type : VARCHAR2
  --       The type of source target
  --   p_assoc_target_name : VARCHAR2
  --       The name of associated target
  --   p_assoc_target_type : VARCHAR2
  --       The type of associated target
  --   p_scope_target_name : VARCHAR2
  --       The name of the target in whose context this Association is valid. 
  --   p_scope_target_type : VARCHAR2
  --       The type of the target in whose context this Association is valid. 
  --   p_property_name : VARCHAR2
  --       the name of the property
  --   p_property_value : VARCHAR2
  --       The value of the property
  -- OUT Parameters:
  --
  -- ERROR CODES:
  --   INVALID_PARAMS_ERR : For invalid parameters
  --   ASSOC_DOES_NOT_EXIST: No such assocaition instance type was found.
  PROCEDURE modify_assoc_property
  (
    p_assoc_def_name     IN mgmt_target_assoc_defs.assoc_def_name%TYPE,
    p_source_target_name IN mgmt_targets.target_name%TYPE,
    p_source_target_type IN mgmt_target_assoc_defs.source_target_type%TYPE,
    p_assoc_target_name  IN mgmt_targets.target_name%TYPE,
    p_assoc_target_type  IN mgmt_target_assoc_defs.assoc_target_type%TYPE,
    p_scope_target_name  IN mgmt_targets.target_name%TYPE,
    p_scope_target_type  IN mgmt_target_assoc_defs.scope_target_type%TYPE,
    p_property_name      IN mgmt_target_assoc_prop_defs.property_name%TYPE,
    p_property_value     IN mgmt_target_assoc_prop.property_value%TYPE
  );

  --
  -- PROCEDURE: delete_assoc_property 
  --
  -- PURPOSE
  --   modifies a property of the association. If the property doen't exists, it will create it.
  -- IN Parameters:
  --   p_assoc_name  : VARCHAR2 
  --       The name of the association to be added
  --   p_source_target_name : VARCHAR2 
  --       The name of the source target
  --   p_source_target_type : VARCHAR2 
  --       The type of source target
  --   p_assoc_target_name : VARCHAR2 
  --       The name of associated target
  --   p_assoc_target_type : VARCHAR2 
  --       The type of associated target
  --   p_scope_target_name : VARCHAR2 
  --       The name of the target in whose context this Association is valid.
  --   p_scope_target_type : VARCHAR2
  --       The type of the target in whose context this Association is valid.
  --   p_property_name : VARCHAR2 
  --       the name of the property 
  -- OUT Parameters:
  --
  -- ERROR CODES:
  --   INVALID_PARAMS_ERR : For invalid parameters
  --   ASSOC_DOES_NOT_EXIST: No such assocaition instance type was found.
  PROCEDURE delete_assoc_property
  (
    p_assoc_def_name     IN mgmt_target_assoc_defs.assoc_def_name%TYPE,
    p_source_target_name IN mgmt_targets.target_name%TYPE,
    p_source_target_type IN mgmt_target_assoc_defs.source_target_type%TYPE,
    p_assoc_target_name  IN mgmt_targets.target_name%TYPE,
    p_assoc_target_type  IN mgmt_target_assoc_defs.assoc_target_type%TYPE,
    p_scope_target_name  IN mgmt_targets.target_name%TYPE,
    p_scope_target_type  IN mgmt_target_assoc_defs.scope_target_type%TYPE,
    p_property_name      IN mgmt_target_assoc_prop_defs.property_name%TYPE
  );

  -- Creates a list of associations of the specified association type.
  -- This flavor does not support taking scope target as an argument. 
  -- Example: When a group is created or modified, this API will be used
  PROCEDURE create_target_assocs
  (
    p_assoc_def_name       IN mgmt_target_assoc_defs.assoc_def_name%TYPE,
    p_source_target_name   IN mgmt_targets.target_name%TYPE,
    p_source_target_type   IN mgmt_target_assoc_defs.source_target_type%TYPE,
    p_assoc_targets_list   IN SMP_EMD_NVPAIR_ARRAY,
    p_is_editable          IN mgmt_target_assocs.is_editable%TYPE
                                DEFAULT MGMT_ASSOC.ASSOC_NOT_EDITABLE,
    p_created_by           IN mgmt_target_assocs.created_by%TYPE
                                DEFAULT mgmt_assoc.CREATED_BY_END_USER,
    p_suppress_error       IN BOOLEAN DEFAULT FALSE 
  );

  PROCEDURE create_target_assocs
  (
    p_assoc_guid           IN mgmt_target_assocs.assoc_guid%TYPE,
    p_source_target_guid   IN mgmt_target_assocs.source_target_guid%TYPE,
    p_assoc_targets_list   IN MGMT_GUID_ARRAY,
    p_is_editable          IN mgmt_target_assocs.is_editable%TYPE
                                DEFAULT MGMT_ASSOC.ASSOC_NOT_EDITABLE,
    p_created_by           IN mgmt_target_assocs.created_by%TYPE
                                DEFAULT mgmt_assoc.CREATED_BY_END_USER,
    p_suppress_error       IN BOOLEAN DEFAULT FALSE 
  );

  --
  -- Creates a list of associations of the specified association type
  -- with in a given scope target.
  -- Example: When system association is created, this API will be used
  -- to instantiate all the scoped associations. 
  --
  PROCEDURE create_target_assocs
  (
    p_assoc_def_name       IN mgmt_target_assoc_defs.assoc_def_name%TYPE,
    p_scope_target_name    IN mgmt_targets.target_name%TYPE,
    p_scope_target_type    IN mgmt_target_assoc_defs.scope_target_type%TYPE,
    p_assoc_list           IN MGMT_NVPAIR_TUPLE_LIST,
    p_is_editable          IN mgmt_target_assocs.is_editable%TYPE
                                DEFAULT MGMT_ASSOC.ASSOC_NOT_EDITABLE,
    p_created_by           IN mgmt_target_assocs.created_by%TYPE
                                DEFAULT mgmt_assoc.CREATED_BY_END_USER,
    p_suppress_error       IN BOOLEAN DEFAULT FALSE 
  );

  PROCEDURE create_target_assocs
  (
    p_assoc_guid           IN mgmt_target_assocs.assoc_guid%TYPE,
    p_scope_target_guid    IN mgmt_target_assocs.scope_target_guid%TYPE,
    p_assoc_list           IN MGMT_GUID_PAIR_ARRAY,
    p_is_editable          IN mgmt_target_assocs.is_editable%TYPE
                                DEFAULT MGMT_ASSOC.ASSOC_NOT_EDITABLE,
    p_created_by           IN mgmt_target_assocs.created_by%TYPE
                                DEFAULT mgmt_assoc.CREATED_BY_END_USER,  
    p_suppress_error       IN BOOLEAN DEFAULT FALSE 
  );

  --
  -- Replaces the existing associations of type "p_assoc_def_name" with the
  -- the new list.  If the new list is null, should remove all the existing assocs. 
  -- This is again for the groups case.
  --
  PROCEDURE set_target_assocs
  (
    p_assoc_def_name       IN mgmt_target_assoc_defs.assoc_def_name%TYPE,
    p_source_target_name   IN mgmt_targets.target_name%TYPE,
    p_source_target_type   IN mgmt_target_assoc_defs.source_target_type%TYPE,
    p_assoc_targets_list   IN SMP_EMD_NVPAIR_ARRAY,
    p_is_editable          IN mgmt_target_assocs.is_editable%TYPE
                                DEFAULT MGMT_ASSOC.ASSOC_NOT_EDITABLE
  );

   PROCEDURE set_target_assocs
   (
     p_assoc_guid           IN mgmt_target_assocs.assoc_guid%TYPE,
     p_source_target_guid   IN mgmt_target_assocs.source_target_guid%TYPE,
     p_assoc_targets_list   IN MGMT_GUID_ARRAY,
     p_is_editable          IN mgmt_target_assocs.is_editable%TYPE
                                 DEFAULT MGMT_ASSOC.ASSOC_NOT_EDITABLE
  );

  --
  -- Replaces the existing associations of type "p_assoc_def_name" with the
  -- the new list. If the new list is null, should remove all the existing assocs.
  --  This corresponds to systems case.
  --
  PROCEDURE set_target_assocs
  (
    p_assoc_def_name       IN mgmt_target_assoc_defs.assoc_def_name%TYPE,
    p_scope_target_name    IN mgmt_targets.target_name%TYPE,
    p_scope_target_type    IN mgmt_target_assoc_defs.source_target_type%TYPE,
    p_assoc_list           IN MGMT_NVPAIR_TUPLE_LIST,
    p_is_editable          IN mgmt_target_assocs.is_editable%TYPE
                                DEFAULT MGMT_ASSOC.ASSOC_NOT_EDITABLE
  );


  PROCEDURE set_target_assocs
  (
    p_assoc_guid           IN mgmt_target_assocs.assoc_guid%TYPE,
    p_scope_target_guid    IN mgmt_target_assocs.source_target_guid%TYPE,
    p_assoc_list           IN MGMT_GUID_PAIR_ARRAY,
    p_is_editable          IN mgmt_target_assocs.is_editable%TYPE
                                DEFAULT MGMT_ASSOC.ASSOC_NOT_EDITABLE
  );

  -- 
  -- Deletes all the associations of the specified assoc type
  -- for the given source target. This also allow deleting
  -- assocs of all types, by taking NULL for assocdefname
  -- parameter  
  -- 
  PROCEDURE delete_target_assocs
  (
    p_assoc_def_name       IN mgmt_target_assoc_defs.assoc_def_name%TYPE,
    p_source_target_name   IN mgmt_targets.target_name%TYPE,
    p_source_target_type   IN mgmt_target_assoc_defs.source_target_type%TYPE,
    p_assoc_targets_list   IN SMP_EMD_NVPAIR_ARRAY DEFAULT NULL,
    p_suppress_error       IN BOOLEAN DEFAULT FALSE 
  );


  PROCEDURE delete_target_assocs
  (
    p_assoc_guid         IN mgmt_target_assocs.assoc_guid%TYPE,
    p_source_target_guid IN mgmt_target_assocs.source_target_guid%TYPE,
    p_suppress_error     IN BOOLEAN DEFAULT FALSE 
  );

  -- 
  -- Deletes all the associations with the specified scope target type.
  -- his also allow deleting assocs of all types, by taking NULL for assocdefname 
  -- parameter  
  PROCEDURE delete_assocs_in_scope
  (
    p_assoc_def_name       IN mgmt_target_assoc_defs.assoc_def_name%TYPE,
    p_scope_target_name    IN mgmt_targets.target_name%TYPE,
    p_scope_target_type    IN mgmt_target_assoc_defs.source_target_type%TYPE,
    p_suppress_error       IN BOOLEAN DEFAULT FALSE 
  );


  PROCEDURE delete_assocs_in_scope
  (
    p_assoc_guid        IN mgmt_target_assocs.assoc_guid%TYPE,
    p_scope_target_guid IN mgmt_target_assocs.scope_target_guid%TYPE,
    p_suppress_error    IN BOOLEAN DEFAULT FALSE 
  );

  -- This procdere will be at the beginning of rowset from loader 
  PROCEDURE start_assoc_rowset;

  -- This procdere will be at the end of rowset from loader 
  PROCEDURE end_assoc_rowset;

  -- This procedure will be called from loader when membership data comes from 10gR1 agent
  PROCEDURE add_member_from_loader
  (
     p_composite_target_name  IN mgmt_targets.target_name%TYPE ,
     p_composite_target_type  IN mgmt_targets.target_type%TYPE ,
     p_composite_target_guid  IN mgmt_targets.target_guid%TYPE DEFAULT NULL,
     p_member_target_name     IN mgmt_targets.target_name%TYPE ,
     p_member_target_type     IN mgmt_targets.target_type%TYPE ,
     p_member_target_guid     IN mgmt_targets.target_guid%TYPE DEFAULT NULL,
     p_association            IN VARCHAR2 DEFAULT NULL
  );
 
  -- This procedure will be called from loader when loader sees assoc rowset 
  PROCEDURE add_assoc_from_loader
  (
     p_assoc_guid         IN mgmt_target_assocs.assoc_guid%TYPE,
     p_source_target_guid IN mgmt_target_assocs.source_target_guid%TYPE,
     p_assoc_target_guid  IN mgmt_target_assocs.assoc_target_guid%TYPE,
     p_scope_target_guid  IN mgmt_target_assocs.scope_target_guid%TYPE DEFAULT mgmt_assoc.GLOBAL_SCOPE_TARGET_GUID,
     p_is_editable        IN mgmt_target_assocs.is_editable%TYPE DEFAULT mgmt_assoc.ASSOC_NOT_EDITABLE 
  );

  --
  -- PROCEDURE: recreate_flat_assoc_list
  --
  -- PURPOSE
  --   To recreate all entry in mgmt_flat_target_assoc for given target
  --   To be used during upgrade of repository or if required to recreate all entry in flat table
  -- IN Parameters:
  --   p_target_guid : Target for which flat assoc entries needs to be recreate
  --
  PROCEDURE recreate_flat_target_list
  (
    p_target_guid mgmt_targets.target_guid%TYPE
  ) ;

  -- to be use in upgrade case only.
  -- It would recreate flat assoc table entry for all targets

  PROCEDURE recreate_full_flat_assoc ;

END em_assoc;
/
