Rem drv: <create type="pkgdefs" pos="crypt/crypt_pkgdef.plb+"/>
Rem
Rem $Header: audit_admin_pkgdef.sql 18-may-2007.12:34:00 pshishir Exp $
Rem
Rem audit_admin_pkgdef.sql
Rem
Rem Copyright (c) 2004, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      audit_admin_pkgdef.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    pshishir    05/18/07 - Adding custom attributes 
Rem    gsbhatia    07/23/05 - Fix repmgr header. Change reference to 
Rem                           crypt_pkgdef.plb instead of .sql 
Rem    gsbhatia    07/23/05 - Fix repmgr header 
Rem    gsbhatia    07/01/05 - New repmgr header impl 
Rem    shianand    02/03/05 - shianand_audit
Rem    shianand    12/13/04 - Created
Rem



CREATE OR REPLACE PACKAGE MGMT_AUDIT_ADMIN IS

--Constants for setting the mode of audit
AUDIT_MODE_DB           constant NUMBER(1) :=0; 
AUDIT_MODE_FILE         constant NUMBER(1) :=1;
AUDIT_MODE_DB_FILE      constant NUMBER(1) :=2; 

--Constants for setting the level of audit
AUDIT_LEVEL_ALL         constant NUMBER(1) :=0; 
AUDIT_LEVEL_SELECTED    constant NUMBER(1) :=1;
AUDIT_LEVEL_NONE        constant NUMBER(1) :=2; 

--Constants for setting the level of audit for different operation codes
OPERATION_AUDIT_ON      constant NUMBER(1) :=0; 
OPERATION_AUDIT_OFF     constant NUMBER(1) :=1; 

-- Constants for Custom attribute
G_CA_NOT_REQUIRED constant NUMBER(1) := 0;
G_CA_REQUIRED     constant NUMBER(1) := 1;
G_MAX_CA_ALLOWED  constant NUMBER(1) := 3;

--The following Procedure sets the audit on or off with the data storage 
--information - DB or file
PROCEDURE set_audit (p_audit_mode        IN NUMBER   DEFAULT AUDIT_MODE_DB,
                     p_audit_destination IN VARCHAR2 DEFAULT NULL,
                     p_audit_level       IN NUMBER   DEFAULT AUDIT_LEVEL_NONE);


--This Procedure registers a new operation code to include that operation for 
--auditing.
PROCEDURE register_operation_code (p_op_code               IN NUMBER,
                                   p_operation_description IN VARCHAR2,
                                   p_operation_audit       IN NUMBER   DEFAULT OPERATION_AUDIT_OFF,
                                   p_audit_column_name1    IN VARCHAR2 DEFAULT NULL,
                                   p_audit_column_name2    IN VARCHAR2 DEFAULT NULL,
                                   p_audit_column_name3    IN VARCHAR2 DEFAULT NULL,
                                   p_audit_column_name4    IN VARCHAR2 DEFAULT NULL,
                                   p_audit_column_name5    IN VARCHAR2 DEFAULT NULL,
                                   p_audit_column_name6    IN VARCHAR2 DEFAULT NULL,
                                   p_audit_column_name7    IN VARCHAR2 DEFAULT NULL,
                                   p_audit_column_name8    IN VARCHAR2 DEFAULT NULL,
                                   p_audit_column_name9    IN VARCHAR2 DEFAULT NULL,
                                   p_audit_column_name10   IN VARCHAR2 DEFAULT NULL,
                                   p_audit_column_name11   IN VARCHAR2 DEFAULT NULL,
                                   p_audit_column_name12   IN VARCHAR2 DEFAULT NULL,
                                   p_audit_column_name13   IN VARCHAR2 DEFAULT NULL,
                                   p_audit_column_name14   IN VARCHAR2 DEFAULT NULL,
                                   p_audit_column_name15   IN VARCHAR2 DEFAULT NULL,
                                   p_audit_clob_name1      IN VARCHAR2 DEFAULT NULL);


--This Procedure unregisters an operation code to exclude that operation from 
--auditing.
PROCEDURE unregister_operation_code (p_op_code IN NUMBER);


--When the global audit flag is AUDIT_LEVEL_SELECTED, then this Procedure 
--sets the audit flag on for a particular operation
PROCEDURE set_audit_on (p_op_code IN NUMBER);


--When the global audit flag is AUDIT_LEVEL_SELECTED, then this Procedure 
--unsets the audit flag on for a particular operation
PROCEDURE set_audit_off (p_op_code IN NUMBER);


--This procedure purges all the records from audit table, currently the purge 
--can be used by SYSMAN but it may change in the future. User with admin 
--priviledge to use this package can purge the audit records which will be other
--than SYSMAN.
PROCEDURE audit_purge (p_time_stamp IN DATE := sysdate+1);


--This procedure returns the value of global audit flag as on or off or 
--selected, which is stored as package variable
PROCEDURE audit_level (p_audit_level OUT NUMBER);

--This procedure generates and stores the user session id guid into package 
--variable.
PROCEDURE gen_user_session_id_guid (p_user_session_id_guid OUT RAW);


--This procedure sets the user session id guid into the package variable.
PROCEDURE set_user_session_id_guid (p_user_session_id_guid IN RAW);

--This function returns the user session id guid from package variable.
FUNCTION get_user_session_id_guid RETURN RAW;


--This Procedure sets the user session information into mgmt_user_session table
PROCEDURE set_user_info(p_user_session_id_guid  IN RAW,
                        p_user_session_id       IN RAW,
                        p_em_user               IN VARCHAR2 DEFAULT NULL,
                        p_em_user_type          IN VARCHAR2 DEFAULT NULL,
                        p_em_user_host_name     IN VARCHAR2 DEFAULT NULL,
                        p_oms_host_name         IN VARCHAR2 DEFAULT NULL,
                        p_browser_type          IN VARCHAR2 DEFAULT NULL,
                        p_login_time            IN DATE DEFAULT NULL,
                        p_ip_address            IN VARCHAR2 DEFAULT NULL,
                        p_session_status        IN VARCHAR2 DEFAULT NULL,
                        p_session_type          IN VARCHAR2 DEFAULT NULL,
                        p_time_zone             IN VARCHAR2 DEFAULT NULL);


--This Procedure updates the user record in mgmt_user_session table with logoff
--information
PROCEDURE update_user_info(p_user_session_id_guid IN RAW,
                           p_logoff_time          IN DATE DEFAULT NULL,
                           p_session_status       IN VARCHAR2 DEFAULT NULL);

---------------------------------------------------------------
--    Registration and DeRestration APIs for Custom attribute
---------------------------------------------------------------

-- This procedure is to be used by the user to register custom attributes 
-- with Audit framework. This procedure throws a DUPLICATE_AUDIT_OBJECT
-- exception, if the custom attribute name being registered already exists.

PROCEDURE register_audit_custom_attrib(
    p_ca_name           IN VARCHAR2,
    p_ca_display_name   IN VARCHAR2  DEFAULT NULL,
    p_ca_description    IN VARCHAR2  DEFAULT NULL,
    p_ca_required       IN NUMBER    DEFAULT G_CA_NOT_REQUIRED);

-- This procedure is to be used by the user to register custom attributes 
-- with Audit framework. This procedure throws a DUPLICATE_AUDIT_OBJECT
-- exception, if the custom attribute name being registered already exists.

PROCEDURE register_audit_custom_attribs(
    p_ca_array  IN MGMT_AUDIT_CUSTOM_ATTRIB_ARRAY);

-- This procedure is to be used by the user to deregister custom attributes 
-- from Audit framework. This procedure throws a AUDIT_OBJECT_DOES_NOT_EXIST
-- exception, if the custom attribute name being registered not found.

PROCEDURE deregister_audit_custom_attrib( p_ca_name IN VARCHAR2);

-- This procedure is to be used by the user to get custom attributes 
-- which has been registered with Audit framework. This procedure also
-- return the total count of audit custom attributes registered with Audit
-- Framework.

PROCEDURE get_audit_custom_attribs(
    p_ca_array  OUT MGMT_AUDIT_CUSTOM_ATTRIB_ARRAY,
    p_ca_count  OUT NUMBER);

--This Procedure updates the user record in mgmt_user_session table with custom attributes
--information

PROCEDURE update_ca_for_user(
    p_user_session_id_guid IN RAW,
    p_ca_name_1          IN   VARCHAR2 DEFAULT NULL,
    p_ca_value_1         IN   VARCHAR2 DEFAULT NULL,
    p_ca_name_2          IN   VARCHAR2 DEFAULT NULL,
    p_ca_value_2         IN   VARCHAR2 DEFAULT NULL,
    p_ca_name_3          IN   VARCHAR2 DEFAULT NULL,
    p_ca_value_3         IN   VARCHAR2 DEFAULT NULL);

END MGMT_AUDIT_ADMIN;

/
show errors;


