Rem
Rem $Header: emcore/source/oracle/sysman/emdrep/sql/core/latest/availability/availability_master_agent_pkgdef.sql /st_emcore_10.2.0.4.2db11.2/2 2009/03/25 11:24:45 joyoon Exp $
Rem
Rem availability_master_agent_pkgdef.sql
Rem
Rem Copyright (c) 2003, 2009, Oracle and/or its affiliates. 
Rem All rights reserved. 
Rem
Rem    NAME
Rem      availability_master_agent_pkgdef.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      For multi-agent targets like clusters, one of the agents is chosen
Rem      as a master agent. Master agent is responsible for monitoring and
Rem      managing the target for the period during which it is master. This
Rem      package contains the implementation of master agent handling.
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    rkpandey    07/19/05 - Expose set_master_agent 
Rem    neearora    03/03/05 - Added MODULE_NAME constant 
Rem    ramalhot    02/17/05 - added handle_agent_port_change 
Rem    streddy     11/30/03 - Added blackout functions 
Rem    streddy     09/25/03 - Handle unreachable changes correctly 
Rem    rpinnama    09/08/03 - Add purge policy for MGMT_MASTER_AGENT 
Rem    streddy     07/22/03 - Added master_agent_changed callback
Rem    streddy     06/30/03 - Added process_cluster_instance_changes
Rem    streddy     06/11/03 - streddy_master_agent_support
Rem    streddy     04/24/03 - Created
Rem

CREATE OR REPLACE PACKAGE em_master_agent AS

-- Constant for module name
MODULE_NAME CONSTANT VARCHAR2(15) := 'EM_MASTER_AGENT';

-- DELETE THIS STUFF AFTER RELOADING REPOSITORY
NON_MASTER_AGENT_ERR CONSTANT INTEGER := -20614;
non_master_agent EXCEPTION;
PRAGMA EXCEPTION_INIT(non_master_agent, -20614);
NON_MASTER_AGENT_ERR_M CONSTANT VARCHAR2(128) := 'Severity loaded from a non-master agent for the target. ';


-- ignore master check
p_ignore_master_check BOOLEAN := FALSE;

--
-- PURPOSE
--   Initializes master agent for a target. This is called
--   when a target is added to the repository for the firt
--   time.
--
PROCEDURE initialize_master_agent(v_target_guid IN RAW,
                                  v_agent_guid  IN RAW,
                                  v_timestamp   IN DATE);

--
-- PURPOSE
--   Processes new master agent selections.
--     o Closes the previous master agent record
--     o Submits a job to make previous master a standby
--     o Submits a job to set the new master agent
-- This is called from BEFORE INSERT TRIGGER of mgmt_master_agent table
PROCEDURE process_new_master_agent(v_target_guid IN RAW,
                                   v_new_master_guid IN RAW,
                                   v_timestamp IN DATE);

-- PURPOSE
--    Sets a new master agent 
PROCEDURE set_new_master_agent(v_target_guid IN RAW,
                               v_agent_guid IN RAW,
                               v_timestamp  IN DATE);

--
-- PURPOSE
--   Processes agent availability changes. If this agent is monitoring any
--   multi-agent targets, then master agent settings are appropriately
--   updated for these targets.
--
PROCEDURE process_agent_avail_change(v_agent_guid IN RAW,
                                     v_agent_new_status IN NUMBER,
                                     v_timestamp IN DATE);


--
-- PURPOSE
--  Processes cluster instance availability changes. If the cluster
--  instance on the current master goes down, then this procedure
--  initiates re-mastering.
--
PROCEDURE process_cluster_inst_changes(v_target_guid IN RAW,
                                       v_new_status  IN NUMBER,
                                       v_timestamp   IN DATE);

-- 
-- PURPOSE
--   Returns true if the specified emd_url is the agent_url
--   of the specified target for the specified timestamp
--
FUNCTION is_master_agent_for_ts(v_target_guid IN RAW,
                                v_emd_url IN VARCHAR2,
                                v_timestamp IN DATE)
  RETURN BOOLEAN;                                 


--
-- PURPOSE
--   Submits a job to mark an agent as the master agent
--
PROCEDURE submit_master_agent_job(v_target_guid IN RAW,
                                  v_agent_guid  IN RAW,
                                  v_timestamp   IN DATE);


--
-- PURPOSE
--   Submits a job to mark an agent as a standby agent
--
PROCEDURE submit_standby_agent_job(v_target_guid IN RAW,
                                   v_emd_url IN VARCHAR2,
                                   v_timestamp IN DATE);


--
-- PURPOSE
--   Submits a job to mark an agent as a standby agent
--
PROCEDURE submit_standby_agent_job(v_target_name IN VARCHAR2,
                                   v_target_type IN VARCHAR2,
                                   v_emd_url IN VARCHAR2,
                                   v_timestamp IN DATE);


--
-- PURPOSE
--  Given a target guid and an agent guid, this procedure processes the
--  target and marks the agent as standby if a master is already present
--  for the target.
--  This is called when a new agent is added for a multi-agent target.
PROCEDURE update_agent_mon_status(v_target_guid IN RAW,
                                  v_agent_guid IN RAW);



--
-- PURPOSE
--    Select new master
PROCEDURE process_agent_deletion(v_agent_guid IN RAW);

--
-- PURPOSE
--    Select new master in case that master instance is deleted
PROCEDURE process_instance_deletion(v_instance_target_guid IN RAW);

--
-- Adds a master changed callback. The signature of the callback is:
--   procedure callback_name(v_target_name IN VARCHAR2,
--                           v_target_type IN VARCHAR2,
--                           v_master_agent_url IN VARCHAR2)
--  
PROCEDURE ADD_MASTER_CHANGED_CALLBACK(v_target_name IN VARCHAR2,
                                      v_target_type IN VARCHAR2,
                                      v_callback_name IN VARCHAR2);

-- Deletes a master changed callback
PROCEDURE DELETE_MASTER_CHANGED_CALLBACK(v_target_name IN VARCHAR2,
                                         v_target_type IN VARCHAR2,
                                         v_callback_name IN VARCHAR2
                                                          DEFAULT NULL);
--
-- PURPOSE
--  Change master agent for given target_guid 
--
PROCEDURE change_master_agent(v_target_guid IN RAW,
                              v_curr_master_guid IN RAW,
                              v_timestamp   IN DATE,
                              v_force_change IN BOOLEAN,
                              v_new_master_guid OUT RAW);


  -- Purge policy for cleaning master agent data
  TYPE t_rowid_list IS TABLE OF ROWID INDEX BY BINARY_INTEGER;

  PROCEDURE MASTER_AGENT_HIST_PURGE(pcb_params IN OUT MGMT_PURGE_CALLBACK_PARAMS);

  -- This procedure handles the case when agent
  -- port number is changed. 
  PROCEDURE handle_agent_port_change
  (
    p_old_agent_guid IN mgmt_targets.target_guid%TYPE,
    p_new_agent_guid IN mgmt_targets.target_guid%TYPE
  );

-- Selects a master agent for the specified target
PROCEDURE SELECT_MASTER_AGENT(v_target_guid IN RAW,
                              v_timestamp IN DATE);

-- Sets the list of blacked out targets
PROCEDURE SET_BLACKOUT_TARGET_LIST(v_target_list IN MGMT_GUID_ARRAY);

-- Clears the list of blacked out target list
PROCEDURE CLEAR_BLACKOUT_TARGET_LIST;

-- list of blacked out targets
p_blacked_out_targets  MGMT_GUID_ARRAY;

--
-- PROCEDURE: instance_pre_del_callback
-- PURPOSE
--   callback when an instance is about to be deleted. Will cleanup the
--   dependens assocs and metric dependency for all services running on it
PROCEDURE INSTANCE_PRE_DEL_CALLBACK(v_target_name IN VARCHAR2,
                                    v_target_type IN VARCHAR2,
                                    v_target_guid IN RAW);



END em_master_agent;

/

show errors

