Rem drv: <create type="pkgbodys"/>
Rem
Rem $Header: bam_pkgbody.sql 27-nov-2006.13:56:35 skkunise Exp $
Rem
Rem bam_pkgdef.sql
Rem
Rem Copyright (c) 2006, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      bam_pkgdef.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    skkunise    05/25/06 - Fix typo in description 
Rem    skkunise    01/16/06 - Created
Rem


CREATE OR REPLACE PACKAGE BODY EM_BAM_UTIL IS

  G_MODULE constant VARCHAR2(64) := 'BAM';

  PROCEDURE CREATE_BAM_NOTIF_DEVICE(p_servername_in IN VARCHAR2)
  IS
    l_device_name VARCHAR2(100);
  BEGIN

    -- construct a device name
   l_device_name := '_' || p_servername_in || G_DEVICE_SUFFIX_NAME;
   IF emdw_log.p_is_debug_set THEN
     emdw_log.debug('CREATE_BAM_NOTIF_DEVICE::Device name: ' || l_device_name,
       G_MODULE);
   END IF;

   -- create a notification device with this name
   MGMT_NOTIFICATION.ADD_JAVA_DEVICE(l_device_name, 'SYSMAN', 
      G_DEVICE_CLASS_NAME,
     'System generated notification device for data exchange hub ' || p_servername_in,
     MGMT_MEDIUM_STRING_TABLE(p_servername_in)) ; 

 END CREATE_BAM_NOTIF_DEVICE;


 PROCEDURE CREATE_BAM_NOTIF_RULE(p_servername_in IN VARCHAR2,
                                 p_sessionname_in IN VARCHAR2)
 IS
   l_device_name VARCHAR2(100);
   l_rule_name VARCHAR2(100);
   l_rule_exists_val NUMBER(1) := MGMT_GLOBAL.G_FALSE;
 BEGIN

   -- construct a device name
   l_device_name := '_' || p_servername_in || G_DEVICE_SUFFIX_NAME;
  
   -- construct a rule name
   l_rule_name := '_' || p_sessionname_in || G_RULE_SUFFIX_NAME;

   IF emdw_log.p_is_debug_set THEN
     emdw_log.debug ('CREATE_BAM_NOTIF_RULE::Rule name: ' || l_rule_name,
       G_MODULE);
     emdw_log.debug ('CREATE_BAM_NOTIF_RULE::Device name: ' || l_device_name,
       G_MODULE);
   END IF;

   -- figure out if rule  exists
   l_rule_exists_val := EMD_NOTIFICATION.RULE_EXISTS (l_rule_name, 'SYSMAN');

   -- create a rule if it doesn't exist
   IF (l_rule_exists_val=MGMT_GLOBAL.G_FALSE)
   THEN

     -- create notiification rule with this name
     EMD_NOTIFICATION.ADD_NOTIFICATION_RULE(l_rule_name,'SYSMAN', 
       'System generated notification rule for data exchange session ' || p_sessionname_in) ; 

     -- add device to this rule
     MGMT_NOTIFICATION.ADD_DEVICE_TO_RULE(l_rule_name, 'SYSMAN', 
       l_device_name, 'SYSMAN') ; 

   END IF;

 END CREATE_BAM_NOTIF_RULE;

END EM_BAM_UTIL;
/
show errors;
