Rem drv: <create type="pkgbodys"/>
Rem
Rem $Header: bam_service_pkgbody.sql 28-nov-2006.18:31:08 skkunise Exp $
Rem
Rem bam_service_pkgbody.sql
Rem
Rem Copyright (c) 2006, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      bam_service_pkgbody.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    skkunise    04/26/06 - Fix the disable bug 
Rem    eporter     04/19/06 - add getter method to see if bam is already 
Rem                           enabled 
Rem    skkunise    03/28/06 - Created
Rem


CREATE OR REPLACE PACKAGE BODY EM_BAM_SERVICE IS

   G_MODULE CONSTANT VARCHAR2(30) := 'EM_BAM_SERVICE';
  
   -- 
   -- package private functions
   --
   -- Customizes UI pages with business consumption for the given target instance
   PROCEDURE CUSTOMIZE_PAGES_FOR_BIZDATA (
     p_target_name IN VARCHAR2,
     p_target_type IN VARCHAR2
   )
   IS
     l_customization_data  SMP_EMD_NVPAIR_ARRAY;
     l_conditions     SMP_EMD_NVPAIR_ARRAY;
     CUSTOMIZATION_EXISTS EXCEPTION;
     PRAGMA EXCEPTION_INIT(CUSTOMIZATION_EXISTS, -20955); 
   BEGIN

     if (p_target_name IS NULL) or (p_target_type IS NULL) THEN
       MGMT_LOG.LOG_ERROR (G_MODULE, null, 'target name and type cannot be null '
         || 'target name: ' || p_target_name || ' target type: ' || p_target_type);
     END IF;

     -- add the customization property
     l_customization_data := SMP_EMD_NVPAIR_ARRAY();
     l_customization_data.extend;
     l_customization_data(1) := SMP_EMD_NVPAIR(EM_SERVICE.G_SVC_HAS_BUSINESS, 'true');

     -- add the conditions
     l_conditions := SMP_EMD_NVPAIR_ARRAY();
     l_conditions.extend;
     l_conditions(1) := SMP_EMD_NVPAIR('target', p_target_name);
     l_conditions.extend; 
     l_conditions(2) := SMP_EMD_NVPAIR('type', p_target_type);
  
     -- register the customizations
     BEGIN
       mgmt_page_custmzn.add_page_customzn_conditions(mgmt_service.G_SERVICE_CHARTS_PAGE, 
            l_customization_data, l_conditions);
       mgmt_page_custmzn.add_page_customzn_conditions(mgmt_service.G_SERVICE_HOME_PAGE, 
            l_customization_data, l_conditions);
     EXCEPTION
       -- ignore if already customized
       WHEN CUSTOMIZATION_EXISTS THEN
         IF emdw_log.p_is_debug_set THEN
           emdw_log.debug('Cannot add  page custimzations for target ' || p_target_name,
                          G_MODULE);
         END IF;
         -- MGMT_LOG.LOG_ERROR (G_MODULE, null, 'Cannot add  page custimzations for target '
         --              || p_target_name);
     END;
    
   END CUSTOMIZE_PAGES_FOR_BIZDATA;

   -- DeCustomizes UI pages with business consumption for the given target instance
   PROCEDURE DECUSTOMIZE_PAGES_FOR_BIZDATA (
     p_target_name IN VARCHAR2,
     p_target_type IN VARCHAR2
   )
   IS
     l_customization_data  SMP_EMD_NVPAIR_ARRAY;
     l_conditions     SMP_EMD_NVPAIR_ARRAY;
   BEGIN

     if (p_target_name IS NULL) or (p_target_type IS NULL) THEN
       MGMT_LOG.LOG_ERROR (G_MODULE, null, 'target name and type cannot be null '
         || 'target name: ' || p_target_name || ' target type: ' || p_target_type);
     END IF;

     -- add the customization property
     l_customization_data := SMP_EMD_NVPAIR_ARRAY();
     l_customization_data.extend;
     l_customization_data(1) := SMP_EMD_NVPAIR(EM_SERVICE.G_SVC_HAS_BUSINESS, 'true');

     -- add the conditions
     l_conditions := SMP_EMD_NVPAIR_ARRAY();
     l_conditions.extend;
     l_conditions(1) := SMP_EMD_NVPAIR('target', p_target_name);
     l_conditions.extend; 
     l_conditions(2) := SMP_EMD_NVPAIR('type', p_target_type);
  
     -- deregister the customizations
     BEGIN
       -- todo: remove hardcoded references to page names
       mgmt_page_custmzn.remove_page_customzn_condns(mgmt_service.G_SERVICE_CHARTS_PAGE, 
            l_customization_data, l_conditions);

       mgmt_page_custmzn.remove_page_customzn_condns(mgmt_service.G_SERVICE_HOME_PAGE, 
            l_customization_data, l_conditions);
       EXCEPTION
         -- ignore if there are any errors
         WHEN OTHERS THEN
           IF emdw_log.p_is_debug_set THEN
             emdw_log.debug('Cannot remove page custimzations for target ' || p_target_name,
                          G_MODULE);
           END IF;
           -- MGMT_LOG.LOG_ERROR (G_MODULE, null, 'Cannot remove page custimzations for target '
           --            || p_target_name);

     END;
    
 
   END DECUSTOMIZE_PAGES_FOR_BIZDATA;

   -- enables or disables the has_business property on the target instance
   PROCEDURE SET_HAS_BUSINESS_PROPERTY  (
     p_target_name IN VARCHAR2,
     p_target_type IN VARCHAR2,
     p_enable IN VARCHAR2 default 'true'
   ) IS
   BEGIN
     -- set the property
     MGMT_TARGET.SET_INSTANCE_TARGET_PROPERTY(p_target_name, p_target_type,
	 EM_SERVICE.G_SVC_HAS_BUSINESS, p_enable);

   END SET_HAS_BUSINESS_PROPERTY;

   --         PUBLIC FUNCTIONS       --

   --
   -- PROCEDURE: ENABLE_BUSINESS_DATA
   --
   -- PURPOSE
   --   Enables the target instance to receive and display business data.
   --        Check whether target_type is one of the valid Service types
   --        Set has_business property on the target instance
   --        Set UI page customizations for this target instance
   -- IN PARAMETERS
   --     p_target_name: target instance name
   --     p_target_type: target instance type
   --
   PROCEDURE ENABLE_BUSINESS_DATA
   (
     p_target_name IN VARCHAR2, 
     p_target_type IN VARCHAR2
   ) IS
   BEGIN

     -- validate the target type to be one of the service types
     IF (MGMT_SERVICE.IMPLEMENTS_SERVICE_INTERFACE (p_target_type) != 1)
     THEN
       MGMT_LOG.LOG_ERROR (G_MODULE, null,
	'Type has to be a Service type');
       -- raise an error
       raise_application_error(MGMT_GLOBAL.INVALID_PARAMS_ERR,
        'Target type (' || p_target_type || ') has to be a valid service interface type');
     END IF;

     -- enable has_business property (
     SET_HAS_BUSINESS_PROPERTY (p_target_name, p_target_type);

     -- Do UI page customizations for this target instance
     CUSTOMIZE_PAGES_FOR_BIZDATA (p_target_name, p_target_type);

   END ENABLE_BUSINESS_DATA;


   --
   -- PROCEDURE: ENABLE_BUSINESS_DATA
   --
   -- PURPOSE
   --   Enables the target instance to receive and display business data
   --   and also create on-demand collections for the business indicators.
   --        Check whether target_type is one of the valid Service types
   --        Set has_business property on the target instance
   --        Set UI page customizations for this target instance
   --        Create on-demand collections for each different KPI
   -- IN PARAMETERS
   --     p_target_name: target instance name
   --     p_target_type: target instance type
   --     p_kpis: list of business indicators registered for this target instance
   --  
   PROCEDURE ENABLE_BUSINESS_DATA
   (
     p_target_name IN VARCHAR2, 
     p_target_type IN VARCHAR2,
     p_kpis IN SMP_EMD_STRING_ARRAY
   ) 
   IS
     l_policy_key_val_list MGMT_POLICY_KEY_VAL_ARRAY := null;
   BEGIN

     -- call the base api 
     ENABLE_BUSINESS_DATA (p_target_name, p_target_type);
     
     -- create on-demand collections for each indicator
     IF (p_kpis IS NOT NULL) THEN
       FOR i in 1..p_kpis.COUNT
       LOOP
         -- start a collection for the indicator (key value)
         MGMT_COLLECTION.START_COLLECTION(p_target_type => p_target_type,
           p_target_name => p_target_name,
           p_metric_name =>  MGMT_SERVICE.G_BUSINESS_METRIC_NAME,
           p_metric_column => ' ',
           p_coll_name => p_kpis (i),
           p_coll_schedule =>  mgmt_coll_schedule_obj.on_demand_schedule);
      
         l_policy_key_val_list := MGMT_POLICY_KEY_VAL_ARRAY();
         l_policy_key_val_list.extend;

         l_policy_key_val_list(1) :=
             MGMT_POLICY_KEY_VAL.NEW(
               p_key_value => MGMT_POLICY_KEY_COL_COND_ARRAY(
                 MGMT_POLICY_KEY_COL_COND.NEW(
                   p_key_value => p_kpis(i),
                   p_has_wildcard => MGMT_GLOBAL.G_FALSE
                 )
               ),
               p_condition_operator =>  mgmt_global.G_THRESHOLD_GE,
               p_param_values => MGMT_POLICY_PARAM_VAL_ARRAY(
                 MGMT_POLICY_PARAM_VAL.NEW(
                 p_param_name => ' ')
         ));

         -- commit the treshold settings
         MGMT_MONITORING.SAVE_TARGET_METRIC_CONFIG (p_target_type, p_target_name,
           MGMT_SERVICE.G_BUSINESS_METRIC_NAME,
           MGMT_SERVICE.G_BUSINESS_VALUE_COL_NAME,
           p_kpis (i),
           1,
           l_policy_key_val_list);
         
       END LOOP;
     END IF;
   END ENABLE_BUSINESS_DATA;

   --
   -- FUNCTION GET_TARGET_DATASESSIONS
   -- PURPOSE
   --    Returns a list of DataSession Names that are mapped to this target instance
   -- IN PARAMETERS
   --     p_target_name: target instance name
   --     p_target_type: target instance type
   -- RETURN PARAMETER:
   --  SMP_EMD_STRING_ARRAY: Array of Datasession names
   --
   FUNCTION GET_TARGET_DATASESSIONS
   (
     p_target_name IN VARCHAR2, 
     p_target_type IN VARCHAR2
   ) RETURN SMP_EMD_STRING_ARRAY IS
     l_session_names SMP_EMD_STRING_ARRAY := SMP_EMD_STRING_ARRAY();
   BEGIN

     -- validate the target type to be one of the service types
     IF (MGMT_SERVICE.IMPLEMENTS_SERVICE_INTERFACE (p_target_type) != 1)
     THEN
       MGMT_LOG.LOG_ERROR (G_MODULE, null,
	'Type has to be a Service type');
       -- raise an error
       raise_application_error(MGMT_GLOBAL.INVALID_PARAMS_ERR,
        'Target type (' || p_target_type || ') has to be a valid service interface type');
     END IF;

     -- collect all the session names ito
     SELECT mbdi.SESSION_NAME BULK COLLECT INTO l_session_names 
       FROM MGMT_BAM_DATA_ISESSIONS mbdi, MGMT_TARGETS mt,
         MGMT_BAM_ISESSION_DATASOURCE mbid
       WHERE mt.TARGET_NAME = p_target_name and mt.target_type = p_target_type
         and mt.TARGET_GUID = mbid.TARGET_GUID 
         and mbdi.SESSION_GUID = mbid.SESSION_GUID;

     return l_session_names;

   END GET_TARGET_DATASESSIONS;


   --
   -- PROCEDURE: DISABLE_BUSINESS_DATA
   --
   -- PURPOSE:
   --   Disables getting and showing business data for this target instance. 
   -- IN PARAMETERS
   --     p_target_name: target instance name
   --     p_target_type: target instance type 
   --
   PROCEDURE DISABLE_BUSINESS_DATA
   (
     p_target_name IN VARCHAR2, 
     p_target_type IN VARCHAR2
   ) 
   IS
     l_datasession_metrics SMP_EMD_STRING_ARRAY;
     l_datasession_metrics_count NUMERIC := 0;
     l_promoted_business_metrics BOOLEAN;
   BEGIN

     -- validate the target type to be one of the service types
     IF (MGMT_SERVICE.IMPLEMENTS_SERVICE_INTERFACE (p_target_type) != 1)
     THEN
       MGMT_LOG.LOG_ERROR (G_MODULE, null,
	'Type has to be a Service type');
       -- raise an error
       raise_application_error(MGMT_GLOBAL.INVALID_PARAMS_ERR,
        'Target type (' || p_target_type || ') has to be a valid service interface type');
     END IF;

     -- check whether there are any other data sessions linked to this target
     l_datasession_metrics := GET_TARGET_DATASESSIONS (p_target_name, p_target_type);

     IF (l_datasession_metrics IS NOT NULL) THEN
       l_datasession_metrics_count := l_datasession_metrics.count;
     END IF;

     l_promoted_business_metrics := GENSVC.HAS_PROMOTED_METRICS (
                     p_target_name,
                     p_target_type,
                     MGMT_GLOBAL.G_SERVICE_CATEGORY_BUSINESS);

     IF  (l_datasession_metrics_count = 0 AND
                  ( NOT l_promoted_business_metrics)) THEN

       -- disable has_business property
       SET_HAS_BUSINESS_PROPERTY (p_target_name, p_target_type, 'false');

       -- Undo UI page customizations for this target instance
       DECUSTOMIZE_PAGES_FOR_BIZDATA (p_target_name, p_target_type);

     END IF;

   END DISABLE_BUSINESS_DATA;

   --
   -- PROCEDURE: DISABLE_BUSINESS_DATA
   --
   -- PURPOSE:
   --   Disables getting and showing business data for this target instance
   --   and additionally deletes the on-demand collections based on this
   --   dataservice and delinks the target from the service. 
   -- IN PARAMETERS
   --     p_target_name: target instance name
   --     p_target_type: target instance type
   --     p_session_name: data session name to delink
   --     p_kpis: list of business indicators that need to be removed
   --
   PROCEDURE DISABLE_BUSINESS_DATA
   (
     p_target_name IN VARCHAR2, 
     p_target_type IN VARCHAR2,
     p_session_name IN VARCHAR2,
     p_kpis IN SMP_EMD_STRING_ARRAY
   ) 
   IS
     v_target_guid       mgmt_targets.target_guid%TYPE;
     v_metric_guids      SMP_EMD_STRING_ARRAY; 
     v_session_guid      mgmt_bam_data_isessions.session_guid%TYPE;
   BEGIN

     -- get the target guid
     v_target_guid :=  mgmt_target.get_target_guid(p_target_name, p_target_type);

     -- get the mrtic guids
     v_metric_guids := SMP_EMD_STRING_ARRAY();
     v_metric_guids.EXTEND(1);
     v_metric_guids (1) := mgmt_target.get_metric_guid( p_target_type,
				MGMT_SERVICE.G_BUSINESS_METRIC_NAME,
           			MGMT_SERVICE.G_BUSINESS_VALUE_COL_NAME);
                                         

     -- delete on-demand collections for each indicator
     IF (p_kpis IS NOT NULL) THEN
       FOR i in 1..p_kpis.COUNT
       LOOP

         -- delete the metrics
         EM_METRIC.EXEC_CBK_METRIC_KEYVAL(v_target_guid, v_metric_guids,
           p_kpis (i));

         -- delete a collection for this indicator (key value)
         MGMT_COLLECTION.DELETE_COLLECTION(p_target_type => p_target_type,
           p_target_name => p_target_name,
           p_coll_name => p_kpis (i));

         -- delete the treshold settings for this indicator
         MGMT_MONITORING.DELETE_TARGET_METRIC_CONFIG (p_target_type, p_target_name,
           MGMT_SERVICE.G_BUSINESS_METRIC_NAME,
           MGMT_SERVICE.G_BUSINESS_VALUE_COL_NAME,
           p_kpis (i));
  
       END LOOP;
     END IF;

     -- disbale business semantics on this instance
     DISABLE_BUSINESS_DATA (p_target_name, p_target_type);
     
     -- get the session guid
     -- SELECT session_guid
     --  INTO v_session_guid
     -- FROM MGMT_BAM_DATA_ISESSIONS
     --  WHERE session_name = p_session_name;
 
     -- remove the link
     --UPDATE mgmt_bam_isession_datasource 
     --  SET target_guid = null
    --  WHERE session_guid  = v_session_guid;
   

   END DISABLE_BUSINESS_DATA;
   --
   -- FUNCTION: IS_BUSINESS_DATA_ENABLED
   -- 
   -- PURPOSE:
   --   Checks to see if business data for this target instance is enabled.
   -- IN PARAMETERS
   --     p_target_name: target instance name
   --     p_target_type: target isntance type
   --
   FUNCTION IS_BUSINESS_DATA_ENABLED
   (
     p_target_name IN VARCHAR2,
     p_target_type IN VARCHAR2
   ) RETURN BOOLEAN
   IS
     l_prop_count INTEGER;
   BEGIN
    SELECT COUNT(*)
      INTO l_prop_count
      FROM mgmt_target_properties props,
           mgmt_targets t
     WHERE t.target_guid = props.target_guid
       AND t.target_name = p_target_name
       AND t.target_type = p_target_type
       AND props.property_name = EM_SERVICE.G_SVC_HAS_BUSINESS
       AND props.property_value = 'true';
     
     return (l_prop_count > 0);
        
   END IS_BUSINESS_DATA_ENABLED; 

   -- PROCEDURE: ENABLE_BUSINESS_EVENTS
   --
   -- PURPOSE
   --   Enables Business events by creating GenericExternalAlertMetric
   --   for the given target_type/meta_ver combination
   -- IN PARAMETERS
   --   p_target_type: target instance type
   --   p_type_meta_ver: target type meta version
   --     
   PROCEDURE ENABLE_BUSINESS_EVENTS
   (
     p_target_type IN VARCHAR2, 
     p_type_meta_ver IN VARCHAR2 DEFAULT '1.0'
    )
   IS 
     v_metric_guid       mgmt_metrics.metric_guid%TYPE;
   BEGIN

     BEGIN

       -- check whether the Metric was already created or not
       v_metric_guid := MGMT_METRIC.GET_METRIC_GUID_FOR_PROPS (
                          p_target_type,
                          MGMT_GLOBAL.G_EXTERNAL_METRIC_NAME,
                          MGMT_GLOBAL.G_EXTERNAL_METRIC_COLUMN,
                          p_type_meta_ver);

     EXCEPTION

       -- if the metric doesn't exist create one.
       WHEN MGMT_GLOBAL.NO_SUCH_METRIC_FOUND THEN
         MGMT_METRIC_EXTERNAL.CREATE_GENERIC_METRIC (p_target_type,
             p_type_meta_ver);

     END;
   END ENABLE_BUSINESS_EVENTS;
  
END EM_BAM_SERVICE;
/
show errors;
