Rem drv: <create type="pkgdefs" />
Rem
Rem $Header: bam_service_pkgdef.sql 17-jul-2006.13:45:36 eporter Exp $
Rem
Rem bam_service_pkgdef.sql
Rem
Rem Copyright (c) 2006, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      bam_service_pkgdef.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    skkunise    05/25/06 - Enable business alerts 
Rem    eporter     04/19/06 - add getter method to see if bam is already 
Rem                           enabled 
Rem    skkunise    03/28/06 - Created
Rem

CREATE OR REPLACE PACKAGE EM_BAM_SERVICE IS

   G_MODULE_NAME CONSTANT VARCHAR2(30) := 'EM_BAM_SERVICE';

   --
   -- PROCEDURE: ENABLE_BUSINESS_DATA
   --
   -- PURPOSE
   --   Enables the target instance to receive and display business data.
   --        Check whether target_type is one of the valid Service types
   --        Set has_business property on the target instance
   --        Set UI page customizations for this target instance
   -- IN PARAMETERS
   --     p_target_name: target instance name
   --     p_target_type: target instance type. 
   --
   PROCEDURE ENABLE_BUSINESS_DATA
   (
     p_target_name IN VARCHAR2, 
     p_target_type IN VARCHAR2
   ); 

   --
   -- PROCEDURE: ENABLE_BUSINESS_DATA
   --
   -- PURPOSE
   --   Enables the target instance to receive and display business data
   --   and also create on-demand collections for the business indicators.
   --        Check whether target_type is one of the valid Service types
   --        Set has_business property on the target instance
   --        Set UI page customizations for this target instance
   --        Create on-demand collections for each different KPI
   -- IN PARAMETERS
   --     p_target_name: target instance name
   --     p_target_type: target instance type
   --     p_kpis: list of business indicators registered for this target instance 
   --  
   PROCEDURE ENABLE_BUSINESS_DATA
   (
     p_target_name IN VARCHAR2, 
     p_target_type IN VARCHAR2,
     p_kpis IN SMP_EMD_STRING_ARRAY
   ); 

   --
   -- FUNCTION GET_TARGET_DATASESSIONS
   -- PURPOSE
   --    Returns a list of DataSession Names that are mapped to this target instance
   -- IN PARAMETERS
   --     p_target_name: target instance name
   --     p_target_type: target instance type
   -- RETURN PARAMETER:
   --  SMP_EMD_STRING_ARRAY: Array of Datasession names
   --
   FUNCTION GET_TARGET_DATASESSIONS
   (
     p_target_name IN VARCHAR2, 
     p_target_type IN VARCHAR2
   ) RETURN SMP_EMD_STRING_ARRAY;

   --
   -- PROCEDURE: DISABLE_BUSINESS_DATA
   --
   -- PURPOSE:
   --   Disables getting and showing business data for this target instance. 
   -- IN PARAMETERS
   --     p_target_name: target instance name
   --     p_target_type: target instance type
   --
   PROCEDURE DISABLE_BUSINESS_DATA
   (
     p_target_name IN VARCHAR2, 
     p_target_type IN VARCHAR2
   ); 

   --
   -- PROCEDURE: DISABLE_BUSINESS_DATA
   --
   -- PURPOSE:
   --   Disables getting and showing business data for this target instance. 
   -- IN PARAMETERS
   --     p_target_name: target instance name
   --     p_target_type: target instance type
   --     p_session_name: data session name to delink
   --     p_kpis: list of business indicators that need to be removed 
   --
  PROCEDURE DISABLE_BUSINESS_DATA
   (
     p_target_name IN VARCHAR2, 
     p_target_type IN VARCHAR2,
     p_session_name IN VARCHAR2,
     p_kpis IN SMP_EMD_STRING_ARRAY
   ); 

   --
   -- PROCEDURE: IS_BUSINESS_DATA_ENABLED
   -- 
   -- PURPOSE:
   --   Checks to see if business data for this target instance is enabled.
   -- IN PARAMETERS
   --     p_target_name: target instance name
   --     p_target_type: target isntance type
   --
   FUNCTION IS_BUSINESS_DATA_ENABLED
   (
     p_target_name IN VARCHAR2,
     p_target_type IN VARCHAR2
   ) RETURN BOOLEAN;

   --
   -- PURPOSE
   --   Enables Business events by creating GenericExternalAlertMetric
   --   for the given target_type/meta_ver combination
   -- IN PARAMETERS
   --   p_target_type: target instance type
   --   p_type_meta_ver: target type meta version
   --     
   PROCEDURE ENABLE_BUSINESS_EVENTS
   (
     p_target_type IN VARCHAR2, 
     p_type_meta_ver IN VARCHAR2 DEFAULT '1.0'
   );

END EM_BAM_SERVICE;
/
show errors;
