Rem drv: <create type="pkgdefs" pos="basic/basic_pkgdefs.sql+"/>
Rem
Rem $Header: baselines_pkgdefs.sql 01-jul-2005.17:22:03 gsbhatia Exp $
Rem
Rem baselines_pkgdefs.sql
Rem
Rem Copyright (c) 2002, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      baselines_pkgdefs.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    gsbhatia    07/01/05 - New repmgr header impl 
Rem    gsbhatia    06/26/05 - New repmgr header impl 
Rem    gsbhatia    02/13/05 - updating repmgr header 
Rem    gsbhatia    02/09/05 - updating repmgr header 
Rem    gsbhatia    02/07/05 - updating repmgr header 
Rem    ktlaw       01/11/05 - add repmgr header 
Rem    jsoule      07/02/04 - add wrapper for baselineable check 
Rem    njuillar    11/06/03 - perf fixes 
Rem    njuillar    04/23/03 - Added get_src_dest_tgt_diff_counts function
Rem    aholser     04/08/03 - return emd_url from saveThresholds
Rem    ancheng     04/04/03 - change get_edit_metric_thresholds
Rem    ancheng     11/07/02 - add get_edit_metric_thresholds
Rem    tjaiswal    09/03/02 - Add composite key support
Rem    tjaiswal    08/13/02 - Edit thresholds enhancements
Rem    tjaiswal    07/18/02 - Add plsql for copy metric settings
Rem    rpinnama    05/15/02 - rpinnama_reorg_rep_scripts
Rem    rpinnama    05/15/02 - Created
Rem

CREATE OR REPLACE PACKAGE emd_mntr_baseline AS

-- Package level Type Definition 
   TYPE cursorType IS REF CURSOR;

   CREATE_MODE NUMBER(1) := 0;
   EDIT_MODE NUMBER(1) := 1;

   IGNORE_ACTIVATE_VALUE NUMBER(1) := -1;
   
   DAY_ROLLUP_MODE NUMBER(1) := 0;
   HOUR_ROLLUP_MODE NUMBER(1) := 1;
   
   COPY_TO_MODE VARCHAR2(15) := 'copyTo';
   COPY_FROM_MODE VARCHAR2(15) := 'copyFrom';

--
-- Name: get_edit_metric_thresholds
--
-- Package: emd_mntr_baseline
--
-- Purpose: 
--  Get the metric thresholds data for the given target.
--
-- IN parameters:
--   target_name_in: VARCHAR2 the name of the target
--   target_type_in: VARCHAR2 the type of the target
--   metric_name_in: VARCHAR2 the metric name
--   metric_column_in: VARCHAR2 the metric column
--
-- OUT parameters:
--  has_priv_out: NUMBER 1 if the user has at least OPERATOR_TARGET privilege
--                       0 otherwise
--  target_guid_out: RAW target guid
--  metric_thresholds_cur_out: CURSORTYPE contains all the metric thresholds
--                                        information
--
-- ERROR codes:
--  TARGET_DOES_NOT_EXIST_ERR: target does not exist error
--
PROCEDURE get_edit_metric_thresholds(target_name_in IN VARCHAR2,
                                     target_type_in IN VARCHAR2,
                                     metric_name_in IN VARCHAR2 DEFAULT NULL,
                                     metric_column_in IN VARCHAR2 DEFAULT NULL,
                                     target_guid_out OUT RAW,
                                     has_priv_out OUT NUMBER,
                                     metric_thresholds_cur_out OUT cursorType);

--
-- Name: get_metric_threshold_data
--
-- Package: emd_mntr_baseline
--
-- Purpose: 
--  Get the metric thresholds data for the given target; wrapper for the
--  get_edit_metric_thresholds procedure.
--
-- IN parameters:
--   target_name_in: VARCHAR2 the name of the target
--   target_type_in: VARCHAR2 the type of the target
--   metric_name_in: VARCHAR2 the metric name
--   metric_column_in: VARCHAR2 the metric column
--
-- OUT parameters:
--  has_priv_out: NUMBER 1 if the user has at least OPERATOR_TARGET privilege
--                       0 otherwise
--  target_guid_out: RAW target guid
--  is_baselineable_out: VARCHAR2 'true' iff this target supports dynamic baselines
--  metric_thresholds_cur_out: CURSORTYPE contains all the metric thresholds
--                                        information
--
-- ERROR codes:
--  TARGET_DOES_NOT_EXIST_ERR: target does not exist error
--
PROCEDURE get_metric_threshold_data(target_name_in IN VARCHAR2,
                                    target_type_in IN VARCHAR2,
                                    metric_name_in IN VARCHAR2 DEFAULT NULL,
                                    metric_column_in IN VARCHAR2 DEFAULT NULL,
                                    target_guid_out OUT RAW,
                                    has_priv_out OUT NUMBER,
                                    is_baselineable_out OUT VARCHAR2,
                                    metric_thresholds_cur_out OUT cursorType);

--
-- Name: get_target_baselines
--
-- Package: emd_mntr_baseline
--
-- Purpose: 
--  Get the baselines for the given target.
--
-- IN parameters:
--   target_name_in: VARCHAR2
--       the name of the target
--   target_type_in: VARCHAR2
--       the type of the target
--
-- OUT parameters:
--  baselines_out: CURSORTYPE
--    A cursor which returns rows containing:
--      baseline_name: VARCHAR2
--          the name of the baseline
--      baseline_date: DATE
--          the date of the baseline
--      baseline_date_string: VARCHAR2
--          the date of the baseline as a string value
--      is_active: NUMBER
--          if this baseline is active
--      target_guid: RAW
--          the target_guid of the baseline
--
-- ERROR codes:
--  TARGET_DOES_NOT_EXIST_ERR: target does not exist error
--
PROCEDURE get_target_baselines(
                            target_name_in IN VARCHAR2,
                            target_type_in IN VARCHAR2,
                            baselines_out OUT cursorType);
                                                    
--
-- Name: edit_baseline
--
-- Package: emd_mntr_baseline
--
-- Purpose: 
--  Create/Edit the baseline
--
-- IN parameters:
--   target_name_in: VARCHAR2
--       the name of the target
--   target_type_in: VARCHAR2
--       the type of the target
--   baseline_name_in: VARCHAR2
--       the name of the baseline
--   baseline_date_in: VARCHAR2
--       the date of the baseline as a string
--   date_format_in: VARCHAR2
--       the format of the baseline date.
--           for day rollup, the format is: dd-MM-yyyy
--           for hour rollup, the format is: dd-MM-yyyy hh24:mi:ss
--   baseline_active_in: NUMBER
--       is this baseline active? 1 - is active, 0 - not active
--   baseline_thr_data_in: MGMT_BASELINE_OBJ_ARRAY
--       An array containing the baseline thresholds data
--   mode_in: NUMBER
--       CREATE_MODE for create, EDIT_MODE for edit
--
-- OUT parameters:
--  none
--
-- ERROR codes:
--  TARGET_DOES_NOT_EXIST_ERR: target does not exist error
--  INSUFFICIENT_PRIVILEGES_ERR: insufficient privileges error
--  DUPLICATE_BASELINE_NAME_ERR: duplicate baseline name error(for create mode) 
--  BASELINE_DOES_NOT_EXIST_ERR: baseline does not exist error(for edit mode)
--
PROCEDURE edit_baseline(
                         target_name_in IN VARCHAR2,
                         target_type_in IN VARCHAR2,
                         baseline_name_in IN VARCHAR2,
                         baseline_date_in IN VARCHAR2,
                         date_format_in IN VARCHAR2,
                         baseline_active_in IN NUMBER,
                         baseline_thr_data_in IN MGMT_BASELINE_OBJ_ARRAY,
                         mode_in IN NUMBER );
                                                    
--
-- Name: delete_baseline
--
-- Package: emd_mntr_baseline
--
-- Purpose: 
--  Delete the baseline
--
-- IN parameters:
--   target_name_in: VARCHAR2
--       the name of the target
--   target_type_in: VARCHAR2
--       the type of the target
--   baseline_name_in: VARCHAR2
--       the name of the baseline
--
-- OUT parameters:
--  none
--
-- ERROR codes:
--  TARGET_DOES_NOT_EXIST_ERR: target does not exist error
--  INSUFFICIENT_PRIVILEGES_ERR: insufficient privileges error
--  BASELINE_DOES_NOT_EXIST_ERR: baseline does not exist error(for edit mode)
--
PROCEDURE delete_baseline(
                         target_name_in IN VARCHAR2,
                         target_type_in IN VARCHAR2,
                         baseline_name_in IN VARCHAR2 );
                                                    
--
-- Name: get_baseline_data
--
-- Package: emd_mntr_baseline
--
-- Purpose: 
--  Get the baseline data for a given baseline name. 
--
-- IN parameters:
--   target_name_in: VARCHAR2
--       the name of the target
--   target_type_in: VARCHAR2
--       the type of the target
--   baseline_name_in: VARCHAR2
--       the name of the baseline
-- OUT parameters:
--   baseline_date_out: DATE
--       the date of the baseline
--   baseline_date_string_out OUT VARCHAR2,
--       the baseline date as a string value
--   baseline_active_out: NUMBER
--       is this baseline active?
--   baseline_data_out: CURSORTYPE
--    A cursor which returns rows containing:
--      metric_name: VARCHAR2 the metric name
--      metric_column: VARCHAR2 the metric column
--      metric_label: VARCHAR2 the label for metric name
--      column_label: VARCHAR2 the label for metric column
--      key_column: VARCHAR2 the key column
--      metric_type: NUMBER(1) the metric type
--      key_value: VARCHAR2 the key value
--      metric_value: NUMBER the metric value
--      warning_threshold: VARCHAR2 the warning threshold
--      critical_threshold: VARCHAR2 the critical threshold
--      warning_operator: VARCHAR2 the warning operator
--      critical_operator: VARCHAR2 the critical operator
--      metric_guid: RAW the metric guid
--      target_guid: RAW the target guid
--
-- ERROR codes:
--  TARGET_DOES_NOT_EXIST_ERR: target does not exist error
--  BASELINE_DOES_NOT_EXIST_ERR: baseline does not exist error(for edit mode)
--
PROCEDURE get_baseline_data(
                             target_name_in IN VARCHAR2,
                             target_type_in IN VARCHAR2,
                             baseline_name_in IN VARCHAR2,
                             baseline_date_out OUT DATE,
                             baseline_date_string_out OUT VARCHAR2,
                             baseline_active_out OUT NUMBER,
                             baseline_data_out OUT cursorType);
                                                    
--
-- Name: get_baseline_data_for_date
--
-- Package: emd_mntr_baseline
--
-- Purpose: 
--  Get the baseline data for the given date. This data will be used in creating
--  or editing a baseline 
--
-- IN parameters:
--   target_name_in: VARCHAR2
--       the name of the target
--   target_type_in: VARCHAR2
--       the type of the target
--   baseline_date_in: DATE
--       the date of the baseline
--   date_format_in: VARCHAR2
--       the format to be used for the date
--   rollup_mode_in: NUMBER
--       0 for day rollup, 1 for hour rollup
-- OUT parameters:
--   baseline_data_out: CURSORTYPE
--    A cursor which returns rows containing:
--      metric_name: VARCHAR2 the metric name
--      metric_column: VARCHAR2 the metric column
--      metric_label: VARCHAR2 the label for metric name
--      column_label: VARCHAR2 the label for metric column
--      key_column: VARCHAR2 the key column
--      metric_type: NUMBER(1) the metric type
--      key_value: VARCHAR2 the key value
--      metric_value: NUMBER the metric value
--      warning_threshold: VARCHAR2 the warning threshold
--      critical_threshold: VARCHAR2 the critical threshold
--      warning_operator: VARCHAR2 the warning operator
--      critical_operator: VARCHAR2 the critical operator
--      metric_guid: RAW the metric guid
--      target_guid: RAW the target guid
--
-- ERROR codes:
--  TARGET_DOES_NOT_EXIST_ERR: target does not exist error
--

PROCEDURE get_baseline_data_for_date(
                                      target_name_in IN VARCHAR2,
                                      target_type_in IN VARCHAR2,
                                      baseline_date_in IN VARCHAR2,
                                      date_format_in IN VARCHAR2,
                                      rollup_mode_in IN NUMBER,
                                      baseline_data_out OUT cursorType);
                                                    
--
-- Name: get_baseline_data_for_thr
--
-- Package: emd_mntr_baseline
--
-- Purpose: 
--  Get the baseline data for the given date and passed in metric thresholds data. 
--  This data will be used in creating or editing a baseline 
--
-- IN parameters:
--   target_name_in: VARCHAR2
--       the name of the target
--   target_type_in: VARCHAR2
--       the type of the target
--   baseline_date_in: DATE
--       the date of the baseline
--   date_format_in: VARCHAR2
--       the format to be used for the date
--   rollup_mode_in: NUMBER
--       0 for day rollup, 1 for hour rollup
--   met_thr_data_in: MGMT_METRIC_THR_OBJ_ARRAY
--       An array containing the metric thresholds data
-- OUT parameters:
--   baseline_data_out: CURSORTYPE
--    A cursor which returns rows containing:
--      metric_name: VARCHAR2 the metric name
--      metric_column: VARCHAR2 the metric column
--      metric_label: VARCHAR2 the label for metric name
--      column_label: VARCHAR2 the label for metric column
--      key_column: VARCHAR2 the key column
--      metric_type: NUMBER(1) the metric type
--      key_value: VARCHAR2 the key value
--      metric_value: NUMBER the metric value
--      warning_threshold: VARCHAR2 the warning threshold
--      critical_threshold: VARCHAR2 the critical threshold
--      warning_operator: VARCHAR2 the warning operator
--      critical_operator: VARCHAR2 the critical operator
--      metric_guid: RAW the metric guid
--      target_guid: RAW the target guid
--
-- ERROR codes:
--  TARGET_DOES_NOT_EXIST_ERR: target does not exist error
--
PROCEDURE get_baseline_data_for_thr(
                                      target_name_in IN VARCHAR2,
                                      target_type_in IN VARCHAR2,
                                      baseline_date_in IN VARCHAR2,
                                      date_format_in IN VARCHAR2,
                                      rollup_mode_in IN NUMBER,
                                      met_thr_data_in IN MGMT_METRIC_THR_OBJ_ARRAY,
                                      baseline_data_out OUT cursorType);
                                                    
--
-- Name: save_thresholds
--
-- Package: emd_mntr_baseline
--
-- Purpose: 
--  Save the thresholds data for a given target
--
-- IN parameters:
--   target_name_in: VARCHAR2
--       the name of the target
--   target_type_in: VARCHAR2
--       the type of the target
--   met_thr_data_in: MGMT_METRIC_THR_OBJ_ARRAY
--       An array containing the metric thresholds data. contains data both
--       for a composite or non composite key
-- OUT parameters:
--   emd_url_out: VARCHAR2
--       The emd_url for the target 
--
-- ERROR codes:
--  TARGET_DOES_NOT_EXIST_ERR: target does not exist error
--  INSUFFICIENT_PRIVILEGES_ERR: insufficient privileges error
--
PROCEDURE save_thresholds( target_name_in IN VARCHAR2,
                           target_type_in IN VARCHAR2,
                           met_thr_data_in IN MGMT_METRIC_THR_OBJ_ARRAY,
                           emd_url_out OUT VARCHAR2,
                           is_multi_agent_target_out OUT NUMBER);
                                                    
--
-- Name: copy_thresholds
--
-- Package: emd_mntr_baseline
--
-- Purpose: 
--  Copy the thresholds data of the source target to the destination target
--
-- IN parameters:
--   source_target_name_in: VARCHAR2
--       the name of the source target
--   source_target_type_in: VARCHAR2
--       the type of the source target
--   destination_target_name_in: VARCHAR2
--       the name of the destination target
--   destination_target_type_in: VARCHAR2
--       the type of the destination target
--   source_tgt_met_thr_data_in: MGMT_METRIC_THR_OBJ_ARRAY
--       An array containing the metric thresholds data fo the source target
--   copy_common_ony_in: NUMBER
--       if this is 1, only the metrics(with or without key values) common
--       to both the source and destination target will be copied
--       if this is 0, a "clone" of the source target metrics will be performed
--       on the destination target metrics. look in the plsql implementation
--       for more details on this
-- OUT parameters:
--   dest_tgt_met_thr_data_out: CURSORTYPE
--    This cursor contains the thresholds data of the destination target
--    after the thresholds of the source target were copied to the
--    destination target
--    A cursor which returns rows containing:
--      metric_name: VARCHAR2 the metric name
--      metric_column: VARCHAR2 the metric column
--      metric_label: VARCHAR2 the label for metric name
--      column_label: VARCHAR2 the label for metric column
--      key_column: VARCHAR2 the key column
--      metric_type: NUMBER(1) the metric type
--      coll_name: VARCHAR2 the collection name of this metric
--      key_value: VARCHAR2 the key value
--      eval_order: NUMBER the eval order of this metric
--      warning_threshold: VARCHAR2 the warning threshold
--      critical_threshold: VARCHAR2 the critical threshold
--      warning_operator: VARCHAR2 the warning operator
--      critical_operator: VARCHAR2 the critical operator
--      num_occurences: NUMBER number of occurrences
--      fixit_job: VARCHAR2 the fixit job associated with this metric
--      metric_guid: RAW the metric guid
--      target_guid: RAW the target guid
--   non_applicable_metric_list: SMP_EMD_INTEGER_ARRAY
--      A list of all metrics which are not applicable to the destination target
--      and whose thresholds were not copied over to the destination target
--   non_applicable_kvalue_list: SMP_EMD_INTEGER_ARRAY
--      A list of all key values which are not applicable to the destination 
--      target and whose thresholds were not copied over to the destination target
--   NOTE: the length of arrays non_applicable_metric_list and 
--         non_applicable_kvalue_list are the same. also 
--         non_applicable_kvalue_list(i) corresponds to 
--         non_applicable_metric_list(i)
--   is_multi_agent_target: NUMBER
--      A flag to indicate whether or not the destination target is multi-agent.
--      If it is, we need to submit a job to update all of its standby agents
--      with the thresholds of the source target.
--      
--   
-- ERROR codes:
--  TARGET_DOES_NOT_EXIST_ERR: target does not exist error
--  INSUFFICIENT_PRIVILEGES_ERR: insufficient privileges error
--
PROCEDURE copy_thresholds(
                           source_target_name_in IN VARCHAR2,
                           source_target_type_in IN VARCHAR2,
                           destination_target_name_in IN VARCHAR2,
                           destination_target_type_in IN VARCHAR2,
                           source_tgt_met_thr_data_in IN MGMT_METRIC_THR_OBJ_ARRAY,
                           copy_common_only_in IN NUMBER,
                           dest_tgt_met_thr_data_out OUT cursorType,
                           non_applicable_metric_list OUT SMP_EMD_STRING_ARRAY,
                           non_applicable_kvalue_list OUT SMP_EMD_STRING_ARRAY,
                           is_multi_agent_target_out OUT NUMBER);

PROCEDURE get_number_of_pending_changes(target_name_in IN VARCHAR2,
                                        target_type_in IN VARCHAR2,
                                        pending_changes_count OUT NUMBER);

FUNCTION get_additions_count(source_target_name_in IN VARCHAR2,
                             destination_target_name_in IN VARCHAR2,
                             target_type_in IN VARCHAR2,
                             copy_mode_in IN VARCHAR2,
                             tgt_met_thr_data_in IN MGMT_METRIC_THR_OBJ_ARRAY)

RETURN number;

FUNCTION get_deletions_count(source_target_name_in IN VARCHAR2,
                             destination_target_name_in IN VARCHAR2,
                             target_type_in IN VARCHAR2,
                             copy_mode_in IN VARCHAR2,
                             tgt_met_thr_data_in IN MGMT_METRIC_THR_OBJ_ARRAY)

RETURN number;

PROCEDURE get_metric_indices_changes(source_target_name_in IN VARCHAR2,
                                     target_type_in IN VARCHAR2,
                                     dest_target_data_in SMP_EMD_STRING_ARRAY,
                                     tgt_met_thr_data_in IN MGMT_METRIC_THR_OBJ_ARRAY,
                                     copy_mode_in IN VARCHAR2,
                                     data_cursor_out OUT cursorType);


PROCEDURE get_pending_jobs_from_target(source_target_name_in IN VARCHAR2,
                                       source_target_type_in IN VARCHAR2,
                                       data_cursor_out OUT cursorType);                                    


PROCEDURE get_pending_jobs_to_target(destination_target_name_in IN VARCHAR2,
                                     destination_target_type_in IN VARCHAR2,
                                     data_cursor_out OUT cursorType); 

PROCEDURE get_past_changes(current_target_name_in IN VARCHAR2,
                           current_target_type_in IN VARCHAR2,
                           data_cursor_out OUT cursorType); 

PROCEDURE get_threshold_update_data(operation_guid_in IN VARCHAR2,
                                    target_type_in IN VARCHAR2,
                                    data_cursor_out OUT cursorType); 

PROCEDURE delete_past_changes(operation_guids_in IN SMP_EMD_STRING_ARRAY,
                              agents_in IN SMP_EMD_STRING_ARRAY);

PROCEDURE is_valid_target(target_name_in IN VARCHAR2,
                          target_type_in IN VARCHAR2,
                          result_out OUT NUMBER);                              
                                                    
--
-- Name: get_src_dest_tgt_diff_met
--
-- Package: emd_mntr_baseline
--
-- Purpose: 
--  Get the diff metrics(with key values) between the source and the 
--  destination target
--
-- IN parameters:
--   target_name_in: VARCHAR2
--       the name of the source target
--   target_type_in: VARCHAR2
--       the type of the source target
--   selected_target_name_in: VARCHAR2
--       the name of the destination target
--   selected_target_type_in: VARCHAR2
--       the type of the destination target
--   copy_mode_in: VARCHAR2
--       the copy mode - copyTo or copyFrom
--   NOTE: if copy_mode_in is copyTo, source target is target_name_in
--         if copy_mode_in is copyTo, source target is selected_target_name_in
--   tgt_met_thr_data_in: MGMT_METRIC_THR_OBJ_ARRAY
--       An array containing the metric thresholds data of the current target
-- OUT parameters:
--   source_tgt_only_met_out: CURSORTYPE
--    This cursor contains those metrics with key values that have thresholds
--    setup only on the source target
--    A cursor which returns rows containing:
--      metric_label: VARCHAR2 the label for metric name
--      column_label: VARCHAR2 the label for metric column
--      key_value: VARCHAR2 the key value
--      metric_guid: RAW the metric guid
--   dest_tgt_only_met_out: CURSORTYPE
--    This cursor contains those metrics with key values that have thresholds
--    setup only on the destination target
--    A cursor which returns rows containing:
--      metric_label: VARCHAR2 the label for metric name
--      column_label: VARCHAR2 the label for metric column
--      key_value: VARCHAR2 the key value
--      metric_guid: RAW the metric guid
--   common_met_out: CURSORTYPE
--    This cursor contains those metrics with thresholds which are common to
--    both the source and destination target
--    A cursor which returns rows containing:
--      metric_label: VARCHAR2 the label for metric name
--      column_label: VARCHAR2 the label for metric column
--      key_value: VARCHAR2 the key value
--      metric_guid: RAW the metric guid
--   
-- ERROR codes:
--  TARGET_DOES_NOT_EXIST_ERR: target does not exist error
--  INSUFFICIENT_PRIVILEGES_ERR: insufficient privileges error
--
PROCEDURE get_src_dest_tgt_diff_met(
                           target_name_in IN VARCHAR2,
                           target_type_in IN VARCHAR2,
                           selected_target_name_in IN VARCHAR2,
                           selected_target_type_in IN VARCHAR2,
                           copy_mode_in IN VARCHAR2,
                           tgt_met_thr_data_in IN MGMT_METRIC_THR_OBJ_ARRAY,
                           source_tgt_only_met_out OUT cursorType,
                           dest_tgt_only_met_out OUT cursorType,
                           common_met_out OUT cursorType);

-- 
-- Name: get_targets_of_type
--
-- Package: emd_mntr_baseline
--
-- Purpose: 
--  Get all the targets of the type
--
-- IN parameters:
--   target_type_in: VARCHAR2
--       the type of the target
-- Returns:
--    A cursor which returns rows containing:
--      target_name: VARCHAR2 the target name
--      target_type: VARCHAR2 the target type
--      target_guid: RAW the target guid
--
-- ERROR codes:
--   None.
--
FUNCTION get_targets_of_type(
                               target_type_in IN VARCHAR2 )
RETURN cursorType;

END emd_mntr_baseline;
/

show errors;


