Rem drv: <create type="tables"/>
Rem
Rem $Header: baselines_tables.sql 29-jun-2005.01:47:13 gsbhatia Exp $
Rem
Rem baselines_tables.sql
Rem
Rem Copyright (c) 2002, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      baselines_tables.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    gsbhatia    06/26/05 - New repmgr header impl 
Rem    gsbhatia    02/13/05 - updating repmgr header 
Rem    gsbhatia    02/09/05 - updating repmgr header 
Rem    gsbhatia    02/07/05 - updating repmgr header 
Rem    ktlaw       01/11/05 - add repmgr header 
Rem    rpinnama    05/14/02 - rpinnama_reorg_rep_scripts
Rem    rpinnama    05/14/02 - Created
Rem

rem
rem  PURPOSE
rem
rem    The MGMT_TARGET_BASELINES table contains the baseline overview data
rem    for a given target. The baseline related thresholds data are stored
rem    in MGMT_TARGET_BASELINES_DATA table.
rem
rem  COLUMNS
rem
rem     BASELINE_NAME
rem                
rem                 - The name of the baseline
rem
rem     BASELINE_DATE
rem                
rem                 - The date associated with the baseline
rem
rem     IS_ACTIVE
rem                
rem                 - Is this baseline active? If the metric thresholds are
rem                   edited using this baseline s data, then this baseline
rem                   is considered active
rem
rem     TARGET_GUID
rem                
rem                 - The target guid of the target whose metric values are used
rem                   in creating this baseline 
rem
rem

CREATE TABLE MGMT_TARGET_BASELINES
    (baseline_name      VARCHAR2(128)  NOT NULL,
     baseline_date      DATE           NOT NULL,
     is_active          NUMBER(1)      DEFAULT 0,
     target_guid        RAW(16)  ) MONITORING;


rem
rem  PURPOSE
rem
rem    The MGMT_TARGET_BASELINES_DATA table contains the baseline detail data
rem    for a given target s baseline. The detail data consists of the metric 
rem    values and the warning and critical thresholds for these values.
rem
rem  COLUMNS
rem
rem     BASELINE_NAME
rem                
rem                 - The name of the baseline
rem
rem     TARGET_GUID
rem                
rem                 - The target guid of the target whose metric values are used
rem                   in creating this baseline 
rem
rem     METRIC_GUID
rem                
rem                 - The guid of a given metric of a target type
rem
rem     KEY_VALUE
rem                
rem                 - If the metric defined at collection time is a TABLE type, the
rem                   value of the column in the table that is designated as the
rem                   key for the row that identifies the value of this metric should
rem                   be written here.  This information is used during reporting to
rem                   uniquely identify the specific value in the table that was
rem                   collected.  KEY_VALUE is the identifying row.  Together with the
rem                   target name, target type, and metric name, the metric value can be
rem                   uniquely identified.  This allows us to flatten tables of metrics into
rem                   simple metric values.  For example, the value in this table might
rem                   be \usr if we were storing the SpaceUsed metric.
rem
rem     VALUE_AVERAGE
rem                
rem                 - The average value of the metric for samples in the time period
rem
rem     VALUE_MINIMUM
rem                
rem                 - The minimum value of the metric for samples in the time period
rem
rem     VALUE_MAXIMUM
rem                
rem                 - The maximum value of the metric for samples in the time period
rem
rem     WARNING_OPERATOR
rem
rem                 - The operator for the warning threshold.  This is used in
rem                   the reporting environment to create a line on the graph
rem                   representing the warning threshold appropriately.
rem
rem                         0 - GT
rem                         1 - EQ
rem                         2 - LT
rem                         3 - LE
rem                         4 - GE
rem                         5 - CONTAINS
rem                         6 - NE
rem                         7 - MATCH    :  regular expression
rem
rem     WARNING_THRESHOLD
rem
rem                 - value for the warning.  Together with the warning operator
rem                   a graph line can be drawn to show the warning threshold.
rem
rem     CRITICAL_OPERATOR
rem
rem                 - The operator for the critical threshold.  This is used in
rem                   the reporting environment to create a line on the graph
rem                   representing the critical threshold appropriately.
rem
rem                         0 - GT
rem                         1 - EQ
rem                         2 - LT
rem                         3 - LE
rem                         4 - GE
rem                         5 - CONTAINS
rem                         6 - NE
rem                         7 - MATCH    :  regular expression
rem
rem     CRITICAL_THRESHOLD
rem
rem                 - value for the critical severity.  Together with the
rem                   critical operator, a graph line can be drawn to show the
rem                   critical severity threshold.
rem

CREATE TABLE MGMT_TARGET_BASELINES_DATA
    (baseline_name         VARCHAR2(128)   NOT NULL,
     target_guid           RAW(16)         NOT NULL,
     metric_guid           RAW(16)         NOT NULL,
     key_value             VARCHAR2(256)   DEFAULT ' ',
     value_average         NUMBER          DEFAULT 0,
     value_minimum         NUMBER          DEFAULT 0,
     value_maximum         NUMBER          DEFAULT 0,
     warning_operator      NUMBER          DEFAULT 0,
     warning_threshold     VARCHAR2(256)   DEFAULT ' ',
     critical_operator     NUMBER          DEFAULT 0,
     critical_threshold    VARCHAR2(256)   DEFAULT ' ') MONITORING;
    

