Rem drv: <create type="funcs"/>
Rem
Rem $Header: basic_funcs.sql 29-jun-2005.01:49:42 gsbhatia Exp $
Rem
Rem basic_funcs.sql
Rem
Rem Copyright (c) 2002, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      basic_funcs.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    gsbhatia    06/26/05 - New repmgr header impl 
Rem    jsadras     03/10/05 - Bug:4186866: redirect tgt_sysdate_wguid 
Rem    gsbhatia    02/13/05 - updating repmgr header 
Rem    gsbhatia    02/09/05 - updating repmgr header 
Rem    gsbhatia    02/07/05 - updating repmgr header 
Rem    ktlaw       01/11/05 - add repmgr header 
Rem    dcawley     03/12/03 - Add commandline arguments to EMDSYSTEM
Rem    rpinnama    09/11/02 - Add sysdate_wtzrgn function
Rem    dcawley     05/20/02 - Add program argument to EMDSYSTEM.
Rem    rpinnama    05/15/02 - rpinnama_reorg_rep_scripts
Rem    rpinnama    05/14/02 - Created
Rem

rem
rem  PURPOSE
rem
rem     The TGT_SYSDATE_WTZ function returns the SYSDATE as seen on the
rem     the target, which is in tgt_tz timezone.
rem
CREATE OR REPLACE FUNCTION TGT_SYSDATE_WTZ(tgt_tz NUMBER)
    RETURN DATE AS
    l_curr_time    TIMESTAMP WITH TIME ZONE;
    n_dbtz_hrs   NUMBER;
    n_dbtz_min   NUMBER;
BEGIN

    -- Get current time
    l_curr_time := systimestamp;

    -- Get hours and minutes portions of the database timezone
    n_dbtz_hrs := to_number( to_char(l_curr_time, 'TZH') );
    n_dbtz_min := to_number( to_char(l_curr_time, 'TZM') );

    return SYSDATE - ((n_dbtz_hrs*60 + n_dbtz_min)/(24*60)) + (tgt_tz/(24*60));

END;
/
show errors;

--
-- Function redirected to mgmt_target.
-- use mgmt_target.sysdate_target instead of this function
--
CREATE OR REPLACE FUNCTION TGT_SYSDATE_WGUID(tgt_guid RAW)
    RETURN DATE AS
l_target_sysdate DATE ;
BEGIN
  RETURN(MGMT_TARGET.sysdate_target(tgt_guid)) ;
END;
/
show errors;

CREATE OR REPLACE FUNCTION EMDSYSTEM (program IN VARCHAR2,
                                      env     IN EMDSYSTEM_ARGS,
                                      args    IN EMDSYSTEM_ARGS)
RETURN VARCHAR2
AS LANGUAGE JAVA
   NAME 'oracle.sysman.emdrep.util.EMDRuntime.system (java.lang.String,
                                                      java.sql.Array,
                                                      java.sql.Array)
        return java.lang.String';
/
show errors;
