Rem
Rem $Header: emcore/source/oracle/sysman/emdrep/sql/core/latest/basic/basic_mntr_pkgbody.sql /st_emcore_10.2.0.4.2db11.2/3 2009/06/17 22:26:40 paachary Exp $
Rem
Rem basic_mntr_pkgbody.sql
Rem
Rem Copyright (c) 2002, 2009, Oracle and/or its affiliates. 
Rem All rights reserved. 
Rem
Rem    NAME
Rem      basic_mntr_pkgbody.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    paachary    06/10/09 - backport bug 6724021
Rem    paachary    03/10/09 - Fixing perf bugs in basic mntr
Rem    jsadras     12/24/08 - Bug:7563016, get_targets_summary2_db_hst
Rem    jashukla    06/03/08 - Bug 7144619 remove internal identifiers
Rem    paachary    09/10/07 - Fixing bug 6405995
Rem    rtakeish    09/06/07 - fixing performance bug6379932
Rem    manaraya    09/03/07 - BUG 6314797
Rem    bram        09/05/07 - XbranchMerge bram_bug-6314632 from main
Rem    denath      09/03/07 - RFI Manual for Base Bug 6379940.
Rem    denath      09/03/07 - changed get_targets_summary2 and 
Rem                           get_metrics_summary
Rem    bram        09/07/07 - bram_fix_6379692
Rem    paachary    08/30/07 - XbranchMerge paachary_bug-6314880 from main
Rem    rsamaved    07/25/07 - fix Single Cell UDM for RAC
Rem    groyal      07/18/07 - Bug 4863138: Update get_*_lib_mntr_settings to 
Rem                           retrieve info about repository metric collections
Rem    paachary    08/06/07 - Fixing perf bug 6314880
Rem    shnavane    07/10/07 - Fix bug #6019805
Rem    shnavane    07/18/07 - Backport shnavane_bug-6019805 from main
Rem    yma         07/06/07 - Fix bug 5755326 
Rem    vmotamar    07/02/07 - Bug No : 6151378
Rem    mgoswami    06/19/07 - Backport mgoswami_bug-4625462 from main
Rem    paachary    05/31/07 - Fixing bug 6084268
Rem    paachary    05/17/07 - Backport paachary_bug-5954189 from
Rem                           st_emcore_10.2.0.1.0
Rem    paachary    05/14/07 - Fixing bug 5954189
Rem    vmotamar    05/23/07 - Added new functions : "check_metric_parent", "check_for_warn_crit_tip"
Rem    acgopala    04/19/07 - Bug-5519492 Add support for server generated metric tip in UI
Rem                            For 10g DB and above
Rem    denath      02/21/07 - Backport denath_bug-5019532 from main
Rem    bram        08/29/06 - Bug-5478798
Rem    bram        09/17/06 - Backport bram_bug-5478798 from main
Rem    lgloyd      09/06/06 - Backport lgloyd_bug-5350131 from main
Rem    lgloyd      09/01/06 - remove optimizer hints causing performance issues
Rem                           with 24 hour metric graphs
Rem    denath      08/24/06 - Fix Bug 5019532.Changed how l_key_values are
Rem                           populated for numeric type metric in
Rem                           get_key_value_avg_details breaking for day, week
Rem                           and month.
Rem    denath      08/20/06 - Fix Bug 5019532.Behavior of cursors
Rem                           avg_details_out, thresholds_out changed for
Rem                           String type metrics in get_key_value_avg_details.
Rem    pratagar    01/10/06 - 2 Col SQL UDM support and Delete UDM.
Rem    pratagar    07/25/06 - Backport pratagar_bug-4653111 from main 
Rem    schoudha    12/20/05 - Bug 4893529: fix sql violation
Rem    schoudha    12/21/05 - Backport schoudha_bug-4893529 from main 
Rem    jgwang      12/01/05 - Backport jgwang_bug-4620368 from main 
Rem    rpinnama    09/23/05 - Fix 4595139 : Obtain settings lock before 
Rem                           updating the settings 
Rem    jgwang      09/22/05 - add collection disabling for UDMs 
Rem    skini       09/09/05 - Trim selects of fixit_job to eliminate blanks 
Rem    niramach    09/01/05 - Fix for bug 4578669. 
Rem    bram        09/01/05 - Bug 4585482
Rem    paachary    09/01/05 - Bug 4586078
Rem    vkgarg      08/30/05 - add get_target_timestamp_info 
Rem    paachary    08/29/05 - Bug 4578674
Rem    jabramso    08/29/05 - "isolate multi-key multi-tgt for reporting 
Rem                           framework " 
Rem    jabramso    08/26/05 - multi-key/mult-tgt - use single tgt 
Rem    dtsao       08/24/05 - Add get_console_homepage_info_simple procedure 
Rem    jgwang      08/22/05 - add support for modify_threshold 
Rem    paachary    08/23/05 - Bug 4560094. Mismatch in alerts count in the console home page and Alerts Tab
Rem    xuliu       08/19/05 - 4554298
Rem    ancheng     08/19/05 - pending update execution 
Rem    jaysmith    08/11/05 - cluster target-types inherit job-types from 
Rem                           members 
Rem    njuillar    08/10/05 - Add apply_template_operations() 
Rem    bram        08/08/05 - Perf:System Page
Rem    bram        08/09/05 - Bug-4544278
Rem    paachary    08/04/05 - Bug 4520236 (PERF: GROUPS PAGES TAKES 226 SECONDS TO DOWNLOAD ON PERF SITE)
Rem    njuillar    08/02/05 - Take into account agent in get_pending_changes() 
Rem    jpyang      07/29/05 - fix type_meta_ver for service s 
Rem    ancheng     07/20/05 - modify get_pending_changes 
Rem    jgwang      07/11/05 - 
Rem    bram        06/27/05 - Bug 3292341
Rem    ancheng     07/12/05 - bug 4261421 
Rem    jpyang      07/15/05 - increase column size 
Rem    niramach    07/07/05 - Bug fix for 4472023. 
Rem    mfidanbo    07/11/05 - dont display local beacon in the count 
Rem    njuillar    07/06/05 - Add get_has_template_priv 
Rem    jgwang      06/29/05 - set p_has_wildcard = 0 in create_udm() 
Rem    dcawley     06/28/05 - Include rownum 
Rem    jaysmith    06/21/05 - only non-execution ca parameters 
Rem    rpatti      06/21/05 - bug 4328129 
Rem    jaysmith    06/02/05 - load violation context def to monitoring 
Rem                           settings 
Rem    niramach    06/14/05 - Bug 4378821 is fixed. 
Rem    paachary    06/16/05 - Changed hard coded values (is_group, is_system) to global constants.
Rem    bram        06/13/05 - Fix-4287713-Add get_metric_errors
Rem    vkgarg      06/16/05 - perf tuning in get_key_value_avg_details 
Rem    vkgarg      06/14/05 - remove k.* from get_key_value_avg_details 
Rem    jgwang      06/08/05 - add create and edit udm 
Rem    bram        06/03/05 - Bug-4359208
Rem    mfidanbo    05/23/05 - dont get availability alertsfor services 
Rem    dtsao       05/10/05 - In the group folder, do not roll up non-up 
Rem                           targets alert 
Rem    ancheng     05/05/05 - add collection schedule to All Metrics page 
Rem    ancheng     05/02/05 - handle hidden metrics 
Rem    njuillar    05/02/05 - Add get_pending_changes 
Rem    dtsao       04/27/05 - Let system folder also generate members column 
Rem                           data 
Rem    rpinnama    05/09/05 - Call delete_collection to delete UDM collections 
Rem    ancheng     04/19/05 - bug 4295694 
Rem    jvishen     04/17/05 - add key_value in get_metric_associated_ca 
Rem    rzazueta    04/11/05 - get collection creds for template copies 
Rem    ancheng     04/07/05 - get agent version 
Rem    njuillar    04/07/05 - Fix bug 4203215 
Rem    jgwang      04/04/05 - add delete_udm procedure 
Rem    jaysmith    04/01/05 - check type_meta_ver in get_metric_associated_ca
Rem    ancheng     04/01/05 - remove old APIs 
Rem    jvishen     03/30/05 - Add get_unconfig_targets 
Rem    dtsao       03/25/05 - Alert in system folder should not count response 
Rem    rpinnama    03/14/05 - Use type_guid and type_ver_guid 
Rem    jvishen     03/09/05 - fix get_metric_associated_ca 
Rem    jvishen     03/08/05 - get the broken corrective action count 
Rem    dtsao       03/04/05 - Change the codition of group case 
Rem    njuillar    03/04/05 - Fix bug 4087311 
Rem    ancheng     03/03/05 - add more columns 
Rem    dcawley     02/21/05 - Replace enter super user mode 
Rem    ancheng     02/16/05 - bug 2662095 
Rem    yxie        02/15/05 - retrieve status in addition to up and down
Rem    jabramso    02/08/05 - Change total_target to MGMT_MD_COMPARE_ARRAY 
Rem    niramach    02/04/05 - exempt->suppress conversions 
Rem    ancheng     02/11/05 - bug 4176489
Rem    ancheng     02/08/05 - modify get_target_settings 
Rem    paachary    02/08/05 - Changed the package name from mgmt_license to em_license
Rem    ancheng     01/28/05 - remote metrics 
Rem    vkgarg      01/24/05 - pass date as varchar in get_metric_details and 
Rem                           get_metric_details_ts 
Rem    vkgarg      01/20/05 - add proc to get target info 
Rem    vkgarg      01/17/05 - update get_key_value_avg_details to get last 
Rem                           collected timestamp 
Rem    vkgarg      01/16/05 - get target loadtime in get_all_metrics 
Rem    vkgarg      01/11/05 - add omstimezone to get_metric_details and get_metric_details_ts 
Rem    vkgarg      01/11/05 - add timezone to custom dates 
Rem    vkgarg      01/06/05 - get target load and last load timestamp
Rem    vkgarg      01/06/05 - get last comment for metric severity 
Rem    ancheng     01/17/05 - add more APIs 
Rem    ramalhot    01/17/05 - g_member_guid->g_contains_guid
Rem    ancheng     01/11/05 - bug 4051181
Rem    jabramso    01/07/05 - Support for multiple key -values- (not composites)
Rem    vagarwal    01/05/05 - fix perf bug 3927890 cur metric query, sev query 
Rem    skini       12/29/04 - Change in collection_name column 
Rem    groyal      12/28/04 - Update get_*_mntr_settings to grab all agent-side metrics 
Rem    jvishen     12/29/04 - update to get ca reference count 
Rem    mfidanbo    12/22/04 - get beacon/test information for generic services 
Rem                           folder 
Rem    groyal      12/22/04 - Update collection config sql to include external 
Rem                           metrics 
Rem    ancheng     12/21/04 - change queries
Rem    mfidanbo    12/07/04 - make changes to get webapp data 
Rem    ancheng     12/09/04 - object type change 
Rem    jpyang      12/01/04 - fix service folder page 
Rem    njuillar    12/03/04 - Add get_has_template_privilege 
Rem    rpinnama    12/03/04 - Use object type constants
Rem    ancheng     11/30/04 - change collection queries 
Rem    groyal      11/29/04 - Add additional select columns in 
Rem                           get_[library|target]_policy_settings 
Rem    jvishen     12/02/04 - update get_metric detail for CAs 
Rem    njuillar    11/24/04 - Add get_template_pending_changes 
Rem    groyal      11/22/04 - Add get_target_policy_settings, get_library_policy_settings
Rem    groyal      11/17/04 - Support for event-driven policies 
Rem    ancheng     11/17/04 - policy change for transposed metrics 
Rem    yaofeng     11/16/04 - alert number 
Rem    jaysmith    11/13/04 - get CA execution id 
Rem    jaysmith    11/12/04 - ca job-types must be editable 
Rem    dcawley     11/10/04 - Fix queries against priv grants tables 
Rem    yaofeng     11/10/04 - no fixed types for group 
Rem    vkgarg      11/07/04 - update get_metric_details for last known value 
Rem    jpyang      11/05/04 - member type column for groups 
Rem    jpyang      11/01/04 - fix system folder 
Rem    ancheng     11/02/04 - add get_metric_collection_info
Rem    skini       10/22/04 - job versioning changes 
Rem    ancheng     10/25/04 - add get_target_collection_info
Rem    jaysmith    10/22/04 - multitask CAs 
Rem    groyal      10/15/04 - Add policy support to get_console_homepage_info
Rem    jpyang      10/14/04 - responsetime -> performance 
Rem    ancheng     10/13/04 - add collection credentials 
Rem    rzazueta    10/06/04 - Set ca_scope according to object type 
Rem    asawant     09/16/04 - Extending user preferences.
Rem    rpinnama    10/10/04 - Replace template_ with mntr_ 
Rem    rzazueta    09/26/04 - Add get_template_copy_settings, 
Rem                           get_mntr_settings_copy 
Rem    vagarwal    09/27/04 - add support for system 
Rem    jaysmith    09/26/04 - initialize corrective actions 
Rem    njuillar    09/30/04 - Add get_template_settings 
Rem    groyal      09/28/04 - Add get_policy_settings 
Rem    ancheng     09/24/04 - add save_target_settings 
Rem    jpyang      09/20/04 - add query for services folder 
Rem    groyal      09/22/04 - Add compilance score 
Rem    rpinnama    09/23/04 - Rename template_override as prevent_override 
Rem    rzazueta    09/15/04 - Return keyColumn in MonitoringSettings 
Rem    groyal      09/17/04 - Enhance get_*_mntr_settings to get 
Rem                           additional policy attributes 
Rem    asaraswa    09/16/04 - removing unused procedure get_ecm_homepage_info 
Rem    asawant     07/08/04 - Integrating with TgtSrch 
Rem    ancheng     09/01/04 - change API 
Rem    ramalhot    08/24/04 - cutover to new assoc tables 
Rem    vkgarg      08/24/04 - updating retention period APIs
Rem    vkgarg      08/24/04 - removing retention period APIs
Rem    vkgarg      08/04/04 - adding retention period APIs
Rem    vkgarg      07/28/04 - removing byCustom from get_key_value_avg_details 
Rem    vkgarg      07/23/04 - adding start and end time parameters 
Rem    ancheng     08/17/04 - add get_monitoring_settings 
Rem    groyal      08/09/04 - Policy work 
Rem    dcawley     07/07/04 - Increase user name size 
Rem    rdabbott    12/19/03 - Fix 3328590: allow timezone regions 
Rem    ancheng     12/11/03 - bug 3308283 
Rem    jpyang      12/04/03 - 
Rem    jpyang      11/23/03 - add license table sql 
Rem    joguo       11/14/03 - cleanup 
Rem    joguo       11/03/03 - create new group pages
Rem    rpatti      10/21/03 - change def. sort order to target name 
Rem    hasriniv    10/16/03 - Moving proc get_lsnr_homepage_info to mgmt_dbnet 
Rem    ancheng     10/09/03 - bug 3186102 
Rem    joguo       10/03/03 - Fix of bug 2997137 
Rem    shuberma    09/26/03 - Use group_flat_memberships 
Rem    ancheng     09/22/03 - bug 3129616 
Rem    rpatti      09/25/03 - clean up to_char references 
Rem    jpyang      09/09/03 - fix sql for target picker 
Rem    jpyang      08/29/03 - add multiple targets deletion 
Rem    jpyang      08/27/03 - add resource bundle map 
Rem    ancheng     08/26/03 - bug 3029095 
Rem    hasriniv    08/19/03 - Fix for bug 3021974
Rem    joguo       08/15/03 - 
Rem    jpyang      07/30/03 - target selection query
Rem    ancheng     07/30/03 - severity/annotation change
Rem    ancheng     07/08/03 - bug 3025046
Rem    groyal      07/03/03 - Add support for policy violations
Rem    ancheng     06/16/03 - manual clear of alerts
Rem    yaofeng     06/11/03 - fix wrong condition
Rem    ancheng     06/02/03 - change get_key_value_avg_details
Rem    ancheng     05/19/03 - manual clear of severity
Rem    jpyang      05/19/03 - 2849312
Rem    rpatti      04/11/03 - show latest values for string metrics
Rem    ancheng     03/24/03 - support 5 composite keys
Rem    jpyang      03/24/03 - nls support
Rem    ancheng     02/20/03 - targets and metrics version support
Rem    dcawley     02/20/03 - Fix non-key lookups
Rem    aarasu      02/14/03 - add new function for ecm home page
Rem    ancheng     02/13/03 - target version fix
Rem    xuliu       01/22/03 - review chg
Rem    xuliu       01/20/03 - database type & rac status details
Rem    xuliu       12/02/02 - fix rac rollup
Rem    xuliu       11/18/02 - rac db rollup in database folder
Rem    agor        11/14/02 - get some more counts for console home page
Rem    rpatti      11/11/02 - fix date changes
Rem    rpatti      11/04/02 - get collection timestamp as well
Rem    jsoule      10/31/02 - add new alias variable for clarity
Rem    jsoule      10/30/02 - modify user prefs queries
Rem    ltheobal    10/23/02 - use internal name for display name 
Rem    ancheng     10/15/02 - all metrics UI review
Rem    ancheng     10/04/02 - bug 2595209
Rem    ancheng     09/24/02 - cut over to use ecm views in get_console_homepage_info
Rem    ancheng     09/16/02 - modify get_current_metric_details, get_metric_details
Rem    ancheng     09/09/02 - console homepage group avail change
Rem    rpatti      09/14/02 - move folders pl/sql
Rem    yaofeng     08/28/02 - remove oracle_context and associated files
Rem    ancheng     07/16/02 - add procedure for console home page
Rem    rzazueta    07/23/02 - fix version in get_ebs_sitemap_info
Rem    rpatti      07/18/02 - composite keys table now has target guids
Rem    ancheng     06/27/02 - bug 2323918
Rem    ancheng     06/24/02 - modify get_current_metric_details
Rem    yaofeng     06/26/02 - initialize out parameters
Rem    yaofeng     06/26/02 - dos2unix
Rem    yaofeng     06/24/02 - remove passing label and images out
Rem    ancheng     06/18/02 - support composite key
Rem    rpatti      06/20/02 - support composite keys
Rem    ancheng     06/13/02 - add severity table for string metrics
Rem    ancheng     06/07/02 - fix get_all_metrics
Rem    ancheng     05/22/02 - add proc for all metrics
Rem    rpinnama    05/15/02 - rpinnama_reorg_rep_scripts
Rem    rpinnama    05/15/02 - Restructured.
Rem    ancheng     05/06/02 - fix lsnr host name
Rem    rpatti      04/23/02 - remove big ip support
Rem    rpatti      04/23/02 - add get_metric_threshold_info Procedure
Rem    ancheng     04/05/02 - dummy cursor for get_databases_info
Rem    tjaiswal    04/01/02 - Misc group fixes
Rem    ancheng     03/01/02 - add procedure
Rem    rpatti      03/06/02 - support mcAvg, mcCurrent pages
Rem    yaofeng     01/25/02 - add get_ebs_sitemap_info
Rem    rzazueta    01/18/02 - Update get_forms6_sitemap_info
Rem    edemembe    01/08/02 - Metrics are now target independent
Rem    edemembe    12/26/01 - Removing TARGET_NAME,TARGET_TYPE,etc
Rem    ancheng     12/18/01 - changes for listener
Rem    njuillar    12/13/01 - Split file
Rem    njuillar    12/11/01 - Get needed properties for metric details
Rem    rmarripa    12/07/01 - To fix the order in watch list table..
Rem    rmarripa    12/06/01 - To fix the query which retrieves the filter. bug#2135073.
Rem    rmarripa    12/06/01 - Fix query to get metric guid in getMostFavTimeSeries..
Rem    yaofeng     12/11/01 - add get_reports6_sitemap_info for oracle_reports6
Rem    rmarripa    11/29/01 - emd_user_mntr.getMostFavResponseTimeSeries and 
Rem                           getMetricsResponseTimeseries. Changed where clause 
Rem                           from !='Status' to ='Timing'..
Rem    rpatti      12/05/01 - move host sql out
Rem    rpatti      11/28/01 - do not show number of alerts
Rem    starng      11/23/01 -
Rem    lgloyd      11/19/01 - fix cursor leak
Rem    lgloyd      11/16/01 - fix min hits prob, handle nulls
Rem    lgloyd      11/14/01 - more chronos procedures
Rem    lgloyd      11/13/01 - add procedures
Rem    tjaiswal    11/09/01 - Add get_comp_tgt_children_data
Rem    lgloyd      11/12/01 - chronos performance work
Rem    yaofeng     11/06/01 - changed metric name
Rem    njuillar    10/25/01 - Get occurrences in get_metric_details
Rem    tjaiswal    10/31/01 - Remove usage of em$target_ui_status
Rem    njuillar    10/22/01 - Added back Memory Scan Rate to Host homepage
Rem    smishra     10/19/01 - Getstatuscode fixed
Rem    smishra     10/18/01 - Blackout status added
Rem    rzazueta    10/17/01 - add get_forms6_sitemap_info for oracle_forms6
Rem    yaofeng     10/10/01 - use hourly completed requests
Rem    njuillar    10/08/01 - Get key name for get_metric_details()
Rem    yaofeng     10/05/01 - add get_cmanager_sitemap_info for oracle_cmanager
Rem    rmarripa    09/28/01 - To modify chronosDataExists to use targetGuid.
Rem    lgloyd      09/26/01 - remove target_name from exchange and website pack
Rem    rmarripa    09/27/01 - modify chronosDataExists.
Rem    rmarripa    09/26/01 - To change chronosDataExists function to look 
Rem                           for property in properties table..
Rem    lgloyd      09/25/01 - use guids for chronsDataExists
Rem    rpatti      09/24/01 - remove references to perf_code
Rem    njuillar    09/19/01 - Separate query for metric details thresholds
Rem    rpatti      09/14/01 - use the global timestamp format
Rem    rpatti      09/10/01 - use consistent timestamp format
Rem    vnukal      09/14/01 - update hostsitemap query
Rem    njuillar    08/31/01 - Use 1-day rollups for 31-day metric details
Rem    rpinnama    08/24/01 - Use timestamp instead of date
Rem    ancheng     08/30/01 - reset initial values
Rem    njuillar    08/21/01 - Change latest value handling in get_metric_details
Rem    njuillar    08/20/01 - Added get_metric_details() in emd_mntr package
Rem    lgloyd      08/20/01 - add distinct keyword to subselect where multi val
Rem    lgloyd      08/09/01 - fix chronos exists check
Rem    ancheng     07/31/01 - use mgmt_ table name
Rem    rpatti      07/20/01 - update for repository changes
Rem    skini       07/21/01 - Merge in rpatti transaction
Rem    lgloyd      07/20/01 - latency check
Rem    lgloyd      07/18/01 - new exchange metrics
Rem    rpatti      07/10/01 - update fro schema revamp
Rem    lgloyd      07/09/01 - move utility function to EmdSchema
Rem    lgloyd      07/05/01 - add chronos package
Rem    lgloyd      07/02/01 - new metric format
Rem    lgloyd      06/28/01 - exchange sitemap work
Rem    ancheng     06/27/01 - modify getHostSiteMapInfo
Rem    ancheng     06/21/01 - modify getHostSiteMapInfo
Rem    ancheng     06/15/01 - modify getHostSiteMapInfo
Rem    ancheng     06/12/01 - modify getExchangeSiteMapInfo
Rem    rpatti      06/07/01 - check NULL values
Rem    ancheng     05/24/01 - check availability
Rem    ancheng     05/14/01 - fix getMonitoredDatabaseInfo
Rem    ancheng     05/08/01 - modify getExchangeSiteMapInfo
Rem    ancheng     05/04/01 - remove functions
Rem    rpatti      05/03/01 - rearrange display for host
Rem    ancheng     05/02/01 - add getSystemComponents
Rem    ancheng     05/01/01 - capitalize trace level, etc
Rem    ancheng     04/30/01 - add getBigIPSiteMapInfo, getExchangeSiteMapInfo
Rem    rpatti      04/24/01 - cleanup sql
Rem    ancheng     04/18/01 - add getMonitoredDatabases
Rem    rpatti      04/19/01 - get host config rel values
Rem    rpatti      04/12/01 - updates to the host overview page
Rem    ancheng     04/13/01 - add procedures/functions for listener
Rem    tjaiswal    04/11/01 - Modify getHostTargetsInfo procedure
Rem    tjaiswal    04/06/01 - Changes to getHostSiteMapInfo
Rem    tjaiswal    04/05/01 - Created
Rem


CREATE OR REPLACE PACKAGE BODY emd_mntr AS

-- These are the IDs under which the preferences for All Targets and Groups
-- are stored.
ALL_TARGETS_PREF_ID VARCHAR2(20) := 'All Targets';
GROUPS_PREF_ID VARCHAR2(20) := 'Groups';

function getStatusCode(
                            targetName VARCHAR2,
                            targetType VARCHAR2) return INTEGER IS
    statusCode INTEGER;
    gotStatus INTEGER;
    l_target_guid mgmt_targets.target_guid%TYPE;
    
    begin
        /*
        initialize parameters            
        */
        statusCode := 0;
        gotStatus  := 0; /* 0 meaning did not get status, 1 meaning got status */
        
        /*
        Store the target guid to improve performance.
        */
        SELECT target_guid 
          INTO l_target_guid
          FROM mgmt_targets t
          WHERE t.target_name = targetName
            AND t.target_type = targetType;
        
        /* 
        find out the status code for the given target name and target type
        combination
        */                    
        for record in (
                    
            SELECT a.current_status
              FROM mgmt_current_availability a
              WHERE l_target_guid = a.target_guid
                      
                      ) loop

            statusCode := record.current_status;
            gotStatus := 1;
            exit;
                    
        end loop;
        
        if( gotStatus = 0 ) then
            statusCode := 2; /* a value to indicate the status is unknown */
        end if;
        
        return statusCode;        
    end;
                                
function getMetricValue(
                            targetName IN VARCHAR2,
                            targetType IN VARCHAR2,
                            metricName IN VARCHAR2,
                            metricColumn IN VARCHAR2,
                            doRound IN NUMBER DEFAULT 0) return NUMBER IS
    
    metricValue NUMBER;
    
    begin
        /*
        initialize parameters            
        */
        metricValue := NULL; /* default to NULL if not found */
            
        IF doRound = 0
        THEN
          /* 
          find out the metric value for the given target name, target type 
          metric name and metric column combination
          */                    
          for record in (

            select value
                from mgmt_current_metrics curmet,
                     mgmt_targets tgt, mgmt_metrics met
                where tgt.target_name = targetName and
                      tgt.target_type = targetType and
                      tgt.target_guid = curmet.target_guid and
                      tgt.target_type = met.target_type and
                      met.metric_name = metricName and
                      met.metric_column = metricColumn and
                      met.metric_guid = curmet.metric_guid 
                  AND met.type_meta_ver = tgt.type_meta_ver
                  AND (met.category_prop_1 = tgt.category_prop_1 OR met.category_prop_1 = ' ')
                  AND (met.category_prop_2 = tgt.category_prop_2 OR met.category_prop_2 = ' ')
                  AND (met.category_prop_3 = tgt.category_prop_3 OR met.category_prop_3 = ' ')
                  AND (met.category_prop_4 = tgt.category_prop_4 OR met.category_prop_4 = ' ')
                  AND (met.category_prop_5 = tgt.category_prop_5 OR met.category_prop_5 = ' ')
          ) loop

              metricValue := record.value;                
              exit;
                    
          end loop;
        ELSE 
          /* 
          find out the metric value rounded to 2 values
          for the given target name, target type 
          metric name and metric column combination
          */                    
          for record in (
                      
              select round(value, 2) as value
                from mgmt_current_metrics curmet,
                     mgmt_targets tgt, mgmt_metrics met
                where tgt.target_name = targetName and
                      tgt.target_type = targetType and
                      tgt.target_guid = curmet.target_guid and
                      tgt.target_type = met.target_type and
                      met.metric_name = metricName and
                      met.metric_column = metricColumn and
                      met.metric_guid = curmet.metric_guid
                  AND met.type_meta_ver = tgt.type_meta_ver
                  AND (met.category_prop_1 = tgt.category_prop_1 OR met.category_prop_1 = ' ')
                  AND (met.category_prop_2 = tgt.category_prop_2 OR met.category_prop_2 = ' ')
                  AND (met.category_prop_3 = tgt.category_prop_3 OR met.category_prop_3 = ' ')
                  AND (met.category_prop_4 = tgt.category_prop_4 OR met.category_prop_4 = ' ')
                  AND (met.category_prop_5 = tgt.category_prop_5 OR met.category_prop_5 = ' ')
          ) loop

              metricValue := record.value;                
              exit;
                    
          end loop;
        END IF;
        return metricValue;
    end;

function getMetricStringValue(
                            targetName IN VARCHAR2,
                            targetType IN VARCHAR2,
                            metricName IN VARCHAR2,
                            metricColumn IN VARCHAR2) return VARCHAR2 IS
    
    metricValue VARCHAR2(128);
    
    begin
        /*
        initialize parameters            
        */
        metricValue := NULL; /* default to NULL if not found */
            
        /* 
        find out the metric value for the given target name, target type 
        metric name and metric column combination
        */                    
        for record in (
                    
            select string_value
                from mgmt_current_metrics curmet,
                     mgmt_targets tgt, mgmt_metrics met
                where tgt.target_name = targetName and
                      tgt.target_type = targetType and
                      tgt.target_guid = curmet.target_guid and
                      tgt.target_type = met.target_type and
                      met.metric_name = metricName and
                      met.metric_column = metricColumn and
                      met.metric_guid = curmet.metric_guid 
                  AND met.type_meta_ver = tgt.type_meta_ver
                  AND (met.category_prop_1 = tgt.category_prop_1 OR met.category_prop_1 = ' ')
                  AND (met.category_prop_2 = tgt.category_prop_2 OR met.category_prop_2 = ' ')
                  AND (met.category_prop_3 = tgt.category_prop_3 OR met.category_prop_3 = ' ')
                  AND (met.category_prop_4 = tgt.category_prop_4 OR met.category_prop_4 = ' ')
                  AND (met.category_prop_5 = tgt.category_prop_5 OR met.category_prop_5 = ' ')
        ) loop
                                  
            metricValue := record.string_value;                
            exit;
                    
        end loop;
        
        return metricValue;
    end;

procedure get_lsnr_member_summary(
                                target_name_in IN VARCHAR2,
                                summary_out OUT cursorType ) IS
                                
    BEGIN

        -- now for the given target name, target type(oracle_database), get
        -- the summary info
        -- NOTE: this cursor returns a hard-coded value for severity code
        --       The calling procedure does not really use the severity code
        --       and so returning a hard coded value. 
        --       SMP_EMD_TARGET_OBJ needs to change by removing the severity_code
        --       field from there
        OPEN summary_out FOR
          SELECT tgt.target_name, 
                 tgt.target_type, 
                 tgt.display_name, 
                 tgt.type_display_name, 
                 15 AS severity_code,
                 ROUND(mgmt_target.get_avail_pct_value(tgt.target_guid, 1), 0) AS avail_pct,
                 mgmt_target.get_avail_current_status(tgt.target_guid) AS current_status,
                 NVL(sev_detail.warning_count, 0) AS warning_count,
                 NVL(sev_detail.critical_count, 0) AS critical_count,
                 tgt.target_guid
            FROM mgmt_targets tgt,
                 (SELECT target_guid, 
                         SUM(DECODE(severity_code,MGMT_GLOBAL.G_SEVERITY_WARNING,1,0)) AS warning_count,
                         SUM(DECODE(severity_code,MGMT_GLOBAL.G_SEVERITY_CRITICAL,1,0)) AS critical_count
                    FROM mgmt_current_severity
                   GROUP BY target_guid ) sev_detail
           WHERE tgt.target_guid = sev_detail.target_guid (+) 
             AND tgt.target_name=target_name_in
             AND tgt.target_type= MGMT_GLOBAL.G_DATABASE_TARGET_TYPE
           ORDER BY tgt.type_display_name, tgt.target_name;            

    END;                                        
                                                    

--
-- PROCEDURE: get_comp_tgt_children_data
--
-- PURPOSE:
--   Returns a summary of monitoring details for the members of 
--     a particular target.
--
PROCEDURE get_comp_tgt_children_data
  (target_name_in  IN VARCHAR2,
   target_type_in  IN VARCHAR2,
   timeperiod_in   IN NUMBER DEFAULT MGMT_GLOBAL.G_DAY,   
   traffic_summary_out OUT cursorType,   
   summary_out OUT cursorType)
IS

  l_target_guid  mgmt_targets.target_guid%TYPE;
  l_time_difference NUMBER := 1;

BEGIN

  l_time_difference := mgmt_target.get_time_difference(timeperiod_in);
  
  -- may throw a TARGET_DOES_NOT_EXIST EXCEPTION
  l_target_guid := mgmt_target.get_target_guid(target_name_in, target_type_in);

  -- get the traffic light related info of the composite target
  OPEN traffic_summary_out FOR
    SELECT ROUND(mgmt_target.get_avail_pct_value(tgt.target_guid, l_time_difference), 2) AS avail_pct,
           mgmt_target.get_avail_current_status(tgt.target_guid) AS current_status,
           NVL(sev_detail.warning_count, 0) AS warning_count,
           NVL(sev_detail.critical_count, 0) AS critical_count
      FROM mgmt_targets tgt,
           (SELECT target_guid, 
                   SUM(DECODE(severity_code,MGMT_GLOBAL.G_SEVERITY_WARNING,1,0)) AS warning_count,
                   SUM(DECODE(severity_code,MGMT_GLOBAL.G_SEVERITY_CRITICAL,1,0)) AS critical_count
              FROM mgmt_current_severity
             WHERE target_guid = l_target_guid
             GROUP BY target_guid ) sev_detail
     WHERE tgt.target_guid = l_target_guid 
       AND tgt.target_guid = sev_detail.target_guid (+);

  -- get member monitoring summary for all member targets of the 
  -- composite target
  mgmt_target.get_member_monitoring_summary( target_name_in,
                                             target_type_in,
                                             '',
                                             timeperiod_in,
                                             summary_out );                                                                                          

END get_comp_tgt_children_data;

--
-- PROCEDURE: get_current_metric_details
--
-- PURPOSE:
--   This procedure returns all current metric information displayed in the current
--   metric detail page
--
PROCEDURE get_current_metric_details(target_name_in                 IN  VARCHAR2,
                                     target_type_in                 IN  VARCHAR2,
                                     metric_name_in                 IN  VARCHAR2,
                                     metric_column_in               IN  VARCHAR2,
                                     key_value_in                   IN  VARCHAR2,
                                     metric_warning_threshold_out   OUT VARCHAR2,
                                     metric_critical_threshold_out  OUT VARCHAR2,
                                     num_occurences_out             OUT VARCHAR2,
                                     has_priv_out                   OUT NUMBER,
                                     metric_info_out                OUT cursorType,
                                     composite_key_info_out         OUT cursorType,
                                     number_metric_info_out         OUT cursorType,
                                     string_metric_info_out         OUT cursorType,
                                     metric_sev_out                 OUT cursorType,
                                     current_metric_sev_out         OUT cursorType,
                                     ca_severity_out                OUT NUMBER,
                                     target_info_out                OUT cursorType ) IS

  l_target_guid RAW(16);
  l_metric_guid RAW(16);
  l_metric_column_type VARCHAR2(16);
  l_latest_point_timestamp DATE;
  l_end_time DATE;
  l_timezone_region mgmt_targets.timezone_region%TYPE;
  l_type_meta_ver mgmt_targets.type_meta_ver%TYPE;
  l_category_prop_1 mgmt_targets.category_prop_1%TYPE;
  l_category_prop_2 mgmt_targets.category_prop_2%TYPE;
  l_category_prop_3 mgmt_targets.category_prop_3%TYPE;
  l_category_prop_4 mgmt_targets.category_prop_4%TYPE;
  l_category_prop_5 mgmt_targets.category_prop_5%TYPE;
  l_cfg_coll_name mgmt_policy_assoc_cfg.coll_name%TYPE;
  l_cfg_key_value mgmt_policy_assoc_cfg.key_value%TYPE;
  l_cfg_key_operator mgmt_policy_assoc_cfg.key_operator%TYPE;

BEGIN

  -- target guid
  BEGIN
    SELECT target_guid, type_meta_ver, category_prop_1, category_prop_2,
           category_prop_3, category_prop_4, category_prop_5, timezone_region
      INTO l_target_guid, l_type_meta_ver, l_category_prop_1, l_category_prop_2,
           l_category_prop_3, l_category_prop_4, l_category_prop_5,
           l_timezone_region
      FROM mgmt_targets
     WHERE target_name = target_name_in
       AND target_type = target_type_in;

    EXCEPTION
      WHEN NO_DATA_FOUND
        THEN raise MGMT_GLOBAL.target_does_not_exist;
  END;

  -- metric guid and metric column type
  BEGIN
    -- note: the "rownum = 1" is to ensure only one row is returned. This may
    -- not return the correct metric row if EMD allow empty and non-empty 
    -- values of category_prop_* columns to exist at the same time. The problem
    -- will also occur during migration.
    SELECT metric_guid, DECODE(metric_type, 0, 'NUMBER', 1, 'STRING', 'OTHER')
      INTO l_metric_guid, l_metric_column_type
      FROM mgmt_metrics
     WHERE target_type = target_type_in
       AND metric_name = metric_name_in
       AND metric_column = metric_column_in
       AND usage_type = MGMT_GLOBAL.G_USAGE_VIEW_COLLECT
       AND type_meta_ver = l_type_meta_ver
       AND (category_prop_1 = l_category_prop_1 OR category_prop_1 = ' ')
       AND (category_prop_2 = l_category_prop_2 OR category_prop_2 = ' ')
       AND (category_prop_3 = l_category_prop_3 OR category_prop_3 = ' ')
       AND (category_prop_4 = l_category_prop_4 OR category_prop_4 = ' ')
       AND (category_prop_5 = l_category_prop_5 OR category_prop_5 = ' ')
       AND rownum = 1;

    EXCEPTION
      WHEN NO_DATA_FOUND
        THEN raise MGMT_GLOBAL.no_such_metric_found;
  END;          

  -- labels, key column, key order, number of keys, and metric type information 
  OPEN metric_info_out FOR
    -- note: This may not return the correct metric rows if EMD allow empty and
    -- non-empty values of category_prop_* columns to exist at the same time.
    -- The problem will also occur during migration.
    SELECT metric_label, column_label,  
           metric_column, key_column, key_order, num_keys, metric_type, 
           DECODE(metric_type, 0, 'NUMBER', 1, 'STRING', 'OTHER') AS metric_type_str,
           metric_label_nlsid, column_label_nlsid, statefull
      FROM mgmt_metrics
     WHERE target_type = target_type_in
       AND metric_name = metric_name_in
       AND (metric_column = metric_column_in OR key_order != 0 OR 
            metric_type = MGMT_GLOBAL.G_METRIC_TYPE_TABLE OR
            metric_type = MGMT_GLOBAL.G_METRIC_TYPE_REPOS_TABLE)
       AND usage_type = MGMT_GLOBAL.G_USAGE_VIEW_COLLECT
       AND type_meta_ver = l_type_meta_ver
       AND (category_prop_1 = l_category_prop_1 OR category_prop_1 = ' ')
       AND (category_prop_2 = l_category_prop_2 OR category_prop_2 = ' ')
       AND (category_prop_3 = l_category_prop_3 OR category_prop_3 = ' ')
       AND (category_prop_4 = l_category_prop_4 OR category_prop_4 = ' ')
       AND (category_prop_5 = l_category_prop_5 OR category_prop_5 = ' ');

  -- for composite keys
  IF(key_value_in IS NOT NULL)
  THEN
    OPEN composite_key_info_out FOR
      SELECT *
        FROM mgmt_metrics_composite_keys
       WHERE target_guid = l_target_guid 
         AND composite_key = key_value_in;
  ELSE
    -- open a dummy cursor
    OPEN composite_key_info_out FOR
      SELECT * 
        FROM mgmt_metrics_composite_keys
       WHERE rownum < 1;
  END IF;

  -- check if the user has at least OPERATOR_TARGET privilege
  has_priv_out := mgmt_user.has_priv(
    mgmt_user.get_current_em_user(), mgmt_user.OPERATOR_TARGET, l_target_guid);

  -- get configuration details for key_value_in
  EM_POLICY.get_config_key_details(p_object_guid => l_target_guid,
                                   p_policy_guid => l_metric_guid,
                                   p_key_value => key_value_in,
                                   p_cfg_coll_name => l_cfg_coll_name,
                                   p_cfg_key_value => l_cfg_key_value,
                                   p_cfg_key_operator => l_cfg_key_operator);

  -- thresholds information
  IF(key_value_in IS NOT NULL)
  THEN 
    BEGIN
      SELECT warning_threshold, critical_threshold, num_occurences
        INTO metric_warning_threshold_out, metric_critical_threshold_out,
             num_occurences_out
        FROM mgmt_metric_thresholds
       WHERE target_guid = HEXTORAW(l_target_guid)
         AND metric_guid = HEXTORAW(l_metric_guid)
         AND coll_name = l_cfg_coll_name
         AND key_value = l_cfg_key_value
         AND key_operator = l_cfg_key_operator;

      EXCEPTION
        WHEN NO_DATA_FOUND
          THEN
            BEGIN
              SELECT warning_threshold, critical_threshold, num_occurences
                INTO metric_warning_threshold_out, metric_critical_threshold_out,
                     num_occurences_out
                FROM mgmt_metric_thresholds
               WHERE target_guid = HEXTORAW(l_target_guid)
                 AND metric_guid = HEXTORAW(l_metric_guid)
                 AND key_value = ' ';

              EXCEPTION
                WHEN NO_DATA_FOUND
                  THEN
                    metric_warning_threshold_out := NULL;
                    metric_critical_threshold_out := NULL;
                    num_occurences_out := 0;
            END;
    END;
  ELSE
    BEGIN
      SELECT warning_threshold, critical_threshold, num_occurences
        INTO metric_warning_threshold_out, metric_critical_threshold_out,
             num_occurences_out
        FROM mgmt_metric_thresholds
       WHERE target_guid = HEXTORAW(l_target_guid)
         AND metric_guid = HEXTORAW(l_metric_guid)
         AND key_value = ' ';

      EXCEPTION
        WHEN NO_DATA_FOUND
          THEN
            metric_warning_threshold_out := NULL;
            metric_critical_threshold_out := NULL;
            num_occurences_out := 0;
    END;
  END IF;

  -- get the sysdate in terms of this target
  l_end_time := mgmt_global.SYSDATE_TZRGN(l_timezone_region);

  -- metric value for the past 1.5 hours
  IF(l_metric_column_type = 'NUMBER')
  THEN
    -- number metric
    IF(key_value_in is NOT NULL)
    THEN
      OPEN number_metric_info_out FOR
        SELECT collection_timestamp, value
          FROM mgmt_metrics_raw
         WHERE target_guid = HEXTORAW(l_target_guid)  
           AND metric_guid = HEXTORAW(l_metric_guid) 
           AND collection_timestamp >= l_end_time - 1/16
           AND key_value = key_value_in
         ORDER BY collection_timestamp, value;
    ELSE
      OPEN number_metric_info_out FOR
        SELECT collection_timestamp, value
          FROM mgmt_metrics_raw
         WHERE target_guid = HEXTORAW(l_target_guid)  
           AND metric_guid = HEXTORAW(l_metric_guid) 
           AND collection_timestamp >= l_end_time - 1/16
         ORDER BY collection_timestamp, value;
    END IF;
  ELSIF(l_metric_column_type = 'STRING')
  THEN
    -- string metric
    IF(key_value_in is NOT NULL)
    THEN
      OPEN string_metric_info_out FOR
        SELECT collection_timestamp, string_value
          FROM mgmt_metrics_raw
         WHERE target_guid = HEXTORAW(l_target_guid)  
           AND metric_guid = HEXTORAW(l_metric_guid) 
           AND collection_timestamp >= l_end_time - 1/16
           AND key_value = key_value_in
         ORDER BY collection_timestamp, string_value;
    ELSE
      OPEN string_metric_info_out FOR
        SELECT collection_timestamp, string_value
          FROM mgmt_metrics_raw
         WHERE target_guid = HEXTORAW(l_target_guid)  
           AND metric_guid = HEXTORAW(l_metric_guid) 
           AND collection_timestamp >= l_end_time - 1/16
         ORDER BY collection_timestamp, string_value;
    END IF;
  END IF;

  -- severity information
  IF(key_value_in is NOT NULL)
  THEN
    -- find the latest severity timestamp
    BEGIN
    /*
      SELECT MAX(collection_timestamp) INTO l_latest_point_timestamp
        FROM mgmt_violations
       WHERE target_guid = HEXTORAW(l_target_guid)
         AND policy_guid = HEXTORAW(l_metric_guid)
         AND key_value = key_value_in
         AND collection_timestamp <= l_end_time
         AND violation_level != MGMT_GLOBAL.G_SEVERITY_COMMENT
         AND violation_type IN (0, 1, 2);
    */
      SELECT collection_timestamp 
      INTO l_latest_point_timestamp
      FROM
       ( SELECT collection_timestamp
         FROM mgmt_violations
         WHERE target_guid = HEXTORAW(l_target_guid)
           AND policy_guid = HEXTORAW(l_metric_guid)
           AND key_value = key_value_in
           AND collection_timestamp <= l_end_time
           AND violation_level != MGMT_GLOBAL.G_SEVERITY_COMMENT
           AND violation_type IN (0, 1, 2)
           ORDER BY collection_timestamp DESC
        ) 
        WHERE ROWNUM < 2;

      IF(l_latest_point_timestamp IS NULL)
      THEN
        l_latest_point_timestamp := l_end_time;
      END IF;

      EXCEPTION
        WHEN NO_DATA_FOUND
        THEN
          l_latest_point_timestamp := l_end_time;
      END;

    OPEN metric_sev_out FOR
      SELECT sev.severity_guid, sev.severity_code, sev.collection_timestamp,
             '<SYSTEM>' AS user_name, sev.message, sev.message_nlsid, sev.message_params,
             ( (SELECT COUNT(*)
                  FROM mgmt_severity_annotation
                 WHERE severity_guid = sev.severity_guid) + 
               (SELECT COUNT(*)
                  FROM mgmt_notification_log
                 WHERE source_obj_type = MGMT_GLOBAL.G_ANNOTATION_SOURCE_SEVERITY
                   AND source_obj_guid = sev.severity_guid) ) AS annotation_count,
               (SELECT message 
                  FROM mgmt_severity_annotation 
                 WHERE severity_guid = sev.severity_guid
                   AND rownum < 2
                   AND collection_timestamp = (SELECT max(collection_timestamp)
                                                 FROM mgmt_severity_annotation 
                                                WHERE severity_guid = sev.severity_guid)) AS last_comment
        FROM mgmt_severity sev
       WHERE sev.target_guid = HEXTORAW(l_target_guid)
         AND sev.metric_guid = HEXTORAW(l_metric_guid)
         AND sev.key_value = key_value_in
         AND sev.collection_timestamp >= l_latest_point_timestamp
         AND sev.collection_timestamp <= l_end_time
         AND sev.severity_code != MGMT_GLOBAL.G_SEVERITY_COMMENT
       ORDER BY sev.collection_timestamp desc;
  ELSE
    -- find the latest severity timestamp
    BEGIN
    /*
      SELECT MAX(collection_timestamp) INTO l_latest_point_timestamp
        FROM mgmt_violations
       WHERE target_guid = HEXTORAW(l_target_guid)
         AND policy_guid = HEXTORAW(l_metric_guid)
         AND collection_timestamp <= l_end_time
         AND violation_level != MGMT_GLOBAL.G_SEVERITY_COMMENT
         AND violation_type IN (0, 1, 2);
    */

      SELECT collection_timestamp 
      INTO l_latest_point_timestamp
      FROM
      (
        SELECT collection_timestamp 
        FROM mgmt_violations
        WHERE target_guid = HEXTORAW(l_target_guid)
          AND policy_guid = HEXTORAW(l_metric_guid)
          AND collection_timestamp <= l_end_time
          AND violation_level != MGMT_GLOBAL.G_SEVERITY_COMMENT
          AND violation_type IN (0, 1, 2)
          ORDER BY collection_timestamp DESC
       ) WHERE ROWNUM < 2;

      IF(l_latest_point_timestamp IS NULL)
      THEN
        l_latest_point_timestamp := l_end_time;
      END IF;

      EXCEPTION
        WHEN NO_DATA_FOUND
        THEN
          l_latest_point_timestamp := l_end_time;
      END;

    OPEN metric_sev_out FOR
      SELECT sev.severity_guid, sev.severity_code, sev.collection_timestamp,
             '<SYSTEM>' AS user_name, sev.message, sev.message_nlsid, sev.message_params,
             ( (SELECT COUNT(*)
                  FROM mgmt_severity_annotation
                 WHERE severity_guid = sev.severity_guid) + 
               (SELECT COUNT(*)
                  FROM mgmt_notification_log
                 WHERE source_obj_type = MGMT_GLOBAL.G_ANNOTATION_SOURCE_SEVERITY
                   AND source_obj_guid = sev.severity_guid) ) AS annotation_count,
               (SELECT message 
                  FROM mgmt_severity_annotation 
                 WHERE severity_guid = sev.severity_guid
                   AND rownum < 2
                   AND collection_timestamp = (SELECT max(collection_timestamp)
                                                 FROM mgmt_severity_annotation 
                                                WHERE severity_guid = sev.severity_guid)) AS last_comment
        FROM mgmt_severity sev
       WHERE sev.target_guid = HEXTORAW(l_target_guid)
         AND sev.metric_guid = HEXTORAW(l_metric_guid)
         AND sev.collection_timestamp >= l_latest_point_timestamp
         AND sev.collection_timestamp <= l_end_time
         AND sev.severity_code != MGMT_GLOBAL.G_SEVERITY_COMMENT
       ORDER BY sev.collection_timestamp desc;
  END IF;

  -- current severity
  IF(key_value_in IS NOT NULL)  
  THEN
    OPEN current_metric_sev_out FOR
      SELECT *
        FROM mgmt_current_severity
       WHERE target_guid = HEXTORAW(l_target_guid)
         AND metric_guid = HEXTORAW(l_metric_guid)
         AND key_value = key_value_in;
  ELSE
    OPEN current_metric_sev_out FOR
      SELECT *
        FROM mgmt_current_severity
       WHERE target_guid = HEXTORAW(l_target_guid)
         AND metric_guid = HEXTORAW(l_metric_guid);
  END IF;
-- Get associated corrective action 
        get_metric_associated_ca(
                                  target_name_in ,
                                  target_type_in ,
                                  metric_name_in ,
                                  metric_column_in ,
                                  key_value_in ,
                                  ca_severity_out );

 -- Get target load and lastload timestamp with timezone
        get_target_info(
                          target_name_in ,
                          target_type_in ,
                          target_info_out);        
 
  
END get_current_metric_details;

/*
 * Get the metric details info. This procedure returns all the relevant 
 * information for a given target name, target type, metric name, metric column
 * and key value. The values returned as OUT parameters are used for display in
 * the Metric Details pages.
 */

PROCEDURE get_metric_details(target_name_in                 IN  VARCHAR2,
                             target_type_in                 IN  VARCHAR2,
                             metric_name_in                 IN  VARCHAR2,
                             metric_column_in               IN  VARCHAR2,
                             key_value_in                   IN  VARCHAR2,
                             page_type_in                   IN  VARCHAR2,
                             metric_latest_value_out        OUT VARCHAR2,
                             collection_timestamp_out       OUT DATE,
                             metric_warning_threshold_out   OUT VARCHAR2,
                             metric_critical_threshold_out  OUT VARCHAR2,
                             num_occurences_out             OUT VARCHAR2,
                             has_priv_out                   OUT NUMBER,
                             metric_info_out                OUT cursorType,
                             composite_key_info_out         OUT cursorType,
                             number_metric_info_out         OUT cursorType,
                             string_metric_info_out         OUT cursorType,
                             metric_sev_out                 OUT cursorType,
                             current_metric_sev_out         OUT cursorType,
                             start_Date_in                  IN  VARCHAR2 DEFAULT NULL,
                             end_Date_in                    IN  VARCHAR2 DEFAULT NULL,
                             ca_severity_out                OUT NUMBER,
                             target_info_out                OUT cursorType)
IS

 l_days NUMBER(2);  
 l_target_guid RAW(16);
 l_metric_guid RAW(16);
 l_metric_column_type VARCHAR2(16);
 l_first_point_timestamp DATE;
 l_start_time DATE;
 l_end_time DATE;
 l_custom_start_time DATE;
 l_custom_end_time DATE;
 l_period NUMBER;
 l_timezone_region mgmt_targets.timezone_region%TYPE;
 l_type_meta_ver mgmt_targets.type_meta_ver%TYPE;
 l_category_prop_1 mgmt_targets.category_prop_1%TYPE;
 l_category_prop_2 mgmt_targets.category_prop_2%TYPE;
 l_category_prop_3 mgmt_targets.category_prop_3%TYPE;
 l_category_prop_4 mgmt_targets.category_prop_4%TYPE;
 l_category_prop_5 mgmt_targets.category_prop_5%TYPE;
 l_custom_raw_window  NUMBER := null;
 l_custom_hour_window NUMBER := null;
 l_custom_day_window  NUMBER := null;
 l_crit_action_job_id mgmt_policy_assoc_cfg.crit_action_job_id%TYPE;
 l_warn_action_job_id mgmt_policy_assoc_cfg.warn_action_job_id%TYPE; 
 l_end_time_str VARCHAR2(200);
 l_cfg_coll_name mgmt_policy_assoc_cfg.coll_name%TYPE;
 l_cfg_key_value mgmt_policy_assoc_cfg.key_value%TYPE;
 l_cfg_key_operator mgmt_policy_assoc_cfg.key_operator%TYPE;

 BEGIN
  dbms_output.put_line('get_metric_details(): IN');

  -- Initialize out parameters:

  metric_latest_value_out := ' ';
  metric_warning_threshold_out := ' ';
  metric_critical_threshold_out := ' ';
  collection_timestamp_out := NULL;
   
  l_custom_raw_window := emd_loader.get_raw_retention_window;

  l_custom_hour_window := emd_loader.get_1hour_retention_window;

  l_custom_day_window := emd_loader.get_1day_retention_window;


  -- First, determine the target_guid from the table on which the security
  -- policy is defined, mgmt_targets. If no data is found, we exit immediately
  -- since there is no need to continue (but this should never happen):
  
  BEGIN
    SELECT target_guid, type_meta_ver, category_prop_1, category_prop_2,
           category_prop_3, category_prop_4, category_prop_5, timezone_region
      INTO l_target_guid, l_type_meta_ver, l_category_prop_1, l_category_prop_2,
           l_category_prop_3, l_category_prop_4, l_category_prop_5, l_timezone_region
      FROM mgmt_targets
     WHERE target_name = target_name_in
       AND target_type = target_type_in;

    EXCEPTION
      WHEN NO_DATA_FOUND
      THEN
        raise MGMT_GLOBAL.target_does_not_exist;
    
  END;

  -- Convert the custom Start Date and End Date into Date
  l_custom_start_time := TO_DATE(start_Date_in, 'MM-DD-YYYY HH24');
  l_custom_end_time   := TO_DATE(end_Date_in, 'MM-DD-YYYY HH24');

  
  -- Then, get metric guid and metric column type
  BEGIN 
    -- note: the "rownum = 1" is to ensure only one row is returned. This may
    -- not return the correct metric row if EMD allow empty and non-empty 
    -- values of category_prop_* columns to exist at the same time. The problem
    -- will also occur during migration.
    SELECT metric_guid, DECODE(metric_type, 0, 'NUMBER', 1, 'STRING', 'OTHER')
      INTO l_metric_guid, l_metric_column_type
      FROM mgmt_metrics
     WHERE target_type = target_type_in
       AND metric_name = metric_name_in
       AND metric_column = metric_column_in
       AND usage_type = MGMT_GLOBAL.G_USAGE_VIEW_COLLECT
       AND type_meta_ver = l_type_meta_ver
       AND (category_prop_1 = l_category_prop_1 OR category_prop_1 = ' ')
       AND (category_prop_2 = l_category_prop_2 OR category_prop_2 = ' ')
       AND (category_prop_3 = l_category_prop_3 OR category_prop_3 = ' ')
       AND (category_prop_4 = l_category_prop_4 OR category_prop_4 = ' ')
       AND (category_prop_5 = l_category_prop_5 OR category_prop_5 = ' ')
       AND rownum = 1;

    EXCEPTION
      WHEN NO_DATA_FOUND
        THEN raise MGMT_GLOBAL.no_such_metric_found;
  END; 

  -- labels, key column, key order, number of keys, and metric type information
  OPEN metric_info_out FOR
    -- note: This may not return the correct metric rows if EMD allow empty and
    -- non-empty values of category_prop_* columns to exist at the same time.
    -- The problem will also occur during migration.
    SELECT metric_label, metric_label_nlsid, column_label, column_label_nlsid,  
           metric_column, key_column, key_order, num_keys, metric_type, 
           DECODE(metric_type, 0, 'NUMBER', 1, 'STRING', 'OTHER') AS metric_type_str,
           statefull
      FROM mgmt_metrics
     WHERE target_type = target_type_in
       AND metric_name = metric_name_in
       AND (metric_column = metric_column_in OR key_order != 0 OR
            metric_type = MGMT_GLOBAL.G_METRIC_TYPE_TABLE)
       AND usage_type = MGMT_GLOBAL.G_USAGE_VIEW_COLLECT
       AND type_meta_ver = l_type_meta_ver
       AND (category_prop_1 = l_category_prop_1 OR category_prop_1 = ' ')
       AND (category_prop_2 = l_category_prop_2 OR category_prop_2 = ' ')
       AND (category_prop_3 = l_category_prop_3 OR category_prop_3 = ' ')
       AND (category_prop_4 = l_category_prop_4 OR category_prop_4 = ' ')
       AND (category_prop_5 = l_category_prop_5 OR category_prop_5 = ' ');

  -- for composite keys
  IF(key_value_in IS NOT NULL)
  THEN
    OPEN composite_key_info_out FOR
      SELECT *
        FROM mgmt_metrics_composite_keys
       WHERE target_guid = HEXTORAW(l_target_guid)
         AND composite_key = key_value_in;
  ELSE
    -- open a dummy cursor
    OPEN composite_key_info_out FOR
      SELECT * 
        FROM mgmt_metrics_composite_keys
       WHERE rownum < 1;
  END IF;

  -- check if the user has at least OPERATOR_TARGET privilege
  has_priv_out := mgmt_user.has_priv(
    mgmt_user.get_current_em_user(), mgmt_user.OPERATOR_TARGET, l_target_guid);

  -- Determine the value for the 'days' parameter depending on the page type; needed
  -- for the cursor returning severity data.

  IF (page_type_in = 'byDay')
  THEN
      l_days := 1;
  ELSIF (page_type_in = 'byWeek')
  THEN
      l_days := 7;
  ELSIF (page_type_in = 'byCustom')
  THEN
      l_days := 0;      
  ELSE
      l_days := 31;
  END IF;                   

  -- Value of l_period defines whether to show raw data, 1hour roll-up data or 1day roll-up data
  l_end_time := mgmt_global.SYSDATE_TZRGN(l_timezone_region) -l_days;
  l_period := (l_end_time -l_custom_start_time);
  
  -- get SYSDATE in dd-mon-yyyy hh24:mi:ss format
  BEGIN
    SELECT to_char(l_end_time,'dd-mon-yyyy hh24:mi:ss')
      INTO l_end_time_str 
      FROM dual;


    EXCEPTION
     WHEN NO_DATA_FOUND
        THEN
            l_end_time_str := NULL;      

  END;

  
  IF (EMDW_LOG.p_is_info_set)
  THEN
    EMDW_LOG.info('get l_timezone_region ' || l_timezone_region, MODULE_NAME);
    EMDW_LOG.info('get l_end_time ' || l_end_time_str, MODULE_NAME);
    EMDW_LOG.info('get start_Date_in ' || start_Date_in, MODULE_NAME);
    EMDW_LOG.info('get end_Date_in ' || end_Date_in, MODULE_NAME);    
    EMDW_LOG.info('get l_period ' || l_period *24, MODULE_NAME);
  END IF;
  
  -- get configuration details for key_value_in
  EM_POLICY.get_config_key_details(p_object_guid => l_target_guid,
                                   p_policy_guid => l_metric_guid,
                                   p_key_value => key_value_in,
                                   p_cfg_coll_name => l_cfg_coll_name,
                                   p_cfg_key_value => l_cfg_key_value,
                                   p_cfg_key_operator => l_cfg_key_operator);

  -- Metric is of type NUMBER

  IF (l_metric_column_type = 'NUMBER')
  THEN

      -- Take care of non-null key value first:  

      IF key_value_in IS NOT NULL   
      THEN
          -- Get metric's latest value information:

          IF (page_type_in = 'byCustom')
          THEN
              BEGIN 

                   SELECT ROUND(value, 2), collection_timestamp
                     INTO metric_latest_value_out, collection_timestamp_out
                     FROM mgmt_current_metrics
                    WHERE target_guid = HEXTORAW(l_target_guid)
                      AND metric_guid = HEXTORAW(l_metric_guid)
                      AND key_value = key_value_in
                      AND collection_timestamp >= l_custom_start_time;

                EXCEPTION
                 WHEN NO_DATA_FOUND
                    THEN
                        metric_latest_value_out := NULL;
                        collection_timestamp_out := NULL;

              END;
          
          ELSE
              BEGIN 

                   SELECT ROUND(value, 2), collection_timestamp
                     INTO metric_latest_value_out, collection_timestamp_out
                     FROM mgmt_current_metrics
                    WHERE target_guid = HEXTORAW(l_target_guid)
                      AND metric_guid = HEXTORAW(l_metric_guid)
                      AND key_value = key_value_in
                      AND collection_timestamp >= l_end_time;

                EXCEPTION
                 WHEN NO_DATA_FOUND
                    THEN
                        metric_latest_value_out := NULL;
                        collection_timestamp_out := NULL;

              END;

          END IF;
        
          -- Get metric's threshold and occurences data:

          BEGIN 
           
               SELECT warning_threshold, critical_threshold, num_occurences
                 INTO metric_warning_threshold_out, 
                      metric_critical_threshold_out, num_occurences_out
                 FROM mgmt_metric_thresholds 
                WHERE target_guid = HEXTORAW(l_target_guid)
                  AND metric_guid = HEXTORAW(l_metric_guid)
                  AND coll_name = l_cfg_coll_name
                  AND key_value = l_cfg_key_value
                  AND key_operator = l_cfg_key_operator;

            EXCEPTION
             WHEN NO_DATA_FOUND
                THEN

                    BEGIN

                           SELECT warning_threshold, critical_threshold, 
                                  num_occurences
                             INTO metric_warning_threshold_out, 
                                  metric_critical_threshold_out, 
                                  num_occurences_out
                             FROM mgmt_metric_thresholds 
                            WHERE target_guid = HEXTORAW(l_target_guid)
                              AND metric_guid = HEXTORAW(l_metric_guid)
                              AND key_value = ' ';

                        EXCEPTION
                         WHEN NO_DATA_FOUND
                            THEN

                                metric_warning_threshold_out := NULL;
                                metric_critical_threshold_out := NULL;
                                num_occurences_out := NULL;

                    END;

          END;

          IF (page_type_in = 'byDay')
          THEN

              -- Get metric's statistics data (average, maximum and minimum 
              -- values) for 24-hour page using raw data from mgmt_metrics_raw:

              OPEN number_metric_info_out FOR
                        SELECT ROUND(AVG(value), 2),
                               ROUND(MIN(value), 2),  
                               ROUND(MAX(value), 2)
                          FROM mgmt_metrics_raw
                         WHERE target_guid = HEXTORAW(l_target_guid)  
                           AND metric_guid = HEXTORAW(l_metric_guid)
                           AND key_value = key_value_in
                           AND collection_timestamp >= l_end_time;
                     

          ELSIF (page_type_in = 'byWeek')
          THEN

              -- Get metric's statistics data (average, maximum and minimum 
              -- values) for 7-day page using rollups from mgmt_metrics_1hour:

              OPEN number_metric_info_out FOR
                        SELECT ROUND(AVG(value_average), 2),
                               ROUND(MIN(value_minimum), 2),  
                               ROUND(MAX(value_maximum), 2)
                          FROM mgmt_metrics_1hour
                         WHERE target_guid = HEXTORAW(l_target_guid)  
                           AND metric_guid = HEXTORAW(l_metric_guid)
                           AND key_value = key_value_in
                           AND rollup_timestamp >= l_end_time ;

          ELSIF (page_type_in = 'byCustom')
          THEN

                IF (l_period <= l_custom_raw_window)  
                THEN

                  -- Get metric's statistics data (average, maximum and minimum 
                  -- values) for upto 1-day page using raw data from mgmt_metrics_raw:

                  OPEN number_metric_info_out FOR
                            SELECT ROUND(AVG(value), 2),
                                   ROUND(MIN(value), 2),  
                                   ROUND(MAX(value), 2)
                              FROM mgmt_metrics_raw 
                             WHERE target_guid = HEXTORAW(l_target_guid) 
                               AND metric_guid = HEXTORAW(l_metric_guid)
                               AND key_value = key_value_in
                               AND collection_timestamp >= l_custom_start_time
                               AND collection_timestamp <= l_custom_end_time;

                ELSIF ((l_period > l_custom_raw_window) AND (l_period <= l_custom_hour_window))
                THEN

                  -- Get metric's statistics data (average, maximum and minimum 
                  -- values) for upto 7-day page using rollups from mgmt_metrics_1hour:

                  OPEN number_metric_info_out FOR
                            SELECT ROUND(AVG(value_average), 2),
                                   ROUND(MIN(value_minimum), 2),  
                                   ROUND(MAX(value_maximum), 2)
                              FROM mgmt_metrics_1hour
                             WHERE target_guid = HEXTORAW(l_target_guid)  
                               AND metric_guid = HEXTORAW(l_metric_guid)
                               AND key_value = key_value_in
                               AND rollup_timestamp >= l_custom_start_time
                               AND rollup_timestamp <= l_custom_end_time;                   

                ELSIF (l_period > l_custom_hour_window)
                THEN

                  -- Get metric's statistics data (average, maximum and minimum 
                  -- values) for upto 31-day page using rollups from mgmt_metrics_1day:

                  OPEN number_metric_info_out FOR
                            SELECT ROUND(AVG(value_average), 2),
                                   ROUND(MIN(value_minimum), 2),  
                                   ROUND(MAX(value_maximum), 2)
                              FROM mgmt_metrics_1day
                             WHERE target_guid = HEXTORAW(l_target_guid)
                               AND metric_guid = HEXTORAW(l_metric_guid)
                               AND key_value = key_value_in
                               AND rollup_timestamp >= l_custom_start_time
                               AND rollup_timestamp <= l_custom_end_time;  

                END IF;

          ELSE 

              -- Get metric's statistics data (average, maximum and minimum 
              -- values) for 31-day page using rollups from mgmt_metrics_1day:

              OPEN number_metric_info_out FOR
                        SELECT ROUND(AVG(value_average), 2),
                               ROUND(MIN(value_minimum), 2),  
                               ROUND(MAX(value_maximum), 2)
                          FROM mgmt_metrics_1day
                         WHERE target_guid = HEXTORAW(l_target_guid)
                           AND metric_guid = HEXTORAW(l_metric_guid)
                           AND key_value = key_value_in
                           AND rollup_timestamp >= l_end_time ;

            END IF;

      -- Start of null key value case:

      ELSE  

          -- Get metric's latest value information:

          IF (page_type_in = 'byCustom')
          THEN
              BEGIN  

                   SELECT ROUND(value, 2), collection_timestamp
                     INTO metric_latest_value_out, collection_timestamp_out
                     FROM mgmt_current_metrics
                    WHERE target_guid = HEXTORAW(l_target_guid)
                      AND metric_guid = HEXTORAW(l_metric_guid)
                      AND collection_timestamp >= l_custom_start_time;

                EXCEPTION
                 WHEN NO_DATA_FOUND
                    THEN
                        metric_latest_value_out := NULL;
                        collection_timestamp_out := NULL;

              END;
          ELSE
        
              BEGIN  

                   SELECT ROUND(value, 2), collection_timestamp
                     INTO metric_latest_value_out, collection_timestamp_out
                     FROM mgmt_current_metrics
                    WHERE target_guid = HEXTORAW(l_target_guid)
                      AND metric_guid = HEXTORAW(l_metric_guid)
                      AND collection_timestamp >= l_end_time ;

                EXCEPTION
                 WHEN NO_DATA_FOUND
                    THEN
                        metric_latest_value_out := NULL;
                        collection_timestamp_out := NULL;

              END;

          END IF;
        
          -- Get metric's threshold and occurences data:

          BEGIN  

               SELECT warning_threshold, critical_threshold, num_occurences
                 INTO metric_warning_threshold_out, 
                      metric_critical_threshold_out, num_occurences_out
                 FROM mgmt_metric_thresholds
                WHERE target_guid = HEXTORAW(l_target_guid) 
                  AND metric_guid = HEXTORAW(l_metric_guid)
                  AND key_value = ' ';

            EXCEPTION
             WHEN NO_DATA_FOUND
                THEN

                    metric_warning_threshold_out := NULL;
                    metric_critical_threshold_out := NULL;
                    num_occurences_out := NULL;

          END;

          IF (page_type_in = 'byDay')
          THEN

              -- Get metric's statistics data (average, maximum and minimum 
              -- values) for 24-hour page using raw data from mgmt_metrics_raw:

              OPEN number_metric_info_out FOR
                        SELECT ROUND(AVG(value), 2),
                               ROUND(MIN(value), 2),  
                               ROUND(MAX(value), 2)
                          FROM mgmt_metrics_raw 
                         WHERE target_guid = HEXTORAW(l_target_guid) 
                           AND metric_guid = HEXTORAW(l_metric_guid)
                           AND collection_timestamp >= l_end_time ; 

          ELSIF (page_type_in = 'byWeek')
          THEN  

              -- Get metric's statistics data (average, maximum and minimum 
              -- values) for 7-day page using rollups from mgmt_metrics_1hour:

              OPEN number_metric_info_out FOR
                        SELECT ROUND(AVG(value_average), 2),
                               ROUND(MIN(value_minimum), 2),  
                               ROUND(MAX(value_maximum), 2)
                          FROM mgmt_metrics_1hour
                         WHERE target_guid = HEXTORAW(l_target_guid)  
                           AND metric_guid = HEXTORAW(l_metric_guid)
                           AND rollup_timestamp >= l_end_time ; 

          ELSIF (page_type_in = 'byCustom')
          THEN  

                IF (l_period <= l_custom_raw_window)  
                THEN

                  -- Get metric's statistics data (average, maximum and minimum 
                  -- values) for upto 1-day page using raw data from mgmt_metrics_raw:

                  OPEN number_metric_info_out FOR
                            SELECT ROUND(AVG(value), 2),
                                   ROUND(MIN(value), 2),  
                                   ROUND(MAX(value), 2)
                              FROM mgmt_metrics_raw 
                             WHERE target_guid = HEXTORAW(l_target_guid) 
                               AND metric_guid = HEXTORAW(l_metric_guid)
                               AND collection_timestamp >= l_custom_start_time
                               AND collection_timestamp <= l_custom_end_time;

                ELSIF ((l_period > l_custom_raw_window) AND (l_period <= l_custom_hour_window))
                THEN

                  -- Get metric's statistics data (average, maximum and minimum 
                  -- values) for upto 7-day page using rollups from mgmt_metrics_1hour:

                  OPEN number_metric_info_out FOR
                            SELECT ROUND(AVG(value_average), 2),
                                   ROUND(MIN(value_minimum), 2),  
                                   ROUND(MAX(value_maximum), 2)
                              FROM mgmt_metrics_1hour
                             WHERE target_guid = HEXTORAW(l_target_guid)  
                               AND metric_guid = HEXTORAW(l_metric_guid)
                               AND rollup_timestamp >= l_custom_start_time
                               AND rollup_timestamp <= l_custom_end_time;                   

                ELSIF (l_period > l_custom_hour_window)
                THEN

                  -- Get metric's statistics data (average, maximum and minimum 
                  -- values) for upto 31-day page using rollups from mgmt_metrics_1day:

                  OPEN number_metric_info_out FOR
                            SELECT ROUND(AVG(value_average), 2),
                                   ROUND(MIN(value_minimum), 2),  
                                   ROUND(MAX(value_maximum), 2)
                              FROM mgmt_metrics_1day
                             WHERE target_guid = HEXTORAW(l_target_guid)
                               AND metric_guid = HEXTORAW(l_metric_guid)
                               AND rollup_timestamp >= l_custom_start_time
                               AND rollup_timestamp <= l_custom_end_time;  

                END IF;


          ELSE  

              -- Get metric's statistics data (average, maximum and minimum 
              -- values) for 31-day page using rollups from mgmt_metrics_1day:

              OPEN number_metric_info_out FOR
                        SELECT ROUND(AVG(value_average), 2),
                               ROUND(MIN(value_minimum), 2),  
                               ROUND(MAX(value_maximum), 2)
                          FROM mgmt_metrics_1day
                         WHERE target_guid = HEXTORAW(l_target_guid)
                           AND metric_guid = HEXTORAW(l_metric_guid)
                           AND rollup_timestamp >= l_end_time ; 

          END IF;

      END IF;    
      
  -- Metric is of type STRING           
      
  ELSIF (l_metric_column_type = 'STRING')
  THEN

      -- Take care of non-null key value first:  

      IF (key_value_in IS NOT NULL)  
      THEN
            IF (page_type_in = 'byCustom')
            THEN
                 
                  OPEN string_metric_info_out FOR
                    SELECT DISTINCT *
                      FROM (
                            SELECT string_value,
                                   collection_timestamp
                              FROM mgmt_string_metric_history
                             WHERE collection_timestamp >= l_custom_start_time
                               AND collection_timestamp <= l_custom_end_time
                               AND target_guid = HEXTORAW(l_target_guid)  
                               AND metric_guid = HEXTORAW(l_metric_guid)
                               AND key_value = key_value_in
                            UNION
                            SELECT string_value,
                                   collection_timestamp
                              FROM mgmt_current_metrics
                             WHERE target_guid = HEXTORAW(l_target_guid)  
                               AND metric_guid = HEXTORAW(l_metric_guid)
                               AND key_value = key_value_in
                            );
            ELSE

                  OPEN string_metric_info_out FOR
                    SELECT DISTINCT *
                      FROM (
                            SELECT string_value,
                                   collection_timestamp
                              FROM mgmt_string_metric_history
                             WHERE collection_timestamp >= l_end_time 
                               AND target_guid = HEXTORAW(l_target_guid)  
                               AND metric_guid = HEXTORAW(l_metric_guid)
                               AND key_value = key_value_in
                            UNION
                            SELECT string_value,
                                   collection_timestamp
                              FROM mgmt_current_metrics
                             WHERE target_guid = HEXTORAW(l_target_guid)  
                               AND metric_guid = HEXTORAW(l_metric_guid)
                               AND key_value = key_value_in
                            );
            
            END IF;        

      -- no key value:  

      ELSE
            IF (page_type_in = 'byCustom')
            THEN

                  OPEN string_metric_info_out FOR
                    SELECT DISTINCT *
                      FROM (
                            SELECT string_value,
                                   collection_timestamp
                              FROM mgmt_string_metric_history
                             WHERE collection_timestamp >= l_custom_start_time
                               AND collection_timestamp <= l_custom_end_time
                               AND target_guid = HEXTORAW(l_target_guid)  
                               AND metric_guid = HEXTORAW(l_metric_guid)
                            UNION
                            SELECT string_value,
                                   collection_timestamp
                              FROM mgmt_current_metrics
                             WHERE target_guid = HEXTORAW(l_target_guid)  
                               AND metric_guid = HEXTORAW(l_metric_guid)
                            );
                            
            ELSE
            
                  OPEN string_metric_info_out FOR
                    SELECT DISTINCT *
                      FROM (
                            SELECT string_value,
                                   collection_timestamp
                              FROM mgmt_string_metric_history
                             WHERE collection_timestamp >= l_end_time 
                               AND target_guid = HEXTORAW(l_target_guid)  
                               AND metric_guid = HEXTORAW(l_metric_guid)
                            UNION
                            SELECT string_value,
                                   collection_timestamp
                              FROM mgmt_current_metrics
                             WHERE target_guid = HEXTORAW(l_target_guid)  
                               AND metric_guid = HEXTORAW(l_metric_guid)
                            );
            
            END IF;
      END IF;  

  END IF; 
              
  -- Get metric's severity data
  IF(key_value_in IS NOT NULL)  
  THEN
    -- find the extra point timestamp
    IF (page_type_in = 'byCustom')
    THEN    
        l_start_time := l_custom_start_time;
    ELSE
        l_start_time := mgmt_global.SYSDATE_TZRGN(l_timezone_region) - l_days;
    END IF;
        
    BEGIN
    /*
      SELECT MAX(collection_timestamp) INTO l_first_point_timestamp
        FROM mgmt_severity
       WHERE target_guid = HEXTORAW(l_target_guid)
         AND metric_guid = HEXTORAW(l_metric_guid)
         AND key_value = key_value_in
         AND collection_timestamp < l_start_time
         AND severity_code != MGMT_GLOBAL.G_SEVERITY_COMMENT;
      */
      SELECT collection_timestamp 
      INTO l_first_point_timestamp
      FROM
      (
        SELECT collection_timestamp
        FROM mgmt_violations
       WHERE target_guid = HEXTORAW(l_target_guid)
         AND policy_guid = HEXTORAW(l_metric_guid)
         AND key_value = key_value_in
         AND collection_timestamp < l_start_time
         AND violation_level != MGMT_GLOBAL.G_SEVERITY_COMMENT
         AND violation_type IN (0,1,2)
         ORDER BY collection_timestamp DESC
       ) WHERE rownum < 2;

      IF(l_first_point_timestamp IS NULL)
      THEN
        l_first_point_timestamp := l_start_time;
      END IF;

      EXCEPTION
        WHEN NO_DATA_FOUND
        THEN
          l_first_point_timestamp := l_start_time;
    END;

    OPEN metric_sev_out FOR
      SELECT sev.severity_guid, sev.severity_code, sev.collection_timestamp,
             '<SYSTEM>' AS user_name, sev.message, sev.message_nlsid, sev.message_params,
             ( (SELECT COUNT(*)
                  FROM mgmt_severity_annotation
                 WHERE severity_guid = sev.severity_guid) + 
               (SELECT COUNT(*)
                  FROM mgmt_notification_log
                 WHERE source_obj_type = MGMT_GLOBAL.G_ANNOTATION_SOURCE_SEVERITY
                   AND source_obj_guid = sev.severity_guid) ) AS annotation_count,
               (SELECT message 
                  FROM mgmt_severity_annotation 
                 WHERE severity_guid = sev.severity_guid
                   AND rownum < 2
                   AND collection_timestamp = (SELECT max(collection_timestamp)
                                                 FROM mgmt_severity_annotation 
                                                WHERE severity_guid = sev.severity_guid)) AS last_comment
        FROM mgmt_severity sev
       WHERE sev.target_guid = HEXTORAW(l_target_guid)
         AND sev.metric_guid = HEXTORAW(l_metric_guid)
         AND sev.key_value = key_value_in
         AND sev.collection_timestamp >= l_first_point_timestamp
         AND sev.severity_code != MGMT_GLOBAL.G_SEVERITY_COMMENT
       ORDER BY sev.collection_timestamp desc;
  ELSE
    -- find the extra point timestamp
    IF (page_type_in = 'byCustom')
    THEN    
        l_start_time := l_custom_start_time;
    ELSE
        l_start_time := mgmt_global.SYSDATE_TZRGN(l_timezone_region) - l_days;
    END IF;
    
    
    BEGIN
    /*
      SELECT MAX(collection_timestamp) INTO l_first_point_timestamp
        FROM mgmt_severity
       WHERE target_guid = HEXTORAW(l_target_guid)
         AND metric_guid = HEXTORAW(l_metric_guid)
         AND collection_timestamp < l_start_time
         AND severity_code != MGMT_GLOBAL.G_SEVERITY_COMMENT;
    */
      SELECT collection_timestamp
      INTO   l_first_point_timestamp
      FROM
      (
        SELECT collection_timestamp
        FROM mgmt_violations
       WHERE target_guid = HEXTORAW(l_target_guid)
         AND policy_guid = HEXTORAW(l_metric_guid)
         AND collection_timestamp < l_start_time
         AND violation_level != MGMT_GLOBAL.G_SEVERITY_COMMENT
         AND violation_type IN (0,1,2)
         ORDER BY collection_timestamp DESC
      ) WHERE ROWNUM < 2;

      IF(l_first_point_timestamp IS NULL)
      THEN
        l_first_point_timestamp := l_start_time;
      END IF;

      EXCEPTION
        WHEN NO_DATA_FOUND
        THEN
          l_first_point_timestamp := l_start_time;
    END;

    OPEN metric_sev_out FOR
      SELECT sev.severity_guid, sev.severity_code, sev.collection_timestamp,
             '<SYSTEM>' AS user_name, sev.message, sev.message_nlsid, sev.message_params,
             ( (SELECT COUNT(*)
                  FROM mgmt_severity_annotation
                 WHERE severity_guid = sev.severity_guid) + 
               (SELECT COUNT(*)
                  FROM mgmt_notification_log
                 WHERE source_obj_type = MGMT_GLOBAL.G_ANNOTATION_SOURCE_SEVERITY
                   AND source_obj_guid = sev.severity_guid) ) AS annotation_count,
               (SELECT message 
                  FROM mgmt_severity_annotation 
                 WHERE severity_guid = sev.severity_guid
                   AND rownum < 2
                   AND collection_timestamp = (SELECT max(collection_timestamp)
                                                 FROM mgmt_severity_annotation 
                                                WHERE severity_guid = sev.severity_guid)) AS last_comment
        FROM mgmt_severity sev
       WHERE sev.target_guid = HEXTORAW(l_target_guid)
         AND sev.metric_guid = HEXTORAW(l_metric_guid)
         AND sev.collection_timestamp >= l_first_point_timestamp
         AND sev.severity_code != MGMT_GLOBAL.G_SEVERITY_COMMENT
       ORDER BY sev.collection_timestamp desc;
  END IF;

  -- current severity
  IF(key_value_in IS NOT NULL)  
  THEN
    OPEN current_metric_sev_out FOR
      SELECT *
        FROM mgmt_current_severity
       WHERE target_guid = HEXTORAW(l_target_guid)
         AND metric_guid = HEXTORAW(l_metric_guid)
         AND key_value = key_value_in;
  ELSE
    OPEN current_metric_sev_out FOR
      SELECT *
        FROM mgmt_current_severity
       WHERE target_guid = HEXTORAW(l_target_guid)
         AND metric_guid = HEXTORAW(l_metric_guid);
  END IF;
 -- Get associated corrective action 
      get_metric_associated_ca(
                               target_name_in ,
                               target_type_in ,
                               metric_name_in ,
                               metric_column_in ,
                               key_value_in ,
                               ca_severity_out );
 -- Get target load and lastload timestamp with timezone
        get_target_info(
                          target_name_in ,
                          target_type_in ,
                          target_info_out);          

 END get_metric_details;

-- PROCEDURE: get_target_info
--
-- PURPOSE :
--     Get the metadata associated with the target
--   IN Parameters:
--     target_name_in : target name of the target
--     target_type_in : target type of the target
--
--   OUT Parameters:
--       target_info_out : Gets complete target details from mgmt_targets

PROCEDURE get_target_info(target_name_in    IN  VARCHAR2,
                          target_type_in    IN  VARCHAR2,
                          target_info_out   OUT cursorType) IS

BEGIN

 -- Get target info
  OPEN target_info_out FOR
    SELECT *
      FROM mgmt_targets
     WHERE target_name = target_name_in
       AND target_type = target_type_in;

END get_target_info;

-- PROCEDURE: get_target_timestamp_info
--
-- PURPOSE :
--     Get the load timestamps associated with the target
--   IN Parameters:
--     target_name_in : target name of the target
--     target_type_in : target type of the target
--     metric_name_in : metric name
--     metric_column_in : metric column
--     key_value_in     :key value
--
--   OUT Parameters:
--     load_timestamp_out        target load timestamp
--     last_load_time_out        target lastload timestamp
--     timezone_region_out       target timezone
--     collection_timestamp_out  target last metric data upload time by agent too repository

PROCEDURE get_target_timestamp_info(target_name_in            IN  VARCHAR2,
                                    target_type_in            IN  VARCHAR2,
                                    metric_name_in            IN  VARCHAR2,
                                    metric_column_in          IN  VARCHAR2,
                                    key_value_in              IN  VARCHAR2,                                    
                                    load_timestamp_out        OUT DATE,
                                    last_load_time_out        OUT DATE,
                                    timezone_region_out       OUT VARCHAR2,
                                    collection_timestamp_out  OUT DATE) 
IS

 l_target_guid RAW(16);
 l_metric_guid RAW(16);
 l_metric_column_type VARCHAR2(16);
 l_type_meta_ver mgmt_targets.type_meta_ver%TYPE;
 l_category_prop_1 mgmt_targets.category_prop_1%TYPE;
 l_category_prop_2 mgmt_targets.category_prop_2%TYPE;
 l_category_prop_3 mgmt_targets.category_prop_3%TYPE;
 l_category_prop_4 mgmt_targets.category_prop_4%TYPE;
 l_category_prop_5 mgmt_targets.category_prop_5%TYPE;


BEGIN

-- To get metric upload timestamp for a targetw e need only the max upload timestamp,
-- hence we are reading only for mgmt_current_metrics for STRING metrics as well

  BEGIN
    SELECT target_guid, type_meta_ver, load_timestamp, last_load_time, timezone_region,
           category_prop_1, category_prop_2, category_prop_3, category_prop_4, category_prop_5
      INTO l_target_guid, l_type_meta_ver, load_timestamp_out, last_load_time_out, timezone_region_out,
           l_category_prop_1, l_category_prop_2, l_category_prop_3, l_category_prop_4, l_category_prop_5
      FROM mgmt_targets
     WHERE target_name = target_name_in
       AND target_type = target_type_in;

    EXCEPTION
      WHEN NO_DATA_FOUND
      THEN
        raise MGMT_GLOBAL.target_does_not_exist;
    
  END;

  -- Then, get metric guid and metric column type
  BEGIN 
    -- note: the "rownum = 1" is to ensure only one row is returned. This may
    -- not return the correct metric row if EMD allow empty and non-empty 
    -- values of category_prop_* columns to exist at the same time. The problem
    -- will also occur during migration.
    SELECT metric_guid, DECODE(metric_type, 0, 'NUMBER', 1, 'STRING', 'OTHER')
      INTO l_metric_guid, l_metric_column_type
      FROM mgmt_metrics
     WHERE target_type = target_type_in
       AND metric_name = metric_name_in
       AND metric_column = metric_column_in
       AND usage_type = MGMT_GLOBAL.G_USAGE_VIEW_COLLECT
       AND type_meta_ver = l_type_meta_ver
       AND (category_prop_1 = l_category_prop_1 OR category_prop_1 = ' ')
       AND (category_prop_2 = l_category_prop_2 OR category_prop_2 = ' ')
       AND (category_prop_3 = l_category_prop_3 OR category_prop_3 = ' ')
       AND (category_prop_4 = l_category_prop_4 OR category_prop_4 = ' ')
       AND (category_prop_5 = l_category_prop_5 OR category_prop_5 = ' ')
       AND rownum = 1;

    EXCEPTION
      WHEN NO_DATA_FOUND
        THEN raise MGMT_GLOBAL.no_such_metric_found;
  END; 


    IF key_value_in IS NOT NULL   
    THEN

        BEGIN 

               SELECT collection_timestamp
                 INTO collection_timestamp_out
                 FROM mgmt_current_metrics                          
                WHERE target_guid = HEXTORAW(l_target_guid)
                  AND metric_guid = HEXTORAW(l_metric_guid)
                  AND key_value = key_value_in;

            EXCEPTION
             WHEN NO_DATA_FOUND
                THEN
                    collection_timestamp_out := NULL;

        END;

    ELSE

        BEGIN 

               SELECT collection_timestamp
                 INTO collection_timestamp_out
                 FROM mgmt_current_metrics
                WHERE target_guid = HEXTORAW(l_target_guid)
                  AND metric_guid = HEXTORAW(l_metric_guid);

            EXCEPTION
             WHEN NO_DATA_FOUND
                THEN
                    collection_timestamp_out := NULL;

        END;

    END IF;         

END get_target_timestamp_info;

-- PROCEDURE: get_addtnl_folder_details 
--
-- PURPOSE :
--     Get the unconfigurred targets and broken CA counts
--   IN Parameters:
--     target_type_in : target type of the target
--     folder_tgt_type_list_in : target types in a folder
--
--   OUT Parameters:
--     unconfig_targets_cur_out : cursor with unconfigurred targets count
--     broken_ca_cur_out : cursor with Broken Corrective Action count



PROCEDURE get_addtnl_folder_details (
               target_type_in           IN  VARCHAR2,
               folder_tgt_type_list_in  IN  SMP_EMD_STRING_ARRAY DEFAULT NULL,
               unconfig_targets_cur_out OUT cursorType,
               broken_ca_cur_out        OUT cursorType) IS

BEGIN

   IF(target_type_in IS NULL) THEN
     BEGIN
      --  get the unconfigurred targets
     OPEN unconfig_targets_cur_out  FOR
       SELECT count(*) AS num_unconfig_targets
       FROM mgmt_targets
       WHERE broken_reason > 0
        AND broken_reason != 256;

     OPEN broken_ca_cur_out FOR
       SELECT count(unique(j.job_id)) AS num_broken_ca 
       FROM mgmt_job j, 
            mgmt_policy_assoc_cfg mpac, 
            mgmt_policies mp 
       WHERE j.broken = 1 
        AND j.is_corrective_action =1 
        AND (j.job_id = mpac.crit_action_job_id OR 
             j.job_id = mpac.warn_action_job_id OR 
             j.job_id = mpac.info_action_job_id) 
        AND mp.policy_guid = mpac.policy_guid ;
     END;
   ELSE
     BEGIN
       --get the unconfigurred targets
     OPEN unconfig_targets_cur_out  FOR
       SELECT count(*) AS num_unconfig_targets
       FROM mgmt_targets
       WHERE broken_reason > 0
        AND broken_reason != 256
        AND target_type IN ( SELECT  *
                             FROM TABLE(CAST(folder_tgt_type_list_in AS SMP_EMD_STRING_ARRAY)) );

     OPEN broken_ca_cur_out FOR
       SELECT count(unique(j.job_id)) AS num_broken_ca 
       FROM mgmt_job j, 
            mgmt_policy_assoc_cfg mpac, 
            mgmt_policies mp 
       WHERE j.broken = 1 
        AND j.is_corrective_action =1 
        AND (j.job_id = mpac.crit_action_job_id OR 
             j.job_id = mpac.warn_action_job_id OR 
             j.job_id = mpac.info_action_job_id) 
        AND mp.policy_guid = mpac.policy_guid
        AND j.target_type = target_type_in ;
     END;
  END IF;
END get_addtnl_folder_details;
                                
--
-- PURPOSE :
--     Get the Corrective Action associated with the metric
--   IN Parameters:
--     target_name_in : target name of the target
--     target_type_in : target type of the target
--     metric_name_in : name of the metric
--     metric_column_in : name of the metric column
--
--   OUT Parameters:
--       ca_severity_out : corrective action associted on which severity
--                         for eg: Warning
--
PROCEDURE get_metric_associated_ca(
                                target_name_in                 IN  VARCHAR2,
                                target_type_in                 IN  VARCHAR2,
                                metric_name_in                 IN  VARCHAR2,
                                metric_column_in               IN  VARCHAR2,
                                key_value_in                   IN  VARCHAR2,
                                ca_severity_out                OUT NUMBER  ) IS 


 l_crit_action_job_id mgmt_policy_assoc_cfg.crit_action_job_id%TYPE := NULL ;
 l_warn_action_job_id mgmt_policy_assoc_cfg.warn_action_job_id%TYPE := NULL ;
 l_fixit_job mgmt_policy_assoc_cfg.fixit_job%TYPE;     
 l_cfg_coll_name      mgmt_policy_assoc_cfg.coll_name%TYPE;
 l_cfg_key_value      mgmt_policy_assoc_cfg.key_value%TYPE;
 l_cfg_key_operator   mgmt_policy_assoc_cfg.key_operator%TYPE;

 l_target_guid mgmt_targets.target_guid%TYPE;
 l_type_meta_ver mgmt_targets.type_meta_ver%TYPE;
 l_category_prop_1 mgmt_targets.category_prop_1%TYPE;
 l_category_prop_2 mgmt_targets.category_prop_2%TYPE;
 l_category_prop_3 mgmt_targets.category_prop_3%TYPE;
 l_category_prop_4 mgmt_targets.category_prop_4%TYPE;
 l_category_prop_5 mgmt_targets.category_prop_5%TYPE;

 l_metric_guid mgmt_metrics.metric_guid%TYPE;
BEGIN

 -- get the target guid and category property columns
  BEGIN
    SELECT target_guid, type_meta_ver, category_prop_1, category_prop_2,
           category_prop_3, category_prop_4, category_prop_5
      INTO l_target_guid, l_type_meta_ver, l_category_prop_1, l_category_prop_2,
           l_category_prop_3, l_category_prop_4, l_category_prop_5
      FROM mgmt_targets
     WHERE target_name = target_name_in
       AND target_type = target_type_in;

    EXCEPTION
      WHEN NO_DATA_FOUND
      THEN
        raise MGMT_GLOBAL.target_does_not_exist;
  END;

  -- get the metric_guid for this column
  BEGIN 
    SELECT DISTINCT metric_guid INTO l_metric_guid
      FROM mgmt_metrics
     WHERE target_type = target_type_in
       AND metric_name = metric_name_in
       AND metric_column = metric_column_in;

    EXCEPTION
      WHEN NO_DATA_FOUND
        THEN raise MGMT_GLOBAL.no_such_metric_found;
  END;

  -- get coll_name , key_value , key_operator for the metric 

    EM_POLICY.get_config_key_details(
                            p_object_guid =>l_target_guid,
                            p_policy_guid => l_metric_guid,
                            p_key_value   => key_value_in ,
                            p_cfg_coll_name => l_cfg_coll_name ,
                            p_cfg_key_value => l_cfg_key_value ,
                            p_cfg_key_operator => l_cfg_key_operator );

  -- Now, check for corrective actions or response actions
 BEGIN
   SELECT crit_action_job_id , warn_action_job_id,
          TRIM(fixit_job)
   INTO l_crit_action_job_id , l_warn_action_job_id, l_fixit_job
   FROM mgmt_policy_assoc_cfg 
   WHERE object_guid   = l_target_guid
   AND   policy_guid   = l_metric_guid
   AND   coll_name     = l_cfg_coll_name
   AND   key_value     = l_cfg_key_value
   AND   key_operator  = l_cfg_key_operator;

  EXCEPTION
  WHEN NO_DATA_FOUND
  THEN NULL ; -- ca_severity_out  :='Not Set';
 END;

  IF(l_fixit_job IS NOT NULL) THEN
   ca_severity_out := 3;
   return ;
  END IF;

  IF( l_crit_action_job_id  is NOT NULL AND
      l_warn_action_job_id  is NOT NULL)
   THEN
        ca_severity_out :=3;
  ELSIF( l_crit_action_job_id  is NOT NULL)
   THEN
        ca_severity_out :=1;
  ELSIF(l_warn_action_job_id  is NOT NULL)
   THEN
        ca_severity_out :=2;
  ELSE
        ca_severity_out  :=4;
  END IF;

END get_metric_associated_ca;

-- PURPOSE:
--     Get the charts for the metric detail page.
--   IN Parameters:
--     target_name_in : target name of the target
--     target_type_in : target type of the target
--     metric_name_in : name of the metric
--     metric_column_in : name of the metric column
--     key_value_in   : specific key value we are looking at
--     page_type_in : time period of the chart
--     cmp_targets_in : list of targets to compare against
--     cmp_key_values_in : list of key values to compare against
--     start_Date_in  :start date time for custom view
--     end_Date_in    :end date time for custom view
--     multi_key_value_in : Whether or not we should look for
--                          multiple key --values--.
--
--   OUT Parameters:
--     Cursor with the chart data 
PROCEDURE get_metric_details_ts_mk(
                             target_name_in                 IN  VARCHAR2,
                             target_type_in                 IN  VARCHAR2,
                             metric_name_in                 IN  VARCHAR2,
                             metric_column_in               IN  VARCHAR2,
                             key_value_in                   IN  VARCHAR2,
                             page_type_in                   IN  VARCHAR2,
                             cmp_targets_in                 IN  SMP_EMD_STRING_ARRAY,
                             cmp_key_values_in              IN  SMP_EMD_STRING_ARRAY,
                             timeseries_out                 OUT cursorType,
                             start_Date_in                  IN  VARCHAR2 DEFAULT NULL,
                             end_Date_in                    IN  VARCHAR2 DEFAULT NULL,
                             multi_key_value_in             IN NUMBER DEFAULT 0)
IS

    l_target_guid mgmt_targets.target_guid%TYPE;

    l_timezone_region mgmt_targets.timezone_region%TYPE;
    l_temp_target_guid mgmt_targets.target_guid%TYPE;
    l_temp_target_name mgmt_targets.target_name%TYPE;
    l_temp_timezone_region mgmt_targets.timezone_region%TYPE;
    l_temp_start_timestamp DATE;
    l_temp_end_timestamp DATE;
    l_systimestamp TIMESTAMP WITH TIME ZONE;
    l_metric_guid mgmt_metrics.metric_guid%TYPE;

    l_key_values SMP_EMD_STRING_ARRAY := SMP_EMD_STRING_ARRAY();
    l_check_keys NUMBER := 0;
    l_real_keys NUMBER := 0;
    l_num_keys mgmt_metrics.num_keys%TYPE;
    l_total_targets MGMT_MD_COMPARE_ARRAY := MGMT_MD_COMPARE_ARRAY();
    l_is_diff_timezone_flag BOOLEAN := FALSE;
    l_tgt_list        cursorType;
    l_cnt      NUMBER := 0;
    l_tgt_counter INTEGER := 1;
    l_custom_start_time DATE;
    l_custom_end_time DATE;
    l_period NUMBER;
    l_end_time DATE;
    l_custom_raw_window  NUMBER := null;
    l_custom_hour_window NUMBER := null;
    l_custom_day_window  NUMBER := null;    
    l_temp_key_value VARCHAR2(256) := '';

    
BEGIN

  l_custom_raw_window := emd_loader.get_raw_retention_window;

  l_custom_hour_window := emd_loader.get_1hour_retention_window;

  l_custom_day_window := emd_loader.get_1day_retention_window;  

  BEGIN
    SELECT target_guid , timezone_region
       INTO l_target_guid, l_timezone_region
      FROM mgmt_targets
     WHERE target_name = target_name_in
       AND target_type = target_type_in;

    EXCEPTION
      WHEN NO_DATA_FOUND
        THEN raise MGMT_GLOBAL.target_does_not_exist;
  END;

  BEGIN
    SELECT DISTINCT metric_guid, num_keys
      INTO l_metric_guid, l_num_keys
      FROM mgmt_metrics
     WHERE target_type = target_type_in
       AND metric_name = metric_name_in
       AND metric_column = metric_column_in
       AND usage_type = MGMT_GLOBAL.G_USAGE_VIEW_COLLECT;

    EXCEPTION
      WHEN NO_DATA_FOUND
        THEN raise MGMT_GLOBAL.no_such_metric_found;
  END;
  -- Convert the custom Start Date and End Date into Date
  l_custom_start_time := TO_DATE(start_Date_in, 'MM-DD-YYYY HH24');
  l_custom_end_time   := TO_DATE(end_Date_in, 'MM-DD-YYYY HH24');

  l_total_targets.extend;
  l_total_targets(1) := MGMT_MD_COMPARE_OBJ(l_target_guid, l_metric_guid,
                                            target_name_in, l_timezone_region,
                                            l_custom_start_time, l_custom_end_time);

  -- Value of l_period defines whether to show raw data, 1hour roll-up data or 1day roll-up data
  l_end_time := mgmt_global.SYSDATE_TZRGN(l_timezone_region);
  l_period := (l_end_time -l_custom_start_time);
                                 

  IF cmp_targets_in IS NOT NULL AND cmp_targets_in.COUNT > 0
  THEN
    OPEN l_tgt_list FOR
      SELECT target_guid, target_name, timezone_region
        FROM mgmt_targets
       WHERE target_type = target_type_in
         AND target_name IN
               (SELECT * FROM TABLE(CAST(cmp_targets_in AS SMP_EMD_STRING_ARRAY)));

    LOOP
      FETCH l_tgt_list INTO l_temp_target_guid, l_temp_target_name, l_temp_timezone_region;
        EXIT WHEN l_tgt_list%NOTFOUND;
      IF ( l_temp_timezone_region != l_timezone_region)
      THEN
        l_is_diff_timezone_flag := true;
      END IF;

      l_total_targets.extend;
      l_tgt_counter := l_tgt_counter + 1;
      
      l_systimestamp := SYSTIMESTAMP;
      IF page_type_in = 'byMonth'
      THEN
          l_temp_start_timestamp := CAST(l_systimestamp at time zone l_temp_timezone_region as DATE) - 31;   
          l_temp_end_timestamp := null;  -- not required as we just see greater than start date
      ELSIF page_type_in = 'byWeek'
      THEN
          l_temp_start_timestamp := CAST(l_systimestamp at time zone l_temp_timezone_region as DATE) - 7;   
          l_temp_end_timestamp := null;  -- not required as we just see greater than start date
      ELSIF page_type_in = 'byCustom'
      THEN 
          -- convert the custom time to each targets timezone
          l_temp_start_timestamp := mgmt_global.adjust_tz(l_custom_start_time, 
                                                          l_timezone_region, 
                                                          l_temp_timezone_region);
          l_temp_end_timestamp := mgmt_global.adjust_tz(l_custom_end_time, 
                                                        l_timezone_region, 
                                                        l_temp_timezone_region);        
      ELSE
          l_temp_start_timestamp := CAST(l_systimestamp at time zone l_temp_timezone_region as DATE) - 1;
          l_temp_end_timestamp := null;  -- not required as we just see greater than start date
      END IF;
                              
      l_total_targets(l_tgt_counter) := MGMT_MD_COMPARE_OBJ(l_temp_target_guid, l_metric_guid,
                                                            l_temp_target_name, l_temp_timezone_region,
                                                            l_temp_start_timestamp, l_temp_end_timestamp);

    END LOOP;
    CLOSE l_tgt_list;


  END IF;

  IF cmp_key_values_in IS NOT NULL AND cmp_key_values_in.COUNT > 0
  THEN
    FOR l_cnt in cmp_key_values_in.FIRST..cmp_key_values_in.LAST
    LOOP
      l_key_values.extend;
      l_key_values(l_cnt) := cmp_key_values_in(l_cnt);
    END LOOP;
  ELSIF key_value_in IS NOT NULL AND length(key_value_in) <> 0
  THEN
      l_key_values.extend;
      l_cnt := l_cnt+1;
      l_key_values(l_cnt) := key_value_in;
  ELSE
        --
        -- If no keys passed in we can safely alter the
        -- query based on the unique key values that are
        -- part of the metric.
        -- 
        -- If there are no unique key values as part of the metric
        -- then we revert back to the previous behavior and set
        -- the key value to a space (' ') and the num Keys to 1
        --
        --                                
        IF multi_key_value_in = 1
        THEN

          -- We get the list of possible metric key values
          SELECT /*+ CARDINALITY(tgt 10) */ metrics.key_value BULK COLLECT INTO l_key_values
          FROM MGMT_CURRENT_METRICS metrics,
               TABLE(CAST(l_total_targets AS MGMT_MD_COMPARE_ARRAY) ) tgt
          WHERE metrics.target_guid = tgt.target_guid
            AND metrics.metric_guid = l_metric_guid;

          l_num_keys := l_key_values.COUNT;
          l_cnt := l_num_keys;

        END IF;

        -- If there are no key values desired, set the key value to a space
        IF l_num_keys = 0
        THEN
           l_key_values.extend;
           l_key_values(1) := ' ';
           l_cnt := 1;
           l_num_keys := 1;
        END IF;

        IF multi_key_value_in = 1
        THEN
           IF l_num_keys > 1
           THEN
              FOR l_check_keys in 1..l_num_keys
              LOOP
                 IF trim(l_key_values(l_check_keys)) IS NOT NULL
                 THEN
                    l_real_keys := l_real_keys + 1;
                 END IF;
              END LOOP;
           END IF;

           IF l_real_keys > 1
           THEN
              -- If we are dealing with the multi-tgt case, and
              -- there are multi-keys, that's ok. Strip off rest of
              -- targets and use single tgt, multi-key.
              IF l_tgt_counter > 1
              THEN
                 l_tgt_counter := 1;
                 l_total_targets := MGMT_MD_COMPARE_ARRAY();
                 l_total_targets.extend;
                 l_total_targets(1) := MGMT_MD_COMPARE_OBJ(l_target_guid,
                                                           l_metric_guid,
                                                           target_name_in,
                                                           l_timezone_region,
                                                           l_custom_start_time, 
                                                           l_custom_end_time);
              END IF;
           END IF;
        END IF;
  END IF;

  -- case for multiple targets and multiple time zones, need to call mgmt_global.adjust_tz function
  -- for every records, three table joins(tgt, data, comp)

  IF l_total_targets.COUNT > 1 AND l_is_diff_timezone_flag = TRUE
  THEN

    -- with one key value (can only have one since we're comparing targets)
    IF key_value_in IS NOT NULL AND length(key_value_in) <> 0
    THEN
      IF page_type_in = 'byMonth'
      THEN
        OPEN timeseries_out FOR
          SELECT /*+ CARDINALITY(tgt 10) */
                 tgt.target_name, mgmt_global.adjust_tz(data.rollup_timestamp,
                   tgt.timezone_region, l_timezone_region) AS rollup_timestamp,
                 data.value_maximum, data.value_minimum,
                 data.value_average, data.key_value,
                 l_num_keys AS num_keys, comp.key_part1_value, comp.key_part2_value,
                 comp.key_part3_value, comp.key_part4_value, comp.key_part5_value
            FROM TABLE(CAST(l_total_targets AS MGMT_MD_COMPARE_ARRAY) ) tgt,
                 mgmt_metrics_1day data,
                 mgmt_metrics_composite_keys comp
           WHERE data.target_guid = tgt.target_guid
             AND data.metric_guid = l_metric_guid
             AND data.key_value = key_value_in
             AND data.rollup_timestamp >= tgt.start_time
             AND data.target_guid = comp.target_guid (+)
             AND data.key_value = comp.composite_key (+)
           ORDER BY rollup_timestamp;
      ELSIF page_type_in = 'byWeek'
      THEN
        OPEN timeseries_out FOR
          SELECT /*+ CARDINALITY(tgt 10) */
                 tgt.target_name, mgmt_global.adjust_tz(data.rollup_timestamp,
                   tgt.timezone_region, l_timezone_region) AS rollup_timestamp,
                 data.value_maximum, data.value_minimum,
                 data.value_average, data.key_value,
                 l_num_keys AS num_keys, comp.key_part1_value, comp.key_part2_value,
                 comp.key_part3_value, comp.key_part4_value, comp.key_part5_value
            FROM TABLE(CAST(l_total_targets AS MGMT_MD_COMPARE_ARRAY) ) tgt,
                 mgmt_metrics_1hour data,
                 mgmt_metrics_composite_keys comp
           WHERE data.target_guid = tgt.target_guid
             AND data.metric_guid = l_metric_guid
             AND data.key_value = key_value_in
             AND data.rollup_timestamp >= tgt.start_time
             AND data.target_guid = comp.target_guid (+)
             AND data.key_value = comp.composite_key (+)
           ORDER BY rollup_timestamp;
      ELSIF page_type_in = 'byCustom'
      THEN

            IF (l_period <= l_custom_raw_window)  
            THEN

                OPEN timeseries_out FOR
                  SELECT /*+ CARDINALITY(tgt 10) */
                         tgt.target_name, mgmt_global.adjust_tz(data.collection_timestamp,
                           tgt.timezone_region, l_timezone_region) AS custom_timestamp,
                         data.value AS custom_value, data.key_value,
                         l_num_keys AS num_keys, comp.key_part1_value, comp.key_part2_value,
                         comp.key_part3_value, comp.key_part4_value, comp.key_part5_value
                    FROM TABLE(CAST(l_total_targets AS MGMT_MD_COMPARE_ARRAY) ) tgt,
                         mgmt_metrics_raw data,
                         mgmt_metrics_composite_keys comp
                   WHERE data.target_guid = tgt.target_guid
                     AND data.metric_guid = l_metric_guid
                     AND data.key_value = key_value_in
                     AND data.collection_timestamp >= tgt.start_time
                     AND data.collection_timestamp <= tgt.end_time
                     AND data.target_guid = comp.target_guid (+)
                     AND data.key_value = comp.composite_key (+)
                   ORDER BY collection_timestamp;

            ELSIF ((l_period > l_custom_raw_window) AND (l_period <= l_custom_hour_window))
            THEN

                OPEN timeseries_out FOR
                  SELECT /*+ CARDINALITY(tgt 10) */
                         tgt.target_name, mgmt_global.adjust_tz(data.rollup_timestamp,
                           tgt.timezone_region, l_timezone_region) AS custom_timestamp,
                         data.value_maximum, data.value_minimum,
                         data.value_average AS custom_value, data.key_value,
                         l_num_keys AS num_keys, comp.key_part1_value, comp.key_part2_value,
                         comp.key_part3_value, comp.key_part4_value, comp.key_part5_value
                    FROM TABLE(CAST(l_total_targets AS MGMT_MD_COMPARE_ARRAY) ) tgt,
                         mgmt_metrics_1hour data,
                         mgmt_metrics_composite_keys comp
                   WHERE data.target_guid = tgt.target_guid
                     AND data.metric_guid = l_metric_guid
                     AND data.key_value = key_value_in                  
                     AND data.rollup_timestamp >= tgt.start_time
                     AND data.rollup_timestamp <= tgt.end_time
                     AND data.target_guid = comp.target_guid (+)
                     AND data.key_value = comp.composite_key (+)
                   ORDER BY rollup_timestamp;           

            ELSIF (l_period > l_custom_hour_window)
            THEN

                OPEN timeseries_out FOR
                  SELECT /*+ CARDINALITY(tgt 10) */
                         tgt.target_name, mgmt_global.adjust_tz(data.rollup_timestamp,
                           tgt.timezone_region, l_timezone_region) AS custom_timestamp,
                         data.value_maximum, data.value_minimum,
                         data.value_average AS custom_value, data.key_value,
                         l_num_keys AS num_keys, comp.key_part1_value, comp.key_part2_value,
                         comp.key_part3_value, comp.key_part4_value, comp.key_part5_value
                    FROM TABLE(CAST(l_total_targets AS MGMT_MD_COMPARE_ARRAY) ) tgt,
                         mgmt_metrics_1day data,
                         mgmt_metrics_composite_keys comp
                   WHERE data.target_guid = tgt.target_guid
                     AND data.metric_guid = l_metric_guid
                     AND data.key_value = key_value_in
                     AND data.rollup_timestamp >= tgt.start_time
                     AND data.rollup_timestamp <= tgt.end_time
                     AND data.target_guid = comp.target_guid (+)
                     AND data.key_value = comp.composite_key (+)
                   ORDER BY rollup_timestamp;

            END IF;


      ELSE
        OPEN timeseries_out FOR
          SELECT /*+ CARDINALITY(tgt 10) */
                 tgt.target_name, mgmt_global.adjust_tz(data.collection_timestamp,
                   tgt.timezone_region, l_timezone_region) AS collection_timestamp,
                 data.value, data.key_value,
                 l_num_keys AS num_keys, comp.key_part1_value, comp.key_part2_value,
                 comp.key_part3_value, comp.key_part4_value, comp.key_part5_value
            FROM TABLE(CAST(l_total_targets AS MGMT_MD_COMPARE_ARRAY) ) tgt,
                 mgmt_metrics_raw data,
                 mgmt_metrics_composite_keys comp
           WHERE data.target_guid = tgt.target_guid
             AND data.metric_guid = l_metric_guid
             AND data.key_value = key_value_in
             AND data.collection_timestamp >= tgt.start_time
             AND data.target_guid = comp.target_guid (+)
             AND data.key_value = comp.composite_key (+)
           ORDER BY collection_timestamp;
      END IF;
    -- without key value
    ELSE
      IF page_type_in = 'byMonth'
      THEN
        OPEN timeseries_out FOR
          SELECT /*+ CARDINALITY(tgt 10) */
                 tgt.target_name, mgmt_global.adjust_tz(data.rollup_timestamp,
                   tgt.timezone_region, l_timezone_region) AS rollup_timestamp,
                 data.value_maximum, data.value_minimum,
                 data.value_average, data.key_value,
                 l_num_keys AS num_keys, comp.key_part1_value, comp.key_part2_value,
                 comp.key_part3_value, comp.key_part4_value, comp.key_part5_value
            FROM TABLE(CAST(l_total_targets AS MGMT_MD_COMPARE_ARRAY) ) tgt,
                 mgmt_metrics_1day data,
                 mgmt_metrics_composite_keys comp
           WHERE data.target_guid = tgt.target_guid
             AND data.metric_guid = l_metric_guid
             AND data.key_value = ' '
             AND data.rollup_timestamp >= tgt.start_time
             AND data.target_guid = comp.target_guid (+)
             AND data.key_value = comp.composite_key (+)
           ORDER BY rollup_timestamp;
      ELSIF page_type_in = 'byWeek'
      THEN
        OPEN timeseries_out FOR
          SELECT /*+ CARDINALITY(tgt 10) */
                 tgt.target_name, mgmt_global.adjust_tz(data.rollup_timestamp,
                   tgt.timezone_region, l_timezone_region) AS rollup_timestamp,
                 data.value_maximum, data.value_minimum,
                 data.value_average, data.key_value,
                 l_num_keys AS num_keys, comp.key_part1_value, comp.key_part2_value,
                 comp.key_part3_value, comp.key_part4_value, comp.key_part5_value
            FROM TABLE(CAST(l_total_targets AS MGMT_MD_COMPARE_ARRAY) ) tgt,
                 mgmt_metrics_1hour data,
                 mgmt_metrics_composite_keys comp
           WHERE data.target_guid = tgt.target_guid
             AND data.metric_guid = l_metric_guid
             AND data.key_value = ' '
             AND data.rollup_timestamp >= tgt.start_time
             AND data.target_guid = comp.target_guid (+)
             AND data.key_value = comp.composite_key (+)
           ORDER BY rollup_timestamp;
      ELSIF page_type_in = 'byCustom'
      THEN

            IF (l_period <= l_custom_raw_window)  
            THEN

                OPEN timeseries_out FOR
                  SELECT /*+ CARDINALITY(tgt 10) */
                         tgt.target_name, mgmt_global.adjust_tz(data.collection_timestamp,
                           tgt.timezone_region, l_timezone_region) AS custom_timestamp,
                         data.value AS custom_value, data.key_value,
                         l_num_keys AS num_keys, comp.key_part1_value, comp.key_part2_value,
                         comp.key_part3_value, comp.key_part4_value, comp.key_part5_value
                    FROM TABLE(CAST(l_total_targets AS MGMT_MD_COMPARE_ARRAY) ) tgt,
                         mgmt_metrics_raw data,
                         mgmt_metrics_composite_keys comp
                   WHERE data.target_guid = tgt.target_guid
                     AND data.metric_guid = l_metric_guid
                     AND data.key_value = ' '
                     AND data.collection_timestamp >= tgt.start_time
                     AND data.collection_timestamp <= tgt.end_time
                     AND data.target_guid = comp.target_guid (+)
                     AND data.key_value = comp.composite_key (+)
                   ORDER BY collection_timestamp;

            ELSIF ((l_period > l_custom_raw_window) AND (l_period <= l_custom_hour_window))
            THEN

                OPEN timeseries_out FOR
                  SELECT /*+ CARDINALITY(tgt 10) */
                         tgt.target_name, mgmt_global.adjust_tz(data.rollup_timestamp,
                           tgt.timezone_region, l_timezone_region) AS custom_timestamp,
                         data.value_maximum, data.value_minimum,
                         data.value_average AS custom_value, data.key_value,
                         l_num_keys AS num_keys, comp.key_part1_value, comp.key_part2_value,
                         comp.key_part3_value, comp.key_part4_value, comp.key_part5_value
                    FROM TABLE(CAST(l_total_targets AS MGMT_MD_COMPARE_ARRAY) ) tgt,
                         mgmt_metrics_1hour data,
                         mgmt_metrics_composite_keys comp
                   WHERE data.target_guid = tgt.target_guid
                     AND data.metric_guid = l_metric_guid
                     AND data.key_value = ' '
                     AND data.rollup_timestamp >= tgt.start_time
                     AND data.rollup_timestamp <= tgt.end_time
                     AND data.target_guid = comp.target_guid (+)
                     AND data.key_value = comp.composite_key (+)
                   ORDER BY rollup_timestamp;

            ELSIF (l_period > l_custom_hour_window)
            THEN

                OPEN timeseries_out FOR
                  SELECT /*+ CARDINALITY(tgt 10) */
                         tgt.target_name, mgmt_global.adjust_tz(data.rollup_timestamp,
                           tgt.timezone_region, l_timezone_region) AS custom_timestamp,
                         data.value_maximum, data.value_minimum,
                         data.value_average AS custom_value, data.key_value,
                         l_num_keys AS num_keys, comp.key_part1_value, comp.key_part2_value,
                         comp.key_part3_value, comp.key_part4_value, comp.key_part5_value
                    FROM TABLE(CAST(l_total_targets AS MGMT_MD_COMPARE_ARRAY) ) tgt,
                         mgmt_metrics_1day data,
                         mgmt_metrics_composite_keys comp
                   WHERE data.target_guid = tgt.target_guid
                     AND data.metric_guid = l_metric_guid
                     AND data.key_value = ' '
                     AND data.rollup_timestamp >= tgt.start_time
                     AND data.rollup_timestamp <= tgt.end_time
                     AND data.target_guid = comp.target_guid (+)
                     AND data.key_value = comp.composite_key (+)
                   ORDER BY rollup_timestamp;

            END IF;

                
      ELSE
        OPEN timeseries_out FOR
          SELECT /*+ CARDINALITY(tgt 10) */
                 tgt.target_name, mgmt_global.adjust_tz(data.collection_timestamp,
                   tgt.timezone_region, l_timezone_region) AS collection_timestamp,
                 data.value, data.key_value,
                 l_num_keys AS num_keys, comp.key_part1_value, comp.key_part2_value,
                 comp.key_part3_value, comp.key_part4_value, comp.key_part5_value
            FROM TABLE(CAST(l_total_targets AS MGMT_MD_COMPARE_ARRAY) ) tgt,
                 mgmt_metrics_raw data,
                 mgmt_metrics_composite_keys comp
           WHERE data.target_guid = tgt.target_guid
             AND data.metric_guid = l_metric_guid
             AND data.key_value = ' '
             AND data.collection_timestamp >= tgt.start_time
             AND data.target_guid = comp.target_guid (+)
             AND data.key_value = comp.composite_key (+)
           ORDER BY collection_timestamp;
      END IF;
    END IF;

  -- multiple targets and single target time zone, just need to convert db time zone to 
  -- target time zone, three table joins (tgt, data, comp)

  ELSIF l_total_targets.COUNT > 1 AND l_is_diff_timezone_flag = FALSE
  THEN

    -- with one key value (can only have one since we're comparing targets)
    IF key_value_in IS NOT NULL AND length(key_value_in) <> 0
    THEN
      IF page_type_in = 'byMonth'
      THEN
        OPEN timeseries_out FOR
          SELECT /*+ CARDINALITY(tgt 10) */
                 tgt.target_name, data.rollup_timestamp, 
                 data.value_maximum, data.value_minimum,
                 data.value_average, data.key_value,
                 l_num_keys AS num_keys, comp.key_part1_value, comp.key_part2_value,
                 comp.key_part3_value, comp.key_part4_value, comp.key_part5_value
            FROM TABLE(CAST(l_total_targets AS MGMT_MD_COMPARE_ARRAY) ) tgt,
                 mgmt_metrics_1day data,
                 mgmt_metrics_composite_keys comp
           WHERE data.target_guid = tgt.target_guid
             AND data.metric_guid = l_metric_guid
             AND data.key_value = key_value_in
             AND data.rollup_timestamp >= tgt.start_time
             AND data.target_guid = comp.target_guid (+)
             AND data.key_value = comp.composite_key (+)
           ORDER BY data.rollup_timestamp;
      ELSIF page_type_in = 'byWeek'
      THEN
        OPEN timeseries_out FOR
          SELECT /*+ CARDINALITY(tgt 10) */
                 tgt.target_name, data.rollup_timestamp,
                 data.value_maximum, data.value_minimum,
                 data.value_average, data.key_value,
                 l_num_keys AS num_keys, comp.key_part1_value, comp.key_part2_value,
                 comp.key_part3_value, comp.key_part4_value, comp.key_part5_value
            FROM TABLE(CAST(l_total_targets AS MGMT_MD_COMPARE_ARRAY) ) tgt,
                 mgmt_metrics_1hour data,
                 mgmt_metrics_composite_keys comp
           WHERE data.target_guid = tgt.target_guid
             AND data.metric_guid = l_metric_guid
             AND data.key_value = key_value_in
             AND data.rollup_timestamp >= tgt.start_time
             AND data.target_guid = comp.target_guid (+)
             AND data.key_value = comp.composite_key (+)
           ORDER BY data.rollup_timestamp;
      ELSIF page_type_in = 'byCustom'
      THEN

            IF (l_period <= l_custom_raw_window)  
            THEN

                OPEN timeseries_out FOR
                  SELECT /*+ CARDINALITY(tgt 10) */
                         tgt.target_name, data.collection_timestamp AS custom_timestamp,
                         data.value AS custom_value, data.key_value,
                         l_num_keys AS num_keys, comp.key_part1_value, comp.key_part2_value,
                         comp.key_part3_value, comp.key_part4_value, comp.key_part5_value
                    FROM TABLE(CAST(l_total_targets AS MGMT_MD_COMPARE_ARRAY) ) tgt,
                         mgmt_metrics_raw data,
                         mgmt_metrics_composite_keys comp
                   WHERE data.target_guid = tgt.target_guid
                     AND data.metric_guid = l_metric_guid
                     AND data.key_value = key_value_in
                     AND data.collection_timestamp >= tgt.start_time
                     AND data.collection_timestamp <= tgt.end_time
                     AND data.target_guid = comp.target_guid (+)
                     AND data.key_value = comp.composite_key (+)
                   ORDER BY data.collection_timestamp;

            ELSIF ((l_period > l_custom_raw_window) AND (l_period <= l_custom_hour_window))
            THEN

                OPEN timeseries_out FOR
                  SELECT /*+ CARDINALITY(tgt 10) */
                         tgt.target_name, data.rollup_timestamp AS custom_timestamp,
                         data.value_maximum, data.value_minimum,
                         data.value_average AS custom_value, data.key_value,
                         l_num_keys AS num_keys, comp.key_part1_value, comp.key_part2_value,
                         comp.key_part3_value, comp.key_part4_value, comp.key_part5_value
                    FROM TABLE(CAST(l_total_targets AS MGMT_MD_COMPARE_ARRAY) ) tgt,
                         mgmt_metrics_1hour data,
                         mgmt_metrics_composite_keys comp
                   WHERE data.target_guid = tgt.target_guid
                     AND data.metric_guid = l_metric_guid
                     AND data.key_value = key_value_in
                     AND data.rollup_timestamp >= tgt.start_time
                     AND data.rollup_timestamp <= tgt.end_time
                     AND data.target_guid = comp.target_guid (+)
                     AND data.key_value = comp.composite_key (+)
                   ORDER BY data.rollup_timestamp;

            ELSIF (l_period > l_custom_hour_window)
            THEN

                OPEN timeseries_out FOR
                  SELECT /*+ CARDINALITY(tgt 10) */
                         tgt.target_name, data.rollup_timestamp AS custom_timestamp, 
                         data.value_maximum, data.value_minimum,
                         data.value_average AS custom_value, data.key_value,
                         l_num_keys AS num_keys, comp.key_part1_value, comp.key_part2_value,
                         comp.key_part3_value, comp.key_part4_value, comp.key_part5_value
                    FROM TABLE(CAST(l_total_targets AS MGMT_MD_COMPARE_ARRAY) ) tgt,
                         mgmt_metrics_1day data,
                         mgmt_metrics_composite_keys comp
                   WHERE data.target_guid = tgt.target_guid
                     AND data.metric_guid = l_metric_guid
                     AND data.key_value = key_value_in
                     AND data.rollup_timestamp >= tgt.start_time
                     AND data.rollup_timestamp <= tgt.end_time
                     AND data.target_guid = comp.target_guid (+)
                     AND data.key_value = comp.composite_key (+)
                   ORDER BY data.rollup_timestamp;

            END IF;

      ELSE
        OPEN timeseries_out FOR
          SELECT /*+ CARDINALITY(tgt 10) */
                 tgt.target_name, data.collection_timestamp,
                 data.value, data.key_value,
                 l_num_keys AS num_keys, comp.key_part1_value, comp.key_part2_value,
                 comp.key_part3_value, comp.key_part4_value, comp.key_part5_value
            FROM TABLE(CAST(l_total_targets AS MGMT_MD_COMPARE_ARRAY) ) tgt,
                 mgmt_metrics_raw data,
                 mgmt_metrics_composite_keys comp
           WHERE data.target_guid = tgt.target_guid
             AND data.metric_guid = l_metric_guid
             AND data.key_value = key_value_in
             AND data.collection_timestamp >= tgt.start_time
             AND data.target_guid = comp.target_guid (+)
             AND data.key_value = comp.composite_key (+)
           ORDER BY data.collection_timestamp;
      END IF;
    -- without key value
    ELSE
      IF page_type_in = 'byMonth'
      THEN
        OPEN timeseries_out FOR
          SELECT /*+ CARDINALITY(tgt 10) */
                 tgt.target_name, data.rollup_timestamp, 
                 data.value_maximum, data.value_minimum,
                 data.value_average, data.key_value,
                 l_num_keys AS num_keys, comp.key_part1_value, comp.key_part2_value,
                 comp.key_part3_value, comp.key_part4_value, comp.key_part5_value
            FROM TABLE(CAST(l_total_targets AS MGMT_MD_COMPARE_ARRAY) ) tgt,
                 mgmt_metrics_1day data,
                 mgmt_metrics_composite_keys comp
           WHERE data.target_guid = tgt.target_guid
             AND data.metric_guid = l_metric_guid
             AND data.key_value = ' '
             AND data.rollup_timestamp >= tgt.start_time
             AND data.target_guid = comp.target_guid (+)
             AND data.key_value = comp.composite_key (+)
           ORDER BY data.rollup_timestamp;
      ELSIF page_type_in = 'byWeek'
      THEN
        OPEN timeseries_out FOR
          SELECT /*+ CARDINALITY(tgt 10) */
                 tgt.target_name, data.rollup_timestamp,
                 data.value_maximum, data.value_minimum,
                 data.value_average, data.key_value,
                 l_num_keys AS num_keys, comp.key_part1_value, comp.key_part2_value,
                 comp.key_part3_value, comp.key_part4_value, comp.key_part5_value
            FROM TABLE(CAST(l_total_targets AS MGMT_MD_COMPARE_ARRAY) ) tgt,
                 mgmt_metrics_1hour data,
                 mgmt_metrics_composite_keys comp
           WHERE data.target_guid = tgt.target_guid
             AND data.metric_guid = l_metric_guid
             AND data.key_value = ' '
             AND data.rollup_timestamp >= tgt.start_time
             AND data.target_guid = comp.target_guid (+)
             AND data.key_value = comp.composite_key (+)
           ORDER BY data.rollup_timestamp;
      ELSIF page_type_in = 'byCustom'
      THEN

            IF (l_period <= l_custom_raw_window)  
            THEN

                OPEN timeseries_out FOR
                  SELECT /*+ CARDINALITY(tgt 10) */
                         tgt.target_name, data.collection_timestamp AS custom_timestamp,
                         data.value AS custom_value, data.key_value,
                         l_num_keys AS num_keys, comp.key_part1_value, comp.key_part2_value,
                         comp.key_part3_value, comp.key_part4_value, comp.key_part5_value
                    FROM TABLE(CAST(l_total_targets AS MGMT_MD_COMPARE_ARRAY) ) tgt,
                         mgmt_metrics_raw data,
                         mgmt_metrics_composite_keys comp
                   WHERE data.target_guid = tgt.target_guid
                     AND data.metric_guid = l_metric_guid
                     AND data.key_value = ' '
                     AND data.collection_timestamp >= tgt.start_time
                     AND data.collection_timestamp <= tgt.end_time
                     AND data.target_guid = comp.target_guid (+)
                     AND data.key_value = comp.composite_key (+)
                   ORDER BY data.collection_timestamp;

            ELSIF ((l_period > l_custom_raw_window) AND (l_period <= l_custom_hour_window))
            THEN

                OPEN timeseries_out FOR
                  SELECT /*+ CARDINALITY(tgt 10) */
                         tgt.target_name, data.rollup_timestamp AS custom_timestamp,
                         data.value_maximum, data.value_minimum,
                         data.value_average AS custom_value, data.key_value,
                         l_num_keys AS num_keys, comp.key_part1_value, comp.key_part2_value,
                         comp.key_part3_value, comp.key_part4_value, comp.key_part5_value
                    FROM TABLE(CAST(l_total_targets AS MGMT_MD_COMPARE_ARRAY) ) tgt,
                         mgmt_metrics_1hour data,
                         mgmt_metrics_composite_keys comp
                   WHERE data.target_guid = tgt.target_guid
                     AND data.metric_guid = l_metric_guid
                     AND data.key_value = ' '
                     AND data.rollup_timestamp >= tgt.start_time
                     AND data.rollup_timestamp <= tgt.end_time
                     AND data.target_guid = comp.target_guid (+)
                     AND data.key_value = comp.composite_key (+)
                   ORDER BY data.rollup_timestamp;

            ELSIF (l_period > l_custom_hour_window)
            THEN

                OPEN timeseries_out FOR
                  SELECT /*+ CARDINALITY(tgt 10) */
                         tgt.target_name, data.rollup_timestamp AS custom_timestamp, 
                         data.value_maximum, data.value_minimum,
                         data.value_average AS custom_value, data.key_value,
                         l_num_keys AS num_keys, comp.key_part1_value, comp.key_part2_value,
                         comp.key_part3_value, comp.key_part4_value, comp.key_part5_value
                    FROM TABLE(CAST(l_total_targets AS MGMT_MD_COMPARE_ARRAY) ) tgt,
                         mgmt_metrics_1day data,
                         mgmt_metrics_composite_keys comp
                   WHERE data.target_guid = tgt.target_guid
                     AND data.metric_guid = l_metric_guid
                     AND data.key_value = ' '
                     AND data.rollup_timestamp >= tgt.start_time
                     AND data.rollup_timestamp <= tgt.end_time
                     AND data.target_guid = comp.target_guid (+)
                     AND data.key_value = comp.composite_key (+)
                   ORDER BY data.rollup_timestamp;

            END IF;
               
      ELSE
        OPEN timeseries_out FOR
          SELECT /*+ CARDINALITY(tgt 10) */
                 tgt.target_name, data.collection_timestamp,
                 data.value, data.key_value,
                 l_num_keys AS num_keys, comp.key_part1_value, comp.key_part2_value,
                 comp.key_part3_value, comp.key_part4_value, comp.key_part5_value
            FROM TABLE(CAST(l_total_targets AS MGMT_MD_COMPARE_ARRAY) ) tgt,
                 mgmt_metrics_raw data,
                 mgmt_metrics_composite_keys comp
           WHERE data.target_guid = tgt.target_guid
             AND data.metric_guid = l_metric_guid
             AND data.key_value = ' '
             AND data.collection_timestamp >= tgt.start_time
             AND data.target_guid = comp.target_guid (+)
             AND data.key_value = comp.composite_key (+)
           ORDER BY data.collection_timestamp;
      END IF;
    END IF;  
  
  -- single target and single target time zone, just need to convert db time zone to 
  -- the target time zone, two table joins (data, comp)

  ELSE
    l_systimestamp := CAST(SYSTIMESTAMP at time zone l_timezone_region as DATE);

    -- we may have multiple key values (comparing keys), 1 key value, 
    -- or no key value. l_key_values already has this information
    IF page_type_in = 'byMonth'
    THEN
      OPEN timeseries_out FOR
        SELECT /*+ CARDINALITY(keys 10)*/
               target_name_in AS target_name, data.rollup_timestamp,
               data.value_maximum, data.value_minimum,
               data.value_average, data.key_value,
               l_num_keys AS num_keys, comp.key_part1_value, comp.key_part2_value,
               comp.key_part3_value, comp.key_part4_value, comp.key_part5_value
          FROM TABLE(CAST(l_key_values AS SMP_EMD_STRING_ARRAY) ) keys,
               mgmt_metrics_1day data,
               mgmt_metrics_composite_keys comp
         WHERE data.target_guid = l_target_guid
           AND data.metric_guid = l_metric_guid
           AND data.key_value = keys.column_value
           AND data.rollup_timestamp >= l_systimestamp - 31
           AND data.target_guid = comp.target_guid (+)
           AND data.key_value = comp.composite_key (+)
         ORDER BY data.rollup_timestamp;
    ELSIF page_type_in = 'byWeek'
    THEN
      OPEN timeseries_out FOR
        SELECT /*+ CARDINALITY(keys 10)*/
               target_name_in AS target_name, data.rollup_timestamp,
               data.value_maximum, data.value_minimum,
               data.value_average, data.key_value,
               l_num_keys AS num_keys, comp.key_part1_value, comp.key_part2_value,
               comp.key_part3_value, comp.key_part4_value, comp.key_part5_value
          FROM TABLE(CAST(l_key_values AS SMP_EMD_STRING_ARRAY) ) keys,
               mgmt_metrics_1hour data,
               mgmt_metrics_composite_keys comp
         WHERE data.target_guid = l_target_guid
           AND data.metric_guid = l_metric_guid
           AND data.key_value = keys.column_value
           AND data.rollup_timestamp >= l_systimestamp - 7
           AND data.target_guid = comp.target_guid (+)
           AND data.key_value = comp.composite_key (+)
         ORDER BY data.rollup_timestamp;
    ELSIF page_type_in = 'byCustom'
    THEN

            IF (l_period <= l_custom_raw_window)  
            THEN

              OPEN timeseries_out FOR
                SELECT  /*+ CARDINALITY(keys 10)*/
                       target_name_in AS target_name, data.collection_timestamp AS custom_timestamp,
                       data.value AS custom_value, data.key_value,
                       l_num_keys AS num_keys, comp.key_part1_value, comp.key_part2_value,
                       comp.key_part3_value, comp.key_part4_value, comp.key_part5_value
                  FROM TABLE(CAST(l_key_values AS SMP_EMD_STRING_ARRAY) ) keys,
                       mgmt_metrics_raw data,
                       mgmt_metrics_composite_keys comp
                 WHERE data.target_guid = l_target_guid
                   AND data.metric_guid = l_metric_guid
                   AND data.key_value = keys.column_value
                   AND data.collection_timestamp >= l_custom_start_time
                   AND data.collection_timestamp <= l_custom_end_time
                   AND data.target_guid = comp.target_guid (+)
                   AND data.key_value = comp.composite_key (+)
                 ORDER BY data.collection_timestamp;

            ELSIF ((l_period > l_custom_raw_window) AND (l_period <= l_custom_hour_window))
            THEN

              OPEN timeseries_out FOR
                SELECT  /*+ CARDINALITY(keys 10)*/
                       target_name_in AS target_name, data.rollup_timestamp AS custom_timestamp,
                       data.value_maximum, data.value_minimum,
                       data.value_average AS custom_value, data.key_value,
                       l_num_keys AS num_keys, comp.key_part1_value, comp.key_part2_value,
                       comp.key_part3_value, comp.key_part4_value, comp.key_part5_value
                  FROM TABLE(CAST(l_key_values AS SMP_EMD_STRING_ARRAY) ) keys,
                       mgmt_metrics_1hour data,
                       mgmt_metrics_composite_keys comp
                 WHERE data.target_guid = l_target_guid
                   AND data.metric_guid = l_metric_guid
                   AND data.key_value = keys.column_value
                   AND data.rollup_timestamp >= l_custom_start_time
                   AND data.rollup_timestamp <= l_custom_end_time
                   AND data.target_guid = comp.target_guid (+)
                   AND data.key_value = comp.composite_key (+)
                 ORDER BY data.rollup_timestamp;

            ELSIF (l_period > l_custom_hour_window)
            THEN

              OPEN timeseries_out FOR
                SELECT  /*+ CARDINALITY(keys 10)*/
                       target_name_in AS target_name, data.rollup_timestamp AS custom_timestamp,
                       data.value_maximum, data.value_minimum,
                       data.value_average AS custom_value, data.key_value,
                       l_num_keys AS num_keys, comp.key_part1_value, comp.key_part2_value,
                       comp.key_part3_value, comp.key_part4_value, comp.key_part5_value
                  FROM TABLE(CAST(l_key_values AS SMP_EMD_STRING_ARRAY) ) keys,
                       mgmt_metrics_1day data,
                       mgmt_metrics_composite_keys comp
                 WHERE data.target_guid = l_target_guid
                   AND data.metric_guid = l_metric_guid
                   AND data.key_value = keys.column_value
                   AND data.rollup_timestamp >= l_custom_start_time
                   AND data.rollup_timestamp <= l_custom_end_time
                   AND data.target_guid = comp.target_guid (+)
                   AND data.key_value = comp.composite_key (+)
                 ORDER BY data.rollup_timestamp;

            END IF;
                
    ELSE
       OPEN timeseries_out FOR
        select  /*+ CARDINALITY(k 10) USE_HASH(c) INDEX(c MGMT_METRICS_COMP_KEYS_PK) */
                target_name_in  AS target_name,
                d.collection_timestamp AS collection_timestamp,
                d.value AS value,
                d.key_value AS key_value, 
                l_num_keys AS num_keys,
                c.key_part1_value, 
                c.key_part2_value, 
                c.key_part3_value, 
                c.key_part4_value, 
                c.key_part5_value
        FROM    mgmt_metrics_raw d,
                TABLE(CAST(l_key_values AS SMP_EMD_STRING_ARRAY)) k,
                mgmt_metrics_composite_keys c
        WHERE   d.target_guid = HEXTORAW(l_target_guid)
            AND d.metric_guid = HEXTORAW(l_metric_guid)
            AND d.key_value   = k.column_value
            AND d.collection_timestamp >= TO_DATE(l_systimestamp-1)
            AND d.target_guid  = c.target_guid (+)
            AND d.key_value    = c.composite_key (+)
        ORDER BY d.collection_timestamp;
      END IF;
  END IF;

END get_metric_details_ts_mk;

PROCEDURE get_metric_details_ts(
                             target_name_in                 IN  VARCHAR2,
                             target_type_in                 IN  VARCHAR2,
                             metric_name_in                 IN  VARCHAR2,
                             metric_column_in               IN  VARCHAR2,
                             key_value_in                   IN  VARCHAR2,
                             page_type_in                   IN  VARCHAR2,
                             cmp_targets_in                 IN  SMP_EMD_STRING_ARRAY,
                             cmp_key_values_in              IN  SMP_EMD_STRING_ARRAY,
                             timeseries_out                 OUT cursorType,
                             start_Date_in                  IN  VARCHAR2 DEFAULT NULL,
                             end_Date_in                    IN  VARCHAR2 DEFAULT NULL)
IS
BEGIN
        get_metric_details_ts_mk(target_name_in,
                                      target_type_in,
                                      metric_name_in,
                                      metric_column_in,
                                      key_value_in,
                                      page_type_in,
                                      cmp_targets_in,
                                      cmp_key_values_in,
                                      timeseries_out,
                                      start_Date_in,
                                      end_Date_in);
END get_metric_details_ts;

--
-- PURPOSE:
--   This procedure returns all alert details information displayed in the alert
--   details page
--
-- IN Parameters:
--   severity_guid_in: RAW  severity guid
--
-- OUT Parameters:
--   key_value_out: VARCHAR2  key value
--   metric_info_out: CURSOR  cursor containing labels, key order, and 
--                            number of keys, etc. information
--   composite_key_info_out: CURSOR  cursor containing composite key information
--   alert_details_out: CURSOR  cursor containing alert details information
--
PROCEDURE get_alert_details(severity_guid_in       IN RAW,
                            key_value_out          OUT VARCHAR2,
                            metric_info_out        OUT cursorType,
                            composite_key_info_out OUT cursorType,
                            alert_details_out      OUT cursorType,
                            execution_id_out       OUT RAW) IS

  l_target_guid RAW(16);
  l_metric_guid RAW(16);
  l_type_meta_ver mgmt_targets.type_meta_ver%TYPE;
  l_category_prop_1 mgmt_targets.category_prop_1%TYPE;
  l_category_prop_2 mgmt_targets.category_prop_2%TYPE;
  l_category_prop_3 mgmt_targets.category_prop_3%TYPE;
  l_category_prop_4 mgmt_targets.category_prop_4%TYPE;
  l_category_prop_5 mgmt_targets.category_prop_5%TYPE;

BEGIN

  BEGIN 
    SELECT tgt.target_guid, tgt.type_meta_ver, tgt.category_prop_1, 
           tgt.category_prop_2, tgt.category_prop_3, tgt.category_prop_4,
           tgt.category_prop_5, sev.metric_guid, sev.key_value
      INTO l_target_guid, l_type_meta_ver, l_category_prop_1, 
           l_category_prop_2, l_category_prop_3, l_category_prop_4,
           l_category_prop_5, l_metric_guid, key_value_out
      FROM mgmt_severity sev, mgmt_targets tgt
     WHERE sev.severity_guid = severity_guid_in
       AND sev.target_guid = tgt.target_guid;

    EXCEPTION
      WHEN NO_DATA_FOUND
        THEN
          raise;

      WHEN TOO_MANY_ROWS
        THEN
          raise;
  END;

  -- labels, key order, and number of keys, etc. information
  OPEN metric_info_out FOR
    SELECT met.metric_label, met.metric_label_nlsid, 
           met.column_label, met.column_label_nlsid,  
           met.metric_column, met.key_order, met.num_keys
      FROM mgmt_metrics met,
           (SELECT DISTINCT target_type, metric_name, metric_column
              FROM mgmt_metrics
             WHERE metric_guid = l_metric_guid) m
     WHERE met.target_type = m.target_type
       AND met.metric_name = m.metric_name
       AND (met.metric_column = m.metric_column OR met.key_order != 0 OR met.metric_type = 2)
       AND met.type_meta_ver = l_type_meta_ver
       AND (met.category_prop_1 = l_category_prop_1 OR met.category_prop_1 = ' ')
       AND (met.category_prop_2 = l_category_prop_2 OR met.category_prop_2 = ' ')
       AND (met.category_prop_3 = l_category_prop_3 OR met.category_prop_3 = ' ')
       AND (met.category_prop_4 = l_category_prop_4 OR met.category_prop_4 = ' ')
       AND (met.category_prop_5 = l_category_prop_5 OR met.category_prop_5 = ' ');

  -- for composite keys
  OPEN composite_key_info_out FOR
    SELECT *
      FROM mgmt_metrics_composite_keys
     WHERE target_guid = l_target_guid 
       AND composite_key = key_value_out;

  -- severity, annotation, and notification
  OPEN alert_details_out FOR
    SELECT sev.*
      FROM ( (SELECT severity_code, collection_timestamp, NULL AS annotation_type,
                     '<SYSTEM>' AS user_name, message, message_nlsid, message_params
                FROM mgmt_severity
               WHERE severity_guid = severity_guid_in)
             UNION
             (SELECT NULL AS severity_code, collection_timestamp, annotation_type,
                     user_name, message, NULL AS message_nlsid, NULL AS message_params
                FROM mgmt_severity_annotation
               WHERE severity_guid = severity_guid_in)
             UNION
             (SELECT NULL AS severity_code, timestamp AS collection_timestamp, 'NOTIFICATION' AS annotation_type,
                     '<SYSTEM>' AS user_name, message, NULL AS message_nlsid, NULL AS message_params
                FROM mgmt_notification_log
               WHERE source_obj_type = MGMT_GLOBAL.G_ANNOTATION_SOURCE_SEVERITY
                 AND source_obj_guid = severity_guid_in) ) sev
     ORDER BY sev.collection_timestamp desc;

  BEGIN 
    SELECT execution_id
      INTO execution_id_out
      FROM mgmt_job_exec_summary
     WHERE triggering_severity = severity_guid_in;

    EXCEPTION
      WHEN NO_DATA_FOUND
        THEN
          execution_id_out := NULL;
  END;

END get_alert_details;

--
-- Purpose: 
--   clear the metric severity
--
-- IN parameters:
--   sev_guids_in: MGMT_USER_GUID_ARRAY  severity guids
--   annotation_in: VARCHAR2  the user annotation for clearing the severity
--   message_in: VARCHAR2  the message for the clear severity record
--
PROCEDURE clear_metric_severity(sev_guids_in IN MGMT_USER_GUID_ARRAY,
                                annotation_in IN VARCHAR2,
                                message_in IN VARCHAR2) IS

  l_met_inst MGMT_METRIC_INSTANCE_ARRAY := MGMT_METRIC_INSTANCE_ARRAY();
  l_sev_guids MGMT_USER_GUID_ARRAY := MGMT_USER_GUID_ARRAY();
  l_user_name VARCHAR2(64);

BEGIN

  l_user_name := UPPER(mgmt_user.get_current_em_user() );

  SELECT MGMT_METRIC_INSTANCE(inst.target_name, inst.target_type, 
           inst.metric_name, inst.metric_column, inst.key_value),
         inst.severity_guid
         BULK COLLECT INTO l_met_inst, l_sev_guids
    FROM (SELECT DISTINCT tgt.target_name, tgt.target_type, 
                 met.metric_name, met.metric_column,
                 sev.key_value, sev.severity_guid
            FROM TABLE(CAST(sev_guids_in AS MGMT_USER_GUID_ARRAY)) guids,
                 mgmt_current_severity sev, mgmt_targets tgt, mgmt_metrics met
           WHERE guids.column_value = sev.severity_guid
             AND sev.target_guid = tgt.target_guid
             AND sev.metric_guid = met.metric_guid) inst;

  FOR i in l_met_inst.FIRST..l_met_inst.LAST
  LOOP
    -- add user annotation
    emd_schema.add_severity_annotation_ttzr(l_sev_guids(i), annotation_in,
      l_user_name, NULL);

    -- clear severity
    clear_metric_severity(l_met_inst(i).target_name, l_met_inst(i).target_type, 
      l_met_inst(i).metric_name, l_met_inst(i).metric_column, 
      l_met_inst(i).key_value, NULL, message_in);
  END LOOP;

END clear_metric_severity;

--
-- Purpose: 
--   clear the metric severity
--
-- IN parameters:
--   target_name_in: VARCHAR2  target name
--   target_type_in: VARCHAR2  target type
--   metric_name_in: VARCHAR2  metric name
--   metric_column_in: VARCHAR2  metric column
--   key_value_in: VARCHAR2  key value
--   annotation_in: VARCHAR2  the user annotation for clearing the severity
--   message_in: VARCHAR2  the message for the clear severity record
--
PROCEDURE clear_metric_severity(target_name_in IN VARCHAR2,
                                target_type_in IN VARCHAR2,
                                metric_name_in IN VARCHAR2,
                                metric_column_in IN VARCHAR2,
                                key_value_in IN VARCHAR2,
                                annotation_in IN VARCHAR2,
                                message_in IN VARCHAR2) IS

  l_key_value VARCHAR2(256) := ' ';

BEGIN

  IF(key_value_in is NOT NULL)
  THEN
    l_key_value := key_value_in;
  END IF;

  emd_schema.add_severity_clear(target_name_in, target_type_in, 
    metric_name_in, metric_column_in, l_key_value, 0, annotation_in, message_in);

END clear_metric_severity;

--
-- Note: Should not use this to add annotations any more. Will be removed.
--       Call emd_schema.add_severity_annotation. 
--
--
-- Purpose: 
--  add user-entered annotation
--
-- IN parameters:
--   target_name_in: VARCHAR2  target name
--   target_type_in: VARCHAR2  target type
--   metric_name_in: VARCHAR2  metric name
--   metric_column_in: VARCHAR2  metric column
--   key_value_in: VARCHAR2  key value
--   annotation_in: VARCHAR2  the annotation that the user entered
-- OUT parameters:
--
-- Exceptions: MGMT_GLOBAL.target_does_not_exist
--             MGMT_GLOBAL.no_such_metric_found
PROCEDURE add_metric_annotation(target_name_in IN VARCHAR2,
                                target_type_in IN VARCHAR2,
                                metric_name_in IN VARCHAR2,
                                metric_column_in IN VARCHAR2,
                                key_value_in IN VARCHAR2,
                                annotation_in IN VARCHAR2) IS
  l_target_guid RAW(16);
  l_metric_guid RAW(16);
  l_user_name VARCHAR2(64);
  l_key_value VARCHAR2(256) := ' ';

BEGIN
  -- get current user name from sys context
  l_user_name := UPPER(mgmt_user.get_current_em_user() );

  BEGIN 
    SELECT target_guid INTO l_target_guid
      FROM mgmt_targets
     WHERE target_name = target_name_in
       AND target_type = target_type_in;

    EXCEPTION
      WHEN NO_DATA_FOUND
        THEN raise MGMT_GLOBAL.target_does_not_exist;
  END;

  BEGIN 
    SELECT DISTINCT metric_guid INTO l_metric_guid
      FROM mgmt_metrics
     WHERE target_type = target_type_in
       AND metric_name = metric_name_in
       AND metric_column = metric_column_in;

    EXCEPTION
      WHEN NO_DATA_FOUND
        THEN raise MGMT_GLOBAL.no_such_metric_found;
  END;

  IF(key_value_in is NOT NULL)
  THEN
    l_key_value := key_value_in;
  END IF;

  INSERT INTO mgmt_severity
    (target_guid, metric_guid, key_value, collection_timestamp, load_timestamp,
     severity_code, severity_type, severity_guid, annotated_flag, 
     notification_status, message, user_name)
  VALUES
    (l_target_guid, l_metric_guid, l_key_value, SYSDATE, NULL,
     10, NULL, NULL, NULL, 
     NULL, annotation_in, l_user_name);

END add_metric_annotation;

/*
 * Get the thresholds/current severities for all the key values monitored 
 * for a key-based metric.
 */
PROCEDURE get_key_value_current_details(target_name_in IN VARCHAR2,
                                        target_type_in IN VARCHAR2,
                                        metric_name_in IN VARCHAR2,
                                        metric_column_in IN VARCHAR2,
                                        has_priv_out OUT NUMBER,
                                        statefull_out OUT NUMBER,
                                        thresholds_out OUT cursorType,
                                        current_metric_sev_out OUT cursorType) IS

  l_target_guid RAW(16);
  l_metric_guid RAW(16);
  l_type_meta_ver mgmt_targets.type_meta_ver%TYPE;
  l_category_prop_1 mgmt_targets.category_prop_1%TYPE;
  l_category_prop_2 mgmt_targets.category_prop_2%TYPE;
  l_category_prop_3 mgmt_targets.category_prop_3%TYPE;
  l_category_prop_4 mgmt_targets.category_prop_4%TYPE;
  l_category_prop_5 mgmt_targets.category_prop_5%TYPE;
  l_key_values SMP_EMD_STRING_ARRAY := SMP_EMD_STRING_ARRAY();
  l_cfg_coll_name mgmt_policy_assoc_cfg.coll_name%TYPE;
  l_cfg_key_value mgmt_policy_assoc_cfg.key_value%TYPE;
  l_cfg_key_operator mgmt_policy_assoc_cfg.key_operator%TYPE;
  l_warning_threshold mgmt_policy_assoc_cfg_params.warn_threshold%TYPE;
  l_critical_threshold mgmt_policy_assoc_cfg_params.crit_threshold%TYPE;
  l_critical_operator mgmt_policy_assoc_cfg.condition_operator%TYPE;
  l_metric_thr_list MGMT_METRIC_THR_OBJ_ARRAY := MGMT_METRIC_THR_OBJ_ARRAY();

BEGIN

  -- get the target_guid
  BEGIN
    SELECT target_guid, type_meta_ver, category_prop_1, category_prop_2,
           category_prop_3, category_prop_4, category_prop_5
      INTO l_target_guid, l_type_meta_ver, l_category_prop_1, l_category_prop_2,
           l_category_prop_3, l_category_prop_4, l_category_prop_5
      FROM mgmt_targets
     WHERE target_name = target_name_in
       AND target_type = target_type_in;

    EXCEPTION
      WHEN NO_DATA_FOUND
      THEN
        raise MGMT_GLOBAL.target_does_not_exist;
  END;

  -- get the metric_guid and other metric related details
  BEGIN
    -- note: the "rownum = 1" is to ensure only one row is returned. This may
    -- not return the correct metric row if EMD allow empty and non-empty 
    -- values of category_prop_* columns to exist at the same time. The problem
    -- will also occur during migration.
    SELECT metric_guid, statefull 
      INTO l_metric_guid, statefull_out
      FROM mgmt_metrics
     WHERE target_type = target_type_in
       AND metric_name = metric_name_in
       AND metric_column = metric_column_in
       AND usage_type = MGMT_GLOBAL.G_USAGE_VIEW_COLLECT
       AND type_meta_ver = l_type_meta_ver
       AND (category_prop_1 = l_category_prop_1 OR category_prop_1 = ' ')
       AND (category_prop_2 = l_category_prop_2 OR category_prop_2 = ' ')
       AND (category_prop_3 = l_category_prop_3 OR category_prop_3 = ' ')
       AND (category_prop_4 = l_category_prop_4 OR category_prop_4 = ' ')
       AND (category_prop_5 = l_category_prop_5 OR category_prop_5 = ' ')
       AND rownum = 1;

  EXCEPTION
    WHEN NO_DATA_FOUND
    THEN
        raise mgmt_global.no_such_metric_found;
  END;

  -- check if the user has at least OPERATOR_TARGET privilege
  has_priv_out := mgmt_user.has_priv(
    mgmt_user.get_current_em_user(), mgmt_user.OPERATOR_TARGET, l_target_guid);

  -- find all the key values
  SELECT key_value BULK COLLECT INTO l_key_values
    FROM MGMT_CURRENT_METRICS
   WHERE target_guid = l_target_guid
     AND metric_guid = l_metric_guid;

  IF(l_key_values IS NOT NULL AND l_key_values.COUNT > 0)
  THEN
    FOR i in l_key_values.FIRST..l_key_values.LAST
    LOOP
      -- get configuration details for each key value
      EM_POLICY.get_config_key_details(p_object_guid => l_target_guid,
                                       p_policy_guid => l_metric_guid,
                                       p_key_value => l_key_values(i),
                                       p_cfg_coll_name => l_cfg_coll_name,
                                       p_cfg_key_value => l_cfg_key_value,
                                       p_cfg_key_operator => l_cfg_key_operator);

      BEGIN
        -- get warning threshold and critical threshold
        SELECT warning_threshold, critical_threshold, critical_operator
          INTO l_warning_threshold, l_critical_threshold, l_critical_operator
          FROM MGMT_METRIC_THRESHOLDS
         WHERE target_guid = l_target_guid
           AND metric_guid = l_metric_guid
           AND coll_name = l_cfg_coll_name
           AND key_value = l_cfg_key_value
           AND key_operator = l_cfg_key_operator;

        EXCEPTION
          WHEN NO_DATA_FOUND
          THEN
            l_warning_threshold := NULL;
            l_critical_threshold := NULL;
            l_critical_operator := NULL;
      END;

      l_metric_thr_list.extend;
      l_metric_thr_list(i) := MGMT_METRIC_THR_OBJ(null, null, 0, null, null,
        l_key_values(i), 0, 0, null, l_warning_threshold, l_critical_threshold,
        0, l_critical_operator, 0, null, null, 0, null, null, null, null, null);
    END LOOP;
  END IF;

  OPEN thresholds_out FOR
    SELECT list.key_value, list.warning_threshold,
           list.critical_threshold, list.critical_operator
      FROM TABLE(CAST(l_metric_thr_list AS MGMT_METRIC_THR_OBJ_ARRAY) ) list;

  OPEN current_metric_sev_out FOR
    SELECT key_value, severity_code, severity_guid, 
           collection_timestamp AS sev_timestamp
      FROM mgmt_current_severity
     WHERE target_guid = l_target_guid
       AND metric_guid = l_metric_guid;

END get_key_value_current_details;

/*
 * Get the average values/thresholds/any current severities for
 *  all the key values monitored for a key-based metric
 *  within a time period.
 */

PROCEDURE get_key_value_avg_details(
                             target_name_in                 IN  VARCHAR2,
                             target_type_in                 IN  VARCHAR2,
                             metric_name_in                 IN  VARCHAR2,
                             metric_column_in               IN  VARCHAR2,
                             time_period_in                 IN  VARCHAR2,
                             has_priv_out                   OUT NUMBER,
                             statefull_out                  OUT NUMBER,
                             key_values_out                 OUT cursorType,
                             avg_details_out                OUT cursorType,
                             thresholds_out                 OUT cursorType,
                             target_info_out                OUT cursorType
) IS
 l_days NUMBER(2);  
 l_num_keys NUMBER(1);  
 l_target_guid RAW(16);
 l_metric_guid RAW(16);
 l_type VARCHAR2(10);
 l_end_time DATE;
 l_timezone_region mgmt_targets.timezone_region%TYPE;
 l_type_meta_ver mgmt_targets.type_meta_ver%TYPE;
 l_category_prop_1 mgmt_targets.category_prop_1%TYPE;
 l_category_prop_2 mgmt_targets.category_prop_2%TYPE;
 l_category_prop_3 mgmt_targets.category_prop_3%TYPE;
 l_category_prop_4 mgmt_targets.category_prop_4%TYPE;
 l_category_prop_5 mgmt_targets.category_prop_5%TYPE;
 l_key_values SMP_EMD_STRING_ARRAY := SMP_EMD_STRING_ARRAY();
 l_cfg_coll_name mgmt_policy_assoc_cfg.coll_name%TYPE;
 l_cfg_key_value mgmt_policy_assoc_cfg.key_value%TYPE;
 l_cfg_key_operator mgmt_policy_assoc_cfg.key_operator%TYPE;
 l_warning_threshold mgmt_policy_assoc_cfg_params.warn_threshold%TYPE;
 l_critical_threshold mgmt_policy_assoc_cfg_params.crit_threshold%TYPE;
 l_metric_thr_list MGMT_METRIC_THR_OBJ_ARRAY := MGMT_METRIC_THR_OBJ_ARRAY();

BEGIN
  -- get the target_guid
  BEGIN
    SELECT target_guid, type_meta_ver, category_prop_1, category_prop_2,
           category_prop_3, category_prop_4, category_prop_5, timezone_region
      INTO l_target_guid, l_type_meta_ver, l_category_prop_1, l_category_prop_2,
           l_category_prop_3, l_category_prop_4, l_category_prop_5, l_timezone_region
      FROM mgmt_targets
     WHERE target_name = target_name_in
       AND target_type = target_type_in;

    EXCEPTION
      WHEN NO_DATA_FOUND
      THEN
        raise MGMT_GLOBAL.target_does_not_exist;
  END;

  -- get the metric_guid and other metric related details
  BEGIN
    -- note: the "rownum = 1" is to ensure only one row is returned. This may
    -- not return the correct metric row if EMD allow empty and non-empty 
    -- values of category_prop_* columns to exist at the same time. The problem
    -- will also occur during migration.
    SELECT metric_guid, num_keys, 
           DECODE(metric_type, 0, 'NUMBER', 1, 'STRING', 
                  'Unknown') metric_type, statefull
      INTO l_metric_guid, l_num_keys, l_type, statefull_out
      FROM mgmt_metrics
     WHERE target_type = target_type_in
       AND metric_name = metric_name_in
       AND metric_column = metric_column_in
       AND usage_type = MGMT_GLOBAL.G_USAGE_VIEW_COLLECT
       AND type_meta_ver = l_type_meta_ver
       AND (category_prop_1 = l_category_prop_1 OR category_prop_1 = ' ')
       AND (category_prop_2 = l_category_prop_2 OR category_prop_2 = ' ')
       AND (category_prop_3 = l_category_prop_3 OR category_prop_3 = ' ')
       AND (category_prop_4 = l_category_prop_4 OR category_prop_4 = ' ')
       AND (category_prop_5 = l_category_prop_5 OR category_prop_5 = ' ')
       AND rownum = 1;

  EXCEPTION
    WHEN NO_DATA_FOUND
    THEN
        raise mgmt_global.no_such_metric_found;
  END;

  -- if this is a metric with just a single key column
  -- create a dummy cursor for the composite key values
  IF l_num_keys <= 1
  THEN
    OPEN key_values_out FOR
      SELECT composite_key, target_guid, key_part1_value, key_part2_value, 
             key_part3_value, key_part4_value, key_part5_value
        FROM mgmt_metrics_composite_keys
       WHERE ROWNUM < 1;
  END IF;

  -- check if the user has at least OPERATOR_TARGET privilege
  has_priv_out := mgmt_user.has_priv(
    mgmt_user.get_current_em_user(), mgmt_user.OPERATOR_TARGET, l_target_guid);

  IF (time_period_in = 'byDay')
  THEN
      l_days := 1;
  ELSIF (time_period_in = 'byWeek')
  THEN
      l_days := 7;
  ELSE
      l_days := 31;
  END IF;

  l_end_time := mgmt_global.SYSDATE_TZRGN(l_timezone_region) - l_days;

  IF l_type = 'NUMBER'
  THEN
    -- handle different timeperiods..
    IF time_period_in = 'byDay'
    THEN
      -- if this is a metric with composite keys 
      -- get the composite key values
      IF l_num_keys > 1
      THEN
        OPEN key_values_out FOR
          SELECT /*+ INDEX(k) */ k.composite_key, k.target_guid, k.key_part1_value, 
                 k.key_part2_value, k.key_part3_value, k.key_part4_value, 
                 k.key_part5_value
            FROM mgmt_metrics_composite_keys k, 
                 ( SELECT DISTINCT key_value
                     FROM mgmt_metrics_raw
                    WHERE collection_timestamp >= l_end_time
                      AND target_guid = l_target_guid
                      AND metric_guid = l_metric_guid ) d
           WHERE k.target_guid = l_target_guid 
             AND k.composite_key = HEXTORAW(d.key_value);
      END IF;

      OPEN avg_details_out FOR
        SELECT avg.key_value, avg.average, avg.minimum, 
               avg.maximum, cur.value, sev.severity_code, sev.severity_guid,
               cur.collection_timestamp,
               sev.collection_timestamp AS sev_timestamp
          FROM
               (SELECT key_value, round(avg(value),2) average,
                       round(min(value),2) minimum,
                       round(max(value),2) maximum
                  FROM MGMT_METRICS_RAW
                 WHERE collection_timestamp >= l_end_time
                   AND target_guid = l_target_guid
                   AND metric_guid = l_metric_guid
                 GROUP BY key_value ) avg,
               (SELECT key_value, value, collection_timestamp
                  FROM MGMT_CURRENT_METRICS
                 WHERE target_guid = l_target_guid
                   AND metric_guid = l_metric_guid ) cur,
               (SELECT key_value, severity_code, severity_guid,
                       collection_timestamp
                  FROM MGMT_CURRENT_SEVERITY
                 WHERE target_guid = l_target_guid
                   AND metric_guid = l_metric_guid ) sev
         WHERE avg.key_value = cur.key_value(+)
           AND avg.key_value = sev.key_value(+)
         ORDER BY avg.key_value;
    
    ELSIF time_period_in = 'byWeek'
    THEN
      -- if this is a metric with composite keys 
      -- get the composite key values
      IF l_num_keys > 1
      THEN
        OPEN key_values_out FOR
          SELECT /*+ INDEX(k) */ k.composite_key, k.target_guid, k.key_part1_value, 
                 k.key_part2_value, k.key_part3_value, k.key_part4_value, 
                 k.key_part5_value
            FROM mgmt_metrics_composite_keys k, 
                 ( SELECT DISTINCT key_value
                     FROM MGMT_METRICS_1HOUR
                    WHERE rollup_timestamp >= l_end_time
                      AND target_guid = l_target_guid
                      AND metric_guid = l_metric_guid ) d
           WHERE k.target_guid = l_target_guid 
             AND k.composite_key = HEXTORAW(d.key_value);
      END IF;

      -- week's worth of history
      OPEN avg_details_out FOR
        SELECT avg.key_value, avg.average, avg.minimum, 
               avg.maximum, cur.value, sev.severity_code, sev.severity_guid, 
               cur.collection_timestamp,
               sev.collection_timestamp AS sev_timestamp
          FROM
               (SELECT key_value, round(avg(value_average),2) average,
                       round(min(value_minimum),2) minimum,
                       round(max(value_maximum),2) maximum
                  FROM MGMT_METRICS_1HOUR
                 WHERE rollup_timestamp >= l_end_time
                   AND target_guid = l_target_guid
                   AND metric_guid = l_metric_guid
                 GROUP BY key_value ) avg,
               (SELECT key_value, value, collection_timestamp
                  FROM MGMT_CURRENT_METRICS
                 WHERE target_guid = l_target_guid
                   AND metric_guid = l_metric_guid ) cur,
               (SELECT key_value, severity_code, severity_guid,
                       collection_timestamp
                  FROM MGMT_CURRENT_SEVERITY
                 WHERE target_guid = l_target_guid
                   AND metric_guid = l_metric_guid ) sev
         WHERE avg.key_value = cur.key_value(+)
           AND avg.key_value = sev.key_value(+)
         ORDER BY avg.key_value;
       
    ELSE
      -- if this is a metric with composite keys 
      -- get the composite key values
      IF l_num_keys > 1
      THEN
        OPEN key_values_out FOR
          SELECT /*+ INDEX(k) */ k.composite_key, k.target_guid, k.key_part1_value, 
                 k.key_part2_value, k.key_part3_value, k.key_part4_value, 
                 k.key_part5_value
            FROM mgmt_metrics_composite_keys k, 
                 ( SELECT DISTINCT key_value
                     FROM MGMT_METRICS_1HOUR
                    WHERE rollup_timestamp >= l_end_time
                      AND target_guid = l_target_guid
                      AND metric_guid = l_metric_guid ) d
           WHERE k.target_guid = l_target_guid 
             AND k.composite_key = HEXTORAW(d.key_value);
      END IF;

      OPEN avg_details_out FOR
        SELECT avg.key_value, avg.average, avg.minimum, 
               avg.maximum, cur.value, sev.severity_code, sev.severity_guid, 
               cur.collection_timestamp,
               sev.collection_timestamp AS sev_timestamp
          FROM
               (SELECT key_value, round(avg(value_average),2) average,
                       round(min(value_minimum),2) minimum, 
                       round(max(value_maximum),2) maximum
                  FROM MGMT_METRICS_1DAY 
                 WHERE rollup_timestamp >= l_end_time
                   AND target_guid = l_target_guid
                   AND metric_guid = l_metric_guid
                 GROUP BY key_value ) avg,
               (SELECT key_value, value, collection_timestamp
                  FROM MGMT_CURRENT_METRICS
                 WHERE target_guid = l_target_guid
                   AND metric_guid = l_metric_guid ) cur,
               (SELECT key_value, severity_code, severity_guid,
                       collection_timestamp
                  FROM MGMT_CURRENT_SEVERITY
                 WHERE target_guid = l_target_guid
                   AND metric_guid = l_metric_guid ) sev
         WHERE avg.key_value = cur.key_value(+) 
           AND avg.key_value = sev.key_value(+)
         ORDER BY avg.key_value;
     
    END IF;
  ELSE
    -- this is a string metric
    -- get all metric changes

    OPEN avg_details_out FOR
      SELECT DISTINCT key_value, string_value, collection_timestamp, 
             severity_code, severity_guid, sev_timestamp
        FROM (
              SELECT h.key_value, h.string_value, h.collection_timestamp, 
                     s.severity_code, s.severity_guid,
                     s.collection_timestamp AS sev_timestamp
                FROM mgmt_string_metric_history h,
                     ( SELECT key_value, severity_code, severity_guid,
                              collection_timestamp
                         FROM mgmt_current_severity
                        WHERE target_guid = l_target_guid
                          AND metric_guid = l_metric_guid ) s
               WHERE h.target_guid = l_target_guid
                 AND h.metric_guid = l_metric_guid
                 AND h.collection_timestamp >= l_end_time
                 AND h.key_value = s.key_value (+)
                 AND h.collection_timestamp = s.collection_timestamp (+)
              UNION
              SELECT m.key_value, m.string_value, m.collection_timestamp, 
                     s.severity_code, s.severity_guid,
                     s.collection_timestamp AS sev_timestamp
                FROM mgmt_current_metrics m,
                     (SELECT key_value, severity_code, severity_guid,
                             collection_timestamp
                        FROM mgmt_current_severity
                       WHERE target_guid = l_target_guid
                         AND metric_guid = l_metric_guid) s
               WHERE m.target_guid = l_target_guid
                 AND m.metric_guid = l_metric_guid
                 AND m.key_value = s.key_value (+)
              )
       ORDER BY key_value, collection_timestamp desc;

      -- if this is a metric with composite keys 
      -- get the composite key values
      IF l_num_keys > 1
      THEN
        OPEN key_values_out FOR
          SELECT  /*+ INDEX(k) */ k.composite_key, k.target_guid, k.key_part1_value, 
                 k.key_part2_value, k.key_part3_value, k.key_part4_value, 
                 k.key_part5_value
            FROM mgmt_metrics_composite_keys k, 
                 ( SELECT DISTINCT key_value
                     FROM (
                            SELECT key_value
                              FROM mgmt_string_metric_history
                             WHERE target_guid = l_target_guid
                               AND metric_guid = l_metric_guid
                               AND collection_timestamp >= l_end_time
                            UNION
                            SELECT key_value
                              FROM mgmt_current_metrics
                             WHERE target_guid = l_target_guid
                               AND metric_guid = l_metric_guid
                          )
                 ) d
           WHERE k.target_guid = l_target_guid 
             AND k.composite_key = HEXTORAW(d.key_value);
      END IF;

  END IF;

  -- find all the key values
  IF l_type = 'NUMBER'
  THEN
     IF time_period_in = 'byDay'
     THEN
        SELECT distinct key_value BULK COLLECT INTO l_key_values
          FROM MGMT_METRICS_RAW
         WHERE collection_timestamp >= l_end_time
           AND target_guid = l_target_guid
           AND metric_guid = l_metric_guid;
     ELSIF time_period_in = 'byWeek'
     THEN
        SELECT distinct key_value BULK COLLECT INTO l_key_values
          FROM MGMT_METRICS_1HOUR
         WHERE rollup_timestamp >= l_end_time
           AND target_guid = l_target_guid
           AND metric_guid = l_metric_guid;
     ELSIF time_period_in = 'byMonth'
     THEN
        SELECT distinct key_value BULK COLLECT INTO l_key_values
          FROM MGMT_METRICS_1DAY
         WHERE rollup_timestamp >= l_end_time
           AND target_guid = l_target_guid
           AND metric_guid = l_metric_guid;
     END IF;
  ELSE
  SELECT distinct key_value BULK COLLECT INTO l_key_values
    FROM (
         SELECT key_value
           FROM MGMT_CURRENT_METRICS
          WHERE target_guid = l_target_guid
            AND metric_guid = l_metric_guid
          UNION
         SELECT key_value
           FROM MGMT_STRING_METRIC_HISTORY 
          WHERE target_guid = l_target_guid
            AND metric_guid = l_metric_guid
            AND collection_timestamp >= l_end_time
         );
  END IF;

  IF(l_key_values IS NOT NULL AND l_key_values.COUNT > 0)
  THEN
    FOR i in l_key_values.FIRST..l_key_values.LAST
    LOOP
      -- get configuration details for each key value
      EM_POLICY.get_config_key_details(p_object_guid => l_target_guid,
                                       p_policy_guid => l_metric_guid,
                                       p_key_value => l_key_values(i),
                                       p_cfg_coll_name => l_cfg_coll_name,
                                       p_cfg_key_value => l_cfg_key_value,
                                       p_cfg_key_operator => l_cfg_key_operator);

      BEGIN
        -- get warning threshold and critical threshold
        SELECT warning_threshold, critical_threshold
          INTO l_warning_threshold, l_critical_threshold
          FROM MGMT_METRIC_THRESHOLDS
         WHERE target_guid = l_target_guid
           AND metric_guid = l_metric_guid
           AND coll_name = l_cfg_coll_name
           AND key_value = l_cfg_key_value
           AND key_operator = l_cfg_key_operator;

        EXCEPTION
          WHEN NO_DATA_FOUND
          THEN
            l_warning_threshold := NULL;
            l_critical_threshold := NULL;
      END;

      l_metric_thr_list.extend;
      l_metric_thr_list(i) := MGMT_METRIC_THR_OBJ(null, null, 0, null, null,
        l_key_values(i), 0, 0, null, l_warning_threshold, l_critical_threshold,
        0, 0, 0, null, null, 0, null, null, null, null, null);
    END LOOP;
  END IF;

  OPEN thresholds_out FOR
    SELECT list.key_value, list.warning_threshold, list.critical_threshold
      FROM TABLE(CAST(l_metric_thr_list AS MGMT_METRIC_THR_OBJ_ARRAY) ) list;

 -- Get target load and lastload timestamp with timezone
        get_target_info(
                          target_name_in ,
                          target_type_in ,
                          target_info_out);        
 
END get_key_value_avg_details;

/*
 * Get the concurrent manager site map related info.
 * This procedure returns all the relevant information for a given
 * concurrent manager target name and oracle_cmanager target type.
 * The values returned as OUT parameters are used for display in the
 * cmOverview page
 */
PROCEDURE get_cmanager_sitemap_info
  (target_name_in IN VARCHAR2,
   target_type_in IN VARCHAR2,
   type_display_name_out OUT VARCHAR2,
   last_load_time_out OUT VARCHAR2,
   current_status_out OUT INTEGER,
   avail_pct_out OUT NUMBER,
   severity_code_out OUT INTEGER,
   num_severity_out OUT INTEGER,
   request_successful_out OUT INTEGER,
   request_warning_out OUT INTEGER,
   request_error_out OUT INTEGER,
   current_forms_out OUT INTEGER,
   standby_request_out OUT INTEGER,
   pending_request_out OUT INTEGER,
   running_request_out OUT INTEGER)
IS
  l_target_guid mgmt_targets.target_guid%TYPE;

BEGIN

  -- initialize OUT parameters
  type_display_name_out := target_type_in;
  last_load_time_out := to_char(SYSDATE);
  current_status_out := 0;
  avail_pct_out := 0;
  severity_code_out := 15;
  num_severity_out := 0;

  -- target guid, type display name, last load time,
  BEGIN
    SELECT target_guid, type_display_name, TO_CHAR(last_load_time)
      INTO l_target_guid, type_display_name_out, last_load_time_out
      FROM mgmt_targets
     WHERE target_name = target_name_in
       AND target_type = target_type_in;

    EXCEPTION
      WHEN NO_DATA_FOUND
      THEN
        raise MGMT_GLOBAL.target_does_not_exist;
  END;

  -- current status
  current_status_out := mgmt_target.get_avail_current_status(l_target_guid);

  -- availability percentage
  avail_pct_out := ROUND(mgmt_target.get_avail_pct_value(l_target_guid, 1), 2);

  -- severity code
  severity_code_out := mgmt_target.get_target_max_severity(l_target_guid);

  -- total number of severities
  num_severity_out := mgmt_target.get_target_num_severity(l_target_guid);

  -- requests and forms
  request_successful_out := 0;
  request_warning_out := 0;
  request_error_out := 0;
  current_forms_out := 0;
  standby_request_out := 0;
  pending_request_out := 0;
  running_request_out := 0;


  -- get completed requests
  request_successful_out := getMetricValue (target_name_in,
                                            target_type_in,
                                            'Hourly Completed Requests',
                                            'Completed Successfully' );

  request_warning_out := getMetricValue (target_name_in,
                                         target_type_in,
                                         'Hourly Completed Requests',
                                         'Completed With Warning' );

  request_error_out := getMetricValue (target_name_in,
                                       target_type_in,
                                       'Hourly Completed Requests',
                                       'Completed With Error' );

  -- get form sessions and active requests
  current_forms_out := getMetricValue (target_name_in,
                                       target_type_in,
                                       'Form Sessions and Concurrent Requests',
                                       'Number of Current Form Sessions' );

  standby_request_out := getMetricValue (target_name_in,
                                         target_type_in,
                                         'Form Sessions and Concurrent Requests',
                                         'Standby Requests' );

  pending_request_out := getMetricValue (target_name_in,
                                         target_type_in,
                                         'Form Sessions and Concurrent Requests',
                                         'Pending Requests' );

  running_request_out := getMetricValue (target_name_in,
                                         target_type_in,
                                         'Form Sessions and Concurrent Requests',
                                         'Running Requests' );

END;

/*
 * Get the forms6 listener site map related info.
 * This procedure returns all the relevant information for a given
 * forms6 listener target name and oracle_forms6 target type.
 * The values returned as OUT parameters are used for display in the
 * forms6Overview page
 */
PROCEDURE get_forms6_sitemap_info
  (target_name_in IN VARCHAR2,
   target_type_in IN VARCHAR2,
   type_display_name_out OUT VARCHAR2,
   last_load_time_out OUT VARCHAR2,
   current_status_out OUT INTEGER,
   avail_pct_out OUT NUMBER,
   severity_code_out OUT INTEGER,
   num_severity_out OUT INTEGER,
   num_forms_sessions_out OUT INTEGER,
   mem_util_out OUT NUMBER,
   cpu_util_out OUT NUMBER,
   apps_context_out OUT VARCHAR2)
IS
  l_target_guid mgmt_targets.target_guid%TYPE;

BEGIN

  -- initialize OUT parameters
  type_display_name_out := target_type_in;
  last_load_time_out := to_char(SYSDATE);
  current_status_out := 0;
  avail_pct_out := 0;
  severity_code_out := 15;
  num_severity_out := 0;

  -- target guid, type display name, last load time
  BEGIN
    SELECT target_guid, type_display_name, TO_CHAR(last_load_time)
      INTO l_target_guid, type_display_name_out, last_load_time_out
      FROM mgmt_targets
     WHERE target_name = target_name_in
       AND target_type = target_type_in;

    EXCEPTION
      WHEN NO_DATA_FOUND
      THEN
        raise MGMT_GLOBAL.target_does_not_exist;
  END;

  -- current status
  current_status_out := mgmt_target.get_avail_current_status(l_target_guid);

  -- availability percentage
  avail_pct_out := ROUND(mgmt_target.get_avail_pct_value(l_target_guid, 1), 2);

  -- severity code
  severity_code_out := mgmt_target.get_target_max_severity(l_target_guid);

  -- total number of severities
  num_severity_out := mgmt_target.get_target_num_severity(l_target_guid);

  -- load metrics
  num_forms_sessions_out := 0;
  mem_util_out := 0;
  cpu_util_out := 0;

  -- Flag: is target used in an Oracle Applications Environment
  apps_context_out := 'N';

  -- Load values
  num_forms_sessions_out := getMetricValue (target_name_in,
                                            target_type_in,
                                            'Load',
                                            'totalCount' );

  mem_util_out := getMetricValue (target_name_in,
                                  target_type_in,
                                  'Load',
                                  'totalMem' );

  cpu_util_out := getMetricValue (target_name_in,
                                  target_type_in,
                                  'Load',
                                  'totalCPU' );
  -- get the value for isAppsContext
  for record in (
      select distinct(prop.property_value) as appsContext
      from mgmt_target_properties prop, mgmt_targets tgt
      where tgt.target_name = target_name_in and tgt.target_type = target_type_in and
            tgt.target_guid = prop.target_guid and
            prop.property_name = 'AppsContext') loop

      apps_context_out := record.appsContext;
      exit;
  end loop;
                                  
END;

/*
 * Get the reports6 site map related info.
 * This procedure returns all the relevant information for a given
 * reports6 target name and oracle_reports6 target type.
 * The values returned as OUT parameters are used for display in the
 * reports6Overview page
 */
PROCEDURE get_reports6_sitemap_info
  (target_name_in IN VARCHAR2,
   target_type_in IN VARCHAR2,
   type_display_name_out OUT VARCHAR2,
   last_load_time_out OUT VARCHAR2,
   current_status_out OUT INTEGER,
   avail_pct_out OUT NUMBER,
   severity_code_out OUT INTEGER,
   num_severity_out OUT INTEGER,
   num_users_out OUT INTEGER,
   mem_util_out OUT NUMBER,
   cpu_util_out OUT NUMBER)
IS
  l_target_guid mgmt_targets.target_guid%TYPE;

BEGIN

  -- initialize OUT parameters
  type_display_name_out := target_type_in;
  last_load_time_out := to_char(SYSDATE);
  current_status_out := 0;
  avail_pct_out := 0;
  severity_code_out := 15;
  num_severity_out := 0;

  -- target guid, type display name, last load time
  BEGIN
    SELECT target_guid, type_display_name, TO_CHAR(last_load_time)
      INTO l_target_guid, type_display_name_out, last_load_time_out
      FROM mgmt_targets
     WHERE target_name = target_name_in
       AND target_type = target_type_in;

    EXCEPTION
      WHEN NO_DATA_FOUND
      THEN
        raise MGMT_GLOBAL.target_does_not_exist;
  END;

  -- current status
  current_status_out := mgmt_target.get_avail_current_status(l_target_guid);

  -- availability percentage
  avail_pct_out := ROUND(mgmt_target.get_avail_pct_value(l_target_guid, 1), 2);

  -- severity code
  severity_code_out := mgmt_target.get_target_max_severity(l_target_guid);

  -- total number of severities
  num_severity_out := mgmt_target.get_target_num_severity(l_target_guid);

  -- load metrics
  num_users_out := 0;
  mem_util_out := 0;
  cpu_util_out := 0;

  -- Load values
  num_users_out := getMetricValue (target_name_in,
                                            target_type_in,
                                            'Load',
                                            'totalCount' );

  mem_util_out := getMetricValue (target_name_in,
                                  target_type_in,
                                  'Load',
                                  'totalMem' );

  cpu_util_out := getMetricValue (target_name_in,
                                  target_type_in,
                                  'Load',
                                  'totalCPU' );
END;

/*
 * Get the E-Business Suite site map related info.
 * This procedure returns all the relevant information for a given
 * E-Business Suite target name and oracle_EBS target type.
 * The values returned as OUT parameters are used for display in the
 * ebsOverview page
 */
PROCEDURE get_ebs_sitemap_info
  (target_name_in IN VARCHAR2,
   target_type_in IN VARCHAR2,
   type_display_name_out OUT VARCHAR2,
   last_load_time_out OUT VARCHAR2,
   current_status_out OUT INTEGER,
   avail_pct_out OUT NUMBER,
   severity_code_out OUT INTEGER,
   num_severity_out OUT INTEGER,
   current_forms_out OUT INTEGER,
   standby_request_out OUT INTEGER,
   pending_request_out OUT INTEGER,
   running_request_out OUT INTEGER,
   version_out OUT VARCHAR2,
   products_out OUT INTEGER,
   invalid_objects_out OUT INTEGER,
   patches_out OUT INTEGER,
   has_chronos_data_out OUT VARCHAR2)
IS
  l_target_guid mgmt_targets.target_guid%TYPE;

BEGIN

  -- initialize OUT parameters
  type_display_name_out := target_type_in;
  last_load_time_out := to_char(SYSDATE);
  current_status_out := 0;
  avail_pct_out := 0;
  severity_code_out := 15;
  num_severity_out := 0;

  -- target guid, type display name, last load time
  BEGIN
    SELECT target_guid, type_display_name, TO_CHAR(last_load_time)
      INTO l_target_guid, type_display_name_out, last_load_time_out
      FROM mgmt_targets
     WHERE target_name = target_name_in
       AND target_type = target_type_in;

    EXCEPTION
      WHEN NO_DATA_FOUND
      THEN
        raise MGMT_GLOBAL.target_does_not_exist;
  END;

  -- current status
  current_status_out := mgmt_target.get_avail_current_status(l_target_guid);

  -- availability percentage
  avail_pct_out := ROUND(mgmt_target.get_avail_pct_value(l_target_guid, 1), 2);

  -- severity code
  severity_code_out := mgmt_target.get_target_max_severity(l_target_guid);

  -- total number of severities
  num_severity_out := mgmt_target.get_target_num_severity(l_target_guid);

  -- requests
  current_forms_out := 0;
  standby_request_out := 0;
  pending_request_out := 0;
  running_request_out := 0;
  version_out := 'Unknown';
  products_out := 0;
  invalid_objects_out := 0;
  patches_out := 0;
  has_chronos_data_out := 'N';

  -- get general information
  version_out := getMetricStringValue (target_name_in,
                                       target_type_in,
                                       'Configuration',
                                       'Version' );

  invalid_objects_out := getMetricValue (target_name_in,
                                         target_type_in,
                                         'Configuration',
                                         'Invalid Objects' );

  products_out := getMetricValue (target_name_in,
                                  target_type_in,
                                  'Configuration',
                                  'Products Installed' );

  patches_out := getMetricValue (target_name_in,
                                 target_type_in,
                                 'Patches',
                                 'Patches Applied in Last Week' );

  -- get form sessions and active requests
  current_forms_out := getMetricValue (target_name_in,
                                       target_type_in,
                                       'Form Sessions and Concurrent Requests',
                                       'Number of Current Form Sessions' );

  standby_request_out := getMetricValue (target_name_in,
                                         target_type_in,
                                         'Form Sessions and Concurrent Requests',
                                         'Standby Requests' );

  pending_request_out := getMetricValue (target_name_in,
                                         target_type_in,
                                         'Form Sessions and Concurrent Requests',
                                         'Pending Requests' );

  running_request_out := getMetricValue (target_name_in,
                                         target_type_in,
                                         'Form Sessions and Concurrent Requests',
                                         'Running Requests' );

END;




--
-- PROCEDURE: get_console_homepage_info
--
-- PURPOSE:
--   This procedure returns information displayed in the console homepage.
--
PROCEDURE get_console_homepage_info(target_type_in IN VARCHAR2,
                                    num_targets_out OUT NUMBER,
                                    target_types_cur_out OUT cursorType,
                                    avail_cur_out OUT cursorType,
                                    severity_cur_out OUT cursorType,
                                    metric_error_cur_out OUT cursorType,
                                    policy_violation_cur_out OUT cursorType,
                                    num_targets_cur_out OUT cursorType,
                                    mt_broken_ca_cur_out OUT cursorType,
                                    policy_broken_ca_cur_out OUT cursorType) IS
                                    
BEGIN

  -- Call the simplified version
  get_console_homepage_info_simp(target_type_in,
                                 num_targets_out,
                                 target_types_cur_out,
                                 avail_cur_out);

  -- severity, and metric error
  -- for all target types
  IF(target_type_in IS NULL)
  THEN
    -- severity
    OPEN severity_cur_out FOR
    SELECT  cs.severity_code   severity_code, count(*) AS count
    FROM    mgmt_metrics met, mgmt_targets tgt,         
            mgmt_current_severity cs 
    WHERE   --cs.severity_code  in (25,18,20)       AND 
            not (met.metric_name = MGMT_GLOBAL.G_AVAIL_METRIC_NAME     AND 
                 met.metric_column = MGMT_GLOBAL.G_AVAIL_METRIC_COLUMN )   AND 
            tgt.is_group = 0                      AND 
            tgt.target_guid = cs.target_guid      AND 
            met.metric_guid = cs.metric_guid      AND 
            met.usage_type = 0                    AND 
            met.target_type = tgt.target_type     AND 
            met.type_meta_ver = tgt.type_meta_ver AND 
            (met.category_prop_1 = ' ' OR met.category_prop_1 = tgt.category_prop_1)    AND 
            (met.category_prop_2 = ' ' OR met.category_prop_2 = tgt.category_prop_2)    AND 
            (met.category_prop_3 = ' ' OR met.category_prop_3 = tgt.category_prop_3)    AND 
            (met.category_prop_4 = ' ' OR met.category_prop_4 = tgt.category_prop_4)    AND 
            (met.category_prop_5 = ' ' OR met.category_prop_5 = tgt.category_prop_5)  
    GROUP BY cs.severity_code;

    -- metric error
    -- note: if there is no record, the cursor still contains one row 
    -- with count = 0
    OPEN metric_error_cur_out FOR
    SELECT  count(*) AS count
    FROM    mgmt_current_metric_errors err,
            mgmt_metrics met,
            mgmt_targets tgt 
    WHERE   err.target_guid=tgt.target_guid AND 
            err.metric_guid=met.metric_guid AND 
            err.metric_error_message IS NOT NULL  AND 
            met.usage_type = 0  AND 
            met.type_meta_ver = tgt.type_meta_ver  AND 
            (met.category_prop_1 = ' ' OR met.category_prop_1 = tgt.category_prop_1)  AND 
            (met.category_prop_2 = ' ' OR met.category_prop_2 = tgt.category_prop_2)  AND 
            (met.category_prop_3 = ' ' OR met.category_prop_3 = tgt.category_prop_3)  AND 
            (met.category_prop_4 = ' ' OR met.category_prop_4 = tgt.category_prop_4)  AND 
            (met.category_prop_5 = ' ' OR met.category_prop_5 = tgt.category_prop_5);
       
    -- policy violations
    OPEN policy_violation_cur_out FOR 
        SELECT
            NVL(SUM(CASE WHEN e.max_violation_level = MGMT_GLOBAL.G_SEVERITY_INFORMATIONAL 
                           THEN e.non_exempt_violations_logged ELSE 0 END), 0) informational_count,
            NVL(SUM(CASE WHEN e.max_violation_level = MGMT_GLOBAL.G_SEVERITY_WARNING
                            THEN e.non_exempt_violations_logged ELSE 0 END), 0)  warning_count,
            NVL(SUM(CASE WHEN e.max_violation_level =  MGMT_GLOBAL.G_SEVERITY_CRITICAL 
                            THEN e.non_exempt_violations_logged ELSE 0 END), 0) critical_count
        FROM mgmt_policy_assoc_eval_summ e,mgmt_policies p  
        WHERE EXISTS
            (SELECT 'x' FROM mgmt_targets t WHERE e.target_guid = t.target_guid)
            AND e.non_exempt_violations_logged > 0
            AND p.policy_guid = e.policy_guid
            AND p.policy_type = MGMT_GLOBAL.G_TYPE_POLICY;           

    -- metric thresholds  broken corrective action 
    -- note: if there is no record, the cursor still contains one row 
    -- with count = 0
    OPEN mt_broken_ca_cur_out FOR
      SELECT count(UNIQUE(j.job_id)) AS count 
        FROM mgmt_job j, 
             mgmt_policy_assoc_cfg mpac, 
             mgmt_policies mp 
        WHERE j.broken = 1
          AND j.is_corrective_action =1
          AND (j.job_id = mpac.crit_action_job_id OR 
               j.job_id = mpac.warn_action_job_id OR 
               j.job_id = mpac.info_action_job_id) 
          AND mp.policy_guid = mpac.policy_guid 
          AND mp.policy_type = MGMT_GLOBAL.G_TYPE_THRESHOLD_METRIC;

    -- policy broken corrective action
    -- note: if there is no record, the cursor still contains one row 
    -- with count = 0
    OPEN policy_broken_ca_cur_out FOR
      SELECT count(UNIQUE(j.job_id)) AS count
        FROM mgmt_job j ,
             mgmt_policy_assoc_cfg mpac, 
             mgmt_policies mp 
        WHERE j.broken = 1 
          AND j.is_corrective_action =1 
          AND (j.job_id = mpac.crit_action_job_id OR 
               j.job_id = mpac.warn_action_job_id OR 
               j.job_id = mpac.info_action_job_id ) 
        AND mp.policy_guid = mpac.policy_guid
        AND mp.policy_type = MGMT_GLOBAL.G_TYPE_POLICY;

  -- for a specific target type
  ELSE
    -- severity
    OPEN severity_cur_out FOR
    SELECT  cs.severity_code   severity_code, count(*) AS count
    FROM    mgmt_metrics met, mgmt_targets tgt,         
            mgmt_current_severity cs 
    WHERE   --cs.severity_code  in (25,18,20)     AND 
            tgt.target_type = target_type_in      AND
            not (met.metric_name = MGMT_GLOBAL.G_AVAIL_METRIC_NAME    AND 
                 met.metric_column = MGMT_GLOBAL.G_AVAIL_METRIC_COLUMN )   AND 
            tgt.is_group = 0                      AND 
            tgt.target_guid = cs.target_guid      AND 
            met.metric_guid = cs.metric_guid      AND 
            met.usage_type = 0                    AND 
            met.target_type = tgt.target_type     AND 
            met.type_meta_ver = tgt.type_meta_ver AND 
            (met.category_prop_1 = ' ' OR met.category_prop_1 = tgt.category_prop_1)    AND 
            (met.category_prop_2 = ' ' OR met.category_prop_2 = tgt.category_prop_2)    AND 
            (met.category_prop_3 = ' ' OR met.category_prop_3 = tgt.category_prop_3)    AND 
            (met.category_prop_4 = ' ' OR met.category_prop_4 = tgt.category_prop_4)    AND 
            (met.category_prop_5 = ' ' OR met.category_prop_5 = tgt.category_prop_5)  
    GROUP BY cs.severity_code;

    -- metric error
    -- note: if there is no record, the cursor still contains one row 
    -- with count = 0
    OPEN metric_error_cur_out FOR
    SELECT  count(*) AS count
    FROM    mgmt_current_metric_errors err,
            mgmt_metrics met,
            mgmt_targets tgt 
    WHERE   err.target_guid=tgt.target_guid AND
            tgt.target_type = target_type_in AND
            err.metric_guid=met.metric_guid AND 
            err.metric_error_message IS NOT NULL  AND 
            met.usage_type = 0  AND 
            met.type_meta_ver = tgt.type_meta_ver  AND 
            (met.category_prop_1 = ' ' OR met.category_prop_1 = tgt.category_prop_1)  AND 
            (met.category_prop_2 = ' ' OR met.category_prop_2 = tgt.category_prop_2)  AND 
            (met.category_prop_3 = ' ' OR met.category_prop_3 = tgt.category_prop_3)  AND 
            (met.category_prop_4 = ' ' OR met.category_prop_4 = tgt.category_prop_4)  AND 
            (met.category_prop_5 = ' ' OR met.category_prop_5 = tgt.category_prop_5);

    -- policy violations
    OPEN policy_violation_cur_out FOR
       SELECT
            NVL(SUM(CASE WHEN e.max_violation_level = MGMT_GLOBAL.G_SEVERITY_INFORMATIONAL 
                           THEN e.non_exempt_violations_logged ELSE 0 END), 0) informational_count,
            NVL(SUM(CASE WHEN e.max_violation_level = MGMT_GLOBAL.G_SEVERITY_WARNING
                            THEN e.non_exempt_violations_logged ELSE 0 END), 0)  warning_count,
            NVL(SUM(CASE WHEN e.max_violation_level =  MGMT_GLOBAL.G_SEVERITY_CRITICAL 
                            THEN e.non_exempt_violations_logged ELSE 0 END), 0) critical_count
        FROM mgmt_policy_assoc_eval_summ e,mgmt_policies p  
        WHERE EXISTS
            (SELECT 'x' FROM mgmt_targets t WHERE e.target_guid = t.target_guid and 
            t.target_type = target_type_in )
            AND e.non_exempt_violations_logged > 0
            AND p.policy_guid = e.policy_guid
            AND p.policy_type = MGMT_GLOBAL.G_TYPE_POLICY;
      
             
  -- metric thresholds  broken corrective action for a target type
  -- note: if there is no record, the cursor still contains one row 
  -- with count = 0
  OPEN mt_broken_ca_cur_out FOR
     SELECT count(unique(j.job_id)) AS count 
       FROM mgmt_job j, 
            mgmt_policy_assoc_cfg mpac, 
            mgmt_policies mp, 
            mgmt_targets mt 
       WHERE (j.job_id = mpac.crit_action_job_id OR 
              j.job_id = mpac.warn_action_job_id OR 
              j.job_id = mpac.info_action_job_id) 
         AND j.broken = 1 
         AND j.is_corrective_action = 1
         AND mp.policy_guid = mpac.policy_guid 
         AND mt.target_type = target_type_in 
         AND mpac.object_guid = mt.target_guid 
         AND mp.policy_type = MGMT_GLOBAL.G_TYPE_THRESHOLD_METRIC;

  -- policy broken corrective action
  -- note: if there is no record, the cursor still contains one row 
  -- with count = 0
      OPEN policy_broken_ca_cur_out FOR
          SELECT count(unique(j.job_id)) AS count
            FROM mgmt_job j ,
                 mgmt_corrective_action ca, 
                 mgmt_policy_assoc_cfg mpac, 
                 mgmt_policies mp, 
                 mgmt_targets mt 
            WHERE (j.job_id = mpac.crit_action_job_id OR 
                   j.job_id = mpac.warn_action_job_id OR 
                   j.job_id = mpac.info_action_job_id) 
              AND j.broken = 1 
              AND j.is_corrective_action =1 
              AND mp.policy_guid = mpac.policy_guid 
              AND mt.target_type = target_type_in
              AND mpac.object_guid = mt.target_guid 
              AND mp.policy_type = MGMT_GLOBAL.G_TYPE_POLICY;
  END IF;

  -- find the numbers of monitored and unconfigured targets
  OPEN num_targets_cur_out FOR
    SELECT broken_reason, COUNT(broken_reason) AS count
      FROM (SELECT DECODE(broken_reason, 0, 0, 
                                       256, 0, 1) AS broken_reason
              FROM mgmt_targets)
     GROUP BY broken_reason;

END get_console_homepage_info;

--
-- PROCEDURE: get_console_homepage_info_simp
--
-- PURPOSE:
--   This procedure returns information displayed in the console homepage
--     when in simplified mode to increase performance,
--
PROCEDURE get_console_homepage_info_simp(target_type_in IN VARCHAR2,
                                         num_targets_out OUT NUMBER,
                                         target_types_cur_out OUT cursorType,
                                         avail_cur_out OUT cursorType) IS

BEGIN
  -- initialize out parameters
  num_targets_out := 0;

  -- find the target types the user can see
  OPEN target_types_cur_out FOR
    SELECT t.target_type, tt.type_display_name,
           NVL2(tp.target_type, 1, 0) AS is_group
      FROM (SELECT DISTINCT target_type
              FROM mgmt_targets) t,
           mgmt_target_types tt,
           (SELECT DISTINCT target_type
              FROM mgmt_type_properties
             WHERE property_name = MGMT_GLOBAL.G_IS_GROUP_PROP
               AND property_value = '1') tp
     WHERE t.target_type = tt.target_type
       AND t.target_type = tp.target_type (+)
     ORDER BY tt.type_display_name;

  -- availability and target count for all target types
  IF(target_type_in IS NULL)
  THEN
    -- find the number of targets
    SELECT COUNT(target_guid) INTO num_targets_out
      FROM mgmt_targets;

    -- availability but exclude group targets 
    OPEN avail_cur_out FOR
      SELECT /*+ USE_HASH (tgt avail)*/ 
              nvl(current_status,MGMT_GLOBAL.G_STATUS_UNKNOWN) AS current_status, 
              count(*) AS count 
        FROM    mgmt_current_availability avail, 
                mgmt_targets tgt 
       WHERE  avail.current_status != 0 AND 
               tgt.is_group = 0     AND 
               avail.target_guid(+) = tgt.target_guid 
      GROUP BY avail.current_status 
      UNION ALL 
      SELECT  /*+ USE_HASH (tgt avail)*/ current_status, 
                count(tgt.target_name) AS count 
        FROM    mgmt_current_availability avail, 
                mgmt_targets tgt, 
                (SELECT severity.target_guid, met.metric_name, met.metric_column, 
                        severity.key_value, severity.severity_code, severity.severity_guid, 
                        severity.message, severity.message_nlsid, severity.message_params, 
                        met.type_meta_ver, met.category_prop_1, met.category_prop_2, 
                        met.category_prop_3, met.category_prop_4, met.category_prop_5 
                  FROM  mgmt_metrics met, mgmt_current_severity severity 
                 WHERE  met.metric_name  = MGMT_GLOBAL.G_AVAIL_METRIC_NAME AND 
                        met.metric_column  = MGMT_GLOBAL.G_AVAIL_METRIC_COLUMN AND 
                        severity.metric_guid  = met.metric_guid AND 
                        severity.severity_code = MGMT_GLOBAL.G_SEVERITY_CRITICAL 
                  ) sev 
      WHERE   avail.current_status = MGMT_GLOBAL.G_STATUS_DOWN     AND 
              tgt.is_group = 0  AND 
              tgt.target_guid = avail.target_guid  AND 
              tgt.target_guid = sev.target_guid (+)  AND 
              sev.type_meta_ver = tgt.type_meta_ver AND 
              (sev.category_prop_1 = ' ' OR sev.category_prop_1 = tgt.category_prop_1) AND 
              (sev.category_prop_2 = ' ' OR sev.category_prop_2 = tgt.category_prop_2) AND 
              (sev.category_prop_3 = ' ' OR sev.category_prop_3 = tgt.category_prop_3) AND 
              (sev.category_prop_4 = ' ' OR sev.category_prop_4 = tgt.category_prop_4) AND 
              (sev.category_prop_5 = ' ' OR sev.category_prop_5 = tgt.category_prop_5) 
      GROUP BY avail.current_status;

  -- for a specific target type
  ELSE
    -- find the number of targets of the specific type
    SELECT COUNT(*) INTO num_targets_out
      FROM mgmt_targets
     WHERE target_type = target_type_in;

    -- availability
    OPEN avail_cur_out FOR
      SELECT /*+ USE_HASH (tgt avail)*/ current_status, count(*) AS count
    FROM    mgmt_current_availability avail,
            mgmt_targets tgt
    WHERE   avail.current_status =MGMT_GLOBAL.G_STATUS_UP AND
            tgt.is_group = 0 AND
            avail.target_guid = tgt.target_guid AND
            tgt.target_type = target_type_in
    GROUP BY avail.current_status
    UNION ALL
    SELECT /*+ USE_HASH (tgt avail)*/
            nvl(current_status,MGMT_GLOBAL.G_STATUS_UNKNOWN) AS current_status,
            count(*) AS count
    FROM    mgmt_current_availability avail,
            mgmt_targets tgt
    WHERE   avail.current_status  IN (MGMT_GLOBAL.G_STATUS_ERROR,
                                      MGMT_GLOBAL.G_STATUS_AGENT_DOWN,
                                      MGMT_GLOBAL.G_STATUS_UNREACHABLE,
                                      MGMT_GLOBAL.G_STATUS_UNKNOWN ) AND
            tgt.is_group = 0 AND
            avail.target_guid(+) = tgt.target_guid AND
            tgt.target_type = target_type_in
    GROUP BY avail.current_status
    UNION ALL
    SELECT /*+ USE_HASH (tgt avail)*/ current_status, count(*) AS count
    FROM    mgmt_current_availability avail,
            mgmt_targets tgt
    WHERE   avail.current_status = MGMT_GLOBAL.G_STATUS_BLACKOUT AND
            tgt.is_group = 0 AND
            avail.target_guid = tgt.target_guid AND
            tgt.target_type = target_type_in
    GROUP BY avail.current_status
    UNION ALL
    SELECT  /*+ USE_HASH (tgt avail)*/ current_status, count(tgt.target_name) AS count
    FROM    mgmt_current_availability avail,
            mgmt_targets tgt,
            (SELECT   /*+ ORDERED INDEX(met) */
             DISTINCT severity.target_guid, met.metric_name, met.metric_column,
                      severity.key_value, severity.severity_code, severity.severity_guid,
                      severity.message, severity.message_nlsid, severity.message_params,
                      met.type_meta_ver, met.category_prop_1, met.category_prop_2,
                      met.category_prop_3, met.category_prop_4, met.category_prop_5
             FROM     mgmt_metrics met, mgmt_current_severity severity
             WHERE    met.metric_name        = MGMT_GLOBAL.G_AVAIL_METRIC_NAME AND
                      met.metric_column      = MGMT_GLOBAL.G_AVAIL_METRIC_COLUMN AND
                      severity.metric_guid   = met.metric_guid AND
                      severity.severity_code = MGMT_GLOBAL.G_SEVERITY_CRITICAL
                  ) sev
    WHERE   avail.current_status = MGMT_GLOBAL.G_STATUS_DOWN     AND
            tgt.is_group = 0  AND
            tgt.target_guid = avail.target_guid  AND
            tgt.target_guid = sev.target_guid (+)  AND
            tgt.target_type = target_type_in AND
            sev.type_meta_ver = tgt.type_meta_ver AND
            (sev.category_prop_1 = ' ' OR sev.category_prop_1 = tgt.category_prop_1) AND
            (sev.category_prop_2 = ' ' OR sev.category_prop_2 = tgt.category_prop_2) AND
            (sev.category_prop_3 = ' ' OR sev.category_prop_3 = tgt.category_prop_3) AND
            (sev.category_prop_4 = ' ' OR sev.category_prop_4 = tgt.category_prop_4) AND
            (sev.category_prop_5 = ' ' OR sev.category_prop_5 = tgt.category_prop_5)
    GROUP BY avail.current_status;
  END IF;
END get_console_homepage_info_simp;

--
-- PROCEDURE: get_group_homepage_info
--
-- PURPOSE:
--   This procedure returns information displayed in the group homepage.
--
PROCEDURE get_group_homepage_info(  target_name_in IN VARCHAR2,
                        target_type_in IN VARCHAR2,
                                    num_group_targets_out OUT NUMBER,
                                    avail_cur_out OUT cursorType,
                                    severity_cur_out OUT cursorType,
                                    metric_error_cur_out OUT cursorType,
                                    num_targets_cur_out OUT cursorType) IS
                                    
  l_target_guid mgmt_targets.target_guid%TYPE;

BEGIN
  -- initialize out parameters
  num_group_targets_out := 0;

  /*        
      Store the target guid to improve performance.
  */
  SELECT target_guid 
     INTO l_target_guid
     FROM mgmt_targets t
         WHERE t.target_name = target_name_in
         AND t.target_type = target_type_in;

  -- availability, severity, and metric error
  -- for all target types
  -- availability but exclude group targets 

    OPEN avail_cur_out FOR
      SELECT NVL(avail.current_status, MGMT_GLOBAL.G_STATUS_UNKNOWN) AS current_status,
             COUNT(*) AS count
        FROM  mgmt_flat_target_assoc members, mgmt_targets tgt, mgmt_current_availability avail
        WHERE members.source_target_guid=l_target_guid
        AND members.assoc_target_guid = tgt.target_guid
        AND tgt.is_group = 0
        AND members.is_membership = 1
        AND members.assoc_target_guid = avail.target_guid (+)
       GROUP BY avail.current_status;

    -- find the number of group targets
    SELECT COUNT(*) INTO num_group_targets_out 
      FROM mgmt_flat_target_assoc members, mgmt_targets t
      WHERE members.source_target_guid=l_target_guid 
      AND members.assoc_target_guid = t.target_guid
      AND members.is_membership = 1
      AND t.is_group = 1;

    -- severity
    OPEN severity_cur_out FOR
     SELECT sev.severity_code, COUNT(*) AS count
                FROM mgmt_flat_target_assoc members,
                     mgmt_current_severity sev
                WHERE members.source_target_guid=l_target_guid
                AND members.assoc_target_guid=sev.target_guid
                AND members.is_membership = 1
               GROUP BY sev.severity_code;

    -- metric error
    -- note: if there is no record, the cursor still contains one row 
    -- with count = 0
    OPEN metric_error_cur_out FOR
      SELECT COUNT(*) AS count
        FROM mgmt_flat_target_assoc members, mgmt_current_metric_errors err
       WHERE members.source_target_guid=l_target_guid 
       AND members.is_membership = 1
       AND members.assoc_target_guid = err.target_guid;


  -- find the numbers of monitored and unconfigured targets
  OPEN num_targets_cur_out FOR
    SELECT broken_reason, COUNT(broken_reason) AS count
      FROM (SELECT DECODE(broken_reason, 0, 0, 
                                       256, 0, 1) AS broken_reason
              FROM mgmt_targets)
     GROUP BY broken_reason;

END get_group_homepage_info;

--
-- PROCEDURE: get_subtab_preferred_cols
--
-- PURPOSE:
--   This procedure returns the a cursor containing the columns to be displayed
-- for EM sub-tabs (i.e. "All Targets", "Groups", etc.). The set of return
-- columns contains either the user preferences or the default preferences (in
-- case the user has no preferences set).
--
PROCEDURE get_subtab_preferred_cols(subtab_name_in IN VARCHAR2,
                                    case_in NUMBER,
                                    user_name_in IN VARCHAR2 DEFAULT NULL,
                                    user_alias_in IN VARCHAR2 DEFAULT NULL,
                                    pref_cols_out OUT cursorType) IS
  l_user_alias VARCHAR2(256);
  l_user_name  VARCHAR2(256);
  l_pref_count NUMBER(3);
BEGIN
  l_user_name  := user_name_in;
  l_user_alias := user_alias_in;

  IF(l_user_alias IS NULL)THEN
    IF(l_user_name IS NULL)THEN
      -- get the current user name from sys context
      l_user_name := UPPER(mgmt_user.get_current_em_user());
    END IF;
    -- find the alias for the current user
    l_user_alias := mgmt_user.get_subtab_prefs_alias(l_user_name,
                                                     subtab_name_in);
  END IF;

  IF (case_in = 2) THEN

    SELECT COUNT(1) INTO l_pref_count
      FROM mgmt_user_subtab_col_prefs
     WHERE user_name = l_user_alias
       AND subtab_name = subtab_name_in;

    IF (l_pref_count != 0) THEN  -- The folder (or user) have preferences
      -- Folders where only one tgt type is displayed. In these cases the subtab
      -- name is the target type.
      -- The query consists of 3 sub-queries "unioned" together. Each sub-query
      -- fetches one of the three categories of columns (generic, properties,
      -- metrics). All columns are fetched according to the preferences (which
      -- are fetched up front using a with clause).
      OPEN pref_cols_out FOR
      WITH prefs AS
      (
        SELECT user_name, subtab_name, display_order, column_id_guid, column_id,
               column_type
          FROM mgmt_user_subtab_col_prefs
         WHERE user_name = l_user_alias
           AND subtab_name = subtab_name_in
      )
      SELECT column_id AS "col_id_p1",
             NULL AS "col_id_p2",
             NULL AS "col_id_p3",
             NULL AS "col_id_p4",
             NULL AS "col_id_p5",
             column_type AS "col_type",
             display_order AS "DISPLAY_ORDER"
        FROM prefs
       WHERE column_type = 2
       UNION
      SELECT column_id AS "col_id_p1", 
             property_display_name AS "col_id_p2",
             property_display_nlsid AS "col_id_p3",
             NULL AS "col_id_p4",
             NULL AS "col_id_p5",
             column_type AS "col_type",
             display_order AS "DISPLAY_ORDER"
        FROM prefs, mgmt_target_prop_defs props
       WHERE prefs.column_type = 1
         AND props.property_type = 'INSTANCE'
         AND props.hidden_flag = 0
         AND props.target_type = subtab_name_in
         AND props.target_type = prefs.subtab_name
         AND props.property_name = prefs.column_id
       UNION
      SELECT DISTINCT RAWTOHEX(met.metric_guid) AS "col_id_p1", 
             met.metric_name AS "col_id_p2",
             met.metric_column AS "col_id_p3",
             met.short_name AS "col_id_p4", 
             met.short_name_nlsid AS "col_id_p5",
             column_type AS "col_type",
             display_order AS "DISPLAY_ORDER"
        FROM prefs, mgmt_metrics met 
       WHERE prefs.column_type = 0
         AND met.metric_guid = prefs.column_id_guid
         AND met.metric_type = 0
         AND met.is_for_summary = 1
       ORDER BY display_order;

    ELSE

      -- Folders where only one tgt type is displayed. In these cases the subtab
      -- name is the target type.
      -- The query consists of 2 sub-queries "unioned" together. Each sub-query
      -- fetches one of two categories of columns (generic, metrics).
      OPEN pref_cols_out FOR
      SELECT "col_id_p1", "col_id_p2", "col_id_p3", "col_id_p4", "col_id_p5",
              "col_type", ROWNUM AS "display_order"
      FROM
      (
        SELECT emd_pref.MGMT_USER_PREF_AVAIL_COL AS "col_id_p1",
               NULL AS "col_id_p2",
               NULL AS "col_id_p3",
               NULL AS "col_id_p4",
               NULL AS "col_id_p5",
               2 AS "col_type",
               0 AS "order_col"
          FROM dual
         UNION ALL
        SELECT emd_pref.MGMT_USER_PREF_ALERTS_COL AS "col_id_p1",
               NULL AS "col_id_p2",
               NULL AS "col_id_p3",
               NULL AS "col_id_p4",
               NULL AS "col_id_p5",
               2 AS "col_type",
               1 AS "order_col"
          FROM dual
         UNION ALL
        SELECT DISTINCT RAWTOHEX(met.metric_guid) AS "col_id_p1", 
               met.metric_name AS "col_id_p2",
               met.metric_column AS "col_id_p3",
               met.short_name AS "col_id_p4", 
               met.short_name_nlsid AS "col_id_p5",
               0 AS "col_type",
               2 AS "order_col"
          FROM mgmt_metrics met 
         WHERE met.metric_type = 0
           AND met.is_for_summary = 1
           AND met.target_type = subtab_name_in
         ORDER BY "order_col", "col_id_p1"
       );
     END IF;
  ELSE -- (case IN {1, 4, 5, 6, 7})
    -- Folders where types are mixed (no tgt type specific props or metrics)
    -- The query consists of 2 sub-queries "unioned" together. Each sub-query
    -- fetches one of the two categories of columns allowed for sub-tabs that
    -- mix target types (generic, global properties). All columns are fetched 
    -- according to the preferences (which are fetched up front using a with 
    -- clause).
    OPEN pref_cols_out FOR
    WITH prefs AS
    (
      SELECT user_name, subtab_name, display_order, column_id_guid, column_id,
             column_type
        FROM mgmt_user_subtab_col_prefs
       WHERE user_name = l_user_alias
         AND subtab_name = subtab_name_in
  
    )
    SELECT column_id AS "col_id_p1",
           NULL AS "col_id_p2",
           NULL AS "col_id_p3",
           NULL AS "col_id_p4",
           NULL AS "col_id_p5",
           column_type AS "col_type",
           display_order AS "DISPLAY_ORDER"
      FROM prefs
     WHERE column_type = 2
    UNION
    SELECT column_id AS "col_id_p1", 
           property_display_name AS "col_id_p2",
           property_display_nlsid AS "col_id_p3",
           NULL AS "col_id_p4",
           NULL AS "col_id_p5",
           column_type AS "col_type",
           display_order AS "DISPLAY_ORDER"
      FROM prefs, mgmt_all_target_props props
     WHERE prefs.column_type = 1
       AND props.property_type = 'INSTANCE'
       AND props.hidden_flag = 0
       AND props.property_name = prefs.column_id
     ORDER BY DISPLAY_ORDER;
  END IF;

END get_subtab_preferred_cols;

FUNCTION get_simple_targets(tgt_types_srch_lst_in IN SMP_EMD_STRING_ARRAY DEFAULT NULL,
                            target_name_in        IN VARCHAR2 DEFAULT NULL)
RETURN SMP_EMD_TGT_OBJECT_TBL
IS
    l_tgt_array SMP_EMD_TGT_OBJECT_TBL := 
        SMP_EMD_TGT_OBJECT_TBL();
BEGIN
    IF (target_name_in IS NULL)
    THEN
        IF (tgt_types_srch_lst_in IS NOT NULL AND 
              tgt_types_srch_lst_in.COUNT > 0)
        THEN

            SELECT SMP_EMD_TGT_OBJECT(tgt.target_name,
                   tgt.target_type,
                   tgt.target_guid,
                   tgt.display_name,
                   tgt.type_display_name,
                   tgt.host_name)
            BULK COLLECT INTO l_tgt_array
            FROM mgmt_targets tgt
            WHERE target_type IN 
                  (SELECT /*+ CARDINALITY(tgttypestab 10) */ column_value
                   FROM TABLE(CAST(tgt_types_srch_lst_in AS SMP_EMD_STRING_ARRAY))tgttypestab);
       ELSE
            SELECT SMP_EMD_TGT_OBJECT(tgt.target_name,
                   tgt.target_type,
                   tgt.target_guid,
                   tgt.display_name,
                   tgt.type_display_name,
                   tgt.host_name)
            BULK COLLECT INTO l_tgt_array
            FROM mgmt_targets tgt;
      END IF;
    ELSE
        IF (tgt_types_srch_lst_in IS NOT NULL AND 
          tgt_types_srch_lst_in.COUNT > 0)
        THEN
            SELECT SMP_EMD_TGT_OBJECT(tgt.target_name,
                   tgt.target_type,
                   tgt.target_guid,
                   tgt.display_name,
                   tgt.type_display_name,
                   tgt.host_name)
            BULK COLLECT INTO l_tgt_array
            FROM mgmt_targets tgt
            WHERE tgt.target_type IN 
                  (SELECT /*+ CARDINALITY(tgttypestab 10) */ column_value
                   FROM TABLE(CAST(tgt_types_srch_lst_in AS SMP_EMD_STRING_ARRAY))tgttypestab)
               AND (NLS_UPPER(tgt.target_name) LIKE NLS_UPPER(target_name_in) ESCAPE '#');
        ELSE
            SELECT SMP_EMD_TGT_OBJECT(tgt.target_name,
                   tgt.target_type,
                   tgt.target_guid,
                   tgt.display_name,
                   tgt.type_display_name,
                   tgt.host_name)
            BULK COLLECT INTO l_tgt_array
            FROM mgmt_targets tgt
            WHERE (NLS_UPPER(tgt.target_name) LIKE NLS_UPPER(target_name_in) ESCAPE '#');
        END IF;
    END IF;
    RETURN l_tgt_array;
END get_simple_targets;

/*
  a -> location_in
  b -> lob_in
  c -> deployment_in
  d -> comment_in
  e -> contact_in
*/

FUNCTION get_targets( search_query_in       IN VARCHAR2,
                      search_mode_in        IN VARCHAR2,
                      tgt_types_srch_lst_in IN SMP_EMD_STRING_ARRAY DEFAULT NULL, 
                      target_name_in        IN VARCHAR2 DEFAULT NULL,      
                      location_in           IN VARCHAR2 DEFAULT NULL,
                      lob_in                IN VARCHAR2 DEFAULT NULL, 
                      deployment_in         IN VARCHAR2 DEFAULT NULL,
                      comment_in            IN VARCHAR2 DEFAULT NULL,
                      contact_in            IN VARCHAR2 DEFAULT NULL)
RETURN SMP_EMD_TGT_OBJECT_TBL
IS
    l_targets_details_cur SYS_REFCURSOR;
    l_tgt_array    SMP_EMD_TGT_OBJECT_TBL := SMP_EMD_TGT_OBJECT_TBL();
    l_target_name_in mgmt_targets.target_name%TYPE := target_name_in;
    l_tgt_types_srch_lst SMP_EMD_STRING_ARRAY := tgt_types_srch_lst_in;
BEGIN
    IF (search_query_in IS NOT NULL)
    THEN
        IF (search_mode_in = '0') -- simple search
        THEN
            l_tgt_array := get_simple_targets(tgt_types_srch_lst_in => tgt_types_srch_lst_in,
                                              target_name_in => target_name_in );
        ELSIF (search_mode_in = '1') -- advanced search
        THEN
            IF (location_in  IS NULL 
                 AND lob_in IS NULL
                 AND deployment_in IS NULL
                 AND comment_in IS NULL
                 AND contact_in IS NULL)
            THEN
                l_tgt_array := get_simple_targets(tgt_types_srch_lst_in => tgt_types_srch_lst_in,
                                                  target_name_in => target_name_in );
            ELSE
                IF (l_tgt_types_srch_lst IS NULL OR l_tgt_types_srch_lst.COUNT = 0)
                THEN
                    SELECT DISTINCT target_type
                    BULK COLLECT INTO l_tgt_types_srch_lst
                    FROM mgmt_targets;
                END IF;
                IF (l_target_name_in IS NULL)
                THEN
                    l_target_name_in := '%';
                END IF;                     
                IF ((location_in IS NOT NULL) --a
                   AND (lob_in IS NULL
                     AND deployment_in IS NULL
                     AND comment_in IS NULL
                     AND contact_in IS NULL))
                THEN
                    WITH props AS (SELECT property_name, 
                                          property_value, 
                                          target_guid
                                    FROM mgmt_target_properties 
                                    WHERE property_type = emd_mntr.INSTANCE_PPROP
                                      AND property_name IN( emd_mntr.DEPLOYMENT_PROP, 
                                                            emd_mntr.LOCATION_PROP,
                                                            emd_mntr.CONTACT_PROP,
                                                            emd_mntr.LOB_PROP,
                                                            emd_mntr.COMMENT_PROP)
                                      AND ((NLS_UPPER(property_value) LIKE NLS_UPPER(location_in) ESCAPE '#' )))
                    SELECT /*+ CARDINALITY(tgttypestab 10) */ SMP_EMD_TGT_OBJECT(tgt.target_name,
                           tgt.target_type,
                           tgt.target_guid,
                           tgt.display_name,
                           tgt.type_display_name,
                           tgt.host_name)
                    BULK COLLECT INTO l_tgt_array
                    FROM mgmt_targets tgt, 
                        TABLE(CAST(l_tgt_types_srch_lst AS SMP_EMD_STRING_ARRAY))tgttypestab,
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.DEPLOYMENT_PROP ) prop1, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.LOCATION_PROP) prop2, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.CONTACT_PROP) prop3, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.LOB_PROP) prop4, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.COMMENT_PROP) prop5
                    WHERE prop1.target_guid(+) = tgt.target_guid 
                      AND prop2.target_guid(+) = tgt.target_guid 
                      AND prop3.target_guid(+) = tgt.target_guid 
                      AND prop4.target_guid(+) = tgt.target_guid 
                      AND prop5.target_guid(+) = tgt.target_guid 
                      AND tgt.target_type = tgttypestab.column_value
                      AND (NLS_UPPER(prop2.property_value) LIKE NLS_UPPER(location_in) ESCAPE '#' ) 
                      AND (NLS_UPPER(target_name) LIKE NLS_UPPER(l_target_name_in) ESCAPE '#');
                ELSIF ((location_in IS NOT NULL AND --ab
                          lob_in IS NOT NULL)
                   AND (deployment_in IS NULL
                     AND comment_in IS NULL
                     AND contact_in IS NULL))
                THEN
                    WITH props AS (SELECT property_name, 
                                          property_value, 
                                          target_guid
                                    FROM mgmt_target_properties 
                                    WHERE property_type = emd_mntr.INSTANCE_PPROP
                                      AND property_name IN( emd_mntr.DEPLOYMENT_PROP, 
                                                            emd_mntr.LOCATION_PROP,
                                                            emd_mntr.CONTACT_PROP,
                                                            emd_mntr.LOB_PROP,
                                                            emd_mntr.COMMENT_PROP)
                                      AND ((NLS_UPPER(property_value) LIKE NLS_UPPER(location_in) ESCAPE '#' )
                                        OR (NLS_UPPER(property_value) LIKE NLS_UPPER(lob_in) ESCAPE '#')))
                    SELECT /*+ CARDINALITY(tgttypestab 10) */ SMP_EMD_TGT_OBJECT(tgt.target_name,
                           tgt.target_type,
                           tgt.target_guid,
                           tgt.display_name,
                           tgt.type_display_name,
                           tgt.host_name)
                    BULK COLLECT INTO l_tgt_array
                    FROM mgmt_targets tgt, 
                        TABLE(CAST(l_tgt_types_srch_lst AS SMP_EMD_STRING_ARRAY))tgttypestab,
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.DEPLOYMENT_PROP ) prop1, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.LOCATION_PROP) prop2, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.CONTACT_PROP) prop3, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.LOB_PROP) prop4, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.COMMENT_PROP) prop5
                    WHERE prop1.target_guid(+) = tgt.target_guid 
                      AND prop2.target_guid(+) = tgt.target_guid 
                      AND prop3.target_guid(+) = tgt.target_guid 
                      AND prop4.target_guid(+) = tgt.target_guid 
                      AND prop5.target_guid(+) = tgt.target_guid 
                      AND tgt.target_type = tgttypestab.column_value
                      AND (NLS_UPPER(prop2.property_value) LIKE NLS_UPPER(location_in) ESCAPE '#' )
                      AND (NLS_UPPER(prop4.property_value) LIKE NLS_UPPER(lob_in) ESCAPE '#' )
                      AND (NLS_UPPER(target_name) LIKE NLS_UPPER(l_target_name_in) ESCAPE '#');
                ELSIF ((location_in IS NOT NULL AND --abc
                          lob_in IS NOT NULL AND 
                          deployment_in IS NOT NULL)
                    AND (comment_in IS NULL
                     AND contact_in IS NULL))
                THEN
                    WITH props AS (SELECT property_name, 
                                          property_value, 
                                          target_guid
                                    FROM mgmt_target_properties 
                                    WHERE property_type = emd_mntr.INSTANCE_PPROP
                                      AND property_name IN( emd_mntr.DEPLOYMENT_PROP, 
                                                            emd_mntr.LOCATION_PROP,
                                                            emd_mntr.CONTACT_PROP,
                                                            emd_mntr.LOB_PROP,
                                                            emd_mntr.COMMENT_PROP)
                                    AND ((NLS_UPPER(property_value) LIKE NLS_UPPER(location_in) ESCAPE '#' )
                                        OR (NLS_UPPER(property_value) LIKE NLS_UPPER(lob_in) ESCAPE '#') 
                                        OR (NLS_UPPER(property_value) LIKE NLS_UPPER(deployment_in) ESCAPE '#' )))
                    SELECT /*+ CARDINALITY(tgttypestab 10) */ SMP_EMD_TGT_OBJECT(tgt.target_name,
                           tgt.target_type,
                           tgt.target_guid,
                           tgt.display_name,
                           tgt.type_display_name,
                           tgt.host_name)
                    BULK COLLECT INTO l_tgt_array
                    FROM mgmt_targets tgt, 
                        TABLE(CAST(l_tgt_types_srch_lst AS SMP_EMD_STRING_ARRAY))tgttypestab,
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.DEPLOYMENT_PROP ) prop1, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.LOCATION_PROP) prop2, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.CONTACT_PROP) prop3, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.LOB_PROP) prop4, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.COMMENT_PROP) prop5
                    WHERE prop1.target_guid(+) = tgt.target_guid 
                      AND prop2.target_guid(+) = tgt.target_guid 
                      AND prop3.target_guid(+) = tgt.target_guid 
                      AND prop4.target_guid(+) = tgt.target_guid 
                      AND prop5.target_guid(+) = tgt.target_guid 
                      AND tgt.target_type = tgttypestab.column_value
                      AND (NLS_UPPER(prop2.property_value) LIKE NLS_UPPER(location_in) ESCAPE '#' )
                      AND (NLS_UPPER(prop4.property_value) LIKE NLS_UPPER(lob_in) ESCAPE '#' )
                      AND (NLS_UPPER(prop1.property_value) LIKE NLS_UPPER(deployment_in) ESCAPE '#' )
                      AND (NLS_UPPER(target_name) LIKE NLS_UPPER(l_target_name_in) ESCAPE '#');
                ELSIF ((location_in IS NOT NULL AND --abcd
                          lob_in IS NOT NULL AND 
                          deployment_in IS NOT NULL AND
                          comment_in IS NOT NULL)
                    AND (contact_in IS NULL))
                THEN
                    WITH props AS (SELECT property_name, 
                                          property_value, 
                                          target_guid
                                    FROM mgmt_target_properties 
                                    WHERE property_type = emd_mntr.INSTANCE_PPROP
                                      AND property_name IN( emd_mntr.DEPLOYMENT_PROP, 
                                                            emd_mntr.LOCATION_PROP,
                                                            emd_mntr.CONTACT_PROP,
                                                            emd_mntr.LOB_PROP,
                                                            emd_mntr.COMMENT_PROP)
                                    AND ((NLS_UPPER(property_value) LIKE NLS_UPPER(location_in) ESCAPE '#' )
                                        OR (NLS_UPPER(property_value) LIKE NLS_UPPER(lob_in) ESCAPE '#') 
                                        OR (NLS_UPPER(property_value) LIKE NLS_UPPER(deployment_in) ESCAPE '#' )
                                        OR (NLS_UPPER(property_value) LIKE NLS_UPPER(comment_in) ESCAPE '#' )))
                    SELECT /*+ CARDINALITY(tgttypestab 10) */ SMP_EMD_TGT_OBJECT(tgt.target_name,
                           tgt.target_type,
                           tgt.target_guid,
                           tgt.display_name,
                           tgt.type_display_name,
                           tgt.host_name)
                    BULK COLLECT INTO l_tgt_array
                    FROM mgmt_targets tgt, 
                        TABLE(CAST(l_tgt_types_srch_lst AS SMP_EMD_STRING_ARRAY))tgttypestab,
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.DEPLOYMENT_PROP ) prop1, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.LOCATION_PROP) prop2, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.CONTACT_PROP) prop3, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.LOB_PROP) prop4, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.COMMENT_PROP) prop5
                    WHERE prop1.target_guid(+) = tgt.target_guid 
                      AND prop2.target_guid(+) = tgt.target_guid 
                      AND prop3.target_guid(+) = tgt.target_guid 
                      AND prop4.target_guid(+) = tgt.target_guid 
                      AND prop5.target_guid(+) = tgt.target_guid 
                      AND tgt.target_type = tgttypestab.column_value
                      AND (NLS_UPPER(prop2.property_value) LIKE NLS_UPPER(location_in) ESCAPE '#' )
                      AND (NLS_UPPER(prop4.property_value) LIKE NLS_UPPER(lob_in) ESCAPE '#' )
                      AND (NLS_UPPER(prop1.property_value) LIKE NLS_UPPER(deployment_in) ESCAPE '#' )
                      AND (NLS_UPPER(prop5.property_value) LIKE NLS_UPPER(comment_in) ESCAPE '#' )
                      AND (NLS_UPPER(target_name) LIKE NLS_UPPER(l_target_name_in) ESCAPE '#');
                ELSIF (location_in IS NOT NULL AND --abcde
                          lob_in IS NOT NULL AND 
                          deployment_in IS NOT NULL AND
                          comment_in IS NOT NULL AND 
                          contact_in IS NOT NULL)
                THEN
                    WITH props AS (SELECT property_name, 
                                          property_value, 
                                          target_guid
                                    FROM mgmt_target_properties 
                                    WHERE property_type = emd_mntr.INSTANCE_PPROP
                                      AND property_name IN( emd_mntr.DEPLOYMENT_PROP, 
                                                            emd_mntr.LOCATION_PROP,
                                                            emd_mntr.CONTACT_PROP,
                                                            emd_mntr.LOB_PROP,
                                                            emd_mntr.COMMENT_PROP)
                                    AND ((NLS_UPPER(property_value) LIKE NLS_UPPER(location_in) ESCAPE '#' )
                                        OR (NLS_UPPER(property_value) LIKE NLS_UPPER(lob_in) ESCAPE '#') 
                                        OR (NLS_UPPER(property_value) LIKE NLS_UPPER(deployment_in) ESCAPE '#' )
                                        OR (NLS_UPPER(property_value) LIKE NLS_UPPER(comment_in) ESCAPE '#' )
                                        OR (NLS_UPPER(property_value) LIKE NLS_UPPER(contact_in) ESCAPE '#' )))
                    SELECT /*+ CARDINALITY(tgttypestab 10) */ SMP_EMD_TGT_OBJECT(tgt.target_name,
                           tgt.target_type,
                           tgt.target_guid,
                           tgt.display_name,
                           tgt.type_display_name,
                           tgt.host_name)
                    BULK COLLECT INTO l_tgt_array
                    FROM mgmt_targets tgt, 
                        TABLE(CAST(l_tgt_types_srch_lst AS SMP_EMD_STRING_ARRAY))tgttypestab,
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.DEPLOYMENT_PROP ) prop1, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.LOCATION_PROP) prop2, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.CONTACT_PROP) prop3, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.LOB_PROP) prop4, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.COMMENT_PROP) prop5
                    WHERE prop1.target_guid(+) = tgt.target_guid 
                      AND prop2.target_guid(+) = tgt.target_guid 
                      AND prop3.target_guid(+) = tgt.target_guid 
                      AND prop4.target_guid(+) = tgt.target_guid 
                      AND prop5.target_guid(+) = tgt.target_guid 
                      AND tgt.target_type = tgttypestab.column_value
                      AND (NLS_UPPER(prop2.property_value) LIKE NLS_UPPER(location_in) ESCAPE '#' )
                      AND (NLS_UPPER(prop4.property_value) LIKE NLS_UPPER(lob_in) ESCAPE '#' )
                      AND (NLS_UPPER(prop1.property_value) LIKE NLS_UPPER(deployment_in) ESCAPE '#' )
                      AND (NLS_UPPER(prop5.property_value) LIKE NLS_UPPER(comment_in) ESCAPE '#' )
                      AND (NLS_UPPER(prop3.property_value) LIKE NLS_UPPER(contact_in) ESCAPE '#' )
                      AND (NLS_UPPER(target_name) LIKE NLS_UPPER(l_target_name_in) ESCAPE '#');
                ELSIF ((location_in IS NOT NULL AND --abce
                          lob_in IS NOT NULL AND 
                          deployment_in IS NOT NULL AND
                          contact_in IS NOT NULL)
                       AND (comment_in IS NULL))
                THEN
                    WITH props AS (SELECT property_name, 
                                          property_value, 
                                          target_guid
                                    FROM mgmt_target_properties 
                                    WHERE property_type = emd_mntr.INSTANCE_PPROP
                                      AND property_name IN( emd_mntr.DEPLOYMENT_PROP, 
                                                            emd_mntr.LOCATION_PROP,
                                                            emd_mntr.CONTACT_PROP,
                                                            emd_mntr.LOB_PROP,
                                                            emd_mntr.COMMENT_PROP)
                                    AND ((NLS_UPPER(property_value) LIKE NLS_UPPER(location_in) ESCAPE '#' )
                                        OR (NLS_UPPER(property_value) LIKE NLS_UPPER(lob_in) ESCAPE '#') 
                                        OR (NLS_UPPER(property_value) LIKE NLS_UPPER(deployment_in) ESCAPE '#' )
                                        OR (NLS_UPPER(property_value) LIKE NLS_UPPER(contact_in) ESCAPE '#' )))
                    SELECT /*+ CARDINALITY(tgttypestab 10) */ SMP_EMD_TGT_OBJECT(tgt.target_name,
                           tgt.target_type,
                           tgt.target_guid,
                           tgt.display_name,
                           tgt.type_display_name,
                           tgt.host_name)
                    BULK COLLECT INTO l_tgt_array
                    FROM mgmt_targets tgt, 
                        TABLE(CAST(l_tgt_types_srch_lst AS SMP_EMD_STRING_ARRAY))tgttypestab,
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.DEPLOYMENT_PROP ) prop1, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.LOCATION_PROP) prop2, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.CONTACT_PROP) prop3, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.LOB_PROP) prop4, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.COMMENT_PROP) prop5
                    WHERE prop1.target_guid(+) = tgt.target_guid 
                      AND prop2.target_guid(+) = tgt.target_guid 
                      AND prop3.target_guid(+) = tgt.target_guid 
                      AND prop4.target_guid(+) = tgt.target_guid 
                      AND prop5.target_guid(+) = tgt.target_guid 
                      AND tgt.target_type = tgttypestab.column_value
                      AND (NLS_UPPER(prop2.property_value) LIKE NLS_UPPER(location_in) ESCAPE '#' )
                      AND (NLS_UPPER(prop4.property_value) LIKE NLS_UPPER(lob_in) ESCAPE '#' )
                      AND (NLS_UPPER(prop1.property_value) LIKE NLS_UPPER(deployment_in) ESCAPE '#' )
                      AND (NLS_UPPER(prop3.property_value) LIKE NLS_UPPER(contact_in) ESCAPE '#' )
                      AND (NLS_UPPER(target_name) LIKE NLS_UPPER(l_target_name_in) ESCAPE '#');
                ELSIF ((location_in IS NOT NULL AND --abd
                          lob_in IS NOT NULL AND 
                          comment_in IS NOT NULL)
                      AND (deployment_in IS NULL
                         AND contact_in IS NULL))
                THEN
                    WITH props AS (SELECT property_name, 
                                          property_value, 
                                          target_guid
                                    FROM mgmt_target_properties 
                                    WHERE property_type = emd_mntr.INSTANCE_PPROP
                                      AND property_name IN( emd_mntr.DEPLOYMENT_PROP, 
                                                            emd_mntr.LOCATION_PROP,
                                                            emd_mntr.CONTACT_PROP,
                                                            emd_mntr.LOB_PROP,
                                                            emd_mntr.COMMENT_PROP)
                                    AND ((NLS_UPPER(property_value) LIKE NLS_UPPER(location_in) ESCAPE '#' )
                                        OR (NLS_UPPER(property_value) LIKE NLS_UPPER(lob_in) ESCAPE '#') 
                                        OR (NLS_UPPER(property_value) LIKE NLS_UPPER(comment_in) ESCAPE '#' )))
                    SELECT /*+ CARDINALITY(tgttypestab 10) */ SMP_EMD_TGT_OBJECT(tgt.target_name,
                           tgt.target_type,
                           tgt.target_guid,
                           tgt.display_name,
                           tgt.type_display_name,
                           tgt.host_name)
                    BULK COLLECT INTO l_tgt_array
                    FROM mgmt_targets tgt, 
                        TABLE(CAST(l_tgt_types_srch_lst AS SMP_EMD_STRING_ARRAY))tgttypestab,
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.DEPLOYMENT_PROP ) prop1, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.LOCATION_PROP) prop2, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.CONTACT_PROP) prop3, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.LOB_PROP) prop4, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.COMMENT_PROP) prop5
                    WHERE prop1.target_guid(+) = tgt.target_guid 
                      AND prop2.target_guid(+) = tgt.target_guid 
                      AND prop3.target_guid(+) = tgt.target_guid 
                      AND prop4.target_guid(+) = tgt.target_guid 
                      AND prop5.target_guid(+) = tgt.target_guid 
                      AND tgt.target_type = tgttypestab.column_value
                      AND (NLS_UPPER(prop2.property_value) LIKE NLS_UPPER(location_in) ESCAPE '#' )
                      AND (NLS_UPPER(prop4.property_value) LIKE NLS_UPPER(lob_in) ESCAPE '#' )
                      AND (NLS_UPPER(prop5.property_value) LIKE NLS_UPPER(comment_in) ESCAPE '#' )
                      AND (NLS_UPPER(target_name) LIKE NLS_UPPER(l_target_name_in) ESCAPE '#');
                ELSIF ((location_in IS NOT NULL AND --abde
                          lob_in IS NOT NULL AND 
                          comment_in IS NOT NULL AND 
                          contact_in IS NOT NULL)
                      AND (deployment_in IS NULL))
                THEN
                    WITH props AS (SELECT property_name, 
                                          property_value, 
                                          target_guid
                                    FROM mgmt_target_properties 
                                    WHERE property_type = emd_mntr.INSTANCE_PPROP
                                      AND property_name IN( emd_mntr.DEPLOYMENT_PROP, 
                                                            emd_mntr.LOCATION_PROP,
                                                            emd_mntr.CONTACT_PROP,
                                                            emd_mntr.LOB_PROP,
                                                            emd_mntr.COMMENT_PROP)
                                    AND ((NLS_UPPER(property_value) LIKE NLS_UPPER(location_in) ESCAPE '#' )
                                        OR (NLS_UPPER(property_value) LIKE NLS_UPPER(lob_in) ESCAPE '#') 
                                        OR (NLS_UPPER(property_value) LIKE NLS_UPPER(comment_in) ESCAPE '#' )
                                        OR (NLS_UPPER(property_value) LIKE NLS_UPPER(contact_in) ESCAPE '#' )))
                    SELECT /*+ CARDINALITY(tgttypestab 10) */ SMP_EMD_TGT_OBJECT(tgt.target_name,
                           tgt.target_type,
                           tgt.target_guid,
                           tgt.display_name,
                           tgt.type_display_name,
                           tgt.host_name)
                    BULK COLLECT INTO l_tgt_array
                    FROM mgmt_targets tgt, 
                        TABLE(CAST(l_tgt_types_srch_lst AS SMP_EMD_STRING_ARRAY))tgttypestab,
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.DEPLOYMENT_PROP ) prop1, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.LOCATION_PROP) prop2, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.CONTACT_PROP) prop3, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.LOB_PROP) prop4, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.COMMENT_PROP) prop5
                    WHERE prop1.target_guid(+) = tgt.target_guid 
                      AND prop2.target_guid(+) = tgt.target_guid 
                      AND prop3.target_guid(+) = tgt.target_guid 
                      AND prop4.target_guid(+) = tgt.target_guid 
                      AND prop5.target_guid(+) = tgt.target_guid 
                      AND tgt.target_type = tgttypestab.column_value
                      AND (NLS_UPPER(prop2.property_value) LIKE NLS_UPPER(location_in) ESCAPE '#' )
                      AND (NLS_UPPER(prop4.property_value) LIKE NLS_UPPER(lob_in) ESCAPE '#' )
                      AND (NLS_UPPER(prop5.property_value) LIKE NLS_UPPER(comment_in) ESCAPE '#' )
                      AND (NLS_UPPER(prop3.property_value) LIKE NLS_UPPER(contact_in) ESCAPE '#' )
                      AND (NLS_UPPER(target_name) LIKE NLS_UPPER(l_target_name_in) ESCAPE '#');
                ELSIF ((location_in IS NOT NULL AND --abe
                          lob_in IS NOT NULL AND 
                          contact_in IS NOT NULL)
                      AND (deployment_in IS NULL AND
                           comment_in IS NULL ))
                THEN
                    WITH props AS (SELECT property_name, 
                                          property_value, 
                                          target_guid
                                    FROM mgmt_target_properties 
                                    WHERE property_type = emd_mntr.INSTANCE_PPROP
                                      AND property_name IN( emd_mntr.DEPLOYMENT_PROP, 
                                                            emd_mntr.LOCATION_PROP,
                                                            emd_mntr.CONTACT_PROP,
                                                            emd_mntr.LOB_PROP,
                                                            emd_mntr.COMMENT_PROP)
                                    AND ((NLS_UPPER(property_value) LIKE NLS_UPPER(location_in) ESCAPE '#' )
                                        OR (NLS_UPPER(property_value) LIKE NLS_UPPER(lob_in) ESCAPE '#') 
                                        OR (NLS_UPPER(property_value) LIKE NLS_UPPER(contact_in) ESCAPE '#' )))
                    SELECT /*+ CARDINALITY(tgttypestab 10) */ SMP_EMD_TGT_OBJECT(tgt.target_name,
                           tgt.target_type,
                           tgt.target_guid,
                           tgt.display_name,
                           tgt.type_display_name,
                           tgt.host_name)
                    BULK COLLECT INTO l_tgt_array
                    FROM mgmt_targets tgt, 
                        TABLE(CAST(l_tgt_types_srch_lst AS SMP_EMD_STRING_ARRAY))tgttypestab,
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.DEPLOYMENT_PROP ) prop1, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.LOCATION_PROP) prop2, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.CONTACT_PROP) prop3, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.LOB_PROP) prop4, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.COMMENT_PROP) prop5
                    WHERE prop1.target_guid(+) = tgt.target_guid 
                      AND prop2.target_guid(+) = tgt.target_guid 
                      AND prop3.target_guid(+) = tgt.target_guid 
                      AND prop4.target_guid(+) = tgt.target_guid 
                      AND prop5.target_guid(+) = tgt.target_guid 
                      AND tgt.target_type = tgttypestab.column_value
                      AND (NLS_UPPER(prop2.property_value) LIKE NLS_UPPER(location_in) ESCAPE '#' )
                      AND (NLS_UPPER(prop4.property_value) LIKE NLS_UPPER(lob_in) ESCAPE '#' )
                      AND (NLS_UPPER(prop3.property_value) LIKE NLS_UPPER(contact_in) ESCAPE '#' )
                      AND (NLS_UPPER(target_name) LIKE NLS_UPPER(l_target_name_in) ESCAPE '#');
                ELSIF ((location_in IS NOT NULL AND --ac
                       deployment_in IS NOT NULL)
                   AND (lob_in IS NULL                     
                     AND comment_in IS NULL
                     AND contact_in IS NULL))
                THEN
                    WITH props AS (SELECT property_name, 
                                          property_value, 
                                          target_guid
                                    FROM mgmt_target_properties 
                                    WHERE property_type = emd_mntr.INSTANCE_PPROP
                                      AND property_name IN( emd_mntr.DEPLOYMENT_PROP, 
                                                            emd_mntr.LOCATION_PROP,
                                                            emd_mntr.CONTACT_PROP,
                                                            emd_mntr.LOB_PROP,
                                                            emd_mntr.COMMENT_PROP)
                                    AND ((NLS_UPPER(property_value) LIKE NLS_UPPER(location_in) ESCAPE '#' )
                                        OR (NLS_UPPER(property_value) LIKE NLS_UPPER(deployment_in) ESCAPE '#' )))
                    SELECT /*+ CARDINALITY(tgttypestab 10) */ SMP_EMD_TGT_OBJECT(tgt.target_name,
                           tgt.target_type,
                           tgt.target_guid,
                           tgt.display_name,
                           tgt.type_display_name,
                           tgt.host_name)
                    BULK COLLECT INTO l_tgt_array
                    FROM mgmt_targets tgt, 
                        TABLE(CAST(l_tgt_types_srch_lst AS SMP_EMD_STRING_ARRAY))tgttypestab,
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.DEPLOYMENT_PROP ) prop1, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.LOCATION_PROP) prop2, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.CONTACT_PROP) prop3, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.LOB_PROP) prop4, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.COMMENT_PROP) prop5
                    WHERE prop1.target_guid(+) = tgt.target_guid 
                      AND prop2.target_guid(+) = tgt.target_guid 
                      AND prop3.target_guid(+) = tgt.target_guid 
                      AND prop4.target_guid(+) = tgt.target_guid 
                      AND prop5.target_guid(+) = tgt.target_guid 
                      AND tgt.target_type = tgttypestab.column_value
                      AND (NLS_UPPER(prop2.property_value) LIKE NLS_UPPER(location_in) ESCAPE '#' )
                      AND (NLS_UPPER(prop1.property_value) LIKE NLS_UPPER(deployment_in) ESCAPE '#' )
                      AND (NLS_UPPER(target_name) LIKE NLS_UPPER(l_target_name_in) ESCAPE '#');
                ELSIF ((location_in IS NOT NULL AND --acd
                       deployment_in IS NOT NULL AND
                       comment_in IS NOT NULL)
                   AND (lob_in IS NULL
                     AND contact_in IS NULL))
                THEN
                    WITH props AS (SELECT property_name, 
                                          property_value, 
                                          target_guid
                                    FROM mgmt_target_properties 
                                    WHERE property_type = emd_mntr.INSTANCE_PPROP
                                      AND property_name IN( emd_mntr.DEPLOYMENT_PROP, 
                                                            emd_mntr.LOCATION_PROP,
                                                            emd_mntr.CONTACT_PROP,
                                                            emd_mntr.LOB_PROP,
                                                            emd_mntr.COMMENT_PROP)
                                    AND ((NLS_UPPER(property_value) LIKE NLS_UPPER(location_in) ESCAPE '#' )
                                        OR (NLS_UPPER(property_value) LIKE NLS_UPPER(deployment_in) ESCAPE '#' )
                                        OR (NLS_UPPER(property_value) LIKE NLS_UPPER(comment_in) ESCAPE '#' )))
                    SELECT /*+ CARDINALITY(tgttypestab 10) */ SMP_EMD_TGT_OBJECT(tgt.target_name,
                           tgt.target_type,
                           tgt.target_guid,
                           tgt.display_name,
                           tgt.type_display_name,
                           tgt.host_name)
                    BULK COLLECT INTO l_tgt_array
                    FROM mgmt_targets tgt, 
                        TABLE(CAST(l_tgt_types_srch_lst AS SMP_EMD_STRING_ARRAY))tgttypestab,
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.DEPLOYMENT_PROP ) prop1, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.LOCATION_PROP) prop2, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.CONTACT_PROP) prop3, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.LOB_PROP) prop4, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.COMMENT_PROP) prop5
                    WHERE prop1.target_guid(+) = tgt.target_guid 
                      AND prop2.target_guid(+) = tgt.target_guid 
                      AND prop3.target_guid(+) = tgt.target_guid 
                      AND prop4.target_guid(+) = tgt.target_guid 
                      AND prop5.target_guid(+) = tgt.target_guid 
                      AND tgt.target_type = tgttypestab.column_value
                      AND (NLS_UPPER(prop2.property_value) LIKE NLS_UPPER(location_in) ESCAPE '#' )
                      AND (NLS_UPPER(prop1.property_value) LIKE NLS_UPPER(deployment_in) ESCAPE '#' )
                      AND (NLS_UPPER(prop5.property_value) LIKE NLS_UPPER(comment_in) ESCAPE '#' )
                      AND (NLS_UPPER(target_name) LIKE NLS_UPPER(l_target_name_in) ESCAPE '#');
                ELSIF ((location_in IS NOT NULL AND --acde
                       deployment_in IS NOT NULL  AND
                       comment_in IS NOT NULL AND 
                       contact_in IS NOT NULL)
                   AND (lob_in IS NULL))
                THEN
                    WITH props AS (SELECT property_name, 
                                          property_value, 
                                          target_guid
                                    FROM mgmt_target_properties 
                                    WHERE property_type = emd_mntr.INSTANCE_PPROP
                                      AND property_name IN( emd_mntr.DEPLOYMENT_PROP, 
                                                            emd_mntr.LOCATION_PROP,
                                                            emd_mntr.CONTACT_PROP,
                                                            emd_mntr.LOB_PROP,
                                                            emd_mntr.COMMENT_PROP)
                                    AND ((NLS_UPPER(property_value) LIKE NLS_UPPER(location_in) ESCAPE '#' )
                                        OR (NLS_UPPER(property_value) LIKE NLS_UPPER(deployment_in) ESCAPE '#' )
                                        OR (NLS_UPPER(property_value) LIKE NLS_UPPER(comment_in) ESCAPE '#' )
                                        OR (NLS_UPPER(property_value) LIKE NLS_UPPER(contact_in) ESCAPE '#' )))
                    SELECT /*+ CARDINALITY(tgttypestab 10) */ SMP_EMD_TGT_OBJECT(tgt.target_name,
                           tgt.target_type,
                           tgt.target_guid,
                           tgt.display_name,
                           tgt.type_display_name,
                           tgt.host_name)
                    BULK COLLECT INTO l_tgt_array
                    FROM mgmt_targets tgt, 
                        TABLE(CAST(l_tgt_types_srch_lst AS SMP_EMD_STRING_ARRAY))tgttypestab,
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.DEPLOYMENT_PROP ) prop1, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.LOCATION_PROP) prop2, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.CONTACT_PROP) prop3, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.LOB_PROP) prop4, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.COMMENT_PROP) prop5
                    WHERE prop1.target_guid(+) = tgt.target_guid 
                      AND prop2.target_guid(+) = tgt.target_guid 
                      AND prop3.target_guid(+) = tgt.target_guid 
                      AND prop4.target_guid(+) = tgt.target_guid 
                      AND prop5.target_guid(+) = tgt.target_guid 
                      AND tgt.target_type = tgttypestab.column_value
                      AND (NLS_UPPER(prop2.property_value) LIKE NLS_UPPER(location_in) ESCAPE '#' )
                      AND (NLS_UPPER(prop1.property_value) LIKE NLS_UPPER(deployment_in) ESCAPE '#' )
                      AND (NLS_UPPER(prop5.property_value) LIKE NLS_UPPER(comment_in) ESCAPE '#' )
                      AND (NLS_UPPER(prop3.property_value) LIKE NLS_UPPER(contact_in) ESCAPE '#' )
                      AND (NLS_UPPER(target_name) LIKE NLS_UPPER(l_target_name_in) ESCAPE '#');
                ELSIF ((location_in IS NOT NULL AND --ace
                       deployment_in IS NOT NULL AND
                       contact_in IS NOT NULL)
                   AND (lob_in IS NULL AND 
                        comment_in IS NULL))
                THEN
                    WITH props AS (SELECT property_name, 
                                          property_value, 
                                          target_guid
                                    FROM mgmt_target_properties 
                                    WHERE property_type = emd_mntr.INSTANCE_PPROP
                                      AND property_name IN( emd_mntr.DEPLOYMENT_PROP, 
                                                            emd_mntr.LOCATION_PROP,
                                                            emd_mntr.CONTACT_PROP,
                                                            emd_mntr.LOB_PROP,
                                                            emd_mntr.COMMENT_PROP)
                                    AND ((NLS_UPPER(property_value) LIKE NLS_UPPER(location_in) ESCAPE '#' )
                                        OR (NLS_UPPER(property_value) LIKE NLS_UPPER(deployment_in) ESCAPE '#' )
                                        OR (NLS_UPPER(property_value) LIKE NLS_UPPER(contact_in) ESCAPE '#' )))
                    SELECT /*+ CARDINALITY(tgttypestab 10) */ SMP_EMD_TGT_OBJECT(tgt.target_name,
                           tgt.target_type,
                           tgt.target_guid,
                           tgt.display_name,
                           tgt.type_display_name,
                           tgt.host_name)
                    BULK COLLECT INTO l_tgt_array
                    FROM mgmt_targets tgt, 
                        TABLE(CAST(l_tgt_types_srch_lst AS SMP_EMD_STRING_ARRAY))tgttypestab,
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.DEPLOYMENT_PROP ) prop1, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.LOCATION_PROP) prop2, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.CONTACT_PROP) prop3, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.LOB_PROP) prop4, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.COMMENT_PROP) prop5
                    WHERE prop1.target_guid(+) = tgt.target_guid 
                      AND prop2.target_guid(+) = tgt.target_guid 
                      AND prop3.target_guid(+) = tgt.target_guid 
                      AND prop4.target_guid(+) = tgt.target_guid 
                      AND prop5.target_guid(+) = tgt.target_guid 
                      AND tgt.target_type = tgttypestab.column_value
                      AND (NLS_UPPER(prop2.property_value) LIKE NLS_UPPER(location_in) ESCAPE '#' )
                      AND (NLS_UPPER(prop1.property_value) LIKE NLS_UPPER(deployment_in) ESCAPE '#' )
                      AND (NLS_UPPER(prop3.property_value) LIKE NLS_UPPER(contact_in) ESCAPE '#' )
                      AND (NLS_UPPER(target_name) LIKE NLS_UPPER(l_target_name_in) ESCAPE '#');
                ELSIF ((location_in IS NOT NULL AND --ad
                       comment_in IS NOT NULL)
                   AND (lob_in IS NULL AND
                        deployment_in IS NULL AND
                        contact_in IS NULL))
                THEN
                    WITH props AS (SELECT property_name, 
                                          property_value, 
                                          target_guid
                                    FROM mgmt_target_properties 
                                    WHERE property_type = emd_mntr.INSTANCE_PPROP
                                      AND property_name IN( emd_mntr.DEPLOYMENT_PROP, 
                                                            emd_mntr.LOCATION_PROP,
                                                            emd_mntr.CONTACT_PROP,
                                                            emd_mntr.LOB_PROP,
                                                            emd_mntr.COMMENT_PROP)
                                    AND ((NLS_UPPER(property_value) LIKE NLS_UPPER(location_in) ESCAPE '#' )
                                        OR (NLS_UPPER(property_value) LIKE NLS_UPPER(comment_in) ESCAPE '#' )))
                    SELECT /*+ CARDINALITY(tgttypestab 10) */ SMP_EMD_TGT_OBJECT(tgt.target_name,
                           tgt.target_type,
                           tgt.target_guid,
                           tgt.display_name,
                           tgt.type_display_name,
                           tgt.host_name)
                    BULK COLLECT INTO l_tgt_array
                    FROM mgmt_targets tgt, 
                        TABLE(CAST(l_tgt_types_srch_lst AS SMP_EMD_STRING_ARRAY))tgttypestab,
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.DEPLOYMENT_PROP ) prop1, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.LOCATION_PROP) prop2, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.CONTACT_PROP) prop3, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.LOB_PROP) prop4, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.COMMENT_PROP) prop5
                    WHERE prop1.target_guid(+) = tgt.target_guid 
                      AND prop2.target_guid(+) = tgt.target_guid 
                      AND prop3.target_guid(+) = tgt.target_guid 
                      AND prop4.target_guid(+) = tgt.target_guid 
                      AND prop5.target_guid(+) = tgt.target_guid 
                      AND tgt.target_type = tgttypestab.column_value
                      AND (NLS_UPPER(prop2.property_value) LIKE NLS_UPPER(location_in) ESCAPE '#' )
                      AND (NLS_UPPER(prop5.property_value) LIKE NLS_UPPER(comment_in) ESCAPE '#' )
                      AND (NLS_UPPER(target_name) LIKE NLS_UPPER(l_target_name_in) ESCAPE '#');
                ELSIF ((location_in IS NOT NULL AND --ade
                       comment_in IS NOT NULL AND
                        contact_in IS NOT NULL)
                   AND (lob_in IS NULL AND
                        deployment_in IS NULL))
                THEN
                    WITH props AS (SELECT property_name, 
                                          property_value, 
                                          target_guid
                                    FROM mgmt_target_properties 
                                    WHERE property_type = emd_mntr.INSTANCE_PPROP
                                      AND property_name IN( emd_mntr.DEPLOYMENT_PROP, 
                                                            emd_mntr.LOCATION_PROP,
                                                            emd_mntr.CONTACT_PROP,
                                                            emd_mntr.LOB_PROP,
                                                            emd_mntr.COMMENT_PROP)
                                    AND ((NLS_UPPER(property_value) LIKE NLS_UPPER(location_in) ESCAPE '#' )
                                        OR (NLS_UPPER(property_value) LIKE NLS_UPPER(comment_in) ESCAPE '#' )
                                        OR (NLS_UPPER(property_value) LIKE NLS_UPPER(contact_in) ESCAPE '#' )))
                    SELECT /*+ CARDINALITY(tgttypestab 10) */ SMP_EMD_TGT_OBJECT(tgt.target_name,
                           tgt.target_type,
                           tgt.target_guid,
                           tgt.display_name,
                           tgt.type_display_name,
                           tgt.host_name)
                    BULK COLLECT INTO l_tgt_array
                    FROM mgmt_targets tgt, 
                        TABLE(CAST(l_tgt_types_srch_lst AS SMP_EMD_STRING_ARRAY))tgttypestab,
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.DEPLOYMENT_PROP ) prop1, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.LOCATION_PROP) prop2, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.CONTACT_PROP) prop3, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.LOB_PROP) prop4, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.COMMENT_PROP) prop5
                    WHERE prop1.target_guid(+) = tgt.target_guid 
                      AND prop2.target_guid(+) = tgt.target_guid 
                      AND prop3.target_guid(+) = tgt.target_guid 
                      AND prop4.target_guid(+) = tgt.target_guid 
                      AND prop5.target_guid(+) = tgt.target_guid 
                      AND tgt.target_type = tgttypestab.column_value
                      AND (NLS_UPPER(prop2.property_value) LIKE NLS_UPPER(location_in) ESCAPE '#' )
                      AND (NLS_UPPER(prop5.property_value) LIKE NLS_UPPER(comment_in) ESCAPE '#' )
                      AND (NLS_UPPER(prop3.property_value) LIKE NLS_UPPER(contact_in) ESCAPE '#' )
                      AND (NLS_UPPER(target_name) LIKE NLS_UPPER(l_target_name_in) ESCAPE '#');
                ELSIF ((location_in IS NOT NULL AND --ae
                        contact_in IS NOT NULL)
                   AND (lob_in IS NULL AND
                        deployment_in IS NULL AND
                        comment_in IS NULL ))
                THEN
                    WITH props AS (SELECT property_name, 
                                          property_value, 
                                          target_guid
                                    FROM mgmt_target_properties 
                                    WHERE property_type = emd_mntr.INSTANCE_PPROP
                                      AND property_name IN( emd_mntr.DEPLOYMENT_PROP, 
                                                            emd_mntr.LOCATION_PROP,
                                                            emd_mntr.CONTACT_PROP,
                                                            emd_mntr.LOB_PROP,
                                                            emd_mntr.COMMENT_PROP)
                                    AND ((NLS_UPPER(property_value) LIKE NLS_UPPER(location_in) ESCAPE '#' )
                                        OR (NLS_UPPER(property_value) LIKE NLS_UPPER(contact_in) ESCAPE '#' )))
                    SELECT /*+ CARDINALITY(tgttypestab 10) */ SMP_EMD_TGT_OBJECT(tgt.target_name,
                           tgt.target_type,
                           tgt.target_guid,
                           tgt.display_name,
                           tgt.type_display_name,
                           tgt.host_name)
                    BULK COLLECT INTO l_tgt_array
                    FROM mgmt_targets tgt, 
                        TABLE(CAST(l_tgt_types_srch_lst AS SMP_EMD_STRING_ARRAY))tgttypestab,
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.DEPLOYMENT_PROP ) prop1, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.LOCATION_PROP) prop2, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.CONTACT_PROP) prop3, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.LOB_PROP) prop4, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.COMMENT_PROP) prop5
                    WHERE prop1.target_guid(+) = tgt.target_guid 
                      AND prop2.target_guid(+) = tgt.target_guid 
                      AND prop3.target_guid(+) = tgt.target_guid 
                      AND prop4.target_guid(+) = tgt.target_guid 
                      AND prop5.target_guid(+) = tgt.target_guid 
                      AND tgt.target_type = tgttypestab.column_value
                      AND (NLS_UPPER(prop2.property_value) LIKE NLS_UPPER(location_in) ESCAPE '#' )
                      AND (NLS_UPPER(prop3.property_value) LIKE NLS_UPPER(contact_in) ESCAPE '#' )
                      AND (NLS_UPPER(target_name) LIKE NLS_UPPER(l_target_name_in) ESCAPE '#');
                ELSIF ((lob_in IS NOT NULL) --b
                   AND (location_in IS NULL
                     AND comment_in IS NULL
                     AND contact_in IS NULL AND
                         deployment_in IS NULL))
                THEN
                    WITH props AS (SELECT property_name, 
                                          property_value, 
                                          target_guid
                                    FROM mgmt_target_properties 
                                    WHERE property_type = emd_mntr.INSTANCE_PPROP
                                      AND property_name IN( emd_mntr.DEPLOYMENT_PROP, 
                                                            emd_mntr.LOCATION_PROP,
                                                            emd_mntr.CONTACT_PROP,
                                                            emd_mntr.LOB_PROP,
                                                            emd_mntr.COMMENT_PROP)
                                    AND ((NLS_UPPER(property_value) LIKE NLS_UPPER(lob_in) ESCAPE '#')))
                    SELECT /*+ CARDINALITY(tgttypestab 10) */ SMP_EMD_TGT_OBJECT(tgt.target_name,
                           tgt.target_type,
                           tgt.target_guid,
                           tgt.display_name,
                           tgt.type_display_name,
                           tgt.host_name)
                    BULK COLLECT INTO l_tgt_array
                    FROM mgmt_targets tgt, 
                        TABLE(CAST(l_tgt_types_srch_lst AS SMP_EMD_STRING_ARRAY))tgttypestab,
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.DEPLOYMENT_PROP ) prop1, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.LOCATION_PROP) prop2, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.CONTACT_PROP) prop3, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.LOB_PROP) prop4, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.COMMENT_PROP) prop5
                    WHERE prop1.target_guid(+) = tgt.target_guid 
                      AND prop2.target_guid(+) = tgt.target_guid 
                      AND prop3.target_guid(+) = tgt.target_guid 
                      AND prop4.target_guid(+) = tgt.target_guid 
                      AND prop5.target_guid(+) = tgt.target_guid 
                      AND tgt.target_type = tgttypestab.column_value
                      AND (NLS_UPPER(prop4.property_value) LIKE NLS_UPPER(lob_in) ESCAPE '#' )
                      AND (NLS_UPPER(target_name) LIKE NLS_UPPER(l_target_name_in) ESCAPE '#');
                ELSIF ((lob_in IS NOT NULL AND --bc
                    deployment_in IS NOT NULL)
                   AND (location_in IS NULL
                     AND comment_in IS NULL
                     AND contact_in IS NULL))
                THEN
                    WITH props AS (SELECT property_name, 
                                          property_value, 
                                          target_guid
                                    FROM mgmt_target_properties 
                                    WHERE property_type = emd_mntr.INSTANCE_PPROP
                                      AND property_name IN( emd_mntr.DEPLOYMENT_PROP, 
                                                            emd_mntr.LOCATION_PROP,
                                                            emd_mntr.CONTACT_PROP,
                                                            emd_mntr.LOB_PROP,
                                                            emd_mntr.COMMENT_PROP)
                                    AND ((NLS_UPPER(property_value) LIKE NLS_UPPER(lob_in) ESCAPE '#' )
                                        OR (NLS_UPPER(property_value) LIKE NLS_UPPER(deployment_in) ESCAPE '#' )))
                    SELECT /*+ CARDINALITY(tgttypestab 10) */ SMP_EMD_TGT_OBJECT(tgt.target_name,
                           tgt.target_type,
                           tgt.target_guid,
                           tgt.display_name,
                           tgt.type_display_name,
                           tgt.host_name)
                    BULK COLLECT INTO l_tgt_array
                    FROM mgmt_targets tgt, 
                        TABLE(CAST(l_tgt_types_srch_lst AS SMP_EMD_STRING_ARRAY))tgttypestab,
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.DEPLOYMENT_PROP ) prop1, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.LOCATION_PROP) prop2, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.CONTACT_PROP) prop3, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.LOB_PROP) prop4, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.COMMENT_PROP) prop5
                    WHERE prop1.target_guid(+) = tgt.target_guid 
                      AND prop2.target_guid(+) = tgt.target_guid 
                      AND prop3.target_guid(+) = tgt.target_guid 
                      AND prop4.target_guid(+) = tgt.target_guid 
                      AND prop5.target_guid(+) = tgt.target_guid 
                      AND tgt.target_type = tgttypestab.column_value
                      AND (NLS_UPPER(prop4.property_value) LIKE NLS_UPPER(lob_in) ESCAPE '#' )
                      AND (NLS_UPPER(prop1.property_value) LIKE NLS_UPPER(deployment_in) ESCAPE '#' )
                      AND (NLS_UPPER(target_name) LIKE NLS_UPPER(l_target_name_in) ESCAPE '#');
                ELSIF ((lob_in IS NOT NULL AND --bcd
                    deployment_in IS NOT NULL AND 
                    comment_in IS NOT NULL)
                   AND (location_in IS NULL
                     AND contact_in IS NULL))
                THEN
                    WITH props AS (SELECT property_name, 
                                          property_value, 
                                          target_guid
                                    FROM mgmt_target_properties 
                                    WHERE property_type = emd_mntr.INSTANCE_PPROP
                                      AND property_name IN( emd_mntr.DEPLOYMENT_PROP, 
                                                            emd_mntr.LOCATION_PROP,
                                                            emd_mntr.CONTACT_PROP,
                                                            emd_mntr.LOB_PROP,
                                                            emd_mntr.COMMENT_PROP)
                                    AND ((NLS_UPPER(property_value) LIKE NLS_UPPER(lob_in) ESCAPE '#' )
                                        OR (NLS_UPPER(property_value) LIKE NLS_UPPER(deployment_in) ESCAPE '#' )
                                        OR (NLS_UPPER(property_value) LIKE NLS_UPPER(comment_in) ESCAPE '#' )))
                    SELECT /*+ CARDINALITY(tgttypestab 10) */ SMP_EMD_TGT_OBJECT(tgt.target_name,
                           tgt.target_type,
                           tgt.target_guid,
                           tgt.display_name,
                           tgt.type_display_name,
                           tgt.host_name)
                    BULK COLLECT INTO l_tgt_array
                    FROM mgmt_targets tgt, 
                        TABLE(CAST(l_tgt_types_srch_lst AS SMP_EMD_STRING_ARRAY))tgttypestab,
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.DEPLOYMENT_PROP ) prop1, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.LOCATION_PROP) prop2, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.CONTACT_PROP) prop3, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.LOB_PROP) prop4, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.COMMENT_PROP) prop5
                    WHERE prop1.target_guid(+) = tgt.target_guid 
                      AND prop2.target_guid(+) = tgt.target_guid 
                      AND prop3.target_guid(+) = tgt.target_guid 
                      AND prop4.target_guid(+) = tgt.target_guid 
                      AND prop5.target_guid(+) = tgt.target_guid 
                      AND tgt.target_type = tgttypestab.column_value
                      AND (NLS_UPPER(prop4.property_value) LIKE NLS_UPPER(lob_in) ESCAPE '#' )
                      AND (NLS_UPPER(prop1.property_value) LIKE NLS_UPPER(deployment_in) ESCAPE '#' )
                      AND (NLS_UPPER(prop5.property_value) LIKE NLS_UPPER(comment_in) ESCAPE '#' )
                      AND (NLS_UPPER(target_name) LIKE NLS_UPPER(l_target_name_in) ESCAPE '#');
                ELSIF ((lob_in IS NOT NULL AND --bcde
                    deployment_in IS NOT NULL AND 
                    comment_in IS NOT NULL AND 
                    contact_in IS NOT NULL)
                   AND (location_in IS NULL))
                THEN
                    WITH props AS (SELECT property_name, 
                                          property_value, 
                                          target_guid
                                    FROM mgmt_target_properties 
                                    WHERE property_type = emd_mntr.INSTANCE_PPROP
                                      AND property_name IN( emd_mntr.DEPLOYMENT_PROP, 
                                                            emd_mntr.LOCATION_PROP,
                                                            emd_mntr.CONTACT_PROP,
                                                            emd_mntr.LOB_PROP,
                                                            emd_mntr.COMMENT_PROP)
                                    AND ((NLS_UPPER(property_value) LIKE NLS_UPPER(lob_in) ESCAPE '#' )
                                        OR (NLS_UPPER(property_value) LIKE NLS_UPPER(deployment_in) ESCAPE '#' )
                                        OR (NLS_UPPER(property_value) LIKE NLS_UPPER(comment_in) ESCAPE '#' )
                                        OR (NLS_UPPER(property_value) LIKE NLS_UPPER(contact_in) ESCAPE '#' )))
                    SELECT /*+ CARDINALITY(tgttypestab 10) */ SMP_EMD_TGT_OBJECT(tgt.target_name,
                           tgt.target_type,
                           tgt.target_guid,
                           tgt.display_name,
                           tgt.type_display_name,
                           tgt.host_name)
                    BULK COLLECT INTO l_tgt_array
                    FROM mgmt_targets tgt, 
                        TABLE(CAST(l_tgt_types_srch_lst AS SMP_EMD_STRING_ARRAY))tgttypestab,
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.DEPLOYMENT_PROP ) prop1, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.LOCATION_PROP) prop2, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.CONTACT_PROP) prop3, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.LOB_PROP) prop4, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.COMMENT_PROP) prop5
                    WHERE prop1.target_guid(+) = tgt.target_guid 
                      AND prop2.target_guid(+) = tgt.target_guid 
                      AND prop3.target_guid(+) = tgt.target_guid 
                      AND prop4.target_guid(+) = tgt.target_guid 
                      AND prop5.target_guid(+) = tgt.target_guid 
                      AND tgt.target_type = tgttypestab.column_value
                      AND (NLS_UPPER(prop4.property_value) LIKE NLS_UPPER(lob_in) ESCAPE '#' )
                      AND (NLS_UPPER(prop1.property_value) LIKE NLS_UPPER(deployment_in) ESCAPE '#' )
                      AND (NLS_UPPER(prop5.property_value) LIKE NLS_UPPER(comment_in) ESCAPE '#' )
                      AND (NLS_UPPER(prop3.property_value) LIKE NLS_UPPER(contact_in) ESCAPE '#' )
                      AND (NLS_UPPER(target_name) LIKE NLS_UPPER(l_target_name_in) ESCAPE '#');
                ELSIF ((lob_in IS NOT NULL AND --bce
                    deployment_in IS NOT NULL AND 
                    contact_in IS NOT NULL)
                   AND (location_in IS NULL AND 
                        comment_in IS NULL ))
                THEN
                    WITH props AS (SELECT property_name, 
                                          property_value, 
                                          target_guid
                                    FROM mgmt_target_properties 
                                    WHERE property_type = emd_mntr.INSTANCE_PPROP
                                      AND property_name IN( emd_mntr.DEPLOYMENT_PROP, 
                                                            emd_mntr.LOCATION_PROP,
                                                            emd_mntr.CONTACT_PROP,
                                                            emd_mntr.LOB_PROP,
                                                            emd_mntr.COMMENT_PROP)
                                    AND ((NLS_UPPER(property_value) LIKE NLS_UPPER(lob_in) ESCAPE '#' )
                                        OR (NLS_UPPER(property_value) LIKE NLS_UPPER(deployment_in) ESCAPE '#' )
                                        OR (NLS_UPPER(property_value) LIKE NLS_UPPER(contact_in) ESCAPE '#' )))
                    SELECT /*+ CARDINALITY(tgttypestab 10) */ SMP_EMD_TGT_OBJECT(tgt.target_name,
                           tgt.target_type,
                           tgt.target_guid,
                           tgt.display_name,
                           tgt.type_display_name,
                           tgt.host_name)
                    BULK COLLECT INTO l_tgt_array
                    FROM mgmt_targets tgt, 
                        TABLE(CAST(l_tgt_types_srch_lst AS SMP_EMD_STRING_ARRAY))tgttypestab,
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.DEPLOYMENT_PROP ) prop1, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.LOCATION_PROP) prop2, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.CONTACT_PROP) prop3, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.LOB_PROP) prop4, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.COMMENT_PROP) prop5
                    WHERE prop1.target_guid(+) = tgt.target_guid 
                      AND prop2.target_guid(+) = tgt.target_guid 
                      AND prop3.target_guid(+) = tgt.target_guid 
                      AND prop4.target_guid(+) = tgt.target_guid 
                      AND prop5.target_guid(+) = tgt.target_guid 
                      AND tgt.target_type = tgttypestab.column_value
                      AND (NLS_UPPER(prop4.property_value) LIKE NLS_UPPER(lob_in) ESCAPE '#' )
                      AND (NLS_UPPER(prop1.property_value) LIKE NLS_UPPER(deployment_in) ESCAPE '#' )
                      AND (NLS_UPPER(prop3.property_value) LIKE NLS_UPPER(contact_in) ESCAPE '#' )
                      AND (NLS_UPPER(target_name) LIKE NLS_UPPER(l_target_name_in) ESCAPE '#');
                ELSIF ((lob_in IS NOT NULL AND --bd
                    comment_in IS NOT NULL )
                   AND (location_in IS NULL AND 
                        deployment_in IS NULL AND 
                        contact_in IS NULL))
                THEN
                    WITH props AS (SELECT property_name, 
                                          property_value, 
                                          target_guid
                                    FROM mgmt_target_properties 
                                    WHERE property_type = emd_mntr.INSTANCE_PPROP
                                      AND property_name IN( emd_mntr.DEPLOYMENT_PROP, 
                                                            emd_mntr.LOCATION_PROP,
                                                            emd_mntr.CONTACT_PROP,
                                                            emd_mntr.LOB_PROP,
                                                            emd_mntr.COMMENT_PROP)
                                    AND ((NLS_UPPER(property_value) LIKE NLS_UPPER(lob_in) ESCAPE '#' )
                                        OR (NLS_UPPER(property_value) LIKE NLS_UPPER(comment_in) ESCAPE '#' )))
                    SELECT /*+ CARDINALITY(tgttypestab 10) */ SMP_EMD_TGT_OBJECT(tgt.target_name,
                           tgt.target_type,
                           tgt.target_guid,
                           tgt.display_name,
                           tgt.type_display_name,
                           tgt.host_name)
                    BULK COLLECT INTO l_tgt_array
                    FROM mgmt_targets tgt, 
                        TABLE(CAST(l_tgt_types_srch_lst AS SMP_EMD_STRING_ARRAY))tgttypestab,
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.DEPLOYMENT_PROP ) prop1, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.LOCATION_PROP) prop2, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.CONTACT_PROP) prop3, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.LOB_PROP) prop4, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.COMMENT_PROP) prop5
                    WHERE prop1.target_guid(+) = tgt.target_guid 
                      AND prop2.target_guid(+) = tgt.target_guid 
                      AND prop3.target_guid(+) = tgt.target_guid 
                      AND prop4.target_guid(+) = tgt.target_guid 
                      AND prop5.target_guid(+) = tgt.target_guid 
                      AND tgt.target_type = tgttypestab.column_value
                      AND (NLS_UPPER(prop4.property_value) LIKE NLS_UPPER(lob_in) ESCAPE '#' )
                      AND (NLS_UPPER(prop5.property_value) LIKE NLS_UPPER(comment_in) ESCAPE '#' )
                      AND (NLS_UPPER(target_name) LIKE NLS_UPPER(l_target_name_in) ESCAPE '#');
                ELSIF ((lob_in IS NOT NULL AND --bde
                    comment_in IS NOT NULL AND 
                    contact_in IS NOT NULL)
                   AND (location_in IS NULL AND 
                        deployment_in IS NULL))
                THEN
                    WITH props AS (SELECT property_name, 
                                          property_value, 
                                          target_guid
                                    FROM mgmt_target_properties 
                                    WHERE property_type = emd_mntr.INSTANCE_PPROP
                                      AND property_name IN( emd_mntr.DEPLOYMENT_PROP, 
                                                            emd_mntr.LOCATION_PROP,
                                                            emd_mntr.CONTACT_PROP,
                                                            emd_mntr.LOB_PROP,
                                                            emd_mntr.COMMENT_PROP)
                                    AND ((NLS_UPPER(property_value) LIKE NLS_UPPER(lob_in) ESCAPE '#' )
                                        OR (NLS_UPPER(property_value) LIKE NLS_UPPER(comment_in) ESCAPE '#' )
                                        OR (NLS_UPPER(property_value) LIKE NLS_UPPER(contact_in) ESCAPE '#' )))
                    SELECT /*+ CARDINALITY(tgttypestab 10) */ SMP_EMD_TGT_OBJECT(tgt.target_name,
                           tgt.target_type,
                           tgt.target_guid,
                           tgt.display_name,
                           tgt.type_display_name,
                           tgt.host_name)
                    BULK COLLECT INTO l_tgt_array
                    FROM mgmt_targets tgt, 
                        TABLE(CAST(l_tgt_types_srch_lst AS SMP_EMD_STRING_ARRAY))tgttypestab,
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.DEPLOYMENT_PROP ) prop1, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.LOCATION_PROP) prop2, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.CONTACT_PROP) prop3, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.LOB_PROP) prop4, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.COMMENT_PROP) prop5
                    WHERE prop1.target_guid(+) = tgt.target_guid 
                      AND prop2.target_guid(+) = tgt.target_guid 
                      AND prop3.target_guid(+) = tgt.target_guid 
                      AND prop4.target_guid(+) = tgt.target_guid 
                      AND prop5.target_guid(+) = tgt.target_guid 
                      AND tgt.target_type = tgttypestab.column_value
                      AND (NLS_UPPER(prop4.property_value) LIKE NLS_UPPER(lob_in) ESCAPE '#' )
                      AND (NLS_UPPER(prop5.property_value) LIKE NLS_UPPER(comment_in) ESCAPE '#' )
                      AND (NLS_UPPER(prop3.property_value) LIKE NLS_UPPER(contact_in) ESCAPE '#' )
                      AND (NLS_UPPER(target_name) LIKE NLS_UPPER(l_target_name_in) ESCAPE '#');
                ELSIF ((lob_in IS NOT NULL AND --be
                    contact_in IS NOT NULL)
                   AND (location_in IS NULL AND 
                        deployment_in IS NULL AND 
                        comment_in IS NULL ))
                THEN
                    WITH props AS (SELECT property_name, 
                                          property_value, 
                                          target_guid
                                    FROM mgmt_target_properties 
                                    WHERE property_type = emd_mntr.INSTANCE_PPROP
                                      AND property_name IN( emd_mntr.DEPLOYMENT_PROP, 
                                                            emd_mntr.LOCATION_PROP,
                                                            emd_mntr.CONTACT_PROP,
                                                            emd_mntr.LOB_PROP,
                                                            emd_mntr.COMMENT_PROP)
                                    AND ((NLS_UPPER(property_value) LIKE NLS_UPPER(lob_in) ESCAPE '#' )
                                        OR (NLS_UPPER(property_value) LIKE NLS_UPPER(contact_in) ESCAPE '#' )))
                    SELECT /*+ CARDINALITY(tgttypestab 10) */ SMP_EMD_TGT_OBJECT(tgt.target_name,
                           tgt.target_type,
                           tgt.target_guid,
                           tgt.display_name,
                           tgt.type_display_name,
                           tgt.host_name)
                    BULK COLLECT INTO l_tgt_array
                    FROM mgmt_targets tgt, 
                        TABLE(CAST(l_tgt_types_srch_lst AS SMP_EMD_STRING_ARRAY))tgttypestab,
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.DEPLOYMENT_PROP ) prop1, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.LOCATION_PROP) prop2, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.CONTACT_PROP) prop3, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.LOB_PROP) prop4, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.COMMENT_PROP) prop5
                    WHERE prop1.target_guid(+) = tgt.target_guid 
                      AND prop2.target_guid(+) = tgt.target_guid 
                      AND prop3.target_guid(+) = tgt.target_guid 
                      AND prop4.target_guid(+) = tgt.target_guid 
                      AND prop5.target_guid(+) = tgt.target_guid 
                      AND tgt.target_type = tgttypestab.column_value
                      AND (NLS_UPPER(prop4.property_value) LIKE NLS_UPPER(lob_in) ESCAPE '#' )
                      AND (NLS_UPPER(prop3.property_value) LIKE NLS_UPPER(contact_in) ESCAPE '#' )
                      AND (NLS_UPPER(target_name) LIKE NLS_UPPER(l_target_name_in) ESCAPE '#');
                ELSIF ((deployment_in IS NOT NULL) --c
                   AND (location_in IS NULL AND 
                        lob_in IS NULL AND 
                        comment_in IS NULL AND 
                        contact_in IS NULL))
                THEN
                    WITH props AS (SELECT property_name, 
                                          property_value, 
                                          target_guid
                                    FROM mgmt_target_properties 
                                    WHERE property_type = emd_mntr.INSTANCE_PPROP
                                      AND property_name IN( emd_mntr.DEPLOYMENT_PROP, 
                                                            emd_mntr.LOCATION_PROP,
                                                            emd_mntr.CONTACT_PROP,
                                                            emd_mntr.LOB_PROP,
                                                            emd_mntr.COMMENT_PROP)
                                    AND ((NLS_UPPER(property_value) LIKE NLS_UPPER(deployment_in) ESCAPE '#' )))
                    SELECT /*+ CARDINALITY(tgttypestab 10) */ SMP_EMD_TGT_OBJECT(tgt.target_name,
                           tgt.target_type,
                           tgt.target_guid,
                           tgt.display_name,
                           tgt.type_display_name,
                           tgt.host_name)
                    BULK COLLECT INTO l_tgt_array
                    FROM mgmt_targets tgt, 
                        TABLE(CAST(l_tgt_types_srch_lst AS SMP_EMD_STRING_ARRAY))tgttypestab,
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.DEPLOYMENT_PROP ) prop1, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.LOCATION_PROP) prop2, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.CONTACT_PROP) prop3, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.LOB_PROP) prop4, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.COMMENT_PROP) prop5
                    WHERE prop1.target_guid(+) = tgt.target_guid 
                      AND prop2.target_guid(+) = tgt.target_guid 
                      AND prop3.target_guid(+) = tgt.target_guid 
                      AND prop4.target_guid(+) = tgt.target_guid 
                      AND prop5.target_guid(+) = tgt.target_guid 
                      AND tgt.target_type = tgttypestab.column_value
                      AND (NLS_UPPER(prop1.property_value) LIKE NLS_UPPER(deployment_in) ESCAPE '#' )
                      AND (NLS_UPPER(target_name) LIKE NLS_UPPER(l_target_name_in) ESCAPE '#');
                ELSIF ((deployment_in IS NOT NULL AND --cd
                        comment_in IS NOT NULL)
                   AND (location_in IS NULL AND 
                        lob_in IS NULL AND 
                        contact_in IS NULL))
                THEN
                    WITH props AS (SELECT property_name, 
                                          property_value, 
                                          target_guid
                                    FROM mgmt_target_properties 
                                    WHERE property_type = emd_mntr.INSTANCE_PPROP
                                      AND property_name IN( emd_mntr.DEPLOYMENT_PROP, 
                                                            emd_mntr.LOCATION_PROP,
                                                            emd_mntr.CONTACT_PROP,
                                                            emd_mntr.LOB_PROP,
                                                            emd_mntr.COMMENT_PROP)
                                    AND ((NLS_UPPER(property_value) LIKE NLS_UPPER(deployment_in) ESCAPE '#' )
                                        OR (NLS_UPPER(property_value) LIKE NLS_UPPER(comment_in) ESCAPE '#' )))
                    SELECT /*+ CARDINALITY(tgttypestab 10) */ SMP_EMD_TGT_OBJECT(tgt.target_name,
                           tgt.target_type,
                           tgt.target_guid,
                           tgt.display_name,
                           tgt.type_display_name,
                           tgt.host_name)
                    BULK COLLECT INTO l_tgt_array
                    FROM mgmt_targets tgt, 
                        TABLE(CAST(l_tgt_types_srch_lst AS SMP_EMD_STRING_ARRAY))tgttypestab,
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.DEPLOYMENT_PROP ) prop1, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.LOCATION_PROP) prop2, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.CONTACT_PROP) prop3, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.LOB_PROP) prop4, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.COMMENT_PROP) prop5
                    WHERE prop1.target_guid(+) = tgt.target_guid 
                      AND prop2.target_guid(+) = tgt.target_guid 
                      AND prop3.target_guid(+) = tgt.target_guid 
                      AND prop4.target_guid(+) = tgt.target_guid 
                      AND prop5.target_guid(+) = tgt.target_guid 
                      AND tgt.target_type = tgttypestab.column_value
                      AND (NLS_UPPER(prop1.property_value) LIKE NLS_UPPER(deployment_in) ESCAPE '#' )
                      AND (NLS_UPPER(prop5.property_value) LIKE NLS_UPPER(comment_in) ESCAPE '#' )
                      AND (NLS_UPPER(target_name) LIKE NLS_UPPER(l_target_name_in) ESCAPE '#');
                ELSIF ((deployment_in IS NOT NULL AND --cde
                        comment_in IS NOT NULL AND 
                        contact_in IS NOT NULL)
                   AND (location_in IS NULL AND 
                        lob_in IS NULL))
                THEN
                    WITH props AS (SELECT property_name, 
                                          property_value, 
                                          target_guid
                                    FROM mgmt_target_properties 
                                    WHERE property_type = emd_mntr.INSTANCE_PPROP
                                      AND property_name IN( emd_mntr.DEPLOYMENT_PROP, 
                                                            emd_mntr.LOCATION_PROP,
                                                            emd_mntr.CONTACT_PROP,
                                                            emd_mntr.LOB_PROP,
                                                            emd_mntr.COMMENT_PROP)
                                    AND ((NLS_UPPER(property_value) LIKE NLS_UPPER(deployment_in) ESCAPE '#' )
                                        OR (NLS_UPPER(property_value) LIKE NLS_UPPER(comment_in) ESCAPE '#' )
                                        OR (NLS_UPPER(property_value) LIKE NLS_UPPER(contact_in) ESCAPE '#' )))
                    SELECT /*+ CARDINALITY(tgttypestab 10) */ SMP_EMD_TGT_OBJECT(tgt.target_name,
                           tgt.target_type,
                           tgt.target_guid,
                           tgt.display_name,
                           tgt.type_display_name,
                           tgt.host_name)
                    BULK COLLECT INTO l_tgt_array
                    FROM mgmt_targets tgt, 
                        TABLE(CAST(l_tgt_types_srch_lst AS SMP_EMD_STRING_ARRAY))tgttypestab,
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.DEPLOYMENT_PROP ) prop1, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.LOCATION_PROP) prop2, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.CONTACT_PROP) prop3, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.LOB_PROP) prop4, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.COMMENT_PROP) prop5
                    WHERE prop1.target_guid(+) = tgt.target_guid 
                      AND prop2.target_guid(+) = tgt.target_guid 
                      AND prop3.target_guid(+) = tgt.target_guid 
                      AND prop4.target_guid(+) = tgt.target_guid 
                      AND prop5.target_guid(+) = tgt.target_guid 
                      AND tgt.target_type = tgttypestab.column_value
                      AND (NLS_UPPER(prop1.property_value) LIKE NLS_UPPER(deployment_in) ESCAPE '#' )
                      AND (NLS_UPPER(prop5.property_value) LIKE NLS_UPPER(comment_in) ESCAPE '#' )
                      AND (NLS_UPPER(prop3.property_value) LIKE NLS_UPPER(contact_in) ESCAPE '#' )
                      AND (NLS_UPPER(target_name) LIKE NLS_UPPER(l_target_name_in) ESCAPE '#');
                ELSIF ((deployment_in IS NOT NULL AND --ce
                        contact_in IS NOT NULL)
                   AND (location_in IS NULL AND 
                        lob_in IS NULL AND 
                        comment_in IS NULL))
                THEN
                    WITH props AS (SELECT property_name, 
                                          property_value, 
                                          target_guid
                                    FROM mgmt_target_properties 
                                    WHERE property_type = emd_mntr.INSTANCE_PPROP
                                      AND property_name IN( emd_mntr.DEPLOYMENT_PROP, 
                                                            emd_mntr.LOCATION_PROP,
                                                            emd_mntr.CONTACT_PROP,
                                                            emd_mntr.LOB_PROP,
                                                            emd_mntr.COMMENT_PROP)
                                    AND ((NLS_UPPER(property_value) LIKE NLS_UPPER(deployment_in) ESCAPE '#' )
                                        OR (NLS_UPPER(property_value) LIKE NLS_UPPER(contact_in) ESCAPE '#' )))
                    SELECT /*+ CARDINALITY(tgttypestab 10) */ SMP_EMD_TGT_OBJECT(tgt.target_name,
                           tgt.target_type,
                           tgt.target_guid,
                           tgt.display_name,
                           tgt.type_display_name,
                           tgt.host_name)
                    BULK COLLECT INTO l_tgt_array
                    FROM mgmt_targets tgt, 
                        TABLE(CAST(l_tgt_types_srch_lst AS SMP_EMD_STRING_ARRAY))tgttypestab,
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.DEPLOYMENT_PROP ) prop1, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.LOCATION_PROP) prop2, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.CONTACT_PROP) prop3, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.LOB_PROP) prop4, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.COMMENT_PROP) prop5
                    WHERE prop1.target_guid(+) = tgt.target_guid 
                      AND prop2.target_guid(+) = tgt.target_guid 
                      AND prop3.target_guid(+) = tgt.target_guid 
                      AND prop4.target_guid(+) = tgt.target_guid 
                      AND prop5.target_guid(+) = tgt.target_guid 
                      AND tgt.target_type = tgttypestab.column_value
                      AND (NLS_UPPER(prop1.property_value) LIKE NLS_UPPER(deployment_in) ESCAPE '#' )
                      AND (NLS_UPPER(prop3.property_value) LIKE NLS_UPPER(contact_in) ESCAPE '#' )
                      AND (NLS_UPPER(target_name) LIKE NLS_UPPER(l_target_name_in) ESCAPE '#');
                ELSIF ((comment_in IS NOT NULL) --d
                   AND (location_in IS NULL AND 
                        lob_in IS NULL AND 
                        deployment_in IS NULL AND 
                        contact_in IS NULL))
                THEN
                    WITH props AS (SELECT property_name, 
                                          property_value, 
                                          target_guid
                                    FROM mgmt_target_properties 
                                    WHERE property_type = emd_mntr.INSTANCE_PPROP
                                      AND property_name IN( emd_mntr.DEPLOYMENT_PROP, 
                                                            emd_mntr.LOCATION_PROP,
                                                            emd_mntr.CONTACT_PROP,
                                                            emd_mntr.LOB_PROP,
                                                            emd_mntr.COMMENT_PROP)
                                    AND ((NLS_UPPER(property_value) LIKE NLS_UPPER(comment_in) ESCAPE '#' )))
                    SELECT /*+ CARDINALITY(tgttypestab 10) */ SMP_EMD_TGT_OBJECT(tgt.target_name,
                           tgt.target_type,
                           tgt.target_guid,
                           tgt.display_name,
                           tgt.type_display_name,
                           tgt.host_name)
                    BULK COLLECT INTO l_tgt_array
                    FROM mgmt_targets tgt, 
                        TABLE(CAST(l_tgt_types_srch_lst AS SMP_EMD_STRING_ARRAY))tgttypestab,
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.DEPLOYMENT_PROP ) prop1, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.LOCATION_PROP) prop2, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.CONTACT_PROP) prop3, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.LOB_PROP) prop4, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.COMMENT_PROP) prop5
                    WHERE prop1.target_guid(+) = tgt.target_guid 
                      AND prop2.target_guid(+) = tgt.target_guid 
                      AND prop3.target_guid(+) = tgt.target_guid 
                      AND prop4.target_guid(+) = tgt.target_guid 
                      AND prop5.target_guid(+) = tgt.target_guid 
                      AND tgt.target_type = tgttypestab.column_value
                      AND (NLS_UPPER(prop5.property_value) LIKE NLS_UPPER(comment_in) ESCAPE '#' ) 
                      AND (NLS_UPPER(target_name) LIKE NLS_UPPER(l_target_name_in) ESCAPE '#');
                ELSIF ((comment_in IS NOT NULL AND --de
                        contact_in IS NOT NULL)
                   AND (location_in IS NULL AND 
                        lob_in IS NULL AND 
                        deployment_in IS NULL))
                THEN
                    WITH props AS (SELECT property_name, 
                                          property_value, 
                                          target_guid
                                    FROM mgmt_target_properties 
                                    WHERE property_type = emd_mntr.INSTANCE_PPROP
                                      AND property_name IN( emd_mntr.DEPLOYMENT_PROP, 
                                                            emd_mntr.LOCATION_PROP,
                                                            emd_mntr.CONTACT_PROP,
                                                            emd_mntr.LOB_PROP,
                                                            emd_mntr.COMMENT_PROP)
                                    AND ((NLS_UPPER(property_value) LIKE NLS_UPPER(comment_in) ESCAPE '#' )
                                        OR (NLS_UPPER(property_value) LIKE NLS_UPPER(contact_in) ESCAPE '#' )))
                    SELECT /*+ CARDINALITY(tgttypestab 10) */ SMP_EMD_TGT_OBJECT(tgt.target_name,
                           tgt.target_type,
                           tgt.target_guid,
                           tgt.display_name,
                           tgt.type_display_name,
                           tgt.host_name)
                    BULK COLLECT INTO l_tgt_array
                    FROM mgmt_targets tgt, 
                        TABLE(CAST(l_tgt_types_srch_lst AS SMP_EMD_STRING_ARRAY))tgttypestab,
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.DEPLOYMENT_PROP ) prop1, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.LOCATION_PROP) prop2, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.CONTACT_PROP) prop3, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.LOB_PROP) prop4, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.COMMENT_PROP) prop5
                    WHERE prop1.target_guid(+) = tgt.target_guid 
                      AND prop2.target_guid(+) = tgt.target_guid 
                      AND prop3.target_guid(+) = tgt.target_guid 
                      AND prop4.target_guid(+) = tgt.target_guid 
                      AND prop5.target_guid(+) = tgt.target_guid 
                      AND tgt.target_type = tgttypestab.column_value
                      AND (NLS_UPPER(prop5.property_value) LIKE NLS_UPPER(comment_in) ESCAPE '#' )
                      AND (NLS_UPPER(prop3.property_value) LIKE NLS_UPPER(contact_in) ESCAPE '#' )
                      AND (NLS_UPPER(target_name) LIKE NLS_UPPER(l_target_name_in) ESCAPE '#');
                ELSIF ((contact_in IS NOT NULL) --e
                   AND (comment_in IS NULL AND
                        location_in IS NULL AND 
                        lob_in IS NULL AND 
                        deployment_in IS NULL))
                THEN
                    WITH props AS (SELECT property_name, 
                                          property_value, 
                                          target_guid
                                    FROM mgmt_target_properties 
                                    WHERE property_type = emd_mntr.INSTANCE_PPROP
                                      AND property_name IN( emd_mntr.DEPLOYMENT_PROP, 
                                                            emd_mntr.LOCATION_PROP,
                                                            emd_mntr.CONTACT_PROP,
                                                            emd_mntr.LOB_PROP,
                                                            emd_mntr.COMMENT_PROP)
                                    AND ((NLS_UPPER(property_value) LIKE NLS_UPPER(contact_in) ESCAPE '#' )))
                    SELECT /*+ CARDINALITY(tgttypestab 10) */ SMP_EMD_TGT_OBJECT(tgt.target_name,
                           tgt.target_type,
                           tgt.target_guid,
                           tgt.display_name,
                           tgt.type_display_name,
                           tgt.host_name)
                    BULK COLLECT INTO l_tgt_array
                    FROM mgmt_targets tgt, 
                        TABLE(CAST(l_tgt_types_srch_lst AS SMP_EMD_STRING_ARRAY))tgttypestab,
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.DEPLOYMENT_PROP ) prop1, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.LOCATION_PROP) prop2, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.CONTACT_PROP) prop3, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.LOB_PROP) prop4, 
                        (SELECT target_guid, property_value FROM props WHERE property_name = emd_mntr.COMMENT_PROP) prop5
                    WHERE prop1.target_guid(+) = tgt.target_guid 
                      AND prop2.target_guid(+) = tgt.target_guid 
                      AND prop3.target_guid(+) = tgt.target_guid 
                      AND prop4.target_guid(+) = tgt.target_guid 
                      AND prop5.target_guid(+) = tgt.target_guid 
                      AND tgt.target_type = tgttypestab.column_value
                      AND (NLS_UPPER(prop3.property_value) LIKE NLS_UPPER(contact_in) ESCAPE '#' )
                      AND (NLS_UPPER(target_name) LIKE NLS_UPPER(l_target_name_in) ESCAPE '#');
                END IF;
            END IF;
        END IF;
    END IF;
    RETURN l_tgt_array;
EXCEPTION
    WHEN OTHERS THEN
        RAISE_APPLICATION_ERROR(-20001,'Error in get_targets');
END get_targets;
--
-- This PL/SQL table function can spare CPU cycles by allowing the DB to
-- cache the result. As such, a UNIQUE unique_key should be used accross the
-- txn that wishes to leverage from this functionality. Callers must ensure
-- that the unique_key does not conflict with other sessions or even txns on
-- the same session in the future.
--
FUNCTION get_targets2(query IN VARCHAR2, unique_key IN VARCHAR2)
RETURN SMP_EMD_TGT_OBJECT_TBL
DETERMINISTIC PIPELINED IS
  l_tgt_cur cursorType;
  l_tgt SMP_EMD_TGT_OBJECT := 
    SMP_EMD_TGT_OBJECT(NULL, NULL, NULL, NULL, NULL, NULL);
BEGIN
  OPEN l_tgt_cur FOR query;
  LOOP
    FETCH l_tgt_cur INTO l_tgt.target_name, l_tgt.target_type,
                         l_tgt.target_guid, l_tgt.display_name,
                         l_tgt.type_display_name, l_tgt.host_name;
    EXIT WHEN l_tgt_cur%NOTFOUND;
    PIPE ROW(l_tgt);
  END LOOP;
  CLOSE l_tgt_cur;
  RETURN;
END;
 
--
-- PROCEDURE: get_targets_summary1
--
-- PURPOSE: 
--   This is used inside get_targets_summary for Case 1. See get_targets_summary.
--
-- IN Parameters:
--   search_query_in: VARCHAR2 See get_targets_summary.
--
-- OUT Parameters:
--   targets_cur_out: cursorType See get_targets_summary.
--
PROCEDURE get_targets_summary1(search_query_in IN VARCHAR2 DEFAULT NULL,
                               search_mode_in  IN VARCHAR2 DEFAULT NULL,
                               targets_cur_out OUT cursorType,
                                tgt_types_srch_lst_in IN SMP_EMD_STRING_ARRAY DEFAULT NULL,                               
                                target_name_in        IN VARCHAR2 DEFAULT NULL,                                           
                                location_in           IN VARCHAR2 DEFAULT NULL,            
                                lob_in                IN VARCHAR2 DEFAULT NULL,            
                                deployment_in         IN VARCHAR2 DEFAULT NULL,            
                                comment_in            IN VARCHAR2 DEFAULT NULL,                                           
                                contact_in            IN VARCHAR2 DEFAULT NULL) 
IS
    l_target_array SMP_EMD_TGT_OBJECT_TBL;
    l_sql_msg      VARCHAR2(4000);
BEGIN

  IF(search_query_in IS NULL)
  THEN
    -- no search filter at all
    OPEN targets_cur_out FOR
      SELECT tgt.target_name, 
             tgt.target_type, 
             tgt.target_name as display_name, 
             tgt.type_display_name, 
             NVL(avail.current_status,MGMT_GLOBAL.G_STATUS_UNKNOWN) cur_status,
             tgt.target_guid,
             DECODE(met.metric_guid, NULL, 1, 0) member_based_avail
        FROM mgmt_targets tgt,
             mgmt_current_availability avail,
             (SELECT DISTINCT metric_guid, target_type
                FROM mgmt_metrics
               WHERE metric_name = 'Response'
                 AND metric_column = 'Status') met 
       WHERE tgt.target_guid = avail.target_guid (+)
         AND tgt.target_type = met.target_type (+)
       ORDER BY tgt.target_name;
  ELSE
    l_target_array := get_targets(search_query_in,
                                  search_mode_in,
                                  tgt_types_srch_lst_in,
                                  target_name_in,
                                  location_in,
                                  lob_in,
                                  deployment_in,
                                  comment_in,
                                  contact_in);
    OPEN targets_cur_out FOR
      SELECT tgt.target_name, 
             tgt.target_type, 
             tgt.target_name as display_name, 
             tgt.type_display_name, 
             NVL(avail.current_status,MGMT_GLOBAL.G_STATUS_UNKNOWN) cur_status,
             tgt.target_guid,
             DECODE(met.metric_guid, NULL, 1, 0) member_based_avail
        FROM TABLE(CAST(l_target_array AS SMP_EMD_TGT_OBJECT_TBL)) tgt,
             mgmt_current_availability avail,
             (SELECT DISTINCT metric_guid, target_type
                FROM mgmt_metrics
               WHERE metric_name = 'Response'
                 AND metric_column = 'Status') met 
       WHERE tgt.target_guid = avail.target_guid (+)
         AND tgt.target_type = met.target_type (+)
       ORDER BY tgt.target_name;
  END IF;
EXCEPTION
    WHEN OTHERS THEN
        l_sql_msg := sqlerrm;
        RAISE_APPLICATION_ERROR(-20001, 'Error in get_targets_summary1: '||l_sql_msg);
END get_targets_summary1;

--
-- PROCEDURE: get_targets_summary2_db_hst
--
-- PURPOSE:
--   This is used inside get_targets_summary2 for RAC case. When databases 
--   folder are displayed, we'll show rac_database targets instead
--   of their member oracle_database targets
--
-- IN Parameters:
--   search_query_in: VARCHAR2 See get_targets_summary.
--
-- OUT Parameters:
--   targets_cur_out: cursorType See get_targets_summary.
--
PROCEDURE get_targets_summary2_db_hst(search_query_in IN VARCHAR2 DEFAULT NULL,
                                      search_mode_in  IN VARCHAR2 DEFAULT NULL,
                                      targets_cur_out OUT cursorType,
                                      tgt_types_srch_lst_in IN SMP_EMD_STRING_ARRAY DEFAULT NULL,
                                      target_name_in        IN VARCHAR2 DEFAULT NULL,            
                                      location_in           IN VARCHAR2 DEFAULT NULL,            
                                      lob_in                IN VARCHAR2 DEFAULT NULL,            
                                      deployment_in         IN VARCHAR2 DEFAULT NULL,            
                                      comment_in            IN VARCHAR2 DEFAULT NULL,            
                                      contact_in            IN VARCHAR2 DEFAULT NULL) IS
  rac_tgt_type VARCHAR2(64);
  db_tgt_type  VARCHAR2(64);
  ms_db_tgt_type VARCHAR2(64);
  ibm_db_tgt_type  VARCHAR2(64);
  l_target_array   SMP_EMD_TGT_OBJECT_TBL;

BEGIN

  -- the composite target type
  db_tgt_type  := MGMT_GLOBAL.G_DATABASE_TARGET_TYPE;
  rac_tgt_type := MGMT_GLOBAL.G_RAC_DATABASE_TARGET_TYPE ;
  ms_db_tgt_type  := 'microsoft_sqlserver_database';
  ibm_db_tgt_type := 'ibm_db2_database'; 

  -- get targets_cur_out
  -- the query will get rac_database or cluster targets, not their member targets
  IF(search_query_in IS NULL)
  THEN
    -- no search target query provided
    OPEN targets_cur_out FOR
    SELECT tgt.target_name,
           tgt.target_type,
           tgt.display_name,
           tgt.type_display_name,
           NVL(avail.current_status,MGMT_GLOBAL.G_STATUS_UNKNOWN) cur_status,
           tgt.target_guid,
           alrt_warn  as warning_count,
           alrt_crit as critical_count,
           mtp.property_value data_guard_status,
           pol_info as policy_information_count,
           pol_warn as policy_warning_count,
           pol_crit as policy_critical_count,
           cs as target_compliance_score
      FROM (SELECT NVL(ta.source_target_guid,tgt.target_guid) target_guid,
                   NVL(SUM(alltgt.warning_count),0) alrt_warn,
                   NVL(SUM(alltgt.critical_count),0) alrt_crit,
                   NVL(SUM(allpolicy.information_count),0) pol_info,
                   NVL(SUM(allpolicy.warning_count),0) pol_warn,
                   NVL(SUM(allpolicy.critical_count),0) pol_crit ,
                   NVL(ROUND(SUM(compliance_score)/DECODE(sum(cnt),0,1,sum(cnt))),-1) cs
              FROM mgmt_targets tgt, 
                   (SELECT source_target_guid,assoc_target_guid
                      FROM mgmt_target_assocs ta1, mgmt_targets t2
                     WHERE ta1.source_target_guid  = t2.target_guid
                       AND ta1.assoc_guid = MGMT_ASSOC.G_CONTAINS_GUID
                       AND t2.target_type = rac_tgt_type) ta,
                  (SELECT target_guid, 
                          SUM(DECODE(violation_level,MGMT_GLOBAL.G_SEVERITY_WARNING,1,0)) warning_count,
                          SUM(DECODE(violation_level,MGMT_GLOBAL.G_SEVERITY_CRITICAL,1,0)) critical_count
                     FROM mgmt_current_violation
                    WHERE violation_type IN (0,1,2)
                    GROUP BY target_guid) alltgt,
                  (SELECT SUM(DECODE(max_violation_level,MGMT_GLOBAL.G_SEVERITY_INFORMATIONAL,non_exempt_violations_logged,0)) as information_count,
                          SUM(DECODE(max_violation_level,MGMT_GLOBAL.G_SEVERITY_WARNING,non_exempt_violations_logged,0)) as warning_count,
                          SUM(DECODE(max_violation_level,MGMT_GLOBAL.G_SEVERITY_CRITICAL,non_exempt_violations_logged,0)) as critical_count,
                          SUM(compliance_score) as compliance_score, COUNT(*) as cnt,
                          target_guid 
                    FROM mgmt_policy_assoc_eval_summ e, 
                         mgmt_policies r
                   WHERE r.policy_guid = e.policy_guid 
                     AND r.policy_type = MGMT_GLOBAL.G_TYPE_POLICY
                   GROUP BY target_guid) allpolicy
            WHERE tgt.target_type  IN ( db_tgt_type , rac_tgt_type, 
                                        ms_db_tgt_type , ibm_db_tgt_type)
              AND tgt.target_guid  = ta.assoc_target_guid(+)
              AND tgt.target_guid = alltgt.target_guid (+)
              AND tgt.target_guid = allpolicy.target_guid(+)
            GROUP BY NVL(ta.source_target_guid,tgt.target_guid)
           ) summry,
           mgmt_targets tgt,      
           mgmt_target_properties mtp,
           mgmt_current_Availability avail
      WHERE tgt.target_guid = summry.target_guid
        AND mtp.target_guid(+) = tgt.target_guid
        AND mtp.property_name(+) = 'DataGuardStatus'
        AND tgt.target_guid = avail.target_guid 
     ORDER BY target_name ;
  ELSE
    -- search target query provided
    l_target_array := get_targets(search_query_in,
                                  search_mode_in,
                                  tgt_types_srch_lst_in,
                                  target_name_in,
                                  location_in,
                                  lob_in,
                                  deployment_in,
                                  comment_in,
                                  contact_in);
    OPEN targets_cur_out FOR
      SELECT /*+ INDEX(tgt) INDEX(avail) */
             tgt.target_name,
             tgt.target_type,
             tgt.display_name,
             tgt.type_display_name,
             NVL(avail.current_status,MGMT_GLOBAL.G_STATUS_UNKNOWN) cur_status,
             tgt.target_guid,
             NVL(alltgt.warning_count,0) AS warning_count,
             NVL(alltgt.critical_count,0) AS critical_count,
             tgt.data_guard_status,
             NVL(allpolicy.information_count, 0) AS policy_information_count,
             NVL(allpolicy.warning_count, 0) AS policy_warning_count,
             NVL(allpolicy.critical_count, 0) AS policy_critical_count,
             NVL(allpolicy.compliance_score, -1) as target_compliance_score
        FROM 
             (SELECT mgmt_targets.target_name,
                     mgmt_targets.target_guid,
                     mgmt_targets.type_display_name,
                     mgmt_targets.target_type,
                     mgmt_targets.display_name,
                     property_value data_guard_status 
                FROM mgmt_targets, 
                  (SELECT target_guid,
                          property_type,
                          property_value 
                     FROM mgmt_target_properties 
                   WHERE property_name = 'DataGuardStatus'
                  )propTbl 
                  WHERE 
                    (target_type = db_tgt_type OR target_type = rac_tgt_type OR
		     target_type = ms_db_tgt_type OR target_type = ibm_db_tgt_type)
                    AND target_name NOT IN (SELECT mt.target_name 
                         FROM mgmt_target_assocs, mgmt_targets ct, mgmt_targets mt
                        WHERE ct.target_type = rac_tgt_type AND 
                          assoc_guid = MGMT_ASSOC.g_contains_guid AND
                          ct.target_guid = source_target_guid AND
                          mt.target_guid = assoc_target_guid AND
                          mt.target_type = db_tgt_type)
                    AND mgmt_targets.target_guid = propTbl.target_guid (+) 
             ) tgt,
             mgmt_current_availability avail,
             (SELECT SUM(DECODE(severity_code,MGMT_GLOBAL.G_SEVERITY_WARNING,1,0)) warning_count,
                     SUM(DECODE(severity_code,MGMT_GLOBAL.G_SEVERITY_CRITICAL,1,0)) critical_count,
                     target_guid tguid
                FROM (SELECT target_guid, severity_code FROM mgmt_current_severity
                    UNION ALL SELECT source_target_guid, severity_code 
                    FROM mgmt_current_severity s, mgmt_target_assocs, mgmt_targets ct, mgmt_targets mt
                    WHERE assoc_target_guid = s.target_guid AND
                          assoc_guid = MGMT_ASSOC.g_contains_guid AND
                          ct.target_guid = source_target_guid AND
                          mt.target_guid = assoc_target_guid AND
                        ct.target_type = rac_tgt_type AND 
                        mt.target_type = db_tgt_type)
                GROUP BY target_guid) alltgt,
             (SELECT * 
                FROM TABLE(CAST(l_target_array AS SMP_EMD_TGT_OBJECT_TBL))
             ) search,
             (SELECT SUM(DECODE(max_violation_level,MGMT_GLOBAL.G_SEVERITY_INFORMATIONAL,non_exempt_violations_logged,0)) as information_count,
                     SUM(DECODE(max_violation_level,MGMT_GLOBAL.G_SEVERITY_WARNING,non_exempt_violations_logged,0)) as warning_count,
                     SUM(DECODE(max_violation_level,MGMT_GLOBAL.G_SEVERITY_CRITICAL,non_exempt_violations_logged,0)) as critical_count,
                     ROUND(AVG(compliance_score)) as compliance_score,
                     target_guid tguid
               FROM (
                  SELECT e.target_guid, e.max_violation_level, e.non_exempt_violations_logged, e.compliance_score
                  FROM mgmt_policy_assoc_eval_summ e, mgmt_policies r
                  WHERE r.policy_guid = e.policy_guid AND r.policy_type = MGMT_GLOBAL.G_TYPE_POLICY
                  UNION ALL 
                  SELECT m.source_target_guid, e.max_violation_level, e.non_exempt_violations_logged, e.compliance_score
                  FROM mgmt_policy_assoc_eval_summ e, mgmt_policies r, mgmt_target_assocs m, mgmt_targets ct, mgmt_targets mt
                  WHERE r.policy_guid = e.policy_guid AND r.policy_type = MGMT_GLOBAL.G_TYPE_POLICY AND 
                        m.assoc_target_guid = e.target_guid AND
                        m.assoc_guid = MGMT_ASSOC.g_contains_guid AND 
                        ct.target_guid = m.source_target_guid AND 
                        mt.target_guid = m.assoc_target_guid AND 
                        ct.target_type = rac_tgt_type AND 
                        mt.target_type = db_tgt_type
                  )                    
              GROUP BY target_guid) allpolicy 
       WHERE tgt.target_guid = avail.target_guid (+)
         AND tgt.target_guid = alltgt.tguid (+)
         AND tgt.target_guid = allpolicy.tguid(+)
         AND tgt.target_guid = search.target_guid
         ORDER BY tgt.target_name;
  END IF;
EXCEPTION
    WHEN OTHERS THEN
        RAISE_APPLICATION_ERROR(-20001, 'Error in get_targets_summary2_db_hst');
END get_targets_summary2_db_hst;


--
-- PROCEDURE: get_targets_summary2
--
-- PURPOSE:
--   This is used inside get_targets_summary for Case 2. See get_targets_summary.
--
-- IN Parameters:
--   folder_types_in: SMP_EMD_STRING_ARRAY See get_targets_summary.
--   search_query_in: VARCHAR2 See get_targets_summary.
--
-- OUT Parameters:
--   targets_cur_out: cursorType See get_targets_summary.
--
PROCEDURE get_targets_summary2(folder_types_in IN SMP_EMD_STRING_ARRAY,
                               search_query_in IN VARCHAR2 DEFAULT NULL,
                               search_mode_in  IN VARCHAR2 DEFAULT NULL,
                               targets_cur_out OUT cursorType,
                                tgt_types_srch_lst_in IN SMP_EMD_STRING_ARRAY DEFAULT NULL,                               
                                target_name_in        IN VARCHAR2 DEFAULT NULL,                                           
                                location_in           IN VARCHAR2 DEFAULT NULL,                                           
                                lob_in                IN VARCHAR2 DEFAULT NULL,                                           
                                deployment_in         IN VARCHAR2 DEFAULT NULL,                                           
                                comment_in            IN VARCHAR2 DEFAULT NULL,                                           
                                contact_in            IN VARCHAR2 DEFAULT NULL) IS

  l_target_type VARCHAR2(64);
  l_target_array   SMP_EMD_TGT_OBJECT_TBL;
BEGIN

  -- get the target type - the first and only in the list
  l_target_type := folder_types_in(1);
  
  -- call get_targets_summary2_db_hst for 'oracle_database'
  IF (l_target_type = MGMT_GLOBAL.G_DATABASE_TARGET_TYPE)
  THEN
      get_targets_summary2_db_hst(search_query_in, search_mode_in, 
                                  targets_cur_out,
                                  tgt_types_srch_lst_in,
                                  target_name_in,
                                  location_in,      
                                  lob_in,         
                                  deployment_in,
                                  comment_in,       
                                  contact_in);

  -- get targets_cur_out
  ELSIF(search_query_in IS NULL)
  THEN
    -- no search query 
    OPEN targets_cur_out FOR
    With tgt AS
    (
     select target_name, target_type, type_display_name, target_guid
       from mgmt_targets where target_type = l_target_type 
    )
      SELECT /*+ INDEX(tgt) */
             tgt.target_name,
             tgt.target_type,
             tgt.target_name as display_name,
             tgt.type_display_name,
             NVL(avail.current_status, MGMT_GLOBAL.G_STATUS_UNKNOWN) cur_status,
             tgt.target_guid,
             NVL(alltgt.warning_count,0) AS warning_count,
             NVL(alltgt.critical_count,0) AS critical_count,
             NVL(allpolicy.information_count, 0) AS policy_information_count,             
             NVL(allpolicy.warning_count, 0) AS policy_warning_count,
             NVL(allpolicy.critical_count, 0) AS policy_critical_count,
             NVL(allpolicy.compliance_score, -1) as target_compliance_score
        FROM tgt,
             MGMT_CURRENT_AVAILABILITY avail,
             (SELECT SUM(DECODE(vio.violation_level,MGMT_GLOBAL.G_SEVERITY_WARNING,1,0)) warning_count,
                     SUM(DECODE(vio.violation_level,MGMT_GLOBAL.G_SEVERITY_CRITICAL,1,0)) critical_count,
                     vio.target_guid tguid
                FROM mgmt_current_violation vio, tgt
               WHERE vio.target_guid = tgt.target_guid
                 AND vio.violation_type in (0, 1, 2)
               GROUP BY vio.target_guid ) alltgt,
             (SELECT /*+ INDEX(r) INDEX(e) */
                     SUM(DECODE(e.max_violation_level,MGMT_GLOBAL.G_SEVERITY_INFORMATIONAL,e.non_exempt_violations_logged,0)) information_count,
                     SUM(DECODE(e.max_violation_level,MGMT_GLOBAL.G_SEVERITY_WARNING,e.non_exempt_violations_logged,0)) warning_count,
                     SUM(DECODE(e.max_violation_level,MGMT_GLOBAL.G_SEVERITY_CRITICAL,e.non_exempt_violations_logged,0)) critical_count,
                     ROUND(AVG(compliance_score)) as compliance_score,
                     e.target_guid tguid
                FROM mgmt_policy_assoc_eval_summ e, mgmt_policies r, tgt
                WHERE r.policy_guid = e.policy_guid AND r.policy_type = MGMT_GLOBAL.G_TYPE_POLICY 
                  AND tgt.target_guid = e.target_guid
               GROUP BY e.target_guid ) allpolicy                            
       WHERE tgt.target_guid = alltgt.tguid (+)
         AND tgt.target_guid = avail.target_guid (+)
         AND tgt.target_guid = allpolicy.tguid(+)         
       ORDER BY tgt.target_name;
  ELSE
    -- search target query provided
    l_target_array := get_targets(search_query_in,
                                  search_mode_in,
                                  tgt_types_srch_lst_in,
                                  target_name_in,
                                  location_in,
                                  lob_in,
                                  deployment_in,
                                  comment_in,
                                  contact_in);
    OPEN targets_cur_out FOR
    With tgt AS
    (
      SELECT /*+ CARDINALITY(t 10) */
             * FROM TABLE(CAST(l_target_array AS SMP_EMD_TGT_OBJECT_TBL)) t
    )
      SELECT 
             tgt.target_name,
             tgt.target_type,
             tgt.target_name as display_name,
             tgt.type_display_name,
             NVL(avail.current_status, MGMT_GLOBAL.G_STATUS_UNKNOWN) cur_status,
             tgt.target_guid,
             NVL(alltgt.warning_count,0) AS warning_count,
             NVL(alltgt.critical_count,0) AS critical_count,
             NVL(allpolicy.information_count, 0) AS policy_information_count,
             NVL(allpolicy.warning_count, 0) AS policy_warning_count,
             NVL(allpolicy.critical_count, 0) AS policy_critical_count,
             NVL(allpolicy.compliance_score, -1) as target_compliance_score
        FROM tgt,
             MGMT_CURRENT_AVAILABILITY avail,
             (SELECT SUM(DECODE(vio.violation_level,MGMT_GLOBAL.G_SEVERITY_WARNING,1,0)) warning_count,
                     SUM(DECODE(vio.violation_level,MGMT_GLOBAL.G_SEVERITY_CRITICAL,1,0)) critical_count,
                     vio.target_guid tguid
                FROM mgmt_current_violation vio, tgt
               WHERE vio.target_guid = tgt.target_guid
                 AND vio.violation_type in (0, 1, 2)
               GROUP BY vio.target_guid ) alltgt,
             (SELECT /*+ INDEX(r) INDEX(e) */
                     SUM(DECODE(e.max_violation_level,MGMT_GLOBAL.G_SEVERITY_INFORMATIONAL,e.non_exempt_violations_logged,0)) information_count,
                     SUM(DECODE(e.max_violation_level,MGMT_GLOBAL.G_SEVERITY_WARNING,e.non_exempt_violations_logged,0)) warning_count,
                     SUM(DECODE(e.max_violation_level,MGMT_GLOBAL.G_SEVERITY_CRITICAL,e.non_exempt_violations_logged,0)) critical_count,
                     ROUND(AVG(compliance_score)) as compliance_score,
                     e.target_guid tguid
                FROM mgmt_policy_assoc_eval_summ e, mgmt_policies r, tgt
                WHERE r.policy_guid = e.policy_guid AND r.policy_type = MGMT_GLOBAL.G_TYPE_POLICY              
                  AND tgt.target_guid = e.target_guid 
               GROUP BY e.target_guid ) allpolicy                            
      WHERE tgt.target_guid = alltgt.tguid (+)
        AND tgt.target_guid = avail.target_guid (+)
        AND tgt.target_guid = allpolicy.tguid(+)         
      ORDER BY tgt.target_name;
  END IF;
EXCEPTION
    WHEN OTHERS THEN
        RAISE_APPLICATION_ERROR(-20001, 'Error in get_targets_summary2');
END get_targets_summary2;

--
-- PROCEDURE: get_targets_summary3
--
-- PURPOSE:
--   This is used inside get_targets_summary for Case 3. See get_targets_summary.
--
-- IN Parameters:
--   SMP_EMD_STRING_ARRAY See get_targets_summary.
--   search_query_in: VARCHAR2 See get_targets_summary.
--
-- OUT Parameters:
--   targets_cur_out: cursorType See get_targets_summary.
--
PROCEDURE get_targets_summary3(folder_types_in IN SMP_EMD_STRING_ARRAY,
                               search_query_in IN VARCHAR2 DEFAULT NULL,
                               search_mode_in  IN VARCHAR2 DEFAULT NULL,
                               targets_cur_out OUT cursorType,
                                tgt_types_srch_lst_in IN SMP_EMD_STRING_ARRAY DEFAULT NULL,                               
                                target_name_in        IN VARCHAR2 DEFAULT NULL,                                           
                                location_in           IN VARCHAR2 DEFAULT NULL,                                           
                                lob_in                IN VARCHAR2 DEFAULT NULL,                                           
                                deployment_in         IN VARCHAR2 DEFAULT NULL,                                           
                                comment_in            IN VARCHAR2 DEFAULT NULL,
                                contact_in            IN VARCHAR2 DEFAULT NULL) IS
  l_target_type VARCHAR2(64);
  l_target_array   SMP_EMD_TGT_OBJECT_TBL;
BEGIN

  -- get the target type - first and the only one in the list
  l_target_type := folder_types_in(1);

  -- get targets_cur_out
  IF(search_query_in IS NULL)
  THEN
    -- no search target query
    OPEN targets_cur_out FOR
      SELECT /*+ INDEX(tgt) INDEX(avail) */
             tgt.target_name,
             tgt.target_type,
             tgt.target_name as display_name,
             tgt.type_display_name,
             NVL(avail.current_status,MGMT_GLOBAL.G_STATUS_UNKNOWN) cur_status,
             tgt.target_guid,
             NVL(alltgt.warning_count,0) + NVL(comptgt.warning_count,0) AS warning_count,
             NVL(alltgt.critical_count,0) + NVL(comptgt.critical_count,0) AS critical_count,
             DECODE(comptgt.has_member_status,1,1,0) has_member_status
        FROM mgmt_targets tgt,
             mgmt_current_availability avail,
             (SELECT SUM(DECODE(severity_code,MGMT_GLOBAL.G_SEVERITY_WARNING,1,0)) warning_count,
                     SUM(DECODE(severity_code,MGMT_GLOBAL.G_SEVERITY_CRITICAL,1,0)) critical_count,
                     target_guid tguid
                FROM mgmt_current_severity sev
               GROUP BY target_guid ) alltgt,
             (SELECT SUM(DECODE(cs.severity_code,MGMT_GLOBAL.G_SEVERITY_WARNING,1,0)) warning_count,
                     SUM(DECODE(cs.severity_code,MGMT_GLOBAL.G_SEVERITY_CRITICAL,1,0)) critical_count,
                     tm.source_target_guid tguid,
                     1 as has_member_status
                FROM mgmt_target_assocs tm, mgmt_current_severity cs,
                     mgmt_type_properties prop, mgmt_targets mt, mgmt_targets ct
               WHERE prop.property_name = 'memberDerivedAlert' AND
                     assoc_guid = MGMT_ASSOC.g_contains_guid AND
                     ct.target_guid = source_target_guid AND
                     mt.target_guid = assoc_target_guid AND
                     ct.target_type = prop.target_type AND
                     tm.assoc_target_guid = cs.target_guid
               GROUP BY tm.source_target_guid) comptgt
       WHERE tgt.target_type = l_target_type
         AND tgt.target_guid = avail.target_guid (+)
         AND tgt.target_guid = comptgt.tguid (+)
         AND tgt.target_guid = alltgt.tguid (+)
       ORDER BY tgt.target_name;
  ELSE
    -- search target query provided
    l_target_array := get_targets(search_query_in,
                                  search_mode_in,
                                  tgt_types_srch_lst_in,
                                  target_name_in,
                                  location_in,
                                  lob_in,
                                  deployment_in,
                                  comment_in,
                                  contact_in);
    OPEN targets_cur_out FOR
      SELECT /*+ INDEX(tgt) INDEX(avail) */
             tgt.target_name,
             tgt.target_type,
             tgt.target_name as display_name,
             tgt.type_display_name,
             NVL(avail.current_status,MGMT_GLOBAL.G_STATUS_UNKNOWN) cur_status,
             tgt.target_guid,
             NVL(alltgt.warning_count,0) + NVL(comptgt.warning_count,0) AS warning_count,
             NVL(alltgt.critical_count,0) + NVL(comptgt.critical_count,0) AS critical_count,
             DECODE(comptgt.has_member_status, 1, 1, 0) has_member_status
        FROM TABLE(CAST(l_target_array AS SMP_EMD_TGT_OBJECT_TBL)) tgt,
             mgmt_current_availability avail,
             (SELECT SUM(DECODE(severity_code,MGMT_GLOBAL.G_SEVERITY_WARNING,1,0)) warning_count,
                     SUM(DECODE(severity_code,MGMT_GLOBAL.G_SEVERITY_CRITICAL,1,0)) critical_count,
                     target_guid tguid
                FROM mgmt_current_severity
               GROUP BY target_guid ) alltgt,
             (SELECT SUM(DECODE(cs.severity_code,MGMT_GLOBAL.G_SEVERITY_WARNING,1,0)) warning_count,
                     SUM(DECODE(cs.severity_code,MGMT_GLOBAL.G_SEVERITY_CRITICAL,1,0)) critical_count,
                     tm.source_target_guid tguid,
                     1 as has_member_status
                FROM mgmt_target_assocs tm, mgmt_current_severity cs,
                     mgmt_type_properties prop, mgmt_targets mt, mgmt_targets ct
               WHERE prop.property_name = 'memberDerivedAlert' AND
                     assoc_guid = MGMT_ASSOC.g_contains_guid AND
                     ct.target_guid = source_target_guid AND
                     mt.target_guid = assoc_target_guid AND
                     ct.target_type = prop.target_type AND
                     tm.assoc_target_guid = cs.target_guid
               GROUP BY tm.source_target_guid) comptgt
       WHERE tgt.target_guid = avail.target_guid (+)
         AND tgt.target_guid = comptgt.tguid (+)
         AND tgt.target_guid = alltgt.tguid (+)
       ORDER BY tgt.target_name;
  END IF;
EXCEPTION
    WHEN OTHERS THEN
        RAISE_APPLICATION_ERROR(-20001, 'Error in get_targets_summary3');
END get_targets_summary3;

--
-- PROCEDURE: get_targets_summary4
--
-- PURPOSE:
--   This is used inside get_targets_summary for Case 4. See get_targets_summary.
--
-- IN Parameters:
--   SMP_EMD_STRING_ARRAY See get_targets_summary.
--   search_query_in: VARCHAR2 See get_targets_summary.
--
-- OUT Parameters:
--   targets_cur_out: cursorType See get_targets_summary.
--
PROCEDURE get_targets_summary4(folder_types_in IN SMP_EMD_STRING_ARRAY,
                               search_query_in IN VARCHAR2 DEFAULT NULL,
                               search_mode_in  IN VARCHAR2 DEFAULT NULL,
                               targets_cur_out OUT cursorType,
                                tgt_types_srch_lst_in IN SMP_EMD_STRING_ARRAY DEFAULT NULL,                               
                                target_name_in        IN VARCHAR2 DEFAULT NULL,                                           
                                location_in           IN VARCHAR2 DEFAULT NULL,                                           
                                lob_in                IN VARCHAR2 DEFAULT NULL,                                           
                                deployment_in         IN VARCHAR2 DEFAULT NULL,                                           
                                comment_in            IN VARCHAR2 DEFAULT NULL,
                                contact_in            IN VARCHAR2 DEFAULT NULL) IS

    l_target_array   SMP_EMD_TGT_OBJECT_TBL;
BEGIN

  IF(search_query_in IS NULL)
  THEN
    -- no search target query
    OPEN targets_cur_out FOR
      SELECT /*+ INDEX(tgt) INDEX(avail) */
             tgt.target_name,
             tgt.target_type,
             tgt.target_name as display_name,
             tgt.type_display_name,
             NVL(avail.current_status,MGMT_GLOBAL.G_STATUS_UNKNOWN) cur_status,
             tgt.target_guid,
             NVL(alltgt.warning_count,0) AS warning_count,
             NVL(alltgt.critical_count,0) AS critical_count,
             NVL(allpolicy.information_count, 0) AS policy_information_count,
             NVL(allpolicy.warning_count, 0) AS policy_warning_count,
             NVL(allpolicy.critical_count, 0) AS policy_critical_count,
             NVL(allpolicy.compliance_score, -1) as target_compliance_score
        FROM ( SELECT target_name, target_type, target_guid,
                      target_name as display_name, type_display_name
                 FROM mgmt_targets
                WHERE target_type IN
                      ( SELECT *
                          FROM  TABLE(CAST(folder_types_in AS SMP_EMD_STRING_ARRAY)))) tgt,
             mgmt_current_availability avail,
             (SELECT SUM(DECODE(severity_code,MGMT_GLOBAL.G_SEVERITY_WARNING,1,0)) warning_count,
                     SUM(DECODE(severity_code,MGMT_GLOBAL.G_SEVERITY_CRITICAL,1,0)) critical_count,
                     target_guid tguid
                FROM mgmt_current_severity
               GROUP BY target_guid ) alltgt,              
             (SELECT SUM(DECODE(e.max_violation_level,MGMT_GLOBAL.G_SEVERITY_INFORMATIONAL,e.non_exempt_violations_logged,0)) information_count,
                     SUM(DECODE(e.max_violation_level,MGMT_GLOBAL.G_SEVERITY_WARNING,e.non_exempt_violations_logged,0)) warning_count,
                     SUM(DECODE(e.max_violation_level,MGMT_GLOBAL.G_SEVERITY_CRITICAL,e.non_exempt_violations_logged,0)) critical_count,
                     ROUND(AVG(compliance_score)) as compliance_score,
                     e.target_guid tguid
                FROM mgmt_policy_assoc_eval_summ e, mgmt_policies r
                WHERE r.policy_guid = e.policy_guid AND r.policy_type = MGMT_GLOBAL.G_TYPE_POLICY              
               GROUP BY target_guid ) allpolicy                            
      WHERE tgt.target_guid = avail.target_guid (+)
         AND tgt.target_guid = alltgt.tguid (+)
         AND tgt.target_guid = allpolicy.tguid(+)           
       ORDER BY tgt.target_name;
  ELSE
    -- search target query provided
    l_target_array := get_targets(search_query_in,
                                  search_mode_in,
                                  tgt_types_srch_lst_in,
                                  target_name_in,
                                  location_in,
                                  lob_in,
                                  deployment_in,
                                  comment_in,
                                  contact_in);
    OPEN targets_cur_out FOR
      SELECT /*+ INDEX(tgt) INDEX(avail) */
             tgt.target_name,
             tgt.target_type,
             tgt.target_name as display_name,
             tgt.type_display_name,
             NVL(avail.current_status,MGMT_GLOBAL.G_STATUS_UNKNOWN) cur_status,
             tgt.target_guid,
             NVL(alltgt.warning_count, 0) AS warning_count,
             NVL(alltgt.critical_count, 0) AS critical_count,
             NVL(allpolicy.information_count, 0) AS policy_information_count,
             NVL(allpolicy.warning_count, 0) AS policy_warning_count,
             NVL(allpolicy.critical_count, 0) AS policy_critical_count,
             NVL(allpolicy.compliance_score, -1) as target_compliance_score
        FROM ( SELECT target_name, target_type, target_guid,
                      target_name as display_name, type_display_name
                 FROM TABLE(CAST(l_target_array AS SMP_EMD_TGT_OBJECT_TBL))
             ) tgt,
             mgmt_current_availability avail,
             (SELECT SUM(DECODE(severity_code,MGMT_GLOBAL.G_SEVERITY_WARNING,1,0)) warning_count,
                     SUM(DECODE(severity_code,MGMT_GLOBAL.G_SEVERITY_CRITICAL,1,0)) critical_count,
                     target_guid tguid
                FROM mgmt_current_severity
               GROUP BY target_guid ) alltgt,
             (SELECT SUM(DECODE(e.max_violation_level,MGMT_GLOBAL.G_SEVERITY_INFORMATIONAL,e.non_exempt_violations_logged,0)) information_count,
                     SUM(DECODE(e.max_violation_level,MGMT_GLOBAL.G_SEVERITY_WARNING,e.non_exempt_violations_logged,0)) warning_count,
                     SUM(DECODE(e.max_violation_level,MGMT_GLOBAL.G_SEVERITY_CRITICAL,e.non_exempt_violations_logged,0)) critical_count,
                     ROUND(AVG(compliance_score)) as compliance_score,
                     e.target_guid tguid
                FROM mgmt_policy_assoc_eval_summ e, mgmt_policies r
                WHERE r.policy_guid = e.policy_guid AND r.policy_type = MGMT_GLOBAL.G_TYPE_POLICY              
               GROUP BY target_guid ) allpolicy                            
      WHERE tgt.target_guid = avail.target_guid (+)
         AND tgt.target_guid = alltgt.tguid (+)
         AND tgt.target_guid = allpolicy.tguid(+)           
       ORDER BY tgt.target_name;
  END IF;
EXCEPTION
    WHEN OTHERS THEN
        RAISE_APPLICATION_ERROR(-20001, 'Error in get_targets_summary4');
END get_targets_summary4;

--
-- PROCEDURE: get_targets_summary5
--
-- PURPOSE:
--   This is used inside get_targets_summary for Case 5. See get_targets_summary.
--
-- IN Parameters:
--   SMP_EMD_STRING_ARRAY See get_targets_summary.
--   search_query_in: VARCHAR2 See get_targets_summary.
--
-- OUT Parameters:
--   targets_cur_out: cursorType See get_targets_summary.
--
PROCEDURE get_targets_summary5(folder_types_in IN SMP_EMD_STRING_ARRAY,
                               search_query_in IN VARCHAR2 DEFAULT NULL,
                               search_mode_in  IN VARCHAR2 DEFAULT NULL,
                               targets_cur_out OUT cursorType,
                                tgt_types_srch_lst_in IN SMP_EMD_STRING_ARRAY DEFAULT NULL,                               
                                target_name_in        IN VARCHAR2 DEFAULT NULL,                                           
                                location_in           IN VARCHAR2 DEFAULT NULL,                                           
                                lob_in                IN VARCHAR2 DEFAULT NULL,                                           
                                deployment_in         IN VARCHAR2 DEFAULT NULL,                                           
                                comment_in            IN VARCHAR2 DEFAULT NULL,
                                contact_in            IN VARCHAR2 DEFAULT NULL) IS
    
    l_target_array   SMP_EMD_TGT_OBJECT_TBL;
BEGIN

  IF(search_query_in IS NULL)
  THEN
  -- no search target query
  -- Breaking this query into 2 parts because of performance problems.
  -- 1st case: Restricting the query to get the target types to 10 records so that it increases selectivity.
  -- 2nd case: Leave the existing query as is. This will happen when there are large number of target types (more than 10) under the 
  --           Groups / Systems tabs.
        OPEN targets_cur_out FOR
        WITH tgts AS
            (SELECT /*+ CARDINALITY(t1 10) */ mt.target_name AS target_name,
                    mt.target_type AS target_type,
                    mt.target_guid AS target_guid,
                    mt.target_name AS display_name,
                    mt.type_display_name AS type_display_name
            FROM mgmt_targets   mt,
                 TABLE(CAST(folder_types_in AS SMP_EMD_STRING_ARRAY)) t1
            WHERE target_type = column_value),
        fltgts AS
            (SELECT tgts.target_guid AS target_guid,
                     mfta.assoc_target_guid
            FROM mgmt_flat_target_assoc mfta, 
                 tgts
            WHERE tgts.target_guid = mfta.source_target_guid
              AND is_membership = 1)
            SELECT tgts.target_name, 
                   tgts.target_type, 
                   tgts.display_name,
                   tgts.type_display_name,
                   MGMT_GLOBAL.G_STATUS_UNKNOWN as cur_status,
                   tgts.target_guid,
                   NVL(warning_count,0) AS warning_count,
                   NVL(critical_count,0) AS critical_count,
                   DECODE(alertstab.has_member_status,1,1,0) AS has_member_status,
                   NVL(policy_information_count,0) AS policy_information_count,
                   NVL(policy_warning_count,0) AS policy_warning_count,
                   NVL(policy_critical_count,0) AS policy_critical_count
            FROM tgts,
                    (SELECT SUM(DECODE(mcs.severity_code,MGMT_GLOBAL.G_SEVERITY_WARNING,1,0)) warning_count,
                            SUM(DECODE(mcs.severity_code,MGMT_GLOBAL.G_SEVERITY_CRITICAL,1,0)) critical_count,
                            fltgts.target_guid  tgtguid,
                            1 as has_member_status
                    FROM fltgts ,
                         mgmt_current_severity mcs,
                         mgmt_current_availability mca
                    WHERE fltgts.assoc_target_guid = mcs.target_guid(+)
                      AND fltgts.assoc_target_guid = mca.target_guid
                      AND mca.current_status  = MGMT_GLOBAL.G_STATUS_UP
                      AND mcs.severity_type = 0
                    GROUP BY fltgts.target_guid) alertstab,
                    (SELECT fltgts.target_guid, 
                           SUM(DECODE(e.max_violation_level,MGMT_GLOBAL.G_SEVERITY_INFORMATIONAL,e.non_exempt_violations_logged,0)) policy_information_count,
                           SUM(DECODE(e.max_violation_level,MGMT_GLOBAL.G_SEVERITY_WARNING, e.non_exempt_violations_logged,0)) policy_warning_count,
                           SUM(DECODE(e.max_violation_level,MGMT_GLOBAL.G_SEVERITY_CRITICAL,e.non_exempt_violations_logged,0))  policy_critical_count
                    FROM    mgmt_policy_assoc_eval_summ e,
                            mgmt_policies p,
                            fltgts
                    WHERE   e.policy_guid = p.policy_guid
                        AND p.policy_type = MGMT_GLOBAL.G_TYPE_POLICY
                        AND fltgts.assoc_target_guid = e.target_guid
                    GROUP BY fltgts.target_guid) policytab
            WHERE alertstab.tgtguid(+) =  tgts.target_guid
              AND policytab.target_guid(+) =  tgts.target_guid
            ORDER BY  tgts.target_name;
  ELSE
    -- search target query provided
    l_target_array := get_targets(search_query_in,
                                  search_mode_in,
                                  tgt_types_srch_lst_in,
                                  target_name_in,
                                  location_in,
                                  lob_in,
                                  deployment_in,
                                  comment_in,
                                  contact_in);
    OPEN targets_cur_out FOR
            SELECT /*+ CARDINALITY(tgts 100) */
                   tgts.target_name, 
                   tgts.target_type, 
                   tgts.display_name,
                   tgts.type_display_name,
                   MGMT_GLOBAL.G_STATUS_UNKNOWN as cur_status,
                   tgts.target_guid,
                   NVL(warning_count,0) AS warning_count,
                   NVL(critical_count,0) AS critical_count,
                   DECODE(alertstab.has_member_status,1,1,0) AS has_member_status,
                   NVL(policy_information_count,0) AS policy_information_count,
                   NVL(policy_warning_count,0) AS policy_warning_count,
                   NVL(policy_critical_count,0) AS policy_critical_count 
            FROM TABLE(CAST(l_target_array AS SMP_EMD_TGT_OBJECT_TBL)) tgts,
                (SELECT /*+ CARDINALITY(tgts 100) */
                        SUM(DECODE(mcs.violation_level,MGMT_GLOBAL.G_SEVERITY_WARNING,1,0)) warning_count,
                        SUM(DECODE(mcs.violation_level,MGMT_GLOBAL.G_SEVERITY_CRITICAL,1,0)) critical_count,
                        tgts.target_guid tgtguid,
                        1 as has_member_status
                FROM TABLE(CAST(l_target_array AS SMP_EMD_TGT_OBJECT_TBL)) tgts,
                     mgmt_flat_target_assoc mfta,
                     mgmt_current_violation mcs,
                     mgmt_current_availability mca
                WHERE mfta.is_membership = 1
                  AND mfta.source_target_guid = tgts.target_guid
                  AND mfta.assoc_target_guid = mcs.target_guid(+)
                  AND mfta.assoc_target_guid = mca.target_guid
                  AND mca.current_status  = MGMT_GLOBAL.G_STATUS_UP
                  AND mcs.violation_type = 0
                  AND mcs.violation_level IN (MGMT_GLOBAL.G_SEVERITY_WARNING,
                                              MGMT_GLOBAL.G_SEVERITY_CRITICAL)
                GROUP BY tgts.target_guid) alertstab,
                (SELECT  /*+ CARDINALITY(tgts 100) */ 
                       tgts.target_guid, 
                       SUM(DECODE(e.max_violation_level,MGMT_GLOBAL.G_SEVERITY_INFORMATIONAL,
                                    e.non_exempt_violations_logged,0)) policy_information_count,
                       SUM(DECODE(e.max_violation_level,MGMT_GLOBAL.G_SEVERITY_WARNING, 
                                    e.non_exempt_violations_logged,0)) policy_warning_count,
                       SUM(DECODE(e.max_violation_level,MGMT_GLOBAL.G_SEVERITY_CRITICAL,
                                    e.non_exempt_violations_logged,0))  policy_critical_count
                FROM    mgmt_policy_assoc_eval_summ e,
                        mgmt_policies p,
                        TABLE(CAST(l_target_array AS SMP_EMD_TGT_OBJECT_TBL)) tgts,
                        mgmt_flat_target_assoc mfta
                WHERE  mfta.is_membership = 1
                   AND mfta.source_target_guid = tgts.target_guid
                   AND mfta.assoc_target_guid = e.target_guid
                   AND e.policy_guid = p.policy_guid
                   AND p.policy_type = MGMT_GLOBAL.G_TYPE_POLICY
                GROUP BY tgts.target_guid) policytab
            WHERE alertstab.tgtguid(+) =  tgts.target_guid
              AND policytab.target_guid(+) =  tgts.target_guid
            ORDER BY tgts.target_name;
  END IF;
  EXCEPTION
    WHEN OTHERS THEN
        RAISE_APPLICATION_ERROR(-20001, 'Error in get_targets_summary5');
END get_targets_summary5;

--
-- PROCEDURE: get_targets_summary6
--
-- PURPOSE:
--   This is used inside get_targets_summary for Case 6. See get_targets_summary.
--
-- IN Parameters:
--   SMP_EMD_STRING_ARRAY See get_targets_summary.
--   search_query_in: VARCHAR2 See get_targets_summary.
--
-- OUT Parameters:
--   targets_cur_out: cursorType See get_targets_summary.
--
PROCEDURE get_targets_summary6(folder_types_in IN SMP_EMD_STRING_ARRAY,
                               search_query_in IN VARCHAR2 DEFAULT NULL,
                               search_mode_in  IN VARCHAR2 DEFAULT NULL,
                               targets_cur_out OUT cursorType,
                                tgt_types_srch_lst_in IN SMP_EMD_STRING_ARRAY DEFAULT NULL,                               
                                target_name_in        IN VARCHAR2 DEFAULT NULL,                                           
                                location_in           IN VARCHAR2 DEFAULT NULL,                                           
                                lob_in                IN VARCHAR2 DEFAULT NULL,                                           
                                deployment_in         IN VARCHAR2 DEFAULT NULL,                                           
                                comment_in            IN VARCHAR2 DEFAULT NULL,
                                contact_in            IN VARCHAR2 DEFAULT NULL) IS

    l_target_array   SMP_EMD_TGT_OBJECT_TBL;
BEGIN

  IF(search_query_in IS NULL)
  THEN
    -- no search target query
     IF (folder_types_in.COUNT < 11) THEN
        OPEN targets_cur_out FOR
          SELECT /*+ INDEX(tgt) INDEX(avail) */
                 tgt.target_name,
                 tgt.target_type,
                 tgt.target_name as display_name,
                 tgt.type_display_name,
                 NVL(avail.current_status,MGMT_GLOBAL.G_STATUS_UNKNOWN) cur_status,
                 tgt.target_guid,
                 NVL(allperf.warning_count,0) AS perf_warning_count,
                 NVL(allperf.critical_count,0) AS perf_critical_count,
                 NVL(allusage.warning_count,0) AS usage_warning_count,
                 NVL(allusage.critical_count,0) AS usage_critical_count,             
                 NVL(allpolicy.information_count, 0) AS policy_information_count,
                 NVL(allpolicy.warning_count, 0) AS policy_warning_count,
                 NVL(allpolicy.critical_count, 0) AS policy_critical_count,
                 sys.target_name AS system_target_name,
                 sys.target_type AS system_target_type,
                 NVL(sysavail.up_count, 0) AS sys_up_count,
                 NVL(sysavail.down_count, 0) AS sys_down_count,
                 NVL(sysavail.error_count, 0) AS sys_error_count,
                 NVL(sysavail.agent_down_count, 0) AS sys_agent_down_count,
                 NVL(sysavail.unreachable_count, 0) AS sys_unreachable_count,
                 NVL(sysavail.blackout_count, 0) AS sys_blackout_count,      
                 NVL(sysavail.unknown_count, 0) AS sys_unknown_count,        
                 NVL(sysalert.warning_count, 0) AS sys_warning_count,
                 NVL(sysalert.critical_count, 0) AS sys_critical_count
            FROM ( SELECT target_name, target_type, target_guid,
                          target_name as display_name, type_display_name
                     FROM mgmt_targets
                    WHERE   EXISTS
                        ( 
                            SELECT  'x'
                            FROM    TABLE(CAST(folder_types_in AS SMP_EMD_STRING_ARRAY ))
                            WHERE   column_value = target_type and rownum <11)) tgt,
                 mgmt_current_availability avail,
                 (SELECT SUM(DECODE(severity_code,MGMT_GLOBAL.G_SEVERITY_WARNING,1,0)) warning_count,
                         SUM(DECODE(severity_code,MGMT_GLOBAL.G_SEVERITY_CRITICAL,1,0)) critical_count,
                         t.target_guid tguid
                    FROM mgmt_current_severity s,
                         mgmt_metrics m,
                         mgmt_targets t,
                         mgmt_category_map c
                    WHERE m.metric_guid = s.metric_guid
                      AND t.target_type = m.target_type
                      AND m.type_meta_ver = t.type_meta_ver
                      AND c.type_meta_ver = t.type_meta_ver
                      AND (m.category_prop_1 = ' ' OR m.category_prop_1 = t.category_prop_1)
                      AND (m.category_prop_2 = ' ' OR m.category_prop_2 = t.category_prop_2)
                      AND (m.category_prop_3 = ' ' OR m.category_prop_3 = t.category_prop_3)
                      AND (m.category_prop_4 = ' ' OR m.category_prop_4 = t.category_prop_4)
                      AND (m.category_prop_5 = ' ' OR m.category_prop_5 = t.category_prop_5)
                      AND m.metric_guid = c.object_guid
                      AND c.object_type = mgmt_global.G_TYPE_THRESHOLD_METRIC
                      AND c.class_name = mgmt_global.G_CATEGORY_CLASS_SERVICE
                      AND c.category_name = mgmt_global.G_SERVICE_CATEGORY_PERFORMANCE
                      AND s.target_guid = t.target_guid
                      AND s.metric_guid = m.metric_guid
                   GROUP BY t.target_guid ) allperf,
                 (SELECT SUM(DECODE(severity_code,MGMT_GLOBAL.G_SEVERITY_WARNING,1,0)) warning_count,
                         SUM(DECODE(severity_code,MGMT_GLOBAL.G_SEVERITY_CRITICAL,1,0)) critical_count,
                         t.target_guid tguid
                    FROM mgmt_current_severity s,
                         mgmt_metrics m,
                         mgmt_targets t,
                         mgmt_category_map c
                    WHERE m.metric_guid = s.metric_guid
                      AND t.target_type = m.target_type
                      AND m.type_meta_ver = t.type_meta_ver
                      AND c.type_meta_ver = t.type_meta_ver
                      AND (m.category_prop_1 = ' ' OR m.category_prop_1 = t.category_prop_1)
                      AND (m.category_prop_2 = ' ' OR m.category_prop_2 = t.category_prop_2)
                      AND (m.category_prop_3 = ' ' OR m.category_prop_3 = t.category_prop_3)
                      AND (m.category_prop_4 = ' ' OR m.category_prop_4 = t.category_prop_4)
                      AND (m.category_prop_5 = ' ' OR m.category_prop_5 = t.category_prop_5)
                      AND m.metric_guid = c.object_guid
                      AND c.object_type = mgmt_global.G_TYPE_THRESHOLD_METRIC
                      AND c.class_name = mgmt_global.G_CATEGORY_CLASS_SERVICE
                      AND c.category_name = mgmt_global.G_SERVICE_CATEGORY_USAGE
                      AND s.target_guid = t.target_guid
                      AND s.metric_guid = m.metric_guid
                  GROUP BY t.target_guid ) allusage,            
                 (SELECT 
                        SUM(DECODE(e.max_violation_level,MGMT_GLOBAL.G_SEVERITY_INFORMATIONAL,
                            e.non_exempt_violations_logged,0)) information_count,
                        SUM(DECODE(e.max_violation_level,MGMT_GLOBAL.G_SEVERITY_WARNING,
                            e.non_exempt_violations_logged,0)) warning_count,
                        SUM(DECODE(e.max_violation_level,MGMT_GLOBAL.G_SEVERITY_CRITICAL,
                            e.non_exempt_violations_logged,0))critical_count,
                        target_guid tguid
                    FROM mgmt_policy_assoc_eval_summ e,mgmt_policies p
                    WHERE e.policy_guid = p.policy_guid 
                     AND p.policy_type = MGMT_GLOBAL.G_TYPE_POLICY                    
                    GROUP BY target_guid ) allpolicy,  
                 (SELECT t.target_name, t.target_type, a.source_target_guid tguid
                    FROM mgmt_target_assocs a, 
                         mgmt_targets t
                   WHERE a.assoc_guid = MGMT_ASSOC.g_runs_on_guid
                     AND t.target_guid = a.assoc_target_guid) sys,
                 (SELECT SUM(DECODE(current_status, MGMT_GLOBAL.G_STATUS_UP,1,0)) up_count,
                         SUM(DECODE(current_status, MGMT_GLOBAL.G_STATUS_DOWN,1,0)) down_count,
                         SUM(DECODE(current_status, MGMT_GLOBAL.G_STATUS_ERROR, 1, 0)) AS error_count,
                         SUM(DECODE(current_status, MGMT_GLOBAL.G_STATUS_AGENT_DOWN, 1, 0)) AS agent_down_count,
                         SUM(DECODE(current_status, MGMT_GLOBAL.G_STATUS_UNREACHABLE, 1, 0)) AS unreachable_count,
                         SUM(DECODE(current_status, MGMT_GLOBAL.G_STATUS_BLACKOUT, 1, 0)) AS blackout_count,
                         SUM(DECODE(current_status, MGMT_GLOBAL.G_STATUS_UNKNOWN, 1, 0)) AS unknown_count,
                         a.source_target_guid tguid
                    FROM mgmt_current_availability c,
                         mgmt_target_assocs a
                   WHERE c.target_guid = a.assoc_target_guid
                     AND a.assoc_guid = MGMT_ASSOC.g_depends_on_guid
                    GROUP BY a.source_target_guid) sysavail,
                 (SELECT SUM(DECODE(severity_code,MGMT_GLOBAL.G_SEVERITY_WARNING,1,0)) warning_count,
                         SUM(DECODE(severity_code,MGMT_GLOBAL.G_SEVERITY_CRITICAL,1,0)) critical_count,
                         a.source_target_guid tguid
                   FROM mgmt_current_severity s,
                        mgmt_target_assocs a
                  WHERE a.assoc_guid = MGMT_ASSOC.g_depends_on_guid
                    AND s.target_guid = a.assoc_target_guid
                    AND s.severity_type <> MGMT_GLOBAL.G_SEVERITY_TYPE_AVAILABILITY
                  GROUP BY a.source_target_guid) sysalert
           WHERE tgt.target_guid = avail.target_guid (+)
             AND tgt.target_guid = allperf.tguid (+)
             AND tgt.target_guid = allusage.tguid (+)
             AND tgt.target_guid = allpolicy.tguid(+)
             AND tgt.target_guid = sys.tguid(+)
             AND tgt.target_guid = sysavail.tguid(+)    
             AND tgt.target_guid = sysalert.tguid(+)
            ORDER BY tgt.target_name;
     ELSE
	OPEN targets_cur_out FOR
          SELECT /*+ INDEX(tgt) INDEX(avail) */
                 tgt.target_name,
                 tgt.target_type,
                 tgt.target_name as display_name,
                 tgt.type_display_name,
                 NVL(avail.current_status,MGMT_GLOBAL.G_STATUS_UNKNOWN) cur_status,
                 tgt.target_guid,
                 NVL(allperf.warning_count,0) AS perf_warning_count,
                 NVL(allperf.critical_count,0) AS perf_critical_count,
                 NVL(allusage.warning_count,0) AS usage_warning_count,
                 NVL(allusage.critical_count,0) AS usage_critical_count,             
                 NVL(allpolicy.information_count, 0) AS policy_information_count,
                 NVL(allpolicy.warning_count, 0) AS policy_warning_count,
                 NVL(allpolicy.critical_count, 0) AS policy_critical_count,
                 sys.target_name AS system_target_name,
                 sys.target_type AS system_target_type,
                 NVL(sysavail.up_count, 0) AS sys_up_count,
                 NVL(sysavail.down_count, 0) AS sys_down_count,
                 NVL(sysavail.error_count, 0) AS sys_error_count,
                 NVL(sysavail.agent_down_count, 0) AS sys_agent_down_count,
                 NVL(sysavail.unreachable_count, 0) AS sys_unreachable_count,
                 NVL(sysavail.blackout_count, 0) AS sys_blackout_count,      
                 NVL(sysavail.unknown_count, 0) AS sys_unknown_count,        
                 NVL(sysalert.warning_count, 0) AS sys_warning_count,
                 NVL(sysalert.critical_count, 0) AS sys_critical_count
            FROM ( SELECT target_name, target_type, target_guid,
                          target_name as display_name, type_display_name
                     FROM mgmt_targets
		     WHERE EXISTS
                        ( 
                            SELECT  'x'
                            FROM    TABLE(CAST(folder_types_in AS SMP_EMD_STRING_ARRAY ))
                            WHERE   column_value = target_type)) tgt,
                 mgmt_current_availability avail,
                 (SELECT SUM(DECODE(severity_code,MGMT_GLOBAL.G_SEVERITY_WARNING,1,0)) warning_count,
                         SUM(DECODE(severity_code,MGMT_GLOBAL.G_SEVERITY_CRITICAL,1,0)) critical_count,
                         t.target_guid tguid
                    FROM mgmt_current_severity s,
                         mgmt_metrics m,
                         mgmt_targets t,
                         mgmt_category_map c
                    WHERE m.metric_guid = s.metric_guid
                      AND t.target_type = m.target_type
                      AND m.type_meta_ver = t.type_meta_ver
                      AND c.type_meta_ver = t.type_meta_ver
                      AND (m.category_prop_1 = ' ' OR m.category_prop_1 = t.category_prop_1)
                      AND (m.category_prop_2 = ' ' OR m.category_prop_2 = t.category_prop_2)
                      AND (m.category_prop_3 = ' ' OR m.category_prop_3 = t.category_prop_3)
                      AND (m.category_prop_4 = ' ' OR m.category_prop_4 = t.category_prop_4)
                      AND (m.category_prop_5 = ' ' OR m.category_prop_5 = t.category_prop_5)
                      AND m.metric_guid = c.object_guid
                      AND c.object_type = mgmt_global.G_TYPE_THRESHOLD_METRIC
                      AND c.class_name = mgmt_global.G_CATEGORY_CLASS_SERVICE
                      AND c.category_name = mgmt_global.G_SERVICE_CATEGORY_PERFORMANCE
                      AND s.target_guid = t.target_guid
                      AND s.metric_guid = m.metric_guid
                   GROUP BY t.target_guid ) allperf,
                 (SELECT SUM(DECODE(severity_code,MGMT_GLOBAL.G_SEVERITY_WARNING,1,0)) warning_count,
                         SUM(DECODE(severity_code,MGMT_GLOBAL.G_SEVERITY_CRITICAL,1,0)) critical_count,
                         t.target_guid tguid
                    FROM mgmt_current_severity s,
                         mgmt_metrics m,
                         mgmt_targets t,
                         mgmt_category_map c
                    WHERE m.metric_guid = s.metric_guid
                      AND t.target_type = m.target_type
                      AND m.type_meta_ver = t.type_meta_ver
                      AND c.type_meta_ver = t.type_meta_ver
                      AND (m.category_prop_1 = ' ' OR m.category_prop_1 = t.category_prop_1)
                      AND (m.category_prop_2 = ' ' OR m.category_prop_2 = t.category_prop_2)
                      AND (m.category_prop_3 = ' ' OR m.category_prop_3 = t.category_prop_3)
                      AND (m.category_prop_4 = ' ' OR m.category_prop_4 = t.category_prop_4)
                      AND (m.category_prop_5 = ' ' OR m.category_prop_5 = t.category_prop_5)
                      AND m.metric_guid = c.object_guid
                      AND c.object_type = mgmt_global.G_TYPE_THRESHOLD_METRIC
                      AND c.class_name = mgmt_global.G_CATEGORY_CLASS_SERVICE
                      AND c.category_name = mgmt_global.G_SERVICE_CATEGORY_USAGE
                      AND s.target_guid = t.target_guid
                      AND s.metric_guid = m.metric_guid
                  GROUP BY t.target_guid ) allusage,            
                 (SELECT 
                        SUM(DECODE(e.max_violation_level,MGMT_GLOBAL.G_SEVERITY_INFORMATIONAL,
                            e.non_exempt_violations_logged,0)) information_count,
                        SUM(DECODE(e.max_violation_level,MGMT_GLOBAL.G_SEVERITY_WARNING,
                            e.non_exempt_violations_logged,0)) warning_count,
                        SUM(DECODE(e.max_violation_level,MGMT_GLOBAL.G_SEVERITY_CRITICAL,
                            e.non_exempt_violations_logged,0))critical_count,
                        target_guid tguid
                    FROM mgmt_policy_assoc_eval_summ e,mgmt_policies p
                    WHERE e.policy_guid = p.policy_guid 
                     AND p.policy_type = MGMT_GLOBAL.G_TYPE_POLICY                    
                    GROUP BY target_guid ) allpolicy,  
                 (SELECT t.target_name, t.target_type, a.source_target_guid tguid
                    FROM mgmt_target_assocs a, 
                         mgmt_targets t
                   WHERE a.assoc_guid = MGMT_ASSOC.g_runs_on_guid
                     AND t.target_guid = a.assoc_target_guid) sys,
                 (SELECT SUM(DECODE(current_status, MGMT_GLOBAL.G_STATUS_UP,1,0)) up_count,
                         SUM(DECODE(current_status, MGMT_GLOBAL.G_STATUS_DOWN,1,0)) down_count,
                         SUM(DECODE(current_status, MGMT_GLOBAL.G_STATUS_ERROR, 1, 0)) AS error_count,
                         SUM(DECODE(current_status, MGMT_GLOBAL.G_STATUS_AGENT_DOWN, 1, 0)) AS agent_down_count,
                         SUM(DECODE(current_status, MGMT_GLOBAL.G_STATUS_UNREACHABLE, 1, 0)) AS unreachable_count,
                         SUM(DECODE(current_status, MGMT_GLOBAL.G_STATUS_BLACKOUT, 1, 0)) AS blackout_count,
                         SUM(DECODE(current_status, MGMT_GLOBAL.G_STATUS_UNKNOWN, 1, 0)) AS unknown_count,
                         a.source_target_guid tguid
                    FROM mgmt_current_availability c,
                         mgmt_target_assocs a
                   WHERE c.target_guid = a.assoc_target_guid
                     AND a.assoc_guid = MGMT_ASSOC.g_depends_on_guid
                    GROUP BY a.source_target_guid) sysavail,
                 (SELECT SUM(DECODE(severity_code,MGMT_GLOBAL.G_SEVERITY_WARNING,1,0)) warning_count,
                         SUM(DECODE(severity_code,MGMT_GLOBAL.G_SEVERITY_CRITICAL,1,0)) critical_count,
                         a.source_target_guid tguid
                   FROM mgmt_current_severity s,
                        mgmt_target_assocs a
                  WHERE a.assoc_guid = MGMT_ASSOC.g_depends_on_guid
                    AND s.target_guid = a.assoc_target_guid
                    AND s.severity_type <> MGMT_GLOBAL.G_SEVERITY_TYPE_AVAILABILITY
                  GROUP BY a.source_target_guid) sysalert
           WHERE tgt.target_guid = avail.target_guid (+)
             AND tgt.target_guid = allperf.tguid (+)
             AND tgt.target_guid = allusage.tguid (+)
             AND tgt.target_guid = allpolicy.tguid(+)
             AND tgt.target_guid = sys.tguid(+)
             AND tgt.target_guid = sysavail.tguid(+)    
             AND tgt.target_guid = sysalert.tguid(+)
            ORDER BY tgt.target_name;
     END IF;	   
  ELSE
    -- search target query provided
    l_target_array := get_targets(search_query_in,
                                  search_mode_in,
                                  tgt_types_srch_lst_in,
                                  target_name_in,
                                  location_in,
                                  lob_in,
                                  deployment_in,
                                  comment_in,
                                  contact_in);
    OPEN targets_cur_out FOR
        WITH cats AS 
        (SELECT /*+ CARDINALITY(t1 10) */ 
                                 m.metric_guid AS metric_guid,
                                 c.category_name AS category_name,
                                 t.target_guid AS target_guid
                            FROM mgmt_metrics m,
                                 mgmt_targets t,
                                 mgmt_category_map c,
                                 TABLE(CAST(l_target_array AS SMP_EMD_TGT_OBJECT_TBL)) t1
                            WHERE t.target_guid = t1.target_guid
                              AND t1.target_type = m.target_type
                              AND m.type_meta_ver = t.type_meta_ver
                              AND c.type_meta_ver = t.type_meta_ver
                              AND c.target_type = t1.target_type
                              AND (m.category_prop_1 = ' ' OR m.category_prop_1 = t.category_prop_1)
                              AND (m.category_prop_2 = ' ' OR m.category_prop_2 = t.category_prop_2)
                              AND (m.category_prop_3 = ' ' OR m.category_prop_3 = t.category_prop_3)
                              AND (m.category_prop_4 = ' ' OR m.category_prop_4 = t.category_prop_4)
                              AND (m.category_prop_5 = ' ' OR m.category_prop_5 = t.category_prop_5)
                              AND m.metric_guid = c.object_guid
                              AND c.object_type = MGMT_GLOBAL.G_TYPE_THRESHOLD_METRIC
                              AND c.class_name =  MGMT_GLOBAL.G_CATEGORY_CLASS_SERVICE
                              AND c.category_name IN ( MGMT_GLOBAL.G_SERVICE_CATEGORY_USAGE, MGMT_GLOBAL.G_SERVICE_CATEGORY_PERFORMANCE )),
        assocs AS (SELECT /*+ CARDINALITY(t3 10) */ t3.target_guid service_target_guid,
                 mem.target_name system_target_name,
                 mem.target_type system_target_type,
                 assoc.assoc_guid,
                 assoc.assoc_target_guid member_target_guid
          FROM mgmt_targets mem,
               TABLE(CAST(l_target_array AS SMP_EMD_TGT_OBJECT_TBL)) t3,
               mgmt_target_assocs assoc
          WHERE mem.target_guid = assoc.assoc_target_guid
            AND t3.target_guid = assoc.source_target_guid
            AND assoc.assoc_guid IN ( MGMT_ASSOC.G_DEPENDS_ON_GUID, MGMT_ASSOC.G_RUNS_ON_GUID ))
        SELECT /*+ CARDINALITY(mt 10) */ mt.target_name,
               mt.target_type,
               mt.target_name as display_name,
               mt.type_display_name,
               NVL(avail.current_status, MGMT_GLOBAL.G_STATUS_UNKNOWN) cur_status,
               mt.target_guid,
               NVL(perf.warning_count, 0) perf_warning_count,
               NVL(perf.critical_count, 0) perf_critical_count,
               NVL(usage.warning_count, 0)  usage_warning_count,
               NVL(usage.critical_count, 0) usage_critical_count,
               NVL(allpolicy.information_count, 0) AS policy_information_count,
               NVL(allpolicy.warning_count, 0) AS policy_warning_count,
               NVL(allpolicy.critical_count, 0) AS policy_critical_count,
               assoc.system_target_name,
               assoc.system_target_type,
               NVL(sysavail.up_count, 0) AS sys_up_count,
               NVL(sysavail.down_count, 0) AS sys_down_count,
               NVL(sysavail.error_count, 0) AS sys_error_count,
               NVL(sysavail.agent_down_count, 0) AS sys_agent_down_count,
               NVL(sysavail.unreachable_count, 0) AS sys_unreachable_count,
               NVL(sysavail.blackout_count, 0) AS sys_blackout_count,      
               NVL(sysavail.unknown_count, 0) AS sys_unknown_count,
               NVL(sysalert.warning_count, 0) AS sys_warning_count,
               NVL(sysalert.critical_count, 0) AS sys_critical_count
        FROM TABLE(CAST(l_target_array AS SMP_EMD_TGT_OBJECT_TBL)) mt,
             (SELECT assocs.system_target_name, 
                     assocs.system_target_type,
                     assocs.service_target_guid
              FROM assocs
              WHERE assocs.assoc_guid =  MGMT_ASSOC.G_RUNS_ON_GUID ) assoc,
             mgmt_current_availability avail,
                (SELECT SUM(DECODE(s.violation_level, MGMT_GLOBAL.G_SEVERITY_WARNING ,1,0)) warning_count,
                       SUM(DECODE(s.violation_level, MGMT_GLOBAL.G_SEVERITY_CRITICAL ,1,0)) critical_count,
                       s.target_guid
                FROM mgmt_current_violation s, 
                      cats
                WHERE s.target_guid = cats.target_guid
                  AND s.policy_guid = cats.metric_guid
                  AND cats.category_name = MGMT_GLOBAL.G_SERVICE_CATEGORY_USAGE
                GROUP BY s.target_guid) usage,
                (SELECT SUM(DECODE(s.violation_level, MGMT_GLOBAL.G_SEVERITY_WARNING ,1,0)) warning_count,
                       SUM(DECODE(s.violation_level, MGMT_GLOBAL.G_SEVERITY_CRITICAL ,1,0)) critical_count,
                       s.target_guid
                FROM mgmt_current_violation s, 
                     cats
                WHERE s.target_guid = cats.target_guid
                  AND s.policy_guid = cats.metric_guid
                  AND cats.category_name = MGMT_GLOBAL.G_SERVICE_CATEGORY_PERFORMANCE
                GROUP BY s.target_guid) perf,
                (SELECT SUM(DECODE(current_status, MGMT_GLOBAL.G_STATUS_UP ,1,0)) up_count,
                        SUM(DECODE(current_status, MGMT_GLOBAL.G_STATUS_DOWN ,1,0)) down_count,
                        SUM(DECODE(current_status, MGMT_GLOBAL.G_STATUS_ERROR , 1, 0)) AS error_count,
                        SUM(DECODE(current_status, MGMT_GLOBAL.G_STATUS_AGENT_DOWN , 1, 0)) AS agent_down_count,
                        SUM(DECODE(current_status, MGMT_GLOBAL.G_STATUS_UNREACHABLE , 1, 0)) AS unreachable_count,
                        SUM(DECODE(current_status, MGMT_GLOBAL.G_STATUS_BLACKOUT , 1, 0)) AS blackout_count,
                        SUM(DECODE(current_status, MGMT_GLOBAL.G_STATUS_UNKNOWN , 1, 0)) AS unknown_count,
                        assocs.service_target_guid tgtguid
                FROM mgmt_current_availability c,
                     assocs
                WHERE c.target_guid = assocs.member_target_guid
                  AND assocs.assoc_guid = MGMT_ASSOC.G_DEPENDS_ON_GUID
                GROUP BY assocs.service_target_guid) sysavail,
                (SELECT /*+ CARDINALITY(mt1 10)*/ SUM(DECODE(e.max_violation_level, MGMT_GLOBAL.G_SEVERITY_INFORMATIONAL ,
                                  e.non_exempt_violations_logged,0)) information_count,
                        SUM(DECODE(e.max_violation_level, MGMT_GLOBAL.G_SEVERITY_WARNING ,
                                  e.non_exempt_violations_logged,0)) warning_count,
                        SUM(DECODE(e.max_violation_level, MGMT_GLOBAL.G_SEVERITY_CRITICAL ,
                                  e.non_exempt_violations_logged,0))critical_count,
                        mt1.target_guid tguid
                FROM mgmt_policy_assoc_eval_summ e,
                     TABLE(CAST(l_target_array AS SMP_EMD_TGT_OBJECT_TBL)) mt1
                WHERE mt1.target_guid = e.target_guid
                  AND e.policy_guid IN
                   ( SELECT r.policy_guid
                     FROM mgmt_policies r
                     WHERE r.policy_type = MGMT_GLOBAL.G_TYPE_POLICY )
                GROUP BY mt1.target_guid ) allpolicy,
                (SELECT SUM(DECODE(s.violation_level, MGMT_GLOBAL.G_SEVERITY_WARNING ,1,0)) warning_count,
                        SUM(DECODE(s.violation_level, MGMT_GLOBAL.G_SEVERITY_CRITICAL ,1,0)) critical_count,
                        assocs.service_target_guid tguid
                FROM    mgmt_current_violation s,
                        assocs
                WHERE assocs.assoc_guid = MGMT_ASSOC.G_DEPENDS_ON_GUID 
                  AND s.target_guid = assocs.member_target_guid
                  AND s.violation_type IN (0,2)
                GROUP BY assocs.service_target_guid) sysalert
        WHERE mt.target_guid = perf.target_guid(+)
          AND mt.target_guid = usage.target_guid(+)
          AND mt.target_guid = assoc.service_target_guid(+)
          AND mt.target_guid = sysavail.tgtguid(+)
          AND mt.target_guid = allpolicy.tguid(+)
          AND mt.target_guid = sysalert.tguid(+)
          AND mt.target_guid = avail.target_guid;
  END IF;
EXCEPTION
WHEN OTHERS THEN
    RAISE_APPLICATION_ERROR(-20001, 'Error in get_targets_summary6');
END get_targets_summary6;

--
-- PROCEDURE: get_targets_summary7
--
-- PURPOSE:
--   This is used inside get_targets_summary for Case 7 - System
--
-- IN Parameters:
--   SMP_EMD_STRING_ARRAY See get_targets_summary.
--   search_query_in: VARCHAR2 See get_targets_summary.
--
-- OUT Parameters:
--   targets_cur_out: cursorType See get_targets_summary.
--
PROCEDURE get_targets_summary7(folder_types_in IN SMP_EMD_STRING_ARRAY,
                               search_query_in IN VARCHAR2 DEFAULT NULL,
                               search_mode_in  IN VARCHAR2 DEFAULT NULL,
                               targets_cur_out OUT cursorType,
                                tgt_types_srch_lst_in IN SMP_EMD_STRING_ARRAY DEFAULT NULL,                               
                                target_name_in        IN VARCHAR2 DEFAULT NULL,                                           
                                location_in           IN VARCHAR2 DEFAULT NULL,                                           
                                lob_in                IN VARCHAR2 DEFAULT NULL,                                           
                                deployment_in         IN VARCHAR2 DEFAULT NULL,                                           
                                comment_in            IN VARCHAR2 DEFAULT NULL,
                                contact_in            IN VARCHAR2 DEFAULT NULL) IS
    l_target_array   SMP_EMD_TGT_OBJECT_TBL;
BEGIN

  IF(search_query_in IS NULL)
  THEN
    -- no search target query
    OPEN targets_cur_out FOR
          WITH tgts as
             (select /*+ cardinality(t1 10) */
                     tgt.target_guid, tgt.target_name, tgt.target_type,
                     tgt.display_name, tgt.type_display_name
                from table(cast(folder_types_in AS SMP_EMD_STRING_ARRAY)) t1
                    , mgmt_targets tgt
               where tgt.target_type = t1.column_value)
          SELECT /*+ cardinality(tgt 5) */ tgt.target_name, tgt.target_type, tgt.display_name, tgt.type_display_name,
                 NVL(avail.current_status, MGMT_GLOBAL.G_STATUS_UNKNOWN) cur_status,
                 tgt.target_guid,
                 NVL(comptgt.warning_count, 0) AS warning_count,
                 NVL(comptgt.critical_count, 0) AS critical_count,
                 DECODE(comptgt.has_member_status,1,1,0) has_member_status,
                 NVL(comppolicytgt.information_count, 0) AS policy_information_count,
                 NVL(comppolicytgt.warning_count, 0) AS policy_warning_count,
                 NVL(comppolicytgt.critical_count, 0) AS policy_critical_count
            FROM tgts tgt,
                 mgmt_current_availability avail,
               (                SELECT /*+ cardinality(sev 100) */
                        SUM(DECODE(violation_level,MGMT_GLOBAL.G_SEVERITY_WARNING,1,0)) warning_count,
                        SUM(DECODE(violation_level,MGMT_GLOBAL.G_SEVERITY_CRITICAL,1,0)) critical_count,
                        sev.parent tguid,
                        1 has_member_status
                   FROM
                      ( SELECT /*+ cardinality(tgts 5) */ target_guid parent, target_guid child
                          FROM tgts
                         UNION ALL
                        SELECT /*+ cardinality(tgts 5) index(mfta) */
                               mfta.source_target_guid parent, mfta.assoc_target_guid child
                          FROM tgts,
                               mgmt_flat_target_assoc mfta,
                               mgmt_targets mt,
                               mgmt_type_properties prop,
                               mgmt_current_availability avail
                         WHERE mfta.source_target_guid = tgts.target_guid
                           AND mfta.is_membership = 1
                           AND mfta.assoc_target_guid = mt.target_guid
                           AND mt.target_type = prop.target_type(+)
                           AND prop.property_name(+) = 'memberDerivedAlert'
                           AND avail.target_guid = mfta.assoc_target_guid
                           AND avail.current_status = 1 ) sev,
                        mgmt_current_violation cs
                  WHERE sev.child = cs.target_guid
                    AND cs.violation_type IN (0,MGMT_GLOBAL.G_TYPE_POLICY)
                  GROUP BY sev.parent) comptgt,
               ( SELECT /*+ cardinality(tm 100) use_nl(e) index(e) */
                        SUM(DECODE(e.max_violation_level,MGMT_GLOBAL.G_SEVERITY_INFORMATIONAL,
                            e.non_exempt_violations_logged,0)) information_count,
                        SUM(DECODE(e.max_violation_level,MGMT_GLOBAL.G_SEVERITY_WARNING,
                            e.non_exempt_violations_logged,0)) warning_count,
                        SUM(DECODE(e.max_violation_level,MGMT_GLOBAL.G_SEVERITY_CRITICAL,
                            e.non_exempt_violations_logged,0))critical_count,
                        tm.parent tguid
                   FROM
                      ( SELECT /*+ cardinality(tgts 5) */ target_guid parent, target_guid child
                          FROM tgts
                         UNION ALL
                        SELECT /*+ cardinality(tgts 5) index(mfta)*/ tgts.target_guid parent, mfta.assoc_target_guid child
                          FROM tgts,
                               mgmt_flat_target_assoc mfta
                         WHERE tgts.target_guid = mfta.source_target_guid
                           AND is_membership = 1 ) tm,
                        mgmt_policy_assoc_eval_summ e
                  WHERE tm.child = e.target_guid (+)
                    AND EXISTS
                      ( SELECT /*+ index(p) no_unnest */ 1 FROM mgmt_policies p
                         WHERE p.policy_guid = e.policy_guid
                           AND p.policy_type = MGMT_GLOBAL.G_TYPE_POLICY)
                  GROUP BY tm.parent) comppolicytgt
           WHERE tgt.target_guid = avail.target_guid (+)
             AND tgt.target_guid = comppolicytgt.tguid(+)
             AND tgt.target_guid = comptgt.tguid (+)
           ORDER BY tgt.target_name;
  ELSE
    -- search target query provided
    l_target_array := get_targets(search_query_in,
                                  search_mode_in,
                                  tgt_types_srch_lst_in,
                                  target_name_in,
                                  location_in,
                                  lob_in,
                                  deployment_in,
                                  comment_in,
                                  contact_in);
    OPEN targets_cur_out FOR
          SELECT /*+ CARDINALITY(tgt 10) INDEX(tgt) */
                 tgt.target_name, tgt.target_type, tgt.display_name, tgt.type_display_name,
                 NVL((SELECT avail.current_status
                        FROM mgmt_current_availability avail
                       WHERE avail.target_guid = tgt.target_guid), MGMT_GLOBAL.G_STATUS_UNKNOWN) cur_status,
                 tgt.target_guid,
                 NVL(comptgt.warning_count, 0) AS warning_count,
                 NVL(comptgt.critical_count, 0) AS critical_count,
                 DECODE(comptgt.has_member_status,1,1,0) has_member_status,
                 NVL(comppolicytgt.information_count, 0) AS policy_information_count,
                 NVL(comppolicytgt.warning_count, 0) AS policy_warning_count,
                 NVL(comppolicytgt.critical_count, 0) AS policy_critical_count
            FROM
               ( SELECT target_name, target_type, target_guid,
                        target_name as display_name, type_display_name
                   FROM TABLE(CAST(l_target_array AS SMP_EMD_TGT_OBJECT_TBL))
               ) tgt,
               ( SELECT /*+ USE_HASH(sev) */
                        SUM(DECODE(violation_level,MGMT_GLOBAL.G_SEVERITY_WARNING,1,0)) warning_count,
                        SUM(DECODE(violation_level,MGMT_GLOBAL.G_SEVERITY_CRITICAL,1,0)) critical_count,
                        sev.parent tguid,
                        1 has_member_status
                   FROM
                      ( SELECT /*+ CARDINALITY(tgt 10) INDEX(tgt) */
                               tgt.target_guid parent, tgt.target_guid child
                          FROM TABLE(CAST(l_target_array AS SMP_EMD_TGT_OBJECT_TBL)) tgt
                         UNION
                        SELECT /*+ CARDINALITY(tgt 10) INDEX(mfta) INDEX(tgt) */
                               mfta.source_target_guid parent, mfta.assoc_target_guid child
                          FROM TABLE(CAST(l_target_array AS SMP_EMD_TGT_OBJECT_TBL)) tgt,
                               mgmt_flat_target_assoc mfta,
                               mgmt_targets mt,
                               mgmt_type_properties prop,
                               mgmt_current_availability avail
                         WHERE prop.property_name(+) = 'memberDerivedAlert'
                           AND mt.target_type = prop.target_type(+)
                           AND avail.current_status = 1
                           AND mfta.is_membership = 1
                           AND mfta.source_target_guid = tgt.target_guid
                           AND avail.target_guid = mfta.assoc_target_guid
                           AND mfta.assoc_target_guid = mt.target_guid ) sev,
                        mgmt_current_violation cs
                  WHERE sev.child = cs.target_guid
                    AND cs.violation_type IN (0,MGMT_GLOBAL.G_TYPE_POLICY)
                  GROUP BY sev.parent) comptgt,
               ( SELECT /*+ INDEX(e) */
                        SUM(DECODE(e.max_violation_level,MGMT_GLOBAL.G_SEVERITY_INFORMATIONAL,
                            e.non_exempt_violations_logged,0)) information_count,
                        SUM(DECODE(e.max_violation_level,MGMT_GLOBAL.G_SEVERITY_WARNING,
                            e.non_exempt_violations_logged,0)) warning_count,
                        SUM(DECODE(e.max_violation_level,MGMT_GLOBAL.G_SEVERITY_CRITICAL,
                            e.non_exempt_violations_logged,0))critical_count,
                        tgts.parent tguid
                   FROM
                      ( SELECT /*+ CARDINALITY(tgt 10) INDEX(tgt) */
                               tgt.target_guid parent, tgt.target_guid child
                          FROM TABLE(CAST(l_target_array AS SMP_EMD_TGT_OBJECT_TBL)) tgt
                         UNION
                        SELECT /*+ CARDINALITY(tgt 10) INDEX(mfta) */
                               tgt.target_guid parent, mfta.assoc_target_guid child
                        FROM TABLE(CAST(l_target_array AS SMP_EMD_TGT_OBJECT_TBL)) tgt,
                               mgmt_flat_target_assoc mfta
                        WHERE tgt.target_guid = mfta.source_target_guid
                           AND is_membership = 1) tgts,
                        mgmt_policy_assoc_eval_summ e
                  WHERE tgts.child = e.target_guid (+)
                    AND EXISTS
                      ( SELECT /*+ INDEX(p) */ 1 FROM mgmt_policies p
                         WHERE p.policy_guid = e.policy_guid
                           AND p.policy_type = MGMT_GLOBAL.G_TYPE_POLICY)
                  GROUP BY tgts.parent) comppolicytgt
           WHERE tgt.target_guid = comppolicytgt.tguid(+)
             AND tgt.target_guid = comptgt.tguid (+)
           ORDER BY tgt.target_name;
  END IF;
EXCEPTION
    WHEN OTHERS THEN
    RAISE_APPLICATION_ERROR(-20001, 'Error in get_targets_summary7');
END get_targets_summary7;

--
-- PROCEDURE: get_metrics_summary_db
--
-- PURPOSE:
--   This is used inside get_metrics_summary for handling RAC DB rollup
--
-- IN Parameters:
--   SMP_EMD_STRING_ARRAY See get_targets_summary.
--   search_query_in: VARCHAR2 See get_targets_summary.
--
-- OUT Parameters:
--   metric_sevs_cur_out: cursorType See get_targets_summary.
--   metric_vals_cur_out: cursorType See get_targets_summary.
--
PROCEDURE get_metrics_summary_db(folder_types_in IN SMP_EMD_STRING_ARRAY,
                              search_query_in IN VARCHAR2 DEFAULT NULL,
                              search_mode_in  IN VARCHAR2 DEFAULT NULL,
                              metric_sevs_cur_out OUT cursorType,
                              metric_vals_cur_out OUT cursorType,
                              tgt_types_srch_lst_in IN SMP_EMD_STRING_ARRAY DEFAULT NULL,
                              target_name_in        IN VARCHAR2 DEFAULT NULL,            
                              location_in           IN VARCHAR2 DEFAULT NULL,            
                              lob_in                IN VARCHAR2 DEFAULT NULL,            
                              deployment_in         IN VARCHAR2 DEFAULT NULL,            
                              comment_in            IN VARCHAR2 DEFAULT NULL,            
                              contact_in            IN VARCHAR2 DEFAULT NULL) IS

  l_user_name VARCHAR2(256);
  l_user_alias VARCHAR2(256);
  l_target_type VARCHAR2(64);
  l_metric_col_count NUMBER := 0;
  l_rac_db_type VARCHAR2(64);
  l_target_array   SMP_EMD_TGT_OBJECT_TBL;
BEGIN

  -- get the current user name from sys context
  l_user_name := UPPER(mgmt_user.get_current_em_user());

  -- get the target type (Should always be 'oracle_database'
  -- should be the first  and only item in the folder types list
  l_target_type := folder_types_in(1);
  
  -- rac database type
  l_rac_db_type := MGMT_GLOBAL.G_RAC_DATABASE_TARGET_TYPE;
    
  -- find the alias for the current user
  l_user_alias := mgmt_user.get_subtab_prefs_alias(l_user_name, l_target_type);

  -- find out if the aliased user has the metric preferences
  SELECT COUNT(1) INTO l_metric_col_count
    FROM mgmt_user_subtab_col_prefs
   WHERE user_name = l_user_alias
     AND subtab_name = l_target_type
     AND column_type = 0;

  -- get metric_sevs_cur_out, and metric_vals_cur_out
  IF(l_metric_col_count = 0)
  THEN
    -- Case A:
    --   no preferences, then show all metrics
    IF(search_query_in IS NULL)
    THEN
      -- no search target query
      OPEN metric_sevs_cur_out FOR
        SELECT mt.target_guid, mt.metric_guid, NVL(max(cv.violation_level),MGMT_GLOBAL.G_SEVERITY_CLEAR) severity_code 
        FROM  mgmt_current_violation cv, mgmt_policy_assoc pa,
               ( SELECT tgt.target_guid, tgt.target_guid object_guid, met.metric_guid 
                         FROM   mgmt_targets tgt, mgmt_metrics met 
                         WHERE  tgt.target_type    = l_target_type 
                           AND  met.target_type    = tgt.target_type 
                           AND  met.type_meta_ver  = tgt.type_meta_ver 
                           AND  (met.category_prop_1=tgt.category_prop_1 OR met.category_prop_1=' ') 
                           AND  (met.category_prop_2=tgt.category_prop_2 OR met.category_prop_2=' ') 
                           AND  (met.category_prop_3=tgt.category_prop_3 OR met.category_prop_3=' ') 
                           AND  (met.category_prop_4=tgt.category_prop_4 OR met.category_prop_4=' ') 
                           AND  (met.category_prop_5=tgt.category_prop_5 OR met.category_prop_5=' ') 
                           AND  met.metric_type    = 0 
                           AND  met.is_for_summary = 1 
                        UNION ALL 
                         SELECT t1.target_guid, ta.assoc_target_guid object_guid, m.metric_guid 
                         FROM   mgmt_targets t1, mgmt_target_assocs ta, mgmt_targets t2, mgmt_metrics m 
                         WHERE  t1.target_type   = l_rac_db_type 
                           AND  t1.target_guid   = ta.source_target_guid 
                           AND  ta.assoc_guid    = MGMT_ASSOC.g_contains_guid 
                           AND  t2.target_guid   = ta.assoc_target_guid 
                           AND  t2.target_type   = l_target_type 
                           AND  m.target_type    = t2.target_type 
                           AND  m.type_meta_ver  = t2.type_meta_ver 
                           AND  (m.category_prop_1=t2.category_prop_1 OR m.category_prop_1=' ') 
                           AND  (m.category_prop_2=t2.category_prop_2 OR m.category_prop_2=' ') 
                           AND  (m.category_prop_3=t2.category_prop_3 OR m.category_prop_3=' ') 
                           AND  (m.category_prop_4=t2.category_prop_4 OR m.category_prop_4=' ') 
                           AND  (m.category_prop_5=t2.category_prop_5 OR m.category_prop_5=' ') 
                           AND  m.metric_type    = 0 
                           AND  m.is_for_summary = 1
               ) mt 
        WHERE mt.object_guid = pa.object_guid
          AND mt.metric_guid = pa.policy_guid
          AND mt.object_guid = cv.target_guid (+) 
          AND mt.metric_guid = cv.policy_guid (+) 
          AND NVL(cv.violation_type,0) IN (0,1,2) 
          group by mt.target_guid, mt.metric_guid;

      OPEN metric_vals_cur_out FOR
        SELECT curmet.target_guid, curmet.metric_guid, ROUND(curmet.value,2) AS value
          FROM  mgmt_current_metrics curmet
          WHERE curmet.metric_guid IN 
                 (SELECT DISTINCT met.metric_guid
                  FROM mgmt_metrics met
                 WHERE met.target_type = l_target_type
                   AND met.metric_type = 0
                   AND met.is_for_summary = 1 
                );
    ELSE
      -- search target query provided
      l_target_array := get_targets(search_query_in,
                                  search_mode_in,
                                  tgt_types_srch_lst_in,
                                  target_name_in,
                                  location_in,
                                  lob_in,
                                  deployment_in,
                                  comment_in,
                                  contact_in);
      OPEN metric_sevs_cur_out FOR
        WITH targets AS
        (
          SELECT *
            FROM TABLE(CAST(l_target_array AS SMP_EMD_TGT_OBJECT_TBL))
        )
        SELECT mt.target_guid, mt.metric_guid, NVL(max(cv.violation_level),MGMT_GLOBAL.G_SEVERITY_CLEAR) severity_code 
        FROM  mgmt_current_violation cv, mgmt_policy_assoc pa,
               ( SELECT tgt.target_guid, tgt.target_guid object_guid, met.metric_guid 
                         FROM   mgmt_targets tgt, mgmt_metrics met 
                         WHERE  tgt.target_type    = l_target_type 
                           AND  met.target_type    = tgt.target_type 
                           AND  met.type_meta_ver  = tgt.type_meta_ver 
                           AND  (met.category_prop_1=tgt.category_prop_1 OR met.category_prop_1=' ') 
                           AND  (met.category_prop_2=tgt.category_prop_2 OR met.category_prop_2=' ') 
                           AND  (met.category_prop_3=tgt.category_prop_3 OR met.category_prop_3=' ') 
                           AND  (met.category_prop_4=tgt.category_prop_4 OR met.category_prop_4=' ') 
                           AND  (met.category_prop_5=tgt.category_prop_5 OR met.category_prop_5=' ') 
                           AND  met.metric_type    = 0 
                           AND  met.is_for_summary = 1 
                        UNION ALL 
                         SELECT t1.target_guid, ta.assoc_target_guid object_guid, m.metric_guid 
                         FROM   mgmt_targets t1, mgmt_target_assocs ta, mgmt_targets t2, mgmt_metrics m 
                         WHERE  t1.target_type   = l_rac_db_type 
                           AND  t1.target_guid   = ta.source_target_guid 
                           AND  ta.assoc_guid    = MGMT_ASSOC.g_contains_guid 
                           AND  t2.target_guid   = ta.assoc_target_guid 
                           AND  t2.target_type   = l_target_type 
                           AND  m.target_type    = t2.target_type 
                           AND  m.type_meta_ver  = t2.type_meta_ver 
                           AND  (m.category_prop_1=t2.category_prop_1 OR m.category_prop_1=' ') 
                           AND  (m.category_prop_2=t2.category_prop_2 OR m.category_prop_2=' ') 
                           AND  (m.category_prop_3=t2.category_prop_3 OR m.category_prop_3=' ') 
                           AND  (m.category_prop_4=t2.category_prop_4 OR m.category_prop_4=' ') 
                           AND  (m.category_prop_5=t2.category_prop_5 OR m.category_prop_5=' ') 
                           AND  m.metric_type    = 0 
                           AND  m.is_for_summary = 1
               ) mt 
        WHERE mt.object_guid = pa.object_guid
          AND mt.metric_guid = pa.policy_guid
          AND mt.object_guid = cv.target_guid (+) 
          AND mt.metric_guid = cv.policy_guid (+) 
          AND NVL(cv.violation_type,0) IN (0,1,2) 
          AND mt.target_guid IN (SELECT target_guid FROM targets)
          group by mt.target_guid, mt.metric_guid;

      OPEN metric_vals_cur_out FOR
        SELECT curmet.target_guid, curmet.metric_guid, ROUND(curmet.value,2) AS value
        FROM mgmt_current_metrics curmet, 
             TABLE(CAST(l_target_array AS SMP_EMD_TGT_OBJECT_TBL)) tgt
        WHERE curmet.metric_guid IN
               (SELECT DISTINCT met.metric_guid
                FROM  mgmt_metrics met
                WHERE met.target_type = l_target_type
                  AND met.metric_type = 0
                  AND met.is_for_summary = 1 
               )
         AND tgt.target_guid = curmet.target_guid;
    END IF;
  ELSE
    -- Case B:
    --   the aliased user has preferences
    IF(search_query_in IS NULL)
    THEN
      -- no search target query
      OPEN metric_sevs_cur_out FOR
        SELECT mt.target_guid, mt.metric_guid, NVL(max(cv.violation_level),MGMT_GLOBAL.G_SEVERITY_CLEAR) severity_code 
        FROM  mgmt_current_violation cv, mgmt_policy_assoc pa,
               ( SELECT tgt.target_guid, tgt.target_guid object_guid, met.metric_guid 
                         FROM   mgmt_targets tgt, mgmt_metrics met 
                         WHERE  tgt.target_type    = l_target_type 
                           AND  met.target_type    = tgt.target_type 
                           AND  met.type_meta_ver  = tgt.type_meta_ver 
                           AND  (met.category_prop_1=tgt.category_prop_1 OR met.category_prop_1=' ') 
                           AND  (met.category_prop_2=tgt.category_prop_2 OR met.category_prop_2=' ') 
                           AND  (met.category_prop_3=tgt.category_prop_3 OR met.category_prop_3=' ') 
                           AND  (met.category_prop_4=tgt.category_prop_4 OR met.category_prop_4=' ') 
                           AND  (met.category_prop_5=tgt.category_prop_5 OR met.category_prop_5=' ') 
                           AND  met.metric_guid IN
                           (SELECT p.column_id_guid
                              FROM mgmt_user_subtab_col_prefs p
                             WHERE p.subtab_name = l_target_type
                               AND p.user_name = l_user_alias
                               AND p.column_type = 0)
                        UNION ALL 
                         SELECT t1.target_guid, ta.assoc_target_guid object_guid, m.metric_guid 
                         FROM   mgmt_targets t1, mgmt_target_assocs ta, mgmt_targets t2, mgmt_metrics m 
                         WHERE  t1.target_type   = l_rac_db_type 
                           AND  t1.target_guid   = ta.source_target_guid 
                           AND  ta.assoc_guid    = MGMT_ASSOC.g_contains_guid 
                           AND  t2.target_guid   = ta.assoc_target_guid 
                           AND  t2.target_type   = l_target_type 
                           AND  m.target_type    = t2.target_type 
                           AND  m.type_meta_ver  = t2.type_meta_ver 
                           AND  (m.category_prop_1=t2.category_prop_1 OR m.category_prop_1=' ') 
                           AND  (m.category_prop_2=t2.category_prop_2 OR m.category_prop_2=' ') 
                           AND  (m.category_prop_3=t2.category_prop_3 OR m.category_prop_3=' ') 
                           AND  (m.category_prop_4=t2.category_prop_4 OR m.category_prop_4=' ') 
                           AND  (m.category_prop_5=t2.category_prop_5 OR m.category_prop_5=' ') 
                           AND  m.metric_guid IN
                           (SELECT p.column_id_guid
                              FROM mgmt_user_subtab_col_prefs p
                             WHERE p.subtab_name = l_target_type
                               AND p.user_name = l_user_alias
                               AND p.column_type = 0)
               ) mt 
        WHERE mt.object_guid = pa.object_guid
          AND mt.metric_guid = pa.policy_guid
          AND mt.object_guid = cv.target_guid (+) 
          AND mt.metric_guid = cv.policy_guid (+) 
          AND NVL(cv.violation_type,0) IN (0,1,2) 
          group by mt.target_guid, mt.metric_guid;
          
      OPEN metric_vals_cur_out FOR
        SELECT curmet.target_guid, curmet.metric_guid, ROUND(curmet.value,2) AS value
        FROM  mgmt_current_metrics curmet
        WHERE curmet.metric_guid IN
               (SELECT DISTINCT m.metric_guid
                  FROM mgmt_user_subtab_col_prefs p, mgmt_metrics m, mgmt_targets t
                 WHERE p.user_name = l_user_alias
                   AND p.subtab_name = l_target_type
                   AND p.column_type = 0
                   AND m.metric_guid = p.column_id_guid
                   AND m.metric_type = 0
                   AND m.is_for_summary = 1
		   AND m.target_type = t.target_type
		   AND m.type_meta_ver = t.type_meta_ver
          	   AND  ( m.category_prop_1 = t.category_prop_1 or
                 	m.category_prop_1 = ' ')
          	   AND  ( m.category_prop_2 = t.category_prop_2 or
                 	m.category_prop_2 = ' ')
          	   AND  ( m.category_prop_3 = t.category_prop_3 or
                 	m.category_prop_3 = ' ')
          	   AND  ( m.category_prop_4 = t.category_prop_4 or
                 	m.category_prop_4 = ' ')
          	   AND  ( m.category_prop_5 = t.category_prop_5 or
                 	m.category_prop_5 = ' ')
               );
    ELSE
      -- search target query provided
      l_target_array := get_targets(search_query_in,
                                  search_mode_in,
                                  tgt_types_srch_lst_in,
                                  target_name_in,
                                  location_in,
                                  lob_in,
                                  deployment_in,
                                  comment_in,
                                  contact_in);
      OPEN metric_sevs_cur_out FOR
        WITH targets AS
        (
          SELECT *
            FROM TABLE(CAST(l_target_array AS SMP_EMD_TGT_OBJECT_TBL))
        )
        SELECT mt.target_guid, mt.metric_guid, NVL(max(cv.violation_level),MGMT_GLOBAL.G_SEVERITY_CLEAR) severity_code 
        FROM  mgmt_current_violation cv, mgmt_policy_assoc pa,
               ( SELECT tgt.target_guid, tgt.target_guid object_guid, met.metric_guid 
                         FROM   mgmt_targets tgt, mgmt_metrics met
                         WHERE  tgt.target_type    = l_target_type 
                           AND  met.target_type    = tgt.target_type 
                           AND  met.type_meta_ver  = tgt.type_meta_ver 
                           AND  (met.category_prop_1=tgt.category_prop_1 OR met.category_prop_1=' ') 
                           AND  (met.category_prop_2=tgt.category_prop_2 OR met.category_prop_2=' ') 
                           AND  (met.category_prop_3=tgt.category_prop_3 OR met.category_prop_3=' ') 
                           AND  (met.category_prop_4=tgt.category_prop_4 OR met.category_prop_4=' ') 
                           AND  (met.category_prop_5=tgt.category_prop_5 OR met.category_prop_5=' ') 
                           AND  met.metric_guid IN
                           (SELECT p.column_id_guid
                              FROM mgmt_user_subtab_col_prefs p
                             WHERE p.subtab_name = l_target_type
                               AND p.user_name = l_user_alias
                               AND p.column_type = 0)
                        UNION ALL 
                         SELECT t1.target_guid, ta.assoc_target_guid object_guid, m.metric_guid 
                         FROM   mgmt_targets t1, mgmt_target_assocs ta, mgmt_targets t2, mgmt_metrics m 
                         WHERE  t1.target_type   = l_rac_db_type 
                           AND  t1.target_guid   = ta.source_target_guid 
                           AND  ta.assoc_guid    = MGMT_ASSOC.g_contains_guid 
                           AND  t2.target_guid   = ta.assoc_target_guid 
                           AND  t2.target_type   = l_target_type 
                           AND  m.target_type    = t2.target_type 
                           AND  m.type_meta_ver  = t2.type_meta_ver 
                           AND  (m.category_prop_1=t2.category_prop_1 OR m.category_prop_1=' ') 
                           AND  (m.category_prop_2=t2.category_prop_2 OR m.category_prop_2=' ') 
                           AND  (m.category_prop_3=t2.category_prop_3 OR m.category_prop_3=' ') 
                           AND  (m.category_prop_4=t2.category_prop_4 OR m.category_prop_4=' ') 
                           AND  (m.category_prop_5=t2.category_prop_5 OR m.category_prop_5=' ') 
                           AND  m.metric_guid IN
                           (SELECT p.column_id_guid
                              FROM mgmt_user_subtab_col_prefs p
                             WHERE p.subtab_name = l_target_type
                               AND p.user_name = l_user_alias
                               AND p.column_type = 0)
               ) mt 
        WHERE mt.object_guid = pa.object_guid
          AND mt.metric_guid = pa.policy_guid
          AND mt.object_guid = cv.target_guid (+) 
          AND mt.metric_guid = cv.policy_guid (+) 
          AND NVL(cv.violation_type,0) IN (0,1,2) 
          AND mt.target_guid IN (SELECT target_guid FROM targets)
          group by mt.target_guid, mt.metric_guid;

      OPEN metric_vals_cur_out FOR
        SELECT curmet.target_guid, curmet.metric_guid, ROUND(curmet.value,2) AS value
        FROM mgmt_current_metrics curmet,
             TABLE(CAST(l_target_array AS SMP_EMD_TGT_OBJECT_TBL)) tgt
        WHERE curmet.metric_guid IN
               (SELECT DISTINCT m.metric_guid
                  FROM mgmt_user_subtab_col_prefs p, mgmt_metrics m, mgmt_targets t
                 WHERE p.user_name = l_user_alias
                   AND p.subtab_name = l_target_type
                   AND p.column_type = 0
                   AND m.metric_guid = p.column_id_guid
                   AND m.metric_type = 0
                   AND m.is_for_summary = 1
                   AND m.target_type = t.target_type
                   AND m.type_meta_ver = t.type_meta_ver
                   AND  ( m.category_prop_1 = t.category_prop_1 or
                        m.category_prop_1 = ' ')
                   AND  ( m.category_prop_2 = t.category_prop_2 or
                        m.category_prop_2 = ' ')
                   AND  ( m.category_prop_3 = t.category_prop_3 or
                        m.category_prop_3 = ' ')
                   AND  ( m.category_prop_4 = t.category_prop_4 or
                        m.category_prop_4 = ' ')
                   AND  ( m.category_prop_5 = t.category_prop_5 or
                        m.category_prop_5 = ' ')

               )
          AND tgt.target_guid = curmet.target_guid;
    END IF;
  END IF;
EXCEPTION
WHEN OTHERS THEN
    RAISE_APPLICATION_ERROR(-20001, 'Error in get_metrics_summary_db');
END get_metrics_summary_db;

--
-- PROCEDURE: get_metrics_summary
--
-- PURPOSE:
--   This is used inside get_targets_summary for Case 2 and 3. See get_targets_summary.
--
-- IN Parameters:
--   SMP_EMD_STRING_ARRAY See get_targets_summary.
--   search_query_in: VARCHAR2 See get_targets_summary.
--
-- OUT Parameters:
--   metric_sevs_cur_out: cursorType See get_targets_summary.
--   metric_vals_cur_out: cursorType See get_targets_summary.
--
PROCEDURE get_metrics_summary(folder_types_in IN SMP_EMD_STRING_ARRAY,
                              search_query_in IN VARCHAR2 DEFAULT NULL,
                              search_mode_in  IN VARCHAR2 DEFAULT NULL,
                              metric_sevs_cur_out OUT cursorType,
                              metric_vals_cur_out OUT cursorType,
                              tgt_types_srch_lst_in IN SMP_EMD_STRING_ARRAY DEFAULT NULL, 
                              target_name_in        IN VARCHAR2 DEFAULT NULL,      
                              location_in           IN VARCHAR2 DEFAULT NULL,
                              lob_in                IN VARCHAR2 DEFAULT NULL, 
                              deployment_in         IN VARCHAR2 DEFAULT NULL,
                              comment_in            IN VARCHAR2 DEFAULT NULL,
                              contact_in            IN VARCHAR2 DEFAULT NULL) IS

  l_user_name VARCHAR2(256);
  l_user_alias VARCHAR2(256);
  l_target_type VARCHAR2(64);
  l_metric_col_count NUMBER := 0;
  l_target_array   SMP_EMD_TGT_OBJECT_TBL;
BEGIN

  -- get the target type
  -- should be the first  and only item in the folder types list
  l_target_type := folder_types_in(1);
  
 IF (l_target_type = MGMT_GLOBAL.G_DATABASE_TARGET_TYPE)
 THEN
   -- call get_metrics_summary_db to handle RAC case
   get_metrics_summary_db(folder_types_in, search_query_in, search_mode_in,
                          metric_sevs_cur_out, metric_vals_cur_out, 
                          tgt_types_srch_lst_in,
                          target_name_in,
                          location_in,      
                          lob_in,         
                          deployment_in,
                          comment_in,       
                          contact_in);  
 ELSE
  -- other cases
  -- get the current user name from sys context
  l_user_name := UPPER(mgmt_user.get_current_em_user());

  -- find the alias for the current user
  l_user_alias := mgmt_user.get_subtab_prefs_alias(l_user_name, l_target_type);

  -- find out if the aliased user has preferences
  SELECT COUNT(1) INTO l_metric_col_count
    FROM mgmt_user_subtab_col_prefs
   WHERE user_name = l_user_alias
     AND subtab_name = l_target_type;

  -- get metric_sevs_cur_out, and metric_vals_cur_out
  IF(l_metric_col_count = 0)
  THEN
    -- Case A:
    --   no preferences, then show all metrics
    IF(search_query_in IS NULL)
    THEN
      -- no search target query 
      
      OPEN metric_sevs_cur_out FOR
        SELECT /*+ INDEX(pa) */ 
              pa.object_guid as target_guid, pa.policy_guid as metric_guid, NVL(viol.violation_level,MGMT_GLOBAL.G_SEVERITY_CLEAR) severity_code
        FROM mgmt_policy_assoc pa,mgmt_policy_assoc_cfg pac,mgmt_policy_assoc_cfg_params pacp, mgmt_current_violation viol  
        WHERE pa.policy_guid = pac.policy_guid
	  AND pa.object_guid = pac.object_guid
	  AND pa.coll_name = pac.coll_name
	  AND pac.policy_guid = pacp.policy_guid
	  AND pac.object_guid = pacp.object_guid
	  AND pac.coll_name = pacp.coll_name
	  AND pac.key_value = pacp.key_value
	  AND pac.key_operator = pacp.key_operator
	  AND pa.object_type = 2
	  AND pa.policy_type = 1
          AND pacp.param_name = ' '
          AND (pa.object_guid, pa.policy_guid) IN
               (SELECT DISTINCT tgt.target_guid, met.metric_guid
                  FROM mgmt_targets tgt, mgmt_metrics met
                 WHERE tgt.target_type = l_target_type
                   AND met.target_type = tgt.target_type
                   AND met.metric_type = 0
                   AND met.is_for_summary = 1 
               )
          AND pa.object_guid = viol.target_guid (+)
          AND pa.policy_guid = viol.policy_guid (+)
          AND viol.violation_type in (0,1,2);
          
      OPEN metric_vals_cur_out FOR
        SELECT curmet.target_guid, curmet.metric_guid, ROUND(curmet.value,2) AS value
          FROM mgmt_current_metrics curmet
          WHERE curmet.metric_guid IN
                 (SELECT DISTINCT met.metric_guid
                  FROM mgmt_metrics met
                  WHERE met.target_type = l_target_type
                    AND met.metric_type = 0
                    AND met.is_for_summary = 1 
                 );
                 
    ELSE
      -- search target query provided
            l_target_array := get_targets(search_query_in,
                                  search_mode_in,
                                  tgt_types_srch_lst_in,
                                  target_name_in,
                                  location_in,
                                  lob_in,
                                  deployment_in,
                                  comment_in,
                                  contact_in);
            OPEN metric_sevs_cur_out FOR
              SELECT /*+ INDEX(pa) */
                     pa.object_guid as target_guid, pa.policy_guid as metric_guid, NVL(viol.violation_level,
                     MGMT_GLOBAL.G_SEVERITY_CLEAR) severity_code
                FROM mgmt_policy_assoc pa,mgmt_policy_assoc_cfg pac,mgmt_policy_assoc_cfg_params pacp, mgmt_current_violation viol 
		WHERE pa.policy_guid = pac.policy_guid
		  AND pa.object_guid = pac.object_guid
		  AND pa.coll_name = pac.coll_name
		  AND pac.policy_guid = pacp.policy_guid
		  AND pac.object_guid = pacp.object_guid
		  AND pac.coll_name = pacp.coll_name
		  AND pac.key_value = pacp.key_value
		  AND pac.key_operator = pacp.key_operator
		  AND pa.object_type = 2
		  AND pa.policy_type = 1
		  AND pacp.param_name = ' '
                  AND (pa.object_guid, pa.policy_guid) IN
                     (SELECT DISTINCT tgt.target_guid, met.metric_guid
                        FROM TABLE(CAST(l_target_array AS SMP_EMD_TGT_OBJECT_TBL)) tgt, 
                             mgmt_metrics met
                       WHERE tgt.target_type = l_target_type
                         AND met.target_type = tgt.target_type
                         AND met.metric_type = 0
                         AND met.is_for_summary = 1 
                     ) 
                 AND pa.object_guid = viol.target_guid (+)
                 AND pa.policy_guid = viol.policy_guid (+)
                 AND viol.violation_type in (0,1,2);
      
	      OPEN metric_vals_cur_out FOR
		SELECT curmet.target_guid, curmet.metric_guid, ROUND(curmet.value,2) AS value
		  FROM mgmt_current_metrics curmet,
		       TABLE(CAST(l_target_array AS SMP_EMD_TGT_OBJECT_TBL)) tgt
		 WHERE curmet.metric_guid IN
		       (SELECT DISTINCT met.metric_guid
			FROM mgmt_metrics met
			WHERE met.target_type = l_target_type
			  AND met.metric_type = 0
			  AND met.is_for_summary = 1 
		       )
		   AND tgt.target_guid = curmet.target_guid;
           
    END IF;
  ELSE
    -- Case B:
    --   the aliased user has preferences
    IF(search_query_in IS NULL)
    THEN
      -- no search target query
      OPEN metric_sevs_cur_out FOR
        SELECT /*+ INDEX(pa) */
               pa.object_guid as target_guid, 
               pa.policy_guid as metric_guid, 
               NVL(viol.violation_level, MGMT_GLOBAL.G_SEVERITY_CLEAR) severity_code
          FROM mgmt_policy_assoc pa, mgmt_current_violation viol
         WHERE  pa.policy_type = 1
            AND pa.object_type = 2
            AND 
                (pa.object_guid, pa.policy_guid) IN
               (SELECT DISTINCT tgt.target_guid, p.column_id_guid
                  FROM mgmt_targets tgt, mgmt_user_subtab_col_prefs p
                 WHERE p.user_name = l_user_alias
                   AND tgt.target_type = l_target_type
                   AND p.subtab_name = tgt.target_type
                   AND p.column_type = 0
               ) 
           AND pa.policy_guid = viol.policy_guid (+)
           AND pa.object_guid = viol.target_guid (+)
           AND viol.violation_type in (0,1,2);

      OPEN metric_vals_cur_out FOR
        SELECT curmet.target_guid, curmet.metric_guid, ROUND(curmet.value,2) AS value
        FROM mgmt_current_metrics curmet
        WHERE (curmet.metric_guid,curmet.target_guid) IN 
               (SELECT DISTINCT m.metric_guid, tgt.target_guid
                FROM    mgmt_user_subtab_col_prefs p, 
                        mgmt_metrics m,
                        mgmt_targets tgt
                WHERE p.user_name   = l_user_alias
                  AND p.subtab_name = l_target_type
                  AND p.column_type = 0
                  AND m.metric_guid = p.column_id_guid
                  AND m.metric_type = 0
                  AND m.is_for_summary = 1
                  AND p.subtab_name = tgt.target_type
                  AND p.column_type = 0
              );
              
    ELSE
      -- search target query provided
      l_target_array := get_targets(search_query_in,
                                  search_mode_in,
                                  tgt_types_srch_lst_in,
                                  target_name_in,
                                  location_in,
                                  lob_in,
                                  deployment_in,
                                  comment_in,
                                  contact_in);
      OPEN metric_sevs_cur_out FOR
        SELECT /*+ INDEX(pa) */ 
               pa.object_guid as target_guid, pa.policy_guid as metric_guid, NVL(viol.violation_level,
               MGMT_GLOBAL.G_SEVERITY_CLEAR) severity_code
          FROM mgmt_policy_assoc pa,mgmt_policy_assoc_cfg pac,mgmt_policy_assoc_cfg_params pacp, mgmt_current_violation viol
	 WHERE pa.policy_guid = pac.policy_guid
	   AND pa.object_guid = pac.object_guid
	   AND pa.coll_name = pac.coll_name
	   AND pac.policy_guid = pacp.policy_guid
	   AND pac.object_guid = pacp.object_guid
	   AND pac.coll_name = pacp.coll_name
	   AND pac.key_value = pacp.key_value
	   AND pac.key_operator = pacp.key_operator
	   AND pa.object_type = 2
	   AND pa.policy_type = 1
	   AND pacp.param_name = ' '
           AND (pa.object_guid, pa.policy_guid) IN
               (SELECT DISTINCT tgt.target_guid, p.column_id_guid
                  FROM TABLE(CAST(l_target_array AS SMP_EMD_TGT_OBJECT_TBL)) tgt, 
                       mgmt_user_subtab_col_prefs p
                 WHERE p.user_name = l_user_alias
                   AND tgt.target_type = l_target_type
                   AND p.subtab_name = tgt.target_type
                   AND p.column_type = 0
               )
           AND pa.policy_guid = viol.policy_guid (+)
           AND pa.object_guid = viol.target_guid (+)
           AND viol.violation_type in (0,1,2);
      
      OPEN metric_vals_cur_out FOR
        SELECT curmet.target_guid, curmet.metric_guid, ROUND(curmet.value,2) AS value
          FROM TABLE(CAST(l_target_array AS SMP_EMD_TGT_OBJECT_TBL)) tgt,
               mgmt_current_metrics curmet
         WHERE curmet.metric_guid IN
                (SELECT DISTINCT m.metric_guid
                 FROM mgmt_user_subtab_col_prefs p, mgmt_metrics m, mgmt_targets t
                 WHERE p.user_name = l_user_alias
                   AND p.subtab_name = l_target_type
                   AND p.column_type = 0
                   AND m.metric_guid = p.column_id_guid
                   AND m.metric_type = 0
                   AND m.is_for_summary = 1
                   AND m.target_type = t.target_type
                   AND m.type_meta_ver = t.type_meta_ver
                   AND  ( m.category_prop_1 = t.category_prop_1 or
                        m.category_prop_1 = ' ')
                   AND  ( m.category_prop_2 = t.category_prop_2 or
                        m.category_prop_2 = ' ')
                   AND  ( m.category_prop_3 = t.category_prop_3 or
                        m.category_prop_3 = ' ')
                   AND  ( m.category_prop_4 = t.category_prop_4 or
                        m.category_prop_4 = ' ')
                   AND  ( m.category_prop_5 = t.category_prop_5 or
                        m.category_prop_5 = ' ')

               )
           AND tgt.target_guid = curmet.target_guid;
           
    END IF;
  END IF;
 END IF;
EXCEPTION
    WHEN OTHERS THEN
    RAISE_APPLICATION_ERROR(-20001, 'Error in get_metrics_summary');
END get_metrics_summary;

--
-- PROCEDURE: get_properties_summary_db
--
-- PURPOSE:
--   This is used inside get_properties_summary_db.
--
-- IN Parameters:
--   user_name_in: EM user calling the proc
--   folder_types_in: VARCHAR2 See get_targets_summary.
--   search_query_in: Target search query
--
-- OUT Parameters:
--   prop_vals_cur_out: cursorType See get_targets_summary.
--
PROCEDURE get_properties_summary_db(search_query_in IN VARCHAR2 DEFAULT NULL,
                                    prop_vals_cur_out OUT cursorType,
                                    search_mode_in IN VARCHAR2 DEFAULT NULL,
                                    tgt_types_srch_lst_in IN SMP_EMD_STRING_ARRAY DEFAULT NULL, 
                                      target_name_in        IN VARCHAR2 DEFAULT NULL,      
                                      location_in           IN VARCHAR2 DEFAULT NULL,
                                      lob_in                IN VARCHAR2 DEFAULT NULL, 
                                      deployment_in         IN VARCHAR2 DEFAULT NULL,
                                      comment_in            IN VARCHAR2 DEFAULT NULL,
                                      contact_in            IN VARCHAR2 DEFAULT NULL) IS
  l_user_alias VARCHAR2(256);
  --l_prop_col_count NUMBER := 0;
  l_user_name VARCHAR2(64) := mgmt_user.get_current_em_user();
  l_target_array   SMP_EMD_TGT_OBJECT_TBL;
BEGIN
  -- find the alias for the current user
  l_user_alias := mgmt_user.get_subtab_prefs_alias(l_user_name,
                                                   MGMT_GLOBAL.G_DATABASE_TARGET_TYPE);
  
    IF(search_query_in IS NULL)
    THEN
      -- no search provided
      -- Note that this query only returns the data for the selected property 
      -- columns (optimization).
      OPEN prop_vals_cur_out FOR
        SELECT /*+ INDEX(prop)*/ tgt.target_guid, prop.property_name, prop.property_value,
               tgt.target_type AS target_type
          FROM mgmt_targets tgt, mgmt_target_properties prop,
               mgmt_user_subtab_col_prefs prefs
         WHERE prefs.subtab_name = MGMT_GLOBAL.G_DATABASE_TARGET_TYPE
           AND prefs.user_name = l_user_alias
           AND prefs.column_type = 1
           AND prefs.column_id = prop.property_name
           AND (tgt.target_type= MGMT_GLOBAL.G_DATABASE_TARGET_TYPE OR tgt.target_type = MGMT_GLOBAL.G_RAC_DATABASE_TARGET_TYPE)
           AND tgt.target_guid = prop.target_guid;
    ELSE
      -- target search query provided
      l_target_array := get_targets(search_query_in,
                                  search_mode_in,
                                  tgt_types_srch_lst_in,
                                  target_name_in,
                                  location_in,
                                  lob_in,
                                  deployment_in,
                                  comment_in,
                                  contact_in);
      OPEN prop_vals_cur_out FOR
        SELECT tgt.target_guid, prop.property_name, prop.property_value,
               tgt.target_type AS target_type
          FROM mgmt_target_properties prop, mgmt_user_subtab_col_prefs prefs,
               TABLE(CAST(l_target_array AS SMP_EMD_TGT_OBJECT_TBL)) tgt
         WHERE prefs.subtab_name = MGMT_GLOBAL.G_DATABASE_TARGET_TYPE
           AND prefs.user_name = l_user_alias
           AND prefs.column_type = 1
           AND prefs.column_id = prop.property_name
           AND (tgt.target_type= MGMT_GLOBAL.G_DATABASE_TARGET_TYPE OR tgt.target_type = MGMT_GLOBAL.G_RAC_DATABASE_TARGET_TYPE)
           AND tgt.target_guid = prop.target_guid;
    END IF;
EXCEPTION
    WHEN OTHERS THEN
    RAISE_APPLICATION_ERROR(-20001, 'Error in get_properties_summary_db');
END get_properties_summary_db;


--
-- PROCEDURE: get_properties_summary_1
--
-- PURPOSE:
--   This is used inside get_targets_summary. See get_targets_summary.
--
-- IN Parameters:
--   user_name_in: EM user calling the proc
--   folder_types_in: VARCHAR2 See get_targets_summary.
--   search_query_in: Target search query
--
-- OUT Parameters:
--   prop_vals_cur_out: cursorType See get_targets_summary.
--
PROCEDURE get_properties_summary_1(target_type_in IN VARCHAR2,
                                 search_query_in IN VARCHAR2 DEFAULT NULL,
                                 prop_vals_cur_out OUT cursorType,
                                 search_mode_in   IN VARCHAR2 DEFAULT NULL,
                                 tgt_types_srch_lst_in IN SMP_EMD_STRING_ARRAY DEFAULT NULL, 
                                  target_name_in        IN VARCHAR2 DEFAULT NULL,      
                                  location_in           IN VARCHAR2 DEFAULT NULL,
                                  lob_in                IN VARCHAR2 DEFAULT NULL, 
                                  deployment_in         IN VARCHAR2 DEFAULT NULL,
                                  comment_in            IN VARCHAR2 DEFAULT NULL,
                                  contact_in            IN VARCHAR2 DEFAULT NULL) IS

  l_user_alias VARCHAR2(256);
  l_user_name VARCHAR2(64) := mgmt_user.get_current_em_user();
  l_target_array   SMP_EMD_TGT_OBJECT_TBL;
BEGIN
  -- find the alias for the current user
  l_user_alias := mgmt_user.get_subtab_prefs_alias(l_user_name, target_type_in);
  
  IF(search_query_in IS NULL)
  THEN
    -- no search provided
    -- Note that this query only returns the data for the selected property 
    -- columns (optimization). Remember that properties are only displayed if
    -- the user has set his prefs (they aren't part of the defaults...)
    OPEN prop_vals_cur_out FOR
      SELECT tgt.target_guid, prop.property_name, prop.property_value
        FROM mgmt_targets tgt, mgmt_target_properties prop,
             mgmt_user_subtab_col_prefs prefs
       WHERE prefs.subtab_name = target_type_in
         AND prefs.user_name = l_user_alias
         AND prefs.column_type = 1
         AND prefs.column_id = prop.property_name
         AND tgt.target_guid = prop.target_guid;
  ELSE
    -- target search query provided
    l_target_array := get_targets(search_query_in,
                                  search_mode_in,
                                  tgt_types_srch_lst_in,
                                  target_name_in,
                                  location_in,
                                  lob_in,
                                  deployment_in,
                                  comment_in,
                                  contact_in);
    OPEN prop_vals_cur_out FOR
      SELECT tgt.target_guid, prop.property_name, prop.property_value
        FROM mgmt_target_properties prop, mgmt_user_subtab_col_prefs prefs,
             TABLE(CAST(l_target_array AS SMP_EMD_TGT_OBJECT_TBL)) tgt
       WHERE prefs.subtab_name = target_type_in
         AND prefs.user_name = l_user_alias
         AND prefs.column_type = 1
         AND prefs.column_id = prop.property_name
         AND tgt.target_guid = prop.target_guid;
  END IF;
EXCEPTION
    WHEN OTHERS THEN
    RAISE_APPLICATION_ERROR(-20001, 'Error in get_properties_summary_1');
END get_properties_summary_1;


--
-- PROCEDURE: get_properties_summary_2
--
-- PURPOSE:
--   This is used inside get_targets_summary. See get_targets_summary.
--
-- IN Parameters:
--   user_name_in: EM user calling the proc
--   folder_types_in: VARCHAR2 See get_targets_summary.
--   search_query_in: Target search query
--
-- OUT Parameters:
--   prop_vals_cur_out: cursorType See get_targets_summary.
--
PROCEDURE get_properties_summary_2(target_type_in IN VARCHAR2,
                                 search_query_in IN VARCHAR2 DEFAULT NULL,
                                 prop_vals_cur_out OUT cursorType,
                                 search_mode_in IN VARCHAR2 DEFAULT NULL,
                                 tgt_types_srch_lst_in IN SMP_EMD_STRING_ARRAY DEFAULT NULL, 
                              target_name_in        IN VARCHAR2 DEFAULT NULL,      
                              location_in           IN VARCHAR2 DEFAULT NULL,
                              lob_in                IN VARCHAR2 DEFAULT NULL, 
                              deployment_in         IN VARCHAR2 DEFAULT NULL,
                              comment_in            IN VARCHAR2 DEFAULT NULL,
                              contact_in            IN VARCHAR2 DEFAULT NULL) IS

  l_user_alias VARCHAR2(256);
  -- l_prop_col_count NUMBER := 0;
  l_user_name VARCHAR2(64) := mgmt_user.get_current_em_user();
  l_target_array   SMP_EMD_TGT_OBJECT_TBL;
BEGIN
  -- find the alias for the current user
  l_user_alias := mgmt_user.get_subtab_prefs_alias(l_user_name, target_type_in);
  
  IF (target_type_in = MGMT_GLOBAL.G_DATABASE_TARGET_TYPE) THEN
    get_properties_summary_db(search_query_in, prop_vals_cur_out, 
                              search_mode_in,
                              tgt_types_srch_lst_in,
                              target_name_in,
                              location_in,      
                              lob_in,         
                              deployment_in,
                              comment_in,       
                              contact_in);
    return;
  END IF;

  /*
  -- find out if the aliased user has property preferences
  SELECT COUNT(*) INTO l_prop_col_count
    FROM mgmt_user_subtab_col_prefs
   WHERE user_name = l_user_alias
     AND column_type = 1
     AND subtab_name = target_type_in;

  --   the aliased user has property preferences
  IF (l_prop_col_count != 0) THEN
  END IF;
  */
    IF(search_query_in IS NULL)
    THEN
      -- no search provided
      -- Note that this query only returns the data for the selected property 
      -- columns (optimization).
      OPEN prop_vals_cur_out FOR
        SELECT tgt.target_guid, prop.property_name, prop.property_value
          FROM mgmt_targets tgt, mgmt_target_properties prop,
               mgmt_user_subtab_col_prefs prefs
         WHERE tgt.target_type = target_type_in
           AND prefs.subtab_name = target_type_in
           AND prefs.user_name = l_user_alias
           AND prefs.column_type = 1
           AND prefs.column_id = prop.property_name
           AND tgt.target_guid = prop.target_guid;
    ELSE
      -- target search query provided
      l_target_array := get_targets(search_query_in,
                                  search_mode_in,
                                  tgt_types_srch_lst_in,
                                  target_name_in,
                                  location_in,
                                  lob_in,
                                  deployment_in,
                                  comment_in,
                                  contact_in);
      OPEN prop_vals_cur_out FOR
        SELECT tgt.target_guid, prop.property_name, prop.property_value
          FROM mgmt_target_properties prop, mgmt_user_subtab_col_prefs prefs,
               TABLE(CAST(l_target_array AS SMP_EMD_TGT_OBJECT_TBL)) tgt
         WHERE tgt.target_type = target_type_in
           AND prefs.subtab_name = target_type_in
           AND prefs.user_name = l_user_alias
           AND prefs.column_type = 1
           AND prefs.column_id = prop.property_name
           AND tgt.target_guid = prop.target_guid;
    END IF;
EXCEPTION
    WHEN OTHERS THEN
    RAISE_APPLICATION_ERROR(-20001, 'Error in get_properties_summary_2');
END get_properties_summary_2;

--
-- PURPOSE:
--   Returns a summary of targets/metrics detail given the internal system
--   folder name
--
PROCEDURE get_targets_summary(folder_types_in       IN SMP_EMD_STRING_ARRAY, 
                              search_query_in       IN VARCHAR2 DEFAULT NULL,
                              case_number_out       OUT NUMBER,
                              user_prefs_cur_out    OUT cursorType,
                              metric_sevs_cur_out   OUT cursorType,
                              metric_vals_cur_out   OUT cursorType,
                              targets_cur_out       OUT cursorType,
                              prop_vals_cur_out     OUT cursorType,
                              member_type_cur_out   OUT cursorType) 
IS
  l_sql_message    VARCHAR2(4000);
BEGIN
    get_targets_summary(folder_types_in         =>   folder_types_in,
                        search_query_in         =>   search_query_in,
                        case_number_out         =>   case_number_out,
                        user_prefs_cur_out      =>   user_prefs_cur_out,
                        metric_sevs_cur_out     =>   metric_sevs_cur_out, 
                        metric_vals_cur_out     =>   metric_vals_cur_out,
                        targets_cur_out         =>   targets_cur_out,
                        prop_vals_cur_out       =>   prop_vals_cur_out,
                        member_type_cur_out     =>   member_type_cur_out,
                        search_mode_in          =>   0,
                        tgt_types_srch_lst_in   =>   NULL,
                        target_name_in          =>   NULL,
                        location_in             =>   NULL,
                        lob_in                  =>   NULL,
                        deployment_in           =>   NULL,
                        comment_in              =>   NULL,
                        contact_in              =>   NULL);

EXCEPTION               
    WHEN OTHERS THEN
        l_sql_message := sqlerrm;
        RAISE_APPLICATION_ERROR(-20012, 'Error in get_targets_summary: '||l_sql_message);
END;

--
-- PURPOSE:
--   Returns a summary of targets/metrics detail given the internal system
--   folder name
--
PROCEDURE get_targets_summary(folder_types_in       IN SMP_EMD_STRING_ARRAY, 
                              search_query_in       IN VARCHAR2 DEFAULT NULL,
                              search_mode_in        IN VARCHAR2 DEFAULT 0,
                              tgt_types_srch_lst_in IN SMP_EMD_STRING_ARRAY DEFAULT NULL, 
                              target_name_in        IN VARCHAR2 DEFAULT NULL,      
                              location_in           IN VARCHAR2 DEFAULT NULL,
                              lob_in                IN VARCHAR2 DEFAULT NULL, 
                              deployment_in         IN VARCHAR2 DEFAULT NULL,
                              comment_in            IN VARCHAR2 DEFAULT NULL,
                              contact_in            IN VARCHAR2 DEFAULT NULL,
                              case_number_out       OUT NUMBER,
                              user_prefs_cur_out    OUT cursorType,
                              metric_sevs_cur_out   OUT cursorType,
                              metric_vals_cur_out   OUT cursorType,
                              targets_cur_out       OUT cursorType,
                              prop_vals_cur_out     OUT cursorType,
                              member_type_cur_out   OUT cursorType) IS

  l_target_type_count NUMBER := 0;
  l_has_mem_derv_alert_count NUMBER := 0;
  l_is_service BOOLEAN := FALSE;
  l_is_system BOOLEAN := FALSE;
  l_is_group BOOLEAN := FALSE;
  l_folder_types SMP_EMD_STRING_ARRAY := SMP_EMD_STRING_ARRAY();
  l_target_array   SMP_EMD_TGT_OBJECT_TBL;
BEGIN    
  -- find the count of target types of the folder
  IF (folder_types_in IS NOT NULL)
  THEN
    l_target_type_count := folder_types_in.COUNT;
  END IF;

  -- find out if those types of the folder have memberDerivedAlert properties
  SELECT count(1) INTO l_has_mem_derv_alert_count
    FROM mgmt_type_properties
   WHERE target_type IN 
           ( SELECT * 
               FROM TABLE(CAST(folder_types_in AS SMP_EMD_STRING_ARRAY))) 
     AND property_name = MGMT_GLOBAL.G_DERIVED_ALERT_PROP;

  IF (l_target_type_count > 0 AND folder_types_in(1) = MGMT_GLOBAL.G_GENERIC_SERVICE_TYPE)
  THEN
    l_is_service := TRUE;
  END IF;

  -- there is no fixed target type for system.
  IF (l_target_type_count > 0 AND folder_types_in(1) = MGMT_GLOBAL.G_GENERIC_SYSTEM_TYPE)
  THEN
    l_is_system := TRUE;
  END IF;
  
  -- there is no fixed target type for system.
  IF (l_target_type_count > 0 AND folder_types_in(1) = MGMT_GLOBAL.G_COMPOSITE_TARGET_TYPE)
  THEN
    l_is_group := TRUE;
  END IF;

  -- Based on l_target_type_count and l_has_mem_derv_alert_count,
  -- we'll have 5 cases

  -- Case1:
  --   l_target_type_count = 0
  --   All Targets folder
  IF(l_target_type_count = 0)
  THEN
    case_number_out := 1;
    get_subtab_preferred_cols(  subtab_name_in => emd_pref.mgmt_user_pref_all_targets, 
                                case_in        => case_number_out,
                                pref_cols_out  => user_prefs_cur_out);

    get_targets_summary1(search_query_in, 
                         search_mode_in, 
                         targets_cur_out,
                         tgt_types_srch_lst_in,
                         target_name_in,
                         location_in,      
                         lob_in,         
                         deployment_in,
                         comment_in,       
                         contact_in);

    get_properties_summary_1(emd_pref.mgmt_user_pref_all_targets,
                             search_query_in, 
                             prop_vals_cur_out,
                             search_mode_in,
                             tgt_types_srch_lst_in,
                             target_name_in,
                             location_in,      
                             lob_in,         
                             deployment_in,
                             comment_in,       
                             contact_in);

  ELSIF(folder_types_in(1) = MGMT_GLOBAL.G_WEBSITE_TARGET_TYPE) THEN
      case_number_out := 3;
      get_subtab_preferred_cols(subtab_name_in => EMD_PREF.MGMT_USER_PREF_WEBAPPS,
                                case_in        => case_number_out,
                                pref_cols_out  => user_prefs_cur_out);

      get_targets_summary6(folder_types_in, 
                           search_query_in, 
                           search_mode_in,
                           targets_cur_out,
                           tgt_types_srch_lst_in,
                           target_name_in,
                           location_in,      
                           lob_in,         
                           deployment_in,
                           comment_in,       
                           contact_in);

      get_properties_summary_1(emd_pref.mgmt_user_pref_webapps,
                               search_query_in, 
                               prop_vals_cur_out,
                               search_mode_in,
                               tgt_types_srch_lst_in,
                               target_name_in,
                               location_in,      
                               lob_in,         
                               deployment_in,
                               comment_in,       
                               contact_in);
  -- Case2:
  --   l_target_type_count = 1, l_has_mem_derv_alert_count = 0
  --   Hosts, Databases, etc. folders
  ELSIF(l_target_type_count = 1 AND l_has_mem_derv_alert_count = 0)
  THEN
      case_number_out := 2;
      get_subtab_preferred_cols(subtab_name_in => folder_types_in(1), 
                                case_in        => case_number_out,
                                pref_cols_out  => user_prefs_cur_out);

      get_metrics_summary(folder_types_in, 
                          search_query_in, 
                          search_mode_in,
                          metric_sevs_cur_out,
                          metric_vals_cur_out, 
                          tgt_types_srch_lst_in,
                          target_name_in,
                          location_in,      
                          lob_in,         
                          deployment_in,
                          comment_in,       
                          contact_in);

      get_targets_summary2(folder_types_in, 
                           search_query_in,
                           search_mode_in,
                           targets_cur_out,
                           tgt_types_srch_lst_in,
                           target_name_in,
                           location_in,      
                           lob_in,         
                           deployment_in,
                           comment_in,       
                           contact_in);

      get_properties_summary_2(folder_types_in(1), 
                               search_query_in,
                               prop_vals_cur_out, 
                               search_mode_in,
                               tgt_types_srch_lst_in,
                               target_name_in,
                               location_in,      
                               lob_in,         
                               deployment_in,
                               comment_in,       
                               contact_in);
  -- Case3:
  --   l_target_type_count = 1, l_has_mem_derv_alert_count > 0
  --   Websites, etc. folders
  ELSIF(l_target_type_count = 1 AND l_has_mem_derv_alert_count > 0 
       AND l_is_group = FALSE)
  THEN
    case_number_out := 3;
    get_subtab_preferred_cols(subtab_name_in => folder_types_in(1), 
                              case_in        => case_number_out,
                              pref_cols_out  => user_prefs_cur_out);

    get_metrics_summary(folder_types_in, 
                        search_query_in, 
                        search_mode_in,
                        metric_sevs_cur_out,
                        metric_vals_cur_out,
                        tgt_types_srch_lst_in,
                        target_name_in,
                        location_in,      
                        lob_in,         
                        deployment_in,
                        comment_in,       
                        contact_in);

    get_targets_summary3(folder_types_in,
                         search_query_in, 
                         search_mode_in, 
                         targets_cur_out,
                         tgt_types_srch_lst_in,
                         target_name_in,
                         location_in,      
                         lob_in,         
                         deployment_in,
                         comment_in,       
                         contact_in);

    get_properties_summary_2(folder_types_in(1), 
                             search_query_in,
                             prop_vals_cur_out, 
                             search_mode_in,
                             tgt_types_srch_lst_in,
                             target_name_in,
                             location_in,      
                             lob_in,         
                             deployment_in,
                             comment_in,       
                             contact_in);

  -- Case4 and Case 6(services):
  --   l_target_type_count > 1, l_has_mem_derv_alert_count = 0
  --   Currently we don't have this system folder, but may have in the future
  ELSIF(l_target_type_count > 1 AND l_has_mem_derv_alert_count = 0)
  THEN
    IF (l_is_service)
    THEN
      case_number_out := 6;
      SELECT target_type BULK COLLECT into l_folder_types
      FROM mgmt_type_properties
      WHERE property_name= MGMT_GLOBAL.G_IS_SERVICE_PROP
        AND property_value='1';
      get_subtab_preferred_cols(subtab_name_in => emd_pref.mgmt_user_pref_services,
                                case_in        => case_number_out,
                                pref_cols_out  => user_prefs_cur_out);

      get_targets_summary6(l_folder_types, 
                           search_query_in, 
                           search_mode_in, 
                           targets_cur_out,
                           tgt_types_srch_lst_in,
                           target_name_in,
                           location_in,      
                           lob_in,         
                           deployment_in,
                           comment_in,       
                           contact_in);

      get_properties_summary_1(emd_pref.mgmt_user_pref_services,
                               search_query_in, 
                               prop_vals_cur_out,
                               search_mode_in,
                               tgt_types_srch_lst_in,
                               target_name_in,
                               location_in,      
                               lob_in,         
                               deployment_in,
                               comment_in,       
                               contact_in);
    ELSE
      case_number_out := 4;
      get_subtab_preferred_cols(subtab_name_in => emd_pref.MGMT_USER_PREF_GROUPS,
                                case_in        => case_number_out,
                                pref_cols_out  => user_prefs_cur_out);

      get_targets_summary4(folder_types_in, 
                           search_query_in, 
                           search_mode_in, 
                           targets_cur_out,
                           tgt_types_srch_lst_in,
                           target_name_in,
                           location_in,      
                           lob_in,         
                           deployment_in,
                           comment_in,       
                           contact_in);

      get_properties_summary_2(emd_pref.MGMT_USER_PREF_GROUPS, 
                               search_query_in,
                               prop_vals_cur_out, 
                               search_mode_in,
                               tgt_types_srch_lst_in,
                               target_name_in,
                               location_in,      
                               lob_in,         
                               deployment_in,
                               comment_in,       
                               contact_in);
    END IF;
  -- Case5:
  --   l_target_type_count >= 1, l_has_mem_derv_alert_count > 0
  --   Groups folder
  ELSIF(l_target_type_count >= 1 AND l_has_mem_derv_alert_count > 0)
  THEN
    IF (l_is_system)
    THEN
      case_number_out := 7;
      SELECT target_type BULK COLLECT into l_folder_types
      FROM mgmt_type_properties
      WHERE property_name= MGMT_GLOBAL.G_IS_SYSTEM_PROP
        AND property_value='1';
      get_subtab_preferred_cols(subtab_name_in => emd_pref.mgmt_user_pref_systems,
                                case_in        => case_number_out,
                                pref_cols_out  => user_prefs_cur_out);

      get_targets_summary7(l_folder_types, 
                           search_query_in, 
                           search_mode_in,
                           targets_cur_out,
                           tgt_types_srch_lst_in,
                           target_name_in,
                           location_in,      
                           lob_in,         
                           deployment_in,
                           comment_in,       
                           contact_in);

      get_properties_summary_1(emd_pref.mgmt_user_pref_systems,
                               search_query_in, 
                               prop_vals_cur_out,
                               search_mode_in,
                               tgt_types_srch_lst_in,
                               target_name_in,
                               location_in,      
                               lob_in,         
                               deployment_in,
                               comment_in,       
                               contact_in);
    ELSIF (l_is_group)
    THEN
      case_number_out := 5;
      SELECT target_type BULK COLLECT into l_folder_types
      FROM  (
        SELECT target_type FROM mgmt_type_properties
      WHERE property_name= MGMT_GLOBAL.G_IS_GROUP_PROP
        AND property_value='1'
      MINUS
      SELECT target_type FROM mgmt_type_properties
      WHERE ( property_name= MGMT_GLOBAL.G_IS_SYSTEM_PROP 
         OR   property_name= MGMT_GLOBAL.G_IS_CLUSTER_PROP)
        AND property_value='1'
      )
      -- Putting this additional clause to increase selectivity.
      -- Out of the target types got from is_group, get only those target types
      -- which are present in the EM (from mgmt_targets).
      WHERE target_type IN                  
      (SELECT DISTINCT target_type 
       FROM mgmt_targets);

      get_subtab_preferred_cols(subtab_name_in => emd_pref.MGMT_USER_PREF_GROUPS,
                                case_in => case_number_out,
                                pref_cols_out => user_prefs_cur_out);
      get_targets_summary5(l_folder_types, 
                           search_query_in, 
                           search_mode_in,
                           targets_cur_out,
                           tgt_types_srch_lst_in,
                           target_name_in,
                           location_in,
                           lob_in,
                           deployment_in,
                           comment_in,
                           contact_in);
      get_properties_summary_1(emd_pref.MGMT_USER_PREF_GROUPS,
                               search_query_in,
                               prop_vals_cur_out,
                               search_mode_in,
                               tgt_types_srch_lst_in,
                               target_name_in,
                               location_in,      
                               lob_in,         
                               deployment_in,
                               comment_in,       
                               contact_in);

      END IF; --End group/system if
        -- gets member type
        -- we use metric_vals_cur_out so for this so we do not have
        -- to change top level signature
        IF (search_query_in IS NULL)
        THEN
        -- This query is being broken up because of performance problems.
        -- 1st case: if folder_types = 1, then get only the first 3 member types in the descending order
        -- of their count.
        -- Implementing analytical function only when folder_types = 1
        -- 2nd case: Restricting the query to get the target types to 10 records so that it increases selectivity.
        -- 3rd case: Leave the existing query as is. This will happen when there are large number of target types (more than 10) under the 
        --           Groups / Systems tabs.
            IF (l_folder_types.COUNT = 1 )
            THEN
                OPEN member_type_cur_out FOR
                SELECT  target_name, 
                        target_type, 
                        member_type,
                        member_type_display,
                        member_type_count
                FROM
                (
                    SELECT  t1.target_name, 
                            t1.target_type, 
                            t.target_type as member_type,
                            t.type_display_name as member_type_display,
                            count(t.target_guid) as member_type_count,
                            rank() over (partition by t1.target_name 
                                        ORDER by count(t.target_guid) desc) r
                    FROM    mgmt_flat_target_assoc a,
                            mgmt_targets t,
                            mgmt_targets t1
                    WHERE   a.source_target_guid = t1.target_guid AND 
                            a.is_membership = 1 AND 
                            a.assoc_target_guid = t.target_guid AND 
                            t1.target_type = l_folder_types(1)
                    GROUP BY t.target_type, 
		                     t1.target_name, 
			                 t1.target_type, 
                             t.type_display_name
                ) WHERE r in (1,2,3);
            ELSIF (l_folder_types.COUNT < 11 ) 
            THEN
                OPEN member_type_cur_out FOR
                SELECT  t1.target_name, 
                        t1.target_type, 
                        t.target_type as member_type,
                        t.type_display_name as member_type_display,
                        count(t.target_guid) as member_type_count
                FROM    mgmt_flat_target_assoc a,
                        mgmt_targets t,
                        (
                        SELECT  target_name, target_type, target_guid
                        FROM    mgmt_targets
                        WHERE EXISTS 
                            ( 
                            SELECT  'x'
                            FROM    TABLE(CAST(l_folder_types AS SMP_EMD_STRING_ARRAY))  
                            WHERE   target_type = column_value AND
				                    ROWNUM < 11 )) t1
                WHERE   a.source_target_guid = t1.target_guid AND 
                        a.is_membership = 1 AND 
                        a.assoc_target_guid = t.target_guid
                GROUP BY t.target_type, t1.target_name, t1.target_type, t.type_display_name
                ORDER BY member_type_count DESC;
            ELSE
                OPEN member_type_cur_out FOR
                SELECT t1.target_name, t1.target_type, t.target_type as member_type,
                       t.type_display_name as member_type_display,
                       count(t.target_guid) as member_type_count
                FROM  mgmt_flat_target_assoc a,
                      mgmt_targets t,
                      (SELECT  target_name, target_type, target_guid
                       FROM mgmt_targets
                       WHERE EXISTS
                             ( SELECT 'x'
                                  FROM  TABLE(CAST(l_folder_types AS SMP_EMD_STRING_ARRAY))
                                  WHERE target_type = column_value)) t1
                 WHERE a.source_target_guid = t1.target_guid
                       AND a.is_membership = 1
                       AND a.assoc_target_guid = t.target_guid
                 GROUP BY t.target_type, t1.target_name, t1.target_type, t.type_display_name
                 ORDER BY member_type_count DESC;
            END IF;
         ELSE
             l_target_array := get_targets(search_query_in,
                                      search_mode_in,
                                      tgt_types_srch_lst_in,
                                      target_name_in,
                                      location_in,
                                      lob_in,
                                      deployment_in,
                                      comment_in,
                                      contact_in);
             OPEN member_type_cur_out FOR
              SELECT t1.target_name, t1.target_type, t.target_type as member_type, 
                     t.type_display_name as member_type_display, 
                     count(t.target_guid) as member_type_count
                FROM mgmt_flat_target_assoc a,
                     mgmt_targets t,
                     ( SELECT target_name, target_type, target_guid 
                         FROM TABLE(CAST(l_target_array AS SMP_EMD_TGT_OBJECT_TBL))) t1
               WHERE a.source_target_guid IN t1.target_guid
                 AND a.is_membership = 1
                 AND a.assoc_target_guid = t.target_guid
                 GROUP BY t.target_type, t1.target_name, t1.target_type, t.type_display_name
                 ORDER BY member_type_count DESC;
       END IF; 
  END IF;
EXCEPTION
  WHEN OTHERS THEN
    RAISE;
END get_targets_summary;

--
-- PURPOSE:
--    Returns three target type lists:
--    1.  target types : all available target types from mgmt_targets
--    2.  parent types : all possible parent types from mgmt_target_memberships;
--    3.  child types  : all possible child types from mgmt_target_memberships;
--
PROCEDURE get_types_in_target_selection(priv_name_in IN VARCHAR2,
                                        target_types_cur_out OUT cursorType,
                                        parent_types_cur_out OUT cursorType,
                                        child_types_cur_out OUT cursorType) IS
BEGIN
  -- find the target types the user can see
  target_types_cur_out := MGMT_USER.GET_TARGET_TYPES(priv_name_in);

  OPEN parent_types_cur_out FOR
    SELECT DISTINCT ct.target_type composite_target_type
      FROM mgmt_target_assocs, mgmt_targets ct
      WHERE ct.target_guid = source_target_guid
        AND assoc_guid = MGMT_ASSOC.g_contains_guid;

  OPEN child_types_cur_out FOR
    SELECT DISTINCT mt.target_type member_target_type
      FROM mgmt_target_assocs, mgmt_targets mt
     WHERE assoc_target_guid = mt.target_guid
       AND assoc_guid = MGMT_ASSOC.g_contains_guid;

END get_types_in_target_selection;


--
-- PURPOSE:
--    Returns target information from mgmt_targets 
--    target_guids_in : array of target guids that user selected from 
--    targetSelection page
--
PROCEDURE get_targets_info(target_guids_in IN MGMT_USER_GUID_ARRAY,
                           targets_cursor_out OUT cursorType) IS
BEGIN
  OPEN targets_cursor_out FOR
    SELECT * 
    --SELECT target_guid, target_name, target_type, load_timestamp,
    --       timezone_delta, display_name, type_display_name, service_type,
    --       host_name, emd_url, last_load_time, is_group, broken_str, 
    --       broken_reason, last_rt_load_time, timezone_region
      FROM TABLE(CAST(target_guids_in AS MGMT_USER_GUID_ARRAY)) guids,
           MGMT_TARGETS tgt
     WHERE tgt.target_guid = guids.column_value;

END get_targets_info;

--
--  A util function to get the list of targets on which a user has a  
--  certain privilege with given search criteria
--
FUNCTION GET_TARGETS_BY_HOST_WITH_PRIV(priv_name_in IN VARCHAR2,
                                       target_type_in IN VARCHAR2,
                                       target_name_search_in IN VARCHAR2,
                                       host_name_search_in IN VARCHAR2)
RETURN TARGETS_CURSOR
IS
  targets_cursor_out TARGETS_CURSOR;
  uname          VARCHAR2(256);
  pname          VARCHAR2(30);
  include_agents BOOLEAN := FALSE;
  tguids         MGMT_USER_GUID_ARRAY;
  group_members  MGMT_USER_GUID_ARRAY;
  max_row_num    NUMBER := 201;
  l_user_name    VARCHAR2(64) := mgmt_user.get_current_em_user();
  l_iprivs       MGMT_SHORT_STRING_ARRAY;
BEGIN

  uname := UPPER(l_user_name);
  pname := UPPER(priv_name_in);

  -- If this is a SUPER_USER or the privilege is VIEW_TARGET and the user then
  -- no need to check for privileges. For VIEW_TARGET case since the query is
  -- executed in the context of the current user, the VPD will filter the
  -- targets the user can see
  IF MGMT_USER.HAS_PRIV(uname, MGMT_USER.SUPER_USER) = MGMT_USER.USER_HAS_PRIV 
     OR pname = MGMT_USER.VIEW_TARGET 
  THEN
    IF( target_type_in = '%' AND
        target_name_search_in = '%'  AND  
        host_name_search_in = '%') 
    THEN
        -- return all targets of all types
        OPEN targets_cursor_out FOR 
          SELECT tgt.target_guid,
                 tgt.target_name, 
                 tgt.target_type, 
                 tgt.host_name,
                 NVL(avail.current_status,MGMT_GLOBAL.G_STATUS_UNKNOWN) cur_status
            FROM MGMT_TARGETS tgt, MGMT_CURRENT_AVAILABILITY avail
            WHERE tgt.target_guid = avail.target_guid
            AND rownum < max_row_num;
    ELSE
        OPEN targets_cursor_out FOR
          SELECT tgt.target_guid,
                 tgt.target_name,
                 tgt.target_type,
                 tgt.host_name,
                 NVL(avail.current_status,MGMT_GLOBAL.G_STATUS_UNKNOWN) cur_status
            FROM MGMT_TARGETS tgt, MGMT_CURRENT_AVAILABILITY avail
            WHERE tgt.target_type like target_type_in
            AND UPPER(host_name) like host_name_search_in
            AND UPPER(tgt.target_name) like target_name_search_in
            AND tgt.target_guid = avail.target_guid
            AND rownum < max_row_num;
    END IF;

  ELSE
    -- Get the privs that include this privilege
    SELECT priv_name BULK COLLECT INTO l_iprivs
    FROM mgmt_priv_includes where ipriv_name = pname;
    l_iprivs.extend;
    l_iprivs(l_iprivs.COUNT) := pname;

    -- not a super user
    IF( target_type_in = '%' AND
        target_name_search_in = '%'  AND
        host_name_search_in = '%')
    THEN
      OPEN targets_cursor_out FOR
        SELECT tgt.target_guid,
               tgt.target_name,
               tgt.target_type,
               tgt.host_name,
               NVL(avail.current_status, MGMT_GLOBAL.G_STATUS_UNKNOWN) cur_status
          FROM MGMT_TARGETS tgt,
               MGMT_CURRENT_AVAILABILITY avail
         WHERE tgt.target_guid = avail.target_guid (+)
           AND EXISTS (
                SELECT guid
                  FROM MGMT_PRIV_GRANTS
                 WHERE (grantee = uname OR
                        grantee IN (SELECT role_name FROM MGMT_ROLE_GRANTS
                        START WITH grantee = uname
                        CONNECT BY PRIOR role_name = grantee))
                   AND  tgt.target_guid = guid
                   AND  priv_name IN (SELECT * FROM
                        TABLE(CAST(l_iprivs AS MGMT_SHORT_STRING_ARRAY)))
                 )
           AND rownum < max_row_num;
     ELSE
      OPEN targets_cursor_out FOR
        SELECT tgt.target_guid,
               tgt.target_name,
               tgt.target_type,
               tgt.host_name,
               NVL(avail.current_status, MGMT_GLOBAL.G_STATUS_UNKNOWN) cur_status
          FROM MGMT_TARGETS tgt,
               MGMT_CURRENT_AVAILABILITY avail
         WHERE tgt.target_guid = avail.target_guid (+)
           AND tgt.target_type like target_type_in
           AND UPPER(host_name) like host_name_search_in
           AND UPPER(tgt.target_name) like target_name_search_in
           AND EXISTS (
                SELECT guid
                  FROM MGMT_PRIV_GRANTS
                 WHERE (grantee = uname OR
                        grantee IN (SELECT role_name FROM MGMT_ROLE_GRANTS
                        START WITH grantee = uname
                        CONNECT BY PRIOR role_name = grantee))
                   AND  tgt.target_guid = guid
                   AND  priv_name IN (SELECT * FROM
                        TABLE(CAST(l_iprivs AS MGMT_SHORT_STRING_ARRAY)))
                 )
           AND rownum < max_row_num;
     END IF;
  END IF;

  -- data has been obtained, return the cursor
  RETURN targets_cursor_out; 

END GET_TARGETS_BY_HOST_WITH_PRIV;


--
--  A util function to get the list of targets on which a user has a
--  certain privilege with given search criteria
--
FUNCTION GET_TARGETS_BY_MEMBERSHIP(priv_name_in IN VARCHAR2,
                                   target_type_in IN VARCHAR2,
                                   target_name_search_in IN VARCHAR2,
                                   parent_type_in IN VARCHAR2,
                                   parent_name_search_in IN VARCHAR)
RETURN TARGETS_CURSOR
IS
  targets_cursor_out TARGETS_CURSOR;
  uname          VARCHAR2(256);
  pname          VARCHAR2(30);
  include_agents BOOLEAN := FALSE;
  tguids         MGMT_USER_GUID_ARRAY;
  group_members  MGMT_USER_GUID_ARRAY;
  max_row_num    NUMBER := 201;
  l_user_name    VARCHAR2(64) := mgmt_user.get_current_em_user();
  l_iprivs       MGMT_SHORT_STRING_ARRAY;
BEGIN

  uname := UPPER(l_user_name);
  pname := UPPER(priv_name_in);

  -- If this is a SUPER_USER or the privilege is VIEW_TARGET and the user then
  -- no need to check for privileges. For VIEW_TARGET case since the query is
  -- executed in the context of the current user, the VPD will filter the
  -- targets the user can see
  IF MGMT_USER.HAS_PRIV(uname, MGMT_USER.SUPER_USER) = MGMT_USER.USER_HAS_PRIV 
     OR pname = MGMT_USER.VIEW_TARGET 
  THEN
    IF( target_type_in = '%' AND
        parent_type_in = '%' AND  
        parent_name_search_in = '%' AND 
        target_name_search_in = '%')
    THEN
      OPEN targets_cursor_out FOR
        SELECT tgt.target_guid,
               tgt.target_name,
               tgt.target_type,
               ct.target_name as host_name,
               ct.target_type composite_target_type,
               NVL(avail.current_status, MGMT_GLOBAL.G_STATUS_UNKNOWN) cur_status
          FROM MGMT_TARGETS tgt,
               MGMT_CURRENT_AVAILABILITY avail,
               MGMT_TARGET_ASSOCS tm,
               MGMT_TARGETS ct
         WHERE tgt.target_guid = avail.target_guid
           AND tm.assoc_target_guid = tgt.target_guid
           AND tm.assoc_guid = MGMT_ASSOC.g_contains_guid
           AND ct.target_guid = tm.source_target_guid 
           AND rownum < max_row_num;
     ELSE 
        OPEN targets_cursor_out FOR
          SELECT tgt.target_guid,
                 tgt.target_name,
                 tgt.target_type,
                 ct.target_name as host_name,
                 ct.target_type composite_target_type,
                 NVL(avail.current_status, MGMT_GLOBAL.G_STATUS_UNKNOWN) cur_status
            FROM MGMT_TARGETS tgt,
                 MGMT_CURRENT_AVAILABILITY avail,
                 MGMT_TARGET_ASSOCS tm,
                 MGMT_TARGETS ct
           WHERE tgt.target_guid = avail.target_guid
             AND tm.assoc_target_guid = tgt.target_guid
             AND tm.assoc_guid = MGMT_ASSOC.g_contains_guid
             AND ct.target_guid = tm.source_target_guid
             AND tgt.target_type like target_type_in
             AND UPPER(tgt.target_name) like target_name_search_in
             AND ct.target_type like parent_type_in
             AND UPPER(ct.target_name) like parent_name_search_in
             AND rownum < max_row_num; 
    END IF;
    return targets_cursor_out;
  ELSE
    -- Get the privs that include this privilege
    SELECT priv_name BULK COLLECT INTO l_iprivs
    FROM mgmt_priv_includes where ipriv_name = pname;
    l_iprivs.extend;
    l_iprivs(l_iprivs.COUNT) := pname;

    IF( target_type_in = '%' AND
        parent_type_in = '%' AND  
        parent_name_search_in = '%' AND 
        target_name_search_in = '%')
    THEN
      OPEN targets_cursor_out FOR
        SELECT tgt.target_guid,
               tgt.target_name,
               tgt.target_type,
               ct.target_name as host_name,
               ct.target_type composite_target_type,
               NVL(avail.current_status, MGMT_GLOBAL.G_STATUS_UNKNOWN) cur_status
          FROM MGMT_TARGETS tgt,
               MGMT_CURRENT_AVAILABILITY avail,
               MGMT_TARGET_ASSOCS tm,
               MGMT_TARGETS ct
         WHERE tgt.target_guid = avail.target_guid
           AND tm.assoc_guid = MGMT_ASSOC.g_contains_guid
           AND ct.target_guid = tm.source_target_guid
           AND tm.assoc_target_guid = tgt.target_guid
           AND EXISTS (
                SELECT guid
                  FROM MGMT_PRIV_GRANTS
                 WHERE (grantee = uname OR
                        grantee IN (SELECT role_name FROM MGMT_ROLE_GRANTS
                        START WITH grantee = uname 
                        CONNECT BY PRIOR role_name = grantee))
                   AND  tgt.target_guid = guid
                   AND  priv_name IN (SELECT * FROM
                        TABLE(CAST(l_iprivs AS MGMT_SHORT_STRING_ARRAY)))
                 )           
           AND rownum < max_row_num;
     ELSE 
        OPEN targets_cursor_out FOR
          SELECT tgt.target_guid,
                 tgt.target_name,
                 tgt.target_type,
                 ct.target_name as host_name,
                 ct.target_type composite_target_type,
                 NVL(avail.current_status, MGMT_GLOBAL.G_STATUS_UNKNOWN) cur_status
            FROM MGMT_TARGETS tgt,
                 MGMT_CURRENT_AVAILABILITY avail,
                 MGMT_TARGET_ASSOCS tm,
                 MGMT_TARGETS ct
           WHERE tgt.target_guid = avail.target_guid
             AND tm.assoc_guid = MGMT_ASSOC.g_contains_guid
             AND ct.target_guid = tm.source_target_guid
             AND tm.assoc_target_guid = tgt.target_guid
             AND tgt.target_type like target_type_in
             AND UPPER(tgt.target_name) like target_name_search_in
             AND ct.target_type like parent_type_in
             AND UPPER(ct.target_name) like parent_name_search_in
             AND EXISTS (
                  SELECT guid
                    FROM MGMT_PRIV_GRANTS
                   WHERE (grantee = uname OR
                          grantee IN (SELECT role_name FROM MGMT_ROLE_GRANTS
                          START WITH grantee = uname 
                          CONNECT BY PRIOR role_name = grantee))
                   AND  tgt.target_guid = guid
                   AND  priv_name IN (SELECT * FROM
                        TABLE(CAST(l_iprivs AS MGMT_SHORT_STRING_ARRAY)))
                 )             
             AND rownum < max_row_num; 
    END IF;
  
    return targets_cursor_out;

  END IF;

END GET_TARGETS_BY_MEMBERSHIP;

--
--  A util function to get the list of targets on which a user has a
--  certain privilege with given search criteria
--  In addition this is to search targets that are member targets.
--
FUNCTION GET_TARGETS_BY_MEMBERS(priv_name_in IN VARCHAR2,
                                target_type_in IN VARCHAR2,
                                target_name_search_in IN VARCHAR2,
                                child_type_in IN VARCHAR2,
                                child_name_search_in IN VARCHAR)
RETURN TARGETS_CURSOR
IS
  targets_cursor_out TARGETS_CURSOR;
  uname          VARCHAR2(256);
  pname          VARCHAR2(30);
  include_agents BOOLEAN := FALSE;
  tguids         MGMT_USER_GUID_ARRAY;
  group_members  MGMT_USER_GUID_ARRAY;
  max_row_num    NUMBER := 201;
  l_user_name    VARCHAR2(64) := mgmt_user.get_current_em_user();
  l_iprivs       MGMT_SHORT_STRING_ARRAY;
BEGIN

  uname := UPPER(l_user_name);
  pname := UPPER(priv_name_in);

  -- If this is a SUPER_USER or the privilege is VIEW_TARGET and the user then
  -- no need to check for privileges. For VIEW_TARGET case since the query is
  -- executed in the context of the current user, the VPD will filter the
  -- targets the user can see
  IF MGMT_USER.HAS_PRIV(uname, MGMT_USER.SUPER_USER) = MGMT_USER.USER_HAS_PRIV 
     OR pname = MGMT_USER.VIEW_TARGET 
  THEN
    IF( target_type_in ='%' AND
        child_type_in = '%' AND
        child_name_search_in = '%' AND 
        target_name_search_in = '%')
    THEN
      OPEN targets_cursor_out FOR
        SELECT tgt.target_guid,
               tgt.target_name,
               tgt.target_type,
               tgt.host_name,
               NVL(avail.current_status, MGMT_GLOBAL.G_STATUS_UNKNOWN) cur_status
          FROM MGMT_TARGETS tgt,
               MGMT_CURRENT_AVAILABILITY avail
         WHERE tgt.target_guid = avail.target_guid (+)
           AND EXISTS(
                   select mt.target_name 
                     from mgmt_flat_target_assoc a, mgmt_targets mt, mgmt_targets ct
                    WHERE ct.target_name = tgt.target_name
                      AND a.is_membership = 1
                      AND ct.target_guid = a.source_target_guid
                      AND mt.target_guid = a.assoc_target_guid )
           AND rownum < max_row_num; 
    ELSE
        OPEN targets_cursor_out FOR
        SELECT tgt.target_guid,
               tgt.target_name,
               tgt.target_type,
               tgt.host_name,
               NVL(avail.current_status, MGMT_GLOBAL.G_STATUS_UNKNOWN) cur_status
          FROM MGMT_TARGETS tgt,
               MGMT_CURRENT_AVAILABILITY avail
         WHERE tgt.target_guid = avail.target_guid (+)
           AND tgt.target_type like target_type_in
           AND UPPER(tgt.target_name) like target_name_search_in 
           AND EXISTS(
                   select mt.target_name, mt.target_type 
                     from mgmt_flat_target_assoc a, mgmt_targets mt, mgmt_targets ct
                    WHERE ct.target_name = tgt.target_name
                      AND a.is_membership = 1
                      AND ct.target_guid = a.source_target_guid
                      AND mt.target_guid = a.assoc_target_guid
                      AND mt.target_type like child_type_in
                      AND UPPER(mt.target_name) like child_name_search_in)
           AND rownum < max_row_num; 
    END IF;

--    return targets_cursor_out;

  ELSE     
    -- Get the privs that include this privilege
    SELECT priv_name BULK COLLECT INTO l_iprivs
    FROM mgmt_priv_includes where ipriv_name = pname;
    l_iprivs.extend;
    l_iprivs(l_iprivs.COUNT) := pname;

    IF( target_type_in ='%' AND
        child_type_in = '%' AND
        child_name_search_in = '%' AND 
        target_name_search_in = '%')
    THEN
      OPEN targets_cursor_out FOR
        SELECT tgt.target_guid,
               tgt.target_name,
               tgt.target_type,
               tgt.host_name,
               NVL(avail.current_status, MGMT_GLOBAL.G_STATUS_UNKNOWN) cur_status
          FROM MGMT_TARGETS tgt,                 
               MGMT_CURRENT_AVAILABILITY avail
         WHERE tgt.target_guid = avail.target_guid (+)
           AND EXISTS(
                   select mt.target_name, mt.target_type 
                     from mgmt_flat_target_assoc a, mgmt_targets mt, mgmt_targets ct
                    WHERE ct.target_name = tgt.target_name
                      AND a.is_membership = 1
                      AND ct.target_guid = a.source_target_guid
                      AND mt.target_guid = a.assoc_target_guid)
           AND EXISTS (
                SELECT guid
                  FROM MGMT_PRIV_GRANTS
                 WHERE (grantee = uname OR
                        grantee IN (SELECT role_name FROM MGMT_ROLE_GRANTS
                        START WITH grantee = uname 
                        CONNECT BY PRIOR role_name = grantee))
                   AND  tgt.target_guid = guid
                   AND  priv_name IN (SELECT * FROM
                        TABLE(CAST(l_iprivs AS MGMT_SHORT_STRING_ARRAY)))
                 )
           AND rownum < max_row_num;
    ELSE
      OPEN targets_cursor_out FOR
        SELECT tgt.target_guid,
               tgt.target_name,
               tgt.target_type,
               tgt.host_name,
               NVL(avail.current_status, MGMT_GLOBAL.G_STATUS_UNKNOWN) cur_status
          FROM MGMT_TARGETS tgt,                 
               MGMT_CURRENT_AVAILABILITY avail
         WHERE tgt.target_guid = avail.target_guid (+)
           AND tgt.target_type like target_type_in
           AND UPPER(tgt.target_name)like target_name_search_in
           AND EXISTS(
                   select mt.target_name, mt.target_type 
                     from mgmt_flat_target_assoc a, mgmt_targets mt, mgmt_targets ct
                    WHERE ct.target_name = tgt.target_name
                      AND a.is_membership = 1
                      AND ct.target_guid = a.source_target_guid
                      AND mt.target_guid = a.assoc_target_guid
                      AND mt.target_type like child_type_in
                      AND UPPER(mt.target_name) like child_name_search_in)
           AND EXISTS (
                SELECT guid
                  FROM MGMT_PRIV_GRANTS
                 WHERE (grantee = uname OR
                        grantee IN (SELECT role_name FROM MGMT_ROLE_GRANTS
                        START WITH grantee = uname 
                        CONNECT BY PRIOR role_name = grantee))
                   AND  tgt.target_guid = guid
                   AND  priv_name IN (SELECT * FROM
                        TABLE(CAST(l_iprivs AS MGMT_SHORT_STRING_ARRAY)))
                 )
           AND rownum < max_row_num;
      END IF; 

  END IF;
  return targets_cursor_out;
END GET_TARGETS_BY_MEMBERS;

PROCEDURE GET_TYPES_RESOURCE_BUNDLES(bundles_out OUT cursorType) IS
l_current_user VARCHAR2(256) := MGMT_USER.GET_CURRENT_EM_USER;
BEGIN
    -- We need to assume super-user privilege since the user may
    -- not be able to see all the types 
    SETEMUSERCONTEXT(MGMT_USER.GET_REPOSITORY_OWNER, 
                     MGMT_USER.OP_SET_IDENTIFIER);

    OPEN bundles_out FOR
      SELECT target_type, type_display_name, type_display_nlsid,
             type_resource_bundle 
        FROM mgmt_target_types; 

    SETEMUSERCONTEXT(l_current_user, MGMT_USER.OP_SET_IDENTIFIER);

EXCEPTION WHEN OTHERS
THEN
    -- Make sure to rest the user context in the case of any errors
    SETEMUSERCONTEXT(l_current_user, MGMT_USER.OP_SET_IDENTIFIER);
    RAISE;
END GET_TYPES_RESOURCE_BUNDLES;

--
-- Purpose:
--   delete multiple targets 
--
-- IN parameters:
--   target_guids_in: MGMT_USER_GUID_ARRAY  target guids
--
PROCEDURE DELETE_TARGETS(target_guids_in IN MGMT_USER_GUID_ARRAY) IS
  l_tgt_inst SMP_EMD_DELETE_REC_ARRAY := SMP_EMD_DELETE_REC_ARRAY();

BEGIN

  SELECT SMP_EMD_DELETE_REC(tgt.target_name, tgt.target_type)
         BULK COLLECT INTO l_tgt_inst
    FROM TABLE(CAST(target_guids_in AS MGMT_USER_GUID_ARRAY)) guids,
         mgmt_targets tgt
    WHERE guids.column_value = tgt.target_guid;

  FOR i in l_tgt_inst.FIRST..l_tgt_inst.LAST
  LOOP
    mgmt_admin.delete_target(l_tgt_inst(i).targetName, l_tgt_inst(i).targetType,
      0, 0, 1);
  END LOOP;

END DELETE_TARGETS;

--
-- Purpose:
--   updates License table
--
-- IN parameters:
--   user_name_in : name of EM user
--   check_dont_show_in: user marks the don't show agreement checkbox or not
--
PROCEDURE UPDATE_USER_LICENSE(username_in IN VARCHAR2,
                              i_agree_in  IN VARCHAR2,
                              setup_details_in IN SMP_EMD_STRING_ARRAY
                                               DEFAULT NULL) IS
  isTrue NUMBER := 1;
                              
BEGIN
  -- delete all old user license entry 
  DELETE FROM mgmt_licenses
   WHERE username = UPPER(username_in);

  -- insert into the mgmt_license table
  INSERT INTO MGMT_LICENSES(username, i_agree) VALUES(UPPER(username_in), i_agree_in);

  IF setup_details_in IS NOT NULL
  THEN
    em_license.save_setup_data(setup_details_in);
  END IF;

END UPDATE_USER_LICENSE;

--
-- Name: get_target_mntr_settings
--
-- Package: emd_mntr
--
-- Purpose: 
--  Get the monitoring_settings which include metric thresholds, policies, and
--  collections for the given target.
--
PROCEDURE get_target_mntr_settings(target_name_in IN VARCHAR2,
                                   target_type_in IN VARCHAR2,
                                   language_code_in IN VARCHAR2,
                                   country_code_in IN VARCHAR2,
                                   has_remote_out OUT NUMBER,
                                   policy_cur_out OUT cursorType,
                                   collection_cur_out OUT cursorType,
                                   key_render_cur_out OUT cursorType,
                                   policy_ctxt_cur_out OUT cursorType,
                                   ca_multitask_cur_out OUT cursorType,
                                   ca_param_cur_out OUT cursorType,
                                   ca_cred_cur_out OUT cursorType,
                                   job_types_cur_out OUT cursorType) IS

  l_target_guid mgmt_targets.target_guid%TYPE;
  l_default_guid mgmt_policy_assoc.object_guid%TYPE;
  l_type_meta_ver mgmt_targets.type_meta_ver%TYPE;
  l_category_prop_1 mgmt_targets.category_prop_1%TYPE;
  l_category_prop_2 mgmt_targets.category_prop_2%TYPE;
  l_category_prop_3 mgmt_targets.category_prop_3%TYPE;
  l_category_prop_4 mgmt_targets.category_prop_4%TYPE;
  l_category_prop_5 mgmt_targets.category_prop_5%TYPE;

BEGIN

 -- get the target guid and category property columns
  BEGIN
    SELECT target_guid, type_meta_ver, category_prop_1, category_prop_2,
           category_prop_3, category_prop_4, category_prop_5
      INTO l_target_guid, l_type_meta_ver, l_category_prop_1, l_category_prop_2,
           l_category_prop_3, l_category_prop_4, l_category_prop_5
      FROM mgmt_targets
     WHERE target_name = target_name_in
       AND target_type = target_type_in;

    EXCEPTION
      WHEN NO_DATA_FOUND
      THEN
        raise MGMT_GLOBAL.target_does_not_exist;
  END;

  l_default_guid := EM_TARGET.generate_target_type_guid(target_type_in);

  -- check if we have remote metrics for this target type
    SELECT DECODE(COUNT(met.remote), 0, 0, 1) INTO has_remote_out
      FROM mgmt_metrics met
     WHERE met.target_type = target_type_in
       AND met.usage_type = MGMT_GLOBAL.G_USAGE_VIEW_COLLECT
       AND met.remote != 0
       AND met.type_meta_ver = l_type_meta_ver
       AND (met.category_prop_1 = l_category_prop_1 OR met.category_prop_1 = ' ')
       AND (met.category_prop_2 = l_category_prop_2 OR met.category_prop_2 = ' ')
       AND (met.category_prop_3 = l_category_prop_3 OR met.category_prop_3 = ' ')
       AND (met.category_prop_4 = l_category_prop_4 OR met.category_prop_4 = ' ')
       AND (met.category_prop_5 = l_category_prop_5 OR met.category_prop_5 = ' ');

  -- renderable information of key columns for metrics with composite keys
  OPEN key_render_cur_out FOR
    SELECT met.metric_name, met.key_order, met.is_renderable
      FROM mgmt_metrics met
     WHERE met.target_type = target_type_in
       AND met.num_keys > 1
       AND met.key_order ! = 0
       AND met.type_meta_ver = l_type_meta_ver
       AND (met.category_prop_1 = l_category_prop_1 OR met.category_prop_1 = ' ')
       AND (met.category_prop_2 = l_category_prop_2 OR met.category_prop_2 = ' ')
       AND (met.category_prop_3 = l_category_prop_3 OR met.category_prop_3 = ' ')
       AND (met.category_prop_4 = l_category_prop_4 OR met.category_prop_4 = ' ')
       AND (met.category_prop_5 = l_category_prop_5 OR met.category_prop_5 = ' ')
     ORDER BY met.metric_name, met.key_order;

  -- metric threshold and policy information
  OPEN policy_cur_out FOR
    SELECT met.metric_name,
           met.metric_label, 
           met.metric_label_nlsid,  
           met.metric_column,
           met.column_label,
           met.column_label_nlsid,
           met.metric_type,
           met.num_keys,
           met.key_column,
           met.is_repository,
           met.is_transposed,
           met.has_push,
           met.has_pull,
           met.remote,
           met.non_thresholded_alerts,
           met.keyonly_thresholds,
           p.policy_guid,
           p.policy_name,
           NVL(msg.message, NVL(emsg.message, p.policy_name)) AS policy_name_display,
           p.metric_guid,
           p.policy_type,
           p.policy_label_nlsid,
           NVL(msgdesc.message, NVL(emsgdesc.message, p.description)) AS description,
           p.violation_level,
           p.condition_type,
           p.condition,
           p.condition_operator,
           p.message,
           p.message_nlsid,
           p.clear_message,
           p.clear_message_nlsid,
           p.detailed_url_link,
           p.owner,
           pc.category_name as category,
           NVL(msgcat.message, NVL(emsgcat.message, pc.category_name)) AS   category_display,
           pa.coll_name,
           pa.is_enabled,
           pa.add_or_delete,
           pac.key_value,
           pac.key_operator,
           pac.eval_order,
           pac.is_exception,
           pac.is_push,
           pac.has_active_baseline,
           pac.prevent_override,
           pac.crit_action_job_id,
           pac.warn_action_job_id,
           pac.info_action_job_id,
           TRIM(pac.fixit_job) as fixit_job,
           pac.simultaneous_actions,
           pac.importance,
           pac.num_occurrences,
           pacp.param_name,
           NVL(msgparam.message,NVL(emsgparam.message, pp.param_name)) AS param_name_display,
           pp.param_type,
           pacp.crit_threshold,
           pacp.warn_threshold,
           pacp.info_threshold,
           dpacp.crit_threshold as default_crit_threshold,
           dpacp.warn_threshold as default_warn_threshold,
           dpacp.info_threshold as default_info_threshold,
           compkeys.key_part1_value,
           compkeys.key_part2_value,
           compkeys.key_part3_value,
           compkeys.key_part4_value,
           compkeys.key_part5_value,
           am.agent_side_metric_guid,
           am.agent_side_metric_name,
           am.agent_side_metric_label,
           am.agent_side_metric_label_nlsid             
      FROM mgmt_metrics met,
           mgmt_policies p, 
           mgmt_category_map pcm, mgmt_categories pc,
           mgmt_policy_assoc pa,
           mgmt_policy_assoc_cfg pac, mgmt_policy_assoc_cfg_params pacp,
           mgmt_policy_parameters pp,
           (SELECT message, message_id 
            FROM mgmt_messages 
            WHERE subsystem = 'POLICY' 
              AND language_code = language_code_in 
              AND country_code = country_code_in) msg,
           (SELECT message, message_id 
            FROM mgmt_messages 
            WHERE subsystem = 'POLICY' 
              AND language_code = 'en'              
              AND country_code = ' ') emsg,
           (SELECT message, message_id 
            FROM mgmt_messages 
            WHERE subsystem = 'POLICY' 
              AND language_code = language_code_in 
              AND country_code = country_code_in) msgdesc,
           (SELECT message, message_id 
            FROM mgmt_messages 
            WHERE subsystem = 'POLICY' 
              AND language_code = 'en'              
              AND country_code = ' ') emsgdesc,
           (SELECT message, message_id 
            FROM mgmt_messages 
            WHERE subsystem = 'CATEGORY' 
              AND language_code = language_code_in 
              AND country_code = country_code_in) msgcat,
           (SELECT message, message_id 
            FROM mgmt_messages 
            WHERE subsystem = 'CATEGORY' 
              AND language_code = 'en'              
              AND country_code = ' ') emsgcat,
           (SELECT message, message_id 
            FROM mgmt_messages 
            WHERE subsystem = 'POLICY' 
              AND language_code = language_code_in 
              AND country_code = country_code_in) msgparam,
           (SELECT message, message_id 
            FROM mgmt_messages 
            WHERE subsystem = 'POLICY' 
              AND language_code = 'en'              
              AND country_code = ' ') emsgparam,
           mgmt_policy_assoc_cfg_params dpacp,mgmt_metrics_composite_keys compkeys,
           (SELECT p.policy_guid,
                   m.metric_guid as agent_side_metric_guid,
                   m.metric_name as agent_side_metric_name,
                   m.metric_label as agent_side_metric_label,
                   m.metric_label_nlsid as agent_side_metric_label_nlsid
              FROM mgmt_policies p, mgmt_snapshot_metric_map s,
                   mgmt_metrics m, mgmt_collection_metric_tasks cmt
             WHERE p.target_type = target_type_in
               AND p.policy_type = MGMT_GLOBAL.G_TYPE_POLICY
               AND s.snapshot_target_type = target_type_in
               AND s.metric_guid = p.metric_guid
               AND m.target_type = target_type_in
               AND m.type_meta_ver = l_type_meta_ver
               AND (m.category_prop_1 = l_category_prop_1 OR m.category_prop_1 = ' ')
               AND (m.category_prop_2 = l_category_prop_2 OR m.category_prop_2 = ' ')
               AND (m.category_prop_3 = l_category_prop_3 OR m.category_prop_3 = ' ')
               AND (m.category_prop_4 = l_category_prop_4 OR m.category_prop_4 = ' ')
               AND (m.category_prop_5 = l_category_prop_5 OR m.category_prop_5 = ' ')
               AND cmt.target_guid = l_target_guid
               AND cmt.coll_name = s.snapshot_name
               AND cmt.metric_guid = m.metric_guid) am
     WHERE met.target_type = target_type_in
       AND met.type_meta_ver = l_type_meta_ver
       AND (met.category_prop_1 = l_category_prop_1 OR met.category_prop_1 = ' ')
       AND (met.category_prop_2 = l_category_prop_2 OR met.category_prop_2 = ' ')
       AND (met.category_prop_3 = l_category_prop_3 OR met.category_prop_3 = ' ')
       AND (met.category_prop_4 = l_category_prop_4 OR met.category_prop_4 = ' ')
       AND (met.category_prop_5 = l_category_prop_5 OR met.category_prop_5 = ' ')
       AND p.metric_guid = met.metric_guid
       AND p.policy_type = MGMT_GLOBAL.G_TYPE_POLICY
       AND p.target_type = target_type_in
       AND p.policy_guid = pcm.object_guid (+)
       AND MGMT_GLOBAL.G_CATEGORY_CLASS_FUNCTIONAL = pcm.class_name (+)
       AND pcm.category_name = pc.category_name (+)      
       AND pa.object_guid = l_target_guid
       AND pa.policy_guid = p.policy_guid
    -- AND pa.coll_name = ?
       AND pa.object_type = MGMT_GLOBAL.G_OBJECT_TYPE_TARGET
       AND pa.object_guid = pac.object_guid
    -- AND pac.object_guid  = l_target_guid
       AND pac.policy_guid = pa.policy_guid
       AND pac.coll_name = pa.coll_name
       AND pac.object_guid = pacp.object_guid (+)  
       AND pac.policy_guid = pacp.policy_guid (+)
       AND pac.coll_name = pacp.coll_name (+)
       AND pac.key_value = pacp.key_value (+)
       AND pac.key_operator = pacp.key_operator (+)  
       AND pacp.policy_guid = pp.policy_guid (+)
       AND pacp.param_name = pp.param_name (+) 
       AND l_default_guid = dpacp.object_guid (+)
       AND pacp.policy_guid = dpacp.policy_guid (+) 
       AND pacp.coll_name = dpacp.coll_name (+)
       AND pacp.key_value = dpacp.key_value (+)
       AND pacp.key_operator = dpacp.key_operator (+)
       AND pacp.param_name = dpacp.param_name (+) 
       AND pac.key_value = compkeys.composite_key (+)
       AND pac.object_guid = compkeys.target_guid(+)
       AND p.policy_guid = am.policy_guid (+)
       AND msg.message_id(+)       =  p.policy_label_nlsid
       AND emsg.message_id(+)      =  p.policy_label_nlsid
       AND msgdesc.message_id(+)   =  p.description_nlsid
       AND emsgdesc.message_id(+)  =  p.description_nlsid
       AND msgcat.message_id(+)    =  pc.category_name_nlsid
       AND emsgcat.message_id(+)   =  pc.category_name_nlsid
       AND msgparam.message_id(+)  =  pp.param_name_nlsid
       AND emsgparam.message_id(+) =  pp.param_name_nlsid
    UNION
    SELECT met.metric_name,
           met.metric_label, 
           met.metric_label_nlsid,  
           met.metric_column,
           met.column_label,
           met.column_label_nlsid,
           met.metric_type,
           met.num_keys,
           met.key_column,
           met.is_repository,
           met.is_transposed,
           met.has_push,
           met.has_pull,
           met.remote,
           met.non_thresholded_alerts,
           met.keyonly_thresholds,
           met.metric_guid AS policy_guid,
           met.metric_column AS policy_name,
           NULL AS policy_name_display,
           tablemet.metric_guid,
           MGMT_GLOBAL.G_TYPE_THRESHOLD_METRIC AS policy_type,
           NULL AS policy_label_nlsid,
           NULL AS description,
           NULL AS violation_level,
           MGMT_GLOBAL.G_CONDITION_THRESHOLD AS condition_type,
           met.metric_column AS condition,
           pac.condition_operator,
           pac.message,
           pac.message_nlsid,
           pac.clear_message,
           pac.clear_message_nlsid,
           NULL AS detailed_url_link,
           NULL AS owner,
           NULL AS category,
           NULL AS category_display,
           pa.coll_name,
           pa.is_enabled,
           pa.add_or_delete,
           pac.key_value,
           pac.key_operator,
           pac.eval_order,
           pac.is_exception,
           pac.is_push,
           pac.has_active_baseline,
           pac.prevent_override,
           pac.crit_action_job_id,
           pac.warn_action_job_id,
           pac.info_action_job_id,
           TRIM(pac.fixit_job) as fixit_job,
           pac.simultaneous_actions,
           pac.importance,
           pac.num_occurrences,
           pacp.param_name,
           NULL AS param_name_display,
           NULL AS param_type,
           pacp.crit_threshold,
           pacp.warn_threshold,
           pacp.info_threshold,
           NULL AS default_crit_threshold,
           NULL AS default_warn_threshold,
           NULL AS default_info_threshold,
           compkeys.key_part1_value,
           compkeys.key_part2_value,
           compkeys.key_part3_value,
           compkeys.key_part4_value,
           compkeys.key_part5_value,
           NULL as agent_side_metric_guid,
           NULL as agent_side_metric_name,
           NULL as agent_side_metric_label,
           NULL as agent_side_metric_label_nlsid
      FROM mgmt_metrics met,
           (SELECT metric_name, metric_guid
              FROM mgmt_metrics
             WHERE target_type = target_type_in
               AND usage_type = MGMT_GLOBAL.G_USAGE_VIEW_COLLECT
               AND type_meta_ver = l_type_meta_ver
               AND (category_prop_1 = l_category_prop_1 OR category_prop_1 = ' ')
               AND (category_prop_2 = l_category_prop_2 OR category_prop_2 = ' ')
               AND (category_prop_3 = l_category_prop_3 OR category_prop_3 = ' ')
               AND (category_prop_4 = l_category_prop_4 OR category_prop_4 = ' ')
               AND (category_prop_5 = l_category_prop_5 OR category_prop_5 = ' ')
               AND metric_column = ' ') tablemet,
           mgmt_policy_assoc pa,
           mgmt_policy_assoc_cfg pac,
           mgmt_policy_assoc_cfg_params pacp,
           (SELECT composite_key, key_part1_value, key_part2_value,
                   key_part3_value, key_part4_value, key_part5_value
              FROM mgmt_metrics_composite_keys
             WHERE target_guid = l_target_guid) compkeys
     WHERE met.target_type = target_type_in
       AND met.usage_type = MGMT_GLOBAL.G_USAGE_VIEW_COLLECT
       AND met.type_meta_ver = l_type_meta_ver
       AND (met.category_prop_1 = l_category_prop_1 OR met.category_prop_1 = ' ')
       AND (met.category_prop_2 = l_category_prop_2 OR met.category_prop_2 = ' ')
       AND (met.category_prop_3 = l_category_prop_3 OR met.category_prop_3 = ' ')
       AND (met.category_prop_4 = l_category_prop_4 OR met.category_prop_4 = ' ')
       AND (met.category_prop_5 = l_category_prop_5 OR met.category_prop_5 = ' ')
       AND met.metric_name = tablemet.metric_name
       AND pa.object_guid = l_target_guid
       AND pa.object_guid = pac.object_guid
       AND pa.policy_guid = met.metric_guid
    -- AND pa.coll_name = ?
       AND pa.object_type = MGMT_GLOBAL.G_OBJECT_TYPE_TARGET
    -- AND pac.object_guid  = l_target_guid
       AND pac.policy_guid = pa.policy_guid
       AND pac.coll_name = pa.coll_name
       AND pac.object_guid = pacp.object_guid
       AND pac.policy_guid = pacp.policy_guid
       AND pac.coll_name = pacp.coll_name
       AND pac.key_value = pacp.key_value
       AND pac.key_operator = pacp.key_operator
       AND pac.key_value = compkeys.composite_key (+)
     ORDER BY policy_type, policy_guid, eval_order, key_value;

  -- collection information
  OPEN collection_cur_out FOR
    SELECT met.metric_guid,
           met.metric_name,
           met.metric_label,
           met.metric_label_nlsid,
           met.metric_type,
           met.is_repository,
           met.is_transposed,
           met.has_push,
           met.has_pull,
           met.remote,
           met.non_thresholded_alerts,
           c.coll_name,
           c.is_enabled,
           c.schedule_ex,
           c.store_metric,
           c.upload_frequency,
           c.frequency_code,
           c.start_time,
           c.end_time,
           c.execution_hours,
           c.execution_minutes,
           c.interval,
           c.months,
           c.days,
           NVL(ci.is_required, 0) AS is_required,
           cip.property_name,
           cip.property_value,
           cc.credential_set_name,
           cc.credential_set_column,
           cc.credential_value
      FROM mgmt_metrics met, mgmt_collections c,
           mgmt_collection_metric_tasks cmt,
           (SELECT coll_name, is_required
              FROM mgmt_coll_items
             WHERE target_type = target_type_in
               AND type_meta_ver = l_type_meta_ver
               AND (category_prop_1 = l_category_prop_1 OR category_prop_1 = ' ')
               AND (category_prop_2 = l_category_prop_2 OR category_prop_2 = ' ')
               AND (category_prop_3 = l_category_prop_3 OR category_prop_3 = ' ')
               AND (category_prop_4 = l_category_prop_4 OR category_prop_4 = ' ')
               AND (category_prop_5 = l_category_prop_5 OR category_prop_5 = ' ') ) ci,
           (SELECT metric_guid, coll_name, property_name, property_value
              FROM mgmt_coll_item_properties
             WHERE object_guid = l_target_guid
               AND object_type = MGMT_GLOBAL.G_OBJECT_TYPE_TARGET) cip,
           (SELECT collc.metric_guid, collc.coll_name, 
                   collc.credential_set_name, cred.credential_set_column,
                   decode(cred.credential_value, NULL, NULL, 
                     decrypt(cred.credential_value) ) AS credential_value
              FROM mgmt_collection_credentials collc, mgmt_credentials2 cred
             WHERE collc.target_guid = l_target_guid
               AND collc.credential_guid = cred.credential_guid) cc
     WHERE met.target_type = target_type_in
       AND (met.metric_type = MGMT_GLOBAL.G_METRIC_TYPE_TABLE OR 
            met.metric_type = MGMT_GLOBAL.G_METRIC_TYPE_REPOS_TABLE OR
            met.metric_type = MGMT_GLOBAL.G_METRIC_TYPE_RAW OR
            met.metric_type = MGMT_GLOBAL.G_METRIC_TYPE_EXTERNAL)
       AND met.type_meta_ver = l_type_meta_ver
       AND (met.category_prop_1 = l_category_prop_1 OR met.category_prop_1 = ' ')
       AND (met.category_prop_2 = l_category_prop_2 OR met.category_prop_2 = ' ')
       AND (met.category_prop_3 = l_category_prop_3 OR met.category_prop_3 = ' ')
       AND (met.category_prop_4 = l_category_prop_4 OR met.category_prop_4 = ' ')
       AND (met.category_prop_5 = l_category_prop_5 OR met.category_prop_5 = ' ')
       AND c.object_guid = l_target_guid
       AND c.object_type = MGMT_GLOBAL.G_OBJECT_TYPE_TARGET
       AND c.coll_name = ci.coll_name (+)
       AND cmt.target_guid = l_target_guid
       AND cmt.coll_name = c.coll_name
       AND cmt.metric_guid = met.metric_guid
       AND cmt.metric_guid = cip.metric_guid (+)
       AND cmt.coll_name = cip.coll_name (+)
       AND cmt.metric_guid = cc.metric_guid (+)
       AND cmt.coll_name = cc.coll_name (+)
     ORDER BY met.metric_guid;

  -- violation context definitions
  OPEN policy_ctxt_cur_out FOR
    SELECT p.policy_guid,
           met.is_transposed,
           pa.coll_name,
           pvcd.column_name
      FROM mgmt_metrics met,
           mgmt_policies p, 
           mgmt_policy_assoc pa,
           mgmt_policy_viol_ctxt_def pvcd
     WHERE pa.object_guid = l_target_guid
       AND pa.policy_guid = p.policy_guid
       AND pvcd.policy_guid = p.policy_guid
       AND p.metric_guid = met.metric_guid
       AND met.type_meta_ver = l_type_meta_ver
       AND (met.category_prop_1 = l_category_prop_1 OR met.category_prop_1 = ' ')
       AND (met.category_prop_2 = l_category_prop_2 OR met.category_prop_2 = ' ')
       AND (met.category_prop_3 = l_category_prop_3 OR met.category_prop_3 = ' ')
       AND (met.category_prop_4 = l_category_prop_4 OR met.category_prop_4 = ' ')
       AND (met.category_prop_5 = l_category_prop_5 OR met.category_prop_5 = ' ')
     ORDER BY pvcd.policy_guid, pvcd.column_position;

  -- corrective action information
  OPEN ca_multitask_cur_out FOR
    SELECT ca.job_id,
           ca.ca_reference_count
      FROM MGMT_CORRECTIVE_ACTION ca,
           MGMT_JOB j,
           MGMT_JOB_TYPE_INFO jti
     WHERE j.job_id = ca.job_id
       AND j.job_type = jti.job_type
       AND jti.job_type_category = MGMT_JOB_ENGINE.JOBTYPE_CATEGORY_HIDDEN
       AND ca.ca_scope = MGMT_CA.CA_SCOPE_TARGET
       AND ca.ca_target_guid = l_target_guid;

  OPEN ca_param_cur_out FOR
    SELECT ca.job_id,
           ca.ca_reference_count, 
           j.job_name,
           j.job_description,
           j.job_type,
           j.job_owner,
           jp.parameter_name,
           jp.parameter_type,
           MGMT_JOB_ENGINE.decrypt_scalar(jp.encrypted, jp.scalar_value) scalar_value,
           MGMT_JOB_ENGINE.decrypt_vector(jp.encrypted, jp.vector_value) vector_value
      FROM MGMT_CORRECTIVE_ACTION ca,
           MGMT_JOB j,
           MGMT_JOB_TYPE_INFO jti,
           MGMT_JOB_PARAMETER jp
     WHERE j.job_id = ca.job_id
       AND j.job_type = jti.job_type
       AND jti.job_type_category != MGMT_JOB_ENGINE.JOBTYPE_CATEGORY_HIDDEN
       AND j.job_id = jp.job_id (+)
       AND jp.execution_id = MGMT_JOB_ENGINE.NO_EXECUTION
       AND ca.ca_scope = MGMT_CA.CA_SCOPE_TARGET
       AND ca.ca_target_guid = l_target_guid;

  OPEN ca_cred_cur_out FOR
    SELECT ca.job_id,
           jc.credential_guid, 
           jc.container_location,
           jc.credential_set_name,
           jc.user_name,
           c2.credential_set_column, 
           decode(c2.credential_value, null, null, 
                  decrypt(c2.credential_value)) credential_value
      FROM MGMT_CORRECTIVE_ACTION ca,
           MGMT_JOB j,
           MGMT_JOB_TYPE_INFO jti,
           MGMT_JOB_CREDENTIALS jc,
           MGMT_CREDENTIALS2 c2
     WHERE j.job_id = ca.job_id
       AND j.job_type = jti.job_type
       AND jti.job_type_category != MGMT_JOB_ENGINE.JOBTYPE_CATEGORY_HIDDEN
       AND ca.job_id = jc.job_id
       AND jc.credential_guid = c2.credential_guid
       AND ca.ca_scope = MGMT_CA.CA_SCOPE_TARGET
       AND ca.ca_target_guid = l_target_guid;

  OPEN job_types_cur_out FOR
    SELECT UNIQUE mv.job_type
      FROM MGMT_JOB_TYPE_DISPLAY_INFO tdi,
           MGMT_JOB_TYPE_INFO ti,
           MGMT_JOB_SINGLE_TARGET_TYPES stt,
           MGMT_JOB_TYPE_MAX_VERSIONS mv
     WHERE tdi.use_default_create_ui = 1
       AND ti.editable = 1
       AND tdi.job_type_id = stt.job_type_id
       AND mv.job_type_id=tdi.job_type_id
       AND ti.job_type_id=tdi.job_type_id
       AND mv.major_version=1
       AND (stt.single_target_type = 'all' OR
            stt.single_target_type = target_type_in OR
            stt.single_target_type IN (SELECT property_value
                                         FROM MGMT_TYPE_PROPERTIES
                                        WHERE property_name = MGMT_GLOBAL.G_CLUSTER_MEMBER_TYPE_PROP
                                          AND target_type = target_type_in));

END get_target_mntr_settings;

--
-- Name: get_object_mntr_settings
--
-- Package: emd_mntr
--
-- Purpose: 
--  Get the monitoring_settings which include metric thresholds, policies, and
--  collections for the given object (template, template copy or monitoring settings copy).
--
PROCEDURE get_object_mntr_settings(object_guid_in IN RAW,
                                   object_type_in IN NUMBER,
                                   target_type_in IN VARCHAR2,
                                   language_code_in IN VARCHAR2,
                                   country_code_in IN VARCHAR2,                                     
                                   has_remote_out OUT NUMBER,
                                   policy_cur_out OUT cursorType,
                                   collection_cur_out OUT cursorType,
                                   key_render_cur_out OUT cursorType,
                                   policy_ctxt_cur_out OUT cursorType,
                                   ca_multitask_cur_out OUT cursorType,
                                   ca_param_cur_out OUT cursorType,
                                   ca_cred_cur_out OUT cursorType,
                                   job_types_cur_out OUT cursorType,
                                   target_guid_in IN RAW DEFAULT NULL) IS

  l_ca_scope NUMBER(1);
    l_default_guid mgmt_policy_assoc.object_guid%TYPE;

BEGIN

  IF (object_type_in = MGMT_GLOBAL.G_OBJECT_TYPE_TEMPLATE) THEN
    l_ca_scope := MGMT_CA.CA_SCOPE_TEMPLATE;
  ELSIF (object_type_in = MGMT_GLOBAL.G_OBJECT_TYPE_TEMPLATE_COPY) THEN
    l_ca_scope := MGMT_CA.CA_SCOPE_TEMPLATE_COPY;
  ELSE 
    -- There's no CAs for monitoring settings copy. Set to 0 (non-existing scope)
    l_ca_scope := 0;
  END IF;

  l_default_guid := EM_TARGET.generate_target_type_guid(target_type_in);

  -- check if we have remote metrics for this target type
    SELECT DECODE(COUNT(met.remote), 0, 0, 1) INTO has_remote_out
      FROM mgmt_metrics met
     WHERE met.target_type = target_type_in
       AND met.usage_type = MGMT_GLOBAL.G_USAGE_VIEW_COLLECT
       AND met.remote != 0;

  -- renderable information of key columns for metrics with composite keys
  -- note that this may return duplicate rows if is_renderable is 1 in
  -- some versions and 0 in other versions
  OPEN key_render_cur_out FOR
    SELECT DISTINCT met.metric_name, met.key_order, met.is_renderable
      FROM mgmt_metrics met
     WHERE met.target_type = target_type_in
       AND met.num_keys > 1
       AND met.key_order ! = 0
     ORDER BY met.metric_name, met.key_order;

  -- metric threshold and policy information
  OPEN policy_cur_out FOR
    SELECT met.metric_name,
           met.metric_label, 
           met.metric_label_nlsid,    
           met.metric_column,
           met.column_label,
           met.column_label_nlsid,
           met.metric_type,
           met.num_keys,
           met.key_column,
           met.is_repository,
           met.is_transposed,
           met.has_push,
           met.has_pull,
           met.remote,
           met.non_thresholded_alerts,
           met.keyonly_thresholds,
           p.policy_guid,
           p.policy_name,
           NVL(msg.message,   NVL(emsg.message,   p.policy_name))
           as policy_name_display,
           p.metric_guid,
           p.policy_type,
           p.policy_label_nlsid,
           NVL(msgdesc.message,   NVL(emsgdesc.message,   p.description))
           as description,
           p.violation_level,
           p.condition_type,
           p.condition,
           p.condition_operator,
           p.message,
           p.message_nlsid,
           p.clear_message,
           p.clear_message_nlsid,
           p.detailed_url_link,
           p.owner,
           pc.category_name as category,
           NVL(msgcat.message,   NVL(emsgcat.message,   pc.category_name))
           as category_display, 
           pa.coll_name,
           pa.is_enabled,
           pa.add_or_delete,
           pac.key_value,
           pac.key_operator,
           pac.eval_order,
           pac.is_exception,
           pac.is_push,
           pac.has_active_baseline,
           pac.prevent_override,
           pac.crit_action_job_id,
           pac.warn_action_job_id,
           pac.info_action_job_id,
           TRIM(pac.fixit_job) as fixit_job,
           pac.simultaneous_actions,
           pac.importance,
           pac.num_occurrences,
           pacp.param_name,
           NVL(msgparam.message,   NVL(emsgparam.message,   pp.param_name))
           as param_name_display, 
           pp.param_type,
           pacp.crit_threshold,
           pacp.warn_threshold,
           pacp.info_threshold,
           dpacp.crit_threshold as default_crit_threshold,
           dpacp.warn_threshold as default_warn_threshold,
           dpacp.info_threshold as default_info_threshold,
           compkeys.key_part1_value,
           compkeys.key_part2_value,
           compkeys.key_part3_value,
           compkeys.key_part4_value,
           compkeys.key_part5_value,
           am.agent_side_metric_guid,
           am.agent_side_metric_name,
           am.agent_side_metric_label,
           am.agent_side_metric_label_nlsid              
      FROM (SELECT DISTINCT metric_guid, metric_name, metric_label, metric_label_nlsid, 
                   metric_column, column_label, column_label_nlsid, metric_type, 
                   num_keys, key_column, is_repository, is_transposed,
                   has_push, has_pull, remote, non_thresholded_alerts, keyonly_thresholds
              FROM mgmt_metrics 
             WHERE target_type = target_type_in) met,
           mgmt_policies p, 
           mgmt_category_map pcm, mgmt_categories pc,
           mgmt_policy_assoc pa,
           mgmt_policy_assoc_cfg pac,
           mgmt_policy_assoc_cfg_params pacp,
           mgmt_policy_parameters pp,
           mgmt_policy_assoc_cfg_params dpacp,
           mgmt_metrics_composite_keys compkeys,
           (SELECT DISTINCT p.policy_guid,
                   m.metric_guid as agent_side_metric_guid,
                   m.metric_name as agent_side_metric_name,
                   m.metric_label as agent_side_metric_label,
                   m.metric_label_nlsid as agent_side_metric_label_nlsid
              FROM mgmt_policies p, mgmt_snapshot_metric_map s,
                   mgmt_metrics m, mgmt_coll_item_metrics cim
             WHERE p.target_type = target_type_in
               AND p.policy_type = MGMT_GLOBAL.G_TYPE_POLICY
               AND s.snapshot_target_type = target_type_in
               AND s.metric_guid = p.metric_guid
               AND m.target_type = target_type_in
               AND cim.target_type = target_type_in
               AND cim.coll_name = s.snapshot_name
               AND cim.metric_guid = m.metric_guid) am,
           (SELECT message, message_id
            FROM mgmt_messages
            WHERE subsystem = 'POLICY'
              AND language_code = language_code_in
              AND country_code = country_code_in) msg,
           (SELECT message, message_id
            FROM mgmt_messages
            WHERE subsystem = 'POLICY'
              AND language_code = 'en'
              AND country_code = ' ') emsg,
           (SELECT message, message_id
            FROM mgmt_messages
            WHERE subsystem = 'POLICY'
              AND language_code = language_code_in
              AND country_code = country_code_in) msgdesc,
           (SELECT message, message_id
            FROM mgmt_messages
            WHERE subsystem = 'POLICY'
              AND language_code = 'en'
              AND country_code = ' ') emsgdesc,
           (SELECT message, message_id
            FROM mgmt_messages
            WHERE subsystem = 'CATEGORY'
              AND language_code = language_code_in
              AND country_code = country_code_in) msgcat,
           (SELECT message, message_id
            FROM mgmt_messages
            WHERE subsystem = 'CATEGORY'
              AND language_code = 'en'
              AND country_code = ' ') emsgcat,
           (SELECT message, message_id
            FROM mgmt_messages
            WHERE subsystem = 'POLICY'
              AND language_code = language_code_in
              AND country_code = country_code_in) msgparam,
           (SELECT message, message_id
            FROM mgmt_messages
            WHERE subsystem = 'POLICY'
              AND language_code = 'en'
              AND country_code = ' ') emsgparam
     WHERE p.metric_guid = met.metric_guid 
       AND p.policy_type = MGMT_GLOBAL.G_TYPE_POLICY
       AND p.target_type = target_type_in
       AND p.policy_guid = pcm.object_guid (+)
       AND pcm.class_name (+) = MGMT_GLOBAL.G_CATEGORY_CLASS_FUNCTIONAL
       ANd pcm.target_type = target_type_in
       AND pcm.category_name = pc.category_name (+)      
       AND pa.object_guid = object_guid_in
       AND pa.policy_guid = p.policy_guid
       AND pa.object_type = object_type_in
       AND pac.object_guid  = pa.object_guid
       AND pac.policy_guid = pa.policy_guid
       AND pac.coll_name = pa.coll_name      
       AND pac.object_guid = pacp.object_guid (+)  
       AND pac.policy_guid = pacp.policy_guid (+)
       AND pac.coll_name = pacp.coll_name (+)
       AND pac.key_value = pacp.key_value (+)
       AND pac.key_operator = pacp.key_operator (+)  
       AND pacp.policy_guid = pp.policy_guid (+)
       AND pacp.param_name = pp.param_name (+) 
       AND dpacp.object_guid (+) = l_default_guid
       AND pacp.policy_guid = dpacp.policy_guid (+) 
       AND pacp.coll_name = dpacp.coll_name (+)
       AND pacp.key_value = dpacp.key_value (+)
       AND pacp.key_operator = dpacp.key_operator (+)
       AND pacp.param_name = dpacp.param_name (+) 
       AND p.policy_guid = am.policy_guid(+)
       AND pac.key_value = compkeys.composite_key (+)
       AND pac.object_guid = compkeys.target_guid (+)
       AND msg.message_id(+)       =  p.policy_label_nlsid
       AND emsg.message_id(+)      =  p.policy_label_nlsid
       AND msgdesc.message_id(+)   =  p.description_nlsid
       AND emsgdesc.message_id(+)  =  p.description_nlsid
       AND msgcat.message_id(+)    =  pc.category_name_nlsid
       AND emsgcat.message_id(+)   =  pc.category_name_nlsid
       AND msgparam.message_id(+)  =  pp.param_name_nlsid
       AND emsgparam.message_id(+) =  pp.param_name_nlsid
   UNION ALL
       SELECT met.metric_name,
           met.metric_label, 
           met.metric_label_nlsid,    
           met.metric_column,
           met.column_label,
           met.column_label_nlsid,
           met.metric_type,
           met.num_keys,
           met.key_column,
           met.is_repository,
           met.is_transposed,
           met.has_push,
           met.has_pull,
           met.remote,
           met.non_thresholded_alerts,
           met.keyonly_thresholds,
           met.metric_guid AS policy_guid,
           met.metric_column AS policy_name,
           NULL AS policy_name_display,
           tablemet.metric_guid,
           MGMT_GLOBAL.G_TYPE_THRESHOLD_METRIC AS policy_type,
           NULL AS policy_label_nlsid,
           NULL AS description,
           NULL AS violation_level,
           MGMT_GLOBAL.G_CONDITION_THRESHOLD AS condition_type,
           met.metric_column AS condition,
           pac.condition_operator,
           pac.message,
           pac.message_nlsid,
           pac.clear_message,
           pac.clear_message_nlsid,
           NULL AS detailed_url_link,
           NULL AS owner,
           NULL AS category,
           NULL AS category_display,
           pa.coll_name,
           pa.is_enabled,
           pa.add_or_delete,
           pac.key_value,
           pac.key_operator,
           pac.eval_order,
           pac.is_exception,
           pac.is_push,
           pac.has_active_baseline,
           pac.prevent_override,
           pac.crit_action_job_id,
           pac.warn_action_job_id,
           pac.info_action_job_id,
           TRIM(pac.fixit_job) as fixit_job,
           pac.simultaneous_actions,
           pac.importance,
           pac.num_occurrences,
           pacp.param_name,
           NULL AS param_name_display,
           NULL AS param_type,
           pacp.crit_threshold,
           pacp.warn_threshold,
           pacp.info_threshold,
           NULL AS default_crit_threshold,
           NULL AS default_warn_threshold,
           NULL AS default_info_threshold,
           compkeys.key_part1_value,
           compkeys.key_part2_value,
           compkeys.key_part3_value,
           compkeys.key_part4_value,
           compkeys.key_part5_value,
           NULL AS agent_side_metric_guid,
           NULL AS agent_side_metric_name,
           NULL AS agent_side_metric_label,
           NULL AS agent_side_metric_label_nlsid
      FROM (SELECT /*+ no_merge */ DISTINCT metric_guid, metric_name, metric_label, metric_label_nlsid,
                   metric_column, column_label, column_label_nlsid, metric_type,
                   num_keys, key_column, is_repository, is_transposed,
                   has_push, has_pull, remote, non_thresholded_alerts, keyonly_thresholds
              FROM mgmt_metrics
             WHERE target_type = target_type_in
               AND usage_type = MGMT_GLOBAL.G_USAGE_VIEW_COLLECT) met,
           (SELECT /*+ no_merge */ DISTINCT metric_name, metric_guid
              FROM mgmt_metrics
             WHERE target_type = target_type_in
               AND usage_type = MGMT_GLOBAL.G_USAGE_VIEW_COLLECT
               AND metric_column = ' ') tablemet,
           mgmt_policy_assoc pa,
           mgmt_policy_assoc_cfg pac,
           mgmt_policy_assoc_cfg_params pacp,
           mgmt_metrics_composite_keys compkeys
     WHERE met.metric_name = tablemet.metric_name
       AND pa.object_guid = object_guid_in
       AND pa.policy_guid = met.metric_guid
       AND pa.object_type = object_type_in
       AND pac.object_guid = pa.object_guid
       AND pac.policy_guid = pa.policy_guid
       AND pac.coll_name = pa.coll_name
       AND pac.object_guid = pacp.object_guid
       AND pac.policy_guid = pacp.policy_guid
       AND pac.coll_name = pacp.coll_name
       AND pac.key_value = pacp.key_value
       AND pac.key_operator = pacp.key_operator
       AND pac.key_value = compkeys.composite_key (+)
       AND pac.object_guid = compkeys.target_guid(+)
     ORDER BY policy_type, policy_guid, eval_order, key_value;

  -- collection information
  OPEN collection_cur_out FOR
    SELECT met.metric_guid,
           met.metric_name,
           met.metric_label,
           met.metric_label_nlsid,
           met.metric_type,
           met.is_repository,
           met.is_transposed,
           met.has_push,
           met.has_pull,
           met.remote,
           met.non_thresholded_alerts,
           c.coll_name,
           c.is_enabled,
           c.schedule_ex,
           c.store_metric,
           c.upload_frequency,
           c.frequency_code,
           c.start_time,
           c.end_time,
           c.execution_hours,
           c.execution_minutes,
           c.interval,
           c.months,
           c.days,
           NULL AS is_required,
           cip.property_name,
           cip.property_value,
           cc.credential_set_name,
           cc.credential_set_column,
           cc.credential_value
      FROM (SELECT DISTINCT metric_guid, metric_name, metric_label,
                   metric_label_nlsid, metric_type,
                   is_repository, is_transposed, has_push, has_pull, remote,
                   non_thresholded_alerts
              FROM mgmt_metrics 
             WHERE target_type = target_type_in
               AND (metric_type = MGMT_GLOBAL.G_METRIC_TYPE_TABLE OR 
                    metric_type = MGMT_GLOBAL.G_METRIC_TYPE_REPOS_TABLE OR
                    metric_type = MGMT_GLOBAL.G_METRIC_TYPE_RAW OR
                    metric_type = MGMT_GLOBAL.G_METRIC_TYPE_EXTERNAL) ) met,
           mgmt_collections c,
           mgmt_collection_metric_tasks cmt,
           (SELECT metric_guid, coll_name, property_name, property_value
              FROM mgmt_coll_item_properties
             WHERE object_guid = object_guid_in
               AND object_type = object_type_in) cip,
           (SELECT collc.metric_guid, collc.coll_name, 
                   collc.credential_set_name, cred.credential_set_column,
                   decode(cred.credential_value, NULL, NULL, 
                     decrypt(cred.credential_value) ) AS credential_value
              FROM mgmt_collection_template_creds collc, mgmt_credentials2 cred
             WHERE collc.object_guid = object_guid_in
               AND collc.object_type = MGMT_CREDENTIAL.OBJECT_TYPE_TEMPLATE_COPY
               AND collc.target_guid = target_guid_in
               AND collc.credential_guid = cred.credential_guid) cc
     WHERE c.object_guid = object_guid_in
       AND c.object_type = object_type_in
       AND cmt.target_guid = object_guid_in
       AND cmt.coll_name = c.coll_name
       AND cmt.metric_guid = met.metric_guid
       AND cmt.metric_guid = cip.metric_guid (+)
       AND cmt.coll_name = cip.coll_name (+)
       AND cmt.metric_guid = cc.metric_guid (+)
       AND cmt.coll_name = cc.coll_name (+)
     ORDER BY met.metric_guid;

  -- violation context definitions
  OPEN policy_ctxt_cur_out FOR
    SELECT p.policy_guid,
           met.is_transposed,
           pa.coll_name,
           pvcd.column_name
      FROM mgmt_metrics met,
           mgmt_policies p, 
           mgmt_policy_assoc pa,
           mgmt_policy_viol_ctxt_def pvcd
     WHERE pa.object_guid = object_guid_in
       AND pa.policy_guid = p.policy_guid
       AND pvcd.policy_guid = p.policy_guid
       AND p.metric_guid = met.metric_guid
     ORDER BY pvcd.policy_guid, pvcd.column_position;

  -- corrective action information
  OPEN ca_multitask_cur_out FOR
    SELECT ca.job_id,
           ca.ca_reference_count
      FROM MGMT_CORRECTIVE_ACTION ca,
           MGMT_JOB j,
           MGMT_JOB_TYPE_INFO jti
     WHERE j.job_id = ca.job_id
       AND j.job_type = jti.job_type
       AND jti.job_type_category = MGMT_JOB_ENGINE.JOBTYPE_CATEGORY_HIDDEN
       AND ca.ca_scope = l_ca_scope
       AND ca.ca_template_guid = object_guid_in;

  OPEN ca_param_cur_out FOR
    SELECT ca.job_id,
           ca.ca_reference_count,
           j.job_name,
           j.job_description,
           j.job_type,
           j.job_owner,
           jp.parameter_name,
           jp.parameter_type,
           MGMT_JOB_ENGINE.decrypt_scalar(jp.encrypted, jp.scalar_value) scalar_value,
           MGMT_JOB_ENGINE.decrypt_vector(jp.encrypted, jp.vector_value) vector_value
      FROM MGMT_CORRECTIVE_ACTION ca,
           MGMT_JOB j,
           MGMT_JOB_TYPE_INFO jti,
           MGMT_JOB_PARAMETER jp
     WHERE j.job_id = ca.job_id
       AND j.job_type = jti.job_type
       AND jti.job_type_category != MGMT_JOB_ENGINE.JOBTYPE_CATEGORY_HIDDEN
       AND j.job_id = jp.job_id (+)
       AND jp.execution_id = MGMT_JOB_ENGINE.NO_EXECUTION
       AND ca.ca_scope = l_ca_scope
       AND ca.ca_template_guid = object_guid_in;

  OPEN ca_cred_cur_out FOR
    SELECT ca.job_id,
           jc.credential_guid, 
           jc.container_location,
           jc.credential_set_name,
           jc.user_name,
           c2.credential_set_column, 
           decode(c2.credential_value, null, null, 
                  decrypt(c2.credential_value)) credential_value
      FROM MGMT_CORRECTIVE_ACTION ca,
           MGMT_JOB j,
           MGMT_JOB_TYPE_INFO jti,
           MGMT_JOB_CREDENTIALS jc,
           MGMT_CREDENTIALS2 c2
     WHERE j.job_id = ca.job_id
       AND j.job_type = jti.job_type
       AND jti.job_type_category != MGMT_JOB_ENGINE.JOBTYPE_CATEGORY_HIDDEN
       AND ca.job_id = jc.job_id
       AND jc.credential_guid = c2.credential_guid
       AND ca.ca_scope = l_ca_scope
       AND ca.ca_template_guid = object_guid_in;

  OPEN job_types_cur_out FOR
    SELECT UNIQUE mv.job_type
      FROM MGMT_JOB_TYPE_DISPLAY_INFO tdi,
           MGMT_JOB_TYPE_INFO ti,
           MGMT_JOB_SINGLE_TARGET_TYPES stt,
           MGMT_JOB_TYPE_MAX_VERSIONS mv
     WHERE tdi.use_default_create_ui = 1
       AND ti.editable = 1
       AND tdi.job_type_id = stt.job_type_id
       AND mv.job_type_id=tdi.job_type_id
       AND ti.job_type_id=tdi.job_type_id
       AND mv.major_version=1
       AND (stt.single_target_type = 'all' OR
            stt.single_target_type = target_type_in OR
            stt.single_target_type IN (SELECT property_value
                                         FROM MGMT_TYPE_PROPERTIES
                                        WHERE property_name = MGMT_GLOBAL.G_CLUSTER_MEMBER_TYPE_PROP
                                          AND target_type = target_type_in));

END get_object_mntr_settings;

--
-- Name: get_template_mntr_settings
--
-- Package: emd_mntr
--
-- Purpose: 
--  Get the monitoring_settings which include metric thresholds, policies, and
--  collections for the given template.
--
PROCEDURE get_template_mntr_settings(template_name_in IN VARCHAR2,
                                     target_type_in IN VARCHAR2,
                                     language_code_in IN VARCHAR2,
                                     country_code_in IN VARCHAR2,                                     
                                     has_remote_out OUT NUMBER,
                                     policy_cur_out OUT cursorType,
                                     collection_cur_out OUT cursorType,
                                     key_render_cur_out OUT cursorType,
                                     policy_ctxt_cur_out OUT cursorType,
                                     ca_multitask_cur_out OUT cursorType,
                                     ca_param_cur_out OUT cursorType,
                                     ca_cred_cur_out OUT cursorType,
                                     job_types_cur_out OUT cursorType) IS

  l_template_guid mgmt_templates.template_guid%TYPE;

BEGIN

  -- get the template guid
  BEGIN
    SELECT template_guid INTO l_template_guid
      FROM mgmt_templates
     WHERE template_name = template_name_in
       AND target_type = target_type_in;

    EXCEPTION
      WHEN NO_DATA_FOUND
      THEN
        raise MGMT_GLOBAL.template_does_not_exist;
  END;

  -- get monitoring settings
  get_object_mntr_settings(l_template_guid, 
                           MGMT_GLOBAL.G_OBJECT_TYPE_TEMPLATE, 
                           target_type_in,
                           language_code_in, 
                           country_code_in,
                           has_remote_out,
                           policy_cur_out, 
                           collection_cur_out,
                           key_render_cur_out,
                           policy_ctxt_cur_out,
                           ca_multitask_cur_out, 
                           ca_param_cur_out, 
                           ca_cred_cur_out, 
                           job_types_cur_out);

END get_template_mntr_settings;

--
-- Name: get_template_crt_mntr_settings
--
-- Package: emd_mntr
--
-- Purpose: 
--  Get the monitoring settings which include metric thresholds, policies, and
--  collections for creating a template with the given target.
--
PROCEDURE get_template_crt_mntr_settings(target_name_in IN VARCHAR2,
                                         target_type_in IN VARCHAR2,
                                         language_code_in IN VARCHAR2,
                                         country_code_in IN VARCHAR2, 
                                         has_remote_out OUT NUMBER,
                                         policy_cur_out OUT cursorType,
                                         collection_cur_out OUT cursorType,
                                         key_render_cur_out OUT cursorType,
                                         policy_ctxt_cur_out OUT cursorType,
                                         ca_multitask_cur_out OUT cursorType,
                                         ca_param_cur_out OUT cursorType,
                                         ca_cred_cur_out OUT cursorType,
                                         job_types_cur_out OUT cursorType) IS

  l_key_render_cur cursorType;

BEGIN

  -- renderable information of key columns for metrics with composite keys
  -- note that this may return duplicate rows if is_renderable is 1 in
  -- some versions and 0 in other versions
  OPEN key_render_cur_out FOR
    SELECT DISTINCT met.metric_name, met.key_order, met.is_renderable
      FROM mgmt_metrics met
     WHERE met.target_type = target_type_in
       AND met.num_keys > 1
       AND met.key_order ! = 0
     ORDER BY met.metric_name, met.key_order;

  -- get monitoring settings
  get_target_mntr_settings(target_name_in, target_type_in, 
    language_code_in, country_code_in, has_remote_out,
    policy_cur_out, collection_cur_out, l_key_render_cur, policy_ctxt_cur_out,
    ca_multitask_cur_out, ca_param_cur_out, ca_cred_cur_out, job_types_cur_out);

END get_template_crt_mntr_settings;

--
-- Name: get_template_copy_settings
--
-- Package: emd_mntr
--
-- Purpose: 
--  Get the monitoring settings which include metric thresholds, policies, and
--  collections for the given template copy.
--
PROCEDURE get_template_copy_settings(template_copy_guid_in IN VARCHAR2,
                                     target_type_in IN VARCHAR2,
                                     language_code_in IN VARCHAR2,
                                     country_code_in IN VARCHAR2,
                                     has_remote_out OUT NUMBER,
                                     policy_cur_out OUT cursorType,
                                     collection_cur_out OUT cursorType,
                                     key_render_cur_out OUT cursorType,
                                     policy_ctxt_cur_out OUT cursorType,
                                     ca_multitask_cur_out OUT cursorType,
                                     ca_param_cur_out OUT cursorType,
                                     ca_cred_cur_out OUT cursorType,
                                     job_types_cur_out OUT cursorType) IS

BEGIN

  -- get monitoring settings
  get_object_mntr_settings(HEXTORAW(template_copy_guid_in), 
                           MGMT_GLOBAL.G_OBJECT_TYPE_TEMPLATE_COPY, 
                           target_type_in, 
                           language_code_in, 
                           country_code_in,
                           has_remote_out,
                           policy_cur_out, 
                           collection_cur_out,
                           key_render_cur_out,
                           policy_ctxt_cur_out,
                           ca_multitask_cur_out, 
                           ca_param_cur_out, 
                           ca_cred_cur_out, 
                           job_types_cur_out);

END get_template_copy_settings;

--
-- Name: get_template_copy_tgt_settings
--
-- Package: emd_mntr
--
-- Purpose: 
--  Get the monitoring settings which include metric thresholds, policies, and
--  collections for the given template copy and the specified target.
--
PROCEDURE get_template_copy_tgt_settings(template_copy_guid_in IN VARCHAR2,
                                         target_type_in IN VARCHAR2,
                                         language_code_in IN VARCHAR2,
                                         country_code_in IN VARCHAR2,
                                         has_remote_out OUT NUMBER,
                                         policy_cur_out OUT cursorType,
                                         collection_cur_out OUT cursorType,
                                         key_render_cur_out OUT cursorType,
                                         policy_ctxt_cur_out OUT cursorType,
                                         ca_multitask_cur_out OUT cursorType,
                                         ca_param_cur_out OUT cursorType,
                                         ca_cred_cur_out OUT cursorType,
                                         job_types_cur_out OUT cursorType,
                                         target_guid_in IN VARCHAR2) IS

BEGIN

  -- get monitoring settings
  get_object_mntr_settings(HEXTORAW(template_copy_guid_in), 
                           MGMT_GLOBAL.G_OBJECT_TYPE_TEMPLATE_COPY, 
                           target_type_in, 
                           language_code_in, 
                           country_code_in,
                           has_remote_out,
                           policy_cur_out, 
                           collection_cur_out,
                           key_render_cur_out,
                           policy_ctxt_cur_out,
                           ca_multitask_cur_out, 
                           ca_param_cur_out, 
                           ca_cred_cur_out, 
                           job_types_cur_out,
                           HEXTORAW(target_guid_in));

END get_template_copy_tgt_settings;

--
-- Name: get_mntr_settings_copy
--
-- Package: emd_mntr
--
-- Purpose: 
--  Get the metric thresholds, policies, and collections for the given 
--  monitoring settings copy.
--
PROCEDURE get_mntr_settings_copy(mntr_settings_copy_guid_in IN VARCHAR2,
                                 target_type_in IN VARCHAR2,
                                 language_code_in IN VARCHAR2,
                                 country_code_in IN VARCHAR2,
                                 has_remote_out OUT NUMBER,
                                 policy_cur_out OUT cursorType,
                                 collection_cur_out OUT cursorType,
                                 key_render_cur_out OUT cursorType,
                                 policy_ctxt_cur_out OUT cursorType,
                                 ca_multitask_cur_out OUT cursorType,
                                 ca_param_cur_out OUT cursorType,
                                 ca_cred_cur_out OUT cursorType,
                                 job_types_cur_out OUT cursorType) IS

BEGIN

  -- get monitoring settings
  get_object_mntr_settings(HEXTORAW(mntr_settings_copy_guid_in), 
                           MGMT_GLOBAL.G_OBJECT_TYPE_MNTR_SET_COPY, 
                           target_type_in, 
                           language_code_in, 
                           country_code_in,
                           has_remote_out,
                           policy_cur_out, 
                           collection_cur_out,
                           key_render_cur_out,
                           policy_ctxt_cur_out,
                           ca_multitask_cur_out, 
                           ca_param_cur_out, 
                           ca_cred_cur_out, 
                           job_types_cur_out);

END get_mntr_settings_copy;

--
-- Name: get_target_settings
--
-- Package: emd_mntr
--
-- Purpose: 
--  Get target settings for the given target.
--
PROCEDURE get_target_settings(target_name_in IN VARCHAR2,
                              target_type_in IN VARCHAR2,
                              language_code_in IN VARCHAR2,
                              country_code_in IN VARCHAR2,
                              has_priv_out OUT NUMBER,
                              has_remote_out OUT NUMBER,
                              has_update_execution_out OUT NUMBER,
                              agent_current_status_out OUT NUMBER,
                              agent_version_out OUT VARCHAR2,
                              is_baselineable_out OUT VARCHAR2, 
                              policy_cur_out OUT cursorType,
                              collection_cur_out OUT cursorType,
                              key_render_cur_out OUT cursorType,
                              policy_ctxt_cur_out OUT cursorType,
                              ca_multitask_cur_out OUT cursorType,
                              ca_param_cur_out OUT cursorType,
                              ca_cred_cur_out OUT cursorType,
                              job_types_cur_out OUT cursorType) IS

  l_target_guid mgmt_targets.target_guid%TYPE;
  l_emd_url mgmt_targets.emd_url%TYPE;

BEGIN

  -- find the target guid and emd url
  BEGIN
    SELECT target_guid, emd_url INTO l_target_guid, l_emd_url
      FROM mgmt_targets
     WHERE target_name = target_name_in
       AND target_type = target_type_in;

    EXCEPTION
      WHEN NO_DATA_FOUND
      THEN
        raise MGMT_GLOBAL.target_does_not_exist;
  END;

  -- find the agent current status and the agent version if the emd url exists
  IF(l_emd_url IS NOT NULL)
  THEN
    BEGIN
      SELECT avail.current_status INTO agent_current_status_out
        FROM mgmt_targets tgt, mgmt_current_availability avail
       WHERE tgt.target_type = MGMT_GLOBAL.G_AGENT_TARGET_TYPE
         AND tgt.emd_url = l_emd_url
         AND avail.target_guid = tgt.target_guid;

      EXCEPTION
        WHEN NO_DATA_FOUND
        THEN
          agent_current_status_out := MGMT_GLOBAL.G_STATUS_UNKNOWN;

        WHEN TOO_MANY_ROWS
        THEN
          agent_current_status_out := MGMT_GLOBAL.G_STATUS_UNKNOWN;
    END;

    BEGIN
      SELECT prop.property_value INTO agent_version_out
        FROM mgmt_targets tgt, mgmt_target_properties prop
       WHERE tgt.target_type = MGMT_GLOBAL.G_AGENT_TARGET_TYPE
         AND tgt.emd_url = l_emd_url
         AND prop.target_guid = tgt.target_guid
         AND prop.property_name = 'Version'
         AND prop.property_type = 'INSTANCE';

      EXCEPTION
        WHEN NO_DATA_FOUND
        THEN
          agent_version_out := ' ';

        WHEN TOO_MANY_ROWS
        THEN
          agent_current_status_out := ' ';
    END;
  ELSE
    agent_current_status_out := MGMT_GLOBAL.G_STATUS_UNKNOWN;
    agent_version_out := ' ';
  END IF;

  -- check if this target instance is baselinable
  BEGIN
    SELECT MAX(p.property_value) is_baselineable
      INTO is_baselineable_out
      FROM mgmt_target_properties p
     WHERE p.target_guid = l_target_guid
       AND p.property_name = 'IsBaselineable';

    -- the target instance is not baselineable so figure out if the target type is
    IF(is_baselineable_out IS NULL)
    THEN
      SELECT MAX(p.property_value) is_baselineable
        INTO is_baselineable_out
        FROM mgmt_type_properties p
       WHERE p.target_type = target_type_in
         AND p.property_name = 'IsBaselineable';
    END IF;

    IF(is_baselineable_out IS NULL)
    THEN
      is_baselineable_out := 'false';
    END IF;
  END;

  -- check if the user has at least OPERATOR_TARGET privilege
  has_priv_out := mgmt_user.has_priv(mgmt_user.get_current_em_user(), 
    mgmt_user.OPERATOR_TARGET, target_name_in, target_type_in);

  -- check if the target has pending update executions
  has_update_execution_out := mgmt_target_update.has_running_update_execution(
    l_target_guid, MGMT_TARGET_UPDATE.TARGET_OP_MNTR_SETTINGS);

  -- get monitoring settings
  get_target_mntr_settings(target_name_in, target_type_in, 
    language_code_in, country_code_in, has_remote_out,
    policy_cur_out, collection_cur_out, key_render_cur_out, policy_ctxt_cur_out,
    ca_multitask_cur_out, ca_param_cur_out, ca_cred_cur_out, job_types_cur_out);

END get_target_settings;

--
-- Name: get_template_settings
--
-- Package: emd_mntr
--
-- Purpose: 
--  Get template settings for the given template.
--
PROCEDURE get_template_settings(template_name_in IN VARCHAR2,
                                target_type_in IN VARCHAR2,
                                language_code_in IN VARCHAR2,
                                country_code_in IN VARCHAR2,  
                                template_owner_out OUT VARCHAR2,
                                template_description_out OUT VARCHAR2,
                                is_public_out OUT NUMBER,
                                has_priv_out OUT NUMBER,
                                has_remote_out OUT NUMBER,
                                policy_cur_out OUT cursorType,
                                collection_cur_out OUT cursorType,
                                key_render_cur_out OUT cursorType,
                                policy_ctxt_cur_out OUT cursorType,
                                ca_multitask_cur_out OUT cursorType,
                                ca_param_cur_out OUT cursorType,
                                ca_cred_cur_out OUT cursorType,
                                job_types_cur_out OUT cursorType) IS
                                
  l_template_guid mgmt_templates.template_guid%TYPE;                               

BEGIN

  -- get the template's general data (only owner and description since when
  -- calling this procedure we already know the template's name and target type)
  BEGIN
    SELECT owner, description, is_public, template_guid
      INTO template_owner_out, template_description_out, is_public_out, l_template_guid
      FROM mgmt_templates
     WHERE template_name = template_name_in
       AND target_type = target_type_in;
       
     EXCEPTION
      WHEN NO_DATA_FOUND THEN
           raise_application_error(MGMT_GLOBAL.TEMPLATE_DOES_NOT_EXIST_ERR,
          'Template not found.target_type = ' || target_type_in ||
          'template_name = ' || template_name_in);  
  END;
  
  -- If there is no exception it means the current user has at least the 
  -- VIEW_TEMPLATE privilege on the template. In that case, check whether or 
  -- not the user also has the FULL_TEMPLATE privilege on this template
  has_priv_out := mgmt_user.has_priv(mgmt_user.get_current_em_user(), 
                                     mgmt_user.FULL_TEMPLATE, 
                                     l_template_guid);
  
  -- Now call get_monitoring_settings in order to get the monitoring settings
  -- of this template
  get_template_mntr_settings(template_name_in,
                             target_type_in,
                             language_code_in,
                             country_code_in,
                             has_remote_out,
                             policy_cur_out,
                             collection_cur_out,
                             key_render_cur_out,
                             policy_ctxt_cur_out,
                             ca_multitask_cur_out, 
                             ca_param_cur_out,
                             ca_cred_cur_out,
                             job_types_cur_out);

END get_template_settings;

--
-- Name: get_target_lib_mntr_settings
--
-- Package: emd_mntr
--
-- Purpose: 
--  Get the monitoring settings which include policies and collections for
--  policy library with the given target type. This is used in the case when
--  we add policies from the library to a target. The given target will be
--  used to retrieve the default collection information.
--
PROCEDURE get_target_lib_mntr_settings(target_name_in IN VARCHAR2,
                                       target_type_in IN VARCHAR2,
                                       language_code_in IN VARCHAR2,
                                       country_code_in IN VARCHAR2,
                                       has_remote_out OUT NUMBER,
                                       policy_cur_out OUT cursorType,
                                       collection_cur_out OUT cursorType,
                                       key_render_cur_out OUT cursorType,
                                       policy_ctxt_cur_out OUT cursorType,
                                       ca_multitask_cur_out OUT cursorType,
                                       ca_param_cur_out OUT cursorType,
                                       ca_cred_cur_out OUT cursorType,
                                       job_types_cur_out OUT cursorType,
                                       default_udp_repository_cur_out OUT cursorType) IS

  l_target_guid mgmt_targets.target_guid%TYPE;
  l_type_meta_ver mgmt_targets.type_meta_ver%TYPE;
  l_category_prop_1 mgmt_targets.category_prop_1%TYPE;
  l_category_prop_2 mgmt_targets.category_prop_2%TYPE;
  l_category_prop_3 mgmt_targets.category_prop_3%TYPE;
  l_category_prop_4 mgmt_targets.category_prop_4%TYPE;
  l_category_prop_5 mgmt_targets.category_prop_5%TYPE;
  l_target_type_guid mgmt_target_types.target_type_guid%TYPE;
  l_target_type_ver_guid mgmt_target_type_versions.target_type_ver_guid%TYPE;
  l_default_type_meta_ver mgmt_targets.type_meta_ver%TYPE;
  l_default_target_type_ver_guid mgmt_target_type_versions.target_type_ver_guid%TYPE; 

BEGIN

  -- get the target guid and category property columns
  BEGIN
    SELECT target_guid, type_meta_ver, category_prop_1, category_prop_2,
           category_prop_3, category_prop_4, category_prop_5
      INTO l_target_guid, l_type_meta_ver, l_category_prop_1, l_category_prop_2,
           l_category_prop_3, l_category_prop_4, l_category_prop_5
      FROM mgmt_targets
     WHERE target_name = target_name_in
       AND target_type = target_type_in;

    EXCEPTION
      WHEN NO_DATA_FOUND
      THEN
        raise MGMT_GLOBAL.target_does_not_exist;
  END;

  -- get the target type guid
  l_target_type_guid := EM_TARGET.generate_target_type_guid(target_type_in);

  -- get the target type ver guid
  l_target_type_ver_guid := EM_TARGET.generate_type_ver_guid(target_type_in, l_type_meta_ver);

  -- get the target type ver guid for the given type with the 1.0 type meta ver
  l_default_type_meta_ver := '1.0';
  l_default_target_type_ver_guid := mgmt_collection.default_object_guid(target_type_in, l_default_type_meta_ver);  
 
  -- check if we have remote metrics for this target type
    SELECT DECODE(COUNT(met.remote), 0, 0, 1) INTO has_remote_out
      FROM mgmt_metrics met
     WHERE met.target_type = target_type_in
       AND met.usage_type = MGMT_GLOBAL.G_USAGE_VIEW_COLLECT
       AND met.remote != 0
       AND met.type_meta_ver = l_type_meta_ver
       AND (met.category_prop_1 = l_category_prop_1 OR met.category_prop_1 = ' ')
       AND (met.category_prop_2 = l_category_prop_2 OR met.category_prop_2 = ' ')
       AND (met.category_prop_3 = l_category_prop_3 OR met.category_prop_3 = ' ')
       AND (met.category_prop_4 = l_category_prop_4 OR met.category_prop_4 = ' ')
       AND (met.category_prop_5 = l_category_prop_5 OR met.category_prop_5 = ' ');

  -- renderable information of key columns for metrics with composite keys
  OPEN key_render_cur_out FOR
    SELECT met.metric_name, met.key_order, met.is_renderable
      FROM mgmt_metrics met
     WHERE met.target_type = target_type_in
       AND met.num_keys > 1
       AND met.key_order ! = 0
       AND met.type_meta_ver = l_type_meta_ver
       AND (met.category_prop_1 = l_category_prop_1 OR met.category_prop_1 = ' ')
       AND (met.category_prop_2 = l_category_prop_2 OR met.category_prop_2 = ' ')
       AND (met.category_prop_3 = l_category_prop_3 OR met.category_prop_3 = ' ')
       AND (met.category_prop_4 = l_category_prop_4 OR met.category_prop_4 = ' ')
       AND (met.category_prop_5 = l_category_prop_5 OR met.category_prop_5 = ' ')
     ORDER BY met.metric_name, met.key_order;

  -- policy information
  OPEN policy_cur_out FOR
    SELECT met.metric_name,
           met.metric_label, 
           met.metric_label_nlsid,  
           met.metric_column,
           met.column_label,
           met.column_label_nlsid,
           met.metric_type,
           met.num_keys,
           met.key_column,
           met.is_repository,
           met.is_transposed,
           met.has_push,
           met.has_pull,
           met.remote,
           met.non_thresholded_alerts,
           met.keyonly_thresholds,
           p.policy_guid,
           p.policy_name,
           MGMT_MESSAGE.GET_MESSAGE(p.policy_label_nlsid, 'POLICY',
             language_code_in, country_code_in, p.policy_name) as policy_name_display,
           p.metric_guid,
           p.policy_type,
           p.policy_label_nlsid,
           MGMT_MESSAGE.GET_MESSAGE(p.description_nlsid, 'POLICY',
             language_code_in, country_code_in, p.description) as description,
           p.violation_level,
           p.condition_type,
           p.condition,
           p.condition_operator,
           p.message,
           p.message_nlsid,
           p.clear_message,
           p.clear_message_nlsid,
           p.detailed_url_link,
           p.owner,
           pc.category_name as category,
           MGMT_MESSAGE.GET_MESSAGE(pc.category_name_nlsid, 'CATEGORY', 
             language_code_in, country_code_in, pc.category_name) as category_display, 
           pa.coll_name,
           pa.is_enabled,
           pa.add_or_delete,
           pac.key_value,
           pac.key_operator,
           pac.eval_order,
           pac.is_exception,
           pac.is_push,
           pac.has_active_baseline,
           pac.prevent_override,
           pac.crit_action_job_id,
           pac.warn_action_job_id,
           pac.info_action_job_id,
           TRIM(pac.fixit_job) as fixit_job,
           pac.simultaneous_actions,
           pac.importance,
           pac.num_occurrences,
           pacp.param_name,
           MGMT_MESSAGE.GET_MESSAGE(pp.param_name_nlsid, 'POLICY',
             language_code_in, country_code_in, pp.param_name) as param_name_display, 
           pp.param_type,
           pacp.crit_threshold,
           pacp.warn_threshold,
           pacp.info_threshold,
           pacp.crit_threshold as default_crit_threshold,
           pacp.warn_threshold as default_warn_threshold,
           pacp.info_threshold as default_info_threshold,
           compkeys.key_part1_value,
           compkeys.key_part2_value,
           compkeys.key_part3_value,
           compkeys.key_part4_value,
           compkeys.key_part5_value,
           am.agent_side_metric_guid,
           am.agent_side_metric_name,
           am.agent_side_metric_label,
           am.agent_side_metric_label_nlsid             
      FROM mgmt_metrics met,
           mgmt_policies p, 
           mgmt_category_map pcm, mgmt_categories pc,
           mgmt_policy_assoc pa,
           mgmt_policy_assoc_cfg pac, mgmt_policy_assoc_cfg_params pacp,
           mgmt_policy_parameters pp,
           (SELECT composite_key, key_part1_value, key_part2_value,
                   key_part3_value, key_part4_value, key_part5_value
              FROM mgmt_metrics_composite_keys 
             WHERE target_guid = l_target_type_guid) compkeys,
           (SELECT p.policy_guid,
                   m.metric_guid as agent_side_metric_guid,
                   m.metric_name as agent_side_metric_name,
                   m.metric_label as agent_side_metric_label,
                   m.metric_label_nlsid as agent_side_metric_label_nlsid
              FROM mgmt_policies p, mgmt_snapshot_metric_map s,
                   mgmt_metrics m, mgmt_collection_metric_tasks cmt
             WHERE p.target_type = target_type_in
               AND p.policy_type = MGMT_GLOBAL.G_TYPE_POLICY
               AND s.snapshot_target_type = target_type_in
               AND s.metric_guid = p.metric_guid
               AND m.target_type = target_type_in
               AND m.type_meta_ver = l_type_meta_ver
               AND (m.category_prop_1 = l_category_prop_1 OR m.category_prop_1 = ' ')
               AND (m.category_prop_2 = l_category_prop_2 OR m.category_prop_2 = ' ')
               AND (m.category_prop_3 = l_category_prop_3 OR m.category_prop_3 = ' ')
               AND (m.category_prop_4 = l_category_prop_4 OR m.category_prop_4 = ' ')
               AND (m.category_prop_5 = l_category_prop_5 OR m.category_prop_5 = ' ')
               AND cmt.target_guid = l_target_guid
               AND cmt.coll_name = s.snapshot_name
               AND cmt.metric_guid = m.metric_guid) am
     WHERE met.target_type = target_type_in
       AND met.type_meta_ver = l_type_meta_ver
       AND (met.category_prop_1 = l_category_prop_1 OR met.category_prop_1 = ' ')
       AND (met.category_prop_2 = l_category_prop_2 OR met.category_prop_2 = ' ')
       AND (met.category_prop_3 = l_category_prop_3 OR met.category_prop_3 = ' ')
       AND (met.category_prop_4 = l_category_prop_4 OR met.category_prop_4 = ' ')
       AND (met.category_prop_5 = l_category_prop_5 OR met.category_prop_5 = ' ')
       AND p.metric_guid = met.metric_guid
       AND p.policy_type = MGMT_GLOBAL.G_TYPE_POLICY
       AND p.target_type = target_type_in
       AND p.policy_guid = pcm.object_guid (+)
       AND MGMT_GLOBAL.G_CATEGORY_CLASS_FUNCTIONAL = pcm.class_name (+)
       AND pcm.category_name = pc.category_name (+)      
       AND pa.object_guid = l_target_type_guid
       AND pa.policy_guid = p.policy_guid
    -- AND pa.coll_name = ?
       AND pa.object_type = MGMT_GLOBAL.G_OBJECT_TYPE_DEFAULT
       AND pac.object_guid  = l_target_type_guid
       AND pac.policy_guid = pa.policy_guid
       AND pac.coll_name = pa.coll_name
       AND pac.object_guid = pacp.object_guid (+)  
       AND pac.policy_guid = pacp.policy_guid (+)
       AND pac.coll_name = pacp.coll_name (+)
       AND pac.key_value = pacp.key_value (+)
       AND pac.key_operator = pacp.key_operator (+)  
       AND pacp.policy_guid = pp.policy_guid (+)
       AND pacp.param_name = pp.param_name (+) 
       AND pac.key_value = compkeys.composite_key (+)
       AND p.policy_guid = am.policy_guid(+)
     ORDER BY policy_type, policy_guid, eval_order, key_value;

  -- collection information
  OPEN collection_cur_out FOR
    SELECT met.metric_guid,
           met.metric_name,
           met.metric_label,
           met.metric_label_nlsid,
           met.metric_type,
           met.is_repository,
           met.is_transposed,
           met.has_push,
           met.has_pull,
           met.remote,
           met.non_thresholded_alerts,
           c.coll_name,
           c.is_enabled,
           c.schedule_ex,
           c.store_metric,
           c.upload_frequency,
           c.frequency_code,
           c.start_time,
           c.end_time,
           c.execution_hours,
           c.execution_minutes,
           c.interval,
           c.months,
           c.days,
           NVL(ci.is_required, 0) AS is_required,
           cip.property_name,
           cip.property_value,
           NULL AS credential_set_name,
           NULL AS credential_set_column,
           NULL AS credential_value
      FROM mgmt_metrics met, mgmt_collections c,
           mgmt_collection_metric_tasks cmt,
           (SELECT coll_name, is_required
              FROM mgmt_coll_items
             WHERE target_type = target_type_in
               AND type_meta_ver = l_type_meta_ver
               AND (category_prop_1 = l_category_prop_1 OR category_prop_1 = ' ')
               AND (category_prop_2 = l_category_prop_2 OR category_prop_2 = ' ')
               AND (category_prop_3 = l_category_prop_3 OR category_prop_3 = ' ')
               AND (category_prop_4 = l_category_prop_4 OR category_prop_4 = ' ')
               AND (category_prop_5 = l_category_prop_5 OR category_prop_5 = ' ') ) ci,
           (SELECT metric_guid, coll_name, property_name, property_value
              FROM mgmt_coll_item_properties
             WHERE object_guid = l_target_guid
               AND object_type = MGMT_GLOBAL.G_OBJECT_TYPE_TARGET) cip
     WHERE met.target_type = target_type_in
       AND (met.metric_type = MGMT_GLOBAL.G_METRIC_TYPE_TABLE OR 
            met.metric_type = MGMT_GLOBAL.G_METRIC_TYPE_REPOS_TABLE OR
            met.metric_type = MGMT_GLOBAL.G_METRIC_TYPE_RAW OR
            met.metric_type = MGMT_GLOBAL.G_METRIC_TYPE_EXTERNAL)
       AND met.type_meta_ver = l_type_meta_ver
       AND (met.category_prop_1 = l_category_prop_1 OR met.category_prop_1 = ' ')
       AND (met.category_prop_2 = l_category_prop_2 OR met.category_prop_2 = ' ')
       AND (met.category_prop_3 = l_category_prop_3 OR met.category_prop_3 = ' ')
       AND (met.category_prop_4 = l_category_prop_4 OR met.category_prop_4 = ' ')
       AND (met.category_prop_5 = l_category_prop_5 OR met.category_prop_5 = ' ')
       AND c.object_guid = l_target_guid
       AND c.object_type = MGMT_GLOBAL.G_OBJECT_TYPE_TARGET
       AND c.coll_name = ci.coll_name (+)
       AND cmt.target_guid = l_target_guid
       AND cmt.coll_name = c.coll_name
       AND cmt.metric_guid = met.metric_guid
       AND cmt.metric_guid = cip.metric_guid (+)
       AND cmt.coll_name = cip.coll_name (+)
     ORDER BY met.metric_guid;

    -- collection information for repository metrics that are behind UDPs
    OPEN default_udp_repository_cur_out FOR
      SELECT met.metric_guid,
             met.metric_name,
             met.metric_label,
             met.metric_label_nlsid,
             met.metric_type,
             met.is_repository,
             met.is_transposed,
             met.has_push,
             met.has_pull,
             met.remote,
             met.non_thresholded_alerts,
             c.coll_name,
             c.is_enabled,
             c.schedule_ex,
             c.store_metric,
             c.upload_frequency,
             c.frequency_code,
             c.start_time,
             c.end_time,
             c.execution_hours,
             c.execution_minutes,
             c.interval,
             c.months,
             c.days,
             NULL AS is_required,
             cip.property_name,
             cip.property_value,
             NULL AS credential_set_name,
             NULL AS credential_set_column,
             NULL AS credential_value
      FROM (SELECT DISTINCT metric_guid, metric_name, metric_label,
                       metric_label_nlsid, metric_type,
                       is_repository, is_transposed, has_push, has_pull, remote,
                       non_thresholded_alerts
                  FROM mgmt_metrics 
                 WHERE target_type = target_type_in
                   AND is_repository = MGMT_GLOBAL.G_TRUE
                   AND (metric_type = MGMT_GLOBAL.G_METRIC_TYPE_TABLE OR 
                        metric_type = MGMT_GLOBAL.G_METRIC_TYPE_REPOS_TABLE OR
                        metric_type = MGMT_GLOBAL.G_METRIC_TYPE_RAW OR
                        metric_type = MGMT_GLOBAL.G_METRIC_TYPE_EXTERNAL) ) met,
               mgmt_collections c,
               mgmt_coll_item_metrics cim,
               (SELECT metric_guid, coll_name, property_name, property_value
                  FROM mgmt_coll_item_properties
                 WHERE object_guid = l_default_target_type_ver_guid
                   AND object_type = MGMT_GLOBAL.G_OBJECT_TYPE_DEFAULT) cip
         WHERE c.object_guid = l_default_target_type_ver_guid
           AND c.object_type = MGMT_GLOBAL.G_OBJECT_TYPE_DEFAULT
           AND cim.target_type = target_type_in
           AND cim.type_meta_ver = l_default_type_meta_ver
           AND cim.coll_name = c.coll_name
           AND cim.metric_guid = met.metric_guid
           AND cim.metric_guid = cip.metric_guid (+)
           AND cim.coll_name = cip.coll_name (+)
       ORDER BY met.metric_guid;     

  -- violation context definitions
  OPEN policy_ctxt_cur_out FOR
    SELECT p.policy_guid,
           met.is_transposed,
           pa.coll_name,
           pvcd.column_name
      FROM mgmt_metrics met,
           mgmt_policies p, 
           mgmt_policy_assoc pa,
           mgmt_policy_viol_ctxt_def pvcd
     WHERE pa.object_guid = l_target_guid
       AND pa.policy_guid = p.policy_guid
       AND pvcd.policy_guid = p.policy_guid
       AND p.metric_guid = met.metric_guid
       AND met.type_meta_ver = l_type_meta_ver
       AND (met.category_prop_1 = l_category_prop_1 OR met.category_prop_1 = ' ')
       AND (met.category_prop_2 = l_category_prop_2 OR met.category_prop_2 = ' ')
       AND (met.category_prop_3 = l_category_prop_3 OR met.category_prop_3 = ' ')
       AND (met.category_prop_4 = l_category_prop_4 OR met.category_prop_4 = ' ')
       AND (met.category_prop_5 = l_category_prop_5 OR met.category_prop_5 = ' ')
     ORDER BY pvcd.policy_guid, pvcd.column_position;

  -- corrective action information
  OPEN ca_multitask_cur_out FOR
    SELECT ca.job_id,
           ca.ca_reference_count
      FROM MGMT_CORRECTIVE_ACTION ca,
           MGMT_JOB j,
           MGMT_JOB_TYPE_INFO jti
     WHERE j.job_id = ca.job_id
       AND j.job_type = jti.job_type
       AND jti.job_type_category = MGMT_JOB_ENGINE.JOBTYPE_CATEGORY_HIDDEN
       AND ca.ca_scope = MGMT_CA.CA_SCOPE_TARGET_TYPE
       AND j.target_type = target_type_in;

  OPEN ca_param_cur_out FOR
    SELECT ca.job_id,
           ca.ca_reference_count, 
           j.job_name,
           j.job_description,
           j.job_type,
           j.job_owner,
           jp.parameter_name,
           jp.parameter_type,
           MGMT_JOB_ENGINE.decrypt_scalar(jp.encrypted, jp.scalar_value) scalar_value,
           MGMT_JOB_ENGINE.decrypt_vector(jp.encrypted, jp.vector_value) vector_value
      FROM MGMT_CORRECTIVE_ACTION ca,
           MGMT_JOB j,
           MGMT_JOB_TYPE_INFO jti,
           MGMT_JOB_PARAMETER jp
     WHERE j.job_id = ca.job_id
       AND j.job_type = jti.job_type
       AND jti.job_type_category != MGMT_JOB_ENGINE.JOBTYPE_CATEGORY_HIDDEN
       AND j.job_id = jp.job_id (+)
       AND jp.execution_id = MGMT_JOB_ENGINE.NO_EXECUTION
       AND ca.ca_scope = MGMT_CA.CA_SCOPE_TARGET_TYPE
       AND j.target_type = target_type_in;

  OPEN ca_cred_cur_out FOR
    SELECT ca.job_id,
           jc.credential_guid, 
           jc.container_location,
           jc.credential_set_name,
           jc.user_name,
           c2.credential_set_column, 
           decode(c2.credential_value, null, null, 
                  decrypt(c2.credential_value)) credential_value
      FROM MGMT_CORRECTIVE_ACTION ca,
           MGMT_JOB j,
           MGMT_JOB_TYPE_INFO jti,
           MGMT_JOB_CREDENTIALS jc,
           MGMT_CREDENTIALS2 c2
     WHERE j.job_id = ca.job_id
       AND j.job_type = jti.job_type
       AND jti.job_type_category != MGMT_JOB_ENGINE.JOBTYPE_CATEGORY_HIDDEN
       AND ca.job_id = jc.job_id
       AND jc.credential_guid = c2.credential_guid
       AND ca.ca_scope = MGMT_CA.CA_SCOPE_TARGET_TYPE
       AND j.target_type = target_type_in;

  OPEN job_types_cur_out FOR
    SELECT UNIQUE mv.job_type
      FROM MGMT_JOB_TYPE_DISPLAY_INFO tdi,
           MGMT_JOB_TYPE_INFO ti,
           MGMT_JOB_SINGLE_TARGET_TYPES stt,
           MGMT_JOB_TYPE_MAX_VERSIONS mv
     WHERE tdi.use_default_create_ui = 1
       AND ti.editable = 1
       AND tdi.job_type_id = stt.job_type_id
       AND mv.job_type_id=tdi.job_type_id
       AND ti.job_type_id=tdi.job_type_id
       AND mv.major_version=1
       AND (stt.single_target_type = 'all' OR
            stt.single_target_type = target_type_in OR
            stt.single_target_type IN (SELECT property_value
                                         FROM MGMT_TYPE_PROPERTIES
                                        WHERE property_name = MGMT_GLOBAL.G_CLUSTER_MEMBER_TYPE_PROP
                                          AND target_type = target_type_in));

END get_target_lib_mntr_settings;

--
-- Name: get_template_lib_mntr_settings
--
-- Package: emd_mntr
--
-- Purpose: 
--  Get the monitoring settings which include policies and collections for
--  policy library with the given target type. This is used in the case when
--  we add policies from the library to a template.
--
PROCEDURE get_template_lib_mntr_settings(template_name_in IN VARCHAR2,
                                         target_type_in IN VARCHAR2,
                                         language_code_in IN VARCHAR2,
                                         country_code_in IN VARCHAR2,
                                         has_remote_out OUT NUMBER,
                                         policy_cur_out OUT cursorType,
                                         collection_cur_out OUT cursorType,
                                         key_render_cur_out OUT cursorType,
                                         policy_ctxt_cur_out OUT cursorType,
                                         ca_multitask_cur_out OUT cursorType,
                                         ca_param_cur_out OUT cursorType,
                                         ca_cred_cur_out OUT cursorType,
                                         job_types_cur_out OUT cursorType,
                                         default_udp_repository_cur_out OUT cursorType) IS

  l_max_type_meta_ver mgmt_targets.type_meta_ver%TYPE;
  l_target_type_guid mgmt_target_types.target_type_guid%TYPE;
  l_target_type_ver_guid mgmt_target_type_versions.target_type_ver_guid%TYPE;

  l_default_type_meta_ver mgmt_targets.type_meta_ver%TYPE;
  l_default_target_type_ver_guid mgmt_target_type_versions.target_type_ver_guid%TYPE;  

BEGIN

  -- get the target type ver guid for the given type with the max type meta ver
  BEGIN
    SELECT v.target_type_ver_guid, t.max_type_meta_ver, t.target_type_guid
      INTO l_target_type_ver_guid, l_max_type_meta_ver, l_target_type_guid
      FROM mgmt_target_types t, mgmt_target_type_versions v
     WHERE t.target_type = target_type_in
       AND v.target_type = target_type_in
       AND v.type_meta_ver = t.max_type_meta_ver;

    EXCEPTION
      WHEN NO_DATA_FOUND
      THEN
        raise;
  END;

  -- get the target type ver guid for the given type with the 1.0 type meta ver
  l_default_type_meta_ver := '1.0';
  l_default_target_type_ver_guid := mgmt_collection.default_object_guid(target_type_in, l_default_type_meta_ver);

  -- check if we have remote metrics for this target type
    SELECT DECODE(COUNT(met.remote), 0, 0, 1) INTO has_remote_out
      FROM mgmt_metrics met
     WHERE met.target_type = target_type_in
       AND met.usage_type = MGMT_GLOBAL.G_USAGE_VIEW_COLLECT
       AND met.remote != 0;

  -- renderable information of key columns for metrics with composite keys
  -- note that this may return duplicate rows if is_renderable is 1 in
  -- some versions and 0 in other versions
  OPEN key_render_cur_out FOR
    SELECT DISTINCT met.metric_name, met.key_order, met.is_renderable
      FROM mgmt_metrics met
     WHERE met.target_type = target_type_in
       AND met.num_keys > 1
       AND met.key_order ! = 0
     ORDER BY met.metric_name, met.key_order;

  -- policy information
  OPEN policy_cur_out FOR
    SELECT met.metric_name,
           met.metric_label, 
           met.metric_label_nlsid,    
           met.metric_column,
           met.column_label,
           met.column_label_nlsid,
           met.metric_type,
           met.num_keys,
           met.key_column,
           met.is_repository,
           met.is_transposed,
           met.has_push,
           met.has_pull,
           met.remote,
           met.non_thresholded_alerts,
           met.keyonly_thresholds,
           p.policy_guid,
           p.policy_name,
           MGMT_MESSAGE.GET_MESSAGE(p.policy_label_nlsid, 'POLICY',
             language_code_in, country_code_in, p.policy_name) as policy_name_display,
           p.metric_guid,
           p.policy_type,
           p.policy_label_nlsid,
           MGMT_MESSAGE.GET_MESSAGE(p.description_nlsid, 'POLICY',
             language_code_in, country_code_in, p.description) as description,
           p.violation_level,
           p.condition_type,
           p.condition,
           p.condition_operator,
           p.message,
           p.message_nlsid,
           p.clear_message,
           p.clear_message_nlsid,
           p.detailed_url_link,
           p.owner,
           pc.category_name as category,
           MGMT_MESSAGE.GET_MESSAGE(pc.category_name_nlsid, 'CATEGORY', 
             language_code_in, country_code_in, pc.category_name) as category_display, 
           pa.coll_name,
           pa.is_enabled,
           pa.add_or_delete,
           pac.key_value,
           pac.key_operator,
           pac.eval_order,
           pac.is_exception,
           pac.is_push,
           pac.has_active_baseline,
           pac.prevent_override,
           pac.crit_action_job_id,
           pac.warn_action_job_id,
           pac.info_action_job_id,
           TRIM(pac.fixit_job) as fixit_job,
           pac.simultaneous_actions,
           pac.importance,
           pac.num_occurrences,
           pacp.param_name,
           MGMT_MESSAGE.GET_MESSAGE(pp.param_name_nlsid, 'POLICY',
             language_code_in, country_code_in, pp.param_name) as param_name_display, 
           pp.param_type,
           pacp.crit_threshold,
           pacp.warn_threshold,
           pacp.info_threshold,
           pacp.crit_threshold as default_crit_threshold,
           pacp.warn_threshold as default_warn_threshold,
           pacp.info_threshold as default_info_threshold,
           compkeys.key_part1_value,
           compkeys.key_part2_value,
           compkeys.key_part3_value,
           compkeys.key_part4_value,
           compkeys.key_part5_value,
           am.agent_side_metric_guid,
           am.agent_side_metric_name,
           am.agent_side_metric_label,
           am.agent_side_metric_label_nlsid              
      FROM (SELECT DISTINCT metric_guid, metric_name, metric_label, metric_label_nlsid, 
                   metric_column, column_label, column_label_nlsid, metric_type, 
                   num_keys, key_column, is_repository, is_transposed,
                   has_push, has_pull, remote, non_thresholded_alerts, keyonly_thresholds
              FROM mgmt_metrics 
             WHERE target_type = target_type_in) met,
           mgmt_policies p, 
           mgmt_category_map pcm, mgmt_categories pc,
           mgmt_policy_assoc pa,
           mgmt_policy_assoc_cfg pac, mgmt_policy_assoc_cfg_params pacp,
           mgmt_policy_parameters pp,
           (SELECT DISTINCT composite_key, key_part1_value, key_part2_value,
                   key_part3_value, key_part4_value, key_part5_value
              FROM mgmt_metrics_composite_keys) compkeys,
           (SELECT DISTINCT p.policy_guid,
                   m.metric_guid as agent_side_metric_guid,
                   m.metric_name as agent_side_metric_name,
                   m.metric_label as agent_side_metric_label,
                   m.metric_label_nlsid as agent_side_metric_label_nlsid
              FROM mgmt_policies p, mgmt_snapshot_metric_map s,
                   mgmt_metrics m, mgmt_coll_item_metrics cim
             WHERE p.target_type = target_type_in
               AND p.policy_type = MGMT_GLOBAL.G_TYPE_POLICY
               AND s.snapshot_target_type = target_type_in
               AND s.metric_guid = p.metric_guid
               AND m.target_type = target_type_in
               AND cim.target_type = target_type_in
               AND cim.coll_name = s.snapshot_name
               AND cim.metric_guid = m.metric_guid) am
     WHERE p.metric_guid = met.metric_guid 
       AND p.policy_type = MGMT_GLOBAL.G_TYPE_POLICY
       AND p.target_type = target_type_in
       AND p.policy_guid = pcm.object_guid (+)
       AND MGMT_GLOBAL.G_CATEGORY_CLASS_FUNCTIONAL = pcm.class_name (+)
       AND pcm.category_name = pc.category_name (+)      
       AND pa.object_guid = l_target_type_guid
       AND pa.policy_guid = p.policy_guid
    -- AND pa.coll_name = ?
       AND pa.object_type = MGMT_GLOBAL.G_OBJECT_TYPE_DEFAULT
       AND pac.object_guid  = l_target_type_guid
       AND pac.policy_guid = pa.policy_guid
       AND pac.coll_name = pa.coll_name      
       AND pac.object_guid = pacp.object_guid (+)  
       AND pac.policy_guid = pacp.policy_guid (+)
       AND pac.coll_name = pacp.coll_name (+)
       AND pac.key_value = pacp.key_value (+)
       AND pac.key_operator = pacp.key_operator (+)  
       AND pacp.policy_guid = pp.policy_guid (+)
       AND pacp.param_name = pp.param_name (+)
       AND pac.key_value = compkeys.composite_key (+)
       AND p.policy_guid = am.policy_guid(+)
     ORDER BY policy_type, policy_guid, eval_order, key_value;

  -- collection information
  OPEN collection_cur_out FOR
    SELECT met.metric_guid,
           met.metric_name,
           met.metric_label,
           met.metric_label_nlsid,
           met.metric_type,
           met.is_repository,
           met.is_transposed,
           met.has_push,
           met.has_pull,
           met.remote,
           met.non_thresholded_alerts,
           c.coll_name,
           c.is_enabled,
           c.schedule_ex,
           c.store_metric,
           c.upload_frequency,
           c.frequency_code,
           c.start_time,
           c.end_time,
           c.execution_hours,
           c.execution_minutes,
           c.interval,
           c.months,
           c.days,
           NULL AS is_required,
           cip.property_name,
           cip.property_value,
           NULL AS credential_set_name,
           NULL AS credential_set_column,
           NULL AS credential_value
      FROM (SELECT DISTINCT metric_guid, metric_name, metric_label,
                   metric_label_nlsid, metric_type,
                   is_repository, is_transposed, has_push, has_pull, remote,
                   non_thresholded_alerts
              FROM mgmt_metrics 
             WHERE target_type = target_type_in
               AND (metric_type = MGMT_GLOBAL.G_METRIC_TYPE_TABLE OR 
                    metric_type = MGMT_GLOBAL.G_METRIC_TYPE_REPOS_TABLE OR
                    metric_type = MGMT_GLOBAL.G_METRIC_TYPE_RAW OR
                    metric_type = MGMT_GLOBAL.G_METRIC_TYPE_EXTERNAL) ) met,
           mgmt_collections c,
           mgmt_coll_item_metrics cim,
           (SELECT metric_guid, coll_name, property_name, property_value
              FROM mgmt_coll_item_properties
             WHERE object_guid = l_target_type_ver_guid
               AND object_type = MGMT_GLOBAL.G_OBJECT_TYPE_DEFAULT) cip
     WHERE c.object_guid = l_target_type_ver_guid
       AND c.object_type = MGMT_GLOBAL.G_OBJECT_TYPE_DEFAULT
       AND cim.target_type = target_type_in
       AND cim.type_meta_ver = l_max_type_meta_ver
         AND cim.coll_name = c.coll_name
         AND cim.metric_guid = met.metric_guid
         AND cim.metric_guid = cip.metric_guid (+)
         AND cim.coll_name = cip.coll_name (+)
      ORDER BY met.metric_guid;       
       
    -- collection information for repository metrics that are behind UDPs
    OPEN default_udp_repository_cur_out FOR
      SELECT met.metric_guid,
             met.metric_name,
             met.metric_label,
             met.metric_label_nlsid,
             met.metric_type,
             met.is_repository,
             met.is_transposed,
             met.has_push,
             met.has_pull,
             met.remote,
             met.non_thresholded_alerts,
             c.coll_name,
             c.is_enabled,
             c.schedule_ex,
             c.store_metric,
             c.upload_frequency,
             c.frequency_code,
             c.start_time,
             c.end_time,
             c.execution_hours,
             c.execution_minutes,
             c.interval,
             c.months,
             c.days,
             NULL AS is_required,
             cip.property_name,
             cip.property_value,
             NULL AS credential_set_name,
             NULL AS credential_set_column,
             NULL AS credential_value           
        FROM (SELECT DISTINCT metric_guid, metric_name, metric_label,
                     metric_label_nlsid, metric_type,
                     is_repository, is_transposed, has_push, has_pull, remote,
                     non_thresholded_alerts
                FROM mgmt_metrics 
               WHERE target_type = target_type_in
                 AND is_repository = MGMT_GLOBAL.G_TRUE               
                 AND (metric_type = MGMT_GLOBAL.G_METRIC_TYPE_TABLE OR 
                      metric_type = MGMT_GLOBAL.G_METRIC_TYPE_REPOS_TABLE OR
                      metric_type = MGMT_GLOBAL.G_METRIC_TYPE_RAW OR
                      metric_type = MGMT_GLOBAL.G_METRIC_TYPE_EXTERNAL) ) met,
             mgmt_collections c,
             mgmt_coll_item_metrics cim,
             (SELECT metric_guid, coll_name, property_name, property_value
                FROM mgmt_coll_item_properties
               WHERE object_guid = l_default_target_type_ver_guid
                 AND object_type = MGMT_GLOBAL.G_OBJECT_TYPE_DEFAULT) cip
       WHERE c.object_guid = l_default_target_type_ver_guid
         AND c.object_type = MGMT_GLOBAL.G_OBJECT_TYPE_DEFAULT
         AND cim.target_type = target_type_in
         AND cim.type_meta_ver = l_default_type_meta_ver
       AND cim.coll_name = c.coll_name
       AND cim.metric_guid = met.metric_guid
       AND cim.metric_guid = cip.metric_guid (+)
       AND cim.coll_name = cip.coll_name (+)
     ORDER BY met.metric_guid;

  -- violation context definitions
  OPEN policy_ctxt_cur_out FOR
    SELECT p.policy_guid,
           met.is_transposed,
           pa.coll_name,
           pvcd.column_name
      FROM mgmt_metrics met,
           mgmt_policies p, 
           mgmt_policy_assoc pa,
           mgmt_policy_viol_ctxt_def pvcd
     WHERE pa.object_guid = l_target_type_guid
       AND pa.policy_guid = p.policy_guid
       AND pvcd.policy_guid = p.policy_guid
       AND p.metric_guid = met.metric_guid
     ORDER BY pvcd.policy_guid, pvcd.column_position;

  -- corrective action information
  OPEN ca_multitask_cur_out FOR
    SELECT ca.job_id,
           ca.ca_reference_count
      FROM MGMT_CORRECTIVE_ACTION ca,
           MGMT_JOB j,
           MGMT_JOB_TYPE_INFO jti
     WHERE j.job_id = ca.job_id
       AND j.job_type = jti.job_type
       AND jti.job_type_category = MGMT_JOB_ENGINE.JOBTYPE_CATEGORY_HIDDEN
       AND ca.ca_scope = MGMT_CA.CA_SCOPE_TARGET_TYPE
       AND j.target_type = target_type_in;

  OPEN ca_param_cur_out FOR
    SELECT ca.job_id,
           ca.ca_reference_count,
           j.job_name,
           j.job_description,
           j.job_type,
           j.job_owner,
           jp.parameter_name,
           jp.parameter_type,
           MGMT_JOB_ENGINE.decrypt_scalar(jp.encrypted, jp.scalar_value) scalar_value,
           MGMT_JOB_ENGINE.decrypt_vector(jp.encrypted, jp.vector_value) vector_value
      FROM MGMT_CORRECTIVE_ACTION ca,
           MGMT_JOB j,
           MGMT_JOB_TYPE_INFO jti,
           MGMT_JOB_PARAMETER jp
     WHERE j.job_id = ca.job_id
       AND j.job_type = jti.job_type
       AND jti.job_type_category != MGMT_JOB_ENGINE.JOBTYPE_CATEGORY_HIDDEN
       AND j.job_id = jp.job_id (+)
       AND jp.execution_id = MGMT_JOB_ENGINE.NO_EXECUTION
       AND ca.ca_scope = MGMT_CA.CA_SCOPE_TARGET_TYPE
       AND j.target_type = target_type_in;

  OPEN ca_cred_cur_out FOR
    SELECT ca.job_id,
           jc.credential_guid, 
           jc.container_location,
           jc.credential_set_name,
           jc.user_name,
           c2.credential_set_column, 
           decode(c2.credential_value, null, null, 
                  decrypt(c2.credential_value)) credential_value
      FROM MGMT_CORRECTIVE_ACTION ca,
           MGMT_JOB j,
           MGMT_JOB_TYPE_INFO jti,
           MGMT_JOB_CREDENTIALS jc,
           MGMT_CREDENTIALS2 c2
     WHERE j.job_id = ca.job_id
       AND j.job_type = jti.job_type
       AND jti.job_type_category != MGMT_JOB_ENGINE.JOBTYPE_CATEGORY_HIDDEN
       AND ca.job_id = jc.job_id
       AND jc.credential_guid = c2.credential_guid
       AND ca.ca_scope = MGMT_CA.CA_SCOPE_TARGET_TYPE
       AND j.target_type = target_type_in;

  OPEN job_types_cur_out FOR
    SELECT UNIQUE mv.job_type
      FROM MGMT_JOB_TYPE_DISPLAY_INFO tdi,
           MGMT_JOB_TYPE_INFO ti,
           MGMT_JOB_SINGLE_TARGET_TYPES stt,
           MGMT_JOB_TYPE_MAX_VERSIONS mv
     WHERE tdi.use_default_create_ui = 1
       AND ti.editable = 1
       AND tdi.job_type_id = stt.job_type_id
       AND mv.job_type_id=tdi.job_type_id
       AND ti.job_type_id=tdi.job_type_id
       AND mv.major_version=1
       AND (stt.single_target_type = 'all' OR
            stt.single_target_type = target_type_in OR
            stt.single_target_type IN (SELECT property_value
                                         FROM MGMT_TYPE_PROPERTIES
                                        WHERE property_name = MGMT_GLOBAL.G_CLUSTER_MEMBER_TYPE_PROP
                                          AND target_type = target_type_in));

END get_template_lib_mntr_settings;

--
-- Name: save_target_settings
--
-- Package: emd_mntr
--
-- Purpose: 
--  Save target settings for the given target.
--
PROCEDURE save_target_settings(target_name_in IN VARCHAR2,
                               target_type_in IN VARCHAR2,
                               metric_list_in IN MGMT_MNTR_METRIC_ARRAY,
                               policy_list_in IN MGMT_MNTR_POLICY_ARRAY,
                               collection_list_in IN MGMT_MNTR_COLLECTION_ARRAY,
                               emd_url_out OUT VARCHAR2) IS

  l_target_guid mgmt_targets.target_guid%TYPE;

BEGIN

  -- get the target guid and the emd URL
  BEGIN
    SELECT target_guid, emd_url INTO l_target_guid, emd_url_out
      FROM mgmt_targets
     WHERE target_name = target_name_in
       AND target_type = target_type_in;

    EXCEPTION
      WHEN NO_DATA_FOUND
      THEN
        raise MGMT_GLOBAL.target_does_not_exist;
  END;

  -- stop pending update executions
  mgmt_target_update.stop_propagation_execution(l_target_guid,
    MGMT_TARGET_UPDATE.TARGET_OP_MNTR_SETTINGS);

  -- save monitoring settings
  BEGIN
    mgmt_monitoring.save_settings(target_type_in, target_name_in,
      metric_list_in, policy_list_in, collection_list_in);
  EXCEPTION
      WHEN MGMT_GLOBAL.metric_settings_lock_busy THEN
         raise_application_error(MGMT_GLOBAL.METRIC_SETTINGS_LOCK_BUSY_ERR,
             'Update operation failed due to concurrent updates of this target''s settings ' ||
             'by another administrator or by Enterprise Manager''s background operations.  ' ||
             'Click ''OK'' to retry.');
  END;

END save_target_settings;

--
-- Name: get_target_collection_info
--
-- Package: emd_mntr
--
-- Purpose: 
--  Get the information of all metrics (and metric columns) collected 
--  in the given collection for the given target, and all policies 
--  defined on these metrics for this target.
--
PROCEDURE get_target_collection_info(target_name_in IN VARCHAR2,
                                     target_type_in IN VARCHAR2,
                                     coll_name_in IN VARCHAR2,
                                     language_code_in IN VARCHAR2,
                                     country_code_in IN VARCHAR2,
                                     metric_cur_out OUT cursorType,
                                     policy_cur_out OUT cursorType) IS

  l_target_guid mgmt_targets.target_guid%TYPE;
  l_type_meta_ver mgmt_targets.type_meta_ver%TYPE;
  l_category_prop_1 mgmt_targets.category_prop_1%TYPE;
  l_category_prop_2 mgmt_targets.category_prop_2%TYPE;
  l_category_prop_3 mgmt_targets.category_prop_3%TYPE;
  l_category_prop_4 mgmt_targets.category_prop_4%TYPE;
  l_category_prop_5 mgmt_targets.category_prop_5%TYPE;
  l_count INTEGER;
  l_metric_list MGMT_GUID_ARRAY := MGMT_GUID_ARRAY();
  l_snapshot_metric_list MGMT_GUID_ARRAY := MGMT_GUID_ARRAY();

BEGIN

  -- note: we don't call this API for transposed metrics

  -- get the target guid and category property columns
  BEGIN
    SELECT target_guid, type_meta_ver, category_prop_1, category_prop_2,
           category_prop_3, category_prop_4, category_prop_5
      INTO l_target_guid, l_type_meta_ver, l_category_prop_1, l_category_prop_2,
           l_category_prop_3, l_category_prop_4, l_category_prop_5
      FROM mgmt_targets
     WHERE target_name = target_name_in
       AND target_type = target_type_in;

    EXCEPTION
      WHEN NO_DATA_FOUND
      THEN
        raise MGMT_GLOBAL.target_does_not_exist;
  END;

  -- all metrics collected in the given collection
  SELECT MGMT_GUID_OBJ(met.metric_guid, met.metric_name)
         BULK COLLECT INTO l_metric_list
    FROM mgmt_metrics met, mgmt_collection_metric_tasks cmt
   WHERE met.target_type = target_type_in
     AND (met.metric_type = MGMT_GLOBAL.G_METRIC_TYPE_TABLE OR 
          met.metric_type = MGMT_GLOBAL.G_METRIC_TYPE_REPOS_TABLE OR
          met.metric_type = MGMT_GLOBAL.G_METRIC_TYPE_RAW OR
          met.metric_type = MGMT_GLOBAL.G_METRIC_TYPE_EXTERNAL)
     AND met.type_meta_ver = l_type_meta_ver
     AND (met.category_prop_1 = l_category_prop_1 OR met.category_prop_1 = ' ')
     AND (met.category_prop_2 = l_category_prop_2 OR met.category_prop_2 = ' ')
     AND (met.category_prop_3 = l_category_prop_3 OR met.category_prop_3 = ' ')
     AND (met.category_prop_4 = l_category_prop_4 OR met.category_prop_4 = ' ')
     AND (met.category_prop_5 = l_category_prop_5 OR met.category_prop_5 = ' ')
     AND cmt.target_guid = l_target_guid
     AND cmt.coll_name = coll_name_in
     AND cmt.metric_guid = met.metric_guid;

  -- the repository metrics associated with the given collection
  -- this metric list is for policies with event-driven collections
  SELECT MGMT_GUID_OBJ(met.metric_guid, met.metric_name)
         BULK COLLECT INTO l_snapshot_metric_list
    FROM mgmt_metrics met, mgmt_snapshot_metric_map s
   WHERE met.target_type = target_type_in
     AND (met.metric_type = MGMT_GLOBAL.G_METRIC_TYPE_TABLE OR 
          met.metric_type = MGMT_GLOBAL.G_METRIC_TYPE_REPOS_TABLE OR
          met.metric_type = MGMT_GLOBAL.G_METRIC_TYPE_RAW OR
          met.metric_type = MGMT_GLOBAL.G_METRIC_TYPE_EXTERNAL)
     AND met.type_meta_ver = l_type_meta_ver
     AND (met.category_prop_1 = l_category_prop_1 OR met.category_prop_1 = ' ')
     AND (met.category_prop_2 = l_category_prop_2 OR met.category_prop_2 = ' ')
     AND (met.category_prop_3 = l_category_prop_3 OR met.category_prop_3 = ' ')
     AND (met.category_prop_4 = l_category_prop_4 OR met.category_prop_4 = ' ')
     AND (met.category_prop_5 = l_category_prop_5 OR met.category_prop_5 = ' ')
     AND s.snapshot_target_type = target_type_in
     AND s.snapshot_name = coll_name_in
     AND s.metric_guid = met.metric_guid;

  -- all metrics and their metric columns
  OPEN metric_cur_out FOR
    SELECT met.metric_guid,
           met.metric_name,
           met.metric_label,
           met.metric_label_nlsid,
           met.metric_column,
           met.column_label,
           met.column_label_nlsid,
           met.metric_type
      FROM mgmt_metrics met,
           TABLE(CAST(l_metric_list AS MGMT_GUID_ARRAY) ) metric
     WHERE met.target_type = target_type_in
       AND met.usage_type = MGMT_GLOBAL.G_USAGE_VIEW_COLLECT
       AND met.metric_name = metric.name
       AND (met.metric_column = ' ' OR met.key_order = 0)
       AND met.type_meta_ver = l_type_meta_ver
       AND (met.category_prop_1 = l_category_prop_1 OR met.category_prop_1 = ' ')
       AND (met.category_prop_2 = l_category_prop_2 OR met.category_prop_2 = ' ')
       AND (met.category_prop_3 = l_category_prop_3 OR met.category_prop_3 = ' ')
       AND (met.category_prop_4 = l_category_prop_4 OR met.category_prop_4 = ' ')
       AND (met.category_prop_5 = l_category_prop_5 OR met.category_prop_5 = ' ')
     ORDER BY met.metric_name, met.metric_column;

  -- append l_snapshot_metric_list to l_metric_list
  IF(l_snapshot_metric_list.COUNT > 0)
  THEN
    l_count := l_metric_list.COUNT;
    l_metric_list.extend(l_snapshot_metric_list.COUNT);

    FOR i in l_snapshot_metric_list.FIRST..l_snapshot_metric_list.LAST
    LOOP
      l_count := l_count + 1;
      l_metric_list(l_count) := l_snapshot_metric_list(i);
    END LOOP;
  END IF;

  -- all policies defined on these metrics for this target
  OPEN policy_cur_out FOR
    SELECT MGMT_MESSAGE.GET_MESSAGE(p.policy_label_nlsid, 'POLICY',
             language_code_in, country_code_in, p.policy_name) AS policy_label
      FROM TABLE(CAST(l_metric_list AS MGMT_GUID_ARRAY) ) metric,
           mgmt_policies p, mgmt_policy_assoc pa
     WHERE p.metric_guid = metric.guid
       AND p.target_type = target_type_in
       AND p.policy_type = MGMT_GLOBAL.G_TYPE_POLICY
       AND pa.object_guid = l_target_guid
       AND pa.policy_guid = p.policy_guid
    -- AND pa.coll_name = ?
       AND pa.object_type = MGMT_GLOBAL.G_OBJECT_TYPE_TARGET;

END get_target_collection_info;

--
-- Name: get_template_collection_info
--
-- Package: emd_mntr
--
-- Purpose: 
--  Get the information of all metrics (and metric columns) collected 
--  together with the given metric accross all target versions, and all policies 
--  defined on these metrics for this template.
--
PROCEDURE get_template_collection_info(template_name_in IN VARCHAR2,
                                       target_type_in IN VARCHAR2,
                                       metric_guid_in IN VARCHAR2,
                                       language_code_in IN VARCHAR2,
                                       country_code_in IN VARCHAR2,
                                       metric_cur_out OUT cursorType,
                                       policy_cur_out OUT cursorType) IS

  l_template_guid mgmt_templates.template_guid%TYPE;
  l_metric_guid mgmt_metrics.metric_guid%TYPE;
  l_metric_name mgmt_metrics.metric_name%TYPE;
  l_is_repository mgmt_metrics.is_repository%TYPE;
  l_count INTEGER;
  l_metric_list MGMT_GUID_ARRAY := MGMT_GUID_ARRAY();
  l_snapshot_metric_list MGMT_GUID_ARRAY := MGMT_GUID_ARRAY();

BEGIN

  -- note: we don't call this API for transposed metrics

  -- get the template guid
  IF(template_name_in IS NOT NULL)
  THEN
    BEGIN
      SELECT template_guid INTO l_template_guid
        FROM mgmt_templates
       WHERE template_name = template_name_in
         AND target_type = target_type_in;

      EXCEPTION
        WHEN NO_DATA_FOUND
        THEN
          raise MGMT_GLOBAL.template_does_not_exist;
    END;
  END IF;

  -- check if the metric is a repository metric
  BEGIN
    SELECT DISTINCT metric_guid, metric_name, is_repository
      INTO l_metric_guid, l_metric_name, l_is_repository
      FROM mgmt_metrics
     WHERE target_type = target_type_in
       AND metric_guid = HEXTORAW(metric_guid_in);

    EXCEPTION
      WHEN NO_DATA_FOUND
      THEN
        raise MGMT_GLOBAL.no_such_metric_found;
  END;

  IF(l_is_repository = 0)
  THEN
    -- all metrics collected together with the given metric accross all target versions
    -- note that this query only returns those metrics directly associated with
    -- the given metric, not a flattened relationship
    SELECT MGMT_GUID_OBJ(metric.metric_guid, metric.metric_name)
           BULK COLLECT INTO l_metric_list
      FROM (SELECT DISTINCT met.metric_guid, met.metric_name
              FROM (SELECT DISTINCT coll_name
                      FROM mgmt_coll_item_metrics
                     WHERE target_type = target_type_in
                       AND metric_guid = HEXTORAW(metric_guid_in) ) coll,
                   mgmt_coll_item_metrics cim,
                   mgmt_metrics met
             WHERE cim.target_type = target_type_in
               AND cim.coll_name = coll.coll_name
               AND cim.metric_guid = met.metric_guid
               AND met.target_type = target_type_in
               AND (met.metric_type = MGMT_GLOBAL.G_METRIC_TYPE_TABLE OR 
                    met.metric_type = MGMT_GLOBAL.G_METRIC_TYPE_REPOS_TABLE OR
                    met.metric_type = MGMT_GLOBAL.G_METRIC_TYPE_RAW OR
                    met.metric_type = MGMT_GLOBAL.G_METRIC_TYPE_EXTERNAL) ) metric;

    -- the repository metrics associated with the collections that contain
    -- the given metric accross all target versions
    -- this metric list is for policies with event-driven collections
    SELECT MGMT_GUID_OBJ(metric.metric_guid, metric.metric_name)
           BULK COLLECT INTO l_snapshot_metric_list
      FROM (SELECT DISTINCT met.metric_guid, met.metric_name
              FROM (SELECT DISTINCT coll_name
                      FROM mgmt_coll_item_metrics
                     WHERE target_type = target_type_in
                       AND metric_guid = HEXTORAW(metric_guid_in) ) coll,
                   mgmt_snapshot_metric_map s,
                   mgmt_metrics met
             WHERE s.snapshot_target_type = target_type_in
               AND s.snapshot_name = coll.coll_name
               AND s.metric_guid = met.metric_guid
               AND met.target_type = target_type_in
               AND (met.metric_type = MGMT_GLOBAL.G_METRIC_TYPE_TABLE OR 
                    met.metric_type = MGMT_GLOBAL.G_METRIC_TYPE_REPOS_TABLE OR
                    met.metric_type = MGMT_GLOBAL.G_METRIC_TYPE_RAW OR
                    met.metric_type = MGMT_GLOBAL.G_METRIC_TYPE_EXTERNAL) ) metric;
  ELSE
    -- for repository metrics, there is only one metric collected in a collection
    l_metric_list.extend;
    l_metric_list(1) := MGMT_GUID_OBJ(l_metric_guid, l_metric_name);
  END IF;

  -- all metrics and their metric columns
  OPEN metric_cur_out FOR
    SELECT DISTINCT met.metric_guid,
           met.metric_name,
           met.metric_label,
           met.metric_label_nlsid,           
           met.metric_column,
           met.column_label,
           met.column_label_nlsid,
           met.metric_type
      FROM mgmt_metrics met,
           TABLE(CAST(l_metric_list AS MGMT_GUID_ARRAY) ) metric
     WHERE met.target_type = target_type_in
       AND met.usage_type = MGMT_GLOBAL.G_USAGE_VIEW_COLLECT
       AND met.metric_name = metric.name
       AND (met.metric_column = ' ' OR met.key_order = 0)
     ORDER BY met.metric_name, met.metric_column;

  -- append l_snapshot_metric_list to l_metric_list
  IF(l_snapshot_metric_list.COUNT > 0)
  THEN
    l_count := l_metric_list.COUNT;
    l_metric_list.extend(l_snapshot_metric_list.COUNT);

    FOR i in l_snapshot_metric_list.FIRST..l_snapshot_metric_list.LAST
    LOOP
      l_count := l_count + 1;
      l_metric_list(l_count) := l_snapshot_metric_list(i);
    END LOOP;
  END IF;

  -- all policies defined on these metrics for this template
  IF(template_name_in IS NOT NULL)
  THEN
    OPEN policy_cur_out FOR
      SELECT MGMT_MESSAGE.GET_MESSAGE(p.policy_label_nlsid, 'POLICY',
               language_code_in, country_code_in, p.policy_name) AS policy_label
        FROM TABLE(CAST(l_metric_list AS MGMT_GUID_ARRAY) ) metric,
             mgmt_policies p, mgmt_policy_assoc pa
       WHERE p.metric_guid = metric.guid
         AND p.target_type = target_type_in
         AND p.policy_type = MGMT_GLOBAL.G_TYPE_POLICY
         AND pa.object_guid = l_template_guid
         AND pa.policy_guid = p.policy_guid
      -- AND pa.coll_name = ?
         AND pa.object_type = MGMT_GLOBAL.G_OBJECT_TYPE_TEMPLATE;
  ELSE
    OPEN policy_cur_out FOR
      SELECT MGMT_MESSAGE.GET_MESSAGE(p.policy_label_nlsid, 'POLICY',
               language_code_in, country_code_in, p.policy_name) AS policy_label
        FROM TABLE(CAST(l_metric_list AS MGMT_GUID_ARRAY) ) metric,
             mgmt_policies p
       WHERE p.metric_guid = metric.guid
         AND p.target_type = target_type_in
         AND p.policy_type = MGMT_GLOBAL.G_TYPE_POLICY;
  END IF;

END get_template_collection_info;

--
-- Name: get_metric_collection_info
--
-- Package: emd_mntr
--
-- Purpose: 
--   For each metric of the given metric list, if it is collected together with
--   some other metrics accross all target versions, then get the information of
--   all metrics (and metric columns) collected together with this metric.
--
PROCEDURE get_metric_collection_info(target_type_in IN VARCHAR2,
                                     metric_guid_list_in IN MGMT_GUID_ARRAY,
                                     metric_cur_out OUT cursorType) IS

  l_metric_list MGMT_GUID_ARRAY := MGMT_GUID_ARRAY();

BEGIN

  -- note: we don't call this API for repository metrics and transposed metrics

  -- for each metric of the given metric list, find all metrics collected 
  -- together with this metric accross all target versions, and store them
  -- in a MGMT_GUID_ARRAY
  -- note that this query only returns those metrics directly associated with
  -- each given metric, not a flattened relationship
  SELECT MGMT_GUID_OBJ(metric.guid, metric.metric_name)
         BULK COLLECT INTO l_metric_list
    FROM (SELECT DISTINCT coll.metric_guid AS guid, m.metric_name
            FROM (SELECT DISTINCT cimet.metric_guid, cimet.coll_name
                    FROM mgmt_coll_item_metrics cimet,
                         TABLE(CAST(metric_guid_list_in AS MGMT_GUID_ARRAY) ) list
                   WHERE cimet.target_type = target_type_in
                     AND cimet.metric_guid = HEXTORAW(list.guid) ) coll,
                 mgmt_coll_item_metrics cim,
                 mgmt_metrics m
           WHERE cim.target_type = target_type_in
             AND cim.coll_name = coll.coll_name
             AND cim.metric_guid = m.metric_guid
             AND m.target_type = target_type_in
             AND (m.metric_type = MGMT_GLOBAL.G_METRIC_TYPE_TABLE OR 
                  m.metric_type = MGMT_GLOBAL.G_METRIC_TYPE_REPOS_TABLE OR
                  m.metric_type = MGMT_GLOBAL.G_METRIC_TYPE_RAW OR
                  m.metric_type = MGMT_GLOBAL.G_METRIC_TYPE_EXTERNAL)
           ORDER BY coll.metric_guid) metric;

  -- from the stored MGMT_GUID_ARRAY, find those metrics that have more than
  -- one record in the guid column. This means they are collected together with
  -- some other metrics. Then for each of them, get all metrics and their 
  -- metric columns collected together with this metric.
  OPEN metric_cur_out FOR
    SELECT DISTINCT metric.guid, metric.metric_name AS name,
           met.metric_guid,
           met.metric_name,
           met.metric_column,
           met.column_label,
           met.column_label_nlsid
      FROM mgmt_metrics met,
           (SELECT /*+ CARDINALITY(m1 10) */ DISTINCT ml.guid, me.metric_name, ml.name
              FROM (SELECT /*+ cardinality(m 10) */ m.guid
                      FROM TABLE(CAST(l_metric_list AS MGMT_GUID_ARRAY) ) m
                     GROUP BY m.guid
                    HAVING COUNT(m.name) > 1) g,
                   TABLE(CAST(l_metric_list AS MGMT_GUID_ARRAY) ) ml,
                   mgmt_metrics me
             WHERE g.guid = ml.guid
               AND g.guid = me.metric_guid) metric
     WHERE met.target_type = target_type_in
       AND met.metric_name = metric.name
       AND (met.metric_column = ' ' OR met.key_order = 0)
     ORDER BY metric.guid, met.metric_name, met.metric_column;

END get_metric_collection_info;


--  search_query_in -> Obsolete (maintaining it for backward compatibility
--  apply_operation1_cur_out -> apply_operation1_cur_out contains template names, agent
--                            names and execution ids
--  apply_operation2_cur_out -> apply_operation1_cur_out contains the rest of the
--                            detais for each apply operation (destination
--                            target, job owner, submission timestamp, etc.)
--  p_temp_name_op -> template_name :: 1 = IS_EXACTLY ,  0 = CONTAINS
--  p_temp_name -> template_name 
--  p_tgt_name_op -> target_name :: 1 = IS_EXACTLY ,  0 = CONTAINS
--  p_tgt_type -> target_type :: % = ALL
--  p_mode -> Past or Pending Apply Operations :: past / pending

PROCEDURE get_template_apply_operations(search_query_in             IN VARCHAR2 DEFAULT NULL,
                                        apply_operation1_cur_out    OUT SYS_REFCURSOR,
                                        apply_operation2_cur_out    OUT SYS_REFCURSOR,
                                        p_temp_name_op              IN NUMBER DEFAULT NULL,
                                        p_temp_name                 IN VARCHAR2 DEFAULT NULL,
                                        p_tgt_name_op               IN NUMBER DEFAULT NULL,
                                        p_tgt_name                  IN VARCHAR2 DEFAULT NULL,
                                        p_tgt_type                  IN VARCHAR2 DEFAULT NULL,
                                        p_mode                      IN VARCHAR2 DEFAULT NULL)
IS
    l_current_user            mgmt_created_users.user_name%TYPE;
    l_query                   VARCHAR2(2000);  
    l_tgt_search_str          VARCHAR2(3999);
    l_tmpt_search_str         VARCHAR2(3999);
    l_temp_name_op_internal   NUMBER := 0;
    l_tgt_name_op_internal    NUMBER := 0;
    l_tgt_type_internal       mgmt_targets.target_type%TYPE;
    l_mode_internal           VARCHAR2(20);
    l_temp_name_internal      mgmt_templates.template_name%TYPE;
    l_tgt_name_internal       mgmt_targets.target_name%TYPE;

BEGIN
    IF (p_temp_name_op IS NULL)
    THEN
        l_temp_name_op_internal := 1;
    ELSE
        l_temp_name_op_internal := p_temp_name_op;
    END IF;

    IF (p_tgt_name_op IS NULL)
    THEN
        l_tgt_name_op_internal := 1;
    ELSE
        l_tgt_name_op_internal := p_tgt_name_op;
    END IF;

    IF (p_tgt_type IS NULL OR p_tgt_type = 'All')
    THEN
        l_tgt_type_internal := '%';
    ELSE
        l_tgt_type_internal := p_tgt_type;
    END IF;

    IF ( (p_mode IS NULL) OR  (LENGTH(p_mode) = 0 ) )
    THEN
        l_mode_internal := 'past';
    ELSE
        l_mode_internal := p_mode;
    END IF;

    l_temp_name_internal := TRIM(p_temp_name);
    l_tgt_name_internal  := TRIM(p_tgt_name);

    IF (LENGTH(l_temp_name_internal) = 0)
    THEN
        l_temp_name_internal := NULL;
    END IF;

    IF (LENGTH(l_tgt_name_internal) = 0)
    THEN
        l_tgt_name_internal := NULL;
    END IF;

    IF (l_tgt_name_op_internal = 0 ) -- CONTAINS
    THEN
        l_tgt_search_str := '%'||UPPER(LTRIM(RTRIM(l_tgt_name_internal)))||'%';
        IF LENGTH(TRIM(l_tgt_name_internal))>0 
        THEN
            SELECT UPPER( TRIM( DECODE( INSTR( l_tgt_name_internal,'*'),0, 
                                DECODE( INSTR( l_tgt_name_internal,'%'),0,'%'|| l_tgt_name_internal ||'%', l_tgt_name_internal ), 
                                         REPLACE(l_tgt_name_internal,'*','%'))))
            INTO l_tgt_search_str
            FROM dual;
            l_tgt_search_str := REPLACE( l_tgt_search_str,'_','^_');
        END IF;
    END IF;

    IF (l_temp_name_op_internal = 0 ) -- CONTAINS
    THEN
        l_tmpt_search_str := '%'||UPPER(LTRIM(RTRIM(l_temp_name_internal)))||'%';
        IF LENGTH(TRIM(l_tgt_name_internal))>0 
        THEN
            SELECT UPPER( TRIM( DECODE( INSTR( l_temp_name_internal,'*'),0, 
                                DECODE( INSTR( l_temp_name_internal,'%'),0,'%'|| l_temp_name_internal ||'%', l_temp_name_internal ), 
                                         REPLACE( l_temp_name_internal,'*','%'))))
            INTO l_tmpt_search_str
            FROM dual;
            l_tmpt_search_str := REPLACE( l_tmpt_search_str,'_','^_');
        END IF;
    END IF;

    -- Become super-user. This is necessary because we need to retrieve the name
    -- of templates and agents on which the current user does not have any 
    -- privilege. If such a template is applied to a target on which the user
    -- has Operator privilege, the user should know where the data is coming from.
    -- Also the user might not have any privilege on the agent of the target but
    -- we still need to display the agent name.
    l_current_user := MGMT_USER.GET_CURRENT_EM_USER;
    SETEMUSERCONTEXT(MGMT_USER.get_repository_owner, MGMT_USER.OP_SET_IDENTIFIER);    

    -- Put the execution_id, template_name and agent_name into a cursor that will
    -- be passed back to Java.
    IF (l_temp_name_internal IS NULL AND l_tgt_name_internal IS NULL)
    THEN
        IF ( l_tgt_type_internal = '%' )
        THEN
            IF (l_mode_internal = 'pending')
            THEN
                OPEN apply_operation1_cur_out FOR
                SELECT tmp.template_name as template_name,
                       det.execution_id as execution_id,
                       emd.target_name as agent_name
                  FROM mgmt_update_operations_data dat,
                       mgmt_update_operations_details det,
                       mgmt_update_template_data_map map,
                       mgmt_update_operations op,
                       mgmt_templates tmp,
                       mgmt_targets tgt,
                       (SELECT target_guid, target_name
                          FROM mgmt_targets
                         WHERE target_type = MGMT_GLOBAL.G_AGENT_TARGET_TYPE) emd
                 WHERE tgt.target_guid = det.destination_target_guid
                   AND det.agent_guid = emd.target_guid (+)
                   AND dat.operation_guid = det.operation_guid
                   AND dat.operation_guid = op.operation_guid
                   AND dat.data_set_type = 4
                   AND dat.source_target_guid = tmp.template_guid (+)
                   AND dat.data_set_guid = map.data_set_guid
                   AND det.execution_status IN (1,2,6);
            ELSIF (l_mode_internal = 'past')
            THEN
                OPEN apply_operation1_cur_out FOR
                SELECT tmp.template_name as template_name,
                       det.execution_id as execution_id,
                       emd.target_name as agent_name
                  FROM mgmt_update_operations_data dat,
                       mgmt_update_operations_details det,
                       mgmt_update_template_data_map map,
                       mgmt_update_operations op,
                       mgmt_templates tmp,
                       mgmt_targets tgt,
                       (SELECT target_guid, target_name
                          FROM mgmt_targets
                         WHERE target_type = MGMT_GLOBAL.G_AGENT_TARGET_TYPE) emd
                 WHERE tgt.target_guid = det.destination_target_guid
                   AND det.agent_guid = emd.target_guid (+)
                   AND dat.operation_guid = det.operation_guid
                   AND dat.operation_guid = op.operation_guid
                   AND dat.data_set_type = 4
                   AND dat.source_target_guid = tmp.template_guid (+)
                   AND dat.data_set_guid = map.data_set_guid
                   AND det.execution_status IN (3,4,5,8);
            END IF;
        ELSE
            IF (l_mode_internal = 'pending')
            THEN
                OPEN apply_operation1_cur_out FOR
                SELECT tmp.template_name as template_name,
                       det.execution_id as execution_id,
                       emd.target_name as agent_name
                  FROM mgmt_update_operations_data dat,
                       mgmt_update_operations_details det,
                       mgmt_update_template_data_map map,
                       mgmt_update_operations op,
                       mgmt_templates tmp,
                       mgmt_targets tgt,
                       (SELECT target_guid, target_name
                          FROM mgmt_targets
                         WHERE target_type = MGMT_GLOBAL.G_AGENT_TARGET_TYPE) emd
                 WHERE tgt.target_guid = det.destination_target_guid
                   AND det.agent_guid = emd.target_guid (+)
                   AND dat.operation_guid = det.operation_guid
                   AND dat.operation_guid = op.operation_guid
                   AND dat.data_set_type = 4
                   AND dat.source_target_guid = tmp.template_guid (+)
                   AND dat.data_set_guid = map.data_set_guid
                   AND det.execution_status IN (1,2,6)
                   AND tgt.target_type = l_tgt_type_internal;
            ELSIF (l_mode_internal = 'past')
            THEN
                OPEN apply_operation1_cur_out FOR
                SELECT tmp.template_name as template_name,
                       det.execution_id as execution_id,
                       emd.target_name as agent_name
                  FROM mgmt_update_operations_data dat,
                       mgmt_update_operations_details det,
                       mgmt_update_template_data_map map,
                       mgmt_update_operations op,
                       mgmt_templates tmp,
                       mgmt_targets tgt,
                       (SELECT target_guid, target_name
                          FROM mgmt_targets
                         WHERE target_type = MGMT_GLOBAL.G_AGENT_TARGET_TYPE) emd
                 WHERE tgt.target_guid = det.destination_target_guid
                   AND det.agent_guid = emd.target_guid (+)
                   AND dat.operation_guid = det.operation_guid
                   AND dat.operation_guid = op.operation_guid
                   AND dat.data_set_type = 4
                   AND dat.source_target_guid = tmp.template_guid (+)
                   AND dat.data_set_guid = map.data_set_guid
                   AND det.execution_status IN (3,4,5,8)
                   AND tgt.target_type = l_tgt_type_internal;
            END IF;
        END IF;
    ELSIF (l_temp_name_internal IS NULL AND l_tgt_name_internal IS NOT NULL)
    THEN
        IF (l_tgt_name_op_internal = 1) -- IS_EXACTLY
        THEN
            IF ( l_tgt_type_internal = '%' )
            THEN
                IF (l_mode_internal = 'pending')
                THEN
                    OPEN apply_operation1_cur_out FOR
                    SELECT tmp.template_name as template_name,
                           det.execution_id as execution_id,
                           emd.target_name as agent_name
                      FROM mgmt_update_operations_data dat,
                           mgmt_update_operations_details det,
                           mgmt_update_template_data_map map,
                           mgmt_update_operations op,
                           mgmt_templates tmp,
                           mgmt_targets tgt,
                           (SELECT target_guid, target_name
                              FROM mgmt_targets
                             WHERE target_type = MGMT_GLOBAL.G_AGENT_TARGET_TYPE) emd
                     WHERE tgt.target_guid = det.destination_target_guid
                       AND det.agent_guid = emd.target_guid (+)
                       AND dat.operation_guid = det.operation_guid
                       AND dat.operation_guid = op.operation_guid
                       AND dat.data_set_type = 4
                       AND dat.source_target_guid = tmp.template_guid (+)
                       AND dat.data_set_guid = map.data_set_guid
                       AND det.execution_status IN (1,2,6)
                       AND tgt.target_name = l_tgt_name_internal;
                ELSIF (l_mode_internal = 'past')
                THEN
                    OPEN apply_operation1_cur_out FOR
                    SELECT tmp.template_name as template_name,
                           det.execution_id as execution_id,
                           emd.target_name as agent_name
                      FROM mgmt_update_operations_data dat,
                           mgmt_update_operations_details det,
                           mgmt_update_template_data_map map,
                           mgmt_update_operations op,
                           mgmt_templates tmp,
                           mgmt_targets tgt,
                           (SELECT target_guid, target_name
                              FROM mgmt_targets
                             WHERE target_type = MGMT_GLOBAL.G_AGENT_TARGET_TYPE) emd
                     WHERE tgt.target_guid = det.destination_target_guid
                       AND det.agent_guid = emd.target_guid (+)
                       AND dat.operation_guid = det.operation_guid
                       AND dat.operation_guid = op.operation_guid
                       AND dat.data_set_type = 4
                       AND dat.source_target_guid = tmp.template_guid (+)
                       AND dat.data_set_guid = map.data_set_guid
                       AND det.execution_status IN (3,4,5,8)
                       AND tgt.target_name = l_tgt_name_internal;
                END IF; -- end of mode
            ELSE -- specific target type
                IF (l_mode_internal = 'pending')
                THEN
                    OPEN apply_operation1_cur_out FOR
                    SELECT tmp.template_name as template_name,
                           det.execution_id as execution_id,
                           emd.target_name as agent_name
                      FROM mgmt_update_operations_data dat,
                           mgmt_update_operations_details det,
                           mgmt_update_template_data_map map,
                           mgmt_update_operations op,
                           mgmt_templates tmp,
                           mgmt_targets tgt,
                           (SELECT target_guid, target_name
                              FROM mgmt_targets
                             WHERE target_type = MGMT_GLOBAL.G_AGENT_TARGET_TYPE) emd
                     WHERE tgt.target_guid = det.destination_target_guid
                       AND det.agent_guid = emd.target_guid (+)
                       AND dat.operation_guid = det.operation_guid
                       AND dat.operation_guid = op.operation_guid
                       AND dat.data_set_type = 4
                       AND dat.source_target_guid = tmp.template_guid (+)
                       AND dat.data_set_guid = map.data_set_guid
                       AND det.execution_status IN (1,2,6)
                       AND tgt.target_type = l_tgt_type_internal
                       AND tgt.target_name = l_tgt_name_internal;
                ELSIF (l_mode_internal = 'past')
                THEN
                    OPEN apply_operation1_cur_out FOR
                    SELECT tmp.template_name as template_name,
                           det.execution_id as execution_id,
                           emd.target_name as agent_name
                      FROM mgmt_update_operations_data dat,
                           mgmt_update_operations_details det,
                           mgmt_update_template_data_map map,
                           mgmt_update_operations op,
                           mgmt_templates tmp,
                           mgmt_targets tgt,
                           (SELECT target_guid, target_name
                              FROM mgmt_targets
                             WHERE target_type = MGMT_GLOBAL.G_AGENT_TARGET_TYPE) emd
                     WHERE tgt.target_guid = det.destination_target_guid
                       AND det.agent_guid = emd.target_guid (+)
                       AND dat.operation_guid = det.operation_guid
                       AND dat.operation_guid = op.operation_guid
                       AND dat.data_set_type = 4
                       AND dat.source_target_guid = tmp.template_guid (+)
                       AND dat.data_set_guid = map.data_set_guid
                       AND det.execution_status IN (3,4,5,8)
                       AND tgt.target_type = l_tgt_type_internal
                       AND tgt.target_name = l_tgt_name_internal;
                END IF;
            END IF; -- end of target type
        ELSIF (l_tgt_name_op_internal = 0) -- CONTAINS
        THEN
            IF ( l_tgt_type_internal = '%' )
            THEN
                IF (l_mode_internal = 'pending')
                THEN
                    OPEN apply_operation1_cur_out FOR
                    SELECT tmp.template_name as template_name,
                           det.execution_id as execution_id,
                           emd.target_name as agent_name
                      FROM mgmt_update_operations_data dat,
                           mgmt_update_operations_details det,
                           mgmt_update_template_data_map map,
                           mgmt_update_operations op,
                           mgmt_templates tmp,
                           mgmt_targets tgt,
                           (SELECT target_guid, target_name
                              FROM mgmt_targets
                             WHERE target_type = MGMT_GLOBAL.G_AGENT_TARGET_TYPE) emd
                     WHERE tgt.target_guid = det.destination_target_guid
                       AND det.agent_guid = emd.target_guid (+)
                       AND dat.operation_guid = det.operation_guid
                       AND dat.operation_guid = op.operation_guid
                       AND dat.data_set_type = 4
                       AND dat.source_target_guid = tmp.template_guid (+)
                       AND dat.data_set_guid = map.data_set_guid
                       AND det.execution_status IN (1,2,6)
                       AND UPPER(tgt.target_name) LIKE l_tgt_search_str escape '^';
                ELSIF (l_mode_internal = 'past')
                THEN
                    OPEN apply_operation1_cur_out FOR
                    SELECT tmp.template_name as template_name,
                           det.execution_id as execution_id,
                           emd.target_name as agent_name
                      FROM mgmt_update_operations_data dat,
                           mgmt_update_operations_details det,
                           mgmt_update_template_data_map map,
                           mgmt_update_operations op,
                           mgmt_templates tmp,
                           mgmt_targets tgt,
                           (SELECT target_guid, target_name
                              FROM mgmt_targets
                             WHERE target_type = MGMT_GLOBAL.G_AGENT_TARGET_TYPE) emd
                     WHERE tgt.target_guid = det.destination_target_guid
                       AND det.agent_guid = emd.target_guid (+)
                       AND dat.operation_guid = det.operation_guid
                       AND dat.operation_guid = op.operation_guid
                       AND dat.data_set_type = 4
                       AND dat.source_target_guid = tmp.template_guid (+)
                       AND dat.data_set_guid = map.data_set_guid
                       AND det.execution_status IN (3,4,5,8)
                       AND UPPER(tgt.target_name) LIKE l_tgt_search_str escape '^';
                END IF; -- end of mode
            ELSE -- specific target type
                IF (l_mode_internal = 'pending')
                THEN
                    OPEN apply_operation1_cur_out FOR
                    SELECT tmp.template_name as template_name,
                           det.execution_id as execution_id,
                           emd.target_name as agent_name
                      FROM mgmt_update_operations_data dat,
                           mgmt_update_operations_details det,
                           mgmt_update_template_data_map map,
                           mgmt_update_operations op,
                           mgmt_templates tmp,
                           mgmt_targets tgt,
                           (SELECT target_guid, target_name
                              FROM mgmt_targets
                             WHERE target_type = MGMT_GLOBAL.G_AGENT_TARGET_TYPE) emd
                     WHERE tgt.target_guid = det.destination_target_guid
                       AND det.agent_guid = emd.target_guid (+)
                       AND dat.operation_guid = det.operation_guid
                       AND dat.operation_guid = op.operation_guid
                       AND dat.data_set_type = 4
                       AND dat.source_target_guid = tmp.template_guid (+)
                       AND dat.data_set_guid = map.data_set_guid
                       AND det.execution_status IN (1,2,6)
                       AND tgt.target_type = l_tgt_type_internal
                       AND UPPER(tgt.target_name) LIKE l_tgt_search_str escape '^';
                ELSIF (l_mode_internal = 'past')
                THEN
                    OPEN apply_operation1_cur_out FOR
                    SELECT tmp.template_name as template_name,
                           det.execution_id as execution_id,
                           emd.target_name as agent_name
                      FROM mgmt_update_operations_data dat,
                           mgmt_update_operations_details det,
                           mgmt_update_template_data_map map,
                           mgmt_update_operations op,
                           mgmt_templates tmp,
                           mgmt_targets tgt,
                           (SELECT target_guid, target_name
                              FROM mgmt_targets
                             WHERE target_type = MGMT_GLOBAL.G_AGENT_TARGET_TYPE) emd
                     WHERE tgt.target_guid = det.destination_target_guid
                       AND det.agent_guid = emd.target_guid (+)
                       AND dat.operation_guid = det.operation_guid
                       AND dat.operation_guid = op.operation_guid
                       AND dat.data_set_type = 4
                       AND dat.source_target_guid = tmp.template_guid (+)
                       AND dat.data_set_guid = map.data_set_guid
                       AND det.execution_status IN (3,4,5,8)
                       AND tgt.target_type = l_tgt_type_internal
                       AND UPPER(tgt.target_name) LIKE l_tgt_search_str escape '^';
                END IF;
            END IF; -- end of target type
        END IF; -- end of tgt operator
    ELSIF ( l_temp_name_internal IS NOT NULL AND l_tgt_name_internal IS NULL )
    THEN
        IF ( l_temp_name_op_internal = 1) -- IS_EXACTLY
        THEN
            IF ( l_tgt_type_internal = '%' )
            THEN
                IF (l_mode_internal = 'pending')
                THEN
                    OPEN apply_operation1_cur_out FOR
                    SELECT tmp.template_name as template_name,
                           det.execution_id as execution_id,
                           emd.target_name as agent_name
                      FROM mgmt_update_operations_data dat,
                           mgmt_update_operations_details det,
                           mgmt_update_template_data_map map,
                           mgmt_update_operations op,
                           mgmt_templates tmp,
                           mgmt_targets tgt,
                           (SELECT target_guid, target_name
                              FROM mgmt_targets
                             WHERE target_type = MGMT_GLOBAL.G_AGENT_TARGET_TYPE) emd
                     WHERE tgt.target_guid = det.destination_target_guid
                       AND det.agent_guid = emd.target_guid (+)
                       AND dat.operation_guid = det.operation_guid
                       AND dat.operation_guid = op.operation_guid
                       AND dat.data_set_type = 4
                       AND dat.source_target_guid = tmp.template_guid (+)
                       AND dat.data_set_guid = map.data_set_guid
                       AND det.execution_status IN (1,2,6)
                       AND tmp.template_name = l_temp_name_internal;
                ELSIF (l_mode_internal = 'past')
                THEN
                    OPEN apply_operation1_cur_out FOR
                    SELECT tmp.template_name as template_name,
                           det.execution_id as execution_id,
                           emd.target_name as agent_name
                      FROM mgmt_update_operations_data dat,
                           mgmt_update_operations_details det,
                           mgmt_update_template_data_map map,
                           mgmt_update_operations op,
                           mgmt_templates tmp,
                           mgmt_targets tgt,
                           (SELECT target_guid, target_name
                              FROM mgmt_targets
                             WHERE target_type = MGMT_GLOBAL.G_AGENT_TARGET_TYPE) emd
                     WHERE tgt.target_guid = det.destination_target_guid
                       AND det.agent_guid = emd.target_guid (+)
                       AND dat.operation_guid = det.operation_guid
                       AND dat.operation_guid = op.operation_guid
                       AND dat.data_set_type = 4
                       AND dat.source_target_guid = tmp.template_guid (+)
                       AND dat.data_set_guid = map.data_set_guid
                       AND det.execution_status IN (3,4,5,8)
                       AND tmp.template_name = l_temp_name_internal;
                END IF; -- end of mode
            ELSE -- specific target type
                IF (l_mode_internal = 'pending')
                THEN
                    OPEN apply_operation1_cur_out FOR
                    SELECT tmp.template_name as template_name,
                           det.execution_id as execution_id,
                           emd.target_name as agent_name
                      FROM mgmt_update_operations_data dat,
                           mgmt_update_operations_details det,
                           mgmt_update_template_data_map map,
                           mgmt_update_operations op,
                           mgmt_templates tmp,
                           mgmt_targets tgt,
                           (SELECT target_guid, target_name
                              FROM mgmt_targets
                             WHERE target_type = MGMT_GLOBAL.G_AGENT_TARGET_TYPE) emd
                     WHERE tgt.target_guid = det.destination_target_guid
                       AND det.agent_guid = emd.target_guid (+)
                       AND dat.operation_guid = det.operation_guid
                       AND dat.operation_guid = op.operation_guid
                       AND dat.data_set_type = 4
                       AND dat.source_target_guid = tmp.template_guid (+)
                       AND dat.data_set_guid = map.data_set_guid
                       AND det.execution_status IN (1,2,6)
                       AND tgt.target_type = l_tgt_type_internal
                       AND tmp.template_name = l_temp_name_internal;
                ELSIF (l_mode_internal = 'past')
                THEN
                    OPEN apply_operation1_cur_out FOR
                    SELECT tmp.template_name as template_name,
                           det.execution_id as execution_id,
                           emd.target_name as agent_name
                      FROM mgmt_update_operations_data dat,
                           mgmt_update_operations_details det,
                           mgmt_update_template_data_map map,
                           mgmt_update_operations op,
                           mgmt_templates tmp,
                           mgmt_targets tgt,
                           (SELECT target_guid, target_name
                              FROM mgmt_targets
                             WHERE target_type = MGMT_GLOBAL.G_AGENT_TARGET_TYPE) emd
                     WHERE tgt.target_guid = det.destination_target_guid
                       AND det.agent_guid = emd.target_guid (+)
                       AND dat.operation_guid = det.operation_guid
                       AND dat.operation_guid = op.operation_guid
                       AND dat.data_set_type = 4
                       AND dat.source_target_guid = tmp.template_guid (+)
                       AND dat.data_set_guid = map.data_set_guid
                       AND det.execution_status IN (3,4,5,8)
                       AND tgt.target_type = l_tgt_type_internal
                       AND tmp.template_name = l_temp_name_internal;
                END IF;
            END IF; -- end of target type
        ELSIF ( l_temp_name_op_internal = 0) -- CONTAINS
        THEN
            IF ( l_tgt_type_internal = '%' )
            THEN
                IF (l_mode_internal = 'pending')
                THEN
                    OPEN apply_operation1_cur_out FOR
                    SELECT tmp.template_name as template_name,
                           det.execution_id as execution_id,
                           emd.target_name as agent_name
                      FROM mgmt_update_operations_data dat,
                           mgmt_update_operations_details det,
                           mgmt_update_template_data_map map,
                           mgmt_update_operations op,
                           mgmt_templates tmp,
                           mgmt_targets tgt,
                           (SELECT target_guid, target_name
                              FROM mgmt_targets
                             WHERE target_type = MGMT_GLOBAL.G_AGENT_TARGET_TYPE) emd
                     WHERE tgt.target_guid = det.destination_target_guid
                       AND det.agent_guid = emd.target_guid (+)
                       AND dat.operation_guid = det.operation_guid
                       AND dat.operation_guid = op.operation_guid
                       AND dat.data_set_type = 4
                       AND dat.source_target_guid = tmp.template_guid (+)
                       AND dat.data_set_guid = map.data_set_guid
                       AND det.execution_status IN (1,2,6)
                       AND UPPER(tmp.template_name) LIKE l_tmpt_search_str escape '^';
                ELSIF (l_mode_internal = 'past')
                THEN
                    OPEN apply_operation1_cur_out FOR
                    SELECT tmp.template_name as template_name,
                           det.execution_id as execution_id,
                           emd.target_name as agent_name
                      FROM mgmt_update_operations_data dat,
                           mgmt_update_operations_details det,
                           mgmt_update_template_data_map map,
                           mgmt_update_operations op,
                           mgmt_templates tmp,
                           mgmt_targets tgt,
                           (SELECT target_guid, target_name
                              FROM mgmt_targets
                             WHERE target_type = MGMT_GLOBAL.G_AGENT_TARGET_TYPE) emd
                     WHERE tgt.target_guid = det.destination_target_guid
                       AND det.agent_guid = emd.target_guid (+)
                       AND dat.operation_guid = det.operation_guid
                       AND dat.operation_guid = op.operation_guid
                       AND dat.data_set_type = 4
                       AND dat.source_target_guid = tmp.template_guid (+)
                       AND dat.data_set_guid = map.data_set_guid
                       AND det.execution_status IN (3,4,5,8)
                       AND UPPER(tmp.template_name) LIKE l_tmpt_search_str escape '^';
                END IF; -- end of mode
            ELSE -- specific target type
                IF (l_mode_internal = 'pending')
                THEN
                    OPEN apply_operation1_cur_out FOR
                    SELECT tmp.template_name as template_name,
                           det.execution_id as execution_id,
                           emd.target_name as agent_name
                      FROM mgmt_update_operations_data dat,
                           mgmt_update_operations_details det,
                           mgmt_update_template_data_map map,
                           mgmt_update_operations op,
                           mgmt_templates tmp,
                           mgmt_targets tgt,
                           (SELECT target_guid, target_name
                              FROM mgmt_targets
                             WHERE target_type = MGMT_GLOBAL.G_AGENT_TARGET_TYPE) emd
                     WHERE tgt.target_guid = det.destination_target_guid
                       AND det.agent_guid = emd.target_guid (+)
                       AND dat.operation_guid = det.operation_guid
                       AND dat.operation_guid = op.operation_guid
                       AND dat.data_set_type = 4
                       AND dat.source_target_guid = tmp.template_guid (+)
                       AND dat.data_set_guid = map.data_set_guid
                       AND det.execution_status IN (1,2,6)
                       AND tgt.target_type = l_tgt_type_internal
                       AND UPPER(tmp.template_name) LIKE l_tmpt_search_str escape '^';
                ELSIF (l_mode_internal = 'past')
                THEN
                    OPEN apply_operation1_cur_out FOR
                    SELECT tmp.template_name as template_name,
                           det.execution_id as execution_id,
                           emd.target_name as agent_name
                      FROM mgmt_update_operations_data dat,
                           mgmt_update_operations_details det,
                           mgmt_update_template_data_map map,
                           mgmt_update_operations op,
                           mgmt_templates tmp,
                           mgmt_targets tgt,
                           (SELECT target_guid, target_name
                              FROM mgmt_targets
                             WHERE target_type = MGMT_GLOBAL.G_AGENT_TARGET_TYPE) emd
                     WHERE tgt.target_guid = det.destination_target_guid
                       AND det.agent_guid = emd.target_guid (+)
                       AND dat.operation_guid = det.operation_guid
                       AND dat.operation_guid = op.operation_guid
                       AND dat.data_set_type = 4
                       AND dat.source_target_guid = tmp.template_guid (+)
                       AND dat.data_set_guid = map.data_set_guid
                       AND det.execution_status IN (3,4,5,8)
                       AND tgt.target_type = l_tgt_type_internal
                       AND UPPER(tmp.template_name) LIKE l_tmpt_search_str escape '^';
                END IF;
            END IF; -- end of target type
        END IF; -- end of tgt operator
    ELSIF ( l_temp_name_internal IS NOT NULL AND l_tgt_name_internal IS NOT NULL )
    THEN
        IF ( l_temp_name_op_internal = 1 AND l_tgt_name_op_internal = 1 ) -- template name and tgt name IS_EXACTLY
        THEN
            IF ( l_tgt_type_internal = '%' )
            THEN
                IF (l_mode_internal = 'pending')
                THEN
                    OPEN apply_operation1_cur_out FOR
                    SELECT tmp.template_name as template_name,
                           det.execution_id as execution_id,
                           emd.target_name as agent_name
                      FROM mgmt_update_operations_data dat,
                           mgmt_update_operations_details det,
                           mgmt_update_template_data_map map,
                           mgmt_update_operations op,
                           mgmt_templates tmp,
                           mgmt_targets tgt,
                           (SELECT target_guid, target_name
                              FROM mgmt_targets
                             WHERE target_type = MGMT_GLOBAL.G_AGENT_TARGET_TYPE) emd
                     WHERE tgt.target_guid = det.destination_target_guid
                       AND det.agent_guid = emd.target_guid (+)
                       AND dat.operation_guid = det.operation_guid
                       AND dat.operation_guid = op.operation_guid
                       AND dat.data_set_type = 4
                       AND dat.source_target_guid = tmp.template_guid (+)
                       AND dat.data_set_guid = map.data_set_guid
                       AND det.execution_status IN (1,2,6)
                       AND tmp.template_name = l_temp_name_internal
                       AND tgt.target_name = l_tgt_name_internal;
                ELSIF (l_mode_internal = 'past')
                THEN
                    OPEN apply_operation1_cur_out FOR
                    SELECT tmp.template_name as template_name,
                           det.execution_id as execution_id,
                           emd.target_name as agent_name
                      FROM mgmt_update_operations_data dat,
                           mgmt_update_operations_details det,
                           mgmt_update_template_data_map map,
                           mgmt_update_operations op,
                           mgmt_templates tmp,
                           mgmt_targets tgt,
                           (SELECT target_guid, target_name
                              FROM mgmt_targets
                             WHERE target_type = MGMT_GLOBAL.G_AGENT_TARGET_TYPE) emd
                     WHERE tgt.target_guid = det.destination_target_guid
                       AND det.agent_guid = emd.target_guid (+)
                       AND dat.operation_guid = det.operation_guid
                       AND dat.operation_guid = op.operation_guid
                       AND dat.data_set_type = 4
                       AND dat.source_target_guid = tmp.template_guid (+)
                       AND dat.data_set_guid = map.data_set_guid
                       AND det.execution_status IN (3,4,5,8)
                       AND tmp.template_name = l_temp_name_internal
                       AND tgt.target_name = l_tgt_name_internal;
                END IF; -- end of mode
            ELSE -- specific target type
                IF (l_mode_internal = 'pending')
                THEN
                    OPEN apply_operation1_cur_out FOR
                    SELECT tmp.template_name as template_name,
                           det.execution_id as execution_id,
                           emd.target_name as agent_name
                      FROM mgmt_update_operations_data dat,
                           mgmt_update_operations_details det,
                           mgmt_update_template_data_map map,
                           mgmt_update_operations op,
                           mgmt_templates tmp,
                           mgmt_targets tgt,
                           (SELECT target_guid, target_name
                              FROM mgmt_targets
                             WHERE target_type = MGMT_GLOBAL.G_AGENT_TARGET_TYPE) emd
                     WHERE tgt.target_guid = det.destination_target_guid
                       AND det.agent_guid = emd.target_guid (+)
                       AND dat.operation_guid = det.operation_guid
                       AND dat.operation_guid = op.operation_guid
                       AND dat.data_set_type = 4
                       AND dat.source_target_guid = tmp.template_guid (+)
                       AND dat.data_set_guid = map.data_set_guid
                       AND det.execution_status IN (1,2,6)
                       AND tgt.target_type = l_tgt_type_internal
                       AND tmp.template_name = l_temp_name_internal
                       AND tgt.target_name = l_tgt_name_internal;
                ELSIF (l_mode_internal = 'past')
                THEN
                    OPEN apply_operation1_cur_out FOR
                    SELECT tmp.template_name as template_name,
                           det.execution_id as execution_id,
                           emd.target_name as agent_name
                      FROM mgmt_update_operations_data dat,
                           mgmt_update_operations_details det,
                           mgmt_update_template_data_map map,
                           mgmt_update_operations op,
                           mgmt_templates tmp,
                           mgmt_targets tgt,
                           (SELECT target_guid, target_name
                              FROM mgmt_targets
                             WHERE target_type = MGMT_GLOBAL.G_AGENT_TARGET_TYPE) emd
                     WHERE tgt.target_guid = det.destination_target_guid
                       AND det.agent_guid = emd.target_guid (+)
                       AND dat.operation_guid = det.operation_guid
                       AND dat.operation_guid = op.operation_guid
                       AND dat.data_set_type = 4
                       AND dat.source_target_guid = tmp.template_guid (+)
                       AND dat.data_set_guid = map.data_set_guid
                       AND det.execution_status IN (3,4,5,8)
                       AND tgt.target_type = l_tgt_type_internal
                       AND tmp.template_name = l_temp_name_internal
                       AND tgt.target_name = l_tgt_name_internal;
                END IF;
            END IF; -- end of target type        
        ELSIF ( l_temp_name_op_internal = 1 AND l_tgt_name_op_internal = 0 ) -- template name IS_EXACTLY and tgt name CONTAINS
        THEN
            IF ( l_tgt_type_internal = '%' )
            THEN
                IF (l_mode_internal = 'pending')
                THEN
                    OPEN apply_operation1_cur_out FOR
                    SELECT tmp.template_name as template_name,
                           det.execution_id as execution_id,
                           emd.target_name as agent_name
                      FROM mgmt_update_operations_data dat,
                           mgmt_update_operations_details det,
                           mgmt_update_template_data_map map,
                           mgmt_update_operations op,
                           mgmt_templates tmp,
                           mgmt_targets tgt,
                           (SELECT target_guid, target_name
                              FROM mgmt_targets
                             WHERE target_type = MGMT_GLOBAL.G_AGENT_TARGET_TYPE) emd
                     WHERE tgt.target_guid = det.destination_target_guid
                       AND det.agent_guid = emd.target_guid (+)
                       AND dat.operation_guid = det.operation_guid
                       AND dat.operation_guid = op.operation_guid
                       AND dat.data_set_type = 4
                       AND dat.source_target_guid = tmp.template_guid (+)
                       AND dat.data_set_guid = map.data_set_guid
                       AND det.execution_status IN (1,2,6)
                       AND tmp.template_name = l_temp_name_internal
                       AND UPPER(tgt.target_name) LIKE l_tgt_search_str escape '^';
                ELSIF (l_mode_internal = 'past')
                THEN
                    OPEN apply_operation1_cur_out FOR
                    SELECT tmp.template_name as template_name,
                           det.execution_id as execution_id,
                           emd.target_name as agent_name
                      FROM mgmt_update_operations_data dat,
                           mgmt_update_operations_details det,
                           mgmt_update_template_data_map map,
                           mgmt_update_operations op,
                           mgmt_templates tmp,
                           mgmt_targets tgt,
                           (SELECT target_guid, target_name
                              FROM mgmt_targets
                             WHERE target_type = MGMT_GLOBAL.G_AGENT_TARGET_TYPE) emd
                     WHERE tgt.target_guid = det.destination_target_guid
                       AND det.agent_guid = emd.target_guid (+)
                       AND dat.operation_guid = det.operation_guid
                       AND dat.operation_guid = op.operation_guid
                       AND dat.data_set_type = 4
                       AND dat.source_target_guid = tmp.template_guid (+)
                       AND dat.data_set_guid = map.data_set_guid
                       AND det.execution_status IN (3,4,5,8)
                       AND tmp.template_name = l_temp_name_internal
                       AND UPPER(tgt.target_name) LIKE l_tgt_search_str escape '^';
                END IF; -- end of mode
            ELSE -- specific target type
                IF (l_mode_internal = 'pending')
                THEN
                    OPEN apply_operation1_cur_out FOR
                    SELECT tmp.template_name as template_name,
                           det.execution_id as execution_id,
                           emd.target_name as agent_name
                      FROM mgmt_update_operations_data dat,
                           mgmt_update_operations_details det,
                           mgmt_update_template_data_map map,
                           mgmt_update_operations op,
                           mgmt_templates tmp,
                           mgmt_targets tgt,
                           (SELECT target_guid, target_name
                              FROM mgmt_targets
                             WHERE target_type = MGMT_GLOBAL.G_AGENT_TARGET_TYPE) emd
                     WHERE tgt.target_guid = det.destination_target_guid
                       AND det.agent_guid = emd.target_guid (+)
                       AND dat.operation_guid = det.operation_guid
                       AND dat.operation_guid = op.operation_guid
                       AND dat.data_set_type = 4
                       AND dat.source_target_guid = tmp.template_guid (+)
                       AND dat.data_set_guid = map.data_set_guid
                       AND det.execution_status IN (1,2,6)
                       AND tgt.target_type = l_tgt_type_internal
                       AND tmp.template_name = l_temp_name_internal
                       AND UPPER(tgt.target_name) LIKE l_tgt_search_str escape '^';
                ELSIF (l_mode_internal = 'past')
                THEN
                    OPEN apply_operation1_cur_out FOR
                    SELECT tmp.template_name as template_name,
                           det.execution_id as execution_id,
                           emd.target_name as agent_name
                      FROM mgmt_update_operations_data dat,
                           mgmt_update_operations_details det,
                           mgmt_update_template_data_map map,
                           mgmt_update_operations op,
                           mgmt_templates tmp,
                           mgmt_targets tgt,
                           (SELECT target_guid, target_name
                              FROM mgmt_targets
                             WHERE target_type = MGMT_GLOBAL.G_AGENT_TARGET_TYPE) emd
                     WHERE tgt.target_guid = det.destination_target_guid
                       AND det.agent_guid = emd.target_guid (+)
                       AND dat.operation_guid = det.operation_guid
                       AND dat.operation_guid = op.operation_guid
                       AND dat.data_set_type = 4
                       AND dat.source_target_guid = tmp.template_guid (+)
                       AND dat.data_set_guid = map.data_set_guid
                       AND det.execution_status IN (3,4,5,8)
                       AND tgt.target_type = l_tgt_type_internal
                       AND tmp.template_name = l_temp_name_internal
                       AND UPPER(tgt.target_name) LIKE l_tgt_search_str escape '^';
                END IF;
            END IF; -- end of target type
        ELSIF ( l_temp_name_op_internal = 0 AND l_tgt_name_op_internal = 1 ) -- template name CONTAINS and tgt name IS_EXACTLY
        THEN
            IF ( l_tgt_type_internal = '%' )
            THEN
                IF (l_mode_internal = 'pending')
                THEN
                    OPEN apply_operation1_cur_out FOR
                    SELECT tmp.template_name as template_name,
                           det.execution_id as execution_id,
                           emd.target_name as agent_name
                      FROM mgmt_update_operations_data dat,
                           mgmt_update_operations_details det,
                           mgmt_update_template_data_map map,
                           mgmt_update_operations op,
                           mgmt_templates tmp,
                           mgmt_targets tgt,
                           (SELECT target_guid, target_name
                              FROM mgmt_targets
                             WHERE target_type = MGMT_GLOBAL.G_AGENT_TARGET_TYPE) emd
                     WHERE tgt.target_guid = det.destination_target_guid
                       AND det.agent_guid = emd.target_guid (+)
                       AND dat.operation_guid = det.operation_guid
                       AND dat.operation_guid = op.operation_guid
                       AND dat.data_set_type = 4
                       AND dat.source_target_guid = tmp.template_guid (+)
                       AND dat.data_set_guid = map.data_set_guid
                       AND det.execution_status IN (1,2,6)
                       AND UPPER(tmp.template_name) LIKE l_tmpt_search_str escape '^'
                       AND tgt.target_name = l_tgt_name_internal;
                ELSIF (l_mode_internal = 'past')
                THEN
                    OPEN apply_operation1_cur_out FOR
                    SELECT tmp.template_name as template_name,
                           det.execution_id as execution_id,
                           emd.target_name as agent_name
                      FROM mgmt_update_operations_data dat,
                           mgmt_update_operations_details det,
                           mgmt_update_template_data_map map,
                           mgmt_update_operations op,
                           mgmt_templates tmp,
                           mgmt_targets tgt,
                           (SELECT target_guid, target_name
                              FROM mgmt_targets
                             WHERE target_type = MGMT_GLOBAL.G_AGENT_TARGET_TYPE) emd
                     WHERE tgt.target_guid = det.destination_target_guid
                       AND det.agent_guid = emd.target_guid (+)
                       AND dat.operation_guid = det.operation_guid
                       AND dat.operation_guid = op.operation_guid
                       AND dat.data_set_type = 4
                       AND dat.source_target_guid = tmp.template_guid (+)
                       AND dat.data_set_guid = map.data_set_guid
                       AND det.execution_status IN (3,4,5,8)
                       AND UPPER(tmp.template_name) LIKE l_tmpt_search_str escape '^'
                       AND tgt.target_name = l_tgt_name_internal;
                END IF; -- end of mode
            ELSE -- specific target type
                IF (l_mode_internal = 'pending')
                THEN
                    OPEN apply_operation1_cur_out FOR
                    SELECT tmp.template_name as template_name,
                           det.execution_id as execution_id,
                           emd.target_name as agent_name
                      FROM mgmt_update_operations_data dat,
                           mgmt_update_operations_details det,
                           mgmt_update_template_data_map map,
                           mgmt_update_operations op,
                           mgmt_templates tmp,
                           mgmt_targets tgt,
                           (SELECT target_guid, target_name
                              FROM mgmt_targets
                             WHERE target_type = MGMT_GLOBAL.G_AGENT_TARGET_TYPE) emd
                     WHERE tgt.target_guid = det.destination_target_guid
                       AND det.agent_guid = emd.target_guid (+)
                       AND dat.operation_guid = det.operation_guid
                       AND dat.operation_guid = op.operation_guid
                       AND dat.data_set_type = 4
                       AND dat.source_target_guid = tmp.template_guid (+)
                       AND dat.data_set_guid = map.data_set_guid
                       AND det.execution_status IN (1,2,6)
                       AND tgt.target_type = l_tgt_type_internal
                       AND UPPER(tmp.template_name) LIKE l_tmpt_search_str escape '^'
                       AND tgt.target_name = l_tgt_name_internal;
                ELSIF (l_mode_internal = 'past')
                THEN
                    OPEN apply_operation1_cur_out FOR
                    SELECT tmp.template_name as template_name,
                           det.execution_id as execution_id,
                           emd.target_name as agent_name
                      FROM mgmt_update_operations_data dat,
                           mgmt_update_operations_details det,
                           mgmt_update_template_data_map map,
                           mgmt_update_operations op,
                           mgmt_templates tmp,
                           mgmt_targets tgt,
                           (SELECT target_guid, target_name
                              FROM mgmt_targets
                             WHERE target_type = MGMT_GLOBAL.G_AGENT_TARGET_TYPE) emd
                     WHERE tgt.target_guid = det.destination_target_guid
                       AND det.agent_guid = emd.target_guid (+)
                       AND dat.operation_guid = det.operation_guid
                       AND dat.operation_guid = op.operation_guid
                       AND dat.data_set_type = 4
                       AND dat.source_target_guid = tmp.template_guid (+)
                       AND dat.data_set_guid = map.data_set_guid
                       AND det.execution_status IN (3,4,5,8)
                       AND tgt.target_type = l_tgt_type_internal
                       AND UPPER(tmp.template_name) LIKE l_tmpt_search_str escape '^'
                       AND tgt.target_name = l_tgt_name_internal;
                END IF;
            END IF; -- end of target type  
        ELSIF ( l_temp_name_op_internal = 0 AND l_tgt_name_op_internal = 0 ) -- template name and tgt name CONTAINS
        THEN
            IF ( l_tgt_type_internal = '%' )
            THEN
                IF (l_mode_internal = 'pending')
                THEN
                    OPEN apply_operation1_cur_out FOR
                    SELECT tmp.template_name as template_name,
                           det.execution_id as execution_id,
                           emd.target_name as agent_name
                      FROM mgmt_update_operations_data dat,
                           mgmt_update_operations_details det,
                           mgmt_update_template_data_map map,
                           mgmt_update_operations op,
                           mgmt_templates tmp,
                           mgmt_targets tgt,
                           (SELECT target_guid, target_name
                              FROM mgmt_targets
                             WHERE target_type = MGMT_GLOBAL.G_AGENT_TARGET_TYPE) emd
                     WHERE tgt.target_guid = det.destination_target_guid
                       AND det.agent_guid = emd.target_guid (+)
                       AND dat.operation_guid = det.operation_guid
                       AND dat.operation_guid = op.operation_guid
                       AND dat.data_set_type = 4
                       AND dat.source_target_guid = tmp.template_guid (+)
                       AND dat.data_set_guid = map.data_set_guid
                       AND det.execution_status IN (1,2,6)
                       AND UPPER(tmp.template_name) LIKE l_tmpt_search_str escape '^'
                       AND UPPER(tgt.target_name) LIKE l_tgt_search_str escape '^';
                ELSIF (l_mode_internal = 'past')
                THEN
                    OPEN apply_operation1_cur_out FOR
                    SELECT tmp.template_name as template_name,
                           det.execution_id as execution_id,
                           emd.target_name as agent_name
                      FROM mgmt_update_operations_data dat,
                           mgmt_update_operations_details det,
                           mgmt_update_template_data_map map,
                           mgmt_update_operations op,
                           mgmt_templates tmp,
                           mgmt_targets tgt,
                           (SELECT target_guid, target_name
                              FROM mgmt_targets
                             WHERE target_type = MGMT_GLOBAL.G_AGENT_TARGET_TYPE) emd
                     WHERE tgt.target_guid = det.destination_target_guid
                       AND det.agent_guid = emd.target_guid (+)
                       AND dat.operation_guid = det.operation_guid
                       AND dat.operation_guid = op.operation_guid
                       AND dat.data_set_type = 4
                       AND dat.source_target_guid = tmp.template_guid (+)
                       AND dat.data_set_guid = map.data_set_guid
                       AND det.execution_status IN (3,4,5,8)
                       AND UPPER(tmp.template_name) LIKE l_tmpt_search_str escape '^'
                       AND UPPER(tgt.target_name) LIKE l_tgt_search_str escape '^';
                END IF; -- end of mode
            ELSE -- specific target type
                IF (l_mode_internal = 'pending')
                THEN
                    OPEN apply_operation1_cur_out FOR
                    SELECT tmp.template_name as template_name,
                           det.execution_id as execution_id,
                           emd.target_name as agent_name
                      FROM mgmt_update_operations_data dat,
                           mgmt_update_operations_details det,
                           mgmt_update_template_data_map map,
                           mgmt_update_operations op,
                           mgmt_templates tmp,
                           mgmt_targets tgt,
                           (SELECT target_guid, target_name
                              FROM mgmt_targets
                             WHERE target_type = MGMT_GLOBAL.G_AGENT_TARGET_TYPE) emd
                     WHERE tgt.target_guid = det.destination_target_guid
                       AND det.agent_guid = emd.target_guid (+)
                       AND dat.operation_guid = det.operation_guid
                       AND dat.operation_guid = op.operation_guid
                       AND dat.data_set_type = 4
                       AND dat.source_target_guid = tmp.template_guid (+)
                       AND dat.data_set_guid = map.data_set_guid
                       AND det.execution_status IN (1,2,6)
                       AND tgt.target_type = l_tgt_type_internal
                       AND UPPER(tmp.template_name) LIKE l_tmpt_search_str escape '^'
                       AND UPPER(tgt.target_name) LIKE l_tgt_search_str escape '^';
                ELSIF (l_mode_internal = 'past')
                THEN
                    OPEN apply_operation1_cur_out FOR
                    SELECT tmp.template_name as template_name,
                           det.execution_id as execution_id,
                           emd.target_name as agent_name
                      FROM mgmt_update_operations_data dat,
                           mgmt_update_operations_details det,
                           mgmt_update_template_data_map map,
                           mgmt_update_operations op,
                           mgmt_templates tmp,
                           mgmt_targets tgt,
                           (SELECT target_guid, target_name
                              FROM mgmt_targets
                             WHERE target_type = MGMT_GLOBAL.G_AGENT_TARGET_TYPE) emd
                     WHERE tgt.target_guid = det.destination_target_guid
                       AND det.agent_guid = emd.target_guid (+)
                       AND dat.operation_guid = det.operation_guid
                       AND dat.operation_guid = op.operation_guid
                       AND dat.data_set_type = 4
                       AND dat.source_target_guid = tmp.template_guid (+)
                       AND dat.data_set_guid = map.data_set_guid
                       AND det.execution_status IN (3,4,5,8)
                       AND tgt.target_type = l_tgt_type_internal
                       AND UPPER(tmp.template_name) LIKE l_tmpt_search_str escape '^'
                       AND UPPER(tgt.target_name) LIKE l_tgt_search_str escape '^';
                END IF;
            END IF; -- end of target type 
        END IF;
    END IF; -- tgt name and tmpl name checks  
  
   -- Revert back to being the same user as we entered
   SETEMUSERCONTEXT(l_current_user, MGMT_USER.OP_SET_IDENTIFIER);    
   
   -- Now for each execution_id, get the rest of the apply operation info 
   -- (destination target and type, user who applied the template and when it
   -- was applied, status of the job and error messsage if any). We will only
   -- retrieve relevant data (for example, targets on which the user has at
   -- least View Privilege)

    IF (l_temp_name_internal IS NULL AND l_tgt_name_internal IS NULL)
    THEN
        IF ( l_tgt_type_internal = '%' )
        THEN
            IF (l_mode_internal = 'pending')
            THEN
                OPEN apply_operation2_cur_out FOR
                SELECT tmp.template_name as template_name,
                       det.destination_target_guid,
                       det.execution_status as execution_status,
                       det.error_message as error_message,
                       det.execution_id as execution_id,
                       tgt.target_name as target_name,
                       tgt.target_type as target_type,
                       emd.target_name as agent_name,
                       map.template_copy_guid as template_copy_guid,
                       op.job_owner as job_owner,
                       op.submission_timestamp as submission_timestamp
                  FROM mgmt_update_operations_data dat,
                       mgmt_update_operations_details det,
                       mgmt_update_template_data_map map,
                       mgmt_update_operations op,
                       mgmt_templates tmp,
                       mgmt_targets tgt,
                       (SELECT target_guid, target_name
                          FROM mgmt_targets
                         WHERE target_type = MGMT_GLOBAL.G_AGENT_TARGET_TYPE) emd
                 WHERE tgt.target_guid = det.destination_target_guid
                   AND det.agent_guid = emd.target_guid (+)
                   AND dat.operation_guid = det.operation_guid
                   AND dat.operation_guid = op.operation_guid
                   AND dat.data_set_type = 4
                   AND dat.source_target_guid = tmp.template_guid (+)
                   AND dat.data_set_guid = map.data_set_guid
                   AND det.execution_status IN (1,2,6);
            ELSIF (l_mode_internal = 'past')
            THEN
                OPEN apply_operation2_cur_out FOR
                SELECT tmp.template_name as template_name,
                       det.destination_target_guid,
                       det.execution_status as execution_status,
                       det.error_message as error_message,
                       det.execution_id as execution_id,
                       tgt.target_name as target_name,
                       tgt.target_type as target_type,
                       emd.target_name as agent_name,
                       map.template_copy_guid as template_copy_guid,
                       op.job_owner as job_owner,
                       op.submission_timestamp as submission_timestamp
                  FROM mgmt_update_operations_data dat,
                       mgmt_update_operations_details det,
                       mgmt_update_template_data_map map,
                       mgmt_update_operations op,
                       mgmt_templates tmp,
                       mgmt_targets tgt,
                       (SELECT target_guid, target_name
                          FROM mgmt_targets
                         WHERE target_type = MGMT_GLOBAL.G_AGENT_TARGET_TYPE) emd
                 WHERE tgt.target_guid = det.destination_target_guid
                   AND det.agent_guid = emd.target_guid (+)
                   AND dat.operation_guid = det.operation_guid
                   AND dat.operation_guid = op.operation_guid
                   AND dat.data_set_type = 4
                   AND dat.source_target_guid = tmp.template_guid (+)
                   AND dat.data_set_guid = map.data_set_guid
                   AND det.execution_status IN (3,4,5,8);
            END IF;
        ELSE
            IF (l_mode_internal = 'pending')
            THEN
                OPEN apply_operation2_cur_out FOR
                SELECT tmp.template_name as template_name,
                       det.destination_target_guid,
                       det.execution_status as execution_status,
                       det.error_message as error_message,
                       det.execution_id as execution_id,
                       tgt.target_name as target_name,
                       tgt.target_type as target_type,
                       emd.target_name as agent_name,
                       map.template_copy_guid as template_copy_guid,
                       op.job_owner as job_owner,
                       op.submission_timestamp as submission_timestamp
                  FROM mgmt_update_operations_data dat,
                       mgmt_update_operations_details det,
                       mgmt_update_template_data_map map,
                       mgmt_update_operations op,
                       mgmt_templates tmp,
                       mgmt_targets tgt,
                       (SELECT target_guid, target_name
                          FROM mgmt_targets
                         WHERE target_type = MGMT_GLOBAL.G_AGENT_TARGET_TYPE) emd
                 WHERE tgt.target_guid = det.destination_target_guid
                   AND det.agent_guid = emd.target_guid (+)
                   AND dat.operation_guid = det.operation_guid
                   AND dat.operation_guid = op.operation_guid
                   AND dat.data_set_type = 4
                   AND dat.source_target_guid = tmp.template_guid (+)
                   AND dat.data_set_guid = map.data_set_guid
                   AND det.execution_status IN (1,2,6)
                   AND tgt.target_type = l_tgt_type_internal;
            ELSIF (l_mode_internal = 'past')
            THEN
                OPEN apply_operation2_cur_out FOR
                SELECT tmp.template_name as template_name,
                       det.destination_target_guid,
                       det.execution_status as execution_status,
                       det.error_message as error_message,
                       det.execution_id as execution_id,
                       tgt.target_name as target_name,
                       tgt.target_type as target_type,
                       emd.target_name as agent_name,
                       map.template_copy_guid as template_copy_guid,
                       op.job_owner as job_owner,
                       op.submission_timestamp as submission_timestamp
                  FROM mgmt_update_operations_data dat,
                       mgmt_update_operations_details det,
                       mgmt_update_template_data_map map,
                       mgmt_update_operations op,
                       mgmt_templates tmp,
                       mgmt_targets tgt,
                       (SELECT target_guid, target_name
                          FROM mgmt_targets
                         WHERE target_type = MGMT_GLOBAL.G_AGENT_TARGET_TYPE) emd
                 WHERE tgt.target_guid = det.destination_target_guid
                   AND det.agent_guid = emd.target_guid (+)
                   AND dat.operation_guid = det.operation_guid
                   AND dat.operation_guid = op.operation_guid
                   AND dat.data_set_type = 4
                   AND dat.source_target_guid = tmp.template_guid (+)
                   AND dat.data_set_guid = map.data_set_guid
                   AND det.execution_status IN (3,4,5,8)
                   AND tgt.target_type = l_tgt_type_internal;
            END IF;
        END IF;
    ELSIF (l_temp_name_internal IS NULL AND l_tgt_name_internal IS NOT NULL)
    THEN
        IF (l_tgt_name_op_internal = 1) -- IS_EXACTLY
        THEN
            IF ( l_tgt_type_internal = '%' )
            THEN
                IF (l_mode_internal = 'pending')
                THEN
                    OPEN apply_operation2_cur_out FOR
                    SELECT tmp.template_name as template_name,
                           det.destination_target_guid,
                           det.execution_status as execution_status,
                           det.error_message as error_message,
                           det.execution_id as execution_id,
                           tgt.target_name as target_name,
                           tgt.target_type as target_type,
                           emd.target_name as agent_name,
                           map.template_copy_guid as template_copy_guid,
                           op.job_owner as job_owner,
                           op.submission_timestamp as submission_timestamp
                      FROM mgmt_update_operations_data dat,
                           mgmt_update_operations_details det,
                           mgmt_update_template_data_map map,
                           mgmt_update_operations op,
                           mgmt_templates tmp,
                           mgmt_targets tgt,
                           (SELECT target_guid, target_name
                              FROM mgmt_targets
                             WHERE target_type = MGMT_GLOBAL.G_AGENT_TARGET_TYPE) emd
                     WHERE tgt.target_guid = det.destination_target_guid
                       AND det.agent_guid = emd.target_guid (+)
                       AND dat.operation_guid = det.operation_guid
                       AND dat.operation_guid = op.operation_guid
                       AND dat.data_set_type = 4
                       AND dat.source_target_guid = tmp.template_guid (+)
                       AND dat.data_set_guid = map.data_set_guid
                       AND det.execution_status IN (1,2,6)
                       AND tgt.target_name = l_tgt_name_internal;
                ELSIF (l_mode_internal = 'past')
                THEN
                    OPEN apply_operation2_cur_out FOR
                    SELECT tmp.template_name as template_name,
                           det.destination_target_guid,
                           det.execution_status as execution_status,
                           det.error_message as error_message,
                           det.execution_id as execution_id,
                           tgt.target_name as target_name,
                           tgt.target_type as target_type,
                           emd.target_name as agent_name,
                           map.template_copy_guid as template_copy_guid,
                           op.job_owner as job_owner,
                           op.submission_timestamp as submission_timestamp
                      FROM mgmt_update_operations_data dat,
                           mgmt_update_operations_details det,
                           mgmt_update_template_data_map map,
                           mgmt_update_operations op,
                           mgmt_templates tmp,
                           mgmt_targets tgt,
                           (SELECT target_guid, target_name
                              FROM mgmt_targets
                             WHERE target_type = MGMT_GLOBAL.G_AGENT_TARGET_TYPE) emd
                     WHERE tgt.target_guid = det.destination_target_guid
                       AND det.agent_guid = emd.target_guid (+)
                       AND dat.operation_guid = det.operation_guid
                       AND dat.operation_guid = op.operation_guid
                       AND dat.data_set_type = 4
                       AND dat.source_target_guid = tmp.template_guid (+)
                       AND dat.data_set_guid = map.data_set_guid
                       AND det.execution_status IN (3,4,5,8)
                       AND tgt.target_name = l_tgt_name_internal;
                END IF; -- end of mode
            ELSE -- specific target type
                IF (l_mode_internal = 'pending')
                THEN
                    OPEN apply_operation2_cur_out FOR
                    SELECT tmp.template_name as template_name,
                           det.destination_target_guid,
                           det.execution_status as execution_status,
                           det.error_message as error_message,
                           det.execution_id as execution_id,
                           tgt.target_name as target_name,
                           tgt.target_type as target_type,
                           emd.target_name as agent_name,
                           map.template_copy_guid as template_copy_guid,
                           op.job_owner as job_owner,
                           op.submission_timestamp as submission_timestamp
                      FROM mgmt_update_operations_data dat,
                           mgmt_update_operations_details det,
                           mgmt_update_template_data_map map,
                           mgmt_update_operations op,
                           mgmt_templates tmp,
                           mgmt_targets tgt,
                           (SELECT target_guid, target_name
                              FROM mgmt_targets
                             WHERE target_type = MGMT_GLOBAL.G_AGENT_TARGET_TYPE) emd
                     WHERE tgt.target_guid = det.destination_target_guid
                       AND det.agent_guid = emd.target_guid (+)
                       AND dat.operation_guid = det.operation_guid
                       AND dat.operation_guid = op.operation_guid
                       AND dat.data_set_type = 4
                       AND dat.source_target_guid = tmp.template_guid (+)
                       AND dat.data_set_guid = map.data_set_guid
                       AND det.execution_status IN (1,2,6)
                       AND tgt.target_type = l_tgt_type_internal
                       AND tgt.target_name = l_tgt_name_internal;
                ELSIF (l_mode_internal = 'past')
                THEN
                    OPEN apply_operation2_cur_out FOR
                    SELECT tmp.template_name as template_name,
                           det.destination_target_guid,
                           det.execution_status as execution_status,
                           det.error_message as error_message,
                           det.execution_id as execution_id,
                           tgt.target_name as target_name,
                           tgt.target_type as target_type,
                           emd.target_name as agent_name,
                           map.template_copy_guid as template_copy_guid,
                           op.job_owner as job_owner,
                           op.submission_timestamp as submission_timestamp
                      FROM mgmt_update_operations_data dat,
                           mgmt_update_operations_details det,
                           mgmt_update_template_data_map map,
                           mgmt_update_operations op,
                           mgmt_templates tmp,
                           mgmt_targets tgt,
                           (SELECT target_guid, target_name
                              FROM mgmt_targets
                             WHERE target_type = MGMT_GLOBAL.G_AGENT_TARGET_TYPE) emd
                     WHERE tgt.target_guid = det.destination_target_guid
                       AND det.agent_guid = emd.target_guid (+)
                       AND dat.operation_guid = det.operation_guid
                       AND dat.operation_guid = op.operation_guid
                       AND dat.data_set_type = 4
                       AND dat.source_target_guid = tmp.template_guid (+)
                       AND dat.data_set_guid = map.data_set_guid
                       AND det.execution_status IN (3,4,5,8)
                       AND tgt.target_type = l_tgt_type_internal
                       AND tgt.target_name = l_tgt_name_internal;
                END IF;
            END IF; -- end of target type
        ELSIF (l_tgt_name_op_internal = 0) -- CONTAINS
        THEN
            IF ( l_tgt_type_internal = '%' )
            THEN
                IF (l_mode_internal = 'pending')
                THEN
                    OPEN apply_operation2_cur_out FOR
                    SELECT tmp.template_name as template_name,
                           det.destination_target_guid,
                           det.execution_status as execution_status,
                           det.error_message as error_message,
                           det.execution_id as execution_id,
                           tgt.target_name as target_name,
                           tgt.target_type as target_type,
                           emd.target_name as agent_name,
                           map.template_copy_guid as template_copy_guid,
                           op.job_owner as job_owner,
                           op.submission_timestamp as submission_timestamp
                      FROM mgmt_update_operations_data dat,
                           mgmt_update_operations_details det,
                           mgmt_update_template_data_map map,
                           mgmt_update_operations op,
                           mgmt_templates tmp,
                           mgmt_targets tgt,
                           (SELECT target_guid, target_name
                              FROM mgmt_targets
                             WHERE target_type = MGMT_GLOBAL.G_AGENT_TARGET_TYPE) emd
                     WHERE tgt.target_guid = det.destination_target_guid
                       AND det.agent_guid = emd.target_guid (+)
                       AND dat.operation_guid = det.operation_guid
                       AND dat.operation_guid = op.operation_guid
                       AND dat.data_set_type = 4
                       AND dat.source_target_guid = tmp.template_guid (+)
                       AND dat.data_set_guid = map.data_set_guid
                       AND det.execution_status IN (1,2,6)
                       AND UPPER(tgt.target_name) LIKE l_tgt_search_str escape '^';
                ELSIF (l_mode_internal = 'past')
                THEN
                    OPEN apply_operation2_cur_out FOR
                    SELECT tmp.template_name as template_name,
                           det.destination_target_guid,
                           det.execution_status as execution_status,
                           det.error_message as error_message,
                           det.execution_id as execution_id,
                           tgt.target_name as target_name,
                           tgt.target_type as target_type,
                           emd.target_name as agent_name,
                           map.template_copy_guid as template_copy_guid,
                           op.job_owner as job_owner,
                           op.submission_timestamp as submission_timestamp
                      FROM mgmt_update_operations_data dat,
                           mgmt_update_operations_details det,
                           mgmt_update_template_data_map map,
                           mgmt_update_operations op,
                           mgmt_templates tmp,
                           mgmt_targets tgt,
                           (SELECT target_guid, target_name
                              FROM mgmt_targets
                             WHERE target_type = MGMT_GLOBAL.G_AGENT_TARGET_TYPE) emd
                     WHERE tgt.target_guid = det.destination_target_guid
                       AND det.agent_guid = emd.target_guid (+)
                       AND dat.operation_guid = det.operation_guid
                       AND dat.operation_guid = op.operation_guid
                       AND dat.data_set_type = 4
                       AND dat.source_target_guid = tmp.template_guid (+)
                       AND dat.data_set_guid = map.data_set_guid
                       AND det.execution_status IN (3,4,5,8)
                       AND UPPER(tgt.target_name) LIKE l_tgt_search_str escape '^';
                END IF; -- end of mode
            ELSE -- specific target type
                IF (l_mode_internal = 'pending')
                THEN
                    OPEN apply_operation2_cur_out FOR
                    SELECT tmp.template_name as template_name,
                           det.destination_target_guid,
                           det.execution_status as execution_status,
                           det.error_message as error_message,
                           det.execution_id as execution_id,
                           tgt.target_name as target_name,
                           tgt.target_type as target_type,
                           emd.target_name as agent_name,
                           map.template_copy_guid as template_copy_guid,
                           op.job_owner as job_owner,
                           op.submission_timestamp as submission_timestamp
                      FROM mgmt_update_operations_data dat,
                           mgmt_update_operations_details det,
                           mgmt_update_template_data_map map,
                           mgmt_update_operations op,
                           mgmt_templates tmp,
                           mgmt_targets tgt,
                           (SELECT target_guid, target_name
                              FROM mgmt_targets
                             WHERE target_type = MGMT_GLOBAL.G_AGENT_TARGET_TYPE) emd
                     WHERE tgt.target_guid = det.destination_target_guid
                       AND det.agent_guid = emd.target_guid (+)
                       AND dat.operation_guid = det.operation_guid
                       AND dat.operation_guid = op.operation_guid
                       AND dat.data_set_type = 4
                       AND dat.source_target_guid = tmp.template_guid (+)
                       AND dat.data_set_guid = map.data_set_guid
                       AND det.execution_status IN (1,2,6)
                       AND tgt.target_type = l_tgt_type_internal
                       AND UPPER(tgt.target_name) LIKE l_tgt_search_str escape '^';
                ELSIF (l_mode_internal = 'past')
                THEN
                    OPEN apply_operation2_cur_out FOR
                    SELECT tmp.template_name as template_name,
                           det.destination_target_guid,
                           det.execution_status as execution_status,
                           det.error_message as error_message,
                           det.execution_id as execution_id,
                           tgt.target_name as target_name,
                           tgt.target_type as target_type,
                           emd.target_name as agent_name,
                           map.template_copy_guid as template_copy_guid,
                           op.job_owner as job_owner,
                           op.submission_timestamp as submission_timestamp
                      FROM mgmt_update_operations_data dat,
                           mgmt_update_operations_details det,
                           mgmt_update_template_data_map map,
                           mgmt_update_operations op,
                           mgmt_templates tmp,
                           mgmt_targets tgt,
                           (SELECT target_guid, target_name
                              FROM mgmt_targets
                             WHERE target_type = MGMT_GLOBAL.G_AGENT_TARGET_TYPE) emd
                     WHERE tgt.target_guid = det.destination_target_guid
                       AND det.agent_guid = emd.target_guid (+)
                       AND dat.operation_guid = det.operation_guid
                       AND dat.operation_guid = op.operation_guid
                       AND dat.data_set_type = 4
                       AND dat.source_target_guid = tmp.template_guid (+)
                       AND dat.data_set_guid = map.data_set_guid
                       AND det.execution_status IN (3,4,5,8)
                       AND tgt.target_type = l_tgt_type_internal
                       AND UPPER(tgt.target_name) LIKE l_tgt_search_str escape '^';
                END IF;
            END IF; -- end of target type
        END IF; -- end of tgt operator
    ELSIF ( l_temp_name_internal IS NOT NULL AND l_tgt_name_internal IS NULL )
    THEN
        IF ( l_temp_name_op_internal = 1) -- IS_EXACTLY
        THEN
            IF ( l_tgt_type_internal = '%' )
            THEN
                IF (l_mode_internal = 'pending')
                THEN
                    OPEN apply_operation2_cur_out FOR
                    SELECT tmp.template_name as template_name,
                           det.destination_target_guid,
                           det.execution_status as execution_status,
                           det.error_message as error_message,
                           det.execution_id as execution_id,
                           tgt.target_name as target_name,
                           tgt.target_type as target_type,
                           emd.target_name as agent_name,
                           map.template_copy_guid as template_copy_guid,
                           op.job_owner as job_owner,
                           op.submission_timestamp as submission_timestamp
                      FROM mgmt_update_operations_data dat,
                           mgmt_update_operations_details det,
                           mgmt_update_template_data_map map,
                           mgmt_update_operations op,
                           mgmt_templates tmp,
                           mgmt_targets tgt,
                           (SELECT target_guid, target_name
                              FROM mgmt_targets
                             WHERE target_type = MGMT_GLOBAL.G_AGENT_TARGET_TYPE) emd
                     WHERE tgt.target_guid = det.destination_target_guid
                       AND det.agent_guid = emd.target_guid (+)
                       AND dat.operation_guid = det.operation_guid
                       AND dat.operation_guid = op.operation_guid
                       AND dat.data_set_type = 4
                       AND dat.source_target_guid = tmp.template_guid (+)
                       AND dat.data_set_guid = map.data_set_guid
                       AND det.execution_status IN (1,2,6)
                       AND tmp.template_name = l_temp_name_internal;
                ELSIF (l_mode_internal = 'past')
                THEN
                    OPEN apply_operation2_cur_out FOR
                    SELECT tmp.template_name as template_name,
                           det.destination_target_guid,
                           det.execution_status as execution_status,
                           det.error_message as error_message,
                           det.execution_id as execution_id,
                           tgt.target_name as target_name,
                           tgt.target_type as target_type,
                           emd.target_name as agent_name,
                           map.template_copy_guid as template_copy_guid,
                           op.job_owner as job_owner,
                           op.submission_timestamp as submission_timestamp
                      FROM mgmt_update_operations_data dat,
                           mgmt_update_operations_details det,
                           mgmt_update_template_data_map map,
                           mgmt_update_operations op,
                           mgmt_templates tmp,
                           mgmt_targets tgt,
                           (SELECT target_guid, target_name
                              FROM mgmt_targets
                             WHERE target_type = MGMT_GLOBAL.G_AGENT_TARGET_TYPE) emd
                     WHERE tgt.target_guid = det.destination_target_guid
                       AND det.agent_guid = emd.target_guid (+)
                       AND dat.operation_guid = det.operation_guid
                       AND dat.operation_guid = op.operation_guid
                       AND dat.data_set_type = 4
                       AND dat.source_target_guid = tmp.template_guid (+)
                       AND dat.data_set_guid = map.data_set_guid
                       AND det.execution_status IN (3,4,5,8)
                       AND tmp.template_name = l_temp_name_internal;
                END IF; -- end of mode
            ELSE -- specific target type
                IF (l_mode_internal = 'pending')
                THEN
                    OPEN apply_operation2_cur_out FOR
                    SELECT tmp.template_name as template_name,
                           det.destination_target_guid,
                           det.execution_status as execution_status,
                           det.error_message as error_message,
                           det.execution_id as execution_id,
                           tgt.target_name as target_name,
                           tgt.target_type as target_type,
                           emd.target_name as agent_name,
                           map.template_copy_guid as template_copy_guid,
                           op.job_owner as job_owner,
                           op.submission_timestamp as submission_timestamp
                      FROM mgmt_update_operations_data dat,
                           mgmt_update_operations_details det,
                           mgmt_update_template_data_map map,
                           mgmt_update_operations op,
                           mgmt_templates tmp,
                           mgmt_targets tgt,
                           (SELECT target_guid, target_name
                              FROM mgmt_targets
                             WHERE target_type = MGMT_GLOBAL.G_AGENT_TARGET_TYPE) emd
                     WHERE tgt.target_guid = det.destination_target_guid
                       AND det.agent_guid = emd.target_guid (+)
                       AND dat.operation_guid = det.operation_guid
                       AND dat.operation_guid = op.operation_guid
                       AND dat.data_set_type = 4
                       AND dat.source_target_guid = tmp.template_guid (+)
                       AND dat.data_set_guid = map.data_set_guid
                       AND det.execution_status IN (1,2,6)
                       AND tgt.target_type = l_tgt_type_internal
                       AND tmp.template_name = l_temp_name_internal;
                ELSIF (l_mode_internal = 'past')
                THEN
                    OPEN apply_operation2_cur_out FOR
                    SELECT tmp.template_name as template_name,
                           det.destination_target_guid,
                           det.execution_status as execution_status,
                           det.error_message as error_message,
                           det.execution_id as execution_id,
                           tgt.target_name as target_name,
                           tgt.target_type as target_type,
                           emd.target_name as agent_name,
                           map.template_copy_guid as template_copy_guid,
                           op.job_owner as job_owner,
                           op.submission_timestamp as submission_timestamp
                      FROM mgmt_update_operations_data dat,
                           mgmt_update_operations_details det,
                           mgmt_update_template_data_map map,
                           mgmt_update_operations op,
                           mgmt_templates tmp,
                           mgmt_targets tgt,
                           (SELECT target_guid, target_name
                              FROM mgmt_targets
                             WHERE target_type = MGMT_GLOBAL.G_AGENT_TARGET_TYPE) emd
                     WHERE tgt.target_guid = det.destination_target_guid
                       AND det.agent_guid = emd.target_guid (+)
                       AND dat.operation_guid = det.operation_guid
                       AND dat.operation_guid = op.operation_guid
                       AND dat.data_set_type = 4
                       AND dat.source_target_guid = tmp.template_guid (+)
                       AND dat.data_set_guid = map.data_set_guid
                       AND det.execution_status IN (3,4,5,8)
                       AND tgt.target_type = l_tgt_type_internal
                       AND tmp.template_name = l_temp_name_internal;
                END IF;
            END IF; -- end of target type
        ELSIF ( l_temp_name_op_internal = 0) -- CONTAINS
        THEN
            IF ( l_tgt_type_internal = '%' )
            THEN
                IF (l_mode_internal = 'pending')
                THEN
                    OPEN apply_operation2_cur_out FOR
                    SELECT tmp.template_name as template_name,
                           det.destination_target_guid,
                           det.execution_status as execution_status,
                           det.error_message as error_message,
                           det.execution_id as execution_id,
                           tgt.target_name as target_name,
                           tgt.target_type as target_type,
                           emd.target_name as agent_name,
                           map.template_copy_guid as template_copy_guid,
                           op.job_owner as job_owner,
                           op.submission_timestamp as submission_timestamp
                      FROM mgmt_update_operations_data dat,
                           mgmt_update_operations_details det,
                           mgmt_update_template_data_map map,
                           mgmt_update_operations op,
                           mgmt_templates tmp,
                           mgmt_targets tgt,
                           (SELECT target_guid, target_name
                              FROM mgmt_targets
                             WHERE target_type = MGMT_GLOBAL.G_AGENT_TARGET_TYPE) emd
                     WHERE tgt.target_guid = det.destination_target_guid
                       AND det.agent_guid = emd.target_guid (+)
                       AND dat.operation_guid = det.operation_guid
                       AND dat.operation_guid = op.operation_guid
                       AND dat.data_set_type = 4
                       AND dat.source_target_guid = tmp.template_guid (+)
                       AND dat.data_set_guid = map.data_set_guid
                       AND det.execution_status IN (1,2,6)
                       AND UPPER(tmp.template_name) LIKE l_tmpt_search_str escape '^';
                ELSIF (l_mode_internal = 'past')
                THEN
                    OPEN apply_operation2_cur_out FOR
                    SELECT tmp.template_name as template_name,
                           det.destination_target_guid,
                           det.execution_status as execution_status,
                           det.error_message as error_message,
                           det.execution_id as execution_id,
                           tgt.target_name as target_name,
                           tgt.target_type as target_type,
                           emd.target_name as agent_name,
                           map.template_copy_guid as template_copy_guid,
                           op.job_owner as job_owner,
                           op.submission_timestamp as submission_timestamp
                      FROM mgmt_update_operations_data dat,
                           mgmt_update_operations_details det,
                           mgmt_update_template_data_map map,
                           mgmt_update_operations op,
                           mgmt_templates tmp,
                           mgmt_targets tgt,
                           (SELECT target_guid, target_name
                              FROM mgmt_targets
                             WHERE target_type = MGMT_GLOBAL.G_AGENT_TARGET_TYPE) emd
                     WHERE tgt.target_guid = det.destination_target_guid
                       AND det.agent_guid = emd.target_guid (+)
                       AND dat.operation_guid = det.operation_guid
                       AND dat.operation_guid = op.operation_guid
                       AND dat.data_set_type = 4
                       AND dat.source_target_guid = tmp.template_guid (+)
                       AND dat.data_set_guid = map.data_set_guid
                       AND det.execution_status IN (3,4,5,8)
                       AND UPPER(tmp.template_name) LIKE l_tmpt_search_str escape '^';
                END IF; -- end of mode
            ELSE -- specific target type
                IF (l_mode_internal = 'pending')
                THEN
                    OPEN apply_operation2_cur_out FOR
                    SELECT tmp.template_name as template_name,
                           det.destination_target_guid,
                           det.execution_status as execution_status,
                           det.error_message as error_message,
                           det.execution_id as execution_id,
                           tgt.target_name as target_name,
                           tgt.target_type as target_type,
                           emd.target_name as agent_name,
                           map.template_copy_guid as template_copy_guid,
                           op.job_owner as job_owner,
                           op.submission_timestamp as submission_timestamp
                      FROM mgmt_update_operations_data dat,
                           mgmt_update_operations_details det,
                           mgmt_update_template_data_map map,
                           mgmt_update_operations op,
                           mgmt_templates tmp,
                           mgmt_targets tgt,
                           (SELECT target_guid, target_name
                              FROM mgmt_targets
                             WHERE target_type = MGMT_GLOBAL.G_AGENT_TARGET_TYPE) emd
                     WHERE tgt.target_guid = det.destination_target_guid
                       AND det.agent_guid = emd.target_guid (+)
                       AND dat.operation_guid = det.operation_guid
                       AND dat.operation_guid = op.operation_guid
                       AND dat.data_set_type = 4
                       AND dat.source_target_guid = tmp.template_guid (+)
                       AND dat.data_set_guid = map.data_set_guid
                       AND det.execution_status IN (1,2,6)
                       AND tgt.target_type = l_tgt_type_internal
                       AND UPPER(tmp.template_name) LIKE l_tmpt_search_str escape '^';
                ELSIF (l_mode_internal = 'past')
                THEN
                    OPEN apply_operation2_cur_out FOR
                    SELECT tmp.template_name as template_name,
                           det.destination_target_guid,
                           det.execution_status as execution_status,
                           det.error_message as error_message,
                           det.execution_id as execution_id,
                           tgt.target_name as target_name,
                           tgt.target_type as target_type,
                           emd.target_name as agent_name,
                           map.template_copy_guid as template_copy_guid,
                           op.job_owner as job_owner,
                           op.submission_timestamp as submission_timestamp
                      FROM mgmt_update_operations_data dat,
                           mgmt_update_operations_details det,
                           mgmt_update_template_data_map map,
                           mgmt_update_operations op,
                           mgmt_templates tmp,
                           mgmt_targets tgt,
                           (SELECT target_guid, target_name
                              FROM mgmt_targets
                             WHERE target_type = MGMT_GLOBAL.G_AGENT_TARGET_TYPE) emd
                     WHERE tgt.target_guid = det.destination_target_guid
                       AND det.agent_guid = emd.target_guid (+)
                       AND dat.operation_guid = det.operation_guid
                       AND dat.operation_guid = op.operation_guid
                       AND dat.data_set_type = 4
                       AND dat.source_target_guid = tmp.template_guid (+)
                       AND dat.data_set_guid = map.data_set_guid
                       AND det.execution_status IN (3,4,5,8)
                       AND tgt.target_type = l_tgt_type_internal
                       AND UPPER(tmp.template_name) LIKE l_tmpt_search_str escape '^';
                END IF;
            END IF; -- end of target type
        END IF; -- end of tgt operator
    ELSIF ( l_temp_name_internal IS NOT NULL AND l_tgt_name_internal IS NOT NULL )
    THEN
        IF ( l_temp_name_op_internal = 1 AND l_tgt_name_op_internal = 1 ) -- template name and tgt name IS_EXACTLY
        THEN
            IF ( l_tgt_type_internal = '%' )
            THEN
                IF (l_mode_internal = 'pending')
                THEN
                    OPEN apply_operation2_cur_out FOR
                    SELECT tmp.template_name as template_name,
                           det.destination_target_guid,
                           det.execution_status as execution_status,
                           det.error_message as error_message,
                           det.execution_id as execution_id,
                           tgt.target_name as target_name,
                           tgt.target_type as target_type,
                           emd.target_name as agent_name,
                           map.template_copy_guid as template_copy_guid,
                           op.job_owner as job_owner,
                           op.submission_timestamp as submission_timestamp
                      FROM mgmt_update_operations_data dat,
                           mgmt_update_operations_details det,
                           mgmt_update_template_data_map map,
                           mgmt_update_operations op,
                           mgmt_templates tmp,
                           mgmt_targets tgt,
                           (SELECT target_guid, target_name
                              FROM mgmt_targets
                             WHERE target_type = MGMT_GLOBAL.G_AGENT_TARGET_TYPE) emd
                     WHERE tgt.target_guid = det.destination_target_guid
                       AND det.agent_guid = emd.target_guid (+)
                       AND dat.operation_guid = det.operation_guid
                       AND dat.operation_guid = op.operation_guid
                       AND dat.data_set_type = 4
                       AND dat.source_target_guid = tmp.template_guid (+)
                       AND dat.data_set_guid = map.data_set_guid
                       AND det.execution_status IN (1,2,6)
                       AND tmp.template_name = l_temp_name_internal
                       AND tgt.target_name = l_tgt_name_internal;
                ELSIF (l_mode_internal = 'past')
                THEN
                    OPEN apply_operation2_cur_out FOR
                    SELECT tmp.template_name as template_name,
                           det.destination_target_guid,
                           det.execution_status as execution_status,
                           det.error_message as error_message,
                           det.execution_id as execution_id,
                           tgt.target_name as target_name,
                           tgt.target_type as target_type,
                           emd.target_name as agent_name,
                           map.template_copy_guid as template_copy_guid,
                           op.job_owner as job_owner,
                           op.submission_timestamp as submission_timestamp
                      FROM mgmt_update_operations_data dat,
                           mgmt_update_operations_details det,
                           mgmt_update_template_data_map map,
                           mgmt_update_operations op,
                           mgmt_templates tmp,
                           mgmt_targets tgt,
                           (SELECT target_guid, target_name
                              FROM mgmt_targets
                             WHERE target_type = MGMT_GLOBAL.G_AGENT_TARGET_TYPE) emd
                     WHERE tgt.target_guid = det.destination_target_guid
                       AND det.agent_guid = emd.target_guid (+)
                       AND dat.operation_guid = det.operation_guid
                       AND dat.operation_guid = op.operation_guid
                       AND dat.data_set_type = 4
                       AND dat.source_target_guid = tmp.template_guid (+)
                       AND dat.data_set_guid = map.data_set_guid
                       AND det.execution_status IN (3,4,5,8)
                       AND tmp.template_name = l_temp_name_internal
                       AND tgt.target_name = l_tgt_name_internal;
                END IF; -- end of mode
            ELSE -- specific target type
                IF (l_mode_internal = 'pending')
                THEN
                    OPEN apply_operation2_cur_out FOR
                    SELECT tmp.template_name as template_name,
                           det.destination_target_guid,
                           det.execution_status as execution_status,
                           det.error_message as error_message,
                           det.execution_id as execution_id,
                           tgt.target_name as target_name,
                           tgt.target_type as target_type,
                           emd.target_name as agent_name,
                           map.template_copy_guid as template_copy_guid,
                           op.job_owner as job_owner,
                           op.submission_timestamp as submission_timestamp
                      FROM mgmt_update_operations_data dat,
                           mgmt_update_operations_details det,
                           mgmt_update_template_data_map map,
                           mgmt_update_operations op,
                           mgmt_templates tmp,
                           mgmt_targets tgt,
                           (SELECT target_guid, target_name
                              FROM mgmt_targets
                             WHERE target_type = MGMT_GLOBAL.G_AGENT_TARGET_TYPE) emd
                     WHERE tgt.target_guid = det.destination_target_guid
                       AND det.agent_guid = emd.target_guid (+)
                       AND dat.operation_guid = det.operation_guid
                       AND dat.operation_guid = op.operation_guid
                       AND dat.data_set_type = 4
                       AND dat.source_target_guid = tmp.template_guid (+)
                       AND dat.data_set_guid = map.data_set_guid
                       AND det.execution_status IN (1,2,6)
                       AND tgt.target_type = l_tgt_type_internal
                       AND tmp.template_name = l_temp_name_internal
                       AND tgt.target_name = l_tgt_name_internal;
                ELSIF (l_mode_internal = 'past')
                THEN
                    OPEN apply_operation2_cur_out FOR
                    SELECT tmp.template_name as template_name,
                           det.destination_target_guid,
                           det.execution_status as execution_status,
                           det.error_message as error_message,
                           det.execution_id as execution_id,
                           tgt.target_name as target_name,
                           tgt.target_type as target_type,
                           emd.target_name as agent_name,
                           map.template_copy_guid as template_copy_guid,
                           op.job_owner as job_owner,
                           op.submission_timestamp as submission_timestamp
                      FROM mgmt_update_operations_data dat,
                           mgmt_update_operations_details det,
                           mgmt_update_template_data_map map,
                           mgmt_update_operations op,
                           mgmt_templates tmp,
                           mgmt_targets tgt,
                           (SELECT target_guid, target_name
                              FROM mgmt_targets
                             WHERE target_type = MGMT_GLOBAL.G_AGENT_TARGET_TYPE) emd
                     WHERE tgt.target_guid = det.destination_target_guid
                       AND det.agent_guid = emd.target_guid (+)
                       AND dat.operation_guid = det.operation_guid
                       AND dat.operation_guid = op.operation_guid
                       AND dat.data_set_type = 4
                       AND dat.source_target_guid = tmp.template_guid (+)
                       AND dat.data_set_guid = map.data_set_guid
                       AND det.execution_status IN (3,4,5,8)
                       AND tgt.target_type = l_tgt_type_internal
                       AND tmp.template_name = l_temp_name_internal
                       AND tgt.target_name = l_tgt_name_internal;
                END IF;
            END IF; -- end of target type        
        ELSIF ( l_temp_name_op_internal = 1 AND l_tgt_name_op_internal = 0 ) -- template name IS_EXACTLY and tgt name CONTAINS
        THEN
            IF ( l_tgt_type_internal = '%' )
            THEN
                IF (l_mode_internal = 'pending')
                THEN
                    OPEN apply_operation2_cur_out FOR
                    SELECT tmp.template_name as template_name,
                           det.destination_target_guid,
                           det.execution_status as execution_status,
                           det.error_message as error_message,
                           det.execution_id as execution_id,
                           tgt.target_name as target_name,
                           tgt.target_type as target_type,
                           emd.target_name as agent_name,
                           map.template_copy_guid as template_copy_guid,
                           op.job_owner as job_owner,
                           op.submission_timestamp as submission_timestamp
                      FROM mgmt_update_operations_data dat,
                           mgmt_update_operations_details det,
                           mgmt_update_template_data_map map,
                           mgmt_update_operations op,
                           mgmt_templates tmp,
                           mgmt_targets tgt,
                           (SELECT target_guid, target_name
                              FROM mgmt_targets
                             WHERE target_type = MGMT_GLOBAL.G_AGENT_TARGET_TYPE) emd
                     WHERE tgt.target_guid = det.destination_target_guid
                       AND det.agent_guid = emd.target_guid (+)
                       AND dat.operation_guid = det.operation_guid
                       AND dat.operation_guid = op.operation_guid
                       AND dat.data_set_type = 4
                       AND dat.source_target_guid = tmp.template_guid (+)
                       AND dat.data_set_guid = map.data_set_guid
                       AND det.execution_status IN (1,2,6)
                       AND tmp.template_name = l_temp_name_internal
                       AND UPPER(tgt.target_name) LIKE l_tgt_search_str escape '^';
                ELSIF (l_mode_internal = 'past')
                THEN
                    OPEN apply_operation2_cur_out FOR
                    SELECT tmp.template_name as template_name,
                           det.destination_target_guid,
                           det.execution_status as execution_status,
                           det.error_message as error_message,
                           det.execution_id as execution_id,
                           tgt.target_name as target_name,
                           tgt.target_type as target_type,
                           emd.target_name as agent_name,
                           map.template_copy_guid as template_copy_guid,
                           op.job_owner as job_owner,
                           op.submission_timestamp as submission_timestamp
                      FROM mgmt_update_operations_data dat,
                           mgmt_update_operations_details det,
                           mgmt_update_template_data_map map,
                           mgmt_update_operations op,
                           mgmt_templates tmp,
                           mgmt_targets tgt,
                           (SELECT target_guid, target_name
                              FROM mgmt_targets
                             WHERE target_type = MGMT_GLOBAL.G_AGENT_TARGET_TYPE) emd
                     WHERE tgt.target_guid = det.destination_target_guid
                       AND det.agent_guid = emd.target_guid (+)
                       AND dat.operation_guid = det.operation_guid
                       AND dat.operation_guid = op.operation_guid
                       AND dat.data_set_type = 4
                       AND dat.source_target_guid = tmp.template_guid (+)
                       AND dat.data_set_guid = map.data_set_guid
                       AND det.execution_status IN (3,4,5,8)
                       AND tmp.template_name = l_temp_name_internal
                       AND UPPER(tgt.target_name) LIKE l_tgt_search_str escape '^';
                END IF; -- end of mode
            ELSE -- specific target type
                IF (l_mode_internal = 'pending')
                THEN
                    OPEN apply_operation2_cur_out FOR
                    SELECT tmp.template_name as template_name,
                           det.destination_target_guid,
                           det.execution_status as execution_status,
                           det.error_message as error_message,
                           det.execution_id as execution_id,
                           tgt.target_name as target_name,
                           tgt.target_type as target_type,
                           emd.target_name as agent_name,
                           map.template_copy_guid as template_copy_guid,
                           op.job_owner as job_owner,
                           op.submission_timestamp as submission_timestamp
                      FROM mgmt_update_operations_data dat,
                           mgmt_update_operations_details det,
                           mgmt_update_template_data_map map,
                           mgmt_update_operations op,
                           mgmt_templates tmp,
                           mgmt_targets tgt,
                           (SELECT target_guid, target_name
                              FROM mgmt_targets
                             WHERE target_type = MGMT_GLOBAL.G_AGENT_TARGET_TYPE) emd
                     WHERE tgt.target_guid = det.destination_target_guid
                       AND det.agent_guid = emd.target_guid (+)
                       AND dat.operation_guid = det.operation_guid
                       AND dat.operation_guid = op.operation_guid
                       AND dat.data_set_type = 4
                       AND dat.source_target_guid = tmp.template_guid (+)
                       AND dat.data_set_guid = map.data_set_guid
                       AND det.execution_status IN (1,2,6)
                       AND tgt.target_type = l_tgt_type_internal
                       AND tmp.template_name = l_temp_name_internal
                       AND UPPER(tgt.target_name) LIKE l_tgt_search_str escape '^';
                ELSIF (l_mode_internal = 'past')
                THEN
                    OPEN apply_operation2_cur_out FOR
                    SELECT tmp.template_name as template_name,
                           det.destination_target_guid,
                           det.execution_status as execution_status,
                           det.error_message as error_message,
                           det.execution_id as execution_id,
                           tgt.target_name as target_name,
                           tgt.target_type as target_type,
                           emd.target_name as agent_name,
                           map.template_copy_guid as template_copy_guid,
                           op.job_owner as job_owner,
                           op.submission_timestamp as submission_timestamp
                      FROM mgmt_update_operations_data dat,
                           mgmt_update_operations_details det,
                           mgmt_update_template_data_map map,
                           mgmt_update_operations op,
                           mgmt_templates tmp,
                           mgmt_targets tgt,
                           (SELECT target_guid, target_name
                              FROM mgmt_targets
                             WHERE target_type = MGMT_GLOBAL.G_AGENT_TARGET_TYPE) emd
                     WHERE tgt.target_guid = det.destination_target_guid
                       AND det.agent_guid = emd.target_guid (+)
                       AND dat.operation_guid = det.operation_guid
                       AND dat.operation_guid = op.operation_guid
                       AND dat.data_set_type = 4
                       AND dat.source_target_guid = tmp.template_guid (+)
                       AND dat.data_set_guid = map.data_set_guid
                       AND det.execution_status IN (3,4,5,8)
                       AND tgt.target_type = l_tgt_type_internal
                       AND tmp.template_name = l_temp_name_internal
                       AND UPPER(tgt.target_name) LIKE l_tgt_search_str escape '^';
                END IF;
            END IF; -- end of target type
        ELSIF ( l_temp_name_op_internal = 0 AND l_tgt_name_op_internal = 1 ) -- template name CONTAINS and tgt name IS_EXACTLY
        THEN
            IF ( l_tgt_type_internal = '%' )
            THEN
                IF (l_mode_internal = 'pending')
                THEN
                    OPEN apply_operation2_cur_out FOR
                    SELECT tmp.template_name as template_name,
                           det.destination_target_guid,
                           det.execution_status as execution_status,
                           det.error_message as error_message,
                           det.execution_id as execution_id,
                           tgt.target_name as target_name,
                           tgt.target_type as target_type,
                           emd.target_name as agent_name,
                           map.template_copy_guid as template_copy_guid,
                           op.job_owner as job_owner,
                           op.submission_timestamp as submission_timestamp
                      FROM mgmt_update_operations_data dat,
                           mgmt_update_operations_details det,
                           mgmt_update_template_data_map map,
                           mgmt_update_operations op,
                           mgmt_templates tmp,
                           mgmt_targets tgt,
                           (SELECT target_guid, target_name
                              FROM mgmt_targets
                             WHERE target_type = MGMT_GLOBAL.G_AGENT_TARGET_TYPE) emd
                     WHERE tgt.target_guid = det.destination_target_guid
                       AND det.agent_guid = emd.target_guid (+)
                       AND dat.operation_guid = det.operation_guid
                       AND dat.operation_guid = op.operation_guid
                       AND dat.data_set_type = 4
                       AND dat.source_target_guid = tmp.template_guid (+)
                       AND dat.data_set_guid = map.data_set_guid
                       AND det.execution_status IN (1,2,6)
                       AND UPPER(tmp.template_name) LIKE l_tmpt_search_str escape '^'
                       AND tgt.target_name = l_tgt_name_internal;
                ELSIF (l_mode_internal = 'past')
                THEN
                    OPEN apply_operation2_cur_out FOR
                    SELECT tmp.template_name as template_name,
                           det.destination_target_guid,
                           det.execution_status as execution_status,
                           det.error_message as error_message,
                           det.execution_id as execution_id,
                           tgt.target_name as target_name,
                           tgt.target_type as target_type,
                           emd.target_name as agent_name,
                           map.template_copy_guid as template_copy_guid,
                           op.job_owner as job_owner,
                           op.submission_timestamp as submission_timestamp
                      FROM mgmt_update_operations_data dat,
                           mgmt_update_operations_details det,
                           mgmt_update_template_data_map map,
                           mgmt_update_operations op,
                           mgmt_templates tmp,
                           mgmt_targets tgt,
                           (SELECT target_guid, target_name
                              FROM mgmt_targets
                             WHERE target_type = MGMT_GLOBAL.G_AGENT_TARGET_TYPE) emd
                     WHERE tgt.target_guid = det.destination_target_guid
                       AND det.agent_guid = emd.target_guid (+)
                       AND dat.operation_guid = det.operation_guid
                       AND dat.operation_guid = op.operation_guid
                       AND dat.data_set_type = 4
                       AND dat.source_target_guid = tmp.template_guid (+)
                       AND dat.data_set_guid = map.data_set_guid
                       AND det.execution_status IN (3,4,5,8)
                       AND UPPER(tmp.template_name) LIKE l_tmpt_search_str escape '^'
                       AND tgt.target_name = l_tgt_name_internal;
                END IF; -- end of mode
            ELSE -- specific target type
                IF (l_mode_internal = 'pending')
                THEN
                    OPEN apply_operation2_cur_out FOR
                    SELECT tmp.template_name as template_name,
                           det.destination_target_guid,
                           det.execution_status as execution_status,
                           det.error_message as error_message,
                           det.execution_id as execution_id,
                           tgt.target_name as target_name,
                           tgt.target_type as target_type,
                           emd.target_name as agent_name,
                           map.template_copy_guid as template_copy_guid,
                           op.job_owner as job_owner,
                           op.submission_timestamp as submission_timestamp
                      FROM mgmt_update_operations_data dat,
                           mgmt_update_operations_details det,
                           mgmt_update_template_data_map map,
                           mgmt_update_operations op,
                           mgmt_templates tmp,
                           mgmt_targets tgt,
                           (SELECT target_guid, target_name
                              FROM mgmt_targets
                             WHERE target_type = MGMT_GLOBAL.G_AGENT_TARGET_TYPE) emd
                     WHERE tgt.target_guid = det.destination_target_guid
                       AND det.agent_guid = emd.target_guid (+)
                       AND dat.operation_guid = det.operation_guid
                       AND dat.operation_guid = op.operation_guid
                       AND dat.data_set_type = 4
                       AND dat.source_target_guid = tmp.template_guid (+)
                       AND dat.data_set_guid = map.data_set_guid
                       AND det.execution_status IN (1,2,6)
                       AND tgt.target_type = l_tgt_type_internal
                       AND UPPER(tmp.template_name) LIKE l_tmpt_search_str escape '^'
                       AND tgt.target_name = l_tgt_name_internal;
                ELSIF (l_mode_internal = 'past')
                THEN
                    OPEN apply_operation2_cur_out FOR
                    SELECT tmp.template_name as template_name,
                           det.destination_target_guid,
                           det.execution_status as execution_status,
                           det.error_message as error_message,
                           det.execution_id as execution_id,
                           tgt.target_name as target_name,
                           tgt.target_type as target_type,
                           emd.target_name as agent_name,
                           map.template_copy_guid as template_copy_guid,
                           op.job_owner as job_owner,
                           op.submission_timestamp as submission_timestamp
                      FROM mgmt_update_operations_data dat,
                           mgmt_update_operations_details det,
                           mgmt_update_template_data_map map,
                           mgmt_update_operations op,
                           mgmt_templates tmp,
                           mgmt_targets tgt,
                           (SELECT target_guid, target_name
                              FROM mgmt_targets
                             WHERE target_type = MGMT_GLOBAL.G_AGENT_TARGET_TYPE) emd
                     WHERE tgt.target_guid = det.destination_target_guid
                       AND det.agent_guid = emd.target_guid (+)
                       AND dat.operation_guid = det.operation_guid
                       AND dat.operation_guid = op.operation_guid
                       AND dat.data_set_type = 4
                       AND dat.source_target_guid = tmp.template_guid (+)
                       AND dat.data_set_guid = map.data_set_guid
                       AND det.execution_status IN (3,4,5,8)
                       AND tgt.target_type = l_tgt_type_internal
                       AND UPPER(tmp.template_name) LIKE l_tmpt_search_str escape '^'
                       AND tgt.target_name = l_tgt_name_internal;
                END IF;
            END IF; -- end of target type  
        ELSIF ( l_temp_name_op_internal = 0 AND l_tgt_name_op_internal = 0 ) -- template name and tgt name CONTAINS
        THEN
            IF ( l_tgt_type_internal = '%' )
            THEN
                IF (l_mode_internal = 'pending')
                THEN
                    OPEN apply_operation2_cur_out FOR
                    SELECT tmp.template_name as template_name,
                           det.destination_target_guid,
                           det.execution_status as execution_status,
                           det.error_message as error_message,
                           det.execution_id as execution_id,
                           tgt.target_name as target_name,
                           tgt.target_type as target_type,
                           emd.target_name as agent_name,
                           map.template_copy_guid as template_copy_guid,
                           op.job_owner as job_owner,
                           op.submission_timestamp as submission_timestamp
                      FROM mgmt_update_operations_data dat,
                           mgmt_update_operations_details det,
                           mgmt_update_template_data_map map,
                           mgmt_update_operations op,
                           mgmt_templates tmp,
                           mgmt_targets tgt,
                           (SELECT target_guid, target_name
                              FROM mgmt_targets
                             WHERE target_type = MGMT_GLOBAL.G_AGENT_TARGET_TYPE) emd
                     WHERE tgt.target_guid = det.destination_target_guid
                       AND det.agent_guid = emd.target_guid (+)
                       AND dat.operation_guid = det.operation_guid
                       AND dat.operation_guid = op.operation_guid
                       AND dat.data_set_type = 4
                       AND dat.source_target_guid = tmp.template_guid (+)
                       AND dat.data_set_guid = map.data_set_guid
                       AND det.execution_status IN (1,2,6)
                       AND UPPER(tmp.template_name) LIKE l_tmpt_search_str escape '^'
                       AND UPPER(tgt.target_name) LIKE l_tgt_search_str escape '^';
                ELSIF (l_mode_internal = 'past')
                THEN
                    OPEN apply_operation2_cur_out FOR
                    SELECT tmp.template_name as template_name,
                           det.destination_target_guid,
                           det.execution_status as execution_status,
                           det.error_message as error_message,
                           det.execution_id as execution_id,
                           tgt.target_name as target_name,
                           tgt.target_type as target_type,
                           emd.target_name as agent_name,
                           map.template_copy_guid as template_copy_guid,
                           op.job_owner as job_owner,
                           op.submission_timestamp as submission_timestamp
                      FROM mgmt_update_operations_data dat,
                           mgmt_update_operations_details det,
                           mgmt_update_template_data_map map,
                           mgmt_update_operations op,
                           mgmt_templates tmp,
                           mgmt_targets tgt,
                           (SELECT target_guid, target_name
                              FROM mgmt_targets
                             WHERE target_type = MGMT_GLOBAL.G_AGENT_TARGET_TYPE) emd
                     WHERE tgt.target_guid = det.destination_target_guid
                       AND det.agent_guid = emd.target_guid (+)
                       AND dat.operation_guid = det.operation_guid
                       AND dat.operation_guid = op.operation_guid
                       AND dat.data_set_type = 4
                       AND dat.source_target_guid = tmp.template_guid (+)
                       AND dat.data_set_guid = map.data_set_guid
                       AND det.execution_status IN (3,4,5,8)
                       AND UPPER(tmp.template_name) LIKE l_tmpt_search_str escape '^'
                       AND UPPER(tgt.target_name) LIKE l_tgt_search_str escape '^';
                END IF; -- end of mode
            ELSE -- specific target type
                IF (l_mode_internal = 'pending')
                THEN
                    OPEN apply_operation2_cur_out FOR
                    SELECT tmp.template_name as template_name,
                           det.destination_target_guid,
                           det.execution_status as execution_status,
                           det.error_message as error_message,
                           det.execution_id as execution_id,
                           tgt.target_name as target_name,
                           tgt.target_type as target_type,
                           emd.target_name as agent_name,
                           map.template_copy_guid as template_copy_guid,
                           op.job_owner as job_owner,
                           op.submission_timestamp as submission_timestamp
                      FROM mgmt_update_operations_data dat,
                           mgmt_update_operations_details det,
                           mgmt_update_template_data_map map,
                           mgmt_update_operations op,
                           mgmt_templates tmp,
                           mgmt_targets tgt,
                           (SELECT target_guid, target_name
                              FROM mgmt_targets
                             WHERE target_type = MGMT_GLOBAL.G_AGENT_TARGET_TYPE) emd
                     WHERE tgt.target_guid = det.destination_target_guid
                       AND det.agent_guid = emd.target_guid (+)
                       AND dat.operation_guid = det.operation_guid
                       AND dat.operation_guid = op.operation_guid
                       AND dat.data_set_type = 4
                       AND dat.source_target_guid = tmp.template_guid (+)
                       AND dat.data_set_guid = map.data_set_guid
                       AND det.execution_status IN (1,2,6)
                       AND tgt.target_type = l_tgt_type_internal
                       AND UPPER(tmp.template_name) LIKE l_tmpt_search_str escape '^'
                       AND UPPER(tgt.target_name) LIKE l_tgt_search_str escape '^';
                ELSIF (l_mode_internal = 'past')
                THEN
                    OPEN apply_operation2_cur_out FOR
                    SELECT tmp.template_name as template_name,
                           det.destination_target_guid,
                           det.execution_status as execution_status,
                           det.error_message as error_message,
                           det.execution_id as execution_id,
                           tgt.target_name as target_name,
                           tgt.target_type as target_type,
                           emd.target_name as agent_name,
                           map.template_copy_guid as template_copy_guid,
                           op.job_owner as job_owner,
                           op.submission_timestamp as submission_timestamp
                      FROM mgmt_update_operations_data dat,
                           mgmt_update_operations_details det,
                           mgmt_update_template_data_map map,
                           mgmt_update_operations op,
                           mgmt_templates tmp,
                           mgmt_targets tgt,
                           (SELECT target_guid, target_name
                              FROM mgmt_targets
                             WHERE target_type = MGMT_GLOBAL.G_AGENT_TARGET_TYPE) emd
                     WHERE tgt.target_guid = det.destination_target_guid
                       AND det.agent_guid = emd.target_guid (+)
                       AND dat.operation_guid = det.operation_guid
                       AND dat.operation_guid = op.operation_guid
                       AND dat.data_set_type = 4
                       AND dat.source_target_guid = tmp.template_guid (+)
                       AND dat.data_set_guid = map.data_set_guid
                       AND det.execution_status IN (3,4,5,8)
                       AND tgt.target_type = l_tgt_type_internal
                       AND UPPER(tmp.template_name) LIKE l_tmpt_search_str escape '^'
                       AND UPPER(tgt.target_name) LIKE l_tgt_search_str escape '^';
                END IF;
            END IF; -- end of target type 
        END IF;
    END IF; -- tgt name and tmpl name checks  


/*
   OPEN apply_operation2_cur_out FOR
    SELECT det.execution_id,
           map.template_copy_guid, 
           tgt.target_name,
           tgt.target_type,
           op.job_owner,
           op.submission_timestamp,
           det.execution_status,
           det.error_message
      FROM mgmt_targets tgt,
           mgmt_update_operations op,
           mgmt_update_operations_data dat,
           mgmt_update_operations_details det,
           mgmt_update_template_data_map map
     WHERE det.execution_id IN (SELECT * FROM TABLE (CAST(l_execution_ids AS MGMT_JOB_GUID_ARRAY)))
       AND det.destination_target_guid = tgt.target_guid
       AND det.operation_guid = op.operation_guid
       AND det.operation_guid = dat.operation_guid
       AND dat.data_set_guid = map.data_set_guid
       AND dat.data_set_type = MGMT_TARGET_UPDATE.TARGET_OP_TEMPLATES;
       */
END get_template_apply_operations;


PROCEDURE get_template_apply_ttypes( p_mode        IN VARCHAR2 DEFAULT NULL,
                                     p_c_tgt_types OUT cursortype)
IS
BEGIN
    IF ( p_mode IS NULL OR p_mode = 'past' )
    THEN
        OPEN p_c_tgt_types FOR
        SELECT DISTINCT tgt.target_type
        FROM mgmt_targets tgt,
            mgmt_update_operations_data dat,        
            mgmt_update_operations_details det  
        WHERE tgt.target_guid=det.destination_target_guid    
        AND det.operation_guid=dat.operation_guid    
        AND dat.data_set_type=4
        AND det.execution_status IN (3,4,5,8);
    ELSIF ( p_mode = 'pending' )
    THEN
        OPEN p_c_tgt_types FOR
        SELECT DISTINCT tgt.target_type
        FROM mgmt_targets tgt,
            mgmt_update_operations_data dat,        
            mgmt_update_operations_details det  
        WHERE tgt.target_guid=det.destination_target_guid    
        AND det.operation_guid=dat.operation_guid    
        AND dat.data_set_type=4
        AND det.execution_status IN (1,2,6);
    END IF;
END get_template_apply_ttypes;


PROCEDURE get_has_template_priv(template_name_in IN VARCHAR2,
                                target_type_in IN VARCHAR2,
                                event_name_in IN VARCHAR2,
                                has_priv_out OUT NUMBER,
                                pending_changes_priv_out OUT cursorType,
                                all_pending_changes_out OUT NUMBER)
                             
IS

  l_template_guid mgmt_templates.template_guid%TYPE;

BEGIN

  -- First, get the template guid
  IF (template_name_in IS NOT NULL)
  THEN
    BEGIN
      SELECT template_guid INTO l_template_guid
        FROM mgmt_templates
       WHERE template_name = template_name_in
         AND target_type = target_type_in;

      EXCEPTION
        WHEN NO_DATA_FOUND
        THEN RAISE MGMT_GLOBAL.template_does_not_exist;
    END;
  END IF;
  
  -- Then,check if the current user has the FULL_TEMPLATE privilege for this 
  -- template
  has_priv_out := mgmt_user.has_priv(mgmt_user.get_current_em_user(), 
                                     mgmt_user.FULL_TEMPLATE, 
                                     l_template_guid);
                      
  -- User is trying to delete a template and has the necessary privileges, so
  -- check whether or not there are pending changes against that target. If
  -- there are some, we will attempt to stop them
  -- First get the number of all the pending changes for this template 
  -- regardless of user privileges on the destination targets.
  -- Then, get the number of pending changes for this template against targets
  -- on which the user has at least View privileges
  -- The difference between these numbers represent the number of pending
  -- changes against targets on which the user does not have any privileges
  
  IF (has_priv_out = 1 AND event_name_in = 'confirmDelete')
  THEN
    BEGIN
      SELECT COUNT(*) INTO all_pending_changes_out
        FROM mgmt_update_operations_data dat,
             mgmt_update_operations_details det                                            
       WHERE dat.data_set_type = MGMT_TARGET_UPDATE.TARGET_OP_TEMPLATES
         AND dat.source_target_guid = l_template_guid
         AND dat.operation_guid = det.operation_guid 
         AND det.execution_status IN (MGMT_JOB_ENGINE.SCHEDULED_STATUS,
                                      MGMT_JOB_ENGINE.EXECUTING_STATUS,
                                      MGMT_JOB_ENGINE.SUSPENDED_STATUS);
     
     
     OPEN pending_changes_priv_out FOR
      SELECT det.execution_id
        FROM mgmt_update_operations_data dat,
             mgmt_update_operations_details det,
             mgmt_targets tgt,
             (SELECT target_guid, target_name 
                FROM mgmt_targets 
               WHERE target_type = MGMT_GLOBAL.G_AGENT_TARGET_TYPE) emd 
       WHERE dat.data_set_type = MGMT_TARGET_UPDATE.TARGET_OP_TEMPLATES
         AND dat.source_target_guid = l_template_guid
         AND dat.operation_guid = det.operation_guid 
         AND det.execution_status IN (MGMT_JOB_ENGINE.SCHEDULED_STATUS,
                                      MGMT_JOB_ENGINE.EXECUTING_STATUS,
                                      MGMT_JOB_ENGINE.SUSPENDED_STATUS)
         AND det.destination_target_guid = tgt.target_guid
         AND det.agent_guid = emd.target_guid (+);
    END;
    
  END IF; 

END get_has_template_priv;

PROCEDURE get_has_template_privilege(template_name_in IN VARCHAR2,
                                     target_type_in IN VARCHAR2,
                                     has_priv_out OUT NUMBER)
                             
IS

  l_template_guid mgmt_templates.template_guid%TYPE;

BEGIN

  -- First, get the template guid
  IF (template_name_in IS NOT NULL)
  THEN
    BEGIN
      SELECT template_guid INTO l_template_guid
        FROM mgmt_templates
       WHERE template_name = template_name_in
         AND target_type = target_type_in;

      EXCEPTION
        WHEN NO_DATA_FOUND
        THEN RAISE MGMT_GLOBAL.template_does_not_exist;
    END;
  END IF;
  
  -- Then,check if the current user has the FULL_TEMPLATE privilege for this 
  -- template
  has_priv_out := mgmt_user.has_priv(mgmt_user.get_current_em_user(), 
                                     mgmt_user.FULL_TEMPLATE, 
                                     l_template_guid);

END get_has_template_privilege;

--
-- Name: get_pending_changes
--
-- Package: emd_mntr
--
-- Purpose: 
--  Get the number of pending changes for all templates in the system, including
--  the templates that have been deleted. If the target information is passed in,
--  it's the number of pending changes for that target.
--
FUNCTION get_pending_changes(target_name_in IN VARCHAR2 DEFAULT NULL,
                             target_type_in IN VARCHAR2 DEFAULT NULL) RETURN NUMBER IS

  l_all_pending_changes NUMBER := 0;

BEGIN

  IF(target_name_in IS NOT NULL AND target_type_in IS NOT NULL)
  THEN
    SELECT COUNT(*) into l_all_pending_changes
      FROM mgmt_update_operations op,
           mgmt_update_operations_data dat,
           mgmt_update_operations_details det,
           mgmt_update_template_data_map map,
           mgmt_templates tmp,
           mgmt_targets tgt,
           (SELECT target_guid, target_name 
             FROM mgmt_targets 
            WHERE target_type = MGMT_GLOBAL.G_AGENT_TARGET_TYPE) emd
     WHERE op.operation_guid = dat.operation_guid
       AND dat.data_set_guid = map.data_set_guid
       AND dat.source_target_guid = tmp.template_guid (+)
       AND dat.data_set_type = MGMT_TARGET_UPDATE.TARGET_OP_TEMPLATES
       AND det.operation_guid = dat.operation_guid
       AND det.destination_target_guid = tgt.target_guid
       AND det.agent_guid = emd.target_guid (+)
       AND det.execution_status IN (MGMT_JOB_ENGINE.SCHEDULED_STATUS,
                                    MGMT_JOB_ENGINE.EXECUTING_STATUS,
                                    MGMT_JOB_ENGINE.SUSPENDED_STATUS)
       AND tgt.target_name = target_name_in
       AND tgt.target_type = target_type_in;
  ELSE
    SELECT COUNT(*) into l_all_pending_changes
      FROM mgmt_update_operations op,
           mgmt_update_operations_data dat,
           mgmt_update_operations_details det,
           mgmt_update_template_data_map map,
           mgmt_templates tmp,
           mgmt_targets tgt,
           (SELECT target_guid, target_name 
             FROM mgmt_targets 
            WHERE target_type = MGMT_GLOBAL.G_AGENT_TARGET_TYPE) emd
     WHERE op.operation_guid = dat.operation_guid
       AND dat.data_set_guid = map.data_set_guid
       AND dat.source_target_guid = tmp.template_guid (+)
       AND dat.data_set_type = MGMT_TARGET_UPDATE.TARGET_OP_TEMPLATES
       AND det.operation_guid = dat.operation_guid
       AND det.destination_target_guid = tgt.target_guid
       AND det.agent_guid = emd.target_guid (+)
       AND det.execution_status IN (MGMT_JOB_ENGINE.SCHEDULED_STATUS,
                                    MGMT_JOB_ENGINE.EXECUTING_STATUS,
                                    MGMT_JOB_ENGINE.SUSPENDED_STATUS);
  END IF;
    
  RETURN l_all_pending_changes;

END get_pending_changes;

PROCEDURE get_bcn_test_cur_summary(target_type_in IN VARCHAR2,
                                   test_summary OUT cursorType,
                                   bcn_summary OUT cursorType)
IS
  l_target_types SMP_EMD_STRING_ARRAY := SMP_EMD_STRING_ARRAY();
BEGIN

IF (target_type_in IS NULL) THEN
  SELECT target_type BULK COLLECT into l_target_types
    FROM mgmt_type_properties
   WHERE property_name='is_service'
     AND property_value='1';
ELSE
  l_target_types.extend(1);
  l_target_types(1) := target_type_in;
END IF;


OPEN test_summary FOR
  SELECT tt.target_guid as target_guid,
         NVL(warning_count, 0) as warning_count,
         NVL(critical_count, 0) as critical_count, 
         NVL(up_count, 0) as up_count, 
         NVL(down_count, 0) as down_count,
         NVL(unknown_count, 0) as unknown_count
    FROM 
        (SELECT test.target_guid, 
                SUM(DECODE(v.violation_level, MGMT_GLOBAL.G_SEVERITY_WARNING,1,0)) AS warning_count, 
                SUM(DECODE(v.violation_level, MGMT_GLOBAL.G_SEVERITY_CRITICAL,1,0)) AS critical_count
           FROM 
            (SELECT t.target_guid, tst.txn_guid, k.composite_key
               FROM mgmt_bcn_txn_defn tst, 
                    mgmt_targets t, 
                    mgmt_metrics_composite_keys k
              WHERE t.target_type IN 
                    (SELECT *
                       FROM TABLE(CAST(l_target_types AS SMP_EMD_STRING_ARRAY))
                    )
                AND k.target_guid = t.target_guid 
                AND k.key_part1_value = tst.name 
                AND tst.is_representative = 'Y' 
                AND tst.target_guid = t.target_guid) test, 
            mgmt_current_violation v
          WHERE v.key_value = test.composite_key 
            AND v.target_guid = test.target_guid
          GROUP BY test.target_guid) alert_counts, 
        (SELECT test.target_guid, 
                SUM(DECODE(avail.current_status, MGMT_GLOBAL.G_STATUS_UP, 1, 0)) AS up_count,
                SUM(DECODE(avail.current_status, MGMT_GLOBAL.G_STATUS_DOWN, 1, 0)) AS down_count,
                SUM(DECODE(avail.current_status, MGMT_GLOBAL.G_STATUS_UNKNOWN, 1, 0)) AS unknown_count
           FROM 
            (SELECT t.target_guid, tst.txn_guid
               FROM mgmt_bcn_txn_defn tst, 
                    mgmt_targets t
              WHERE t.target_type IN 
                    (SELECT *
                       FROM TABLE(CAST(l_target_types AS SMP_EMD_STRING_ARRAY))
                    )
                AND tst.is_representative = 'Y' 
                AND tst.target_guid = t.target_guid) test,
                MGMT_GENSVC_TEST_CUR_AVAIL avail
          WHERE avail.target_guid = test.target_guid
            AND avail.test_guid = test.txn_guid
          GROUP BY test.target_guid) status_counts, 
          mgmt_targets tt 
  WHERE tt.target_type IN 
        (SELECT *
           FROM TABLE(CAST(l_target_types AS SMP_EMD_STRING_ARRAY))
        )
    AND tt.target_guid = alert_counts.target_guid (+) 
    AND tt.target_guid = status_counts.target_guid (+)
  ORDER BY tt.target_guid;

OPEN bcn_summary FOR
  SELECT count(*) as beacon_count, t1.target_guid as target_guid 
    FROM mgmt_bcn_target b, mgmt_targets t1, mgmt_targets t2 
   WHERE b.target_guid = t1.target_guid 
     AND b.beacon_target_guid = t2.target_guid
     AND b.beacon_target_guid <> t1.target_guid 
     AND t1.target_type IN 
         (SELECT *
            FROM TABLE(CAST(l_target_types AS SMP_EMD_STRING_ARRAY))
         )
   GROUP BY t1.target_guid;

END get_bcn_test_cur_summary;










PROCEDURE modify_threshold(target_name VARCHAR2,
                          target_type VARCHAR2,
                          metric VARCHAR2,
                          column VARCHAR2,
                          coll_name VARCHAR2,
                          key_info VARCHAR2 DEFAULT '',
                          operator NUMBER,
                          warn  VARCHAR2,
                          crit  VARCHAR2,
                          schedule_ex VARCHAR2,
                          agent_fixit VARCHAR2,
                          num_occurrences NUMBER 
                       ) IS
 l_policy_val_list   MGMT_POLICY_KEY_VAL_ARRAY;
 l_object_guid  mgmt_targets.target_guid%TYPE;
 l_object_type  NUMBER;
 l_metric_guid  mgmt_metrics.metric_guid%TYPE;
 l_metric_name  VARCHAR2(64);
 l_delim_semicolon NUMBER;
 l_delim_colon NUMBER;
 l_key VARCHAR2(256);
 l_delim_key NUMBER;

 l_key_col_cond_list MGMT_POLICY_KEY_COL_COND_ARRAY;
 l_key_columns VARCHAR2(4096);
 l_key_info VARCHAR2(4096);
 l_column_name VARCHAR2(256);
 l_column_value  VARCHAR2(256);

 l_warn VARCHAR2(256);
 l_crit VARCHAR2(256);
 l_operator NUMBER;
 l_num_occurrences NUMBER;
 l_agent_fixit  VARCHAR2(256);

BEGIN
    l_object_guid := MGMT_TARGET.get_target_guid(target_name, target_type);
    l_object_type := MGMT_GLOBAL.G_OBJECT_TYPE_TARGET;


    --IF (already_exists = 1) THEN
    --   mgmt_collection.delete_collection(
    --       p_target_type => target_type,
    --       p_target_name => target_name,
    --       p_coll_name   => p_coll_name);
    --END IF;
  

         
    l_metric_guid := MGMT_METRIC.get_metric_guid(target_type, metric);

    mgmt_collection.start_collection(p_target_name=>target_name,
                                     p_target_type=>target_type,
                                     p_metric_name=>metric,                                     
                                     p_coll_name=> coll_name,
                                     p_schedule_ex => schedule_ex) ; 
      

    l_key_info := key_info;

    l_policy_val_list := MGMT_POLICY_KEY_VAL_ARRAY();

    WHILE LENGTH(l_key_info) IS NOT NULL
    LOOP
        l_delim_key := INSTR(l_key_info, '---');
        l_key_columns := SUBSTR(l_key_info, 1, l_delim_key - 1);

        l_key_col_cond_list := MGMT_POLICY_KEY_COL_COND_ARRAY();

        WHILE LENGTH(l_key_columns) IS NOT NULL      
        LOOP
            l_delim_colon := INSTR(l_key_columns, ':');
            l_delim_semicolon := INSTR(l_key_columns, ';', l_delim_colon + 1);            
            l_column_name := SUBSTR(l_key_columns, 1, l_delim_colon - 1);
            l_column_value := SUBSTR(l_key_columns, l_delim_colon + 1, l_delim_semicolon - l_delim_colon - 1);

            --dbms_output.put_line('l_column_name = ' || l_column_name);
            --dbms_output.put_line('l_column_value = ' || l_column_value);

            l_key_col_cond_list.extend(1);
            l_key_col_cond_list(l_key_col_cond_list.COUNT) := 
                           MGMT_POLICY_KEY_COL_COND.NEW( p_key_value       => l_column_value,
                                                         --p_has_wildcard    => 0,
                                                         p_key_column_name => l_column_name);

            l_key_columns := SUBSTR(l_key_columns, l_delim_semicolon + 1);
        END LOOP;

        l_key_info := SUBSTR(l_key_info, l_delim_key + 3);  
        l_delim_semicolon := INSTR(l_key_info, ';');     
        l_warn := SUBSTR(l_key_info, 1, l_delim_semicolon - 1);

        --dbms_output.put_line('l_warn =' || l_warn);
        
        l_key_info := SUBSTR(l_key_info, l_delim_semicolon + 1);  
        l_delim_semicolon := INSTR(l_key_info, ';');     
        l_crit := SUBSTR(l_key_info, 1, l_delim_semicolon - 1);

        --dbms_output.put_line('l_crit =' || l_crit);

        l_key_info := SUBSTR(l_key_info, l_delim_semicolon + 1);  
        l_delim_semicolon := INSTR(l_key_info, ';');     
        l_operator := TO_NUMBER(SUBSTR(l_key_info, 1, l_delim_semicolon - 1));

        --dbms_output.put_line('l_operator = ' || l_operator);

        l_key_info := SUBSTR(l_key_info, l_delim_semicolon + 1);  
        l_delim_semicolon := INSTR(l_key_info, ';');     
        l_agent_fixit := SUBSTR(l_key_info, 1, l_delim_semicolon - 1);

        --dbms_output.put_line('l_agent_fixit = ' || l_agent_fixit);

        l_key_info := SUBSTR(l_key_info, l_delim_semicolon + 1);  
        l_delim_semicolon := INSTR(l_key_info, ';');     
        l_num_occurrences := TO_NUMBER(SUBSTR(l_key_info, 1, l_delim_semicolon - 1));

        --dbms_output.put_line('l_num_occurrences = ' || l_num_occurrences);  



        l_key_info := SUBSTR(l_key_info, l_delim_semicolon + 1);  

        l_policy_val_list.extend(1);
        l_policy_val_list(l_policy_val_list.COUNT) :=                
                   MGMT_POLICY_KEY_VAL.NEW(
                          p_key_value       => l_key_col_cond_list,
                          p_agent_fixit     => l_agent_fixit,            
                          p_num_occurrences => l_num_occurrences,
                          p_condition_operator => l_operator,
                          p_param_values => MGMT_POLICY_PARAM_VAL_ARRAY(
	                                              MGMT_POLICY_PARAM_VAL.NEW(
                                                      p_param_name     => ' ',
                                                      p_crit_threshold => l_crit,
                                                      p_warn_threshold => l_warn)                   
                                            )
                   );

    END LOOP;


    --dbms_output.put_line('agent_fixit = ' || agent_fixit);
    --dbms_output.put_line('num_occurrences = ' || num_occurrences);
    --dbms_output.put_line('operator = ' || operator);
    --dbms_output.put_line('crit =' || crit);
    --dbms_output.put_line('warn =' || warn);


    l_policy_val_list.extend(1);

    l_policy_val_list(l_policy_val_list.COUNT) := 
 
                   MGMT_POLICY_KEY_VAL.NEW(
                          p_agent_fixit     => agent_fixit,            
                          p_num_occurrences => num_occurrences,
                          p_condition_operator => operator,
                          p_param_values => MGMT_POLICY_PARAM_VAL_ARRAY(
	                                              MGMT_POLICY_PARAM_VAL.NEW(
                                                      p_param_name     => ' ',
                                                      p_crit_threshold => crit,
                                                      p_warn_threshold => warn)                   
                                            )
                   );



              mgmt_monitoring.save_target_metric_config (
                  p_target_type => target_type,
                  p_target_name => target_name,
                  p_metric_name => metric,
                  p_metric_column => column,
                  p_coll_name  => metric,
                  p_policy_val_list => l_policy_val_list
                );




END modify_threshold;











PROCEDURE create_udm(target_name VARCHAR2,
                          target_type VARCHAR2,
                          udm_name VARCHAR2,
                          udm_type VARCHAR2,
                          warn  VARCHAR2,
                          crit  VARCHAR2,
                          schedule_ex VARCHAR2,
                          agent_fixit VARCHAR2,
                          num_occurrences NUMBER,
                          id VARCHAR2,
                          command VARCHAR2,
                          valuetype VARCHAR2,
                          operator NUMBER,
                          message VARCHAR2,
                          already_exists NUMBER,
                          is_multi NUMBER DEFAULT 0,
                          threshold_string VARCHAR2 DEFAULT '',
                          collection_enabled NUMBER DEFAULT 1          
                       ) IS
 l_policy_val_list   MGMT_POLICY_KEY_VAL_ARRAY;
 l_object_guid  mgmt_targets.target_guid%TYPE;
 l_object_type  NUMBER;
 l_metric_guid  mgmt_metrics.metric_guid%TYPE;
 l_metric_name  VARCHAR2(64);
 l_delim_semicolon NUMBER;
 l_delim_colon1 NUMBER;
 l_delim_colon2 NUMBER;
 l_key VARCHAR2(256);
 l_keyed_warn VARCHAR2(256);
 l_keyed_crit VARCHAR2(256);
 l_arr_index NUMBER;
 l_threshold_string VARCHAR2(4096);
BEGIN
    l_object_guid := MGMT_TARGET.get_target_guid(target_name, target_type);
    l_object_type := MGMT_GLOBAL.G_OBJECT_TYPE_TARGET;



    IF (already_exists = 1) THEN
       mgmt_collection.delete_collection(
           p_target_type => target_type,
           p_target_name => target_name,
           p_coll_name   => udm_name);
    END IF;
  

      IF (target_type = 'host') THEN           
            l_metric_guid := MGMT_METRIC.get_metric_guid(target_type, 'UDM');

            mgmt_collection.start_collection(p_target_name=>target_name,
                                             p_target_type=>target_type,
                                             p_metric_name=>'UDM',
                                             -- p_metric_column => udm_type,
                                             p_coll_name=> udm_name,
                                             p_schedule_ex => schedule_ex) ; 
      
            em_coll_util.add_coll_item_property(l_object_guid, l_metric_guid, udm_name, l_object_type, 'ID', id); 
            em_coll_util.add_coll_item_property(l_object_guid, l_metric_guid, udm_name, l_object_type, 'command', command); 
            em_coll_util.add_coll_item_property(l_object_guid, l_metric_guid, udm_name, l_object_type, 'valuetype', valuetype); 

            l_policy_val_list := 
                MGMT_POLICY_KEY_VAL_ARRAY(
                   MGMT_POLICY_KEY_VAL.NEW(
                          p_key_value       => MGMT_POLICY_KEY_COL_COND_ARRAY(
	                                              MGMT_POLICY_KEY_COL_COND.NEW(
                                                      p_has_wildcard    => 0,
                                                      p_key_value       => udm_name)
                                               ),
                          p_agent_fixit     => agent_fixit,            
                          p_num_occurrences => num_occurrences,
                          p_condition_operator => operator,
                          p_message => message,
                          p_param_values => MGMT_POLICY_PARAM_VAL_ARRAY(
	                                              MGMT_POLICY_PARAM_VAL.NEW(
                                                      p_param_name     => ' ',
                                                      p_crit_threshold => crit,
                                                      p_warn_threshold => warn)                   
                                            ) 
                   )
               );


              mgmt_monitoring.save_target_metric_config (
                  p_target_type => target_type,
                  p_target_name => target_name,
                  p_metric_name => 'UDM',
                  p_metric_column => udm_type,
                  p_coll_name  => udm_name,
                  p_policy_val_list => l_policy_val_list
                );

       ELSIF (is_multi = 1) THEN

            IF (valuetype = 'STRING') THEN
                l_metric_name := 'SQLUDMSTR';
            ELSE
                l_metric_name := 'SQLUDMNUM';
            END IF;

            l_metric_guid := MGMT_METRIC.get_metric_guid(target_type, l_metric_name);
      
            mgmt_collection.start_collection(p_target_name=>target_name,
                                             p_target_type=>target_type,
                                             p_metric_name=>l_metric_name,
                                             --p_metric_column => udm_type,
                                             p_coll_name=> udm_name,
                                             p_schedule_ex => schedule_ex) ; 
      
            em_coll_util.add_coll_item_property(l_object_guid, l_metric_guid, udm_name, l_object_type, 'ID', id); 
            em_coll_util.add_coll_item_property(l_object_guid, l_metric_guid, udm_name, l_object_type, 'sqlstmt', command); 
            em_coll_util.add_coll_item_property(l_object_guid, l_metric_guid, udm_name, l_object_type, 'valuetype', valuetype); 
            em_coll_util.add_coll_item_property(l_object_guid, l_metric_guid, udm_name, l_object_type, 'keytype', 'STRING'); 


            l_threshold_string := threshold_string;
            l_policy_val_list := MGMT_POLICY_KEY_VAL_ARRAY();

            l_arr_index := 0;

            WHILE LENGTH(l_threshold_string) IS NOT NULL      
            LOOP
                l_delim_colon1 := INSTR(l_threshold_string, ':');
                l_delim_colon2 := INSTR(l_threshold_string, ':', l_delim_colon1 + 1);
                l_delim_semicolon := INSTR(l_threshold_string, ';', l_delim_colon2 +1);
                l_key := SUBSTR(l_threshold_string, 1, l_delim_colon1 - 1);
                l_keyed_warn := SUBSTR(l_threshold_string, l_delim_colon1 + 1, l_delim_colon2 - l_delim_colon1 -1);
                l_keyed_crit := SUBSTR(l_threshold_string, l_delim_colon2 + 1, l_delim_semicolon - l_delim_colon2 - 1);

                IF LENGTH(l_keyed_warn) IS NULL THEN
                    l_keyed_warn := NULL;
                END IF;

               IF LENGTH(l_keyed_crit) IS NULL THEN
                    l_keyed_crit := NULL;
                END IF;


                l_policy_val_list.extend(1);    
                l_arr_index := l_arr_index + 1;
                l_policy_val_list(l_arr_index) :=
                     MGMT_POLICY_KEY_VAL.NEW(
                           p_key_value       =>  MGMT_POLICY_KEY_COL_COND_ARRAY(
                                                       MGMT_POLICY_KEY_COL_COND.NEW(
                                                         p_key_value       => udm_name,
                                                         p_has_wildcard    => 0,
                                                         p_key_column_name => 'ID'),
                                                       MGMT_POLICY_KEY_COL_COND.NEW(
                                                         p_key_value       => l_key,
                                                         p_has_wildcard    => 0,
                                                         p_key_column_name => 'Key')
                                                     ),
                          p_agent_fixit     => agent_fixit,            
                          p_num_occurrences => num_occurrences,
                          p_condition_operator => operator,
                          p_message => message,
                          p_param_values => MGMT_POLICY_PARAM_VAL_ARRAY(
	                                              MGMT_POLICY_PARAM_VAL.NEW(
                                                      p_param_name     => ' ',
                                                      p_crit_threshold => l_keyed_crit,
                                                      p_warn_threshold => l_keyed_warn)                   
                                            )
                   );


                l_threshold_string := SUBSTR(l_threshold_string, l_delim_semicolon + 1);
            END LOOP;

            l_policy_val_list.extend(1);
            l_arr_index := l_arr_index + 1;    

            l_policy_val_list(l_arr_index) := 
                   MGMT_POLICY_KEY_VAL.NEW(
                          p_key_value       => NULL,
                          p_agent_fixit     => agent_fixit,            
                          p_num_occurrences => num_occurrences,
                          p_condition_operator => operator,
                          p_message => message,
                          p_param_values => MGMT_POLICY_PARAM_VAL_ARRAY(
	                                              MGMT_POLICY_PARAM_VAL.NEW(
                                                      p_param_name     => ' ',
                                                      p_crit_threshold => crit,
                                                      p_warn_threshold => warn)                   
                                            ) 
                   );
               


              mgmt_monitoring.save_target_metric_config (
                  p_target_type => target_type,
                  p_target_name => target_name,
                  p_metric_name => l_metric_name,
                  p_metric_column => udm_type,
                  p_coll_name  => udm_name,
                  p_policy_val_list => l_policy_val_list
                );






       ELSIF (target_type = 'oracle_database' or
              target_type = 'rac_database') THEN 
      
            l_metric_guid := MGMT_METRIC.get_metric_guid(target_type, 'SQLUDM');
  
            mgmt_collection.start_collection(p_target_name=>target_name,
                                             p_target_type=>target_type,
                                             p_metric_name=>'SQLUDM',
                                             --p_metric_column => udm_type,
                                             p_coll_name=> udm_name,
                                             p_schedule_ex => schedule_ex) ; 
      
            em_coll_util.add_coll_item_property(l_object_guid, l_metric_guid, udm_name, l_object_type, 'ID', id); 
            em_coll_util.add_coll_item_property(l_object_guid, l_metric_guid, udm_name, l_object_type, 'sqlstmt', command); 
            em_coll_util.add_coll_item_property(l_object_guid, l_metric_guid, udm_name, l_object_type, 'valuetype', valuetype); 

            l_policy_val_list := 
                MGMT_POLICY_KEY_VAL_ARRAY(
                   MGMT_POLICY_KEY_VAL.NEW(
                          p_key_value       => MGMT_POLICY_KEY_COL_COND_ARRAY(
	                                              MGMT_POLICY_KEY_COL_COND.NEW(
                                                      p_has_wildcard    => 0,
                                                      p_key_value       => udm_name)
                                               ),
                          p_agent_fixit     => agent_fixit,            
                          p_num_occurrences => num_occurrences,
                          p_condition_operator => operator,
                          p_message => message,
                          p_param_values => MGMT_POLICY_PARAM_VAL_ARRAY(
	                                              MGMT_POLICY_PARAM_VAL.NEW(
                                                      p_param_name     => ' ',
                                                      p_crit_threshold => crit,
                                                      p_warn_threshold => warn)                   
                                            ) 
                   )
               );


              mgmt_monitoring.save_target_metric_config (
                  p_target_type => target_type,
                  p_target_name => target_name,
                  p_metric_name => 'SQLUDM',
                  p_metric_column => udm_type,
                  p_coll_name  => udm_name,
                  p_policy_val_list => l_policy_val_list
                );

   

       END IF;


       --disabled
       IF collection_enabled = 0 THEN
           EM_COLL_UTIL.modify_collection_entry(
               p_object_guid => l_object_guid,
               p_object_type => l_object_type,              
               p_coll_name => udm_name,  
               p_is_enabled =>  0);
       END IF;


END create_udm;



PROCEDURE delete_udm(p_target_name VARCHAR2,
                     p_target_type VARCHAR2,
                     p_udm_name VARCHAR2,
                     p_udm_type VARCHAR2) IS
total NUMBER ;
l_target_guid  mgmt_targets.target_guid%TYPE;
l_metric_guid_str mgmt_metrics.metric_guid%TYPE;
l_metric_guid_num mgmt_metrics.metric_guid%TYPE;
l_metric_guid_emp mgmt_metrics.metric_guid%TYPE;


l_metric_guid_sqludmnum_str mgmt_metrics.metric_guid%TYPE;
l_metric_guid_sqludmnum_num mgmt_metrics.metric_guid%TYPE;
l_metric_guid_sqludmstr_str mgmt_metrics.metric_guid%TYPE;
l_metric_guid_sqludmstr_num mgmt_metrics.metric_guid%TYPE;


l_metric_guid_sqludmnum_empty mgmt_metrics.metric_guid%TYPE;
l_metric_guid_sqludmstr_empty mgmt_metrics.metric_guid%TYPE;
l_metric_guid_sqludm_empty mgmt_metrics.metric_guid%TYPE;

BEGIN
    l_target_guid := MGMT_TARGET.get_target_guid(p_target_name, p_target_type);

    total := 0;

    IF (p_target_type = 'host') THEN

        l_metric_guid_str := MGMT_METRIC.get_metric_guid(p_target_type, 'UDM', 'StrValue');
        l_metric_guid_num := MGMT_METRIC.get_metric_guid(p_target_type, 'UDM', 'NumValue');
        l_metric_guid_emp := MGMT_METRIC.get_metric_guid(p_target_type, 'UDM', ' ');

        mgmt_violation.clear_open_alerts(p_target_name, p_target_type, 'UDM', 'NumValue', mgmt_medium_string_table(p_udm_name));
        mgmt_violation.clear_open_alerts(p_target_name, p_target_type, 'UDM', 'StrValue', mgmt_medium_string_table(p_udm_name));

        --current errors (4)
        delete from mgmt_current_metric_errors where 
            target_guid = l_target_guid AND 
            (metric_guid = l_metric_guid_str OR metric_guid = l_metric_guid_num OR metric_guid = l_metric_guid_emp) AND
            coll_name = p_udm_name;


        --errors (5)
        delete from mgmt_metric_errors where 
            target_guid = l_target_guid AND 
            (metric_guid = l_metric_guid_str OR metric_guid = l_metric_guid_num OR metric_guid = l_metric_guid_emp) AND
            coll_name = p_udm_name;


        --raw data (6)
        delete from mgmt_metrics_raw where 
            target_guid = l_target_guid AND 
            (metric_guid = l_metric_guid_str OR metric_guid = l_metric_guid_num OR metric_guid = l_metric_guid_emp) AND
            key_value = p_udm_name;


        --1-hour data (7)
        delete from mgmt_metrics_1hour where 
            target_guid = l_target_guid AND 
            (metric_guid = l_metric_guid_str OR metric_guid = l_metric_guid_num OR metric_guid = l_metric_guid_emp) AND
            key_value = p_udm_name;


        --1-day data (8)
         delete from mgmt_metrics_1day where 
            target_guid = l_target_guid AND 
            (metric_guid = l_metric_guid_str OR metric_guid = l_metric_guid_num OR metric_guid = l_metric_guid_emp) AND
            key_value = p_udm_name;


       --current data (9)
         delete from mgmt_current_metrics where 
            target_guid = l_target_guid AND 
            (metric_guid = l_metric_guid_str OR metric_guid = l_metric_guid_num OR metric_guid = l_metric_guid_emp) AND
            key_value = p_udm_name;
        
       -- This API deletes all the collection/threshold/credential info for the UDM
       mgmt_collection.delete_collection(
           p_target_type => p_target_type,
           p_target_name => p_target_name,
           p_coll_name   => p_udm_name);


    ELSIF (p_udm_type = 'multi') THEN        
        
         l_metric_guid_sqludmnum_str := MGMT_METRIC.get_metric_guid(p_target_type, 'SQLUDMNUM', 'StrValue');
         l_metric_guid_sqludmnum_num := MGMT_METRIC.get_metric_guid(p_target_type, 'SQLUDMNUM', 'NumValue');
         l_metric_guid_sqludmstr_str := MGMT_METRIC.get_metric_guid(p_target_type, 'SQLUDMSTR', 'StrValue');
         l_metric_guid_sqludmstr_num := MGMT_METRIC.get_metric_guid(p_target_type, 'SQLUDMSTR', 'NumValue');

         l_metric_guid_sqludmnum_empty := MGMT_METRIC.get_metric_guid(p_target_type, 'SQLUDMNUM', ' ');
         l_metric_guid_sqludmstr_empty := MGMT_METRIC.get_metric_guid(p_target_type, 'SQLUDMSTR', ' ');
         l_metric_guid_sqludm_empty := MGMT_METRIC.get_metric_guid(p_target_type, 'SQLUDM', ' ');


         mgmt_violation.clear_open_alerts(p_target_name, p_target_type, 'SQLUDMNUM', 'NumValue', mgmt_key_value_array(mgmt_key_value_obj(p_udm_name)));
         mgmt_violation.clear_open_alerts(p_target_name, p_target_type, 'SQLUDMNUM', 'StrValue', mgmt_key_value_array(mgmt_key_value_obj(p_udm_name)));
         mgmt_violation.clear_open_alerts(p_target_name, p_target_type, 'SQLUDMSTR', 'NumValue', mgmt_key_value_array(mgmt_key_value_obj(p_udm_name)));
         mgmt_violation.clear_open_alerts(p_target_name, p_target_type, 'SQLUDMSTR', 'StrValue', mgmt_key_value_array(mgmt_key_value_obj(p_udm_name)));


        --current errors (4)
        delete from mgmt_current_metric_errors where 
            target_guid = l_target_guid AND 
            (metric_guid IN (l_metric_guid_sqludmnum_str, l_metric_guid_sqludmnum_num, 
                             l_metric_guid_sqludmstr_str, l_metric_guid_sqludmstr_num,
                             l_metric_guid_sqludmnum_empty, l_metric_guid_sqludmstr_empty,
                             l_metric_guid_sqludm_empty)) AND
            coll_name = p_udm_name;


        --errors (5)
        delete from mgmt_metric_errors where 
            target_guid = l_target_guid AND 
            (metric_guid IN (l_metric_guid_sqludmnum_str, l_metric_guid_sqludmnum_num, 
                             l_metric_guid_sqludmstr_str, l_metric_guid_sqludmstr_num,
                             l_metric_guid_sqludmnum_empty, l_metric_guid_sqludmstr_empty,
                             l_metric_guid_sqludm_empty)) AND
            coll_name = p_udm_name;



         --raw data (6)
          delete from mgmt_metrics_raw where 
             target_guid = l_target_guid 
                 AND
             (metric_guid IN (l_metric_guid_sqludmnum_str, l_metric_guid_sqludmnum_num, 
                             l_metric_guid_sqludmstr_str, l_metric_guid_sqludmstr_num)) 
                 AND
             (key_value IN 
                (SELECT data.key_value FROM  mgmt_current_metrics data,  mgmt_metrics_composite_keys compKeys 
                 WHERE compKeys.target_guid = l_target_guid AND data.target_guid = l_target_guid 
                 AND  data.key_value = compKeys.composite_key AND compKeys.key_part1_value=p_udm_name
                 AND data.metric_guid in (l_metric_guid_sqludmnum_str, l_metric_guid_sqludmnum_num, 
                                          l_metric_guid_sqludmstr_str, l_metric_guid_sqludmstr_num)));


        --1-hour data (7)
        delete from mgmt_metrics_1hour where 
             target_guid = l_target_guid 
                 AND
             (metric_guid IN (l_metric_guid_sqludmnum_str, l_metric_guid_sqludmnum_num, 
                             l_metric_guid_sqludmstr_str, l_metric_guid_sqludmstr_num)) 
                 AND
             (key_value IN 
                (SELECT data.key_value FROM  mgmt_current_metrics data,  mgmt_metrics_composite_keys compKeys 
                 WHERE compKeys.target_guid = l_target_guid AND data.target_guid = l_target_guid 
                 AND  data.key_value = compKeys.composite_key AND compKeys.key_part1_value=p_udm_name
                 AND data.metric_guid in (l_metric_guid_sqludmnum_str, l_metric_guid_sqludmnum_num, 
                                          l_metric_guid_sqludmstr_str, l_metric_guid_sqludmstr_num)));


        --1-day data (8)
           delete from mgmt_metrics_1day where 
             target_guid = l_target_guid 
                 AND
             (metric_guid IN (l_metric_guid_sqludmnum_str, l_metric_guid_sqludmnum_num, 
                             l_metric_guid_sqludmstr_str, l_metric_guid_sqludmstr_num)) 
                 AND
             (key_value IN 
                (SELECT data.key_value FROM  mgmt_current_metrics data,  mgmt_metrics_composite_keys compKeys 
                 WHERE compKeys.target_guid = l_target_guid AND data.target_guid = l_target_guid 
                 AND  data.key_value = compKeys.composite_key AND compKeys.key_part1_value=p_udm_name
                 AND data.metric_guid in (l_metric_guid_sqludmnum_str, l_metric_guid_sqludmnum_num, 
                                          l_metric_guid_sqludmstr_str, l_metric_guid_sqludmstr_num)));


      
          --current data (9)
            delete from mgmt_current_metrics where 
             target_guid = l_target_guid 
                 AND
             (metric_guid IN (l_metric_guid_sqludmnum_str, l_metric_guid_sqludmnum_num, 
                             l_metric_guid_sqludmstr_str, l_metric_guid_sqludmstr_num)) 
                 AND
             (key_value IN 
                (SELECT data.key_value FROM  mgmt_current_metrics data,  mgmt_metrics_composite_keys compKeys 
                 WHERE compKeys.target_guid = l_target_guid AND data.target_guid = l_target_guid 
                 AND  data.key_value = compKeys.composite_key AND compKeys.key_part1_value=p_udm_name
                 AND data.metric_guid in (l_metric_guid_sqludmnum_str, l_metric_guid_sqludmnum_num, 
                                          l_metric_guid_sqludmstr_str, l_metric_guid_sqludmstr_num)));


       -- The following API deletes collection/thresholds/credential info for 
       -- the given coll_name
       mgmt_collection.delete_collection(
           p_target_type => p_target_type,
           p_target_name => p_target_name,
           p_coll_name   => p_udm_name);

    ELSIF (p_udm_type = 'single') THEN    
        l_metric_guid_str := MGMT_METRIC.get_metric_guid(p_target_type, 'SQLUDM', 'StrValue');
        l_metric_guid_num := MGMT_METRIC.get_metric_guid(p_target_type, 'SQLUDM', 'NumValue');

         l_metric_guid_sqludmnum_empty := MGMT_METRIC.get_metric_guid(p_target_type, 'SQLUDMNUM', ' ');
         l_metric_guid_sqludmstr_empty := MGMT_METRIC.get_metric_guid(p_target_type, 'SQLUDMSTR', ' ');
         l_metric_guid_sqludm_empty := MGMT_METRIC.get_metric_guid(p_target_type, 'SQLUDM', ' ');



        mgmt_violation.clear_open_alerts(p_target_name, p_target_type, 'SQLUDM', 'NumValue', mgmt_medium_string_table(p_udm_name));
        mgmt_violation.clear_open_alerts(p_target_name, p_target_type, 'SQLUDM', 'StrValue', mgmt_medium_string_table(p_udm_name));


       --current errors (4)
        delete from mgmt_current_metric_errors where 
            target_guid = l_target_guid AND 
            (metric_guid IN (l_metric_guid_str, l_metric_guid_num, 
                             l_metric_guid_sqludmnum_empty, l_metric_guid_sqludmstr_empty,
                             l_metric_guid_sqludm_empty)) AND
            coll_name = p_udm_name;


        --errors (5)
        delete from mgmt_metric_errors where 
            target_guid = l_target_guid AND 
            (metric_guid IN (l_metric_guid_str, l_metric_guid_num, 
                             l_metric_guid_sqludmnum_empty, l_metric_guid_sqludmstr_empty,
                             l_metric_guid_sqludm_empty)) AND
            coll_name = p_udm_name;


        --raw data (6)
        delete from mgmt_metrics_raw where 
            target_guid = l_target_guid AND 
            (metric_guid = l_metric_guid_str OR metric_guid = l_metric_guid_num) AND
            key_value = p_udm_name;


        --1-hour data (7)
        delete from mgmt_metrics_1hour where 
            target_guid = l_target_guid AND 
            (metric_guid = l_metric_guid_str OR metric_guid = l_metric_guid_num) AND
            key_value = p_udm_name;


        --1-day data (8)
         delete from mgmt_metrics_1day where 
            target_guid = l_target_guid AND 
            (metric_guid = l_metric_guid_str OR metric_guid = l_metric_guid_num) AND
            key_value = p_udm_name;


       --current data (9)
         delete from mgmt_current_metrics where 
            target_guid = l_target_guid AND 
            (metric_guid = l_metric_guid_str OR metric_guid = l_metric_guid_num) AND
            key_value = p_udm_name;


         -- Collection
         mgmt_collection.delete_collection(
             p_target_type => p_target_type,
             p_target_name => p_target_name,
             p_coll_name   => p_udm_name);

    END IF;

   
END delete_udm;
--PUBLIC Procedure : get_metric_errors
--IN Parameters:p_emd_url
--OUT parameter:p_met_cur
--This Procedure Is used to retreive the list of Metric Errors
PROCEDURE get_metric_errors (p_emd_url in varchar2,
                             p_met_cur out CursorType) is
BEGIN
    OPEN p_met_cur FOR 
        SELECT 
            tgt.emd_url, 
            tgt.target_name, 
            tgt.target_type, 
            tgt.type_display_name, 
            met.metric_name, 
            met.metric_label, 
            TO_CHAR(err.collection_timestamp) AS collection_timestamp_string, 
            err.collection_timestamp, 
            err.metric_error_message, 
            err.coll_name, 
            met.metric_label_nlsid
       FROM mgmt_current_metric_errors err,
            mgmt_metrics met,mgmt_targets tgt
      WHERE err.target_guid=tgt.target_guid AND 
            err.metric_guid=met.metric_guid AND 
            err.metric_error_message IS NOT NULL  AND 
            met.type_meta_ver = tgt.type_meta_ver AND
           (met.category_prop_1 = ' ' OR met.category_prop_1 = tgt.category_prop_1) AND 
           (met.category_prop_2 = ' ' OR met.category_prop_2 = tgt.category_prop_2) AND 
           (met.category_prop_3 = ' ' OR met.category_prop_3 = tgt.category_prop_3) AND
           (met.category_prop_4 = ' ' OR met.category_prop_4 = tgt.category_prop_4) AND 
           (met.category_prop_5 = ' ' OR met.category_prop_5 = tgt.category_prop_5) AND
           tgt.emd_url =p_emd_url;

END get_metric_errors;			     

PROCEDURE delete_udm(p_target_guid     IN RAW,
                     p_metric_guid     IN RAW,
                     p_object_type     IN NUMBER,
                     p_coll_name       IN VARCHAR2
                     ) IS
l_target_name  mgmt_targets.target_name%TYPE;
l_target_type  mgmt_targets.target_type%TYPE;
l_num_occurances mgmt_metrics.NUM_KEYS%TYPE;
l_type_meta_ver mgmt_targets.type_meta_ver%TYPE;
l_category_prop_1 mgmt_targets.category_prop_1%TYPE;
l_category_prop_2 mgmt_targets.category_prop_2%TYPE;
l_category_prop_3 mgmt_targets.category_prop_3%TYPE;
l_category_prop_4 mgmt_targets.category_prop_4%TYPE;
l_category_prop_5 mgmt_targets.category_prop_5%TYPE;
l_udm_type VARCHAR2(10);
BEGIN

  BEGIN
    SELECT target_name, target_type, type_meta_ver, category_prop_1, category_prop_2,
           category_prop_3, category_prop_4, category_prop_5
      INTO  l_target_name, l_target_type, l_type_meta_ver, l_category_prop_1, l_category_prop_2,
           l_category_prop_3, l_category_prop_4, l_category_prop_5
      FROM mgmt_targets
     WHERE target_guid = p_target_guid;

    EXCEPTION
      WHEN NO_DATA_FOUND
        THEN
        l_target_name := null;
        l_target_type := null;
        RETURN;
  END;

  BEGIN
    SELECT DISTINCT num_keys INTO l_num_occurances
    FROM mgmt_metrics met 
    WHERE met.metric_guid = p_metric_guid
      AND met.target_type = l_target_type
      AND met.type_meta_ver = l_type_meta_ver
      AND (met.category_prop_1 = l_category_prop_1 OR met.category_prop_1 = ' ')
      AND (met.category_prop_2 = l_category_prop_2 OR met.category_prop_2 = ' ')
      AND (met.category_prop_3 = l_category_prop_3 OR met.category_prop_3 = ' ')
      AND (met.category_prop_4 = l_category_prop_4 OR met.category_prop_4 = ' ')
      AND (met.category_prop_5 = l_category_prop_5 OR met.category_prop_5 = ' ');
  EXCEPTION
      WHEN NO_DATA_FOUND
        THEN
        l_num_occurances := null;
        RETURN;
  END;

  l_udm_type := null;
  IF (l_num_occurances > 1
      AND (l_target_type = MGMT_GLOBAL.G_DATABASE_TARGET_TYPE
           OR l_target_type = MGMT_GLOBAL.G_RAC_DATABASE_TARGET_TYPE))
  THEN
      l_udm_type := 'multi';
  ELSE
      l_udm_type := 'single';
  END IF;

  delete_udm(p_target_name => l_target_name,
             p_target_type => l_target_type,
             p_udm_name => p_coll_name,
             p_udm_type => l_udm_type);

END delete_udm;

    -- PROCEDURE: is_server_gnrtd_metric
    --
    -- PURPOSE:
    --   This procedure checks if the db version is 10g or greater and the metric 
    --   is server generated metric
    --
    -- IN Parameters:
    --   target_name_in: The target name
    --   target_type_in: The target type. 
    --   metric_guid_in : metric guid
    -- OUT Parameters:
    -- is_srvr_gnrtd         : 0 (if metric is not server generated) or 1 (if metric is server generated)

    PROCEDURE is_server_gnrtd_metric(
                target_name_in      IN MGMT_TARGETS.target_name%TYPE, 
                target_type_in      IN MGMT_TARGETS.target_type%TYPE, 
                metric_guid_in      IN  MGMT_METRICS.metric_guid%TYPE,
                is_srvr_gnrtd       OUT MGMT_METRICS.has_push%TYPE) 
    IS
        l_target_guid       mgmt_targets.target_guid%TYPE;
        l_type_meta_ver     mgmt_targets.type_meta_ver%TYPE;
        l_category_prop_1   mgmt_targets.category_prop_1%TYPE;
        l_category_prop_2   mgmt_targets.category_prop_2%TYPE;
        l_category_prop_3   mgmt_targets.category_prop_3%TYPE;
        l_category_prop_4   mgmt_targets.category_prop_4%TYPE;
        l_category_prop_5   mgmt_targets.category_prop_5%TYPE;
        l_version           NUMBER;
    BEGIN
    -- Get the target guid, type_meta_ver, category_prop_1 to category_prop_5 from the mgmt_targets
        BEGIN
            SELECT target_guid,
                   type_meta_ver,
                   category_prop_1,
                   category_prop_2,
                   category_prop_3,
                   category_prop_4,
                   category_prop_5
            INTO l_target_guid,    
                 l_type_meta_ver,  
                 l_category_prop_1,
                 l_category_prop_2,
                 l_category_prop_3,
                 l_category_prop_4,
                 l_category_prop_5 
            FROM  mgmt_targets
            WHERE target_name = target_name_in
              AND target_type = target_type_in;
        EXCEPTION
            WHEN NO_DATA_FOUND THEN
                RAISE_APPLICATION_ERROR(-20010,'Target '||target_name_in||':'||target_type_in||'does not exist');
             WHEN OTHERS THEN
                RAISE_APPLICATION_ERROR(-20011,'Error has occured');
        END;
        --Get target_properties
        IF (target_type_in  IN (MGMT_GLOBAL.G_DATABASE_TARGET_TYPE, MGMT_GLOBAL.G_RAC_DATABASE_TARGET_TYPE))
        THEN
                BEGIN
                    SELECT TO_NUMBER(SUBSTR(TRIM(property_value),1,
                                       INSTR(TRIM(property_value),'.',1)-1)) 
                    INTO l_version
                    FROM mgmt_target_properties
                    WHERE target_guid= l_target_guid
                       AND property_name='Version';
                EXCEPTION
                    WHEN NO_DATA_FOUND THEN
                        RAISE_APPLICATION_ERROR(-20012,'Target Properties does not exist for '||
                                            target_name_in||':'||target_type_in);
                    WHEN OTHERS THEN
                        RAISE_APPLICATION_ERROR(-20013,'Error has occured');
                END;
                -- If the DB version >= 10, 
                -- then find out if the metric is a server generated metric
                IF (l_version >= 10)
                THEN
                    BEGIN
                        SELECT has_push
                        INTO is_srvr_gnrtd
                        FROM mgmt_metrics
                        WHERE target_type = target_type_in
                          AND ( type_meta_ver   = l_type_meta_ver    OR  type_meta_ver    = ' ')
                          AND ( category_prop_1 = l_category_prop_1  OR  category_prop_1  = ' ')
                          AND ( category_prop_2 = l_category_prop_2  OR   category_prop_2 = ' ')
                          AND ( category_prop_3 = l_category_prop_3  OR  category_prop_3  = ' ')
                          AND ( category_prop_4 = l_category_prop_4  OR  category_prop_4  = ' ')
                          AND ( category_prop_5 = l_category_prop_5  OR  category_prop_5  = ' ')
                          AND metric_guid = metric_guid_in;
                      EXCEPTION
                            WHEN NO_DATA_FOUND THEN
                                RAISE_APPLICATION_ERROR(-20014,'Metric Properties does not exist for '||
                                                        metric_guid_in||':'||target_type_in);
                            WHEN OTHERS THEN
                                RAISE_APPLICATION_ERROR(-20015,'Error has occured');
                      END;
                END IF;
            END IF;
    EXCEPTION
        WHEN OTHERS THEN
            is_srvr_gnrtd := 0;
    END is_server_gnrtd_metric;

    -- FUNCTION: check_metric_parent
    --
    -- IN Parameters:
    --   l_target_name_in   : The target name
    --   l_target_type_in   : The target type. 
    --   l_metric_name_in   : The metric name
    --   l_metric_column_in : The metric column
    -- OUT Parameter:
    --   l_is_parent        : 0 (if metric parent doesnt contain '%Tablespace%') 
    --                        or any integer (if metric parent contains '%Tablespace%')
    /*
    Added for Bug No 6017721
    This checks if the metric_label for the specified metric_name, metric_column
    combination contains '%Tablespace%'. Returns 0 if no match is found and the original
    count in case the occurrences happen.
    */   
    FUNCTION check_metric_parent (l_target_name_in    IN MGMT_TARGETS.target_name%TYPE DEFAULT NULL, 
                                  l_target_type_in    IN MGMT_TARGETS.target_type%TYPE, 
                                  l_metric_name_in    IN MGMT_METRICS.metric_name%TYPE,
                                  l_metric_column_in  IN MGMT_METRICS.metric_column%TYPE) 
    RETURN NUMBER       
    IS
        l_target_guid       mgmt_targets.target_guid%TYPE;
        l_type_meta_ver     mgmt_targets.type_meta_ver%TYPE;
        l_category_prop_1   mgmt_targets.category_prop_1%TYPE;
        l_category_prop_2   mgmt_targets.category_prop_2%TYPE;
        l_category_prop_3   mgmt_targets.category_prop_3%TYPE;
        l_category_prop_4   mgmt_targets.category_prop_4%TYPE;
        l_category_prop_5   mgmt_targets.category_prop_5%TYPE;
        l_version           NUMBER;
        l_is_parent         NUMBER:=1;
        l_metric_guid       mgmt_metrics.metric_guid%TYPE;
        l_is_svr_gnrtd      NUMBER:=0;
    BEGIN
        IF (l_target_type_in  IN (MGMT_GLOBAL.G_DATABASE_TARGET_TYPE, MGMT_GLOBAL.G_RAC_DATABASE_TARGET_TYPE))
        THEN
        -- Get the target guid, type_meta_ver, category_prop_1 to category_prop_5 from the mgmt_targets
            IF l_target_name_in IS NULL
            THEN
                BEGIN
                    SELECT count(metric_label)
                    INTO l_is_parent
                    FROM mgmt_metrics
                    WHERE metric_name=l_metric_name_in
                        AND metric_column=l_metric_column_in
                        AND column_label = 'Tablespace Space Used (%)'
                        AND target_type = l_target_type_in;
                EXCEPTION
                    WHEN OTHERS THEN
                    l_is_parent := 0;
                END;
            ELSE
                -- Get the target guid, type_meta_ver, category_prop_1 to category_prop_5 from the mgmt_targets
                BEGIN
                    SELECT target_guid,
                           type_meta_ver,
                           category_prop_1,
                           category_prop_2,
                           category_prop_3,
                           category_prop_4,
                           category_prop_5
                    INTO l_target_guid,    
                         l_type_meta_ver,  
                         l_category_prop_1,
                         l_category_prop_2,
                         l_category_prop_3,
                         l_category_prop_4,
                         l_category_prop_5 
                    FROM  mgmt_targets
                    WHERE target_name = l_target_name_in
                    AND target_type = l_target_type_in;
                EXCEPTION
                    WHEN NO_DATA_FOUND THEN
                        RAISE_APPLICATION_ERROR(-20010,'Target '||l_target_name_in||':'||l_target_type_in||'does not exist');
                    WHEN OTHERS THEN
                        RAISE_APPLICATION_ERROR(-20011,'Error has occured');
                END;
            
                BEGIN
                    SELECT metric_guid
                        INTO l_metric_guid
                        FROM mgmt_metrics
                        WHERE metric_name=l_metric_name_in
                        AND metric_column=l_metric_column_in
                        AND LOWER(metric_label) like LOWER('%Tablespace%')
                        AND target_type = l_target_type_in
                        AND ( type_meta_ver   = l_type_meta_ver    OR  type_meta_ver    = ' ')
                        AND ( category_prop_1 = l_category_prop_1  OR  category_prop_1  = ' ')
                        AND ( category_prop_2 = l_category_prop_2  OR   category_prop_2 = ' ')
                        AND ( category_prop_3 = l_category_prop_3  OR  category_prop_3  = ' ')
                        AND ( category_prop_4 = l_category_prop_4  OR  category_prop_4  = ' ')
                        AND ( category_prop_5 = l_category_prop_5  OR  category_prop_5  = ' ')
                        AND NOT (num_keys=1 AND is_transposed=1)
                        AND (num_keys>0);

                        is_server_gnrtd_metric( target_name_in => l_target_name_in ,
                                                target_type_in => l_target_type_in ,
                                                metric_guid_in => l_metric_guid ,
                                                is_srvr_gnrtd  => l_is_svr_gnrtd ) ;

                        IF  l_is_svr_gnrtd != 0 THEN
                            l_is_parent := 1;
                        ELSE 
                            l_is_parent := 0;
                        END IF;

                    EXCEPTION
                        WHEN NO_DATA_FOUND THEN
                            l_is_parent := 0;
                        WHEN OTHERS THEN
                            l_metric_guid :='0';
                            l_is_parent := 0;
                END;
            END IF;
        ELSE
            l_is_parent := 0;    
        END IF;
        RETURN l_is_parent ;
    END check_metric_parent;

    -- FUNCTION: check_for_warn_crit_tip
    --
    -- IN Parameters:
    --   l_target_name_in   : The target name
    --   l_target_type_in   : The target type. 
    --   l_metric_name_in   : The metric name
    --   l_metric_column_in : The metric column
    -- OUT Parameter:
    --   l_is_parent        : 0 (if column label doesnt contain 'Tablespace Space Used (%)') 
    --                        or any integer (if column label contains 'Tablespace Space Used (%)')
    /*
    Added for Bug No 6017688
    This checks if the column_label for the specified metric_name, metric_column
    combination contains 'Tablespace Space Used (%)'. Returns 0 if no match is found and the original
    count in case the occurrences happen.
    */ 
    FUNCTION check_for_warn_crit_tip (l_target_name_in    IN MGMT_TARGETS.target_name%TYPE DEFAULT NULL,
                                      l_target_type_in    IN MGMT_TARGETS.target_type%TYPE,
                                      l_metric_name_in    IN MGMT_METRICS.metric_name%TYPE,
                                      l_metric_column_in  IN MGMT_METRICS.metric_column%TYPE)
    RETURN NUMBER
    IS
        l_target_guid       mgmt_targets.target_guid%TYPE;
        l_type_meta_ver     mgmt_targets.type_meta_ver%TYPE;
        l_category_prop_1   mgmt_targets.category_prop_1%TYPE;
        l_category_prop_2   mgmt_targets.category_prop_2%TYPE;
        l_category_prop_3   mgmt_targets.category_prop_3%TYPE;
        l_category_prop_4   mgmt_targets.category_prop_4%TYPE;
        l_category_prop_5   mgmt_targets.category_prop_5%TYPE;
        l_version           NUMBER;
        l_is_parent         NUMBER:=0;
    BEGIN
        IF (l_target_type_in  IN (MGMT_GLOBAL.G_DATABASE_TARGET_TYPE, MGMT_GLOBAL.G_RAC_DATABASE_TARGET_TYPE))
        THEN
            IF l_target_name_in IS NULL
            THEN
                BEGIN
                    SELECT count(metric_label)
                    INTO l_is_parent
                    FROM mgmt_metrics
                    WHERE metric_name=l_metric_name_in
                        AND metric_column=l_metric_column_in
                        AND column_label = 'Tablespace Space Used (%)'
                        AND target_type = l_target_type_in;
                EXCEPTION
                    WHEN OTHERS THEN
                    l_is_parent := 0;
                END;
            ELSE
                -- Get the target guid, type_meta_ver, category_prop_1 to category_prop_5 from the mgmt_targets
                BEGIN
                    SELECT target_guid,
                        type_meta_ver,
                        category_prop_1,
                        category_prop_2,
                        category_prop_3,
                        category_prop_4,
                        category_prop_5
                    INTO l_target_guid,
                        l_type_meta_ver,
                        l_category_prop_1,
                        l_category_prop_2,
                        l_category_prop_3,
                        l_category_prop_4,
                        l_category_prop_5
                    FROM  mgmt_targets
                    WHERE target_name = l_target_name_in
                        AND target_type = l_target_type_in;
                EXCEPTION
                    WHEN NO_DATA_FOUND THEN
                        RAISE_APPLICATION_ERROR(-20010,'Target '||l_target_name_in||':'||l_target_type_in||'does not exist');
                    WHEN OTHERS THEN
                        RAISE_APPLICATION_ERROR(-20011,'Error has occured');
                END;
                BEGIN
                    SELECT TO_NUMBER(SUBSTR(TRIM(property_value),1,
                                       INSTR(TRIM(property_value),'.',1)-1)) 
                    INTO l_version
                    FROM mgmt_target_properties
                    WHERE target_guid= l_target_guid
                       AND property_name='Version';
                EXCEPTION
                    WHEN NO_DATA_FOUND THEN
                        RAISE_APPLICATION_ERROR(-20012,'Target Properties does not exist for '||
                                            l_target_name_in||':'||l_target_type_in);
                    WHEN OTHERS THEN
                        RAISE_APPLICATION_ERROR(-20013,'Error has occured');
                END;
                -- If the DB version >= 10, 
                -- then find out if the metric is a server generated metric
                IF (l_version >= 10)
                THEN
                    BEGIN
                        SELECT count(metric_label)
                        INTO l_is_parent
                        FROM mgmt_metrics
                        WHERE metric_name=l_metric_name_in
                            AND metric_column=l_metric_column_in
                            AND column_label = 'Tablespace Space Used (%)'
                            AND target_type = l_target_type_in
                            AND ( type_meta_ver   = l_type_meta_ver    OR  type_meta_ver    = ' ')
                            AND ( category_prop_1 = l_category_prop_1  OR  category_prop_1  = ' ')
                            AND ( category_prop_2 = l_category_prop_2  OR   category_prop_2 = ' ')
                            AND ( category_prop_3 = l_category_prop_3  OR  category_prop_3  = ' ')
                            AND ( category_prop_4 = l_category_prop_4  OR  category_prop_4  = ' ')
                            AND ( category_prop_5 = l_category_prop_5  OR  category_prop_5  = ' ');
                    EXCEPTION
                        WHEN OTHERS THEN
                            l_is_parent :=0;
                    END;
                END IF;
            END IF;
        ELSE
            l_is_parent := 0;    
        END IF;
        RETURN l_is_parent ;
    END check_for_warn_crit_tip;
end emd_mntr;
/

show errors;


