Rem drv: <create type="post_creation" pos="blackout/blackout_post_creation.sql-"/>
Rem
Rem $Header: basic_post_creation.sql 21-feb-2007.09:54:23 aptrived Exp $
Rem
Rem basic_post_creation.sql
Rem
Rem Copyright (c) 2002, 2007, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      basic_post_creation.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    aptrived    04/18/06 - Bug#5152908, Adding MGMT_METRICS_1DAY to 
Rem                           MGMT_TARGET_DELETE_EXCEPTIONS 
Rem    vnukal      08/14/06 - XbranchMerge vnukal_reloc_job from main
Rem    pmodi       08/18/05 - Bug:4538663 - Setting purge batchsize in 
Rem                           mgmt_parameters 
Rem    jsadras     07/29/05 - basic_data_upgrade missing 
Rem    vkarpura    07/13/05 - Allow WC RG creation 
Rem    gsbhatia    07/14/05 - 
Rem    rkpandey    07/07/05 - Bug 4474926: move registering logging TARGET 
Rem                           Module to basic_common_init.sql 
Rem    scgrover    07/06/05 - add extended sql trace 
Rem    gsbhatia    07/03/05 - New repmgr header impl 
Rem    rmarripa    06/06/05 - Remove webapp composite target type property 
Rem    rpinnama    05/12/05 - Move 102010 init to a common file 
Rem    vkarpura    04/05/05 - Fix Naming 
Rem    rkpandey    04/07/05 - Removing duplicate target_type registering 
Rem    vkarpura    03/31/05 - Moving IAS v102010 to IAS module 
Rem    ramalhot    03/03/05 - handler for MGMT_CHANGE_AGENT_URL added 
Rem    vkarpura    03/02/05 - Adding Red Group Exclude for OHS, OC4J, WC and IAS
Rem    rmaggarw    02/24/05 - bug 4204931: prefix schema name to AQ objects 
Rem    vkarpura    02/02/05 - Changing type Strings for IAS 
Rem    rpinnama    02/03/05 - Populate schema owner name to parameters table 
Rem    vkarpura    01/25/05 - Adding props for IAS custom RGs 
Rem    vkarpura    01/20/05 - Adding Custom RGs for IAS 
Rem    rpinnama    01/07/05 - Set the version of oracle_emrep target to 2.0 
Rem    ktlaw       01/11/05 - add repmgr header 
Rem    bkesavan    12/12/04 - Change string and metrics error to system wide purge
Rem    vagarwal    12/10/04 - disallow emdrep target from redundancy group 
Rem    groyal      11/10/04 - Add NLS support for functional categories 
Rem    streddy     11/08/04 - Change redundancy group to exclusion mechanism 
Rem    vkarpura    10/18/04 - Changing Labels 
Rem    rmaggarw    10/08/04 - add AQ creation, add synonym creation - shared FS 
Rem    vkarpura    09/03/04 - Adding Farm and Cluster 
Rem    ckumar	   09/03/04 - Added Redundacy Group property
Rem    ramalhot    08/17/04 - Register TARGET for logging 
Rem    streddy     08/10/04 - Add Funtional metric categories 
Rem    klmichae    04/09/04 - make oc4j as being a composite type 
Rem    vkapur      11/19/03 - bug 3256326: insert rac_database metrics into mgmt_metrics_ext
Rem    rzazueta    11/12/03 - Fix 3156431: Add MGMT_METRICS_RAW and 
Rem                           MGMT_METRICS_1HOUR to deletion exceptions 
Rem    rpinnama    09/25/03 - Register target types 
Rem    rpinnama    09/07/03 - Add purge policy for string metric history 
Rem    jsoule      08/18/03 - add population of metric metadata extension 
Rem    rpinnama    03/17/03 - Move DBMS job submission to basic_dbms_jobs file
Rem    rpinnama    12/27/02 - Register PURGE for logging
Rem    rpinnama    11/21/02 - Add mgmt_duplicate target to target delete exception
Rem    rpinnama    11/12/02 - Add mgmt_targets_delete as deleteion exception
Rem    rpinnama    10/18/02 - Remove maint logging commands
Rem    rpinnama    10/15/02 - Fix register_logging_module API
Rem    rpinnama    10/14/02 - Use log_registration API
Rem    edemembe    08/15/02 - Adding performance logging
Rem    edemembe    08/08/02 - Adding performance logging
Rem    aholser     05/31/02 - add display and dbms job info
Rem    rpinnama    06/05/02 - Initialize performance log.
Rem    rpinnama    05/16/02 - add submit job.
Rem    rpinnama    05/14/02 - Created
Rem


INSERT INTO MGMT_PARAMETERS
    (parameter_name, parameter_value, parameter_comment)
  VALUES
    ('load_interval', '300', 'The load interval in seconds');
COMMIT;

-- Register logging modules.
BEGIN
  mgmt_log.register_logging_module ('LOADER','Loader');

  mgmt_log.register_logging_module ('RELOCATE','Relocate');

  mgmt_log.register_logging_module ('ROLLUP','Rollup','EMD_LOADER.ROLLUP()');

  mgmt_log.register_logging_module ('PURGE','Purge');

  mgmt_log.register_logging_module ('ROLLUP 1HOUR','1 Hour Rollup');

  mgmt_log.register_logging_module ('PURGE RAW','Raw Data Purge');

  mgmt_log.register_logging_module ('ROLLUP 1DAY','1 Day Rollup');

  mgmt_log.register_logging_module ('PURGE 1HOUR','1 Hour Data Purge');

  mgmt_log.register_logging_module ('PURGE 1DAY','1 Day Data Purge');  

  mgmt_log.register_logging_module ('PURGE ERROR LOG','Error Log Purge');

  mgmt_log.register_logging_module ('PURGE PERFORMANCE LOG','Performance Log Purge');  

  COMMIT;
END;
/

-- Initialize performance log for Rollup DBMS job.
BEGIN
  mgmt_log.log_performance('ROLLUP');

  COMMIT;
END;
/


-- Add targets_delete table as a delete exception.
BEGIN
DECLARE del_exceptions SMP_EMD_STRING_ARRAY := SMP_EMD_STRING_ARRAY();
BEGIN
    -- Add deletion exceptions here
    del_exceptions.extend(5);
    del_exceptions(1) := 'MGMT_TARGETS_DELETE';
    del_exceptions(2) := 'MGMT_DUPLICATE_TARGETS';
    del_exceptions(3) := 'MGMT_METRICS_RAW';
    del_exceptions(4) := 'MGMT_METRICS_1HOUR';
    del_exceptions(5) := 'MGMT_METRICS_1DAY';
    MGMT_ADMIN.add_target_deletion_exceptions(del_exceptions);
END;
END;
/

-- Register wellknown target types
BEGIN
DECLARE l_type_properties SMP_EMD_NVPAIR_ARRAY;
BEGIN

  -- Database target type
  
  l_type_properties := SMP_EMD_NVPAIR_ARRAY (
         SMP_EMD_NVPAIR(MGMT_GLOBAL.G_DISALLOW_REDUNDANCY_GROUP, '1') );
  MGMT_TARGET.register_target_type(MGMT_GLOBAL.G_DATABASE_TARGET_TYPE,
                              'Database', 'name',
			      l_type_properties);
  l_type_properties.delete;

  -- Listener target type
  MGMT_TARGET.register_target_type(MGMT_GLOBAL.G_LISTENER_TARGET_TYPE,
                              'Listener', 'oracle_listener_name');

  COMMIT;

  -- Application server target type
  -- with is_composite = '1'
  l_type_properties := SMP_EMD_NVPAIR_ARRAY (
         SMP_EMD_NVPAIR(MGMT_GLOBAL.G_IS_COMPOSITE_PROP, '1'),
	 SMP_EMD_NVPAIR(MGMT_GLOBAL.G_DISALLOW_REDUNDANCY_GROUP, '1'));
  MGMT_TARGET.register_target_type(MGMT_GLOBAL.G_IAS_TARGET_TYPE,
                              'Oracle Application Server', 'ias_name',
			      l_type_properties);
  l_type_properties.delete;

  -- OC4J target type
  -- with is_composite = '1'
  l_type_properties := SMP_EMD_NVPAIR_ARRAY (
         SMP_EMD_NVPAIR(MGMT_GLOBAL.G_IS_COMPOSITE_PROP, '1'),
	 SMP_EMD_NVPAIR(MGMT_GLOBAL.G_DISALLOW_REDUNDANCY_GROUP, '1'));
  MGMT_TARGET.register_target_type(MGMT_GLOBAL.G_OC4J_TARGET_TYPE,
                              'OC4J', 'oc4j_name',
			      l_type_properties);
  l_type_properties.delete;

  -- Website target type
  -- with is_composite = '1'
  MGMT_TARGET.register_target_type(MGMT_GLOBAL.G_WEBSITE_TARGET_TYPE,
                              'Web Application', 'website_name');

  -- HTTP Server target type

  l_type_properties := SMP_EMD_NVPAIR_ARRAY (
         SMP_EMD_NVPAIR(MGMT_GLOBAL.G_DISALLOW_REDUNDANCY_GROUP, '1') );

  MGMT_TARGET.register_target_type(MGMT_GLOBAL.G_HTTP_SERVER_TARGET_TYPE,
                              'HTTP Server', 'oracle_apache_name',
                              l_type_properties);
  l_type_properties.delete;

  -- Web cache target type
  l_type_properties := SMP_EMD_NVPAIR_ARRAY (
         SMP_EMD_NVPAIR(MGMT_GLOBAL.G_DISALLOW_REDUNDANCY_GROUP, '0') );

  MGMT_TARGET.register_target_type(MGMT_GLOBAL.G_WEBCACHE_TARGET_TYPE,
                              'Web Cache', 'oracle_webcache_name',
                              l_type_properties);
  l_type_properties.delete;

  -- OC4J target type
  l_type_properties := SMP_EMD_NVPAIR_ARRAY (
         SMP_EMD_NVPAIR(MGMT_GLOBAL.G_DISALLOW_REDUNDANCY_GROUP, '1') );

  MGMT_TARGET.register_target_type(MGMT_GLOBAL.G_OC4J_TARGET_TYPE,
                              'OC4J', 'oracle_dms_name',
                              l_type_properties);
  l_type_properties.delete;

  -- BC4J target type
  MGMT_TARGET.register_target_type(MGMT_GLOBAL.G_BC4J_TARGET_TYPE,
                              'Business Components for Java', 'bc4j_name');

  COMMIT;

  -- LDAP target type
  MGMT_TARGET.register_target_type(MGMT_GLOBAL.G_LDAP_TARGET_TYPE,
                              'OID LDAP Server', 'oracle_ldap_server_name');

  -- Single Sign on server target type
  MGMT_TARGET.register_target_type(MGMT_GLOBAL.G_SSO_SERVER_TARGET_TYPE,
                              'Single Sign-On Server', 'SingleSignOn');

  -- Single Sign on server target type
  MGMT_TARGET.register_target_type(MGMT_GLOBAL.G_PORTAL_TARGET_TYPE,
                              'Portal', 'oracle_portal_name');

  COMMIT;
END;
END;
/

BEGIN
  -- Purge policy for MGMT_STRING METRIC_HISTORY
  EM_PURGE.add_purge_policy('MGMT_STRING_METRIC_HISTORY',
                            EM_PURGE.G_POLICY_TYPE_SYSTEM,
                            'EMD_LOADER.STRING_HISTORY_PURGE',
                            31*24,
                            NULL,
                            'Purge policy for String metric history.',
                            EM_PURGE.G_RETENTION_GROUP_LVL2_SUMMARY
                            );

  -- Purge policy for MGMT_METRIC_ERRORS
  EM_PURGE.add_purge_policy('MGMT_METRIC_ERRORS',
                            EM_PURGE.G_POLICY_TYPE_SYSTEM,
                            'EMD_LOADER.METRIC_ERROR_PURGE',
                            180*24,
                            NULL,
                            'Purge policy for Metric errors.',
                            EM_PURGE.G_RETENTION_GROUP_ALERTS
                            );
  COMMIT;
END;
/


rem
rem Keyonly threshold-based alert oracle_database.wait_sess_cls.count
rem
INSERT INTO mgmt_metrics_ext VALUES
(HEXTORAW('4996E975E5AC5A452156FE3E2A3D13FD'),
 'oracle_database', '2.1', '10i',
 DEFAULT, DEFAULT, DEFAULT, DEFAULT,
 DEFAULT, DEFAULT, 'Y');

rem
rem Keyonly threshold-based alert oracle_database.wait_sess_cls.wait_cs
rem
INSERT INTO mgmt_metrics_ext VALUES
(HEXTORAW('799C18F58BB4B590D3A7EA6EC7AA6C4C'),
 'oracle_database', '2.1', '10i',
 DEFAULT, DEFAULT, DEFAULT, DEFAULT,
 DEFAULT, DEFAULT, 'Y');

rem
rem Keyonly threshold-based alert oracle_database.service.elapsed_cs
rem
INSERT INTO mgmt_metrics_ext VALUES
(HEXTORAW('5820BF1AA43F88AA0CAF0BA6969B7B13'),
 'oracle_database', '2.1', '10i',
 DEFAULT, DEFAULT, DEFAULT, DEFAULT,
 DEFAULT, DEFAULT, 'Y');

rem
rem Keyonly threshold-based alert oracle_database.service.cpu_cs
rem
INSERT INTO mgmt_metrics_ext VALUES
(HEXTORAW('33C0C81DC02AD4304E565982C71FD269'),
 'oracle_database', '2.1', '10i',
 DEFAULT, DEFAULT, DEFAULT, DEFAULT,
 DEFAULT, DEFAULT, 'Y');

rem
rem Keyonly threshold-based alert oracle_database.file.read_cs
rem
INSERT INTO mgmt_metrics_ext VALUES
(HEXTORAW('7999FAFED7B9413248A38708FC034D65'),
 'oracle_database', '2.1', '10i',
 DEFAULT, DEFAULT, DEFAULT, DEFAULT,
 DEFAULT, DEFAULT, 'Y');

rem
rem Keyonly threshold-based alert oracle_database.file.write_cs
rem
INSERT INTO mgmt_metrics_ext VALUES
(HEXTORAW('7B8CC059F09F12BC5B29937406DDF53C'),
 'oracle_database', '2.1', '10i',
 DEFAULT, DEFAULT, DEFAULT, DEFAULT,
 DEFAULT, DEFAULT, 'Y');

rem
rem Non-threshold based alert oracle_database.Recovery_Area.Free_Space
rem
INSERT INTO mgmt_metrics_ext VALUES
(HEXTORAW('3F2BBE6BF105C0D16A3710F2868B8399'),
 'oracle_database', '2.1', '10i',
 DEFAULT, DEFAULT, DEFAULT, DEFAULT,
 DEFAULT, 'N', DEFAULT);

rem
rem Non-threshold based alert oracle_database.Suspended_Session.Tablespace
rem
INSERT INTO mgmt_metrics_ext VALUES
(HEXTORAW('8FBCDDD764847D03E3882564E85DADBD'),
 'oracle_database', '2.1', '10i',
 DEFAULT, DEFAULT, DEFAULT, DEFAULT,
 DEFAULT, 'N', DEFAULT);

rem
rem Non-threshold based alert oracle_database.Suspended_Session.Rollback_Segment
rem
INSERT INTO mgmt_metrics_ext VALUES
(HEXTORAW('970054759B20844C7FECFC236BD8EC4A'),
 'oracle_database', '2.1', '10i',
 DEFAULT, DEFAULT, DEFAULT, DEFAULT,
 DEFAULT, 'N', DEFAULT);

rem
rem Non-threshold based alert oracle_database.Suspended_Session.Data_Object
rem
INSERT INTO mgmt_metrics_ext VALUES
(HEXTORAW('C4219FD236BA6B4277D993CBEDCA160C'),
 'oracle_database', '2.1', '10i',
 DEFAULT, DEFAULT, DEFAULT, DEFAULT,
 DEFAULT, 'N', DEFAULT);

rem
rem Non-threshold based alert oracle_database.Suspended_Session.Quota
rem
INSERT INTO mgmt_metrics_ext VALUES
(HEXTORAW('9DEE122999951641979D669AE4AEA4AA'),
 'oracle_database', '2.1', '10i',
 DEFAULT, DEFAULT, DEFAULT, DEFAULT,
 DEFAULT, 'N', DEFAULT);

rem
rem Non-threshold based alert oracle_database.Snap_Shot_Too_Old.Tablespace
rem
INSERT INTO mgmt_metrics_ext VALUES
(HEXTORAW('109613CA182F59DA38A43D8C1E79E7AB'),
 'oracle_database', '2.1', '10i',
 DEFAULT, DEFAULT, DEFAULT, DEFAULT,
 DEFAULT, 'N', DEFAULT);

rem
rem Non-threshold based alert oracle_database.Snap_Shot_Too_Old.Rollback_Segment
rem
INSERT INTO mgmt_metrics_ext VALUES
(HEXTORAW('ABF0447428D1F6A801626203A3A0A531'),
 'oracle_database', '2.1', '10i',
 DEFAULT, DEFAULT, DEFAULT, DEFAULT,
 DEFAULT, 'N', DEFAULT);

rem
rem Non-threshold based alert rac_database.Recovery_Area.Free_Space
rem Cluster db-level metric
rem
INSERT INTO mgmt_metrics_ext VALUES
(HEXTORAW('BE99716C462B6C3CB41A3E2D31D76352'),
 'rac_database', '2.1', '10i',
 DEFAULT, DEFAULT, DEFAULT, DEFAULT,
 DEFAULT, 'N', DEFAULT);

rem
rem Non-threshold based alert rac_database.Suspended_Session.Tablespace
rem Cluster db-level metric
rem
INSERT INTO mgmt_metrics_ext VALUES
(HEXTORAW('B201CC479402186825F8D7836BBE8007'),
 'rac_database', '2.1', '10i',
 DEFAULT, DEFAULT, DEFAULT, DEFAULT,
 DEFAULT, 'N', DEFAULT);

rem
rem Non-threshold based alert rac_database.Suspended_Session.Rollback_Segment
rem Cluster db-level metric
rem
INSERT INTO mgmt_metrics_ext VALUES
(HEXTORAW('84B2E7FEAEE909B0F09DB4B41C5F2BC0'),
 'rac_database', '2.1', '10i',
 DEFAULT, DEFAULT, DEFAULT, DEFAULT,
 DEFAULT, 'N', DEFAULT);

rem
rem Non-threshold based alert rac_database.Suspended_Session.Data_Object
rem Cluster db-level metric
rem
INSERT INTO mgmt_metrics_ext VALUES
(HEXTORAW('74CBDDCF0FDCBD1ADD48EF85EA1877D2'),
 'rac_database', '2.1', '10i',
 DEFAULT, DEFAULT, DEFAULT, DEFAULT,
 DEFAULT, 'N', DEFAULT);

rem
rem Non-threshold based alert rac_database.Suspended_Session.Quota
rem Cluster db-level metric
rem
INSERT INTO mgmt_metrics_ext VALUES
(HEXTORAW('1772B8B7FACF05C1FD35FF711B092461'),
 'rac_database', '2.1', '10i',
 DEFAULT, DEFAULT, DEFAULT, DEFAULT,
 DEFAULT, 'N', DEFAULT);

rem
rem Non-threshold based alert rac_database.Snap_Shot_Too_Old.Tablespace
rem Cluster db-level metric
rem
INSERT INTO mgmt_metrics_ext VALUES
(HEXTORAW('F0618F81F9BB09B4767ECFF97F465BF7'),
 'rac_database', '2.1', '10i',
 DEFAULT, DEFAULT, DEFAULT, DEFAULT,
 DEFAULT, 'N', DEFAULT);

rem
rem Non-threshold based alert rac_database.Snap_Shot_Too_Old.Rollback_Segment
rem Cluster db-level metric
rem
INSERT INTO mgmt_metrics_ext VALUES
(HEXTORAW('73D3A217BA3190713B9B7153D08F0696'),
 'rac_database', '2.1', '10i',
 DEFAULT, DEFAULT, DEFAULT, DEFAULT,
 DEFAULT, 'N', DEFAULT);


rem
rem Setting default value for purge batchsize
rem

EXEC EMD_LOADER.set_purge_batchsize (p_purge_batchsize => EMD_LOADER.p_purge_batchsize);


-- 1020101 initialization done by calling the common init
@@&&EM_SQL_ROOT/core/v102010/basic/basic_common_init.sql
@@&&EM_SQL_ROOT/core/v102020/basic_data_upgrade.sql
@@&&EM_SQL_ROOT/core/v102020/basic/basic_data_upgrade.sql
