Rem drv: <create type="tables" params="EM_ECM_DEPOT_TABLESPACE"/>
Rem
Rem $Header: basic_tables.sql 23-apr-2007.23:28:22 jsadras Exp $
Rem
Rem basic_tables.sql
Rem
Rem Copyright (c) 2002, 2007, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      basic_tables.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    jsadras     04/02/07 - move last_sync_load_details to basic_tables_gc/db
Rem    jsadras     04/23/07 - Backport jsadras_bug-5934433 from main
Rem    neearora    07/16/06 - Backport neearora_bug-5108394 from main 
Rem    neearora    04/06/06 - Bug 5108394. added handler_type in 
Rem                           PK of mgmt_rowset_handlers        
Rem    jsadras     09/12/05 - add comments for keys_from_mult_coll 
Rem    neearora    07/06/05 - Bug 4447004. Added script for 
Rem                           MGMT_LAST_SYNC_LOAD_DETAILS 
Rem    gsbhatia    06/26/05 - New repmgr header impl 
Rem    dcawley     06/15/05 - Increase size of user name in annotation table 
Rem    pmodi       05/26/05 - Bug:4396320 -change default value of is_transposed to NULL 
Rem    rpinnama    05/17/05 - Add is_renderable to mgmt_metrics 
Rem    rmarripa    05/06/05 - set default value for remote column to NULL 
Rem    jsadras     05/02/05 - add long_running 
Rem    jsadras     03/10/05 - add mgmt_callback.eval_order 
Rem    rpinnama    02/25/05 - Bug 3924067: Add non_thresholded_alerts, 
Rem                           keyonly_thresholds columns to mgmt_metrics 
Rem    pmodi       02/23/05 - Setting default of timezone_region to NULL in 
Rem                           mgmt_targets 
Rem    gsbhatia    02/13/05 - updating repmgr header 
Rem    gsbhatia    02/09/05 - updating repmgr header 
Rem    gsbhatia    02/07/05 - updating repmgr header 
Rem    scgrover    02/01/05 - comporess iot 
Rem    ktlaw       01/11/05 - add repmgr header 
Rem    asawant     11/10/04 - Adding mgmt_target_type_versions 
Rem    rpinnama    12/23/04 - Add mgmt_target_type_versions table 
Rem    rmaggarw    10/08/04 - Add mgmt_loader_designators 
Rem    jsadras     10/19/04 - timing
Rem    ramalhot    10/14/04 - one more column added in mgmt_callback table 
Rem    kmanicka    09/14/04 - added column owner in MGMT_TARGET
Rem    rpinnama    09/29/04 - Add rowset handlers table 
Rem    gan         09/14/04 - add remote column for mgmt_metrics 
Rem    groyal      09/13/04 - Add mgmt_messages 
Rem    ramalhot    08/22/04 - mgmt_callback pk changed 
Rem    gan         08/20/04 - add monitoring 
Rem    rpinnama    08/19/04 - Add is_test_metric, has_push, has_pull to mgmt_metrics
Rem    streddy     08/09/04 - Add is_transposed column to mgmt_metrics 
Rem    asawant     06/03/04 - Adding extra columns for UDTP 
Rem    rzkrishn    07/30/04 - using MGMT_CALLBACKS for relocation target 
Rem                           callbacks as well 
Rem    rpinnama    07/30/04 - Make author 256 chars 
Rem    ramalhot    07/09/04 - mgmt_targets modified for assoc 
Rem    ramalhot    07/06/04 - global callback table added 
Rem    asawant     06/29/04 - Adding columns necessary for UDTP 
Rem    gachen      06/14/04 - add usage_type 
Rem    rpinnama    06/15/04 - Add source_type columns to support repository 
Rem                           metrics 
Rem    rpinnama    11/05/03 - 
Rem    rpinnama    10/30/03 - Add table to store metadata load status 
Rem    rpinnama    09/25/03 - set initrans for mgmt_target_types and 
Rem    jsoule      08/18/03 - add table for metric metadata extension 
Rem    rpinnama    07/18/03 - Add agent_guid, coll_name to metric_errors
Rem    streddy     07/10/03 - Added mgmt_annotation table
Rem    skini       07/10/03 - Tables for associations
Rem    skini       06/30/03 - Fixes for reducing db blocksize
Rem    streddy     04/21/03 - Add target callback support
Rem    rpinnama    05/26/03 - Add comments
Rem    sgrover     04/12/03 - move string_value to overflow table
Rem    mbhoopat    05/13/03 - support server generated alerts
Rem    streddy     04/08/03 - Add a new column for tracking repository side availability
Rem    rzkrishn    04/09/03 - adding MASTER_AGENT table 
Rem    sgrover     03/19/03 - remove variance column
Rem    rpinnama    03/13/03 - Add property_display_nlsid column
Rem    rpinnama    02/27/03 - Parameterize the ECM depot table space
Rem    streddy     02/14/03 - Added monitoring_mode column
Rem    root        01/24/03 - add type_display_name back to MGMT_TARGETS
Rem    xxu         01/14/03 - add nlsid
Rem    vnukal      12/30/02 - Add coll_name to mgmt_metric_errors and mgmt_current_metric_errors
Rem    rpinnama    02/06/03 - Add type_meta_ver column
Rem    rpinnama    01/17/03 - Add timezoneregion to duplicate targets
Rem    snakai      01/02/03 - Add new load_time to mgmt_targets
Rem    rpinnama    12/18/02 - Add delete_completion_time
Rem    rpinnama    11/21/02 - Add target_name and target_type to duplicate list
Rem    rpinnama    11/11/02 - 
Rem    rpinnama    11/08/02 - add mgmg_change_agent_url table
Rem    rpinnama    11/01/02 - Add support for duplicates
Rem    njagathe    11/13/02 - Adding additional key columns
Rem    njagathe    10/24/02 - Increasing short name length from 14 to 20
Rem    rpinnama    09/09/02 - Add timezone region name
Rem    xxu         09/03/02 - add columns for metric versioning
Rem    edemembe    08/21/02 - Adding IOTs
Rem    skini       07/15/02 - Increase display_name to 256
Rem    njagathe    07/11/02 - Adding target_guid to composite_keys table
Rem    skini       07/11/02 - Increase target name length to 256
Rem    skini       07/02/02 - Add emd_url column to mgmt_targets_delete
Rem    mbhoopat    06/06/02 - Add broken cols to mgmt_targets.
Rem    rpinnama    05/14/02 - rpinnama_reorg_rep_scripts
Rem    rpinnama    05/14/02 - Created
Rem

rem  NOTES
rem  This section provides an example of how information from the target is 
rem  mapped to the metric table in the reporting schema for table types.  
rem
rem
rem  To help provide context for the example, we will use the following 
rem  table of information:
rem
rem
rem  Target:          SLIMER
rem  Target type:     HOST
rem  TimezoneDelta:   0
rem  Display Name:    "Host Information"
rem
rem
rem  The following metrics are defined for the HOST type
rem
rem  ProcessCount : 147
rem
rem  DiskInformation
rem
rem         ------- this is the key column
rem         |
rem        \./
rem  .---------------------------------.
rem  | FileSystem  | SpaceUsed  | Util |
rem  |----------------------------------
rem  |    /usr     |    30.1    | 60.0 |
rem  |.................................|
rem  |    /sys     |    45.2    | 33.5 |
rem  |.................................|
rem  |    /prv     |    85.1    | 29.2 |
rem  .---------------------------------.
rem
rem  These metrics are mapped into the reporting schema as follows:
rem
rem   
rem  To define the HOST metric in the reporting schema, the host type should
rem  be mapped as follows:
rem
rem  This section defines the process count "simple" metric
rem
rem  Target name:        SLIMER
rem  Target type:        HOST
rem  Metric name:        ProcessCount
rem  Metric type:        0
rem  Warning threshold:  Greater than 200
rem  Critical threshold: Greater than 250
rem  Label:              Process Count
rem  Description:        The maximum number of processes observed on the 
rem                      host for the interval period 
rem  Unit:               processes
rem
rem  This section defines the disk information "table" metric.  We need
rem  one row to define the table metric, then a row for each column of
rem  the table.
rem
rem  Target name:        SLIMER
rem  Target type:        HOST
rem  Metric name:        DiskInformation
rem  Metric type:        2
rem  Metric column:
rem  Key column:         FileSystem
rem  Label:              Disk Information
rem  Description:        Disk metrics that I care about for my host
rem  
rem  Target name:        SLIMER
rem  Target type:        HOST
rem  Metric name:        DiskInformation
rem  Metric type:        1
rem  Metric column:      FileSystem
rem  Key column:         FileSystem
rem  Label:              File System
rem  Description:        Individual file system that I'm interested in.  This
rem                      is the key for my disk information table metric
rem
rem  Target name:        SLIMER
rem  Target type:        HOST
rem  Metric name:        DiskInformation
rem  Metric type:        0
rem  Metric column:      SpaceUsed
rem  Key column:         FileSystem
rem  Label:              Total Space Used
rem  Warning threshold:  Greater than 80
rem  Critical threshold: Greater than 90
rem  Description:        Percentage of space used for the file system
rem  Unit:               (%)
rem
rem  Target name:        SLIMER
rem  Target type:        HOST
rem  Metric name:        DiskInformation
rem  Metric type:        0
rem  Metric column:      Util
rem  Key column:         FileSystem
rem  Label:              File System Utilization
rem  Warning threshold:  Greater than 80
rem  Critical threshold: Greater than 90
rem  Description:        The average file system utilization over the interval
rem  Unit:               (%)
rem
rem  Given the above information, we can identify the types of metrics that are
rem  being collected on the target (SLIMER) and give the user details about which
rem  metrics are part of the type on the node.  From the maintanence portion of the
rem  product, we will use this information from the metrics table to show the user
rem  what metrics have been collected, and allow the user to see when targets and
rem  metrics were last loaded into the reporting schema, as well as to remove
rem  individual metrics that are obsolete.
rem
rem  The threshold information is read only in the reporting schema and is provided
rem  for informational purposes - it sets a context for the metric data and the
rem  alert information.  Thresholds are intended to hold a user readable string that
rem  provides details on the set of thresholds defined at the target for a metric.
rem  The thresholds represent the current settings at the target.  We do not track
rem  changes to the thresholds over time.
rem
rem
rem  Once the HOST metric has been defined in the reporting schema, the host
rem  information can be stored in the reporting schema.  This section shows how
rem  the example is mapped.  The reporting schema will automatically roll up
rem  this information as approprate.
rem
rem  This section shows a row of the process count "simple" metric data
rem
rem  Target name:        SLIMER
rem  Target type:        HOST
rem  Metric name:        ProcessCount
rem  Collection date:    17-DEC-2000 15:49:00
rem  Metric type:        0
rem  Value:              147
rem
rem  This section shows how metric data for the more complex disk information
rem  "table" data should be mapped
rem
rem
rem  Target name:        SLIMER
rem  Target type:        HOST
rem  Metric name:        DiskInformation
rem  Metric type:        0
rem  Collection date:    17-DEC-2000 15:49:00
rem  Metric column:      SpaceUsed
rem  Key column:         FileSystem
rem  Key value:          /usr
rem  Value:              30.1
rem
rem  Target name:        SLIMER
rem  Target type:        HOST
rem  Metric name:        DiskInformation
rem  Metric type:        0
rem  Collection date:    17-DEC-2000 15:49:00
rem  Metric column:      SpaceUsed
rem  Key column:         FileSystem
rem  Key value:          /sys
rem  Value:              45.2
rem
rem  Target name:        SLIMER
rem  Target type:        HOST
rem  Metric name:        DiskInformation
rem  Metric type:        0
rem  Collection date:    17-DEC-2000 15:49:00
rem  Metric column:      SpaceUsed
rem  Key column:         FileSystem
rem  Key value:          /prv
rem  Value:              85.1
rem
rem  Target name:        SLIMER
rem  Target type:        HOST
rem  Metric name:        DiskInformation
rem  Metric type:        0
rem  Collection date:    17-DEC-2000 15:49:00
rem  Metric column:      Util
rem  Key column:         FileSystem
rem  Key value:          /usr
rem  Value:              60.0
rem
rem  Target name:        SLIMER
rem  Target type:        HOST
rem  Metric name:        DiskInformation
rem  Metric type:        0
rem  Collection date:    17-DEC-2000 15:49:00
rem  Metric column:      Util
rem  Key column:         FileSystem
rem  Key value:          /sys
rem  Value:              33.5
rem
rem  Target name:        SLIMER
rem  Target type:        HOST
rem  Metric name:        DiskInformation
rem  Metric type:        0
rem  Collection date:    17-DEC-2000 15:49:00
rem  Metric column:      Util
rem  Key column:         FileSystem
rem  Key value:          /prv
rem  Value:              29.2
rem
rem  Note that the collection date for a set of table metrics should be the
rem  same.  Also note that the key value is not stored as a separate row in the
rem  metric data tables - it is used specifically as part of the primary key
rem  for reporting purposes to identify a particular row in the table of
rem  information that was collected - then flattened into simple metrics.
rem

rem
rem This script requires the following arguments
rem  1. Name of the ecm_depot tablespace where all LOBs are stored
rem
DEFINE EM_ECM_DEPOT_TABLESPACE = "&1"


rem
rem Some SQL define
rem
DEFINE EM_TARGET_NAME_SIZE=256
DEFINE EM_TARGET_TYPE_SIZE=64
DEFINE EM_META_VER_SIZE=8
DEFINE EM_URL_SIZE=1024
DEFINE EM_CLASS_NAME_SIZE=64
DEFINE EM_CATEGORY_NAME_SIZE=64
DEFINE EM_DEFAULT_NLSID_SIZE=64



rem
rem  PURPOSE
rem
rem     The MGMT_METRICS table provides metric descriptions for a given target
rem     name and target type.  This table is primarily used to make the standard
rem     reports more understandable.
rem
rem     The content of the MGMT_METRICS table is close to what you will find in
rem     the MGMT_METRICS_RAW table.  A key difference is that the RAW table
rem     also contains a timestamp, so there will be multiple rows per metric, making
rem     it much bigger.  Maintenence queries where the user wants to understand what
rem     metrics are defined for a target will use the MGMT_METRICS table.  This
rem     will be much more efficient and performant than using the SM_VTD_METRICS_RAW
rem     table.
rem
rem  COLUMNS
rem
rem     TARGET_TYPE - the type of the target.  The type defines the set of
rem                   metrics that are applicable for the target.
rem
rem     CATEGORY_PROP_1
rem     CATEGORY_PROP_2
rem     CATEGORY_PROP_3
rem     CATEGORY_PROP_4
rem     CATEGORY_PROP_5
rem
rem                 - up to 5 category properties can be used to distinguish
rem                   different metric definitions based on different configuration
rem                   For example, OS version, DB version, RAC configuration, etc..
rem
rem     METRIC_NAME - the name of the metric that is being defined
rem
rem     METRIC_TYPE - the type of information the metric represents.  Only basic
rem                   types are supported.
rem
rem                         0 - NUMBER
rem                         1 - STRING
rem                         2 - TABLE  (table with one column primary key, no alternate keys)
rem                         3 - RAW (long character object)
rem                         4 - EXTERNAL
rem                         5 - REPOSITORY_TABLE
rem                         6 - REPOSITORY_NUMBER
rem                         7 - REPOSITORY_STRING
rem
rem                   The type is used during the rollup process to determine whether
rem                   the metric can be rolled up or not.  It also provides additional
rem                   information for the report formating for the metric's value.
rem
rem
rem     USAGE_TYPE -  how the metric should be used
rem                         0 - VIEW_COLLECT      metric is viewable in All Metric page
rem                         1 - REALTIME_ONLY     metric not viewable, may have duplicate key
rem                         2 - DISPLAY_ONLY      (obsolate) ,  map to REALTIME_ONLY
rem                         3 - MULTI_KEY         (obsolate),   map to VIEW_COLLECT
rem                         4 - COLLECT_ONLY      (obsolate),   map to VIEW_COLLECT
rem                         5 - HIDDEN            metric not viewable, not collectable, not uploadable
rem                         6 - HIDDEN_COLLECT    metric not viewable, collectable, not uploadable
rem                         7 - COLLECT_UPLOAD    metric not viewable, collectable, uploadable
rem
rem     METRIC_GUID
rem
rem                 - A unique ID for the metric.  It can be used to associate
rem                   metric information with metric data information during
rem                   reporting.
rem
rem     EVAL_FUNC
rem
rem                 - For repository side metrics, the PL/SQL procedure that
rem                   when executed provides the values for the metric. The
rem                   procedure must look like the following:
rem
rem       PROCEDURE EVAL_PROC(v_target_guid   IN RAW,
rem                           v_metric_guid   IN RAW
rem                           v_metric_result OUT
rem                                       EMD_COLLECTION.MGMT_METRIC_RESULTS);
rem
rem     LOAD_TIMESTAMP - The date/time when the metric record was first loaded
rem
rem     METRIC_COLUMN
rem
rem                 - If the metric defined at collection time is a TABLE type, the
rem                   name of the column in the table that is represented by this
rem                   metric is written to this field.  This information is used
rem                   flatten the table construct that was collected into a simple
rem                   metric for reporting purposes.  The metric column is part of the
rem                   primary key that uniqely identifies the value of the table that
rem                   this metric represents.  For example, if this metric is defining
rem                   a Util value in a metric - DiskInformation, then the value in this
rem                   field would be "Util".
rem
rem
rem     COLUMN_LABEL - The display name for this column of a table metric
rem
rem     COLUMN_LABEL_NLSID
rem
rem                  - The nlsid of the display name for this column of a table metric
rem
rem     METRIC_LABEL - The display name for this metric
rem
rem     METRIC_LABEL_NLSID
rem
rem                  - The nlsid of the display name for this metric
rem
rem     KEY_COLUMN  - If the metric defined at collection time is a TABLE type, the
rem                   metric name of the column in the table that is designated as the
rem                   key should be written here.  For example, if a table
rem                   of disk information includes a FileSystem column that contains
rem                   key information for metrics such as space usage and file system
rem                   utilization, then this field would contain FileSystem.
rem
rem     KEY_ORDER   - Lists the order of the key columns. This value is set to
rem                   0 for non-key metric columns and can have values 1 to 3
rem                   for the key columns
rem
rem     NUM_KEYS    - The number of key metric columns in the metric. Valid
rem                   values are 0 to 3.
rem
rem     DESCRIPTION - A more detailed description of the metric
rem
rem     DESCRIPTION_NLSID
rem
rem                 - The nlsid of the more detailed description of the metric
rem
rem     UNIT        - The unit of the metric
rem
rem     UNIT_NLSID  - The nlsid of the unit of the metric
rem
rem     SHORT_NAME  - This is a shortened version of the metric display name for
rem                   the "dense" UI concept.
rem
rem     SHORT_NAME_NLSID
rem
rem                 - The nlsid of the shortened version of the metric display name for
rem                   the "dense" UI concept.
rem
rem     IS_FOR_SUMMARY
rem
rem                 - This flag specifies whether or not this metric should be
rem                   displayed as part of a "summary" UI. 1=TRUE, 0=FALSE
rem
rem     KEYS_FROM_MULT_COLLS
rem
rem                 - This flag specifies whether or not this metric should be
rem                   purged from the MGMT_CURRENT_METRICS table using its key
rem                   value. 1=TRUE, 0=FALSE
rem                   1(TRUE) means the keys for this metric are generated from
rem                   multiple collections.
rem
rem     STATEFULL
rem
rem                 - This flag specifies whether or not severities generated
rem                   by this metric will be cleared by agent.
rem                   1=TRUE, 0=FALSE 
rem                   Alert log metric of the database is a stateless metric
rem
rem    IS_LONG_RUNNING
rem                 - Flag specifies whether the metric is a long running metric
rem                   1=TRUE, 0=FALSE(Default)
rem
rem  NOTES
rem
rem     There is a check constraint on this table and the targets table on
rem     target_type.  It is used to enforce the condition that a type must exist
rem     in the targets table before a row can be inserted into the metrics table.
rem
rem     NULL default is used for non_thresholded_alerts and keyonly_thresholds
rem     so that the pre-insert triggers populates them with NULL.
rem     This helps in distinguishing whether the insert is providing values for
rem     these columns or not.
rem

CREATE TABLE MGMT_METRICS
(
    target_type                VARCHAR2(&EM_TARGET_TYPE_SIZE)    NOT NULL,
    type_meta_ver              VARCHAR2(8)     DEFAULT '1.0',
    category_prop_1            VARCHAR2(64)    DEFAULT ' ',
    category_prop_2            VARCHAR2(64)    DEFAULT ' ',
    category_prop_3            VARCHAR2(64)    DEFAULT ' ',
    category_prop_4            VARCHAR2(64)    DEFAULT ' ',
    category_prop_5            VARCHAR2(64)    DEFAULT ' ',
    metric_name                VARCHAR2(64)    NOT NULL,
    metric_type                NUMBER          DEFAULT 0,
    usage_type                 NUMBER          DEFAULT 0,
    metric_guid                RAW(16)         DEFAULT SYS_GUID() NOT NULL,
    metric_column              VARCHAR2(64)    DEFAULT ' ',
    column_label               VARCHAR2(64)    DEFAULT NULL,
    column_label_nlsid         VARCHAR2(64)    DEFAULT NULL,
    metric_label               VARCHAR2(64)    DEFAULT NULL,
    metric_label_nlsid         VARCHAR2(64)    DEFAULT NULL,
    key_column                 VARCHAR2(512)   DEFAULT ' ',
    key_order                  NUMBER          DEFAULT 0,
    num_keys                   NUMBER          DEFAULT 0,
    description                VARCHAR2(128)   DEFAULT ' ',
    description_nlsid          VARCHAR2(64)    DEFAULT NULL,
    unit                       VARCHAR2(32)    DEFAULT ' ',
    unit_nlsid                 VARCHAR2(64)    DEFAULT NULL,
    short_name                 VARCHAR2(40)    DEFAULT NULL,
    short_name_nlsid           VARCHAR2(64)    DEFAULT NULL,
    is_for_summary             NUMBER          DEFAULT 0,
    keys_from_mult_colls       NUMBER          DEFAULT 0,
    statefull                  NUMBER          DEFAULT 1,
    is_repository              NUMBER(1)       DEFAULT 0,
    author                     VARCHAR2(256)   DEFAULT 'ORACLE',
    source_type                NUMBER(1)       DEFAULT 0,
    source                     VARCHAR2(4000)  DEFAULT NULL,
    load_timestamp             DATE            DEFAULT SYSDATE,
    is_transposed              NUMBER(1)       DEFAULT NULL,
    is_test_metric             NUMBER(1)       DEFAULT 0,
    has_push                   NUMBER(1)       DEFAULT 0,
    has_pull                   NUMBER(1)       DEFAULT 0,
    remote                     NUMBER(1)       DEFAULT NULL,
    repo_timing_enabled        NUMBER(1)       DEFAULT 0,
    non_thresholded_alerts     NUMBER(1)       DEFAULT NULL,
    keyonly_thresholds         NUMBER(1)       DEFAULT NULL,
    is_long_running            NUMBER(1)       DEFAULT 0,
    is_renderable              NUMBER(1)       DEFAULT 1,
-- This column has been obsoleted.
    eval_func                  VARCHAR2(256)   DEFAULT ' '
)
INITRANS 2
MONITORING;

COMMENT ON TABLE MGMT_METRICS IS
  'The MGMT_METRICS table provides metric descriptions for a given target
   name and target type.  This table is primarily used to make the standard
   reports more understandable.
   The content of the MGMT_METRICS table is close to what you will find in
   the MGMT_METRICS_RAW table.  A key difference is that the RAW table
   also contains a timestamp, so there will be multiple rows per metric, making
   it much bigger.  Maintenence queries where the user wants to understand what
   metrics are defined for a target will use the MGMT_METRICS table.  This
   will be much more efficient and performant.';

COMMENT ON COLUMN MGMT_METRICS.TARGET_TYPE IS
  'the type of the target.  The type defines the set of metrics that are 
   applicable for the target.';

COMMENT ON COLUMN MGMT_METRICS.TYPE_META_VER IS
  'This identifies the metaversion of the target type.';

COMMENT ON COLUMN MGMT_METRICS.CATEGORY_PROP_1 IS
  'up to 5 category properties can be used to distinguish different metric
   definitions based on different configuration. For example, OS version, DB
   version, RAC configuration, etc.';

COMMENT ON COLUMN MGMT_METRICS.METRIC_NAME IS
  'the name of the metric that is being defined.';

COMMENT ON COLUMN MGMT_METRICS.METRIC_TYPE IS
  'The type of information the metric represents.  Only basic types are 
   supported.
    0 - NUMBER
    1 - STRING
    2 - TABLE 
    3 - RAW
    4 - EXTERNAL
    5 - REPOSITORY_TABLE
    6 - REPOSITORY_NUMBER
    7 - REPOSITORY_STRING.
   The type is used during the rollup process to determine whether
   the metric can be rolled up or not.  It also provides additional
   information for the report formating for the metrics value.';

COMMENT ON COLUMN MGMT_METRICS.METRIC_GUID IS
  'A unique ID for the metric.  It can be used to associate metric information 
   with metric data information during reporting the name of the metric that 
   is being defined.';

COMMENT ON COLUMN MGMT_METRICS.METRIC_COLUMN IS
  'If the metric defined at collection time is a TABLE type, the name of the 
   column in the table that is represented by this metric is written to this 
   field.  This information is used flatten the table construct that was 
   collected into a simple metric for reporting purposes.  The metric column is 
   part of the primary key that uniqely identifies the value of the table that 
   this metric represents.  For example, if this metric is defining a Util 
   value in a metric - DiskInformation, then the value in this field 
   would be "Util".';

COMMENT ON COLUMN MGMT_METRICS.COLUMN_LABEL IS
  'The display name for this column of a table metric.';

COMMENT ON COLUMN MGMT_METRICS.COLUMN_LABEL_NLSID IS
  'The nlsid of the display name for this column of a table metric.';

COMMENT ON COLUMN MGMT_METRICS.METRIC_LABEL IS
  'The display name for this metric.';

COMMENT ON COLUMN MGMT_METRICS.METRIC_LABEL_NLSID IS
  'The nlsid of the display name for this metric.';

COMMENT ON COLUMN MGMT_METRICS.KEY_COLUMN  IS
  'If the metric defined at collection time is a TABLE type, the metric
     name of the column in the table that is designated as the key should be
     written here.  For example, if a table of disk information includes a 
     FileSystem column that contains key information for metrics such as space
     usage and file system utilization, then this field would contain
     FileSystem.';

COMMENT ON COLUMN MGMT_METRICS.KEY_ORDER   IS
  'Lists the order of the key columns. This value is set to 0 for non-key
     metric columns and can have values 1 to 5 for the key columns.';

COMMENT ON COLUMN MGMT_METRICS.NUM_KEYS    IS 
  'The number of key metric columns in the metric. Valid values are 0 to 5.';

COMMENT ON COLUMN MGMT_METRICS.DESCRIPTION IS
  'A more detailed description of the metric.';

COMMENT ON COLUMN MGMT_METRICS. DESCRIPTION_NLSID IS
  'The nlsid of the more detailed description of the metric.';

COMMENT ON COLUMN MGMT_METRICS.UNIT    IS
  'The unit of the metric.';

COMMENT ON COLUMN MGMT_METRICS.UNIT_NLSID  IS
  'The nlsid of the unit of the metric.';

COMMENT ON COLUMN MGMT_METRICS.SHORT_NAME  IS
  'This is a shortened version of the metric display name for the "
   dense" UI concept.';

COMMENT ON COLUMN MGMT_METRICS.SHORT_NAME_NLSID IS
  'The nlsid of the shortened version of the metric display name for the
   "dense" UI concept.';

COMMENT ON COLUMN MGMT_METRICS.IS_FOR_SUMMARY IS
  'This flag specifies whether or not this metric should be displayed as part
   of a "summary" UI. 1=TRUE, 0=FALSE.';

COMMENT ON COLUMN MGMT_METRICS.KEYS_FROM_MULT_COLLS IS
  'This flag specifies whether or not this metric should be purged from the
   MGMT_CURRENT_METRICS table using its key value. 1=TRUE, 0=FALSE.';

COMMENT ON COLUMN MGMT_METRICS.STATEFULL IS
  'This flag specifies whether or not severities generated by this metric
   will be cleared by agent. 1=TRUE, 0=FALSE
   Alert log metric of the database is a stateless metric.';

COMMENT ON COLUMN MGMT_METRICS.IS_REPOSITORY IS
  'This column distinguishes repository metrics from agent side metrics.
   If is_repository =1, then the metric is a repository metric. Agent metric
   otherwise.';

COMMENT ON COLUMN MGMT_METRICS.AUTHOR IS
  'Author of the metric definition. Default is <ORACLE>':

COMMENT ON COLUMN MGMT_METRICS.SOURCE_TYPE IS
  'Only applicable for repository-side metrics.  (IS_REPOSITORY=1).
   Valid values are:1 - PL/SQL 2 - QUERY 3 - Batch PL/SQL.';

COMMENT ON COLUMN MGMT_METRICS.SOURCE IS
  'If SOURCE_TYPE =1, the PL/SQL procedure that when executed provides the
                        values for the metric.
   If SOURCE_TYPE = 2, then the SQL statement.
   Else if SOURCE_TYPE = 3, the contains the PL/SQL procedure to do bulk
    Collection.';

COMMENT ON COLUMN MGMT_METRICS.LOAD_TIMESTAMP IS
  'The date/time when the metric record was first loaded.';


COMMENT ON COLUMN MGMT_METRICS.IS_TRANSPOSED IS
  'This column distinguishes transposed metrics from regular metrics. Transposed metrics are metrics whose metric columns are not known at definition time and only known at run time.The values of the key columns are used as the names for the data columns.
   If IS_TRANSPOSED = 0, then it means that the metric is not transposed.
   If IS_TRANSPOSED = 1, then it means that the metric is transposed';

COMMENT ON COLUMN MGMT_METRICS.IS_TEST_METRIC IS
  'This column distinguishes identifies whether a metric is a test metric or not.
   Test metrics are metrics that are collected for a target before a target is added to the agent to 
   test whether the target is properly configured.';

COMMENT ON COLUMN MGMT_METRICS.HAS_PUSH IS
  'This column distinguishes whether the agent metric has PushDescriptor. 
   Applicable only for agent metrics';

COMMENT ON COLUMN MGMT_METRICS.HAS_PULL IS
  'This column distinguishes whether the agent metric has QueryDescriptor or ExecutionDescriptor. 
   Applicable only for agent metrics.';

COMMENT ON COLUMN MGMT_METRICS.REMOTE IS
  'This column distinguishes remotely collectable metrics from regular metrics. Remotely collectable metrics are metrics collected from beacon.
   If REMOTE = 0, then it means that the metric is not remotely collectable.
   If REMOTE = 1, then it means that the metric is remotely collectable';

COMMENT ON COLUMN MGMT_METRICS.repo_timing_enabled IS
  'Stores if timing has to be enabled for metrics
     0 = Timing not written to system performance log
     1 = Timing written to system performance log' ;

COMMENT ON COLUMN MGMT_METRICS.non_thresholded_alerts IS
  'This column distinguishes of alerts can be logged for this metric or metric column
   without thresholds. Default NULL.
     0 = Thresholds are required to generate alerts for this metric or metric column
     1 = Thresholds are not required to generate alerts for this metric/metric column.';

COMMENT ON COLUMN MGMT_METRICS.keyonly_thresholds IS
  'This column identifies whether the "All Others" key threshold configuration 
   is supported or not. Default NULL.
     0 = "All Others" threshold is supported.
     1 = Only key based thresholds are supported. Thresholds canno be specified 
         for "All Others" ';

COMMENT ON COLUMN MGMT_METRICS.is_long_running IS
  'This column identifies whether the collection of this metric is 
   long running or not. Default 0.
     0 = The collection of this metric does not take long time.
     1 = The collection of this metric takes long time.';

COMMENT ON COLUMN MGMT_METRICS.is_renderable IS
  'This column identifies whether the value of this metric/column can
   be rendered on the UI. Default 1.
     0 = The value of the metric/column cannot be rendered on UI
     1 = The value of the metric/column can be rendered on UI.';

rem
rem  PURPOSE
rem    This table stores the versions for which the repository metric
rem    is supported.
rem
CREATE TABLE mgmt_metric_versions
(
    target_type         VARCHAR2(&&EM_TARGET_TYPE_SIZE) NOT NULL,
    metric_name         VARCHAR2(64)                    NOT NULL,
    start_type_meta_ver VARCHAR2(8)                     DEFAULT '1.0',
    end_type_meta_ver   VARCHAR2(8)                     DEFAULT NULL
)
MONITORING;

COMMENT ON TABLE mgmt_metric_versions IS
  'This table stores the list of versions for which the repository metric
   is supported.';

COMMENT ON COLUMN mgmt_metric_versions.target_type IS
  'The type of the target.';

COMMENT ON COLUMN mgmt_metric_versions.metric_name IS
  'The name of the repository metric that is supported for multiple versions.';

COMMENT ON COLUMN mgmt_metric_versions.start_type_meta_ver IS
  'The starting type meta version from which this metric is supported. 
   Defaults to 1.0, the first meta version for all target types.';

COMMENT ON COLUMN mgmt_metric_versions.end_type_meta_ver IS
  'The ending type meta version till which this metric is supported. 
   Defaults to NULL, to specify that this metric has to be applied to all versions
   above start_type_meta_ver.';


rem
rem  PURPOSE
rem
rem    This table stores the list of metric classes.
rem
CREATE TABLE mgmt_category_classes
(
    class_name       VARCHAR2(&&EM_CLASS_NAME_SIZE)    NOT NULL,
    class_name_nlsid VARCHAR2(&&EM_DEFAULT_NLSID_SIZE)
)
MONITORING;

COMMENT ON TABLE mgmt_category_classes IS
  'This table stores the list of category classes.';

COMMENT ON COLUMN mgmt_category_classes.class_name IS
  'The name of the category class.';

COMMENT ON COLUMN mgmt_category_classes.class_name_nlsid IS
  'The NLSID of the category class.';



rem
rem  PURPOSE
rem
rem    This table contains categories available for a metric class.
rem
CREATE TABLE mgmt_categories
(
    class_name          VARCHAR2(&&EM_CLASS_NAME_SIZE) NOT NULL,
    category_name       VARCHAR2(&&EM_CATEGORY_NAME_SIZE) NOT NULL,
    category_name_nlsid VARCHAR2(&&EM_DEFAULT_NLSID_SIZE)
)
MONITORING;

COMMENT ON TABLE mgmt_categories IS
  'This table defines the category names available for a metric class.';

COMMENT ON COLUMN mgmt_categories.class_name IS
  'The name of the metric class for which the categories are defined.';

COMMENT ON COLUMN mgmt_categories.category_name IS
  'The name of the category applicable for the metric class.';

COMMENT ON COLUMN mgmt_categories.category_name_nlsid IS
  'The NLSID of the category name.';


rem
rem  PURPOSE
rem
rem    This table provides information about what category is applicable
rem    for a given metric/policy guid and metric class. The same table is
rem    used to define mappings for both metrics and policies.
rem
CREATE TABLE mgmt_category_map
(     
    target_type         VARCHAR2(&&EM_TARGET_TYPE_SIZE)   NOT NULL,
    type_meta_ver       VARCHAR2(&&EM_META_VER_SIZE)      DEFAULT '1.0' NOT NULL,
    object_guid         RAW(16)                           NOT NULL,
    class_name          VARCHAR2(&&EM_CLASS_NAME_SIZE)    NOT NULL,
    category_name       VARCHAR2(&&EM_CATEGORY_NAME_SIZE) NOT NULL,
    object_type         NUMBER(1)                         DEFAULT 0 NOT NULL
)
MONITORING; 

COMMENT ON TABLE mgmt_category_map IS
  'This table provides information about what category is applicable
   for a given metric/policy guid and metric class. The same table is
   used to define mappings for both metrics and policies.';
  
COMMENT ON COLUMN mgmt_category_map.target_type is
  'Defines the target type of the object being categorized.';

COMMENT ON COLUMN mgmt_category_map.type_meta_ver is
  'Defines the type meta version of the object being categorized.';

COMMENT ON COLUMN mgmt_category_map.object_guid IS
  'The GUID of either metric or policy. If object_type =
        = 1, the guid is metric_guid
        = 2, the guid is a policy_guid.';

COMMENT ON COLUMN mgmt_category_map.class_name IS
  'The classification name.';

COMMENT ON COLUMN mgmt_category_map.category_name IS
  'The name of the category for which the object_guid belongs to
   for the given classification.';

COMMENT ON COLUMN mgmt_category_map.object_type IS
  'Defines the type of the object for which the mapping is defined.
   If the object_type = 0, the object_guid is a metric_guid
   Else if the object_type = 1, then the object_guid is policy_guid';.


rem
rem  PURPOSE
rem
rem    This table contains metric metadata information that doesn't fit
rem    in the mgmt_metrics table.
rem
rem  COLUMNS
rem
rem    METRIC_GUID - A unique ID for the metric.  It can be used to associate
rem                  metric information with metric data information during
rem                  reporting.
rem
rem    META_VER    - The metadata version.  This should always be '2.2'.
rem
rem    CATEGORY_PROP_1
rem    CATEGORY_PROP_2
rem    CATEGORY_PROP_3
rem    CATEGORY_PROP_4
rem    CATEGORY_PROP_5
rem
rem                - up to 5 category properties can be used to distinguish
rem                  different metric definitions based on different
rem                  configuration
rem                  For example, OS version, DB version, RAC configuration,
rem                  etc..
rem                  Note: for this table, the version should always be 10i.
rem
rem    ALERTABLE   - can this metric generate an alert?
rem                  ('Y' == yes, 'N' == no)
rem
rem    THRESHOLDABLE
rem                - does this alert require thresholds?
rem                  ('Y' == yes, 'N' == no)
rem
rem    KEYONLY_THRESHOLDS
rem                - does this thresholdable metric support only key-specific
rem                  thresholds?
rem                  ('Y' == yes, 'N' == no)
rem
rem  NOTES
rem
rem    This table is not for public consumption; it is not part of the SDK.
rem    It will be replaced with an appropriate, different mechanism post 4.1.
rem    Do not use it.
rem
rem    Also, this table should not be changed post-installation, and so doesn't
rem    require the MONITORING clause.
rem

CREATE TABLE mgmt_metrics_ext
   (metric_guid        RAW(16)      NOT NULL,
    target_type        VARCHAR2(&EM_TARGET_TYPE_SIZE) NOT NULL,
    meta_ver           VARCHAR2(8)  DEFAULT ' ',
    category_prop_1    VARCHAR2(64) DEFAULT ' ',
    category_prop_2    VARCHAR2(64) DEFAULT ' ',
    category_prop_3    VARCHAR2(64) DEFAULT ' ',
    category_prop_4    VARCHAR2(64) DEFAULT ' ',
    category_prop_5    VARCHAR2(64) DEFAULT ' ',
    alertable          VARCHAR2(1)  DEFAULT 'Y',
    thresholdable      VARCHAR2(1)  DEFAULT 'Y',
    keyonly_thresholds VARCHAR2(1)  DEFAULT 'N',
    CONSTRAINT mgmt_metrics_ext_pk PRIMARY KEY
    (metric_guid, target_type, meta_ver, category_prop_1,
     category_prop_2, category_prop_3, category_prop_4, category_prop_5));

COMMENT ON TABLE MGMT_METRICS_EXT IS
  'The MGMT_METRICS_EXT table is not a supported part of the SDK.
   Do not rely on its contents; do not rely on its presence; do not modify
   it.';


rem
rem PURPOSE
rem
rem     The MGMT_TARGET_TYPES table holds the list of target type
rem
rem  COLUMNS
rem
rem     TARGET_TYPE    - the type of the target.  The type defines the set of
rem                      metrics that are applicable for the target.
rem
rem     TYPE_DISPLAY_NAME
rem                    - a user friendly name in English for the target type
rem                      that is used from the user interface.
rem
rem     TYPE_DISPLAY_NLSID
rem                    - NLS id for the target type display
rem
rem     TYPE_RESOURCE_BUNDLE
rem                    - Resource bundle name that holds all the NLS ids for this type.
rem
rem     TARGET_TYPE_GUID
rem                    - The unique ID for the target type
rem
rem     MAX_TYPE_META_VER
rem                    - The maximum type meta version known in the repository.
rem

CREATE TABLE MGMT_TARGET_TYPES
    (target_type            VARCHAR2(&EM_TARGET_TYPE_SIZE)    NOT NULL,
     type_display_name      VARCHAR2(128)                     DEFAULT ' ',
     type_display_nlsid     VARCHAR2(64)                      DEFAULT ' ',
     type_resource_bundle   VARCHAR2(256)                     DEFAULT ' ',
     target_type_guid       RAW(16)                           NOT NULL,
     max_type_meta_ver      VARCHAR(8)                        DEFAULT '1.0')
  INITRANS 2
  MONITORING;


COMMENT ON TABLE mgmt_target_types IS
    'The MGMT_TARGET_TYPES table holds the list of target type';

COMMENT ON COLUMN mgmt_target_types.target_type IS
    'the type of the target.  The type defines the set of metrics that are 
     applicable for the target.';

COMMENT ON COLUMN mgmt_target_types.type_display_name IS
    'a user friendly name in English for the target type that is 
    used from the user interface.';

COMMENT ON COLUMN mgmt_target_types.type_display_nlsid IS
    'NLS id for the target type display';

COMMENT ON COLUMN mgmt_target_types.type_resource_bundle IS
    'Resource bundle name that holds all the NLS ids for this type.';

COMMENT ON COLUMN mgmt_target_types.target_type_guid IS
    'The unique ID for the target type.';

COMMENT ON COLUMN mgmt_target_types.max_type_meta_ver IS
    'The maximum type meta version known in the repository.';


rem
rem  PURPOSE
rem     The MGMT_TARGET_TYPE_VERSIONS table holds the list of 
rem     target type versions.
rem
CREATE TABLE MGMT_TARGET_TYPE_VERSIONS
   (target_type           VARCHAR2(&EM_TARGET_TYPE_SIZE) NOT NULL,
    type_meta_ver         VARCHAR2(128)                  DEFAULT '1.0',
    type_display_name     VARCHAR2(128)                  DEFAULT ' ',
    type_display_nlsid    VARCHAR2(64)                   DEFAULT ' ',
    type_resource_bundle  VARCHAR2(256)                  DEFAULT ' ',
    target_type_ver_guid  RAW(16)                        NOT NULL,
    created_date          DATE                           DEFAULT SYSDATE,
    last_updated_date     DATE                           DEFAULT SYSDATE)
  INITRANS 2
  MONITORING;

COMMENT ON TABLE mgmt_target_type_versions IS
    'The MGMT_TARGET_TYPE_VERSIONS table holds the list of target type versions';

COMMENT ON COLUMN mgmt_target_type_versions.target_type IS
    'the type of the target.';

COMMENT ON COLUMN mgmt_target_type_versions.type_meta_ver IS
    'the target type metadata version.';

COMMENT ON COLUMN mgmt_target_type_versions.target_type_ver_guid IS
    'the unqiue ID for the targe type metadata version.';

COMMENT ON COLUMN mgmt_target_type_versions.type_display_name IS
    'a user friendly name in English for the target type version that is 
    used from the user interface.';

COMMENT ON COLUMN mgmt_target_type_versions.type_display_nlsid IS
    'NLS id for the target type display';

COMMENT ON COLUMN mgmt_target_type_versions.type_resource_bundle IS
    'Resource bundle name that holds all the NLS ids for this type.';

COMMENT ON COLUMN mgmt_target_type_versions.created_date IS
    'the date/time when the target type meta version is created 
    in the repository.';

COMMENT ON COLUMN mgmt_target_type_versions.last_updated_date IS
    'the date/time when the target type meta version is 
    last updated in the repository.';

rem
rem  PURPOSE
rem
rem     The MGMT_TARGETS table holds the list of targets that have
rem     metrics collected and stored in the reporting schema.
rem
rem  COLUMNS
rem
rem     TARGET_NAME    - the target name is the name of the target where the
rem                      metrics will be collected
rem
rem     TARGET_TYPE    - the type of the target.  The type defines the set of
rem                      metrics that are applicable for the target.
rem
rem     CATEGORY_PROP_1
rem     CATEGORY_PROP_2
rem     CATEGORY_PROP_3
rem     CATEGORY_PROP_4
rem     CATEGORY_PROP_5
rem
rem                    - up to 5 category properties can be used to distinguish
rem                      different metric definitions based on different configuration
rem                      For example, OS version, DB version, RAC configuration, etc..
rem
rem     TARGET_GUID    - The unique id of the target
rem
rem     LOAD_TIMESTAMP - The date/time when the target record was first loaded
rem
rem     TIMEZONE_DELTA - the timezone delta between the target where the information
rem                      was collected and GMT time.  This is used to
rem                      correlate information across targets when times span
rem                      timezones.
rem                      This will be obsoleted soon. Use timezone_region instead.
rem
rem     TIMEZONE_REGION - the timezone region name the target operates in.
rem
rem     DISPLAY_NAME   - a user friendly name for the target that is used from the
rem                      user interface
rem
rem     TYPE_DISPLAY_NAME
rem
rem                    - a user friendly name for the target type that is used from the
rem                      user interface
rem
rem     LAST_LOAD_TIME - date/time when data was last loaded for the target
rem
rem     SERVICE_TYPE   - the EM style service type as discovered through an
rem                      agent, i.e. oracle_sysman_xxx - needed for response time
rem                      metric reporting
rem
rem     HOST_NAME       - The host the target is on
rem
rem     EMD_URL        - The URL for the EMD where the target is being collected
rem
rem     IS_GROUP       - A flag that indicates if a target is a group. This is
rem                      used for privilege propagation. Privileges always
rem                      propagate for a group 
rem                      0 => not a group
rem                      1 => is a group
rem
rem     BROKEN_REASON  - A code that indicates if/why a target is broken.
rem                      0 => not broken
rem                      1 => missing required properties
rem                      2 => metadata not found
rem                      4 => error computing dynamic properties
rem                      8 => dynamic property missing in result
rem                      16 => target name not specified
rem                      32 => target could not be saved.
rem                      64 => errors in target test metrics
rem
rem     BROKEN_STR     - The string associated with the broken reason
rem
rem     LAST_RT_LOAD_TIME - date/time when chronos data was last loaded for the target
rem
rem     LAST_UPDATED_TIME - The date when this target was last update/created. 
rem
rem     MONITORING_MODE - Indicates how the target is being monitored
rem           MGMT_GLOBAL.G_MON_MODE_DEFAULT - Single agent, vanilla monitoring mode
rem           MGMT_GLOBAL.G_MON_MODE_OMS_MEDIATED - Multi agent, OMS mediated monitoring
rem           MGMT_GLOBAL.G_MON_MODE_AGENT_MEDIATED - Multi agent, agent mediated monitoring
rem
rem           MGMT_GLOBAL.G_MON_MODE_DEFAULT is the default value (0).
rem
rem     REP_SIDE_AVAIL - Indicates whether this targets availability is calculated on the
rem                      repository side.
rem     LAST_E2E_LOAD_TIME - date/time when e2e trace data was last loaded for the target
rem
rem
rem  NOTES
rem
rem     The primary key of this table is target_type, target_name
rem
rem     A row must exist in this table before metrics can be defined for a
rem     target.  This is enforced through the metrics_targets_foreign_key
rem     constraint.
rem

CREATE TABLE MGMT_TARGETS
    (target_name        VARCHAR2(&EM_TARGET_NAME_SIZE)   NOT NULL,
     target_type        VARCHAR2(&EM_TARGET_TYPE_SIZE)    NOT NULL,
     type_meta_ver      VARCHAR2(8)     DEFAULT '1.0', 
     category_prop_1    VARCHAR2(64)    DEFAULT ' ',
     category_prop_2    VARCHAR2(64)    DEFAULT ' ',
     category_prop_3    VARCHAR2(64)    DEFAULT ' ',
     category_prop_4    VARCHAR2(64)    DEFAULT ' ',
     category_prop_5    VARCHAR2(64)    DEFAULT ' ',
     target_guid        RAW(16)         NOT NULL,
     load_timestamp     DATE            DEFAULT SYSDATE,
     timezone_delta     NUMBER          DEFAULT TO_NUMBER(TO_CHAR(SYSTIMESTAMP,'TZH'))*60,
     timezone_region    VARCHAR2(64)    DEFAULT NULL,
     display_name       VARCHAR2(256)   DEFAULT NULL,
     owner              VARCHAR2(256)   DEFAULT '<SYSTEM>',
     type_display_name  VARCHAR2(128)   DEFAULT ' ',
     service_type       VARCHAR2(64)    DEFAULT ' ',
     host_name          VARCHAR2(256)   DEFAULT ' ',
     emd_url            VARCHAR2(&EM_URL_SIZE)   DEFAULT NULL,
     last_load_time     DATE            DEFAULT NULL,
     is_group           NUMBER(1)       DEFAULT 0,
     broken_reason      NUMBER          DEFAULT 0,
     broken_str         VARCHAR2(512)   DEFAULT NULL,
     last_rt_load_time  DATE            DEFAULT NULL,
     last_updated_time  DATE            DEFAULT SYSDATE,
     monitoring_mode    NUMBER          DEFAULT 0,
     rep_side_avail     NUMBER          DEFAULT 0,
     last_e2e_load_time DATE            DEFAULT NULL)
  INITRANS 2
  MONITORING;

rem
rem  PURPOSE
rem
rem     The MGMT_TYPE_PROPERTIES table holds the list of type properties
rem
rem  COLUMNS
rem
rem     TARGET_TYPE    - the target type
rem
rem     PROPERTY_NAME  - the name of the property.
rem
rem     PROPERTY_VALUE - the value of the property.
rem
rem
rem  NOTES
rem
rem

CREATE TABLE MGMT_TYPE_PROPERTIES (
  TARGET_TYPE     VARCHAR2 (&EM_TARGET_TYPE_SIZE)  NOT NULL,
  PROPERTY_NAME   VARCHAR2 (64)  NOT NULL,
  PROPERTY_VALUE  VARCHAR2 (1024)  DEFAULT ' ')
  MONITORING;

rem
rem  PURPOSE
rem
rem     The MGMT_TARGET_PROP_DEFS table holds the list of target property definitions
rem
rem  COLUMNS
rem
rem     TARGET_TYPE               - The target type.
rem
rem     TYPE_META_VER             - Type meta version.
rem
rem     PROPERTY_NAME             - the name of the property.
rem
rem     PROPERTY_TYPE             - the type of the property.
rem
rem     PROPERTY_DISPLAY_NAME     - the display name of the property in English.
rem
rem     PROPERTY_DISPLAY_NLSID    - the nlsid of the display name of the property.
rem
rem     REQUIRED_FLAG             - the property is required or optional. 
rem
rem     CREDENTIAL_FLAG           - the property is credential property?
rem
rem     DEFAULT_VALUE             - the default value of the property.
rem
rem     COMPUTED_FLAG             - the property is computed or not. Computed
rem                                 properties are set dynamically by EM and 
rem                                 may not have their value set by the user.
rem
rem     SYSTEM_FLAG               - if the property is a system property (i.e.
rem                                 added by EM) value 1, or a user propery (0).
rem
rem     READ_ONLY_FLAG            - dictates whether the property can be edited
rem                                 by the end user through the UI or not.
rem
rem     HIDDEN_FLAG               - dictates whether the property should be
rem                                 displayed to the end user through ANY UI.
rem
rem     ALL_VERSIONS              - if the property applies to all versions
rem                                 (1) or just to the given version (0).
rem
rem
rem  NOTES
rem
rem

CREATE TABLE MGMT_TARGET_PROP_DEFS
    (target_type              VARCHAR2 (&EM_TARGET_TYPE_SIZE)    NOT NULL,
     type_meta_ver            VARCHAR2(8)                        NOT NULL,
     property_name            VARCHAR2(64)                       NOT NULL,
     property_type            VARCHAR2(64)                       DEFAULT 'INSTANCE',
     property_display_name    VARCHAR2(64)                       NOT NULL,
     property_display_nlsid   VARCHAR2(64)                       DEFAULT NULL,
     required_flag            NUMBER(1)                          DEFAULT 0,
     credential_flag          NUMBER(1)                          DEFAULT 0,
     default_value            VARCHAR2(1024)                     DEFAULT ' ',
     computed_flag            NUMBER(1)                          DEFAULT 0 NOT NULL,
     read_only_flag           NUMBER(1)                          DEFAULT 0 NOT NULL,
     hidden_flag              NUMBER(1)                          DEFAULT 0 NOT NULL,
     system_flag              NUMBER(1)                          DEFAULT 1 NOT NULL,
     all_versions             NUMBER(1)                          DEFAULT 0 NOT NULL)
  INITRANS 2
  MONITORING;


rem
rem  PURPOSE
rem
rem     The MGMT_ALL_TARGET_PROPS table holds the list of UDTPs that apply
rem     to all target types (i.e. CTPs).
rem
rem  COLUMNS
rem
rem     PROPERTY_NAME             - the name of the property.
rem
rem     PROPERTY_TYPE             - the type of the property.
rem
rem     PROPERTY_DISPLAY_NAME     - the display name of the property in English.
rem
rem     PROPERTY_DISPLAY_NLSID    - the nlsid of the display name of the 
rem                                 property.
rem     REQUIRED_FLAG             - the property is required or optional. 
rem
rem     CREDENTIAL_FLAG           - the property is credential property?
rem
rem     DEFAULT_VALUE             - the default value of the property.
rem
rem     COMPUTED_FLAG             - whether the property is computed by the
rem                                 system or set by the users.
rem
rem     READ_ONLY_FLAG            - dictates whether the property can be edited
rem                                 by the end user through the UI or not.
rem
rem     HIDDEN_FLAG               - dictates whether the property should be
rem                                 displayed to the end user through ANY UI.
rem
rem     SYSTEM_FLAG               - if the property is a system property (i.e.
rem                                 added by EM) value 1, or a user propery (0).
rem
rem  NOTES
rem
rem

CREATE TABLE MGMT_ALL_TARGET_PROPS
    (property_name            VARCHAR2(64)                       NOT NULL,
     property_type            VARCHAR2(64)                       DEFAULT 'INSTANCE',
     property_display_name    VARCHAR2(64)                       NOT NULL,
     property_display_nlsid   VARCHAR2(64)                       DEFAULT NULL,
     required_flag            NUMBER(1)                          DEFAULT 0,
     credential_flag          NUMBER(1)                          DEFAULT 0,
     default_value            VARCHAR2(1024)                     DEFAULT NULL,
     computed_flag            NUMBER(1)                          DEFAULT 0,
     read_only_flag           NUMBER(1)                          DEFAULT 0,
     hidden_flag              NUMBER(1)                          DEFAULT 0,
     system_flag              NUMBER(1)                          DEFAULT 0)
  INITRANS 2
  MONITORING;


rem
rem  PURPOSE
rem
rem     The MGMT_TARGET_PROPERTIES table holds the list of target properties
rem
rem  COLUMNS
rem
rem     TARGET_GUID    - The unique id of the target
rem
rem     PROPERTY_NAME  - the name of the property.
rem
rem     PROPERTY_TYPE  - the type of the property.
rem
rem     PROPERTY_VALUE - the value of the property.
rem
rem
rem  NOTES
rem
rem

CREATE TABLE MGMT_TARGET_PROPERTIES
    (target_guid      RAW(16)         DEFAULT NULL,
     property_name    VARCHAR2(64)    NOT NULL,
     property_type    VARCHAR2(64)    DEFAULT 'INSTANCE',
     property_value   VARCHAR2(1024)  DEFAULT ' ')
  MONITORING;


rem
rem  PURPOSE
rem
rem     The MGMT_TARGET_AGENT_ASSOC table holds the list of agents
rem     redundantly monitoring the target
rem
rem  COLUMNS
rem
rem     TARGET_GUID    - The unique id of the target
rem
rem     AGENT_GUID     - the unique id of the agent
rem
rem  NOTES
rem
rem

CREATE TABLE MGMT_TARGET_AGENT_ASSOC
    (target_guid      RAW(16)    NOT NULL,
     agent_guid       RAW(16)    NOT NULL) 
    MONITORING;


rem
rem  PURPOSE
rem
rem     The MGMT_METRICS_RAW table contains the raw metric samples that were
rem     collected on the target system.  Metrics are any type of numberic data that
rem     is collected - response times, utilizations, performance measurements,
rem     user logins, availability values, etc.
rem
rem  COLUMNS
rem
rem     TARGET_GUID    - The unique id of the target
rem
rem     COLLECTION_TIMESTAMP
rem
rem                 - the date/time when the metric was collected
rem     METRIC_GUID
rem
rem                 - A unique ID for the metric.  It can be used to associate metric information
rem                   with metric data information during reporting.
rem
rem     KEY_VALUE   - If the metric defined at collection time is a TABLE type, the
rem                   value of the column in the table that is designated as the
rem                   key for the row that identifies the value of this metric should
rem                   be written here.  This information is used during reporting to
rem                   uniquely identify the specific value in the table that was
rem                   collected.  KEY_VALUE is the identifying row.  Together with the
rem                   target name, target type, and metric name, the metric value can be
rem                   uniquely identified.  This allows us to flatten tables of metrics into
rem                   simple metric values.  For example, the value in this table might
rem                   be \usr if we were storing the SpaceUsed metric.
rem
rem     VALUE       - The value of the metric if the metric is numeric.  Since the only metric
rem                   type that we allow rollups on is a numeric type, metric data that is
rem                   a string is stored in the string_value column.
rem
rem     STRING_VALUE
rem
rem                 - The value of the metric if the metric value is a string
rem
rem
rem  NOTES
rem
rem     The specification defines two levels of raw metrics so that we can
rem     minimize contention between the load and rollup processes plus optimize
rem     a load table for inserts and the raw data table for read access.
rem
rem     We decided to simplify the schema by having the raw data table initially
rem     cover the load table requirements.  We will break out the load table as
rem     a separate entity at a future point if we determine under load testing that
rem     the simplification has introduced a scalability bottleneck.
rem
rem     A second decision that was made for this table was to not introduce a
rem     metric sequence number.  Sequence numbers have been problematic when
rem     data is moved or merged from one schema to another.  If necessary we can
rem     avoid most of the issues by using a sequence number combined with a host
rem     name.  At this point, not using a sequence number wastes a little space,
rem     but should have a negligible performance impact.
rem
rem     The default value for the value of the metric is NULL.  We don't expect
rem     to get any null values, since NULLs should be filtered out by the collection
rem     process - but if we do, having this default to NULL will prevent NULLs from
rem     messing up the statistics during the rollup process.
rem

CREATE TABLE MGMT_METRICS_RAW
    (target_guid           RAW(16)         NOT NULL,
     metric_guid           RAW(16)         NOT NULL,
     key_value             VARCHAR2(256)   DEFAULT ' ',     
     collection_timestamp  DATE            NOT NULL,
     value                 NUMBER          DEFAULT NULL,
     string_value          VARCHAR2(4000)  DEFAULT NULL,
     CONSTRAINT mgmt_metrics_raw_pk
       PRIMARY KEY (target_guid, metric_guid, key_value, collection_timestamp))
  ORGANIZATION INDEX PCTFREE 0 COMPRESS 3 INITRANS 4
  OVERFLOW INCLUDING value
  MONITORING;

rem
rem  PURPOSE
rem
rem     The MGMT_CURRENT_METRICS table contains the most recent value of raw
rem     metrics that were collected on the target system.  This will allow any
rem     view to quickly determine the last (or current) value for any metric.
rem     There will only be records in this table for metrics that have been
rem     collected at least once.
rem
rem  COLUMNS
rem
rem       see the definition for MGMT_METRICS_RAW
rem

CREATE TABLE MGMT_CURRENT_METRICS
    (target_guid           RAW(16)         DEFAULT NULL,
     metric_guid           RAW(16)         DEFAULT NULL,
     key_value             VARCHAR2(256)   DEFAULT ' ',     
     collection_timestamp  DATE            NOT NULL,     
     value                 NUMBER          DEFAULT NULL,
     string_value          VARCHAR2(4000)  DEFAULT NULL,
     CONSTRAINT mgmt_current_metrics_pk
       PRIMARY KEY (target_guid, metric_guid, key_value))
  ORGANIZATION INDEX COMPRESS 1 INITRANS 4
  OVERFLOW INCLUDING value
  MONITORING;

rem
rem  PURPOSE
rem
rem     The MGMT_STRING_METRIC_HISTORY table contains all values of a
rem     of string metrics that were collected on the target system.  This will
rem     provide a historical view of the values of string metrics over
rem     time for a given (target_guid, metric_guid, key_value).  The identical
rem     values of a string metric will never be recorded twice in sequence to
rem     conserve space.
rem
rem  COLUMNS
rem
rem       see the definition for MGMT_METRICS_RAW
rem

CREATE TABLE MGMT_STRING_METRIC_HISTORY
    (target_guid           RAW(16)         DEFAULT NULL,
     metric_guid           RAW(16)         DEFAULT NULL,
     key_value             VARCHAR2(256)   DEFAULT ' ',     
     collection_timestamp  DATE            NOT NULL,     
     string_value          VARCHAR2(4000)  DEFAULT NULL)
  PCTFREE 0
  INITRANS 2
  MONITORING;

rem
rem  PURPOSE
rem
rem    The MGMT_LONG_TEXT table contains the long text strings for all
rem    metrics.  These strings are often less than 4000 bytes, and for con-
rem    venience there is a prefix column which stores the first 4000 bytes.
rem    The text is identified by a message digest.
rem
rem  COLUMNS
rem
rem    DIGEST
rem
rem            - A message digest representing the full text with
rem              statistical uniqueness.
rem
rem    PREFIX
rem
rem            - The prefix of the text: the first 4000 bytes of the string.
rem
rem    FRAGMENT#
rem
rem            - The order of the fragment# within the full SQL text string.
rem              Given a digest value, the full SQL text may be constructed
rem              by concatenating the text_fragments together according to the
rem              ordering of fragment#.
rem
rem
rem  NOTES
rem
rem    It may make sense in the future to add a date column which represents
rem    the last collection time for the long string.  This will provide the
rem    means to determine whether or not the string is 'orphaned'.
rem

CREATE TABLE MGMT_LONG_TEXT
    (digest RAW(20)        NOT NULL,
     prefix VARCHAR2(4000) NOT NULL,
     entire CLOB           DEFAULT EMPTY_CLOB())
  MONITORING
  LOB(entire) STORE AS (TABLESPACE &EM_ECM_DEPOT_TABLESPACE);

rem
rem  PURPOSE
rem
rem    The MGMT_METRICS_COMPOSITE_KEYS table contains the mapping of composite
rem    keys to the key components.
rem
rem  COLUMNS
rem
rem    COMPOSITE_KEY
rem
rem            - A digest of the string concatenation of the individual key 
rem              values. This value is used as the key in all other tables 
rem
rem    TARGET_GUID
rem
rem            - The target for which this composite key was generated
rem
rem    KEY_PART1_VALUE
rem
rem            - The value of the first key component
rem
rem    KEY_PART2_VALUE
rem
rem            - The value of the second key component
rem
rem    KEY_PART3_VALUE
rem
rem            - The value of the third key component
rem
rem    KEY_PART4_VALUE
rem
rem            - The value of the fourth key component
rem
rem    KEY_PART5_VALUE
rem
rem            - The value of the fifth key component
rem
rem
rem
rem  NOTES
rem
rem    It may make sense in the future to add a date column which represents
rem    the last collection time for the composite key.  This will provide the
rem    means to determine whether or not the key is 'orphaned'.
rem

CREATE TABLE MGMT_METRICS_COMPOSITE_KEYS
    (composite_key    RAW(16)        NOT NULL,
     target_guid      RAW(16)        NOT NULL,
     key_part1_value  VARCHAR2(256) DEFAULT ' ',
     key_part2_value  VARCHAR2(256) DEFAULT ' ',
     key_part3_value  VARCHAR2(256) DEFAULT ' ',
     key_part4_value  VARCHAR2(256) DEFAULT ' ',
     key_part5_value  VARCHAR2(256) DEFAULT ' ')
  MONITORING;

rem
rem  PURPOSE
rem
rem     The MGMT_TARGETS_DELETE table holds the list of targets that have been deleted.
rem
rem  COLUMNS
rem
rem     TARGET_NAME    - the target name is the name of the target where the
rem                      metrics will be collected
rem
rem     TARGET_TYPE    - the type of the target.  The type defines the set of
rem                      metrics that are applicable for the target.
rem
rem     TARGET_GUID    - The unique id of the target
rem
rem     DELETE_REQUEST_TIME - The date/time when the target deletion was requested
rem
rem     DELETE_COMPLETE_TIME - The date/time when the target deletion was completed
rem
rem     LAST_UPDATED_TIME - The date/time when the target was last updated
rem

CREATE TABLE MGMT_TARGETS_DELETE
    (target_name                VARCHAR2(&EM_TARGET_NAME_SIZE) NOT NULL,
     target_type                VARCHAR2(&EM_TARGET_TYPE_SIZE) NOT NULL,
     target_guid                RAW(16),
     emd_url                    VARCHAR2(&EM_URL_SIZE)         DEFAULT ' ',
     timezone_region            VARCHAR2(64)    DEFAULT TO_CHAR(SYSTIMESTAMP,'TZR'),
     delete_request_time        DATE                           DEFAULT SYSDATE,
     delete_complete_time       DATE                           DEFAULT NULL,
     last_updated_time          DATE                           DEFAULT SYSDATE)
  MONITORING;

rem
rem  PURPOSE
rem
rem  The MGMT_CALLBACKS table holds a set of callbacks
rem
rem  COLUMNS
rem
rem  CALLBACK_TYPE The callback type
rem
rem  CALLBACK_NAME The callback name
rem
rem  SELECTOR_1    Selector for which this callback is applicable (optional). 
rem                e.g Target Type
rem 
rem  SELECTOR_2    Selector for which this callback is applicable (optional). 
rem                e.g Target Type
rem  EVAL_ORDER    Order in which the callback is called
rem                lower numbers are called first

CREATE TABLE MGMT_CALLBACKS (
    callback_type NUMBER(2) NOT NULL,
    callback_name VARCHAR2(100) NOT NULL,
    selector_1    VARCHAR2(64) DEFAULT ' ',
    selector_2    VARCHAR2(64) DEFAULT ' ',
    selector_3    VARCHAR2(64) DEFAULT ' ',
    eval_order    NUMBER(2)    DEFAULT 0,
    CONSTRAINT MGMT_CALLBACKS_PK PRIMARY KEY (callback_name,callback_type, selector_1,selector_2)
)MONITORING;

rem
rem  'PURPOSE
rem
rem  The MGMT_TARGET_ADD_CALLBACKS table holds a set of callbacks
rem  that will be executed when a target is added.
rem
rem  COLUMNS
rem 
rem  CALLBACK_NAME The add callback name
rem
rem  TARGET_TYPE   Target type for which this callback is applicable (optional). 
rem                If empty, callback applies to all target types.
rem 
rem
CREATE TABLE MGMT_TARGET_ADD_CALLBACKS (
    callback_name VARCHAR2(100) NOT NULL,
    target_type   VARCHAR2(&EM_TARGET_TYPE_SIZE) DEFAULT ' ',
    CONSTRAINT MGMT_TARGET_ADD_CALLBACKS_PK
       PRIMARY KEY (callback_name, target_type)
) MONITORING;


rem
rem  PURPOSE
rem
rem     The MGMT_TARGET_DELETE_CALLBACKS table holds a set of callbacks
rem     that will be executed, in turn, when a target is deleted.
rem
rem  COLUMNS
rem  
rem  CALLBACK_NAME The delete callback
rem
CREATE TABLE MGMT_TARGET_DELETE_CALLBACKS (
    callback_name VARCHAR2(100) NOT NULL
) MONITORING;

rem
rem  PURPOSE
rem
rem    The MGMT_TARGET_DELETE_EXCEPTIONS table holds a set of tables
rem    that the target delete algorithm will not scan. By default,
rem    the target deletion procedure will attempt to remove data
rem    from all tables that have a TARGET_GUID column.
rem
rem  COLUMNS
rem  
rem  CALLBACK_NAME The delete callback
rem
CREATE TABLE MGMT_TARGET_DELETE_EXCEPTIONS (
    table_name VARCHAR2(32),
    CONSTRAINT PK_DEL_EXCEPTIONS PRIMARY KEY(table_name)
) MONITORING;

rem
rem  PURPOSE
rem
rem     The MGMT_DUPLICATE_TARGETS table holds the list of duplicate targets detected.
rem
rem  COLUMNS
rem
rem     TARGET_GUID    - the target guid of the duplicate target
rem
rem     AGENT_GUID     - the target guid of the agent that sent the duplicate
rem
rem     DETECTION_TIME - The date/time when the target was detected duplicate
rem
rem     RESOLVED_TIME  - The date/time when the target was duplication was resolved
rem

CREATE TABLE MGMT_DUPLICATE_TARGETS (
     target_name        VARCHAR2(&EM_TARGET_NAME_SIZE) NOT NULL,
     target_type        VARCHAR2(&EM_TARGET_TYPE_SIZE) NOT NULL,
     target_guid        RAW(16)                        NOT NULL,
     duplicate_emd_url  VARCHAR2(&EM_URL_SIZE)         NOT NULL,
     timezone_region    VARCHAR2(64)    DEFAULT TO_CHAR(SYSTIMESTAMP,'TZR'),
     detection_time     DATE                           DEFAULT SYSDATE,
     resolved_time      DATE                           DEFAULT NULL)
  MONITORING;

rem
rem  PURPOSE
rem
rem     The MGMT_CHANGE_AGENT_URL table is used to change the agent URL
rem
rem  COLUMNS
rem
rem     LAST_EMD_URL - the old agent URL
rem
rem     EMD_URL      - the new agent URL
rem

CREATE TABLE MGMT_CHANGE_AGENT_URL
    (last_emd_url   VARCHAR2(&EM_URL_SIZE),
     emd_url        VARCHAR2(&EM_URL_SIZE))
  MONITORING;



rem
rem
rem  PURPOSE
rem
rem     The MGMT_TARGET_ROLLUP_TIMES table holds a list of the last time a
rem     data for a target was rolled up into each rollup table.
rem
rem  COLUMNS
rem
rem     TARGET_GUID              - The unique id of the target
rem
rem     ROLLUP_TABLE_NAME        - the name of the table data for the target
rem                                was rolled up into.
rem
rem     ROLLUP_TIMESTAMP         - the last timestamp entry in the rollup table
rem                                for the target.
rem
rem  NOTES
rem
rem

CREATE TABLE MGMT_TARGET_ROLLUP_TIMES
    (target_guid            RAW(16)         DEFAULT NULL,
     rollup_table_name      VARCHAR2(64)    NOT NULL,
     rollup_timestamp       DATE            NOT NULL)
  MONITORING;

rem
rem  PURPOSE
rem
rem     The MGMT_METRICS_1HOUR table contains the rollup metrics from the raw
rem     data samples into 1 hour intervals that were collected on the target
rem     system.  For more information on valid metrics, see the description of the
rem     MGMT_METRICS_RAW table.
rem
rem  COLUMNS
rem
rem     METRIC_GUID - This is a unique identifier for a metric.  Query
rem                   MGMT_METRICS using the metric_guid to get the full metric
rem                   definition.
rem
rem     TARGET_GUID    - The unique id of the target
rem
rem     ROLLUP_TIMESTAMP
rem
rem                 - the date/time for the start of the rollup period.  In this case
rem                   the rollup times will be on 1 hour boundaries using a 24 hour
rem                   clock.  Samples included in the rollup are greater than or equal to
rem                   the start of the period, and less than the next period.  So the
rem                   00 rollup includes samples from midnight up to samples collected
rem                   at 1 o'clock AM.
rem
rem     KEY_VALUE   - If the metric defined at collection time is a TABLE type, the
rem                   value of the column in the table that is designated as the
rem                   key for the row that identifies the value of this metric should
rem                   be written here.  This information is used during reporting to
rem                   uniquely identify the specific value in the table that was
rem                   collected.  KEY_VALUE is the identifying row.  Together with the
rem                   target name, target type, and metric name, the metric value can be
rem                   uniquely identified.  This allows us to flatten tables of metrics into
rem                   simple metric values.  For example, the value in this table might
rem                   be \usr if we were storing the SpaceUsed metric.
rem
rem     SAMPLE_COUNT
rem
rem                 - The number of samples that have been rolled for this time period
rem
rem     VALUE_AVERAGE
rem
rem                 - The average value of the metric for samples in the time period
rem
rem
rem     VALUE_MINIMUM
rem
rem                 - The minimum value of the metric for samples in the time period
rem
rem     VALUE_MAXIMUM
rem
rem                 - The maximum value of the metric for samples in the time period
rem
rem     VALUE_SDEV  - The standard deviation of the metric for samples in the time period
rem
rem  NOTES
rem
rem

CREATE TABLE MGMT_METRICS_1HOUR
    (target_guid        RAW(16)         NOT NULL,
     metric_guid        RAW(16)         NOT NULL,
     key_value          VARCHAR2(256)   DEFAULT ' ',
     rollup_timestamp   DATE            NOT NULL,
     sample_count       NUMBER          DEFAULT 0,
     value_average      NUMBER          DEFAULT 0,
     value_minimum      NUMBER          DEFAULT 0,
     value_maximum      NUMBER          DEFAULT 0,
     value_sdev         NUMBER          DEFAULT 0,
     CONSTRAINT MGMT_METRICS_1HOUR_PK
       PRIMARY KEY (target_guid, metric_guid, key_value, rollup_timestamp))
  ORGANIZATION INDEX PCTFREE 0 COMPRESS 3
  MONITORING;

rem
rem  PURPOSE
rem
rem     The MGMT_METRICS_1DAY table contains the rollup metrics from the raw
rem     data samples into daily intervals that were collected on the target
rem     system.  For more information on valid metrics, see the description of the
rem     MGMT_METRICS_RAW table.
rem
rem  COLUMNS
rem
rem     METRIC_GUID - This is a unique identifier for a metric.  Query
rem                   MGMT_METRICS using the metric_guid to get the full metric
rem                   definition.
rem
rem     TARGET_GUID    - The unique id of the target
rem
rem     ROLLUP_TIMESTAMP
rem
rem                 - the date/time for the start of the rollup period.  In this case
rem                   the rollup times will be on daily boundaries.  Samples included
rem                   in the rollup are greater than or equal to the start of the
rem                   period, and less than the next period.  So the rollup period for
rem                   the first day of the month includes samples from midnight on
rem                   that day up to samples collected on midnight of the following day.
rem
rem     KEY_VALUE   - If the metric defined at collection time is a TABLE type, the
rem                   value of the column in the table that is designated as the
rem                   key for the row that identifies the value of this metric should
rem                   be written here.  This information is used during reporting to
rem                   uniquely identify the specific value in the table that was
rem                   collected.  KEY_VALUE is the identifying row.  Together with the
rem                   target name, target type, and metric name, the metric value can be
rem                   uniquely identified.  This allows us to flatten tables of metrics into
rem                   simple metric values.  For example, the value in this table might
rem                   be \usr if we were storing the SpaceUsed metric.
rem
rem     SAMPLE_COUNT
rem
rem                 - The number of samples that have been rolled for this time period
rem
rem     VALUE_AVERAGE
rem
rem                 - The average value of the metric for samples in the time period
rem
rem
rem     VALUE_MINIMUM
rem
rem                 - The minimum value of the metric for samples in the time period
rem
rem     VALUE_MAXIMUM
rem
rem                 - The maximum value of the metric for samples in the time period
rem
rem     VALUE_SDEV  - The standard deviation of the metric for samples in the time period
rem
rem  NOTES
rem
rem

CREATE TABLE MGMT_METRICS_1DAY
    (target_guid        RAW(16)         NOT NULL,
     metric_guid        RAW(16)         NOT NULL,
     key_value          VARCHAR2(256)   DEFAULT ' ',
     rollup_timestamp   DATE            NOT NULL,
     sample_count       NUMBER          DEFAULT 0,
     value_average      NUMBER          DEFAULT 0,
     value_minimum      NUMBER          DEFAULT 0,
     value_maximum      NUMBER          DEFAULT 0,
     value_sdev         NUMBER          DEFAULT 0,
     CONSTRAINT MGMT_METRICS_1DAY_PK
       PRIMARY KEY (target_guid, metric_guid, key_value, rollup_timestamp))
  ORGANIZATION INDEX PCTFREE 0 COMPRESS 3
  MONITORING;

rem
rem  PURPOSE
rem
rem     The MGMT_METRIC_ERRORS table contains the information on
rem     metric errors for a metric
rem
rem
rem  COLUMNS
rem
rem     TARGET_GUID    - The unique id of the target
rem
rem     METRIC_GUID
rem                 - A unique ID for the metric.  It can be used to associate
rem                   metric information with metric data information during
rem                   reporting.
rem
rem     COLL_NAME
rem                 - The name of the collection collecting the metric
rem
rem     AGENT_GUID
rem                 - The target guid of the agent that generated this error
rem
rem     COLLECTION_TIMESTAMP
rem                 - the date/time when the collection was attempted
rem
rem     METRIC_ERROR_MESSAGE
rem
rem                 - a string that indicates the error that happened or a NULL
rem                   for a clearing of an error
rem
rem     METRIC_ERROR_TYPE
rem
rem                 - a number that indicates the type of error that happened 
rem                   during the collection of the metric
rem
rem                         0 - ERROR
rem                         1 - WARNING
rem
rem
rem  NOTES
rem
rem

CREATE TABLE MGMT_METRIC_ERRORS
    (target_guid           RAW(16)         NOT NULL,
     metric_guid           RAW(16)         NOT NULL,
     coll_name             VARCHAR2(64)    DEFAULT ' ',
     agent_guid            RAW(16)         DEFAULT '00000000000000000000000000000000',
     collection_timestamp  DATE            NOT NULL,
     metric_error_message  VARCHAR2(4000)  DEFAULT '',
     metric_error_type     NUMBER(1)       DEFAULT 0)
  INITRANS 2
  MONITORING;

rem
rem  PURPOSE
rem
rem     The MGMT_CURRENT_METRIC_ERRORS table contains the current metric
rem     error, if any, for a metric.
rem     This table is created to improve the performance of queries requesting
rem     the current metric information for a metric.
rem
rem
rem  COLUMNS
rem
rem     See MGMT_METRIC_ERRORS
rem
rem
rem  NOTES
rem
rem     The primary key for this table doesn't include the timestamp.  We
rem     only want one record in this table for each metric.
rem

CREATE TABLE MGMT_CURRENT_METRIC_ERRORS
    (target_guid           RAW(16)         NOT NULL,
     metric_guid           RAW(16)         NOT NULL,
     coll_name             VARCHAR2(64)    DEFAULT ' ',
     agent_guid            RAW(16)         DEFAULT '00000000000000000000000000000000',
     collection_timestamp  DATE            NOT NULL,
     metric_error_message  VARCHAR2(4000)  DEFAULT '',
     metric_error_type     NUMBER(1)       DEFAULT 0)
  INITRANS 2
  MONITORING;
 



REM
REM Tables for associations
REM 

REM
REM The MGMT_TARGET_ASSOC table stores association metadata
REM
REM TARGET_TYPE The target type
REM TYPE_META_VER The target type meta version
REM ASSOCIATION The association
REM ASSOC_TARGET_TYPE The target type of the associated target
REM
CREATE TABLE MGMT_TARGET_ASSOC (
    target_type VARCHAR2(256),
    type_meta_ver VARCHAR2(8),
    association VARCHAR2(64),
    assoc_target_type VARCHAR2(256),
    CONSTRAINT PK_MGMT_TARGET_ASSOC 
       PRIMARY KEY(target_type, type_meta_ver, association)
)
  INITRANS 2
  MONITORING;

REM
REM The MGMT_TARGET_ASSOC_INSTANCE table stores association 
REM instance information
REM
REM target_guid The target guid
REM association The association name
REM assoc_target_guid The guid of the associated target
REM
CREATE TABLE MGMT_TARGET_ASSOC_INSTANCE (
    target_guid RAW(16),
    association VARCHAR2(64),
    assoc_target_guid RAW(16),
    CONSTRAINT PK_MGMT_TARGET_ASSOC_INSTANCE
        PRIMARY KEY(target_guid, association)
)
  INITRANS 2
  MONITORING;

rem
rem  PURPOSE
rem
rem  MGMT_ANNOTATION is a general purpose table for storing annotations
rem  about different EM objects.
rem
rem  COLUMNS
rem
rem     SOURCE_OBJ_TYPE - Source object type. Possible values are:
rem                         mgmt_global.G_ANNOTATION_SOURCE_SEVERITY
rem                         mgmt_global.G_ANNOTATION_SOURCE_JOB
rem                         mgmt_global.G_ANNOTATION_SOURCE_POLICY
rem
rem
rem     SOURCE_OBJ_GUID - Source object guid. 
rem
rem     TIMESTAMP - Time at which this annotation is created
rem
rem     USER_NAME - EM User who authored the annotation
rem
rem     MESSAGE - The annotation itself.
rem
CREATE TABLE MGMT_ANNOTATION (
     source_obj_type           NUMBER(2) NOT NULL,
     source_obj_guid           RAW(16)   NOT NULL,
     timestamp                 DATE      NOT NULL,
     annotation_type           VARCHAR2(64) DEFAULT NULL,
     user_name                 VARCHAR2(256), 
     message                   VARCHAR2(4000)
) INITRANS 2
  MONITORING;

rem
rem  PURPOSE
rem
rem  MGMT_METADATA_SETS is a table to store what metadata sets
rem  are loaded into the EM repository
rem

CREATE TABLE MGMT_METADATA_SETS (
    target_type    VARCHAR2(&EM_TARGET_TYPE_SIZE) NOT NULL,
    type_meta_ver  VARCHAR2(8)  DEFAULT ' ',
    table_name     VARCHAR2(32) NOT NULL,
    load_time      DATE DEFAULT NULL
) MONITORING;

COMMENT ON TABLE MGMT_METADATA_SETS IS
  'The MGMT_METRICS table provides details about what metadata sets are 
   loaded into the repository.
   EM repository metadata can be divided into several disjoint metadata sets.
   A metadata set is a set of rows into a table for a given 
   target_type and type_meta_ver.
   The XMLLoader uses data from this table to determine whether to load
   a given metadata set for a given target_type and meta_ver into the repository.';

COMMENT ON COLUMN MGMT_METADATA_SETS.TARGET_TYPE IS
  'the target type of the metadata set.';

COMMENT ON COLUMN MGMT_METADATA_SETS.TYPE_META_VER IS
  'the type meta version of the metadata set.';

COMMENT ON COLUMN MGMT_METADATA_SETS.TABLE_NAME IS
  'the table name of the metadata set.';

COMMENT ON COLUMN MGMT_METADATA_SETS.LOAD_TIME IS
  'the time when the metadata set is loaded into the repository.';
  
rem
rem  PURPOSE
rem
rem  MGMT_ROWSET_HANDLERS table stores rowset handlers used by XMLLoader
rem

CREATE TABLE MGMT_ROWSET_HANDLERS (
    rowset_name       VARCHAR2(32)  NOT NULL,
    protocol_version  VARCHAR2(16)  DEFAULT ' ',
    handler_type      NUMBER(2)     NOT NULL,
    handler_info      VARCHAR2(128) DEFAULT NULL,
    CONSTRAINT MGMT_ROWSET_HANDLERS_PK 
        PRIMARY KEY (rowset_name, protocol_version, handler_type)
) MONITORING;

COMMENT ON TABLE MGMT_ROWSET_HANDLERS IS
  'The MGMT_ROWSET_HANDLERS table stores details of the handlers used
   by XMLLoader to process rowsets.';

COMMENT ON COLUMN MGMT_ROWSET_HANDLERS.ROWSET_NAME IS
  'the rowset name.';
  
COMMENT ON COLUMN MGMT_ROWSET_HANDLERS.PROTOCOL_VERSION IS
  'the protocol version for which this handler settings have to be applied.';

COMMENT ON COLUMN MGMT_ROWSET_HANDLERS.HANDLER_TYPE IS
  'the type of the rowset handler.';
  
COMMENT ON COLUMN MGMT_ROWSET_HANDLERS.HANDLER_INFO IS
  'Additional info related to the type of the handler.
   For PL/SQL rowset handler the handler_info stores the 
   plsql procedure name.';
  
  
rem
rem  PURPOSE
rem
rem  The MGMT_MESSAGES table stores translated seed messages
rem
rem  COLUMNS
rem
rem  MESSAGE_ID     ID of the message
rem
rem  SUBSYSTEM      Name of the subsystem for which this message is applicable
rem
rem  LANGUAGE_CODE  The Java abbreviation of the language name used to identify  
rem                 the language of the message; for example, 'en' for English.
rem                 Maps to Locale.getLanguage()
rem
rem COUNTRY_CODE    The Java abbreviation of the country name used to identify
rem                 the country of the message; for example, ' ' for English.
rem                 Maps to Locale.getCountry()
rem                 
rem  MESSAGE        Message text


CREATE TABLE MGMT_MESSAGES (
    message_id    VARCHAR2(256)   NOT NULL,
    subsystem     VARCHAR2(64)    NOT NULL,
    language_code VARCHAR2(2)     DEFAULT 'en' NOT NULL,
    country_code  VARCHAR2(2)     DEFAULT ' ' NOT NULL,
    message       NVARCHAR2(1000) DEFAULT ' ',
    CONSTRAINT MGMT_MESSAGES_PK PRIMARY KEY (message_id, subsystem, language_code, country_code)
) MONITORING;

rem
rem  PURPOSE
rem
rem  Contains the Load designators and the OMS handling them
rem
rem  COLUMNS
rem     
rem     DESIGNATOR   The name of the load designator 
rem
rem     OMS_ID       The failover id of the oms. This is the same as 
rem                  the failover_id in the mgmt_failover_table 
rem
CREATE TABLE MGMT_LOADER_DESIGNATORS (
    designator   VARCHAR2(2) NOT NULL,
    oms_id       NUMBER DEFAULT 0,
    CONSTRAINT MGMT_LOADER_DESIGNATORS_PK PRIMARY KEY(designator)
) MONITORING;

rem
rem  PURPOSE
rem     Sequence for generating unique filenames in Shared FS solution
rem
CREATE SEQUENCE MGMT_LOADER_SEQUENCE
    MINVALUE 1000000000
    MAXVALUE 9999999999
    START WITH 1000000001
    INCREMENT BY 1
    CYCLE 
    ORDER;

