Rem drv: <create type="tables" pos="basic/basic_tables.sql+" condition="EM_REPOS_MODE=SYSAUX"/>
Rem
Rem $Header: emcore/source/oracle/sysman/emdrep/sql/core/latest/basic/basic_tables_db.sql /st_emcore_10.2.0.4.2db11.2/2 2009/05/04 22:17:07 jsadras Exp $
Rem
Rem basic_tables_db.sql
Rem
Rem Copyright (c) 2007, 2009, Oracle and/or its affiliates. 
Rem All rights reserved. 
Rem
Rem    NAME
Rem      basic_tables_db.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    jsadras     02/27/09 - compress mgmt_metrics for all operations
Rem    jsadras     04/02/07 - tables for db control
Rem    jsadras     04/02/07 - Created
Rem

rem
rem  PURPOSE
rem
rem  MGMT_LAST_SYNC_LOAD_DETAILS is a table to store information about last
rem  synchronous file upload for a particular agent
rem

CREATE TABLE MGMT_LAST_SYNC_LOAD_DETAILS (
    emd_url    VARCHAR2(1024),
    load_type  VARCHAR2(32)  DEFAULT ' ',
    load_time      DATE DEFAULT NULL,
    CONSTRAINT MGMT_LAST_SYNC_LOAD_PK PRIMARY KEY(emd_url)
) 
MONITORING ;

COMMENT ON TABLE MGMT_LAST_SYNC_LOAD_DETAILS IS
  'The MGMT_LAST_SYNC_LOAD_DETAILS table provides details about the last
   synchronous file upload by a particular agent.';

COMMENT ON COLUMN MGMT_LAST_SYNC_LOAD_DETAILS.EMD_URL IS
  'URL of the agent.';

COMMENT ON COLUMN MGMT_LAST_SYNC_LOAD_DETAILS.LOAD_TYPE IS
  'load type of the last loaded file.';

COMMENT ON COLUMN MGMT_LAST_SYNC_LOAD_DETAILS.LOAD_TIME IS
  'time at which last synchronous file was loaded by the agent';

BEGIN
  EXECUTE IMMEDIATE 'ALTER TABLE mgmt_metrics MOVE COMPRESS FOR ALL OPERATIONS';
EXCEPTION
 -- Currently compress does not raise errors even if tables is compressed
WHEN OTHERS THEN NULL ;
END ;
/
