Rem drv: <create type="tables" pos="basic/basic_tables.sql+" condition="EM_REPOS_MODE=CENTRAL"/>
Rem
Rem $Header: basic_tables_gc.sql 02-apr-2007.05:39:17 jsadras Exp $
Rem
Rem basic_tables_gc.sql
Rem
Rem Copyright (c) 2007, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      basic_tables_gc.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    jsadras     04/02/07 - Created
Rem

rem
rem  PURPOSE
rem
rem  MGMT_LAST_SYNC_LOAD_DETAILS is a table to store information about last
rem  synchronous file upload for a particular agent
rem

CREATE TABLE MGMT_LAST_SYNC_LOAD_DETAILS (
    emd_url    VARCHAR2(1024),
    load_type  VARCHAR2(32)  DEFAULT ' ',
    load_time      DATE DEFAULT NULL,
    CONSTRAINT MGMT_LAST_SYNC_LOAD_PK PRIMARY KEY(emd_url)
) 
ORGANIZATION INDEX MONITORING
OVERFLOW ;

COMMENT ON TABLE MGMT_LAST_SYNC_LOAD_DETAILS IS
  'The MGMT_LAST_SYNC_LOAD_DETAILS table provides details about the last
   synchronous file upload by a particular agent.';

COMMENT ON COLUMN MGMT_LAST_SYNC_LOAD_DETAILS.EMD_URL IS
  'URL of the agent.';

COMMENT ON COLUMN MGMT_LAST_SYNC_LOAD_DETAILS.LOAD_TYPE IS
  'load type of the last loaded file.';

COMMENT ON COLUMN MGMT_LAST_SYNC_LOAD_DETAILS.LOAD_TIME IS
  'time at which last synchronous file was loaded by the agent';

