Rem drv: <create type="types" pos="baselines/baselines_types.sql-"/>
Rem
Rem $Header: basic_types.sql 29-jun-2005.01:46:17 gsbhatia Exp $
Rem
Rem basic_types.sql
Rem
Rem Copyright (c) 2002, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      basic_types.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    gsbhatia    06/26/05 - New repmgr header impl 
Rem    gsbhatia    02/13/05 - updating repmgr header 
Rem    gsbhatia    02/09/05 - updating repmgr header 
Rem    gsbhatia    02/07/05 - updating repmgr header 
Rem    vkgarg      01/27/05 - add target type for comparing targets in metric 
Rem                           details page 
Rem    ktlaw       01/11/05 - add repmgr header 
Rem    asawant     07/13/04 - Adding type for advanced search 
Rem    jpyang      08/29/03 - add target record 
Rem    rpinnama    11/12/02 - Add upload_time record
Rem    rpinnama    09/20/02 - 
Rem    rpinnama    09/18/02 - Move exchange types to exchange component
Rem    skini       07/12/02 - target_name column change
Rem    rpinnama    05/15/02 - rpinnama_reorg_rep_scripts
Rem    rpinnama    05/15/02 - Created
Rem

CREATE OR REPLACE TYPE EMDSYSTEM_ARGS IS TABLE OF VARCHAR2(1024);
/

create or replace type SMP_EMD_AVAIL_OBJ as OBJECT (
    nodeStatus VARCHAR2(128),
    imageName  VARCHAR2(128),
    availInfo VARCHAR2(128),
    severityCode INTEGER,
    numAlerts INTEGER
);
/

create or replace type SMP_EMD_TARGET_OBJ as OBJECT (
    targetName VARCHAR2(256),
    targetType VARCHAR2(128),
    displayName VARCHAR2(128),
    typeDisplayName VARCHAR2(128),
    targetSev INTEGER,
    targetAvail NUMBER(15,2),
    targetStatus INTEGER,
    warningAlert INTEGER,
    criticalAlert INTEGER,
    association VARCHAR2(128)
);
/

create or replace type SMP_EMD_TARGET_OBJ_ARRAY as TABLE of SMP_EMD_TARGET_OBJ;
/


create or replace type SMP_EMD_LOAD_OBJ as OBJECT (
    numProcesses INTEGER,
    numUsers INTEGER,
    avgLoad NUMBER,
    cpuUtil INTEGER,
    cpuKernel INTEGER,
    cpuUser INTEGER,
    cpuIOWait INTEGER,
    numProcessesSev INTEGER,
    numUsersSev INTEGER,
    avgLoadSev INTEGER,
    cpuUtilSev INTEGER,
    cpuKernelSev INTEGER,
    cpuUserSev INTEGER,
    cpuIOWaitSev INTEGER,
    memScanRate INTEGER
);
/

create or replace type SMP_EMD_HOST_CONFIG_OBJ as OBJECT (
    os VARCHAR2(128),
    osVersion VARCHAR2(128),
    upsince VARCHAR2(128),
    platform VARCHAR2(128),
    patchLevel VARCHAR2(128),
    ipAddress VARCHAR2(128)
);
/

create or replace type SMP_EMD_MEMORY_OBJ as OBJECT (
    totalMem INTEGER,
    freeMem INTEGER,
    freeMemSev INTEGER,
    swapUtil INTEGER,
    totalSwap INTEGER,
    freeSwap INTEGER, 
    swapUtilSev INTEGER
);
/

create or replace type SMP_EMD_DISK_OBJ as OBJECT (
    diskTotalSize INTEGER,
    diskAvailSize INTEGER,
    diskTotalSizeKeyVal VARCHAR2(128),
    diskTotalSizeSev INTEGER,
    diskTotalSizeStatusFound INTEGER,
    diskAvailSizeKeyVal VARCHAR2(128),
    diskAvailSizeSev INTEGER,
    diskAvailSizeStatusFound INTEGER,
    ioActivity NUMBER,
    longestServ NUMBER
);
/

create or replace type SMP_EMD_KEY_DETAIL_OBJ as OBJECT (
    keyName VARCHAR2(128),
    metricColumn VARCHAR2(128),
    value NUMBER
);
/    

create or replace type SMP_EMD_KEY_DETAIL_ARRAY as TABLE of SMP_EMD_KEY_DETAIL_OBJ;
/

create or replace type SMP_EMD_TIME_SERIES_OBJ as OBJECT (
    metricColumn VARCHAR2(128),
    rollupTimestamp DATE,
    valueMaximum NUMBER,
    valueMinimum NUMBER,
    valueAverage NUMBER
);
/

create or replace type SMP_EMD_TIME_SERIES_ARRAY as TABLE of SMP_EMD_TIME_SERIES_OBJ;
/

create or replace type SMP_EMD_TOP_PROCS_OBJ as OBJECT (
    processID VARCHAR2(128),
    userName VARCHAR2(128),
    cmdArgs  VARCHAR2(128),
    cpuUtil  NUMBER(5,2),
    memUtil  NUMBER(5,2)
);
/

create or replace type SMP_EMD_TOP_PROCS_ARRAY as TABLE of SMP_EMD_TOP_PROCS_OBJ;
/

create or replace type SMP_EMD_PAGING_OBJ as OBJECT (
    pgout NUMBER(15,2),
    ppgout NUMBER(15,2),
    pgfree NUMBER(15,2),
    pgscan NUMBER(15,2),
    ufsipf NUMBER(15,2),
    atch NUMBER(15,2),
    pgin NUMBER(15,2),
    ppgin NUMBER(15,2),
    pflt NUMBER(15,2),
    vflt NUMBER(15,2),
    slock NUMBER(15,2)
);
/

create or replace type SMP_EMD_LSNR_LOAD_RESP_OBJ as OBJECT (
    estConns NUMBER(15,2),
    refConns NUMBER(15,2),
    tnsPing NUMBER(15,2),
    tnsPingSev INTEGER
);
/

create or replace type SMP_EMD_LSNR_GEN_STATUS_OBJ as OBJECT (
    tnsAddress VARCHAR2(128),
    alias VARCHAR2(128),
    version VARCHAR2(128),
    startDate VARCHAR2(128),
    uptime VARCHAR2(128),
    traceLevel VARCHAR2(128),
    security VARCHAR2(128),
    snmp VARCHAR2(128)
);
/

-- Upload time object
CREATE OR REPLACE TYPE EM_LOADER_UPLOAD_TIME AS OBJECT
(
    target_guid VARCHAR2(32),
    upload_time VARCHAR2(32)
);
/

CREATE OR REPLACE TYPE EM_LOADER_UPLOAD_TIME_ARRAY AS TABLE
  OF EM_LOADER_UPLOAD_TIME;
/

CREATE OR REPLACE TYPE SMP_EMD_DELETE_REC as OBJECT (
    targetName VARCHAR2(256),
    targetType VARCHAR2(128)
);
/

CREATE OR REPLACE TYPE SMP_EMD_DELETE_REC_ARRAY as TABLE of SMP_EMD_DELETE_REC;
/


CREATE OR REPLACE TYPE SMP_EMD_TGT_OBJECT as OBJECT (
     target_name VARCHAR2(256),
     target_type VARCHAR2(64),
     target_guid RAW(16),
     display_name VARCHAR(256),
     type_display_name VARCHAR2(128),
     host_name VARCHAR2(256)
);
/

CREATE OR REPLACE TYPE SMP_EMD_TGT_OBJECT_TBL as TABLE of SMP_EMD_TGT_OBJECT;
/

-- type for compare metrics in metric details page
CREATE OR REPLACE TYPE MGMT_MD_COMPARE_OBJ as OBJECT (
    target_guid RAW(16),
    metric_guid RAW(16),
    target_name VARCHAR2(256),
    timezone_region VARCHAR2(64),
    start_time DATE,
    end_time DATE
);
/

create or replace type MGMT_MD_COMPARE_ARRAY as TABLE of MGMT_MD_COMPARE_OBJ;
/
