Rem
Rem $Header: beacon_admin_pkgbody.sql 29-aug-2005.11:57:25 mfidanbo Exp $
Rem
Rem beacon_admin_pkgbody.sql
Rem
Rem Copyright (c) 2002, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      beacon_admin_pkgbody.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    mfidanbo    08/29/05 - dont call key value deletion for table metrics 
Rem    mfidanbo    08/01/05 - null check 
Rem    mfidanbo    07/18/05 - publicize key_cal deletion 
Rem    mfidanbo    05/31/05 - bcn delete callback fixes 
Rem    rmarripa    05/13/05 - force job queue cleanup 
Rem    mfidanbo    03/03/05 - clean data, sevs, thresholds from svcs when bcn 
Rem                           is deleted 
Rem    snakai      09/24/04 - fix type_meta_ver 
Rem    snakai      11/10/03 - up metric version 
Rem    rmarripa    10/29/03 - code review comments 
Rem    rmarripa    10/27/03 - add procedures to configure transaction 
Rem    vjraghav    08/26/03 - Changing Max Response Time to Slowest Page 
Rem    snakai      07/25/02 - snakai_bug-2465988
Rem    snakai      07/25/02 - Created
Rem

CREATE OR REPLACE PACKAGE BODY EMD_BCN_ADMIN AS

CURSOR affected_svcs(bcn_guid RAW) IS
  SELECT t.target_guid, t.target_name, t.target_type, b.participates_avail as is_key
    FROM MGMT_BCN_TARGET b,
         MGMT_TARGETS t
   WHERE b.beacon_target_guid = bcn_guid
     AND t.target_guid = b.target_guid;

--------------------------------------------------------------------------
----------Start Add/Remove Transaction Collection Properties API--------------

--------------------------------------------------------------------------------
--Collection properties are of two types. Target Level properties and Transaction
--level properties. Target level properties are applied to all transactions. 
--Transaction level properties are applied only specified transactions. If a property
--is specified both at the Target level and Transaction level, the property specified 
--at the Transaction level takes precedence. Following are the APIs to add/delete 
--properties at the Target and Transaction Level. 

-- Target Name, Target Type in the APIs below for the target, whcih owns 
-- transactions. 
-- Collection Property names should match the property name in the target type meta
-- data. These APIs will not check the Property Names with the target type metadata. 
-- It is the callers responsibility to make sure that the preoprty names are correct.
--------------------------------------------------------------------------------
 
--PROCEDURE ADD_TXN_COLL_TGT_LEVEL_PROP
--This procedure adds TARGET level collection property. 
-- target_type_in - Target Name 
-- target_type_in - Target Type 
-- property_name_in - Collection Property Name (should match the ItemProperty in the
-- target type metadata. Use "OCCURENCES" to set number of occurences. ) 
-- property_value_in - Collection Property Value 

PROCEDURE ADD_TXN_COLL_TGT_LEVEL_PROP(
              target_name_in             IN VARCHAR2,
              target_type_in             IN VARCHAR2,
              property_name_in           IN VARCHAR2,
              property_value_in          IN VARCHAR2) IS
v_tgt RAW(16);
BEGIN
  IF ((target_name_in IS NULL ) OR (target_type_in IS NULL ) OR 
     (property_name_in IS NULL ) OR (property_value_in IS NULL ) ) THEN
   raise_application_error( -20001, 'Invalid arguments. target_name_in, target_type_in, property_name_in, property_value_in arguments can not be empty', TRUE);
  END IF;

  BEGIN
    SELECT target_guid 
      INTO v_tgt
      FROM mgmt_targets 
     WHERE target_name = target_name_in 
       AND target_type = target_type_in;
  EXCEPTION
    WHEN NO_DATA_FOUND THEN
      raise_application_error(-20002, 'Target Name and Target Type does not exist in the repository Or you may not have privileges on the target', TRUE);
  END;

  INSERT INTO mgmt_target_properties (target_guid, property_name, property_type, property_value)
       VALUES  ( v_tgt, property_name_in, REP_ONLY_PROP_TYPE, property_value_in);
END ADD_TXN_COLL_TGT_LEVEL_PROP;

--PROCEDURE ADD_TXN_COLL_TXN_LEVEL_PROP
--This procedure adds TRANSACTION level collection property. 
-- target_type_in - Target Name 
-- target_type_in - Target Type 
-- txn_name_in - Transaction Name 
-- txn_type_in - Transaction Type 
-- property_name_in - Collection Property Name (should match the ItemProperty in the
-- target type metadata. Use "OCCURENCES" to set number of occurences. ) 
-- property_value_in - Collection Property Value 

PROCEDURE ADD_TXN_COLL_TXN_LEVEL_PROP(
              target_name_in             IN VARCHAR2,
              target_type_in             IN VARCHAR2,
              txn_name_in                IN VARCHAR2, 
              txn_type_in                IN VARCHAR2, 
              property_name_in           IN VARCHAR2,
              property_value_in          IN VARCHAR2) IS 
v_tgt RAW(16);
v_txn_id VARCHAR(64);
BEGIN
  IF ((target_name_in IS NULL ) OR (target_type_in IS NULL ) OR (txn_name_in  IS NULL ) OR
     (txn_type_in IS NULL ) OR (property_name_in IS NULL ) OR (property_value_in IS NULL ) ) THEN
   raise_application_error( -20001, 'Invalid arguments. target_name_in, target_type_in, txn_name_in, property_name_in, property_value_in arguments can not be empty', TRUE);
  END IF;

  BEGIN
    SELECT target_guid 
      INTO v_tgt
      FROM mgmt_targets 
     WHERE target_name = target_name_in 
       AND target_type = target_type_in;
  EXCEPTION
    WHEN NO_DATA_FOUND THEN
      raise_application_error(-20002, 'Target Name and Target Type does not exist in the repository Or you may not have privileges on the target', TRUE);
  END;

  BEGIN
    SELECT RAWTOHEX(txn_guid)||':' 
      INTO v_txn_id
      FROM mgmt_bcn_txn_defn 
     WHERE target_guid = v_tgt 
       AND name = txn_name_in
       AND txn_type = txn_type_in;
  EXCEPTION
    WHEN NO_DATA_FOUND THEN
      raise_application_error(-20003, 'Specified Transaction Name does not exist in the repository', TRUE);
  END;

  INSERT INTO mgmt_target_properties (target_guid, property_name, property_type, property_value)
       VALUES  ( v_tgt, v_txn_id||property_name_in, REP_ONLY_PROP_TYPE, property_value_in);
  
END ADD_TXN_COLL_TXN_LEVEL_PROP;

--PROCEDURE DEL_TXN_COLL_TGT_LEVEL_PROP
--This procedure deletes TARGET level collection property given the property name. 
-- target_type_in - Target Name 
-- target_type_in - Target Type 
-- property_name_in - Collection Property Name (should match the ItemProperty in the
-- target type metadata. Use "OCCURENCES" to set number of occurences. ) 

PROCEDURE DEL_TXN_COLL_TGT_LEVEL_PROP(
              target_name_in             IN VARCHAR2,
              target_type_in             IN VARCHAR2,
              property_name_in           IN VARCHAR2) IS 
v_tgt RAW(16);
BEGIN
  IF ((target_name_in IS NULL ) OR (target_type_in IS NULL ) OR 
     (property_name_in IS NULL ) ) THEN
   raise_application_error( -20001, 'Invalid arguments. target_name_in, target_type_in, property_name_in arguments can not be empty', TRUE);
  END IF;
 
  BEGIN
    SELECT target_guid 
      INTO v_tgt
      FROM mgmt_targets 
     WHERE target_name = target_name_in 
       AND target_type = target_type_in;
  EXCEPTION
    WHEN NO_DATA_FOUND THEN
      raise_application_error(-20002, 'Target Name and Target Type does not exist in the repository Or you may not have privileges on the target', TRUE);
  END;

  DELETE FROM mgmt_target_properties 
   WHERE target_guid = v_tgt 
     AND property_type = REP_ONLY_PROP_TYPE
     AND property_name = property_name_in;
  
END DEL_TXN_COLL_TGT_LEVEL_PROP;

--PROCEDURE DEL_TXN_COLL_TXN_LEVEL_PROP
--This procedure deletes TRANSACTION level collection property given the transaction 
--name and property name. 
-- target_type_in - Target Name 
-- target_type_in - Target Type 
-- txn_name_in - Transaction Name 
-- txn_type_in - Transaction Type 
-- property_name_in - Collection Property Name (should match the ItemProperty in the
-- target type metadata. Use "OCCURENCES" to set number of occurences. ) 

PROCEDURE DEL_TXN_COLL_TXN_LEVEL_PROP(
              target_name_in             IN VARCHAR2,
              target_type_in             IN VARCHAR2,
              txn_name_in                IN VARCHAR2,               
              txn_type_in                IN VARCHAR2,               
              property_name_in           IN VARCHAR2) IS 
v_tgt RAW(16);
prop_name VARCHAR2(64);
BEGIN
  IF ((target_name_in IS NULL ) OR (target_type_in IS NULL ) OR (txn_name_in  IS NULL ) OR
     (txn_type_in IS NULL ) OR (property_name_in IS NULL ) ) THEN
   raise_application_error( -20001, 'Invalid arguments. target_name_in, target_type_in, txn_name_in, property_name_in arguments can not be empty', TRUE);
  END IF;

  BEGIN
    SELECT target_guid 
      INTO v_tgt
      FROM mgmt_targets 
     WHERE target_name = target_name_in 
       AND target_type = target_type_in;
  EXCEPTION
    WHEN NO_DATA_FOUND THEN
      raise_application_error(-20002, 'Target Name and Target Type does not exist in the repository Or you may not have privileges on the target', TRUE);
  END;

  BEGIN
    SELECT RAWTOHEX(txn_guid)||':' 
      INTO prop_name
      FROM mgmt_bcn_txn_defn 
     WHERE target_guid = v_tgt 
       AND name = txn_name_in
       AND txn_type = txn_type_in;
  EXCEPTION
    WHEN NO_DATA_FOUND THEN
      raise_application_error(-20003, 'Specified Transaction Name does not exist in the repository', TRUE);
  END;
  prop_name := prop_name||property_name_in;

  DELETE FROM mgmt_target_properties 
   WHERE target_guid = v_tgt 
     AND property_type = REP_ONLY_PROP_TYPE
     AND property_name = prop_name;
  
END DEL_TXN_COLL_TXN_LEVEL_PROP;

--PROCEDURE DEL_TXN_COLL_TGT_LEVEL_PROPS
--This procedure deletes all TARGET level collection properties. 
-- target_type_in - Target Name 
-- target_type_in - Target Type 

PROCEDURE DEL_TXN_COLL_TGT_LEVEL_PROPS(
              target_name_in             IN VARCHAR2,
              target_type_in             IN VARCHAR2) IS 
v_tgt RAW(16);
BEGIN
  IF ((target_name_in IS NULL ) OR (target_type_in IS NULL ) ) THEN
   raise_application_error( -20001, 'Invalid arguments. target_name_in, target_type_in arguments can not be empty', TRUE);
  END IF;

  BEGIN
    SELECT target_guid 
      INTO v_tgt
      FROM mgmt_targets 
     WHERE target_name = target_name_in 
       AND target_type = target_type_in;
  EXCEPTION
    WHEN NO_DATA_FOUND THEN
      raise_application_error(-20002, 'Target Name and Target Type does not exist in the repository Or you may not have privileges on the target', TRUE);
  END;

  DELETE FROM mgmt_target_properties 
   WHERE target_guid = v_tgt 
     AND property_type = REP_ONLY_PROP_TYPE
     AND INSTR(property_name, ':') = 0; 
  
END DEL_TXN_COLL_TGT_LEVEL_PROPS;

--PROCEDURE DEL_TXN_COLL_TXN_LEVEL_PROPS
--This procedure deletes all TRANSACTION level collection properties given a transaction name. 
-- target_type_in - Target Name 
-- target_type_in - Target Type 
-- txn_name_in - Transaction Name 
-- txn_type_in - Transaction Type 

PROCEDURE DEL_TXN_COLL_TXN_LEVEL_PROPS(
              target_name_in             IN VARCHAR2,
              target_type_in             IN VARCHAR2,
              txn_name_in                IN VARCHAR2, 
              txn_type_in                IN VARCHAR2) IS 
v_tgt RAW(16);
v_prop_name VARCHAR(64);
BEGIN
  IF ((target_name_in IS NULL ) OR (target_type_in IS NULL ) OR (txn_name_in  IS NULL )) THEN
   raise_application_error( -20001, 'Invalid arguments. target_name_in, target_type_in, txn_name_in can not be empty', TRUE);
  END IF;

  BEGIN
    SELECT target_guid 
      INTO v_tgt
      FROM mgmt_targets 
     WHERE target_name = target_name_in 
       AND target_type = target_type_in;
  EXCEPTION
    WHEN NO_DATA_FOUND THEN
      raise_application_error(-20002, 'Target Name and Target Type does not exist in the repository Or you may not have privileges on the target', TRUE);
  END;

  BEGIN
    SELECT RAWTOHEX(txn_guid)||':' 
      INTO v_prop_name
      FROM mgmt_bcn_txn_defn 
     WHERE target_guid = v_tgt 
       AND name = txn_name_in
       AND txn_type = txn_type_in;
  EXCEPTION
    WHEN NO_DATA_FOUND THEN
      raise_application_error(-20003, 'Specified Transaction Name does not exist in the repository', TRUE);
  END;
  
  DELETE FROM mgmt_target_properties 
   WHERE target_guid = v_tgt 
     AND property_type = REP_ONLY_PROP_TYPE
     AND property_name like v_prop_name||'%';
  
END DEL_TXN_COLL_TXN_LEVEL_PROPS;

--PROCEDURE DEL_TXN_COLL_ALL_PROPS
--This procedure deletes all TARGET and TRANSACTION level collection properties. 
-- target_type_in - Target Name 
-- target_type_in - Target Type 

PROCEDURE DEL_TXN_COLL_ALL_PROPS(
              target_name_in             IN VARCHAR2,
              target_type_in             IN VARCHAR2) IS 
v_tgt RAW(16);
BEGIN
  IF ((target_name_in IS NULL ) OR (target_type_in IS NULL ) ) THEN
   raise_application_error( -20001, 'Invalid arguments. target_name_in, target_type_in can not be empty', TRUE);
  END IF;

  BEGIN
    SELECT target_guid 
      INTO v_tgt
      FROM mgmt_targets 
     WHERE target_name = target_name_in 
       AND target_type = target_type_in;
  EXCEPTION
    WHEN NO_DATA_FOUND THEN
      raise_application_error(-20002, 'Target Name and Target Type does not exist in the repository Or you may not have privileges on the target', TRUE);
  END;
  DELETE FROM mgmt_target_properties 
   WHERE target_guid = v_tgt 
     AND property_type = REP_ONLY_PROP_TYPE;
END DEL_TXN_COLL_ALL_PROPS;

--------------------------------------------------------------------------

PROCEDURE GEN_BEACON_RESP_METRICS( tgt_type_in IN VARCHAR2, type_meta_ver_in IN VARCHAR2 )
IS

  v_metric_guid    RAW(16);

BEGIN

  -- Response
  BEGIN
    v_metric_guid := dbms_obfuscation_toolkit.md5(
                       input => utl_raw.cast_to_raw(tgt_type_in ||
                         ';Response'));
    INSERT INTO MGMT_METRICS 
      ( target_type, metric_name, metric_type, metric_guid, 
        description, short_name, is_for_summary, type_meta_ver )
    VALUES   
      ( tgt_type_in, 'Response', 2, v_metric_guid, 
        NULL, 'Response', 0, type_meta_ver_in );
    INSERT INTO MGMT_METRICS 
      ( target_type, metric_name, metric_type, metric_guid, 
        description, short_name, is_for_summary )
    VALUES   
      ( tgt_type_in, 'Response', 2, v_metric_guid, 
        NULL, 'Response', 0 );
  EXCEPTION
    WHEN DUP_VAL_ON_INDEX THEN
      -- already done, but try all columns to be sure
      NULL;
  END;

  -- Response/Status
  BEGIN
    v_metric_guid := dbms_obfuscation_toolkit.md5(
                       input => utl_raw.cast_to_raw(tgt_type_in ||
                         ';Response;Status'));
    INSERT INTO MGMT_METRICS 
      ( target_type, metric_name, metric_type, metric_guid, 
        metric_column, key_column, description, unit, short_name, 
        is_for_summary, type_meta_ver)
    VALUES   
      ( tgt_type_in, 'Response', 0, v_metric_guid, 'Status', ' ',
        NULL, NULL, 'Status', 0, type_meta_ver_in );
    INSERT INTO MGMT_METRICS 
      ( target_type, metric_name, metric_type, metric_guid, 
        metric_column, key_column, description, unit, short_name, 
        is_for_summary)
    VALUES   
      ( tgt_type_in, 'Response', 0, v_metric_guid, 'Status', ' ',
        NULL, NULL, 'Status', 0 );
  EXCEPTION
    WHEN DUP_VAL_ON_INDEX THEN
      -- already done, but try all columns to be sure
      NULL;
  END;

END GEN_BEACON_RESP_METRICS;

PROCEDURE DELETE_BEACON_PROPS(p_bcn_guid IN RAW) IS
BEGIN
  -- remove all bcn txn props which belong to this beacon
  DELETE
    FROM MGMT_BCN_BCNTXN_PROPS
   WHERE bcn_guid = p_bcn_guid;

  DELETE
    FROM MGMT_BCN_BCNSTEP_PROPS
   WHERE bcn_guid = p_bcn_guid;

END DELETE_BEACON_PROPS;


PROCEDURE LOG_SYS_ERR  (errmsg IN VARCHAR2 )
IS

  -- length of column in system err log table is 2048.   no constant
  -- provided in the log pkg so, i'm using a local constant for now.
  k_logmsg_maxlen INTEGER := 2048;

BEGIN

  IF (errmsg IS NOT NULL) THEN
    IF LENGTH(errmsg) > k_logmsg_maxlen THEN
      MGMT_LOG.LOG_ERROR(EMD_BCNTXN.MODULE_NAME, NULL, SUBSTR(errmsg, 1, k_logmsg_maxlen));
    ELSE
      MGMT_LOG.LOG_ERROR(EMD_BCNTXN.MODULE_NAME, NULL, errmsg);
    END IF;
  END IF;

END LOG_SYS_ERR;


PROCEDURE CLEANUP_BEACON_JOB_QUEUES(p_bcn_guid IN RAW,
                                    p_target_guid IN RAW) IS

  v_queue_name          VARCHAR2(128);
  v_job_exists          NUMBER;

BEGIN
  -- remove all pending jobs (clear all job queues)
  v_queue_name := MGMT_GENSVC_UPDBCN.JOB_NAME_PREFIX || p_target_guid || ' ' || p_bcn_guid;
      
  SELECT count(1) INTO v_job_exists
    FROM MGMT_JOB_QUEUES
   WHERE queue_name = v_queue_name;

  IF v_job_exists > 0 THEN
    MGMT_JOB_ENGINE.CLEANUP_JOB_QUEUE(v_queue_name, true);
  END IF;

END CLEANUP_BEACON_JOB_QUEUES;

PROCEDURE BEACON_KEY_VALUE_CLEANUP2
  (
    p_target_guid IN RAW,
    p_metric_guids IN SMP_EMD_STRING_ARRAY,
    p_key_value   IN VARCHAR2
  )
IS
BEGIN
  
  IF (p_target_guid IS NULL OR p_key_value IS NULL) THEN
   LOG_SYS_ERR('Invalid arguments. p_target_guid and p_key_value arguments can not be empty');
   raise_application_error( -20001, 'Invalid arguments. p_target_guid and p_key_value arguments can not be empty', TRUE);   
  END IF;

  -- cleanup thresholds for all targets and key_values passed
  DELETE FROM MGMT_ADMIN_METRIC_THRESHOLDS
   WHERE key_value = p_key_value
     AND target_guid = p_target_guid;

  EM_METRIC.EXEC_CBK_METRIC_KEYVAL(p_target_guid, p_metric_guids, p_key_value);

END BEACON_KEY_VALUE_CLEANUP2;

PROCEDURE BEACON_KEY_VALUE_CLEANUP
(
  p_target_guid IN RAW,
  p_beacon_name IN VARCHAR2
)

IS
  v_metric_guids        SMP_EMD_STRING_ARRAY := NULL;
  v_keys                SMP_EMD_STRING_ARRAY := NULL;

BEGIN
      -- collect all keys that belong to this beacon and proxy target
    SELECT composite_key BULK COLLECT INTO v_keys
      FROM MGMT_METRICS_COMPOSITE_KEYS
     WHERE target_guid = p_target_guid
       AND key_part2_value = p_beacon_name;

      --execute key_value deletion callbacks with p_target_guid, metric_guids and keys
   IF(v_keys IS NOT NULL AND v_keys.COUNT > 0) THEN
      FOR i IN v_keys.FIRST..v_keys.LAST LOOP
        v_metric_guids := EMD_BCNTXN.GET_METRICS_FOR_KEYVAL(p_target_guid, v_keys(i), 'ALL');

        -- if metric_guids is null then we are trying to get a composite key for which
        -- the test definition does not exist. So ignore.
        IF(v_metric_guids IS NOT NULL AND v_metric_guids.COUNT > 0) THEN
          BEACON_KEY_VALUE_CLEANUP2(p_target_guid, v_metric_guids, v_keys(i));
        END IF;
      END LOOP;      
   END IF;
   IF(v_keys IS NOT NULL) THEN
     v_keys.DELETE;
   END IF;
   IF(v_metric_guids IS NOT NULL) THEN
     v_metric_guids.DELETE;
   END IF;

  EXCEPTION WHEN OTHERS THEN
   IF(v_keys IS NOT NULL) THEN
     v_keys.DELETE;
   END IF;
   IF(v_metric_guids IS NOT NULL) THEN
     v_metric_guids.DELETE;
   END IF;
  RAISE;

END BEACON_KEY_VALUE_CLEANUP;



PROCEDURE BEACON_PRE_DELETE_CALLBACK(p_target_name IN VARCHAR2,
                                     p_target_type IN VARCHAR2,
                                     p_target_guid IN RAW)
IS
  CURSOR key_bcn_cur(tgt_id RAW ) IS
      SELECT tgt.target_name as tgt_name
        FROM MGMT_BCN_TARGET bcn, MGMT_TARGETS tgt
       WHERE bcn.target_guid = tgt_id
         AND bcn.beacon_target_guid = tgt.target_guid
         AND tgt.target_type = MGMT_GLOBAL.G_BEACON_TARGET_TYPE
         AND bcn.participates_avail = 'Y';

  v_key_bcn_list        MGMT_GENSVC_TGT_NAME_ARRAY := NULL;
BEGIN

  IF (p_target_type = 'oracle_beacon') AND
     (p_target_name IS NOT NULL) AND
     (p_target_name <> '-') THEN

    DELETE_BEACON_PROPS(p_target_guid);

    FOR v_tgt IN affected_svcs(p_target_guid)
    LOOP
      CLEANUP_BEACON_JOB_QUEUES(p_target_guid, v_tgt.target_guid);
      -- reset key beacons for svc if what we deleted was a key_beacon
      -- right now, we do not allow deletion of key_beacons so this is never touched
      IF ( v_tgt.is_key = 'Y') THEN
        FOR sub_rec in key_bcn_cur(v_tgt.target_guid)
        LOOP
          v_key_bcn_list := MGMT_GENSVC_TGT_NAME_ARRAY();
          v_key_bcn_list.extend;
          v_key_bcn_list(key_bcn_cur%ROWCOUNT) := sub_rec.tgt_name;
        END LOOP;
        MGMT_GENSVC_AVAIL.SET_BEACONS(v_tgt.target_name, v_tgt.target_type, v_key_bcn_list);
        v_key_bcn_list.DELETE;
      END IF;
    END LOOP;
    -- delete the beacon target queue for watch list items
    CLEANUP_BEACON_JOB_QUEUES(p_target_guid, p_target_guid);
    COMMIT;
  END IF;

END BEACON_PRE_DELETE_CALLBACK;

--------------------------------------------------------------------------

PROCEDURE BEACON_DELETE_CALLBACK( p_target_name IN VARCHAR2,
                                  p_target_type VARCHAR2,
                                  p_target_guid RAW )
IS

  v_more                BOOLEAN;
  v_txn_list            MGMT_GENSVC_UBJOB_TEST_ARRAY := NULL;
  v_dep_keys            SMP_EMD_STRING_ARRAY := NULL;  
BEGIN

  IF (p_target_type = 'oracle_beacon') AND
     (p_target_name IS NOT NULL) AND
     (p_target_name <> '-') THEN
    
    -- delete properties defined for this beacon for all tests
    DELETE_BEACON_PROPS(p_target_guid);

    FOR v_tgt IN affected_svcs(p_target_guid)
    LOOP



      CLEANUP_BEACON_JOB_QUEUES(p_target_guid, v_tgt.target_guid);
      BEACON_KEY_VALUE_CLEANUP(v_tgt.target_guid, p_target_name);

      DELETE 
        FROM MGMT_BCN_TARGET
       WHERE target_guid = v_tgt.target_guid
         AND beacon_target_guid = p_target_guid;

    END LOOP;
    -- delete the beacon target queue for watch list items
    CLEANUP_BEACON_JOB_QUEUES(p_target_guid, p_target_guid);
    COMMIT;
  END IF;
END BEACON_DELETE_CALLBACK;

--------------------------------------------------------------------------

END EMD_BCN_ADMIN;
/
--------------------------------------------------------------------------

SHOW ERRORS;

