Rem
Rem $Header: beacon_admin_pkgdef.sql 18-jul-2005.16:38:54 mfidanbo Exp $
Rem
Rem beacon_admin_pkgdef.sql
Rem
Rem Copyright (c) 2002, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      beacon_admin_pkgdef.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    mfidanbo    07/18/05 - publicize key_cal deletion 
Rem    mfidanbo    03/07/05 - add pre deletion call back 
Rem    snakai      09/24/04 - fix type_meta_ver 
Rem    rmarripa    10/29/03 - code review comments 
Rem    rmarripa    10/27/03 - add procedures to configure transaction 
Rem    rpinnama    09/18/02 - Remove authid current_user from create package
Rem    snakai      07/25/02 - snakai_bug-2465988
Rem    snakai      07/25/02 - Created
Rem

-- Beacon Admin Package -------------------------------------------

CREATE OR REPLACE PACKAGE EMD_BCN_ADMIN AS

--------------------------------------------------------------------------

REP_ONLY_PROP_TYPE      CONSTANT VARCHAR2(64) := 'REP_ONLY';

----------Start Add/Remove Transaction Collection Properties API--------------

--------------------------------------------------------------------------------
--Collection properties are of two types. Target Level properties and Transaction
--level properties. Target level properties are applied to all transactions. 
--Transaction level properties are applied only specified transactions. If a property
--is specified both at the Target level and Transaction level, the property specified 
--at the Transaction level takes precedence. Following are the APIs to add/delete 
--properties at the Target and Transaction Level. 

-- Target Name, Target Type in the APIs below for the target, whcih owns 
-- transactions. 
-- Collection Property names should match the property name in the target type meta
-- data. These APIs will not check the Property Names with the target type metadata. 
-- It is the callers responsibility to make sure that the preoprty names are correct.
--------------------------------------------------------------------------------
 
--PROCEDURE ADD_TXN_COLL_TGT_LEVEL_PROP
--This procedure adds TARGET level collection property. 
-- target_type_in - Target Name 
-- target_type_in - Target Type 
-- property_name_in - Collection Property Name (should match the ItemProperty in the
-- target type metadata. Use "OCCURENCES" to set number of occurences. ) 
-- property_value_in - Collection Property Value 

PROCEDURE ADD_TXN_COLL_TGT_LEVEL_PROP(
              target_name_in             IN VARCHAR2,
              target_type_in             IN VARCHAR2,
              property_name_in           IN VARCHAR2,
              property_value_in          IN VARCHAR2);

--PROCEDURE ADD_TXN_COLL_TXN_LEVEL_PROP
--This procedure adds TRANSACTION level collection property. 
-- target_type_in - Target Name 
-- target_type_in - Target Type 
-- txn_name_in - Transaction Name 
-- txn_type_in - Transaction Type 
-- property_name_in - Collection Property Name (should match the ItemProperty in the
-- target type metadata. Use "OCCURENCES" to set number of occurences. ) 
-- property_value_in - Collection Property Value 

PROCEDURE ADD_TXN_COLL_TXN_LEVEL_PROP(
              target_name_in             IN VARCHAR2,
              target_type_in             IN VARCHAR2,
              txn_name_in                IN VARCHAR2, 
              txn_type_in                IN VARCHAR2, 
              property_name_in           IN VARCHAR2,
              property_value_in          IN VARCHAR2);

--PROCEDURE DEL_TXN_COLL_TGT_LEVEL_PROP
--This procedure deletes TARGET level collection property given the property name. 
-- target_type_in - Target Name 
-- target_type_in - Target Type 
-- property_name_in - Collection Property Name (should match the ItemProperty in the
-- target type metadata. Use "OCCURENCES" to set number of occurences. ) 

PROCEDURE DEL_TXN_COLL_TGT_LEVEL_PROP(
              target_name_in             IN VARCHAR2,
              target_type_in             IN VARCHAR2,
              property_name_in           IN VARCHAR2);

--PROCEDURE DEL_TXN_COLL_TXN_LEVEL_PROP
--This procedure deletes TRANSACTION level collection property given the transaction 
--name and property name. 
-- target_type_in - Target Name 
-- target_type_in - Target Type 
-- txn_name_in - Transaction Name 
-- txn_type_in - Transaction Type 
-- property_name_in - Collection Property Name (should match the ItemProperty in the
-- target type metadata. Use "OCCURENCES" to set number of occurences. ) 

PROCEDURE DEL_TXN_COLL_TXN_LEVEL_PROP(
              target_name_in             IN VARCHAR2,
              target_type_in             IN VARCHAR2,
              txn_name_in                IN VARCHAR2,               
              txn_type_in                IN VARCHAR2,               
              property_name_in           IN VARCHAR2);

--PROCEDURE DEL_TXN_COLL_TGT_LEVEL_PROPS
--This procedure deletes all TARGET level collection properties. 
-- target_type_in - Target Name 
-- target_type_in - Target Type 

PROCEDURE DEL_TXN_COLL_TGT_LEVEL_PROPS(
              target_name_in             IN VARCHAR2,
              target_type_in             IN VARCHAR2);

--PROCEDURE DEL_TXN_COLL_TXN_LEVEL_PROPS
--This procedure deletes all TRANSACTION level collection properties given a transaction name. 
-- target_type_in - Target Name 
-- target_type_in - Target Type 
-- txn_name_in - Transaction Name 
-- txn_type_in - Transaction Type 

PROCEDURE DEL_TXN_COLL_TXN_LEVEL_PROPS(
              target_name_in             IN VARCHAR2,
              target_type_in             IN VARCHAR2,
              txn_name_in                IN VARCHAR2,
              txn_type_in                IN VARCHAR2);

--PROCEDURE DEL_TXN_COLL_ALL_PROPS
--This procedure deletes all TARGET and TRANSACTION level collection properties. 
-- target_type_in - Target Name 
-- target_type_in - Target Type 

PROCEDURE DEL_TXN_COLL_ALL_PROPS(
              target_name_in             IN VARCHAR2,
              target_type_in             IN VARCHAR2);

----------End Add/Remove Transaction Collection Properties API--------------

-- disabling the metric http and ping generation metrics as they repository
-- is now prepulated with all metrics.
-- PROCEDURE GEN_BEACON_HTTP_METRICS( tgt_type_in IN VARCHAR2 ); 
-- PROCEDURE GEN_BEACON_PING_METRICS( tgt_type_in IN VARCHAR2 );

PROCEDURE GEN_BEACON_RESP_METRICS( tgt_type_in IN VARCHAR2, type_meta_ver_in IN VARCHAR2 );

PROCEDURE BEACON_KEY_VALUE_CLEANUP (p_target_guid IN RAW,
                                    p_beacon_name IN VARCHAR2);

PROCEDURE BEACON_DELETE_CALLBACK( p_target_name IN VARCHAR2,
                                  p_target_type IN VARCHAR2,
                                  p_target_guid IN RAW) ;

PROCEDURE BEACON_PRE_DELETE_CALLBACK( p_target_name IN VARCHAR2,
                                  p_target_type IN VARCHAR2,
                                  p_target_guid IN RAW) ;
 
END EMD_BCN_ADMIN;
/
--------------------------------------------------------------------------

SHOW ERRORS;

