Rem drv: <create type="tables"/>
Rem
Rem $Header: beacon_tables.sql 29-jun-2005.01:47:16 gsbhatia Exp $
Rem
Rem beacon_tables.sql
Rem
Rem Copyright (c) 2002, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      beacon_tables.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    gsbhatia    06/26/05 - New repmgr header impl 
Rem    rmarripa    03/30/05 - add parent to the step 
Rem    rmarripa    03/25/05 - add parent field to the step 
Rem    rmarripa    03/10/05 - remove obsolete tables 
Rem    gsbhatia    02/13/05 - updating repmgr header 
Rem    gsbhatia    02/09/05 - updating repmgr header 
Rem    gsbhatia    02/07/05 - updating repmgr header 
Rem    ktlaw       01/11/05 - add repmgr header 
Rem    vjraghav    11/03/04 - Creating a new data type for templatizing 
Rem                           properties 
Rem    vjraghav    11/02/04 - Creating a new data type for templatizing 
Rem                           properties 
Rem    mvajapey    10/26/04 - Increase the size of the JDBC conn_string field 
Rem                           from 256 to 4000 
Rem    vjraghav    10/07/04 - Increasing the sizes of txn/step/stepgroup type 
Rem                           columns 
Rem    vjraghav    10/07/04 - 
Rem    vjraghav    09/15/04 - 
Rem    rmarripa    08/30/04 - change mgmt_bcn_target table 
Rem    vjraghav    06/25/04 - New tables for Rel2 
Rem    snakai      09/19/03 - add target guid to sql and conn tables 
Rem    asawant     05/14/03 - Adding JDBC details table.
Rem    snakai      12/30/02 - Add e2e tables
Rem    snakai      07/31/03 - add collection to avail def table to handle metric errors
Rem    snakai      06/26/03 - update avail marker properly
Rem    snakai      04/20/03 - increase size of hidden_input_hint to 4k
Rem    snakai      07/16/02 - log availability changes
Rem    snakai      06/19/02 - remove trace table
Rem    snakai      06/04/02 - generate txn_guid as an md5 hash.
Rem    rpinnama    05/14/02 - rpinnama_reorg_rep_scripts
Rem    rpinnama    05/14/02 - Created
Rem

Rem
Rem  PURPOSE
Rem
Rem     MGMT_BCN_TARGET holds the list of beacons that monitor a target.  
Rem
Rem  COLUMNS
Rem
Rem     TARGET_GUID          - the target to monitor.
Rem     BEACON_TARGET_GUID   - the beacon that monitors the target.
Rem     PARTICIPATES_AVAIL   - 'Y' if the beacon participates in determining
Rem                            the availability status of the target
Rem     IS_REMOVING          - 'Y' if the beacon is in the process of being 
Rem                            removed from monitoring the target.
Rem

--TBD RAJ: This table can be completely dropped if target association properties 
-- can be used to store is_avail, is_local properties. 
CREATE TABLE MGMT_BCN_TARGET
  (
     target_guid          RAW(16)          NOT NULL,
     beacon_target_guid   RAW(16)          NOT NULL,
     participates_avail   CHAR(1)          DEFAULT 'N' NOT NULL,
     is_removing          CHAR(1)          DEFAULT 'N' NOT NULL,
     is_local             CHAR(1)          DEFAULT 'N' NOT NULL
  )
  STORAGE (FREELISTS 4)
  INITRANS 2
  MONITORING;


rem
rem  PURPOSE
rem
rem     This table is used to define the beacon availability
rem     of a target.  
rem     The key_part columns are used to specify the key to 
rem     use for the availability calculations.  These columns
rem     may use NULL (not used), a constant value to check for,
rem     or one of two globals: 'mgmt_bcn_use_bcn_guid' or
rem     'mgmt_bcn_use_bcn_name'.  
rem   

CREATE TABLE MGMT_BCN_AVAIL_DEF
(
    target_guid        RAW(16)          NOT NULL,
    metric_guid        RAW(16)          NOT NULL,
    coll_name          VARCHAR2(64),
    key_part1          VARCHAR2(256),
    key_part2          VARCHAR2(256),
    key_part3          VARCHAR2(256)
) STORAGE
    (FREELISTS 4)
  INITRANS 2
  MONITORING;

rem
rem  PURPOSE
rem
rem     This table has the list of targets that require their
rem     beacon availability to be recomputed.  A db job runs
rem     periodically and processes the targets on this list.
rem     

CREATE TABLE MGMT_BCN_AVAIL_JOB
(
    target_guid        RAW(16)          NOT NULL,
    insert_time        DATE             DEFAULT SYSDATE
) STORAGE
    (FREELISTS 4)
  INITRANS 2
  MONITORING;

Rem
Rem  PURPOSE
Rem
Rem     MGMT_BCN_TXN_DEFN holds the definition of a transaction.
Rem
Rem  COLUMNS
Rem
Rem     TARGET_GUID        - the target for which the transaction is defined.
Rem     TXN_GUID           - guid that identifies the transaction.
Rem     TXN_TYPE           - valid types: 'HTTP', 'PING'
Rem     NAME               - the name of the transaction.
Rem     DESCRIPTION        - a description of the transaction.
Rem     VERSION            - indicates the current version of the transaction.
Rem                          the version is incremented whenever the user 
Rem                          modifies the txn.
Rem     IS_REPRESENTATIVE  - 'Y' if the txn is designated as the txn to use
Rem                          to determine the availability of the target.
Rem     STATE              - 'NM' (default) : not monitoring
Rem                          'M' : monitoring
Rem                          'S' : stopping
Rem                          'D' : deleting
Rem
Rem  NOTES
Rem
Rem   - Trigger to update version (also on dependant tables such 
Rem     as step and params)?

CREATE TABLE MGMT_BCN_TXN_DEFN
  (
     target_guid          RAW(16)          NOT NULL,
     txn_guid             RAW(16)          NOT NULL,
     txn_type             VARCHAR2(64)     DEFAULT 'HTTP' NOT NULL,
     name                 VARCHAR2(64)     NOT NULL,
     description          VARCHAR2(2000),
     version              NUMBER           DEFAULT 1 NOT NULL,
     modified_date        DATE             DEFAULT SYSDATE,
     is_representative    CHAR(1)          DEFAULT 'N',
     state                VARCHAR2(8)      DEFAULT 'NM' NOT NULL
  )
  STORAGE (FREELISTS 4)
  INITRANS 2
  MONITORING;

Rem
Rem  PURPOSE
Rem
Rem     MGMT_BCN_STEP_DEFN holds the information of each step in a transaction.
Rem
Rem  COLUMNS
Rem
Rem     TARGET_GUID          - target identifier
Rem     TXN_GUID             - txn identifier.
Rem     STEP_GUID            - step identifier.
Rem     STEP                 - step order, starting at 1.
Rem     NAME                 - a user friendly name identifying the step
Rem     STEP_TYPE            - identifies the type of the step, usually a 
Rem                            protocol such as HTTP
Rem     PARENT_STEP_GUID     - Step guid of the parent step. Example, in HTTP transaction,
Rem                            the parent step for a FRAME is the USER ACTIION, which 
Rem                            generated the frame.
Rem
CREATE TABLE MGMT_BCN_STEP_DEFN
  (
     target_guid           RAW(16)          NOT NULL,
     txn_guid              RAW(16)          NOT NULL,
     step_guid             RAW(16)          NOT NULL,
     step                  NUMBER           NOT NULL,
     name                  VARCHAR2(64)     NOT NULL,
     step_type             VARCHAR2(64)     DEFAULT 'HTTP' NOT NULL, 
     parent_step_guid      RAW(16)          DEFAULT NULL
  )
  STORAGE (FREELISTS 4)
  INITRANS 2
  MONITORING;


Rem
Rem  PURPOSE
Rem
Rem     MGMT_BCN_STEPGROUP_DEFN holds step group information.
Rem
Rem  COLUMNS
Rem
Rem     TARGET_GUID          - target identifier
Rem     TXN_GUID             - txn identifier.
Rem     STEPGROUP_GUID       - step group identifier.
Rem     NAME                 - a user friendly name identifying the step group
Rem     STEPGROUP_TYPE       - identifies the type of the stepgroup, usually a 
Rem                            protocol such as HTTP
Rem
CREATE TABLE MGMT_BCN_STEPGROUP_DEFN
  (
     target_guid           RAW(16)          NOT NULL,
     txn_guid              RAW(16)          NOT NULL,
     stepgroup_guid        RAW(16)          NOT NULL,
     name                  VARCHAR2(64)     NOT NULL,
     stepgroup_type        VARCHAR2(64)     DEFAULT 'HTTP' NOT NULL
  )
  STORAGE (FREELISTS 4)
  INITRANS 2
  MONITORING;


Rem
Rem  PURPOSE
Rem
Rem     MGMT_BCN_STEPGROUP_STEPS holds the step group to step mapping.
Rem
Rem  COLUMNS
Rem
Rem     TARGET_GUID          - target identifier
Rem     TXN_GUID             - txn identifier.
Rem     STEPGROUP_GUID       - step group identifier.
Rem     STEP_GUID            - step identifier.
Rem
CREATE TABLE MGMT_BCN_STEPGROUP_STEPS
  (
     target_guid           RAW(16)          NOT NULL,
     txn_guid              RAW(16)          NOT NULL,
     stepgroup_guid        RAW(16)          NOT NULL,
     step_guid             RAW(16)          NOT NULL
  )
  STORAGE (FREELISTS 4)
  INITRANS 2
  MONITORING;


Rem
Rem  PURPOSE
Rem
Rem     MGMT_BCN_TXN_AUDIT 
Rem
Rem  COLUMNS
Rem
Rem     TXN_GUID          - txn identifier.
Rem     AUDIT_TIMESTAMP   - the time at which the change(s) occured
Rem     CHANGE_TYPE       - A bit map representing the changes
Rem                         Bit	Change Detail
Rem                         0	Version change due to transaction level changes
Rem                         1	Transaction level threshold change
Rem                         2	Transaction level attribute change
Rem                         3	Transaction level state changes
Rem                         4	Version change due to user action level changes
Rem                         5	User action level threshold change
Rem                         6	User action level attribute change
Rem                         7	Unused
Rem                         8	Version change due to user action group level changes (unused)
Rem                         9	User action group level threshold change
Rem                         10	User action group level attribute change
Rem                         11	Unused
Rem     IS_VERSION_CHANGE   Flag to indicate version change for quick reference
Rem     DETAILS             Details of the change as text

CREATE TABLE MGMT_BCN_TXN_AUDIT
  (
     target_guid       RAW(16)         NOT NULL,
     txn_guid          RAW(16)         NOT NULL,
     audit_timestamp   DATE            NOT NULL,
     change_type       NUMBER          NOT NULL,
     is_version_change CHAR(1)         DEFAULT 'N' NOT NULL,
     version           NUMBER,
     details           VARCHAR2(1024)
  )
  STORAGE (FREELISTS 4)
  INITRANS 2
  MONITORING;


Rem
Rem  PURPOSE
Rem
Rem     MGMT_BCN_TXN_PROPS 
Rem
Rem  COLUMNS
Rem
Rem     TARGET_GUID       - target identifier
Rem     TXN_GUID          - txn identifier.
Rem     NAME              - the name of the property
Rem     STRING_PART       - Part number for a multi-part value. 
Rem                         NULL, 0 indicate a single part property.
Rem     STRING_VALUE      - string value of the property
Rem     NUM_VALUE         - number value of the property
Rem     DATE_VALUE        - date value of the property
Rem     CHAR_VALUE        - character value of the property
Rem     PROP_TYPE         - the property type, indicates which value column to use
Rem     ENCRYPTED         - Flag to indicate if the property is encrypted
Rem     TEMPLATE          - Flag to indicate if the property is a template value

CREATE TABLE MGMT_BCN_TXN_PROPS
  (
     target_guid       RAW(16)         NOT NULL,
     txn_guid          RAW(16)         NOT NULL,
     name              VARCHAR2(64)    NOT NULL,
     string_part       NUMBER          DEFAULT 0 NOT NULL,
     string_value      VARCHAR2(4000),
     num_value         NUMBER,
     date_value        DATE,
     char_value        CHAR,
     prop_type         NUMBER          DEFAULT 1 NOT NULL,
     encrypted         CHAR            DEFAULT 'N',
     template          CHAR            DEFAULT 'N'
  )
  STORAGE (FREELISTS 4)
  INITRANS 2
  MONITORING;

Rem
Rem  PURPOSE
Rem
Rem     MGMT_BCN_STEP_PROPS 
Rem
Rem  COLUMNS
Rem
Rem     TARGET_GUID       - target identifier
Rem     STEP_GUID         - step identifier.
Rem     NAME              - the name of the property
Rem     STRING_PART       - Part number for a multi-part value. 
Rem                         NULL, 0 indicate a single part property.
Rem          - flag to turn off property at the step level
Rem     STRING_VALUE      - string value of the property
Rem     NUM_VALUE         - number value of the property
Rem     DATE_VALUE        - date value of the property
Rem     CHAR_VALUE        - character value of the property
Rem     PROP_TYPE         - the property type, indicates which value column to use
Rem     ENCRYPTED         - Flag to indicate if the property is encrypted
Rem     TEMPLATE          - Flag to indicate if the property is a template value

CREATE TABLE MGMT_BCN_STEP_PROPS
  (
     target_guid       RAW(16)         NOT NULL,
     step_guid         RAW(16)         NOT NULL,
     name              VARCHAR2(64)    NOT NULL,
     string_part       NUMBER          DEFAULT 0 NOT NULL,
     string_value      VARCHAR2(4000),
     num_value         NUMBER,
     date_value        DATE,
     char_value        CHAR,
     prop_type         NUMBER          DEFAULT 1 NOT NULL,
     encrypted         CHAR            DEFAULT 'N',
     template          CHAR            DEFAULT 'N'
  )
  STORAGE (FREELISTS 4)
  INITRANS 2
  MONITORING;


Rem
Rem  PURPOSE
Rem
Rem     MGMT_BCN_BCNTXN_PROPS 
Rem
Rem  COLUMNS
Rem
Rem     TARGET_GUID       - target identifier
Rem     TXN_GUID          - txn identifier
Rem     BCN_GUID          - beacon identifier
Rem     NAME              - the name of the property
Rem     STRING_PART       - Part number for a multi-part value. 
Rem                         NULL, 0 indicate a single part property.
Rem     STRING_VALUE      - string value of the property
Rem     NUM_VALUE         - number value of the property
Rem     DATE_VALUE        - date value of the property
Rem     CHAR_VALUE        - character value of the property
Rem     PROP_TYPE         - the property type, indicates which value column to use
Rem     ENCRYPTED         - Flag to indicate if the property is encrypted
Rem     TEMPLATE          - Flag to indicate if the property is a template value

CREATE TABLE MGMT_BCN_BCNTXN_PROPS
  (
     target_guid       RAW(16)         NOT NULL,
     txn_guid          RAW(16)         NOT NULL,
     bcn_guid          RAW(16)         NOT NULL,
     name              VARCHAR2(64)    NOT NULL,
     string_part       NUMBER          DEFAULT 0 NOT NULL,
     string_value      VARCHAR2(4000),
     num_value         NUMBER,
     date_value        DATE,
     char_value        CHAR,
     prop_type         NUMBER          DEFAULT 1 NOT NULL,
     encrypted         CHAR            DEFAULT 'N',
     template          CHAR            DEFAULT 'N'
  )
  STORAGE (FREELISTS 4)
  INITRANS 2
  MONITORING;

Rem
Rem  PURPOSE
Rem
Rem     MGMT_BCN_BCNSTEP_PROPS 
Rem
Rem  COLUMNS
Rem
Rem     TARGET_GUID       - target identifier
Rem     STEP_GUID         - step identifier
Rem     BCN_GUID          - beacon identifier
Rem     NAME              - the name of the property
Rem     STRING_PART       - Part number for a multi-part value. 
Rem                         NULL, 0 indicate a single part property.
Rem     STRING_VALUE      - string value of the property
Rem     NUM_VALUE         - number value of the property
Rem     DATE_VALUE        - date value of the property
Rem     CHAR_VALUE        - character value of the property
Rem     PROP_TYPE         - the property type, indicates which value column to use
Rem     ENCRYPTED         - Flag to indicate if the property is encrypted
Rem     TEMPLATE          - Flag to indicate if the property is a template value

CREATE TABLE MGMT_BCN_BCNSTEP_PROPS
  (
     target_guid       RAW(16)         NOT NULL,
     step_guid         RAW(16)         NOT NULL,
     bcn_guid          RAW(16)         NOT NULL,
     name              VARCHAR2(64)    NOT NULL,
     string_part       NUMBER          DEFAULT 0 NOT NULL,
     string_value      VARCHAR2(4000),
     num_value         NUMBER,
     date_value        DATE,
     char_value        CHAR,
     prop_type         NUMBER          DEFAULT 1 NOT NULL,
     encrypted         CHAR            DEFAULT 'N',
     template          CHAR            DEFAULT 'N'
  )
  STORAGE (FREELISTS 4)
  INITRANS 2
  MONITORING;


Rem
Rem  PURPOSE
Rem
Rem     MGMT_ADMIN_METRIC_THRESHOLDS is used to store beacon
Rem  transaction thresholds.  It is defined identically to 
Rem  MGMT_METRIC_THRESHOLDS, which use it replaces for beacon
Rem  transactions.  It is required to store the user changes
Rem  BEFORE they are updated on all EMDs.  If the push fail,
Rem  the latest user changes can be retrieved from this table.
Rem
Rem

CREATE TABLE MGMT_ADMIN_METRIC_THRESHOLDS
    (target_guid           RAW(16)         NOT NULL,
     metric_guid           RAW(16)         NOT NULL,
     coll_name             VARCHAR2(64)    DEFAULT ' ',
     key_value             VARCHAR2(256)   DEFAULT ' ',
     warning_operator      NUMBER          DEFAULT 0,
     warning_threshold     VARCHAR2(256)   DEFAULT ' ',
     critical_operator     NUMBER          DEFAULT 0,
     critical_threshold    VARCHAR2(256)   DEFAULT ' ',
     num_occurences        NUMBER          DEFAULT 1,
     num_warnings          NUMBER          DEFAULT 0,
     num_criticals         NUMBER          DEFAULT 0,
     eval_order            NUMBER          DEFAULT 0,
     fixit_job             VARCHAR2(256)   DEFAULT '')
  MONITORING;


Rem
Rem  PURPOSE
Rem
Rem    MGMT_BCN_AVAIL_LOG is used to log all beacon 
Rem  availability changes.  The message column keeps a 
Rem  tracing message indicating what the status of each
Rem  availability beacon was and how each voted.
Rem

CREATE TABLE MGMT_BCN_AVAIL_LOG
    (target_guid           RAW(16)         NOT NULL,
     severity_guid         RAW(16),
     availability_status   NUMBER(8)       NOT NULL,
     collection_timestamp  DATE, 
     compute_timestamp     DATE            DEFAULT SYSDATE,
     message               VARCHAR2(4000) )
  MONITORING;



Rem
Rem E2E Aggregate Tables
Rem

Rem
Rem MGMT_E2E_SUMMARY
Rem

CREATE TABLE MGMT_E2E_SUMMARY
  (
     target_guid           RAW(16)         NOT NULL,
     vhost                 VARCHAR2(256),
     uri                   VARCHAR2(2000)  NOT NULL,
     collection_timestamp  DATE            NOT NULL,
     hit_count             NUMBER(8),
     total_time            NUMBER(10),
     max_time              NUMBER(10),
     min_time              NUMBER(10),
     servlet_count         NUMBER(8),
     servlet_time          NUMBER(10),
     jsp_count             NUMBER(8),
     jsp_time              NUMBER(10),
     ejb_count             NUMBER(8),
     ejb_time              NUMBER(10),
     jdbc_time             NUMBER(10)
  )
  STORAGE (FREELISTS 4)
  INITRANS 2
  MONITORING;


Rem
Rem MGMT_E2E_DETAILS
Rem   
Rem node_type : servlet = 1
Rem             jsp     = 2
Rem             ejb     = 3
Rem             sql     = 4
Rem             jdbc    = 5
Rem

CREATE TABLE MGMT_E2E_DETAILS
  (
     target_guid           RAW(16)         NOT NULL,
     vhost                 VARCHAR2(256),
     app_id                VARCHAR2(128),
     uri                   VARCHAR2(2000)  NOT NULL,
     key_guid              RAW(16)         NOT NULL,
     parent_key_guid       RAW(16),
     node_id               VARCHAR2(1000)  NOT NULL,
     node_attribute        VARCHAR2(1000),
     node_type             NUMBER(4)       NOT NULL,
     collection_timestamp  DATE            NOT NULL,
     hit_count             NUMBER(8),
     total_time            NUMBER(10),
     component_time        NUMBER(10)
  )
  STORAGE (FREELISTS 4)
  INITRANS 2
  MONITORING;


Rem
Rem MGMT_E2E_SQL
Rem

CREATE TABLE MGMT_E2E_SQL
  (
     target_guid           RAW(16)         NOT NULL,
     vhost                 VARCHAR2(256),
     app_id                VARCHAR2(128),
     uri                   VARCHAR2(2000)  NOT NULL,
     key_guid              RAW(16)         NOT NULL,
     collection_timestamp  DATE            NOT NULL,
     exec_count            NUMBER(8),
     exec_time             NUMBER(10),
     fetch_count           NUMBER(8),
     fetch_time            NUMBER(10)
  )
  STORAGE (FREELISTS 4)
  INITRANS 2
  MONITORING;


Rem
Rem MGMT_E2E_JDBC
Rem

CREATE TABLE MGMT_E2E_JDBC
  (
     target_guid           RAW(16)         NOT NULL,
     vhost                 VARCHAR2(256),
     app_id                VARCHAR2(128),
     uri                   VARCHAR2(2000)  NOT NULL,
     key_guid              RAW(16)         NOT NULL,
     collection_timestamp  DATE            NOT NULL,
     used_conn_count       NUMBER(8),
     conn_cache_hit        NUMBER(8),
     conn_cache_miss       NUMBER(8),
     stmt_create_time      NUMBER(10),
     stmt_cache_hit        NUMBER(8),
     stmt_cache_miss       NUMBER(8)
  )
  STORAGE (FREELISTS 4)
  INITRANS 2
  MONITORING;


Rem
Rem MGMT_E2E_SQL_STMT
Rem

CREATE TABLE MGMT_E2E_SQL_STMT
  (
     target_guid           RAW(16)         NOT NULL,
     stmt_guid             RAW(16)         NOT NULL,
     stmt_text             VARCHAR2(4000)  NOT NULL,
     part_no               NUMBER(8)       NOT NULL,
     ttl_ref               DATE
  )
  STORAGE (FREELISTS 4)
  INITRANS 2
  MONITORING;


Rem
Rem MGMT_E2E_SQL_CONN
Rem

CREATE TABLE MGMT_E2E_SQL_CONN
  (
     target_guid           RAW(16)         NOT NULL,
     conn_guid             RAW(16)         NOT NULL,
     conn_schema           VARCHAR2(64)    NOT NULL,
     conn_string           VARCHAR2(4000)   NOT NULL,
     ttl_ref               DATE
  )
  STORAGE (FREELISTS 4)
  INITRANS 2
  MONITORING;


Rem
Rem MGMT_E2E_SUMMARY_1HOUR
Rem

CREATE TABLE MGMT_E2E_SUMMARY_1HOUR
  (
     target_guid           RAW(16)         NOT NULL,
     vhost                 VARCHAR2(256),
     uri                   VARCHAR2(2000)  NOT NULL,
     rollup_timestamp      DATE            NOT NULL,
     hit_count             NUMBER(8),
     total_time            NUMBER(10),
     max_time              NUMBER(10),
     min_time              NUMBER(10),
     servlet_count         NUMBER(8),
     servlet_time          NUMBER(10),
     jsp_count             NUMBER(8),
     jsp_time              NUMBER(10),
     ejb_count             NUMBER(8),
     ejb_time              NUMBER(10),
     jdbc_time             NUMBER(10)
  )
  STORAGE (FREELISTS 4)
  INITRANS 2
  MONITORING;


Rem
Rem MGMT_E2E_SUMMARY_1DAY
Rem

CREATE TABLE MGMT_E2E_SUMMARY_1DAY
  (
     target_guid           RAW(16)         NOT NULL,
     vhost                 VARCHAR2(256),
     uri                   VARCHAR2(2000)  NOT NULL,
     rollup_timestamp      DATE            NOT NULL,
     hit_count             NUMBER(8),
     total_time            NUMBER(10),
     max_time              NUMBER(10),
     min_time              NUMBER(10),
     servlet_count         NUMBER(8),
     servlet_time          NUMBER(10),
     jsp_count             NUMBER(8),
     jsp_time              NUMBER(10),
     ejb_count             NUMBER(8),
     ejb_time              NUMBER(10),
     jdbc_time             NUMBER(10)
  )
  STORAGE (FREELISTS 4)
  INITRANS 2
  MONITORING;


Rem
Rem MGMT_E2E_DETAILS_1HOUR
Rem

CREATE TABLE MGMT_E2E_DETAILS_1HOUR
  (
     target_guid           RAW(16)         NOT NULL,
     vhost                 VARCHAR2(256),
     app_id                VARCHAR2(128),
     uri                   VARCHAR2(2000)  NOT NULL,
     key_guid              RAW(16)         NOT NULL,
     parent_key_guid       RAW(16),
     node_id               VARCHAR2(1000)  NOT NULL,
     node_attribute        VARCHAR2(1000),
     node_type             NUMBER(4)       NOT NULL,
     rollup_timestamp      DATE            NOT NULL,
     hit_count             NUMBER(8),
     total_time            NUMBER(10),
     component_time        NUMBER(10)
  )
  STORAGE (FREELISTS 4)
  INITRANS 2
  MONITORING;


Rem
Rem MGMT_E2E_DETAILS_1DAY
Rem

CREATE TABLE MGMT_E2E_DETAILS_1DAY
  (
     target_guid           RAW(16)         NOT NULL,
     vhost                 VARCHAR2(256),
     app_id                VARCHAR2(128),
     uri                   VARCHAR2(2000)  NOT NULL,
     key_guid              RAW(16)         NOT NULL,
     parent_key_guid       RAW(16),
     node_id               VARCHAR2(1000)  NOT NULL,
     node_attribute        VARCHAR2(1000),
     node_type             NUMBER(4)       NOT NULL,
     rollup_timestamp      DATE            NOT NULL,
     hit_count             NUMBER(8),
     total_time            NUMBER(10),
     component_time        NUMBER(10)
  )
  STORAGE (FREELISTS 4)
  INITRANS 2
  MONITORING;


Rem
Rem MGMT_E2E_SQL_1HOUR
Rem

CREATE TABLE MGMT_E2E_SQL_1HOUR
  (
     target_guid           RAW(16)         NOT NULL,
     vhost                 VARCHAR2(256),
     app_id                VARCHAR2(128),
     uri                   VARCHAR2(2000)  NOT NULL,
     key_guid              RAW(16)         NOT NULL,
     rollup_timestamp      DATE            NOT NULL,
     exec_count            NUMBER(8),
     exec_time             NUMBER(10),
     fetch_count           NUMBER(8),
     fetch_time            NUMBER(10)
  )
  STORAGE (FREELISTS 4)
  INITRANS 2
  MONITORING;


Rem
Rem MGMT_E2E_SQL_1DAY
Rem

CREATE TABLE MGMT_E2E_SQL_1DAY
  (
     target_guid           RAW(16)         NOT NULL,
     vhost                 VARCHAR2(256),
     app_id                VARCHAR2(128),
     uri                   VARCHAR2(2000)  NOT NULL,
     key_guid              RAW(16)         NOT NULL,
     rollup_timestamp      DATE            NOT NULL,
     exec_count            NUMBER(8),
     exec_time             NUMBER(10),
     fetch_count           NUMBER(8),
     fetch_time            NUMBER(10)
  )
  STORAGE (FREELISTS 4)
  INITRANS 2
  MONITORING;


Rem
Rem MGMT_E2E_JDBC_1HOUR
Rem

CREATE TABLE MGMT_E2E_JDBC_1HOUR
  (
     target_guid           RAW(16)         NOT NULL,
     vhost                 VARCHAR2(256),
     app_id                VARCHAR2(128),
     uri                   VARCHAR2(2000)  NOT NULL,
     key_guid              RAW(16)         NOT NULL,
     rollup_timestamp      DATE            NOT NULL,
     used_conn_count       NUMBER(8),
     conn_cache_hit        NUMBER(8),
     conn_cache_miss       NUMBER(8),
     stmt_create_time      NUMBER(10),
     stmt_cache_hit        NUMBER(8),
     stmt_cache_miss       NUMBER(8)
  )
  STORAGE (FREELISTS 4)
  INITRANS 2
  MONITORING;


Rem
Rem MGMT_E2E_JDBC_1DAY
Rem

CREATE TABLE MGMT_E2E_JDBC_1DAY
  (
     target_guid           RAW(16)         NOT NULL,
     vhost                 VARCHAR2(256),
     app_id                VARCHAR2(128),
     uri                   VARCHAR2(2000)  NOT NULL,
     key_guid              RAW(16)         NOT NULL,
     rollup_timestamp      DATE            NOT NULL,
     used_conn_count       NUMBER(8),
     conn_cache_hit        NUMBER(8),
     conn_cache_miss       NUMBER(8),
     stmt_create_time      NUMBER(10),
     stmt_cache_hit        NUMBER(8),
     stmt_cache_miss       NUMBER(8)
  )
  STORAGE (FREELISTS 4)
  INITRANS 2
  MONITORING;

