Rem
Rem $Header: beacon_txn_pkgbody.sql 17-jul-2007.11:14:50 rgraham Exp $
Rem
Rem beacon_txn_pkgbody.sql
Rem
Rem Copyright (c) 2002, 2007, Oracle. All rights reserved.  
Rem
Rem
Rem    NAME
Rem      beacon_txn_pkgbody.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    rgraham     07/17/07 - 
Rem    andyao      06/04/07 - update txn type
Rem    rmarripa    06/29/06 - bug 5042654 
Rem    rmarripa    07/10/06 - Backport rmarripa_bug-5042654 from main 
Rem    andyao      12/07/05 - Backport andyao_bug-4743101 from main 
Rem    mfidanbo    11/23/05 - Backport mfidanbo_bug-3699033 from main 
Rem    afontana    11/28/05 - Backport afontana_bug-4684061 from main 
Rem    andyao      11/27/05 - Insert mandatory property Collection Interval if not present.
Rem    mfidanbo    11/02/05 - get all websites for beacon websites page 
Rem    andyao      08/31/05 - check privilege for TXN_CREATE
Rem    mfidanbo    08/29/05 - dont call key value deletion for table metrics 
Rem    mvajapey    08/29/05 - Add function HAS_ALL_BCN_PRIVS, EMD_BCN_ASSOC_TMPL_APPLY (bug 4580884). 
Rem    mvajapey    08/19/05 - Fix set_tests_keyness. 
Rem    rmarripa    08/12/05 - pass key values to the beacon job 
Rem    yxie        08/08/05 - fix bug 4539795 
Rem    mfidanbo    08/22/05 - dont register test_avail for beacon watchlists 
Rem    yxie        08/05/05 - fix bug 4526542 
Rem    mfidanbo    07/29/05 - 
Rem    mvajapey    07/26/05 - check monitoring state for key tests in template 
Rem                           mode also 
Rem    andyao      07/16/05 - add API to set keyness of transactions 
Rem    rmarripa    06/23/05 - fix bug 4445446 
Rem    rmarripa    06/23/05 - fix bug 4445446 
Rem    mfidanbo    07/14/05 - fix step/step grp key value deletion
Rem    mfidanbo    07/14/05 - cutover to exec_key_val_callback 
Rem    mfidanbo    07/11/05 - dont get local beacon when accessing beacons 
Rem                           list 
Rem    rmarripa    05/20/05 - add min beacon version check to add/edit test 
Rem                           and assoc beacons APIs 
Rem    andyao      06/21/05 - step and stepgroup cannot have the same name 
Rem    mfidanbo    07/01/05 - 
Rem    andyao      06/09/05 - add associate beacons for template api 
Rem    mfidanbo    06/06/05 - add coll_name api 
Rem    mfidanbo    06/01/05 - incomplete txn delete functionality 
Rem    andyao      05/12/05 - fix bug 4307875 
Rem    andyao      04/28/05 - fix bug 4313846 
Rem    andyao      04/28/05 - remove nocycle and add error code 
Rem    mvajapey    04/20/05 - Reset v_new_bcn variable in for loop (procedure 
Rem                           assoc_bcns). 
Rem    mfidanbo    04/10/05 - remove debug msgs 
Rem    rmarripa    04/07/05 - Allow changing to key transaction during modify 
Rem    andyao      04/02/05 - 
Rem    rmarripa    03/25/05 - add parent field to the step 
Rem    mfidanbo    03/18/05 - remove global.tgt_sysdate reference 
Rem    rmarripa    03/10/05 - remove obsolete tables 
Rem    andyao      03/13/05 - fix encryption of url property 
Rem    andyao      02/24/05 - add template support for start/stop monitor txn 
Rem    dcawley     02/21/05 - Replace enter super user mode 
Rem    rmarripa    02/16/05 - fix EMD_BCN_GET_THRESH 
Rem    rmarripa    02/08/05 - fix modify transaction push 
Rem    snakai      02/11/05 - 
Rem    mfidanbo    02/04/05 - remove string comments from get_perf 
Rem    andyao      02/01/05 - add API to support num of occurrences 
Rem    mfidanbo    01/26/05 - fix string value getter 
Rem    andyao      01/18/05 - add () in GET_COMPOSITE_KEYS 
Rem    mfidanbo    01/18/05 - add is_local 
Rem    jmarfati    01/11/05 - create keys while associating the beacons 
Rem    snakai      01/07/05 - remove reference to bcn_avail pkg 
Rem    andyao      01/07/05 - fix bug 4090746 
Rem    mfidanbo    12/13/04 - add priviledge on beacon msg 
Rem    mfidanbo    12/06/04 - user model fixes 
Rem    mfidanbo    12/01/04 - replace tgt_sysdate_wguid call to use 
Rem                           mgmt_global function 
Rem    rmarripa    11/22/04 - MTA config changes 
Rem    snakai      11/22/04 - Update beacon avail 
Rem    vjraghav    11/22/04 - Adding a template type to the returned txn defn 
Rem    vjraghav    11/17/04 - Fixing issues for templates 
Rem    andyao      11/05/04 - remove reference to mgmt_bcn_target_txn 
Rem    vjraghav    11/02/04 - Creating a new data type for templatizing 
Rem                           properties 
Rem    rmarripa    10/26/04 - continue sync job chages 
Rem    rmarripa    10/20/04 - make changes to use sync job 
Rem    vjraghav    10/27/04 - Fixing problem with unsetting per-beacon thresholds
Rem    vjraghav    10/25/04 - Fixing uninitialized collection error 
Rem    vjraghav    10/19/04 - Commenting out debug output. 
Rem    vjraghav    10/18/04 - Fixing issue with perf data 
Rem    vjraghav    10/16/04 - Fixing issue with setting thresholds 
Rem    mfidanbo    10/14/04 - get is_avail for a beacon 
Rem    afontana    10/04/04 - add beacon version to mgmt_bcn 
Rem    vjraghav    10/07/04 - Implementing auditing of changes 
Rem    andyao      10/12/04 - undo fixes for simple http 
Rem    andyao      10/11/04 - fix error during beacon removal 
Rem    rmarripa    10/01/04 - add util procedure to get constituent elements 
Rem                           given composite keys 
Rem    vjraghav    09/16/04 - Code to retrieve performance data for a transaction
Rem    mfidanbo    09/20/04 - grabtrans 'mfidanbo_txn_perf_10' 
Rem    vjraghav    09/16/04 - Code to retrieve performance data for a transaction
Rem    pmadyalk    09/15/04 - Txn Representative Fix Send by VR 
Rem    rmarripa    09/10/04 - code review comments 
Rem    rmarripa    08/30/04 - add associate beacons procedure for create 
Rem                           service 
Rem    vjraghav    09/07/04 - remove dbms_ouput comments 
Rem    vjraghav    09/03/04 - Retrieve beacons along with a txn definition 
Rem    vjraghav    09/03/04 - Transaction/Step/Stepgroup performance 
Rem    dcawley     07/07/04 - Increase user name size 
Rem    vjraghav    06/25/04 - Rel2 changes to transaction definitions and 
Rem                           properties 
Rem    afontana    02/26/04 - add priv-check for config priv 
Rem    snakai      02/09/04 - fix null comparisons 
Rem    snakai      12/01/03 - remove targets/metric join from table cast query 
Rem    snakai      11/10/03 - support metric versions 
Rem    snakai      10/20/03 - delete thresholds when deleting a txn 
Rem    rmarripa    10/01/03 - set avail txn if it only monitoring 
Rem    rmarripa    09/26/03 - Do not delete data from current values table in 
Rem                           case of Stop Monitoring 
Rem    snakai      09/05/03 - clear metric errors when removing a txn or 
Rem    snakai      08/25/03 - remove initial clear severity 
Rem    snakai      06/16/03 - insert clear sevs when starting a txn
Rem    snakai      06/13/03 - close severities properly
Rem    snakai      04/17/03 - split the postdata into parts
Rem    asawant     03/25/03 - Adding functions to get beacon HP data
Rem    snakai      03/23/03 - use beacon avail status instead of host
Rem    rmarripa    03/17/03 - USE_BEACON privilege required for Add beacons to the target when there are no beacons
Rem    snakai      02/20/03 - encode basic auth params
Rem    snakai      03/11/03 - EMD_BCN_TXN_SYNC_LIST - order txns by name
Rem    snakai      11/14/02 - fix closing of alerts
Rem    snakai      11/11/02 - clean up system errors
Rem    snakai      10/07/02 - Close sevs when removing bcn/txn
Rem    rmarripa    10/08/02 - use constants defined in mgmt_user package 
Rem    rmarripa    10/03/02 - add delete target privilege
Rem    tjaiswal    10/07/02 - Use composite key guid gen api
Rem    asawant     09/27/02 - Changing time zone offset to time zone string
Rem    snakai      09/30/02 - Comment out dbms_output.put_line calls
Rem    rmarripa    09/30/02 - add user model to unlock target procedure/function
Rem    rmarripa    09/17/02 - change EMD_BCN_GET_BCN_WEBSITES
Rem    rmarripa    09/16/02 - add preocedure to get websites registered with a beacon
Rem    asawant     08/14/02 - Improving performance.
Rem    rmarripa    08/16/02 - fix bug#2486796. USE_ANY_BEACON priv is not required if there are d to the website
Rem    snakai      07/25/02 - move beacon funcs/procs to a pkg
Rem    snakai      07/24/02 - fix default sevs
Rem    snakai      07/16/02 - add target_guid when insert to comp. key table
Rem    skini       07/11/02 - Cutover target_name column size
Rem    rmarripa    07/08/02 - availability txn not found err in homepage data
Rem    rmarripa    07/08/02 - availability txn not found err in homepage data
Rem    rmarripa    07/05/02 - get comp keys for beacon sync list
Rem    snakai      07/09/02 - check if the postdata is NULL before decrypting
Rem    asawant     06/26/02 - API for forcefull unlock of target
Rem    rmarripa    06/24/02 - add error reporting
Rem    asawant     06/19/02 - Adding API to handle the whole set avail txn
Rem    rmarripa    06/23/02 - fix Usermodel API
Rem    rmarripa    06/20/02 - add usermodel API
Rem    snakai      06/18/02 - several minor fixes
Rem    snakai      06/18/02 - use mgmt_log to report errors
Rem    rmarripa    06/07/02 - add alerts for website homepage API.
Rem    snakai      06/05/02 - delete beacon target
Rem    mashukla    06/03/02 - fix bcn hmpg packages.
Rem    mashukla    06/02/02 - change home page sql.
Rem    snakai      05/28/02 - merge changes made to old location.
Rem    asawant     05/21/02 - Simplifying txnDataDisplay data retrievel package..
Rem    asawant     05/20/02 - GetTxnData metric guid cursor has missleading cursour params
Rem    rmarripa    05/21/02 - fix the cursor to get metric guid in WEBSITE_HP_DATA proc.
Rem    njuillar    05/17/02 - Fixed emd_bcn_get_coll_details to return null thresholds
Rem    rpinnama    05/15/02 - rpinnama_reorg_rep_scripts
Rem    rpinnama    05/15/02 - Restructured.
Rem    asawant     05/14/02 - Fixing 7days and 31 days queries for 1 txn/1bcn..
Rem    snakai      05/10/02 - implement beacon availability
Rem    asawant     05/08/02 - Fixing 1 hour data return bug..
Rem    asawant     05/06/02 - Fixing the split bar chart .
Rem    mashukla    05/04/02 - fix bcn sev sql.
Rem    asawant     05/02/02 - Adding average line..
Rem    asawant     05/01/02 - Adding thresholds..
Rem    asawant     05/01/02 - Fixing HP data func (return all avail beacons 
Rem                           regardless of data presence)..
Rem    snakai      04/30/02 - implement flexible thresholds.
Rem    snakai      04/29/02 - fix set_bcns returning incorrect thresholds.
Rem    asawant     04/29/02 - Adding TZ for website in 
Rem                           EMD_BCN_GET_WEBSITE_HP_DATA..
Rem    asawant     04/23/02 - Adding local time to all charts..
Rem    asawant     04/22/02 - Catching exceptions..
Rem    asawant     04/22/02 - Adding txn guid to api..
Rem    snakai      04/21/02 - add txn name to get_coll_details .
Rem    asawant     04/19/02 - Adding data fetching pl/sql..
Rem    mashukla    04/21/02 - add hmpg pkg.
Rem    snakai      04/14/02 - metric_guid fix.
Rem    snakai      04/12/02 - add schedule to set_thresholds
Rem    snakai      04/09/02 - encrypt postdata in database tables.
Rem    snakai      04/05/02 - add target timezone to txn object.
Rem    snakai      04/03/02 - snakai_beacon_api_4
Rem    snakai      04/03/02 - fix composite key gen (use 2 semicolons).
Rem    snakai      04/03/02 - Created
Rem

-- Beacon Package --------------------------------------------------------

CREATE OR REPLACE PACKAGE BODY EMD_BCNTXN AS

--------------------------------------------------------------------------


--------------------------------------------------------------------------
PROCEDURE LOG_SYS_ERR  ( errcode IN INTEGER, errmsg IN VARCHAR2 )
IS

  -- length of column in system err log table is 2048.   no constant
  -- provided in the log pkg so, i'm using a local constant for now.
  k_logmsg_maxlen INTEGER := 2048;

BEGIN

  IF (errcode = p_bcn_err_oraerr) AND (errmsg IS NOT NULL) THEN
    IF LENGTH(errmsg) > k_logmsg_maxlen THEN
      MGMT_LOG.LOG_ERROR(MODULE_NAME, NULL, SUBSTR(errmsg, 1, k_logmsg_maxlen));
    ELSE
      MGMT_LOG.LOG_ERROR(MODULE_NAME, NULL, errmsg);
    END IF;
  END IF;

END LOG_SYS_ERR;
--------------------------------------------------------------------------


--------------------------------------------------------------------------
-- Given a functionality type and the target type 
-- this function will return the privileges required 
-- for this functionality
-- RETURN 0 - VIEW_TARGET 
--        1 - OPERATOR_TARGET 
--        2 - OPERATOR_TARGET AND USE_ANY_BEACON 
FUNCTION GET_FUNC_PRIV_TYPE ( function IN INTEGER, 
                              is_bcn IN BOOLEAN ) RETURN INTEGER
IS
BEGIN
  IF ( is_bcn = FALSE ) THEN 
      -- The following functionality requires 
      -- operator target and use beacon system privileges.
    IF ( ( function = p_sync_beacon ) OR
         ( function = p_manage_beacons ) OR
         ( function = p_set_beacons ) OR
         ( function = p_modify_txn ) OR
         ( function = p_remove_txn ) OR
         ( function = p_start_txn ) OR
         ( function = p_stop_txn ) OR
         ( function = p_set_bcn_txn_thresholds ) ) THEN
      RETURN p_priv_use_bcn_op_tgt;
      -- The following functionality requires 
      -- operator target privilege.
    ELSIF ( ( function = p_create_txn ) OR
            ( function = p_set_availability ) OR
            ( function = p_watchlist_operations ) OR
            ( function = p_unlock_tgt ) OR
            ( function = p_playback_txn ) OR
            ( function = p_config_components ) OR
            ( function = p_region_operations ) ) THEN 
      RETURN p_priv_op_tgt;
      -- The following functionality requires 
      -- view target privilege.
    ELSIF ( function = p_delete_tgt ) THEN
      RETURN p_priv_full_tgt;
    ELSIF ( ( function = p_view_mntr_reports ) OR 
            ( function = p_view_txn ) ) THEN
      RETURN p_priv_view_tgt;
    ELSE
      return p_err_unknown_function;
    END IF; -- For Function Type Check
  ELSE
    IF ( ( function = p_sync_beacon ) OR
         ( function = p_create_txn ) OR
         ( function = p_modify_txn ) OR
         ( function = p_remove_txn ) OR
         ( function = p_start_txn ) OR
         ( function = p_unlock_tgt ) OR
         ( function = p_stop_txn ) ) THEN
      return p_priv_op_tgt;
    ELSIF ( ( function = p_view_mntr_reports ) OR
            ( function = p_view_txn ) )THEN
      RETURN p_priv_view_tgt;
    ELSE
      RETURN p_err_unknown_function;
    END IF; -- For Function Type Check
  END IF; -- Is_bcn check
END GET_FUNC_PRIV_TYPE;

-- Given a list of beacons, checks if the user has op priviledges
-- on all of them
-- bcns- SMP_EMD_STRING_NVPAIR_ARRAY is not null only for set_beacons API. All others 
-- will pass bcn_ids for associated beacon privileges. 
FUNCTION CHECK_BCN_PRIV(bcn_ids      IN  SMP_EMD_STRING_ARRAY,
                        current_user IN  VARCHAR2,
                        function     IN  INTEGER, 
                        bcns         IN  SMP_EMD_NVPAIR_ARRAY,
                        err_desc     OUT VARCHAR2) RETURN INTEGER
IS
  l_count PLS_INTEGER;
  l_bcn_id MGMT_TARGETS.TARGET_GUID%TYPE;
  l_bcn_name VARCHAR2(64);
  l_found INTEGER := 0;
  l_tgt MGMT_TARGETS.TARGET_NAME%TYPE;
  l_type MGMT_TARGETS.TARGET_TYPE%TYPE;

BEGIN
  IF ( (current_user IS NULL ) ) THEN
    RETURN p_bcn_err_badparams;
  END IF;

  -- bcns    is used when the function is p_set_beacons
  -- bcn_ids is used when the function is not p_set_beacons
  -- therefore, if function is not p_set_beacons, bcn_ids are required.
  IF ( function != p_set_beacons AND ((bcn_ids IS NULL) OR (bcn_ids.COUNT < 1))) THEN
    RETURN p_bcn_err_badparams;
  END IF;

  IF ( ( function = p_set_beacons ) AND ( bcns IS NOT NULL ) AND ( bcns.COUNT > 0 ) )THEN 
    FOR l_count IN bcns.FIRST..bcns.LAST LOOP 
      l_tgt := bcns(l_count).name;
      l_type := bcns(l_count).value;

      IF(MGMT_USER.HAS_PRIV(current_user, MGMT_USER.OPERATOR_TARGET, l_tgt, l_type) = MGMT_USER.USER_DOES_NOT_HAVE_PRIV) THEN
         err_desc := err_desc || l_tgt || ', ';
         l_found := 1;
      END IF;
    END LOOP;
  ELSE 
    FOR l_count IN 1..bcn_ids.COUNT LOOP
      l_bcn_id := HEXTORAW(bcn_ids(l_count));
      IF(MGMT_USER.HAS_PRIV(current_user, MGMT_USER.OPERATOR_TARGET, l_bcn_id) = MGMT_USER.USER_DOES_NOT_HAVE_PRIV) THEN
        SELECT target_name INTO l_bcn_name
          FROM MGMT_TARGETS
         WHERE target_guid = l_bcn_id;
         
        err_desc := err_desc || l_bcn_name || ', ';
        l_found := 1;
      END IF;
    END LOOP;
  END IF;

  IF ( l_found = 1) THEN
    RETURN p_err_operator_priv_req;  
  ELSE 
    RETURN p_bcn_success;
  END IF;

END CHECK_BCN_PRIV;


--------------------------------------------------------------------------
--------------------------------------------------------------------------
-- Given a target guid and privilege type this function
-- returns If the current user has enough privileges

FUNCTION CHECK_PRIV ( tgt_id IN VARCHAR2,
                      priv_type IN INTEGER,
                      function in INTEGER, 
                      bcns IN SMP_EMD_NVPAIR_ARRAY DEFAULT NULL,
                      err_desc OUT VARCHAR2) RETURN INTEGER
IS
v_tgt          RAW(16);
l_current_user VARCHAR2(256) := MGMT_USER.get_current_em_user();
l_bcn_guids    SMP_EMD_STRING_ARRAY := SMP_EMD_STRING_ARRAY();
BEGIN
  IF( tgt_id IS NULL ) THEN
    RETURN p_bcn_err_badparams;
  END IF;  

  v_tgt := HEXTORAW(tgt_id);
  IF ( priv_type = p_priv_use_bcn_op_tgt ) THEN
    -- check if user has op privs on all beacons
    SELECT RAWTOHEX(beacon_target_guid) BULK COLLECT INTO l_bcn_guids
      FROM mgmt_bcn_target 
     WHERE target_guid = tgt_id;
    
    IF ( ( MGMT_USER.has_priv(l_current_user, MGMT_USER.USE_ANY_BEACON) = MGMT_USER.USER_DOES_NOT_HAVE_PRIV) AND 
         (CHECK_BCN_PRIV(l_bcn_guids, l_current_user, function, bcns, err_desc) <> p_bcn_success) ) THEN
      RETURN p_err_use_bcn_priv_req;
    ELSIF ( MGMT_USER.has_priv ( l_current_user, 
           MGMT_USER.OPERATOR_TARGET, v_tgt) = MGMT_USER.USER_DOES_NOT_HAVE_PRIV ) THEN
      RETURN p_err_operator_priv_req;
    ELSE
      RETURN p_bcn_success;
    END IF;
  ELSIF ( priv_type = p_priv_op_tgt ) THEN
    IF ( MGMT_USER.has_priv (  l_current_user,
           MGMT_USER.OPERATOR_TARGET, v_tgt) = MGMT_USER.USER_DOES_NOT_HAVE_PRIV ) THEN
      RETURN p_err_operator_priv_req;
    ELSE
      RETURN p_bcn_success;
    END IF;
  ELSIF ( priv_type = p_priv_full_tgt ) THEN
    IF ( MGMT_USER.has_priv (  l_current_user,
           MGMT_USER.FULL_TARGET, v_tgt) = MGMT_USER.USER_DOES_NOT_HAVE_PRIV ) THEN
      RETURN p_err_full_tgt_priv_req;
    ELSE
      RETURN p_bcn_success;
    END IF;
  ELSIF ( priv_type = p_priv_view_tgt ) THEN
    IF ( MGMT_USER.has_priv (  l_current_user,
             MGMT_USER.VIEW_TARGET, v_tgt) = MGMT_USER.USER_DOES_NOT_HAVE_PRIV ) THEN
      RETURN p_err_view_priv_req;
    ELSE
      RETURN p_bcn_success;
    END IF;
  END IF;
  RETURN p_bcn_err_badparams;  

EXCEPTION
  WHEN OTHERS THEN
    err_desc := SUBSTR(SQLERRM, 1, p_err_maxlen);
    LOG_SYS_ERR(p_bcn_err_oraerr, 'CHECK_PRIV: db error: ' || err_desc);
    RETURN p_bcn_err_oraerr;
 
END CHECK_PRIV;
--------------------------------------------------------------------------
--------------------------------------------------------------------------
FUNCTION HAS_TGT_FUNCTION_PRIV ( l_target_name IN VARCHAR2 ,
                                 l_target_type IN VARCHAR2, 
                                 function IN INTEGER,
                                 err_desc OUT VARCHAR2,
                                 bcns IN SMP_EMD_NVPAIR_ARRAY DEFAULT NULL) RETURN INTEGER
IS 
v_tgt_id      VARCHAR2(32);
v_raw_guid    RAW(16);
result        INTEGER;
BEGIN
  
  IF ( ( l_target_name IS NULL ) OR ( l_target_type IS NULL ) ) THEN
    RETURN p_bcn_err_badparams;
  END IF;  

  v_raw_guid := mgmt_target.get_target_guid(l_target_name, l_target_type);
  v_tgt_id := RAWTOHEX(v_raw_guid);

  result := HAS_TGT_FUNCTION_PRIV ( v_tgt_id, function, err_desc, bcns );
  RETURN result;

EXCEPTION 
  WHEN mgmt_global.target_does_not_exist THEN
    result := p_bcn_err_tgtnotfound;
    RETURN result;

END HAS_TGT_FUNCTION_PRIV;
--------------------------------------------------------------------------
--------------------------------------------------------------------------
FUNCTION HAS_TGT_FUNCTION_PRIV ( tgt_id IN VARCHAR2 ,
                                 function IN INTEGER,
                                 err_desc OUT VARCHAR2,
                                 bcns IN SMP_EMD_NVPAIR_ARRAY DEFAULT NULL) RETURN INTEGER
IS 
v_ret_val      INTEGER;
v_priv_req     INTEGER;
v_bcn_count    INTEGER := 0;
BEGIN
  
  IF ( tgt_id IS NULL ) THEN
    RETURN p_bcn_err_badparams;
  END IF;  

  -- Check if target is a beacon or the target 
  -- which uses beacon
  IF ( MGMT_GENSVC_AVAIL.IS_BEACON ( HEXTORAW( tgt_id ) ) = FALSE ) THEN 
    v_priv_req := GET_FUNC_PRIV_TYPE ( function, FALSE );
  ELSE
    v_priv_req := GET_FUNC_PRIV_TYPE ( function, TRUE );
    -- Check for the Privileges
  END IF;
 
  -- If the target is not registered with any of the beacons 
  -- then it is not required to have USE_ANY_BEACON privilege
  -- USE_ANY_BEACON privilege is required to add beacons to 
  -- the target.
  IF ( ( v_priv_req = p_priv_use_bcn_op_tgt ) AND 
       ( function != p_set_beacons ) )THEN
    -- check if the target registered with any beacons.
    SELECT count(*) INTO v_bcn_count 
        FROM mgmt_bcn_target 
        WHERE target_guid = tgt_id;

    IF ( v_bcn_count = 0 ) THEN 
      v_priv_req := p_priv_op_tgt;
    END IF;
  END IF;

  IF (v_priv_req = p_err_unknown_function) THEN
    RETURN p_err_unknown_function;
  END IF;

  -- Check for the Privileges
  v_ret_val := CHECK_PRIV( tgt_id, v_priv_req, function , bcns, err_desc);
  return v_ret_val;

EXCEPTION
  WHEN OTHERS THEN
    err_desc := SUBSTR(SQLERRM, 1, p_err_maxlen);
    LOG_SYS_ERR(p_bcn_err_oraerr, 'HAS_TGT_FUNCTION_PRIV: db error: ' || err_desc);
    return p_bcn_err_oraerr;

END HAS_TGT_FUNCTION_PRIV;

--------------------------------------------------------------------------
FUNCTION HAS_TMPL_FUNCTION_PRIV (tgt_id IN VARCHAR2 ,
        function IN INTEGER, err_desc OUT VARCHAR2) RETURN INTEGER
IS 
    v_tgt               RAW(16);
    l_current_user      VARCHAR2(256) := MGMT_USER.get_current_em_user();
    v_priv_type         INTEGER;
BEGIN
    IF (tgt_id IS NULL) THEN
        RETURN p_bcn_err_badparams;
    END IF;  

    v_tgt := HEXTORAW(tgt_id);
    
    IF (function = p_view_txn) THEN
        v_priv_type := p_priv_view_tmpl;
    ELSE
        v_priv_type := p_priv_full_tmpl;
    END IF;
    
    IF (v_priv_type = p_priv_view_tmpl) THEN
        IF (MGMT_USER.has_priv(l_current_user, MGMT_USER.VIEW_TEMPLATE, v_tgt) 
                = MGMT_USER.USER_DOES_NOT_HAVE_PRIV) THEN
            RETURN p_err_view_tmpl_priv_req;
        ELSE
            RETURN p_bcn_success;
        END IF;
    ELSIF (v_priv_type = p_priv_full_tmpl) THEN
        IF (MGMT_USER.has_priv(l_current_user, MGMT_USER.FULL_TEMPLATE, v_tgt) 
                = MGMT_USER.USER_DOES_NOT_HAVE_PRIV) THEN
            RETURN p_err_full_tmpl_priv_req;
        ELSE
            RETURN p_bcn_success;
        END IF;
    END IF;
    RETURN p_bcn_err_badparams;  
EXCEPTION
    WHEN OTHERS THEN
        err_desc := SUBSTR(SQLERRM, 1, p_err_maxlen);
        LOG_SYS_ERR(p_bcn_err_oraerr, 'HAS_TMPL_FUNCTION_PRIV: db error: ' || err_desc);
        RETURN p_bcn_err_oraerr;

END HAS_TMPL_FUNCTION_PRIV;

--------------------------------------------------------------------------
--------------------------------------------------------------------------
FUNCTION HAS_USE_ANY_BCN_PRIV RETURN INTEGER
IS 
  l_current_user      VARCHAR2(256) := MGMT_USER.get_current_em_user();
BEGIN
  
  RETURN MGMT_USER.has_priv(l_current_user, MGMT_USER.USE_ANY_BEACON);

END HAS_USE_ANY_BCN_PRIV;

--------------------------------------------------------------------------
--------------------------------------------------------------------------
-- HAS_ALL_BCN_PRIVS
--
-- Given a list of beacons and an operation, this function checks whether the current EM user has
-- the required privilege on all the beacons. In particular, if the function is p_set_beacons,
-- the function will check for USE ANY BEACON or OPERATOR privilege on all the beacons. 
--
-- This private function is is used by EMD_BCN_ASSOC_TMPL_APPLY to check whether the user 
-- has privilege on all the template beacons. This is necessary for the user to associate 
-- the template beacons with the target at the time of apply.
-- 
-- Parameters: 
--   IN bcns: a list of beacons
--   IN function: the operation (i.e. create test, associate beacons, etc)
--   OUT err_desc: a string displaying the list of beacons for which user does not
-- have privilege. A beacon name will be included in this list even if it does not
-- exist in the repository.
--
--
-- Returns: 
--   p_err_use_bcn_priv_req, 
--     if there is at least one beacon for which the user does not have enough privilege, 
--   p_bcn_success,
--     otherwise

FUNCTION HAS_ALL_BCN_PRIVS(bcns         IN  SMP_EMD_NVPAIR_ARRAY,
                           function     IN  INTEGER,
                           err_desc     OUT VARCHAR2) 
RETURN INTEGER
IS
  l_current_user      VARCHAR2(256) := MGMT_USER.get_current_em_user();

BEGIN
    
  IF ( ( MGMT_USER.has_priv(l_current_user, MGMT_USER.USE_ANY_BEACON) = MGMT_USER.USER_DOES_NOT_HAVE_PRIV) AND 
       ( CHECK_BCN_PRIV(NULL, l_current_user, function, bcns, err_desc) <> p_bcn_success) ) THEN
      RETURN p_err_use_bcn_priv_req;   
  ELSE
      RETURN p_bcn_success;
  END IF;    

END HAS_ALL_BCN_PRIVS; 

---------------------------------
-- GET_METRICS_FOR_KEYVAL()
-- Gets the metric guids of a test given the key_value
---------------------------------

FUNCTION GET_METRICS_FOR_KEYVAL(p_target_guid IN RAW,
                                p_key_value IN VARCHAR2,
                                p_key_level IN VARCHAR2) --can be TXN, GROUP, STEP or ALL
RETURN SMP_EMD_STRING_ARRAY
IS
  v_metric_guids SMP_EMD_STRING_ARRAY;

BEGIN
   SELECT RAWTOHEX(m.metric_guid) BULK COLLECT INTO v_metric_guids
          FROM MGMT_METRICS m, 
               (SELECT metadata.metric_name
                  FROM MGMT_TEST_METRICS metadata,
                       MGMT_METRICS_COMPOSITE_KEYS k, 
                       MGMT_BCN_TXN_DEFN txn
                 WHERE metadata.test_type = txn.txn_type
                   AND (metadata.level_name = p_key_level OR p_key_level = 'ALL')
                   AND k.composite_key = p_key_value
                   AND k.target_guid = txn.target_guid
                   AND k.target_guid = p_target_guid
                   AND txn.name = k.key_part1_value
               ) metric_names,
               MGMT_TARGETS target
         WHERE target.target_guid = p_target_guid
           AND (target.category_prop_1 = m.category_prop_1 OR target.category_prop_1 = ' ')
           AND (target.category_prop_2 = m.category_prop_2 OR target.category_prop_2 = ' ')
           AND (target.category_prop_3 = m.category_prop_3 OR target.category_prop_3 = ' ')
           AND (target.category_prop_4 = m.category_prop_4 OR target.category_prop_4 = ' ')
           AND (target.category_prop_5 = m.category_prop_5 OR target.category_prop_5 = ' ')
           AND target.target_type = m.target_type
           AND target.type_meta_ver = m.type_meta_ver
           AND metric_names.metric_name = m.metric_name
           AND m.metric_type != MGMT_GLOBAL.G_METRIC_TYPE_TABLE 
           AND m.metric_type != MGMT_GLOBAL.G_METRIC_TYPE_REPOS_TABLE;

  RETURN v_metric_guids;

  EXCEPTION WHEN NO_DATA_FOUND THEN
    LOG_SYS_ERR(p_bcn_err_oraerr, 'GET_METRICS_FOR_KEYVAL: Metrics not found for key value: ' || p_key_value || SQLERRM);
    RETURN null;

END GET_METRICS_FOR_KEYVAL;

---------------
-- KEY_VALUE_DEL_CALLBACK() this function 
-- supports txn-level, step-level, stepgroup-level
-- key value deletion
-------------------------------------------------------------------------
FUNCTION KEY_VALUE_DEL_CALLBACK(tgt_id   IN RAW,
                                txn_id   IN RAW,
                                step_ids IN MGMT_BCN_STEPID_ARRAY,
                                grp_ids  IN MGMT_BCN_STEPGROUPID_ARRAY,
                                bcn_ids  IN SMP_EMD_STRING_ARRAY,
                                p_delete_txn  IN BOOLEAN,
                                err_desc OUT VARCHAR2)
RETURN INTEGER
IS
  v_keys SMP_EMD_STRING_ARRAY;
  v_metric_guids SMP_EMD_STRING_ARRAY;
  v_beacon_names SMP_EMD_STRING_ARRAY := NULL;
  v_txn_name MGMT_BCN_TXN_DEFN.NAME%TYPE;
BEGIN

 IF (txn_id IS NULL OR tgt_id IS NULL) THEN
    RETURN p_bcn_err_badparams;
 END IF;

 IF(bcn_ids IS NOT NULL) THEN
   SELECT target_name BULK COLLECT INTO v_beacon_names
     FROM MGMT_TARGETS
    WHERE target_guid IN (SELECT * FROM TABLE(CAST(bcn_ids AS SMP_EMD_STRING_ARRAY)));
 END IF;

 BEGIN
   SELECT name INTO v_txn_name
     FROM MGMT_BCN_TXN_DEFN
    WHERE txn_guid = txn_id
      AND target_guid = tgt_id;
 EXCEPTION WHEN NO_DATA_FOUND THEN
    LOG_SYS_ERR(p_bcn_err_invalidtxn, 'KEY_VALUE_DEL_CALLBACK: txn name not found for id: ' || txn_id);
    RETURN p_bcn_err_invalidtxn;
 END;

 -- txns
 IF(p_delete_txn = TRUE) THEN
  BEGIN
  SELECT k.composite_key BULK COLLECT INTO v_keys
    FROM MGMT_METRICS_COMPOSITE_KEYS k
   WHERE k.target_guid = tgt_id
     AND k.key_part1_value = v_txn_name
     AND (k.key_part2_value IN  
              ( SELECT * 
                 FROM TABLE(CAST(v_beacon_names AS SMP_EMD_STRING_ARRAY))
              )
          OR bcn_ids IS NULL)
     AND (k.key_part3_value = ' ' OR k.key_part3_value IS NULL)
     AND (k.key_part4_value = ' ' OR k.key_part4_value IS NULL)
     AND (k.key_part5_value = ' ' OR k.key_part5_value IS NULL);
  EXCEPTION WHEN NO_DATA_FOUND THEN
    LOG_SYS_ERR(p_bcn_err_oraerr, 'KEY_VALUE_DEL_CALLBACK: Txn Keys not found err ' || SQLERRM);
    RETURN p_bcn_err_oraerr;
  END;
  IF(v_keys IS NOT NULL AND v_keys.COUNT > 0) THEN
    v_metric_guids := GET_METRICS_FOR_KEYVAL(tgt_id, v_keys(1), 'TXN');
    IF (v_metric_guids IS NOT NULL AND (v_metric_guids.COUNT > 0)) THEN
      FOR i IN v_keys.FIRST..v_keys.LAST LOOP
        EM_METRIC.EXEC_CBK_METRIC_KEYVAL(tgt_id, v_metric_guids, v_keys(i));
      END LOOP;
    END IF;
  END IF;
 END IF;


 IF(grp_ids IS NOT NULL) THEN
  -- grps
  BEGIN
  SELECT k.composite_key BULK COLLECT INTO v_keys
    FROM MGMT_METRICS_COMPOSITE_KEYS k,
         MGMT_BCN_STEPGROUP_DEFN g
   WHERE k.target_guid = tgt_id
     AND g.target_guid = tgt_id
     AND g.txn_guid = txn_id
     AND RAWTOHEX(g.stepgroup_guid) IN 
              ( SELECT * 
                 FROM TABLE(CAST(grp_ids AS MGMT_BCN_STEPGROUPID_ARRAY))
              )
     AND (k.key_part1_value = v_txn_name)
     AND (k.key_part2_value IN 
              ( SELECT * 
                 FROM TABLE(CAST(v_beacon_names AS SMP_EMD_STRING_ARRAY))
              )
          OR bcn_ids IS NULL)
     AND (k.key_part3_value = g.name)
     AND (k.key_part4_value = ' ' OR k.key_part4_value IS NULL)
     AND (k.key_part5_value = ' ' OR k.key_part5_value IS NULL);
  EXCEPTION WHEN NO_DATA_FOUND THEN
    LOG_SYS_ERR(p_bcn_err_oraerr, 'KEY_VALUE_DEL_CALLBACK: Step Keys not found err ' || SQLERRM);
    RETURN p_bcn_err_oraerr;
  END;

  IF(v_keys IS NOT NULL AND v_keys.COUNT > 0) THEN
    v_metric_guids := GET_METRICS_FOR_KEYVAL(tgt_id, v_keys(1), 'GROUP');
    IF (v_metric_guids IS NOT NULL AND (v_metric_guids.COUNT > 0)) THEN
      FOR i IN v_keys.FIRST..v_keys.LAST LOOP
        EM_METRIC.EXEC_CBK_METRIC_KEYVAL(tgt_id, v_metric_guids, v_keys(i));
      END LOOP;
    END IF;
  END IF;
 END IF;

 IF(step_ids IS NOT NULL) THEN
  --steps
  BEGIN
    SELECT k.composite_key BULK COLLECT INTO v_keys
      FROM MGMT_METRICS_COMPOSITE_KEYS k,
           MGMT_BCN_STEP_DEFN s
     WHERE k.target_guid = tgt_id
       AND s.target_guid = tgt_id
       AND s.txn_guid = txn_id
       AND RAWTOHEX(s.step_guid) IN
                 ( SELECT * 
                   FROM TABLE(CAST(step_ids AS MGMT_BCN_STEPID_ARRAY))
                )
       AND (k.key_part1_value = v_txn_name)
       AND (k.key_part2_value IN
                ( SELECT * 
                   FROM TABLE(CAST(v_beacon_names AS SMP_EMD_STRING_ARRAY))
                )
            OR bcn_ids IS NULL)
       AND (k.key_part3_value = s.name)
       AND (k.key_part4_value = ' ' OR k.key_part4_value IS NULL)
       AND (k.key_part5_value = ' ' OR k.key_part5_value IS NULL);
    EXCEPTION WHEN NO_DATA_FOUND THEN
      LOG_SYS_ERR(p_bcn_err_oraerr, 'KEY_VALUE_DEL_CALLBACK: Group Keys not found err ' || SQLERRM);
      RETURN p_bcn_err_oraerr;
  END;
  IF(v_keys IS NOT NULL AND v_keys.COUNT > 0) THEN
    v_metric_guids := GET_METRICS_FOR_KEYVAL(tgt_id, v_keys(1), 'STEP');
    IF (v_metric_guids IS NOT NULL AND (v_metric_guids.COUNT > 0) )THEN
      FOR i IN v_keys.FIRST..v_keys.LAST LOOP
        EM_METRIC.EXEC_CBK_METRIC_KEYVAL(tgt_id, v_metric_guids, v_keys(i));
      END LOOP;
    END IF;
  END IF;
 END IF;

 RETURN p_bcn_success;

END KEY_VALUE_DEL_CALLBACK;

--------------------------------------------------------------------------
/*
--------------------------------------------------------------------------
-- EMD_BCN_LOCK_TARGET
-- 
FUNCTION EMD_BCN_LOCK_TARGET(tgt_id IN RAW) RETURN INTEGER 
IS PRAGMA AUTONOMOUS_TRANSACTION;
  v_tgt         RAW(16);
  v_lock        CHAR(1);

BEGIN

  -- Check if we have a lock record for the target
  BEGIN
    SELECT target_guid, is_locked 
      INTO v_tgt, v_lock
      FROM MGMT_BCN_TARGET_LOCK
      WHERE target_guid = tgt_id;
      IF v_lock = 'Y' THEN
        RETURN p_bcn_err_tgtinuse;    
      END IF;
  EXCEPTION  
    WHEN NO_DATA_FOUND THEN
      BEGIN
        -- we didn't, add it now
        INSERT INTO MGMT_BCN_TARGET_LOCK (target_guid, is_locked)
          VALUES (tgt_id, 'N');
        COMMIT;
      EXCEPTION
        WHEN DUP_VAL_ON_INDEX THEN
          -- Got inserted by someone else, continue
          ROLLBACK;
      END;
  END;

  -- Try to acquire a row-level lock on the target
  SELECT target_guid, is_locked
    INTO v_tgt, v_lock
    FROM MGMT_BCN_TARGET_LOCK
    WHERE target_guid = tgt_id
    FOR UPDATE NOWAIT;
 
  IF v_lock = 'Y' THEN
    RAISE p_record_locked;
  ELSE
    UPDATE MGMT_BCN_TARGET_LOCK
      SET is_locked = 'Y'
      WHERE target_guid = tgt_id;
    COMMIT;
    RETURN p_bcn_success;
  END IF;

EXCEPTION

  WHEN p_record_locked THEN
    ROLLBACK;
    RETURN p_bcn_err_tgtinuse;

  WHEN OTHERS THEN
    ROLLBACK;
    LOG_SYS_ERR(p_bcn_err_oraerr, 'EMD_BCN_LOCK_TARGET: db error: ' || SQLERRM);
    RETURN p_bcn_err_oraerr;

END EMD_BCN_LOCK_TARGET;
--------------------------------------------------------------------------

--------------------------------------------------------------------------
-- EMD_BCN_UNLOCK_TARGET
-- 
FUNCTION EMD_BCN_UNLOCK_TARGET(tgt_id IN RAW) RETURN INTEGER 
IS PRAGMA AUTONOMOUS_TRANSACTION;
  v_tgt         RAW(16);
  v_lock        CHAR(1);

BEGIN

  -- Try to acquire a row-level lock on the target
  SELECT target_guid, is_locked
    INTO v_tgt, v_lock
    FROM MGMT_BCN_TARGET_LOCK
    WHERE target_guid = tgt_id
    FOR UPDATE NOWAIT;
 
  IF v_lock = 'Y' THEN
    UPDATE MGMT_BCN_TARGET_LOCK
      SET is_locked = 'N'
      WHERE target_guid = tgt_id;
    COMMIT;
  ELSE
    ROLLBACK;
  END IF;

  RETURN p_bcn_success;

EXCEPTION

  WHEN p_record_locked THEN
    ROLLBACK;
    RETURN p_bcn_err_tgtinuse;

  WHEN OTHERS THEN
    ROLLBACK;
    LOG_SYS_ERR(p_bcn_err_oraerr, 'EMD_BCN_UNLOCK_TARGET: db error: ' || SQLERRM);
    RETURN p_bcn_err_oraerr;

END EMD_BCN_UNLOCK_TARGET;
--------------------------------------------------------------------------

--------------------------------------------------------------------------
-- EMD_BCN_UNLOCK_TARGET
-- 
PROCEDURE EMD_BCN_UNLOCK_TARGET( tgt_id IN VARCHAR2,
                                 result OUT INTEGER,
                                 err_desc OUT VARCHAR2 )
IS
  v_tgt                  RAW(16);

BEGIN

  result := HAS_TGT_FUNCTION_PRIV ( tgt_id, p_unlock_tgt, err_desc );
  IF result <> p_bcn_success THEN
    RETURN;
  END IF;

  v_tgt := HEXTORAW(tgt_id);
  result := EMD_BCN_UNLOCK_TARGET(v_tgt);
  err_desc := NULL;

EXCEPTION

  WHEN OTHERS THEN
    err_desc := SUBSTR(SQLERRM, 1, p_err_maxlen);
    ROLLBACK;
    LOG_SYS_ERR(p_bcn_err_oraerr, 'EMD_BCN_UNLOCK_TARGET: db error: ' || err_desc);
    result := p_bcn_err_oraerr;

END EMD_BCN_UNLOCK_TARGET;
--------------------------------------------------------------------------
*/
--------------------------------------------------------------------------

--------------------------------------------------------------------------
PROCEDURE CLOSE_TXN_SEVS ( target_in IN RAW, txn_in IN RAW, 
                           txn_name IN VARCHAR2 )
IS

  CURSOR v_sev_cur(tgt RAW, txn RAW) IS
    SELECT s.metric_guid, s.key_value, s.collection_timestamp
      FROM MGMT_CURRENT_SEVERITY s,
           MGMT_BCN_TXN_DEFN t,
           MGMT_METRICS_COMPOSITE_KEYS k
     WHERE s.target_guid = tgt 
       AND t.target_guid = tgt
       AND t.txn_guid = txn
       AND ( s.severity_code = mgmt_global.G_SEVERITY_WARNING
           OR s.severity_code = mgmt_global.G_SEVERITY_CRITICAL )
       AND k.target_guid = tgt 
       AND s.key_value = HEXTORAW(k.composite_key)
       AND k.key_part1_value = t.name;

  -- close errors from ALL beacons
  -- this means matching all collection names which begin with txn_guid

  CURSOR v_err_cur(tgt RAW, txn VARCHAR2) IS
    SELECT e.agent_guid, e.metric_guid, e.coll_name,
           e.collection_timestamp, e.metric_error_type
      FROM mgmt_current_metric_errors e
     WHERE e.target_guid = tgt
       AND e.coll_name LIKE (txn || '%');

  v_tgt_ts     DATE;
  v_ts         DATE;
  v_tz_region  MGMT_TARGETS.timezone_region%TYPE;
  v_more       BOOLEAN;
  v_sev        v_sev_cur%ROWTYPE;
  v_err        v_err_cur%ROWTYPE;
  v_txn        VARCHAR2(32);

  v_key_values mgmt_medium_string_table;

BEGIN

  SELECT timezone_region
    INTO v_tz_region
    FROM MGMT_TARGETS
   WHERE target_guid = target_in
     AND timezone_region IS NOT NULL;

  v_tgt_ts :=  MGMT_GLOBAL.SYSDATE_TZRGN(v_tz_region);

  v_more := TRUE;
  OPEN v_sev_cur(target_in, txn_in);
  WHILE v_more LOOP
    FETCH v_sev_cur INTO v_sev;
    v_more := v_sev_cur%FOUND;
    IF v_more THEN
      v_key_values := mgmt_medium_string_table();
      v_key_values.extend;
      v_key_values(1) := v_sev.key_value;
      EM_SEVERITY.clear_open_alerts(p_target_guid => target_in,
                                    p_policy_guid => v_sev.metric_guid,
                                    p_key_values => v_key_values,
                                    p_is_metric => TRUE,
                                    p_clear_message => 'Transaction ' || txn_name || 
                                                       ' was stopped or deleted.  Clearing all severities for the transaction.'
                                    );
      v_key_values.delete;
    END IF;
  END LOOP;
  IF v_sev_cur%ISOPEN THEN
    CLOSE v_sev_cur;
  END IF;

  v_more := TRUE;
  v_txn := RAWTOHEX(txn_in);
  OPEN v_err_cur(target_in, v_txn);
  WHILE v_more LOOP
    FETCH v_err_cur INTO v_err;
    v_more := v_err_cur%FOUND;
    IF v_more THEN
      v_ts := GREATEST(v_tgt_ts, v_err.collection_timestamp + 1/1440);
      INSERT INTO MGMT_METRIC_ERRORS
        ( target_guid, metric_guid, coll_name, agent_guid, 
          collection_timestamp, metric_error_message, metric_error_type )
      VALUES
        ( target_in, v_err.metric_guid, v_err.coll_name,
          v_err.agent_guid, v_ts, NULL, v_err.metric_error_type );
    END IF;
  END LOOP;
  IF v_err_cur%ISOPEN THEN
    CLOSE v_err_cur;
  END IF;

EXCEPTION  
  WHEN OTHERS THEN
    IF v_sev_cur%ISOPEN THEN
      CLOSE v_sev_cur;
    END IF;
    IF v_err_cur%ISOPEN THEN
      CLOSE v_err_cur;
    END IF;
    RAISE;

END CLOSE_TXN_SEVS;
--------------------------------------------------------------------------

--------------------------------------------------------------------------

--------------------------------------------------------------------------
-- EMD_BCN_TXN_SYNC_LIST
--
PROCEDURE EMD_BCN_TXN_SYNC_LIST(tgt_id IN VARCHAR2,
                                txn_list OUT MGMT_BCN_TXN_SYNC_ARRAY,
                                result OUT INTEGER,
                                err_desc OUT VARCHAR2)
IS

  CURSOR v_txn_cur ( tgt RAW ) IS
    SELECT txn_guid, name, state, version, is_representative
      FROM MGMT_BCN_TXN_DEFN
      WHERE target_guid = tgt
      ORDER BY name;

  v_tgt         RAW(16);

  v_txn_rec     v_txn_cur%ROWTYPE;
  v_more        BOOLEAN;
  v_ctr         PLS_INTEGER;
  v_count       PLS_INTEGER;

BEGIN

  IF tgt_id IS NULL THEN
    result := p_bcn_err_badparams;
    RETURN;
  END IF;
  
  result := HAS_TGT_FUNCTION_PRIV ( tgt_id, p_view_txn, err_desc );
  IF result <> p_bcn_success THEN
    RETURN;
  END IF;

  v_tgt := HEXTORAW(tgt_id);
  txn_list := NULL;

  OPEN v_txn_cur(v_tgt);
  v_more := TRUE;
  v_ctr := 0;
  WHILE v_more LOOP
    FETCH v_txn_cur INTO v_txn_rec;
    v_more := v_txn_cur%FOUND;
    IF v_more THEN

      /*
      IF v_txn_rec.state = 'M' THEN
        SELECT count(*) 
          INTO v_count
          FROM MGMT_BCN_TARGET_TXN bt, MGMT_BCN_TARGET b
          WHERE bt.target_guid = v_tgt
            AND bt.txn_guid = v_txn_rec.txn_guid
            AND bt.target_guid = b.target_guid
            AND ( (b.is_removing = 'Y' AND bt.state = 'M') 
                  OR (b.is_removing <> 'Y' 
                      AND ( bt.state <> 'M'
                            OR bt.version <> v_txn_rec.version
                            OR bt.req_update > 0) ) );
      ELSE
        SELECT count(*) 
          INTO v_count
          FROM MGMT_BCN_TARGET_TXN bt
          WHERE bt.target_guid = v_tgt
            AND bt.txn_guid = v_txn_rec.txn_guid
            AND bt.state = 'M'; 
      END IF;   
     */

      IF v_ctr = 0 THEN
        txn_list := MGMT_BCN_TXN_SYNC_ARRAY();
      END IF;
      txn_list.EXTEND;
      v_ctr := v_ctr + 1;

      IF v_count > 0 THEN
        txn_list(v_ctr) := MGMT_BCN_TXN_SYNC(v_txn_rec.txn_guid,
                                             v_txn_rec.name, 
                                             v_txn_rec.state, 'N',
                                             v_txn_rec.is_representative);
      ELSE        
        txn_list(v_ctr) := MGMT_BCN_TXN_SYNC(v_txn_rec.txn_guid,
                                             v_txn_rec.name, 
                                             v_txn_rec.state, 'Y',
                                             v_txn_rec.is_representative);
      END IF;
    END IF;
  END LOOP;
  CLOSE v_txn_cur;

  result := p_bcn_success;
  err_desc := NULL;

EXCEPTION

  WHEN OTHERS THEN
    result := p_bcn_err_oraerr;
    err_desc := SUBSTR(SQLERRM, 1, p_err_maxlen);
    LOG_SYS_ERR(result, 'EMD_BCN_TXN_SYNC_LIST: db error: ' || err_desc);
    IF v_txn_cur%ISOPEN THEN
      CLOSE v_txn_cur;
    END IF;
    IF txn_list IS NOT NULL THEN
      txn_list.DELETE;
      txn_list := NULL;
    END IF;

END EMD_BCN_TXN_SYNC_LIST;
--------------------------------------------------------------------------

--------------------------------------------------------------------------
-- EMD_BCN_SEV_LIST
--
-- This is an INTERNAL procedure only (not to be called directly from outside.
-- Checking of privileges should be done before calling into this (call
-- HAS_TGT_FUNCTION_PRIV() for that). No checking of param validity is done
-- either (make sure function exposed externaly that call this check these
-- before making the call).
--
PROCEDURE EMD_BCN_SEV_LIST(tgt_id      IN RAW,
                           l_sev_list OUT p_cursor_type,
                           result     OUT INTEGER,
                           err_desc   OUT VARCHAR2)
IS
  v_target_name   mgmt_targets.target_name%TYPE;
  v_target_type   mgmt_targets.target_type%TYPE;

BEGIN

  SELECT target_name, target_type INTO v_target_name, v_target_type 
    FROM mgmt_targets 
    WHERE target_guid = tgt_id;

  OPEN l_sev_list FOR
    WITH bcn_names AS
    (
      SELECT DECODE(tgt.target_name, v_target_name, '-', tgt.target_name)
           bcn_name, tgt.target_name bcn_name_rl,
           DECODE(tgt.target_name, v_target_name, 0, 1) is_bcn
        FROM mgmt_targets tgt, mgmt_bcn_target bcn
        WHERE bcn.target_guid = tgt_id
          AND bcn.beacon_target_guid = tgt.target_guid
    ),
    key AS
    (
      SELECT ckey.composite_key comp_key, bcn.is_bcn, bcn.bcn_name_rl bcn_name
        FROM mgmt_metrics_composite_keys ckey, bcn_names bcn,
             mgmt_bcn_txn_defn txn
        WHERE txn.target_guid = tgt_id
        AND ckey.target_guid = tgt_id
        AND ckey.key_part1_value = txn.name
        AND ckey.key_part2_value = bcn.bcn_name
    )
    SELECT bcn_name, is_bcn, sev_code, c_key
      FROM
      (
         SELECT key.bcn_name bcn_name, key.comp_key c_key, key.is_bcn is_bcn,
                currsev.sev_code sev_code 
           FROM
           (
            SELECT mt.metric_guid met_guid, mt.metric_column met_col
              FROM mgmt_metrics mt, mgmt_targets tg
             WHERE tg.target_guid = tgt_id
               AND mt.metric_name = p_met_name_http
               AND tg.target_type = mt.target_type
               AND tg.type_meta_ver = mt.type_meta_ver
               AND (tg.category_prop_1 = mt.category_prop_1 OR mt.category_prop_1 = ' ')
               AND (tg.category_prop_2 = mt.category_prop_2 OR mt.category_prop_2 = ' ')
               AND (tg.category_prop_3 = mt.category_prop_3 OR mt.category_prop_3 = ' ')
               AND (tg.category_prop_4 = mt.category_prop_4 OR mt.category_prop_4 = ' ')
               AND (tg.category_prop_5 = mt.category_prop_5 OR mt.category_prop_5 = ' ')
           ) met,
           (
           SELECT severity_code sev_code,key_value key_val, metric_guid met_guid
             FROM mgmt_current_severity 
             WHERE target_guid = tgt_id
           ) currsev,
           key 
           WHERE currsev.met_guid = met.met_guid 
           AND currsev.key_val = key.comp_key
      );

  result := p_bcn_success;
  err_desc := NULL;

EXCEPTION

  WHEN OTHERS THEN
    result := p_bcn_err_oraerr;
    err_desc := SUBSTR(SQLERRM, 1, p_err_maxlen);
    LOG_SYS_ERR(result, 'EMD_BCN_SEV_LIST: db error: ' || err_desc);
    IF l_sev_list%ISOPEN THEN
      CLOSE l_sev_list;
    END IF;

END EMD_BCN_SEV_LIST;
--------------------------------------------------------------------------

--------------------------------------------------------------------------
-- EMD_BCN_SYNC_LIST
--
-- This is an INTERNAL procedure only (not to be called directly from outside.
-- Checking of privileges should be done before calling into this (call
-- HAS_TGT_FUNCTION_PRIV() for that). No checking of param validity is done
-- either (make sure function exposed externaly that call this check these
-- before making the call).
--
PROCEDURE EMD_BCN_SYNC_LIST(tgt_id    IN RAW,
                            bcn_list OUT MGMT_BCN_SYNC_ARRAY,
                            result   OUT INTEGER,
                            err_desc OUT VARCHAR2)
IS

  CURSOR v_bcn_cur ( tgt RAW ) IS
    SELECT b.beacon_target_guid, t.target_name AS beacon_name,
           b.is_removing, b.participates_avail AS avail, t.emd_url AS bcn_url
      FROM MGMT_BCN_TARGET b, MGMT_TARGETS t
      WHERE b.target_guid = tgt
        AND b.beacon_target_guid = t.target_guid;

  v_bcn_rec       v_bcn_cur%ROWTYPE;
  v_bcn_status    NUMBER;
  v_more          BOOLEAN;
  v_ctr           PLS_INTEGER;
  v_count         PLS_INTEGER;

BEGIN

  bcn_list := NULL;

  OPEN v_bcn_cur(tgt_id);
  v_more := TRUE;
  v_ctr := 0;
  WHILE v_more LOOP
    FETCH v_bcn_cur INTO v_bcn_rec;
    v_more := v_bcn_cur%FOUND;
    IF v_more THEN
      IF v_ctr = 0 THEN
        bcn_list := MGMT_BCN_SYNC_ARRAY();
      END IF;
      bcn_list.EXTEND;
      v_ctr := v_ctr + 1;

     /*
      IF v_bcn_rec.is_removing = 'Y' THEN
        SELECT count(*)
          INTO v_count
          FROM MGMT_BCN_TARGET_TXN
          WHERE target_guid = tgt_id
            AND beacon_target_guid = v_bcn_rec.beacon_target_guid
            AND state = 'M';
      ELSE
        SELECT count(*)
          INTO v_count
          FROM MGMT_BCN_TXN_DEFN t, MGMT_BCN_TARGET_TXN b
          WHERE b.target_guid = tgt_id
            AND b.beacon_target_guid = v_bcn_rec.beacon_target_guid
            AND b.target_guid = t.target_guid
            AND b.txn_guid = t.txn_guid
            AND ( ( t.state = 'M' 
                    AND ( b.state <> 'M'
                          OR b.version <> t.version
                          OR b.req_update > 0 ) )
                  OR ( t.state <> 'M'
                       AND b.state = 'M' ) );
      END IF;
      */

      -- Get the Beacon status.  For the local beacon, use the emd's status.
      BEGIN
        IF v_bcn_rec.beacon_target_guid = tgt_id THEN
          SELECT a.current_status 
            INTO v_bcn_status
            FROM mgmt_targets t, mgmt_current_availability a
            WHERE t.emd_url = v_bcn_rec.bcn_url
              AND t.target_type = 'oracle_emd'
              AND t.target_guid = a.target_guid
              AND rownum = 1;
        ELSE
          SELECT a.current_status 
            INTO v_bcn_status
            FROM mgmt_current_availability a
            WHERE a.target_guid = v_bcn_rec.beacon_target_guid
              AND rownum = 1;
        END IF;
      EXCEPTION
        WHEN NO_DATA_FOUND THEN
          v_bcn_status := 2;
      END;

      IF v_count > 0 THEN
        bcn_list(v_ctr) := MGMT_BCN_SYNC(v_bcn_rec.beacon_target_guid,
                                         v_bcn_rec.beacon_name, 
                                         v_bcn_rec.is_removing, 'N',
                                         v_bcn_status, v_bcn_rec.avail);
      ELSE        
        bcn_list(v_ctr) := MGMT_BCN_SYNC(v_bcn_rec.beacon_target_guid,
                                         v_bcn_rec.beacon_name, 
                                         v_bcn_rec.is_removing, 'Y',
                                         v_bcn_status, v_bcn_rec.avail);
      END IF;

    END IF;
  END LOOP;
  CLOSE v_bcn_cur;

  result := p_bcn_success;
  err_desc := NULL;

EXCEPTION

  WHEN OTHERS THEN
    result := p_bcn_err_oraerr;
    err_desc := SUBSTR(SQLERRM, 1, p_err_maxlen);
    LOG_SYS_ERR(result, 'EMD_BCN_SYNC_LIST: db error: ' || err_desc);
    IF v_bcn_cur%ISOPEN THEN
      CLOSE v_bcn_cur;
    END IF;
    IF bcn_list IS NOT NULL THEN
      bcn_list.DELETE;
      bcn_list := NULL;
    END IF;

END EMD_BCN_SYNC_LIST;
--------------------------------------------------------------------------

--------------------------------------------------------------------------
-- EMD_BCN_SYNC_SEV_LIST
--
PROCEDURE EMD_BCN_SYNC_SEV_LIST(tgt_id IN VARCHAR2,
                                bcn_list OUT MGMT_BCN_SYNC_ARRAY,
                                l_sev_list OUT p_cursor_type,
                                result OUT INTEGER,
                                err_desc OUT VARCHAR2)
IS

  v_tgt           RAW(16);

BEGIN

  IF tgt_id IS NULL THEN
    result := p_bcn_err_badparams;
    RETURN;
  END IF;
  
  result := HAS_TGT_FUNCTION_PRIV ( tgt_id, p_view_mntr_reports, err_desc );
  IF result <> p_bcn_success THEN
    RETURN;
  END IF;

  v_tgt := HEXTORAW(tgt_id);

  -- Get the sync list
  EMD_BCN_SYNC_LIST(v_tgt, bcn_list, result, err_desc);
  IF result <> p_bcn_success THEN
    RETURN;
  END IF;

  -- Get the severities list
  EMD_BCN_SEV_LIST(v_tgt, l_sev_list, result, err_desc);
  IF result <> p_bcn_success THEN
    IF bcn_list IS NOT NULL THEN
      bcn_list.DELETE;
      bcn_list := NULL;
    END IF;
    RETURN;
  END IF;
  
EXCEPTION

  WHEN OTHERS THEN
    result := p_bcn_err_oraerr;
    err_desc := SUBSTR(SQLERRM, 1, p_err_maxlen);
    LOG_SYS_ERR(result, 'EMD_BCN_SYNC_SEV_LIST: db error: ' || err_desc);
    IF l_sev_list%ISOPEN THEN
      CLOSE l_sev_list;
    END IF;
    IF bcn_list IS NOT NULL THEN
      bcn_list.DELETE;
      bcn_list := NULL;
    END IF;

END EMD_BCN_SYNC_SEV_LIST;
--------------------------------------------------------------------------
/*
--------------------------------------------------------------------------
-- EMD_BCN_TXN_SET_REP_NC
--
PROCEDURE EMD_BCN_TXN_SET_REP_NC(tgt_id IN VARCHAR2,
                                 txn_id IN VARCHAR2,
                                 result OUT INTEGER,
                                 err_desc OUT VARCHAR2)
IS

  v_tgt                 RAW(16);
  v_txn                 RAW(16);
 
  v_name                VARCHAR2(64);
  v_state               VARCHAR2(8);
  v_isrep               CHAR(1);
  v_txn_type            mgmt_bcn_txn_defn.txn_type%TYPE;
  v_av_met              RAW(16);

BEGIN

  IF tgt_id IS NULL OR txn_id IS NULL THEN
    result := p_bcn_err_badparams;
    RETURN;
  END IF;

  result := HAS_TGT_FUNCTION_PRIV ( tgt_id, p_set_availability, err_desc );
  IF result <> p_bcn_success THEN
    RETURN;
  END IF;

  v_tgt := HEXTORAW(tgt_id);
  v_txn := HEXTORAW(txn_id);

  SAVEPOINT EMD_BCN_TXN_SET_REP_NC_SVPT;

  SELECT name, state, is_representative, txn_type
    INTO v_name, v_state, v_isrep, v_txn_type
    FROM MGMT_BCN_TXN_DEFN
    WHERE target_guid = v_tgt
      AND txn_guid = v_txn;

  -- No-op if it's already the representative txn
  IF v_isrep = 'Y' THEN
    result := p_bcn_success;
    err_desc := NULL;
    RETURN;
  END IF;

  -- Error if the txn is not monitoring
  IF v_state <> 'M' THEN
    result := p_bcn_err_txnnotmonitor;
    RAISE p_internal_error;
  END IF;

  -- Invalid Operation for Ping Txns
  IF v_txn_type = p_ping_db_type THEN
    result := p_bcn_err_invalidpingop;
    RAISE p_internal_error;
  END IF;  

  -- Ok to set to rep, clear the previous one first.
  UPDATE MGMT_BCN_TXN_DEFN
    SET is_representative = 'N' 
    WHERE target_guid = v_tgt
      AND is_representative = 'Y';

  UPDATE MGMT_BCN_TXN_DEFN
    SET is_representative = 'Y' 
    WHERE target_guid = v_tgt
      AND txn_guid = v_txn;
  
  -- Change the beacon availability definition
  SELECT mt.metric_guid
    INTO v_av_met
    FROM MGMT_METRICS mt, MGMT_TARGETS tg
   WHERE tg.target_guid = v_tgt
     AND mt.metric_name = 'http_response'
     AND mt.metric_column = 'status'
     AND tg.target_type = mt.target_type
     AND tg.type_meta_ver = mt.type_meta_ver
     AND (tg.category_prop_1 = mt.category_prop_1 OR mt.category_prop_1 = ' ')
     AND (tg.category_prop_2 = mt.category_prop_2 OR mt.category_prop_2 = ' ')
     AND (tg.category_prop_3 = mt.category_prop_3 OR mt.category_prop_3 = ' ')
     AND (tg.category_prop_4 = mt.category_prop_4 OR mt.category_prop_4 = ' ')
     AND (tg.category_prop_5 = mt.category_prop_5 OR mt.category_prop_5 = ' ');

  UPDATE MGMT_BCN_AVAIL_DEF
     SET key_part1 = v_name
   WHERE target_guid = v_tgt;
  IF SQL%NOTFOUND THEN
    INSERT INTO MGMT_BCN_AVAIL_DEF
      ( target_guid, metric_guid, key_part1, key_part2 )
      VALUES
      ( v_tgt, v_av_met, v_name, 'mgmt_bcn_use_bcn_name' );
  END IF;

  -- Recomputate the beacon availability of the target.
--  EMD_BCN_AVAIL.UPDATE_BEACON_AVAIL( v_tgt ); 

  result := p_bcn_success;
  err_desc := NULL;

EXCEPTION

  WHEN p_internal_error THEN
    LOG_SYS_ERR(result, 'EMD_BCN_TXN_SET_REP_NC: failed.');
    ROLLBACK TO EMD_BCN_TXN_SET_REP_NC_SVPT;

  WHEN OTHERS THEN
    result := p_bcn_err_oraerr;
    err_desc := SUBSTR(SQLERRM, 1, p_err_maxlen);
    LOG_SYS_ERR(result, 'EMD_BCN_TXN_SET_REP_NC: db error: ' || err_desc);
    ROLLBACK TO EMD_BCN_TXN_SET_REP_NC_SVPT;

END EMD_BCN_TXN_SET_REP_NC;
--------------------------------------------------------------------------

--------------------------------------------------------------------------
-- EMD_BCN_TXN_SET_REPRESENTATIVE
--
PROCEDURE EMD_BCN_TXN_SET_REPRESENTATIVE(tgt_id IN VARCHAR2,
                                         txn_id IN VARCHAR2,
                                         result OUT INTEGER,
                                         err_desc OUT VARCHAR2)
IS
  v_tgt                 RAW(16);
  v_tmp                 INTEGER;
  v_tgt_locked          BOOLEAN := FALSE;
BEGIN

  IF tgt_id IS NULL OR txn_id IS NULL THEN
    result := p_bcn_err_badparams;
    RETURN;
  END IF;

  result := HAS_TGT_FUNCTION_PRIV ( tgt_id, p_set_availability, err_desc );
  IF result <> p_bcn_success THEN
    RETURN;
  END IF;

  v_tgt := HEXTORAW(tgt_id);

  -- Lock the target
  result := EMD_BCN_LOCK_TARGET(v_tgt);
  IF result <> p_bcn_success THEN
    RETURN;
  END IF;
  v_tgt_locked := TRUE;

  EMD_BCN_TXN_SET_REP_NC(tgt_id, txn_id, result, err_desc);

  IF result = p_bcn_success THEN   -- check is an optimization (unecessary)
    COMMIT;
  END IF;

  v_tmp := EMD_BCN_UNLOCK_TARGET(v_tgt);

EXCEPTION

  WHEN OTHERS THEN
    result := p_bcn_err_oraerr;
    err_desc := SUBSTR(SQLERRM, 1, p_err_maxlen);
    IF v_tgt_locked THEN
      v_tmp := EMD_BCN_UNLOCK_TARGET(v_tgt);
    END IF;
    ROLLBACK;
  
END EMD_BCN_TXN_SET_REPRESENTATIVE;
--------------------------------------------------------------------------

--------------------------------------------------------------------------
-- EMD_BCN_TXN_SET_AVL_LST_NC
--
PROCEDURE EMD_BCN_TXN_SET_AVL_LST_NC(tgt_id IN VARCHAR2,
                                     bcn_list IN MGMT_BCN_GUID_ARRAY,
                                     result OUT INTEGER,
                                     err_desc OUT VARCHAR2)
IS
  v_tgt          RAW(16);
  v_tgt_type     VARCHAR2(64);
  v_bcns_state   MGMT_BCN_SYNC_ARRAY;
  v_bcns         MGMT_BCN_RAW_GUID_ARRAY;
  v_found        BOOLEAN;
  v_tmp          INTEGER;
  v_tmp2         INTEGER;

BEGIN

  IF tgt_id IS NULL OR bcn_list IS NULL OR bcn_list.COUNT <= 0 THEN
    result := p_bcn_err_badparams;
    RETURN;
  END IF;
 
  result := HAS_TGT_FUNCTION_PRIV ( tgt_id, p_set_availability, err_desc );
  IF result <> p_bcn_success THEN
    RETURN;
  END IF;

  v_tgt := HEXTORAW(tgt_id);

  SAVEPOINT EMD_BCN_TXN_SET_AVL_LSTNCSVPT;

  -- Invalid operation on a beacon target
  BEGIN
    SELECT target_type 
      INTO v_tgt_type
      FROM mgmt_targets
      WHERE target_guid = v_tgt;
  EXCEPTION
    WHEN NO_DATA_FOUND THEN
      result := p_bcn_err_tgtnotfound;
      RAISE p_internal_error;
  END;
  IF v_tgt_type = p_beacon_type THEN
    result := p_bcn_err_invalidbcnop;
    RAISE p_internal_error;   
  END IF;

  -- Verify that all beacons are in sync
  EMD_BCN_SYNC_LIST(v_tgt, v_bcns_state, result, err_desc);
  IF result <> p_bcn_success THEN
    RAISE p_internal_error;       
  END IF;  
  IF v_bcns_state IS NULL OR v_bcns_state.COUNT <= 0 THEN
    result := p_bcn_err_invalidrepos;
    RAISE p_internal_error;
  END IF;

  v_bcns := MGMT_BCN_RAW_GUID_ARRAY();
  FOR v_tmp IN 1..bcn_list.COUNT LOOP
    v_found := FALSE;
    v_tmp2 := 1;
    WHILE (NOT v_found) AND (v_tmp2 <= v_bcns_state.COUNT) LOOP
      IF bcn_list(v_tmp) = v_bcns_state(v_tmp2).bcn_guid THEN
        IF v_bcns_state(v_tmp2).is_removing = 'Y' THEN
          result := p_bcn_err_bcndeleting;
          err_desc := v_bcns_state(v_tmp2).bcn_name;
          RAISE p_internal_error;
        ELSIF v_bcns_state(v_tmp2).is_insync <> 'Y' THEN
          result := p_bcn_err_bcnoutofsync;
          err_desc := v_bcns_state(v_tmp2).bcn_name;
          RAISE p_internal_error;
        ELSE 
          -- ok, bcn is in sync
          v_bcns.EXTEND;
          v_bcns(v_tmp) := HEXTORAW(bcn_list(v_tmp));
          v_found := TRUE;
        END IF;
      END IF;
      v_tmp2 := v_tmp2 + 1;
    END LOOP;
    -- Bail if the bcn wasn't found
    IF NOT v_found THEN
      result := p_bcn_err_invalidrepos;
      RAISE p_internal_error;  
    END IF;
  END LOOP;

  -- All ok, set the list
  UPDATE MGMT_BCN_TARGET
    SET participates_avail = 'N'
    WHERE target_guid = v_tgt;
  IF SQL%NOTFOUND THEN
    result := p_bcn_err_invalidrepos;
    RAISE p_internal_error;
  END IF;

  UPDATE MGMT_BCN_TARGET
    SET participates_avail = 'Y'
    WHERE target_guid = v_tgt
      AND beacon_target_guid IN 
             ( SELECT * 
                 FROM TABLE(CAST(v_bcns AS MGMT_BCN_RAW_GUID_ARRAY))
              );
  IF SQL%NOTFOUND THEN
    result := p_bcn_err_invalidrepos;
    RAISE p_internal_error;
  END IF;

  -- Recomputate the beacon availability of the target.
--  EMD_BCN_AVAIL.UPDATE_BEACON_AVAIL( v_tgt ); 

    v_tmp := EMD_BCN_UNLOCK_TARGET(v_tgt);
  IF v_bcns IS NOT NULL THEN
    v_bcns.DELETE;
    v_bcns := NULL;
  END IF;

  IF v_bcns_state IS NOT NULL THEN
    v_bcns_state.DELETE;
    v_bcns_state := NULL;
  END IF;

  result := p_bcn_success;

EXCEPTION

  WHEN p_internal_error THEN
    LOG_SYS_ERR(result, 'EMD_BCN_TXN_SET_AVL_LST_NC: failed.');
    ROLLBACK TO EMD_BCN_TXN_SET_AVL_LSTNCSVPT;
    IF v_bcns IS NOT NULL THEN
      v_bcns.DELETE;
      v_bcns := NULL;
    END IF;
    IF v_bcns_state IS NOT NULL THEN
      v_bcns_state.DELETE;
      v_bcns_state := NULL;
    END IF;

  WHEN OTHERS THEN    
    result := p_bcn_err_oraerr;
    err_desc := SUBSTR(SQLERRM, 1, p_err_maxlen);
    LOG_SYS_ERR(result, 'EMD_BCN_TXN_SET_AVL_LST_NC: db error: ' || err_desc);
    ROLLBACK TO EMD_BCN_TXN_SET_AVL_LSTNCSVPT;
    IF v_bcns IS NOT NULL THEN
      v_bcns.DELETE;
      v_bcns := NULL;
    END IF;
    IF v_bcns_state IS NOT NULL THEN
      v_bcns_state.DELETE;
      v_bcns_state := NULL;
    END IF;

END EMD_BCN_TXN_SET_AVL_LST_NC;
--------------------------------------------------------------------------

--------------------------------------------------------------------------
-- EMD_BCN_TXN_SET_AVAIL_LIST
--
PROCEDURE EMD_BCN_TXN_SET_AVAIL_LIST(tgt_id IN VARCHAR2,
                                     bcn_list IN MGMT_BCN_GUID_ARRAY,
                                     result OUT INTEGER,
                                     err_desc OUT VARCHAR2)
IS
  v_tgt                 RAW(16);
  v_tmp                 INTEGER;
  v_tgt_locked          BOOLEAN := FALSE;
BEGIN

  v_tgt := HEXTORAW(tgt_id);

  result := HAS_TGT_FUNCTION_PRIV ( tgt_id, p_set_availability, err_desc );
  IF result <> p_bcn_success THEN
    RETURN;
  END IF;

  -- Lock the target
  result := EMD_BCN_LOCK_TARGET(v_tgt);
  IF result <> p_bcn_success THEN
    RETURN;
  END IF;
  v_tgt_locked := TRUE;

  EMD_BCN_TXN_SET_AVL_LST_NC(tgt_id, bcn_list, result, err_desc);

  IF result = p_bcn_success THEN   -- check is an optimization (unecessary)
    COMMIT;
  END IF;

  v_tmp := EMD_BCN_UNLOCK_TARGET(v_tgt);

EXCEPTION

  WHEN OTHERS THEN
    result := p_bcn_err_oraerr;
    err_desc := SUBSTR(SQLERRM, 1, p_err_maxlen);
    IF v_tgt_locked THEN
      v_tmp := EMD_BCN_UNLOCK_TARGET(v_tgt);
    END IF;
    ROLLBACK;

END EMD_BCN_TXN_SET_AVAIL_LIST;
--------------------------------------------------------------------------

--------------------------------------------------------------------------
-- EMD_BCN_TXN_SET_AVAIL
--
PROCEDURE EMD_BCN_TXN_SET_AVAIL(tgt_id IN VARCHAR2,
                                txn_id IN VARCHAR2,
                                bcn_list IN MGMT_BCN_GUID_ARRAY,
                                result OUT INTEGER,
                                err_desc OUT VARCHAR2)
IS
  v_tgt                 RAW(16);
  v_tmp                 INTEGER;
  v_tgt_locked          BOOLEAN := FALSE;
BEGIN

  v_tgt := HEXTORAW(tgt_id);

  result := HAS_TGT_FUNCTION_PRIV ( tgt_id, p_set_availability, err_desc );
  IF result <> p_bcn_success THEN
    RETURN;
  END IF;

  -- Lock the target
  result := EMD_BCN_LOCK_TARGET(v_tgt);
  IF result <> p_bcn_success THEN
    RETURN;
  END IF;
  v_tgt_locked := TRUE;

  EMD_BCN_TXN_SET_AVL_LST_NC(tgt_id, bcn_list, result, err_desc);
  IF result = p_bcn_success THEN
    EMD_BCN_TXN_SET_REP_NC(tgt_id, txn_id, result, err_desc);
  END IF;

  IF result = p_bcn_success THEN
    COMMIT;
  ELSE
    ROLLBACK;
  END IF;

  v_tmp := EMD_BCN_UNLOCK_TARGET(v_tgt);

EXCEPTION

  WHEN OTHERS THEN
    result := p_bcn_err_oraerr;
    err_desc := SUBSTR(SQLERRM, 1, p_err_maxlen);
    IF v_tgt_locked THEN
      v_tmp := EMD_BCN_UNLOCK_TARGET(v_tgt);
    END IF;
    ROLLBACK;

END EMD_BCN_TXN_SET_AVAIL;
--------------------------------------------------------------------------

*/
/*
--------------------------------------------------------------------------
-- EMD_BCN_RECOVER
-- 
PROCEDURE EMD_BCN_RECOVER(result OUT INTEGER, err_desc OUT VARCHAR2) 
IS

BEGIN
  UPDATE MGMT_BCN_TARGET_LOCK
    SET is_locked = 'N';
  COMMIT;

  result := p_bcn_success;

EXCEPTION

  WHEN OTHERS THEN    
    result := p_bcn_err_oraerr;
    err_desc := SUBSTR(SQLERRM, 1, p_err_maxlen);
    ROLLBACK;

END EMD_BCN_RECOVER;
--------------------------------------------------------------------------
*/

/*
--------------------------------------------------------------------------
-- EMD_BCN_GET_COLL_DETAILS
-- 
PROCEDURE EMD_BCN_GET_COLL_DETAILS ( tgt_in IN VARCHAR2, 
                                     txn_in IN VARCHAR2, 
                                     txn_name OUT VARCHAR2,
                                     txn_bcn_details OUT p_cursor_type,
                                     result OUT INTEGER, 
                                     err_desc OUT VARCHAR2 )
IS
  v_tgt_guid   RAW(16);
  v_tgt_type   VARCHAR2(64);
  v_txn_guid   RAW(16);
  v_avg_mg     RAW(16);
  v_max_mg     RAW(16);

BEGIN
  
  IF tgt_in IS NULL OR txn_in IS NULL THEN
    result := p_bcn_err_badparams;
    RETURN;
  END IF;

  result := HAS_TGT_FUNCTION_PRIV ( tgt_in, p_view_txn, err_desc );
  IF result <> p_bcn_success THEN
    RETURN;
  END IF;

  v_tgt_guid := HEXTORAW(tgt_in);
  v_txn_guid := HEXTORAW(txn_in);

  SELECT mt.metric_guid
    INTO v_avg_mg
    FROM MGMT_METRICS mt, MGMT_TARGETS tg 
   WHERE mt.metric_name = 'http_response'
     AND mt.metric_column = 'avg_response_time'
     AND tg.target_guid = v_tgt_guid
     AND tg.target_type = mt.target_type
     AND tg.type_meta_ver = mt.type_meta_ver
     AND (tg.category_prop_1 = mt.category_prop_1 OR mt.category_prop_1 = ' ')
     AND (tg.category_prop_2 = mt.category_prop_2 OR mt.category_prop_2 = ' ')
     AND (tg.category_prop_3 = mt.category_prop_3 OR mt.category_prop_3 = ' ')
     AND (tg.category_prop_4 = mt.category_prop_4 OR mt.category_prop_4 = ' ')
     AND (tg.category_prop_5 = mt.category_prop_5 OR mt.category_prop_5 = ' ');

  SELECT mt.metric_guid
    INTO v_max_mg
    FROM MGMT_METRICS mt, MGMT_TARGETS tg 
   WHERE mt.metric_name = 'http_response'
     AND mt.metric_column = 'max_response_time'
     AND tg.target_guid = v_tgt_guid
     AND tg.target_type = mt.target_type
     AND tg.type_meta_ver = mt.type_meta_ver
     AND (tg.category_prop_1 = mt.category_prop_1 OR mt.category_prop_1 = ' ')
     AND (tg.category_prop_2 = mt.category_prop_2 OR mt.category_prop_2 = ' ')
     AND (tg.category_prop_3 = mt.category_prop_3 OR mt.category_prop_3 = ' ')
     AND (tg.category_prop_4 = mt.category_prop_4 OR mt.category_prop_4 = ' ')
     AND (tg.category_prop_5 = mt.category_prop_5 OR mt.category_prop_5 = ' ');
     
  OPEN txn_bcn_details FOR
    SELECT t1.bcn_name, t1.bcn_guid, t1.schedule,
	       t2.warning_threshold as avg_warn, t2.critical_threshold as avg_crit,
           t3.warning_threshold as max_warn, t3.critical_threshold as max_crit
      FROM (SELECT bcn.target_name as bcn_name, 
                   RAWTOHEX(bcn.target_guid) as bcn_guid,
                   bt.schedule as schedule, 
                   RAWTOHEX(ck.composite_key) as key
              FROM MGMT_METRICS_COMPOSITE_KEYS ck,
                   MGMT_BCN_TXN_DEFN tx,
                   MGMT_TARGETS tgt,
                   MGMT_TARGETS bcn,
                   MGMT_BCN_TARGET_TXN bt
             WHERE tgt.target_guid = v_tgt_guid
               AND tx.txn_guid = v_txn_guid
               AND bt.target_guid = v_tgt_guid
               AND bt.txn_guid = v_txn_guid
               AND bt.beacon_target_guid = bcn.target_guid
               AND ck.target_guid = v_tgt_guid
               AND ck.key_part1_value = tx.name
               AND ((bcn.target_guid = v_tgt_guid 
                     AND ck.key_part2_value = '-')
                   OR 
                    (bcn.target_guid <> v_tgt_guid 
                     AND ck.key_part2_value = bcn.target_name ))
               AND (ck.key_part3_value IS NULL
                    OR ck.key_part3_value = ' ')) t1, 
	       (SELECT warning_threshold, critical_threshold, key_value
	          FROM MGMT_ADMIN_METRIC_THRESHOLDS avg_th
	         WHERE avg_th.target_guid = v_tgt_guid
  	           AND avg_th.metric_guid = v_avg_mg
  	           AND avg_th.coll_name = txn_in) t2,
	       (SELECT warning_threshold, critical_threshold, key_value
	          FROM MGMT_ADMIN_METRIC_THRESHOLDS max_th
	         WHERE max_th.target_guid = v_tgt_guid
  	           AND max_th.metric_guid = v_max_mg
  	           AND max_th.coll_name = txn_in) t3
     WHERE t1.key=t2.key_value(+)
       AND t1.key=t3.key_value(+);

  SELECT name
    INTO txn_name
    FROM MGMT_BCN_TXN_DEFN
   WHERE txn_guid = v_txn_guid;

  result := p_bcn_success;

EXCEPTION

  WHEN OTHERS THEN    
    result := p_bcn_err_oraerr;
    err_desc := SUBSTR(SQLERRM, 1, p_err_maxlen);
    LOG_SYS_ERR(result, 'EMD_BCN_GET_COLL_DETAILS: db error: ' || err_desc);

END EMD_BCN_GET_COLL_DETAILS;
--------------------------------------------------------------------------

*/

--------------------------------------------------------------------------
PROCEDURE EMD_BCN_GET_BCN_HOME_PG_DATA( l_bcn_target_name IN VARCHAR2,
                                    l_bcn_target_type IN VARCHAR2,
                                    l_ping_table_data OUT p_cursor_type,
                                    l_url_table_data  OUT p_cursor_type,
                                    l_ping_txn_list   OUT p_cursor_type,
                                    l_url_txn_list    OUT p_cursor_type,
                                    l_ping_txn_sev_list   OUT p_cursor_type,
                                    l_url_txn_sev_list    OUT p_cursor_type,
                                    result OUT INTEGER,
                                    err_desc OUT VARCHAR2 )
IS

  v_tgt_guid      MGMT_TARGETS.target_guid%TYPE;

BEGIN

  
  IF l_bcn_target_name IS NULL OR l_bcn_target_type IS NULL THEN
    result := p_bcn_err_badparams;
    RETURN;
  END IF;

  result := HAS_TGT_FUNCTION_PRIV ( l_bcn_target_name, 
             l_bcn_target_type, p_view_mntr_reports, err_desc );
  IF result <> p_bcn_success THEN
    RETURN;
  END IF;

  SELECT target_guid
    INTO v_tgt_guid
    FROM MGMT_TARGETS
   WHERE target_name = l_bcn_target_name 
     AND target_type = l_bcn_target_type;

  -- REVISIT: This isn't the best way to pick out the URL and host name. 
  -- This procedure may need to go away in the future.

  OPEN l_ping_table_data FOR
    SELECT curr.value as curr_value,
    curr.collection_timestamp as curr_timestamp,
    txn.txn_guid as txn_guid,
    txn.name as txn_name,
    met.metric_column as metric_column,
    met.metric_name as metric_name,
    curr.key_value as curr_key_value,
    props.string_value as hostname,
    curr.string_value as str_value
    FROM
    mgmt_metrics_composite_keys key,
    mgmt_current_metrics curr,
    mgmt_bcn_txn_defn txn,
    mgmt_targets tgt,
    mgmt_metrics met,
    (
      SELECT cm.key_value, cm.collection_timestamp 
        FROM mgmt_current_metrics cm, mgmt_metrics mt, mgmt_targets tg
       WHERE tg.target_guid = v_tgt_guid
         AND mt.metric_name = 'ping'
         AND mt.metric_column = 'host_status' 
         AND tg.target_type = mt.target_type
         AND tg.type_meta_ver = mt.type_meta_ver
         AND (tg.category_prop_1 = mt.category_prop_1 OR mt.category_prop_1 = ' ')
         AND (tg.category_prop_2 = mt.category_prop_2 OR mt.category_prop_2 = ' ')
         AND (tg.category_prop_3 = mt.category_prop_3 OR mt.category_prop_3 = ' ')
         AND (tg.category_prop_4 = mt.category_prop_4 OR mt.category_prop_4 = ' ')
         AND (tg.category_prop_5 = mt.category_prop_5 OR mt.category_prop_5 = ' ')
         AND cm.target_guid = v_tgt_guid 
         AND cm.metric_guid = mt.metric_guid
    ) coll_txn,
    MGMT_BCN_TXN_PROPS props
    WHERE
    rawtohex(key.composite_key) = curr.key_value AND
    tgt.target_guid = v_tgt_guid AND
    txn.target_guid = v_tgt_guid AND
    txn.txn_type = p_ping_db_type AND
    key.target_guid = v_tgt_guid AND
    txn.name=key.key_part1_value AND
    key.key_part2_value= '-' AND
    props.txn_guid = txn.txn_guid AND
    props.name = 'targetHost' AND
    props.string_part = 0 AND
    curr.target_guid = v_tgt_guid AND
    curr.key_value = coll_txn.key_value AND
    curr.collection_timestamp = coll_txn.collection_timestamp AND
    met.metric_guid = curr.metric_guid AND
    met.metric_name = 'ping' AND
    met.target_type = l_bcn_target_type AND
    tgt.type_meta_ver = met.type_meta_ver AND
    (tgt.category_prop_1 = met.category_prop_1 OR met.category_prop_1 = ' ') AND
    (tgt.category_prop_2 = met.category_prop_2 OR met.category_prop_2 = ' ') AND
    (tgt.category_prop_3 = met.category_prop_3 OR met.category_prop_3 = ' ') AND
    (tgt.category_prop_4 = met.category_prop_4 OR met.category_prop_4 = ' ') AND
    (tgt.category_prop_5 = met.category_prop_5 OR met.category_prop_5 = ' ')
    ORDER BY
    txn.txn_guid;

  OPEN l_url_table_data FOR
    SELECT curr.value as curr_value,
    curr.collection_timestamp as curr_timestamp,
    txn.txn_guid as txn_guid,
    txn.name as txn_name,
    met.metric_column as metric_column,
    met.metric_name as metric_name,
    curr.key_value as curr_key_value,
    props.string_value as url,
    curr.string_value as str_value
    FROM
    mgmt_metrics_composite_keys key,
    mgmt_current_metrics curr,
    mgmt_bcn_txn_defn txn,
    mgmt_targets tgt,
    mgmt_metrics met,
    (
      SELECT cm.key_value, cm.collection_timestamp 
        FROM mgmt_current_metrics cm, mgmt_metrics mt, mgmt_targets tg
       WHERE tg.target_guid = v_tgt_guid
         AND mt.metric_name = 'http_response'
         AND mt.metric_column = 'status' 
         AND tg.target_type = mt.target_type
         AND tg.type_meta_ver = mt.type_meta_ver
         AND (tg.category_prop_1 = mt.category_prop_1 OR mt.category_prop_1 = ' ')
         AND (tg.category_prop_2 = mt.category_prop_2 OR mt.category_prop_2 = ' ')
         AND (tg.category_prop_3 = mt.category_prop_3 OR mt.category_prop_3 = ' ')
         AND (tg.category_prop_4 = mt.category_prop_4 OR mt.category_prop_4 = ' ')
         AND (tg.category_prop_5 = mt.category_prop_5 OR mt.category_prop_5 = ' ')
         AND cm.target_guid = v_tgt_guid 
         AND cm.metric_guid = mt.metric_guid
    ) coll_txn,
    MGMT_BCN_STEP_DEFN stp,
    MGMT_BCN_STEP_PROPS props
    WHERE
    RAWTOHEX(key.composite_key) = curr.key_value AND
    tgt.target_guid = v_tgt_guid AND
    txn.target_guid = v_tgt_guid AND
    txn.txn_type=p_http_db_type AND
    key.target_guid = v_tgt_guid AND
    txn.name=key.key_part1_value AND
    key.key_part2_value='-' AND
    curr.target_guid=v_tgt_guid AND
    curr.key_value=coll_txn.key_value AND
    curr.collection_timestamp = coll_txn.collection_timestamp AND
    met.metric_guid=curr.metric_guid AND
    met.metric_name = 'http_response' AND
    stp.txn_guid = txn.txn_guid AND
    stp.step = 1 AND
    props.step_guid = stp.step_guid AND
    props.name = 'url' AND
    props.string_part = 0 AND
    met.target_type = l_bcn_target_type AND
    tgt.type_meta_ver = met.type_meta_ver AND
    (tgt.category_prop_1 = met.category_prop_1 OR met.category_prop_1 = ' ') AND
    (tgt.category_prop_2 = met.category_prop_2 OR met.category_prop_2 = ' ') AND
    (tgt.category_prop_3 = met.category_prop_3 OR met.category_prop_3 = ' ') AND
    (tgt.category_prop_4 = met.category_prop_4 OR met.category_prop_4 = ' ') AND
    (tgt.category_prop_5 = met.category_prop_5 OR met.category_prop_5 = ' ')
    ORDER BY
    txn.txn_guid;

  OPEN l_ping_txn_list FOR
    SELECT txn.txn_guid as txn_guid,
    txn.name as txn_name,
    props.string_value as hostname,
    txn.state as txn_stat,
    key.composite_key as composite_key
    FROM
    mgmt_metrics_composite_keys key,
    mgmt_bcn_txn_defn txn,
    mgmt_targets tgt,
    MGMT_BCN_TXN_PROPS props
    WHERE
    tgt.target_guid = v_tgt_guid AND
    txn.target_guid = v_tgt_guid AND
    txn.txn_type=p_ping_db_type AND
    key.target_guid = v_tgt_guid AND
    txn.name=key.key_part1_value AND
    key.key_part2_value=l_bcn_target_name AND
    props.txn_guid = txn.txn_guid AND
    props.name = 'targetHost' AND
    props.string_part = 0
    ORDER BY txn.txn_guid;

  OPEN l_url_txn_list FOR
    SELECT txn.txn_guid as txn_guid,
    txn.name as txn_name,
    props.string_value as url,
    txn.state as txn_stat,
    key.composite_key as composite_key
    FROM
    mgmt_metrics_composite_keys key,
    mgmt_bcn_txn_defn txn,
    mgmt_targets tgt,
    MGMT_BCN_STEP_DEFN stp,
    MGMT_BCN_STEP_PROPS props
    WHERE
    tgt.target_guid = v_tgt_guid AND
    txn.target_guid = v_tgt_guid AND
    txn.txn_type=p_http_db_type AND
    key.target_guid = v_tgt_guid AND
    txn.name=key.key_part1_value AND
    key.key_part2_value='-' AND
    stp.txn_guid = txn.txn_guid AND
    stp.step = 1 AND
    props.step_guid = stp.step_guid AND
    props.name = 'url' AND
    props.string_part = 0
    ORDER BY txn.txn_guid;

  OPEN l_url_txn_sev_list FOR
    SELECT txn.txn_guid as txn_guid,
    tgt.target_guid as target_guid,
    sev.key_value as key_value,
    met.metric_guid as metric_guid,
    sev.severity_code as severity_code
    FROM
    mgmt_metrics_composite_keys key,
    mgmt_bcn_txn_defn txn,
    mgmt_targets tgt,
    mgmt_current_severity sev,
    mgmt_metrics met
    WHERE
    tgt.target_guid = v_tgt_guid AND
    txn.target_guid = v_tgt_guid AND
    sev.target_guid = v_tgt_guid AND
    key.target_guid = v_tgt_guid AND
    txn.txn_type=p_http_db_type AND
    txn.name=key.key_part1_value AND
    key.key_part2_value='-' AND
    rawtohex(key.composite_key) = sev.key_value AND
    met.metric_guid = sev.metric_guid AND
    met.metric_name = 'http_response' AND
    met.target_type = l_bcn_target_type AND
    tgt.type_meta_ver = met.type_meta_ver AND
    (tgt.category_prop_1 = met.category_prop_1 OR met.category_prop_1 = ' ') AND
    (tgt.category_prop_2 = met.category_prop_2 OR met.category_prop_2 = ' ') AND
    (tgt.category_prop_3 = met.category_prop_3 OR met.category_prop_3 = ' ') AND
    (tgt.category_prop_4 = met.category_prop_4 OR met.category_prop_4 = ' ') AND
    (tgt.category_prop_5 = met.category_prop_5 OR met.category_prop_5 = ' ')
    ORDER BY txn.txn_guid;

  OPEN l_ping_txn_sev_list FOR
    SELECT txn.txn_guid as txn_guid,
    tgt.target_guid as target_guid,
    sev.key_value as key_value,
    met.metric_guid as metric_guid,
    sev.severity_code as severity_code
    FROM
    mgmt_metrics_composite_keys key,
    mgmt_bcn_txn_defn txn,
    mgmt_targets tgt,
    mgmt_current_severity sev,
    mgmt_metrics met
    WHERE
    tgt.target_guid = v_tgt_guid AND
    txn.target_guid = v_tgt_guid AND
    sev.target_guid = v_tgt_guid AND
    key.target_guid = v_tgt_guid AND
    txn.txn_type=p_ping_db_type AND
    txn.name=key.key_part1_value AND
    key.key_part2_value='-' AND
    rawtohex(key.composite_key) = sev.key_value AND
    met.metric_guid=sev.metric_guid AND
    met.metric_name = 'ping' AND
    met.target_type = l_bcn_target_type AND
    tgt.type_meta_ver = met.type_meta_ver AND
    (tgt.category_prop_1 = met.category_prop_1 OR met.category_prop_1 = ' ') AND
    (tgt.category_prop_2 = met.category_prop_2 OR met.category_prop_2 = ' ') AND
    (tgt.category_prop_3 = met.category_prop_3 OR met.category_prop_3 = ' ') AND
    (tgt.category_prop_4 = met.category_prop_4 OR met.category_prop_4 = ' ') AND
    (tgt.category_prop_5 = met.category_prop_5 OR met.category_prop_5 = ' ')
    ORDER BY txn.txn_guid;
   
    result := p_bcn_success;
    RETURN;

EXCEPTION

  WHEN OTHERS THEN
    result := p_bcn_err_oraerr;
    err_desc := SUBSTR(SQLERRM, 1, p_err_maxlen);
    LOG_SYS_ERR(result, 'EMD_BCN_GET_BCN_HOME_PG_DATA: db error:' || err_desc);

END EMD_BCN_GET_BCN_HOME_PG_DATA;
--------------------------------------------------------------------------

--------------------------------------------------------------------------
-- EMD_BCN_GET_BCN_SYNC_STATUS
--
-- Returns the status of a beacon (in sync or not)
-- 
PROCEDURE EMD_BCN_GET_BCN_SYNC_STATUS ( l_bcn_guid    IN VARCHAR2,
                                        l_in_sync    OUT  INTEGER,
                                        result       OUT INTEGER,
                                        err_desc     OUT VARCHAR2 )
IS

  v_bcn_list       MGMT_BCN_SYNC_ARRAY;

BEGIN

  IF l_bcn_guid IS NULL THEN
    result := p_bcn_err_badparams;
    RETURN;
  END IF;

  EMD_BCN_SYNC_LIST(l_bcn_guid, v_bcn_list, result, err_desc);
  IF result <> p_bcn_success THEN
    RETURN;
  END IF;

  l_in_sync := 1;

  -- When the list is NULL the bcn is in sync too
  IF v_bcn_list IS NOT NULL THEN
    IF v_bcn_list(1).is_insync <> 'Y' THEN
      l_in_sync := 0;
    END IF;
    v_bcn_list.DELETE;
    v_bcn_list := NULL;
  END IF;

  result := p_bcn_success;
  RETURN;

EXCEPTION

  WHEN OTHERS THEN
    IF v_bcn_list IS NOT NULL THEN
      v_bcn_list.DELETE;
      v_bcn_list := NULL;
    END IF;
    result := p_bcn_err_oraerr;
    err_desc := SUBSTR(SQLERRM, 1, p_err_maxlen);
    LOG_SYS_ERR(result, 'EMD_BCN_GET_BCN_SYNC_STATUS: db error:' || err_desc);

END EMD_BCN_GET_BCN_SYNC_STATUS;
--------------------------------------------------------------------------

--------------------------------------------------------------------------
-- EMD_BCN_GET_BCN_HP_HOME_DATA
--
PROCEDURE EMD_BCN_GET_BCN_HP_HOME_DATA ( l_bcn_name IN  VARCHAR2,
                                         l_in_sync  OUT INTEGER,
                                         l_props    OUT p_cursor_type,
                                         result     OUT INTEGER,
                                         err_desc   OUT VARCHAR2 )
IS

  v_bcn_guid       mgmt_targets.target_guid%TYPE;
  v_bcn_id         mgmt_targets.target_name%TYPE;

BEGIN

  IF l_bcn_name IS NULL THEN
    result := p_bcn_err_badparams;
    RETURN;
  END IF;

  result := HAS_TGT_FUNCTION_PRIV(l_bcn_name, p_beacon_type,
                                    p_view_mntr_reports, err_desc);
  IF result <> p_bcn_success THEN
    RETURN;
  END IF;

  -- Guranteed to return something as we have priv on the target
  v_bcn_guid := mgmt_target.get_target_guid(l_bcn_name, p_beacon_type);
  v_bcn_id := RAWTOHEX(v_bcn_guid);

  EMD_BCN_GET_BCN_SYNC_STATUS(v_bcn_id, l_in_sync, result, err_desc);
  IF result <> p_bcn_success THEN
    RETURN;
  END IF;

  OPEN l_props FOR
    SELECT property_name, property_value
      FROM mgmt_target_properties prop, mgmt_targets tgt
      WHERE prop.target_guid = v_bcn_guid;

EXCEPTION
  WHEN OTHERS THEN
    IF l_props%ISOPEN THEN
      CLOSE l_props;
    END IF;
    result := p_bcn_err_oraerr;
    err_desc := SUBSTR(SQLERRM, 1, p_err_maxlen);
    LOG_SYS_ERR(result, 'EMD_BCN_GET_BCN_HP_HOME_DATA: db error:' || err_desc);
END EMD_BCN_GET_BCN_HP_HOME_DATA;

--------------------------------------------------------------------------

-- REVISIT: This procedure needs to go away. Keeping it to support the pre-REL2 UI.
--------------------------------------------------------------------------
-- EMD_BCN_GET_THRESH
-- 
PROCEDURE EMD_BCN_GET_THRESH ( l_target_name IN VARCHAR2,
                               l_target_type IN VARCHAR2,
                               l_bcn_name    IN VARCHAR2,
                               l_txn_name    IN VARCHAR2,
                               l_metric_name IN VARCHAR2,
                               l_metric_col  IN VARCHAR2,
                               l_warn_thresh OUT NUMBER,
                               l_crit_thresh OUT NUMBER,
                               result OUT INTEGER,
                               err_desc OUT VARCHAR2 )

IS
  v_bcn_name            mgmt_targets.target_name%TYPE;
  v_target_guid         mgmt_targets.target_guid%TYPE;
BEGIN

  IF l_target_name IS NULL OR l_target_type IS NULL THEN
    result := p_bcn_err_badparams;
    RETURN;
  END IF;

  result := HAS_TGT_FUNCTION_PRIV ( l_target_name,
             l_target_type, p_view_mntr_reports, err_desc );
  IF result <> p_bcn_success THEN
    RETURN;
  END IF;

  IF((l_bcn_name IS NULL) OR (l_target_name = l_bcn_name)) THEN
    v_bcn_name := '-';
  ELSE
    v_bcn_name := l_bcn_name;
  END IF;

  SELECT target_guid
    INTO v_target_guid
    FROM mgmt_targets
    WHERE target_name = l_target_name
      AND target_type = l_target_type;

  SELECT critical_threshold, warning_threshold
    INTO l_crit_thresh, l_warn_thresh
    FROM mgmt_admin_metric_thresholds thr,
      (
        SELECT composite_key
          FROM mgmt_metrics_composite_keys
          WHERE target_guid = v_target_guid
            AND key_part1_value = l_txn_name
            AND key_part2_value = v_bcn_name
      ) key,
      (
        SELECT mt.metric_guid
          FROM mgmt_metrics mt, mgmt_targets tg
         WHERE tg.target_guid = v_target_guid
           AND mt.metric_name = l_metric_name
           AND mt.metric_column = l_metric_col
           AND tg.target_type = mt.target_type
           AND tg.type_meta_ver = mt.type_meta_ver
           AND (tg.category_prop_1 = mt.category_prop_1 OR mt.category_prop_1 = ' ')
           AND (tg.category_prop_2 = mt.category_prop_2 OR mt.category_prop_2 = ' ')
           AND (tg.category_prop_3 = mt.category_prop_3 OR mt.category_prop_3 = ' ')
           AND (tg.category_prop_4 = mt.category_prop_4 OR mt.category_prop_4 = ' ')
           AND (tg.category_prop_5 = mt.category_prop_5 OR mt.category_prop_5 = ' ')
      ) met,
      (
        SELECT txn_guid
          FROM mgmt_bcn_txn_defn
          WHERE target_guid = v_target_guid
            AND name = l_txn_name
      ) txn
    WHERE thr.target_guid = v_target_guid
      AND thr.metric_guid = met.metric_guid
      AND thr.coll_name = txn.txn_guid
      AND thr.key_value = key.composite_key;

EXCEPTION
  WHEN NO_DATA_FOUND THEN
    l_warn_thresh := null;
    l_crit_thresh := null;

  WHEN OTHERS THEN
    result := p_bcn_err_oraerr;
    err_desc := SUBSTR(SQLERRM, 1, p_err_maxlen);
    LOG_SYS_ERR(result, 'EMD_BCN_GET_THRESH: db error:' || err_desc);

END EMD_BCN_GET_THRESH;

--------------------------------------------------------------------------

-- REVISIT: This procedure needs to go away. Keeping it to support the pre-REL2 UI.
--------------------------------------------------------------------------
-- EMD_BCN_GET_TXN_DATA
-- 
PROCEDURE EMD_BCN_GET_TXN_DATA( l_target_name IN VARCHAR2,
                                l_target_type IN VARCHAR2,
                                l_bcn_guid    IN VARCHAR2,
                                l_txn_guid    IN VARCHAR2,
                                l_metric_name IN VARCHAR2,
                                l_metric_col  IN VARCHAR2,
                                l_all         IN VARCHAR2,
                                l_period      IN VARCHAR2,
                                l_max_filter  IN NUMBER,
                                l_min_filter  IN NUMBER,
                                l_max_date    IN DATE,
                                l_min_date    IN DATE,
                                l_txn_name    OUT VARCHAR2,
                                l_bcn_name    OUT VARCHAR2,
                                l_warn_thresh OUT VARCHAR2,
                                l_crit_thresh OUT VARCHAR2,
                                l_chart_data  OUT p_cursor_type,
                                l_cur_tbl_dt  OUT p_cursor_type,
                                l_avg_tbl_dt  OUT p_cursor_type,
                                l_txn_list    OUT p_cursor_type,
                                l_bcn_list    OUT p_cursor_type,
                                l_result      OUT INTEGER,
                                l_err_desc    OUT VARCHAR2)
IS

  -- get the metric guid for a given metric column for a target type
  CURSOR v_metric_guid_cur(c_tgt_guid RAW,
                           c_metric_name VARCHAR2,
                           c_metric_col VARCHAR2) IS
    SELECT mt.metric_guid
      FROM mgmt_metrics mt, mgmt_targets tg
      WHERE tg.target_guid = c_tgt_guid
        AND mt.metric_name = c_metric_name
        AND mt.metric_column = c_metric_col
        AND tg.target_type = mt.target_type
        AND tg.type_meta_ver = mt.type_meta_ver
        AND (tg.category_prop_1 = mt.category_prop_1 OR mt.category_prop_1 = ' ')
        AND (tg.category_prop_2 = mt.category_prop_2 OR mt.category_prop_2 = ' ')
        AND (tg.category_prop_3 = mt.category_prop_3 OR mt.category_prop_3 = ' ')
        AND (tg.category_prop_4 = mt.category_prop_4 OR mt.category_prop_4 = ' ')
        AND (tg.category_prop_5 = mt.category_prop_5 OR mt.category_prop_5 = ' ');

  -- get the txn name
  CURSOR v_txn_name_cur(txn_guid_p RAW) IS
    SELECT name 
      FROM mgmt_bcn_txn_defn def
      WHERE def.txn_guid = txn_guid_p;

  -- get the bcn name
  CURSOR v_bcn_name_cur(bcn_guid RAW) IS
    SELECT target_name
      FROM mgmt_targets
      WHERE target_guid = bcn_guid;

  v_target_guid		mgmt_targets.target_guid%TYPE;
  v_metric_guid		mgmt_metrics.metric_guid%TYPE;
  v_txn_guid		mgmt_bcn_txn_defn.txn_guid%TYPE;
  v_bcn_guid		mgmt_targets.target_guid%TYPE;
  v_txn_name		mgmt_bcn_txn_defn.name%TYPE;
  v_bcn_name		mgmt_targets.target_name%TYPE;
  v_avail_bcn		VARCHAR2(1);
  v_all		        VARCHAR2(10);
  v_txn_type		mgmt_bcn_txn_defn.txn_type%TYPE;
  v_bcn_names		SMP_EMD_STRING_ARRAY;
  v_txn_names		SMP_EMD_STRING_ARRAY;
  v_met_col_array	SMP_EMD_STRING_ARRAY;
  v_composite_keys	MGMT_USER_GUID_ARRAY;
  v_key_component	NUMBER(2);
  v_period		NUMBER;
  v_tgt_cur_time	DATE;
  v_old_date      DATE;
  v_err_msg             VARCHAR2(2048);

  v_type_meta_ver    MGMT_TARGETS.type_meta_ver%TYPE;
  v_cat_prop_1       MGMT_TARGETS.category_prop_1%TYPE;
  v_cat_prop_2       MGMT_TARGETS.category_prop_2%TYPE;
  v_cat_prop_3       MGMT_TARGETS.category_prop_3%TYPE;
  v_cat_prop_4       MGMT_TARGETS.category_prop_4%TYPE;
  v_cat_prop_5       MGMT_TARGETS.category_prop_5%TYPE;

BEGIN
  IF ( ( l_target_name is null ) OR ( l_target_type is null ) ) THEN
    l_result := p_bcn_err_badparams; 
    RETURN;
  END IF;

  l_result := HAS_TGT_FUNCTION_PRIV ( l_target_name,
             l_target_type, p_view_mntr_reports, l_err_desc );
  IF l_result <> p_bcn_success THEN
    RETURN;
  END IF;


  IF ((l_target_name IS NULL) OR (l_target_type IS NULL) OR
     (l_period IS NULL) OR (l_metric_name IS NULL) OR 
     ((l_metric_name != p_met_name_http) AND 
     (l_metric_name != p_met_name_ping)) OR
     ((l_bcn_guid IS NULL) AND (l_txn_guid IS NULL))) THEN
    l_result := emd_bcntxn.p_bcn_err_badparams;
    l_err_desc := 'GET_TXN_DATA: Invalid input parameters.';
    LOG_SYS_ERR(l_result, l_err_desc);
    RETURN;
  END IF;

  IF((l_period != p_period_24_hours) AND (l_period != p_period_7_days) AND
    (l_period != p_period_31_days) AND (l_period != p_period_1_hour)) THEN
    l_result := emd_bcntxn.p_bcn_err_badparams;
    l_err_desc := 'GET_TXN_DATA: Invalid input parameters.';
    LOG_SYS_ERR(l_result, l_err_desc);
    RETURN;
  END IF;

  l_warn_thresh := null;
  l_crit_thresh := null;

  IF l_bcn_guid IS NOT NULL THEN
    v_bcn_guid := HEXTORAW(l_bcn_guid);
  ELSE
    v_bcn_guid := NULL;
  END IF;
 
  IF l_txn_guid IS NOT NULL THEN
    v_txn_guid := HEXTORAW(l_txn_guid);
  ELSE
    v_txn_guid := NULL;
  END IF;

  v_all      := l_all;

  -- get the bcn name (if we can)
  IF(v_bcn_guid IS NOT NULL) THEN
    OPEN v_bcn_name_cur(v_bcn_guid);
    FETCH v_bcn_name_cur INTO v_bcn_name;
    CLOSE v_bcn_name_cur;
    l_bcn_name := v_bcn_name;
  END IF;

  -- get the txn name (if we can)
  IF(v_txn_guid IS NOT NULL) THEN
    OPEN v_txn_name_cur(v_txn_guid);
    FETCH v_txn_name_cur INTO v_txn_name;
    CLOSE v_txn_name_cur;
    l_txn_name := v_txn_name;
  END IF;

  v_err_msg := '1(xg:' || l_txn_guid || ',xn:' || l_txn_name || ',xd:' || l_max_date || ',nd:' || l_min_date || ')';

  IF(v_all IS NULL) THEN
    v_all := ' ';
  END IF;

  -- get the txn type
  IF(l_metric_name = 'http_response') THEN
    v_txn_type := p_http_db_type;
  ELSE
    v_txn_type := p_ping_db_type;
  END IF;

  SELECT target_guid, type_meta_ver, category_prop_1, category_prop_2, 
         category_prop_3, category_prop_4, category_prop_5 
    INTO v_target_guid, v_type_meta_ver, v_cat_prop_1, v_cat_prop_2, 
         v_cat_prop_3, v_cat_prop_4, v_cat_prop_5
    FROM mgmt_targets
    WHERE target_name = l_target_name
      AND target_type = l_target_type;

  -- get the current time at the target's location
  v_tgt_cur_time := MGMT_TARGET.SYSDATE_TARGET(v_target_guid);

  IF(l_period = p_period_24_hours) THEN
    v_period := 1;
  ELSIF (l_period = p_period_1_hour) THEN
    v_period := 1/24;
  ELSIF (l_period = p_period_7_days) THEN
    v_period := 7;
  ELSE
    v_period := 31;
  END IF;

  -- get a very old date to use optimizing queries
  SELECT TO_DATE('01/01/1970', 'mm/dd/YYYY') INTO v_old_date
    FROM DUAL;

  v_err_msg := v_err_msg || ',2(tg:' || v_target_guid || ',tt:' || v_tgt_cur_time || ',pe:' || v_period || ')';

   IF ((v_all = p_bcn_all_beacons) OR (v_all = p_bcn_avail_beacons)) THEN

    IF(v_txn_name IS NULL) THEN
      l_result := emd_bcntxn.p_bcn_err_badparams;
      l_err_desc := '[GET_TXN_DATA] Invalid txn.';
      LOG_SYS_ERR(l_result, l_err_desc || ' [' || v_err_msg || ']');
      RETURN;
    END IF;

    IF (l_metric_col IS NULL) THEN
      l_result := emd_bcntxn.p_bcn_err_badparams;
      l_err_desc := '[GET_TXN_DATA] Invalid metric collumn.';
      LOG_SYS_ERR(l_result, l_err_desc || ' [' || v_err_msg || ']');
      RETURN;
    END IF;

    -- Get the metric guid
    OPEN v_metric_guid_cur(v_target_guid, l_metric_name, l_metric_col);
    FETCH v_metric_guid_cur INTO v_metric_guid;
    CLOSE v_metric_guid_cur;

    IF (v_all = p_bcn_avail_beacons) THEN
      v_avail_bcn := 'N';
    ELSE
      v_avail_bcn := '.';
    END IF;

    -- Get all chosen beacon 
    SELECT DECODE(tgt.target_name, l_target_name, '-', tgt.target_name)
      BULK COLLECT INTO v_bcn_names
      FROM mgmt_targets tgt, mgmt_bcn_target bcn
      WHERE bcn.target_guid = v_target_guid
        AND bcn.is_removing = 'N'
        AND bcn.participates_avail != v_avail_bcn
        AND tgt.target_guid = bcn.beacon_target_guid;

    IF (v_period <= 1) THEN

      OPEN l_chart_data FOR
        SELECT /*+ ordered */ data.time time, key.bcn_name bcn_name,
            ROUND(data.value, p_round_precision) val
          FROM 
            (
              SELECT composite_key, key_part2_value bcn_name
                FROM mgmt_metrics_composite_keys
                WHERE target_guid = v_target_guid
                  AND key_part1_value = v_txn_name
                  AND key_part2_value IN
                    (
                      SELECT * 
                        FROM TABLE(CAST(v_bcn_names AS SMP_EMD_STRING_ARRAY))
                    )
            ) key,
            (
              SELECT key_value, collection_timestamp time, value
                FROM mgmt_metrics_raw
                WHERE collection_timestamp > v_tgt_cur_time - v_period
                  AND target_guid = v_target_guid
                  AND metric_guid = v_metric_guid
                  AND (l_max_filter IS NULL OR value <= l_max_filter)
                  AND (value >= NVL(l_min_filter, 0))
                  AND (collection_timestamp >= NVL(l_min_date, v_old_date))
                  AND (collection_timestamp <= NVL(l_max_date, v_tgt_cur_time))
            ) data
          WHERE data.key_value = key.composite_key
          ORDER BY time, bcn_name;

      v_err_msg := v_err_msg || ',3';

      OPEN l_avg_tbl_dt FOR
        SELECT /*+ ordered */ l_txn_name, key.bcn_name bcn_name,
            met.metric_column metric_column,
            ROUND(AVG(data.value), p_round_precision) val
          FROM
            (
              SELECT mt.metric_column, mt.metric_guid
                FROM mgmt_metrics mt, mgmt_targets tg
                WHERE mt.metric_name = l_metric_name
                  AND tg.target_guid = v_target_guid
                  AND tg.target_type = mt.target_type
                  AND tg.type_meta_ver = mt.type_meta_ver
                  AND (tg.category_prop_1 = mt.category_prop_1 OR mt.category_prop_1 = ' ')
                  AND (tg.category_prop_2 = mt.category_prop_2 OR mt.category_prop_2 = ' ')
                  AND (tg.category_prop_3 = mt.category_prop_3 OR mt.category_prop_3 = ' ')
                  AND (tg.category_prop_4 = mt.category_prop_4 OR mt.category_prop_4 = ' ')
                  AND (tg.category_prop_5 = mt.category_prop_5 OR mt.category_prop_5 = ' ')
            ) met,
            (
              SELECT composite_key, key_part2_value bcn_name
                FROM mgmt_metrics_composite_keys
                WHERE target_guid = v_target_guid
                  AND key_part1_value = v_txn_name
                  AND key_part2_value IN
                    (
                      SELECT *
                        FROM TABLE(CAST(v_bcn_names AS SMP_EMD_STRING_ARRAY))
                    )
            ) key,
            (
              SELECT key_value, value, metric_guid
                FROM mgmt_metrics_raw
                WHERE collection_timestamp > v_tgt_cur_time - v_period
                  AND value IS NOT NULL
                  AND target_guid = v_target_guid
                  AND (l_max_filter IS NULL OR value <= l_max_filter)
                  AND (value >= NVL(l_min_filter, 0))
                  AND (collection_timestamp >= NVL(l_min_date, v_old_date))
                  AND (collection_timestamp <= NVL(l_max_date, v_tgt_cur_time))
            ) data
          WHERE data.key_value = key.composite_key
            AND data.metric_guid = met.metric_guid
          GROUP BY bcn_name, metric_column;

    ELSIF (v_period = 7) THEN

      OPEN l_chart_data FOR
        SELECT /*+ ordered */ data.time time, key.bcn_name bcn_name,
            ROUND(data.value, p_round_precision) val
          FROM 
            (
              SELECT composite_key, key_part2_value bcn_name
                FROM mgmt_metrics_composite_keys
                WHERE target_guid = v_target_guid
                  AND key_part1_value = v_txn_name
                  AND key_part2_value IN
                    (
                      SELECT * 
                        FROM TABLE(CAST(v_bcn_names AS SMP_EMD_STRING_ARRAY))
                    )
            ) key,
            (
              SELECT key_value, rollup_timestamp time, value_average value
                FROM mgmt_metrics_1hour
                WHERE rollup_timestamp > v_tgt_cur_time - 7
                  AND target_guid = v_target_guid
                  AND metric_guid = v_metric_guid
                  AND (l_max_filter IS NULL OR value_average <= l_max_filter)
                  AND (value_average >= NVL(l_min_filter, 0))
                  AND (rollup_timestamp >= NVL(l_min_date, v_old_date))
                  AND (rollup_timestamp <= NVL(l_max_date, v_tgt_cur_time))
            ) data
          WHERE data.key_value = key.composite_key
          ORDER BY time, bcn_name;

      v_err_msg := v_err_msg || ',3';

      OPEN l_avg_tbl_dt FOR
        SELECT /*+ ordered */ l_txn_name, key.bcn_name bcn_name,
            met.metric_column metric_column,
            ROUND(AVG(data.value), p_round_precision) val
          FROM
            (
              SELECT mt.metric_column, mt.metric_guid
                FROM mgmt_metrics mt, mgmt_targets tg
                WHERE mt.metric_name = l_metric_name
                  AND tg.target_guid = v_target_guid
                  AND tg.target_type = mt.target_type
                  AND tg.type_meta_ver = mt.type_meta_ver
                  AND (tg.category_prop_1 = mt.category_prop_1 OR mt.category_prop_1 = ' ')
                  AND (tg.category_prop_2 = mt.category_prop_2 OR mt.category_prop_2 = ' ')
                  AND (tg.category_prop_3 = mt.category_prop_3 OR mt.category_prop_3 = ' ')
                  AND (tg.category_prop_4 = mt.category_prop_4 OR mt.category_prop_4 = ' ')
                  AND (tg.category_prop_5 = mt.category_prop_5 OR mt.category_prop_5 = ' ')
            ) met,
            (
              SELECT composite_key, key_part2_value bcn_name
                FROM mgmt_metrics_composite_keys
                WHERE target_guid = v_target_guid
                  AND key_part1_value = v_txn_name
                  AND key_part2_value IN
                    (
                      SELECT *
                        FROM TABLE(CAST(v_bcn_names AS SMP_EMD_STRING_ARRAY))
                    )
            ) key,
            (
              SELECT key_value, value_average value, metric_guid
                FROM mgmt_metrics_1hour
                WHERE rollup_timestamp > v_tgt_cur_time - 7
                  AND target_guid = v_target_guid
                  AND (l_max_filter IS NULL OR value_average <= l_max_filter)
                  AND (value_average >= NVL(l_min_filter, 0))
                  AND (rollup_timestamp >= NVL(l_min_date, v_old_date))
                  AND (rollup_timestamp <= NVL(l_max_date, v_tgt_cur_time))
            ) data
          WHERE data.key_value = key.composite_key
            AND data.metric_guid = met.metric_guid
          GROUP BY bcn_name, metric_column;

    ELSIF (v_period = 31) THEN

      OPEN l_chart_data FOR
        SELECT /*+ ordered */ data.time time, key.bcn_name bcn_name,
            ROUND(data.value, p_round_precision) val
          FROM 
            (
              SELECT composite_key, key_part2_value bcn_name
                FROM mgmt_metrics_composite_keys
                WHERE target_guid = v_target_guid
                  AND key_part1_value = v_txn_name
                  AND key_part2_value IN
                    (
                      SELECT * 
                        FROM TABLE(CAST(v_bcn_names AS SMP_EMD_STRING_ARRAY))
                    )
            ) key,
            (
              SELECT key_value, rollup_timestamp time, value_average value
                FROM mgmt_metrics_1day
                WHERE rollup_timestamp > v_tgt_cur_time - 31
                  AND target_guid = v_target_guid
                  AND metric_guid = v_metric_guid
                  AND (l_max_filter IS NULL OR value_average <= l_max_filter)
                  AND (value_average >= NVL(l_min_filter, 0))
                  AND (rollup_timestamp >= NVL(l_min_date, v_old_date))
                  AND (rollup_timestamp <= NVL(l_max_date, v_tgt_cur_time))
            ) data
          WHERE data.key_value = key.composite_key
          ORDER BY time, bcn_name;

      v_err_msg := v_err_msg || ',3';

      OPEN l_avg_tbl_dt FOR
        SELECT /*+ ordered */ l_txn_name, key.bcn_name bcn_name,
            met.metric_column metric_column,
            ROUND(AVG(data.value), p_round_precision) val
          FROM
            (
              SELECT mt.metric_column, mt.metric_guid
                FROM mgmt_metrics mt, mgmt_targets tg
                WHERE mt.metric_name = l_metric_name
                  AND tg.target_guid = v_target_guid
                  AND tg.target_type = mt.target_type
                  AND tg.type_meta_ver = mt.type_meta_ver
                  AND (tg.category_prop_1 = mt.category_prop_1 OR mt.category_prop_1 = ' ')
                  AND (tg.category_prop_2 = mt.category_prop_2 OR mt.category_prop_2 = ' ')
                  AND (tg.category_prop_3 = mt.category_prop_3 OR mt.category_prop_3 = ' ')
                  AND (tg.category_prop_4 = mt.category_prop_4 OR mt.category_prop_4 = ' ')
                  AND (tg.category_prop_5 = mt.category_prop_5 OR mt.category_prop_5 = ' ')
            ) met,
            (
              SELECT composite_key, key_part2_value bcn_name
                FROM mgmt_metrics_composite_keys
                WHERE target_guid = v_target_guid
                  AND key_part1_value = v_txn_name
                  AND key_part2_value IN
                    (
                      SELECT *
                        FROM TABLE(CAST(v_bcn_names AS SMP_EMD_STRING_ARRAY))
                    )
            ) key,
            (
              SELECT key_value, value_average value, metric_guid
                FROM mgmt_metrics_1day
                WHERE rollup_timestamp > v_tgt_cur_time - 31
                  AND target_guid = v_target_guid
                  AND (l_max_filter IS NULL OR value_average <= l_max_filter)
                  AND (value_average >= NVL(l_min_filter, 0))
                  AND (rollup_timestamp >= NVL(l_min_date, v_old_date))
                  AND (rollup_timestamp <= NVL(l_max_date, v_tgt_cur_time))
            ) data
          WHERE data.key_value = key.composite_key
            AND data.metric_guid = met.metric_guid
          GROUP BY bcn_name, metric_column;

    ELSE

      l_result := emd_bcntxn.p_bcn_err_badparams;
      l_err_desc := '[GET_TXN_DATA] Invalid period.';
      LOG_SYS_ERR(l_result, l_err_desc || ' [' || v_err_msg || ']');
      RETURN;

    END IF;

    v_err_msg := v_err_msg || ',4';

    OPEN l_cur_tbl_dt FOR
      SELECT col_tm, v_txn_name, bcn_name, met_col,
          ROUND(val, p_round_precision), str_val
        FROM
          (
            SELECT col_tm, bcn_name, met_col, val, str_val,
                MAX(col_tm) OVER (PARTITION BY bcn_name) max_tm
              FROM
                (
                  SELECT dat.col_tm col_tm, key.bcn_name bcn_name, 
                      met.met_col met_col, dat.val val, dat.str_val str_val
                    FROM
                      (
                        SELECT collection_timestamp col_tm, value val,
                            string_value str_val, key_value key_val,
                            metric_guid met_guid
                          FROM mgmt_current_metrics
                          WHERE target_guid = v_target_guid
                      )dat,
                      (
                        SELECT mt.metric_guid met_guid, mt.metric_column met_col
                          FROM mgmt_metrics mt, mgmt_targets tg
                         WHERE tg.target_guid = v_target_guid
                           AND mt.metric_name = l_metric_name
                           AND tg.target_type = mt.target_type
                           AND tg.type_meta_ver = mt.type_meta_ver
                           AND (tg.category_prop_1 = mt.category_prop_1 OR mt.category_prop_1 = ' ')
                           AND (tg.category_prop_2 = mt.category_prop_2 OR mt.category_prop_2 = ' ')
                           AND (tg.category_prop_3 = mt.category_prop_3 OR mt.category_prop_3 = ' ')
                           AND (tg.category_prop_4 = mt.category_prop_4 OR mt.category_prop_4 = ' ')
                           AND (tg.category_prop_5 = mt.category_prop_5 OR mt.category_prop_5 = ' ')
                      ) met,
                      (
                        SELECT composite_key comp_key, key_part2_value bcn_name
                          FROM mgmt_metrics_composite_keys
                          WHERE target_guid = v_target_guid
                            AND key_part1_value = v_txn_name
                            AND key_part2_value IN
                              (
                                SELECT *
                                  FROM TABLE(CAST(v_bcn_names AS 
                                                  SMP_EMD_STRING_ARRAY))
                              )
                      ) key
                    WHERE dat.key_val = key.comp_key
                      AND dat.met_guid = met.met_guid
                )
          )
        WHERE max_tm = col_tm;

  ELSIF (p_bcn_all_transactions = v_all) THEN

    v_err_msg := v_err_msg || ',5';

    IF ((v_bcn_name IS NULL) AND (v_bcn_guid IS NULL)) THEN
      l_result := emd_bcntxn.p_bcn_err_badparams;
      l_err_desc := '[GET_TXN_DATA] Invalid beacon.';
      LOG_SYS_ERR(l_result, l_err_desc || ' [' || v_err_msg || ']');
      RETURN;
    END IF;

    IF(v_bcn_name = l_target_name) THEN
      v_bcn_name := '-';
    END IF;

    IF (l_metric_col IS NULL) THEN
      l_result := emd_bcntxn.p_bcn_err_badparams;
      l_err_desc := '[GET_TXN_DATA] Invalid metric collumn.';
      LOG_SYS_ERR(l_result, l_err_desc || ' [' || v_err_msg || ']');
      RETURN;
    END IF;

    -- Get the metric guid
    OPEN v_metric_guid_cur(v_target_guid, l_metric_name, l_metric_col);
    FETCH v_metric_guid_cur INTO v_metric_guid;
    CLOSE v_metric_guid_cur;

    -- Get the list of all txns of same type for this target
    SELECT UNIQUE def.name BULK COLLECT INTO v_txn_names
      FROM mgmt_bcn_txn_defn def
      WHERE def.txn_type = v_txn_type
        AND def.target_guid = v_target_guid;
    
    IF (v_period <= 1) THEN

      OPEN l_chart_data FOR
        SELECT /*+ ordered */ data.time, key.txn_name,
            ROUND(data.value, p_round_precision)
          FROM
            (
              SELECT composite_key, key_part1_value AS txn_name
                FROM mgmt_metrics_composite_keys
                WHERE target_guid = v_target_guid
                  AND key_part2_value = v_bcn_name
                  AND key_part1_value IN
                    (
                      SELECT *
                        FROM TABLE(CAST(v_txn_names AS SMP_EMD_STRING_ARRAY))
                    )
            ) key,
            (
              SELECT key_value, collection_timestamp time, value
                FROM mgmt_metrics_raw
                WHERE collection_timestamp > v_tgt_cur_time - v_period
                  AND target_guid = v_target_guid
                  AND metric_guid = v_metric_guid
                  AND (l_max_filter IS NULL OR value <= l_max_filter)
                  AND (value >= NVL(l_min_filter, 0))
                  AND (collection_timestamp >= NVL(l_min_date, v_old_date))
                  AND (collection_timestamp <= NVL(l_max_date, v_tgt_cur_time))
            ) data
          WHERE data.key_value = key.composite_key
          ORDER BY data.time, key.txn_name;
  
      v_err_msg := v_err_msg || ',6';
  
      OPEN l_avg_tbl_dt FOR
        SELECT /*+ ordered */ key.txn_name, l_bcn_name, met.metric_column,
            ROUND(AVG(data.value), p_round_precision)
          FROM
            (
              SELECT mt.metric_column, mt.metric_guid
                FROM mgmt_metrics mt, mgmt_targets tg
                WHERE mt.metric_name = l_metric_name
                  AND tg.target_guid = v_target_guid
                  AND tg.target_type = mt.target_type
                  AND tg.type_meta_ver = mt.type_meta_ver
                  AND (tg.category_prop_1 = mt.category_prop_1 OR mt.category_prop_1 = ' ')
                  AND (tg.category_prop_2 = mt.category_prop_2 OR mt.category_prop_2 = ' ')
                  AND (tg.category_prop_3 = mt.category_prop_3 OR mt.category_prop_3 = ' ')
                  AND (tg.category_prop_4 = mt.category_prop_4 OR mt.category_prop_4 = ' ')
                  AND (tg.category_prop_5 = mt.category_prop_5 OR mt.category_prop_5 = ' ')
            ) met,
            (
              SELECT composite_key, key_part1_value AS txn_name
                FROM mgmt_metrics_composite_keys
                WHERE target_guid = v_target_guid
                  AND key_part2_value = v_bcn_name
                  AND key_part1_value IN
                    (
                      SELECT *
                        FROM TABLE(CAST(v_txn_names AS SMP_EMD_STRING_ARRAY))
                    )
            ) key,
            (
              SELECT key_value, value, metric_guid
                FROM mgmt_metrics_raw
                WHERE collection_timestamp > v_tgt_cur_time - v_period
                  AND value IS NOT NULL
                  AND target_guid = v_target_guid
                  AND (l_max_filter IS NULL OR value <= l_max_filter)
                  AND (value >= NVL(l_min_filter, 0))
                  AND (collection_timestamp >= NVL(l_min_date, v_old_date))
                  AND (collection_timestamp <= NVL(l_max_date, v_tgt_cur_time))
            ) data
          WHERE data.key_value = key.composite_key
            AND met.metric_guid = data.metric_guid
          GROUP BY key.txn_name, metric_column;

    ELSIF (v_period = 7) THEN

      OPEN l_chart_data FOR
        SELECT /*+ ordered */ data.time, key.txn_name,
            ROUND(data.value, p_round_precision)
          FROM
            (
              SELECT composite_key, key_part1_value AS txn_name
                FROM mgmt_metrics_composite_keys
                WHERE target_guid = v_target_guid
                  AND key_part2_value = v_bcn_name
                  AND key_part1_value IN
                    (
                      SELECT *
                        FROM TABLE(CAST(v_txn_names AS SMP_EMD_STRING_ARRAY))
                    )
            ) key,
            (
              SELECT key_value, rollup_timestamp time, value_average value
                FROM mgmt_metrics_1hour
                WHERE rollup_timestamp > v_tgt_cur_time - 7
                  AND target_guid = v_target_guid
                  AND metric_guid = v_metric_guid
                  AND (l_max_filter IS NULL OR value_average <= l_max_filter)
                  AND (value_average >= NVL(l_min_filter, 0))
                  AND (rollup_timestamp >= NVL(l_min_date, v_old_date))
                  AND (rollup_timestamp <= NVL(l_max_date, v_tgt_cur_time))
            ) data
          WHERE data.key_value = key.composite_key
          ORDER BY data.time, key.txn_name;
  
      v_err_msg := v_err_msg || ',6';
  
      OPEN l_avg_tbl_dt FOR
        SELECT /*+ ordered */ key.txn_name, l_bcn_name, met.metric_column,
            ROUND(AVG(data.value), p_round_precision)
          FROM
            (
              SELECT mt.metric_column, mt.metric_guid
                FROM mgmt_metrics mt, mgmt_targets tg
                WHERE mt.metric_name = l_metric_name
                  AND tg.target_guid = v_target_guid
                  AND tg.target_type = mt.target_type
                  AND tg.type_meta_ver = mt.type_meta_ver
                  AND (tg.category_prop_1 = mt.category_prop_1 OR mt.category_prop_1 = ' ')
                  AND (tg.category_prop_2 = mt.category_prop_2 OR mt.category_prop_2 = ' ')
                  AND (tg.category_prop_3 = mt.category_prop_3 OR mt.category_prop_3 = ' ')
                  AND (tg.category_prop_4 = mt.category_prop_4 OR mt.category_prop_4 = ' ')
                  AND (tg.category_prop_5 = mt.category_prop_5 OR mt.category_prop_5 = ' ')
            ) met,
            (
              SELECT composite_key, key_part1_value AS txn_name
                FROM mgmt_metrics_composite_keys
                WHERE target_guid = v_target_guid
                  AND key_part2_value = v_bcn_name
                  AND key_part1_value IN
                    (
                      SELECT *
                        FROM TABLE(CAST(v_txn_names AS SMP_EMD_STRING_ARRAY))
                    )
            ) key,
            (
              SELECT key_value, value_average value, metric_guid
                FROM mgmt_metrics_1hour
                WHERE rollup_timestamp > v_tgt_cur_time - 7
                  AND target_guid = v_target_guid
                  AND (l_max_filter IS NULL OR value_average <= l_max_filter)
                  AND (value_average >= NVL(l_min_filter, 0))
                  AND (rollup_timestamp >= NVL(l_min_date, v_old_date))
                  AND (rollup_timestamp <= NVL(l_max_date, v_tgt_cur_time))
            ) data
          WHERE data.key_value = key.composite_key
            AND met.metric_guid = data.metric_guid
          GROUP BY key.txn_name, metric_column;

    ELSIF (v_period = 31) THEN

      OPEN l_chart_data FOR
        SELECT /*+ ordered */ data.time, key.txn_name,
            ROUND(data.value, p_round_precision)
          FROM
            (
              SELECT composite_key, key_part1_value AS txn_name
                FROM mgmt_metrics_composite_keys
                WHERE target_guid = v_target_guid
                  AND key_part2_value = v_bcn_name
                  AND key_part1_value IN
                    (
                      SELECT *
                        FROM TABLE(CAST(v_txn_names AS SMP_EMD_STRING_ARRAY))
                    )
            ) key,
            (
              SELECT key_value, rollup_timestamp time, value_average value
                FROM mgmt_metrics_1day
                WHERE rollup_timestamp > v_tgt_cur_time - 31
                  AND target_guid = v_target_guid
                  AND metric_guid = v_metric_guid
                  AND (l_max_filter IS NULL OR value_average <= l_max_filter)
                  AND (value_average >= NVL(l_min_filter, 0))
                  AND (rollup_timestamp >= NVL(l_min_date, v_old_date))
                  AND (rollup_timestamp <= NVL(l_max_date, v_tgt_cur_time))
            ) data
          WHERE data.key_value = key.composite_key
          ORDER BY data.time, key.txn_name;
  
      v_err_msg := v_err_msg || ',6';
  
      OPEN l_avg_tbl_dt FOR
        SELECT /*+ ordered */ key.txn_name, l_bcn_name, met.metric_column,
            ROUND(AVG(data.value), p_round_precision)
          FROM
            (
              SELECT mt.metric_column, mt.metric_guid
                FROM mgmt_metrics mt, mgmt_targets tg
                WHERE mt.metric_name = l_metric_name
                  AND tg.target_guid = v_target_guid
                  AND tg.target_type = mt.target_type
                  AND tg.type_meta_ver = mt.type_meta_ver
                  AND (tg.category_prop_1 = mt.category_prop_1 OR mt.category_prop_1 = ' ')
                  AND (tg.category_prop_2 = mt.category_prop_2 OR mt.category_prop_2 = ' ')
                  AND (tg.category_prop_3 = mt.category_prop_3 OR mt.category_prop_3 = ' ')
                  AND (tg.category_prop_4 = mt.category_prop_4 OR mt.category_prop_4 = ' ')
                  AND (tg.category_prop_5 = mt.category_prop_5 OR mt.category_prop_5 = ' ')
            ) met,
            (
              SELECT composite_key, key_part1_value AS txn_name
                FROM mgmt_metrics_composite_keys
                WHERE target_guid = v_target_guid
                  AND key_part2_value = v_bcn_name
                  AND key_part1_value IN
                    (
                      SELECT *
                        FROM TABLE(CAST(v_txn_names AS SMP_EMD_STRING_ARRAY))
                    )
            ) key,
            (
              SELECT key_value, value_average value, metric_guid
                FROM mgmt_metrics_1day
                WHERE rollup_timestamp > v_tgt_cur_time - 31
                  AND target_guid = v_target_guid
                  AND (l_max_filter IS NULL OR value_average <= l_max_filter)
                  AND (value_average >= NVL(l_min_filter, 0))
                  AND (rollup_timestamp >= NVL(l_min_date, v_old_date))
                  AND (rollup_timestamp <= NVL(l_max_date, v_tgt_cur_time))
            ) data
          WHERE data.key_value = key.composite_key
            AND met.metric_guid = data.metric_guid
          GROUP BY key.txn_name, metric_column;

    ELSE

      l_result := emd_bcntxn.p_bcn_err_badparams;
      l_err_desc := '[GET_TXN_DATA] Invalid period.';
      LOG_SYS_ERR(l_result, l_err_desc || ' [' || v_err_msg || ']');
      RETURN;

    END IF;

    v_err_msg := v_err_msg || ',7';

    OPEN l_cur_tbl_dt FOR
      SELECT col_tm, txn_name, v_bcn_name, met_col,
          ROUND(val, p_round_precision), str_val
        FROM
          (
            SELECT col_tm, txn_name, met_col, val, str_val,
                MAX(col_tm) OVER (PARTITION BY txn_name) max_tm
              FROM
                (
                  SELECT dat.col_tm col_tm, key.txn_name txn_name,
                      met.met_col met_col, dat.val val, dat.str_val str_val
                    FROM
                      (
                        SELECT collection_timestamp col_tm, value val,
                            string_value str_val, key_value key_val,
                            metric_guid met_guid
                          FROM mgmt_current_metrics
                          WHERE target_guid = v_target_guid
                      )dat,
                      (
                        SELECT mt.metric_guid met_guid, mt.metric_column met_col
                          FROM mgmt_metrics mt, mgmt_targets tg
                         WHERE tg.target_guid = v_target_guid
                           AND mt.metric_name = l_metric_name
                           AND tg.target_type = mt.target_type
                           AND tg.type_meta_ver = mt.type_meta_ver
                           AND (tg.category_prop_1 = mt.category_prop_1 OR mt.category_prop_1 = ' ')
                           AND (tg.category_prop_2 = mt.category_prop_2 OR mt.category_prop_2 = ' ')
                           AND (tg.category_prop_3 = mt.category_prop_3 OR mt.category_prop_3 = ' ')
                           AND (tg.category_prop_4 = mt.category_prop_4 OR mt.category_prop_4 = ' ')
                           AND (tg.category_prop_5 = mt.category_prop_5 OR mt.category_prop_5 = ' ')
                      ) met,
                      (
                        SELECT composite_key comp_key, key_part1_value txn_name
                          FROM mgmt_metrics_composite_keys
                          WHERE target_guid = v_target_guid
                            AND key_part2_value = v_bcn_name
                            AND key_part1_value IN
                              (
                                SELECT *
                                  FROM TABLE(CAST(v_txn_names AS 
                                                  SMP_EMD_STRING_ARRAY))
                              )
                      ) key
                    WHERE dat.key_val = key.comp_key
                      AND dat.met_guid = met.met_guid
                )
          )
        WHERE max_tm = col_tm;

  ELSE

    v_err_msg := v_err_msg || ',8';

    IF(v_bcn_name IS NULL) THEN
      l_result := emd_bcntxn.p_bcn_err_badparams;
      l_err_desc := '[GET_TXN_DATA] Invalid beacon.';
      LOG_SYS_ERR(l_result, l_err_desc || ' [' || v_err_msg || ']');
      RETURN;
    END IF;

    IF(v_txn_name IS NULL) THEN
      l_result := emd_bcntxn.p_bcn_err_badparams;
      l_err_desc := '[GET_TXN_DATA] Invalid txn.';
      LOG_SYS_ERR(l_result, l_err_desc || ' [' || v_err_msg || ']');
      RETURN;
    END IF;

    IF(v_bcn_name = l_target_name) THEN
      v_bcn_name := '-';
    END IF;

    v_bcn_names := SMP_EMD_STRING_ARRAY(v_bcn_name);
    v_err_msg := v_err_msg || ',9(b1:' || v_bcn_names(1) || ')';
    IF(v_all = p_bcn_all_metric_cols) THEN
      -- Set the metric column names according to metric
      IF(l_metric_name = 'http_response') THEN
        v_met_col_array := p_met_col_array_http_resp;
      ELSE
        v_met_col_array := p_met_col_array_ping;
      END IF;
    ELSIF(v_all = p_bcn_time_metric_cols) THEN
      IF(l_metric_name = 'http_response') THEN
        v_met_col_array := p_met_time_col_array_http_resp;
      ELSE
        l_result := emd_bcntxn.p_bcn_err_badparams;
        l_err_desc := '[GET_TXN_DATA] Cannot show all time metrics for a ' ||
                      'ping metric.';
        LOG_SYS_ERR(l_result, l_err_desc || ' [' || v_err_msg || ']');
        RETURN;
      END IF;
    ELSE    -- specific metric column
      v_err_msg := v_err_msg || ',10(mc:' || l_metric_col || ')';
      v_met_col_array := SMP_EMD_STRING_ARRAY(l_metric_col);
      IF(v_bcn_name != '-') THEN
        v_bcn_names.EXTEND();
        v_bcn_names(2) := '-';
        v_err_msg := v_err_msg || ',11(b2:' || v_bcn_names(2) || ')';
      END IF;

      emd_bcn_get_thresh(l_target_name,
                         l_target_type,
                         l_bcn_name,
                         l_txn_name,
                         l_metric_name,
                         l_metric_col,
                         l_warn_thresh,
                         l_crit_thresh,
                         l_result,
                         l_err_desc);

      v_err_msg := v_err_msg || ',12(wt:' || l_warn_thresh || ',ct:' || l_crit_thresh || ')';
      
    END IF;

    v_err_msg := v_err_msg || ',13(bc:' || v_bcn_names.COUNT || ',mc:' || v_met_col_array.COUNT  || ')';

    IF(v_met_col_array.COUNT > 1) THEN
      v_key_component := 1;  -- Keys are the metric names
    ELSIF(v_bcn_names.COUNT > 1) THEN
      v_key_component := 2;  -- Keys are the beacon names
    ELSE
      v_key_component := 3;  -- Key is the txn name
    END IF;

    IF (v_period <= 1) THEN

      OPEN l_chart_data FOR
        SELECT /*+ ordered */ data.time,
            DECODE(v_key_component, 1, met.column_label,
                   2, key.bcn_name, v_txn_name) key_col,
            ROUND(data.value, p_round_precision)
          FROM
            (
              SELECT mt.column_label, mt.metric_guid 
                FROM mgmt_metrics mt
                WHERE mt.metric_name = l_metric_name
                  AND mt.metric_column IN
                    (
                      SELECT *
                        FROM
                          TABLE(CAST(v_met_col_array AS SMP_EMD_STRING_ARRAY))
                    )
                  AND mt.target_type = l_target_type
                  AND mt.type_meta_ver = v_type_meta_ver
                  AND (mt.category_prop_1 = v_cat_prop_1 OR mt.category_prop_1 = ' ')
                  AND (mt.category_prop_2 = v_cat_prop_2 OR mt.category_prop_2 = ' ')
                  AND (mt.category_prop_3 = v_cat_prop_3 OR mt.category_prop_3 = ' ')
                  AND (mt.category_prop_4 = v_cat_prop_4 OR mt.category_prop_4 = ' ')
                  AND (mt.category_prop_5 = v_cat_prop_5 OR mt.category_prop_5 = ' ')
            ) met,
            (
              SELECT composite_key, key_part2_value bcn_name
                FROM mgmt_metrics_composite_keys
                WHERE target_guid = v_target_guid
                  AND key_part1_value = v_txn_name
                  AND key_part2_value IN
                    (
                      SELECT *
                        FROM TABLE(CAST(v_bcn_names AS SMP_EMD_STRING_ARRAY))
                    )
            ) key,
            (
              SELECT key_value, collection_timestamp time, value, metric_guid
                FROM mgmt_metrics_raw
                WHERE collection_timestamp > v_tgt_cur_time - v_period
                  AND target_guid = v_target_guid
                  AND (l_max_filter IS NULL OR value <= l_max_filter)
                  AND (value >= NVL(l_min_filter, 0))
                  AND (collection_timestamp >= NVL(l_min_date, v_old_date))
                  AND (collection_timestamp <= NVL(l_max_date, v_tgt_cur_time))
            ) data
          WHERE data.metric_guid = met.metric_guid
            AND key.composite_key = data.key_value
          ORDER BY data.time, key_col;
  
      OPEN l_avg_tbl_dt FOR
        SELECT /*+ ordered */ l_txn_name, key_col, metric_column,
           ROUND(AVG(value), p_round_precision)
          FROM
          (
            SELECT key.bcn_name key_col, met.metric_column metric_column,
                data.value value
              FROM
                (
                  SELECT mt.metric_column, mt.metric_guid
                    FROM mgmt_metrics mt, mgmt_targets tg
                   WHERE mt.metric_name = l_metric_name
                     AND tg.target_guid = v_target_guid
                     AND tg.target_type = mt.target_type
                     AND tg.type_meta_ver = mt.type_meta_ver
                     AND (tg.category_prop_1 = mt.category_prop_1 OR mt.category_prop_1 = ' ')
                     AND (tg.category_prop_2 = mt.category_prop_2 OR mt.category_prop_2 = ' ')
                     AND (tg.category_prop_3 = mt.category_prop_3 OR mt.category_prop_3 = ' ')
                     AND (tg.category_prop_4 = mt.category_prop_4 OR mt.category_prop_4 = ' ')
                     AND (tg.category_prop_5 = mt.category_prop_5 OR mt.category_prop_5 = ' ')
                ) met,
                (
                  SELECT composite_key, key_part2_value bcn_name
                    FROM mgmt_metrics_composite_keys
                    WHERE target_guid = v_target_guid
                      AND key_part1_value = v_txn_name
                      AND key_part2_value IN
                        (
                          SELECT *
                            FROM TABLE(CAST(v_bcn_names AS
                                            SMP_EMD_STRING_ARRAY))
                        )
                ) key,
                (
                  SELECT key_value, value, metric_guid
                    FROM mgmt_metrics_raw
                    WHERE collection_timestamp > v_tgt_cur_time - v_period
                      AND value IS NOT NULL
                      AND target_guid = v_target_guid
                      AND (l_max_filter IS NULL OR value <= l_max_filter)
                      AND (value >= NVL(l_min_filter, 0))
                      AND (collection_timestamp >= NVL(l_min_date, v_old_date))
                      AND (collection_timestamp <= NVL(l_max_date, v_tgt_cur_time))
                ) data
              WHERE data.metric_guid = met.metric_guid
                AND key.composite_key = data.key_value
          )
          GROUP BY key_col, metric_column;
  
    ELSIF (v_period = 7) THEN

      OPEN l_chart_data FOR
        SELECT /*+ ordered */ data.time,
            DECODE(v_key_component, 1, met.column_label,
                   2, key.bcn_name, v_txn_name) key_col,
            ROUND(data.value, p_round_precision)
          FROM
            (
              SELECT mt.column_label, mt.metric_guid 
                FROM mgmt_metrics mt
                WHERE mt.metric_name = l_metric_name
                  AND mt.metric_column IN
                    (
                      SELECT *
                        FROM
                          TABLE(CAST(v_met_col_array AS SMP_EMD_STRING_ARRAY))
                    )
                  AND mt.target_type = l_target_type
                  AND mt.type_meta_ver = v_type_meta_ver
                  AND (mt.category_prop_1 = v_cat_prop_1 OR mt.category_prop_1 = ' ')
                  AND (mt.category_prop_2 = v_cat_prop_2 OR mt.category_prop_2 = ' ')
                  AND (mt.category_prop_3 = v_cat_prop_3 OR mt.category_prop_3 = ' ')
                  AND (mt.category_prop_4 = v_cat_prop_4 OR mt.category_prop_4 = ' ')
                  AND (mt.category_prop_5 = v_cat_prop_5 OR mt.category_prop_5 = ' ')
            ) met,
            (
              SELECT composite_key, key_part2_value bcn_name
                FROM mgmt_metrics_composite_keys
                WHERE target_guid = v_target_guid
                  AND key_part1_value = v_txn_name
                  AND key_part2_value IN
                    (
                      SELECT *
                        FROM TABLE(CAST(v_bcn_names AS SMP_EMD_STRING_ARRAY))
                    )
            ) key,
            (
              SELECT key_value, rollup_timestamp time, value_average value,
                  metric_guid
                FROM mgmt_metrics_1hour
                WHERE rollup_timestamp > v_tgt_cur_time - 7
                  AND target_guid = v_target_guid
                  AND (l_max_filter IS NULL OR value_average <= l_max_filter)
                  AND (value_average >= NVL(l_min_filter, 0))
                  AND (rollup_timestamp >= NVL(l_min_date, v_old_date))
                  AND (rollup_timestamp <= NVL(l_max_date, v_tgt_cur_time))
            ) data
          WHERE data.metric_guid = met.metric_guid
            AND key.composite_key = data.key_value
          ORDER BY data.time, key_col;
  
      OPEN l_avg_tbl_dt FOR
        SELECT /*+ ordered */ l_txn_name, key_col, metric_column,
           ROUND(AVG(value), p_round_precision)
          FROM
          (
            SELECT key.bcn_name key_col, met.metric_column metric_column,
                data.value value
              FROM
                (
                  SELECT mt.metric_column, mt.metric_guid
                    FROM mgmt_metrics mt, mgmt_targets tg
                   WHERE mt.metric_name = l_metric_name
                     AND tg.target_guid = v_target_guid
                     AND tg.target_type = mt.target_type
                     AND tg.type_meta_ver = mt.type_meta_ver
                     AND (tg.category_prop_1 = mt.category_prop_1 OR mt.category_prop_1 = ' ')
                     AND (tg.category_prop_2 = mt.category_prop_2 OR mt.category_prop_2 = ' ')
                     AND (tg.category_prop_3 = mt.category_prop_3 OR mt.category_prop_3 = ' ')
                     AND (tg.category_prop_4 = mt.category_prop_4 OR mt.category_prop_4 = ' ')
                     AND (tg.category_prop_5 = mt.category_prop_5 OR mt.category_prop_5 = ' ')
                ) met,
                (
                  SELECT composite_key, key_part2_value bcn_name
                    FROM mgmt_metrics_composite_keys
                    WHERE target_guid = v_target_guid
                      AND key_part1_value = v_txn_name
                      AND key_part2_value IN
                        (
                          SELECT *
                            FROM TABLE(CAST(v_bcn_names AS
                                            SMP_EMD_STRING_ARRAY))
                        )
                ) key,
                (
                  SELECT key_value, value_average value, metric_guid
                    FROM mgmt_metrics_1hour
                    WHERE rollup_timestamp > v_tgt_cur_time - 7
                      AND target_guid = v_target_guid
                      AND (l_max_filter IS NULL OR value_average <= l_max_filter)
                      AND (value_average >= NVL(l_min_filter, 0))
                      AND (rollup_timestamp >= NVL(l_min_date, v_old_date))
                      AND (rollup_timestamp <= NVL(l_max_date, v_tgt_cur_time))
                ) data
              WHERE data.metric_guid = met.metric_guid
                AND key.composite_key = data.key_value
          )
          GROUP BY key_col, metric_column;

    ELSIF (v_period = 31) THEN

      OPEN l_chart_data FOR
        SELECT /*+ ordered */ data.time,
            DECODE(v_key_component, 1, met.column_label,
                   2, key.bcn_name, v_txn_name) key_col,
            ROUND(data.value, p_round_precision)
          FROM
            (
              SELECT mt.column_label, mt.metric_guid 
                FROM mgmt_metrics mt
                WHERE mt.metric_name = l_metric_name
                  AND mt.metric_column IN
                    (
                      SELECT *
                        FROM
                          TABLE(CAST(v_met_col_array AS SMP_EMD_STRING_ARRAY))
                    )
                  AND mt.target_type = l_target_type
                  AND mt.type_meta_ver = v_type_meta_ver
                  AND (mt.category_prop_1 = v_cat_prop_1 OR mt.category_prop_1 = ' ')
                  AND (mt.category_prop_2 = v_cat_prop_2 OR mt.category_prop_2 = ' ')
                  AND (mt.category_prop_3 = v_cat_prop_3 OR mt.category_prop_3 = ' ')
                  AND (mt.category_prop_4 = v_cat_prop_4 OR mt.category_prop_4 = ' ')
                  AND (mt.category_prop_5 = v_cat_prop_5 OR mt.category_prop_5 = ' ')
            ) met,
            (
              SELECT composite_key, key_part2_value bcn_name
                FROM mgmt_metrics_composite_keys
                WHERE target_guid = v_target_guid
                  AND key_part1_value = v_txn_name
                  AND key_part2_value IN
                    (
                      SELECT *
                        FROM TABLE(CAST(v_bcn_names AS SMP_EMD_STRING_ARRAY))
                    )
            ) key,
            (
              SELECT key_value, rollup_timestamp time, value_average value,
                  metric_guid
                FROM mgmt_metrics_1day
                WHERE rollup_timestamp > v_tgt_cur_time - 31
                  AND target_guid = v_target_guid
                  AND (l_max_filter IS NULL OR value_average <= l_max_filter)
                  AND (value_average >= NVL(l_min_filter, 0))
                  AND (rollup_timestamp >= NVL(l_min_date, v_old_date))
                  AND (rollup_timestamp <= NVL(l_max_date, v_tgt_cur_time))
            ) data
          WHERE data.metric_guid = met.metric_guid
            AND key.composite_key = data.key_value
          ORDER BY data.time, key_col;
  
      OPEN l_avg_tbl_dt FOR
        SELECT /*+ ordered */ l_txn_name, key_col, metric_column,
           ROUND(AVG(value), p_round_precision)
          FROM
          (
            SELECT key.bcn_name key_col, met.metric_column metric_column,
                data.value value
              FROM
                (
                  SELECT mt.metric_column, mt.metric_guid
                    FROM mgmt_metrics mt, mgmt_targets tg
                   WHERE mt.metric_name = l_metric_name
                     AND tg.target_guid = v_target_guid
                     AND tg.target_type = mt.target_type
                     AND tg.type_meta_ver = mt.type_meta_ver
                     AND (tg.category_prop_1 = mt.category_prop_1 OR mt.category_prop_1 = ' ')
                     AND (tg.category_prop_2 = mt.category_prop_2 OR mt.category_prop_2 = ' ')
                     AND (tg.category_prop_3 = mt.category_prop_3 OR mt.category_prop_3 = ' ')
                     AND (tg.category_prop_4 = mt.category_prop_4 OR mt.category_prop_4 = ' ')
                     AND (tg.category_prop_5 = mt.category_prop_5 OR mt.category_prop_5 = ' ')
                ) met,
                (
                  SELECT composite_key, key_part2_value bcn_name
                    FROM mgmt_metrics_composite_keys
                    WHERE target_guid = v_target_guid
                      AND key_part1_value = v_txn_name
                      AND key_part2_value IN
                        (
                          SELECT *
                            FROM TABLE(CAST(v_bcn_names AS
                                            SMP_EMD_STRING_ARRAY))
                        )
                ) key,
                (
                  SELECT key_value, value_average value, metric_guid
                    FROM mgmt_metrics_1day
                    WHERE rollup_timestamp > v_tgt_cur_time - 31
                      AND target_guid = v_target_guid
                      AND (l_max_filter IS NULL OR value_average <= l_max_filter)
                      AND (value_average >= NVL(l_min_filter, 0))
                      AND (rollup_timestamp >= NVL(l_min_date, v_old_date))
                      AND (rollup_timestamp <= NVL(l_max_date, v_tgt_cur_time))
                ) data
              WHERE data.metric_guid = met.metric_guid
                AND key.composite_key = data.key_value
          )
          GROUP BY key_col, metric_column;

    ELSE

      l_result := emd_bcntxn.p_bcn_err_badparams;
      l_err_desc := '[GET_TXN_DATA] Invalid period.';
      LOG_SYS_ERR(l_result, l_err_desc || ' [' || v_err_msg || ']');
      RETURN;

    END IF;

    -- get table data for 1 bcn (plus local), 1 txn, all metric columns

    OPEN l_cur_tbl_dt FOR
      SELECT col_tm, v_txn_name, bcn_name, met_col,
          ROUND(val, p_round_precision), str_val
        FROM
          (
            SELECT bcn_name, col_tm, met_col, val, str_val,
                MAX(col_tm) OVER (PARTITION BY key_val) max_tm
              FROM
                (
                  SELECT dat.col_tm col_tm, met.met_col met_col, key_val,
                      dat.val val, dat.str_val str_val, key.bcn_name bcn_name
                    FROM
                      (
                        SELECT collection_timestamp col_tm, value val,
                            string_value str_val, key_value key_val,
                            metric_guid met_guid
                          FROM mgmt_current_metrics
                          WHERE target_guid = v_target_guid
                      ) dat,
                      (
                        SELECT mt.metric_guid met_guid, mt.metric_column met_col
                          FROM mgmt_metrics mt, mgmt_targets tg
                         WHERE tg.target_guid = v_target_guid
                           AND mt.metric_name = l_metric_name
                           AND tg.target_type = mt.target_type
                           AND tg.type_meta_ver = mt.type_meta_ver
                           AND (tg.category_prop_1 = mt.category_prop_1 OR mt.category_prop_1 = ' ')
                           AND (tg.category_prop_2 = mt.category_prop_2 OR mt.category_prop_2 = ' ')
                           AND (tg.category_prop_3 = mt.category_prop_3 OR mt.category_prop_3 = ' ')
                           AND (tg.category_prop_4 = mt.category_prop_4 OR mt.category_prop_4 = ' ')
                           AND (tg.category_prop_5 = mt.category_prop_5 OR mt.category_prop_5 = ' ')
                      ) met,
                      (
                        SELECT composite_key, key_part2_value bcn_name
                          FROM mgmt_metrics_composite_keys
                          WHERE target_guid = v_target_guid
                            AND key_part1_value = v_txn_name
                            AND key_part2_value IN
                              (
                                SELECT *
                                  FROM TABLE(CAST(v_bcn_names AS
                                                  SMP_EMD_STRING_ARRAY))
                              )
                      ) key
                    WHERE dat.met_guid = met.met_guid
                      AND key.composite_key = dat.key_val
                )
          )
        WHERE max_tm = col_tm;

  END IF;

  -- get the txn list
  OPEN l_txn_list FOR
    SELECT UNIQUE def.name, def.txn_guid, def.is_representative
      FROM mgmt_bcn_txn_defn def
      WHERE def.txn_type = v_txn_type
        AND def.target_guid = v_target_guid;

  -- get the bcn list
  OPEN l_bcn_list FOR
    SELECT tgt.target_name, tgt.target_guid, 
        DECODE(bcn.beacon_target_guid, bcn.target_guid, 'W', 'B')
      FROM
        (
          SELECT beacon_target_guid, participates_avail, target_guid
            FROM mgmt_bcn_target
            WHERE target_guid = v_target_guid
              AND is_removing = 'N'
        ) bcn,
        mgmt_targets tgt
      WHERE tgt.target_guid = bcn.beacon_target_guid;

EXCEPTION

  WHEN OTHERS THEN
    l_result := emd_bcntxn.p_bcn_err_oraerr;
    l_err_desc := SUBSTR(SQLERRM, 1, emd_bcntxn.p_err_maxlen);
    LOG_SYS_ERR(l_result, 'EMD_BCN_GET_TXN_DATA: db error: ' || l_err_desc || ' [' || v_err_msg || ']');

END EMD_BCN_GET_TXN_DATA;
--------------------------------------------------------------------------

--------------------------------------------------------------------------
-- EMD_BCN_GET_TXN_CURRENT_DATA
--
PROCEDURE EMD_BCN_GET_TXN_CURRENT_DATA( l_target_name IN VARCHAR2,
                                        l_target_type IN VARCHAR2,
                                        l_metric_name IN VARCHAR2,
                                        l_txn_guid    IN RAW,
                                        l_time_period IN NUMBER,
                                        l_table_data  OUT p_cursor_type,
                                        l_sev_list    OUT p_cursor_type,
                                        l_result      OUT INTEGER,
                                        l_err_desc    OUT VARCHAR2 )
IS
  v_target_guid     mgmt_targets.target_guid%TYPE;
  v_txn_name        mgmt_bcn_txn_defn.name%TYPE;
  v_current_time    DATE;
  v_time_period     NUMBER;
  v_err_msg         VARCHAR2(2048);

BEGIN
  IF ( ( l_target_name is null ) OR ( l_target_type is null ) ) THEN
    l_result := p_bcn_err_badparams; 
    RETURN;
  END IF;

  l_result := HAS_TGT_FUNCTION_PRIV ( l_target_name,
             l_target_type, p_view_mntr_reports, l_err_desc );
  IF l_result <> p_bcn_success THEN
    RETURN;
  END IF;


  IF ((l_target_name IS NULL) OR (l_target_type IS NULL) OR
     (l_txn_guid IS NULL) OR (l_metric_name IS NULL) OR 
     (l_time_period IS NULL) ) THEN
    l_result := emd_bcntxn.p_bcn_err_badparams;
    l_err_desc := 'GET_TXN_CURRENT_DATA: Invalid input parmaters.';
    LOG_SYS_ERR(l_result, l_err_desc);
    RETURN;
  END IF;

  -- get the target guid
  SELECT target_guid INTO v_target_guid
    FROM mgmt_targets
    WHERE target_name = l_target_name
      AND target_type = l_target_type;

  -- get the txn name
  SELECT name INTO v_txn_name
    FROM mgmt_bcn_txn_defn
    WHERE txn_guid = l_txn_guid;

  -- convert l_time_period from minutes to "Oracle minutes"
  v_time_period := l_time_period / (24 * 60);

  -- get the current time at the target's location
  v_current_time := MGMT_TARGET.SYSDATE_TARGET(v_target_guid);

  v_err_msg := '1(pe:' || v_time_period || ',ct:' || v_current_time || ')';

  -- get table data for avail all bcns, 1 txn, all metric columns
  OPEN l_table_data FOR
    WITH bcn_names AS
    (
      SELECT DECODE(tgt.target_name, l_target_name, '-', tgt.target_name)
           bcn_name, tgt.target_name bcn_name_rl,
           DECODE(tgt.target_name, l_target_name, 0, 1) is_bcn
        FROM mgmt_targets tgt, mgmt_bcn_target bcn
        WHERE bcn.target_guid = v_target_guid
          AND bcn.beacon_target_guid = tgt.target_guid
          AND
          (
            (bcn.is_removing = 'N' AND bcn.participates_avail = 'Y')
            OR
            bcn.target_guid = bcn.beacon_target_guid
          )
    ),
    key AS
    (
      SELECT rawtohex(ckey.composite_key) comp_key, bcn.is_bcn, bcn.bcn_name_rl bcn_name
        FROM mgmt_metrics_composite_keys ckey, bcn_names bcn
        WHERE ckey.target_guid = v_target_guid
          AND ckey.key_part1_value = v_txn_name
          AND ckey.key_part2_value = bcn.bcn_name
    )
    SELECT k.bcn_name, k.comp_key, x.col_tm, k.is_bcn, x.met_col, x.val, x.str_val, x.is_old
      FROM
      (
        SELECT bcn_name, key_val, col_tm, is_bcn, met_col, val, str_val, is_old
          FROM
          (
            SELECT bcn_name, key_val, col_tm, is_bcn, met_col, val, str_val, is_old,
                MAX(col_tm) OVER (PARTITION BY key_val) max_tm
              FROM
              (
                SELECT key.bcn_name bcn_name, NVL(dat.col_tm, SYSDATE) col_tm,
                    key.is_bcn is_bcn, met.met_col met_col, NVL(dat.val, 0) val,
                    dat.str_val str_val,
                    (CASE WHEN v_current_time - v_time_period > col_tm
                          THEN 'Y' ELSE 'N' END) is_old,
                    dat.key_val key_val
                  FROM
                    (
                      SELECT collection_timestamp col_tm, value val,
                          string_value str_val, target_guid tgt_guid,
                          key_value key_val, metric_guid met_guid
                        FROM mgmt_current_metrics
                        WHERE target_guid = v_target_guid
                    ) dat,
                    (
                      SELECT mt.metric_guid met_guid, mt.metric_column met_col
                        FROM mgmt_metrics mt, mgmt_targets tg
                       WHERE tg.target_guid = v_target_guid
                         AND mt.metric_name = l_metric_name
                         AND tg.target_type = mt.target_type
                         AND tg.type_meta_ver = mt.type_meta_ver
                         AND (tg.category_prop_1 = mt.category_prop_1 OR mt.category_prop_1 = ' ')
                         AND (tg.category_prop_2 = mt.category_prop_2 OR mt.category_prop_2 = ' ')
                         AND (tg.category_prop_3 = mt.category_prop_3 OR mt.category_prop_3 = ' ')
                         AND (tg.category_prop_4 = mt.category_prop_4 OR mt.category_prop_4 = ' ')
                         AND (tg.category_prop_5 = mt.category_prop_5 OR mt.category_prop_5 = ' ')
                    ) met,
                    key 
                  WHERE dat.key_val = key.comp_key
                    AND met.met_guid = dat.met_guid
                    
               )
        )
        WHERE max_tm = col_tm
      ) x,
        key k
      WHERE
        x.bcn_name (+) = k.bcn_name;

  v_err_msg := v_err_msg || ',2';

  OPEN l_sev_list FOR
    WITH bcn_names AS
    (
      SELECT DECODE(tgt.target_name, l_target_name, '-', tgt.target_name)
           bcn_name, tgt.target_name bcn_name_rl,
           DECODE(tgt.target_name, l_target_name, 0, 1) is_bcn
        FROM mgmt_targets tgt, mgmt_bcn_target bcn
        WHERE bcn.target_guid = v_target_guid
          AND bcn.beacon_target_guid = tgt.target_guid
          AND
          (
            (bcn.is_removing = 'N' AND bcn.participates_avail = 'Y')
            OR
            bcn.target_guid = bcn.beacon_target_guid
          )
    ),
    key AS
    (
      SELECT ckey.composite_key comp_key, bcn.is_bcn, bcn.bcn_name_rl bcn_name
        FROM mgmt_metrics_composite_keys ckey, bcn_names bcn
        WHERE ckey.target_guid = v_target_guid
          AND ckey.key_part1_value = v_txn_name
          AND ckey.key_part2_value = bcn.bcn_name
    )
    SELECT bcn_name, is_bcn, sev_code 
      FROM
      (
        SELECT key.bcn_name bcn_name, key.is_bcn is_bcn, currsev.sev_code sev_code 
          FROM
          (
            SELECT mt.metric_guid met_guid, mt.metric_column met_col
              FROM mgmt_metrics mt, mgmt_targets tg
             WHERE tg.target_guid = v_target_guid
               AND mt.metric_name = l_metric_name
               AND tg.target_type = mt.target_type
               AND tg.type_meta_ver = mt.type_meta_ver
               AND (tg.category_prop_1 = mt.category_prop_1 OR mt.category_prop_1 = ' ')
               AND (tg.category_prop_2 = mt.category_prop_2 OR mt.category_prop_2 = ' ')
               AND (tg.category_prop_3 = mt.category_prop_3 OR mt.category_prop_3 = ' ')
               AND (tg.category_prop_4 = mt.category_prop_4 OR mt.category_prop_4 = ' ')
               AND (tg.category_prop_5 = mt.category_prop_5 OR mt.category_prop_5 = ' ')
          ) met,
          (
            SELECT severity_code sev_code,key_value key_val, metric_guid met_guid
              FROM mgmt_current_severity 
              WHERE target_guid = v_target_guid
          )currsev,
          key 
          WHERE currsev.met_guid = met.met_guid 
          AND currsev.key_val = key.comp_key
      );

EXCEPTION

  WHEN OTHERS THEN
    IF l_table_data%ISOPEN THEN
      CLOSE l_table_data;
    END IF;
    IF l_sev_list%ISOPEN THEN
      CLOSE l_sev_list;
    END IF;
    l_result := emd_bcntxn.p_bcn_err_oraerr;
    l_err_desc := SUBSTR(SQLERRM, 1, emd_bcntxn.p_err_maxlen);
    LOG_SYS_ERR(l_result, 'EMD_BCN_GET_TXN_CURRENT_DATA: db error: ' || l_err_desc || ' [' || v_err_msg || ']');

END EMD_BCN_GET_TXN_CURRENT_DATA;
--------------------------------------------------------------------------

--------------------------------------------------------------------------
-- EMD_BCN_GET_HP_DATA
--
PROCEDURE EMD_BCN_GET_WEBSITE_HP_DATA ( l_target_name IN VARCHAR2,
                                        l_target_type IN VARCHAR2,
                                        l_time_period IN NUMBER,
                                        l_txn_guid    OUT VARCHAR2,
                                        l_txn_name    OUT VARCHAR2,
                                        l_tgt_tz      OUT NUMBER,
                                        l_table_data  OUT p_cursor_type,
                                        l_sev_data    OUT p_cursor_type, 
                                        l_chart_data  OUT p_cursor_type,
                                        l_result      OUT INTEGER,
                                        l_err_desc    OUT VARCHAR2 )
IS
  -- get the metric guid for a given metric column for a target type
  CURSOR v_metric_guid_cur(c_tgt_guid RAW,
                           c_metric_name VARCHAR2,
                           c_metric_col VARCHAR2) IS
    SELECT mt.metric_guid
      FROM mgmt_metrics mt, mgmt_targets tg
      WHERE tg.target_guid = c_tgt_guid
        AND mt.metric_name = c_metric_name
        AND mt.metric_column = c_metric_col
        AND tg.target_type = mt.target_type
        AND tg.type_meta_ver = mt.type_meta_ver
        AND (tg.category_prop_1 = mt.category_prop_1 OR mt.category_prop_1 = ' ')
        AND (tg.category_prop_2 = mt.category_prop_2 OR mt.category_prop_2 = ' ')
        AND (tg.category_prop_3 = mt.category_prop_3 OR mt.category_prop_3 = ' ')
        AND (tg.category_prop_4 = mt.category_prop_4 OR mt.category_prop_4 = ' ')
        AND (tg.category_prop_5 = mt.category_prop_5 OR mt.category_prop_5 = ' ');

  v_target_guid         mgmt_targets.target_guid%TYPE;
  v_metric_guid         mgmt_metrics.metric_guid%TYPE;
  v_txn_guid            mgmt_bcn_txn_defn.txn_guid%TYPE;
--  v_txn_name            mgmt_bcn_txn_defn.name%TYPE;
  v_bcn_names           SMP_EMD_STRING_ARRAY;
  v_err_msg             VARCHAR2(2048);

BEGIN
  IF ( ( l_target_name is null ) OR ( l_target_type is null ) ) THEN
    l_result := p_bcn_err_badparams;
    RETURN;
  END IF;

  l_result := HAS_TGT_FUNCTION_PRIV ( l_target_name,
             l_target_type, p_view_mntr_reports, l_err_desc );
  IF l_result <> p_bcn_success THEN
    RETURN;
  END IF;


  IF ((l_target_name IS NULL) OR (l_target_type IS NULL) OR
     (l_time_period IS NULL)) THEN
    l_result := emd_bcntxn.p_bcn_err_badparams;
    l_err_desc := '[GET_WEBSITE_HP_DATA] Invalid input parmaters.';
    LOG_SYS_ERR(l_result, l_err_desc);
    RETURN;
  END IF;

  -- get the target guid and tz
  SELECT target_guid, timezone_delta INTO v_target_guid, l_tgt_tz
    FROM mgmt_targets
    WHERE target_name = l_target_name
      AND target_type = l_target_type;

  -- get the txn guid and name for the rep txn
  BEGIN
    SELECT txn_guid, name INTO v_txn_guid, l_txn_name
      FROM mgmt_bcn_txn_defn
      WHERE target_guid = v_target_guid
        AND is_representative = 'Y';
  EXCEPTION 
    WHEN NO_DATA_FOUND THEN
      l_result := emd_bcntxn.p_bcn_err_txnnotfound;
      l_err_desc := 'GET_TXN_DATA: Invalid txn.';
      RETURN;
  END;

  l_txn_guid := RAWTOHEX(v_txn_guid); 

  v_err_msg := '1(xg:' || l_txn_guid || ',xn:' || l_txn_name || ')';

  IF(l_txn_name IS NULL) THEN
    l_result := emd_bcntxn.p_bcn_err_badparams;
    l_err_desc := 'GET_TXN_DATA: Invalid txn.';
    LOG_SYS_ERR(l_result, l_err_desc || ' [' || v_err_msg || ']');
    RETURN;
  END IF;

  -- Get all availability beacons + local instance
  SELECT DECODE(tgt.target_name, l_target_name, '-', tgt.target_name)
    BULK COLLECT INTO v_bcn_names
    FROM mgmt_targets tgt, mgmt_bcn_target bcn
    WHERE bcn.target_guid = v_target_guid
      AND bcn.beacon_target_guid = tgt.target_guid
      AND 
        (
          (bcn.is_removing = 'N'
           AND bcn.participates_avail = 'Y')
          OR
          bcn.target_guid = bcn.beacon_target_guid
        );

  v_err_msg := v_err_msg || ',2(bc:' || v_bcn_names.COUNT || ')';

  -- get the current values (table data)
  emd_bcn_get_txn_current_data(l_target_name,
                               l_target_type,
                               p_met_name_http,
                               v_txn_guid,
                               l_time_period,
                               l_table_data,
                               l_sev_data,
                               l_result,
                               l_err_desc);

  -- Get the metric guid
  OPEN v_metric_guid_cur(v_target_guid, p_met_name_http, 
                         p_met_col_avg_resp_time);
  FETCH v_metric_guid_cur INTO v_metric_guid;
  CLOSE v_metric_guid_cur;

  OPEN l_chart_data FOR
    SELECT data.collection_timestamp time, key.bcn_name bcn_name,
        ROUND(data.value, p_round_precision) val
      FROM 
        (
          SELECT key_value, collection_timestamp, value
            FROM mgmt_metrics_raw
            WHERE collection_timestamp > SYSDATE - 1
              AND target_guid = v_target_guid
              AND metric_guid = v_metric_guid
        ) data,
        (
          SELECT composite_key,
              DECODE(key_part2_value, '-', l_target_name, key_part2_value)
              AS bcn_name
            FROM mgmt_metrics_composite_keys
            WHERE target_guid = v_target_guid
              AND key_part1_value = l_txn_name
              AND key_part2_value IN
                (
                  SELECT * 
                    FROM TABLE(CAST(v_bcn_names AS SMP_EMD_STRING_ARRAY))
                )
        ) key
      WHERE data.key_value = key.composite_key
      ORDER BY time, bcn_name;

EXCEPTION

  WHEN OTHERS THEN
    l_result := emd_bcntxn.p_bcn_err_oraerr;
    l_err_desc := SUBSTR(SQLERRM, 1, emd_bcntxn.p_err_maxlen);
    LOG_SYS_ERR(l_result, 'EMD_BCN_GET_WEBSITE_HP_DATA: db error: ' || l_err_desc || ' [' || v_err_msg || ']');
    IF l_table_data%ISOPEN THEN
      CLOSE l_table_data;
    END IF;
    IF l_sev_data%ISOPEN THEN
      CLOSE l_sev_data;
    END IF;
    IF l_chart_data%ISOPEN THEN
      CLOSE l_chart_data;
    END IF;

END EMD_BCN_GET_WEBSITE_HP_DATA;
--------------------------------------------------------------------------

--------------------------------------------------------------------------
-- EMD_BCN_GET_BCN_WEBSITES
--
PROCEDURE EMD_BCN_GET_BCN_WEBSITES ( l_bcn_target_name IN VARCHAR2,
                                     l_bcn_target_type IN VARCHAR2,
                                     l_allowed_websites OUT p_cursor_type,
                                     l_websites_data   OUT p_cursor_type,
                                     result OUT INTEGER,
                                     err_desc OUT VARCHAR2  )
IS
  v_err_msg             VARCHAR2(2048);
  l_current_user VARCHAR2(256) := MGMT_USER.get_current_em_user();
  v_bcn_guid            MGMT_TARGETS.TARGET_GUID%TYPE;
BEGIN
  IF ( ( l_bcn_target_name is null ) OR ( l_bcn_target_type is null ) ) THEN
    result := p_bcn_err_badparams;
    RETURN;
  END IF;

  result := HAS_TGT_FUNCTION_PRIV ( l_bcn_target_name,
             l_bcn_target_type, p_view_mntr_reports, err_desc );
  IF result <> p_bcn_success THEN
    RETURN;
  END IF;

 v_bcn_guid := mgmt_target.get_target_guid(l_bcn_target_name, l_bcn_target_type);
  -- Get the websites data

 BEGIN

   SETEMUSERCONTEXT(MGMT_USER.GET_REPOSITORY_OWNER, 
                    MGMT_USER.OP_SET_IDENTIFIER);

   OPEN l_websites_data FOR
   SELECT bcnTgt.participates_avail, tgt.target_name, tgt.target_type, tgt.display_name
     FROM mgmt_bcn_target bcnTgt, mgmt_targets tgt
    WHERE bcnTgt.beacon_target_guid = v_bcn_guid
      AND bcnTgt.target_guid != bcnTgt.beacon_target_guid
      AND bcnTgt.target_guid = tgt.target_guid;

    SETEMUSERCONTEXT(l_current_user, MGMT_USER.OP_SET_IDENTIFIER);

 EXCEPTION WHEN OTHERS THEN
    SETEMUSERCONTEXT(l_current_user, MGMT_USER.OP_SET_IDENTIFIER);
 END;
 
  OPEN l_allowed_websites FOR 
   SELECT tgt.target_name, tgt.target_type, tgt.display_name
     FROM mgmt_bcn_target bcnTgt, mgmt_targets tgt
    WHERE bcnTgt.beacon_target_guid = v_bcn_guid
      AND bcnTgt.target_guid != bcnTgt.beacon_target_guid
      AND bcnTgt.target_guid = tgt.target_guid;

EXCEPTION

  WHEN OTHERS THEN
    result := emd_bcntxn.p_bcn_err_oraerr;
    err_desc := SUBSTR(SQLERRM, 1, emd_bcntxn.p_err_maxlen);
    LOG_SYS_ERR(result, 'EMD_BCN_GET_WEBSITE_HP_DATA: db error: ' || err_desc || ' [' || v_err_msg || ']');
    IF l_websites_data%ISOPEN THEN
      CLOSE l_websites_data;
    END IF;
END EMD_BCN_GET_BCN_WEBSITES;

-- EMD_BCN_GET_BCN_WEBSITES
--------------------------------------------------------------------------

--------------------------------------------------------------------------
-- Utility procecdures and functions
--------------------------------------------------------------------------
FUNCTION BITOR(
        num1                    IN INTEGER,
        num2                    IN INTEGER)
        RETURN INTEGER
IS
BEGIN
    IF (num1 < 0 OR num2 < 0) THEN
        RETURN -1;
    END IF;
    RETURN (num1 + num2 - BITAND(num1, num2));
END BITOR;

FUNCTION EMD_BCN_GET_PROPNAMES(
        properties              IN mgmt_bcn_nvpair_array)
        RETURN mgmt_bcn_pnames_array
IS
        ret                     mgmt_bcn_pnames_array;
        v_counter               PLS_INTEGER;
        v_tmp                   INTEGER;
BEGIN
    ret := MGMT_BCN_PNAMES_ARRAY();
    v_tmp := 0;
    FOR v_counter IN 1..properties.COUNT LOOP
        -- Insert a name only once
        IF properties(v_counter).string_part IS NULL OR
                properties(v_counter).string_part <= 1 THEN
            ret.EXTEND;
            v_tmp := v_tmp + 1;
            ret(v_tmp) := properties(v_counter).name;
        END IF;
    END LOOP;
    return ret;
END EMD_BCN_GET_PROPNAMES;

--------------------------------------------------------------------------
FUNCTION EMD_BCN_GET_TEMPLATE_ID(
        tmpl_name              VARCHAR2, 
        tgt_type              VARCHAR2) RETURN RAW
IS
    v_tmp_id       MGMT_TEMPLATES.template_guid%TYPE := null;
BEGIN
    IF ((tmpl_name IS NULL) OR (tgt_type IS NULL ) )THEN
        RETURN v_tmp_id;
    END IF;

    BEGIN
        SELECT template_guid
        INTO v_tmp_id
        FROM MGMT_TEMPLATES
        WHERE template_name = tmpl_name
          AND target_type = tgt_type;
    EXCEPTION 
        WHEN NO_DATA_FOUND THEN 
            v_tmp_id := NULL;
    END;

    RETURN v_tmp_id;
END EMD_BCN_GET_TEMPLATE_ID;

--------------------------------------------------------------------------

--------------------------------------------------------------------------
FUNCTION EMD_BCN_IS_TEMPLATE(
        tgt_id              RAW) RETURN BOOLEAN
IS
    v_tmp               INTEGER;
BEGIN
    IF (tgt_id IS NULL) THEN
        RETURN FALSE;
    END IF;
    
    SELECT COUNT(*)
    INTO v_tmp
    FROM MGMT_TEMPLATES
    WHERE template_guid = tgt_id;
    
    IF v_tmp > 0 THEN
        RETURN TRUE;
    ELSE
        RETURN FALSE; 
    END IF;
EXCEPTION
    WHEN OTHERS THEN
        RETURN FALSE;
END EMD_BCN_IS_TEMPLATE;

--------------------------------------------------------------------------
PROCEDURE EMD_BCN_FILTER_APPEND_THRESH(
        match_bcn_id            IN VARCHAR2,
        bcn_id                  IN VARCHAR2,
        match_txn_id            IN VARCHAR2,
        txn_id                  IN VARCHAR2,
        match_key_part_3        IN VARCHAR2,
        key_part_3              IN VARCHAR2,
        met_name                IN VARCHAR2,
        thresholds              IN MGMT_BCN_THRESHOLD_ARRAY,
        ret_thresholds          IN OUT MGMT_BCN_THRESHOLD_ARRAY)
IS
    v_tmp                   INTEGER;
    v_num                   INTEGER;
BEGIN
    IF thresholds IS NULL OR ret_thresholds IS NULL OR thresholds.COUNT = 0 THEN
        RETURN;
    END IF;
    v_num := ret_thresholds.COUNT;
    FOR v_tmp IN 1..thresholds.COUNT LOOP
        IF (
                ((match_bcn_id IS NULL AND 
                        thresholds(v_tmp).key.bcn_guid IS NULL) OR
                (match_bcn_id IS NOT NULL AND 
                        thresholds(v_tmp).key.bcn_guid IS NOT NULL AND
                        match_bcn_id = thresholds(v_tmp).key.bcn_guid))
                AND
                ((match_txn_id IS NULL AND 
                        thresholds(v_tmp).key.txn_guid IS NULL) OR
                (match_txn_id IS NOT NULL AND 
                        thresholds(v_tmp).key.txn_guid IS NOT NULL AND
                        (match_txn_id = thresholds(v_tmp).key.txn_guid OR
                               txn_id = thresholds(v_tmp).key.txn_guid)))
                AND
                ((match_key_part_3 IS NULL AND 
                        thresholds(v_tmp).key.key_part_3 IS NULL) OR
                (match_key_part_3 IS NOT NULL AND 
                        thresholds(v_tmp).key.key_part_3 IS NOT NULL AND
                        (match_key_part_3 = thresholds(v_tmp).key.key_part_3 OR
                               key_part_3 = thresholds(v_tmp).key.key_part_3)))
                AND
                (met_name IS NULL OR 
                (thresholds(v_tmp).key.metric_name IS NOT NULL AND
                        met_name = thresholds(v_tmp).key.metric_name))
            ) THEN
  
            ret_thresholds.EXTEND;
            v_num := v_num + 1;
            ret_thresholds(v_num) := MGMT_BCN_THRESHOLD( 
                    MGMT_BCN_THRESHOLD_KEY(bcn_id, txn_id, key_part_3,
                            NULL, NULL, 
                            thresholds(v_tmp).key.metric_name, 
                            thresholds(v_tmp).key.metric_column),
                    thresholds(v_tmp).warning_threshold,
                    thresholds(v_tmp).warning_operator,
                    thresholds(v_tmp).critical_threshold,
                    thresholds(v_tmp).critical_operator,
                    thresholds(v_tmp).num_occurences);
        END IF;
    END LOOP;
END EMD_BCN_FILTER_APPEND_THRESH;

--------------------------------------------------------------------------
FUNCTION EMD_BCN_GET_COLLECTION_NAME(
        target_id               IN RAW,
        key                     IN MGMT_BCN_THRESHOLD_KEY,
        key_type                IN NUMBER)
        RETURN VARCHAR2
IS
BEGIN
    -- We don't care about the target_id.
    IF (key IS NULL OR key_type IS NULL) THEN
        RETURN NULL;
    END IF;
    
    IF key_type = p_txn THEN
        RETURN key.txn_guid;
    ELSE
        RETURN key.key_part_3;
    END IF;
    
END EMD_BCN_GET_COLLECTION_NAME;

--------------------------------------------------------------------------
FUNCTION EMD_BCN_GET_METRIC_GUID(
        target_id               IN RAW,
        is_template             IN BOOLEAN,
        met_name                IN VARCHAR2,
        met_column              IN VARCHAR2)
        RETURN RAW
IS
    v_target_type           MGMT_TARGETS.TARGET_TYPE%TYPE;
    
    ret                     MGMT_ADMIN_METRIC_THRESHOLDS.METRIC_GUID%TYPE;
BEGIN
    ret := NULL;
    IF target_id IS NULL OR met_name IS NULL OR met_column IS NULL THEN
        RETURN ret;
    END IF;

    IF NOT is_template THEN    
        SELECT mt.metric_guid
        INTO ret  
        FROM MGMT_METRICS mt, MGMT_TARGETS tg
        WHERE mt.metric_name = met_name
            AND mt.metric_column = met_column
            AND tg.target_guid = target_id
            AND tg.target_type = mt.target_type
            AND tg.type_meta_ver = mt.type_meta_ver
            AND (tg.category_prop_1 = mt.category_prop_1 OR mt.category_prop_1 = ' ')
            AND (tg.category_prop_2 = mt.category_prop_2 OR mt.category_prop_2 = ' ')
            AND (tg.category_prop_3 = mt.category_prop_3 OR mt.category_prop_3 = ' ')
            AND (tg.category_prop_4 = mt.category_prop_4 OR mt.category_prop_4 = ' ')
            AND (tg.category_prop_5 = mt.category_prop_5 OR mt.category_prop_5 = ' ');
    ELSE
        SELECT target_type
        INTO v_target_type
        FROM MGMT_TEMPLATES
        WHERE template_guid = target_id;
        
        IF v_target_type IS NULL THEN
            RETURN NULL;
        END IF;
    
        SELECT mt.metric_guid
        INTO ret  
        FROM MGMT_METRICS mt
        WHERE mt.metric_name = met_name
            AND mt.metric_column = met_column
            AND mt.target_type = v_target_type
            AND rownum = 1
        ORDER BY type_meta_ver DESC;
        
    END IF;

    RETURN ret;
EXCEPTION
    WHEN NO_DATA_FOUND THEN
        RETURN NULL;
END EMD_BCN_GET_METRIC_GUID;

--------------------------------------------------------------------------
-- Create an audit entry
PROCEDURE EMD_BCN_AUDIT (
        tgt_id                  IN RAW,
        txn_id                  IN RAW,
        change_level            IN NUMBER,
        version_change          IN BOOLEAN,
        threshold_change        IN BOOLEAN,
        attribute_change        IN BOOLEAN,
        state_change            IN BOOLEAN,
        tmstamp                 IN DATE,
        new_version             IN NUMBER,
        detstr                  IN VARCHAR2)
IS
    v_audit_bitmap          INTEGER;
    v_timestamp             DATE;
    v_is_version_change     CHAR(1);
    v_new_version           NUMBER;
    v_details               VARCHAR2(1024);
    
    v_selected_bitmap       INTEGER;
    v_selected_desc         VARCHAR2(1024);
    v_selected_isver        CHAR(1);
    v_selected_version      NUMBER;
BEGIN
    IF (tgt_id IS NULL OR txn_id IS NULL) THEN
        RETURN;
    END IF;
    
    -- First, evaluate the audit bitmap
    -- This is a 12 bit bitmap coded as follows:
    --   Bit 0 - Version change due transaction level change
    --   Bit 1 - Transaction level threshold change
    --   Bit 2 - Transaction level attribute change
    --   Bit 3 - Transaction level state change (creation, monitorying etc.)
    --   Bit 4 - Version change due to step level change
    --   Bit 5 - Step level threshold change
    --   Bit 6 - Step level attribute change
    --   Bit 7 - Unused
    --   Bit 8 - Version change due to stepgroup level change
    --   Bit 9 - Stepgroup level threshold change
    --   Bit 10 - Stepgroup level attribute change
    --   Bit 11 - Unused
    v_audit_bitmap := 0;
    v_is_version_change := 'N';
    
    IF (change_level = p_txn) THEN
        IF (version_change) THEN
            v_audit_bitmap := BITOR(v_audit_bitmap, 1);
            v_is_version_change := 'Y';
        END IF;
        IF (threshold_change) THEN
            v_audit_bitmap := BITOR(v_audit_bitmap, 2);
        END IF;
        IF (attribute_change) THEN
            v_audit_bitmap := BITOR(v_audit_bitmap, 4);
        END IF;        
        IF (state_change) THEN
            v_audit_bitmap := BITOR(v_audit_bitmap, 8);
        END IF;
    ELSIF (change_level = p_step) THEN
        IF (version_change) THEN
            v_audit_bitmap := BITOR(v_audit_bitmap, 16);
            v_is_version_change := 'Y';
        END IF;
        IF (threshold_change) THEN
            v_audit_bitmap := BITOR(v_audit_bitmap, 32);
        END IF;
        IF (attribute_change) THEN
            v_audit_bitmap := BITOR(v_audit_bitmap, 64);
        END IF;        
    ELSIF (change_level = p_stepgroup) THEN
        IF (version_change) THEN
            v_audit_bitmap := BITOR(v_audit_bitmap, 256);
            v_is_version_change := 'Y';
        END IF;
        IF (threshold_change) THEN
            v_audit_bitmap := BITOR(v_audit_bitmap, 512);
        END IF;
        IF (attribute_change) THEN
            v_audit_bitmap := BITOR(v_audit_bitmap, 1024);
        END IF;        
    ELSIF (change_level = p_all) THEN
        IF (version_change) THEN
            v_audit_bitmap := BITOR(v_audit_bitmap, 273);
            v_is_version_change := 'Y';
        END IF;
        IF (threshold_change) THEN
            v_audit_bitmap := BITOR(v_audit_bitmap, 546);
        END IF;
        IF (attribute_change) THEN
            v_audit_bitmap := BITOR(v_audit_bitmap, 1092);
        END IF;        
        IF (state_change) THEN
            v_audit_bitmap := BITOR(v_audit_bitmap, 8);
        END IF;
    END IF;
    
    IF (v_audit_bitmap = 0) THEN
        RETURN;
    END IF;
    
    -- Make sure we have a timestamp for this audit entry
    v_timestamp := tmstamp;
    IF (v_timestamp IS NULL) THEN
        IF NOT EMD_BCN_IS_TEMPLATE(tgt_id) THEN
            v_timestamp := MGMT_TARGET.SYSDATE_TARGET(tgt_id);
        ELSE
            v_timestamp := SYSDATE;
        END IF;
    END IF;
    
    v_new_version := new_version;
    -- Now update the table or insert an entry
    BEGIN
        SELECT change_type, details, is_version_change, version
        INTO v_selected_bitmap, v_selected_desc, v_selected_isver, 
            v_selected_version
        FROM MGMT_BCN_TXN_AUDIT
        WHERE target_guid = tgt_id
            AND txn_guid = txn_id
            AND audit_timestamp = v_timestamp;
            
        v_audit_bitmap := BITOR(v_selected_bitmap, v_audit_bitmap);        
        IF (v_selected_isver = 'Y') THEN
            v_is_version_change := 'Y';
        END IF;
        IF (v_new_version IS NULL) THEN
            v_new_version := v_selected_version;
        END IF;
        -- REVISIT: What do we do with the details string? Is this okay?
        v_details := v_selected_desc || ' ' || detstr || '.';
        -- REVISIT: Should not hardcode 1024
        v_details := SUBSTR(v_details, 1, 1024);
        -- Update the audit table
        UPDATE MGMT_BCN_TXN_AUDIT
        SET
            change_type = v_audit_bitmap,
            is_version_change = v_is_version_change,
            version = v_new_version,
            details = v_details
        WHERE target_guid = tgt_id
            AND txn_guid = txn_id
            AND audit_timestamp = v_timestamp;       
    EXCEPTION
        WHEN OTHERS THEN
            v_details := detstr || '.';
            -- REVISIT: Should not hardcode 1024
            v_details := SUBSTR(v_details, 1, 1024);
            -- We don't have an entry matching this primary key. Create one.
            INSERT INTO MGMT_BCN_TXN_AUDIT
                (target_guid, txn_guid, audit_timestamp, change_type,
                is_version_change, version, details)
            VALUES
                (tgt_id, txn_id, v_timestamp, v_audit_bitmap, 
                v_is_version_change, new_version, v_details);
    END;
    
END EMD_BCN_AUDIT;

--------------------------------------------------------------------------
-- Check if the composite key parts, transaction, beacon, step/step group
-- are associated with target
--------------------------------------------------------------------------
FUNCTION IS_KEY_VALID_ASSOC(
        tgt_id            IN RAW,
        comp_key          IN VARCHAR2) RETURN CHAR
IS 
    v_cnt INTEGER := 0;
BEGIN
    IF ( tgt_id IS NULL ) OR ( comp_key IS NULL ) THEN 
        RETURN 'N';
    END IF;
   
    SELECT count(*) 
      INTO v_cnt 
      FROM mgmt_bcn_txn_defn txn, mgmt_metrics_composite_keys keys
     WHERE keys.target_guid = tgt_id
       AND keys.composite_key = HEXTORAW(comp_key)
       AND txn.target_guid = keys.target_guid 
       AND keys.key_part1_value = txn.name 
       AND keys.key_part2_value IN (SELECT tgt.target_name 
                                      FROM mgmt_targets tgt, mgmt_bcn_target bcn
                                     WHERE bcn.target_guid = tgt_id
                                       AND bcn.beacon_target_guid = tgt.target_guid) 
       AND ( ( keys.key_part3_value IS NULL OR keys.key_part3_value = ' ' )
           OR 
           (keys.key_part3_value IN 
             (
              SELECT name 
                FROM mgmt_bcn_step_defn
               WHERE target_guid = txn.target_guid
                 AND txn_guid = txn.txn_guid
              UNION
              SELECT name 
                FROM mgmt_bcn_stepgroup_defn
               WHERE target_guid = txn.target_guid
                 AND txn_guid = txn.txn_guid
             )
            )
            );
    IF ( v_cnt > 0 ) THEN 
        RETURN 'Y';
    END IF;
    RETURN 'N';

END IS_KEY_VALID_ASSOC;

--------------------------------------------------------------------------
-- Create an entry in the composite key table
PROCEDURE EMD_BCN_CREATE_COMPOSITE_KEY(
        target_guid             IN RAW,
        key_part_1              IN VARCHAR2,
        key_part_2              IN VARCHAR2,
        key_part_3              IN VARCHAR2)
IS
    v_key_part_values       SMP_EMD_STRING_ARRAY;  
    v_ck                    RAW(16);
BEGIN
    v_key_part_values := SMP_EMD_STRING_ARRAY();
    v_key_part_values.EXTEND(2);
    v_key_part_values(1) := key_part_1;
    v_key_part_values(2) := key_part_2;
    IF key_part_3 IS NOT NULL THEN
        v_key_part_values.EXTEND;
        v_key_part_values(3) := key_part_3;
    END IF;
    
    v_ck := mgmt_global.get_composite_key_guid(v_key_part_values);
    IF key_part_3 IS NOT NULL THEN
        INSERT INTO MGMT_METRICS_COMPOSITE_KEYS
            (TARGET_GUID, COMPOSITE_KEY, 
            KEY_PART1_VALUE, KEY_PART2_VALUE, KEY_PART3_VALUE)
        VALUES
            (target_guid, v_ck, key_part_1, key_part_2, key_part_3);
    ELSE
        INSERT INTO MGMT_METRICS_COMPOSITE_KEYS
            (TARGET_GUID, COMPOSITE_KEY, KEY_PART1_VALUE, KEY_PART2_VALUE)
        VALUES
            (target_guid, v_ck, key_part_1, key_part_2);    
    END IF;
EXCEPTION
    WHEN DUP_VAL_ON_INDEX THEN NULL; -- ok
END  EMD_BCN_CREATE_COMPOSITE_KEY;

--------------------------------------------------------------------------
FUNCTION EMD_BCN_GET_COMPOSITE_KEY(
        target_id               IN RAW,
        key                     IN mgmt_bcn_threshold_key,
        key_type                IN NUMBER)
        RETURN VARCHAR2
IS
    ret                     VARCHAR2(256);
BEGIN
    ret := NULL;
    IF key.bcn_guid IS NULL THEN
        -- The key is a default threshold key
        IF key_type = p_txn THEN
            ret := p_default_thresh_key;
        ELSIF key_type = p_step THEN
            ret := p_default_step_thresh_key;
        ELSIF key_type = p_stepgroup THEN
            ret := p_default_stpgrp_thresh_key;
        ELSE
            ret := NULL;
        END IF;
    ELSE
        -- Get the composite key
        IF key_type = p_txn THEN
            SELECT RAWTOHEX(composite_key) 
            INTO ret
            FROM MGMT_METRICS_COMPOSITE_KEYS ck,
                    MGMT_BCN_TXN_DEFN tx,
                    MGMT_TARGETS tg
            WHERE ck.target_guid = target_id
                AND ck.key_part1_value = tx.name
                AND ck.key_part2_value = DECODE(target_id, HEXTORAW(key.bcn_guid), 
                        p_local_target_name, tg.target_name)
                AND tg.target_guid = HEXTORAW(key.bcn_guid)
                AND tx.target_guid = target_id
                AND tx.txn_guid = HEXTORAW(key.txn_guid)
                AND (ck.key_part3_value IS NULL OR ck.key_part3_value = ' ')
                AND (ck.key_part4_value IS NULL OR ck.key_part4_value = ' ')
                AND (ck.key_part5_value IS NULL OR ck.key_part5_value = ' ');
        ELSIF key_type = p_step THEN
            SELECT RAWTOHEX(composite_key) 
            INTO ret
            FROM MGMT_METRICS_COMPOSITE_KEYS ck, 
                    MGMT_BCN_TXN_DEFN tx,
                    MGMT_BCN_STEP_DEFN st,
                    MGMT_TARGETS tg
            WHERE ck.target_guid = target_id
                AND ck.key_part1_value = tx.name
                AND ck.key_part2_value = DECODE(target_id, HEXTORAW(key.bcn_guid), 
                        p_local_target_name, tg.target_name)
                AND ck.key_part3_value = st.name
                AND tg.target_guid = HEXTORAW(key.bcn_guid)
                AND st.target_guid = target_id
                AND st.txn_guid = HEXTORAW(key.txn_guid)
                AND tx.txn_guid = st.txn_guid
                AND st.step_guid = HEXTORAW(key.key_part_3)
                AND (ck.key_part4_value IS NULL OR ck.key_part4_value = ' ')
                AND (ck.key_part5_value IS NULL OR ck.key_part5_value = ' ');
        ELSIF key_type = p_stepgroup THEN
            SELECT RAWTOHEX(composite_key) 
            INTO ret
            FROM MGMT_METRICS_COMPOSITE_KEYS ck, 
                    MGMT_BCN_TXN_DEFN tx,
                    MGMT_BCN_STEPGROUP_DEFN stg,
                    MGMT_TARGETS tg
            WHERE ck.target_guid = target_id
                AND ck.key_part1_value = tx.name
                AND ck.key_part2_value = DECODE(target_id, HEXTORAW(key.bcn_guid), 
                        p_local_target_name, tg.target_name)
                AND ck.key_part3_value = stg.name
                AND tg.target_guid = HEXTORAW(key.bcn_guid)
                AND stg.target_guid = target_id
                AND stg.txn_guid = HEXTORAW(key.txn_guid)
                AND tx.txn_guid = stg.txn_guid
                AND stg.stepgroup_guid = HEXTORAW(key.key_part_3)
                AND (ck.key_part4_value IS NULL OR ck.key_part4_value = ' ')
                AND (ck.key_part5_value IS NULL OR ck.key_part5_value = ' ');
        ELSE
            ret := NULL;
        END IF;
    END IF;
    RETURN ret;
EXCEPTION
    WHEN NO_DATA_FOUND THEN
        RETURN NULL;
END EMD_BCN_GET_COMPOSITE_KEY;

--------------------------------------------------------------------------
-- return value will be -1 if there is no data found. Otherwise the return 
-- value is 1. 
-------------------------------------------------------------------------
FUNCTION EMD_BCN_GET_COMP_KEY_ELEMENTS(
        target_id               IN RAW,
        comp_key                IN RAW,
        txn_guid                OUT VARCHAR2,  
        bcn_guid                OUT VARCHAR2, 
        step_or_grp_guid        OUT VARCHAR2) RETURN NUMBER 
IS
ret  NUMBER := -1; 
BEGIN
    IF ( target_id IS NULL ) OR ( comp_key IS NULL ) THEN
        return ret;
    END IF;
   
    --caller will have to handle no data found exception
    -- according to his needs 
    BEGIN 
        --step or step group has to be determined to get the guid..TBD RAJ
        SELECT RAWTOHEX(txn.txn_guid), RAWTOHEX(tgt.target_guid), keys.KEY_PART3_VALUE
          INTO txn_guid, bcn_guid, step_or_grp_guid
          FROM MGMT_METRICS_COMPOSITE_KEYS keys, mgmt_targets tgt,
               MGMT_BCN_TXN_DEFN txn
         WHERE keys.COMPOSITE_KEY = comp_key
           AND keys.TARGET_GUID = target_id
           AND txn.TARGET_GUID = target_id
           AND keys.KEY_PART1_VALUE = txn.NAME
           AND keys.KEY_PART2_VALUE = tgt.target_name
           AND tgt.TARGET_TYPE =  p_beacon_type;

    EXCEPTION
        WHEN NO_DATA_FOUND THEN 
            return ret;
    END;
    ret := 1; 
    return ret;
END EMD_BCN_GET_COMP_KEY_ELEMENTS;
-------------------------------------------------------------------------

FUNCTION EMD_BCN_GET_TXN_KEYS(
        target_id               IN RAW,
        bcn_ids                 IN SMP_EMD_STRING_ARRAY,
        txn_ids                 IN SMP_EMD_STRING_ARRAY)
        RETURN MGMT_BCN_COMPOSITE_KEY_ARRAY
IS
    ret                 MGMT_BCN_COMPOSITE_KEY_ARRAY;
    v_count             PLS_INTEGER;
    v_count_1           PLS_INTEGER;
    v_count_2           PLS_INTEGER;
    v_bcn_id            VARCHAR2(64);
    v_txn_id            VARCHAR2(64);
    v_threshold_key     MGMT_BCN_THRESHOLD_KEY;
    v_composite_key     VARCHAR2(64);
BEGIN
    IF (target_id IS NULL OR bcn_ids IS NULL OR bcn_ids.COUNT = 0 OR
            txn_ids IS NULL OR txn_ids.COUNT = 0) THEN
        RETURN NULL;
    END IF;

    v_count := 0;
    ret := MGMT_BCN_COMPOSITE_KEY_ARRAY();
    FOR v_count_1 IN 1..bcn_ids.COUNT LOOP
        v_bcn_id := bcn_ids(v_count_1);
        IF (v_bcn_id IS NOT NULL) THEN
            FOR v_count_2 IN 1..txn_ids.COUNT LOOP
                v_txn_id := txn_ids(v_count_2);
                IF (v_txn_id IS NOT NULL) THEN
                    v_threshold_key := MGMT_BCN_THRESHOLD_KEY(
                            v_bcn_id, v_txn_id, NULL, NULL, NULL, NULL, NULL);
                    -- REVISIT: Separate calls to retrieve each key is not very
                    -- efficient. The reason we do this this way is to localize
                    -- the code that retrieves the composite keys in the
                    -- EMD_BCN_GET_COMPOSITE_KEY function.
                    v_composite_key := EMD_BCN_GET_COMPOSITE_KEY(
                            target_id, v_threshold_key, p_txn);
                    IF (v_composite_key IS NOT NULL) THEN
                        v_count := v_count + 1;
                        ret.EXTEND;
                        ret(v_count) := MGMT_BCN_COMPOSITE_KEY(
                                v_bcn_id, v_txn_id, NULL, 
                                HEXTORAW(v_composite_key));
                    END IF;
                END IF;
            END LOOP;
        END IF;
    END LOOP;
    
    RETURN ret;
EXCEPTION
    WHEN NO_DATA_FOUND THEN
        RETURN NULL;
END EMD_BCN_GET_TXN_KEYS;

--------------------------------------------------------------------------
FUNCTION EMD_BCN_GET_STEP_GROUP_KEYS(
        target_id               IN MGMT_TARGETS.TARGET_GUID%TYPE,
        bcn_ids                 IN SMP_EMD_STRING_ARRAY,
        txn_id                  IN MGMT_BCN_TXN_DEFN.TXN_GUID%TYPE,
        step_group_ids          IN SMP_EMD_STRING_ARRAY,
        key_type                IN NUMBER)
        RETURN MGMT_BCN_COMPOSITE_KEY_ARRAY
IS
    ret                 MGMT_BCN_COMPOSITE_KEY_ARRAY;
    v_count             PLS_INTEGER;
    v_count_1           PLS_INTEGER;
    v_count_2           PLS_INTEGER;
    v_bcn_id            VARCHAR2(64);
    v_txn_id            VARCHAR2(64);
    v_step_group_id     VARCHAR2(64);
    v_threshold_key     MGMT_BCN_THRESHOLD_KEY;
    v_composite_key     VARCHAR2(64);
BEGIN
    IF (target_id IS NULL OR bcn_ids IS NULL OR bcn_ids.COUNT = 0 OR
            txn_id IS NULL OR step_group_ids IS NULL OR step_group_ids.COUNT = 0) THEN
        RETURN NULL;
    END IF;

    ret := MGMT_BCN_COMPOSITE_KEY_ARRAY();
    
    v_txn_id := RAWTOHEX(txn_id);
    
    v_count := 0;
    ret := MGMT_BCN_COMPOSITE_KEY_ARRAY();
    FOR v_count_1 IN 1..bcn_ids.COUNT LOOP
        v_bcn_id := bcn_ids(v_count_1);
        IF (v_bcn_id IS NOT NULL) THEN
            FOR v_count_2 IN 1..step_group_ids.COUNT LOOP
                v_step_group_id := step_group_ids(v_count_2);
                IF (v_step_group_id IS NOT NULL) THEN
                    v_threshold_key := MGMT_BCN_THRESHOLD_KEY(v_bcn_id, 
                            v_txn_id, v_step_group_id, NULL, NULL, NULL, NULL);
                    -- REVISIT: Separate calls to retrieve each key is not very
                    -- efficient. The reason we do this this way is to localize
                    -- the code that retrieves the composite keys in the
                    -- EMD_BCN_GET_COMPOSITE_KEY function.
                    v_composite_key := EMD_BCN_GET_COMPOSITE_KEY(
                            target_id, v_threshold_key, key_type);
                    IF (v_composite_key IS NOT NULL) THEN
                        v_count := v_count + 1;
                        ret.EXTEND;
                        ret(v_count) := MGMT_BCN_COMPOSITE_KEY(v_bcn_id, 
                                v_txn_id, v_step_group_id, 
                                HEXTORAW(v_composite_key));
                    END IF;
                END IF;
            END LOOP;
        END IF;
    END LOOP;
    
    RETURN ret;
EXCEPTION
    WHEN NO_DATA_FOUND THEN
        RETURN NULL;
END EMD_BCN_GET_STEP_GROUP_KEYS;

--------------------------------------------------------------------------
FUNCTION EMD_BCN_GET_TXN_THR_KEYS(
        txn_id                  IN VARCHAR2,
        bcn_list                IN MGMT_BCN_ARRAY)
        RETURN MGMT_BCN_THRESHOLD_KEY_ARRAY
IS
    v_ret_keys              MGMT_BCN_THRESHOLD_KEY_ARRAY;
    v_count                 PLS_INTEGER;
    v_bcn_count             PLS_INTEGER;
    v_threshold_key         MGMT_BCN_THRESHOLD_KEY;
BEGIN
    IF (txn_id IS NULL) THEN
        RETURN NULL;
    END IF;
    v_ret_keys := MGMT_BCN_THRESHOLD_KEY_ARRAY();
    v_count := 0;
    -- Add a key for the default threshold
    v_count := v_count + 1;
    v_ret_keys.EXTEND;
    v_ret_keys(v_count) := MGMT_BCN_THRESHOLD_KEY(NULL,
            txn_id, NULL, NULL, NULL, NULL, NULL);
    -- Add keys corresponding to each beacon.
    IF (bcn_list IS NOT NULL AND bcn_list.COUNT > 0) THEN
        FOR v_bcn_count IN 1..bcn_list.COUNT LOOP
            v_count := v_count + 1;
            v_threshold_key := MGMT_BCN_THRESHOLD_KEY(
                    bcn_list(v_bcn_count).bcn_guid,
                    txn_id, 
                    NULL, NULL, NULL, NULL, NULL);
            v_ret_keys.EXTEND;
            v_ret_keys(v_count) := v_threshold_key;
        END LOOP;
    END IF;
    
    RETURN v_ret_keys;
EXCEPTION
    WHEN OTHERS THEN
        IF (v_ret_keys IS NOT NULL) THEN
            v_ret_keys.DELETE;
        END IF;
        RETURN NULL;
END EMD_BCN_GET_TXN_THR_KEYS;

--------------------------------------------------------------------------
FUNCTION EMD_BCN_GET_STEP_THR_KEYS(
        txn_id                  IN VARCHAR2,
        steps_defn_with_props   IN MGMT_BCN_STEP_WITH_PROPS_ARRAY,
        bcn_list                IN MGMT_BCN_ARRAY)
        RETURN MGMT_BCN_THRESHOLD_KEY_ARRAY
IS
    v_ret_keys              MGMT_BCN_THRESHOLD_KEY_ARRAY;
    v_count                 PLS_INTEGER;
    v_stp_count             PLS_INTEGER;
    v_bcn_count             PLS_INTEGER;
    v_threshold_key         MGMT_BCN_THRESHOLD_KEY;
BEGIN
    IF (txn_id IS NULL OR steps_defn_with_props IS NULL 
            OR steps_defn_with_props.COUNT = 0) THEN
        RETURN NULL;
    END IF;
    v_ret_keys := MGMT_BCN_THRESHOLD_KEY_ARRAY();
    v_count := 0;
    FOR v_stp_count IN 1..steps_defn_with_props.COUNT LOOP
        IF (steps_defn_with_props(v_stp_count).step_defn.step_guid IS NOT NULL) THEN
            -- Add a key for the default threshold
            v_count := v_count + 1;
            v_threshold_key := MGMT_BCN_THRESHOLD_KEY(NULL,
                    txn_id,
                    steps_defn_with_props(v_stp_count).step_defn.step_guid,
                    NULL, NULL, NULL, NULL);
            v_ret_keys.EXTEND;
            v_ret_keys(v_count) := v_threshold_key;
            -- Add keys corresponding to each beacon.
            IF (bcn_list IS NOT NULL AND bcn_list.COUNT > 0) THEN
                FOR v_bcn_count IN 1..bcn_list.COUNT LOOP
                    v_count := v_count + 1;
                    v_threshold_key := MGMT_BCN_THRESHOLD_KEY(
                            bcn_list(v_bcn_count).bcn_guid,
                            txn_id,
                            steps_defn_with_props(v_stp_count).step_defn.step_guid,
                            NULL, NULL, NULL, NULL);
                    v_ret_keys.EXTEND;
                    v_ret_keys(v_count) := v_threshold_key;
                END LOOP;
            END IF;
        END IF;
    END LOOP;
    
    RETURN v_ret_keys;
EXCEPTION
    WHEN OTHERS THEN
        IF (v_ret_keys IS NOT NULL) THEN
            v_ret_keys.DELETE;
        END IF;
        RETURN NULL;
END EMD_BCN_GET_STEP_THR_KEYS;

--------------------------------------------------------------------------
FUNCTION EMD_BCN_GET_STPGRP_THR_KEYS(
        txn_id                  IN VARCHAR2,
        stepgroups_defn         IN MGMT_BCN_STEPGROUP_ARRAY,        
        bcn_list                IN MGMT_BCN_ARRAY)
        RETURN MGMT_BCN_THRESHOLD_KEY_ARRAY
IS
    v_ret_keys              MGMT_BCN_THRESHOLD_KEY_ARRAY;
    v_count                 PLS_INTEGER;
    v_stg_count             PLS_INTEGER;
    v_bcn_count             PLS_INTEGER;
    v_threshold_key         MGMT_BCN_THRESHOLD_KEY;
BEGIN
    IF (txn_id IS NULL OR stepgroups_defn IS NULL 
            OR stepgroups_defn.COUNT = 0) THEN
        RETURN NULL;
    END IF;
    v_ret_keys := MGMT_BCN_THRESHOLD_KEY_ARRAY();
    v_count := 0;
    FOR v_stg_count IN 1..stepgroups_defn.COUNT LOOP
        IF (stepgroups_defn(v_stg_count).stepgroup_guid IS NOT NULL) THEN
            -- Add a key for the default threshold
            v_count := v_count + 1;
            v_threshold_key := MGMT_BCN_THRESHOLD_KEY(NULL,
                    txn_id,
                    stepgroups_defn(v_stg_count).stepgroup_guid,
                    NULL, NULL, NULL, NULL);
            v_ret_keys.EXTEND;
            v_ret_keys(v_count) := v_threshold_key;
            -- Add keys corresponding to each beacon.
            IF (bcn_list IS NOT NULL AND bcn_list.COUNT > 0) THEN
                FOR v_bcn_count IN 1..bcn_list.COUNT LOOP
                    v_count := v_count + 1;
                    v_threshold_key := MGMT_BCN_THRESHOLD_KEY(
                            bcn_list(v_bcn_count).bcn_guid,
                            txn_id,
                            stepgroups_defn(v_stg_count).stepgroup_guid,
                            NULL, NULL, NULL, NULL);
                    v_ret_keys.EXTEND;
                    v_ret_keys(v_count) := v_threshold_key;
                END LOOP;
            END IF;
        END IF;
    END LOOP;
    
    RETURN v_ret_keys;
EXCEPTION
    WHEN OTHERS THEN
        IF (v_ret_keys IS NOT NULL) THEN
            v_ret_keys.DELETE;
        END IF;
        RETURN NULL;
END EMD_BCN_GET_STPGRP_THR_KEYS;

--------------------------------------------------------------------------
/*
FUNCTION EMD_BCN_SET_REQ_UPDATE(
        tgt_id              RAW,
        bcn_id              RAW,
        txn_id              RAW) RETURN BOOLEAN
IS
BEGIN
    IF tgt_id IS NULL OR txn_id IS NULL OR bcn_id IS NULL THEN
        RETURN FALSE;
    END IF;

    UPDATE MGMT_BCN_TARGET_TXN
    SET req_update = 1
    WHERE target_guid = tgt_id
        AND beacon_target_guid = bcn_id
        AND txn_guid = txn_id
        AND state = 'M';
        
    RETURN TRUE;
EXCEPTION
    WHEN OTHERS THEN
        RETURN FALSE;
END EMD_BCN_SET_REQ_UPDATE;
*/

--------------------------------------------------------------------------
-- Retrieve beaons corresponding to a target and transaction
--------------------------------------------------------------------------

FUNCTION EMD_BCN_GET_BEACONS(
        tgt_id              VARCHAR2,
        txn_id              VARCHAR2) RETURN MGMT_BCN_ARRAY
IS
    CURSOR v_beacon_cursor(tgt RAW) IS
        SELECT beacon_target_guid AS bcn_guid, 
                t.target_name AS bcn_name, 
                t.target_type AS bcn_type, 
                t.emd_url AS emd_url,
                t.type_meta_ver AS bcn_ver,
                b.participates_avail AS bcn_is_avail,
                b.is_local AS bcn_is_local
        FROM MGMT_BCN_TARGET b, MGMT_TARGETS t
        WHERE b.target_guid = tgt 
          AND b.beacon_target_guid <> tgt
          AND b.beacon_target_guid = t.target_guid;

    CURSOR v_self_cursor(tgt RAW) IS
        SELECT  t.target_guid AS bcn_guid, 
                t.target_name AS bcn_name, 
                t.target_type AS bcn_type, 
                t.emd_url AS emd_url,
                t.type_meta_ver AS bcn_ver,
                'Y' AS bcn_is_avail,
                'Y' AS bcn_is_local
        FROM MGMT_TARGETS t
        WHERE t.target_guid = tgt;

    v_target                RAW(16);
    v_transaction           RAW(16);

    v_more                  BOOLEAN;
    v_count                 INTEGER;
    v_bcn_rec               v_beacon_cursor%ROWTYPE;
    v_bcn_list              MGMT_BCN_ARRAY;

    v_target_type           MGMT_TARGETS.TARGET_TYPE%TYPE;
BEGIN
    v_target := HEXTORAW(tgt_id);
    v_transaction := HEXTORAW(txn_id);
    v_bcn_list := NULL;

    v_count := 0;
    v_more := TRUE;

    IF ( MGMT_GENSVC_AVAIL.IS_BEACON ( v_target ) = TRUE ) THEN 
      OPEN v_self_cursor(v_target);
      FETCH v_self_cursor INTO v_bcn_rec;
      v_more := v_self_cursor%FOUND;
      IF v_more THEN
        v_bcn_list := MGMT_BCN_ARRAY();
        v_bcn_list.EXTEND;
        v_bcn_list(1) := MGMT_BCN(RAWTOHEX(v_bcn_rec.bcn_guid),
                        v_bcn_rec.bcn_name, v_bcn_rec.bcn_type, 
                        v_bcn_rec.emd_url, v_bcn_rec.bcn_ver, 
                        v_bcn_rec.bcn_is_avail, v_bcn_rec.bcn_is_local);
      CLOSE v_self_cursor;
      END IF;
    ELSE
      OPEN v_beacon_cursor(v_target);

      WHILE v_more LOOP
          FETCH v_beacon_cursor INTO v_bcn_rec;
          v_more := v_beacon_cursor%FOUND;
          IF v_more THEN
              IF v_count = 0 THEN
                  v_bcn_list := MGMT_BCN_ARRAY();
              END IF;
              v_count := v_count + 1;
              v_bcn_list.EXTEND;
              v_bcn_list(v_count) := MGMT_BCN(RAWTOHEX(v_bcn_rec.bcn_guid),
                      v_bcn_rec.bcn_name, v_bcn_rec.bcn_type, 
                      v_bcn_rec.emd_url, v_bcn_rec.bcn_ver, 
                      v_bcn_rec.bcn_is_avail, v_bcn_rec.bcn_is_local);
          END IF;             
      END LOOP;
      CLOSE v_beacon_cursor;
    END IF;

    RETURN v_bcn_list;
EXCEPTION
    WHEN OTHERS THEN
        IF v_beacon_cursor%ISOPEN THEN
            CLOSE v_beacon_cursor;
        END IF;
        IF v_bcn_list IS NOT NULL THEN
            v_bcn_list.DELETE;
            v_bcn_list := NULL;
        END IF;
        RETURN NULL;
END EMD_BCN_GET_BEACONS;

--------------------------------------------------------------------------
-- Transaction Performance beginning 10g Rel2
--------------------------------------------------------------------------

--------------------------------------------------------------------------
-- EMD_BCN_GET_AVG_CURRENT_DATA
-- 
PROCEDURE EMD_BCN_GET_AVG_CURRENT_DATA(
        l_target_guid           IN MGMT_TARGETS.TARGET_GUID%TYPE,
        l_period                IN NUMBER,
        l_max_filter            IN NUMBER,
        l_min_filter            IN NUMBER,
        l_max_date              IN DATE,
        l_min_date              IN DATE,
        l_metric_name           IN VARCHAR2,
        l_tgt_cur_time	        IN DATE,
        l_composite_keys        IN MGMT_BCN_COMPOSITE_KEY_ARRAY,
        l_metric_columns        IN SMP_EMD_STRING_ARRAY,
        l_data                  OUT p_cursor_type,
        l_result                OUT INTEGER,
        l_err_desc              OUT VARCHAR2)
IS
    v_tgt_cur_time      DATE;
    v_old_date          DATE;
    
    v_count             PLS_INTEGER;
BEGIN
    IF (l_target_guid IS NULL OR l_composite_keys IS NULL
            OR l_composite_keys.COUNT = 0 OR l_metric_columns IS NULL
            OR l_metric_columns.COUNT = 0) THEN
        l_result := p_bcn_err_badparams; 
        RETURN;
    END IF;

    -- make sure we have the current time set
    IF (l_tgt_cur_time IS NULL) THEN
        v_tgt_cur_time := MGMT_TARGET.SYSDATE_TARGET(l_target_guid);
    ELSE
        v_tgt_cur_time := l_tgt_cur_time;
    END IF;

    -- get a very old date to use optimizing queries
    SELECT TO_DATE('01/01/1970', 'mm/dd/YYYY') INTO v_old_date
    FROM DUAL;

--    l_err_desc := 'AVG-CUR Dat:' || ' pe-' || ROUND(l_period, 2);
--    l_err_desc := l_err_desc || ' met-' || l_metric_name;
--    l_err_desc := l_err_desc || ' keys : (';    
--    FOR v_count IN 1..l_composite_keys.COUNT LOOP
--        l_err_desc := l_err_desc || ' ' || l_composite_keys(v_count).bcn_guid
--        || '-' || l_composite_keys(v_count).txn_guid
--        || '-' || l_composite_keys(v_count).step_group_guid
--        || '-' || l_composite_keys(v_count).composite_key;
--    END LOOP;
--    l_err_desc := l_err_desc || ')';    
--    l_err_desc := l_err_desc || ' mets : (';    
--    FOR v_count IN 1..l_metric_columns.COUNT LOOP
--        l_err_desc := l_err_desc || ' ' || l_metric_columns(v_count);
--   END LOOP;
--    l_err_desc := l_err_desc || ')';    

    IF (l_period IS NULL) THEN
        -- Provide current data
        OPEN l_data FOR
            SELECT bcn_id, txn_id, step_group_id, metric_column, time, 
                    ROUND(value, p_round_precision), str_value
            FROM
            (
                SELECT bcn_id, txn_id, step_group_id, metric_column, time, 
                    value, str_value, MAX(time) OVER (PARTITION BY 
                    bcn_id, txn_id) max_time
                FROM
                (
                    SELECT key.bcn_guid bcn_id, key.txn_guid txn_id, 
                        key.step_group_guid step_group_id,
                        met.metric_column metric_column, data.time time, 
                        data.value value, data.str_value str_value
                    FROM
                    (
                        SELECT mt.metric_column, mt.metric_guid
                        FROM mgmt_metrics mt, mgmt_targets tg
                        WHERE mt.metric_name = l_metric_name
                            AND mt.metric_column IN
                            (
                                SELECT *
                                FROM TABLE(CAST(l_metric_columns AS SMP_EMD_STRING_ARRAY))
                            )
                            AND tg.target_guid = l_target_guid
                            AND tg.target_type = mt.target_type
                            AND tg.type_meta_ver = mt.type_meta_ver
                            AND (tg.category_prop_1 = mt.category_prop_1 OR mt.category_prop_1 = ' ')
                            AND (tg.category_prop_2 = mt.category_prop_2 OR mt.category_prop_2 = ' ')
                            AND (tg.category_prop_3 = mt.category_prop_3 OR mt.category_prop_3 = ' ')
                            AND (tg.category_prop_4 = mt.category_prop_4 OR mt.category_prop_4 = ' ')
                            AND (tg.category_prop_5 = mt.category_prop_5 OR mt.category_prop_5 = ' ')
                    ) met,
                    (
                        SELECT bcn_guid, txn_guid, step_group_guid, composite_key 
                        FROM TABLE(CAST(l_composite_keys AS MGMT_BCN_COMPOSITE_KEY_ARRAY))
                    ) key,
                    (
                        SELECT key_value, collection_timestamp time,
                            value, string_value str_value, metric_guid
                        FROM mgmt_current_metrics
                        WHERE target_guid = l_target_guid
                    ) data
                    WHERE data.key_value = key.composite_key
                        AND data.metric_guid = met.metric_guid
                )
            )
            WHERE max_time = time;

    ELSIF (l_period <= 1) THEN
        OPEN l_data FOR
            SELECT /*+ ordered */ key.bcn_guid bcn_id, key.txn_guid txn_id,
                    key.step_group_guid step_group_id, 
                    met.metric_column metric_column, NULL,
                    ROUND(AVG(data.value), p_round_precision) val
            FROM
            (
                SELECT mt.metric_column, mt.metric_guid
                FROM mgmt_metrics mt, mgmt_targets tg
                WHERE mt.metric_name = l_metric_name
                    AND mt.metric_column IN
                    (
                        SELECT *
                        FROM TABLE(CAST(l_metric_columns AS SMP_EMD_STRING_ARRAY))
                    )
                    AND tg.target_guid = l_target_guid
                    AND tg.target_type = mt.target_type
                    AND tg.type_meta_ver = mt.type_meta_ver
                    AND (tg.category_prop_1 = mt.category_prop_1 OR mt.category_prop_1 = ' ')
                    AND (tg.category_prop_2 = mt.category_prop_2 OR mt.category_prop_2 = ' ')
                    AND (tg.category_prop_3 = mt.category_prop_3 OR mt.category_prop_3 = ' ')
                    AND (tg.category_prop_4 = mt.category_prop_4 OR mt.category_prop_4 = ' ')
                    AND (tg.category_prop_5 = mt.category_prop_5 OR mt.category_prop_5 = ' ')
            ) met,
            (
                SELECT bcn_guid, txn_guid, step_group_guid, composite_key 
                FROM TABLE(CAST(l_composite_keys AS MGMT_BCN_COMPOSITE_KEY_ARRAY))
            ) key,
            (
                SELECT key_value, value, metric_guid
                FROM mgmt_metrics_raw
                WHERE collection_timestamp > v_tgt_cur_time - l_period
                    AND value IS NOT NULL
                    AND target_guid = l_target_guid
                    AND (l_max_filter IS NULL OR value <= l_max_filter)
                    AND (value >= NVL(l_min_filter, 0))
                    AND (collection_timestamp >= NVL(l_min_date, v_old_date))
                    AND (collection_timestamp <= NVL(l_max_date, v_tgt_cur_time))
            ) data
            WHERE data.key_value = key.composite_key
                AND data.metric_guid = met.metric_guid
            GROUP BY bcn_guid, txn_guid, step_group_guid, metric_column;

    ELSIF (l_period > 1 AND l_period <= 7) THEN
        OPEN l_data FOR
            SELECT /*+ ordered */ key.bcn_guid bcn_id, key.txn_guid txn_id,
                    key.step_group_guid step_group_id, 
                    met.metric_column metric_column, NULL,
                    ROUND(AVG(data.value), p_round_precision) val
            FROM
            (
                SELECT mt.metric_column, mt.metric_guid
                FROM mgmt_metrics mt, mgmt_targets tg
                WHERE mt.metric_name = l_metric_name
                    AND mt.metric_column IN
                    (
                        SELECT *
                        FROM TABLE(CAST(l_metric_columns AS SMP_EMD_STRING_ARRAY))
                    )
                    AND tg.target_guid = l_target_guid
                    AND tg.target_type = mt.target_type
                    AND tg.type_meta_ver = mt.type_meta_ver
                    AND (tg.category_prop_1 = mt.category_prop_1 OR mt.category_prop_1 = ' ')
                    AND (tg.category_prop_2 = mt.category_prop_2 OR mt.category_prop_2 = ' ')
                    AND (tg.category_prop_3 = mt.category_prop_3 OR mt.category_prop_3 = ' ')
                    AND (tg.category_prop_4 = mt.category_prop_4 OR mt.category_prop_4 = ' ')
                    AND (tg.category_prop_5 = mt.category_prop_5 OR mt.category_prop_5 = ' ')
            ) met,
            (
                SELECT bcn_guid, txn_guid, step_group_guid, composite_key 
                FROM TABLE(CAST(l_composite_keys AS MGMT_BCN_COMPOSITE_KEY_ARRAY))
            ) key,
            (
                SELECT key_value, value_average value, metric_guid
                FROM mgmt_metrics_1hour
                WHERE rollup_timestamp > v_tgt_cur_time - l_period
                    AND value_average IS NOT NULL
                    AND target_guid = l_target_guid
                    AND (l_max_filter IS NULL OR value_average <= l_max_filter)
                    AND (value_average >= NVL(l_min_filter, 0))
                    AND (rollup_timestamp >= NVL(l_min_date, v_old_date))
                    AND (rollup_timestamp <= NVL(l_max_date, v_tgt_cur_time))
            ) data
            WHERE data.key_value = key.composite_key
                AND data.metric_guid = met.metric_guid
            GROUP BY bcn_guid, txn_guid, step_group_guid, metric_column;

    ELSIF (l_period > 7) THEN
        OPEN l_data FOR
            SELECT /*+ ordered */ key.bcn_guid bcn_id, key.txn_guid txn_id,
                    key.step_group_guid step_group_id, 
                    met.metric_column metric_column, NULL,
                    ROUND(AVG(data.value), p_round_precision) val
            FROM
            (
                SELECT mt.metric_column, mt.metric_guid
                FROM mgmt_metrics mt, mgmt_targets tg
                WHERE mt.metric_name = l_metric_name
                    AND mt.metric_column IN
                    (
                        SELECT *
                        FROM TABLE(CAST(l_metric_columns AS SMP_EMD_STRING_ARRAY))
                    )
                    AND tg.target_guid = l_target_guid
                    AND tg.target_type = mt.target_type
                    AND tg.type_meta_ver = mt.type_meta_ver
                    AND (tg.category_prop_1 = mt.category_prop_1 OR mt.category_prop_1 = ' ')
                    AND (tg.category_prop_2 = mt.category_prop_2 OR mt.category_prop_2 = ' ')
                    AND (tg.category_prop_3 = mt.category_prop_3 OR mt.category_prop_3 = ' ')
                    AND (tg.category_prop_4 = mt.category_prop_4 OR mt.category_prop_4 = ' ')
                    AND (tg.category_prop_5 = mt.category_prop_5 OR mt.category_prop_5 = ' ')
            ) met,
            (
                SELECT bcn_guid, txn_guid, step_group_guid, composite_key 
                FROM TABLE(CAST(l_composite_keys AS MGMT_BCN_COMPOSITE_KEY_ARRAY))
            ) key,
            (
                SELECT key_value, value_average value, metric_guid
                FROM mgmt_metrics_1day
                WHERE rollup_timestamp > v_tgt_cur_time - l_period
                    AND value_average IS NOT NULL
                    AND target_guid = l_target_guid
                    AND (l_max_filter IS NULL OR value_average <= l_max_filter)
                    AND (value_average >= NVL(l_min_filter, 0))
                    AND (rollup_timestamp >= NVL(l_min_date, v_old_date))
                    AND (rollup_timestamp <= NVL(l_max_date, v_tgt_cur_time))
            ) data
            WHERE data.key_value = key.composite_key
                AND data.metric_guid = met.metric_guid
            GROUP BY bcn_guid, txn_guid, step_group_guid, metric_column;
    END IF;
    
EXCEPTION

    WHEN OTHERS THEN
        l_result := emd_bcntxn.p_bcn_err_oraerr;
        l_err_desc := SUBSTR(SQLERRM, 1, emd_bcntxn.p_err_maxlen);
        LOG_SYS_ERR(l_result, 'EMD_BCN_GET_AVG_CURRENT_DATA: db error: ' 
                || l_err_desc);
                
END EMD_BCN_GET_AVG_CURRENT_DATA;

--------------------------------------------------------------------------
-- EMD_BCN_GET_TIME_SERIES_DATA
-- 
PROCEDURE EMD_BCN_GET_TIME_SERIES_DATA(
        l_target_guid           IN MGMT_TARGETS.TARGET_GUID%TYPE,
        l_period                IN NUMBER,
        l_max_filter            IN NUMBER,
        l_min_filter            IN NUMBER,
        l_max_date              IN DATE,
        l_min_date              IN DATE,
        l_metric_name           IN VARCHAR2,
        l_tgt_cur_time	        IN DATE,
        l_composite_keys        IN MGMT_BCN_COMPOSITE_KEY_ARRAY,
        l_metric_columns        IN SMP_EMD_STRING_ARRAY,
        l_data                  OUT p_cursor_type,
        l_result                OUT INTEGER,
        l_err_desc              OUT VARCHAR2)
IS
    v_tgt_cur_time      DATE;
    v_old_date          DATE;
    
    v_count             PLS_INTEGER;
BEGIN
    IF (l_target_guid IS NULL OR l_composite_keys IS NULL
            OR l_composite_keys.COUNT = 0 OR l_metric_columns IS NULL
            OR l_metric_columns.COUNT = 0) THEN
        l_result := p_bcn_err_badparams; 
        RETURN;
    END IF;

    -- make sure we have the current time set
    IF (l_tgt_cur_time IS NULL) THEN
        v_tgt_cur_time := MGMT_TARGET.SYSDATE_TARGET(l_target_guid);
    ELSE
        v_tgt_cur_time := l_tgt_cur_time;
    END IF;

    -- get a very old date to use optimizing queries
    SELECT TO_DATE('01/01/1970', 'mm/dd/YYYY') INTO v_old_date
    FROM DUAL;

--    l_err_desc := 'TS Dat:' || ' pe-' || ROUND(l_period, 2);
--    l_err_desc := l_err_desc || ' met-' || l_metric_name;
--    l_err_desc := l_err_desc || ' keys : (';    
--    FOR v_count IN 1..l_composite_keys.COUNT LOOP
--        l_err_desc := l_err_desc || ' ' || l_composite_keys(v_count).bcn_guid
--        || '-' || l_composite_keys(v_count).txn_guid
--        || '-' || l_composite_keys(v_count).step_group_guid
--        || '-' || l_composite_keys(v_count).composite_key;
--    END LOOP;
--    l_err_desc := l_err_desc || ')';    
--    l_err_desc := l_err_desc || ' mets : (';    
--    FOR v_count IN 1..l_metric_columns.COUNT LOOP
--        l_err_desc := l_err_desc || ' ' || l_metric_columns(v_count);
--    END LOOP;
--    l_err_desc := l_err_desc || ')';    

    IF (l_period IS NULL) THEN
        -- Can't have time series data with only the current values
        RETURN;
    ELSIF (l_period <= 1) THEN
        OPEN l_data FOR
            SELECT /*+ ordered */ key.bcn_guid bcn_id, key.txn_guid txn_id,
                    key.step_group_guid step_group_id, 
                    met.metric_column metric_column, data.time,
                    ROUND(data.value, p_round_precision) val
            FROM
            (
                SELECT mt.metric_column, mt.metric_guid
                FROM mgmt_metrics mt, mgmt_targets tg
                WHERE mt.metric_name = l_metric_name
                    AND mt.metric_column IN
                    (
                        SELECT *
                        FROM TABLE(CAST(l_metric_columns AS SMP_EMD_STRING_ARRAY))
                    )
                    AND tg.target_guid = l_target_guid
                    AND tg.target_type = mt.target_type
                    AND tg.type_meta_ver = mt.type_meta_ver
                    AND (tg.category_prop_1 = mt.category_prop_1 OR mt.category_prop_1 = ' ')
                    AND (tg.category_prop_2 = mt.category_prop_2 OR mt.category_prop_2 = ' ')
                    AND (tg.category_prop_3 = mt.category_prop_3 OR mt.category_prop_3 = ' ')
                    AND (tg.category_prop_4 = mt.category_prop_4 OR mt.category_prop_4 = ' ')
                    AND (tg.category_prop_5 = mt.category_prop_5 OR mt.category_prop_5 = ' ')
            ) met,
            (
                SELECT bcn_guid, txn_guid, step_group_guid, composite_key 
                FROM TABLE(CAST(l_composite_keys AS MGMT_BCN_COMPOSITE_KEY_ARRAY))
            ) key,
            (
                SELECT key_value, collection_timestamp time, value, metric_guid
                FROM mgmt_metrics_raw
                WHERE collection_timestamp > v_tgt_cur_time - l_period
                    AND value IS NOT NULL
                    AND target_guid = l_target_guid
                    AND (l_max_filter IS NULL OR value <= l_max_filter)
                    AND (value >= NVL(l_min_filter, 0))
                    AND (collection_timestamp >= NVL(l_min_date, v_old_date))
                    AND (collection_timestamp <= NVL(l_max_date, v_tgt_cur_time))
            ) data
            WHERE data.key_value = key.composite_key
                AND data.metric_guid = met.metric_guid
            ORDER BY bcn_guid, txn_guid, step_group_guid, metric_column, time;
                    
    ELSIF (l_period > 1 AND l_period <= 7) THEN
        OPEN l_data FOR
            SELECT /*+ ordered */ key.bcn_guid bcn_id, key.txn_guid txn_id,
                    key.step_group_guid step_group_id, 
                    met.metric_column metric_column, data.time,
                    ROUND(data.value, p_round_precision) val
            FROM
            (
                SELECT mt.metric_column, mt.metric_guid
                FROM mgmt_metrics mt, mgmt_targets tg
                WHERE mt.metric_name = l_metric_name
                    AND mt.metric_column IN
                    (
                        SELECT *
                        FROM TABLE(CAST(l_metric_columns AS SMP_EMD_STRING_ARRAY))
                    )
                    AND tg.target_guid = l_target_guid
                    AND tg.target_type = mt.target_type
                    AND tg.type_meta_ver = mt.type_meta_ver
                    AND (tg.category_prop_1 = mt.category_prop_1 OR mt.category_prop_1 = ' ')
                    AND (tg.category_prop_2 = mt.category_prop_2 OR mt.category_prop_2 = ' ')
                    AND (tg.category_prop_3 = mt.category_prop_3 OR mt.category_prop_3 = ' ')
                    AND (tg.category_prop_4 = mt.category_prop_4 OR mt.category_prop_4 = ' ')
                    AND (tg.category_prop_5 = mt.category_prop_5 OR mt.category_prop_5 = ' ')
            ) met,
            (
                SELECT bcn_guid, txn_guid, step_group_guid, composite_key 
                FROM TABLE(CAST(l_composite_keys AS MGMT_BCN_COMPOSITE_KEY_ARRAY))
            ) key,
            (
                SELECT key_value, rollup_timestamp time, value_average value, metric_guid
                FROM mgmt_metrics_1hour
                WHERE rollup_timestamp > v_tgt_cur_time - l_period
                    AND value_average IS NOT NULL
                    AND target_guid = l_target_guid
                    AND (l_max_filter IS NULL OR value_average <= l_max_filter)
                    AND (value_average >= NVL(l_min_filter, 0))
                    AND (rollup_timestamp >= NVL(l_min_date, v_old_date))
                    AND (rollup_timestamp <= NVL(l_max_date, v_tgt_cur_time))
            ) data
            WHERE data.key_value = key.composite_key
                AND data.metric_guid = met.metric_guid
            ORDER BY bcn_guid, txn_guid, step_group_guid, metric_column, time;

    ELSIF (l_period > 7) THEN
        OPEN l_data FOR
            SELECT /*+ ordered */ key.bcn_guid bcn_id, key.txn_guid txn_id,
                    key.step_group_guid step_group_id, 
                    met.metric_column metric_column, data.time,
                    ROUND(data.value, p_round_precision) val
            FROM
            (
                SELECT mt.metric_column, mt.metric_guid
                FROM mgmt_metrics mt, mgmt_targets tg
                WHERE mt.metric_name = l_metric_name
                    AND mt.metric_column IN
                    (
                        SELECT *
                        FROM TABLE(CAST(l_metric_columns AS SMP_EMD_STRING_ARRAY))
                    )
                    AND tg.target_guid = l_target_guid
                    AND tg.target_type = mt.target_type
                    AND tg.type_meta_ver = mt.type_meta_ver
                    AND (tg.category_prop_1 = mt.category_prop_1 OR mt.category_prop_1 = ' ')
                    AND (tg.category_prop_2 = mt.category_prop_2 OR mt.category_prop_2 = ' ')
                    AND (tg.category_prop_3 = mt.category_prop_3 OR mt.category_prop_3 = ' ')
                    AND (tg.category_prop_4 = mt.category_prop_4 OR mt.category_prop_4 = ' ')
                    AND (tg.category_prop_5 = mt.category_prop_5 OR mt.category_prop_5 = ' ')
            ) met,
            (
                SELECT bcn_guid, txn_guid, step_group_guid, composite_key 
                FROM TABLE(CAST(l_composite_keys AS MGMT_BCN_COMPOSITE_KEY_ARRAY))
            ) key,
            (
                SELECT key_value, rollup_timestamp time, value_average value, metric_guid
                FROM mgmt_metrics_1day
                WHERE rollup_timestamp > v_tgt_cur_time - l_period
                    AND value_average IS NOT NULL
                    AND target_guid = l_target_guid
                    AND (l_max_filter IS NULL OR value_average <= l_max_filter)
                    AND (value_average >= NVL(l_min_filter, 0))
                    AND (rollup_timestamp >= NVL(l_min_date, v_old_date))
                    AND (rollup_timestamp <= NVL(l_max_date, v_tgt_cur_time))
            ) data
            WHERE data.key_value = key.composite_key
                AND data.metric_guid = met.metric_guid
            ORDER BY bcn_guid, txn_guid, step_group_guid, metric_column, time;
    END IF;
    
EXCEPTION

    WHEN OTHERS THEN
        l_result := emd_bcntxn.p_bcn_err_oraerr;
        l_err_desc := SUBSTR(SQLERRM, 1, emd_bcntxn.p_err_maxlen);
        LOG_SYS_ERR(l_result, 'EMD_BCN_GET_TIME_SERIES_DATA: db error: ' 
                || l_err_desc);
                
END EMD_BCN_GET_TIME_SERIES_DATA;

--------------------------------------------------------------------------
-- EMD_BCN_GET_TXN_DATA
-- 
PROCEDURE EMD_BCN_GET_TXN_DATA(
        l_target_guid           IN MGMT_TARGETS.TARGET_GUID%TYPE,
        l_period                IN NUMBER,
        l_max_filter            IN NUMBER,
        l_min_filter            IN NUMBER,
        l_max_date              IN DATE,
        l_min_date              IN DATE,
        -- The name of the transaction metric
        l_txn_metric_name       IN VARCHAR2,
        -- The following inputs parameterize the retrieval of average/current data
        l_txn_ids_1             IN SMP_EMD_STRING_ARRAY,
        l_txn_metrics_1         IN SMP_EMD_STRING_ARRAY,
        l_bcn_ids_1             IN SMP_EMD_STRING_ARRAY,
        -- The following inputs parameterize the retrieval of time series data
        l_txn_ids_2             IN SMP_EMD_STRING_ARRAY,
        l_txn_metrics_2         IN SMP_EMD_STRING_ARRAY,
        l_bcn_ids_2             IN SMP_EMD_STRING_ARRAY,
        -- Some miscellaneous inputs in this private interface
        l_tgt_cur_time	        IN DATE,
        -- We return a cursor for average/current data
        l_txn_data_1            OUT p_cursor_type,
        -- We also return a cursor for time series data
        l_txn_data_2            OUT p_cursor_type,
        l_result                OUT INTEGER,
        l_err_desc              OUT VARCHAR2)

IS
    v_keys_1            MGMT_BCN_COMPOSITE_KEY_ARRAY;
    v_keys_2            MGMT_BCN_COMPOSITE_KEY_ARRAY;
    
    v_err_msg           VARCHAR2(2048);
BEGIN
    IF (l_target_guid IS NULL OR l_txn_metric_name IS NULL) THEN
        RETURN;
    END IF;

    IF ((l_txn_ids_1 IS NULL OR l_txn_ids_1.COUNT = 0
            OR l_txn_metrics_1 IS NULL OR l_txn_metrics_1.COUNT = 0
            OR l_bcn_ids_1 IS NULL OR l_bcn_ids_1.COUNT = 0)
        AND 
        (l_txn_ids_2 IS NULL OR l_txn_ids_2.COUNT = 0
            OR l_txn_metrics_2 IS NULL OR l_txn_metrics_2.COUNT = 0
            OR l_bcn_ids_2 IS NULL OR l_bcn_ids_2.COUNT = 0)) THEN
        RETURN;
    END IF;
    
    
    ----------------------------------------------------------------------------
    -- Retrieve Average/Current data for the transaction(s) in l_txn_ids_1
    ----------------------------------------------------------------------------

    -- Put together a list of all the keys for average/current data.
    v_keys_1 := EMD_BCN_GET_TXN_KEYS(l_target_guid, l_bcn_ids_1, l_txn_ids_1);
    
    -- Go retrieve the data using the keys from above
    IF (v_keys_1 IS NOT NULL AND v_keys_1.COUNT > 0) THEN
        EMD_BCN_GET_AVG_CURRENT_DATA(l_target_guid, l_period,
                l_max_filter, l_min_filter, l_max_date, l_min_date, l_txn_metric_name,
                l_tgt_cur_time, v_keys_1, l_txn_metrics_1, l_txn_data_1, 
                l_result, v_err_msg);
    END IF;
    ----------------------------------------------------------------------------
    -- Retrieve time series data for the transaction(s) in l_txn_ids_2
    ----------------------------------------------------------------------------    

    -- Put together a list of all the keys for time series data.
    v_keys_2 := EMD_BCN_GET_TXN_KEYS(l_target_guid, l_bcn_ids_2, l_txn_ids_2);    
    
    -- Go retrieve the data using the keys from above
    IF (v_keys_2 IS NOT NULL AND v_keys_2.COUNT > 0) THEN
        EMD_BCN_GET_TIME_SERIES_DATA(l_target_guid, l_period,
                l_max_filter, l_min_filter, l_max_date, l_min_date, l_txn_metric_name,
                l_tgt_cur_time, v_keys_2, l_txn_metrics_2, l_txn_data_2,
                l_result, v_err_msg);
    END IF;
                
EXCEPTION

    WHEN OTHERS THEN
        l_result := emd_bcntxn.p_bcn_err_oraerr;
        l_err_desc := l_err_desc || ' ' || SUBSTR(SQLERRM, 1, emd_bcntxn.p_err_maxlen);
        LOG_SYS_ERR(l_result, 'EMD_BCN_GET_TXN_DATA: db error: ' 
                || l_err_desc);
                
END EMD_BCN_GET_TXN_DATA;

--------------------------------------------------------------------------
-- EMD_BCN_GET_STEP_DATA
-- 
PROCEDURE EMD_BCN_GET_STEP_DATA(
        l_target_guid           IN MGMT_TARGETS.TARGET_GUID%TYPE,
        l_txn_guid              IN MGMT_BCN_TXN_DEFN.TXN_GUID%TYPE,
        l_period                IN NUMBER,
        l_max_filter            IN NUMBER,
        l_min_filter            IN NUMBER,
        l_max_date              IN DATE,
        l_min_date              IN DATE,
        -- The name of the step metric
        l_step_metric_name      IN VARCHAR2,
        -- The following inputs parameterize the retrieval of average/current data
        l_step_ids_1            IN SMP_EMD_STRING_ARRAY,
        l_step_metrics_1        IN SMP_EMD_STRING_ARRAY,
        l_bcn_ids_1             IN SMP_EMD_STRING_ARRAY,
        -- The following inputs parameterize the retrieval of time series data
        l_step_ids_2            IN SMP_EMD_STRING_ARRAY,
        l_step_metrics_2        IN SMP_EMD_STRING_ARRAY,
        l_bcn_ids_2             IN SMP_EMD_STRING_ARRAY,
        -- Some miscellaneous inputs in this private interface
        l_tgt_cur_time	        IN DATE,
        -- We return a cursor for average/current data
        l_step_data_1           OUT p_cursor_type,
        -- We also return a cursor for time series data
        l_step_data_2           OUT p_cursor_type,
        l_result                OUT INTEGER,
        l_err_desc              OUT VARCHAR2)

IS
    v_keys_1            MGMT_BCN_COMPOSITE_KEY_ARRAY;
    v_keys_2            MGMT_BCN_COMPOSITE_KEY_ARRAY;
    
    v_err_msg           VARCHAR2(2048);
BEGIN
    IF (l_target_guid IS NULL OR l_txn_guid IS NULL OR
            l_step_metric_name IS NULL) THEN
        RETURN;
    END IF;

    IF ((l_step_ids_1 IS NULL OR l_step_ids_1.COUNT = 0
            OR l_step_metrics_1 IS NULL OR l_step_metrics_1.COUNT = 0
            OR l_bcn_ids_1 IS NULL OR l_bcn_ids_1.COUNT = 0)
        AND 
        (l_step_ids_2 IS NULL OR l_step_ids_2.COUNT = 0
            OR l_step_metrics_2 IS NULL OR l_step_metrics_2.COUNT = 0
            OR l_bcn_ids_2 IS NULL OR l_bcn_ids_2.COUNT = 0)) THEN
        RETURN;
    END IF;

--    l_err_desc := 'STP:';

    ----------------------------------------------------------------------------
    -- Retrieve Average/Current data for the step(s) in l_step_ids_1
    ----------------------------------------------------------------------------

    -- Put together a list of all the keys for average/current data.
    v_keys_1 := EMD_BCN_GET_STEP_GROUP_KEYS(l_target_guid, l_bcn_ids_1, 
            l_txn_guid, l_step_ids_1, p_step);    
    
    -- Go retrieve the data using the keys from above
    IF (v_keys_1 IS NOT NULL AND v_keys_1.COUNT > 0) THEN
        EMD_BCN_GET_AVG_CURRENT_DATA(l_target_guid, l_period,
                l_max_filter, l_min_filter, l_max_date, l_min_date, 
                l_step_metric_name, l_tgt_cur_time, v_keys_1, l_step_metrics_1, 
                l_step_data_1, l_result, v_err_msg);
    END IF;
            
    ----------------------------------------------------------------------------
    -- Retrieve time series data for the step(s) in l_step_ids_2
    ----------------------------------------------------------------------------    

    -- Put together a list of all the keys for time series data.
    v_keys_2 := EMD_BCN_GET_STEP_GROUP_KEYS(l_target_guid, l_bcn_ids_2,
            l_txn_guid, l_step_ids_2, p_step);    

    -- Go retrieve the data using the keys from above
    IF (v_keys_2 IS NOT NULL AND v_keys_2.COUNT > 0) THEN
        EMD_BCN_GET_TIME_SERIES_DATA(l_target_guid, l_period,
                l_max_filter, l_min_filter, l_max_date, l_min_date, 
                l_step_metric_name, l_tgt_cur_time, v_keys_2, l_step_metrics_2,
                l_step_data_2, l_result, v_err_msg);
    END IF;

EXCEPTION

    WHEN OTHERS THEN
        l_result := emd_bcntxn.p_bcn_err_oraerr;
        l_err_desc := l_err_desc || ' ' || SUBSTR(SQLERRM, 1, emd_bcntxn.p_err_maxlen);
        LOG_SYS_ERR(l_result, 'EMD_BCN_GET_STEP_DATA: db error: ' 
                || l_err_desc);
                
END EMD_BCN_GET_STEP_DATA;

--------------------------------------------------------------------------
-- EMD_BCN_GET_STEPGROUP_DATA
-- 
PROCEDURE EMD_BCN_GET_STEPGROUP_DATA(
        l_target_guid           IN MGMT_TARGETS.TARGET_GUID%TYPE,
        l_txn_guid              IN MGMT_BCN_TXN_DEFN.TXN_GUID%TYPE,
        l_period                IN NUMBER,
        l_max_filter            IN NUMBER,
        l_min_filter            IN NUMBER,
        l_max_date              IN DATE,
        l_min_date              IN DATE,
        -- The name of the stepgroup metric
        l_stpgrp_metric_name    IN VARCHAR2,
        -- The following inputs parameterize the retrieval of average/current data
        l_stpgrp_ids_1          IN SMP_EMD_STRING_ARRAY,
        l_stpgrp_metrics_1      IN SMP_EMD_STRING_ARRAY,
        l_bcn_ids_1             IN SMP_EMD_STRING_ARRAY,
        -- The following inputs parameterize the retrieval of time series data
        l_stpgrp_ids_2          IN SMP_EMD_STRING_ARRAY,
        l_stpgrp_metrics_2      IN SMP_EMD_STRING_ARRAY,
        l_bcn_ids_2             IN SMP_EMD_STRING_ARRAY,
        -- Some miscellaneous inputs in this private interface
        l_tgt_cur_time	        IN DATE,
        -- We return a cursor for average/current data
        l_stpgrp_data_1         OUT p_cursor_type,
        -- We also return a cursor for time series data
        l_stpgrp_data_2         OUT p_cursor_type,
        l_result                OUT INTEGER,
        l_err_desc              OUT VARCHAR2)

IS
    v_keys_1            MGMT_BCN_COMPOSITE_KEY_ARRAY;
    v_keys_2            MGMT_BCN_COMPOSITE_KEY_ARRAY;
    
    v_err_msg           VARCHAR2(2048);
BEGIN
    IF (l_target_guid IS NULL OR l_txn_guid IS NULL OR
            l_stpgrp_metric_name IS NULL) THEN
        RETURN;
    END IF;

    IF ((l_stpgrp_ids_1 IS NULL OR l_stpgrp_ids_1.COUNT = 0
            OR l_stpgrp_metrics_1 IS NULL OR l_stpgrp_metrics_1.COUNT = 0
            OR l_bcn_ids_1 IS NULL OR l_bcn_ids_1.COUNT = 0)
        AND 
        (l_stpgrp_ids_2 IS NULL OR l_stpgrp_ids_2.COUNT = 0
            OR l_stpgrp_metrics_2 IS NULL OR l_stpgrp_metrics_2.COUNT = 0
            OR l_bcn_ids_2 IS NULL OR l_bcn_ids_2.COUNT = 0)) THEN
        RETURN;
    END IF;

--    l_err_desc := 'GRP:';
    
    ----------------------------------------------------------------------------
    -- Retrieve Average/Current data for the stepgroup(s) in l_stpgrp_ids_1
    ----------------------------------------------------------------------------

    -- Put together a list of all the keys for average/current data.
    v_keys_1 := EMD_BCN_GET_STEP_GROUP_KEYS(l_target_guid, l_bcn_ids_1, 
            l_txn_guid, l_stpgrp_ids_1, p_stepgroup);
    
    -- Go retrieve the data using the keys from above
    IF (v_keys_1 IS NOT NULL AND v_keys_1.COUNT > 0) THEN
        EMD_BCN_GET_AVG_CURRENT_DATA(l_target_guid, l_period,
                l_max_filter, l_min_filter, l_max_date, l_min_date, 
                l_stpgrp_metric_name, l_tgt_cur_time, v_keys_1, 
                l_stpgrp_metrics_1, l_stpgrp_data_1, l_result, v_err_msg);
    END IF;
            
    ----------------------------------------------------------------------------
    -- Retrieve time series data for the stepgroup(s) in l_stpgrp_ids_2
    ----------------------------------------------------------------------------    

    -- Put together a list of all the keys for time series data.
    v_keys_2 := EMD_BCN_GET_STEP_GROUP_KEYS(l_target_guid, l_bcn_ids_2,
            l_txn_guid, l_stpgrp_ids_2, p_stepgroup);    

    -- Go retrieve the data using the keys from above
    IF (v_keys_2 IS NOT NULL AND v_keys_2.COUNT > 0) THEN
        EMD_BCN_GET_TIME_SERIES_DATA(l_target_guid, l_period,
                l_max_filter, l_min_filter, l_max_date, l_min_date, 
                l_stpgrp_metric_name, l_tgt_cur_time, v_keys_2, 
                l_stpgrp_metrics_2, l_stpgrp_data_2, l_result, v_err_msg);
    END IF;
                    
EXCEPTION

    WHEN OTHERS THEN
        l_result := emd_bcntxn.p_bcn_err_oraerr;
        l_err_desc := l_err_desc || ' ' || SUBSTR(SQLERRM, 1, emd_bcntxn.p_err_maxlen);
        LOG_SYS_ERR(l_result, 'EMD_BCN_GET_STEPGROUP_DATA: db error: ' 
                || l_err_desc);
                
END EMD_BCN_GET_STEPGROUP_DATA;

--------------------------------------------------------------------------
-- EMD_BCN_GET_PERF_DATA
-- 
PROCEDURE EMD_BCN_GET_PERF_DATA(
        l_target_name           IN VARCHAR2,
        l_target_type           IN VARCHAR2,
        l_period                IN VARCHAR2,
        l_max_filter            IN NUMBER,
        l_min_filter            IN NUMBER,
        l_max_date              IN DATE,
        l_min_date              IN DATE,
        -- The names of the transaction, step and stepgroup metrics
        l_txn_metric_name       IN VARCHAR2,
        l_step_metric_name      IN VARCHAR2,
        l_stpgrp_metric_name    IN VARCHAR2,
        -- The following inputs parameterize the retrieval of average/current data
        l_txn_ids_1             IN SMP_EMD_STRING_ARRAY,
        l_txn_metrics_1         IN SMP_EMD_STRING_ARRAY,
        l_step_ids_1            IN SMP_EMD_STRING_ARRAY,
        l_step_metrics_1        IN SMP_EMD_STRING_ARRAY,
        l_stpgrp_ids_1          IN SMP_EMD_STRING_ARRAY,
        l_stpgrp_metrics_1      IN SMP_EMD_STRING_ARRAY,
        l_bcn_ids_1             IN SMP_EMD_STRING_ARRAY,
        -- The following inputs parameterize the retrieval of time series data
        l_txn_ids_2             IN SMP_EMD_STRING_ARRAY,
        l_txn_metrics_2         IN SMP_EMD_STRING_ARRAY,
        l_step_ids_2            IN SMP_EMD_STRING_ARRAY,
        l_step_metrics_2        IN SMP_EMD_STRING_ARRAY,
        l_stpgrp_ids_2          IN SMP_EMD_STRING_ARRAY,
        l_stpgrp_metrics_2      IN SMP_EMD_STRING_ARRAY,
        l_bcn_ids_2             IN SMP_EMD_STRING_ARRAY,
        -- We return a set of cursors for average/current data
        l_txn_data_1            OUT p_cursor_type,
        l_step_data_1           OUT p_cursor_type,
        l_stpgrp_data_1         OUT p_cursor_type,
        -- We also return a set of cursors for time series data
        l_txn_data_2            OUT p_cursor_type,
        l_step_data_2           OUT p_cursor_type,
        l_stpgrp_data_2         OUT p_cursor_type,
        -- The version change history, keyed on transaction id
        l_version_history       OUT p_cursor_type,
        l_result                OUT INTEGER,
        l_err_desc              OUT VARCHAR2)

IS
    v_target_guid		mgmt_targets.target_guid%TYPE;
    v_txn_guid		    mgmt_bcn_txn_defn.txn_guid%TYPE;
    v_txn_type		    mgmt_bcn_txn_defn.txn_type%TYPE;
    v_period		    NUMBER;
    v_tgt_cur_time	    DATE;
    v_old_date          DATE;
    v_err_msg           VARCHAR2(2048);

    v_type_meta_ver    MGMT_TARGETS.type_meta_ver%TYPE;
    v_cat_prop_1       MGMT_TARGETS.category_prop_1%TYPE;
    v_cat_prop_2       MGMT_TARGETS.category_prop_2%TYPE;
    v_cat_prop_3       MGMT_TARGETS.category_prop_3%TYPE;
    v_cat_prop_4       MGMT_TARGETS.category_prop_4%TYPE;
    v_cat_prop_5       MGMT_TARGETS.category_prop_5%TYPE;

BEGIN
    IF ((l_target_name is null) OR (l_target_type is null)) THEN
        l_result := p_bcn_err_badparams; 
        RETURN;
    END IF;

    l_result := HAS_TGT_FUNCTION_PRIV (l_target_name,
            l_target_type, p_view_mntr_reports, l_err_desc );
    IF l_result <> p_bcn_success THEN
        RETURN;
    END IF;

    IF ((l_target_name IS NULL) OR (l_target_type IS NULL) OR 
            (l_period IS NULL)) THEN
        l_result := emd_bcntxn.p_bcn_err_badparams;
        l_err_desc := 'EMD_BCN_GET_PERF_DATA: Invalid input parameters.';
        LOG_SYS_ERR(l_result, l_err_desc);
        RETURN;
    END IF;

    IF ((l_period != p_period_24_hours) AND (l_period != p_period_7_days)
            AND (l_period != p_period_31_days) AND (l_period != p_period_1_hour)
            AND (l_period != p_period_current)) THEN
        l_result := emd_bcntxn.p_bcn_err_badparams;
        l_err_desc := 'EMD_BCN_GET_PERF_DATA: Invalid time period input.';
        LOG_SYS_ERR(l_result, l_err_desc);
        RETURN;
    END IF;

    SELECT target_guid, type_meta_ver, category_prop_1, category_prop_2, 
            category_prop_3, category_prop_4, category_prop_5 
    INTO v_target_guid, v_type_meta_ver, v_cat_prop_1, v_cat_prop_2, 
            v_cat_prop_3, v_cat_prop_4, v_cat_prop_5
    FROM mgmt_targets
    WHERE target_name = l_target_name
        AND target_type = l_target_type;

    -- get the current time at the target's location
    v_tgt_cur_time := MGMT_TARGET.SYSDATE_TARGET(v_target_guid);

    IF (l_period = p_period_24_hours) THEN
        v_period := 1;
    ELSIF (l_period = p_period_1_hour) THEN
        v_period := 1/24;
    ELSIF (l_period = p_period_7_days) THEN
        v_period := 7;
    ELSIF (l_period = p_period_31_days) THEN
        v_period := 31;
    ELSE
        v_period := NULL;
    END IF;

    -- First get data for the transaction(s)
    EMD_BCN_GET_TXN_DATA(v_target_guid, v_period, 
            l_max_filter, l_min_filter, 
            l_max_date, l_min_date, l_txn_metric_name,
            l_txn_ids_1, l_txn_metrics_1, l_bcn_ids_1,
            l_txn_ids_2, l_txn_metrics_2, l_bcn_ids_2,
            v_tgt_cur_time, 
            l_txn_data_1, l_txn_data_2,
            l_result, v_err_msg);
    l_err_desc := l_err_desc || ',3(' || v_err_msg || ')';
    
    -- Retrieve the trasaction id required to generate data for steps and stepgroups.
    -- REVISIT: We assume that all the steps and stepgroups belong to the first
    -- transaction in the lists of transactions. We do not support retrieving 
    -- step/stepgroup data.
    v_txn_guid := NULL;
    IF (l_txn_ids_1 IS NOT NULL AND l_txn_ids_1.COUNT > 0 
            AND l_txn_ids_1(1) IS NOT NULL) THEN
        v_txn_guid := HEXTORAW(l_txn_ids_1(1));
    END IF;
    IF (l_txn_ids_2 IS NOT NULL AND l_txn_ids_2.COUNT > 0 
            AND l_txn_ids_2(1) IS NOT NULL) THEN
        IF (v_txn_guid IS NULL) THEN
            v_txn_guid := HEXTORAW(l_txn_ids_2(1));
        ELSIF (v_txn_guid IS NOT NULL 
                AND v_txn_guid <> HEXTORAW(l_txn_ids_2(1))) THEN
            -- REVISIT: The two txn ids lists do not have the same first element
            -- We treat this as a bad parameter situation.
            v_txn_guid := NULL;
        END IF;
    END IF;
--    l_err_desc := l_err_desc || ',4(tg:' || v_txn_guid || ')';

    IF (v_txn_guid IS NOT NULL) THEN
        -- Get data for all the steps
        EMD_BCN_GET_STEP_DATA(v_target_guid, v_txn_guid,
                v_period, l_max_filter, l_min_filter, 
                l_max_date, l_min_date, l_step_metric_name,
                l_step_ids_1, l_step_metrics_1, l_bcn_ids_1,
                l_step_ids_2, l_step_metrics_2, l_bcn_ids_2,
                v_tgt_cur_time, 
                l_step_data_1, l_step_data_2,
                l_result, v_err_msg);
        l_err_desc := l_err_desc || ',5(' || v_err_msg || ')';
    
        -- Get data for all the stepgroups
        EMD_BCN_GET_STEPGROUP_DATA(v_target_guid, v_txn_guid, 
                v_period, l_max_filter, l_min_filter, 
                l_max_date, l_min_date, l_stpgrp_metric_name,
                l_stpgrp_ids_1, l_stpgrp_metrics_1, l_bcn_ids_1,
                l_stpgrp_ids_2, l_stpgrp_metrics_2, l_bcn_ids_2,
                v_tgt_cur_time, 
                l_stpgrp_data_1, l_stpgrp_data_2,
                l_result, v_err_msg);
        l_err_desc := l_err_desc || ',6(' || v_err_msg || ')';
        
        IF (v_period IS NOT NULL) THEN
            -- Get the version change history for the transaction

            -- get a very old date
            SELECT TO_DATE('01/01/1970', 'mm/dd/YYYY') INTO v_old_date
            FROM DUAL;
            
            OPEN l_version_history FOR
                SELECT audit_timestamp, version
                FROM MGMT_BCN_TXN_AUDIT
                WHERE target_guid = v_target_guid
                    AND txn_guid = v_txn_guid
                    AND is_version_change = 'Y'
                    AND audit_timestamp > v_tgt_cur_time - v_period
                    AND (audit_timestamp >= NVL(l_min_date, v_old_date))
                    AND (audit_timestamp <= NVL(l_max_date, v_tgt_cur_time))
                ORDER BY audit_timestamp ASC;
        END IF;
    END IF;

    l_err_desc := l_err_desc || v_err_msg;

EXCEPTION

    WHEN OTHERS THEN
        l_result := emd_bcntxn.p_bcn_err_oraerr;
        l_err_desc := SUBSTR(SQLERRM, 1, emd_bcntxn.p_err_maxlen);
        LOG_SYS_ERR(l_result, 'EMD_BCN_GET_PERF_DATA: db error: ' 
                || l_err_desc || ' [' || v_err_msg || ']');
                
END EMD_BCN_GET_PERF_DATA;

--------------------------------------------------------------------------
-- Transaction Management beginning 10g Rel2
--------------------------------------------------------------------------

-------------------------------------------------------------------------
-- THRESHOLDS
-------------------------------------------------------------------------

--------------------------------------------------------------------------
PROCEDURE EMD_BCN_GET_THRESH (
        tgt_id                  IN RAW,
        key                     IN MGMT_BCN_THRESHOLD_KEY,
        key_type                IN NUMBER,
        collection_name         IN VARCHAR2,
        threshold_list          OUT MGMT_BCN_THRESHOLD_ARRAY,
        result                  OUT INTEGER,
        err_desc                OUT VARCHAR2 )
IS
    CURSOR v_thresh_cur (tgt RAW, t_typ VARCHAR2, comp_key VARCHAR2, 
            met_name VARCHAR2, collection_name VARCHAR2, t_meta_ver VARCHAR2, 
            t_c1 VARCHAR2, t_c2 VARCHAR2, t_c3 VARCHAR2, t_c4 VARCHAR2, 
            t_c5 VARCHAR2) IS
    SELECT mt.metric_name, mt.metric_column,
           th.warning_threshold, th.warning_operator,
           th.critical_threshold, th.critical_operator, th.num_occurences
    FROM MGMT_ADMIN_METRIC_THRESHOLDS th, 
            MGMT_METRICS mt
    WHERE th.target_guid = tgt
            AND th.coll_name = collection_name
            AND th.key_value = comp_key
            AND th.metric_guid = mt.metric_guid
            AND (met_name IS NULL OR mt.metric_name = met_name)
            AND mt.target_type = t_typ
            AND mt.type_meta_ver = t_meta_ver
            AND (mt.category_prop_1 = t_c1 OR mt.category_prop_1 = ' ')
            AND (mt.category_prop_2 = t_c2 OR mt.category_prop_2 = ' ')
            AND (mt.category_prop_3 = t_c3 OR mt.category_prop_3 = ' ')
            AND (mt.category_prop_4 = t_c4 OR mt.category_prop_4 = ' ')
            AND (mt.category_prop_5 = t_c5 OR mt.category_prop_5 = ' ');
            
    CURSOR v_thresh_cur_1 (tgt RAW, t_typ VARCHAR2, comp_key VARCHAR2, 
            met_name VARCHAR2, collection_name VARCHAR2) IS
    SELECT metric_name, metric_column, warning_threshold, warning_operator,
           critical_threshold, critical_operator, num_occurences  
    FROM
    (
        SELECT mt.metric_name, mt.metric_column, 
               th.warning_threshold, th.warning_operator,
               th.critical_threshold, th.critical_operator,
               th.num_occurences,
               mt.type_meta_ver, MAX(mt.type_meta_ver) 
                   OVER (PARTITION BY mt.metric_name, mt.metric_column)
                   max_type_meta_ver
        FROM MGMT_ADMIN_METRIC_THRESHOLDS th, MGMT_METRICS mt
        WHERE th.target_guid = tgt
            AND th.coll_name = collection_name
            AND th.key_value = comp_key
            AND th.metric_guid = mt.metric_guid
            AND (met_name IS NULL OR mt.metric_name = met_name)
            AND mt.target_type = t_typ
    )
    WHERE type_meta_ver = max_type_meta_ver;

    v_mnames                p_char64_list_type;
    v_mcols                 p_char64_list_type;
    v_warns                 p_char256_list_type;
    v_crits                 p_char256_list_type;
    v_w_ops                 p_number_list_type;
    v_c_ops                 p_number_list_type;
    v_occurences            p_number_list_type;

    v_target_type           MGMT_TARGETS.target_type%TYPE;
    v_type_meta_ver         MGMT_TARGETS.type_meta_ver%TYPE;
    v_cat_prop_1            MGMT_TARGETS.category_prop_1%TYPE;
    v_cat_prop_2            MGMT_TARGETS.category_prop_2%TYPE;
    v_cat_prop_3            MGMT_TARGETS.category_prop_3%TYPE;
    v_cat_prop_4            MGMT_TARGETS.category_prop_4%TYPE;
    v_cat_prop_5            MGMT_TARGETS.category_prop_5%TYPE;
    
    v_composite_key         VARCHAR2(32);
    v_ctr                   PLS_INTEGER;
    v_tmp                   PLS_INTEGER;
    v_is_template           BOOLEAN;
BEGIN
    IF tgt_id IS NULL OR key IS NULL OR key_type IS NULL THEN
        result := p_bcn_err_badparams;
        RETURN;
    END IF;
    v_is_template := EMD_BCN_IS_TEMPLATE(tgt_id);
    
    v_composite_key := EMD_BCN_GET_COMPOSITE_KEY(tgt_id, key, key_type);
    
    IF v_composite_key IS NULL THEN
        result := p_bcn_err_badparams;
        err_desc := 'Composite Key is empty for '||key.BCN_GUID||', '||key.TXN_GUID||', '||key.KEY_PART_3||'; ';
        RETURN;
    END IF;

    IF (NOT v_is_template) THEN
        SELECT target_type, type_meta_ver, category_prop_1, category_prop_2, 
                category_prop_3, category_prop_4, category_prop_5 
        INTO v_target_type, v_type_meta_ver, v_cat_prop_1, v_cat_prop_2, 
                v_cat_prop_3, v_cat_prop_4, v_cat_prop_5
        FROM MGMT_TARGETS
        WHERE target_guid = tgt_id;
    
        OPEN v_thresh_cur(tgt_id, v_target_type, v_composite_key, key.metric_name,
                collection_name, v_type_meta_ver, v_cat_prop_1, v_cat_prop_2, 
                v_cat_prop_3, v_cat_prop_4, v_cat_prop_5);
        FETCH v_thresh_cur BULK COLLECT 
        INTO v_mnames, v_mcols, v_warns, v_w_ops, v_crits, v_c_ops, v_occurences LIMIT 1000;
                
        IF v_thresh_cur%ISOPEN THEN
            CLOSE v_thresh_cur;
        END IF; 
    ELSE
        SELECT target_type
        INTO v_target_type
        FROM MGMT_TEMPLATES
        WHERE template_guid = tgt_id;
    
        OPEN v_thresh_cur_1(tgt_id, v_target_type, v_composite_key, key.metric_name,
                collection_name);
        FETCH v_thresh_cur_1 BULK COLLECT 
        INTO v_mnames, v_mcols, v_warns, v_w_ops, v_crits, v_c_ops, v_occurences LIMIT 1000;
                
        IF v_thresh_cur_1%ISOPEN THEN
            CLOSE v_thresh_cur_1;
        END IF; 
    END IF;

    v_ctr := 0;
    IF v_mnames IS NOT NULL AND v_mnames.COUNT > 0 THEN
        FOR v_tmp IN v_mnames.FIRST..v_mnames.LAST LOOP
            IF v_ctr = 0 THEN
                threshold_list := MGMT_BCN_THRESHOLD_ARRAY();
            END IF;
            threshold_list.EXTEND;
            v_ctr := v_ctr + 1;
            threshold_list(v_ctr) := MGMT_BCN_THRESHOLD(
                    MGMT_BCN_THRESHOLD_KEY(NULL, NULL, NULL, NULL, NULL,
                            v_mnames(v_tmp), v_mcols(v_tmp)),
                    v_warns(v_tmp), v_w_ops(v_tmp),
                    v_crits(v_tmp), v_c_ops(v_tmp), 
                    v_occurences(v_tmp));
        END LOOP;
        IF v_mnames IS NOT NULL THEN
            v_mnames.DELETE;
        END IF;
        IF v_mcols IS NOT NULL THEN
            v_mcols.DELETE;
        END IF;
        IF v_warns IS NOT NULL THEN
            v_warns.DELETE;
        END IF;
        IF v_crits IS NOT NULL THEN
            v_crits.DELETE;
        END IF;
    END IF;

    result := p_bcn_success;
    err_desc := NULL;

EXCEPTION
    WHEN p_internal_error THEN
        result := p_bcn_err_oraerr;
        err_desc := SUBSTR(SQLERRM, 1, p_err_maxlen);
        LOG_SYS_ERR(result, 'EMD_BCN_GET_THRESH: failed.');
        IF v_thresh_cur%ISOPEN THEN
            CLOSE v_thresh_cur;
        END IF;
        IF threshold_list IS NOT NULL THEN
            threshold_list.DELETE;
            threshold_list := NULL;
        END IF;
        IF v_mnames IS NOT NULL THEN
            v_mnames.DELETE;
        END IF;
        IF v_mcols IS NOT NULL THEN
            v_mcols.DELETE;
        END IF;
        IF v_warns IS NOT NULL THEN
            v_warns.DELETE;
        END IF;
        IF v_crits IS NOT NULL THEN
            v_crits.DELETE;
        END IF;
    
    WHEN OTHERS THEN
        result := p_bcn_err_oraerr;
        err_desc := SUBSTR(SQLERRM, 1, p_err_maxlen);
        LOG_SYS_ERR(result, 'EMD_BCN_GET_THRESH: db error: ' || err_desc);
        IF v_thresh_cur%ISOPEN THEN
            CLOSE v_thresh_cur;
        END IF;
        IF threshold_list IS NOT NULL THEN
            threshold_list.DELETE;
            threshold_list := NULL;
        END IF;
        IF v_mnames IS NOT NULL THEN
            v_mnames.DELETE;
        END IF;
        IF v_mcols IS NOT NULL THEN
            v_mcols.DELETE;
        END IF;
        IF v_warns IS NOT NULL THEN
            v_warns.DELETE;
        END IF;
        IF v_crits IS NOT NULL THEN
            v_crits.DELETE;
        END IF;
END EMD_BCN_GET_THRESH;

--------------------------------------------------------------------------
PROCEDURE EMD_BCN_RM_THRESH (
        target_id               IN VARCHAR2,
        keys                    IN MGMT_BCN_THRESHOLD_KEY_ARRAY,
        thresh_type             IN NUMBER,
        result                  OUT INTEGER,
        err_desc                OUT VARCHAR2)
IS
    v_target                RAW(16);
    v_counter               PLS_INTEGER;
    v_metric_guid           MGMT_ADMIN_METRIC_THRESHOLDS.METRIC_GUID%TYPE;
    v_key_value             MGMT_ADMIN_METRIC_THRESHOLDS.KEY_VALUE%TYPE;
    v_collection_name       MGMT_ADMIN_METRIC_THRESHOLDS.COLL_NAME%TYPE;

    v_status                BOOLEAN;
    
    v_all_metrics           BOOLEAN;
    
    v_is_template           BOOLEAN;
BEGIN
    IF target_id IS NULL OR keys IS NULL OR keys.COUNT <= 0 THEN
        result := p_bcn_err_badparams;
        RETURN;
    END IF;

    v_target := HEXTORAW(target_id);
    
    v_is_template := EMD_BCN_IS_TEMPLATE(v_target);

    FOR v_counter IN 1..keys.COUNT LOOP
        -- DBMS_OUTPUT.PUT_LINE('Processing deletion of threshold ' || v_counter
        --         || ' ' || keys(v_counter).metric_name
        --         || ' ' || keys(v_counter).metric_column);

        -- Get the key value
        v_key_value := EMD_BCN_GET_COMPOSITE_KEY(v_target, 
                keys(v_counter), thresh_type);
        -- Get the collection name                
        v_collection_name := EMD_BCN_GET_COLLECTION_NAME(v_target,
                keys(v_counter), thresh_type);
        -- Get the metric_guid if applicable
        v_all_metrics := FALSE;
        IF (keys(v_counter).metric_name IS NULL OR 
                keys(v_counter).metric_column IS NULL) THEN
            -- Unless the caller specifies the metric name and the metric column
            -- we assume the caller wants to delete all metric thresholds
            -- corresponding to the collection name.
            v_all_metrics := TRUE;
            v_metric_guid := NULL;
        ELSE
            v_metric_guid := EMD_BCN_GET_METRIC_GUID(v_target, v_is_template,
                    keys(v_counter).metric_name, keys(v_counter).metric_column);
        END IF;

        -- DBMS_OUTPUT.PUT_LINE('Deleting threshold for collection '
        --         || v_collection_name
        --         || '; key value ' || v_key_value
        --         || '; metric guid ' || v_metric_guid);

        IF (v_key_value IS NOT NULL AND v_collection_name IS NOT NULL AND 
                (v_all_metrics OR v_metric_guid IS NOT NULL)) THEN
            DELETE FROM MGMT_ADMIN_METRIC_THRESHOLDS
            WHERE target_guid = v_target
                AND key_value = v_key_value
                AND coll_name = v_collection_name
                AND (v_metric_guid IS NULL OR metric_guid = v_metric_guid);
                
            /* This is not required as modify transaction API, wchich 
               consumes this will push the transaction

            -- Set the 'requires update' flag if it's monitoring
            -- REVISIT: Is this the right place for this
            IF keys(v_counter).bcn_guid IS NOT NULL THEN
                v_status := EMD_BCN_SET_REQ_UPDATE(v_target,
                        HEXTORAW(keys(v_counter).bcn_guid),
                        HEXTORAW(keys(v_counter).txn_guid));
            END IF;
            */
        END IF;

    END LOOP;

    result := p_bcn_success;
    err_desc := NULL;

EXCEPTION

    WHEN p_internal_error THEN
        LOG_SYS_ERR(result, 'EMD_BCN_RM_THRESH: failed.');

    WHEN OTHERS THEN
        result := p_bcn_err_oraerr;
        err_desc := SUBSTR(SQLERRM, 1, p_err_maxlen);
        LOG_SYS_ERR(result, 'EMD_BCN_RM_THRESH: db error: ' || err_desc);

END EMD_BCN_RM_THRESH;

--------------------------------------------------------------------------
PROCEDURE EMD_BCN_SET_THRESH (
        target_id               IN VARCHAR2,
        threshold_list          IN MGMT_BCN_THRESHOLD_ARRAY,
        thresh_type             IN NUMBER,
        result                  OUT INTEGER,
        err_desc                OUT VARCHAR2)
IS
    v_target                RAW(16);
    v_counter               PLS_INTEGER;
    v_counter_1             PLS_INTEGER;
    v_metric_guid           MGMT_ADMIN_METRIC_THRESHOLDS.METRIC_GUID%TYPE;
    v_key_value             MGMT_ADMIN_METRIC_THRESHOLDS.KEY_VALUE%TYPE;
    v_collection_name       MGMT_ADMIN_METRIC_THRESHOLDS.COLL_NAME%TYPE;
    v_status                BOOLEAN;
    
    v_is_template           BOOLEAN;
BEGIN
    IF target_id IS NULL OR threshold_list IS NULL OR 
            threshold_list.COUNT <= 0 THEN
        result := p_bcn_err_badparams;
        RETURN;
    END IF;

    v_target := HEXTORAW(target_id);

    v_is_template := EMD_BCN_IS_TEMPLATE(v_target);

    FOR v_counter IN 1..threshold_list.COUNT LOOP
        -- DBMS_OUTPUT.PUT_LINE('Processing threshold ' || v_counter
        --         || ' ' || threshold_list(v_counter).key.metric_name
        --         || ' ' || threshold_list(v_counter).key.metric_column);

        -- Get the key value
        v_key_value := EMD_BCN_GET_COMPOSITE_KEY(v_target, 
                threshold_list(v_counter).key, thresh_type);
        -- Get the collection name                
        v_collection_name := EMD_BCN_GET_COLLECTION_NAME(v_target,
                threshold_list(v_counter).key, thresh_type);
        -- Get the metric_guid
        v_metric_guid := EMD_BCN_GET_METRIC_GUID(v_target, v_is_template,
                threshold_list(v_counter).key.metric_name,
                threshold_list(v_counter).key.metric_column);

        -- DBMS_OUTPUT.PUT_LINE('Threshold for collection '
        --         || v_collection_name
        --         || '; key value ' || v_key_value
        --         || '; metric guid ' || v_metric_guid);

        IF (v_key_value IS NOT NULL AND v_collection_name IS NOT NULL AND
                v_metric_guid IS NOT NULL) THEN
            -- Try updating the threshold entry first.
            UPDATE MGMT_ADMIN_METRIC_THRESHOLDS
            SET 
                warning_threshold = threshold_list(v_counter).warning_threshold,
                warning_operator = threshold_list(v_counter).warning_operator,
                critical_threshold = threshold_list(v_counter).critical_threshold,
                critical_operator = threshold_list(v_counter).critical_operator,
                num_occurences = threshold_list(v_counter).num_occurences
            WHERE target_guid = v_target
                AND key_value = v_key_value
                AND coll_name = v_collection_name
                AND metric_guid = v_metric_guid;
      
            -- If the entry was not found, insert a new one.
            IF SQL%NOTFOUND THEN
                INSERT 
                INTO MGMT_ADMIN_METRIC_THRESHOLDS
                    (target_guid, metric_guid, coll_name, key_value, 
                    warning_threshold, warning_operator,
                    critical_threshold, critical_operator,
                    num_occurences)
                VALUES
                    (v_target, v_metric_guid, 
                    v_collection_name, 
                    v_key_value, 
                    threshold_list(v_counter).warning_threshold,
                    threshold_list(v_counter).warning_operator,
                    threshold_list(v_counter).critical_threshold,
                    threshold_list(v_counter).critical_operator,
                    threshold_list(v_counter).num_occurences);
            END IF;
    
            /* This is not required as modify transaction API, wchich 
               consumes this will push the transaction

            -- Set the 'requires update' flag if it's monitoring
            -- REVISIT: Is this the right place for this?
            IF threshold_list(v_counter).key.bcn_guid IS NOT NULL THEN
                v_status := EMD_BCN_SET_REQ_UPDATE(v_target,
                        HEXTORAW(threshold_list(v_counter).key.bcn_guid),
                        HEXTORAW(threshold_list(v_counter).key.txn_guid));
            END IF;
            */
        END IF;

    END LOOP;

    result := p_bcn_success;
    err_desc := NULL;

EXCEPTION

    WHEN p_internal_error THEN
        LOG_SYS_ERR(result, 'EMD_BCN_SET_THRESH: failed.');

    WHEN OTHERS THEN
        result := p_bcn_err_oraerr;
        err_desc := SUBSTR(SQLERRM, 1, p_err_maxlen);
        LOG_SYS_ERR(result, 'EMD_BCN_SET_THRESH: db error: ' || err_desc);

END EMD_BCN_SET_THRESH;

-------------------------------------------------------------------------
PROCEDURE EMD_BCN_EDIT_TXN_THRESH (
        target_id               IN VARCHAR2,
        add_thresholds          IN MGMT_BCN_THRESHOLD_ARRAY,
        rm_thresholds           IN MGMT_BCN_THRESHOLD_KEY_ARRAY,
        result                  OUT INTEGER,
        err_desc                OUT VARCHAR2)
IS
BEGIN
    IF target_id IS NULL THEN
        result := p_bcn_err_badparams;
        RETURN;
    END IF;
    
    IF rm_thresholds IS NOT NULL AND rm_thresholds.COUNT > 0 THEN
        EMD_BCN_RM_THRESH(target_id, rm_thresholds, p_txn, result, err_desc);
    END IF;

    IF add_thresholds IS NOT NULL AND add_thresholds.COUNT > 0 THEN
        EMD_BCN_SET_THRESH(target_id, add_thresholds, p_txn, result, err_desc);
    END IF;
EXCEPTION

    WHEN p_internal_error THEN
        LOG_SYS_ERR(result, 'EMD_BCN_EDIT_TXN_THRESH: failed.');

    WHEN OTHERS THEN
        result := p_bcn_err_oraerr;
        err_desc := SUBSTR(SQLERRM, 1, p_err_maxlen);
        LOG_SYS_ERR(result, 'EMD_BCN_EDIT_TXN_THRESH: db error: ' || err_desc);

END EMD_BCN_EDIT_TXN_THRESH;

-------------------------------------------------------------------------
PROCEDURE EMD_BCN_EDIT_STEP_THRESH (
        target_id               IN VARCHAR2,
        add_thresholds          IN MGMT_BCN_THRESHOLD_ARRAY,
        rm_thresholds           IN MGMT_BCN_THRESHOLD_KEY_ARRAY,
        result                  OUT INTEGER,
        err_desc                OUT VARCHAR2)
IS
BEGIN
    IF target_id IS NULL THEN
        result := p_bcn_err_badparams;
        RETURN;
    END IF;
    
    IF rm_thresholds IS NOT NULL AND rm_thresholds.COUNT > 0 THEN
        EMD_BCN_RM_THRESH(target_id, rm_thresholds, p_step, result, err_desc);
    END IF;

    IF add_thresholds IS NOT NULL AND add_thresholds.COUNT > 0 THEN
        EMD_BCN_SET_THRESH(target_id, add_thresholds, p_step, result, err_desc);
    END IF;
EXCEPTION

    WHEN p_internal_error THEN
        LOG_SYS_ERR(result, 'EMD_BCN_EDIT_STEP_THRESH: failed.');

    WHEN OTHERS THEN
        result := p_bcn_err_oraerr;
        err_desc := SUBSTR(SQLERRM, 1, p_err_maxlen);
        LOG_SYS_ERR(result, 'EMD_BCN_EDIT_STEP_THRESH: db error: ' || err_desc);

END EMD_BCN_EDIT_STEP_THRESH;

-------------------------------------------------------------------------
PROCEDURE EMD_BCN_EDIT_STEPGROUP_THRESH (
        target_id               IN VARCHAR2,
        add_thresholds          IN MGMT_BCN_THRESHOLD_ARRAY,
        rm_thresholds           IN MGMT_BCN_THRESHOLD_KEY_ARRAY,
        result                  OUT INTEGER,
        err_desc                OUT VARCHAR2)
IS
BEGIN
    IF target_id IS NULL THEN
        result := p_bcn_err_badparams;
        RETURN;
    END IF;
    
    IF rm_thresholds IS NOT NULL AND rm_thresholds.COUNT > 0 THEN
        EMD_BCN_RM_THRESH(target_id, rm_thresholds, p_stepgroup, result, err_desc);
    END IF;

    IF add_thresholds IS NOT NULL AND add_thresholds.COUNT > 0 THEN
        EMD_BCN_SET_THRESH(target_id, add_thresholds, p_stepgroup, result, err_desc);
    END IF;
EXCEPTION

    WHEN p_internal_error THEN
        LOG_SYS_ERR(result, 'EMD_BCN_EDIT_STEPGROUP_THRESH: failed.');

    WHEN OTHERS THEN
        result := p_bcn_err_oraerr;
        err_desc := SUBSTR(SQLERRM, 1, p_err_maxlen);
        LOG_SYS_ERR(result, 'EMD_BCN_EDIT_STEPGROUP_THRESH: db error: ' || err_desc);

END EMD_BCN_EDIT_STEPGROUP_THRESH;

-------------------------------------------------------------------------
-- TRANSACTION-LEVEL OPERATIONS
-------------------------------------------------------------------------

PROCEDURE EMD_BCN_GET_TXN_PROPS (
        tgt_id                  IN VARCHAR2,
        txn_id                  IN VARCHAR2,
        props                   OUT mgmt_bcn_nvpair_array,
        result                  OUT INTEGER,
        err_desc                OUT VARCHAR2)
IS
    CURSOR props_cursor(tgt_id RAW, txn_id RAW) IS
        SELECT *        
        FROM MGMT_BCN_TXN_PROPS
        WHERE target_guid = tgt_id
            AND txn_guid = txn_id;
    
    v_target                RAW(16);
    v_transaction           RAW(16);

    v_prop                  props_cursor%ROWTYPE;
    v_string_value          VARCHAR2(4000);
    v_more                  BOOLEAN;
    v_count                 INTEGER;
BEGIN
    IF tgt_id IS NULL OR txn_id IS NULL THEN
        result := p_bcn_err_badparams;
        RETURN;
    END IF;
    
    v_target := HEXTORAW(tgt_id);
    v_transaction := HEXTORAW(txn_id);

    props := NULL;

    v_more := TRUE;
    v_count := 0;
    OPEN props_cursor(v_target, v_transaction);
    WHILE v_more LOOP
        FETCH props_cursor INTO v_prop;
        v_more := props_cursor%FOUND;
        IF v_more THEN
            IF props IS NULL THEN
                props := MGMT_BCN_NVPAIR_ARRAY();
            END IF;
            v_count := v_count + 1;
            props.EXTEND;
            IF v_prop.prop_type = p_string_prop_type 
                    AND v_prop.encrypted = 'Y' THEN
                v_string_value := decrypt(v_prop.string_value);
            ELSE
                v_string_value := v_prop.string_value;
            END IF;
            props(v_count) := MGMT_BCN_NVPAIR(
                    v_prop.name, v_prop.string_part,
                    v_string_value, v_prop.num_value, 
                    v_prop.date_value, v_prop.char_value, 
                    v_prop.prop_type, v_prop.encrypted, v_prop.template);
        END IF;
    END LOOP;
    CLOSE props_cursor;
    
    result := p_bcn_success;
    err_desc := NULL;
EXCEPTION
    WHEN p_internal_error THEN
        LOG_SYS_ERR(result, 'EMD_BCN_GET_TXN_PROPS: failed.');
        IF props_cursor%ISOPEN THEN
            CLOSE props_cursor;
        END IF;
        IF props IS NOT NULL THEN
            props.DELETE;
            props := NULL;
        END IF;

    WHEN OTHERS THEN
        result := p_bcn_err_oraerr;
        err_desc := SUBSTR(SQLERRM, 1, p_err_maxlen);
        LOG_SYS_ERR(result, 'EMD_BCN_GET_TXN_PROPS: db error: ' || err_desc);
        IF props_cursor%ISOPEN THEN
            CLOSE props_cursor;
        END IF;
        IF props IS NOT NULL THEN
            props.DELETE;
            props := NULL;
        END IF;
END EMD_BCN_GET_TXN_PROPS;

--------------------------------------------------------------------------
PROCEDURE EMD_BCN_GET_BCNTXN_PROPS (
        tgt_id                  IN VARCHAR2,
        txn_id                  IN VARCHAR2,
        perbcn_props            OUT mgmt_bcn_perbcn_nvpair_array,
        result                  OUT INTEGER,
        err_desc                OUT VARCHAR2)
IS
    CURSOR beacons_cursor(tgt_id RAW, txn_id RAW) IS
        SELECT DISTINCT bcn_guid
        FROM MGMT_BCN_BCNTXN_PROPS
        WHERE target_guid = tgt_id
            AND txn_guid = txn_id;
    
    CURSOR bcntxn_props_cursor(tgt_id RAW, txn_id RAW, beacon_id RAW) IS
        SELECT *        
        FROM MGMT_BCN_BCNTXN_PROPS
        WHERE target_guid = tgt_id
            AND txn_guid = txn_id
            AND bcn_guid = beacon_id;
    
    v_target                RAW(16);
    v_transaction           RAW(16);

    v_bcntxn_prop           bcntxn_props_cursor%ROWTYPE;
    v_beacon                beacons_cursor%ROWTYPE;
    v_more                  BOOLEAN;
    v_more_1                BOOLEAN;
    v_count                 INTEGER;
    v_count_1               INTEGER;
    v_props                 MGMT_BCN_NVPAIR_ARRAY;
    v_string_value          VARCHAR2(4000);
BEGIN
    IF tgt_id IS NULL OR txn_id IS NULL THEN
        result := p_bcn_err_badparams;
        RETURN;
    END IF;
    
    v_target := HEXTORAW(tgt_id);
    v_transaction := HEXTORAW(txn_id);

    perbcn_props := NULL;

    v_more := TRUE;
    v_count := 0;
    OPEN beacons_cursor(v_target, v_transaction);    
    WHILE v_more LOOP
        FETCH beacons_cursor INTO v_beacon;
        v_more := beacons_cursor%FOUND;
        IF v_more AND v_beacon.bcn_guid IS NOT NULL THEN
            IF perbcn_props IS NULL THEN
                perbcn_props := MGMT_BCN_PERBCN_NVPAIR_ARRAY();
            END IF;
        
            v_more_1 := TRUE;
            v_count_1 := 0;
            v_props := NULL;
            OPEN bcntxn_props_cursor(v_target, v_transaction, v_beacon.bcn_guid);
            WHILE v_more_1 LOOP
                FETCH bcntxn_props_cursor INTO v_bcntxn_prop;
                v_more_1 := bcntxn_props_cursor%FOUND;
                IF v_more_1 THEN
                    IF v_props IS NULL THEN
                        v_props := MGMT_BCN_NVPAIR_ARRAY();
                    END IF;
                    v_count_1 := v_count_1 + 1;
                    v_props.EXTEND;
                    IF v_bcntxn_prop.prop_type = p_string_prop_type 
                            AND v_bcntxn_prop.encrypted = 'Y' THEN
                        v_string_value := decrypt(v_bcntxn_prop.string_value);
                    ELSE
                        v_string_value := v_bcntxn_prop.string_value;
                    END IF;
                    v_props(v_count_1) := MGMT_BCN_NVPAIR(
                            v_bcntxn_prop.name,
                            v_bcntxn_prop.string_part,
                            v_string_value,
                            v_bcntxn_prop.num_value,
                            v_bcntxn_prop.date_value,
                            v_bcntxn_prop.char_value,
                            v_bcntxn_prop.prop_type,
                            v_bcntxn_prop.encrypted,
                            v_bcntxn_prop.template);
                END IF;
            END LOOP;
            
            IF v_props IS NOT NULL THEN
                v_count := v_count + 1;
                perbcn_props.EXTEND;
                perbcn_props(v_count) := MGMT_BCN_PERBCN_NVPAIR(
                        v_beacon.bcn_guid, v_props);
            END IF;
            CLOSE bcntxn_props_cursor;
        END IF;
    END LOOP;
    CLOSE beacons_cursor;
    
    result := p_bcn_success;
    err_desc := NULL;
EXCEPTION
    WHEN p_internal_error THEN
        LOG_SYS_ERR(result, 'EMD_BCN_GET_BCNTXN_PROPS: failed.');
        IF beacons_cursor%ISOPEN THEN
            CLOSE beacons_cursor;
        END IF;
        IF bcntxn_props_cursor%ISOPEN THEN
            CLOSE bcntxn_props_cursor;
        END IF;
        IF v_props IS NOT NULL THEN
            v_props.DELETE;
            v_props := NULL;
        END IF;
        IF perbcn_props IS NOT NULL THEN
            perbcn_props.DELETE;
            perbcn_props := NULL;
        END IF;

    WHEN OTHERS THEN
        result := p_bcn_err_oraerr;
        err_desc := SUBSTR(SQLERRM, 1, p_err_maxlen);
        LOG_SYS_ERR(result, 'EMD_BCN_GET_BCNTXN_PROPS: db error: ' || err_desc);
        IF beacons_cursor%ISOPEN THEN
            CLOSE beacons_cursor;
        END IF;
        IF bcntxn_props_cursor%ISOPEN THEN
            CLOSE bcntxn_props_cursor;
        END IF;
        IF v_props IS NOT NULL THEN
            v_props.DELETE;
            v_props := NULL;
        END IF;
        IF perbcn_props IS NOT NULL THEN
            perbcn_props.DELETE;
            perbcn_props := NULL;
        END IF;
END EMD_BCN_GET_BCNTXN_PROPS;

--------------------------------------------------------------------------
PROCEDURE EMD_BCN_RM_TXN_PROPS (
        tgt_guid                IN VARCHAR2,
        txn_guid                IN VARCHAR2,
        propnames               IN mgmt_bcn_pnames_array,
        result                  OUT INTEGER,
        err_desc                OUT VARCHAR2)
IS
    v_target                RAW(16);
    v_transaction           RAW(16);
    v_counter               PLS_INTEGER;
BEGIN
    IF tgt_guid IS NULL OR txn_guid IS NULL OR 
            (propnames IS NOT NULL AND propnames.COUNT <= 0) THEN
        result := p_bcn_err_badparams;
        RETURN;
    END IF;

    v_target := HEXTORAW(tgt_guid);
    v_transaction := HEXTORAW(txn_guid);

    IF (propnames IS NULL) THEN
        -- Delete all properties corresponding to this transaction
        DELETE FROM MGMT_BCN_TXN_PROPS
        WHERE target_guid = v_target
            AND txn_guid = v_transaction;
    ELSE    
        FOR v_counter IN 1..propnames.COUNT LOOP
            DELETE FROM MGMT_BCN_TXN_PROPS
            WHERE target_guid = v_target
                AND txn_guid = v_transaction
                AND name = propnames(v_counter);
        END LOOP;
    END IF;

    result := p_bcn_success;
    err_desc := NULL;
EXCEPTION

    WHEN p_internal_error THEN
        LOG_SYS_ERR(result, 'EMD_BCN_RM_TXN_PROPS: failed.');

    WHEN OTHERS THEN
        result := p_bcn_err_oraerr;
        err_desc := SUBSTR(SQLERRM, 1, p_err_maxlen);
        LOG_SYS_ERR(result, 'EMD_BCN_RM_TXN_PROPS: ' || err_desc);

END EMD_BCN_RM_TXN_PROPS;

--------------------------------------------------------------------------
PROCEDURE EMD_BCN_RM_BCNTXN_PROPS (
        tgt_guid                IN VARCHAR2,
        txn_guid                IN VARCHAR2,
        bcn_guid                IN VARCHAR2,
        propnames               IN mgmt_bcn_pnames_array,
        result                  OUT INTEGER,
        err_desc                OUT VARCHAR2)
IS
    v_target                RAW(16);
    v_transaction           RAW(16);

    v_beacon                RAW(16);
    v_counter               PLS_INTEGER;
BEGIN
    IF tgt_guid IS NULL OR txn_guid IS NULL 
            OR (propnames IS NOT NULL AND propnames.COUNT <= 0) THEN
        result := p_bcn_err_badparams;
        RETURN;
    END IF;
    
    v_target := HEXTORAW(tgt_guid);
    v_transaction := HEXTORAW(txn_guid);

    IF (bcn_guid IS NULL) THEN
        IF (propnames IS NULL) THEN
            DELETE FROM MGMT_BCN_BCNTXN_PROPS
            WHERE target_guid = v_target
                AND txn_guid = v_transaction;
        ELSE
            FOR v_counter IN 1..propnames.COUNT LOOP
                DELETE FROM MGMT_BCN_BCNTXN_PROPS
                WHERE target_guid = v_target
                    AND txn_guid = v_transaction
                    AND name = propnames(v_counter);
            END LOOP;
        END IF;
    ELSE
        v_beacon := HEXTORAW(bcn_guid);
        IF (propnames IS NULL) THEN
            DELETE FROM MGMT_BCN_BCNTXN_PROPS
            WHERE target_guid = v_target
                AND txn_guid = v_transaction
                AND bcn_guid = v_beacon;
        ELSE
            FOR v_counter IN 1..propnames.COUNT LOOP
                DELETE FROM MGMT_BCN_BCNTXN_PROPS
                WHERE target_guid = v_target
                    AND txn_guid = v_transaction
                    AND bcn_guid = v_beacon
                    AND name = propnames(v_counter);
            END LOOP;
        END IF;
    END IF;
       
    result := p_bcn_success;
    err_desc := NULL;
EXCEPTION

    WHEN p_internal_error THEN
        LOG_SYS_ERR(result, 'EMD_BCN_RM_BCNTXN_PROPS: failed.');

    WHEN OTHERS THEN
        result := p_bcn_err_oraerr;
        err_desc := SUBSTR(SQLERRM, 1, p_err_maxlen);
        LOG_SYS_ERR(result, 'EMD_BCN_RM_BCNTXN_PROPS: ' || err_desc);

END EMD_BCN_RM_BCNTXN_PROPS;

--------------------------------------------------------------------------
PROCEDURE EMD_BCN_SET_TXN_PROPS (
        tgt_guid                IN VARCHAR2,
        txn_guid                IN VARCHAR2,
        properties              IN mgmt_bcn_nvpair_array,
        remove_existing         IN BOOLEAN,
        result                  OUT INTEGER,
        err_desc                OUT VARCHAR2)
IS
    v_target                RAW(16);
    v_transaction           RAW(16);
    v_counter               PLS_INTEGER;
    v_propnames             MGMT_BCN_PNAMES_ARRAY;
    v_string_value          VARCHAR2(4000);
    v_interval_count        INTEGER;
    v_interval_name         VARCHAR2(64) := 'Collection Interval';
BEGIN
    IF tgt_guid IS NULL OR txn_guid IS NULL OR properties IS NULL OR 
            properties.COUNT <= 0 THEN
        result := p_bcn_err_badparams;
        RETURN;
    END IF;
    
    v_target := HEXTORAW(tgt_guid);
    v_transaction := HEXTORAW(txn_guid);
    
    -- First delete existing property entries for the properties,
    -- all of them if remove_exising is true, else only those that are being set.
    IF (remove_existing) THEN
        -- DBMS_OUTPUT.PUT_LINE('Removing all existing txn properites');
        EMD_BCN_RM_TXN_PROPS(tgt_guid, txn_guid, NULL, result, err_desc);
    ELSE    
        -- DBMS_OUTPUT.PUT_LINE('Removing select txn properites');
        v_propnames := EMD_BCN_GET_PROPNAMES(properties);
        EMD_BCN_RM_TXN_PROPS(tgt_guid, txn_guid, v_propnames, result, err_desc);
    END IF;

    FOR v_counter IN 1..properties.COUNT LOOP
        -- Encrypt string values that need to be encrypted
        IF (properties(v_counter).prop_type = p_string_prop_type AND
                    properties(v_counter).encrypt = 'Y') THEN
            v_string_value := encrypt(properties(v_counter).string_value);
        ELSE
            v_string_value := properties(v_counter).string_value;
        END IF;
        -- DBMS_OUTPUT.PUT_LINE('Storing property ' || properties(v_counter).name);
        -- Insert a new property entry.
        INSERT 
        INTO MGMT_BCN_TXN_PROPS
            (target_guid, txn_guid, name, string_part, string_value, num_value,
            date_value, char_value, prop_type, encrypted, template)
        VALUES
            (v_target, v_transaction, 
            properties(v_counter).name, properties(v_counter).string_part,
            v_string_value, properties(v_counter).num_value, 
            properties(v_counter).date_value, properties(v_counter).char_value,
            properties(v_counter).prop_type, properties(v_counter).encrypt,
            properties(v_counter).template);
    END LOOP;

    -- check if collection interval is present.
    SELECT COUNT(*)
      INTO v_interval_count
      FROM MGMT_BCN_TXN_PROPS
     WHERE target_guid = v_target
       AND txn_guid = v_transaction
       AND name = v_interval_name;

    -- add if collection interval is not present.
    -- Note:
    -- since this function does not know about template, 
    -- We assume there is at least one property. 
    -- This should be a safe assumption.
    IF (v_interval_count = 0 AND properties.COUNT > 0) THEN
      INSERT 
        INTO MGMT_BCN_TXN_PROPS
             (target_guid, txn_guid, name, string_part, string_value, num_value,
             date_value, char_value, prop_type, encrypted, template)
      VALUES
            -- 5 is the default collection interval (minutes), 
            -- 2 indicates this property is a num value
            (v_target, v_transaction, v_interval_name, 0, NULL, 5, NULL, NULL, 2, 
              -- always unencrypted,
              'N',
              -- use the first property's template value
              properties(1).template);
    END IF;

    result := p_bcn_success;
    err_desc := NULL;
EXCEPTION

    WHEN p_internal_error THEN
        LOG_SYS_ERR(result, 'EMD_BCN_SET_TXN_PROPS: failed.');

    WHEN OTHERS THEN
        result := p_bcn_err_oraerr;
        err_desc := SUBSTR(SQLERRM, 1, p_err_maxlen);
        LOG_SYS_ERR(result, 'EMD_BCN_SET_TXN_PROPS: ' || err_desc);

END EMD_BCN_SET_TXN_PROPS;

--------------------------------------------------------------------------
PROCEDURE EMD_BCN_SET_BCNTXN_PROPS (
        tgt_guid                IN VARCHAR2,
        txn_guid                IN VARCHAR2,
        perbcn_props            IN mgmt_bcn_perbcn_nvpair_array,
        remove_existing         IN BOOLEAN,
        result                  OUT INTEGER,
        err_desc                OUT VARCHAR2)
IS
    v_target                RAW(16);
    v_transaction           RAW(16);
    v_beacon                RAW(16);
    v_counter               PLS_INTEGER;
    v_counter1              PLS_INTEGER;
    v_properties            MGMT_BCN_NVPAIR_ARRAY;
    v_propnames             MGMT_BCN_PNAMES_ARRAY;
    v_string_value          VARCHAR2(4000);
BEGIN
    IF tgt_guid IS NULL OR txn_guid IS NULL OR perbcn_props IS NULL OR 
            perbcn_props.COUNT <= 0 THEN
        result := p_bcn_err_badparams;
        RETURN;
    END IF;

    v_target := HEXTORAW(tgt_guid);
    v_transaction := HEXTORAW(txn_guid);
    
    -- First delete existing property entries for all beacons for the txn
    IF (remove_existing) THEN
        EMD_BCN_RM_BCNTXN_PROPS(tgt_guid, txn_guid, NULL, NULL, result, err_desc);
    END IF;    

    FOR v_counter IN 1..perbcn_props.COUNT LOOP    
        v_beacon := HEXTORAW(perbcn_props(v_counter).bcn_guid);

        v_properties := perbcn_props(v_counter).nvpairlist;
        -- Delete existing property entries, if remove_exsiting is FALSE
        IF (remove_existing = FALSE) THEN
            v_propnames := EMD_BCN_GET_PROPNAMES(v_properties);
            EMD_BCN_RM_BCNTXN_PROPS(tgt_guid, txn_guid, 
                    perbcn_props(v_counter).bcn_guid, v_propnames, result, err_desc);
        END IF;
    
        FOR v_counter_1 IN 1..v_properties.COUNT LOOP
            -- Encrypt string values that need to be encrypted
            IF (v_properties(v_counter_1).prop_type = p_string_prop_type AND 
                    v_properties(v_counter_1).encrypt = 'Y') THEN
                v_string_value := encrypt(v_properties(v_counter_1).string_value);
            ELSE
                v_string_value := v_properties(v_counter_1).string_value;
            END IF;
            -- Insert a new property entry.
            INSERT 
            INTO MGMT_BCN_BCNTXN_PROPS
                (target_guid, txn_guid, bcn_guid, name, string_part, 
                string_value, num_value, date_value, char_value, prop_type, 
                encrypted, template)
            VALUES
                (v_target, 
                v_transaction,
                v_beacon,
                v_properties(v_counter_1).name, 
                v_properties(v_counter_1).string_part,
                v_string_value, 
                v_properties(v_counter_1).num_value, 
                v_properties(v_counter_1).date_value, 
                v_properties(v_counter_1).char_value,
                v_properties(v_counter_1).prop_type, 
                v_properties(v_counter_1).encrypt,
                v_properties(v_counter_1).template);
        END LOOP;
    END LOOP;

    result := p_bcn_success;
    err_desc := NULL;
EXCEPTION
    WHEN p_internal_error THEN
        LOG_SYS_ERR(result, 'EMD_BCN_SET_BCNTXN_PROPS: failed.');

    WHEN OTHERS THEN
        result := p_bcn_err_oraerr;
        err_desc := SUBSTR(SQLERRM, 1, p_err_maxlen);
        LOG_SYS_ERR(result, 'EMD_BCN_SET_BCNTXN_PROPS: ' || err_desc);

END EMD_BCN_SET_BCNTXN_PROPS;

--------------------------------------------------------------------------
PROCEDURE EMD_BCN_REPL_TXN_PROPS (
        tgt_id                  IN VARCHAR2,
        txn_id                  IN VARCHAR2,
        txn_props               IN MGMT_BCN_NVPAIR_ARRAY,
        txn_bcn_props           IN MGMT_BCN_PERBCN_NVPAIR_ARRAY,
        result                  OUT INTEGER,
        err_desc                OUT VARCHAR2)
IS
    v_beacon                RAW(16);
    v_counter               PLS_INTEGER;
    v_propnames             MGMT_BCN_PNAMES_ARRAY;
BEGIN
    IF tgt_id IS NULL OR txn_id IS NULL THEN
        result := p_bcn_err_badparams;
        RETURN;
    END IF;
    
    IF txn_props IS NOT NULL AND txn_props.COUNT > 0 THEN
        EMD_BCN_SET_TXN_PROPS(tgt_id, txn_id, txn_props, TRUE, result, err_desc);
    END IF;

    IF txn_bcn_props IS NOT NULL AND txn_bcn_props.COUNT > 0 THEN
        EMD_BCN_SET_BCNTXN_PROPS(tgt_id, txn_id, txn_bcn_props, TRUE, result, err_desc);
    END IF;
EXCEPTION

    WHEN p_internal_error THEN
        LOG_SYS_ERR(result, 'EMD_BCN_REPL_TXN_PROPS: failed.');

    WHEN OTHERS THEN
        result := p_bcn_err_oraerr;
        err_desc := SUBSTR(SQLERRM, 1, p_err_maxlen);
        LOG_SYS_ERR(result, 'EMD_BCN_REPL_TXN_PROPS: db error: ' || err_desc);
END EMD_BCN_REPL_TXN_PROPS;

--------------------------------------------------------------------------
PROCEDURE EMD_BCN_EDIT_TXN_PROPS (
        tgt_id                  IN VARCHAR2,
        txn_id                  IN VARCHAR2,
        add_txn_props           IN MGMT_BCN_NVPAIR_ARRAY,
        rm_txn_props            IN MGMT_BCN_PNAMES_ARRAY,
        add_bcn_txn_props       IN MGMT_BCN_PERBCN_NVPAIR_ARRAY,
        rm_bcn_txn_props        IN MGMT_BCN_PERBCN_PNAMES_ARRAY,
        result                  OUT INTEGER,
        err_desc                OUT VARCHAR2)
IS
    v_beacon                RAW(16);
    v_counter               PLS_INTEGER;
    v_propnames             MGMT_BCN_PNAMES_ARRAY;
BEGIN
    IF tgt_id IS NULL OR txn_id IS NULL THEN
        result := p_bcn_err_badparams;
        RETURN;
    END IF;

    IF rm_txn_props IS NOT NULL AND rm_txn_props.COUNT > 0 THEN
        EMD_BCN_RM_TXN_PROPS(tgt_id, txn_id, rm_txn_props, result, err_desc);
    END IF;
    
    IF add_txn_props IS NOT NULL AND add_txn_props.COUNT > 0 THEN
        EMD_BCN_SET_TXN_PROPS(tgt_id, txn_id, add_txn_props, FALSE, 
                result, err_desc);
    END IF;

    IF rm_bcn_txn_props IS NOT NULL AND rm_bcn_txn_props.COUNT > 0 THEN
        FOR v_counter IN 1..rm_bcn_txn_props.COUNT LOOP    
            v_beacon := HEXTORAW(rm_bcn_txn_props(v_counter).bcn_guid);   
            v_propnames := rm_bcn_txn_props(v_counter).propnames;
            EMD_BCN_RM_BCNTXN_PROPS(tgt_id, txn_id, 
                    rm_bcn_txn_props(v_counter).bcn_guid, v_propnames, 
                    result, err_desc);
        END LOOP;
    END IF;
    
    IF add_bcn_txn_props IS NOT NULL AND add_bcn_txn_props.COUNT > 0 THEN
        EMD_BCN_SET_BCNTXN_PROPS(tgt_id, txn_id, add_bcn_txn_props, 
                FALSE, result, err_desc);
    END IF;
EXCEPTION

    WHEN p_internal_error THEN
        LOG_SYS_ERR(result, 'EMD_BCN_EDIT_TXN_PROPS: failed.');

    WHEN OTHERS THEN
        result := p_bcn_err_oraerr;
        err_desc := SUBSTR(SQLERRM, 1, p_err_maxlen);
        LOG_SYS_ERR(result, 'EMD_BCN_EDIT_TXN_PROPS: db error: ' || err_desc);
END EMD_BCN_EDIT_TXN_PROPS;

--------------------------------------------------------------------------
PROCEDURE EMD_BCN_GET_TXN (
        tgt_id                  IN VARCHAR2,
        txn_id                  IN VARCHAR2,
        include_props           IN BOOLEAN,
        txn_def_with_props      OUT MGMT_BCN_TXN_WITH_PROPS,
        result                  OUT INTEGER, 
        err_desc                OUT VARCHAR2)
IS
    CURSOR txn_def_cur (target RAW, txn RAW) IS
        SELECT name, txn_type, description, version, is_representative, state
        FROM MGMT_BCN_TXN_DEFN
        WHERE target_guid = target
            AND txn_guid = txn;

    v_target                RAW(16);
    v_transaction           RAW(16);
    
    v_txn_def               mgmt_bcn_txn;
    v_txn_props             mgmt_bcn_nvpair_array;
    v_bcntxn_props          mgmt_bcn_perbcn_nvpair_array;
    v_txn_def_rec           txn_def_cur%ROWTYPE;
    v_tz                    VARCHAR2(64);
    v_is_template           BOOLEAN;
    
    v_tmpl                  CHAR(1);
BEGIN
    IF tgt_id IS NULL OR txn_id IS NULL THEN
        result := p_bcn_err_badparams;
        RETURN;
    END IF;
    
    v_target := HEXTORAW(tgt_id);
    v_transaction := HEXTORAW(txn_id);
    v_is_template := EMD_BCN_IS_TEMPLATE(v_target);
    IF v_is_template THEN
        v_tmpl := 'Y';
    ELSE
        v_tmpl := 'N';
    END IF;

    -- Get the txn definition
    OPEN txn_def_cur(v_target, v_transaction);
    FETCH txn_def_cur INTO v_txn_def_rec;
        IF NOT txn_def_cur%FOUND THEN
            result := p_bcn_err_txnnotfound;
            RAISE p_internal_error;
        END IF;
    CLOSE txn_def_cur;

    v_tz := NULL;
    IF NOT v_is_template THEN
        -- Get the timezone for the target; try the host if unavailable
        SELECT timezone_region
        INTO v_tz
        FROM MGMT_TARGETS
        WHERE target_guid = v_target
            AND rownum = 1;
    
        -- if the tz is set to null, get the host's
        IF v_tz IS NULL THEN
            SELECT t2.timezone_region
            INTO v_tz
            FROM MGMT_TARGETS t1, MGMT_TARGETS t2
            WHERE t1.target_guid = v_target
                AND t1.emd_url = t2.emd_url
                AND t2.target_type = 'host'
                AND rownum = 1;
        END IF;
    END IF;

    v_txn_def := MGMT_BCN_TXN(
            txn_id, 
            v_txn_def_rec.txn_type,
            v_txn_def_rec.name, 
            v_txn_def_rec.description, 
            v_txn_def_rec.is_representative, 
            v_txn_def_rec.version, 
            v_tz, v_tmpl);
    v_txn_props := NULL;
    v_bcntxn_props := NULL;
    IF include_props THEN
        EMD_BCN_GET_TXN_PROPS(tgt_id, txn_id, v_txn_props, result, err_desc);
        EMD_BCN_GET_BCNTXN_PROPS(tgt_id, txn_id, v_bcntxn_props, result, err_desc);
    END IF;

    txn_def_with_props := MGMT_BCN_TXN_WITH_PROPS(v_txn_def, v_txn_props, 
            v_bcntxn_props);
        
    result := p_bcn_success;
    err_desc := NULL;

EXCEPTION

    WHEN p_internal_error THEN
        result := p_bcn_err_oraerr;
        err_desc := SUBSTR(SQLERRM, 1, p_err_maxlen);
        LOG_SYS_ERR(result, 'EMD_BCN_GET_TXN: failed.');
        IF txn_def_cur%ISOPEN THEN
            CLOSE txn_def_cur;
        END IF;
        IF v_txn_props IS NOT NULL THEN
            v_txn_props.DELETE;
            v_txn_props := NULL;
        END IF;
        IF v_bcntxn_props IS NOT NULL THEN
            v_bcntxn_props.DELETE;
            v_bcntxn_props := NULL;
        END IF;

    WHEN OTHERS THEN
        result := p_bcn_err_oraerr;
        err_desc := SUBSTR(SQLERRM, 1, p_err_maxlen);
        LOG_SYS_ERR(result, 'EMD_BCN_GET_TXN: db error: ' || err_desc);
        IF txn_def_cur%ISOPEN THEN
            CLOSE txn_def_cur;
        END IF;
        IF v_txn_props IS NOT NULL THEN
            v_txn_props.DELETE;
            v_txn_props := NULL;
        END IF;
        IF v_bcntxn_props IS NOT NULL THEN
            v_bcntxn_props.DELETE;
            v_bcntxn_props := NULL;
        END IF;

END EMD_BCN_GET_TXN;

--------------------------------------------------------------------------
-- PRIVATE function to submit beacon update collections job for a given 
-- test to all associated beacons
--------------------------------------------------------------------------
FUNCTION EMD_BCN_SUBMIT_TEST_JOB(
        tgt_id            IN RAW,
        txn_id            IN RAW,
        txn_name          IN VARCHAR2,
        txn_type          IN VARCHAR2,
        add_remove_coll   IN NUMBER,
        rm_key_values     IN SMP_EMD_STRING_ARRAY,
        action_desc       IN VARCHAR2, 
        jobs              OUT MGMT_GENSVC_UBJOB_JOB_ARRAY) RETURN VARCHAR2
IS 
  v_txn_array           MGMT_GENSVC_UBJOB_TEST_ARRAY; 
  v_tgt_name            MGMT_TARGETS.TARGET_NAME%TYPE;
  v_tgt_type            MGMT_TARGETS.TARGET_TYPE%TYPE;
  v_err_msg             VARCHAR2(256) := NULL;
BEGIN
    
    IF ( ( tgt_id IS NULL ) OR ( txn_id IS NULL) OR (txn_type IS NULL ) OR 
         (txn_name IS NULL ) OR ( action_desc IS NULL) ) THEN 
        v_err_msg := 'Invalid parameters for update beacon collections job';
        RETURN v_err_msg;
    END IF; 

    IF ( add_remove_coll <> p_add_collection ) AND
       ( add_remove_coll <> p_remove_collection ) THEN 
        v_err_msg := 'Invalid action for update beacon collections job';
        RETURN v_err_msg; 
    END IF;

    SELECT target_name, target_type 
      INTO v_tgt_name, v_tgt_type
      FROM mgmt_targets 
     WHERE target_guid = tgt_id; 

    v_txn_array := MGMT_GENSVC_UBJOB_TEST_ARRAY();
    v_txn_array.extend;

    v_txn_array(1) := MGMT_GENSVC_UBJOB_TEST( txn_name, txn_type, txn_id,
                                                 0, add_remove_coll);
    --submit job for all associated beacons
    MGMT_GENSVC_UPDBCN.UPDATE_TESTS( v_tgt_name, v_tgt_type,
                     v_txn_array, FALSE, rm_key_values, action_desc, jobs );
    RETURN NULL;
END EMD_BCN_SUBMIT_TEST_JOB;
--------------------------------------------------------------------------
--------------------------------------------------------------------------
-- EMD_BCN_TXN_CREATE
-- This procedure is a wrapper around the procedure to throw exceptions
-- This procedure will call main transaction create procedure and convert 
-- error messages to proper exceptions. 
-- EXCEPTION: 
--  MGMT_GLOBAL.SQL_EXECUTION_ERR;
--  MGMT_GLOBAL.INVALID_PARAMS_ERR;
--  MGMT_GLOBAL.INVALID_TEST_DEFINITION_ERR;
--  MGMT_GLOBAL.INSUFFICIENT_PRIVILEGES_ERR;

PROCEDURE EMD_BCN_TXN_CREATE(
        tgt_id                  IN VARCHAR2,
        txn_defn_with_props     IN MGMT_BCN_TXN_WITH_PROPS,
        steps_defn_with_props   IN MGMT_BCN_STEP_WITH_PROPS_ARRAY,
        stepgroups_defn         IN MGMT_BCN_STEPGROUP_ARRAY,
        txn_thresholds          IN MGMT_BCN_THRESHOLD_ARRAY,
        step_thresholds         IN MGMT_BCN_THRESHOLD_ARRAY,
        stepgroup_thresholds    IN MGMT_BCN_THRESHOLD_ARRAY,
        for_push                IN VARCHAR2,
        new_txn_id              OUT VARCHAR2,
        new_version             OUT INTEGER,
        bcn_list                OUT MGMT_BCN_ARRAY)
IS 
l_result INTEGER;
l_err_desc VARCHAR2(2048);
BEGIN
    EMD_BCN_TXN_CREATE( tgt_id, txn_defn_with_props,
        steps_defn_with_props, stepgroups_defn, txn_thresholds,
        step_thresholds, stepgroup_thresholds, for_push,
        new_txn_id, new_version, bcn_list, l_result, l_err_desc);
  
    CASE l_result 
        WHEN p_bcn_success THEN
            RETURN;
        WHEN p_bcn_err_oraerr THEN
            l_result := MGMT_GLOBAL.SQL_EXECUTION_ERR;
        WHEN p_bcn_err_badparams THEN
            l_result := MGMT_GLOBAL.INVALID_PARAMS_ERR;
        WHEN p_bcn_err_dupid THEN
            l_result := MGMT_GLOBAL.INVALID_TEST_DEFINITION_ERR;
            l_err_desc := 'Service Test and type already exists. Name = '||txn_defn_with_props.txn_defn.name ||', Type = '||txn_defn_with_props.txn_defn.txn_type; 
        WHEN p_bcn_err_tgtnotfound THEN
            l_result := MGMT_GLOBAL.INVALID_PARAMS_ERR;
            l_err_desc := MGMT_GLOBAL.TARGET_DOES_NOT_EXIST_ERR_M ;
        WHEN p_bcn_err_invalidtxn THEN
            l_result := MGMT_GLOBAL.INVALID_TEST_DEFINITION_ERR;
            l_err_desc := MGMT_GLOBAL.INSUFFICIENT_PRIVILEGES_ERR_M;
        WHEN p_err_use_bcn_priv_req THEN
            l_result := MGMT_GLOBAL.INSUFFICIENT_PRIVILEGES_ERR;
            l_err_desc := MGMT_GLOBAL.INSUFFICIENT_PRIVILEGES_ERR_M;
        WHEN p_err_operator_priv_req THEN
            l_result := MGMT_GLOBAL.INSUFFICIENT_PRIVILEGES_ERR;
            l_err_desc := MGMT_GLOBAL.INSUFFICIENT_PRIVILEGES_ERR_M;
        ELSE
            l_result := MGMT_GLOBAL.INVALID_TEST_DEFINITION_ERR;
    END CASE;
    raise_application_error(l_result, l_err_desc);
   
END;

--------------------------------------------------------------------------
PROCEDURE EMD_BCN_TXN_CREATE_EDIT(
        tgt_id                  IN RAW,
        txn_defn_with_props     IN MGMT_BCN_TXN_WITH_PROPS,
        remove_existing_props   IN BOOLEAN,
        for_push                IN VARCHAR2,
        txn_thresholds          IN MGMT_BCN_THRESHOLD_ARRAY,
        new_txn_id              OUT RAW,
        new_version             OUT INTEGER,
        is_rep                  OUT CHAR,
        txn_state               OUT VARCHAR2,
        result                  OUT INTEGER,
        err_desc                OUT VARCHAR2)
IS
    
    v_txn                    RAW(16);
    
    v_bcn_ctr                PLS_INTEGER;
    v_beacons                MGMT_BCN_ARRAY;
    v_beacon                 RAW(16);
    v_propnames              MGMT_BCN_PNAMES_ARRAY;
    v_thresholds             MGMT_BCN_THRESHOLD_ARRAY; 
    v_version                INTEGER;
    v_num_invalid_beacons    INTEGER;
    v_assoc_bcn_min_ver      NUMBER;
    v_test_metadata          MGMT_TEST_METADATA_OBJ;
BEGIN
    IF tgt_id IS NULL OR txn_defn_with_props IS NULL THEN
        result := p_bcn_err_badparams;
        RETURN;
    END IF;

    MGMT_TEST_METADATA_READ.READ_TEST_METADATA( 
           txn_defn_with_props.txn_defn.txn_type, v_test_metadata, result, err_desc);
    IF ( v_test_metadata IS NULL ) OR ( result < 0 ) THEN 
        raise_application_error(MGMT_GLOBAL.TEST_METADATA_READ_ERR, MGMT_GLOBAL.TEST_METADATA_READ_ERROR_M);
    END IF;


    -- Check if this test type is supported by all existing 
    -- associated beacons 
    SELECT COUNT(*)
      INTO v_num_invalid_beacons
      FROM mgmt_targets tgt, mgmt_bcn_target bcn
     WHERE bcn.target_guid=tgt_id
       AND bcn.beacon_target_guid = tgt.target_guid
       AND tgt.target_type=p_beacon_type
       AND (em_target.compare_type_meta_vers(tgt.type_meta_ver, 
                                       v_test_metadata.min_beacon_ver) < 0);
   
    IF (v_num_invalid_beacons <> 0) THEN
        raise_application_error(MGMT_GLOBAL.ASSOC_BCN_TEST_NOT_SUPP_ERR, MGMT_GLOBAL.ASSOC_BCN_TEST_NOT_SUPP_ERR_M);
    END IF;

    -- If it has been defined as the representative txn, remove 
    -- this tag from the previous one.
    is_rep := 'N';
    IF txn_defn_with_props.txn_defn.is_representative = 'Y' THEN
        is_rep := 'Y';
    END IF;

    -- Add records in MGMT_BCN_TARGET_TXN and in the composite key table for each beacon
    v_beacons := EMD_BCN_GET_BEACONS(RAWTOHEX(tgt_id), NULL);

    -- Create the txn record.  This generates the txn_guid
    IF txn_defn_with_props.txn_defn.txn_guid IS NOT NULL THEN
        -- We have an existing transaction GUID. This must be an edit.
        v_txn := HEXTORAW(txn_defn_with_props.txn_defn.txn_guid);

        -- Verify that the transaction exists
        BEGIN
            SELECT version, state
            INTO v_version, txn_state
            FROM MGMT_BCN_TXN_DEFN
            WHERE target_guid = tgt_id
                AND txn_guid = v_txn
                AND name = txn_defn_with_props.txn_defn.name;
        EXCEPTION
            WHEN NO_DATA_FOUND THEN
                result := p_bcn_err_txnnotfound;
                RAISE p_internal_error;
        END;

        -- Update the txn record.
        -- pre 10.2.0.4, txn type is not changable.
        -- in  10.2.0.4, we wanted to save the txn_type information as well
        -- but this turned out to be very problematic, thus we disabled
        -- this feature in the UI, apply template disallow this as well.
        UPDATE MGMT_BCN_TXN_DEFN
        SET description = txn_defn_with_props.txn_defn.description, 
            version = v_version + 1,
	    is_representative = txn_defn_with_props.txn_defn.is_representative
        WHERE target_guid = tgt_id
            AND txn_guid = v_txn
            AND name = txn_defn_with_props.txn_defn.name;

        UPDATE MGMT_GENSVC_AVAIL_TESTS
        set test_type = txn_defn_with_props.txn_defn.txn_type
        WHERE target_guid = tgt_id
          AND test_guid = v_txn
          AND test_name = txn_defn_with_props.txn_defn.name;

        -- New transaction id is the same as the old one
        new_txn_id := HEXTORAW(txn_defn_with_props.txn_defn.txn_guid);
        new_version := v_version + 1;
        
        -- Audit the change
        EMD_BCN_AUDIT(tgt_id, new_txn_id, p_txn, TRUE, FALSE, FALSE, FALSE, 
                NULL, new_version, 'New version is ' || new_version);

    ELSE
        -- This is a new transaction
        BEGIN 
            INSERT INTO MGMT_BCN_TXN_DEFN
                (target_guid, txn_type, name, description, 
                is_representative, state )
            VALUES
                (tgt_id, txn_defn_with_props.txn_defn.txn_type,
                txn_defn_with_props.txn_defn.name, 
                txn_defn_with_props.txn_defn.description,
                is_rep, 
                DECODE(for_push, 'Y', 'M', 'NM') );
        EXCEPTION
            WHEN DUP_VAL_ON_INDEX THEN 
            new_txn_id := NULL;
            result := p_bcn_err_dupid;
            err_desc := txn_defn_with_props.txn_defn.name; 
        END;
   
        IF (result <> p_bcn_success) THEN
          return;
        END IF;
        -- Get the transaction guid, version and state
        SELECT txn_guid, version, state
        INTO new_txn_id, new_version, txn_state
        FROM MGMT_BCN_TXN_DEFN
        WHERE target_guid = tgt_id 
            AND name = txn_defn_with_props.txn_defn.name;

        -- Audit the creation
        EMD_BCN_AUDIT(tgt_id, new_txn_id, p_txn, TRUE, FALSE, FALSE, TRUE, 
                NULL, new_version, 'Creation, version ' || new_version);

        IF (v_beacons IS NOT NULL AND v_beacons.COUNT > 0) THEN
            FOR v_bcn_ctr IN 1..v_beacons.COUNT LOOP
                -- Add a record in the composite key table for the transaction
                EMD_BCN_CREATE_COMPOSITE_KEY(tgt_id, 
                        txn_defn_with_props.txn_defn.name, v_beacons(v_bcn_ctr).bcn_target_name, NULL);
            END LOOP; 
        END IF;
    END IF;
    
    -- Validate that the availability transaction is 
    -- in monitoring state
    IF ( is_rep = 'Y' ) AND (txn_state <> 'M' ) THEN 
        result := p_bcn_err_reptxn;
        err_desc := 'Key test can not be in unmonitored state';
        RETURN;
    END IF;

    -- Set transaction level properties
    IF txn_defn_with_props.txn_props IS NOT NULL
            AND txn_defn_with_props.txn_props.COUNT > 0 THEN
        -- DBMS_OUTPUT.PUT_LINE('Processing transaction level properties');
        EMD_BCN_SET_TXN_PROPS(RAWTOHEX(tgt_id), RAWTOHEX(new_txn_id),
                txn_defn_with_props.txn_props, remove_existing_props,
                result, err_desc);
        IF result <> p_bcn_success THEN
            RETURN;
        END IF;
    END IF;
    IF txn_defn_with_props.bcn_txn_props IS NOT NULL
            AND txn_defn_with_props.bcn_txn_props.COUNT > 0 THEN
        -- DBMS_OUTPUT.PUT_LINE('Processing transaction level per-beacon properties');
        EMD_BCN_SET_BCNTXN_PROPS(RAWTOHEX(tgt_id), RAWTOHEX(new_txn_id),
                txn_defn_with_props.bcn_txn_props, remove_existing_props,
                result, err_desc);
        IF result <> p_bcn_success THEN
            RETURN;
        END IF;
    END IF;

    IF txn_thresholds IS NULL OR txn_thresholds.COUNT = 0 THEN
        RETURN;
    END IF;

    v_thresholds := MGMT_BCN_THRESHOLD_ARRAY();
    -- Pick out the default thresholds for this transaction
    EMD_BCN_FILTER_APPEND_THRESH(NULL, NULL, 
            txn_defn_with_props.txn_defn.name, RAWTOHEX(new_txn_id), 
            NULL, NULL,
            NULL, txn_thresholds, v_thresholds);

    -- Pick out thresholds for each beacon for this transaction
    IF (v_beacons IS NOT NULL AND v_beacons.COUNT > 0) THEN
        FOR v_bcn_ctr IN 1..v_beacons.COUNT LOOP
            EMD_BCN_FILTER_APPEND_THRESH(
                    v_beacons(v_bcn_ctr).bcn_guid,
                    v_beacons(v_bcn_ctr).bcn_guid, 
                    txn_defn_with_props.txn_defn.name, RAWTOHEX(new_txn_id), 
                    NULL, NULL, 
                    NULL, txn_thresholds, v_thresholds);
        END LOOP;
    END IF;
    
    -- Add the thresholds using the threshold list created above
    IF v_thresholds IS NOT NULL AND v_thresholds.COUNT > 0 THEN
        EMD_BCN_SET_THRESH(tgt_id, v_thresholds, p_txn, result, err_desc);
        -- clean up
        v_thresholds.DELETE;
        v_thresholds := NULL;
        IF result <> p_bcn_success THEN
            RAISE p_internal_error;
        END IF;  
    END IF;

    result := p_bcn_success;
    err_desc := NULL;
END EMD_BCN_TXN_CREATE_EDIT;

--------------------------------------------------------------------------
/*
PROCEDURE EMD_BCN_EDIT_TXN (
        tgt_id                  IN VARCHAR2,
        txn_defn_with_props     IN MGMT_BCN_TXN_WITH_PROPS,
        for_push                IN VARCHAR2,
        new_version             OUT INTEGER,
        result                  OUT INTEGER,
        err_desc                OUT VARCHAR2)
IS
    v_target                    RAW(16);
    v_txn_id                    RAW(16);

    v_is_rep                    CHAR(1);
    
    v_state                     VARCHAR2(8);
BEGIN
    IF tgt_id IS NULL OR txn_defn_with_props IS NULL THEN
        result := p_bcn_err_badparams;
        RETURN;
    END IF;
    
    v_target := HEXTORAW(tgt_id);

    EMD_BCN_TXN_CREATE_EDIT(v_target, txn_defn_with_props, FALSE, for_push, NULL,
            v_txn_id, new_version, v_is_rep, v_state, result, err_desc);

EXCEPTION

    WHEN p_internal_error THEN
        LOG_SYS_ERR(result, 'EMD_BCN_EDIT_TXN: failed.');

    WHEN OTHERS THEN
        result := p_bcn_err_oraerr;
        err_desc := SUBSTR(SQLERRM, 1, p_err_maxlen);
        LOG_SYS_ERR(result, 'EMD_BCN_EDIT_TXN: db error: ' || err_desc);

END EMD_BCN_EDIT_TXN;

*/

--------------------------------------------------------------------------
PROCEDURE EMD_BCN_TXN_CREATE (
        tgt_id                  IN VARCHAR2,
        txn_defn_with_props     IN MGMT_BCN_TXN_WITH_PROPS,
        txn_thresholds          IN MGMT_BCN_THRESHOLD_ARRAY,
        for_push                IN VARCHAR2,
        new_txn_id              OUT RAW,
        new_version             OUT INTEGER,
        is_rep                  OUT CHAR,
        txn_state               OUT VARCHAR2,
        result                  OUT INTEGER,
        err_desc                OUT VARCHAR2)
IS
    v_target                 RAW(16);
BEGIN
    IF tgt_id IS NULL OR txn_defn_with_props IS NULL THEN
        result := p_bcn_err_badparams;
        RETURN;
    END IF;

    v_target := HEXTORAW(tgt_id);    

    -- Create the transaction definition
    EMD_BCN_TXN_CREATE_EDIT(v_target, txn_defn_with_props, FALSE, for_push, txn_thresholds,
            new_txn_id, new_version, is_rep, txn_state, result, err_desc);
END EMD_BCN_TXN_CREATE;

-------------------------------------------------------------------------
-- STEP-LEVEL OPERATIONS
-------------------------------------------------------------------------

PROCEDURE EMD_BCN_GET_STEP_PROPS (
        target_id               IN VARCHAR2,
        step_id                 IN VARCHAR2,
        props                   OUT mgmt_bcn_nvpair_array,
        result                  OUT INTEGER,
        err_desc                OUT VARCHAR2)
IS
    CURSOR props_cursor(tgt_id RAW, step_id RAW) IS
        SELECT *        
        FROM MGMT_BCN_STEP_PROPS
        WHERE target_guid = tgt_id 
            AND step_guid = step_id;
    
    v_target                RAW(16);
    v_step                  RAW(16);

    v_prop                  props_cursor%ROWTYPE;
    v_more                  BOOLEAN;
    v_count                 INTEGER;
    v_string_value          VARCHAR2(4000);
BEGIN
    IF target_id IS NULL OR step_id IS NULL THEN
        result := p_bcn_err_badparams;
        RETURN;
    END IF;
    
    v_target := HEXTORAW(target_id);
    v_step := HEXTORAW(step_id);

    props := NULL;

    v_more := TRUE;
    v_count := 0;
    OPEN props_cursor(v_target, v_step);
    WHILE v_more LOOP
        FETCH props_cursor INTO v_prop;
        v_more := props_cursor%FOUND;
        IF v_more THEN
            IF props IS NULL THEN
                props := MGMT_BCN_NVPAIR_ARRAY();
            END IF;
            v_count := v_count + 1;
            props.EXTEND;
            IF v_prop.prop_type = p_string_prop_type 
                    AND v_prop.encrypted = 'Y' THEN
                v_string_value := decrypt(v_prop.string_value);
            ELSE
                v_string_value := v_prop.string_value;
            END IF;
            props(v_count) := MGMT_BCN_NVPAIR(
                    v_prop.name, v_prop.string_part,
                    v_string_value, v_prop.num_value, 
                    v_prop.date_value, v_prop.char_value, 
                    v_prop.prop_type, v_prop.encrypted, v_prop.template);
        END IF;
    END LOOP;
    CLOSE props_cursor;
    
    result := p_bcn_success;
    err_desc := NULL;
EXCEPTION
    WHEN p_internal_error THEN
        LOG_SYS_ERR(result, 'EMD_BCN_GET_STEP_PROPS: failed.');
        IF props_cursor%ISOPEN THEN
            CLOSE props_cursor;
        END IF;
        IF props IS NOT NULL THEN
            props.DELETE;
            props := NULL;
        END IF;

    WHEN OTHERS THEN
        result := p_bcn_err_oraerr;
        err_desc := SUBSTR(SQLERRM, 1, p_err_maxlen);
        LOG_SYS_ERR(result, 'EMD_BCN_GET_STEP_PROPS: db error: ' || err_desc);
        IF props_cursor%ISOPEN THEN
            CLOSE props_cursor;
        END IF;
        IF props IS NOT NULL THEN
            props.DELETE;
            props := NULL;
        END IF;
END EMD_BCN_GET_STEP_PROPS;

--------------------------------------------------------------------------
PROCEDURE EMD_BCN_GET_BCNSTEP_PROPS (
        target_id               IN VARCHAR2,
        step_id                 IN VARCHAR2,
        perbcn_props            OUT mgmt_bcn_perbcn_nvpair_array,
        result                  OUT INTEGER,
        err_desc                OUT VARCHAR2)
IS
    CURSOR beacons_cursor(tgt_id RAW, step_id RAW) IS
        SELECT DISTINCT bcn_guid
        FROM MGMT_BCN_BCNSTEP_PROPS
        WHERE target_guid = tgt_id
            AND step_guid = step_id;
    
    CURSOR bcnstep_props_cursor(tgt_id RAW, step_id RAW, beacon_id RAW) IS
        SELECT *        
        FROM MGMT_BCN_BCNSTEP_PROPS
        WHERE target_guid = tgt_id
            AND step_guid = step_id
            AND bcn_guid = beacon_id;
    
    v_target                RAW(16);
    v_step                  RAW(16);

    v_bcnstep_prop          bcnstep_props_cursor%ROWTYPE;
    v_beacon                beacons_cursor%ROWTYPE;
    v_more                  BOOLEAN;
    v_more_1                BOOLEAN;
    v_count                 INTEGER;
    v_count_1               INTEGER;
    v_props                 MGMT_BCN_NVPAIR_ARRAY;
    v_string_value          VARCHAR2(4000);
BEGIN
    IF target_id IS NULL OR step_id IS NULL THEN
        result := p_bcn_err_badparams;
        RETURN;
    END IF;
    
    v_target := HEXTORAW(target_id);
    v_step := HEXTORAW(step_id);

    perbcn_props := NULL;

    v_more := TRUE;
    v_count := 0;
    OPEN beacons_cursor(v_target, v_step);    
    WHILE v_more LOOP
        FETCH beacons_cursor INTO v_beacon;
        v_more := beacons_cursor%FOUND;
        IF v_more AND v_beacon.bcn_guid IS NOT NULL THEN
            IF perbcn_props IS NULL THEN
                perbcn_props := MGMT_BCN_PERBCN_NVPAIR_ARRAY();
            END IF;
        
            v_more_1 := TRUE;
            v_count_1 := 0;
            v_props := NULL;
            OPEN bcnstep_props_cursor(v_target, v_step, v_beacon.bcn_guid);
            WHILE v_more_1 LOOP
                FETCH bcnstep_props_cursor INTO v_bcnstep_prop;
                v_more_1 := bcnstep_props_cursor%FOUND;
                IF v_more_1 THEN
                    IF v_props IS NULL THEN
                        v_props := MGMT_BCN_NVPAIR_ARRAY();
                    END IF;
                    v_count_1 := v_count_1 + 1;
                    v_props.EXTEND;
                    IF v_bcnstep_prop.prop_type = p_string_prop_type 
                            AND v_bcnstep_prop.encrypted = 'Y' THEN
                        v_string_value := decrypt(v_bcnstep_prop.string_value);
                    ELSE
                        v_string_value := v_bcnstep_prop.string_value;
                    END IF;
                    v_props(v_count_1) := MGMT_BCN_NVPAIR(
                            v_bcnstep_prop.name,
                            v_bcnstep_prop.string_part,
                            v_string_value,
                            v_bcnstep_prop.num_value,
                            v_bcnstep_prop.date_value,
                            v_bcnstep_prop.char_value,
                            v_bcnstep_prop.prop_type,
                            v_bcnstep_prop.encrypted,
                            v_bcnstep_prop.template);
                END IF;
            END LOOP;
            
            IF v_props IS NOT NULL THEN
                v_count := v_count + 1;
                perbcn_props.EXTEND;
                perbcn_props(v_count) := MGMT_BCN_PERBCN_NVPAIR(
                        v_beacon.bcn_guid, v_props);
            END IF;
            CLOSE bcnstep_props_cursor;
        END IF;
    END LOOP;
    CLOSE beacons_cursor;
    
    result := p_bcn_success;
    err_desc := NULL;
EXCEPTION
    WHEN p_internal_error THEN
        LOG_SYS_ERR(result, 'EMD_BCN_GET_BCNSTEP_PROPS: failed.');
        IF beacons_cursor%ISOPEN THEN
            CLOSE beacons_cursor;
        END IF;
        IF bcnstep_props_cursor%ISOPEN THEN
            CLOSE bcnstep_props_cursor;
        END IF;
        IF v_props IS NOT NULL THEN
            v_props.DELETE;
            v_props := NULL;
        END IF;
        IF perbcn_props IS NOT NULL THEN
            perbcn_props.DELETE;
            perbcn_props := NULL;
        END IF;

    WHEN OTHERS THEN
        result := p_bcn_err_oraerr;
        err_desc := SUBSTR(SQLERRM, 1, p_err_maxlen);
        LOG_SYS_ERR(result, 'EMD_BCN_GET_BCNSTEP_PROPS: db error: ' || err_desc);
        IF beacons_cursor%ISOPEN THEN
            CLOSE beacons_cursor;
        END IF;
        IF bcnstep_props_cursor%ISOPEN THEN
            CLOSE bcnstep_props_cursor;
        END IF;
        IF v_props IS NOT NULL THEN
            v_props.DELETE;
            v_props := NULL;
        END IF;
        IF perbcn_props IS NOT NULL THEN
            perbcn_props.DELETE;
            perbcn_props := NULL;
        END IF;
END EMD_BCN_GET_BCNSTEP_PROPS;

--------------------------------------------------------------------------
PROCEDURE EMD_BCN_RM_STEP_PROPS (
        tgt_guid                IN VARCHAR2,
        step_guid               IN VARCHAR2,
        propnames               IN mgmt_bcn_pnames_array,
        result                  OUT INTEGER,
        err_desc                OUT VARCHAR2)
IS
    v_target                RAW(16);
    v_step                  RAW(16);
    v_counter               PLS_INTEGER;
BEGIN
    IF tgt_guid IS NULL OR step_guid IS NULL OR 
            (propnames IS NOT NULL AND propnames.COUNT <= 0) THEN
        result := p_bcn_err_badparams;
        RETURN;
    END IF;

    v_target := HEXTORAW(tgt_guid);
    v_step := HEXTORAW(step_guid);

    IF (propnames IS NULL) THEN
        -- Delete all properties corresponding to this step
        DELETE FROM MGMT_BCN_STEP_PROPS
        WHERE target_guid = v_target
            AND step_guid = v_step;
    ELSE    
        FOR v_counter IN 1..propnames.COUNT LOOP
            DELETE FROM MGMT_BCN_STEP_PROPS
            WHERE target_guid = v_target
                AND step_guid = v_step
                AND name = propnames(v_counter);
        END LOOP;
    END IF;

    result := p_bcn_success;
    err_desc := NULL;
EXCEPTION

    WHEN p_internal_error THEN
        LOG_SYS_ERR(result, 'EMD_BCN_RM_STEP_PROPS: failed.');

    WHEN OTHERS THEN
        result := p_bcn_err_oraerr;
        err_desc := SUBSTR(SQLERRM, 1, p_err_maxlen);
        LOG_SYS_ERR(result, 'EMD_BCN_RM_STEP_PROPS: ' || err_desc);

END EMD_BCN_RM_STEP_PROPS;

--------------------------------------------------------------------------
PROCEDURE EMD_BCN_RM_BCNSTEP_PROPS (
        tgt_guid                IN VARCHAR2,
        step_guid               IN VARCHAR2,
        bcn_guid                IN VARCHAR2,
        propnames               IN mgmt_bcn_pnames_array,
        result                  OUT INTEGER,
        err_desc                OUT VARCHAR2)
IS
    v_target                RAW(16);
    v_step                  RAW(16);
    v_beacon                RAW(16);
    v_counter               PLS_INTEGER;
BEGIN
    IF tgt_guid IS NULL OR step_guid IS NULL OR
            (propnames IS NOT NULL AND propnames.COUNT <= 0) THEN
        result := p_bcn_err_badparams;
        RETURN;
    END IF;

    v_target := HEXTORAW(tgt_guid);
    v_step := HEXTORAW(step_guid);
    
    IF (bcn_guid IS NULL) THEN
        IF (propnames IS NULL) THEN
            DELETE FROM MGMT_BCN_BCNSTEP_PROPS
            WHERE target_guid = v_target
                AND step_guid = v_step;
        ELSE
            FOR v_counter IN 1..propnames.COUNT LOOP
                DELETE FROM MGMT_BCN_BCNSTEP_PROPS
                WHERE target_guid = v_target
                    AND step_guid = v_step
                    AND name = propnames(v_counter);
            END LOOP;
        END IF;
    ELSE
        v_beacon := HEXTORAW(bcn_guid);
        IF (propnames IS NULL) THEN
            DELETE FROM MGMT_BCN_BCNSTEP_PROPS
            WHERE target_guid = v_target
                AND step_guid = v_step
                AND bcn_guid = v_beacon;
        ELSE
            FOR v_counter IN 1..propnames.COUNT LOOP
                DELETE FROM MGMT_BCN_BCNSTEP_PROPS
                WHERE target_guid = v_target
                    AND step_guid = v_step
                    AND bcn_guid = v_beacon
                    AND name = propnames(v_counter);
            END LOOP;
        END IF;
    END IF;
       
    result := p_bcn_success;
    err_desc := NULL;
EXCEPTION

    WHEN p_internal_error THEN
        LOG_SYS_ERR(result, 'EMD_BCN_RM_BCNSTEP_PROPS: failed.');

    WHEN OTHERS THEN
        result := p_bcn_err_oraerr;
        err_desc := SUBSTR(SQLERRM, 1, p_err_maxlen);
        LOG_SYS_ERR(result, 'EMD_BCN_RM_BCNSTEP_PROPS: ' || err_desc);

END EMD_BCN_RM_BCNSTEP_PROPS;

--------------------------------------------------------------------------
PROCEDURE EMD_BCN_SET_STEP_PROPS (
        tgt_guid                IN VARCHAR2,
        step_guid               IN VARCHAR2,
        properties              IN mgmt_bcn_nvpair_array,
        remove_existing         IN BOOLEAN,
        result                  OUT INTEGER,
        err_desc                OUT VARCHAR2)
IS
    v_target                RAW(16);
    v_step                  RAW(16);
    v_counter               PLS_INTEGER;
    v_propnames             MGMT_BCN_PNAMES_ARRAY;
    v_string_value          VARCHAR2(4000);
    v_tmp                   INTEGER;
BEGIN
    IF tgt_guid IS NULL OR step_guid IS NULL OR properties IS NULL OR 
            properties.COUNT <= 0 THEN
        result := p_bcn_err_badparams;
        RETURN;
    END IF;
    
    v_target := HEXTORAW(tgt_guid);
    v_step := HEXTORAW(step_guid);
    
    -- First delete existing property entries for the properties,
    -- all of them if remove_exising is true, else only those that are being set.
    IF (remove_existing) THEN
        -- DBMS_OUTPUT.PUT_LINE('Removing all existing step properites');
        EMD_BCN_RM_STEP_PROPS(tgt_guid, step_guid, NULL, result, err_desc);
    ELSE    
        -- DBMS_OUTPUT.PUT_LINE('Removing all existing step properites');
        v_propnames := EMD_BCN_GET_PROPNAMES(properties);
        EMD_BCN_RM_STEP_PROPS(tgt_guid, step_guid, v_propnames, result, err_desc);
    END IF;

    FOR v_counter IN 1..properties.COUNT LOOP
        -- Encrypt string values that need to be encrypted
        IF (properties(v_counter).prop_type = p_string_prop_type AND
                    properties(v_counter).encrypt = 'Y') THEN
            v_string_value := encrypt(properties(v_counter).string_value);
        ELSE
            v_string_value := properties(v_counter).string_value;
        END IF;
        -- DBMS_OUTPUT.PUT_LINE('Storing property ' || properties(v_counter).name);
        -- Insert a new property entry.
        INSERT 
        INTO MGMT_BCN_STEP_PROPS
            (target_guid, step_guid, name, string_part, string_value, 
            num_value, date_value, char_value, prop_type, encrypted, template)
        VALUES
            (v_target, v_step, properties(v_counter).name,
            properties(v_counter).string_part, v_string_value, 
            properties(v_counter).num_value, properties(v_counter).date_value,
            properties(v_counter).char_value, properties(v_counter).prop_type, 
            properties(v_counter).encrypt, properties(v_counter).template);
    END LOOP;

    result := p_bcn_success;
    err_desc := NULL;
EXCEPTION

    WHEN p_internal_error THEN
        LOG_SYS_ERR(result, 'EMD_BCN_SET_STEP_PROPS: failed.');

    WHEN OTHERS THEN
        result := p_bcn_err_oraerr;
        err_desc := SUBSTR(SQLERRM, 1, p_err_maxlen);
        LOG_SYS_ERR(result, 'EMD_BCN_SET_STEP_PROPS: ' || err_desc);

END EMD_BCN_SET_STEP_PROPS;

--------------------------------------------------------------------------
PROCEDURE EMD_BCN_SET_BCNSTEP_PROPS (
        tgt_guid                IN VARCHAR2,
        step_guid               IN VARCHAR2,
        perbcn_props            IN mgmt_bcn_perbcn_nvpair_array,
        remove_existing         IN BOOLEAN,
        result                  OUT INTEGER,
        err_desc                OUT VARCHAR2)
IS
    v_target                RAW(16);
    v_step                  RAW(16);
    v_beacon                RAW(16);
    v_counter               PLS_INTEGER;
    v_counter1              PLS_INTEGER;
    v_properties            MGMT_BCN_NVPAIR_ARRAY;
    v_propnames             MGMT_BCN_PNAMES_ARRAY;
    v_string_value          VARCHAR2(4000);
BEGIN
    IF tgt_guid IS NULL OR step_guid IS NULL OR perbcn_props IS NULL OR 
            perbcn_props.COUNT <= 0 THEN
        result := p_bcn_err_badparams;
        RETURN;
    END IF;

    v_target := HEXTORAW(tgt_guid);
    v_step := HEXTORAW(step_guid);
    
    -- First delete existing property entries for all beacons for the step
    IF (remove_existing) THEN
        EMD_BCN_RM_BCNSTEP_PROPS(tgt_guid, step_guid, NULL, NULL, result, err_desc);
    END IF;    

    FOR v_counter IN 1..perbcn_props.COUNT LOOP    
        v_beacon := HEXTORAW(perbcn_props(v_counter).bcn_guid);

        v_properties := perbcn_props(v_counter).nvpairlist;
        -- Delete existing property entries, if remove_exsiting is FALSE
        IF (remove_existing = FALSE) THEN
            v_propnames := EMD_BCN_GET_PROPNAMES(v_properties);
            EMD_BCN_RM_BCNSTEP_PROPS(tgt_guid, step_guid, 
                    perbcn_props(v_counter).bcn_guid, v_propnames, result, err_desc);
        END IF;
    
        FOR v_counter_1 IN 1..v_properties.COUNT LOOP
            -- Encrypt string values that need to be encrypted
            IF (v_properties(v_counter_1).prop_type = p_string_prop_type AND 
                    v_properties(v_counter_1).encrypt = 'Y') THEN
                v_string_value := encrypt(v_properties(v_counter_1).string_value);
            ELSE
                v_string_value := v_properties(v_counter_1).string_value;
            END IF;
            -- Insert a new property entry.
            INSERT 
            INTO MGMT_BCN_BCNSTEP_PROPS
                (target_guid, step_guid, bcn_guid, name, string_part, string_value, 
                num_value, date_value, char_value, prop_type, encrypted, template)
            VALUES
                (v_target, 
                v_step,
                v_beacon,
                v_properties(v_counter_1).name,
                v_properties(v_counter_1).string_part,
                v_string_value, 
                v_properties(v_counter_1).num_value, 
                v_properties(v_counter_1).date_value, 
                v_properties(v_counter_1).char_value,
                v_properties(v_counter_1).prop_type, 
                v_properties(v_counter_1).encrypt,
                v_properties(v_counter_1).template);
        END LOOP;
    END LOOP;

    result := p_bcn_success;
    err_desc := NULL;
EXCEPTION
    WHEN p_internal_error THEN
        LOG_SYS_ERR(result, 'EMD_BCN_SET_BCNSTEP_PROPS: failed.');

    WHEN OTHERS THEN
        result := p_bcn_err_oraerr;
        err_desc := SUBSTR(SQLERRM, 1, p_err_maxlen);
        LOG_SYS_ERR(result, 'EMD_BCN_SET_BCNSTEP_PROPS: ' || err_desc);

END EMD_BCN_SET_BCNSTEP_PROPS;

--------------------------------------------------------------------------
-- EMD_BCN_REPL_STEP_PROPS
--
PROCEDURE EMD_BCN_REPL_STEP_PROPS (
        target_id               IN VARCHAR2,
        step_id                 IN VARCHAR2,
        step_props              IN MGMT_BCN_NVPAIR_ARRAY,
        result                  OUT INTEGER,
        err_desc                OUT VARCHAR2)
IS
BEGIN
    IF target_id IS NULL OR step_id IS NULL THEN
        result := p_bcn_err_badparams;
        RETURN;
    END IF;
    
    IF step_props IS NOT NULL AND step_props.COUNT > 0 THEN
        EMD_BCN_SET_STEP_PROPS(target_id, step_id, step_props, TRUE, result, err_desc);
    END IF;
EXCEPTION

    WHEN p_internal_error THEN
        LOG_SYS_ERR(result, 'EMD_BCN_REPL_STEP_PROPS: failed.');

    WHEN OTHERS THEN
        result := p_bcn_err_oraerr;
        err_desc := SUBSTR(SQLERRM, 1, p_err_maxlen);
        LOG_SYS_ERR(result, 'EMD_BCN_REPL_STEP_PROPS: db error: ' || err_desc);

END EMD_BCN_REPL_STEP_PROPS;

--------------------------------------------------------------------------
-- EMD_BCN_EDIT_STEP_PROPS
--
PROCEDURE EMD_BCN_EDIT_STEP_PROPS (
        target_id               IN VARCHAR2,
        step_id                 IN VARCHAR2,
        add_props               IN MGMT_BCN_NVPAIR_ARRAY,
        rm_props                IN MGMT_BCN_PNAMES_ARRAY,
        result                  OUT INTEGER,
        err_desc                OUT VARCHAR2)
IS
BEGIN
    IF target_id IS NULL OR step_id IS NULL THEN
        result := p_bcn_err_badparams;
        RETURN;
    END IF;

    IF rm_props IS NOT NULL AND rm_props.COUNT > 0 THEN
        EMD_BCN_RM_STEP_PROPS(target_id, step_id, rm_props, result, err_desc);
    END IF;
    
    IF add_props IS NOT NULL AND add_props.COUNT > 0 THEN
        EMD_BCN_SET_STEP_PROPS(target_id, step_id, add_props, FALSE, result, err_desc);
    END IF;
EXCEPTION

    WHEN p_internal_error THEN
        LOG_SYS_ERR(result, 'EMD_BCN_EDIT_STEP_PROPS: failed.');

    WHEN OTHERS THEN
        result := p_bcn_err_oraerr;
        err_desc := SUBSTR(SQLERRM, 1, p_err_maxlen);
        LOG_SYS_ERR(result, 'EMD_BCN_EDIT_STEP_PROPS: db error: ' || err_desc);

END EMD_BCN_EDIT_STEP_PROPS;

--------------------------------------------------------------------------
-- This procedure returns all the steps in the "step" order. 
PROCEDURE EMD_BCN_GET_STEPS(
        tgt_id                  IN VARCHAR2,
        txn_id                  IN VARCHAR2,
        include_props           IN BOOLEAN,
        steps_def_with_props    OUT MGMT_BCN_STEP_WITH_PROPS_ARRAY,
        result                  OUT INTEGER, 
        err_desc                OUT VARCHAR2)
IS
    CURSOR steps_in_txn_cur (tgt_id RAW, txn_id RAW) IS
        SELECT step1.step_guid, step1.step, step1.name, 
               step1.step_type, step1.parent_step_guid, 
               step2.name as parent_step_name
        FROM MGMT_BCN_STEP_DEFN step1,  MGMT_BCN_STEP_DEFN step2
        WHERE step1.target_guid = tgt_id 
            AND step1.txn_guid = txn_id
            AND step2.target_guid (+) = step1.target_guid 
            AND step2.txn_guid (+) = step1.txn_guid 
            AND step2.step_guid (+) = step1.parent_step_guid 
            ORDER BY step1.step ASC;
        
    /*
    CURSOR step_def_cur (tgt_id RAW, txn_id RAW, step_id RAW) IS
        SELECT step, name, step_type
        FROM MGMT_BCN_STEP_DEFN
        WHERE target_guid = tgt_id
            AND txn_guid = txn_id
            AND step_guid = step_id;
    */

    v_step_def              mgmt_bcn_step;
    v_step_props            mgmt_bcn_nvpair_array;
    v_steps_in_txn_rec      steps_in_txn_cur%ROWTYPE;
    --v_step_def_rec          step_def_cur%ROWTYPE;
    
    v_target                RAW(16);
    v_transaction           RAW(16);

    v_more                  BOOLEAN;
    v_count                 INTEGER;
BEGIN
    IF tgt_id IS NULL OR txn_id IS NULL THEN
        result := p_bcn_err_badparams;
        RETURN;
    END IF;
    
    v_target := HEXTORAW(tgt_id);
    v_transaction := HEXTORAW(txn_id);

    v_more := TRUE;
    v_count := 0;
    steps_def_with_props := NULL;
    /*
    OPEN steps_in_txn_cur(v_target, v_transaction);
    WHILE v_more LOOP
        FETCH steps_in_txn_cur INTO v_steps_in_txn_rec;
        v_more := steps_in_txn_cur%FOUND;
        IF v_more THEN
    */
    FOR v_steps_in_txn_rec in steps_in_txn_cur(v_target, v_transaction) LOOP 
        IF steps_def_with_props IS NULL THEN
            steps_def_with_props := MGMT_BCN_STEP_WITH_PROPS_ARRAY();
        END IF;
            
        /*
            -- Get the step definition
            OPEN step_def_cur(v_target, v_transaction, v_steps_in_txn_rec.step_guid);
            FETCH step_def_cur INTO v_step_def_rec;
                IF NOT step_def_cur%FOUND THEN
                    result := p_bcn_err_txnnotfound;
                    RAISE p_internal_error;
                END IF;
            CLOSE step_def_cur;
         */   
        v_step_def := MGMT_BCN_STEP(
                RAWTOHEX(v_steps_in_txn_rec.step_guid), 
                v_steps_in_txn_rec.step,
                v_steps_in_txn_rec.name,
                v_steps_in_txn_rec.step_type,
                v_steps_in_txn_rec.parent_step_guid, 
                v_steps_in_txn_rec.parent_step_name);
        
        v_step_props := NULL;
        IF include_props THEN
            EMD_BCN_GET_STEP_PROPS(tgt_id, RAWTOHEX(v_steps_in_txn_rec.step_guid), 
                    v_step_props, result, err_desc);
        END IF;
                
        v_count := v_count + 1;
        steps_def_with_props.EXTEND;
        
        steps_def_with_props(v_count) := MGMT_BCN_STEP_WITH_PROPS(
                v_step_def, v_step_props);
        --END IF;
    END LOOP;
    --CLOSE steps_in_txn_cur;
    
    result := p_bcn_success;
    err_desc := NULL;
EXCEPTION

    WHEN p_internal_error THEN
        result := p_bcn_err_oraerr;
        err_desc := SUBSTR(SQLERRM, 1, p_err_maxlen);
        LOG_SYS_ERR(result, 'EMD_BCN_GET_STEPS: failed.');
        IF steps_in_txn_cur%ISOPEN THEN
            CLOSE steps_in_txn_cur;
        END IF;
        IF v_step_props IS NOT NULL THEN
            v_step_props.DELETE;
            v_step_props := NULL;
        END IF;

    WHEN OTHERS THEN
        result := p_bcn_err_oraerr;
        err_desc := SUBSTR(SQLERRM, 1, p_err_maxlen);
        LOG_SYS_ERR(result, 'EMD_BCN_GET_STEPS: db error: ' || err_desc);
        IF steps_in_txn_cur%ISOPEN THEN
            CLOSE steps_in_txn_cur;
        END IF;
        IF v_step_props IS NOT NULL THEN
            v_step_props.DELETE;
            v_step_props := NULL;
        END IF;

END EMD_BCN_GET_STEPS;

-------------------------------------------------------------------------
PROCEDURE EMD_BCN_STEPS_RM (
        tgt_id                  IN VARCHAR2,
        txn_id                  IN VARCHAR2,
        step_ids                IN MGMT_BCN_STEPID_ARRAY,
        result                  OUT INTEGER,
        err_desc                OUT VARCHAR2)
IS
    v_target                RAW(16);
    v_transaction           RAW(16);
    v_step                  RAW(16);
    
    v_counter               PLS_INTEGER;
    v_stepcount             NUMBER;
    LOOP_DETECTED           EXCEPTION;
    PRAGMA EXCEPTION_INIT(LOOP_DETECTED, -01436);
BEGIN
    IF tgt_id IS NULL OR txn_id IS NULL OR step_ids IS NULL 
            OR step_ids.COUNT = 0 THEN
        result := p_bcn_err_badparams;
        RETURN;
    END IF;
    
    v_target := HEXTORAW(tgt_id);
    v_transaction := HEXTORAW(txn_id);
    
    -- remove the key values of the step
    IF (KEY_VALUE_DEL_CALLBACK(tgt_id, txn_id, step_ids, null, null, FALSE, err_desc) < 0) THEN
      result := p_bcn_err_invalidtxn;
      LOG_SYS_ERR(p_bcn_err_invalidtxn, 'EMD_BCN_STEPS_RM: KEY VALUE DEL CALLBACK failed. ');
      RAISE p_internal_error;
    END IF;

    FOR v_counter IN 1..step_ids.COUNT LOOP
        v_step := HEXTORAW(step_ids(v_counter));
        -- All the children of the node are deleted when their parent 
        -- is deleted. It is not necessary to proceed further when child of 
        -- a node is the current element in the loop, which has been deleted  
        -- already. This query checks if the step exists or not.  
        SELECT count(*) 
          INTO v_stepcount
          FROM MGMT_BCN_STEP_DEFN
         WHERE target_guid = v_target
           AND txn_guid = v_transaction
           AND step_guid = v_step;
 
        -- check if this step has already been deleted as 
        -- part part of its parent deletion 
        IF ( v_stepcount > 0 ) THEN 
            --Delete current step and its children recursively
            -- it deletes the steps even if there is a loop
            BEGIN
              DELETE FROM MGMT_BCN_STEP_DEFN 
               WHERE target_guid = v_target
                 AND txn_guid = v_transaction 
                 AND step_guid in (SELECT step_guid 
                                     FROM MGMT_BCN_STEP_DEFN 
                                    WHERE target_guid = v_target 
                                      AND txn_guid = v_transaction 
                                      START WITH step_guid = v_step 
                                      CONNECT BY 
                                      PRIOR step_guid = parent_step_guid);
            EXCEPTION
              WHEN LOOP_DETECTED THEN 
              result := p_bcn_err_step_loop_found;
              err_desc := 'Loop exists in the step tree. Validate the step tree';
              RAISE p_internal_error;
            END;
        END IF;
    END LOOP;

    
END EMD_BCN_STEPS_RM;

-----------------------------------------------------------------------
-- Check if the parent of the current step exists. If exists, it returns
-- the parent step guid. Otherwise, it returns null with p_bcn_err_parentnotfound 
-- error code
-----------------------------------------------------------------------
FUNCTION EMD_BCN_GET_PARENT_STEP_GUID (
        tgt_id                  IN RAW,
        txn_id                  IN RAW,
        step_defn               IN MGMT_BCN_STEP, 
        result                  OUT INTEGER,
        err_desc                OUT VARCHAR2)RETURN RAW
IS 
    v_parent_step_guid       RAW(16) := NULL;
BEGIN
    IF tgt_id IS NULL OR txn_id IS NULL OR step_defn IS NULL THEN 
        result := p_bcn_err_badparams;
        RETURN v_parent_step_guid;
    END IF;
    
    IF ( step_defn.parent_step_guid IS NULL ) AND (step_defn.parent_step_name IS NULL ) THEN 
        result := p_bcn_success;
        err_desc := NULL;
        RETURN v_parent_step_guid;
    END IF;
   
    SELECT step_guid
      INTO v_parent_step_guid 
      FROM MGMT_BCN_STEP_DEFN 
     WHERE target_guid = tgt_id
       AND txn_guid = txn_id
       AND ( step_guid = HEXTORAW(step_defn.parent_step_guid) 
             OR name = step_defn.parent_step_name);

    IF ( v_parent_step_guid IS NOT NULL ) THEN 
        result := p_bcn_success;
        err_desc := NULL;
    ELSE
        result := p_bcn_err_parentnotfound;
        err_desc := 'Parent for the step '|| step_defn.name||', '||
                    step_defn.parent_step_guid ||', ' ||step_defn.parent_step_name ||
                    ' not found.';
    END IF;
    RETURN v_parent_step_guid;

END EMD_BCN_GET_PARENT_STEP_GUID;
-------------------------------------------------------------------------

-------------------------------------------------------------------------
-- This procedure creates or edits given steps. This procedure assumes 
-- that the steps are in order. The parent step should ordered before 
-- any of its child steps. 
-------------------------------------------------------------------------
PROCEDURE EMD_BCN_STEPS_CREATE_EDIT (
        tgt_id                  IN RAW,
        txn_id                  IN RAW,
        steps_defn_with_props   IN MGMT_BCN_STEP_WITH_PROPS_ARRAY,
        remove_existing_props   IN BOOLEAN,
        step_thresholds         IN MGMT_BCN_THRESHOLD_ARRAY,
        result                  OUT INTEGER,
        err_desc                OUT VARCHAR2)
IS
    v_txn_name               VARCHAR2(64);

    v_stp                    RAW(16);
    v_step_ctr               PLS_INTEGER;
    v_bcn_ctr                PLS_INTEGER;

    v_name                   MGMT_TARGETS.TARGET_NAME%TYPE;
    v_beacons                MGMT_BCN_ARRAY;    
    v_parent_step_guid       RAW(16);
    v_dummy_ctr              PLS_INTEGER;
    v_stepgroup_name_count   INTEGER;
    v_thresholds             MGMT_BCN_THRESHOLD_ARRAY;
    LOOP_DETECTED            EXCEPTION;
    PRAGMA EXCEPTION_INIT(LOOP_DETECTED, -01436);
BEGIN
    IF tgt_id IS NULL OR txn_id IS NULL OR steps_defn_with_props IS NULL OR
            steps_defn_with_props.COUNT = 0 THEN
        result := p_bcn_err_badparams;
        RETURN;
    END IF;
    
    -- Find the transaction name
    SELECT name
    INTO v_txn_name
    FROM MGMT_BCN_TXN_DEFN
    WHERE target_guid = tgt_id
        AND txn_guid = txn_id;
    
    v_beacons := EMD_BCN_GET_BEACONS(RAWTOHEX(tgt_id), NULL);
    FOR v_step_ctr IN 1..steps_defn_with_props.COUNT LOOP

        -- check if the parent of the current step exists 
        v_parent_step_guid := EMD_BCN_GET_PARENT_STEP_GUID( tgt_id, txn_id, 
           steps_defn_with_props(v_step_ctr).step_defn, result, err_desc );

        IF result <> p_bcn_success THEN
            RAISE p_internal_error;
            RETURN;
        END IF;

        IF steps_defn_with_props(v_step_ctr).step_defn.step_guid IS NOT NULL THEN
            -- We already have a step guid. So this must be an edit of an existing step
            -- DBMS_OUTPUT.PUT_LINE('Editing step ' || 
            --         steps_defn_with_props(v_step_ctr).step_defn.step_guid);
            v_stp := HEXTORAW(steps_defn_with_props(v_step_ctr).step_defn.step_guid);
            UPDATE MGMT_BCN_STEP_DEFN
            SET
                step      = steps_defn_with_props(v_step_ctr).step_defn.step_number,
                -- pre 10.2.0.4, type is not changable.
                -- in  10.2.0.4: we found that change of test type
                -- e.g. dhtml to http and vice versa is problematic.
                -- step_type = steps_defn_with_props(v_step_ctr).step_defn.step_type,
                parent_step_guid = v_parent_step_guid
                -- Disallowing a name change for now. This should be allowed later.
                -- name = steps_defn_with_props(v_step_ctr).step_defn.name

            WHERE target_guid = tgt_id
                AND txn_guid = txn_id
                AND step_guid = v_stp;
            IF SQL%NOTFOUND THEN
                -- REVISIT: Error handling
                result := p_bcn_err_badparams;
                RETURN;
            END IF;
        ELSE
            -- This is a new step creation
            SELECT COUNT(*) 
              INTO v_stepgroup_name_count
              FROM mgmt_bcn_stepgroup_defn d
             WHERE d.target_guid = tgt_id
               AND d.txn_guid =txn_id 
               AND d.name = steps_defn_with_props(v_step_ctr).step_defn.name;

            IF (v_stepgroup_name_count = 0)
            THEN
                BEGIN 
                    INSERT INTO MGMT_BCN_STEP_DEFN
                        (target_guid, txn_guid, step, name, step_type, parent_step_guid)
                    VALUES
                        (tgt_id, 
                        txn_id,
                        steps_defn_with_props(v_step_ctr).step_defn.step_number, 
                        steps_defn_with_props(v_step_ctr).step_defn.name,
                        steps_defn_with_props(v_step_ctr).step_defn.step_type, 
                        v_parent_step_guid);
                EXCEPTION
                    WHEN DUP_VAL_ON_INDEX THEN
                      result := p_bcn_err_dup_in_steps;
                      err_desc := steps_defn_with_props(v_step_ctr).step_defn.name; 
                      RAISE p_internal_error;
                END;
            ELSE
              result := p_bcn_err_dup_in_steps_n_grps;
              err_desc := steps_defn_with_props(v_step_ctr).step_defn.name; 
              RAISE p_internal_error;
            END IF;

            
            -- Find the guid for the step
            SELECT step_guid
            INTO v_stp
            FROM MGMT_BCN_STEP_DEFN
            WHERE target_guid = tgt_id
                AND txn_guid = txn_id
                AND step = steps_defn_with_props(v_step_ctr).step_defn.step_number
                AND name = steps_defn_with_props(v_step_ctr).step_defn.name;

            -- DBMS_OUTPUT.PUT_LINE('Created step: ' ||
            --         steps_defn_with_props(v_step_ctr).step_defn.name);

            -- Add a record in the composite key table for each beacon
            
            IF (v_beacons IS NOT NULL AND v_beacons.COUNT > 0) THEN
                FOR v_bcn_ctr IN 1..v_beacons.COUNT LOOP
                    IF v_beacons(v_bcn_ctr).bcn_guid = tgt_id THEN
                        v_name := p_local_target_name;
                    ELSE
                        v_name := v_beacons(v_bcn_ctr).bcn_target_name;
                    END IF;
                    EMD_BCN_CREATE_COMPOSITE_KEY(tgt_id, v_txn_name, v_name, 
                            steps_defn_with_props(v_step_ctr).step_defn.name);
                END LOOP;
            END IF;
        END IF;

        -- Set step level properties
        IF steps_defn_with_props(v_step_ctr).step_props IS NOT NULL
                AND steps_defn_with_props(v_step_ctr).step_props.COUNT > 0 THEN
            EMD_BCN_SET_STEP_PROPS(RAWTOHEX(tgt_id), v_stp, 
                    steps_defn_with_props(v_step_ctr).step_props, 
                            remove_existing_props, result, err_desc);
            IF result <> p_bcn_success THEN
                RETURN;
            END IF;
        END IF;

    END LOOP;

    -- At the end of the steps creation, check if there are any loops 
    -- in the step tree.
    BEGIN
        SELECT COUNT(*) 
          INTO v_dummy_ctr
          FROM MGMT_BCN_STEP_DEFN 
         WHERE target_guid = tgt_id
           AND txn_guid = txn_id
         CONNECT BY PRIOR step_guid = parent_step_guid;
    EXCEPTION
        WHEN LOOP_DETECTED THEN 
            result := p_bcn_err_step_loop_found;
            err_desc := 'Loop exists in the step tree. Validate the step tree';
            RAISE p_internal_error;
    END;

    IF step_thresholds IS NULL or step_thresholds.COUNT = 0 THEN
        RETURN;
    END IF;

    -- Find the transaction name
    SELECT name
    INTO v_txn_name
    FROM MGMT_BCN_TXN_DEFN
    WHERE target_guid = tgt_id
        AND txn_guid = txn_id;

    v_thresholds := MGMT_BCN_THRESHOLD_ARRAY();
    FOR v_step_ctr IN 1..steps_defn_with_props.COUNT LOOP

        -- Find the guid for the step
        SELECT step_guid
        INTO v_stp
        FROM MGMT_BCN_STEP_DEFN
        WHERE target_guid = tgt_id
            AND txn_guid = txn_id
            AND step = steps_defn_with_props(v_step_ctr).step_defn.step_number
            AND name = steps_defn_with_props(v_step_ctr).step_defn.name;

        -- Pick out the default thresholds for this step
        EMD_BCN_FILTER_APPEND_THRESH(NULL, NULL, 
                v_txn_name, txn_id, 
                steps_defn_with_props(v_step_ctr).step_defn.name,
                RAWTOHEX(v_stp),
                NULL, step_thresholds, v_thresholds);
        -- Pick out the thresholds for beacon-step combinations
        IF (v_beacons IS NOT NULL AND v_beacons.COUNT > 0) THEN
            FOR v_bcn_ctr IN 1..v_beacons.COUNT LOOP
                EMD_BCN_FILTER_APPEND_THRESH(
                        v_beacons(v_bcn_ctr).bcn_guid,
                        v_beacons(v_bcn_ctr).bcn_guid,
                        v_txn_name, txn_id, 
                        steps_defn_with_props(v_step_ctr).step_defn.name,
                        RAWTOHEX(v_stp),
                        NULL, step_thresholds, v_thresholds);
            END LOOP;
        END IF;
    END LOOP;
    -- Add the thresholds using the threshold list created above
    IF v_thresholds IS NOT NULL AND v_thresholds.COUNT > 0 THEN
        EMD_BCN_SET_THRESH(tgt_id, v_thresholds, p_step,
                result, err_desc);
        -- clean up
        v_thresholds.DELETE;
        v_thresholds := NULL;
        IF result <> p_bcn_success THEN
            RAISE p_internal_error;
        END IF;  
    END IF;
    
    result := p_bcn_success;
    err_desc := NULL;
    
END EMD_BCN_STEPS_CREATE_EDIT;

--------------------------------------------------------------------------
PROCEDURE EMD_BCN_EDIT_STEPS (
        tgt_id                  IN VARCHAR2,
        txn_id                  IN VARCHAR2,
        add_steps               IN MGMT_BCN_STEP_WITH_PROPS_ARRAY,
        rm_steps                IN MGMT_BCN_STEPID_ARRAY,
        result                  OUT INTEGER,
        err_desc                OUT VARCHAR2)
IS
    v_target                RAW(16);
    v_transaction           RAW(16);
BEGIN
    IF tgt_id IS NULL OR txn_id IS NULL THEN
        result := p_bcn_err_badparams;
        RETURN;
    END IF;

    v_target := HEXTORAW(tgt_id);
    v_transaction := HEXTORAW(txn_id);
    
    IF rm_steps IS NOT NULL AND rm_steps.COUNT > 0 THEN
        EMD_BCN_STEPS_RM(tgt_id, txn_id, rm_steps, result, err_desc);
    END IF;
    
    IF add_steps IS NOT NULL AND add_steps.COUNT > 0 THEN
        EMD_BCN_STEPS_CREATE_EDIT(v_target, v_transaction, add_steps, FALSE, NULL, result, err_desc);
    END IF;
EXCEPTION

    WHEN p_internal_error THEN
        LOG_SYS_ERR(result, 'EMD_BCN_EDIT_STEPS: failed.');

    WHEN OTHERS THEN
        result := p_bcn_err_oraerr;
        err_desc := SUBSTR(SQLERRM, 1, p_err_maxlen);
        LOG_SYS_ERR(result, 'EMD_BCN_EDIT_STEPS: db error: ' || err_desc);

END EMD_BCN_EDIT_STEPS;

-------------------------------------------------------------------------
PROCEDURE EMD_BCN_STEPS_CREATE (
        tgt_id                  IN VARCHAR2,
        txn_id                  IN VARCHAR2,
        steps_defn_with_props   IN MGMT_BCN_STEP_WITH_PROPS_ARRAY,
        step_thresholds         IN MGMT_BCN_THRESHOLD_ARRAY,
        result                  OUT INTEGER,
        err_desc                OUT VARCHAR2)
IS
    v_target                 RAW(16);
    v_transaction            RAW(16);
BEGIN
    IF tgt_id IS NULL OR txn_id IS NULL OR steps_defn_with_props IS NULL OR
            steps_defn_with_props.COUNT = 0 THEN
        result := p_bcn_err_badparams;
        RETURN;
    END IF;

    v_target := HEXTORAW(tgt_id);
    v_transaction := HEXTORAW(txn_id);

    -- Create all the step definitions with properties
    EMD_BCN_STEPS_CREATE_EDIT(v_target, v_transaction, steps_defn_with_props, 
            FALSE, step_thresholds, result, err_desc);

END EMD_BCN_STEPS_CREATE;

-------------------------------------------------------------------------
-- STEPGROUP-LEVEL OPERATIONS
-------------------------------------------------------------------------

PROCEDURE EMD_BCN_GET_STEPGROUPS(
        target_id               IN VARCHAR2,
        txn_id                  IN VARCHAR2,
        include_steps           IN BOOLEAN,
        stepgroups_def          OUT MGMT_BCN_STEPGROUP_ARRAY,
        result                  OUT INTEGER, 
        err_desc                OUT VARCHAR2)
IS
    CURSOR stepgroups_in_txn_cur (tgt_id RAW, txn_id RAW) IS
        SELECT DISTINCT stepgroup_guid
        FROM MGMT_BCN_STEPGROUP_DEFN
        WHERE target_guid = tgt_id
            AND txn_guid = txn_id;
        
    CURSOR stepgroup_def_cur (tgt_id RAW, txn_id RAW, stepgroup_id RAW) IS
        SELECT name, stepgroup_type
        FROM MGMT_BCN_STEPGROUP_DEFN
        WHERE target_guid = tgt_id
            AND txn_guid = txn_id
            AND stepgroup_guid = stepgroup_id;
            
    CURSOR stepgroup_steps_cur (tgt_id RAW, txn_id RAW, stepgroup_id RAW) IS
        SELECT step_guid
        FROM MGMT_BCN_STEPGROUP_STEPS
        WHERE target_guid = tgt_id
            AND txn_guid = txn_id
            AND stepgroup_guid = stepgroup_id;
            
    v_stepgroup_def         mgmt_bcn_stepgroup;
    v_steps                 mgmt_bcn_stepid_array;
    v_stepgroups_in_txn_rec stepgroups_in_txn_cur%ROWTYPE;
    v_stepgroup_def_rec     stepgroup_def_cur%ROWTYPE;
    v_stepgroup_steps_rec   stepgroup_steps_cur%ROWTYPE;
    
    v_target                RAW(16);
    v_transaction           RAW(16);

    v_more                  BOOLEAN;
    v_more_1                BOOLEAN;
    v_count                 INTEGER;
    v_count_1               INTEGER;
BEGIN
    IF target_id IS NULL OR txn_id IS NULL THEN
        result := p_bcn_err_badparams;
        RETURN;
    END IF;

    v_target := HEXTORAW(target_id); 
    v_transaction := HEXTORAW(txn_id);
    v_more := TRUE;
    v_count := 0;
    stepgroups_def := NULL;
    OPEN stepgroups_in_txn_cur(v_target, v_transaction);
    WHILE v_more LOOP
        FETCH stepgroups_in_txn_cur INTO v_stepgroups_in_txn_rec;
        v_more := stepgroups_in_txn_cur%FOUND;
        IF v_more THEN
            IF stepgroups_def IS NULL THEN
                stepgroups_def := MGMT_BCN_STEPGROUP_ARRAY();
            END IF;
            
            -- Get the step group definition
            OPEN stepgroup_def_cur(v_target, v_transaction,
                    v_stepgroups_in_txn_rec.stepgroup_guid);
            FETCH stepgroup_def_cur INTO v_stepgroup_def_rec;
                IF NOT stepgroup_def_cur%FOUND THEN
                    result := p_bcn_err_txnnotfound;
                    RAISE p_internal_error;
                END IF;
            CLOSE stepgroup_def_cur;
            
            IF include_steps THEN
                v_more_1 := TRUE;
                v_count_1 := 0;
                v_steps := NULL;
                OPEN stepgroup_steps_cur(v_target, v_transaction, 
                        v_stepgroups_in_txn_rec.stepgroup_guid);
                WHILE v_more_1 LOOP
                    FETCH stepgroup_steps_cur INTO v_stepgroup_steps_rec;
                    v_more_1 := stepgroup_steps_cur%FOUND;
                    IF v_more_1 THEN
                        IF v_steps IS NULL THEN
                            v_steps := MGMT_BCN_STEPID_ARRAY();
                        END IF;
                        v_count_1 := v_count_1 + 1;
                        v_steps.EXTEND;
                        v_steps(v_count_1) := v_stepgroup_steps_rec.step_guid;
                    END IF;
                END LOOP;
                CLOSE stepgroup_steps_cur;
            END IF;
            
            v_count := v_count + 1;
            stepgroups_def.EXTEND;
            
            stepgroups_def(v_count) := MGMT_BCN_STEPGROUP(
                    RAWTOHEX(v_stepgroups_in_txn_rec.stepgroup_guid), 
                    v_stepgroup_def_rec.name, 
                    v_stepgroup_def_rec.stepgroup_type,
                    v_steps);
        END IF;
    END LOOP;
    CLOSE stepgroups_in_txn_cur;
    
    result := p_bcn_success;
    err_desc := NULL;
EXCEPTION

    WHEN p_internal_error THEN
        result := p_bcn_err_oraerr;
        err_desc := SUBSTR(SQLERRM, 1, p_err_maxlen);
        LOG_SYS_ERR(result, 'EMD_BCN_GET_STEPGROUPS: failed.');
        IF stepgroups_in_txn_cur%ISOPEN THEN
            CLOSE stepgroups_in_txn_cur;
        END IF;
        IF stepgroup_def_cur%ISOPEN THEN
            CLOSE stepgroup_def_cur;
        END IF;
        IF stepgroup_steps_cur%ISOPEN THEN
            CLOSE stepgroup_steps_cur;
        END IF;
        IF v_steps IS NOT NULL THEN
            v_steps.DELETE;
            v_steps := NULL;
        END IF;
        IF stepgroups_def IS NOT NULL THEN
            stepgroups_def.DELETE;
            stepgroups_def := NULL;
        END IF;

    WHEN OTHERS THEN
        result := p_bcn_err_oraerr;
        err_desc := SUBSTR(SQLERRM, 1, p_err_maxlen);
        LOG_SYS_ERR(result, 'EMD_BCN_GET_STEPGROUPS: db error: ' || err_desc);
        IF stepgroups_in_txn_cur%ISOPEN THEN
            CLOSE stepgroups_in_txn_cur;
        END IF;
        IF stepgroup_def_cur%ISOPEN THEN
            CLOSE stepgroup_def_cur;
        END IF;
        IF stepgroup_steps_cur%ISOPEN THEN
            CLOSE stepgroup_steps_cur;
        END IF;
        IF v_steps IS NOT NULL THEN
            v_steps.DELETE;
            v_steps := NULL;
        END IF;
        IF stepgroups_def IS NOT NULL THEN
            stepgroups_def.DELETE;
            stepgroups_def := NULL;
        END IF;

END EMD_BCN_GET_STEPGROUPS;

-------------------------------------------------------------------------
PROCEDURE EMD_BCN_STEPGROUPS_RM (
        target_id               IN VARCHAR2,
        txn_id                  IN VARCHAR2,
        stepgroup_ids           IN MGMT_BCN_STEPGROUPID_ARRAY,
        result                  OUT INTEGER,
        err_desc                OUT VARCHAR2)
IS
    v_target                RAW(16);
    v_transaction           RAW(16);
    v_stepgroup             RAW(16);
    
    v_counter               PLS_INTEGER;
BEGIN
    IF target_id IS NULL OR txn_id IS NULL OR stepgroup_ids IS NULL 
            OR stepgroup_ids.COUNT = 0 THEN
        result := p_bcn_err_badparams;
        RETURN;
    END IF;
    
    v_target := HEXTORAW(target_id);
    v_transaction := HEXTORAW(txn_id);

    -- remove the key values associated with step group
    IF (KEY_VALUE_DEL_CALLBACK(target_id, txn_id, null,stepgroup_ids, null, FALSE, err_desc) < 0) THEN
      result := p_bcn_err_invalidtxn;
      LOG_SYS_ERR(p_bcn_err_invalidtxn, 'EMD_BCN_STEPGROUPS_RM: KEY VALUE DEL CALLBACK failed. ');
      RAISE p_internal_error;
    END IF;
    
    FOR v_counter IN 1..stepgroup_ids.COUNT LOOP
        v_stepgroup := HEXTORAW(stepgroup_ids(v_counter));
        DELETE FROM MGMT_BCN_STEPGROUP_DEFN
        WHERE target_guid = target_id
            AND txn_guid = txn_id
            AND stepgroup_guid = v_stepgroup;
    END LOOP;

    

END EMD_BCN_STEPGROUPS_RM;

-------------------------------------------------------------------------
-- 
-------------------------------------------------------------------------
PROCEDURE EMD_BCN_STPGRP_CREATE_EDIT (
        tgt_id                  IN RAW,
        txn_id                  IN RAW,
        stepgroups_defn         IN MGMT_BCN_STEPGROUP_ARRAY,
        stepgroup_thresholds    IN MGMT_BCN_THRESHOLD_ARRAY,
        result                  OUT INTEGER,
        err_desc                OUT VARCHAR2)
IS
    v_txn_name               VARCHAR2(64);

    v_stp                    RAW(16);
    v_grp                    RAW(16);
    v_grp_ctr                PLS_INTEGER;
    v_step_ctr               PLS_INTEGER;
    v_bcn_ctr                PLS_INTEGER;
    v_non_member_step_count  PLS_INTEGER;
    v_step_name_count        INTEGER;
    v_name                   MGMT_TARGETS.TARGET_NAME%TYPE;
    v_thresholds             MGMT_BCN_THRESHOLD_ARRAY := NULL;    

    v_beacons                MGMT_BCN_ARRAY;
BEGIN
    IF tgt_id IS NULL OR txn_id IS NULL OR stepgroups_defn IS NULL OR
            stepgroups_defn.COUNT = 0 THEN
        result := p_bcn_err_badparams;
        RETURN;
    END IF;

    -- Find the transaction name
    SELECT name
    INTO v_txn_name
    FROM MGMT_BCN_TXN_DEFN
    WHERE target_guid = tgt_id
        AND txn_guid = txn_id;

    v_beacons := EMD_BCN_GET_BEACONS(RAWTOHEX(tgt_id), NULL);
    FOR v_grp_ctr IN 1..stepgroups_defn.COUNT LOOP
        -- Create the group definition
        IF stepgroups_defn(v_grp_ctr).stepgroup_guid IS NOT NULL THEN
            v_grp := HEXTORAW(stepgroups_defn(v_grp_ctr).stepgroup_guid);
            -- We already have a step guid. So this must be an edit of an existing step
            -- There is nothing to update in the stepgroup definition.
            -- For now the name is not editable.            
            --
            -- pre 10.2.0.4, type is not changable, 
            -- in 10.2.0.4, we want to change it (for DHTML to HTTP and vice versa)
            -- but that is problematic. 
            --
            -- UPDATE MGMT_BCN_STEPGROUP_DEFN
            -- SET
            --     name = stepgroups_defn(v_grp_ctr).name
            --  stepgroup_type = stepgroups_defn(v_grp_ctr).stepgroup_type
            -- WHERE target_guid = tgt_id
            --     AND txn_guid = txn_id
            --     AND stepgroup_guid = v_grp;
            --
            -- Delete existing steps from the step group. They will be recreated.
            DELETE FROM MGMT_BCN_STEPGROUP_STEPS
            WHERE target_guid = tgt_id
                AND stepgroup_guid = v_grp;
        ELSE
            SELECT COUNT(*) 
              INTO v_step_name_count
              FROM mgmt_bcn_step_defn d
             WHERE d.target_guid = tgt_id
               AND d.txn_guid =txn_id 
               AND d.name = stepgroups_defn(v_grp_ctr).name;
            
            IF (v_step_name_count = 0) THEN
              BEGIN 
                  INSERT INTO MGMT_BCN_STEPGROUP_DEFN (target_guid,
                          txn_guid, name, stepgroup_type)
                  VALUES (tgt_id, txn_id, stepgroups_defn(v_grp_ctr).name, 
                          stepgroups_defn(v_grp_ctr).stepgroup_type);
              EXCEPTION
                  WHEN DUP_VAL_ON_INDEX THEN 
                  result := p_bcn_err_dup_in_groups;
                  err_desc := stepgroups_defn(v_grp_ctr).name; 
                  RAISE p_internal_error;
              END;
            ELSE
              result := p_bcn_err_dup_in_steps_n_grps;
              err_desc := stepgroups_defn(v_grp_ctr).name; 
              RAISE p_internal_error;
            END IF;
            
            -- Find the guid for the stepgroup
            SELECT stepgroup_guid
            INTO v_grp
            FROM MGMT_BCN_STEPGROUP_DEFN
            WHERE target_guid = tgt_id
                AND txn_guid = txn_id
                AND name = stepgroups_defn(v_grp_ctr).name;
    
            IF (v_beacons IS NOT NULL AND v_beacons.COUNT > 0) THEN
                FOR v_bcn_ctr IN 1..v_beacons.COUNT LOOP
                    -- Add a record in the composite key table
                    IF v_beacons(v_bcn_ctr).bcn_guid = tgt_id THEN
                        v_name := p_local_target_name;
                    ELSE
                        v_name := v_beacons(v_bcn_ctr).bcn_target_name;
                    END IF;
                    EMD_BCN_CREATE_COMPOSITE_KEY(tgt_id, v_txn_name, v_name, 
                            stepgroups_defn(v_grp_ctr).name);
                END LOOP;
            END IF;
        END IF;

        -- Irrespective of whether this is a new stepgroup or an edit of
        -- an existing stepgroup, create the stepgroups-steps mapping anew.
        FOR v_step_ctr IN 1..stepgroups_defn(v_grp_ctr).steps.COUNT LOOP
            -- First find the guid for the step
            -- DBMS_OUTPUT.PUT_LINE('Processing step ' 
            --         || stepgroups_defn(v_grp_ctr).steps(v_step_ctr)
            --         || ' in group ' 
            --         || stepgroups_defn(v_grp_ctr).stepgroup_guid);
            
            -- The stepgroup may be created with either the name of a step
            -- or the actual guid passed in. The name is used when the
            -- corresponding step is new. The guid is used when the step
            -- aleady exists.
            BEGIN
                SELECT step_guid
                INTO v_stp
                FROM MGMT_BCN_STEP_DEFN
                WHERE target_guid = tgt_id
                    AND txn_guid = txn_id
                    AND name = stepgroups_defn(v_grp_ctr).steps(v_step_ctr);
            EXCEPTION
                WHEN OTHERS THEN
                    v_stp := HEXTORAW(stepgroups_defn(v_grp_ctr).steps(v_step_ctr));
            END;
            
            -- When a step is a member of the step group, then all children 
            -- of the step should also be part of the step group. 
            -- Validate this condition 
            
/* raj please take a look at this. the steps are not necessarily ids.
            SELECT count(*) 
              INTO v_non_member_step_count
              FROM MGMT_BCN_STEP_DEFN
             WHERE target_guid = tgt_id
               AND txn_guid = txn_id
               AND parent_step_guid = v_stp 
               AND RAWTOHEX(step_guid) NOT IN 
                                      (SELECT * 
                                       FROM TABLE(CAST(stepgroups_defn(v_grp_ctr).steps AS MGMT_BCN_STEPID_ARRAY)));
            IF ( v_non_member_step_count > 0 ) THEN 
                result := p_bcn_err_malformed_stpgrp;
                err_desc := 'Not all the children of the step are members of group';
                RAISE p_internal_error;
            END IF;
*/
            -- Insert the mapping    
            BEGIN 
                INSERT INTO MGMT_BCN_STEPGROUP_STEPS
                    (target_guid, txn_guid, stepgroup_guid, step_guid)
                VALUES
                    (tgt_id, txn_id, v_grp, v_stp);
            EXCEPTION
                WHEN DUP_VAL_ON_INDEX THEN 
                result := p_bcn_err_malformed_stpgrp;
                err_desc := stepgroups_defn(v_grp_ctr).name; 
                RAISE p_internal_error;
            END;
        END LOOP;
    END LOOP;

    IF stepgroup_thresholds IS NULL or stepgroup_thresholds.COUNT = 0 THEN
        RETURN;
    END IF;
    
    -- Find the transaction name
    SELECT name
    INTO v_txn_name
    FROM MGMT_BCN_TXN_DEFN
    WHERE target_guid = tgt_id
        AND txn_guid = txn_id;

    v_thresholds := MGMT_BCN_THRESHOLD_ARRAY();
    FOR v_grp_ctr IN 1..stepgroups_defn.COUNT LOOP
        -- Find the guid for the stepgroup
        SELECT stepgroup_guid
        INTO v_grp
        FROM MGMT_BCN_STEPGROUP_DEFN
        WHERE target_guid = tgt_id
            AND txn_guid = txn_id
            AND name = stepgroups_defn(v_grp_ctr).name;    

        -- Pick out the default thresholds for this stepgroup
        EMD_BCN_FILTER_APPEND_THRESH(
                NULL, NULL, 
                v_txn_name, txn_id,
                stepgroups_defn(v_grp_ctr).name, RAWTOHEX(v_grp),
                NULL, stepgroup_thresholds, v_thresholds);
            
        -- Pick out the thresholds for beacon-stepgroup combinations
        IF (v_beacons IS NOT NULL AND v_beacons.COUNT > 0) THEN
            FOR v_bcn_ctr IN 1..v_beacons.COUNT LOOP
                EMD_BCN_FILTER_APPEND_THRESH(
                        v_beacons(v_bcn_ctr).bcn_guid,
                        v_beacons(v_bcn_ctr).bcn_guid,
                        v_txn_name, txn_id, 
                        stepgroups_defn(v_grp_ctr).name,
                        RAWTOHEX(v_grp),
                        NULL, stepgroup_thresholds, v_thresholds);
            END LOOP;
        END IF;
    END LOOP;
    
    -- Add the thresholds using the threshold list created above
    IF v_thresholds IS NOT NULL AND v_thresholds.COUNT > 0 THEN
        EMD_BCN_SET_THRESH(tgt_id, v_thresholds, p_stepgroup,
                result, err_desc);
        -- clean up
        v_thresholds.DELETE;
        v_thresholds := NULL;
        IF result <> p_bcn_success THEN
            RAISE p_internal_error;
        END IF;  
    END IF;
    result := p_bcn_success;
    err_desc := NULL;    
    
END EMD_BCN_STPGRP_CREATE_EDIT;

--------------------------------------------------------------------------
PROCEDURE EMD_BCN_EDIT_STEPGROUPS (
        tgt_id                  IN VARCHAR2,
        txn_id                  IN VARCHAR2,
        add_stepgroups          IN MGMT_BCN_STEPGROUP_ARRAY,
        rm_stepgroups           IN MGMT_BCN_STEPGROUPID_ARRAY,
        result                  OUT INTEGER,
        err_desc                OUT VARCHAR2)
IS
    v_target                RAW(16);
    v_transaction           RAW(16);
BEGIN
    IF tgt_id IS NULL OR txn_id IS NULL THEN
        result := p_bcn_err_badparams;
        RETURN;
    END IF;
    
    v_target := HEXTORAW(tgt_id);
    v_transaction := HEXTORAW(txn_id);

    IF rm_stepgroups IS NOT NULL AND rm_stepgroups.COUNT > 0 THEN
        EMD_BCN_STEPGROUPS_RM(tgt_id, txn_id, rm_stepgroups, result, err_desc);
    END IF;
    
    IF add_stepgroups IS NOT NULL AND add_stepgroups.COUNT > 0 THEN
        EMD_BCN_STPGRP_CREATE_EDIT(v_target, v_transaction, add_stepgroups, NULL, result, err_desc);
    END IF;
EXCEPTION

    WHEN p_internal_error THEN
        LOG_SYS_ERR(result, 'EMD_BCN_EDIT_STEPGROUPS: failed.');

    WHEN OTHERS THEN
        result := p_bcn_err_oraerr;
        err_desc := SUBSTR(SQLERRM, 1, p_err_maxlen);
        LOG_SYS_ERR(result, 'EMD_BCN_EDIT_STEPGROUPS: db error: ' || err_desc);

END EMD_BCN_EDIT_STEPGROUPS;

-------------------------------------------------------------------------
PROCEDURE EMD_BCN_STEPGROUPS_CREATE (
        tgt_id                  IN VARCHAR2,
        txn_id                  IN VARCHAR2,
        stepgroups_defn         IN MGMT_BCN_STEPGROUP_ARRAY,
        stepgroup_thresholds    IN MGMT_BCN_THRESHOLD_ARRAY,
        result                  OUT INTEGER,
        err_desc                OUT VARCHAR2)
IS
    v_target                 RAW(16);
    v_transaction            RAW(16);
BEGIN
    IF tgt_id IS NULL OR txn_id IS NULL OR stepgroups_defn IS NULL OR
            stepgroups_defn.COUNT = 0 THEN
        result := p_bcn_err_badparams;
        RETURN;
    END IF;

    v_target := HEXTORAW(tgt_id);
    v_transaction := HEXTORAW(txn_id);

    -- Create all the stepgroup definitions
    EMD_BCN_STPGRP_CREATE_EDIT(v_target, v_transaction, stepgroups_defn, stepgroup_thresholds, result, err_desc);

END EMD_BCN_STEPGROUPS_CREATE;

--------------------------------------------------------------------------
-- Get thresholds for the transaction, steps and stepgroups
--------------------------------------------------------------------------

PROCEDURE EMD_BCN_GET_THRESHOLDS(
        tgt_id                  IN VARCHAR2,
        txn_id                  IN VARCHAR2,
        txn_thresholds          OUT MGMT_BCN_THRESHOLD_ARRAY,
        step_thresholds         OUT MGMT_BCN_THRESHOLD_ARRAY,
        stepgroup_thresholds    OUT MGMT_BCN_THRESHOLD_ARRAY,
        result                  OUT INTEGER,
        err_desc                OUT VARCHAR2)
IS
    v_target                    RAW(16);
    v_transaction               RAW(16);

    v_thresholds                MGMT_BCN_THRESHOLD_ARRAY := NULL;
    
    v_beacons                   MGMT_BCN_ARRAY;

    v_txn                       MGMT_BCN_TXN_WITH_PROPS;
    v_steps                     MGMT_BCN_STEP_WITH_PROPS_ARRAY;
    v_stepgroups                MGMT_BCN_STEPGROUP_ARRAY;
    
    v_ctr                       PLS_INTEGER;
    v_bcn_ctr                   PLS_INTEGER;
BEGIN
    IF tgt_id IS NULL OR txn_id IS NULL THEN
        result := p_bcn_err_badparams;
        RETURN;
    END IF;
    
    v_target := HEXTORAW(tgt_id);
    v_transaction := HEXTORAW(txn_id);

    -- Get the beacons for the target
    v_beacons := EMD_BCN_GET_BEACONS(tgt_id, NULL);

    ----------------------------------------------------------------------
    -- Get the transaction definition
    EMD_BCN_GET_TXN(tgt_id, txn_id, FALSE, v_txn, result, err_desc);
    txn_thresholds := MGMT_BCN_THRESHOLD_ARRAY();

    -- Get default transaction thresholds
    EMD_BCN_GET_THRESH(v_target,
            MGMT_BCN_THRESHOLD_KEY(NULL, txn_id, NULL, NULL, NULL,
                    NULL, NULL),
            p_txn, txn_id, v_thresholds, result, err_desc);
    IF v_thresholds IS NOT NULL THEN
        EMD_BCN_FILTER_APPEND_THRESH(NULL, NULL, NULL, txn_id, 
                NULL, NULL, NULL, v_thresholds, txn_thresholds);
        v_thresholds.delete;
        v_thresholds := NULL;
    END IF;
    
    -- Get the beacon-specific transaction thresholds
    IF (v_beacons IS NOT NULL AND v_beacons.COUNT > 0) THEN
        FOR v_bcn_ctr IN 1..v_beacons.COUNT LOOP
            EMD_BCN_GET_THRESH(tgt_id,
                    MGMT_BCN_THRESHOLD_KEY(v_beacons(v_bcn_ctr).bcn_guid, txn_id, 
                            NULL, NULL, NULL, NULL, NULL),
                    p_txn, txn_id, v_thresholds, result, err_desc);
            IF v_thresholds IS NOT NULL THEN
                EMD_BCN_FILTER_APPEND_THRESH(NULL, v_beacons(v_bcn_ctr).bcn_guid,
                        NULL, txn_id, NULL, NULL, 
                        NULL, v_thresholds, txn_thresholds);
                v_thresholds.delete;
                v_thresholds := NULL;
            END IF;    
        END LOOP;
    END IF;
        
    ----------------------------------------------------------------------
    -- Get the step definitions
    EMD_BCN_GET_STEPS(tgt_id, txn_id, FALSE, v_steps, result, err_desc);
    
    step_thresholds := MGMT_BCN_THRESHOLD_ARRAY();
    
    IF (v_steps IS NOT NULL) THEN
        FOR v_ctr IN 1..v_steps.COUNT LOOP
            -- Get default step thresholds
            EMD_BCN_GET_THRESH(tgt_id,
                    MGMT_BCN_THRESHOLD_KEY(NULL, txn_id, v_steps(v_ctr).step_defn.step_guid,
                            NULL, NULL, NULL, NULL),
                    p_step, RAWTOHEX(v_steps(v_ctr).step_defn.step_guid),
                    v_thresholds, result, err_desc);
            IF v_thresholds IS NOT NULL THEN
                EMD_BCN_FILTER_APPEND_THRESH(NULL, NULL, 
                        NULL, txn_id, 
                        NULL, v_steps(v_ctr).step_defn.step_guid, 
                        NULL, v_thresholds, step_thresholds);
                v_thresholds.delete;
                v_thresholds := NULL;
            END IF;
        
            -- Get the beacon-specific step thresholds
            IF ( v_beacons IS NOT NULL ) THEN 
                FOR v_bcn_ctr IN 1..v_beacons.COUNT LOOP
                    EMD_BCN_GET_THRESH(tgt_id,
                            MGMT_BCN_THRESHOLD_KEY(v_beacons(v_bcn_ctr).bcn_guid, txn_id, 
                                    v_steps(v_ctr).step_defn.step_guid, NULL, NULL, 
                                    NULL, NULL),
                            p_step, v_steps(v_ctr).step_defn.step_guid, 
                            v_thresholds, result, err_desc);
                    IF v_thresholds IS NOT NULL THEN
                        EMD_BCN_FILTER_APPEND_THRESH(NULL, v_beacons(v_bcn_ctr).bcn_guid,
                                NULL, txn_id, 
                                NULL, v_steps(v_ctr).step_defn.step_guid, 
                                NULL, v_thresholds, step_thresholds);
                        v_thresholds.delete;
                        v_thresholds := NULL;
                    END IF;    
                END LOOP;    
            END IF;    
        END LOOP;
    END IF;

    ----------------------------------------------------------------------
    -- Get the stepgroup definitions
    EMD_BCN_GET_STEPGROUPS(tgt_id, txn_id, FALSE, v_stepgroups, result, err_desc);
    
    stepgroup_thresholds := MGMT_BCN_THRESHOLD_ARRAY();
    
    IF (v_stepgroups IS NOT NULL) THEN
        FOR v_ctr IN 1..v_stepgroups.COUNT LOOP
            -- Get default stepgroup thresholds
            EMD_BCN_GET_THRESH(tgt_id,
                    MGMT_BCN_THRESHOLD_KEY(NULL, txn_id, v_stepgroups(v_ctr).stepgroup_guid,
                            NULL, NULL, NULL, NULL),
                    p_stepgroup, RAWTOHEX(v_stepgroups(v_ctr).stepgroup_guid),
                    v_thresholds, result, err_desc);
            IF v_thresholds IS NOT NULL THEN
                EMD_BCN_FILTER_APPEND_THRESH(NULL, NULL, 
                        NULL, txn_id, 
                        NULL, v_stepgroups(v_ctr).stepgroup_guid, 
                        NULL, v_thresholds, stepgroup_thresholds);
                v_thresholds.delete;
                v_thresholds := NULL;
            END IF;
        
            -- Get the beacon-specific stepgroup thresholds
            IF (v_beacons IS NOT NULL AND v_beacons.COUNT > 0) THEN
                FOR v_bcn_ctr IN 1..v_beacons.COUNT LOOP
                    EMD_BCN_GET_THRESH(tgt_id,
                            MGMT_BCN_THRESHOLD_KEY(v_beacons(v_bcn_ctr).bcn_guid, txn_id, 
                                    v_stepgroups(v_ctr).stepgroup_guid, NULL, NULL, 
                                    NULL, NULL),
                            p_stepgroup, RAWTOHEX(v_stepgroups(v_ctr).stepgroup_guid), 
                            v_thresholds, result, err_desc);
                    IF v_thresholds IS NOT NULL THEN
                        EMD_BCN_FILTER_APPEND_THRESH(NULL, v_beacons(v_bcn_ctr).bcn_guid,
                                NULL, txn_id, 
                                NULL, v_stepgroups(v_ctr).stepgroup_guid, 
                                NULL, v_thresholds, stepgroup_thresholds);
                        v_thresholds.delete;
                        v_thresholds := NULL;
                    END IF;    
                END LOOP;
            END IF;
        END LOOP;
    END IF;

END EMD_BCN_GET_THRESHOLDS;

--------------------------------------------------------------------------
-- View a transaction along with its constituent steps and stepgroups
--------------------------------------------------------------------------

PROCEDURE EMD_BCN_TXN_VIEW (
        tgt_id                  IN VARCHAR2,
        txn_id                  IN VARCHAR2,
        txn_defn_with_props     OUT MGMT_BCN_TXN_WITH_PROPS,
        steps_defn_with_props   OUT MGMT_BCN_STEP_WITH_PROPS_ARRAY,
        stepgroups_defn         OUT MGMT_BCN_STEPGROUP_ARRAY,
        bcn_list                OUT MGMT_BCN_ARRAY,        
        result                  OUT INTEGER,
        err_desc                OUT VARCHAR2)
IS
    v_tgt               RAW(16);
    v_txn               RAW(16);
    
    v_is_template       BOOLEAN;
BEGIN
    IF tgt_id IS NULL OR txn_id IS NULL THEN
        result := p_bcn_err_badparams;
        RETURN;
    END IF;

    v_tgt := HEXTORAW(tgt_id);
    v_is_template := EMD_BCN_IS_TEMPLATE(v_tgt);

    IF NOT v_is_template THEN
        result := HAS_TGT_FUNCTION_PRIV (tgt_id, p_view_txn, err_desc);
    ELSE
        result := HAS_TMPL_FUNCTION_PRIV (tgt_id, p_view_txn, err_desc);
    END IF;
    IF result <> p_bcn_success THEN
        RETURN;
    END IF;

    v_txn := HEXTORAW(txn_id);
    txn_defn_with_props := NULL;   
    EMD_BCN_GET_TXN(tgt_id, txn_id, TRUE, txn_defn_with_props, result, err_desc);
    IF result <> p_bcn_success THEN
        RAISE p_internal_error;
    END IF;
    
    steps_defn_with_props := NULL;
    EMD_BCN_GET_STEPS(tgt_id, txn_id, TRUE, steps_defn_with_props, result, err_desc);
    IF result <> p_bcn_success THEN
        RAISE p_internal_error;
    END IF;

    stepgroups_defn := NULL;
    EMD_BCN_GET_STEPGROUPS(tgt_id, txn_id, TRUE, stepgroups_defn, result, err_desc);
    IF result <> p_bcn_success THEN
        RAISE p_internal_error;
    END IF;
    
    -- REVISIT: The view interface always retrieves a list of beacons. We may
    -- need to use a boolean to choose whether to retrieve beacons or not.
    -- Until this happens, there is a little bit of extra work happening that may
    -- not always be needed.
    bcn_list := NULL;
    bcn_list := EMD_BCN_GET_BEACONS(tgt_id, txn_id);

    RETURN;
END EMD_BCN_TXN_VIEW;

PROCEDURE EMD_BCN_TXN_VIEW (
        tgt_id                  IN VARCHAR2,
        txn_id                  IN VARCHAR2,
        txn_defn_with_props     OUT MGMT_BCN_TXN_WITH_PROPS,
        steps_defn_with_props   OUT MGMT_BCN_STEP_WITH_PROPS_ARRAY,
        stepgroups_defn         OUT MGMT_BCN_STEPGROUP_ARRAY,
        txn_thresholds          OUT MGMT_BCN_THRESHOLD_ARRAY,
        step_thresholds         OUT MGMT_BCN_THRESHOLD_ARRAY,
        stepgroup_thresholds    OUT MGMT_BCN_THRESHOLD_ARRAY,
        bcn_list                OUT MGMT_BCN_ARRAY,        
        result                  OUT INTEGER,
        err_desc                OUT VARCHAR2)
IS
    v_tgt               RAW(16);

    v_is_template       BOOLEAN;
BEGIN
    IF tgt_id IS NULL OR txn_id IS NULL THEN
        result := p_bcn_err_badparams;
        RETURN;
    END IF;

    v_tgt := HEXTORAW(tgt_id);
    v_is_template := EMD_BCN_IS_TEMPLATE(v_tgt);

    IF NOT v_is_template THEN
        result := HAS_TGT_FUNCTION_PRIV (tgt_id, p_view_txn, err_desc);
    ELSE
        result := HAS_TMPL_FUNCTION_PRIV (tgt_id, p_view_txn, err_desc);
    END IF;
    IF result <> p_bcn_success THEN
        RETURN;
    END IF;

    EMD_BCN_TXN_VIEW(tgt_id, txn_id, txn_defn_with_props, steps_defn_with_props,
            stepgroups_defn, bcn_list, result, err_desc);

    IF result <> p_bcn_success THEN
        RAISE p_internal_error;
    END IF;

    txn_thresholds := NULL;
    step_thresholds := NULL;
    stepgroup_thresholds := NULL;
    EMD_BCN_GET_THRESHOLDS(tgt_id, txn_id, txn_thresholds, step_thresholds, 
            stepgroup_thresholds, result, err_desc);
    
    IF result <> p_bcn_success THEN
        RAISE p_internal_error;
    END IF;

    RETURN;
END EMD_BCN_TXN_VIEW;

-------------------------------------------------------------------------
-- Create a transaction along with its constituent steps and stepgroups
-------------------------------------------------------------------------

PROCEDURE EMD_BCN_TXN_CREATE (
        tgt_id                  IN VARCHAR2,
        txn_defn_with_props     IN MGMT_BCN_TXN_WITH_PROPS,
        steps_defn_with_props   IN MGMT_BCN_STEP_WITH_PROPS_ARRAY,
        stepgroups_defn         IN MGMT_BCN_STEPGROUP_ARRAY,
        txn_thresholds          IN MGMT_BCN_THRESHOLD_ARRAY,
        step_thresholds         IN MGMT_BCN_THRESHOLD_ARRAY,
        stepgroup_thresholds    IN MGMT_BCN_THRESHOLD_ARRAY,
        for_push                IN VARCHAR2,
        new_txn_id              OUT VARCHAR2,
        new_version             OUT INTEGER,
        bcn_list                OUT MGMT_BCN_ARRAY,
        result                  OUT INTEGER,
        err_desc                OUT VARCHAR2)
IS
    v_tgt                   RAW(16);
    v_txn                   RAW(16);
    
    v_step_ctr              PLS_INTEGER;
    v_curdate               DATE;
    
    v_av_met                RAW(16);
    v_ck                    RAW(16);
    v_name                  VARCHAR2(64);
    v_met_name              VARCHAR2(64);
    v_isrep                 CHAR(1);
    v_state                 VARCHAR2(8);
    v_count                 PLS_INTEGER;
    
    v_tmp                   INTEGER;
    v_jobs                  MGMT_GENSVC_UBJOB_JOB_ARRAY; 
    v_tgt_name              MGMT_TARGETS.TARGET_NAME%TYPE;
    v_tgt_type              MGMT_TARGETS.TARGET_TYPE%TYPE;
    v_metric                VARCHAR2(64) := null;
    v_met_col               VARCHAR2(64) := null;
    v_avail_test            MGMT_GENSVC_AV_TEST := null;
    v_is_avail              NUMBER;
    v_is_monit              NUMBER;
    
    v_is_template           BOOLEAN;
BEGIN
    -- Check parameters
    IF tgt_id IS NULL OR txn_defn_with_props IS NULL 
            OR txn_defn_with_props.txn_defn.name IS NULL 
            OR LENGTH(txn_defn_with_props.txn_defn.name) <= 0 THEN
        result := p_bcn_err_badparams;
        RETURN;
    END IF;

    v_tgt := HEXTORAW(tgt_id);
    
    v_is_template := EMD_BCN_IS_TEMPLATE(v_tgt);

    IF NOT v_is_template THEN
        result := HAS_TGT_FUNCTION_PRIV (tgt_id, p_create_txn, err_desc);
        IF (result = p_bcn_success AND for_push = 'Y') THEN
          result := HAS_TGT_FUNCTION_PRIV(tgt_id, p_start_txn, err_desc);
        END IF;
    ELSE
          result := HAS_TMPL_FUNCTION_PRIV (tgt_id, p_create_txn, err_desc);
      END IF;
      IF result <> p_bcn_success THEN
          RETURN;
      END IF;

      v_curdate := SYSDATE;

      bcn_list := NULL;

      -- Create the transaction, set its properties, set thresholds
      EMD_BCN_TXN_CREATE(tgt_id, txn_defn_with_props, txn_thresholds, for_push, 
              v_txn, new_version, v_isrep, v_state, result, err_desc);
      IF result <> p_bcn_success THEN
          RETURN;
      END IF;
      new_txn_id := RAWTOHEX(v_txn);
      -- DBMS_OUTPUT.PUT_LINE('New Transaction GUID: ' || new_txn_id);
          
      -- Create step records, set step properties, set thresholds
      IF steps_defn_with_props IS NOT NULL AND steps_defn_with_props.COUNT > 0 THEN
          EMD_BCN_STEPS_CREATE(tgt_id, new_txn_id, steps_defn_with_props, 
                  step_thresholds, result, err_desc);
          IF result <> p_bcn_success THEN
              RETURN;
          END IF;
      END IF;
      -- Create step group records, set thresholds
      IF stepgroups_defn IS NOT NULL AND stepgroups_defn.COUNT > 0 THEN
          EMD_BCN_STEPGROUPS_CREATE(tgt_id, new_txn_id, stepgroups_defn, 
                  stepgroup_thresholds, result, err_desc);
          IF result <> p_bcn_success THEN
              RETURN;
          END IF;
      END IF;
          
      -- Register the test for computing test availability
      IF NOT v_is_template THEN 
          BEGIN
              SELECT target_name, target_type 
                INTO v_tgt_name, v_tgt_type
                FROM mgmt_targets 
               WHERE target_guid = tgt_id; 
          EXCEPTION
              WHEN NO_DATA_FOUND THEN
                  err_desc := 'Invalid target id '||tgt_id;
                  result := p_bcn_err_tgtnotfound;
                  RETURN;
          END;

       IF (v_tgt_type != MGMT_GLOBAL.G_BEACON_TARGET_TYPE) THEN
 
          IF (txn_defn_with_props.txn_defn.is_representative = 'Y') THEN
              v_is_avail := 1;
          ELSE
              v_is_avail := 0;
          END IF;

          IF for_push = 'Y' THEN
              v_is_monit := 1;
          ELSE
              v_is_monit := 0;
          END IF;
         
          MGMT_TEST_METADATA_READ.GET_AVAIL_METRIC(
               txn_defn_with_props.txn_defn.txn_type, v_metric, v_met_col );
          v_avail_test := MGMT_GENSVC_AV_TEST( 
                           txn_defn_with_props.txn_defn.name, 
                           txn_defn_with_props.txn_defn.txn_type,
                           v_metric,
                           v_met_col,
                           v_is_avail, 
                           v_is_monit );

          MGMT_GENSVC_AVAIL.ADD_TEST(v_tgt_name, v_tgt_type, v_avail_test);
        END IF; -- if target type is not beacon
      END IF; -- Register 
      -- Push the job if the test being created is for push and is not for a template
      IF (NOT v_is_template) AND (for_push = 'Y') THEN
          bcn_list := EMD_BCN_GET_BEACONS(tgt_id, NULL);
          err_desc := EMD_BCN_SUBMIT_TEST_JOB(v_tgt, v_txn, 
                  txn_defn_with_props.txn_defn.name, 
                  txn_defn_with_props.txn_defn.txn_type, p_add_collection, NULL, 
                  p_create_txn_action_desc, v_jobs );
        IF ( err_desc IS NOT NULL ) THEN
            result := p_bcn_err_badparams;
            RETURN;
        END IF;
    END IF;

    result := p_bcn_success;
    err_desc := NULL;
    
END EMD_BCN_TXN_CREATE;

--------------------------------------------------------------------------
-- Delete a transaction along with its constituent steps and stepgroups
--------------------------------------------------------------------------

PROCEDURE EMD_BCN_TXN_DELETE(
        tgt_id              IN VARCHAR2, 
        txn_id              IN VARCHAR2, 
        bcn_list            OUT MGMT_BCN_ARRAY,
        result              OUT INTEGER, 
        err_desc            OUT VARCHAR2)
IS
    v_tgt                 RAW(16);
    v_txn                 RAW(16);
    v_txn_state           VARCHAR2(8);
    v_txn_name            MGMT_BCN_TXN_DEFN.NAME%TYPE;
    v_txn_rep             CHAR(1);
    v_txn_type            mgmt_bcn_txn_defn.txn_type%TYPE;
    
    v_tmp                 INTEGER;
    v_jobs                MGMT_GENSVC_UBJOB_JOB_ARRAY; 
    v_tgt_name            MGMT_TARGETS.TARGET_NAME%TYPE;
    v_tgt_type            MGMT_TARGETS.TARGET_TYPE%TYPE;
    v_metric              VARCHAR2(64) := null;
    v_met_col             VARCHAR2(64) := null;
    v_avail_test          MGMT_GENSVC_AV_TEST := null;
    v_is_monit              NUMBER;

    v_is_template           BOOLEAN;
    v_dep_met_keys       SMP_EMD_NVPAIR_ARRAY;
    v_metric_guids       SMP_EMD_STRING_ARRAY;

    v_step_guids         MGMT_BCN_STEPID_ARRAY;
    v_group_guids        MGMT_BCN_STEPGROUPID_ARRAY;
    v_rm_key_values      SMP_EMD_STRING_ARRAY := NULL;
BEGIN
  
    IF tgt_id IS NULL OR txn_id IS NULL THEN
        result := p_bcn_err_badparams;
        RETURN;
    END IF;

    v_tgt := HEXTORAW(tgt_id);

    v_is_template := EMD_BCN_IS_TEMPLATE(v_tgt);

    IF NOT v_is_template THEN
        result := HAS_TGT_FUNCTION_PRIV (tgt_id, p_remove_txn, err_desc);
    ELSE
        result := HAS_TMPL_FUNCTION_PRIV (tgt_id, p_remove_txn, err_desc);
    END IF;
    IF result <> p_bcn_success THEN
        RETURN;
    END IF;

    v_txn := HEXTORAW(txn_id);
    bcn_list := NULL;

    -- Get the txn details
    SELECT name, txn_type, state, is_representative, txn_type
    INTO v_txn_name, v_txn_type, v_txn_state, v_txn_rep, v_txn_type
    FROM MGMT_BCN_TXN_DEFN
    WHERE target_guid = v_tgt
        AND txn_guid = v_txn; 

    -- Cannot delete the representative txn
    IF v_txn_rep = 'Y' THEN
        result := p_bcn_err_reptxn;
        RAISE p_internal_error;
    END IF;

    -- Get the beacons for the target and transaction
    bcn_list := EMD_BCN_GET_BEACONS(tgt_id, txn_id);
        

    SELECT composite_key
      BULK COLLECT INTO v_rm_key_values
      FROM MGMT_METRICS_COMPOSITE_KEYS
     WHERE target_guid = v_tgt
       AND key_part1_value = v_txn_name;

    -- delete the admin metric thresholds before the key values are gone

    IF( v_rm_key_values IS NOT NULL ) AND (v_rm_key_values.COUNT > 0 ) THEN 
        DELETE 
          FROM MGMT_ADMIN_METRIC_THRESHOLDS
         WHERE target_guid = v_tgt
           AND key_value IN (SELECT *
                               FROM TABLE(CAST(v_rm_key_values AS SMP_EMD_STRING_ARRAY ) ) ); 
    END IF;

    -- get step_ids for txn
    BEGIN
      SELECT RAWTOHEX(step_guid) BULK COLLECT INTO v_step_guids
        FROM MGMT_BCN_STEP_DEFN
       WHERE target_guid = v_tgt
         AND txn_guid = v_txn;
    EXCEPTION WHEN NO_DATA_FOUND THEN
      -- no steps
      v_step_guids := null;
    END;

    BEGIN
      SELECT RAWTOHEX(stepgroup_guid) BULK COLLECT INTO v_group_guids
        FROM MGMT_BCN_STEPGROUP_DEFN
       WHERE target_guid = v_tgt
         AND txn_guid = v_txn;
    EXCEPTION WHEN NO_DATA_FOUND THEN
      -- no group
      v_group_guids := null;
    END;

    -- Call delete key value callbacks for all steps, stepgroups and txn key values
    IF(KEY_VALUE_DEL_CALLBACK(v_tgt, v_txn, v_step_guids, v_group_guids, null, TRUE, err_desc) < 0) THEN
      result := p_bcn_err_invalidtxn;
      LOG_SYS_ERR(p_bcn_err_invalidtxn, 'EMD_BCN_TXN_DELETE: KEY VALUE DEL CALLBACK failed. ');
      raise p_internal_error;
    END IF;



    -- If the transaction is not part of template, deRegister the test 
    -- from computing test availability and submit a job to delete collection
    -- if it is in monitoring state. 
    IF (NOT v_is_template) THEN 
        BEGIN
            SELECT target_name, target_type 
              INTO v_tgt_name, v_tgt_type
              FROM mgmt_targets 
             WHERE target_guid = tgt_id; 
        EXCEPTION
            WHEN NO_DATA_FOUND THEN
                err_desc := 'Invalid target id '||tgt_id;
                result := p_bcn_err_tgtnotfound;
                RETURN;
        END;

        IF (v_tgt_type != MGMT_GLOBAL.G_BEACON_TARGET_TYPE) THEN
        
          IF ( v_txn_state = 'M' ) THEN
              v_is_monit:= 1;
          ELSE
              v_is_monit:= 0;
          END IF;
       
          MGMT_TEST_METADATA_READ.GET_AVAIL_METRIC(v_txn_type, v_metric, v_met_col );
          v_avail_test := MGMT_GENSVC_AV_TEST( v_txn_name, v_txn_type, v_metric, v_met_col, 0, v_is_monit );
  
          MGMT_GENSVC_AVAIL.REMOVE_TEST(v_tgt_name, v_tgt_type, v_avail_test);
          -- End of avail deregistration
        END IF; -- if target is not a beacon
    
        -- Push the job if the test being created is for push
    
    
        -- Submit a job to remove collections from all the beacons
        IF ( v_txn_state = 'M' ) THEN
            err_desc := EMD_BCN_SUBMIT_TEST_JOB(v_tgt, v_txn, v_txn_name, v_txn_type,
                p_remove_collection, v_rm_key_values, p_delete_txn_action_desc, v_jobs );
            IF ( err_desc IS NOT NULL ) THEN
                result := p_bcn_err_badparams;
                RETURN;
            END IF;
        END IF;
    END IF;

    -- Collect all the keys, which are promoted to Service performance metric
    SELECT SMP_EMD_NVPAIR(ckey, metric) BULK COLLECT INTO  v_dep_met_keys 
      FROM (SELECT DISTINCT k.composite_key as ckey, d.metric_guid as metric
              FROM mgmt_metrics_composite_keys k, mgmt_metric_dependency_details d
             WHERE k.target_guid=v_tgt
               AND d.dep_target_guid = k.target_guid
               AND k.key_part1_value = v_txn_name
               AND d.dep_key_value = k.composite_key);

    IF ( v_dep_met_keys IS NOT NULL ) AND ( v_dep_met_keys.COUNT > 0 ) THEN 
      -- Delete any promoted metric dependencies from the target
      -- call delete callback for each of these keys and metrics
      FOR i IN v_dep_met_keys.FIRST..v_dep_met_keys.LAST LOOP
        v_metric_guids := SMP_EMD_STRING_ARRAY();
        v_metric_guids.extend;
        v_metric_guids(1) := v_dep_met_keys(i).value;
        EM_METRIC.EXEC_CBK_METRIC_KEYVAL(tgt_id, v_metric_guids, v_dep_met_keys(i).name);
        v_metric_guids.delete;
      END LOOP;
    END IF;

   
    
    DELETE 
    FROM MGMT_BCN_TXN_DEFN
    WHERE target_guid = v_tgt
      AND txn_guid = v_txn;


    -- Audit the deletion
    EMD_BCN_AUDIT(v_tgt, v_txn, p_txn, FALSE, FALSE, FALSE, TRUE, 
            NULL, NULL, 'Deletion');

    result := p_bcn_success;
    err_desc := NULL;

EXCEPTION

    WHEN p_internal_error THEN
        LOG_SYS_ERR(result, 'EMD_BCN_TXN_DELETE: failed.');
        IF bcn_list IS NOT NULL THEN
            bcn_list.DELETE;
            bcn_list := NULL;
        END IF;
        IF v_metric_guids IS NOT NULL THEN
            v_metric_guids.DELETE;
        END IF;

    WHEN OTHERS THEN
        result := p_bcn_err_oraerr;
        err_desc := SUBSTR(SQLERRM, 1, p_err_maxlen);
        LOG_SYS_ERR(result, 'EMD_BCN_TXN_DELETE: db error: ' || err_desc);
        IF bcn_list IS NOT NULL THEN
            bcn_list.DELETE;
            bcn_list := NULL;
        END IF;
        IF v_metric_guids IS NOT NULL THEN
            v_metric_guids.DELETE;
        END IF;

END EMD_BCN_TXN_DELETE;
--------------------------------------------------------------------------

--------------------------------------------------------------------------
-- Modify a transaction and all its constituents
--------------------------------------------------------------------------
PROCEDURE EMD_BCN_TXN_MODIFY (
        tgt_id                  IN VARCHAR2,
        txn_defn_with_props     IN MGMT_BCN_TXN_WITH_PROPS,        
        steps_defn_with_props   IN MGMT_BCN_STEP_WITH_PROPS_ARRAY,
        rm_steps                IN MGMT_BCN_STEPID_ARRAY,        
        stepgroups_defn         IN MGMT_BCN_STEPGROUP_ARRAY,        
        rm_stepgroups           IN MGMT_BCN_STEPGROUPID_ARRAY,        
        txn_thresholds          IN MGMT_BCN_THRESHOLD_ARRAY,        
        step_thresholds         IN MGMT_BCN_THRESHOLD_ARRAY,        
        stepgroup_thresholds    IN MGMT_BCN_THRESHOLD_ARRAY,        
        new_version             OUT INTEGER,
        bcn_list                OUT MGMT_BCN_ARRAY,        
        result                  OUT INTEGER,        
        err_desc                OUT VARCHAR2)
IS
    v_tgt                   RAW(16);
    v_new_txn_id            RAW(16);
    v_is_rep                CHAR(1);
    v_prev_is_rep           CHAR(1);

    v_state                 VARCHAR2(8);
    
    v_rm_txn_thresh_keys    MGMT_BCN_THRESHOLD_KEY_ARRAY;
    v_rm_step_thresh_keys   MGMT_BCN_THRESHOLD_KEY_ARRAY;
    v_rm_stg_thresh_keys    MGMT_BCN_THRESHOLD_KEY_ARRAY;
    
    v_threshold_key         MGMT_BCN_THRESHOLD_KEY;
    v_count                 PLS_INTEGER;
    v_st_count              PLS_INTEGER;
    v_bcn_count             PLS_INTEGER;

    v_tmp                   INTEGER;
    v_jobs                  MGMT_GENSVC_UBJOB_JOB_ARRAY; 
    v_tgt_name              MGMT_TARGETS.TARGET_NAME%TYPE;
    v_tgt_type              MGMT_TARGETS.TARGET_TYPE%TYPE;
    v_metric                VARCHAR2(64) := null;
    v_met_col               VARCHAR2(64) := null;
    v_avail_test            MGMT_GENSVC_AV_TEST := null;

    v_is_template           BOOLEAN;
    v_is_monit              NUMBER;
    v_is_avail                 NUMBER;
    v_rm_key_values         SMP_EMD_STRING_ARRAY := SMP_EMD_STRING_ARRAY();
BEGIN
    IF tgt_id IS NULL OR txn_defn_with_props IS NULL
            OR txn_defn_with_props.txn_defn.txn_guid IS NULL
            OR txn_defn_with_props.txn_defn.name IS NULL 
            OR LENGTH(txn_defn_with_props.txn_defn.name) <= 0 THEN
        result := p_bcn_err_badparams;
        -- DBMS_OUTPUT.PUT_LINE('Bad parameters for modification');
        RETURN;
    END IF;

    v_tgt := HEXTORAW(tgt_id);

    v_is_template := EMD_BCN_IS_TEMPLATE(v_tgt);

    IF NOT v_is_template THEN
        result := HAS_TGT_FUNCTION_PRIV (tgt_id, p_modify_txn, err_desc);
    ELSE
        result := HAS_TMPL_FUNCTION_PRIV (tgt_id, p_modify_txn, err_desc);
    END IF;
    IF result <> p_bcn_success THEN
        -- DBMS_OUTPUT.PUT_LINE('Insufficient privileges');
        RETURN;
    END IF;

    -- Retrieve the existing availability state of the transaction
    BEGIN
        SELECT is_representative 
          INTO v_prev_is_rep
          FROM MGMT_BCN_TXN_DEFN
         WHERE target_guid = v_tgt
           AND txn_guid = HEXTORAW(txn_defn_with_props.txn_defn.txn_guid);
    EXCEPTION
        WHEN NO_DATA_FOUND THEN
            result := p_bcn_err_txnnotfound;
            RETURN;
    END;

    bcn_list := NULL;

    -- Retrieve the set of beacons. 
    -- This list is also used in order to remove per-beacon thresholds in 
    -- this procedure.
    bcn_list := EMD_BCN_GET_BEACONS(tgt_id, txn_defn_with_props.txn_defn.txn_guid);

    ----------------------------------------
    -- process the transaction
    ----------------------------------------

    -- Collect the key values that are going to be removed as part of this
    -- modify transaction
    IF ( ( ( rm_steps IS NOT NULL ) AND ( rm_steps.COUNT > 0 ) ) OR 
         ( ( rm_stepgroups IS NOT NULL ) AND ( rm_stepgroups.COUNT > 0 ) ) )THEN 
       
        SELECT distinct composite_key 
          BULK COLLECT INTO v_rm_key_values
          FROM mgmt_metrics_composite_keys
         WHERE target_guid = v_tgt
           AND key_part1_value = txn_defn_with_props.txn_defn.name
           AND key_part3_value in ( SELECT name 
                                      FROM mgmt_bcn_step_defn 
                                     WHERE target_guid = v_tgt
                                       AND txn_guid = txn_defn_with_props.txn_defn.txn_guid
                                       AND step_guid in (
                                            SELECT * 
                                              FROM TABLE(CAST(rm_steps AS MGMT_BCN_STEPID_ARRAY ) ) ) 
                                     UNION
                                    SELECT name 
                                      FROM mgmt_bcn_stepgroup_defn 
                                     WHERE target_guid = v_tgt
                                       AND txn_guid = txn_defn_with_props.txn_defn.txn_guid
                                       AND stepgroup_guid in (
                                            SELECT * 
                                              FROM TABLE(CAST(rm_stepgroups AS MGMT_BCN_STEPGROUPID_ARRAY))));
    END IF;
    -- Create the transaction threshold key array, 
    -- used to delete existing txn thresholds
    v_rm_txn_thresh_keys := EMD_BCN_GET_TXN_THR_KEYS(
            txn_defn_with_props.txn_defn.txn_guid, bcn_list);
    -- Remove all existing thresholds for the txn.
    IF v_rm_txn_thresh_keys IS NOT NULL AND v_rm_txn_thresh_keys.COUNT > 0 THEN
        EMD_BCN_RM_THRESH(tgt_id, v_rm_txn_thresh_keys, p_txn, result, err_desc);
    END IF;

    -- Note: The value of v_new_txn_id does not matter. It is here only to
    -- support the create_edit interface. We already have the txn guid when modifying
    -- a transaction.

    -- Edit the transaction definition, remove all existing properties and put the
    -- new ones in.
    EMD_BCN_TXN_CREATE_EDIT(v_tgt, txn_defn_with_props, TRUE, NULL, txn_thresholds, v_new_txn_id,
            new_version, v_is_rep, v_state, result, err_desc);
    IF result <> p_bcn_success THEN
        RETURN;
    END IF;

    ----------------------------------------
    -- processing steps
    ----------------------------------------

    IF rm_steps IS NOT NULL AND rm_steps.COUNT > 0 THEN
        -- DBMS_OUTPUT.PUT_LINE('Removing steps');
        -- Remove steps that are no longer needed. This triggers the deletion
        -- of all items (including thresholds) associated with the steps.
        EMD_BCN_STEPS_RM(tgt_id, txn_defn_with_props.txn_defn.txn_guid,
                rm_steps, result, err_desc);
    END IF;

    -- Create the step threshold keys array, 
    -- used to delete existing step thresholds. We do not delete
    -- thresholds for steps that are not on the edit/create list.
    v_rm_step_thresh_keys := EMD_BCN_GET_STEP_THR_KEYS(
            txn_defn_with_props.txn_defn.txn_guid,
            steps_defn_with_props, bcn_list);
    IF v_rm_step_thresh_keys IS NOT NULL AND v_rm_step_thresh_keys.COUNT > 0 THEN
        -- Remove all existing thresholds for the steps being edited.
        EMD_BCN_RM_THRESH(tgt_id, v_rm_step_thresh_keys, p_step, result, err_desc);
    END IF;
 
    IF steps_defn_with_props IS NOT NULL AND steps_defn_with_props.COUNT > 0 THEN
        -- DBMS_OUTPUT.PUT_LINE('Modifying step definitions');
        -- Create/Edit steps, remove all existing properties and put the new ones in.
        EMD_BCN_STEPS_CREATE_EDIT(v_tgt, 
                HEXTORAW(txn_defn_with_props.txn_defn.txn_guid),
                steps_defn_with_props, TRUE, step_thresholds, result, err_desc);
    END IF;

    IF result <> p_bcn_success THEN
        RETURN;
    END IF;

    ----------------------------------------
    -- processing step groups
    ----------------------------------------

    IF rm_stepgroups IS NOT NULL AND rm_stepgroups.COUNT > 0 THEN
        -- DBMS_OUTPUT.PUT_LINE('Removing steps');
        -- Remove step groups that are no longer needed. This triggers the deletion
        -- of all items (including thresholds) associated with the steps.
        EMD_BCN_STEPGROUPS_RM(tgt_id, txn_defn_with_props.txn_defn.txn_guid,
                rm_stepgroups, result, err_desc);
    END IF;

    -- Create the stepgroup threshold keys array, 
    -- used to delete existing stepgroup thresholds. We do not delete
    -- thresholds for stepgroups that are not on the edit list.
    v_rm_stg_thresh_keys := EMD_BCN_GET_STPGRP_THR_KEYS(
            txn_defn_with_props.txn_defn.txn_guid,
            stepgroups_defn, bcn_list);
    IF v_rm_stg_thresh_keys IS NOT NULL AND v_rm_stg_thresh_keys.COUNT > 0 THEN
        -- Remove all existing thresholds for the stepgroups being edited.
        EMD_BCN_RM_THRESH(tgt_id, v_rm_stg_thresh_keys, p_stepgroup, result, err_desc);
    END IF;

    IF stepgroups_defn IS NOT NULL AND stepgroups_defn.COUNT > 0 THEN
        -- DBMS_OUTPUT.PUT_LINE('Modifying stepgroup definitions');
        -- Create/Edit step groups 
        EMD_BCN_STPGRP_CREATE_EDIT(v_tgt,
                HEXTORAW(txn_defn_with_props.txn_defn.txn_guid),
                stepgroups_defn, stepgroup_thresholds, result, err_desc);
    END IF;

    IF result <> p_bcn_success THEN
        RETURN;
    END IF;
  
    -- All the tests are registerd for computing the test status at the 
    -- time of creation.
    -- If the Key ness is changed during the MDOFIY_TXN, then the 
    -- the corresponding change must be registered with the 
    -- availability engine. 
    IF (NOT v_is_template ) AND ( v_prev_is_rep <> v_is_rep ) THEN
        BEGIN
            SELECT target_name, target_type
              INTO v_tgt_name, v_tgt_type
              FROM mgmt_targets
             WHERE target_guid = v_tgt;
        EXCEPTION
            WHEN NO_DATA_FOUND THEN
                err_desc := 'Invalid target id '||tgt_id;
                result := p_bcn_err_tgtnotfound;
                RETURN;
        END;

        IF (v_is_rep = 'Y') THEN
            v_is_avail := 1;
        ELSE
            v_is_avail := 0;
        END IF;

        IF (v_state = 'M') THEN
            v_is_monit := 1;
        ELSE
            v_is_monit := 0;
        END IF;

        MGMT_TEST_METADATA_READ.GET_AVAIL_METRIC(
             txn_defn_with_props.txn_defn.txn_type, v_metric, v_met_col );
        v_avail_test := MGMT_GENSVC_AV_TEST(
                         txn_defn_with_props.txn_defn.name,
                         txn_defn_with_props.txn_defn.txn_type,
                         v_metric,
                         v_met_col,
                         v_is_avail,
                         v_is_monit );

        MGMT_GENSVC_AVAIL.ADD_TEST(v_tgt_name, v_tgt_type, v_avail_test);
    END IF; -- Register 

    IF (v_state <> 'M') THEN
        -- We send back a list of beacons only when the transaction is in
        -- monitoring state.
        IF (bcn_list IS NOT NULL) THEN
            bcn_list.DELETE;
            bcn_list := NULL;
        END IF;
    ELSIF (v_state = 'M') AND (NOT v_is_template) THEN 
        -- Submit a job to push collections from all the beacons
        err_desc := EMD_BCN_SUBMIT_TEST_JOB(v_tgt, txn_defn_with_props.txn_defn.txn_guid, 
                      txn_defn_with_props.txn_defn.name, txn_defn_with_props.txn_defn.txn_type,
                      p_add_collection, v_rm_key_values, p_modify_txn_action_desc, v_jobs );

        IF ( err_desc IS NOT NULL ) THEN
            result := p_bcn_err_badparams;
            RETURN;
        END IF;
    END IF;
    
    result := p_bcn_success;
    err_desc := NULL;

EXCEPTION

    WHEN p_internal_error THEN
        LOG_SYS_ERR(result, 'EMD_BCN_TXN_MODIFY: failed.');
        IF v_rm_txn_thresh_keys IS NOT NULL THEN
            v_rm_txn_thresh_keys.DELETE;
            v_rm_txn_thresh_keys := NULL;
        END IF;
        IF v_rm_step_thresh_keys IS NOT NULL THEN
            v_rm_step_thresh_keys.DELETE;
            v_rm_step_thresh_keys := NULL;
        END IF;
        IF v_rm_stg_thresh_keys IS NOT NULL THEN
            v_rm_stg_thresh_keys.DELETE;
            v_rm_stg_thresh_keys := NULL;
        END IF;
        IF v_rm_key_values IS NOT NULL THEN
            v_rm_key_values.DELETE;
            v_rm_key_values := NULL;
        END IF;

    WHEN OTHERS THEN
        result := p_bcn_err_oraerr;
        err_desc := SUBSTR(SQLERRM, 1, p_err_maxlen);
        LOG_SYS_ERR(result, 'EMD_BCN_TXN_MODIFY: db error: ' || err_desc);
        IF v_rm_txn_thresh_keys IS NOT NULL THEN
            v_rm_txn_thresh_keys.DELETE;
            v_rm_txn_thresh_keys := NULL;
        END IF;
        IF v_rm_step_thresh_keys IS NOT NULL THEN
            v_rm_step_thresh_keys.DELETE;
            v_rm_step_thresh_keys := NULL;
        END IF;
        IF v_rm_stg_thresh_keys IS NOT NULL THEN
            v_rm_stg_thresh_keys.DELETE;
            v_rm_stg_thresh_keys := NULL;
        END IF;
        IF v_rm_key_values IS NOT NULL THEN
            v_rm_key_values.DELETE;
            v_rm_key_values := NULL;
        END IF;

END EMD_BCN_TXN_MODIFY;

--------------------------------------------------------------------------
-- Start monitoring a transaction
--------------------------------------------------------------------------

PROCEDURE EMD_BCN_TXN_START_MONITOR (
        tgt_id                  IN VARCHAR2,
        txn_id                  IN VARCHAR2,
        txn_defn_with_props     OUT MGMT_BCN_TXN_WITH_PROPS,
        steps_defn_with_props   OUT MGMT_BCN_STEP_WITH_PROPS_ARRAY,
        stepgroups_defn         OUT MGMT_BCN_STEPGROUP_ARRAY,
        txn_thresholds          OUT MGMT_BCN_THRESHOLD_ARRAY,
        step_thresholds         OUT MGMT_BCN_THRESHOLD_ARRAY,
        stepgroup_thresholds    OUT MGMT_BCN_THRESHOLD_ARRAY,
        bcn_list                OUT MGMT_BCN_ARRAY,
        result                  OUT INTEGER,
        err_desc                OUT VARCHAR2)
IS
  v_tgt                 RAW(16);
  v_txn                 RAW(16);
  v_txn_name            MGMT_BCN_TXN_DEFN.NAME%TYPE;
  v_txn_type            MGMT_BCN_TXN_DEFN.TXN_TYPE%TYPE;
  v_is_avail            MGMT_BCN_TXN_DEFN.IS_REPRESENTATIVE%TYPE;
  v_txn_state           VARCHAR2(8);

  v_tmp                 INTEGER;
  v_tmp_bcn_list        MGMT_BCN_ARRAY;
  v_jobs                MGMT_GENSVC_UBJOB_JOB_ARRAY; 
  v_tgt_name            MGMT_TARGETS.TARGET_NAME%TYPE;
  v_tgt_type            MGMT_TARGETS.TARGET_TYPE%TYPE;
  v_is_template         BOOLEAN;
BEGIN
  
    IF tgt_id IS NULL OR txn_id IS NULL THEN
        result := p_bcn_err_badparams;
        RETURN;
    END IF;

    result := HAS_TGT_FUNCTION_PRIV(tgt_id, p_start_txn, err_desc);
    IF result <> p_bcn_success THEN
        RETURN;
    END IF;

    v_tgt := HEXTORAW(tgt_id);
    v_txn := HEXTORAW(txn_id);

    bcn_list := NULL;

    -- Only allow this operation of the txn state is Not Monitoring or
    -- Stopping.
    SELECT name, txn_type, is_representative, state
    INTO v_txn_name, v_txn_type, v_is_avail, v_txn_state
    FROM MGMT_BCN_TXN_DEFN
    WHERE target_guid = v_tgt
        AND txn_guid = v_txn;
                
    -- REVISIT: Transaction state 'D' , 'S' Deleting/Stopping are not valid states 
    -- any more. We should remove the code which checks/sets txn state to 'D' or 'S'
    IF v_txn_state = 'M' THEN
        result := p_bcn_err_txnmonitoring;
        RAISE p_internal_error;
    END IF;
  
    -- Change the state to monitoring
    UPDATE MGMT_BCN_TXN_DEFN
    SET state = 'M'
    WHERE target_guid = v_tgt
        AND txn_guid = v_txn; 

    -- Change availability state
    BEGIN
        SELECT target_name, target_type 
          INTO v_tgt_name, v_tgt_type
          FROM mgmt_targets 
         WHERE target_guid = tgt_id; 
    EXCEPTION
        WHEN NO_DATA_FOUND THEN
            err_desc := 'Invalid target id '||tgt_id;
            result := p_bcn_err_tgtnotfound;
            RETURN;
    END;
    bcn_list := EMD_BCN_GET_BEACONS(tgt_id, txn_id);
    v_is_template := EMD_BCN_IS_TEMPLATE(v_tgt);

    IF NOT v_is_template THEN
     
        MGMT_GENSVC_AVAIL.AVAIL_EVENT( v_tgt_name, v_tgt_type, v_txn_name, v_txn_type, null, 
                                              MGMT_GENSVC_AVAIL.k_event_start_monit, 'Enable');
        -- Change availability state Done
    
        -- Get the beacons
        -- REVISIT: Do we need to use this list of beacons to retrieve
        -- thresholds?
    
        err_desc := EMD_BCN_SUBMIT_TEST_JOB(v_tgt, v_txn, v_txn_name, v_txn_type, 
               p_add_collection, null, p_start_txn_action_desc, v_jobs );
        IF ( err_desc IS NOT NULL ) THEN 
            result := p_bcn_err_badparams;
            RETURN;
        END IF;
    END IF;

    -- Get all the state corresponding to this transaction
    EMD_BCN_TXN_VIEW (tgt_id, txn_id, txn_defn_with_props,
        steps_defn_with_props, stepgroups_defn, txn_thresholds,
        step_thresholds, stepgroup_thresholds, v_tmp_bcn_list, result, err_desc);
    
    IF result <> p_bcn_success THEN
        RAISE p_internal_error;
    END IF;

   
    result := p_bcn_success;
    err_desc := NULL;
    
EXCEPTION

    WHEN p_internal_error THEN
        LOG_SYS_ERR(result, 'EMD_BCN_TXN_START_MONITOR: failed.');
        txn_defn_with_props := NULL;
        IF steps_defn_with_props IS NOT NULL THEN
            steps_defn_with_props.DELETE;
            steps_defn_with_props := NULL;
        END IF;
        IF stepgroups_defn IS NOT NULL THEN
            stepgroups_defn.DELETE;
            stepgroups_defn := NULL;
        END IF;
        IF txn_thresholds IS NOT NULL THEN
            txn_thresholds.DELETE;
            txn_thresholds := NULL;
        END IF;
        IF step_thresholds IS NOT NULL THEN
            step_thresholds.DELETE;
            step_thresholds := NULL;
        END IF;
        IF stepgroup_thresholds IS NOT NULL THEN
            stepgroup_thresholds.DELETE;
            stepgroup_thresholds := NULL;
        END IF;
        IF bcn_list IS NOT NULL THEN
            bcn_list.DELETE;
            bcn_list := NULL;
        END IF;

    WHEN OTHERS THEN
        result := p_bcn_err_oraerr;
        err_desc := SUBSTR(SQLERRM, 1, p_err_maxlen);
        LOG_SYS_ERR(result, 'EMD_BCN_TXN_START_MONITOR: db error: ' || err_desc);
        txn_defn_with_props := NULL;
        IF steps_defn_with_props IS NOT NULL THEN
            steps_defn_with_props.DELETE;
            steps_defn_with_props := NULL;
        END IF;
        IF stepgroups_defn IS NOT NULL THEN
            stepgroups_defn.DELETE;
            stepgroups_defn := NULL;
        END IF;
        IF txn_thresholds IS NOT NULL THEN
            txn_thresholds.DELETE;
            txn_thresholds := NULL;
        END IF;
        IF step_thresholds IS NOT NULL THEN
            step_thresholds.DELETE;
            step_thresholds := NULL;
        END IF;
        IF stepgroup_thresholds IS NOT NULL THEN
            stepgroup_thresholds.DELETE;
            stepgroup_thresholds := NULL;
        END IF;
        IF bcn_list IS NOT NULL THEN
            bcn_list.DELETE;
            bcn_list := NULL;
        END IF;

END EMD_BCN_TXN_START_MONITOR;
--------------------------------------------------------------------------

--------------------------------------------------------------------------
-- Stop monitoring a transaction
--------------------------------------------------------------------------

PROCEDURE EMD_BCN_TXN_STOP_MONITOR(
        tgt_id                  IN VARCHAR2,
        txn_id                  IN VARCHAR2,
        bcn_list                OUT MGMT_BCN_ARRAY,
        result                  OUT INTEGER,
        err_desc                OUT VARCHAR2)
IS
    v_tgt                 RAW(16);
    v_txn                 RAW(16);
    v_txn_name            MGMT_BCN_TXN_DEFN.name%TYPE;
    v_txn_state           VARCHAR2(8);
    v_txn_rep             CHAR(1);
    v_txn_type            MGMT_BCN_TXN_DEFN.TXN_TYPE%TYPE;
    v_txn_array           MGMT_GENSVC_UBJOB_TEST_ARRAY;
    v_tmp                 INTEGER;
    v_jobs                MGMT_GENSVC_UBJOB_JOB_ARRAY; 
    v_tgt_name            MGMT_TARGETS.TARGET_NAME%TYPE;
    v_tgt_type            MGMT_TARGETS.TARGET_TYPE%TYPE;
    v_is_template         BOOLEAN;
    v_rm_key_values       SMP_EMD_STRING_ARRAY;
BEGIN
  
    IF tgt_id IS NULL OR txn_id IS NULL THEN
        result := p_bcn_err_badparams;
        RETURN;
    END IF;

    result := HAS_TGT_FUNCTION_PRIV (tgt_id, p_stop_txn, err_desc);
    IF result <> p_bcn_success THEN
        RETURN;
    END IF;

    v_tgt := HEXTORAW(tgt_id);
    v_txn := HEXTORAW(txn_id);

    bcn_list := NULL;

    SELECT name, txn_type, is_representative, state
    INTO v_txn_name, v_txn_type, v_txn_rep, v_txn_state
    FROM MGMT_BCN_TXN_DEFN
    WHERE target_guid = v_tgt
        AND txn_guid = v_txn; 

    -- Cannot stop the representative txn
    IF v_txn_rep = 'Y' THEN
        result := p_bcn_err_reptxn;
        RAISE p_internal_error;
    END IF;

    -- Only allow this operation of the txn state is Monitoring.
    IF v_txn_state <> 'M' THEN
        result := p_bcn_err_txnnotmonitor;
        RAISE p_internal_error;
    END IF;

    -- Change availability state
    BEGIN
        SELECT target_name, target_type 
          INTO v_tgt_name, v_tgt_type
          FROM mgmt_targets 
         WHERE target_guid = tgt_id; 
    EXCEPTION
        WHEN NO_DATA_FOUND THEN
            err_desc := 'Invalid target id '||tgt_id;
            result := p_bcn_err_tgtnotfound;
            RETURN;
    END;
   -- Change availability state Done

    -- Get the beacons
    -- Get the beacons
    bcn_list := EMD_BCN_GET_BEACONS(tgt_id, txn_id);
    -- Change the state to not-monitoring / stopped

    /* Close the severities before submitting the job*/
    CLOSE_TXN_SEVS(v_tgt, v_txn, v_txn_name);
        -- REVISIT: Need to close step and group severities too.

    UPDATE MGMT_BCN_TXN_DEFN
    SET state = 'NM'
    WHERE target_guid = v_tgt
        AND txn_guid = v_txn; 

    v_is_template := EMD_BCN_IS_TEMPLATE(v_tgt);

    --Get key values for this transaction
    SELECT distinct composite_key 
      BULK COLLECT INTO v_rm_key_values 
      FROM MGMT_METRICS_COMPOSITE_KEYS
     WHERE target_guid = v_tgt
       AND key_part1_value = v_txn_name;

    IF NOT v_is_template THEN
        MGMT_GENSVC_AVAIL.AVAIL_EVENT( v_tgt_name, v_tgt_type, v_txn_name, v_txn_type, null, 
                    MGMT_GENSVC_AVAIL.k_event_stop_monit, 'Disable');
         err_desc := EMD_BCN_SUBMIT_TEST_JOB(v_tgt, v_txn, v_txn_name, v_txn_type,
               p_remove_collection, v_rm_key_values, p_stop_txn_action_desc, v_jobs );
        IF ( err_desc IS NOT NULL ) THEN
            result := p_bcn_err_badparams;
            RETURN;
        END IF;
    END IF;
    result := p_bcn_success;
    err_desc := NULL;

EXCEPTION

    WHEN p_internal_error THEN
        LOG_SYS_ERR(result, 'EMD_BCN_TXN_STOP_MONITOR: failed.');
        IF bcn_list IS NOT NULL THEN
            bcn_list.DELETE;
            bcn_list := NULL;
        END IF;

    WHEN OTHERS THEN
        result := p_bcn_err_oraerr;
        err_desc := SUBSTR(SQLERRM, 1, p_err_maxlen);
        LOG_SYS_ERR(result, 'EMD_BCN_TXN_STOP_MONITOR: db error: ' || err_desc);
        IF bcn_list IS NOT NULL THEN
            bcn_list.DELETE;
            bcn_list := NULL;
        END IF;

END EMD_BCN_TXN_STOP_MONITOR;
--------------------------------------------------------------------------

--------------------------------------------------------------------------
-- Set status after pushing to agents
-- REVISIT: This procedure will not be used anymore. We should delete this 
-- procedure. 
--------------------------------------------------------------------------
/*
PROCEDURE EMD_BCN_TXN_SET_STATUS(
        tgt_id                  IN VARCHAR2,
        status_list             IN MGMT_BCN_TXN_STATUS_ARRAY,
        result                  OUT INTEGER,
        err_desc                OUT VARCHAR2)
IS

    CURSOR v_txn_cur ( tgt RAW, txn_list MGMT_BCN_RAW_GUID_ARRAY) IS
        SELECT txn_guid, name, state
        FROM MGMT_BCN_TXN_DEFN
        WHERE target_guid = tgt
            AND (state = 'S' OR state = 'D')
            AND txn_guid IN (
                    SELECT * 
                    FROM TABLE(CAST(txn_list AS MGMT_BCN_RAW_GUID_ARRAY))
                );

    CURSOR v_bcn_cur ( tgt RAW, bcn_list MGMT_BCN_RAW_GUID_ARRAY) IS
        SELECT beacon_target_guid, t.target_name AS beacon_name
        FROM MGMT_BCN_TARGET bt, MGMT_TARGETS t
        WHERE bt.target_guid = tgt
            AND is_removing = 'Y'
            AND t.target_guid = beacon_target_guid
            AND beacon_target_guid IN (
                    SELECT * 
                    FROM TABLE(CAST(bcn_list AS MGMT_BCN_RAW_GUID_ARRAY))
                );

    v_tgt                    RAW(16);
    v_txn                    RAW(16);
    v_bcn                    RAW(16);

    v_txn_ctr                PLS_INTEGER;
    v_txn_list               p_guid_list_type;
    v_fail_txn_list          p_bool_list_type;
    v_bcn_ctr                PLS_INTEGER;
    v_bcn_list               p_guid_list_type;
    v_fail_bcn_list          p_bool_list_type;

    v_txn_rec                v_txn_cur%ROWTYPE;
    v_bcn_rec                v_bcn_cur%ROWTYPE;
    v_guid_ctr               PLS_INTEGER;
    v_guid_list              MGMT_BCN_RAW_GUID_ARRAY;

    v_tmp                    PLS_INTEGER;
    v_tmp2                   PLS_INTEGER;
    v_found                  BOOLEAN;
    v_more                   BOOLEAN;
    v_count                  PLS_INTEGER;
    v_curdate                DATE;

    v_ck                     RAW(16);

BEGIN

    IF tgt_id IS NULL THEN
        result := p_bcn_err_badparams;
        RETURN;
    END IF;

    v_tgt := HEXTORAW(tgt_id);

    -- if the status list is empty, simply unlock the target
    IF status_list IS NULL OR status_list.COUNT <= 0 THEN
        v_tmp := EMD_BCN_UNLOCK_TARGET(v_tgt);
        result := p_bcn_success;  
        err_desc := NULL;
        RETURN;
    END IF;

    v_curdate := SYSDATE;
    v_txn_ctr := 0;
    v_bcn_ctr := 0;
    v_guid_list := NULL;

    -- First handle the success statuses
    FOR v_tmp IN 1..status_list.COUNT LOOP
        IF status_list(v_tmp) IS NOT NULL AND 
            status_list(v_tmp).attempt_status = 'S' THEN

            -- Convert guids to raw
            IF status_list(v_tmp).txn_guid IS NOT NULL THEN
                v_txn := HEXTORAW(status_list(v_tmp).txn_guid);
            ELSE
                v_txn := NULL;
            END IF;

            IF status_list(v_tmp).bcn_guid IS NOT NULL THEN
                v_bcn := HEXTORAW(status_list(v_tmp).bcn_guid);
            ELSE
                v_bcn := NULL;
            END IF;

            -- Update the bcn/txn record
            UPDATE MGMT_BCN_TARGET_TXN 
            SET state = DECODE(status_list(v_tmp).is_monitoring, 
                        'Y', 'M', 'NM'),
                version = DECODE(status_list(v_tmp).is_monitoring,
                        'Y', status_list(v_tmp).version, NULL),
                req_update = 0,
                pushed_date = v_curdate,
                attempt_date = v_curdate,
                attempt_status = status_list(v_tmp).attempt_status,
                attempt_desc = status_list(v_tmp).attempt_desc
            WHERE target_guid = v_tgt
                AND beacon_target_guid = v_bcn
                AND txn_guid = v_txn;

            IF status_list(v_tmp).is_monitoring = 'N' THEN
                -- Add to the txn list
                v_found := FALSE;
                v_tmp2 := 1;
                WHILE NOT v_found AND v_tmp2 < v_txn_ctr LOOP
                    IF v_txn_list(v_tmp2) = v_txn THEN
                        v_found := TRUE;
                    END IF;
                    v_tmp2 := v_tmp2 + 1;
                END LOOP;
                IF NOT v_found THEN
                    v_txn_ctr := v_txn_ctr + 1;
                    v_txn_list(v_txn_ctr) := v_txn;
                END IF;
                -- Add to the bcn list
                v_found := FALSE;
                v_tmp2 := 1;
                WHILE NOT v_found AND v_tmp2 < v_bcn_ctr LOOP
                    IF v_bcn_list(v_tmp2) = v_bcn THEN
                        v_found := TRUE;
                    END IF;
                    v_tmp2 := v_tmp2 + 1;
                END LOOP;
                IF NOT v_found THEN
                    v_bcn_ctr := v_bcn_ctr + 1;
                    v_bcn_list(v_bcn_ctr) := v_bcn;
                END IF;
            --ELSE
                -- Insert a CLEAR severity for all metrics
                -- REVISIT: Use the GET_COMPOSITE_KEY function
                --BEGIN
                --    SELECT k.composite_key
                --    INTO v_ck
                --    FROM MGMT_METRICS_COMPOSITE_KEYS k, MGMT_BCN_TXN_DEFN x, MGMT_TARGETS t
                --    WHERE t.target_guid = v_bcn
                --        AND x.txn_guid = v_txn
                --        AND k.target_guid = v_tgt
                --        AND k.key_part1_value = x.name
                --        AND k.key_part2_value = 
                --                DECODE(v_tgt, v_bcn, p_local_target_name, t.target_name);
                --EXCEPTION
                --    WHEN NO_DATA_FOUND THEN
                --        v_ck := NULL;
                --END;

            END IF;
        END IF;
    END LOOP;

    FOR v_tmp IN 1..v_txn_ctr LOOP
        v_fail_txn_list(v_tmp) := FALSE;
    END LOOP;

    FOR v_tmp IN 1..v_bcn_ctr LOOP
        v_fail_bcn_list(v_tmp) := FALSE;
    END LOOP;

    -- Now handle the failure statuses
    FOR v_tmp IN 1..status_list.COUNT LOOP
        IF status_list(v_tmp) IS NOT NULL AND 
                status_list(v_tmp).attempt_status <> 'S' THEN

            -- Convert guids to raw
            IF status_list(v_tmp).txn_guid IS NOT NULL THEN
                v_txn := HEXTORAW(status_list(v_tmp).txn_guid);
            ELSE
                v_txn := NULL;
            END IF;
    
            IF status_list(v_tmp).bcn_guid IS NOT NULL THEN
                v_bcn := HEXTORAW(status_list(v_tmp).bcn_guid);
            ELSE
                v_bcn := NULL;
            END IF;
    
            -- Update the bcn/txn record
            UPDATE MGMT_BCN_TARGET_TXN 
            SET attempt_date = v_curdate,
                attempt_status = status_list(v_tmp).attempt_status,
                attempt_desc = status_list(v_tmp).attempt_desc
            WHERE target_guid = v_tgt
                AND beacon_target_guid = v_bcn
                AND txn_guid = v_txn;
    
            -- Remove from the txn list
            v_found := FALSE;
            v_tmp2 := 1;
            WHILE NOT v_found AND v_tmp2 < v_txn_ctr LOOP
                IF v_txn_list(v_tmp2) = v_txn THEN
                    v_fail_txn_list(v_tmp2) := TRUE;
                    v_found := TRUE;
                END IF;
                v_tmp2 := v_tmp2 + 1;
            END LOOP;
    
            -- Remove to the bcn list
            v_found := FALSE;
            v_tmp2 := 1;
            WHILE NOT v_found AND v_tmp2 < v_bcn_ctr LOOP
                IF v_bcn_list(v_tmp2) = v_bcn THEN
                    v_fail_bcn_list(v_tmp2) := TRUE;
                    v_found := TRUE;
                END IF;
                v_tmp2 := v_tmp2 + 1;
            END LOOP;
        END IF;
    END LOOP;

    -- Any txns to stop/delete?
    IF v_txn_ctr > 0 THEN
        v_guid_ctr := 0;
        FOR v_tmp IN 1..v_txn_ctr LOOP
            IF NOT v_fail_txn_list(v_tmp) THEN
                IF v_guid_ctr = 0 THEN
                    v_guid_list := MGMT_BCN_RAW_GUID_ARRAY();
                END IF;
                v_guid_ctr := v_guid_ctr + 1;
                v_guid_list.EXTEND;
                v_guid_list(v_guid_ctr) := v_txn_list(v_tmp);
            END IF;
        END LOOP;

        IF v_guid_ctr > 0 THEN
            OPEN v_txn_cur(v_tgt, v_guid_list);
            v_more := TRUE;
            WHILE v_more LOOP
                FETCH v_txn_cur INTO v_txn_rec;
                v_more := v_txn_cur%FOUND;
                IF v_more THEN
                    SELECT COUNT(*) 
                    INTO v_count
                    FROM MGMT_BCN_TARGET_TXN
                    WHERE target_guid = v_tgt
                        AND txn_guid = v_txn_rec.txn_guid
                        AND state = 'M';
                        
                    IF v_count = 0 THEN
                        -- Delete open sevs and current metrics
                        CLOSE_TXN_SEVS(v_tgt, v_txn_rec.txn_guid, v_txn_rec.name);
                        -- REVISIT: Need to close step and group severities too.
                        -- Delete/Stop the txn
                        IF v_txn_rec.state = 'S' THEN
                            UPDATE MGMT_BCN_TXN_DEFN
                            SET state = 'NM'
                            WHERE target_guid = v_tgt
                                AND txn_guid = v_txn_rec.txn_guid;
                        ELSIF v_txn_rec.state = 'D' THEN
                            DEL_TXN_METRICS(v_tgt, v_txn_rec.txn_guid);
                            -- Delete the txn
                            DELETE FROM MGMT_BCN_TARGET_TXN
                            WHERE target_guid = v_tgt 
                                AND txn_guid = v_txn_rec.txn_guid;
                            DELETE FROM MGMT_BCN_TXN_DEFN
                            WHERE target_guid = v_tgt 
                                AND txn_guid = v_txn_rec.txn_guid;
                            DELETE FROM MGMT_ADMIN_METRIC_THRESHOLDS
                            WHERE target_guid = v_tgt
                                AND coll_name = RAWTOHEX(v_txn_rec.txn_guid);
                            DELETE FROM MGMT_METRIC_THRESHOLDS
                            WHERE target_guid = v_tgt
                                AND coll_name = RAWTOHEX(v_txn_rec.txn_guid);
                        END IF;
                    END IF;
                END IF;
            END LOOP;
            CLOSE v_txn_cur;
        END IF;
    END IF;    

    IF v_guid_list IS NOT NULL THEN
        v_guid_list.DELETE;
        v_guid_list := NULL;
    END IF;

    -- Any beacons to remove
    IF v_bcn_ctr > 0 THEN
        v_guid_ctr := 0;
        FOR v_tmp IN 1..v_bcn_ctr LOOP
            IF NOT v_fail_bcn_list(v_tmp) THEN
                IF v_guid_ctr = 0 THEN
                    v_guid_list := MGMT_BCN_RAW_GUID_ARRAY();
                END IF;
                v_guid_ctr := v_guid_ctr + 1;
                v_guid_list.EXTEND;
                v_guid_list(v_guid_ctr) := v_bcn_list(v_tmp);
            END IF;
        END LOOP;
        IF v_guid_ctr > 0 THEN
            OPEN v_bcn_cur(v_tgt, v_guid_list);
            v_more := TRUE;
            WHILE v_more LOOP
                FETCH v_bcn_cur INTO v_bcn_rec;
                v_more := v_bcn_cur%FOUND;
                IF v_more THEN
                    SELECT COUNT(*) 
                    INTO v_count
                    FROM MGMT_BCN_TARGET_TXN
                    WHERE target_guid = v_tgt
                        AND beacon_target_guid = v_bcn_rec.beacon_target_guid
                        AND state = 'M';
                        
                    IF v_count = 0 THEN
                        -- Delete any open alerts and current metrics
                        CLOSE_BCN_SEVS(v_tgt, v_bcn_rec.beacon_target_guid,
                                v_bcn_rec.beacon_name);
                        -- REVISIT: Need to close step and group severities too.
                        DEL_BCN_METRICS(v_tgt, v_bcn_rec.beacon_target_guid);
                        -- Delete the bcn
                        DELETE FROM MGMT_BCN_TARGET_TXN
                        WHERE target_guid = v_tgt 
                            AND beacon_target_guid = v_bcn_rec.beacon_target_guid;
                        DELETE FROM MGMT_BCN_TARGET
                        WHERE target_guid = v_tgt 
                            AND beacon_target_guid = v_bcn_rec.beacon_target_guid;
                        DELETE FROM MGMT_ADMIN_METRIC_THRESHOLDS
                        WHERE target_guid = v_tgt
                            AND key_value IN (
                        SELECT RAWTOHEX(composite_key)
                        FROM MGMT_METRICS_COMPOSITE_KEYS
                        WHERE target_guid = v_tgt
                            AND key_part2_value =  v_bcn_rec.beacon_name);
                        DELETE FROM MGMT_METRIC_THRESHOLDS
                        WHERE target_guid = v_tgt
                            AND key_value IN (
                        SELECT RAWTOHEX(composite_key)
                        FROM MGMT_METRICS_COMPOSITE_KEYS
                        WHERE target_guid = v_tgt
                            AND key_part2_value =  v_bcn_rec.beacon_name);
                    END IF;
                END IF;
            END LOOP;
            CLOSE v_bcn_cur;
        END IF;
    END IF;    

    IF v_guid_list IS NOT NULL THEN
        v_guid_list.DELETE;
        v_guid_list := NULL;
    END IF;

    -- Done
    COMMIT;

    v_tmp := EMD_BCN_UNLOCK_TARGET(v_tgt);

    result := p_bcn_success;  
    err_desc := NULL;

EXCEPTION

    WHEN OTHERS THEN
        result := p_bcn_err_oraerr;
        err_desc := SUBSTR(SQLERRM, 1, p_err_maxlen);
        LOG_SYS_ERR(result, 'EMD_BCN_TXN_SET_STATUS: db error: ' || err_desc);
        ROLLBACK;
        v_tmp := EMD_BCN_UNLOCK_TARGET(v_tgt);
        IF v_guid_list IS NOT NULL THEN
            v_guid_list.DELETE;
            v_guid_list := NULL;
        END IF;

END EMD_BCN_TXN_SET_STATUS;
--------------------------------------------------------------------------

--------------------------------------------------------------------------
-- Apply beacon additions/removals
-- REVISIT: This procedure will not be used anymore. We should delete this 
-- procedure. 
--------------------------------------------------------------------------

PROCEDURE EMD_BCN_SET_BCNS(
        tgt_id                  IN VARCHAR2,
        new_bcn_list            IN MGMT_BCN_NAME_ARRAY,
        transactions            OUT MGMT_BCN_TRANSACTION_ARRAY,
        add_bcn_list            OUT MGMT_BCN_ARRAY,
        del_bcn_list            OUT MGMT_BCN_ARRAY,
        keep_bcn_list           OUT MGMT_BCN_NAME_ARRAY,
        dbdel_bcn_list          OUT MGMT_BCN_NAME_ARRAY,
        result                  OUT INTEGER,
        err_desc                OUT VARCHAR2)
IS
    TYPE v_new_bcn_rec_type IS RECORD(
        bcn_guid        RAW(16),
        bcn_name        VARCHAR2(64),
        emd_url         VARCHAR(2000),
        bcn_ver         VARCHAR2(8),
        found           CHAR(1),
        remov           CHAR(1));

    TYPE v_new_bcn_list_type IS
        TABLE OF v_new_bcn_rec_type
        INDEX BY BINARY_INTEGER;

    CURSOR v_new_bcn_cur(bcn_list IN MGMT_BCN_NAME_ARRAY) IS
        SELECT target_guid, target_name, emd_url, type_meta_ver, 'N', 'N'
        FROM MGMT_TARGETS
        WHERE target_type = p_beacon_type 
            AND target_name IN (
                SELECT * 
                FROM TABLE(CAST(bcn_list AS MGMT_BCN_NAME_ARRAY))
                );

    CURSOR v_old_bcn_cur (tgt RAW) IS
        SELECT beacon_target_guid, participates_avail, is_removing, 
                t.target_name AS beacon_name
        FROM MGMT_BCN_TARGET bt, MGMT_TARGETS t
        WHERE bt.target_guid = tgt
            AND beacon_target_guid <> tgt
            AND beacon_target_guid = t.target_guid;

    CURSOR v_del_bcn_cur (bcn_list IN MGMT_BCN_RAW_GUID_ARRAY) IS
        SELECT target_guid, target_name, emd_url, type_meta_ver
        FROM MGMT_TARGETS
        WHERE target_type = p_beacon_type 
            AND target_guid IN (
                SELECT * 
                FROM TABLE(CAST(bcn_list AS MGMT_BCN_RAW_GUID_ARRAY))
                );

    CURSOR v_txn_cur (tgt RAW) IS
        SELECT txn_guid, txn_type, name, state 
        FROM MGMT_BCN_TXN_DEFN
        WHERE target_guid = tgt;


    v_tgt                 RAW(16);
    v_txn                 RAW(16);

    v_num_new_bcns        PLS_INTEGER;
    v_new_bcns            v_new_bcn_list_type;

    v_old_bcn_rec         v_old_bcn_cur%ROWTYPE;
    v_found_ctr           PLS_INTEGER;
    v_add_ctr             PLS_INTEGER;
    v_del_ctr             PLS_INTEGER;
    v_del_bcns            MGMT_BCN_RAW_GUID_ARRAY;
    v_del_bcn_rec         v_del_bcn_cur%ROWTYPE;
    v_dbdel_ctr           PLS_INTEGER := 0;

    v_txn_rec             v_txn_cur%ROWTYPE;
    v_txn_ctr             PLS_INTEGER;
    v_step_ctr            PLS_INTEGER;

    v_tmp_txn             MGMT_BCN_TXN_WITH_PROPS;
    v_tmp_steps           MGMT_BCN_STEP_WITH_PROPS_ARRAY;
    v_tmp_stepgroups      MGMT_BCN_STEPGROUP_ARRAY;
    v_tmp_txn_thresh      MGMT_BCN_THRESHOLD_ARRAY;
    v_tmp_step_thresh     MGMT_BCN_THRESHOLD_ARRAY;
    v_tmp_stpgrp_thresh   MGMT_BCN_THRESHOLD_ARRAY;

    v_tmp                 PLS_INTEGER;
    v_tmp2                PLS_INTEGER;
    v_more                BOOLEAN;
    v_found               BOOLEAN;
    v_count               PLS_INTEGER;

    v_ck                  RAW(16);
    v_name                VARCHAR2(64);
    v_target_type         VARCHAR2(64);
  
    v_max_def             PLS_INTEGER;
    v_avg_def             PLS_INTEGER;

    v_tgt_locked          BOOLEAN := FALSE;

    v_key_part_values     SMP_EMD_STRING_ARRAY;

BEGIN
    IF tgt_id IS NULL THEN
        result := p_bcn_err_badparams;
        RETURN;
    END IF;
  
    result := HAS_TGT_FUNCTION_PRIV(tgt_id, p_set_beacons, err_desc);
    IF result <> p_bcn_success THEN
        RETURN;
    END IF;

    v_tgt := HEXTORAW(tgt_id);
    transactions := NULL;
    add_bcn_list := NULL;
    del_bcn_list := NULL;
    v_del_bcns := NULL;

    -- Lock the target
    result := EMD_BCN_LOCK_TARGET(v_tgt);
    IF result <> p_bcn_success THEN
        RETURN;
    END IF;
    v_tgt_locked := TRUE;

    -- DBMS_OUTPUT.PUT_LINE('SET_BCNS: start');

    -- Cannot perform this operation on a target of type beacon
    BEGIN
        SELECT target_type
        INTO v_target_type
        FROM MGMT_TARGETS
        WHERE target_guid = v_tgt;
    EXCEPTION
        WHEN NO_DATA_FOUND THEN
            result := p_bcn_err_tgtnotfound;
            RAISE p_internal_error;
    END;
    IF v_target_type = p_beacon_type THEN
        result := p_bcn_err_invalidbcnop;
        RAISE p_internal_error;
    END IF;

    -- Get the details on the beacons in the new list
    v_num_new_bcns := 0;
    IF new_bcn_list IS NOT NULL AND new_bcn_list.COUNT > 0 THEN
        OPEN v_new_bcn_cur(new_bcn_list);
        v_more := TRUE;
        WHILE v_more LOOP
            v_num_new_bcns := v_num_new_bcns + 1;
            FETCH v_new_bcn_cur INTO v_new_bcns(v_num_new_bcns);
            v_more := v_new_bcn_cur%FOUND;
            IF v_more THEN
                -- Remove the the local emd instance from the 
                -- list.  It's a special case (cannot be removed) 
                -- and is not to be processed with the beacons.
                IF v_new_bcns(v_num_new_bcns).bcn_guid = v_tgt THEN
                    v_num_new_bcns := v_num_new_bcns - 1; 
                END IF;
            END IF;
        END LOOP;
        CLOSE v_new_bcn_cur;
        IF v_num_new_bcns > 0 THEN
            v_num_new_bcns := v_num_new_bcns - 1; 
        END IF;
    END IF;

    -- DBMS_OUTPUT.PUT_LINE('SET_BCNS: v_num_new_bcns: ' || v_num_new_bcns);

    -- Calculate which beacons to add and which to delete
    -- Loop over the existing list of beacons and compare against
    -- the new list.
    v_found_ctr := 0;
    v_del_ctr := 0;
    v_more := TRUE;
    OPEN v_old_bcn_cur(v_tgt);
    WHILE v_more LOOP
        FETCH v_old_bcn_cur INTO v_old_bcn_rec;
        v_more := v_old_bcn_cur%FOUND;
        IF v_more THEN
            v_found := FALSE;
            IF v_num_new_bcns > 0 THEN
                -- Compare with the new beacon list to find the delta
                v_tmp := 1;
                WHILE NOT v_found AND v_tmp <= v_num_new_bcns LOOP
                    IF v_old_bcn_rec.beacon_target_guid = v_new_bcns(v_tmp).bcn_guid THEN
                        v_new_bcns(v_tmp).found := 'Y';
                        v_new_bcns(v_tmp).remov := v_old_bcn_rec.is_removing;
                        v_found := TRUE;
                        -- Add it to the keep list
                        IF v_found_ctr = 0 THEN
                            keep_bcn_list := MGMT_BCN_NAME_ARRAY();
                        END IF;
                        v_found_ctr := v_found_ctr + 1;
                        keep_bcn_list.EXTEND;
                        keep_bcn_list(v_found_ctr) := v_old_bcn_rec.beacon_name;
                    END IF;
                    v_tmp := v_tmp + 1;
                END LOOP;
            END IF;
            -- Not in the new list?  Delete the beacon from the target.
            IF NOT v_found THEN
                -- Cannot remove a beacon that participates in avail
                IF v_old_bcn_rec.participates_avail = 'Y' THEN
                    result := p_bcn_err_bcninavail;
                    err_desc := RAWTOHEX(v_old_bcn_rec.beacon_target_guid);
                    RAISE p_internal_error;
                END IF;
                -- If it's not monitoring any txns, delete it outright.
                SELECT count(*) 
                INTO v_count
                FROM MGMT_BCN_TARGET_TXN
                WHERE target_guid = v_tgt
                    AND beacon_target_guid = v_old_bcn_rec.beacon_target_guid
                    AND state = 'M';
                IF v_count <= 0 THEN
                    -- Delete any open alerts and current metrics
                    -- REVISIT: Need to do this for step and stepgroup severities
                    CLOSE_BCN_SEVS(v_tgt, v_old_bcn_rec.beacon_target_guid,
                            v_old_bcn_rec.beacon_name);
                    DEL_BCN_METRICS(v_tgt, v_old_bcn_rec.beacon_target_guid);
                    -- Delete all records pertaining to the bcn for the target
                    DELETE 
                    FROM MGMT_BCN_TARGET_TXN
                    WHERE beacon_target_guid = v_old_bcn_rec.beacon_target_guid
                        AND target_guid = v_tgt;
                    DELETE 
                    FROM MGMT_BCN_TARGET
                    WHERE beacon_target_guid = v_old_bcn_rec.beacon_target_guid
                        AND target_guid = v_tgt;
                    DELETE 
                    FROM MGMT_ADMIN_METRIC_THRESHOLDS
                    WHERE target_guid = v_tgt
                        AND key_value IN (
                            SELECT RAWTOHEX(composite_key)
                            FROM MGMT_METRICS_COMPOSITE_KEYS
                            WHERE target_guid = v_tgt
                                AND key_part2_value =  v_old_bcn_rec.beacon_name);
                    DELETE 
                    FROM MGMT_METRIC_THRESHOLDS
                    WHERE target_guid = v_tgt
                        AND key_value IN (
                            SELECT RAWTOHEX(composite_key)
                            FROM MGMT_METRICS_COMPOSITE_KEYS
                            WHERE target_guid = v_tgt
                                AND key_part2_value =  v_old_bcn_rec.beacon_name);
          
                    -- Add it to the dbdel list
                    IF v_dbdel_ctr = 0 THEN
                        dbdel_bcn_list := MGMT_BCN_NAME_ARRAY();
                    END IF;
                    dbdel_bcn_list.EXTEND;
                    v_dbdel_ctr := v_dbdel_ctr + 1;
                    dbdel_bcn_list(v_dbdel_ctr) := v_old_bcn_rec.beacon_name;
                ELSE
                    IF v_del_ctr = 0 THEN
                        v_del_bcns := MGMT_BCN_RAW_GUID_ARRAY();
                    END IF;
                    v_del_bcns.EXTEND;
                    v_del_ctr := v_del_ctr + 1;
                    v_del_bcns(v_del_ctr) := v_old_bcn_rec.beacon_target_guid;
                END IF;
            END IF;
        END IF;
    END LOOP;
    CLOSE v_old_bcn_cur;

    -- DBMS_OUTPUT.PUT_LINE('SET_BCNS: v_found_ctr: ' || v_found_ctr);
    -- DBMS_OUTPUT.PUT_LINE('SET_BCNS: v_del_ctr: ' || v_del_ctr);

    -- Beacons to be added
    v_add_ctr := 0;
    IF v_found_ctr < v_num_new_bcns THEN
        FOR v_tmp IN 1..v_num_new_bcns LOOP
            IF v_new_bcns(v_tmp).found = 'N' AND v_new_bcns(v_tmp).remov <> 'Y' THEN
                IF v_add_ctr = 0 THEN
                    add_bcn_list := MGMT_BCN_ARRAY();
                END IF;
                add_bcn_list.EXTEND;
                v_add_ctr := v_add_ctr + 1;
                add_bcn_list(v_add_ctr) := MGMT_BCN(
                        v_new_bcns(v_tmp).bcn_guid,
                        v_new_bcns(v_tmp).bcn_name,
                        p_beacon_type,
                        v_new_bcns(v_tmp).emd_url,
                        v_new_bcns(v_tmp).bcn_ver, null);
                -- Add entry into MGMT_BCN_TARGET
                INSERT INTO MGMT_BCN_TARGET
                    (target_guid, beacon_target_guid)
                VALUES
                    (v_tgt, v_new_bcns(v_tmp).bcn_guid);
            END IF;
        END LOOP;
    END IF;

    -- DBMS_OUTPUT.PUT_LINE('SET_BCNS: v_add_ctr: ' || v_add_ctr);

    -- Beacons to be deleted
    v_del_ctr := 0;
    IF v_del_bcns IS NOT NULL AND v_del_bcns.COUNT > 0 THEN    
        v_more := TRUE;
        OPEN v_del_bcn_cur(v_del_bcns);
        WHILE v_more LOOP
            FETCH v_del_bcn_cur INTO v_del_bcn_rec;
            v_more := v_del_bcn_cur%FOUND;
            IF v_more THEN
                IF v_del_ctr = 0 THEN
                    del_bcn_list := MGMT_BCN_ARRAY();
                END IF;
                del_bcn_list.EXTEND;
                v_del_ctr := v_del_ctr + 1;
                del_bcn_list(v_del_ctr) := MGMT_BCN(
                        v_del_bcn_rec.target_guid,
                        v_del_bcn_rec.target_name,
                        p_beacon_type,
                        v_del_bcn_rec.emd_url,
                        v_del_bcn_rec.type_meta_ver, null);
                -- Set the bcn to be removed from the target
                UPDATE MGMT_BCN_TARGET
                SET is_removing = 'Y'
                WHERE target_guid = v_tgt
                    AND beacon_target_guid = v_del_bcn_rec.target_guid;
            END IF;
        END LOOP;
        CLOSE v_del_bcn_cur;
    END IF;

    -- DBMS_OUTPUT.PUT_LINE('SET_BCNS: v_del_ctr: ' || v_del_ctr);

    -- Get the transactions, steps, stepgroups, thresholds
    IF v_add_ctr > 0 OR v_del_ctr > 0 THEN
        v_more := TRUE;
        v_txn_ctr := 0;
        v_step_ctr := 0;
        OPEN v_txn_cur(v_tgt);
        WHILE v_more LOOP
            FETCH v_txn_cur INTO v_txn_rec;
            v_more := v_txn_cur%FOUND;
            IF v_more THEN
                -- Get the txn def
                EMD_BCN_GET_TXN(tgt_id, RAWTOHEX(v_txn_rec.txn_guid), TRUE, 
                        v_tmp_txn, result, err_desc);
                IF result <> p_bcn_success THEN
                    RAISE p_internal_error;
                END IF;
                
                IF v_txn_rec.state = 'M' THEN
                    -- Read the steps, stepgroups, thresholds only if there are
                    -- beacons to be added
                    v_tmp_steps := NULL;
                    v_tmp_stepgroups := NULL;
                    v_tmp_txn_thresh := NULL;
                    v_tmp_step_thresh := NULL;
                    v_tmp_stpgrp_thresh := NULL;
                    IF v_add_ctr > 0 THEN
                        EMD_BCN_GET_STEPS(tgt_id, RAWTOHEX(v_txn_rec.txn_guid),
                                TRUE, v_tmp_steps, result, err_desc);
                        EMD_BCN_GET_STEPGROUPS(tgt_id, RAWTOHEX(v_txn_rec.txn_guid),
                                TRUE, v_tmp_stepgroups, result, err_desc);
                        EMD_BCN_GET_THRESHOLDS(tgt_id, RAWTOHEX(v_txn_rec.txn_guid),
                                v_tmp_txn_thresh, v_tmp_step_thresh, 
                                v_tmp_stpgrp_thresh, result, err_desc);
                    END IF;
                    
                    IF v_txn_ctr = 0 THEN
                        transactions := MGMT_BCN_TRANSACTION_ARRAY();
                    END IF;                    
                    transactions.EXTEND;
                    v_txn_ctr := v_txn_ctr +1;
                    transactions(v_txn_ctr) := MGMT_BCN_TRANSACTION(
                            v_tmp_txn, v_tmp_steps, v_tmp_stepgroups, 
                            v_tmp_txn_thresh, v_tmp_step_thresh, 
                            v_tmp_stpgrp_thresh);
                            
                END IF;

                -- Process all beacons to be added 
                FOR v_tmp IN 1.. add_bcn_list.COUNT LOOP
                    -- Insert a new record in the bcn/txn table
                    INSERT INTO MGMT_BCN_TARGET_TXN 
                            (target_guid, beacon_target_guid, txn_guid, 
                            state)
                    VALUES
                            (v_tgt, HEXTORAW(add_bcn_list(v_tmp).bcn_guid),
                            v_txn_rec.txn_guid, 'NM');

                    -- cReate a composite key record for the txn/bcn
                    IF HEXTORAW(add_bcn_list(v_tmp).bcn_guid) = v_tgt THEN
                        v_name := p_local_target_name;
                    ELSE
                        v_name := add_bcn_list(v_tmp).bcn_target_name;
                    END IF;
                    EMD_BCN_CREATE_COMPOSITE_KEY(tgt_id, v_txn_rec.name, 
                            v_name, NULL);
                END LOOP;
            END IF;
        END LOOP;
        CLOSE v_txn_cur;
    END IF;

    -- DBMS_OUTPUT.PUT_LINE('SET_BCNS: v_txn_ctr: ' || v_txn_ctr);

     -- Unlock the target if there's nothing to do.
    IF ((add_bcn_list IS NULL OR add_bcn_list.COUNT = 0) 
            AND (del_bcn_list IS NULL OR del_bcn_list.COUNT = 0)) OR
            (transactions IS NULL OR transactions.COUNT = 0) THEN
        v_tmp := EMD_BCN_UNLOCK_TARGET(v_tgt);    
        v_tgt_locked := FALSE;
    END IF;

    -- Clean up
    IF v_del_bcns IS NOT NULL THEN
        v_del_bcns.DELETE;
        v_del_bcns := NULL;
    END IF;

    result := p_bcn_success;  
    err_desc := NULL;

EXCEPTION

  WHEN p_internal_error THEN
        LOG_SYS_ERR(result, 'EMD_BCN_SET_BCNS: failed.');
        ROLLBACK;
        IF v_tgt_locked THEN
            v_tmp := EMD_BCN_UNLOCK_TARGET(v_tgt);
        END IF;
        IF v_new_bcn_cur%ISOPEN THEN
            CLOSE v_new_bcn_cur;
        END IF;
        IF v_old_bcn_cur%ISOPEN THEN
            CLOSE v_old_bcn_cur;
        END IF;
        IF v_del_bcn_cur%ISOPEN THEN
            CLOSE v_del_bcn_cur;
        END IF;
        IF v_txn_cur%ISOPEN THEN
            CLOSE v_txn_cur;
        END IF;
        IF transactions IS NOT NULL THEN
            transactions.DELETE;
            transactions := NULL;
        END IF;
        IF add_bcn_list IS NOT NULL THEN
            add_bcn_list.DELETE;
            add_bcn_list := NULL;
        END IF;
        IF del_bcn_list IS NOT NULL THEN
            del_bcn_list.DELETE;
            del_bcn_list := NULL;
        END IF;
        IF v_del_bcns IS NOT NULL THEN
            v_del_bcns.DELETE;
            v_del_bcns := NULL;
        END IF;
        IF v_tmp_steps IS NOT NULL THEN
            v_tmp_steps.DELETE;
            v_tmp_steps := NULL;
        END IF;
        IF v_tmp_stepgroups IS NOT NULL THEN
            v_tmp_stepgroups.DELETE;
            v_tmp_stepgroups := NULL;
        END IF;
        IF v_tmp_txn_thresh IS NOT NULL THEN
            v_tmp_txn_thresh.DELETE;
            v_tmp_txn_thresh := NULL;
        END IF;
        IF v_tmp_step_thresh IS NOT NULL THEN
            v_tmp_step_thresh.DELETE;
            v_tmp_step_thresh := NULL;
        END IF;
        IF v_tmp_stpgrp_thresh IS NOT NULL THEN
            v_tmp_stpgrp_thresh.DELETE;
            v_tmp_stpgrp_thresh := NULL;
        END IF;

  WHEN OTHERS THEN
        result := p_bcn_err_oraerr;
        err_desc := SUBSTR(SQLERRM, 1, p_err_maxlen);
        LOG_SYS_ERR(result, 'EMD_BCN_SET_BCNS: db error: ' || err_desc);
        ROLLBACK;
        IF v_tgt_locked THEN
            v_tmp := EMD_BCN_UNLOCK_TARGET(v_tgt);
        END IF;
        IF v_new_bcn_cur%ISOPEN THEN
            CLOSE v_new_bcn_cur;
        END IF;
        IF v_old_bcn_cur%ISOPEN THEN
            CLOSE v_old_bcn_cur;
        END IF;
        IF v_del_bcn_cur%ISOPEN THEN
            CLOSE v_del_bcn_cur;
        END IF;
        IF v_txn_cur%ISOPEN THEN
            CLOSE v_txn_cur;
        END IF;
        IF transactions IS NOT NULL THEN
            transactions.DELETE;
            transactions := NULL;
        END IF;
        IF add_bcn_list IS NOT NULL THEN
            add_bcn_list.DELETE;
            add_bcn_list := NULL;
        END IF;
        IF del_bcn_list IS NOT NULL THEN
            del_bcn_list.DELETE;
            del_bcn_list := NULL;
        END IF;
        IF v_del_bcns IS NOT NULL THEN
            v_del_bcns.DELETE;
            v_del_bcns := NULL;
        END IF;
        IF v_tmp_steps IS NOT NULL THEN
            v_tmp_steps.DELETE;
            v_tmp_steps := NULL;
        END IF;
        IF v_tmp_stepgroups IS NOT NULL THEN
            v_tmp_stepgroups.DELETE;
            v_tmp_stepgroups := NULL;
        END IF;
        IF v_tmp_txn_thresh IS NOT NULL THEN
            v_tmp_txn_thresh.DELETE;
            v_tmp_txn_thresh := NULL;
        END IF;
        IF v_tmp_step_thresh IS NOT NULL THEN
            v_tmp_step_thresh.DELETE;
            v_tmp_step_thresh := NULL;
        END IF;
        IF v_tmp_stpgrp_thresh IS NOT NULL THEN
            v_tmp_stpgrp_thresh.DELETE;
            v_tmp_stpgrp_thresh := NULL;
        END IF;

END EMD_BCN_SET_BCNS;
*/
--------------------------------------------------------------------------
-- PROCEDURE: EMD_BCN_GET_ACTIVE_TXN_LIST
-- PURPOSE: Retrieves the list currently active transactions used to add 
--  or remove collections, when a beacon is added or removed from the target.
-- PARAMS 
--   tgt_id target_guid 
--   add_remove_flag txn_list for add or remove.  add - 1 --   remove -0
FUNCTION EMD_BCN_GET_TXN_LIST_FOR_PUSH(tgt_id IN RAW, 
                                       add_remove_flag IN INTEGER)
                                  RETURN MGMT_GENSVC_UBJOB_TEST_ARRAY
IS 
   
    CURSOR active_txn_cursor(tgt_id RAW ) IS
        SELECT txn_guid, name, txn_type, is_representative, state
        FROM MGMT_BCN_TXN_DEFN
        WHERE target_guid = tgt_id
          AND state = 'M';

    v_txn_list     MGMT_GENSVC_UBJOB_TEST_ARRAY := NULL;

BEGIN

    IF ( tgt_id IS NULL ) THEN 
        RETURN v_txn_list;
    END IF;
    
    v_txn_list := MGMT_GENSVC_UBJOB_TEST_ARRAY();

    FOR sub_rec in active_txn_cursor(tgt_id) 
    LOOP 
        v_txn_list.EXTEND;
        v_txn_list(active_txn_cursor%ROWCOUNT) := 
                      MGMT_GENSVC_UBJOB_TEST( sub_rec.name, sub_rec.txn_type, 
                           sub_rec.txn_guid, 0, add_remove_flag);
    END LOOP;
    return v_txn_list;
END;




--------------------------------------------------------------------------
-- PROCEDURE: EMD_BCN_ASSOCIATE_BEACONS
-- PURPOSE: Associate Beacons. This procedure will associate a list of beacons with
-- any given target. This beacons list contains the availability and 
-- local beacons. 
-- target_name: Name of Target being monitored by Beacon
-- target_type: Target Type
-- mgmt_bcn_assoc_array: List of Beacons monitoring the target and their roles. 
-- is_template: true if the target is a template, false if it is a proper target
-- Exceptions:
--  MGMT_GLOBAL.TARGET_DOES_NOT_EXIST_ERR
--  MGMT_GLOBAL.INVALID_PARAMS_ERR
--  MGMT_GLOBAL.INSUFFICIENT_PRIVILEGES_ERR

PROCEDURE EMD_BCN_ASSOCIATE_BEACONS(
        tgt_name                IN VARCHAR2,
        tgt_type                IN VARCHAR2,
        mgmt_bcn_assoc_array    IN MGMT_BCN_ASSOC_ARRAY,
        is_template             IN BOOLEAN)
IS
    CURSOR v_txn_cur (tgt RAW) IS
        SELECT txn_guid, txn_type, name, state 
        FROM MGMT_BCN_TXN_DEFN
        WHERE target_guid = tgt;

    CURSOR v_keys_cur (tgt RAW) IS
        SELECT key1, key2
          FROM
             (
             SELECT name as key1, null as key2
               FROM mgmt_bcn_txn_defn txn
              WHERE target_guid = tgt
             UNION
             SELECT txn.name as key1, st.name as key2
               FROM mgmt_bcn_txn_defn txn, mgmt_bcn_step_defn st
              WHERE txn.target_guid = tgt
                AND st.target_guid = txn.target_guid
                AND st.txn_guid = txn.txn_guid
             UNION
             SELECT txn.name as key1, grp.name as key2
               FROM mgmt_bcn_txn_defn txn, mgmt_bcn_stepgroup_defn grp
              WHERE txn.target_guid = tgt
                AND grp.target_guid = txn.target_guid
                AND grp.txn_guid = txn.txn_guid
              )key_elems group by key1, key2;


    v_tgt_id                 RAW(16);
    v_bcn_id                 RAW(16);
    v_job_id                 RAW(16);
    v_tmp                    NUMBER(16);
    v_bcn_assoc              MGMT_BCN_ASSOC;
    v_result                 INTEGER;
    v_err_desc               VARCHAR2(2048);
    v_txn_list               MGMT_GENSVC_UBJOB_TEST_ARRAY := NULL;
    v_key_bcn_list           MGMT_GENSVC_TGT_NAME_ARRAY := NULL;
    v_key_bcn_idx            INTEGER;
    v_txn_rec                v_txn_cur%ROWTYPE;
    v_all_keys               SMP_EMD_NVPAIR_ARRAY := SMP_EMD_NVPAIR_ARRAY();
    v_bcns                   SMP_EMD_NVPAIR_ARRAY := NULL;
    v_txn_idx                INTEGER;
    v_current_user           VARCHAR2(256) := MGMT_USER.get_current_em_user();
    v_curr_avail             MGMT_BCN_TARGET.participates_avail%TYPE;
    v_curr_local             MGMT_BCN_TARGET.is_local%TYPE;
    v_new_bcn                BOOLEAN := FALSE;
    v_all_test_types         SMP_EMD_STRING_ARRAY := NULL;
    v_test_metadata          MGMT_TEST_METADATA_OBJ;
    v_num_invalid_beacons    INTEGER;
BEGIN
    IF tgt_name IS NULL OR tgt_type IS NULL THEN
        raise_application_error(MGMT_GLOBAL.INVALID_PARAMS_ERR, 'Target name or type is null:'|| tgt_name ||', '||tgt_type);
    END IF;

    --Return success only after performing all checks in case of empty 
    -- beacons list
    IF mgmt_bcn_assoc_array IS NULL OR mgmt_bcn_assoc_array.COUNT <= 0 THEN 
        RETURN;
    END IF;
    IF tgt_type = p_beacon_type THEN
        raise_application_error(MGMT_GLOBAL.INVALID_PARAMS_ERR, 'Can not associate beacons with beacon targets');
    END IF;

    IF ( is_template ) THEN
        v_tgt_id := EMD_BCN_GET_TEMPLATE_ID(tgt_name, tgt_type);
    ELSE
        -- get the target_guid for the target
        v_tgt_id := mgmt_service.get_service_guid(tgt_name, tgt_type); 
    END IF;

    --Check for operator privileges on the new beacons and also on the target
    IF NOT is_template THEN
        v_bcns := SMP_EMD_NVPAIR_ARRAY();
        FOR i IN mgmt_bcn_assoc_array.FIRST .. mgmt_bcn_assoc_array.LAST
        LOOP
            v_bcns.extend ;
            v_bcns(i) := SMP_EMD_NVPAIR(mgmt_bcn_assoc_array(i).BCN_TARGET_NAME, mgmt_bcn_assoc_array(i).BCN_TARGET_TYPE);
        END LOOP;
   
        v_result := HAS_TGT_FUNCTION_PRIV(v_tgt_id, p_set_beacons, v_err_desc, v_bcns);
        -- This will not be used any where else
        v_bcns.DELETE;
        v_bcns := NULL;
    ELSE
        v_result := HAS_TMPL_FUNCTION_PRIV (v_tgt_id, p_set_beacons, v_err_desc);
    END IF;

    IF v_result <> p_bcn_success THEN
        raise_application_error(MGMT_GLOBAL.INSUFFICIENT_PRIVILEGES_ERR,
        v_err_desc);
    END IF;

    -- collect all test types of existing tests
    SELECT distinct txn_type
      BULK COLLECT INTO v_all_test_types
      FROM mgmt_bcn_txn_defn
     WHERE target_guid = v_tgt_id;

    -- Get minimum supported version of the beacon for all test types
    IF (( v_all_test_types IS NOT NULL ) AND (v_all_test_types.COUNT > 0 ) )THEN
        FOR test_idx IN v_all_test_types.FIRST .. v_all_test_types.LAST
        LOOP
            MGMT_TEST_METADATA_READ.READ_TEST_METADATA(
               v_all_test_types(test_idx), v_test_metadata, v_result, v_err_desc);
            IF ( v_test_metadata IS NULL ) OR ( v_result < 0 ) THEN 
                raise_application_error(MGMT_GLOBAL.TEST_METADATA_READ_ERR, MGMT_GLOBAL.TEST_METADATA_READ_ERROR_M);
            END IF;

            -- Check if all beacons are supporting all test types
            -- Get minimum version of all beacons to be associated 
            SELECT count(*)
              INTO v_num_invalid_beacons
              FROM mgmt_targets 
             WHERE target_name in ( SELECT bcn_target_name
                              FROM TABLE(CAST(mgmt_bcn_assoc_array 
                                               AS MGMT_BCN_ASSOC_ARRAY)))
               AND target_type = p_beacon_type
               AND (em_target.compare_type_meta_vers(type_meta_ver, 
                                       v_test_metadata.min_beacon_ver) < 0);

            IF ( v_num_invalid_beacons <> 0 ) THEN
                raise_application_error(MGMT_GLOBAL.ASSOC_BCN_TEST_NOT_SUPP_ERR, MGMT_GLOBAL.ASSOC_BCN_TEST_NOT_SUPP_ERR_M);
            END IF;
        END LOOP;
    END IF;

    v_txn_list := EMD_BCN_GET_TXN_LIST_FOR_PUSH(v_tgt_id, p_add_collection);
    v_key_bcn_idx := 1;

    v_all_keys := SMP_EMD_NVPAIR_ARRAY();
    -- Create a temporary list of all Transaction and Step keys 
    FOR sub_rec in v_keys_cur(v_tgt_id)
    LOOP 
        v_all_keys.extend;
        v_all_keys(v_keys_cur%ROWCOUNT) := SMP_EMD_NVPAIR(sub_rec.key1, sub_rec.key2);
    END LOOP;

    -- Beacons to be added
    FOR v_tmp IN 1..mgmt_bcn_assoc_array.COUNT LOOP
        v_new_bcn := FALSE;
        v_bcn_assoc := mgmt_bcn_assoc_array(v_tmp);
        IF ( v_bcn_assoc IS NOT NULL) AND ( v_bcn_assoc.bcn_target_type = p_beacon_type) THEN

            v_bcn_id := mgmt_target.get_target_guid(v_bcn_assoc.bcn_target_name, p_beacon_type);
            BEGIN
                SELECT participates_avail, is_local 
                  INTO v_curr_avail, v_curr_local
                  FROM MGMT_BCN_TARGET 
                 WHERE target_guid = v_tgt_id
                   AND beacon_target_guid = v_bcn_id;
            EXCEPTION
                WHEN NO_DATA_FOUND THEN 
                    v_new_bcn := TRUE;
            END;
    
            --IF the current beacon in the loop is the local beacon 
            -- then unset previous local beacons. 
            -- This is to ensure that there is only one local beacon
            IF( v_bcn_assoc.bcn_is_local = 'Y' ) THEN 
                UPDATE MGMT_BCN_TARGET
                   SET is_local = 'N'
                 WHERE target_guid = v_tgt_id;
            END IF;

            IF (v_new_bcn = TRUE) THEN
                -- Add entry into MGMT_BCN_TARGET
                INSERT INTO MGMT_BCN_TARGET
                    (target_guid, beacon_target_guid, participates_avail, is_local)
                VALUES
                    (v_tgt_id, v_bcn_id, v_bcn_assoc.bcn_is_avail, v_bcn_assoc.bcn_is_local);

                -- composite keys must be created before association
                -- create composite keys for all transactions
                IF ( v_all_keys IS NOT NULL ) AND ( v_all_keys.COUNT > 0 ) THEN 
                    FOR v_txn_idx IN 1..v_all_keys.COUNT LOOP
                        EMD_BCN_CREATE_COMPOSITE_KEY(v_tgt_id, v_all_keys(v_txn_idx).name, 
                                v_bcn_assoc.bcn_target_name, v_all_keys(v_txn_idx).value);
                    END LOOP;
                END IF;

                IF NOT is_template THEN
                    MGMT_ASSOC.create_target_assoc(MGMT_ASSOC.ASSOC_DEF_REMOTELY_MNTRD_BY, 
                        tgt_name, tgt_type, v_bcn_assoc.bcn_target_name, 
                        v_bcn_assoc.bcn_target_type);
                END IF;
            ELSE
                -- just update the availability state and local 
                UPDATE MGMT_BCN_TARGET
                   SET participates_avail = v_bcn_assoc.bcn_is_avail,
                       is_local = v_bcn_assoc.bcn_is_local
                 WHERE target_guid = v_tgt_id
                   AND beacon_target_guid = v_bcn_id;
            END IF;

            IF NOT is_template THEN
                -- ADD to availability beacons list if it is a Key beacon
                IF ( v_bcn_assoc.bcn_is_avail = 'Y' ) THEN 
                    IF ( v_key_bcn_list IS NULL ) THEN 
                        v_key_bcn_list := MGMT_GENSVC_TGT_NAME_ARRAY();
                    END IF;
                    v_key_bcn_list.extend;
                    v_key_bcn_list(v_key_bcn_idx) := v_bcn_assoc.bcn_target_name;
                    v_key_bcn_idx := v_key_bcn_idx+1;
                END IF;

                IF ( ( v_txn_list IS NOT NULL ) AND ( v_txn_list.COUNT > 0 ) )THEN
                    --submit job for all associated beacons
                    MGMT_GENSVC_UPDBCN.SUBMIT_UPDBCN_JOB( tgt_name, tgt_type,
                         v_bcn_assoc.bcn_target_name, v_txn_list, null, p_add_bcn_action_desc, v_job_id );
                END IF;
            END IF;
        END IF;
    END LOOP;

    IF NOT is_template THEN
        IF ( v_key_bcn_list IS NOT NULL ) AND ( v_key_bcn_list.COUNT > 0 ) THEN 
            MGMT_GENSVC_AVAIL.SET_BEACONS(tgt_name, tgt_type, v_key_bcn_list);
        END IF;
    END IF;
END EMD_BCN_ASSOCIATE_BEACONS;

--------------------------------------------------------------------------
--------------------------------------------------------------------------
-- PROCEDURE: EMD_BCN_ASSOC_TMPL_APPLY
-- PURPOSE: Similar to the main EMD_BCN_ASSOCIATE_BEACONS, with two additional 
-- parameters:
--
--  - result: an integer indicating the success of the operation. Can take values:
--    a) p_bcn_success - if association is successful.
--    b) p_err_use_bcn_priv_req, if user lacks privileges on at least one beacon.
--
--  - err_desc: an error string in case the operation failed. If result = p_err_use_bcn_priv_req, 
-- the err_desc returns a list of such beacons for which the user lacks privilege. 
-- Otherwise it is empty/null.
--
-- This procedure does not use the is_template parameter since it is only applicable to
-- targets (in particular, it requires OPERATOR beacon priv for association). It always
-- passes FALSE to the main ASSOCIATE_BEACONS procedure
--
-- Exceptions:
--  MGMT_GLOBAL.TARGET_DOES_NOT_EXIST_ERR
--  MGMT_GLOBAL.INVALID_PARAMS_ERR
--  MGMT_GLOBAL.INSUFFICIENT_PRIVILEGES_ERR

PROCEDURE EMD_BCN_ASSOC_TMPL_APPLY(
        tgt_name                IN VARCHAR2,
        tgt_type                IN VARCHAR2,
        mgmt_bcn_assoc_array    IN MGMT_BCN_ASSOC_ARRAY,
        result                  OUT INTEGER,
        err_desc                OUT VARCHAR2)
        
IS
    v_bcns                   SMP_EMD_NVPAIR_ARRAY := NULL;
    
BEGIN
 
    --Return success only after performing all checks in case of empty 
    -- beacons list
    IF mgmt_bcn_assoc_array IS NULL OR mgmt_bcn_assoc_array.COUNT <= 0 THEN 
        result := p_bcn_success;
        RETURN;
    END IF;

    -- prepare the beacon nvpair array
    v_bcns := SMP_EMD_NVPAIR_ARRAY();
    FOR i IN mgmt_bcn_assoc_array.FIRST .. mgmt_bcn_assoc_array.LAST
    LOOP 
      v_bcns.extend ;
      v_bcns(i) := SMP_EMD_NVPAIR(mgmt_bcn_assoc_array(i).BCN_TARGET_NAME, mgmt_bcn_assoc_array(i).BCN_TARGET_TYPE);
    END LOOP;
    
    -- pre-check template privileges
    result := HAS_ALL_BCN_PRIVS(v_bcns, p_set_beacons, err_desc);
    
    -- This will not be used any where else
    v_bcns.DELETE;
    v_bcns := NULL;
    
    IF (result <> p_bcn_success) THEN
      -- bail, user lacks privileges
      RETURN;
    ELSE
      -- privs ok, associate
      EMD_BCN_ASSOCIATE_BEACONS(tgt_name, tgt_type, mgmt_bcn_assoc_array, FALSE);
    END IF;

EXCEPTION 
    WHEN OTHERS THEN
       v_bcns.DELETE;
       v_bcns := NULL;
       RAISE;

END EMD_BCN_ASSOC_TMPL_APPLY;     
    

--------------------------------------------------------------------------
--------------------------------------------------------------------------
-- PROCEDURE: EMD_BCN_REMOVE_BEACON_ASSOCS
-- PURPOSE: Removes beacon associations and submits a job to remove collections
-- from beacons. 
-- target_name: Name of Target being monitored by Beacon
-- target_type: Target Type
-- mgmt_bcn_assoc_array: List of Beacons monitoring the target and their roles. 
-- Exceptions:
--  MGMT_GLOBAL.TARGET_DOES_NOT_EXIST_ERR
--  MGMT_GLOBAL.INVALID_PARAMS_ERR
--  MGMT_GLOBAL.INSUFFICIENT_PRIVILEGES_ERR
--  MGMT_GLOBAL.CANNOT_DELETE_KEY_BCN_ERR
--  MGMT_GLOBAL.BCN_ASSOC_DOES_NOT_EXIST_ERR

PROCEDURE EMD_BCN_REMOVE_BEACON_ASSOCS(
        tgt_name                IN VARCHAR2,
        tgt_type                IN VARCHAR2,
        mgmt_bcn_assoc_array    IN MGMT_BCN_ASSOC_ARRAY,
        is_template             IN BOOLEAN)
IS
    CURSOR key_bcn_cur(tgt_id RAW ) IS
        SELECT tgt.target_name as tgt_name
        FROM MGMT_BCN_TARGET bcn, MGMT_TARGETS tgt
        WHERE bcn.target_guid = tgt_id
          AND bcn.beacon_target_guid = tgt.target_guid
          AND tgt.target_type =p_beacon_type
          AND bcn.beacon_target_guid <> tgt_id
          AND bcn.participates_avail = 'Y';

    v_bcn_id                 RAW(16);
    v_job_id                 RAW(16);
    v_tmp                    NUMBER(16);
    v_bcn_assoc              MGMT_BCN_ASSOC;
    v_result                 INTEGER;
    v_err_desc               VARCHAR2(2048);
    v_txn_list               MGMT_GENSVC_UBJOB_TEST_ARRAY := NULL;
    v_bcns                   SMP_EMD_NVPAIR_ARRAY := NULL;
    v_key_bcn_list           MGMT_GENSVC_TGT_NAME_ARRAY := NULL;
    v_key_bcn_idx            INTEGER;
    v_tgt_id                 RAW(16);
    v_dep_keys_all_bcns      SMP_EMD_NVPAIR_ARRAY := NULL;
    v_temp_keys              SMP_EMD_NVPAIR_ARRAY := NULL;
    v_idx                    INTEGER;
    v_is_template            BOOLEAN := FALSE;
    v_is_avail_bcn           CHAR(1) := 'N';

    v_metric_guids           SMP_EMD_STRING_ARRAY;
    v_rm_key_values          SMP_EMD_STRING_ARRAY := NULL;

BEGIN
    IF tgt_name IS NULL OR tgt_type IS NULL THEN
        raise_application_error(MGMT_GLOBAL.INVALID_PARAMS_ERR, 'Target name or type is null:'|| tgt_name ||', '||tgt_type);
    END IF;

    --Return success only after performing all checks in case of empty 
    -- beacons list
    IF mgmt_bcn_assoc_array IS NULL OR mgmt_bcn_assoc_array.COUNT <= 0 THEN 
        RETURN;
    END IF;
   
    IF ( is_template = TRUE ) THEN
        v_tgt_id := EMD_BCN_GET_TEMPLATE_ID(tgt_name, tgt_type);
    ELSE
        v_tgt_id := mgmt_service.get_service_guid(tgt_name, tgt_type); 
    END IF;

    IF ( is_template ) THEN 
        v_result := HAS_TMPL_FUNCTION_PRIV (v_tgt_id, p_set_beacons, v_err_desc);
    ELSE
        v_bcns := SMP_EMD_NVPAIR_ARRAY();
        FOR i IN mgmt_bcn_assoc_array.FIRST .. mgmt_bcn_assoc_array.LAST
        LOOP 
            v_bcns.extend ;
            v_bcns(i) := SMP_EMD_NVPAIR(mgmt_bcn_assoc_array(i).BCN_TARGET_NAME, mgmt_bcn_assoc_array(i).BCN_TARGET_TYPE);
        END LOOP;
        --Check for privileges on target and associated beacons to be removed
        v_result := HAS_TGT_FUNCTION_PRIV(v_tgt_id, p_set_beacons, v_err_desc, v_bcns);
        -- This will not be used any where else
        v_bcns.DELETE;
        v_bcns := NULL;
    END IF;

    IF v_result <> p_bcn_success THEN
        raise_application_error(MGMT_GLOBAL.INSUFFICIENT_PRIVILEGES_ERR,
        v_err_desc);
    END IF;

    v_txn_list := EMD_BCN_GET_TXN_LIST_FOR_PUSH(v_tgt_id, p_remove_collection);

    -- Beacons to be remove associations
    FOR v_tmp IN 1..mgmt_bcn_assoc_array.COUNT LOOP
        v_bcn_assoc := mgmt_bcn_assoc_array(v_tmp);
        IF v_bcn_assoc IS NOT NULL THEN
            v_bcn_id := mgmt_target.get_target_guid(v_bcn_assoc.bcn_target_name, 
                                         v_bcn_assoc.bcn_target_type);
            -- check if this beacon participates in availability 
            -- if yes, raise application error 
            BEGIN
                SELECT participates_avail 
                  INTO v_is_avail_bcn
                  FROM MGMT_BCN_TARGET 
                 WHERE target_guid = v_tgt_id
                   AND beacon_target_guid = v_bcn_id;
            EXCEPTION
                WHEN NO_DATA_FOUND THEN 
                    raise_application_error(MGMT_GLOBAL.BCN_ASSOC_DOES_NOT_EXIST_ERR,
                    'Beacon '|| v_bcn_assoc.bcn_target_name ||' association with the service '|| tgt_name ||', '||tgt_type ||' does not exist');
            END;

            IF ( NOT is_template ) THEN 
              IF ( v_is_avail_bcn = 'Y' ) THEN 
                raise_application_error(MGMT_GLOBAL.CANNOT_DELETE_KEY_BCN_ERR,
                'Key Beacon '|| v_bcn_assoc.bcn_target_name ||'  association can not be removed from the service '|| tgt_name ||', '||tgt_type );
              END IF;
            END IF;

            -- Delete beacon specific txn level  properties
            DELETE 
              FROM MGMT_BCN_BCNTXN_PROPS
             WHERE target_guid = v_tgt_id
               AND bcn_guid = v_bcn_id;

            -- Delete beacon specific step level  properties
            DELETE 
              FROM MGMT_BCN_BCNSTEP_PROPS
             WHERE target_guid = v_tgt_id
               AND bcn_guid = v_bcn_id;

            -- call the EMD_ADMIN procedure to cleanup all key values belonging
            -- to this beacon
            EMD_BCN_ADMIN.BEACON_KEY_VALUE_CLEANUP(v_tgt_id, v_bcn_assoc.bcn_target_name);

            -- Delete entry into MGMT_BCN_TARGET
            DELETE 
            FROM MGMT_BCN_TARGET
            WHERE target_guid = v_tgt_id
              AND beacon_target_guid = v_bcn_id;

            IF ( NOT is_template ) THEN 
                --Check if there are any tests defined on this target, if yes
                -- then create the action list for submitting jobs per beacons. 
                IF ( ( v_txn_list IS NOT NULL ) AND ( v_txn_list.COUNT > 0 ) )THEN
                    --Collect all the key values
                    SELECT composite_key 
                      BULK COLLECT INTO v_rm_key_values 
                      FROM mgmt_metrics_composite_keys
                     WHERE target_guid = v_tgt_id
                       AND key_part2_value = v_bcn_assoc.bcn_target_name;

                    --submit job for all associated beacons
                    MGMT_GENSVC_UPDBCN.SUBMIT_UPDBCN_JOB( tgt_name, tgt_type,
                         v_bcn_assoc.bcn_target_name, v_txn_list, v_rm_key_values, 
                         p_remove_bcns_action_desc, v_job_id );
                END IF;

                -- Collect all the keys that were promoted to Service performance metric 
                SELECT SMP_EMD_NVPAIR(ckey, metric) BULK COLLECT INTO v_temp_keys
                  FROM
                  (SELECT DISTINCT k.composite_key as ckey, d.metric_guid as metric
                    FROM mgmt_metrics_composite_keys k, mgmt_metric_dependency_details d
                   WHERE k.target_guid=v_tgt_id
                     AND d.dep_target_guid = k.target_guid
                     AND k.key_part2_value = v_bcn_assoc.bcn_target_name
                     AND d.dep_key_value = k.composite_key);

                -- Add the composite keys from this beacon to the list 
                IF ( v_temp_keys IS NOT NULL ) AND ( v_temp_keys.COUNT > 0 ) THEN  
                    IF ( v_dep_keys_all_bcns IS NULL ) THEN
                        v_dep_keys_all_bcns := SMP_EMD_NVPAIR_ARRAY();
                    END IF;
                    v_idx := v_dep_keys_all_bcns.count + 1;
 
                    FOR i IN v_temp_keys.FIRST .. v_temp_keys.LAST LOOP
                        v_dep_keys_all_bcns.extend;
                        v_dep_keys_all_bcns(v_idx) := SMP_EMD_NVPAIR(v_temp_keys(i).name, v_temp_keys(i).value);
                        v_idx := v_idx +1;
                    END  LOOP;
                    v_temp_keys.DELETE;
                    v_temp_keys := NULL;
                END IF;  

                MGMT_ASSOC.delete_target_assoc(MGMT_ASSOC.ASSOC_DEF_REMOTELY_MNTRD_BY, 
                  tgt_name, tgt_type, v_bcn_assoc.bcn_target_name, 
                  v_bcn_assoc.bcn_target_type);

            END IF;
        END IF;
    END LOOP;

    

    IF ( NOT is_template ) THEN 
        -- delete all dependecies of promoted metrics 
        IF( v_dep_keys_all_bcns IS NOT NULL ) AND ( v_dep_keys_all_bcns.COUNT > 0 ) THEN 
          FOR i IN v_dep_keys_all_bcns.FIRST..v_dep_keys_all_bcns.LAST LOOP
            v_metric_guids := SMP_EMD_STRING_ARRAY();
            v_metric_guids.extend;
            v_metric_guids(1) := v_dep_keys_all_bcns(i).value;
            EM_METRIC.EXEC_CBK_METRIC_KEYVAL(v_tgt_id, v_metric_guids, v_dep_keys_all_bcns(i).name);
            v_metric_guids.delete;
          END LOOP;            
        END IF;

        FOR sub_rec in key_bcn_cur(v_tgt_id) 
        LOOP 
            IF ( v_key_bcn_list IS NULL ) THEN 
                v_key_bcn_list := MGMT_GENSVC_TGT_NAME_ARRAY();
            END IF;
            v_key_bcn_list.extend;
            v_key_bcn_list(key_bcn_cur%ROWCOUNT) := sub_rec.tgt_name;
        END LOOP;
        IF ( v_key_bcn_list IS NOT NULL ) AND ( v_key_bcn_list.COUNT > 0 ) THEN 
            MGMT_GENSVC_AVAIL.SET_BEACONS(tgt_name, tgt_type, v_key_bcn_list);
        END IF;
    END IF;
END EMD_BCN_REMOVE_BEACON_ASSOCS;
/*
---------------------------------------------------------------------------
--  EMD_BCN_SYNCHRONIZE
-- tgt_name: Name of Target being monitored by Beacon
-- tgt_type: Target Type
-- beacon_tgt_name: Beacon target name
-- beacon_tgt_type: beacon target type 

PROCEDURE EMD_BCN_SYNCHRONIZE(
        tgt_name                IN VARCHAR2,
        tgt_type                IN VARCHAR2,
        beacon_tgt_name            IN VARCHAR2,
        beacon_tgt_type            IN VARCHAR2) 
IS 
BEGIN

    IF tgt_name IS NULL OR tgt_type IS NULL THEN
        raise_application_error(MGMT_GLOBAL.INVALID_PARAMS_ERR, 'Target name or type is null:'|| tgt_name ||', '||tgt_type);
    END IF;

    IF beacon_tgt_name IS NULL OR beacon_tgt_type IS NULL THEN
        raise_application_error(MGMT_GLOBAL.INVALID_PARAMS_ERR, 'Target name or type is null:'|| beacon_tgt_name ||', '||beacon_tgt_type);
    END IF;

    --Return success only after performing all checks in case of empty 
    -- beacons list
    IF mgmt_bcn_assoc_array IS NULL OR mgmt_bcn_assoc_array.COUNT <= 0 THEN 
        RETURN;
    END IF;
   
    v_tgt_id := mgmt_service.get_service_guid(tgt_name, tgt_type); 

    --RAJ TBD: This needs to check only for OPERATOR privileges on target 
    -- and beacon targets. 
    v_result := HAS_TGT_FUNCTION_PRIV(v_tgt_id, p_set_beacons, v_err_desc);
    IF v_result <> p_bcn_success THEN
        raise_application_error(MGMT_GLOBAL.INSUFFICIENT_PRIVILEGES_ERR,
        'The current user does not have enough privileges to remove beacons. ');
    END IF;

    v_txn_list := EMD_BCN_GET_TXN_LIST_FOR_PUSH(v_tgt_id, p_remove_collection);

    -- Beacons to be remove associations
    FOR v_tmp IN 1..mgmt_bcn_assoc_array.COUNT LOOP
        v_bcn_assoc := mgmt_bcn_assoc_array(v_tmp);
        IF v_bcn_assoc IS NOT NULL THEN
            v_bcn_id := mgmt_target.get_target_guid(v_bcn_assoc.bcn_target_name, 
                                         v_bcn_assoc.bcn_target_type);
            -- Delete any open alerts and current metrics
            -- REVISIT: Need to do this for step and stepgroup severities
            CLOSE_BCN_SEVS(v_tgt_id, v_bcn_id, v_bcn_assoc.bcn_target_name);
            DEL_BCN_METRICS(v_tgt_id, v_bcn_id);

            -- Delete entry into MGMT_BCN_TARGET
            DELETE 
            FROM MGMT_BCN_TARGET
            WHERE target_guid = v_tgt_id
              AND beacon_target_guid = v_bcn_id;

            DELETE
            FROM MGMT_ADMIN_METRIC_THRESHOLDS
            WHERE target_guid = v_tgt_id
                AND key_value IN (
                    SELECT RAWTOHEX(composite_key)
                    FROM MGMT_METRICS_COMPOSITE_KEYS
                    WHERE target_guid = v_tgt_id
                        AND key_part2_value =  v_bcn_assoc.bcn_target_name);
            DELETE
            FROM MGMT_METRIC_THRESHOLDS
            WHERE target_guid = v_tgt_id
                AND key_value IN (
                    SELECT RAWTOHEX(composite_key)
                    FROM MGMT_METRICS_COMPOSITE_KEYS
                    WHERE target_guid = v_tgt_id
                        AND key_part2_value =  v_bcn_assoc.bcn_target_name);

            --Check if there are any tests defined on this target, if yes
            -- then create the action list for submitting jobs per beacons. 
            IF ( ( v_txn_list IS NOT NULL ) AND ( v_txn_list.COUNT > 0 ) )THEN
                --submit job for all associated beacons
                MGMT_GENSVC_UPDBCN.SUBMIT_UPDBCN_JOB( tgt_name, tgt_type,
                     v_bcn_assoc.bcn_target_name, v_txn_list, p_remove_bcns_action_desc, v_job_id );

            END IF;

            --TBD RAJ: Delete dependency beacon metrics, which are used to 
            -- compute service level performance metrics 
            -- emem_rep_metric.delete_dependency_target

            MGMT_ASSOC.delete_target_assoc(MGMT_ASSOC.ASSOC_DEF_REMOTELY_MNTRD_BY, 
              tgt_name, tgt_type, v_bcn_assoc.bcn_target_name, v_bcn_assoc.bcn_target_type);

        END IF;
    END LOOP;
END EMD_BCN_SYNCHRONIZE;
*/

---------------------------------------------------------------------------

--------------------------------------------------------------------------
-- Retrieve the configuration for a set of transactions given their ids
--------------------------------------------------------------------------
PROCEDURE EMD_BCN_GET_TXNS (
        tgt_id                  IN VARCHAR2,
        txn_ids                 IN MGMT_BCN_TXNID_ARRAY,
        include_thresh          IN INTEGER,
        transactions            OUT MGMT_BCN_TRANSACTION_ARRAY,
        result                  OUT INTEGER,
        err_desc                OUT VARCHAR2)
IS
    v_count                 PLS_INTEGER;
    v_counter               PLS_INTEGER;
    
    v_txn_with_props        MGMT_BCN_TXN_WITH_PROPS;
    v_steps_with_props      MGMT_BCN_STEP_WITH_PROPS_ARRAY;
    v_stepgroups            MGMT_BCN_STEPGROUP_ARRAY;
    v_txn_thresholds        MGMT_BCN_THRESHOLD_ARRAY;
    v_step_thresholds       MGMT_BCN_THRESHOLD_ARRAY;
    v_stepgrp_thresholds    MGMT_BCN_THRESHOLD_ARRAY;
    
    v_tmp_bcn_list          MGMT_BCN_ARRAY;
    
    v_result                INTEGER;
    v_err_desc              VARCHAR2(2048);
BEGIN
    IF tgt_id IS NULL OR txn_ids IS NULL OR txn_ids.COUNT <= 0 THEN
        result := p_bcn_err_badparams;
        RETURN;
    END IF; 
    
    v_counter := 0;
    transactions := NULL;
    
    result := p_bcn_success;
    
    FOR v_count IN 1..txn_ids.COUNT LOOP
        IF txn_ids(v_count) IS NOT NULL THEN
            v_txn_with_props := NULL;
            IF v_steps_with_props IS NOT NULL THEN
                v_steps_with_props.DELETE;
                v_steps_with_props := NULL;
            END IF;
            IF v_stepgroups IS NOT NULL THEN
                v_stepgroups.DELETE;
                v_stepgroups := NULL;
            END IF;
            IF (include_thresh = 1) THEN
                IF v_txn_thresholds IS NOT NULL THEN
                    v_txn_thresholds.DELETE;
                    v_txn_thresholds := NULL;
                END IF;
                IF v_step_thresholds IS NOT NULL THEN
                    v_step_thresholds.DELETE;
                    v_step_thresholds := NULL;
                END IF;
                IF v_stepgrp_thresholds IS NOT NULL THEN
                    v_stepgrp_thresholds.DELETE;
                    v_stepgrp_thresholds := NULL;
                END IF;
                EMD_BCN_TXN_VIEW(tgt_id, txn_ids(v_count),
                        v_txn_with_props, v_steps_with_props, v_stepgroups,
                        v_txn_thresholds, v_step_thresholds, v_stepgrp_thresholds,
                        v_tmp_bcn_list, v_result, v_err_desc);
            ELSE
                EMD_BCN_TXN_VIEW(tgt_id, txn_ids(v_count),
                        v_txn_with_props, v_steps_with_props, v_stepgroups,
                        v_tmp_bcn_list, v_result, v_err_desc);
            END IF;
            IF v_result = p_bcn_success THEN
                IF transactions IS NULL  THEN
                    transactions := MGMT_BCN_TRANSACTION_ARRAY();
                END IF;
                transactions.EXTEND;
                v_counter := v_counter + 1;
                transactions(v_counter) := MGMT_BCN_TRANSACTION(
                        v_txn_with_props, v_steps_with_props, v_stepgroups,
                        v_txn_thresholds, v_step_thresholds, v_stepgrp_thresholds);
            ELSE
                result := v_result;
                IF (v_err_desc IS NOT NULL) THEN
                    IF (err_desc IS NULL) THEN
                        err_desc := v_err_desc;
                    ELSE
                        err_desc := err_desc || '; ' || v_err_desc;
                    END IF;
                END IF;
            END IF;
        END IF;
    END LOOP;
    
EXCEPTION
  WHEN p_internal_error THEN
        result := p_bcn_err_oraerr;
        err_desc := SUBSTR(SQLERRM, 1, p_err_maxlen);
        LOG_SYS_ERR(result, 'EMD_BCN_GET_TXNS: failed.');
        IF v_steps_with_props IS NOT NULL THEN
            v_steps_with_props.DELETE;
            v_steps_with_props := NULL;
        END IF;
        IF v_stepgroups IS NOT NULL THEN
            v_stepgroups.DELETE;
            v_stepgroups := NULL;
        END IF;
        IF v_txn_thresholds IS NOT NULL THEN
            v_txn_thresholds.DELETE;
            v_txn_thresholds := NULL;
        END IF;
        IF v_step_thresholds IS NOT NULL THEN
            v_step_thresholds.DELETE;
            v_step_thresholds := NULL;
        END IF;
        IF v_stepgrp_thresholds IS NOT NULL THEN
            v_stepgrp_thresholds.DELETE;
            v_stepgrp_thresholds := NULL;
        END IF;
  WHEN OTHERS THEN
        result := p_bcn_err_oraerr;
        err_desc := SUBSTR(SQLERRM, 1, p_err_maxlen);
        LOG_SYS_ERR(result, 'EMD_BCN_GET_TXNS: db error: ' || err_desc);
        IF v_steps_with_props IS NOT NULL THEN
            v_steps_with_props.DELETE;
            v_steps_with_props := NULL;
        END IF;
        IF v_stepgroups IS NOT NULL THEN
            v_stepgroups.DELETE;
            v_stepgroups := NULL;
        END IF;
        IF v_txn_thresholds IS NOT NULL THEN
            v_txn_thresholds.DELETE;
            v_txn_thresholds := NULL;
        END IF;
        IF v_step_thresholds IS NOT NULL THEN
            v_step_thresholds.DELETE;
            v_step_thresholds := NULL;
        END IF;
        IF v_stepgrp_thresholds IS NOT NULL THEN
            v_stepgrp_thresholds.DELETE;
            v_stepgrp_thresholds := NULL;
        END IF;

END EMD_BCN_GET_TXNS;

PROCEDURE EMD_BCN_GET_TXNS_BY_TYPE (
        tgt_id                  IN VARCHAR2,
        txn_types               IN SMP_EMD_STRING_ARRAY,
        include_thresh          IN INTEGER,
        transactions            OUT MGMT_BCN_TRANSACTION_ARRAY,
        result                  OUT INTEGER,
        err_desc                OUT VARCHAR2)
IS
    CURSOR transactions_cursor(tgt_id RAW, tx_type VARCHAR2) IS
        SELECT txn_guid
        FROM MGMT_BCN_TXN_DEFN
        WHERE target_guid = tgt_id
            AND txn_type = tx_type;

    v_tgt               RAW(16);
    v_txn_ids           MGMT_BCN_TXNID_ARRAY;
    
    v_count             PLS_INTEGER;
    v_count_1           PLS_INTEGER;
    v_more              BOOLEAN;
    
    v_txn_rec           transactions_cursor%ROWTYPE;
BEGIN
    IF tgt_id IS NULL OR txn_types IS NULL OR txn_types.COUNT <= 0 THEN
        result := p_bcn_err_badparams;
        RETURN;
    END IF; 
    
    v_tgt := HEXTORAW(tgt_id);
    
    transactions := NULL;
    
    v_count := 0;
    
    FOR v_count_1 IN 1..txn_types.COUNT LOOP
        v_more := TRUE;
        OPEN transactions_cursor(v_tgt, txn_types(v_count_1));
        WHILE v_more LOOP
            FETCH transactions_cursor INTO v_txn_rec;
            v_more := transactions_cursor%FOUND;
            IF v_more THEN
                IF (v_count = 0) THEN
                    v_txn_ids := MGMT_BCN_TXNID_ARRAY();
                END IF;
                v_count := v_count + 1;
                v_txn_ids.EXTEND;
                v_txn_ids(v_count) := RAWTOHEX(v_txn_rec.txn_guid);
            END IF;
        END LOOP;
        CLOSE transactions_cursor;
    END LOOP;
        
    IF (v_txn_ids IS NOT NULL AND v_txn_ids.COUNT > 0) THEN
        EMD_BCN_GET_TXNS(tgt_id, v_txn_ids, include_thresh,
                transactions, result, err_desc);
    END IF;
    
EXCEPTION

  WHEN p_internal_error THEN
        --- DBMS_OUTPUT.PUT_LINE('EMD_BCN_GET_TXNS: failed.');
        LOG_SYS_ERR(result, 'EMD_BCN_GET_TXNS: failed.');

  WHEN OTHERS THEN
        result := p_bcn_err_oraerr;
        err_desc := SUBSTR(SQLERRM, 1, p_err_maxlen);
        -- DBMS_OUTPUT.PUT_LINE('EMD_BCN_GET_TXNS: db error');
        LOG_SYS_ERR(result, 'EMD_BCN_GET_TXNS: db error: ' || err_desc);

END EMD_BCN_GET_TXNS_BY_TYPE;

FUNCTION EMD_BCN_GET_COLL_NAME ( l_target_name IN VARCHAR2,
                                 l_target_type IN VARCHAR2,
                                 l_beacon_name IN VARCHAR2,
                                 l_test_name IN VARCHAR2,
                                 l_test_type IN VARCHAR2)
RETURN VARCHAR2

IS
  l_target_guid MGMT_TARGETS.TARGET_GUID%TYPE;
  l_bcn_guid MGMT_TARGETS.TARGET_GUID%TYPE;
  l_test_guid MGMT_BCN_TXN_DEFN.TXN_GUID%TYPE;  
  l_err_desc VARCHAR2(2048);
BEGIN
  l_target_guid := MGMT_TARGET.GET_TARGET_GUID(l_target_name, l_target_type);
  
  SELECT target_guid INTO l_bcn_guid
    FROM MGMT_TARGETS
   WHERE l_beacon_name = target_name
     AND target_type = MGMT_GLOBAL.G_BEACON_TARGET_TYPE;

  SELECT txn_guid INTO l_test_guid
    FROM MGMT_BCN_TXN_DEFN
   WHERE target_guid = l_target_guid
     AND name = l_test_name
     AND txn_type = l_test_type;
  
  RETURN (RAWTOHEX(l_test_guid) || RAWTOHEX(l_bcn_guid));

  EXCEPTION WHEN NO_DATA_FOUND THEN
    l_err_desc := SUBSTR(SQLERRM, 1, p_err_maxlen);
    LOG_SYS_ERR(p_bcn_err_oraerr, 'EMD_BCN_GET_COLL_NAME: ' || l_err_desc);
    RETURN NULL;

END EMD_BCN_GET_COLL_NAME;

--
-- PROCEDURE :SET_TESTS_KEYNESS 
--
-- PURPOSE
--   Updates the key (is_representative column) for a given set of tests.
--
-- IN PARAMETERS
--   p_target_name:  The target name
--   p_target_type:  The target type 
--   p_tests:        An array of test name/test type pairs.
--   p_key:          if 'Y',    all tests in p_tests should become key tests.
--                   otherwise, all tests in p_tests should become non key tests.
--   p_is_template   if 'Y',    treat the target as a template,
--                   otherwise, treat the target as a normal target.
-- OUT PARAMETERS
--   result:         The error code or p_bcn_success.
--   err_desc:       The error message.
--
-- NOTE
--   If a test in p_tests is not monitored, and p_key is true, the error code/message 
--   will be returned in result/err_desc, changes to any other tests will not be saved.
--
-- EXCEPTION
--   TARGET_DOES_NOT_EXIST: if any sub service does not exist
--
PROCEDURE SET_TESTS_KEYNESS (p_target_name IN VARCHAR2,
                             p_target_type IN VARCHAR2,
                             p_tests       IN SMP_EMD_NVPAIR_ARRAY,
                             p_key         IN VARCHAR2,
                             p_is_template IN VARCHAR2,
                             result        OUT INTEGER,        
                             err_desc      OUT VARCHAR2)
IS
  l_target_guid        MGMT_TARGETS.target_guid%TYPE;
  l_met_name           MGMT_METRICS.metric_name%TYPE;
  l_met_col            MGMT_METRICS.metric_column%TYPE;
  l_test_name          MGMT_BCN_TXN_DEFN.name%TYPE;
  l_test_type          MGMT_BCN_TXN_DEFN.txn_type%TYPE;
  l_old_is_key         MGMT_BCN_TXN_DEFN.is_representative%TYPE;
  l_new_is_key         MGMT_BCN_TXN_DEFN.is_representative%TYPE;
  l_test               MGMT_GENSVC_AV_TEST;
  l_current_user       VARCHAR2(256) := MGMT_USER.get_current_em_user();
  l_avail              NUMBER;
  l_state              NUMBER;
  l_unmon_key_tests    NUMBER;

  CURSOR tests(p_target_guid RAW, p_tests SMP_EMD_NVPAIR_ARRAY) IS
    SELECT d.name, d.txn_type, d.state, d.is_representative
      FROM MGMT_BCN_TXN_DEFN d,
           (SELECT name, value FROM TABLE(CAST(p_tests AS SMP_EMD_NVPAIR_ARRAY))) tests
     WHERE tests.name = d.name
       AND tests.value = d.txn_type
       AND d.target_guid = p_target_guid;

BEGIN
  IF p_is_template = 'Y' THEN
    l_target_guid := emd_bcn_get_template_id ( p_target_name, p_target_type);
    result := HAS_TMPL_FUNCTION_PRIV (RAWTOHEX(l_target_guid), p_modify_txn, err_desc);
  ELSE
    l_target_guid := mgmt_service.get_service_guid ( p_target_name, p_target_type);
    result := HAS_TGT_FUNCTION_PRIV (RAWTOHEX(l_target_guid), p_modify_txn, err_desc);
  END IF;

  IF result <> p_bcn_success THEN
    raise_application_error(MGMT_GLOBAL.INSUFFICIENT_PRIVILEGES_ERR,
      'EMD_BCN.SET_TESTS_KEYNESS: The current user (' 
      || l_current_user || 
      ') does not have sufficient privileges to perform this operation');
    RETURN;
  END IF;

  IF p_key = 'Y' THEN
    -- check for tests that will be marked as key but are not monitored.
    SELECT COUNT(*)
      into l_unmon_key_tests
      FROM MGMT_BCN_TXN_DEFN d,
           (SELECT name, value FROM TABLE(CAST(p_tests AS SMP_EMD_NVPAIR_ARRAY))) tests
     WHERE tests.name = d.name
       AND tests.value = d.txn_type
       AND d.target_guid = l_target_guid
       AND state <> 'M';
    
    IF (l_unmon_key_tests > 0)
    THEN
      result := p_bcn_err_reptxn;
      -- FIXME, the err_desc can be improved to say which test/type are in unmonitored,
      -- but for now, this is not necessary because the client is checking for this in 10.2 release.
      err_desc := 'Key test can not be in unmonitored state';
      RETURN;
    END IF;
  
    l_new_is_key := 'Y';
    l_avail := 1;
  ELSE
    l_new_is_key := 'N';
    l_avail := 0;
  END IF; 

  IF p_is_template = 'Y' THEN
    -- template mode, just updates the is_representative column
    UPDATE mgmt_bcn_txn_defn
       SET is_representative = l_new_is_key
     WHERE target_guid = l_target_guid
       AND txn_guid IN (SELECT d.txn_guid 
                          FROM MGMT_BCN_TXN_DEFN d,
                               (SELECT name, value FROM TABLE(CAST(p_tests AS SMP_EMD_NVPAIR_ARRAY))) tests
                         WHERE d.name        = tests.name
                           AND d.txn_type    = tests.value
                           AND d.target_guid = l_target_guid);
  ELSE
    FOR sub_rec in tests(l_target_guid, p_tests) 
    LOOP
     l_old_is_key := sub_rec.is_representative;
  
      -- update each test individually only if the is_representative column should be changed.
      -- mgmt_bcn_txn_defn is changed only if
      -- 1. mgmt_gensvc_avail.add_test succeeds
      IF (l_old_is_key <> l_new_is_key) 
      THEN
        l_test_name := sub_rec.name;
        l_test_type := sub_rec.txn_type;
         mgmt_test_metadata_read.get_avail_metric(l_test_type, l_met_name, l_met_col );
  
        IF ( sub_rec.state = 'M' ) THEN 
          l_state := 1;
        ELSE
          l_state := 0;
        END IF;
  
        l_test := MGMT_GENSVC_AV_TEST(l_test_name, l_test_type, l_met_name, l_met_col, l_avail, l_state ); 
        mgmt_gensvc_avail.add_test( p_target_name, 
                                    p_target_type,
                                    l_test);
        UPDATE mgmt_bcn_txn_defn
           SET is_representative = l_new_is_key
         WHERE target_guid = l_target_guid
           AND name = l_test_name
           AND txn_type  = l_test_type;
      END IF;
    END LOOP;
  END IF;

  result := p_bcn_success;
  err_desc := NULL;

END SET_TESTS_KEYNESS;

END EMD_BCNTXN;
/
SHOW ERRORS;
/
