Rem
Rem $Header: beacon_txn_pkgdef.sql 23-nov-2005.13:59:26 mfidanbo Exp $
Rem
Rem beacon_txn_pkgdef.sql
Rem
Rem Copyright (c) 2002, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      beacon_txn_pkgdef.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    mfidanbo    11/23/05 - Backport mfidanbo_bug-3699033 from main 
Rem    mfidanbo    11/05/05 - change getwebsites for beacon 
Rem    mfidanbo    11/05/05 - change getwebsites for beacon 
Rem    mfidanbo    08/29/05 - make get_metric_for_keyval public 
Rem    mvajapey    08/29/05 - Add function HAS_ALL_BCN_PRIVS, EMD_BCN_ASSOC_TMPL_APPLY (bug 4580884). 
Rem    rmarripa    08/17/05 - add FUNCTION IS_KEY_VALID_ASSOC 
Rem    yxie        08/05/05 - fix bug 4526542 
Rem    mvajapey    07/26/05 - change input param to set_keyness 
Rem    andyao      07/16/05 - add API to set keyness of transactions 
Rem    mfidanbo    07/18/05 - remove unnecessary code 
Rem    andyao      06/21/05 - add error code 
Rem    andyao      06/09/05 - add associate beacons for template api 
Rem    mfidanbo    06/06/05 - add coll_name api 
Rem    andyao      04/28/05 - remove nocycle and add error code 
Rem    rmarripa    03/25/05 - add parent to step 
Rem    mfidanbo    03/03/05 - make close_bcn_sevs and delete_bcn_metrics 
Rem                           public 
Rem    rmarripa    03/11/05 - remove obsolete procedures 
Rem    rmarripa    02/15/05 - change the signature of HAS_TGT_PRIV 
Rem    mfidanbo    01/26/05 - change signature of getwebsites
Rem    rmarripa    11/22/04 - MTA config changes 
Rem    vjraghav    11/17/04 - Fixing issues for templates 
Rem    vjraghav    11/02/04 - Creating a new data type for templatizing 
Rem                           properties 
Rem    rmarripa    10/28/04 - add action description 
Rem    rmarripa    10/22/04 - continue sync job 
Rem    rmarripa    10/20/04 - make changes to consume sync job 
Rem    vjraghav    10/16/04 - Fixing issue with setting thresholds 
Rem    rmarripa    10/01/04 - add util procedure to get constituent elements 
Rem                           given composite keys 
Rem    rmarripa    09/14/04 - add get_composite_key function 
Rem    rmarripa    09/10/04 - code review comments 
Rem    rmarripa    08/30/04 - add associate beacons procedure for create 
Rem                           service 
Rem    vjraghav    09/03/04 - Retrieve beacons along with a txn definition 
Rem    vjraghav    09/03/04 - Transaction/Step/Stepgroup performance 
Rem    vjraghav    06/25/04 - Rel2 changes to transaction definitions and 
Rem                           properties 
Rem    afontana    02/26/04 - add priv-check for config priv 
Rem    asawant     03/25/03 - Adding functions to get beacon HP data
Rem    rmarripa    03/20/03 - add error code
Rem    rmarripa    03/17/03 - add play back operation
Rem    snakai      03/13/03 - add info on noop bcns in set_bcn
Rem    rmarripa    09/30/02 - add user model to unlock target procedure/function
Rem    rmarripa    10/03/02 - add delete target constant
Rem    rmarripa    09/16/02 - add preocedure to get websites registered with a beacon
Rem    rpinnama    09/18/02 - Remove authid current_user from create package
Rem    rmarripa    07/04/02 - add error code
Rem    snakai      06/28/02 - increase var size
Rem    asawant     06/26/02 - Adding API for target unlock
Rem    rmarripa    06/24/02 - add errcode for create target
Rem    snakai      06/23/02 - add global constants
Rem    asawant     06/19/02 - Adding api for whole def avail
Rem    snakai      06/18/02 - use mgmt_log to report errors
Rem    rmarripa    06/23/02 - fix Usermodel API
Rem    rmarripa    06/20/02 - add usemodel API
Rem    rmarripa    06/07/02 - change website homepage and target beacons API to add alerts.
Rem    asawant     05/31/02 - Adding the status metric col to the "all metrics" of ping..
Rem    jmarfati    05/30/02 - Adding/modifying metric columns..
Rem    rpinnama    05/15/02 - rpinnama_reorg_rep_scripts
Rem    rpinnama    05/15/02 - Restructured.
Rem    snakai      05/06/02 - implement beacon availability.
Rem    asawant     05/01/02 - Adding thresholds.
Rem    asawant     04/29/02 - Adding TZ for website target in 
Rem                           EMD_BCN_GET_WEBSITE_HP_DATA().
Rem    asawant     04/24/02 - Adding functions..
Rem    asawant     04/22/02 - Adding txn guid to api..
Rem    snakai      04/21/02 - add txn name to get_coll_details.
Rem    asawant     04/19/02 - Adding data fetching pl/sql...
Rem    mashukla    04/21/02 - add beacon hmpg pkg.
Rem    snakai      04/16/02 - add GET_COLL_DETAILS.
Rem    snakai      04/12/02 - add schedule to set_thresholds
Rem    snakai      04/03/02 - snakai_beacon_api_4
Rem    snakai      04/03/02 - Created
Rem

-- Beacon Package --------------------------------------------------------

CREATE OR REPLACE PACKAGE EMD_BCNTXN AS

--------------------------------------------------------------------------
-- Types
--------------------------------------------------------------------------
TYPE p_cursor_type IS REF CURSOR;


/*
--------------------------------------------------------------------------
-- Public Procedures/Functions
--------------------------------------------------------------------------
-- EMD_BCN_UNLOCK_TARGET
--
--
PROCEDURE EMD_BCN_UNLOCK_TARGET(tgt_id IN VARCHAR2,
                                result OUT INTEGER,
                                err_desc OUT VARCHAR2);
*/
--------------------------------------------------------------------------
-- HAS_TGT_FUNCTION_PRIV
-- Given a target guid and the funcitonality, this procedure checks 
-- if user has enough privileges or not. 
FUNCTION HAS_TGT_FUNCTION_PRIV ( tgt_id IN VARCHAR2 ,
                                 function IN INTEGER,
                                 err_desc OUT VARCHAR2,
                                 bcns IN SMP_EMD_NVPAIR_ARRAY DEFAULT NULL) RETURN INTEGER;

--------------------------------------------------------------------------
-- HAS_TGT_FUNCTION_PRIV
--
--
FUNCTION HAS_TGT_FUNCTION_PRIV ( l_target_name IN VARCHAR2 ,
                                 l_target_type IN VARCHAR2,
                                 function IN INTEGER,
                                 err_desc OUT VARCHAR2,
                                 bcns IN SMP_EMD_NVPAIR_ARRAY DEFAULT NULL) RETURN INTEGER;

--------------------------------------------------------------------------
-- HAS_USE_ANY_BCN_PRIV
--
--
FUNCTION HAS_USE_ANY_BCN_PRIV RETURN INTEGER;

--------------------------------------------------------------------------
-- IS_KEY_VALID_ASSOC
-- This procedure returns 'Y' if the composite key elements are part of 
-- target. It checks if the key_part1_value, key_part2_vlaue, key_part3_value 
-- are associated with the targets. Returns 'N' if the key value is invalid

FUNCTION IS_KEY_VALID_ASSOC(
        tgt_id            IN RAW,
        comp_key          IN VARCHAR2) RETURN CHAR;

--------------------------------------------------------------------------
FUNCTION EMD_BCN_GET_COMPOSITE_KEY(
        target_id               IN RAW,
        key                     IN mgmt_bcn_threshold_key,
        key_type                IN NUMBER) RETURN VARCHAR2; 
--------------------------------------------------------------------------
-- This procedure signature should change if we change the way we store the 
-- composite key elements 
-- return value will be -1 if there is no data found. Otherwise the retrun 
-- value is 1. 

FUNCTION EMD_BCN_GET_COMP_KEY_ELEMENTS(
        target_id               IN RAW,
        comp_key                IN RAW,
        txn_guid                OUT VARCHAR2,
        bcn_guid                OUT VARCHAR2, 
        step_or_grp_guid        OUT VARCHAR2) RETURN NUMBER; 
--------------------------------------------------------------------------
-- EMD_BCN_TXN_CREATE
-- This procedure is a wrapper around the procedure to throw exceptions
-- This procedure will call main transaction create procedure and convert 
-- error messages to proper exceptions. 
-- EXCEPTION: 
--  MGMT_GLOBAL.SQL_EXECUTION_ERR;
--  MGMT_GLOBAL.INVALID_PARAMS_ERR;
--  MGMT_GLOBAL.INVALID_TEST_DEFINITION_ERR;
--  MGMT_GLOBAL.INSUFFICIENT_PRIVILEGES_ERR;


PROCEDURE EMD_BCN_TXN_CREATE(
        tgt_id                  IN VARCHAR2,
        txn_defn_with_props     IN MGMT_BCN_TXN_WITH_PROPS,
        steps_defn_with_props   IN MGMT_BCN_STEP_WITH_PROPS_ARRAY,
        stepgroups_defn         IN MGMT_BCN_STEPGROUP_ARRAY,
        txn_thresholds          IN MGMT_BCN_THRESHOLD_ARRAY,
        step_thresholds         IN MGMT_BCN_THRESHOLD_ARRAY,
        stepgroup_thresholds    IN MGMT_BCN_THRESHOLD_ARRAY,
        for_push                IN VARCHAR2,
        new_txn_id              OUT VARCHAR2,
        new_version             OUT INTEGER,
        bcn_list                OUT MGMT_BCN_ARRAY);

--------------------------------------------------------------------------
-- EMD_BCN_TXN_CREATE
--
PROCEDURE EMD_BCN_TXN_CREATE(
        tgt_id                  IN VARCHAR2,
        txn_defn_with_props     IN MGMT_BCN_TXN_WITH_PROPS,
        steps_defn_with_props   IN MGMT_BCN_STEP_WITH_PROPS_ARRAY,
        stepgroups_defn         IN MGMT_BCN_STEPGROUP_ARRAY,
        txn_thresholds          IN MGMT_BCN_THRESHOLD_ARRAY,
        step_thresholds         IN MGMT_BCN_THRESHOLD_ARRAY,
        stepgroup_thresholds    IN MGMT_BCN_THRESHOLD_ARRAY,
        for_push                IN VARCHAR2,
        new_txn_id              OUT VARCHAR2,
        new_version             OUT INTEGER,
        bcn_list                OUT MGMT_BCN_ARRAY,
        result                  OUT INTEGER,
        err_desc                OUT VARCHAR2);

--------------------------------------------------------------------------
-- EMD_BCN_GET_THRESHOLDS
--
PROCEDURE EMD_BCN_GET_THRESHOLDS (
        tgt_id                  IN VARCHAR2,
        txn_id                  IN VARCHAR2,
        txn_thresholds          OUT MGMT_BCN_THRESHOLD_ARRAY,
        step_thresholds         OUT MGMT_BCN_THRESHOLD_ARRAY,
        stepgroup_thresholds    OUT MGMT_BCN_THRESHOLD_ARRAY,
        result                  OUT INTEGER,
        err_desc                OUT VARCHAR2);

--------------------------------------------------------------------------
-- EMD_BCN_EDIT_TXN_THRESH
--
PROCEDURE EMD_BCN_EDIT_TXN_THRESH (
        target_id               IN VARCHAR2,
        add_thresholds          IN MGMT_BCN_THRESHOLD_ARRAY,
        rm_thresholds           IN MGMT_BCN_THRESHOLD_KEY_ARRAY,
        result                  OUT INTEGER,
        err_desc                OUT VARCHAR2);

--------------------------------------------------------------------------
-- EMD_BCN_EDIT_STEP_THRESH
--
PROCEDURE EMD_BCN_EDIT_STEP_THRESH (
        target_id               IN VARCHAR2,
        add_thresholds          IN MGMT_BCN_THRESHOLD_ARRAY,
        rm_thresholds           IN MGMT_BCN_THRESHOLD_KEY_ARRAY,
        result                  OUT INTEGER,
        err_desc                OUT VARCHAR2);

--------------------------------------------------------------------------
-- EMD_BCN_EDIT_STEPGROUP_THRESH
--
PROCEDURE EMD_BCN_EDIT_STEPGROUP_THRESH (
        target_id               IN VARCHAR2,
        add_thresholds          IN MGMT_BCN_THRESHOLD_ARRAY,
        rm_thresholds           IN MGMT_BCN_THRESHOLD_KEY_ARRAY,
        result                  OUT INTEGER,
        err_desc                OUT VARCHAR2);

--------------------------------------------------------------------------
-- EMD_BCN_REPL_TXN_PROPS
--
PROCEDURE EMD_BCN_REPL_TXN_PROPS (
        tgt_id                  IN VARCHAR2,
        txn_id                  IN VARCHAR2,
        txn_props               IN MGMT_BCN_NVPAIR_ARRAY,
        txn_bcn_props           IN MGMT_BCN_PERBCN_NVPAIR_ARRAY,
        result                  OUT INTEGER,
        err_desc                OUT VARCHAR2);

--------------------------------------------------------------------------
-- EMD_BCN_EDIT_TXN_PROPS
--
PROCEDURE EMD_BCN_EDIT_TXN_PROPS (
        tgt_id                  IN VARCHAR2,
        txn_id                  IN VARCHAR2,
        add_txn_props           IN MGMT_BCN_NVPAIR_ARRAY,
        rm_txn_props            IN MGMT_BCN_PNAMES_ARRAY,
        add_bcn_txn_props       IN MGMT_BCN_PERBCN_NVPAIR_ARRAY,
        rm_bcn_txn_props        IN MGMT_BCN_PERBCN_PNAMES_ARRAY,
        result                  OUT INTEGER,
        err_desc                OUT VARCHAR2);

--------------------------------------------------------------------------
-- EMD_BCN_REPL_STEP_PROPS
--
PROCEDURE EMD_BCN_REPL_STEP_PROPS (
        target_id               IN VARCHAR2,
        step_id                 IN VARCHAR2,
        step_props              IN MGMT_BCN_NVPAIR_ARRAY,
        result                  OUT INTEGER,
        err_desc                OUT VARCHAR2);

--------------------------------------------------------------------------
-- EMD_BCN_EDIT_STEP_PROPS
--
PROCEDURE EMD_BCN_EDIT_STEP_PROPS (
        target_id               IN VARCHAR2,
        step_id                 IN VARCHAR2,
        add_props               IN MGMT_BCN_NVPAIR_ARRAY,
        rm_props                IN MGMT_BCN_PNAMES_ARRAY,
        result                  OUT INTEGER,
        err_desc                OUT VARCHAR2);

--------------------------------------------------------------------------
-- EMD_BCN_TXN_VIEW
--
PROCEDURE EMD_BCN_TXN_VIEW (
        tgt_id                  IN VARCHAR2,
        txn_id                  IN VARCHAR2,
        txn_defn_with_props     OUT MGMT_BCN_TXN_WITH_PROPS,
        steps_defn_with_props   OUT MGMT_BCN_STEP_WITH_PROPS_ARRAY,
        stepgroups_defn         OUT MGMT_BCN_STEPGROUP_ARRAY,
        bcn_list                OUT MGMT_BCN_ARRAY,        
        result                  OUT INTEGER,
        err_desc                OUT VARCHAR2);

PROCEDURE EMD_BCN_TXN_VIEW (
        tgt_id                  IN VARCHAR2,
        txn_id                  IN VARCHAR2,
        txn_defn_with_props     OUT MGMT_BCN_TXN_WITH_PROPS,
        steps_defn_with_props   OUT MGMT_BCN_STEP_WITH_PROPS_ARRAY,
        stepgroups_defn         OUT MGMT_BCN_STEPGROUP_ARRAY,
        txn_thresholds          OUT MGMT_BCN_THRESHOLD_ARRAY,
        step_thresholds         OUT MGMT_BCN_THRESHOLD_ARRAY,
        stepgroup_thresholds    OUT MGMT_BCN_THRESHOLD_ARRAY,
        bcn_list                OUT MGMT_BCN_ARRAY,        
        result                  OUT INTEGER,
        err_desc                OUT VARCHAR2);

--------------------------------------------------------------------------
-- EMD_BCN_GET_TXNS
--
PROCEDURE EMD_BCN_GET_TXNS (
        tgt_id                  IN VARCHAR2,
        txn_ids                 IN MGMT_BCN_TXNID_ARRAY,
        include_thresh          IN INTEGER,
        transactions            OUT MGMT_BCN_TRANSACTION_ARRAY,
        result                  OUT INTEGER,
        err_desc                OUT VARCHAR2);

PROCEDURE EMD_BCN_GET_TXNS_BY_TYPE (
        tgt_id                  IN VARCHAR2,
        txn_types               IN SMP_EMD_STRING_ARRAY,
        include_thresh          IN INTEGER,
        transactions            OUT MGMT_BCN_TRANSACTION_ARRAY,
        result                  OUT INTEGER,
        err_desc                OUT VARCHAR2);
--------------------------------------------------------------------------
-- EMD_BCN_EDIT_TXN
--
/*
PROCEDURE EMD_BCN_EDIT_TXN (
        tgt_id                  IN VARCHAR2,
        txn_defn_with_props     IN MGMT_BCN_TXN_WITH_PROPS,
        for_push                IN VARCHAR2,
        new_version             OUT INTEGER,
        result                  OUT INTEGER,
        err_desc                OUT VARCHAR2);   
*/
--------------------------------------------------------------------------
-- EMD_BCN_EDIT_STEPS
--
PROCEDURE EMD_BCN_EDIT_STEPS (
        tgt_id                  IN VARCHAR2,
        txn_id                  IN VARCHAR2,
        add_steps               IN MGMT_BCN_STEP_WITH_PROPS_ARRAY,
        rm_steps                IN MGMT_BCN_STEPID_ARRAY,
        result                  OUT INTEGER,
        err_desc                OUT VARCHAR2);

--------------------------------------------------------------------------
-- EMD_BCN_EDIT_STEPGROUPS
--
PROCEDURE EMD_BCN_EDIT_STEPGROUPS (
        tgt_id                  IN VARCHAR2,
        txn_id                  IN VARCHAR2,
        add_stepgroups          IN MGMT_BCN_STEPGROUP_ARRAY,
        rm_stepgroups           IN MGMT_BCN_STEPGROUPID_ARRAY,
        result                  OUT INTEGER,
        err_desc                OUT VARCHAR2);

--------------------------------------------------------------------------
-- EMD_BCN_GET_BEACONS
FUNCTION EMD_BCN_GET_BEACONS(
        tgt_id                  VARCHAR2,
        txn_id                  VARCHAR2) RETURN MGMT_BCN_ARRAY;
        
--------------------------------------------------------------------------
-- EMD_BCN_TXN_MODIFY
--
PROCEDURE EMD_BCN_TXN_MODIFY (
        tgt_id                  IN VARCHAR2,
        txn_defn_with_props     IN MGMT_BCN_TXN_WITH_PROPS,        
        steps_defn_with_props   IN MGMT_BCN_STEP_WITH_PROPS_ARRAY,
        rm_steps                IN MGMT_BCN_STEPID_ARRAY,        
        stepgroups_defn         IN MGMT_BCN_STEPGROUP_ARRAY,        
        rm_stepgroups           IN MGMT_BCN_STEPGROUPID_ARRAY,        
        txn_thresholds          IN MGMT_BCN_THRESHOLD_ARRAY,        
        step_thresholds         IN MGMT_BCN_THRESHOLD_ARRAY,        
        stepgroup_thresholds    IN MGMT_BCN_THRESHOLD_ARRAY,        
        new_version             OUT INTEGER,
        bcn_list                OUT MGMT_BCN_ARRAY,        
        result                  OUT INTEGER,        
        err_desc                OUT VARCHAR2);

--------------------------------------------------------------------------
-- EMD_BCN_TXN_DELETE
--
PROCEDURE EMD_BCN_TXN_DELETE(
        tgt_id                  IN VARCHAR2, 
        txn_id                  IN VARCHAR2, 
        bcn_list                OUT MGMT_BCN_ARRAY,
        result                  OUT INTEGER, 
        err_desc                OUT VARCHAR2);

--------------------------------------------------------------------------
-- EMD_BCN_TXN_START_MONITOR
--
PROCEDURE EMD_BCN_TXN_START_MONITOR (
        tgt_id                  IN VARCHAR2,
        txn_id                  IN VARCHAR2,
        txn_defn_with_props     OUT MGMT_BCN_TXN_WITH_PROPS,
        steps_defn_with_props   OUT MGMT_BCN_STEP_WITH_PROPS_ARRAY,
        stepgroups_defn         OUT MGMT_BCN_STEPGROUP_ARRAY,
        txn_thresholds          OUT MGMT_BCN_THRESHOLD_ARRAY,
        step_thresholds         OUT MGMT_BCN_THRESHOLD_ARRAY,
        stepgroup_thresholds    OUT MGMT_BCN_THRESHOLD_ARRAY,
        bcn_list                OUT MGMT_BCN_ARRAY,
        result                  OUT INTEGER,
        err_desc                OUT VARCHAR2);

--------------------------------------------------------------------------
-- EMD_BCN_TXN_STOP_MONITOR
--
PROCEDURE EMD_BCN_TXN_STOP_MONITOR(
        tgt_id                  IN VARCHAR2,
        txn_id                  IN VARCHAR2,
        bcn_list                OUT MGMT_BCN_ARRAY,
        result                  OUT INTEGER,
        err_desc                OUT VARCHAR2);

--------------------------------------------------------------------------
-- EMD_BCN_TXN_SYNC_LIST
--
PROCEDURE EMD_BCN_TXN_SYNC_LIST(tgt_id IN VARCHAR2,
                                txn_list OUT MGMT_BCN_TXN_SYNC_ARRAY,
                                result OUT INTEGER,
                                err_desc OUT VARCHAR2);

--------------------------------------------------------------------------
-- EMD_BCN_SET_BCNS
--
/*
PROCEDURE EMD_BCN_SET_BCNS(
        tgt_id                  IN VARCHAR2,
        new_bcn_list            IN MGMT_BCN_NAME_ARRAY,
        transactions            OUT MGMT_BCN_TRANSACTION_ARRAY,
        add_bcn_list            OUT MGMT_BCN_ARRAY,
        del_bcn_list            OUT MGMT_BCN_ARRAY,
        keep_bcn_list           OUT MGMT_BCN_NAME_ARRAY,
        dbdel_bcn_list          OUT MGMT_BCN_NAME_ARRAY,
        result                  OUT INTEGER,
        /err_desc                OUT VARCHAR2);
*/

--------------------------------------------------------------------------
-- EMD_BCN_ASSOCIATE_BEACONS
-- target_name: Name of Target being monitored by Beacon
-- target_type: Target Type
-- mgmt_bcn_assoc_array: List of Beacons monitoring the target and their roles. 
-- is_template: true if the target is a template, false if it is a proper target
PROCEDURE EMD_BCN_ASSOCIATE_BEACONS(
        tgt_name             IN VARCHAR2,
        tgt_type             IN VARCHAR2,
        mgmt_bcn_assoc_array IN MGMT_BCN_ASSOC_ARRAY,
        is_template          IN BOOLEAN DEFAULT FALSE);

--------------------------------------------------------------------------
--------------------------------------------------------------------------
-- PROCEDURE: EMD_BCN_ASSOC_TMPL_APPLY
-- PURPOSE: Similar to the main EMD_BCN_ASSOCIATE_BEACONS, with two additional 
-- parameters:
--
--  - result: an integer indicating the success of the operation. Can take values:
--    a) p_bcn_success - if association is successful.
--    b) p_err_use_bcn_priv_req, if user lacks privileges on at least one beacon.
--
--
--  - err_desc: an error string in case the operation failed. If result = p_err_use_bcn_priv_req, 
-- the err_desc returns a list of such beacons for which the user lacks privilege. 
-- Otherwise it is empty/null.
--
-- This procedure does not use the is_template parameter since it is only applicable to
-- targets (in particular, it requires OPERATOR beacon priv for association). It always
-- passes FALSE to the main ASSOCIATE_BEACONS procedure
--
-- Exceptions:
--  MGMT_GLOBAL.TARGET_DOES_NOT_EXIST_ERR
--  MGMT_GLOBAL.INVALID_PARAMS_ERR
--  MGMT_GLOBAL.INSUFFICIENT_PRIVILEGES_ERR

PROCEDURE EMD_BCN_ASSOC_TMPL_APPLY(
        tgt_name                IN VARCHAR2,
        tgt_type                IN VARCHAR2,
        mgmt_bcn_assoc_array    IN MGMT_BCN_ASSOC_ARRAY,
        result                  OUT INTEGER,
        err_desc                OUT VARCHAR2);

--------------------------------------------------------------------------
-- EMD_BCN_ASSOCIATE_BEACONS
-- target_name: Name of Target being monitored by Beacon
-- target_type: Target Type
-- mgmt_bcn_assoc_array: List of Beacons monitoring the target and their roles. 
PROCEDURE EMD_BCN_REMOVE_BEACON_ASSOCS(
        tgt_name                IN VARCHAR2,
        tgt_type                IN VARCHAR2,
        mgmt_bcn_assoc_array    IN MGMT_BCN_ASSOC_ARRAY,
        is_template             IN BOOLEAN DEFAULT FALSE);

--------------------------------------------------------------------------
/*--  EMD_BCN_SYNCHRONIZE
-- tgt_name: Name of Target being monitored by Beacon
-- tgt_type: Target Type
-- beacon_tgt_name: Beacon target name
-- beacon_tgt_type: beacon target type 

PROCEDURE EMD_BCN_SYNCHRONIZE(
        tgt_name                IN VARCHAR2,
        tgt_type                IN VARCHAR2,
        beacon_tgt_name         IN VARCHAR2,
        beacon_tgt_type         IN VARCHAR2);

*/
--------------------------------------------------------------------------
-- EMD_BCN_SYNC_SEV_LIST
--
PROCEDURE EMD_BCN_SYNC_SEV_LIST(tgt_id IN VARCHAR2,
                                bcn_list OUT MGMT_BCN_SYNC_ARRAY,
                                l_sev_list OUT p_cursor_type,
                                result OUT INTEGER,
                                err_desc OUT VARCHAR2);

--------------------------------------------------------------------------
/*
-- EMD_BCN_TXN_SET_STATUS
--
PROCEDURE EMD_BCN_TXN_SET_STATUS(
        tgt_id                  IN VARCHAR2,
        status_list             IN MGMT_BCN_TXN_STATUS_ARRAY,
        result                  OUT INTEGER,
        err_desc                OUT VARCHAR2);

*/
/*
--------------------------------------------------------------------------
-- EMD_BCN_TXN_SET_AVAIL
--
PROCEDURE EMD_BCN_TXN_SET_AVAIL(tgt_id IN VARCHAR2,
                                txn_id IN VARCHAR2,
                                bcn_list IN MGMT_BCN_GUID_ARRAY,
                                result OUT INTEGER,
                                err_desc OUT VARCHAR2);

--------------------------------------------------------------------------
-- EMD_BCN_TXN_SET_REPRESENTATIVE
--
PROCEDURE EMD_BCN_TXN_SET_REPRESENTATIVE(tgt_id IN VARCHAR2,
                                         txn_id IN VARCHAR2,
                                         result OUT INTEGER,
                                         err_desc OUT VARCHAR2);

--------------------------------------------------------------------------
-- EMD_BCN_TXN_SET_AVAIL_LIST
--
PROCEDURE EMD_BCN_TXN_SET_AVAIL_LIST(tgt_id IN VARCHAR2,
                                     bcn_list IN MGMT_BCN_GUID_ARRAY,
                                     result OUT INTEGER,
                                     err_desc OUT VARCHAR2);
--------------------------------------------------------------------------
-- EMD_BCN_RECOVER
--
PROCEDURE EMD_BCN_RECOVER(result OUT INTEGER, err_desc OUT VARCHAR2);
*/
--------------------------------------------------------------------------
-- EMD_BCN_GET_COLL_DETAILS
--
/*
PROCEDURE EMD_BCN_GET_COLL_DETAILS ( tgt_in IN VARCHAR2, 
                                     txn_in IN VARCHAR2, 
                                     txn_name OUT VARCHAR2,
                                     txn_bcn_details OUT p_cursor_type,
                                     result OUT INTEGER, 
                                     err_desc OUT VARCHAR2 );
*/
--------------------------------------------------------------------------
-- EMD_BCN_GET_TXN_DATA
--
PROCEDURE EMD_BCN_GET_TXN_DATA ( l_target_name IN VARCHAR2,
                                 l_target_type IN VARCHAR2,
                                 l_bcn_guid    IN VARCHAR2,
                                 l_txn_guid    IN VARCHAR2,
                                 l_metric_name IN VARCHAR2,
                                 l_metric_col  IN VARCHAR2,
                                 l_all         IN VARCHAR2,
                                 l_period      IN VARCHAR2,
                                 l_max_filter  IN NUMBER,
                                 l_min_filter  IN NUMBER,
                                 l_max_date    IN DATE,
                                 l_min_date    IN DATE,
                                 l_txn_name    OUT VARCHAR2,
                                 l_bcn_name    OUT VARCHAR2,
                                 l_warn_thresh OUT VARCHAR2,
                                 l_crit_thresh OUT VARCHAR2,
                                 l_chart_data  OUT p_cursor_type,
                                 l_cur_tbl_dt  OUT p_cursor_type,
                                 l_avg_tbl_dt  OUT p_cursor_type,
                                 l_txn_list    OUT p_cursor_type,
                                 l_bcn_list    OUT p_cursor_type,
                                 l_result      OUT INTEGER,
                                 l_err_desc    OUT VARCHAR2 );
--------------------------------------------------------------------------
-- EMD_BCN_GET_PERF_DATA
-- 
PROCEDURE EMD_BCN_GET_PERF_DATA(
        l_target_name           IN VARCHAR2,
        l_target_type           IN VARCHAR2,
        l_period                IN VARCHAR2,
        l_max_filter            IN NUMBER,
        l_min_filter            IN NUMBER,
        l_max_date              IN DATE,
        l_min_date              IN DATE,
        -- The names of the transaction, step and stepgroup metrics
        l_txn_metric_name       IN VARCHAR2,
        l_step_metric_name      IN VARCHAR2,
        l_stpgrp_metric_name    IN VARCHAR2,
        -- The following inputs parameterize the retrieval of average/current data
        l_txn_ids_1             IN SMP_EMD_STRING_ARRAY,
        l_txn_metrics_1         IN SMP_EMD_STRING_ARRAY,
        l_step_ids_1            IN SMP_EMD_STRING_ARRAY,
        l_step_metrics_1        IN SMP_EMD_STRING_ARRAY,
        l_stpgrp_ids_1          IN SMP_EMD_STRING_ARRAY,
        l_stpgrp_metrics_1      IN SMP_EMD_STRING_ARRAY,
        l_bcn_ids_1             IN SMP_EMD_STRING_ARRAY,
        -- The following inputs parameterize the retrieval of time series data
        l_txn_ids_2             IN SMP_EMD_STRING_ARRAY,
        l_txn_metrics_2         IN SMP_EMD_STRING_ARRAY,
        l_step_ids_2            IN SMP_EMD_STRING_ARRAY,
        l_step_metrics_2        IN SMP_EMD_STRING_ARRAY,
        l_stpgrp_ids_2          IN SMP_EMD_STRING_ARRAY,
        l_stpgrp_metrics_2      IN SMP_EMD_STRING_ARRAY,
        l_bcn_ids_2             IN SMP_EMD_STRING_ARRAY,
        -- We return a set of cursors for average/current data
        l_txn_data_1            OUT p_cursor_type,
        l_step_data_1           OUT p_cursor_type,
        l_stpgrp_data_1         OUT p_cursor_type,
        -- We also return a set of cursors for time series data
        l_txn_data_2            OUT p_cursor_type,
        l_step_data_2           OUT p_cursor_type,
        l_stpgrp_data_2         OUT p_cursor_type,
        -- The version change history, keyed on transaction id
        l_version_history       OUT p_cursor_type,
        l_result                OUT INTEGER,
        l_err_desc              OUT VARCHAR2);

--------------------------------------------------------------------------
-- EMD_BCN_GET_TXN_CURRENT_DATA
--
PROCEDURE EMD_BCN_GET_TXN_CURRENT_DATA ( l_target_name IN VARCHAR2,
                                         l_target_type IN VARCHAR2,
                                         l_metric_name IN VARCHAR2,
                                         l_txn_guid    IN RAW,
                                         l_time_period IN NUMBER,
                                         l_table_data  OUT p_cursor_type,
                                         l_sev_list    OUT p_cursor_type,
                                         l_result      OUT INTEGER,
                                         l_err_desc    OUT VARCHAR2 );
--------------------------------------------------------------------------
-- EMD_BCN_GET_HP_DATA
--
PROCEDURE EMD_BCN_GET_WEBSITE_HP_DATA ( l_target_name IN VARCHAR2,
                                        l_target_type IN VARCHAR2,
                                        l_time_period IN NUMBER,
                                        l_txn_guid    OUT VARCHAR2,
                                        l_txn_name    OUT VARCHAR2,
                                        l_tgt_tz      OUT NUMBER,
                                        l_table_data  OUT p_cursor_type,
                                        l_sev_data    OUT p_cursor_type,  
                                        l_chart_data  OUT p_cursor_type,
                                        l_result      OUT INTEGER,
                                        l_err_desc    OUT VARCHAR2 );
--------------------------------------------------------------------------
-- EMD_BCN_GET_HOME_PG_DATA
--
PROCEDURE EMD_BCN_GET_BCN_HOME_PG_DATA ( l_bcn_target_name IN VARCHAR2,
                                         l_bcn_target_type IN VARCHAR2,
                                         l_ping_table_data OUT p_cursor_type,
                                         l_url_table_data  OUT p_cursor_type,
                                         l_ping_txn_list   OUT p_cursor_type,
                                         l_url_txn_list    OUT p_cursor_type,
                                         l_ping_txn_sev_list OUT p_cursor_type,
                                         l_url_txn_sev_list OUT p_cursor_type,
                                         result OUT INTEGER,
                                         err_desc OUT VARCHAR2  );

--------------------------------------------------------------------------
-- EMD_BCN_GET_BCN_SYNC_STATUS
--
PROCEDURE EMD_BCN_GET_BCN_SYNC_STATUS ( l_bcn_guid    IN VARCHAR2,
                                        l_in_sync    OUT  INTEGER,
                                        result       OUT INTEGER,
                                        err_desc     OUT VARCHAR2 );

--------------------------------------------------------------------------
-- EMD_BCN_GET_BCN_HP_HOME_DATA
--
PROCEDURE EMD_BCN_GET_BCN_HP_HOME_DATA ( l_bcn_name IN  VARCHAR2,
                                         l_in_sync  OUT INTEGER,
                                         l_props    OUT p_cursor_type,
                                         result     OUT INTEGER,
                                         err_desc   OUT VARCHAR2 );
--------------------------------------------------------------------------
-- EMD_BCN_GET_BCN_WEBSITES
--
PROCEDURE EMD_BCN_GET_BCN_WEBSITES ( l_bcn_target_name IN VARCHAR2,
                                     l_bcn_target_type IN VARCHAR2,
                                     l_allowed_websites OUT p_cursor_type,                        
                                     l_websites_data   OUT p_cursor_type,
                                     result OUT INTEGER,
                                     err_desc OUT VARCHAR2  );

--------------------
-- EMD_BCN_GET_COLL_NAME
--
FUNCTION EMD_BCN_GET_COLL_NAME ( l_target_name IN VARCHAR2,
                                 l_target_type IN VARCHAR2,
                                 l_beacon_name IN VARCHAR2,
                                 l_test_name IN VARCHAR2,
                                 l_test_type IN VARCHAR2)
RETURN VARCHAR2;


--
-- PROCEDURE :SET_TESTS_KEYNESS 
--
-- PURPOSE
--   Updates the key (is_representative column) for a given set of tests.
--
-- IN PARAMETERS
--   p_target_name:  The target name
--   p_target_type:  The target type 
--   p_tests:        An array of test name/test type pairs.
--   p_key:          if 'Y',    all tests in p_tests should become key tests.
--                   otherwise, all tests in p_tests should become non key tests.
--   p_is_template   if 'Y',    treat the target as a template,
--                   otherwise, treat the target as a normal target.
-- OUT PARAMETERS
--   result:         The error code or p_bcn_success.
--   err_desc:       The error message.
--
-- NOTE
--   If a test in p_tests is not monitored, and p_key is true, the error code/message 
--   will be returned in result/err_desc.
--
-- EXCEPTION
--   TARGET_DOES_NOT_EXIST: if any sub service does not exist
--

PROCEDURE SET_TESTS_KEYNESS (p_target_name IN VARCHAR2,
                             p_target_type IN VARCHAR2,
                             p_tests       IN SMP_EMD_NVPAIR_ARRAY,
                             p_key         IN VARCHAR2,
                             p_is_template IN VARCHAR2 DEFAULT 'N',
                             result        OUT INTEGER,        
                             err_desc      OUT VARCHAR2);


--
-- PROCEDURE: GET_METRICS_FOR_KEYVAL
-- PURPOSE: Get the metric guids for a given key value.
--
-- IN params: target_guid, key_value, key_level
-- OUT params: metric_guid array
FUNCTION GET_METRICS_FOR_KEYVAL(p_target_guid IN RAW,
                                p_key_value IN VARCHAR2,
                                p_key_level IN VARCHAR2) 
                                -- can be TXN, GROUP, STEP or ALL
RETURN SMP_EMD_STRING_ARRAY;



--------------------------------------------------------------------------
-- Internal Package Types
--------------------------------------------------------------------------
TYPE p_guid_list_type IS
  TABLE OF RAW(16)
  INDEX BY BINARY_INTEGER;

TYPE p_bool_list_type IS
  TABLE OF BOOLEAN
  INDEX BY BINARY_INTEGER;

TYPE p_char32_list_type IS
  TABLE OF VARCHAR2(32)
  INDEX BY BINARY_INTEGER;

TYPE p_char64_list_type IS
  TABLE OF VARCHAR2(64)
  INDEX BY BINARY_INTEGER;

TYPE p_char256_list_type IS
  TABLE OF VARCHAR2(256)
  INDEX BY BINARY_INTEGER;

TYPE p_number_list_type IS
  TABLE OF NUMBER(8)
  INDEX BY BINARY_INTEGER;

--------------------------------------------------------------------------
-- Package Error Codes
--------------------------------------------------------------------------
p_bcn_success                   CONSTANT INTEGER := 0;
p_bcn_err_oraerr                CONSTANT INTEGER := 1;
p_bcn_err_badparams             CONSTANT INTEGER := 2;
p_bcn_err_dupid                 CONSTANT INTEGER := 3;
p_bcn_err_tgtnotfound           CONSTANT INTEGER := 4;
p_bcn_err_tgtinuse              CONSTANT INTEGER := 5;
p_bcn_err_txnnotfound           CONSTANT INTEGER := 6;
p_bcn_err_bcnnotfound           CONSTANT INTEGER := 7;
p_bcn_err_reptxn                CONSTANT INTEGER := 8;
p_bcn_err_txnmonitoring         CONSTANT INTEGER := 9;
p_bcn_err_txnnotmonitor         CONSTANT INTEGER := 10;
p_bcn_err_txndeleting           CONSTANT INTEGER := 11;
p_bcn_err_bcninavail            CONSTANT INTEGER := 12;
p_bcn_err_bcndeleting           CONSTANT INTEGER := 13;
p_bcn_err_invalidmetric         CONSTANT INTEGER := 14;
p_bcn_err_txnoutofsync          CONSTANT INTEGER := 15;
p_bcn_err_bcnoutofsync          CONSTANT INTEGER := 16;
p_bcn_err_invalidrepos          CONSTANT INTEGER := 17;
p_bcn_err_invalidtxn            CONSTANT INTEGER := 18;
p_bcn_err_invalidpingop         CONSTANT INTEGER := 19;
p_bcn_err_invalidbcnop          CONSTANT INTEGER := 20;

-- User Privileges error codes
p_err_use_bcn_priv_req          CONSTANT INTEGER := 21;
p_err_operator_priv_req         CONSTANT INTEGER := 22;
p_err_view_priv_req             CONSTANT INTEGER := 23;
p_err_unknown_function          CONSTANT INTEGER := 24;
p_err_crttgt_fullmem_priv_req   CONSTANT INTEGER := 25;
p_err_empty_mem_tgt_list        CONSTANT INTEGER := 26;

p_err_homepage_prop_notfound    CONSTANT INTEGER := 27;
p_err_full_tgt_priv_req         CONSTANT INTEGER := 28;
p_err_agent_url_invalid         CONSTANT INTEGER := 29;

p_err_view_tmpl_priv_req        CONSTANT INTEGER := 30;
p_err_full_tmpl_priv_req        CONSTANT INTEGER := 31;

-- Parent not found for the step 
p_bcn_err_parentnotfound        CONSTANT INTEGER := 32;
p_bcn_err_malformed_stpgrp      CONSTANT INTEGER := 33;
p_bcn_err_step_loop_found       CONSTANT INTEGER := 34;
p_bcn_err_dup_in_steps          CONSTANT INTEGER := 35;
p_bcn_err_dup_in_groups         CONSTANT INTEGER := 36;
p_bcn_err_dup_in_steps_n_grps   CONSTANT INTEGER := 37;

--------------------------------------------------------------------------
-- Globals / Constants
--------------------------------------------------------------------------

MODULE_NAME                     CONSTANT VARCHAR2(32) := 'BCN_TXN';

-- The following list of txn , step and groups types needs to grow as we add
-- more types
p_http_db_type                  CONSTANT VARCHAR2(8) := 'HTTP';
p_http_txn_metric               CONSTANT VARCHAR2(64) := 'http_response';
p_http_step_metric              CONSTANT VARCHAR2(64) := 'http_page';
p_http_stepgroup_metric         CONSTANT VARCHAR2(64) := 'http_uagroup';
p_ping_db_type                  CONSTANT VARCHAR2(8) := 'PING';
p_ping_txn_metric               CONSTANT VARCHAR2(64) := 'ping';
p_ftp_db_type                   CONSTANT VARCHAR2(8) := 'FTP';
p_ftp_txn_metric                CONSTANT VARCHAR2(64) := 'ftp_response';

p_all                           CONSTANT NUMBER := 0;
p_txn                           CONSTANT NUMBER := 1;
p_step                          CONSTANT NUMBER := 2;
p_stepgroup                     CONSTANT NUMBER := 3;

p_beacon_type                   CONSTANT VARCHAR2(20) := 'oracle_beacon';
p_local_target_name             CONSTANT VARCHAR2(8)  := '-';
p_default_thresh_key            CONSTANT VARCHAR2(20) := 'default_threshold';
p_default_step_thresh_key       CONSTANT VARCHAR2(25) := 'default_threshold_step';
p_default_stpgrp_thresh_key     CONSTANT VARCHAR2(30) := 'default_threshold_stepgroup';

p_err_maxlen                    CONSTANT INTEGER := 2048;
p_use_bcn_name                  CONSTANT VARCHAR2(22) := 'mgmt_bcn_use_bcn_name';
p_use_bcn_guid                  CONSTANT VARCHAR2(22) := 'mgmt_bcn_use_bcn_guid';

p_internal_error                EXCEPTION;
p_record_locked                 EXCEPTION;
PRAGMA EXCEPTION_INIT(p_record_locked, -54);

p_round_precision               CONSTANT NUMBER := 3;

p_period_current                CONSTANT VARCHAR2(5) := 'pCur';
p_period_1_hour                 CONSTANT VARCHAR2(5) := 'p1h';
p_period_24_hours               CONSTANT VARCHAR2(5) := 'p24h';
p_period_7_days                 CONSTANT VARCHAR2(5) := 'p7d';
p_period_31_days                CONSTANT VARCHAR2(5) := 'p31d';

p_bcn_time_metric_cols          CONSTANT VARCHAR2(5) := 'time';
p_bcn_all_metric_cols           CONSTANT VARCHAR2(5) := 'met';
p_bcn_all_beacons               CONSTANT VARCHAR2(5) := 'bcn';
p_bcn_avail_beacons             CONSTANT VARCHAR2(5) := 'avl';
p_bcn_all_transactions          CONSTANT VARCHAR2(5) := 'txn';

p_met_name_http			CONSTANT VARCHAR2(20):= 'http_response';
p_met_name_ping			CONSTANT VARCHAR2(20):= 'ping';

p_met_col_avg_resp_time		CONSTANT VARCHAR2(20):= 'avg_response_time';

p_met_time_col_array_http_resp  CONSTANT SMP_EMD_STRING_ARRAY :=
  SMP_EMD_STRING_ARRAY('timing', 'connect_time', 'redirect_time',
                       'first_byte_time', 'html_time', 'content_time',
                       'total_response_time', 'max_response_time', 
                       p_met_col_avg_resp_time, 'avg_connect_time', 
                       'avg_first_byte_time');

p_met_col_array_http_resp       CONSTANT SMP_EMD_STRING_ARRAY :=
  SMP_EMD_STRING_ARRAY('timing', 'status', 'connect_time', 'redirect_time',
                       'first_byte_time', 'html_time', 'content_time',
                       'total_response_time', 'rate', 'max_response_time', 
                       p_met_col_avg_resp_time, 'avg_connect_time', 
                       'avg_first_byte_time', 'broken_count');

p_met_col_array_ping            CONSTANT SMP_EMD_STRING_ARRAY :=
  SMP_EMD_STRING_ARRAY('avg', 'drop_rate', 'number_of_hops', 'host_status');


--Sync job constants
p_add_collection               CONSTANT INTEGER := 1;
p_remove_collection             CONSTANT INTEGER := 0;
p_create_txn_action_desc        CONSTANT VARCHAR2(64) := 'Create Service Test';
p_delete_txn_action_desc        CONSTANT VARCHAR2(64) := 'Delete Service Test';
p_modify_txn_action_desc        CONSTANT VARCHAR2(64) := 'Modify Service Test';
p_start_txn_action_desc         CONSTANT VARCHAR2(64) := 'Enable Service Test';
p_stop_txn_action_desc          CONSTANT VARCHAR2(64) := 'Disable Service Test';
p_add_bcn_action_desc           CONSTANT VARCHAR2(64) := 'Add Beacon';
p_remove_bcns_action_desc       CONSTANT VARCHAR2(64) := 'Remove Beacons';
p_sync_bcns_action_desc         CONSTANT VARCHAR2(64) := 'Sync Beacon';

--User Model Constants.
-- Constants for the functionality
p_sync_beacon                   CONSTANT INTEGER := 0;
-- Manage Beacons functionality
p_manage_beacons                CONSTANT INTEGER := 1;
-- Update beacon associations of a target. This is part of Manage Beacons 
-- functionality
p_set_beacons                   CONSTANT INTEGER := 2;
p_create_txn                    CONSTANT INTEGER := 3;
p_modify_txn                    CONSTANT INTEGER := 4;
p_remove_txn                    CONSTANT INTEGER := 5;
p_view_txn                      CONSTANT INTEGER := 6;
p_set_availability              CONSTANT INTEGER := 7;
p_start_txn                     CONSTANT INTEGER := 8;
p_stop_txn                      CONSTANT INTEGER := 9;
p_set_bcn_txn_thresholds        CONSTANT INTEGER := 10;
p_watchlist_operations          CONSTANT INTEGER := 11;
p_region_operations             CONSTANT INTEGER := 12;
p_view_mntr_reports             CONSTANT INTEGER := 13;
p_unlock_tgt                    CONSTANT INTEGER := 14;
p_delete_tgt                    CONSTANT INTEGER := 15;
p_playback_txn                  CONSTANT INTEGER := 16;
p_config_components             CONSTANT INTEGER := 17;

-- Privileges required
p_priv_view_tgt                 CONSTANT INTEGER := 0;
p_priv_op_tgt                   CONSTANT INTEGER := 1;
p_priv_use_bcn_op_tgt           CONSTANT INTEGER := 2;
p_priv_full_tgt                 CONSTANT INTEGER := 3;
p_priv_view_tmpl                CONSTANT INTEGER := 4;
p_priv_full_tmpl                CONSTANT INTEGER := 5;
 
-- Property types
p_string_prop_type              CONSTANT INTEGER := 1;

-- Property Keys
p_schedule_prop_key             CONSTANT VARCHAR2(64) := 'SCHEDULE';

END EMD_BCNTXN;
/
--------------------------------------------------------------------------
show errors;


