Rem drv: <create type="types"/>
Rem
Rem $Header: beacon_types.sql 31-aug-2005.18:28:49 eporter Exp $
Rem
Rem beacon_types.sql
Rem
Rem Copyright (c) 2002, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      beacon_types.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    eporter     08/31/05 - Bug 4582477: Add semicolon to mgmt_bcn_nvpair
Rem    gsbhatia    06/26/05 - New repmgr header impl 
Rem    rmarripa    03/30/05 - add parent to the step 
Rem    rmarripa    03/25/05 - add parent to step 
Rem    gsbhatia    02/13/05 - updating repmgr header 
Rem    gsbhatia    02/09/05 - updating repmgr header 
Rem    gsbhatia    02/07/05 - updating repmgr header 
Rem    andyao      02/01/05 - add API to support num of occurrences 
Rem    mfidanbo    01/18/05 - add is_local to mgmt_bcn 
Rem    ktlaw       01/11/05 - add repmgr header 
Rem    vjraghav    11/22/04 - Adding a template flag to the txn defn 
Rem    mfidanbo    11/19/04 - reduce type length 
Rem    mfidanbo    11/15/04 - add txn,bcn avail states type 
Rem    vjraghav    11/03/04 - Creating a new data type for templatizing 
Rem                           properties 
Rem    vjraghav    11/02/04 - Creating a new data type for templatizing 
Rem                           properties 
Rem    mfidanbo    10/14/04 - get is_avail for a beacon 
Rem    afontana    10/04/04 - add version to mgmt_bcn 
Rem    vjraghav    10/07/04 - Changing the datatype of txn/step/stepgroup type 
Rem    mfidanbo    09/19/04 - 
Rem    vjraghav    09/13/04 - Defining a new type to store composite keys with 
Rem                           their key parts 
Rem    rmarripa    08/30/04 - add associate beacons procedure for create 
Rem                           service 
Rem    vjraghav    06/25/04 - Rel2 changes to transaction definitions and 
Rem                           properties 
Rem    snakai      04/20/03 - increase size of postadata to 32k
Rem    asawant     09/27/02 - Changing time zone offset to time zone string
Rem    skini       07/11/02 - Change in size of target name
Rem    rpinnama    05/14/02 - rpinnama_reorg_rep_scripts
Rem    rpinnama    05/14/02 - Created
Rem

CREATE OR REPLACE TYPE mgmt_bcn_guid_array AS 
       TABLE OF VARCHAR2(32);
/

CREATE OR REPLACE TYPE mgmt_bcn_name_array AS 
       TABLE OF VARCHAR2(64);
/

CREATE OR REPLACE TYPE mgmt_bcn_raw_guid_array AS 
       TABLE OF RAW(16);
/

CREATE OR REPLACE TYPE mgmt_bcn AS OBJECT
  (
     bcn_guid              VARCHAR2(32),
     bcn_target_name       VARCHAR2(256),
     bcn_target_type       VARCHAR2(64),
     bcn_emd_url           VARCHAR2(2000),
     bcn_version           VARCHAR2(8),
     bcn_is_avail          CHAR(1),
     bcn_is_local          CHAR(1)
  );
/

CREATE OR REPLACE TYPE mgmt_bcn_array AS 
        TABLE OF mgmt_bcn;
/

CREATE OR REPLACE TYPE mgmt_bcn_detail AS OBJECT
  (
     bcn_guid              VARCHAR2(32),
     bcn_target_name       VARCHAR2(256),
     bcn_target_type       VARCHAR2(64),
     bcn_emd_url           VARCHAR2(2000),
     txn_guid              VARCHAR2(32),
     schedule              NUMBER
  );
/

CREATE OR REPLACE TYPE mgmt_bcn_detail_array AS 
        TABLE OF mgmt_bcn_detail;
/

CREATE OR REPLACE TYPE mgmt_bcn_txn_sync AS OBJECT
  (
     txn_guid               VARCHAR2(32),
     txn_name               VARCHAR2(64),
     txn_state              VARCHAR2(8),
     is_insync              VARCHAR2(1),
     is_rep                 VARCHAR2(1)
  );
/

CREATE OR REPLACE TYPE mgmt_bcn_txn_sync_array AS 
        TABLE OF mgmt_bcn_txn_sync;
/

CREATE OR REPLACE TYPE mgmt_bcn_sync AS OBJECT
  (
     bcn_guid               VARCHAR2(32),
     bcn_name               VARCHAR2(64),
     is_removing            VARCHAR2(1),
     is_insync              VARCHAR2(1),
     host_status            NUMBER,
     in_avail               VARCHAR2(1)
  );
/

CREATE OR REPLACE TYPE mgmt_bcn_sync_array AS 
        TABLE OF mgmt_bcn_sync;
/

CREATE OR REPLACE TYPE mgmt_bcn_txn_status AS OBJECT
  (
     bcn_guid               VARCHAR2(32),
     txn_guid               VARCHAR2(32),
     is_monitoring          CHAR(1),
     version                NUMBER,
     attempt_status         CHAR(1),
     attempt_desc           VARCHAR2(1000)
  );
/

CREATE OR REPLACE TYPE mgmt_bcn_txn_status_array AS 
       TABLE OF mgmt_bcn_txn_status;
/

 
--  New types in Grid Control 10g Release 2.

--  Types for properties and property names

CREATE OR REPLACE TYPE mgmt_bcn_nvpair AS OBJECT 
(
    name                    VARCHAR2(64),
    string_part             NUMBER,
    string_value            VARCHAR2(3936),
    num_value               NUMBER,
    date_value              DATE,
    char_value              CHAR(1),
    prop_type               NUMBER,
    encrypt                 CHAR(1),
    template                CHAR(1)
);
/
CREATE OR REPLACE TYPE mgmt_bcn_nvpair_array AS
        TABLE OF mgmt_bcn_nvpair;
/
CREATE OR REPLACE TYPE mgmt_bcn_pnames_array AS
        TABLE OF VARCHAR2(64);
/        

-- Types for per-beacon properties and property names

CREATE OR REPLACE TYPE mgmt_bcn_perbcn_nvpair AS OBJECT
(        
    bcn_guid                VARCHAR2(32),
    nvpairlist              mgmt_bcn_nvpair_array
);
/   
CREATE OR REPLACE TYPE mgmt_bcn_perbcn_nvpair_array AS
        TABLE OF mgmt_bcn_perbcn_nvpair;
/      
CREATE OR REPLACE TYPE mgmt_bcn_perbcn_pnames AS OBJECT 
(        
    bcn_guid                VARCHAR2(32),
    propnames               mgmt_bcn_pnames_array
);
/   
CREATE OR REPLACE TYPE mgmt_bcn_perbcn_pnames_array AS
        TABLE OF mgmt_bcn_perbcn_pnames;
/

-- Types for thresholds
CREATE OR REPLACE TYPE mgmt_bcn_threshold_key AS OBJECT 
(
    bcn_guid                VARCHAR2(64),
    txn_guid                VARCHAR2(64),
    key_part_3              VARCHAR2(64),
    key_part_4              VARCHAR2(64),
    key_part_5              VARCHAR2(64),
    metric_name             VARCHAR2(64),
    metric_column           VARCHAR2(64)
);
/
CREATE OR REPLACE TYPE mgmt_bcn_threshold_key_array AS
        TABLE OF mgmt_bcn_threshold_key;
/        
CREATE OR REPLACE TYPE mgmt_bcn_threshold AS OBJECT 
(
    key                     mgmt_bcn_threshold_key,
    warning_threshold       VARCHAR2(256),
    warning_operator        NUMBER,
    critical_threshold      VARCHAR2(256),
    critical_operator       NUMBER,
    num_occurences          NUMBER
);
/
CREATE OR REPLACE TYPE mgmt_bcn_threshold_array AS
        TABLE OF mgmt_bcn_threshold;
/

-- Transaction definition
CREATE OR REPLACE TYPE mgmt_bcn_txn AS OBJECT 
(
    txn_guid                VARCHAR2(32),
    txn_type                VARCHAR2(64),
    name                    VARCHAR2(64),
    description             VARCHAR2(2000),
    is_representative       CHAR(1),
    version                 NUMBER,
    tgt_tz                  VARCHAR2(64),
    template                CHAR(1)
);
/
CREATE OR REPLACE TYPE mgmt_bcn_txn_with_props AS OBJECT 
(
    txn_defn                mgmt_bcn_txn,
    txn_props               mgmt_bcn_nvpair_array,
    bcn_txn_props           mgmt_bcn_perbcn_nvpair_array
);
/
CREATE OR REPLACE TYPE mgmt_bcn_txnid_array AS
        TABLE OF VARCHAR2(32);
/        
-- Step definition
CREATE OR REPLACE TYPE mgmt_bcn_step AS OBJECT 
(
    step_guid               VARCHAR2(32),
    step_number             NUMBER,
    name                    VARCHAR2(64),
    step_type               VARCHAR2(64),
    parent_step_guid        VARCHAR2(32),
    parent_step_name        VARCHAR2(64)
   
);
/
CREATE OR REPLACE TYPE mgmt_bcn_step_array AS
        TABLE OF mgmt_bcn_step;
/       
CREATE OR REPLACE TYPE mgmt_bcn_step_with_props AS OBJECT 
(
    step_defn               mgmt_bcn_step,
    step_props              mgmt_bcn_nvpair_array
);
/    
CREATE OR REPLACE TYPE mgmt_bcn_step_with_props_array AS
        TABLE OF mgmt_bcn_step_with_props;
/

-- Step Group Definition
CREATE OR REPLACE TYPE mgmt_bcn_stepid_array AS
        TABLE OF VARCHAR2(64);
/        
CREATE OR REPLACE TYPE mgmt_bcn_stepgroup AS OBJECT 
(
    stepgroup_guid          VARCHAR2(32),
    name                    VARCHAR2(64),
    stepgroup_type          VARCHAR2(64),
    steps                   mgmt_bcn_stepid_array
);
/
CREATE OR REPLACE TYPE mgmt_bcn_stepgroup_array AS
        TABLE OF mgmt_bcn_stepgroup;
/        
CREATE OR REPLACE TYPE mgmt_bcn_stepgroupid_array AS
        TABLE OF VARCHAR2(32);
/
CREATE OR REPLACE TYPE mgmt_bcn_transaction AS OBJECT
(
    txn_defn_with_props     mgmt_bcn_txn_with_props,
    steps_defn_with_props   mgmt_bcn_step_with_props_array,
    stepgroups_defn         mgmt_bcn_stepgroup_array,
    txn_thresholds          mgmt_bcn_threshold_array,
    step_thresholds         mgmt_bcn_threshold_array,
    stepgroup_thresholds    mgmt_bcn_threshold_array
);
/
CREATE OR REPLACE TYPE mgmt_bcn_transaction_array AS
        TABLE OF mgmt_bcn_transaction;
/        
CREATE OR REPLACE TYPE mgmt_bcn_assoc AS OBJECT
(
    bcn_target_name       VARCHAR2(256),
    bcn_target_type       VARCHAR2(64),
    bcn_is_avail          CHAR(1), 
    bcn_is_local          CHAR(1)
);
/
CREATE OR REPLACE TYPE mgmt_bcn_assoc_array AS
        TABLE OF mgmt_bcn_assoc;
/
CREATE OR REPLACE TYPE mgmt_bcn_composite_key AS OBJECT 
(
    bcn_guid                VARCHAR2(64),
    txn_guid                VARCHAR2(64),
    step_group_guid         VARCHAR2(64),
    composite_key           RAW(16)
);
/
CREATE OR REPLACE TYPE mgmt_bcn_composite_key_array AS
        TABLE OF mgmt_bcn_composite_key;
/
CREATE OR REPLACE TYPE MgmtBcnAvailRowType AS OBJECT
    (target_guid                RAW(16),
     severity_guid              RAW(16),
     current_status             NUMBER,
     start_collection_timestamp DATE,
     end_collection_timestamp   DATE);
/
CREATE OR REPLACE TYPE MgmtBcnAvailTableType AS TABLE OF MgmtBcnAvailRowType;
/
CREATE OR REPLACE TYPE mgmt_bcn_txn_avail AS OBJECT
(
    bcn_guid  RAW(16),
    test_guid RAW(16),
    avail_states MgmtBcnAvailTableType
);
/
CREATE OR REPLACE TYPE mgmt_bcn_txn_avail_array AS
         TABLE OF mgmt_bcn_txn_avail;
/
