Rem drv: <create type="post_creation" pos="chronos/chronos_post_creation.sql-"/>
Rem
Rem $Header: blackout_post_creation.sql 27-dec-2007.02:13:10 smudumba Exp $
Rem
Rem blackout_post_creation.sql
Rem
Rem Copyright (c) 2002, 2007, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      blackout_post_creation.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    smudumba    12/27/07 - Blackout Reasons NLS
Rem    skini       09/01/05 - Add 102020 init 
Rem    gsbhatia    07/03/05 - New repmgr header impl 
Rem    rpinnama    05/12/05 - Move user callback registration to v102010/blackout_post_creation.sql
Rem    paachary    03/04/05 - Moved the post creation scripts for adding blackout reasons to the migration path.
Rem                           emcore/source/oracle/sysman/emdrep/core/v102010/blackout_post_creation.sql
Rem    rzazueta    02/04/05 - Enable grant_priv callback 
Rem    ramalhot    01/25/05 - ASSOC_DEF_MEMBER-->ASSOC_DEF_CONTAINS
Rem    rzazueta    01/12/05 - Add assoc callbacks 
Rem    ktlaw       01/11/05 - add repmgr header 
Rem    ssukavan    01/05/05 - Added Predefined Blackout Reasons 
Rem    vkgarg      10/14/04 - remove add default reason script 
Rem    mbhalla     10/07/04 - Adding Do Not Delete Reason. 
Rem    kmanicka    09/21/04 - add user model callbacks
Rem    rpinnama    09/08/03 - Add purge policy for blackout state 
Rem    rpatti      03/10/03 - fix deletion support
Rem    rpatti      02/26/03 - add target del callback
Rem    skini       11/19/02 - Register only revoke_priv_callback
Rem    rpinnama    10/14/02 - Use log registration API
Rem    skini       10/03/02 - Register user model callbacks
Rem    skini       07/23/02 - Add performance info
Rem    rpatti      07/18/02 - rpatti_blackouts_4
Rem    rpatti      07/18/02 - Created
Rem


-- target deletion will not delete target guid info from blackout tables
-- we need to do some associated cleanup - so we do that ourselves
INSERT INTO MGMT_TARGET_DELETE_EXCEPTIONS
             (table_name)
           VALUES
             ('MGMT_BLACKOUT_TARGET_DETAILS');

INSERT INTO MGMT_TARGET_DELETE_EXCEPTIONS
             (table_name)
           VALUES
             ('MGMT_BLACKOUT_FLAT_TARGETS');


-- Insert a performance entry for the blackout subsystem
BEGIN
  mgmt_log.register_logging_module(MGMT_BLACKOUT_ENGINE.MODULE_NAME, 'Blackouts');

END;
/

BEGIN

  EM_PURGE.add_purge_policy('MGMT_BLACKOUT_STATE',
                            EM_PURGE.G_POLICY_TYPE_TARGET,
                            'MGMT_BLACKOUT_ENGINE.BLACKOUT_STATE_PURGE',
                            0,
                            NULL, -- No rollup procedure
                            'Purge policy for Blackout state.',
                            EM_PURGE.G_RETENTION_GROUP_ALERTS,
                            EM_PURGE.G_POLICY_EXEC_GROUP_DEFAULT,
                            EM_PURGE.G_POLICY_NOT_CONFIGURABLE
                            );

  COMMIT;
END;
/

Rem Calling the script in the migration path for adding reasons and registering callbacks

@&EM_SQL_ROOT/core/v102010/blackout_post_creation.sql
@&EM_SQL_ROOT/core/v102020/blackout/blackout_post_creation.sql
@&EM_SQL_ROOT/core/10.2.0.4/blackout/blackout_post_creation.sql
