Rem drv: <create type="types" pos="jobs/jobs_types.sql+"/>
Rem
Rem $Header: blackout_types.sql 19-sep-2006.05:55:11 kannatar Exp $
Rem
Rem blackout_types.sql
Rem
Rem Copyright (c) 2002, 2006, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      blackout_types.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    sbhagwat    03/23/06 - Retroactive blackout 
Rem    paachary    06/29/05 - Added target_guid and propogate attribute in mgmt_blackout_flat_targets_obj
Rem    paachary    06/27/05 - Added types mgmt_blackout_flat_targets_obj and
Rem                                       mgmt_blackout_flat_tgts_array 
Rem    gsbhatia    06/26/05 - New repmgr header impl 
Rem    gsbhatia    02/13/05 - updating repmgr header 
Rem    gsbhatia    02/09/05 - updating repmgr header 
Rem    gsbhatia    02/07/05 - updating repmgr header 
Rem    ktlaw       01/11/05 - add repmgr header 
Rem    skini       08/30/04 - Add blackout window entry 
Rem    skini       12/12/03 - Provide tzregion support 
Rem    skini       07/11/02 - Change in target name size
Rem    rpatti      06/13/02 - rpatti_blackouts_2
Rem    rpatti      05/28/02 - Created
Rem

CREATE OR REPLACE TYPE MGMT_BLACKOUT_TGT_GUID_ARRAY AS TABLE OF RAW(16);
/

CREATE OR REPLACE TYPE MGMT_BLACKOUT_GUID_ARRAY AS TABLE OF RAW(16);
/

CREATE OR REPLACE TYPE MGMT_BLACKOUT_SCHEDULE_RECORD AS OBJECT 
(
    -- The frequency code for the schedule.
    frequency_code NUMBER,
    
    -- The schedule start time. Use SYSDATE if the job is to start 
    -- immediately. For daily, days of week and days of month schedules, 
    -- the start_time denotes when the job should start. Only the time part 
    -- is used, and the date part is ignored. 
    start_time DATE,

    -- For all periodic schedules, the last date (and time) to run the job. 
    -- For daily, day of week and day of month schedules, only the date 
    -- portion is used. For interval schedules, the time is taken into 
    -- account as well.
    end_time DATE,

    -- The "execution time" for daily, day of week/month/year schedules. 
    -- Indicates the time of the day at which the job will execute. Hours 
    -- are specified in 24-hour format (0 to 23), and minutes is a number 
    -- between 0 and 59. 
    execution_hours NUMBER,
    execution_minutes NUMBER,

    -- The interval, in minutes for interval jobs.
    interval NUMBER,

    -- For days-of-year schedules, this indicates the "month" portion of each
    -- (month, day) pair in the schedule. The "days" portion is specified
    -- using "days", below.
    months MGMT_JOB_INT_ARRAY,

    -- For day of week/month jobs, the day(s) of the week,
    -- or month as the case may be.
    -- For days of week, this is a set of numbers from 1-7 indicating the days
    --    sunday through saturday, in that order.
    -- For days of month, this is a set of numbers from 1-31 indicating the 
    --    date of the month. A special constant called LAST_DAY (-1) 
    --    can be use for day-of-month schedules to indicate the last 
    --    day of the month.
    -- For days of the year, this is a set of numbers from 1-32 
    --    indicating the date of the month. A special constant called 
    --    LAST_DAY (-1) can be used for day-of-year schedules to indicate 
    --    the last day of the month. For day-of-year schedules, the 
    --    corresponding months are taken from the "months" field above 
    days MGMT_JOB_INT_ARRAY,

    -- The blackout duration, in minutes
    duration NUMBER,

    -- Specifies which timezone the start and end times are specified in
    --    TIMEZONE_REPOSITORY: The timezone of the repository
    --    TIMEZONE_SPECIFIED: The timezone offset is specified in the
    --       field timezone_offset
    timezone_info NUMBER,

    -- The actual timezone offset. Relevent only when
    -- timezone_info=TIMEZONE_SPECIFIED
    timezone_offset NUMBER,

    -- The actual timezone region. Relevent only when
    -- timezone_info=TIMEZONE_RGN_SPECIFIED
    timezone_region VARCHAR2(64) 
);
/

CREATE OR REPLACE TYPE MGMT_BLACKOUT_TARGET_RECORD AS OBJECT
(
    -- The target name and type
    target_name VARCHAR2(256),
    target_type VARCHAR2(128),

    -- True (1) if the blackout must be propogated to the target's
    -- members. Valid only for composite targets, groups and hosts
    include_members NUMBER
);
/

CREATE OR REPLACE TYPE MGMT_BLACKOUT_TARGET_LIST AS TABLE OF MGMT_BLACKOUT_TARGET_RECORD;
/

CREATE OR REPLACE TYPE MGMT_BLACKOUT_WINDOW_RECORD AS OBJECT
(
    -- The blackout guid
    blackout_guid RAW(16),
    occurrence_number NUMBER,
    start_time DATE,
    end_time DATE,
    status NUMBER
);
/

CREATE OR REPLACE TYPE MGMT_BLACKOUT_WINDOW_ARRAY AS TABLE OF MGMT_BLACKOUT_WINDOW_RECORD;
/

CREATE OR REPLACE TYPE mgmt_blackout_flat_targets_obj AS OBJECT 
(
    display_name          VARCHAR2(256), 
    target_name           VARCHAR2(256),
    target_type           VARCHAR2(64), 
    type_display_name     VARCHAR2(64), 
    timezone_delta        NUMBER,
    timezone_region       VARCHAR2(64), 
    composite_target_name VARCHAR2(256), 
    composite_target_type VARCHAR2(256),
    hierarchy_level       NUMBER,
    target_guid           VARCHAR2(64),
    propogate             VARCHAR2(64)
);
/

CREATE OR REPLACE TYPE mgmt_blackout_flat_tgts_array AS TABLE OF mgmt_blackout_flat_targets_obj;
/

@&EM_SQL_ROOT/core/10.2.0.3/blackout/blackout_types.sql
