Rem
Rem $Header: emcore/source/oracle/sysman/emdrep/sql/core/latest/blackout/blackout_ui_pkgbody.sql /st_emcore_10.2.0.4.2db11.2/1 2009/03/18 02:29:02 bram Exp $
Rem
Rem blackout_ui_pkgbody.sql
Rem
Rem Copyright (c) 2002, 2009, Oracle and/or its affiliates.
Rem All rights reserved. 
Rem
Rem    NAME
Rem      blackout_ui_pkgbody.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY) 
Rem       bram     10/03/09 - Perf Fixes
Rem    smudumba    12/27/07 - Blackout Reasons NLS
Rem    paachary    07/27/07 - Fixing bug 6193423
Rem    kannatar    09/20/06  - 
Rem    sbhagwat    09/19/06  - Retroactive blackout 
Rem    paachary    07/07/06  - Backport paachary_bug-4873855 from main 
Rem    paachary    01/23/06  - Bug 4873855: BLACKOUTS NUMBER ARE SHOWN LESS IN 
Rem                            SUBMITTED TO ANY MEMBER COLUMN 
Rem    bram        08/03/05  - Bug-452074-(PERF:/ADMIN/REP/BLACKOUT/BLACKOUTSMAIN-FROM=SIDENAV
Rem    ssukavan    07/28/05  - Bug 4522611 use decode for schedule_time in active querry
Rem    ssukavan    07/14/05  - use hextoraw 
Rem    paachary    06/29/05  - Bug 4447116 (PERF: PAGE TIMING VIOLATION /ADMIN/REP/BLACKOUT/BLACKOUTVIEW)
Rem    pratagar    06/25/05  - Type Display Name
Rem    paachary    06/27/05  - Bug 4381215 (PERF: BLACKOUT CONFIG PAGE TAKES LONG TO COME UP)
Rem    ssukavan    06/13/05  - Fix Nested Groups displayed twice in Future view
Rem    ssukavan    06/03/05  - Fix Bug#4340577 Unable to stop a blackout from target home page
Rem    paachary    05/19/05  - MAde changes to the SQL queries to enhance performance.
Rem    vkgarg      03/31/05  - update get_blackout_details for view mode 
Rem    ssukavan    03/28/05  - Bug 4267409 Full Blackout is not Shown for 
Rem                            Redundancy Group in Main Page
Rem    ssukavan    03/21/05 -  added get_targets_full_blackout 
Rem    vkgarg      03/08/05 - update timezone for future/active view 
Rem    ssukavan    03/01/05 - Search with Parent should list all occurances of 
Rem                           its members in Blackout 
Rem    bram        02/27/05 - Wildcard Search
Rem    dcawley     02/21/05 - Replace enter super user mode 
Rem    ssukavan    02/18/05 - Sort by creator for Future/All views
Rem    ssukavan    02/15/05 - Fetch flat targets for host blackout
Rem    ssukavan    02/10/05 - Future and All views with search show
Rem                           show all Targets including No Operator Priv 
Rem    ssukavan    02/10/05 - update search sql 
Rem    ssukavan    02/10/05 - BlackoutsMain Future and All views show all 
Rem                           scheduled Targets including No Operator Priv 
Rem    ssukavan    01/21/05 - add timezone regn to start date 
Rem    ramalhot    01/17/05 - g_member_guid->g_contains_guid
Rem    ssukavan    01/03/05 - Added a new function get_targets_oper_priv 
Rem    ssukavan    12/30/04 - modified get_flat_targets_host
Rem    vkgarg      12/20/04 - support timezone region inplace of delta 
Rem    mbhalla     11/25/04 - Add procedure to identify Active Blackouts for a 
Rem                           Target.
Rem    dcawley     11/09/04 - Fix query on priv grants
Rem    mbhalla     10/26/04 - Sort on Target Names.
Rem    vkgarg      10/26/04 - update get_parent_target_types
Rem    vkgarg      10/25/04 - add get_parent_target_types
Rem    vkgarg      10/21/04 - moving reasons procs to mgmt_blackout_ui pkg
Rem    vkgarg      10/19/04 - add check_priv_on_group
Rem    vkgarg      10/14/04 - add outer join to fetch balckout with no reason
Rem    mbhalla     10/05/04 - grabtrans 'vkgarg_botrans'
Rem    ramalhot    08/30/04 - cutover to new assoc tables
Rem    rzazueta    07/21/04 - Fix 2819028
Rem    dcawley     07/07/04 - Increase user name size
Rem    rpatti      11/13/03 - perf fix bug 3250871
Rem    rpatti      09/11/03 - support active/history views
Rem    rpatti      09/05/03 - support duration_source
Rem    rpatti      08/19/03 - remove direct blackout of agents
Rem    rpatti      07/25/03 - fix navigation issues
Rem    skini       07/21/03 - Fix UI bug with order by
Rem    rpatti      07/16/03 - change target blackouts query
Rem    rpatti      06/30/03 - use created_thru
Rem    rpatti      03/14/03 - use correct err codes
Rem    rpatti      06/18/03 - update for recurring blackouts
Rem    rpatti      05/05/03 - sort reasons
Rem    rpatti      02/26/03 - fix for target deletions
Rem    skini       01/17/03 - Allow agent-side bos to be deleted
Rem    dcawley     12/20/02 - Changes MGMT_PRIV_GRANTS query
Rem    dcawley     12/20/02 - Fix user model queries
Rem    dcawley     12/10/02 - Column renamed to guid
Rem    rpatti      12/04/02 - support job flag in view
Rem    skini       12/03/02 - Introduce modificationFailed, and
Rem                              partialModifyFailed states
Rem    rpatti      10/25/02 - use const for def reason
Rem    rpatti      10/21/02 - update
Rem    skini       10/04/02 - Code review comments
Rem    rpatti      08/29/02 - continue
Rem    rpatti      08/16/02 - fix the priv checks
Rem    tjaiswal    08/05/02 - Use new api for get targets
Rem    rpatti      08/01/02 - continue
Rem    rpatti      07/31/02 - rpatti_blackouts_4
Rem    rpatti      07/31/02 - changes to schedule table
Rem    rpatti      07/25/02 - continue
Rem    rpatti      07/19/02 - continue
Rem    rpatti      07/17/02 - rename packages
Rem    rpatti      06/13/02 - rpatti_blackouts_2
Rem    rpatti      05/28/02 - Created
Rem

CREATE OR REPLACE PACKAGE BODY mgmt_blackout_ui AS

-- PURPOSE:
--   Returns a list of target types that the user has priv on
--     and that are not composite target types..
FUNCTION get_target_types
RETURN CURSOR_TYPE
IS
  l_type_cursor CURSOR_TYPE;

BEGIN
  -- Get the types that the user have operator privilege on
  l_type_cursor := mgmt_user.get_target_types(mgmt_user.OPERATOR_TARGET);
  RETURN l_type_cursor;

END;

--
-- PURPOSE:
--
--  To get the list of parent target types
--
--
-- RETURNS:
--  TYPES_CURSOR: CURSOR_TYPE
--    A cursor which returns rows containing the target type
--    related information: target_type, type_display_name
--
-- ERROR codes:
--  None.
--
FUNCTION get_parent_target_types
RETURN CURSOR_TYPE
IS
  types_cursor_out CURSOR_TYPE;

BEGIN

    OPEN types_cursor_out FOR
    SELECT target_type
      FROM mgmt_type_properties  
     WHERE property_value='1'
       AND property_name=MGMT_GLOBAL.g_is_aggregate_prop
       AND target_type IN (
                             SELECT DISTINCT target_type 
                               FROM mgmt_targets
                          );
  -- return the cursor
  RETURN types_cursor_out;

END get_parent_target_types;

-- Get the blackout guid and current status
-- for the specified blackout
PROCEDURE get_blackout_guid(p_blackout_name VARCHAR2,
                            p_created_by    VARCHAR2,
                            p_created_thru  VARCHAR2,
                            p_blackout_guid_out OUT RAW,
                            p_blackout_status_out OUT NUMBER) IS
BEGIN
    IF p_created_thru IS NULL
    THEN
      SELECT blackout_guid, blackout_status
          INTO p_blackout_guid_out, p_blackout_status_out
           FROM mgmt_blackouts
            WHERE blackout_name = p_blackout_name AND
              created_by = p_created_by;
    ELSE
      SELECT blackout_guid, blackout_status
          INTO p_blackout_guid_out, p_blackout_status_out
           FROM mgmt_blackouts
            WHERE blackout_name = p_blackout_name AND
              created_by = p_created_by AND
              created_thru = p_created_thru;
    END IF;

    EXCEPTION
    WHEN NO_DATA_FOUND THEN
        RAISE MGMT_GLOBAL.blackout_not_exist;
END;

-- PURPOSE:
--   Returns a list of targets that user is able to perform blackouts
--   This is used in individual target blackout
-- IN PARAMETERS:
--   targetType: target type that user can specified that the return
--   list contains targets in targetType
--
-- OUT PARAMETER;
--   tgtList: CURSOR type which contains target name, target type and target guid

PROCEDURE get_blackout_targets
          (p_target_type IN VARCHAR2,
           p_blackout_tgtList OUT CURSOR_TYPE)
IS
  l_unused_list SMP_EMD_STRING_ARRAY;
  l_unused_list2 SMP_EMD_STRING_ARRAY;
  l_current_user mgmt_priv_grants.grantee%type := MGMT_USER.get_current_em_user();

BEGIN
  -- if the user is a super user we just need to get all the blackouts
  IF mgmt_user.has_priv(l_current_user,
                        mgmt_user.SUPER_USER) = mgmt_user.USER_HAS_PRIV
  THEN
    IF (p_target_type = 'all_types')
    THEN
      OPEN p_blackout_tgtList FOR
        SELECT target_name AS display_name, target_name,
               type_display_name, target_type, timezone_delta, timezone_region
          FROM mgmt_targets
         ORDER BY target_type, target_name;
    ELSE
      OPEN p_blackout_tgtList FOR
        SELECT target_name AS display_name, target_name,
               type_display_name, target_type, timezone_delta, timezone_region
          FROM mgmt_targets
         WHERE target_type = p_target_type
         ORDER BY target_type, target_name;
    END IF;
  ELSE
    IF (p_target_type = 'all_types')
    THEN
      -- Get the targets that the user have operator privilege on
      p_blackout_tgtList := mgmt_user.get_targets('', mgmt_user.OPERATOR_TARGET);
    ELSE
      -- Get the targets that the user have operator privilege on
      p_blackout_tgtList := mgmt_user.get_targets(p_target_type, mgmt_user.OPERATOR_TARGET);
    END IF;

  END IF;
END;

--
-- PROCEDURE: get_blackouts
--
PROCEDURE get_blackouts
(
    blk_type IN NUMBER,
    lists_out OUT CURSOR_TYPE
)
IS
  l_current_user mgmt_priv_grants.grantee%TYPE := MGMT_USER.get_current_em_user();
BEGIN
    IF (blk_type = mgmt_blackout_ui.ALL_BLACKOUTS) THEN --All Blackouts
        OPEN lists_out FOR
        SELECT DISTINCT b.blackout_name, p.reason, b.created_thru,
               b.created_by, b.last_updated_by, s.timezone_offset, s.timezone_region,
               s.start_time, s.duration, s.duration_source, s.end_time,
               b.blackout_status, b.last_end_time,
               b.scheduled_time, s.interval, s.frequency_code,
               b.blackout_desc
          FROM mgmt_blackouts b, mgmt_blackout_reason p,
               mgmt_blackout_schedule s, mgmt_blackout_flat_targets bft,
	       mgmt_targets mt
         WHERE
               b.reason_id = p.reason_id (+) AND
               bft.blackout_guid=b.blackout_guid AND
               b.blackout_guid = s.blackout_guid AND
               bft.target_guid = mt.target_guid
         ORDER BY b.scheduled_time DESC;
    ELSIF (blk_type = mgmt_blackout_ui.ACTIVE_BLACKOUTS) THEN --Active Blackouts
        OPEN lists_out FOR
        SELECT DISTINCT b.blackout_name, p.reason, b.created_thru,
               b.created_by, b.last_updated_by, s.timezone_offset, s.timezone_region,
               s.start_time, s.duration, s.duration_source, s.end_time,
               b.blackout_status, b.last_end_time,
               b.scheduled_time, s.interval, s.frequency_code,
               b.blackout_desc
          FROM mgmt_blackouts b, mgmt_blackout_reason p,
               mgmt_blackout_schedule s, mgmt_blackout_flat_targets bft,
	       mgmt_targets mt
         WHERE b.blackout_status NOT IN (mgmt_blackout_engine.BLK_STATE_START_FAILED, 
                                         mgmt_blackout_engine.BLK_STATE_STOPPED, 
                                         mgmt_blackout_engine.BLK_STATE_ENDED) AND
               DECODE(b.scheduled_time, null, b.last_start_time, b.scheduled_time) <= 
               mgmt_blackout_engine.to_blackout_time(SYSDATE, s.timezone_info, s.timezone_offset, s.timezone_region) AND
               b.reason_id = p.reason_id (+) AND
               s.blackout_guid = b.blackout_guid AND
               bft.blackout_guid=b.blackout_guid AND
               bft.target_guid  = mt.target_guid
         ORDER BY b.scheduled_time DESC;
    ELSIF (blk_type = mgmt_blackout_ui.FUTURE_BLACKOUTS) THEN --Future Blackouts
        OPEN lists_out FOR
        SELECT DISTINCT b.blackout_name, p.reason, b.created_thru,
               b.created_by, b.last_updated_by, s.timezone_offset, s.timezone_region,
               s.start_time, s.duration, s.duration_source, s.end_time,
               b.blackout_status, b.last_end_time,
               b.scheduled_time, s.interval, s.frequency_code,
               b.blackout_desc
          FROM mgmt_blackouts b, mgmt_blackout_reason p,
               mgmt_blackout_schedule s, mgmt_blackout_flat_targets bft,
	       mgmt_targets mt
         WHERE b.blackout_status NOT IN (mgmt_blackout_engine.BLK_STATE_START_FAILED, 
                                         mgmt_blackout_engine.BLK_STATE_STOPPED, 
                                         mgmt_blackout_engine.BLK_STATE_ENDED) AND
               b.scheduled_time > 
               mgmt_blackout_engine.to_blackout_time(SYSDATE, s.timezone_info, s.timezone_offset, s.timezone_region) AND
               b.reason_id = p.reason_id (+) AND
               s.blackout_guid = b.blackout_guid AND
               bft.blackout_guid=b.blackout_guid AND
               bft.target_guid  = mt.target_guid
         ORDER BY b.scheduled_time DESC;
    ELSE  -- History Blackouts
        OPEN lists_out FOR
        SELECT DISTINCT b.blackout_name, p.reason, b.created_thru,
               b.created_by, b.last_updated_by, s.timezone_offset, s.timezone_region,
               s.start_time, s.duration, s.duration_source, s.end_time,
               b.blackout_status, b.last_end_time,
               b.scheduled_time, s.interval, s.frequency_code,
               b.blackout_desc
          FROM mgmt_blackouts b, mgmt_blackout_reason p,
               mgmt_blackout_schedule s, mgmt_blackout_flat_targets bft
         WHERE b.blackout_status IN (mgmt_blackout_engine.BLK_STATE_START_FAILED, 
                                     mgmt_blackout_engine.BLK_STATE_STOPPED, 
                                     mgmt_blackout_engine.BLK_STATE_ENDED) AND
               b.reason_id = p.reason_id (+) AND
               s.blackout_guid = b.blackout_guid AND
               bft.blackout_guid=b.blackout_guid AND
               bft.target_guid IN  -- Restrict Blackouts to include Targets the User has atleast VIEW privilege
               (
                  SELECT target_guid
                    FROM mgmt_targets
               )
         ORDER BY b.scheduled_time DESC;
    END IF; -- (blk_type = mgmt_blackout_ui.ALL_BLACKOUTS)
END get_blackouts;


FUNCTION get_blackout_reasons
RETURN CURSOR_TYPE
IS
  l_blackout_reasons CURSOR_TYPE;

BEGIN
  OPEN l_blackout_reasons FOR
     SELECT reason,reason_nls_id
       FROM mgmt_blackout_reason
      WHERE reason <> 'Added via emctl utility'
      ORDER BY reason;
  RETURN l_blackout_reasons;

END get_blackout_reasons;

--
-- PURPOSE:
--   This procedure returns the complete list of targets on the hosts.
--
PROCEDURE get_flat_targets_host
  (p_blk_host_targets    IN SMP_EMD_NVPAIR_ARRAY,
   p_targets_on_hosts    OUT CURSOR_TYPE
  )
IS

  l_current_user mgmt_priv_grants.grantee%type := MGMT_USER.get_current_em_user();
  l_blk_hosts    SMP_EMD_NVPAIR_ARRAY := SMP_EMD_NVPAIR_ARRAY();
BEGIN

  IF p_blk_host_targets IS NOT NULL AND
     p_blk_host_targets.COUNT > 0
  THEN
    -- get the host name and emd_url for all host targets in the list
    SELECT /*+ CARDINALITY(hosts 10)*/ SMP_EMD_NVPAIR(target_name , emd_url)
      BULK COLLECT INTO l_blk_hosts
      FROM mgmt_targets t,
           TABLE(CAST(p_blk_host_targets AS SMP_EMD_NVPAIR_ARRAY)) hosts
     WHERE hosts.value = mgmt_global.G_HOST_TARGET_TYPE AND
           hosts.value = t.target_type AND
           hosts.name = t.target_name;

    -- we just need to get all the targets
    -- that share the same emd url - no checking required

    OPEN p_targets_on_hosts FOR
      SELECT /*+ CARDINALITY(hosts 10)*/ tgt.target_name AS display_name, tgt.target_name, tgt.target_type,
             tgt.type_display_name, tgt.timezone_delta, tgt.timezone_region,
             hosts.name AS host_target_name
        FROM mgmt_targets tgt,
             TABLE(CAST(l_blk_hosts AS SMP_EMD_NVPAIR_ARRAY)) hosts
       WHERE tgt.emd_url = hosts.value AND
             tgt.target_type != mgmt_global.G_HOST_TARGET_TYPE
      ORDER BY host_target_name, type_display_name, display_name;


  ELSE -- return a empty cursor


    OPEN p_targets_on_hosts FOR
      SELECT 1 AS display_name, 1 AS target_name, 1 AS target_type,
             1 AS type_display_name, 1 AS timezone_delta, 1 AS timezone_region,
             1 AS host_target_name 
        FROM dual
       WHERE ROWNUM < 1;

  END IF;
END get_flat_targets_host;    

--
-- Name : get_flattened_targets
-- PURPOSE:
--   This procedure returns the flattened targets for a set of targets
--   selected. If one of the targets is group - it gets the flattened list of
--   targets.
--   This procedure returns an array containing information of flattenend targets 
--   of members of the targets.

--   The query has been rewritten to optimize performance for returning a single group hierarchy.  
--   Retrieving the completely populated (N-level) group hierarchy for more than one root target 
--   in a single SQL execution results in a very poor execution plan from the Oracle CBO at scale. 
--   But retrieving the same data for a single group is very efficient. 
--   So, results are fetched for the target guids one at a time and an array is populated.
--   Finally, this array is returned to the front end.

PROCEDURE get_flattened_targets
  (p_sel_targets              IN SMP_EMD_NVPAIR_ARRAY,
   p_blkout_flat_tgt_array    OUT MGMT_BLACKOUT_FLAT_TGTS_ARRAY
  )
IS
    l_blk_target_guids   MGMT_GUID_ARRAY := MGMT_GUID_ARRAY();
    p_record_count       NUMBER DEFAULT 0;
    TYPE ref_cursor IS REF CURSOR;
    p_blkout_flat_tgt_cursor ref_cursor;

BEGIN
    IF p_sel_targets IS NOT NULL AND
       p_sel_targets.count > 0
    -- get target guids for only those targets which have member targets
    -- for example groups, web applications, application servers etc.
    THEN
        SELECT MGMT_GUID_OBJ(target_guid , target_type)
        BULK COLLECT INTO l_blk_target_guids
        FROM
            (SELECT DISTINCT t.target_guid target_guid, t.target_type
            FROM mgmt_targets t,
	         mgmt_target_assocs mta,
                 TABLE(CAST(p_sel_targets AS SMP_EMD_NVPAIR_ARRAY)) m
           WHERE t.target_name = m.name AND 
                 t.target_type = m.value AND
                 t.target_guid = mta.source_target_guid AND
                 mta.assoc_guid = MGMT_ASSOC.g_contains_guid
            ) 
        ORDER BY target_guid;
    END IF;

    IF l_blk_target_guids IS NOT NULL AND
       l_blk_target_guids.COUNT > 0
    THEN
        p_blkout_flat_tgt_array := mgmt_blackout_flat_tgts_array();
        p_record_count := 1;
        p_blkout_flat_tgt_array.EXTEND;
        FOR tgtguid IN 1..l_blk_target_guids.COUNT
        LOOP
            OPEN p_blkout_flat_tgt_cursor FOR 
            SELECT 
                MGMT_BLACKOUT_FLAT_TARGETS_OBJ
                    (display_name, 
                     target_name,  
                     target_type, 
                     type_display_name, 
                     timezone_delta,
                     timezone_region, 
                     composite_target_name, 
                     composite_target_type, 
                     hierarchy_level,
                     null,
                     null)
            FROM
                (SELECT DISTINCT tgt.target_name AS display_name, 
                        tgt.target_name AS target_name,
                        tgt.target_type AS target_type, 
                        tgt.type_display_name AS type_display_name, 
                        tgt.timezone_delta AS timezone_delta,
                        tgt.timezone_region AS timezone_region, 
                        mem1.composite_target_name AS composite_target_name, 
                        mem1.composite_target_type AS composite_target_type,
                        DECODE(tgt.target_guid, mem1.composite_target_guid, 
                        DECODE(mem1.h_level, 1, 0, mem1.h_level),mem1.h_level) AS hierarchy_level
                FROM
                    mgmt_targets tgt, 
                    (SELECT t2.target_name as composite_target_name,
                            t2.target_type as composite_target_type,
                            mem2.*
                    FROM
                         mgmt_targets t2,
                         (SELECT /*+ INDEX (assoc) */ assoc.*, level AS h_level 
                         FROM
                           (SELECT source_target_guid AS composite_target_guid,
                                   assoc_target_guid AS member_target_guid FROM MGMT_TARGET_ASSOCS WHERE
                                   assoc_guid = MGMT_ASSOC.g_contains_guid) assoc
                         START WITH assoc.composite_target_guid = HEXTORAW(l_blk_target_guids(tgtguid).guid)
                         CONNECT BY assoc.composite_target_guid=PRIOR assoc.member_target_guid ) mem2
                    WHERE t2.target_guid = mem2.composite_target_guid) mem1
                WHERE
                    tgt.target_guid = mem1.member_target_guid OR
                    tgt.target_guid = mem1.composite_target_guid
                ORDER BY hierarchy_level, type_display_name, display_name);
            LOOP
                FETCH p_blkout_flat_tgt_cursor 
                INTO  p_blkout_flat_tgt_array(p_record_count);
                EXIT WHEN p_blkout_flat_tgt_cursor%NOTFOUND;
                p_record_count := p_record_count + 1;
                p_blkout_flat_tgt_array.EXTEND;
            END LOOP; 
        END LOOP;     
    END IF;
END get_flattened_targets;

PROCEDURE get_blackout_details
   (p_blackout_name        IN  VARCHAR2,
    p_created_by           IN  VARCHAR2,
    p_created_thru         IN  VARCHAR2,
    p_get_hierarchy        IN  NUMBER,
    p_blackout_def         OUT CURSOR_TYPE,
    p_blackout_targets     OUT CURSOR_TYPE,
    p_blackout_state       OUT CURSOR_TYPE,
    p_blackout_history     OUT CURSOR_TYPE
   )
IS
  type ref_cursor is REF CURSOR;
  p_blkout_flat_tgt_cursor ref_cursor;
  l_user_name              VARCHAR2(256) := MGMT_USER.get_current_em_user();
  l_current_user           VARCHAR2(256) := MGMT_USER.get_current_em_user();
  l_blackout_guid          mgmt_blackouts.blackout_guid%TYPE;
  l_reason_id              NUMBER DEFAULT 0;
  l_blk_target_guids       MGMT_BLACKOUT_FLAT_TGTS_ARRAY := MGMT_BLACKOUT_FLAT_TGTS_ARRAY();
  l_blk_flat_target_guids  MGMT_BLACKOUT_FLAT_TGTS_ARRAY := MGMT_BLACKOUT_FLAT_TGTS_ARRAY();
  l_blk_comp_target_guids  MGMT_GUID_ARRAY := MGMT_GUID_ARRAY();
  l_blk_host_targets       SMP_EMD_NVPAIR_ARRAY := SMP_EMD_NVPAIR_ARRAY();
  l_actual_flat_targets    NUMBER := 0;
  l_blackout_status        NUMBER ;
  p_blkout_flat_tgt_array  MGMT_BLACKOUT_FLAT_TGTS_ARRAY := MGMT_BLACKOUT_FLAT_TGTS_ARRAY();
  p_record_count           NUMBER := 0;

BEGIN

  -- is there a created by - if not assume current user
  IF p_created_by IS NOT NULL OR
       ( length(p_created_by) > 0 AND
         length(p_created_by) <= 30 )
  THEN
    l_user_name := p_created_by;
  END IF;

  -- get the blackout guid based on the name
  BEGIN
    IF p_created_thru IS NULL
    THEN
      SELECT blackout_guid, blackout_status
        INTO l_blackout_guid,l_blackout_status
        FROM mgmt_blackouts
       WHERE blackout_name = p_blackout_name AND
             created_by = l_user_name;
    ELSE
      SELECT blackout_guid, blackout_status
        INTO l_blackout_guid,l_blackout_status
        FROM mgmt_blackouts
       WHERE blackout_name = p_blackout_name AND
             created_by = l_user_name AND
             created_thru = p_created_thru;
    END IF;
  EXCEPTION
    WHEN NO_DATA_FOUND
    THEN
      raise mgmt_global.blackout_not_exist;
  END;

  -- now become a super user temporarily so that we can get the
  -- number of targets actually in the blackout
  SETEMUSERCONTEXT(MGMT_USER.GET_REPOSITORY_OWNER, MGMT_USER.OP_SET_IDENTIFIER);

  BEGIN
    -- get the total number of targets involved in blackout
    -- so that we can see if the user has lost privileges on any
    SELECT COUNT(target_guid)
      INTO l_actual_flat_targets
      FROM mgmt_blackout_flat_targets
     WHERE blackout_guid = l_blackout_guid;
  EXCEPTION
    WHEN OTHERS THEN
      l_actual_flat_targets := 0;
  END;

  --- get out of superuser mode
  SETEMUSERCONTEXT(l_current_user, MGMT_USER.OP_SET_IDENTIFIER);

  OPEN p_blackout_def FOR
    SELECT r.reason, b.blackout_desc, b.scheduled_time,
           s.start_time, s.duration, s.duration_source,
           s.end_time, s.timezone_offset, s.timezone_region, b.last_end_time,
           b.blackout_status, b.job_flag, b.occurrence_number,
           l_actual_flat_targets AS actual_num_in_blkout,
           s.interval, s.days, s.months, s.frequency_code,
           b.last_updated_by
      FROM mgmt_blackouts b, mgmt_blackout_reason r, mgmt_blackout_schedule s
     WHERE b.blackout_guid = l_blackout_guid AND
           s.blackout_guid = b.blackout_guid AND
           r.reason_id (+) = b.reason_id;

  -- number of occurrences where applicable
  OPEN p_blackout_history FOR
    SELECT occurrence_number, start_time, end_time
      FROM mgmt_blackout_history
     WHERE blackout_guid = l_blackout_guid
     ORDER BY occurrence_number DESC;

  OPEN p_blackout_state FOR
    SELECT t.target_name AS display_name, t.target_name,
           t.type_display_name, t.target_type,
           t.timezone_delta, t.timezone_region,
           f.blackout_status, f.job_status,
           f.error_message
      FROM mgmt_blackout_flat_targets f, mgmt_targets t
     WHERE f.blackout_guid = l_blackout_guid AND
           f.target_guid = t.target_guid;

  IF p_get_hierarchy = 0
  THEN
    OPEN p_blackout_targets FOR
      SELECT t.target_name AS display_name, t.target_name,
             t.target_type, t.type_display_name,
             t.timezone_delta, t.timezone_region, b.include_members, '' AS composite_target_name,
             '' AS composite_target_type, 0 AS hierarchy_level
       FROM mgmt_targets t, mgmt_blackout_target_details b
      WHERE b.blackout_guid = l_blackout_guid AND
            b.target_guid = t.target_guid;
  ELSE
  -- Getting the targets' information from one single hit to the database rather than quering the mgmt_targets in the 
  -- db again in the cursor expression to get the targets' details.
  SELECT MGMT_BLACKOUT_FLAT_TARGETS_OBJ
                    (target_name,
                    target_name,  
                    target_type, 
                    type_display_name, 
                    timezone_delta,
                    timezone_region, 
                    '', 
                    '', 
                    99,
                    target_guid,
                    'NA')  
   BULK COLLECT INTO l_blk_flat_target_guids
   FROM
   ( 
      SELECT target_guid, 
             target_name AS display_name,
             target_name,
             target_type, 
             type_display_name, 
             timezone_delta,
             timezone_region
      FROM   mgmt_targets
      WHERE  target_guid IN  (SELECT target_guid
                                  FROM mgmt_blackout_flat_targets
                                WHERE blackout_guid=l_blackout_guid)
      MINUS
      ( 
         SELECT  target_guid, 
                 target_name AS display_name,
                 target_name,
                 target_type, 
                 type_display_name, 
                 timezone_delta,
                 timezone_region
         FROM mgmt_targets
         WHERE TARGET_GUID IN (SELECT target_guid
                                   FROM mgmt_blackout_target_details
                                  WHERE blackout_guid=l_blackout_guid)
         UNION
         SELECT  target_guid, 
                 target_name AS display_name,
                 target_name,
                 target_type, 
                 type_display_name, 
                 timezone_delta,
                 timezone_region
         FROM mgmt_targets
         WHERE target_guid in (SELECT assoc_target_guid
                                   FROM mgmt_flat_target_assoc
                                  WHERE source_target_guid in (SELECT target_guid
                                                                 FROM mgmt_blackout_target_details
                                                                WHERE blackout_guid=l_blackout_guid)
                                    AND is_membership =1)
        )
      );  

  -- Getting the targets' information from one single hit to the database rather than quering the mgmt_targets in the 
  -- db again in the cursor expression to get the targets' details.
    SELECT MGMT_BLACKOUT_FLAT_TARGETS_OBJ
                    (target_name,  
                     target_name ,  
                     target_type, 
                     type_display_name, 
                     timezone_delta,
                     timezone_region, 
                     '', 
                     '', 
                     0,
                     t.target_guid,
                     'NA')
      BULK COLLECT INTO l_blk_target_guids
      FROM mgmt_targets t, mgmt_blackout_target_details b
     WHERE b.blackout_guid = l_blackout_guid AND
           b.target_guid = t.target_guid AND
           b.include_members != 1;

    SELECT MGMT_GUID_OBJ(t.target_guid , t.target_name)
      BULK COLLECT INTO l_blk_comp_target_guids
      FROM mgmt_targets t, mgmt_blackout_target_details b
     WHERE b.blackout_guid = l_blackout_guid AND
           b.include_members = 1 AND
           b.target_guid = t.target_guid AND
           t.target_type <> mgmt_global.G_HOST_TARGET_TYPE;

    -- The query for retrieving the (N-level) group hierarchy for more than one root target 
    -- (by using Connect by clause)has been rewritten to optimize performance for returning a single group hierarchy.  
    -- Retrieving the completely populated (N-level) group hierarchy for more than one root target 
    -- in a single SQL execution results in a very poor execution plan from the Oracle CBO at scale. 
    -- But retrieving the same data for a single group is very efficient. 
    -- So, results are fetched for the target guids one at a time and an array is populated.
    -- This array is then used in the cursor expression.
    p_record_count := 1;
    p_blkout_flat_tgt_array.EXTEND;
    FOR tgtguid IN 1..l_blk_comp_target_guids.COUNT
    LOOP
       OPEN p_blkout_flat_tgt_cursor FOR 
       SELECT MGMT_BLACKOUT_FLAT_TARGETS_OBJ
                    (display_name, 
                     target_name,  
                     target_type, 
                     type_display_name, 
                     timezone_delta,
                     timezone_region, 
                     composite_target_name, 
                     composite_target_type, 
                     hierarchy_level,
                     target_guid,                   
                     propogate)
       FROM
       (
          SELECT DISTINCT tgt.target_name AS display_name,
                 tgt.target_name, 
                 tgt.target_type,
                 tgt.type_display_name, 
                 tgt.timezone_delta, tgt.timezone_region,
                 mem1.composite_target_name, mem1.composite_target_type,
                 DECODE(tgt.target_guid, mem1.composite_target_guid,
                        DECODE(mem1.h_level, 1, 0, mem1.h_level), mem1.h_level) AS hierarchy_level,
                 target_guid,
                 DECODE(tgt.target_guid, mem1.guid, 'YES', 'NO') AS propogate
          FROM
                 mgmt_targets tgt, 
                 (SELECT t2.target_name as composite_target_name,
                         t2.target_type as composite_target_type,
                         mem2.*
                 FROM    mgmt_targets t2,
                         (SELECT /*+ INDEX (assoc) */ assoc.*, 
                                 l_blk_comp_target_guids(tgtguid).guid AS guid,
                                 level AS h_level 
                         FROM
                           (SELECT source_target_guid AS composite_target_guid,
                                   assoc_target_guid AS member_target_guid FROM MGMT_TARGET_ASSOCS WHERE
                                   assoc_guid = MGMT_ASSOC.g_contains_guid) assoc
                         START WITH assoc.composite_target_guid = HEXTORAW(l_blk_comp_target_guids(tgtguid).guid)
                         CONNECT BY assoc.composite_target_guid=PRIOR assoc.member_target_guid ) mem2
                 WHERE t2.target_guid = mem2.composite_target_guid) mem1
          WHERE
                 tgt.target_guid = mem1.member_target_guid OR
                 tgt.target_guid = mem1.composite_target_guid);
      LOOP
         FETCH p_blkout_flat_tgt_cursor 
         INTO  p_blkout_flat_tgt_array(p_record_count);
         EXIT WHEN p_blkout_flat_tgt_cursor%NOTFOUND;
         p_record_count := p_record_count + 1;
         p_blkout_flat_tgt_array.EXTEND;
      END LOOP; 
    END LOOP;     

    IF (p_blkout_flat_tgt_array(p_blkout_flat_tgt_array.LAST).target_name IS NULL)
    THEN
        p_blkout_flat_tgt_array.delete(p_blkout_flat_tgt_array.LAST);
    END IF;

    SELECT SMP_EMD_NVPAIR(t.target_name , t.emd_url)
      BULK COLLECT INTO l_blk_host_targets
      FROM mgmt_targets t, mgmt_blackout_target_details b
     WHERE b.blackout_guid = l_blackout_guid AND
           b.include_members = 1 AND
           b.target_guid = t.target_guid AND
           t.target_type = mgmt_global.G_HOST_TARGET_TYPE;

    IF ((l_blk_flat_target_guids IS NOT NULL AND
         l_blk_flat_target_guids.COUNT > 0) OR
        (l_blk_target_guids IS NOT NULL AND
         l_blk_target_guids.COUNT > 0) OR
        (l_blk_comp_target_guids IS NOT NULL AND
         l_blk_comp_target_guids.COUNT > 0) OR
        (l_blk_host_targets IS NOT NULL AND
         l_blk_host_targets.COUNT > 0))
    THEN
      IF (l_blackout_status = mgmt_blackout_engine.BLK_STATE_START_PENDING)
      THEN
      -- For Scheduled Blackouts Show all targets even not In mgmt_blackout_flat_targets       
        OPEN p_blackout_targets FOR
          SELECT DISTINCT display_name,
                 target_name, target_type, type_display_name,
                 timezone_delta, timezone_region,
                 DECODE(propogate, 'YES', 1, 'NA', 2, 0) AS include_members,
                 composite_target_name, composite_target_type,
                 hierarchy_level
            FROM (
                   SELECT /*+ CARDINALITY(a 10)*/
                        display_name,
                        target_name, 
                        target_type,
                        type_display_name, 
                        timezone_delta, 
                        timezone_region,
                        propogate,
                        composite_target_name, 
                        composite_target_type,
                        hierarchy_level
                   FROM TABLE(CAST(l_blk_target_guids AS MGMT_BLACKOUT_FLAT_TGTS_ARRAY)) a
                   UNION ALL
                   SELECT /*+ CARDINALITY(hosts 10)*/
                        tgt.target_name AS display_name,
                        tgt.target_name, tgt.target_type,
                        tgt.type_display_name, tgt.timezone_delta, tgt.timezone_region,
                        DECODE(tgt.target_type, mgmt_global.G_HOST_TARGET_TYPE, 'YES', 'NO') AS propogate,
                        hosts.name AS composite_target_name,
                        'host' AS composite_target_type,
                        DECODE(tgt.target_type, mgmt_global.G_HOST_TARGET_TYPE, 0, 1) AS hierarchy_level
                     FROM mgmt_targets tgt,
                          TABLE(CAST(l_blk_host_targets AS SMP_EMD_NVPAIR_ARRAY)) hosts
                    WHERE tgt.emd_url = hosts.value
                   UNION ALL
                   SELECT /*+ CARDINALITY(b 10)*/
                        display_name,
                        target_name, 
                        target_type,
                        type_display_name, 
                        timezone_delta, 
                        timezone_region,
                        propogate,
                        composite_target_name, 
                        composite_target_type,
                        hierarchy_level
                   FROM TABLE(CAST(p_blkout_flat_tgt_array AS MGMT_BLACKOUT_FLAT_TGTS_ARRAY)) b
                 )
           ORDER BY hierarchy_level, type_display_name, display_name;
      ELSE
      -- If the status of Blackout is Not Scheduled, then Show only the targets 
      -- available in mgmt_blackout_flat_targets
        OPEN p_blackout_targets FOR
          SELECT DISTINCT display_name,
                 target_name, target_type, type_display_name,
                 timezone_delta, timezone_region,
                 DECODE(propogate, 'YES', 1, 'NA', 2, 0) AS include_members,
                 composite_target_name, composite_target_type,
                 hierarchy_level,outertbl.target_guid
            FROM (
                 SELECT /*+ CARDINALITY(a 10)*/
                        display_name,
                        target_name, 
                        target_type,
                        type_display_name, 
                        timezone_delta, 
                        timezone_region,
                        propogate,
                        composite_target_name, 
                        composite_target_type,
                        hierarchy_level,
                        hextoraw(target_guid) AS target_guid                 
                 FROM TABLE(CAST(l_blk_flat_target_guids AS MGMT_BLACKOUT_FLAT_TGTS_ARRAY)) a
                 UNION ALL
                 SELECT /*+ CARDINALITY(b 10)*/
                        display_name,
                        target_name, 
                        target_type,
                        type_display_name, 
                        timezone_delta, 
                        timezone_region,
                        propogate,
                        composite_target_name, 
                        composite_target_type,
                        hierarchy_level,
                        hextoraw(target_guid)  AS target_guid
                 FROM TABLE(CAST(l_blk_target_guids AS MGMT_BLACKOUT_FLAT_TGTS_ARRAY)) b
                 UNION ALL
                 SELECT /*+ CARDINALITY(hosts 10)*/
                        tgt.target_name AS display_name,
                        tgt.target_name, tgt.target_type,
                        tgt.type_display_name, tgt.timezone_delta, tgt.timezone_region,
                        DECODE(tgt.target_type, mgmt_global.G_HOST_TARGET_TYPE, 'YES', 'NO') AS propogate,
                        hosts.name AS composite_target_name,
                        'host' AS composite_target_type,
                        DECODE(tgt.target_type, mgmt_global.G_HOST_TARGET_TYPE, 0, 1) AS hierarchy_level,
                        hextoraw(target_guid)  AS target_guid
                   FROM mgmt_targets tgt,
                        TABLE(CAST(l_blk_host_targets AS SMP_EMD_NVPAIR_ARRAY)) hosts
                  WHERE tgt.emd_url = hosts.value
                 UNION ALL
                 SELECT /*+ CARDINALITY(c 10)*/
                        display_name,
                        target_name, 
                        target_type,
                        type_display_name, 
                        timezone_delta, 
                        timezone_region,
                        propogate,
                        composite_target_name, 
                        composite_target_type,
                        hierarchy_level,
                        hextoraw(target_guid) AS target_guid
                 FROM TABLE(CAST(p_blkout_flat_tgt_array AS MGMT_BLACKOUT_FLAT_TGTS_ARRAY)) c
                 ) outertbl, 
                 mgmt_blackout_flat_targets bft 
          WHERE  blackout_guid   = HEXTORAW(l_blackout_guid) and
                 bft.target_guid = outertbl.target_guid 
          ORDER BY hierarchy_level, type_display_name, display_name;
      END IF; -- end of Status Check 
    ELSE -- return a empty cursor
      OPEN p_blackout_targets FOR
        SELECT 1 AS display_name, 1 AS target_name, 1 AS target_type,
               1 AS type_display_name, 1 AS timezone_delta, 1 AS timezone_region,
               1 AS composite_target_name, 1 AS composite_target_type,
               1 AS hierarchy_level, 1 AS include_members
          FROM dual
         WHERE ROWNUM < 1;
    END IF;

   END IF;

END get_blackout_details;

--
-- PURPOSE:
--   This procedure returns the timezones based on a set of targets
--     selected. If one of the targets is group - it gets the timezones for the
--     flattened list of targets..
--
PROCEDURE get_blackout_timezones
  (p_blackout_targets    IN SMP_EMD_NVPAIR_ARRAY,
   p_blackout_tzs        OUT CURSOR_TYPE
  )
IS
  l_blk_target_guids MGMT_GUID_ARRAY := MGMT_GUID_ARRAY();
BEGIN
      -- get target guids for member targets
      -- TODO: throw exception when a member target is not found..
      IF p_blackout_targets IS NOT NULL AND
            p_blackout_targets.count > 0
      THEN
        SELECT MGMT_GUID_OBJ(t.target_guid , t.target_name)
          BULK COLLECT INTO l_blk_target_guids
          FROM mgmt_targets t,
               TABLE(CAST(p_blackout_targets AS SMP_EMD_NVPAIR_ARRAY)) m
         WHERE t.target_name = m.name
           AND t.target_type = m.value;

        IF l_blk_target_guids.count <> p_blackout_targets.count
        THEN
          raise_application_error(MGMT_GLOBAL.INVALID_PARAMS_ERR,
                                  'Cannot find some of the targets passed in.');
        END IF;

      END IF;

      OPEN p_blackout_tzs FOR
        SELECT DISTINCT target_name, target_type, timezone_delta, timezone_region
        FROM
          ((
              SELECT /*+ CARDINALITY(guids 10)*/ tgt.target_name, tgt.target_type, tgt.timezone_delta, tgt.timezone_region
                FROM MGMT_FLAT_TARGET_ASSOC  mem, mgmt_targets tgt,
                     TABLE(CAST(l_blk_target_guids AS MGMT_GUID_ARRAY)) guids
               WHERE mem.source_target_guid = guids.guid
                 AND mem.assoc_target_guid = tgt.target_guid
                 AND mem.is_membership = 1
           )
           UNION ALL
           (
              SELECT /*+ CARDINALITY(guids 10)*/ tgt.target_name, tgt.target_type, tgt.timezone_delta, tgt.timezone_region
                FROM mgmt_targets tgt,
                     TABLE(CAST(l_blk_target_guids AS MGMT_GUID_ARRAY)) guids
               WHERE tgt.target_guid = guids.guid
           ))
        ORDER BY timezone_delta;

END get_blackout_timezones;

--
-- PURPOSE:
--   This procedure adds a new blackout to the repository.  The user calling
--   this procedure must have the operator_target privilege on the targets s/he
--   wish to create blackout
--
PROCEDURE add_blackout
  (p_blackout_name       IN VARCHAR2,
   p_reason              IN VARCHAR2,
   p_blackout_desc       IN VARCHAR2 DEFAULT NULL,
   p_job_flag            IN NUMBER DEFAULT 0,
   p_blackout_targets    IN MGMT_BLACKOUT_TARGET_LIST,
   p_schedule_record     IN MGMT_BLACKOUT_SCHEDULE_RECORD
  )
IS
  l_blackout_guid mgmt_blackouts.blackout_guid%TYPE;
  l_current_user mgmt_priv_grants.grantee%type := MGMT_USER.get_current_em_user();
  l_reason_id    mgmt_blackout_reason.reason_id%TYPE;
  l_reason_required VARCHAR2(10);

BEGIN
  -- verify if the reason exists
  -- if not, and the user is a superuser - add it
  BEGIN
    --Check whether Blackout Reasons are Mandatory
    --If they are, only then proceed to check for validity of the reason
    l_reason_required := MGMT_BLACKOUT.get_reason_required();
    IF (l_reason_required = 'true')
    THEN
      SELECT reason_id
        INTO l_reason_id
        FROM mgmt_blackout_reason
       WHERE reason = p_reason;
    END IF;

  EXCEPTION
    WHEN NO_DATA_FOUND THEN
      IF (mgmt_user.HAS_PRIV(l_current_user, mgmt_user.SUPER_USER) != mgmt_user.USER_HAS_PRIV)
      THEN
        raise_application_error(MGMT_GLOBAL.INVALID_BLACKOUT_REASON_ERR, 'Only superusers are allowed to add new reason');
      ELSE
        l_reason_id := mgmt_blackout.add_reason(p_reason);
      END IF;
  END;

  BEGIN
    -- call API to create the blackout
    l_blackout_guid := mgmt_blackout.create_blackout(
                         p_blackout_name, p_blackout_desc, p_schedule_record,
                         p_reason, p_job_flag, p_blackout_targets);
  EXCEPTION
    WHEN DUP_VAL_ON_INDEX THEN
      -- blackout already exists - duplicate name
      raise mgmt_global.blkout_already_exists;
  END;

END add_blackout;

            
FUNCTION check_modify_privs
           (p_blackout_name VARCHAR2,
            p_created_by    VARCHAR2,
            p_created_thru  VARCHAR2)
RETURN NUMBER
IS
  l_blackout_guid    mgmt_blackouts.blackout_guid%TYPE := NULL;
  l_blackout_status  mgmt_blackouts.blackout_status%TYPE := -1;
BEGIN
  get_blackout_guid(p_blackout_name, p_created_by, p_created_thru,
                    l_blackout_guid, l_blackout_status);

  -- cannot edit a blackout that is currently in effect
  -- or is stopped
  IF (l_blackout_status = -1 OR
      l_blackout_status = mgmt_blackout.BLK_STATE_START_PROCESSING OR
      l_blackout_status = mgmt_blackout.BLK_STATE_STOP_PENDING OR
      l_blackout_status = mgmt_blackout.BLK_STATE_STOPPED OR
      l_blackout_status = mgmt_blackout.BLK_STATE_ENDED OR
      l_blackout_status = mgmt_blackout.BLK_STATE_MODIFY_PENDING)
  THEN
     raise mgmt_global.blkout_invalid_state_mod;
  END IF;


  -- The backend method that checks whether the user has
  -- privileges to modify the blackout and operator
  -- privileges over the flattened list
  MGMT_BLACKOUT_ENGINE.check_modify_privs(l_blackout_guid);

  -- if we got this far, everything's fine - the user can modify
  RETURN HAS_PRIV;

END check_modify_privs;



PROCEDURE modify_blackout
  (p_blackout_name       IN VARCHAR2,
   p_reason              IN VARCHAR2,
   p_blackout_desc       IN VARCHAR2 DEFAULT NULL,
   p_job_flag            IN NUMBER DEFAULT 0,
   p_blackout_targets    IN MGMT_BLACKOUT_TARGET_LIST,
   p_schedule_record     IN MGMT_BLACKOUT_SCHEDULE_RECORD,
   p_created_by          IN VARCHAR2
  )
IS
  l_blackout_guid mgmt_blackouts.blackout_guid%TYPE;
  l_blackout_status mgmt_blackouts.blackout_status%TYPE;
  l_targets_to_add MGMT_BLACKOUT_TARGET_LIST := MGMT_BLACKOUT_TARGET_LIST();
  l_targets_to_remove MGMT_BLACKOUT_TARGET_LIST := MGMT_BLACKOUT_TARGET_LIST();
  l_reason_id    mgmt_blackout_reason.reason_id%TYPE;
  l_current_user mgmt_priv_grants.grantee%type := MGMT_USER.get_current_em_user();
  l_reason_required VARCHAR2(10);

BEGIN
  -- We assume created thru is NULL
  -- 'coz we currently don't allow modification of CLI
  -- blackouts thru UI
  get_blackout_guid(p_blackout_name, p_created_by, NULL,
                    l_blackout_guid, l_blackout_status);

  -- verify if the reason exists
  -- if not, and the user is a superuser - add it
  BEGIN
    --Check whether Blackout Reasons are Mandatory
    --If they are, only then proceed to check for validity of the reason
    l_reason_required := MGMT_BLACKOUT.get_reason_required();
    IF (l_reason_required = 'true')
    THEN
      SELECT reason_id
        INTO l_reason_id
        FROM mgmt_blackout_reason
       WHERE reason = p_reason;
    END IF;

  EXCEPTION
    WHEN NO_DATA_FOUND THEN
      IF (mgmt_user.HAS_PRIV(l_current_user, mgmt_user.SUPER_USER) != mgmt_user.USER_HAS_PRIV)
      THEN
        raise_application_error(MGMT_GLOBAL.INVALID_BLACKOUT_REASON_ERR, 'Only superusers are allowed to add new reason');
      ELSE
        l_reason_id := mgmt_blackout.add_reason(p_reason);
      END IF;
  END;

  -- from the targets that are already selected and the current list
  -- pick out the targets to be added and removed
  SELECT MGMT_BLACKOUT_TARGET_RECORD(t.target_name, t.target_type, d.include_members)
    BULK COLLECT INTO l_targets_to_remove
    FROM mgmt_blackout_target_details d, mgmt_targets t
   WHERE d.blackout_guid = l_blackout_guid AND
         t.target_guid = d.target_guid AND
         (t.target_name, t.target_type, d.include_members) NOT IN
           ( SELECT target_name, target_type, include_members
               FROM TABLE(CAST(p_blackout_targets AS  MGMT_BLACKOUT_TARGET_LIST))
           );

  SELECT /*+ CARDINALITY(tgt_list 10)*/ MGMT_BLACKOUT_TARGET_RECORD(target_name, target_type, include_members)
    BULK COLLECT INTO l_targets_to_add
    FROM TABLE(CAST(p_blackout_targets AS  MGMT_BLACKOUT_TARGET_LIST)) tgt_list
   WHERE (target_name, target_type, include_members) NOT IN
           ( SELECT t.target_name, t.target_type, d.include_members
               FROM mgmt_blackout_target_details d, mgmt_targets t
              WHERE d.blackout_guid = l_blackout_guid AND
                    t.target_guid = d.target_guid
           );

  -- call the modify_blackout API
  mgmt_blackout.edit_blackout(l_blackout_guid, p_blackout_desc, p_schedule_record,
                              p_reason, p_job_flag, l_targets_to_add, l_targets_to_remove);
END modify_blackout;

FUNCTION check_delete_privs
           (p_blackout_name VARCHAR2,
            p_created_by    VARCHAR2,
            p_created_thru  VARCHAR2)
RETURN NUMBER
IS
  l_blackout_guid    mgmt_blackouts.blackout_guid%TYPE := NULL;
  l_blackout_status  mgmt_blackouts.blackout_status%TYPE := -1;
BEGIN
  get_blackout_guid(p_blackout_name, p_created_by, p_created_thru,
                    l_blackout_guid, l_blackout_status);

  -- cannot delete a blackout that is currently in effect
  -- or is scheduled
  IF (l_blackout_status != mgmt_blackout.BLK_STATE_START_FAILED AND
      l_blackout_status != mgmt_blackout.BLK_STATE_STOPPED AND
      l_blackout_status != mgmt_blackout.BLK_STATE_ENDED)
  THEN
     raise mgmt_global.blkout_invalid_state_del;
  END IF;

  IF p_created_thru IS NULL
  THEN
    -- The backend method that checks whether the user has
    -- privileges to modify the blackout and operator
    -- privileges over the flattened list
    MGMT_BLACKOUT_ENGINE.check_modify_privs(l_blackout_guid);
  ELSE
    -- it is ok to delete
    -- CLI blackouts
    MGMT_BLACKOUT_ENGINE.check_modify_privs(l_blackout_guid, false);
  END IF;

  -- if we got this far, everything's fine - the user can delete
  RETURN HAS_PRIV;

END check_delete_privs; 



PROCEDURE delete_blackout
   (p_blackout_name VARCHAR2,
    p_created_by    VARCHAR2,
    p_created_thru  VARCHAR2)
IS
  l_blackout_guid mgmt_blackouts.blackout_guid%TYPE;
  l_blackout_status mgmt_blackouts.blackout_status%TYPE;
BEGIN
  get_blackout_guid(p_blackout_name, p_created_by, p_created_thru, l_blackout_guid,
                    l_blackout_status);

  mgmt_blackout.delete_blackout(l_blackout_guid);

END delete_blackout;

FUNCTION check_stop_privs
           (p_blackout_name VARCHAR2,
            p_created_by    VARCHAR2,
            p_created_thru  VARCHAR2)
RETURN NUMBER
IS
  l_blackout_guid    mgmt_blackouts.blackout_guid%TYPE := NULL;
  l_blackout_status  mgmt_blackouts.blackout_status%TYPE := -1;
BEGIN
  get_blackout_guid(p_blackout_name, p_created_by, p_created_thru,
                    l_blackout_guid, l_blackout_status);

  -- cannot stop a blackout that is currently waiting to stop or stopped
  -- or in modification pending state
  IF (l_blackout_status = -1 OR
      l_blackout_status = mgmt_blackout.BLK_STATE_STOP_PENDING OR
      l_blackout_status = mgmt_blackout.BLK_STATE_STOPPED OR
      l_blackout_status = mgmt_blackout.BLK_STATE_ENDED OR
      l_blackout_status = mgmt_blackout.BLK_STATE_MODIFY_PENDING)
  THEN
     raise mgmt_global.blkout_invalid_state_stop;
  END IF;


  -- The backend method that checks whether the user has
  -- privileges to modify the blackout and operator
  -- privileges over the flattened list
  MGMT_BLACKOUT_ENGINE.check_modify_privs(l_blackout_guid);

  -- if we got this far, everything's fine - the user can modify
  RETURN HAS_PRIV;

END check_stop_privs;


PROCEDURE stop_blackout
   (p_blackout_name VARCHAR2,
    p_created_by VARCHAR2)
IS

  l_current_user mgmt_priv_grants.grantee%type := MGMT_USER.get_current_em_user();
  l_blackout_guid mgmt_blackouts.blackout_guid%TYPE;
  l_blackout_status mgmt_blackouts.blackout_status%TYPE;
BEGIN
  -- We assume created thru is NULL
  -- 'coz we currently don't allow stopping of CLI
  -- blackouts thru UI
  get_blackout_guid(p_blackout_name, p_created_by, NULL, l_blackout_guid,
                    l_blackout_status);

   -- Now stop
   mgmt_blackout.stop_blackout(l_blackout_guid, NULL);

END stop_blackout;


PROCEDURE get_target_blackouts
   (target_name_in IN VARCHAR2,
    target_type_in IN VARCHAR2,
    lists_out      OUT CURSOR_TYPE)
IS
  l_target_guid mgmt_targets.target_guid%TYPE;
BEGIN
  l_target_guid := mgmt_target.get_target_guid(target_name_in, target_type_in);

  OPEN lists_out FOR
    SELECT DISTINCT b.blackout_name, p.reason, b.created_thru,
           b.created_by, b.last_updated_by, b.blackout_desc,
           b.blackout_status, b.last_end_time, b.scheduled_time,
           s.timezone_offset, s.timezone_region, s.start_time, s.duration, s.duration_source,
           s.end_time, s.interval, s.frequency_code
      FROM mgmt_blackouts b, mgmt_blackout_reason p,
           mgmt_blackout_schedule s, mgmt_blackout_flat_targets f
     WHERE f.target_guid = l_target_guid AND
           f.blackout_guid = b.blackout_guid AND
           b.blackout_status NOT IN (mgmt_blackout_engine.BLK_STATE_START_FAILED, 
                                     mgmt_blackout_engine.BLK_STATE_STOPPED, 
                                     mgmt_blackout_engine.BLK_STATE_ENDED) AND
           b.reason_id = p.reason_id (+) AND
           b.blackout_guid = s.blackout_guid
     ORDER BY b.scheduled_time DESC;

END get_target_blackouts;

--
-- PROCEDURE: get_blackout_by_target
--
PROCEDURE get_blackout_by_target
(
   blk_type IN NUMBER,
   lists_out OUT CURSOR_TYPE
)
IS
    l_current_user mgmt_priv_grants.grantee%type := MGMT_USER.get_current_em_user();
BEGIN
  IF (blk_type = mgmt_blackout_ui.ALL_BLACKOUTS)  --All Blackouts
  THEN
      OPEN lists_out FOR
           SELECT
              b.blackout_guid,
              b.blackout_name,
              t.target_name Target,
              t.target_type,
              t.type_display_name,
              b.blackout_status Status,
              DECODE((SELECT property_value
                      FROM mgmt_type_properties 
                      WHERE target_type   = t.target_type AND
                            property_name = mgmt_global.G_IS_AGGREGATE_PROP ), 1, DECODE(td.include_members, 1, 'Yes', 'No'),
                DECODE(t.target_type, mgmt_global.G_HOST_TARGET_TYPE,
                  DECODE(td.include_members, 1, 'Yes', 'No'), 'N/A' )) Full,
              bs.start_time,
              bs.duration,
              bs.frequency_code,
              r.reason Reason,
              b.blackout_desc Comments,
              b.created_by "Created By",
              b.last_updated_by "Last Updated By",
              b.created_thru,
              bs.duration_source,
              bs.end_time,
              b.last_end_time,
              b.scheduled_time,
              bs.interval,
              bs.timezone_offset,
              bs.timezone_region
          FROM
              mgmt_targets t,
              mgmt_blackouts b,
              mgmt_blackout_target_details td,
              mgmt_blackout_schedule bs,
              mgmt_blackout_reason r
          WHERE
              b.reason_id = r.reason_id (+) AND
              b.blackout_guid = td.blackout_guid AND
              b.blackout_guid = bs.blackout_guid AND
              td.target_guid = t.target_guid
          ORDER BY b.scheduled_time;
  ELSIF (blk_type = mgmt_blackout_ui.ACTIVE_BLACKOUTS) --Active Blackouts
  THEN
      OPEN lists_out FOR
          SELECT
              b.blackout_guid,
              b.blackout_name,
              t.target_name Target,
              t.target_type,
              t.type_display_name,
              b.blackout_status Status,
              DECODE((SELECT property_value
                      FROM mgmt_type_properties 
                      WHERE target_type   = t.target_type AND
                            property_name = mgmt_global.G_IS_AGGREGATE_PROP ), 1, DECODE(td.include_members, 1, 'Yes', 'No'),
                DECODE(t.target_type, mgmt_global.G_HOST_TARGET_TYPE,
                  DECODE(td.include_members, 1, 'Yes', 'No'), 'N/A' )) Full,
              bs.start_time,
              bs.duration,
              bs.frequency_code,
              r.reason Reason,
              b.blackout_desc Comments,
              b.created_by "Created By",
              b.last_updated_by "Last Updated By",
              b.created_thru,
              bs.duration_source,
              bs.end_time,
              b.last_end_time,
              b.scheduled_time,
              bs.interval,
              bs.timezone_offset,
              bs.timezone_region
          FROM
              mgmt_targets t,
              mgmt_blackouts b,
              mgmt_blackout_target_details td,
              mgmt_blackout_schedule bs,
              mgmt_blackout_reason r
          WHERE
              b.blackout_status NOT IN (mgmt_blackout_engine.BLK_STATE_START_FAILED, 
                                        mgmt_blackout_engine.BLK_STATE_STOPPED, 
                                        mgmt_blackout_engine.BLK_STATE_ENDED) AND
              DECODE(b.scheduled_time, null, b.last_start_time, b.scheduled_time) <= 
              mgmt_blackout_engine.to_blackout_time(SYSDATE, bs.timezone_info, bs.timezone_offset, bs.timezone_region) AND
              b.reason_id = r.reason_id (+) AND
              b.blackout_guid = td.blackout_guid AND
              b.blackout_guid = bs.blackout_guid AND
              td.target_guid = t.target_guid
          ORDER BY b.scheduled_time;

  ELSIF (blk_type = mgmt_blackout_ui.FUTURE_BLACKOUTS) --Future Blackouts
  THEN
      OPEN lists_out FOR
          SELECT
              b.blackout_guid,
              b.blackout_name,
              t.target_name Target,
              t.target_type,
              t.type_display_name,
              b.blackout_status Status,
              DECODE((SELECT property_value
                      FROM mgmt_type_properties 
                      WHERE target_type   = t.target_type AND
                            property_name = mgmt_global.G_IS_AGGREGATE_PROP ), 1, DECODE(td.include_members, 1, 'Yes', 'No'),
                DECODE(t.target_type, mgmt_global.G_HOST_TARGET_TYPE,
                  DECODE(td.include_members, 1, 'Yes', 'No'), 'N/A' )) Full,
              bs.start_time,
              bs.duration,
              bs.frequency_code,
              r.reason Reason,
              b.blackout_desc Comments,
              b.created_by "Created By",
              b.last_updated_by "Last Updated By",
              b.created_thru,
              bs.duration_source,
              bs.end_time,
              b.last_end_time,
              b.scheduled_time,
              bs.interval,
              bs.timezone_offset,
              bs.timezone_region
          FROM
              mgmt_targets t,
              mgmt_blackouts b,
              mgmt_blackout_target_details td,
              mgmt_blackout_schedule bs,
              mgmt_blackout_reason r
          WHERE
              b.blackout_status NOT IN (mgmt_blackout_engine.BLK_STATE_START_FAILED, 
                                        mgmt_blackout_engine.BLK_STATE_STOPPED, 
                                        mgmt_blackout_engine.BLK_STATE_ENDED) AND
              b.scheduled_time > 
              mgmt_blackout_engine.to_blackout_time(SYSDATE, bs.timezone_info, bs.timezone_offset, bs.timezone_region) AND
              b.reason_id = r.reason_id (+) AND
              b.blackout_guid = td.blackout_guid AND
              b.blackout_guid = bs.blackout_guid AND
              td.target_guid = t.target_guid
          ORDER BY b.scheduled_time;
  ELSE  --History Blackouts
      OPEN lists_out FOR
          SELECT
              b.blackout_guid,
              b.blackout_name,
              t.target_name Target,
              t.target_type,
              t.type_display_name,
              b.blackout_status Status,
              DECODE((SELECT property_value
                      FROM mgmt_type_properties 
                      WHERE target_type   = t.target_type AND
                            property_name = mgmt_global.G_IS_AGGREGATE_PROP ), 1, DECODE(td.include_members, 1, 'Yes', 'No'),
                DECODE(t.target_type, mgmt_global.G_HOST_TARGET_TYPE,
                  DECODE(td.include_members, 1, 'Yes', 'No'), 'N/A' )) Full,
              bs.start_time,
              bs.duration,
              bs.frequency_code,
              r.reason Reason,
              b.blackout_desc Comments,
              b.created_by "Created By",
              b.last_updated_by "Last Updated By",
              b.created_thru,
              bs.duration_source,
              bs.end_time,
              b.last_end_time,
              b.scheduled_time,
              bs.interval,
              bs.timezone_offset,
              bs.timezone_region
          FROM
              mgmt_targets t,
              mgmt_blackouts b,
              mgmt_blackout_target_details td,
              mgmt_blackout_schedule bs,
              mgmt_blackout_reason r
          WHERE
              b.blackout_status IN (mgmt_blackout_engine.BLK_STATE_START_FAILED, 
                                    mgmt_blackout_engine.BLK_STATE_STOPPED, 
                                    mgmt_blackout_engine.BLK_STATE_ENDED) AND
              b.reason_id = r.reason_id (+) AND
              b.blackout_guid = td.blackout_guid AND
              b.blackout_guid = bs.blackout_guid AND
              td.target_guid = t.target_guid
          ORDER BY b.scheduled_time;
  END IF;  --   IF (blk_type = mgmt_blackout_ui.ALL_BLACKOUTS) ends
END get_blackout_by_target;

--
-- PROCEDURE: get_blackout_by_flat_targets
--
PROCEDURE get_blackout_by_flat_targets
(
   blk_type IN NUMBER,
   lists_out OUT CURSOR_TYPE
)
IS
    l_current_user mgmt_priv_grants.grantee%type := MGMT_USER.get_current_em_user();
    l_blk_host_targets SMP_EMD_NVPAIR_ARRAY := SMP_EMD_NVPAIR_ARRAY();
BEGIN
    SELECT /*+ INDEX(b MGMT_BLACKOUT_TGT_DET_IDX01) */ SMP_EMD_NVPAIR(b.blackout_guid , t.emd_url)
      BULK COLLECT INTO l_blk_host_targets
      FROM mgmt_targets t, mgmt_blackout_target_details b
     WHERE b.include_members = 1 AND
           b.target_guid = t.target_guid AND
           t.target_type = mgmt_global.G_HOST_TARGET_TYPE;
  IF (blk_type = mgmt_blackout_ui.ALL_BLACKOUTS) THEN --All Blackouts
      OPEN lists_out FOR
          SELECT
           /*+ FIRST_ROWS */
              bs.blackout_guid,
              b.blackout_name,
              t.target_name Target,
              t.target_type,
              t.type_display_name,
              b.blackout_status Status,
              DECODE((SELECT property_value
                      FROM mgmt_type_properties 
                      WHERE target_type   = t.target_type AND
                            property_name = mgmt_global.G_IS_AGGREGATE_PROP ), 1,
                mgmt_blackout_ui.does_include_members(b.blackout_guid, t.target_guid),
                DECODE(t.target_type, mgmt_global.G_HOST_TARGET_TYPE,
                  mgmt_blackout_ui.does_include_members(b.blackout_guid, t.target_guid), 'N/A')) Full,
              bs.start_time,
              bs.duration,
              bs.frequency_code,
              r.reason Reason,
              b.blackout_desc Comments,
              b.created_by "Created By",
              b.last_updated_by "Last Updated By",
              b.created_thru,
              bs.duration_source,
              bs.end_time,
              b.last_end_time,
              b.scheduled_time,
              bs.interval,
              bs.timezone_offset,
              bs.timezone_region
          FROM
              mgmt_targets t,
              mgmt_blackouts b,
              mgmt_blackout_schedule bs,
              mgmt_blackout_reason r,
              mgmt_blackout_flat_targets bft,
	      mgmt_blackout_target_details mbtd
          WHERE
              b.reason_id = r.reason_id (+) AND
              b.blackout_guid = bft.blackout_guid AND
              b.blackout_guid = bs.blackout_guid AND
              bft.target_guid = t.target_guid AND
              bft.target_guid = mbtd.target_guid(+) AND
	      bft.blackout_guid = mbtd.blackout_guid(+)
          UNION
          SELECT
           /*+ FIRST_ROWS */
              bs.blackout_guid,
              b.blackout_name,
              t.target_name Target,
              t.target_type,
              t.type_display_name,
              b.blackout_status Status,
              DECODE((SELECT property_value
                      FROM mgmt_type_properties 
                      WHERE target_type   = t.target_type AND
                            property_name = mgmt_global.G_IS_AGGREGATE_PROP ), 1,
                mgmt_blackout_ui.does_include_members(b.blackout_guid, t.target_guid),
                DECODE(t.target_type, mgmt_global.G_HOST_TARGET_TYPE,
                  mgmt_blackout_ui.does_include_members(b.blackout_guid, t.target_guid), 'N/A')) Full,
              bs.start_time,
              bs.duration,
              bs.frequency_code,
              r.reason Reason,
              b.blackout_desc Comments,
              b.created_by "Created By",
              b.last_updated_by "Last Updated By",
              b.created_thru,
              bs.duration_source,
              bs.end_time,
              b.last_end_time,
              b.scheduled_time,
              bs.interval,
              bs.timezone_offset,
              bs.timezone_region
          FROM
              mgmt_targets t,
              mgmt_blackouts b,
              mgmt_blackout_schedule bs,
              mgmt_blackout_reason r,
              mgmt_flat_target_assoc assoc,
              mgmt_blackout_target_details btd
          WHERE
              b.blackout_status NOT IN (mgmt_blackout_engine.BLK_STATE_START_FAILED, 
                                        mgmt_blackout_engine.BLK_STATE_STOPPED, 
                                        mgmt_blackout_engine.BLK_STATE_ENDED) AND
              b.scheduled_time > 
              mgmt_blackout_engine.to_blackout_time(SYSDATE, bs.timezone_info, bs.timezone_offset, bs.timezone_region) AND
              b.reason_id = r.reason_id (+) AND
              b.blackout_guid = bs.blackout_guid AND
              b.blackout_guid = btd.blackout_guid AND
              assoc.source_target_guid = btd.target_guid AND
              assoc.assoc_target_guid = t.target_guid AND
              assoc.is_membership =1 AND
              btd.include_members =1
         UNION
         SELECT
           /*+ FIRST_ROWS */
              bs.blackout_guid,
              b.blackout_name,
              t.target_name Target,
              t.target_type,
              t.type_display_name,
              b.blackout_status Status,
              DECODE((SELECT property_value
                      FROM mgmt_type_properties 
                      WHERE target_type   = t.target_type AND
                            property_name = mgmt_global.G_IS_AGGREGATE_PROP ), 1,
                mgmt_blackout_ui.does_include_members(b.blackout_guid, t.target_guid),
                DECODE(t.target_type, mgmt_global.G_HOST_TARGET_TYPE,
                  mgmt_blackout_ui.does_include_members(b.blackout_guid, t.target_guid), 'N/A')) Full,
              bs.start_time,
              bs.duration,
              bs.frequency_code,
              r.reason Reason,
              b.blackout_desc Comments,
              b.created_by "Created By",
              b.last_updated_by "Last Updated By",
              b.created_thru,
              bs.duration_source,
              bs.end_time,
              b.last_end_time,
              b.scheduled_time,
              bs.interval,
              bs.timezone_offset,
              bs.timezone_region
         FROM 
	      mgmt_targets t,
              mgmt_blackout_target_details btd,
              mgmt_blackouts b,
              mgmt_blackout_reason r,
              mgmt_blackout_schedule bs,
              TABLE(CAST(l_blk_host_targets AS SMP_EMD_NVPAIR_ARRAY)) hosts
          WHERE
              b.blackout_status NOT IN (mgmt_blackout_engine.BLK_STATE_START_FAILED, 
                                        mgmt_blackout_engine.BLK_STATE_STOPPED, 
                                        mgmt_blackout_engine.BLK_STATE_ENDED) AND
              b.scheduled_time > 
              mgmt_blackout_engine.to_blackout_time(SYSDATE, bs.timezone_info, bs.timezone_offset, bs.timezone_region) AND
              b.reason_id = r.reason_id (+) AND
              b.blackout_guid = bs.blackout_guid and
              b.blackout_guid = btd.blackout_guid and
              b.blackout_guid = hosts.name and
              t.emd_url = hosts.value AND
	      t.target_guid = btd.target_guid
              ORDER BY "Created By";               
  ELSIF (blk_type = mgmt_blackout_ui.ACTIVE_BLACKOUTS) THEN --Active Blackouts
      OPEN lists_out FOR
          SELECT
              bs.blackout_guid,
              b.blackout_name,
              t.target_name Target,
              t.target_type,
              t.type_display_name,
              b.blackout_status Status,
              DECODE((SELECT property_value
                      FROM mgmt_type_properties 
                      WHERE target_type   = t.target_type AND
                            property_name = mgmt_global.G_IS_AGGREGATE_PROP ), 1,
                mgmt_blackout_ui.does_include_members(b.blackout_guid, t.target_guid),
                DECODE(t.target_type, mgmt_global.G_HOST_TARGET_TYPE,
                  mgmt_blackout_ui.does_include_members(b.blackout_guid, t.target_guid), 'N/A')) Full,
              bs.start_time,
              bs.duration,
              bs.frequency_code,
              r.reason Reason,
              b.blackout_desc Comments,
              b.created_by "Created By",
              b.last_updated_by "Last Updated By",
              b.created_thru,
              bs.duration_source,
              bs.end_time,
              b.last_end_time,
              b.scheduled_time,
              bs.interval,
              bs.timezone_offset,
              bs.timezone_region
          FROM
              mgmt_targets t,
              mgmt_blackouts b,
              mgmt_blackout_schedule bs,
              mgmt_blackout_reason r,
              mgmt_blackout_flat_targets bft,
              mgmt_blackout_target_details btd
          WHERE
              b.blackout_status NOT IN (mgmt_blackout_engine.BLK_STATE_START_FAILED, 
                                        mgmt_blackout_engine.BLK_STATE_STOPPED, 
                                        mgmt_blackout_engine.BLK_STATE_ENDED) AND
              DECODE(b.scheduled_time, null, b.last_start_time, b.scheduled_time) <= 
              mgmt_blackout_engine.to_blackout_time(SYSDATE, bs.timezone_info, bs.timezone_offset, bs.timezone_region) AND
              b.reason_id = r.reason_id (+) AND
              b.blackout_guid = bft.blackout_guid AND
              b.blackout_guid = bs.blackout_guid AND
              bft.target_guid = t.target_guid AND
              btd.target_guid(+) = bft.target_guid AND
              btd.blackout_guid(+) =  bft.blackout_guid ;
  ELSIF (blk_type = mgmt_blackout_ui.FUTURE_BLACKOUTS) THEN --Future Blackouts
        OPEN lists_out FOR
          SELECT
	  /*+ FIRST_ROWS */
              b.blackout_guid,
              b.blackout_name,
              t.target_name Target,
              t.target_type,
              t.type_display_name,
              b.blackout_status Status,
              DECODE((SELECT property_value
                      FROM mgmt_type_properties 
                      WHERE target_type   = t.target_type AND
                            property_name = mgmt_global.G_IS_AGGREGATE_PROP ), 1,
                mgmt_blackout_ui.does_include_members(b.blackout_guid, t.target_guid),
                DECODE(t.target_type, mgmt_global.G_HOST_TARGET_TYPE,
                  mgmt_blackout_ui.does_include_members(b.blackout_guid, t.target_guid), 'N/A')) Full,
              bs.start_time,
              bs.duration,
              bs.frequency_code,
              r.reason Reason,
              b.blackout_desc Comments,
              b.created_by "Created By",
              b.last_updated_by "Last Updated By",
              b.created_thru,
              bs.duration_source,
              bs.end_time,
              b.last_end_time,
              b.scheduled_time,
              bs.interval,
              bs.timezone_offset,
              bs.timezone_region
          FROM
              mgmt_targets t,
              mgmt_blackouts b,
              mgmt_blackout_schedule bs,
              mgmt_blackout_reason r,
              mgmt_blackout_flat_targets bft,
	      mgmt_blackout_target_details btd
          WHERE
              b.blackout_status NOT IN (mgmt_blackout_engine.BLK_STATE_START_FAILED, 
                                        mgmt_blackout_engine.BLK_STATE_STOPPED, 
                                        mgmt_blackout_engine.BLK_STATE_ENDED) AND
              b.scheduled_time > 
              mgmt_blackout_engine.to_blackout_time(SYSDATE, bs.timezone_info, bs.timezone_offset, bs.timezone_region) AND
              b.reason_id = r.reason_id (+) AND
              b.blackout_guid = bft.blackout_guid AND
              b.blackout_guid = bs.blackout_guid AND
              bft.target_guid = t.target_guid AND
              btd.blackout_guid(+) = bft.blackout_guid AND
              btd.target_guid(+) = bft.target_guid 
          UNION
          SELECT 
  	  /*+ FIRST_ROWS */
              b.blackout_guid,
              b.blackout_name,
              t.target_name Target,
              t.target_type,
              t.type_display_name,
              b.blackout_status Status,
              DECODE((SELECT property_value
                      FROM mgmt_type_properties 
                      WHERE target_type   = t.target_type AND
                            property_name = mgmt_global.G_IS_AGGREGATE_PROP ), 1,
                mgmt_blackout_ui.does_include_members(b.blackout_guid, t.target_guid),
                DECODE(t.target_type, mgmt_global.G_HOST_TARGET_TYPE,
                  mgmt_blackout_ui.does_include_members(b.blackout_guid, t.target_guid), 'N/A')) Full,
              bs.start_time,
              bs.duration,
              bs.frequency_code,
              r.reason Reason,
              b.blackout_desc Comments,
              b.created_by "Created By",
              b.last_updated_by "Last Updated By",
              b.created_thru,
              bs.duration_source,
              bs.end_time,
              b.last_end_time,
              b.scheduled_time,
              bs.interval,
              bs.timezone_offset,
              bs.timezone_region
          FROM
              mgmt_targets t,
              mgmt_blackouts b,
              mgmt_blackout_schedule bs,
              mgmt_blackout_reason r,
              mgmt_flat_target_assoc assoc,
              mgmt_blackout_target_details btd
          WHERE
              b.blackout_status NOT IN (mgmt_blackout_engine.BLK_STATE_START_FAILED, 
                                        mgmt_blackout_engine.BLK_STATE_STOPPED, 
                                        mgmt_blackout_engine.BLK_STATE_ENDED) AND
              b.scheduled_time > 
              mgmt_blackout_engine.to_blackout_time(SYSDATE, bs.timezone_info, bs.timezone_offset, bs.timezone_region) AND
              b.reason_id = r.reason_id (+) AND
              b.blackout_guid = bs.blackout_guid AND
              b.blackout_guid = btd.blackout_guid AND
              assoc.source_target_guid = btd.target_guid AND
              assoc.assoc_target_guid = t.target_guid AND
              assoc.is_membership =1 AND
              btd.include_members =1
         UNION
        SELECT 
	  /*+ FIRST_ROWS */
              b.blackout_guid,
              b.blackout_name,
              t.target_name Target,
              t.target_type,
              t.type_display_name,
              b.blackout_status Status,
              DECODE((SELECT property_value
                      FROM mgmt_type_properties 
                      WHERE target_type   = t.target_type AND
                            property_name = mgmt_global.G_IS_AGGREGATE_PROP ), 1,
                mgmt_blackout_ui.does_include_members(b.blackout_guid, t.target_guid),
                DECODE(t.target_type, mgmt_global.G_HOST_TARGET_TYPE,
                  mgmt_blackout_ui.does_include_members(b.blackout_guid, t.target_guid), 'N/A')) Full,
              bs.start_time,
              bs.duration,
              bs.frequency_code,
              r.reason Reason,
              b.blackout_desc Comments,
              b.created_by "Created By",
              b.last_updated_by "Last Updated By",
              b.created_thru,
              bs.duration_source,
              bs.end_time,
              b.last_end_time,
              b.scheduled_time,
              bs.interval,
              bs.timezone_offset,
              bs.timezone_region
        FROM mgmt_targets t,
             mgmt_blackout_target_details btd,
             mgmt_blackouts b,
             mgmt_blackout_reason r,
             mgmt_blackout_schedule bs,
             TABLE(CAST(l_blk_host_targets AS SMP_EMD_NVPAIR_ARRAY)) hosts
        WHERE  
             b.blackout_status NOT IN (mgmt_blackout_engine.BLK_STATE_START_FAILED, 
                                        mgmt_blackout_engine.BLK_STATE_STOPPED, 
                                        mgmt_blackout_engine.BLK_STATE_ENDED) AND
             b.scheduled_time > 
             mgmt_blackout_engine.to_blackout_time(SYSDATE, bs.timezone_info, bs.timezone_offset, bs.timezone_region) AND
             b.reason_id = r.reason_id (+) AND
             b.blackout_guid = bs.blackout_guid and
             b.blackout_guid = btd.blackout_guid and
             b.blackout_guid = hosts.name and
             t.emd_url = hosts.value AND
	     t.target_guid = btd.target_guid
             ORDER BY "Created By";     
  ELSE  --History Blackouts
      OPEN lists_out FOR
          SELECT
              bs.blackout_guid,
              b.blackout_name,
              t.target_name Target,
              t.target_type,
              t.type_display_name,
              b.blackout_status Status,
              DECODE((SELECT property_value
                      FROM mgmt_type_properties 
                      WHERE target_type   = t.target_type AND
                            property_name = mgmt_global.G_IS_AGGREGATE_PROP ), 1,
                mgmt_blackout_ui.does_include_members(b.blackout_guid, t.target_guid),
                DECODE(t.target_type, mgmt_global.G_HOST_TARGET_TYPE,
                  mgmt_blackout_ui.does_include_members(b.blackout_guid, t.target_guid), 'N/A')) Full,
              bs.start_time,
              bs.duration,
              bs.frequency_code,
              r.reason Reason,
              b.blackout_desc Comments,
              b.created_by "Created By",
              b.last_updated_by "Last Updated By",
              b.created_thru,
              bs.duration_source,
              bs.end_time,
              b.last_end_time,
              b.scheduled_time,
              bs.interval,
              bs.timezone_offset,
              bs.timezone_region
          FROM
              mgmt_targets t,
              mgmt_blackouts b,
              mgmt_blackout_schedule bs,
              mgmt_blackout_reason r,
              mgmt_blackout_flat_targets bft,
	      mgmt_blackout_target_details btd
          WHERE
	      b.blackout_status IN (mgmt_blackout_engine.BLK_STATE_START_FAILED, 
                                        mgmt_blackout_engine.BLK_STATE_STOPPED, 
                                        mgmt_blackout_engine.BLK_STATE_ENDED) AND
              b.reason_id = r.reason_id (+) AND
              b.blackout_guid = bft.blackout_guid AND
              b.blackout_guid = bs.blackout_guid AND
              bft.target_guid = t.target_guid AND
	      btd.target_guid(+) = bft.target_guid AND
	      btd.blackout_guid(+) = bft.blackout_guid;
  END IF;  --   IF (blk_type = mgmt_blackout_ui.ALL_BLACKOUTS) ends
END get_blackout_by_flat_targets;

--
-- PROCEDURE: search_blackouts_by_name
--
PROCEDURE search_blackouts_by_name
(
   blk_type IN NUMBER,
   search_string IN VARCHAR2,
   lists_out OUT CURSOR_TYPE
)
IS
  l_current_user mgmt_priv_grants.grantee%type := MGMT_USER.get_current_em_user();
  l_search_string varchar2(2000) := '%'||UPPER(LTRIM(RTRIM(search_string)))||'%';
BEGIN
--added to handle wildcard search
    IF length(TRIM(search_string))>0 THEN
        SELECT upper(
                   trim(
                      decode(instr(search_string,'*'),0,
                          decode(instr(search_string,'%'),
              0,'%'||search_string||'%',search_string),
                          REPLACE(search_string,'*','%'))
                      )
                )
        INTO l_search_string 
        FROM dual;
    END IF;
    
    --to handle escape   character
    l_search_string:=replace(l_search_string,'_','^_');
        
    IF (blk_type = mgmt_blackout_ui.ALL_BLACKOUTS)  --All Blackouts
    THEN
        OPEN lists_out FOR
        SELECT DISTINCT b.blackout_name, p.reason, b.created_thru,
               b.created_by, b.last_updated_by, s.timezone_offset, s.timezone_region,
               s.start_time, s.duration, s.duration_source, s.end_time,
               b.blackout_status, b.last_end_time,
               b.scheduled_time, s.interval, s.frequency_code,
               b.blackout_desc
          FROM mgmt_blackouts b, mgmt_blackout_reason p,
               mgmt_blackout_schedule s, mgmt_blackout_flat_targets bft,
	       mgmt_targets mt
         WHERE b.reason_id = p.reason_id (+) AND
               b.blackout_guid = s.blackout_guid AND
               upper(b.blackout_name) LIKE l_search_string escape '^' AND
               bft.blackout_guid = b.blackout_guid AND
               bft.target_guid = mt.target_guid
         ORDER BY b.scheduled_time DESC;
    ELSIF (blk_type = mgmt_blackout_ui.ACTIVE_BLACKOUTS) --Active Blackouts
    THEN
        OPEN lists_out FOR
        SELECT DISTINCT b.blackout_name, p.reason, b.created_thru,
               b.created_by, b.last_updated_by, s.timezone_offset, s.timezone_region,
               s.start_time, s.duration, s.duration_source, s.end_time,
               b.blackout_status, b.last_end_time,
               b.scheduled_time, s.interval, s.frequency_code,
               b.blackout_desc
          FROM mgmt_blackouts b, mgmt_blackout_reason p,
               mgmt_blackout_schedule s, mgmt_blackout_flat_targets bft,
	       mgmt_targets mt
         WHERE b.blackout_status NOT IN (mgmt_blackout_engine.BLK_STATE_START_FAILED, 
                                        mgmt_blackout_engine.BLK_STATE_STOPPED, 
                                        mgmt_blackout_engine.BLK_STATE_ENDED) AND
               DECODE(b.scheduled_time, null, b.last_start_time, b.scheduled_time) <= 
               mgmt_blackout_engine.to_blackout_time(SYSDATE, s.timezone_info, s.timezone_offset, s.timezone_region) AND
               b.reason_id = p.reason_id (+) AND
               s.blackout_guid = b.blackout_guid AND
               upper(b.blackout_name) LIKE l_search_string escape '^' AND
               bft.blackout_guid = b.blackout_guid AND
               bft.target_guid = mt.target_guid
         ORDER BY b.scheduled_time DESC;
    ELSIF (blk_type = mgmt_blackout_ui.FUTURE_BLACKOUTS) --Future Blackouts
    THEN
        OPEN lists_out FOR
        SELECT DISTINCT b.blackout_name, p.reason, b.created_thru,
               b.created_by, b.last_updated_by, s.timezone_offset, s.timezone_region,
               s.start_time, s.duration, s.duration_source, s.end_time,
               b.blackout_status, b.last_end_time,
               b.scheduled_time, s.interval, s.frequency_code,
               b.blackout_desc
          FROM mgmt_blackouts b, mgmt_blackout_reason p,
               mgmt_blackout_schedule s, mgmt_blackout_flat_targets bft,
	       mgmt_targets mt
         WHERE b.blackout_status NOT IN (mgmt_blackout_engine.BLK_STATE_START_FAILED, 
                                        mgmt_blackout_engine.BLK_STATE_STOPPED, 
                                        mgmt_blackout_engine.BLK_STATE_ENDED) AND
               b.scheduled_time > 
               mgmt_blackout_engine.to_blackout_time(SYSDATE, s.timezone_info, s.timezone_offset, s.timezone_region) AND
               b.reason_id = p.reason_id (+) AND
               s.blackout_guid = b.blackout_guid AND
               upper(b.blackout_name) LIKE l_search_string escape '^' AND
               bft.blackout_guid = b.blackout_guid AND
               bft.target_guid = mt.target_guid
         ORDER BY b.scheduled_time DESC;
    ELSE  --History Blackouts
        OPEN lists_out FOR
        SELECT DISTINCT b.blackout_name, p.reason, b.created_thru,
               b.created_by, b.last_updated_by, s.timezone_offset, s.timezone_region,
               s.start_time, s.duration, s.duration_source, s.end_time,
               b.blackout_status, b.last_end_time,
               b.scheduled_time, s.interval, s.frequency_code,
               b.blackout_desc
          FROM mgmt_blackouts b, mgmt_blackout_reason p,
               mgmt_blackout_schedule s, mgmt_blackout_flat_targets bft,
	       mgmt_targets mt
         WHERE b.blackout_status IN (mgmt_blackout_engine.BLK_STATE_START_FAILED, 
                                        mgmt_blackout_engine.BLK_STATE_STOPPED, 
                                        mgmt_blackout_engine.BLK_STATE_ENDED) AND
               b.reason_id = p.reason_id (+) AND
               s.blackout_guid = b.blackout_guid AND
               upper(b.blackout_name) LIKE l_search_string escape '^' AND
               bft.blackout_guid = b.blackout_guid AND
               bft.target_guid = mt.target_guid
         ORDER BY b.scheduled_time DESC;
    END IF;  --   IF (blk_type = mgmt_blackout_ui.ALL_BLACKOUTS) ends
END search_blackouts_by_name;

--
-- PROCEDURE: search_blackouts_by_target
--
PROCEDURE search_blackouts_by_target
(
  p_target_type IN VARCHAR2,
  p_target_search_string IN VARCHAR2,
  p_parent_type IN VARCHAR2,
  p_parent_search_string IN VARCHAR2,
  p_blk_type IN NUMBER,
  p_lists_out OUT CURSOR_TYPE
)
IS
  l_current_user mgmt_priv_grants.grantee%type := MGMT_USER.get_current_em_user();
  --Form a plain vanilla select string

  l_parent_search_string varchar2(2000) := '%' ||
                                    UPPER(LTRIM(RTRIM(p_parent_search_string))) ||
                                    '%';

  l_search_string varchar2(2000) := '%' ||
                                    UPPER(LTRIM(RTRIM(p_target_search_string))) ||
                                    '%';
BEGIN
--added to handle wildcard search   
    IF length(trim(p_target_search_string))>0 then
        SELECT 
	       UPPER(TRIM(
	          DECODE(instr(p_target_search_string,'*'),0,
                      DECODE(instr(p_target_search_string,'%'),
              0,'%'||p_target_search_string||'%',p_target_search_string),
                  REPLACE(p_target_search_string,'*','%')))
                )
          INTO l_search_string 
      FROM dual;
    END IF;
    --To handle escape characters
    l_search_string :=replace(l_search_string,'_','^_');
    
  --Determine whether all, active, future or history blackouts have to
  --be viewed.

  /* Replaced the Dynamic String which was forming the query with the individual SQL queries 
     in order to enhance the performance.
  */
      IF (p_blk_type = mgmt_blackout_ui.ALL_BLACKOUTS) THEN
           IF (p_parent_type IS NULL) AND (p_target_type IS NULL OR p_target_type = ALL_TARGET_TYPES) THEN
               OPEN p_lists_out FOR
               SELECT
                  b.blackout_guid, b.blackout_name, t.target_name Target, t.target_type,
                  t.type_display_name, b.blackout_status Status,
                  DECODE((SELECT property_value
                          FROM mgmt_type_properties 
                          WHERE target_type   = t.target_type AND
                                property_name = mgmt_global.G_IS_AGGREGATE_PROP ), 1, 
                  DECODE(td.include_members, 1, 'Yes', 'No'), 
                  DECODE(t.target_type, mgmt_global.G_HOST_TARGET_TYPE,
                  DECODE(td.include_members, 1, 'Yes', 'No'), 'N/A' )) Full,
                  bs.start_time, bs.duration,  bs.frequency_code,  r.reason Reason,  b.blackout_desc Comments,
                  b.created_by "Created By", b.last_updated_by "Last Updated By",  b.created_thru,
                  bs.duration_source, bs.end_time,  b.last_end_time, b.scheduled_time, bs.interval,
                  bs.timezone_offset, bs.timezone_region
               FROM
                  mgmt_targets t, mgmt_blackouts b, mgmt_blackout_target_details td, 
                  mgmt_blackout_schedule bs, mgmt_blackout_reason r
               WHERE
                  b.reason_id = r.reason_id (+) AND
                  b.blackout_guid = td.blackout_guid AND
                  b.blackout_guid = bs.blackout_guid AND
                  td.target_guid = t.target_guid  AND
                  UPPER(t.target_name) LIKE l_search_string escape '^'
               ORDER BY b.scheduled_time;
           ELSIF ((p_parent_type IS NOT NULL) AND (p_target_type IS NULL OR p_target_type = ALL_TARGET_TYPES)) THEN
               IF ((p_parent_type = mgmt_blackout_ui.PARENT_TYPE_COMPOSITE)  OR
                  (p_parent_type = mgmt_blackout_ui.PARENT_TYPE_GROUP))
               THEN
                   OPEN p_lists_out FOR
                   SELECT
                       b.blackout_guid, b.blackout_name, t.target_name Target, t.target_type,
                       t.type_display_name, b.blackout_status Status,
                       DECODE((SELECT property_value
                               FROM mgmt_type_properties 
                               WHERE target_type   = t.target_type AND
                                     property_name = mgmt_global.G_IS_AGGREGATE_PROP ), 1, DECODE(td.include_members, 1, 'Yes', 'No'),
                       DECODE(t.target_type, mgmt_global.G_HOST_TARGET_TYPE,
                       DECODE(td.include_members, 1, 'Yes', 'No'), 'N/A' )) Full,
                       bs.start_time, bs.duration,  bs.frequency_code,  r.reason Reason,  b.blackout_desc Comments,
                       b.created_by "Created By", b.last_updated_by "Last Updated By",  b.created_thru,
                       bs.duration_source, bs.end_time,  b.last_end_time, b.scheduled_time, bs.interval,
                       bs.timezone_offset, bs.timezone_region
                   FROM
                       mgmt_targets t,  mgmt_blackouts b, mgmt_blackout_target_details td,   
                       mgmt_blackout_schedule bs,  mgmt_blackout_reason r, mgmt_target_memberships tm
                   WHERE
                       b.reason_id = r.reason_id (+) AND
                       b.blackout_guid = td.blackout_guid AND
                       b.blackout_guid = bs.blackout_guid AND
                       td.target_guid = t.target_guid AND 
                       tm.member_target_guid = t.target_guid AND 
                       UPPER(tm.composite_target_name) LIKE l_parent_search_string AND 
                       UPPER(t.target_name) LIKE l_search_string escape '^'
                   ORDER BY b.scheduled_time;   
               ELSE 
                   OPEN p_lists_out FOR
                   SELECT
                       b.blackout_guid, b.blackout_name, t.target_name Target, t.target_type,
                       t.type_display_name, b.blackout_status Status,
                       DECODE((SELECT property_value
                               FROM mgmt_type_properties 
                               WHERE target_type   = t.target_type AND
                                     property_name = mgmt_global.G_IS_AGGREGATE_PROP ), 1, DECODE(td.include_members, 1, 'Yes', 'No'),
                       DECODE(t.target_type, mgmt_global.G_HOST_TARGET_TYPE,
                       DECODE(td.include_members, 1, 'Yes', 'No'), 'N/A' )) Full,
                       bs.start_time, bs.duration,  bs.frequency_code,  r.reason Reason,  b.blackout_desc Comments,
                       b.created_by "Created By", b.last_updated_by "Last Updated By",  b.created_thru,
                       bs.duration_source, bs.end_time,  b.last_end_time, b.scheduled_time, bs.interval,
                       bs.timezone_offset, bs.timezone_region
                   FROM
                       mgmt_targets t,
                       mgmt_blackouts b,
                       mgmt_blackout_target_details td,
                       mgmt_blackout_schedule bs,
                       mgmt_blackout_reason r
                   WHERE
                       b.reason_id = r.reason_id (+) AND
                       b.blackout_guid = td.blackout_guid AND
                       b.blackout_guid = bs.blackout_guid AND
                       td.target_guid = t.target_guid AND 
                       UPPER(t.host_name) LIKE l_parent_search_string AND 
                       UPPER(t.target_name) LIKE l_search_string escape '^'
                   ORDER BY b.scheduled_time;
               END IF;
           ELSIF ((p_parent_type IS NOT NULL) AND (p_target_type IS NOT NULL AND p_target_type != ALL_TARGET_TYPES)) THEN
               IF ((p_parent_type = mgmt_blackout_ui.PARENT_TYPE_COMPOSITE)  OR
                  (p_parent_type = mgmt_blackout_ui.PARENT_TYPE_GROUP))
               THEN
                   OPEN p_lists_out FOR
                   SELECT
                       b.blackout_guid, b.blackout_name, t.target_name Target, t.target_type,
                       t.type_display_name, b.blackout_status Status,
                       DECODE((SELECT property_value
                               FROM mgmt_type_properties 
                               WHERE target_type   = t.target_type AND
                                     property_name = mgmt_global.G_IS_AGGREGATE_PROP ), 1, DECODE(td.include_members, 1, 'Yes', 'No'),
                       DECODE(t.target_type, mgmt_global.G_HOST_TARGET_TYPE,
                       DECODE(td.include_members, 1, 'Yes', 'No'), 'N/A' )) Full,
                       bs.start_time, bs.duration,  bs.frequency_code,  r.reason Reason,  b.blackout_desc Comments,
                       b.created_by "Created By", b.last_updated_by "Last Updated By",  b.created_thru,
                       bs.duration_source, bs.end_time,  b.last_end_time, b.scheduled_time, bs.interval,
                       bs.timezone_offset, bs.timezone_region
                   FROM
                       mgmt_targets t,
                       mgmt_blackouts b,
                       mgmt_blackout_target_details td,
                       mgmt_blackout_schedule bs,
                       mgmt_blackout_reason r,
                       mgmt_target_memberships tm
                   WHERE
                       b.reason_id = r.reason_id (+) AND
                       b.blackout_guid = td.blackout_guid AND
                       b.blackout_guid = bs.blackout_guid AND
                       td.target_guid = t.target_guid AND 
                       tm.member_target_guid = t.target_guid AND 
                       UPPER(tm.composite_target_name) LIKE l_parent_search_string AND 
                       UPPER(t.target_name) LIKE l_search_string escape '^' AND 
                       t.target_type = p_target_type
                   ORDER BY b.scheduled_time;   
               ELSE 
                   OPEN p_lists_out FOR
                   SELECT
                       b.blackout_guid, b.blackout_name, t.target_name Target, t.target_type,
                       t.type_display_name, b.blackout_status Status,
                       DECODE((SELECT property_value
                               FROM mgmt_type_properties 
                               WHERE target_type   = t.target_type AND
                                     property_name = mgmt_global.G_IS_AGGREGATE_PROP ), 1, DECODE(td.include_members, 1, 'Yes', 'No'),
                       DECODE(t.target_type, mgmt_global.G_HOST_TARGET_TYPE,
                       DECODE(td.include_members, 1, 'Yes', 'No'), 'N/A' )) Full,
                       bs.start_time, bs.duration,  bs.frequency_code,  r.reason Reason,  b.blackout_desc Comments,
                       b.created_by "Created By", b.last_updated_by "Last Updated By",  b.created_thru,
                       bs.duration_source, bs.end_time,  b.last_end_time, b.scheduled_time, bs.interval,
                       bs.timezone_offset, bs.timezone_region
                   FROM
                       mgmt_targets t,
                       mgmt_blackouts b,
                       mgmt_blackout_target_details td,
                       mgmt_blackout_schedule bs,
                       mgmt_blackout_reason r
                   WHERE
                       b.reason_id = r.reason_id (+) AND
                       b.blackout_guid = td.blackout_guid AND
                       b.blackout_guid = bs.blackout_guid AND
                       td.target_guid = t.target_guid AND 
                       UPPER(t.host_name) LIKE l_parent_search_string AND 
                       UPPER(t.target_name) LIKE l_search_string escape '^'  AND 
                       t.target_type = p_target_type
                   ORDER BY b.scheduled_time;
               END IF;
           ELSIF ((p_parent_type IS NULL) AND ((p_target_type IS NOT NULL) AND (p_target_type != ALL_TARGET_TYPES))) THEN
               OPEN p_lists_out FOR
               SELECT
                  b.blackout_guid, b.blackout_name, t.target_name Target, t.target_type,
                  t.type_display_name, b.blackout_status Status,
                  DECODE((SELECT property_value
                          FROM mgmt_type_properties 
                          WHERE target_type   = t.target_type AND
                                property_name = mgmt_global.G_IS_AGGREGATE_PROP ), 1, 
                  DECODE(td.include_members, 1, 'Yes', 'No'), 
                  DECODE(t.target_type, mgmt_global.G_HOST_TARGET_TYPE,
                  DECODE(td.include_members, 1, 'Yes', 'No'), 'N/A' )) Full,
                  bs.start_time, bs.duration,  bs.frequency_code,  r.reason Reason,  b.blackout_desc Comments,
                  b.created_by "Created By", b.last_updated_by "Last Updated By",  b.created_thru,
                  bs.duration_source, bs.end_time,  b.last_end_time, b.scheduled_time, bs.interval,
                  bs.timezone_offset, bs.timezone_region
               FROM
                  mgmt_targets t,
                  mgmt_blackouts b,
                  mgmt_blackout_target_details td,
                  mgmt_blackout_schedule bs,
                  mgmt_blackout_reason r
               WHERE
                  b.reason_id = r.reason_id (+) AND
                  b.blackout_guid = td.blackout_guid AND
                  b.blackout_guid = bs.blackout_guid AND
                  td.target_guid = t.target_guid AND
                  UPPER(t.target_name) LIKE l_search_string escape '^' AND 
                  t.target_type = p_target_type
               ORDER BY b.scheduled_time;
           END IF;
      ELSIF (p_blk_type = mgmt_blackout_ui.ACTIVE_BLACKOUTS) THEN
	   IF (p_parent_type IS NULL) AND (p_target_type IS NULL OR p_target_type = ALL_TARGET_TYPES) THEN
               OPEN p_lists_out FOR
               SELECT
                  b.blackout_guid, b.blackout_name, t.target_name Target, t.target_type,
                  t.type_display_name, b.blackout_status Status,
                  DECODE((SELECT property_value
                          FROM mgmt_type_properties 
                          WHERE target_type   = t.target_type AND
                                property_name = mgmt_global.G_IS_AGGREGATE_PROP ), 1, 
                  DECODE(td.include_members, 1, 'Yes', 'No'), 
                  DECODE(t.target_type, mgmt_global.G_HOST_TARGET_TYPE,
                  DECODE(td.include_members, 1, 'Yes', 'No'), 'N/A' )) Full,
                  bs.start_time, bs.duration,  bs.frequency_code,  r.reason Reason,  b.blackout_desc Comments,
                  b.created_by "Created By", b.last_updated_by "Last Updated By",  b.created_thru,
                  bs.duration_source, bs.end_time,  b.last_end_time, b.scheduled_time, bs.interval,
                  bs.timezone_offset, bs.timezone_region
               FROM
                  mgmt_targets t,
                  mgmt_blackouts b,
                  mgmt_blackout_target_details td,
                  mgmt_blackout_schedule bs,
                  mgmt_blackout_reason r
               WHERE
                  b.blackout_status NOT IN (mgmt_blackout_engine.BLK_STATE_START_FAILED, 
                                        mgmt_blackout_engine.BLK_STATE_STOPPED, 
                                        mgmt_blackout_engine.BLK_STATE_ENDED) AND
                  DECODE(b.scheduled_time, null, b.last_start_time, b.scheduled_time) <= 
                  mgmt_blackout_engine.to_blackout_time(SYSDATE, bs.timezone_info, bs.timezone_offset, bs.timezone_region) AND
                  b.reason_id = r.reason_id (+) AND
                  b.blackout_guid = td.blackout_guid AND
                  b.blackout_guid = bs.blackout_guid AND
                  td.target_guid = t.target_guid   AND
                  UPPER(t.target_name) LIKE l_search_string escape '^' 
               ORDER BY b.scheduled_time;
	   ELSIF ((p_parent_type IS NOT NULL) AND (p_target_type IS NULL OR p_target_type = ALL_TARGET_TYPES)) THEN
               IF ((p_parent_type = mgmt_blackout_ui.PARENT_TYPE_COMPOSITE)  OR
                  (p_parent_type = mgmt_blackout_ui.PARENT_TYPE_GROUP))
               THEN
                   OPEN p_lists_out FOR
                   SELECT
                       b.blackout_guid, b.blackout_name, t.target_name Target, t.target_type,
                       t.type_display_name, b.blackout_status Status,
                       DECODE((SELECT property_value
                               FROM mgmt_type_properties 
                               WHERE target_type   = t.target_type AND
                                     property_name = mgmt_global.G_IS_AGGREGATE_PROP ), 1, DECODE(td.include_members, 1, 'Yes', 'No'),
                       DECODE(t.target_type, mgmt_global.G_HOST_TARGET_TYPE,
                       DECODE(td.include_members, 1, 'Yes', 'No'), 'N/A' )) Full,
                       bs.start_time, bs.duration,  bs.frequency_code,  r.reason Reason,  b.blackout_desc Comments,
                       b.created_by "Created By", b.last_updated_by "Last Updated By",  b.created_thru,
                       bs.duration_source, bs.end_time,  b.last_end_time, b.scheduled_time, bs.interval,
                       bs.timezone_offset, bs.timezone_region
                   FROM
                       mgmt_targets t,
                       mgmt_blackouts b,
                       mgmt_blackout_target_details td,
                       mgmt_blackout_schedule bs,
                       mgmt_blackout_reason r,
                       mgmt_target_memberships tm
                   WHERE
                       b.blackout_status NOT IN (mgmt_blackout_engine.BLK_STATE_START_FAILED, 
                                        mgmt_blackout_engine.BLK_STATE_STOPPED, 
                                        mgmt_blackout_engine.BLK_STATE_ENDED) AND
                       DECODE(b.scheduled_time, null, b.last_start_time, b.scheduled_time) <= 
                       mgmt_blackout_engine.to_blackout_time(SYSDATE, bs.timezone_info, bs.timezone_offset, bs.timezone_region) AND
                       b.reason_id = r.reason_id (+) AND
                       b.blackout_guid = td.blackout_guid AND
                       b.blackout_guid = bs.blackout_guid AND
                       td.target_guid = t.target_guid  AND 
                       tm.member_target_guid = t.target_guid AND 
                       UPPER(tm.composite_target_name) LIKE l_parent_search_string AND 
                       UPPER(t.target_name) LIKE l_search_string escape '^'
                   ORDER BY b.scheduled_time;
               ELSE
                   OPEN p_lists_out FOR
                   SELECT
                       b.blackout_guid, b.blackout_name, t.target_name Target, t.target_type,
                       t.type_display_name, b.blackout_status Status,
                       DECODE((SELECT property_value
                               FROM mgmt_type_properties 
                               WHERE target_type   = t.target_type AND
                                     property_name = mgmt_global.G_IS_AGGREGATE_PROP ), 1, DECODE(td.include_members, 1, 'Yes', 'No'),
                       DECODE(t.target_type, mgmt_global.G_HOST_TARGET_TYPE,
                       DECODE(td.include_members, 1, 'Yes', 'No'), 'N/A' )) Full,
                       bs.start_time, bs.duration,  bs.frequency_code,  r.reason Reason,  b.blackout_desc Comments,
                       b.created_by "Created By", b.last_updated_by "Last Updated By",  b.created_thru,
                       bs.duration_source, bs.end_time,  b.last_end_time, b.scheduled_time, bs.interval,
                       bs.timezone_offset, bs.timezone_region
                   FROM
                       mgmt_targets t,
                       mgmt_blackouts b,
                       mgmt_blackout_target_details td,
                       mgmt_blackout_schedule bs,
                       mgmt_blackout_reason r
                   WHERE
                       b.blackout_status NOT IN (mgmt_blackout_engine.BLK_STATE_START_FAILED, 
                                        mgmt_blackout_engine.BLK_STATE_STOPPED, 
                                        mgmt_blackout_engine.BLK_STATE_ENDED) AND
                       DECODE(b.scheduled_time, null, b.last_start_time, b.scheduled_time) <= 
                       mgmt_blackout_engine.to_blackout_time(SYSDATE, bs.timezone_info, bs.timezone_offset, bs.timezone_region) AND
                       b.reason_id = r.reason_id (+) AND
                       b.blackout_guid = td.blackout_guid AND
                       b.blackout_guid = bs.blackout_guid AND
                       td.target_guid = t.target_guid  AND 
                       UPPER(t.host_name) LIKE l_parent_search_string AND 
                       UPPER(t.target_name) LIKE l_search_string escape '^'
                   ORDER BY b.scheduled_time;
               END IF;
	   ELSIF ((p_parent_type IS NOT NULL) AND (p_target_type IS NOT NULL AND p_target_type != ALL_TARGET_TYPES)) THEN
               IF ((p_parent_type = mgmt_blackout_ui.PARENT_TYPE_COMPOSITE)  OR
                  (p_parent_type = mgmt_blackout_ui.PARENT_TYPE_GROUP))
               THEN
                   OPEN p_lists_out FOR
                   SELECT
                       b.blackout_guid, b.blackout_name, t.target_name Target, t.target_type,
                       t.type_display_name, b.blackout_status Status,
                       DECODE((SELECT property_value
                               FROM mgmt_type_properties 
                               WHERE target_type   = t.target_type AND
                                     property_name = mgmt_global.G_IS_AGGREGATE_PROP ), 1, DECODE(td.include_members, 1, 'Yes', 'No'),
                       DECODE(t.target_type, mgmt_global.G_HOST_TARGET_TYPE,
                       DECODE(td.include_members, 1, 'Yes', 'No'), 'N/A' )) Full,
                       bs.start_time, bs.duration,  bs.frequency_code,  r.reason Reason,  b.blackout_desc Comments,
                       b.created_by "Created By", b.last_updated_by "Last Updated By",  b.created_thru,
                       bs.duration_source, bs.end_time,  b.last_end_time, b.scheduled_time, bs.interval,
                       bs.timezone_offset, bs.timezone_region
                   FROM
                       mgmt_targets t,
                       mgmt_blackouts b,
                       mgmt_blackout_target_details td,
                       mgmt_blackout_schedule bs,
                       mgmt_blackout_reason r,
                       mgmt_target_memberships tm
                   WHERE
                       b.blackout_status NOT IN (mgmt_blackout_engine.BLK_STATE_START_FAILED, 
                                        mgmt_blackout_engine.BLK_STATE_STOPPED, 
                                        mgmt_blackout_engine.BLK_STATE_ENDED) AND
                       DECODE(b.scheduled_time, null, b.last_start_time, b.scheduled_time) <= 
                       mgmt_blackout_engine.to_blackout_time(SYSDATE, bs.timezone_info, bs.timezone_offset, bs.timezone_region) AND
                       b.reason_id = r.reason_id (+) AND
                       b.blackout_guid = td.blackout_guid AND
                       b.blackout_guid = bs.blackout_guid AND
                       td.target_guid = t.target_guid  AND 
                       tm.member_target_guid = t.target_guid AND 
                       UPPER(tm.composite_target_name) LIKE l_parent_search_string AND 
                       UPPER(t.target_name) LIKE l_search_string escape '^'  AND 
                       t.target_type = p_target_type
                   ORDER BY b.scheduled_time;
               ELSE
                   OPEN p_lists_out FOR
                   SELECT /*+ FIRST_ROWS */
                       b.blackout_guid, b.blackout_name, t.target_name Target, t.target_type,
                       t.type_display_name, b.blackout_status Status,
                       DECODE((SELECT property_value
                               FROM mgmt_type_properties 
                               WHERE target_type   = t.target_type AND
                                     property_name = mgmt_global.G_IS_AGGREGATE_PROP ), 1, DECODE(td.include_members, 1, 'Yes', 'No'),
                       DECODE(t.target_type, mgmt_global.G_HOST_TARGET_TYPE,
                       DECODE(td.include_members, 1, 'Yes', 'No'), 'N/A' )) Full,
                       bs.start_time, bs.duration,  bs.frequency_code,  r.reason Reason,  b.blackout_desc Comments,
                       b.created_by "Created By", b.last_updated_by "Last Updated By",  b.created_thru,
                       bs.duration_source, bs.end_time,  b.last_end_time, b.scheduled_time, bs.interval,
                       bs.timezone_offset, bs.timezone_region
                   FROM
                       mgmt_targets t,
                       mgmt_blackouts b,
                       mgmt_blackout_target_details td,
                       mgmt_blackout_schedule bs,
                       mgmt_blackout_reason r
                   WHERE
                       b.blackout_status NOT IN (mgmt_blackout_engine.BLK_STATE_START_FAILED, 
                                        mgmt_blackout_engine.BLK_STATE_STOPPED, 
                                        mgmt_blackout_engine.BLK_STATE_ENDED) AND
                       DECODE(b.scheduled_time, null, b.last_start_time, b.scheduled_time) <= 
                       mgmt_blackout_engine.to_blackout_time(SYSDATE, bs.timezone_info, bs.timezone_offset, bs.timezone_region) AND
                       b.reason_id = r.reason_id (+) AND
                       b.blackout_guid = td.blackout_guid AND
                       b.blackout_guid = bs.blackout_guid AND
                       td.target_guid = t.target_guid  AND 
                       UPPER(t.host_name) LIKE l_parent_search_string AND 
                       UPPER(t.target_name) LIKE l_search_string escape '^'  AND 
                       t.target_type = p_target_type
                   ORDER BY b.scheduled_time;
               END IF;
	   ELSIF ((p_parent_type IS NULL) AND ((p_target_type IS NOT NULL) AND (p_target_type != ALL_TARGET_TYPES))) THEN
                   OPEN p_lists_out FOR
                   SELECT
                       b.blackout_guid, b.blackout_name, t.target_name Target, t.target_type,
                       t.type_display_name, b.blackout_status Status,
                       DECODE((SELECT property_value
                               FROM mgmt_type_properties 
                               WHERE target_type   = t.target_type AND
                                     property_name = mgmt_global.G_IS_AGGREGATE_PROP ), 1, DECODE(td.include_members, 1, 'Yes', 'No'),
                       DECODE(t.target_type, mgmt_global.G_HOST_TARGET_TYPE,
                       DECODE(td.include_members, 1, 'Yes', 'No'), 'N/A' )) Full,
                       bs.start_time, bs.duration,  bs.frequency_code,  r.reason Reason,  b.blackout_desc Comments,
                       b.created_by "Created By", b.last_updated_by "Last Updated By",  b.created_thru,
                       bs.duration_source, bs.end_time,  b.last_end_time, b.scheduled_time, bs.interval,
                       bs.timezone_offset, bs.timezone_region
                   FROM
                       mgmt_targets t,
                       mgmt_blackouts b,
                       mgmt_blackout_target_details td,
                       mgmt_blackout_schedule bs,
                       mgmt_blackout_reason r
                   WHERE
                       b.blackout_status NOT IN (mgmt_blackout_engine.BLK_STATE_START_FAILED, 
                                        mgmt_blackout_engine.BLK_STATE_STOPPED, 
                                        mgmt_blackout_engine.BLK_STATE_ENDED) AND
                       DECODE(b.scheduled_time, null, b.last_start_time, b.scheduled_time) <= 
                       mgmt_blackout_engine.to_blackout_time(SYSDATE, bs.timezone_info, bs.timezone_offset, bs.timezone_region) AND
                       b.reason_id = r.reason_id (+) AND
                       b.blackout_guid = td.blackout_guid AND
                       b.blackout_guid = bs.blackout_guid AND
                       td.target_guid = t.target_guid   AND
                       UPPER(t.target_name) LIKE l_search_string escape '^'   AND 
                       t.target_type = p_target_type
                   ORDER BY b.scheduled_time;
	   END IF;
      ELSIF (p_blk_type = mgmt_blackout_ui.FUTURE_BLACKOUTS) THEN
           IF (p_parent_type IS NULL) AND (p_target_type IS NULL OR p_target_type = ALL_TARGET_TYPES) THEN
                   OPEN p_lists_out FOR
                   SELECT
                       b.blackout_guid, b.blackout_name, t.target_name Target, t.target_type,
                       t.type_display_name, b.blackout_status Status,
                       DECODE((SELECT property_value
                               FROM mgmt_type_properties 
                               WHERE target_type   = t.target_type AND
                                     property_name = mgmt_global.G_IS_AGGREGATE_PROP ), 1, DECODE(td.include_members, 1, 'Yes', 'No'),
                       DECODE(t.target_type, mgmt_global.G_HOST_TARGET_TYPE,
                       DECODE(td.include_members, 1, 'Yes', 'No'), 'N/A' )) Full,
                       bs.start_time, bs.duration,  bs.frequency_code,  r.reason Reason,  b.blackout_desc Comments,
                       b.created_by "Created By", b.last_updated_by "Last Updated By",  b.created_thru,
                       bs.duration_source, bs.end_time,  b.last_end_time, b.scheduled_time, bs.interval,
                       bs.timezone_offset, bs.timezone_region
                   FROM
                       mgmt_targets t,
                       mgmt_blackouts b,
                       mgmt_blackout_target_details td,
                       mgmt_blackout_schedule bs,
                       mgmt_blackout_reason r
                   WHERE
                       b.blackout_status NOT IN (mgmt_blackout_engine.BLK_STATE_START_FAILED, 
                                        mgmt_blackout_engine.BLK_STATE_STOPPED, 
                                        mgmt_blackout_engine.BLK_STATE_ENDED) AND
                       b.scheduled_time > 
                       mgmt_blackout_engine.to_blackout_time(SYSDATE, bs.timezone_info, bs.timezone_offset, bs.timezone_region) AND
                       b.reason_id = r.reason_id (+) AND
                       b.blackout_guid = td.blackout_guid AND
                       b.blackout_guid = bs.blackout_guid AND
                       td.target_guid = t.target_guid  AND
                       UPPER(t.target_name) LIKE l_search_string escape '^'
                   ORDER BY b.scheduled_time;
           ELSIF ((p_parent_type IS NOT NULL) AND (p_target_type IS NULL OR p_target_type = ALL_TARGET_TYPES)) THEN
               IF ((p_parent_type = mgmt_blackout_ui.PARENT_TYPE_COMPOSITE)  OR
                  (p_parent_type = mgmt_blackout_ui.PARENT_TYPE_GROUP))
               THEN
                   OPEN p_lists_out FOR
                   SELECT
                       b.blackout_guid, b.blackout_name, t.target_name Target, t.target_type,
                       t.type_display_name, b.blackout_status Status,
                       DECODE((SELECT property_value
                               FROM mgmt_type_properties 
                               WHERE target_type   = t.target_type AND
                                     property_name = mgmt_global.G_IS_AGGREGATE_PROP ), 1, DECODE(td.include_members, 1, 'Yes', 'No'),
                       DECODE(t.target_type, mgmt_global.G_HOST_TARGET_TYPE,
                       DECODE(td.include_members, 1, 'Yes', 'No'), 'N/A' )) Full,
                       bs.start_time, bs.duration,  bs.frequency_code,  r.reason Reason,  b.blackout_desc Comments,
                       b.created_by "Created By", b.last_updated_by "Last Updated By",  b.created_thru,
                       bs.duration_source, bs.end_time,  b.last_end_time, b.scheduled_time, bs.interval,
                       bs.timezone_offset, bs.timezone_region
                   FROM
                       mgmt_targets t,
                       mgmt_blackouts b,
                       mgmt_blackout_target_details td,
                       mgmt_blackout_schedule bs,
                       mgmt_blackout_reason r, mgmt_target_memberships tm
                   WHERE
                       b.blackout_status NOT IN (mgmt_blackout_engine.BLK_STATE_START_FAILED, 
                                        mgmt_blackout_engine.BLK_STATE_STOPPED, 
                                        mgmt_blackout_engine.BLK_STATE_ENDED) AND
                       b.scheduled_time > 
                       mgmt_blackout_engine.to_blackout_time(SYSDATE, bs.timezone_info, bs.timezone_offset, bs.timezone_region) AND
                       b.reason_id = r.reason_id (+) AND
                       b.blackout_guid = td.blackout_guid AND
                       b.blackout_guid = bs.blackout_guid AND
                       td.target_guid = t.target_guid AND 
                       tm.member_target_guid = t.target_guid AND 
                       UPPER(tm.composite_target_name) LIKE l_parent_search_string AND 
                       UPPER(t.target_name) LIKE l_search_string escape '^'
                   ORDER BY b.scheduled_time;
               ELSE 
                   OPEN p_lists_out FOR
                   SELECT
                       b.blackout_guid, b.blackout_name, t.target_name Target, t.target_type,
                       t.type_display_name, b.blackout_status Status,
                       DECODE((SELECT property_value
                               FROM mgmt_type_properties 
                               WHERE target_type   = t.target_type AND
                                     property_name = mgmt_global.G_IS_AGGREGATE_PROP ), 1, DECODE(td.include_members, 1, 'Yes', 'No'),
                       DECODE(t.target_type, mgmt_global.G_HOST_TARGET_TYPE,
                       DECODE(td.include_members, 1, 'Yes', 'No'), 'N/A' )) Full,
                       bs.start_time, bs.duration,  bs.frequency_code,  r.reason Reason,  b.blackout_desc Comments,
                       b.created_by "Created By", b.last_updated_by "Last Updated By",  b.created_thru,
                       bs.duration_source, bs.end_time,  b.last_end_time, b.scheduled_time, bs.interval,
                       bs.timezone_offset, bs.timezone_region
                   FROM
                       mgmt_targets t,
                       mgmt_blackouts b,
                       mgmt_blackout_target_details td,
                       mgmt_blackout_schedule bs,
                       mgmt_blackout_reason r
                   WHERE
                       b.blackout_status NOT IN (mgmt_blackout_engine.BLK_STATE_START_FAILED, 
                                        mgmt_blackout_engine.BLK_STATE_STOPPED, 
                                        mgmt_blackout_engine.BLK_STATE_ENDED) AND
                       b.scheduled_time > 
                       mgmt_blackout_engine.to_blackout_time(SYSDATE, bs.timezone_info, bs.timezone_offset, bs.timezone_region) AND
                       b.reason_id = r.reason_id (+) AND
                       b.blackout_guid = td.blackout_guid AND
                       b.blackout_guid = bs.blackout_guid AND
                       td.target_guid = t.target_guid AND 
                       UPPER(t.host_name) LIKE l_parent_search_string AND 
                       UPPER(t.target_name) LIKE l_search_string escape '^'
                   ORDER BY b.scheduled_time;
               END IF;
           ELSIF ((p_parent_type IS NOT NULL) AND (p_target_type IS NOT NULL AND p_target_type != ALL_TARGET_TYPES)) THEN
               IF ((p_parent_type = mgmt_blackout_ui.PARENT_TYPE_COMPOSITE)  OR
                  (p_parent_type = mgmt_blackout_ui.PARENT_TYPE_GROUP))
               THEN
                   OPEN p_lists_out FOR
                   SELECT
                       b.blackout_guid, b.blackout_name, t.target_name Target, t.target_type,
                       t.type_display_name, b.blackout_status Status,
                       DECODE((SELECT property_value
                               FROM mgmt_type_properties 
                               WHERE target_type   = t.target_type AND
                                     property_name = mgmt_global.G_IS_AGGREGATE_PROP ), 1, DECODE(td.include_members, 1, 'Yes', 'No'),
                       DECODE(t.target_type, mgmt_global.G_HOST_TARGET_TYPE,
                       DECODE(td.include_members, 1, 'Yes', 'No'), 'N/A' )) Full,
                       bs.start_time, bs.duration,  bs.frequency_code,  r.reason Reason,  b.blackout_desc Comments,
                       b.created_by "Created By", b.last_updated_by "Last Updated By",  b.created_thru,
                       bs.duration_source, bs.end_time,  b.last_end_time, b.scheduled_time, bs.interval,
                       bs.timezone_offset, bs.timezone_region
                   FROM
                       mgmt_targets t,
                       mgmt_blackouts b,
                       mgmt_blackout_target_details td,
                       mgmt_blackout_schedule bs,
                       mgmt_blackout_reason r,
                       mgmt_target_memberships tm
                   WHERE
                       b.blackout_status NOT IN (mgmt_blackout_engine.BLK_STATE_START_FAILED, 
                                        mgmt_blackout_engine.BLK_STATE_STOPPED, 
                                        mgmt_blackout_engine.BLK_STATE_ENDED) AND
                       b.scheduled_time > 
                       mgmt_blackout_engine.to_blackout_time(SYSDATE, bs.timezone_info, bs.timezone_offset, bs.timezone_region) AND
                       b.reason_id = r.reason_id (+) AND
                       b.blackout_guid = td.blackout_guid AND
                        b.blackout_guid = bs.blackout_guid AND
                       td.target_guid = t.target_guid  AND 
                       tm.member_target_guid = t.target_guid AND 
                       UPPER(tm.composite_target_name) LIKE l_parent_search_string AND 
                       UPPER(t.target_name) LIKE l_search_string escape '^' AND 
                       t.target_type = p_target_type
                   ORDER BY b.scheduled_time;
               ELSE 
                   OPEN p_lists_out FOR
                   SELECT
                       b.blackout_guid, b.blackout_name, t.target_name Target, t.target_type,
                       t.type_display_name, b.blackout_status Status,
                       DECODE((SELECT property_value
                               FROM mgmt_type_properties 
                               WHERE target_type   = t.target_type AND
                                     property_name = mgmt_global.G_IS_AGGREGATE_PROP ), 1, DECODE(td.include_members, 1, 'Yes', 'No'),
                       DECODE(t.target_type, mgmt_global.G_HOST_TARGET_TYPE,
                       DECODE(td.include_members, 1, 'Yes', 'No'), 'N/A' )) Full,
                       bs.start_time, bs.duration,  bs.frequency_code,  r.reason Reason,  b.blackout_desc Comments,
                       b.created_by "Created By", b.last_updated_by "Last Updated By",  b.created_thru,
                       bs.duration_source, bs.end_time,  b.last_end_time, b.scheduled_time, bs.interval,
                       bs.timezone_offset, bs.timezone_region
                   FROM
                       mgmt_targets t,
                       mgmt_blackouts b,
                       mgmt_blackout_target_details td,
                       mgmt_blackout_schedule bs,
                       mgmt_blackout_reason r
                   WHERE
                       b.blackout_status NOT IN (mgmt_blackout_engine.BLK_STATE_START_FAILED, 
                                        mgmt_blackout_engine.BLK_STATE_STOPPED, 
                                        mgmt_blackout_engine.BLK_STATE_ENDED) AND
                       b.scheduled_time > 
                       mgmt_blackout_engine.to_blackout_time(SYSDATE, bs.timezone_info, bs.timezone_offset, bs.timezone_region) AND
                       b.reason_id = r.reason_id (+) AND
                       b.blackout_guid = td.blackout_guid AND
                       b.blackout_guid = bs.blackout_guid AND
                       td.target_guid = t.target_guid  AND 
                       UPPER(t.host_name) LIKE l_parent_search_string AND 
                       UPPER(t.target_name) LIKE l_search_string escape '^'  AND 
                       t.target_type = p_target_type
                   ORDER BY b.scheduled_time;
               END IF;
	   ELSIF ((p_parent_type IS NULL) AND ((p_target_type IS NOT NULL) AND (p_target_type != ALL_TARGET_TYPES))) THEN
               OPEN p_lists_out FOR
               SELECT
                  b.blackout_guid, b.blackout_name, t.target_name Target, t.target_type,
                  t.type_display_name, b.blackout_status Status,
                  DECODE((SELECT property_value
                          FROM mgmt_type_properties 
                          WHERE target_type   = t.target_type AND
                                property_name = mgmt_global.G_IS_AGGREGATE_PROP ), 1, 
                  DECODE(td.include_members, 1, 'Yes', 'No'), 
                  DECODE(t.target_type, mgmt_global.G_HOST_TARGET_TYPE,
                  DECODE(td.include_members, 1, 'Yes', 'No'), 'N/A' )) Full,
                  bs.start_time, bs.duration,  bs.frequency_code,  r.reason Reason,  b.blackout_desc Comments,
                  b.created_by "Created By", b.last_updated_by "Last Updated By",  b.created_thru,
                  bs.duration_source, bs.end_time,  b.last_end_time, b.scheduled_time, bs.interval,
                  bs.timezone_offset, bs.timezone_region
               FROM
                  mgmt_targets t,
                  mgmt_blackouts b,
                  mgmt_blackout_target_details td,
                  mgmt_blackout_schedule bs,
                  mgmt_blackout_reason r
               WHERE
                  b.blackout_status NOT IN (mgmt_blackout_engine.BLK_STATE_START_FAILED, 
                                        mgmt_blackout_engine.BLK_STATE_STOPPED, 
                                        mgmt_blackout_engine.BLK_STATE_ENDED) AND
                  b.scheduled_time > 
                  mgmt_blackout_engine.to_blackout_time(SYSDATE, bs.timezone_info, bs.timezone_offset, bs.timezone_region) AND
                  b.reason_id = r.reason_id (+) AND
                  b.blackout_guid = td.blackout_guid AND
                  b.blackout_guid = bs.blackout_guid AND
                  td.target_guid = t.target_guid AND
                  UPPER(t.target_name) LIKE l_search_string escape '^' AND 
                  t.target_type = p_target_type
               ORDER BY b.scheduled_time;
	   END IF;
      ELSE -- history
          IF (p_parent_type IS NULL) AND (p_target_type IS NULL OR p_target_type = ALL_TARGET_TYPES) THEN
              OPEN p_lists_out FOR
              SELECT
                   b.blackout_guid, b.blackout_name, t.target_name Target, t.target_type,
                   t.type_display_name, b.blackout_status Status,
                   DECODE((SELECT property_value
                               FROM mgmt_type_properties 
                               WHERE target_type   = t.target_type AND
                                     property_name = mgmt_global.G_IS_AGGREGATE_PROP ), 1, DECODE(td.include_members, 1, 'Yes', 'No'),
                   DECODE(t.target_type, mgmt_global.G_HOST_TARGET_TYPE,
                   DECODE(td.include_members, 1, 'Yes', 'No'), 'N/A' )) Full,
                   bs.start_time, bs.duration,  bs.frequency_code,  r.reason Reason,  b.blackout_desc Comments,
                   b.created_by "Created By", b.last_updated_by "Last Updated By",  b.created_thru,
                   bs.duration_source, bs.end_time,  b.last_end_time, b.scheduled_time, bs.interval,
                   bs.timezone_offset, bs.timezone_region
              FROM
                   mgmt_targets t,
                   mgmt_blackouts b,
                   mgmt_blackout_target_details td,
                   mgmt_blackout_schedule bs,
                   mgmt_blackout_reason r
              WHERE
                   b.blackout_status IN (mgmt_blackout_engine.BLK_STATE_START_FAILED, 
                                        mgmt_blackout_engine.BLK_STATE_STOPPED, 
                                        mgmt_blackout_engine.BLK_STATE_ENDED) AND
                   b.reason_id = r.reason_id (+) AND
                   b.blackout_guid = td.blackout_guid AND
                   b.blackout_guid = bs.blackout_guid AND
                   td.target_guid = t.target_guid  AND
                   UPPER(t.target_name) LIKE l_search_string escape '^'
              ORDER BY b.scheduled_time;
          ELSIF ((p_parent_type IS NOT NULL) AND (p_target_type IS NULL OR p_target_type = ALL_TARGET_TYPES)) THEN
               IF ((p_parent_type = mgmt_blackout_ui.PARENT_TYPE_COMPOSITE)  OR
                  (p_parent_type = mgmt_blackout_ui.PARENT_TYPE_GROUP))
               THEN
                   OPEN p_lists_out FOR
                   SELECT
                       b.blackout_guid, b.blackout_name, t.target_name Target, t.target_type,
                       t.type_display_name, b.blackout_status Status,
                       DECODE((SELECT property_value
                               FROM mgmt_type_properties 
                               WHERE target_type   = t.target_type AND
                                     property_name = mgmt_global.G_IS_AGGREGATE_PROP ), 1, DECODE(td.include_members, 1, 'Yes', 'No'),
                       DECODE(t.target_type, mgmt_global.G_HOST_TARGET_TYPE,
                       DECODE(td.include_members, 1, 'Yes', 'No'), 'N/A' )) Full,
                       bs.start_time, bs.duration,  bs.frequency_code,  r.reason Reason,  b.blackout_desc Comments,
                       b.created_by "Created By", b.last_updated_by "Last Updated By",  b.created_thru,
                       bs.duration_source, bs.end_time,  b.last_end_time, b.scheduled_time, bs.interval,
                       bs.timezone_offset, bs.timezone_region
                   FROM
                       mgmt_targets t,
                       mgmt_blackouts b,
                       mgmt_blackout_target_details td,
                       mgmt_blackout_schedule bs,
                       mgmt_blackout_reason r, mgmt_target_memberships tm
                   WHERE
                       b.blackout_status IN (mgmt_blackout_engine.BLK_STATE_START_FAILED, 
                                        mgmt_blackout_engine.BLK_STATE_STOPPED, 
                                        mgmt_blackout_engine.BLK_STATE_ENDED) AND
                       b.reason_id = r.reason_id (+) AND
                       b.blackout_guid = td.blackout_guid AND
                       b.blackout_guid = bs.blackout_guid AND
                       td.target_guid = t.target_guid  AND
                       tm.member_target_guid = t.target_guid AND 
                       UPPER(tm.composite_target_name) LIKE l_parent_search_string AND 
                       UPPER(t.target_name) LIKE l_search_string escape '^'
                   ORDER BY b.scheduled_time;
               ELSE
                   OPEN p_lists_out FOR
                   SELECT
                       b.blackout_guid, b.blackout_name, t.target_name Target, t.target_type,
                       t.type_display_name, b.blackout_status Status,
                       DECODE((SELECT property_value
                               FROM mgmt_type_properties 
                               WHERE target_type   = t.target_type AND
                                     property_name = mgmt_global.G_IS_AGGREGATE_PROP ), 1, DECODE(td.include_members, 1, 'Yes', 'No'),
                       DECODE(t.target_type, mgmt_global.G_HOST_TARGET_TYPE,
                       DECODE(td.include_members, 1, 'Yes', 'No'), 'N/A' )) Full,
                       bs.start_time, bs.duration,  bs.frequency_code,  r.reason Reason,  b.blackout_desc Comments,
                       b.created_by "Created By", b.last_updated_by "Last Updated By",  b.created_thru,
                       bs.duration_source, bs.end_time,  b.last_end_time, b.scheduled_time, bs.interval,
                       bs.timezone_offset, bs.timezone_region
                   FROM
                       mgmt_targets t,
                       mgmt_blackouts b,
                       mgmt_blackout_target_details td,
                       mgmt_blackout_schedule bs,
                       mgmt_blackout_reason r
                   WHERE
                       b.blackout_status IN (mgmt_blackout_engine.BLK_STATE_START_FAILED, 
                                        mgmt_blackout_engine.BLK_STATE_STOPPED, 
                                        mgmt_blackout_engine.BLK_STATE_ENDED) AND
                       b.reason_id = r.reason_id (+) AND
                       b.blackout_guid = td.blackout_guid AND
                       b.blackout_guid = bs.blackout_guid AND
                       td.target_guid = t.target_guid  AND 
                       UPPER(t.host_name) LIKE l_parent_search_string AND 
                       UPPER(t.target_name) LIKE l_search_string escape '^'
                   ORDER BY b.scheduled_time;
               END IF;
          ELSIF ((p_parent_type IS NOT NULL) AND (p_target_type IS NOT NULL AND p_target_type != ALL_TARGET_TYPES)) THEN
               IF ((p_parent_type = mgmt_blackout_ui.PARENT_TYPE_COMPOSITE)  OR
                  (p_parent_type = mgmt_blackout_ui.PARENT_TYPE_GROUP))
               THEN
                   OPEN p_lists_out FOR
                   SELECT
                       b.blackout_guid, b.blackout_name, t.target_name Target, t.target_type,
                       t.type_display_name, b.blackout_status Status,
                       DECODE((SELECT property_value
                               FROM mgmt_type_properties 
                               WHERE target_type   = t.target_type AND
                                     property_name = mgmt_global.G_IS_AGGREGATE_PROP ), 1, DECODE(td.include_members, 1, 'Yes', 'No'),
                       DECODE(t.target_type, mgmt_global.G_HOST_TARGET_TYPE,
                       DECODE(td.include_members, 1, 'Yes', 'No'), 'N/A' )) Full,
                       bs.start_time, bs.duration,  bs.frequency_code,  r.reason Reason,  b.blackout_desc Comments,
                       b.created_by "Created By", b.last_updated_by "Last Updated By",  b.created_thru,
                       bs.duration_source, bs.end_time,  b.last_end_time, b.scheduled_time, bs.interval,
                       bs.timezone_offset, bs.timezone_region
                   FROM
                       mgmt_targets t,
                       mgmt_blackouts b,
                       mgmt_blackout_target_details td,
                       mgmt_blackout_schedule bs,
                       mgmt_blackout_reason r,
                       mgmt_target_memberships tm
                   WHERE
                       b.blackout_status IN (mgmt_blackout_engine.BLK_STATE_START_FAILED, 
                                        mgmt_blackout_engine.BLK_STATE_STOPPED, 
                                        mgmt_blackout_engine.BLK_STATE_ENDED) AND
                       b.reason_id = r.reason_id (+) AND
                       b.blackout_guid = td.blackout_guid AND
                       b.blackout_guid = bs.blackout_guid AND
                       td.target_guid = t.target_guid  AND 
                       tm.member_target_guid = t.target_guid AND 
                       UPPER(tm.composite_target_name) LIKE l_parent_search_string AND 
                       UPPER(t.target_name) LIKE l_search_string escape '^' AND 
                       t.target_type = p_target_type
                   ORDER BY b.scheduled_time;
                ELSE
                   OPEN p_lists_out FOR
                   SELECT
                       b.blackout_guid, b.blackout_name, t.target_name Target, t.target_type,
                       t.type_display_name, b.blackout_status Status,
                       DECODE((SELECT property_value
                               FROM mgmt_type_properties 
                               WHERE target_type   = t.target_type AND
                                     property_name = mgmt_global.G_IS_AGGREGATE_PROP ), 1, DECODE(td.include_members, 1, 'Yes', 'No'),
                       DECODE(t.target_type, mgmt_global.G_HOST_TARGET_TYPE,
                       DECODE(td.include_members, 1, 'Yes', 'No'), 'N/A' )) Full,
                       bs.start_time, bs.duration,  bs.frequency_code,  r.reason Reason,  b.blackout_desc Comments,
                       b.created_by "Created By", b.last_updated_by "Last Updated By",  b.created_thru,
                       bs.duration_source, bs.end_time,  b.last_end_time, b.scheduled_time, bs.interval,
                       bs.timezone_offset, bs.timezone_region
                   FROM
                       mgmt_targets t,
                       mgmt_blackouts b,
                       mgmt_blackout_target_details td,
                       mgmt_blackout_schedule bs,
                       mgmt_blackout_reason r
                   WHERE
                       b.blackout_status IN (mgmt_blackout_engine.BLK_STATE_START_FAILED, 
                                        mgmt_blackout_engine.BLK_STATE_STOPPED, 
                                        mgmt_blackout_engine.BLK_STATE_ENDED) AND
                       b.reason_id = r.reason_id (+) AND
                       b.blackout_guid = td.blackout_guid AND
                       b.blackout_guid = bs.blackout_guid AND
                       td.target_guid = t.target_guid AND 
                       UPPER(t.host_name) LIKE l_parent_search_string AND 
                       UPPER(t.target_name) LIKE l_search_string escape '^'  AND 
                       t.target_type = p_target_type
                   ORDER BY b.scheduled_time;
                END IF;
          ELSIF ((p_parent_type IS NULL) AND ((p_target_type IS NOT NULL) AND (p_target_type != ALL_TARGET_TYPES))) THEN
              OPEN p_lists_out FOR
              SELECT
                   b.blackout_guid, b.blackout_name, t.target_name Target, t.target_type,
                   t.type_display_name, b.blackout_status Status,
                   DECODE((SELECT property_value
                               FROM mgmt_type_properties 
                               WHERE target_type   = t.target_type AND
                                     property_name = mgmt_global.G_IS_AGGREGATE_PROP ), 1, DECODE(td.include_members, 1, 'Yes', 'No'),
                   DECODE(t.target_type, mgmt_global.G_HOST_TARGET_TYPE,
                   DECODE(td.include_members, 1, 'Yes', 'No'), 'N/A' )) Full,
                   bs.start_time, bs.duration,  bs.frequency_code,  r.reason Reason,  b.blackout_desc Comments,
                   b.created_by "Created By", b.last_updated_by "Last Updated By",  b.created_thru,
                   bs.duration_source, bs.end_time,  b.last_end_time, b.scheduled_time, bs.interval,
                   bs.timezone_offset, bs.timezone_region
              FROM
                   mgmt_targets t,
                   mgmt_blackouts b,
                   mgmt_blackout_target_details td,
                   mgmt_blackout_schedule bs,
                   mgmt_blackout_reason r
              WHERE
                   b.blackout_status IN (mgmt_blackout_engine.BLK_STATE_START_FAILED, 
                                        mgmt_blackout_engine.BLK_STATE_STOPPED, 
                                        mgmt_blackout_engine.BLK_STATE_ENDED) AND
                   b.reason_id = r.reason_id (+) AND
                   b.blackout_guid = td.blackout_guid AND
                   b.blackout_guid = bs.blackout_guid AND
                   td.target_guid = t.target_guid AND
                   UPPER(t.target_name) LIKE l_search_string escape '^' AND 
                   t.target_type = p_target_type
              ORDER BY b.scheduled_time;
          END IF;
      END IF;
END search_blackouts_by_target;

--
-- PROCEDURE: search_blackouts_flat_targets
--
PROCEDURE search_blackouts_flat_targets
(
  p_target_type IN VARCHAR2,
  p_target_search_string IN VARCHAR2,
  p_parent_type IN VARCHAR2,
  p_parent_search_string IN VARCHAR2,
  p_blk_type IN NUMBER,
  p_lists_out OUT CURSOR_TYPE
)
IS
    l_parent_search_string varchar2(2000) := '%' ||
                                    UPPER(LTRIM(RTRIM(p_parent_search_string))) ||
                                    '%';

    l_search_string varchar2(2000) := '%' ||
                                    UPPER(LTRIM(RTRIM(p_target_search_string))) ||
                                    '%';
    l_blk_host_targets SMP_EMD_NVPAIR_ARRAY := SMP_EMD_NVPAIR_ARRAY();
BEGIN
    SELECT /*+ INDEX(b MGMT_BLACKOUT_TGT_DET_IDX01) */ SMP_EMD_NVPAIR(b.blackout_guid , t.emd_url)
      BULK COLLECT INTO l_blk_host_targets
      FROM mgmt_targets t, mgmt_blackout_target_details b
     WHERE b.include_members = 1 AND
           b.target_guid = t.target_guid AND
           t.target_type = mgmt_global.G_HOST_TARGET_TYPE;
--added to handle wildcard search
    IF LENGTH(TRIM(p_target_search_string))<>0 then 
         SELECT 
            UPPER(TRIM(
            DECODE(instr(p_target_search_string,'*'),0,
                        DECODE(instr(p_target_search_string,'%'),
                0,'%'||p_target_search_string||'%',p_target_search_string),
                    REPLACE(p_target_search_string,'*','%')))
                  )
          INTO l_search_string 
      FROM dual;
    END IF;
    l_search_string :=replace(l_search_string,'_','^_');    
  --Determine whether all, active, future or history blackouts have to
  --be viewed.

  /* Replaced the Dynamic String which was forming the query with the individual SQL queries 
     in order to enhance the performance.
  */
  
    IF (p_blk_type = mgmt_blackout_ui.ACTIVE_BLACKOUTS) THEN
        IF ((p_parent_type IS NULL) AND (p_target_type IS NULL OR p_target_type = ALL_TARGET_TYPES)) THEN
            OPEN p_lists_out FOR
            SELECT
                bs.blackout_guid, b.blackout_name,  t.target_name Target,
                t.target_type, t.type_display_name, b.blackout_status Status,
                DECODE((SELECT property_value
                        FROM mgmt_type_properties 
                        WHERE target_type   = t.target_type AND
                              property_name = mgmt_global.G_IS_AGGREGATE_PROP ), 1,
                  mgmt_blackout_ui.does_include_members(b.blackout_guid, t.target_guid),
                  DECODE(t.target_type, mgmt_global.G_HOST_TARGET_TYPE,
                    mgmt_blackout_ui.does_include_members(b.blackout_guid, t.target_guid), 'N/A')) Full,
                bs.start_time,  bs.duration, bs.frequency_code, r.reason Reason,  b.blackout_desc Comments,
                b.created_by "Created By",  b.last_updated_by "Last Updated By",   b.created_thru,
                bs.duration_source, bs.end_time, b.last_end_time, b.scheduled_time, bs.interval,
                bs.timezone_offset, bs.timezone_region
            FROM
                mgmt_targets t,
                mgmt_blackouts b,
                mgmt_blackout_schedule bs,
                mgmt_blackout_reason r,
                mgmt_blackout_flat_targets bft,
                mgmt_blackout_target_details btd
            WHERE
                b.blackout_status NOT IN (mgmt_blackout_engine.BLK_STATE_START_FAILED, 
                                        mgmt_blackout_engine.BLK_STATE_STOPPED, 
                                        mgmt_blackout_engine.BLK_STATE_ENDED) AND
                DECODE(b.scheduled_time, null, b.last_start_time, b.scheduled_time) <= 
                mgmt_blackout_engine.to_blackout_time(SYSDATE, bs.timezone_info, bs.timezone_offset, bs.timezone_region) AND
                b.reason_id = r.reason_id (+) AND
                b.blackout_guid = bft.blackout_guid AND
                b.blackout_guid = bs.blackout_guid AND
                bft.target_guid = t.target_guid AND
                btd.target_guid(+) = bft.target_guid AND
                btd.blackout_guid(+) =  bft.blackout_guid AND
                UPPER(t.target_name) LIKE l_search_string escape '^'
            ORDER BY "Created By";     
        ELSIF ((p_parent_type IS NOT NULL) AND ((p_target_type IS NOT NULL) AND (p_target_type != ALL_TARGET_TYPES))) THEN
            IF (p_parent_type = mgmt_blackout_ui.PARENT_TYPE_HOST) THEN
                OPEN p_lists_out FOR
                SELECT
                    bs.blackout_guid, b.blackout_name,  t.target_name Target,
                    t.target_type, t.type_display_name, b.blackout_status Status,
                    DECODE((SELECT property_value
                            FROM mgmt_type_properties 
                            WHERE target_type   = t.target_type AND
                                  property_name = mgmt_global.G_IS_AGGREGATE_PROP ), 1,
                      mgmt_blackout_ui.does_include_members(b.blackout_guid, t.target_guid),
                      DECODE(t.target_type, mgmt_global.G_HOST_TARGET_TYPE,
                        mgmt_blackout_ui.does_include_members(b.blackout_guid, t.target_guid), 'N/A')) Full,
                    bs.start_time,  bs.duration, bs.frequency_code, r.reason Reason,  b.blackout_desc Comments,
                    b.created_by "Created By",  b.last_updated_by "Last Updated By",   b.created_thru,
                    bs.duration_source, bs.end_time, b.last_end_time, b.scheduled_time, bs.interval,
                    bs.timezone_offset, bs.timezone_region
                FROM
                    mgmt_targets t,
                    mgmt_blackouts b,
                    mgmt_blackout_schedule bs,
                    mgmt_blackout_reason r,
                    mgmt_blackout_flat_targets bft,
                    mgmt_blackout_target_details btd
                WHERE
                    b.blackout_status NOT IN (mgmt_blackout_engine.BLK_STATE_START_FAILED, 
                                        mgmt_blackout_engine.BLK_STATE_STOPPED, 
                                        mgmt_blackout_engine.BLK_STATE_ENDED) AND
                    DECODE(b.scheduled_time, null, b.last_start_time, b.scheduled_time) <= 
                    mgmt_blackout_engine.to_blackout_time(SYSDATE, bs.timezone_info, bs.timezone_offset, bs.timezone_region) AND
                    b.reason_id = r.reason_id (+) AND
                    b.blackout_guid = bft.blackout_guid AND
                    b.blackout_guid = bs.blackout_guid AND
                    bft.target_guid = t.target_guid AND
                    btd.target_guid(+) = bft.target_guid AND
                    btd.blackout_guid(+) =  bft.blackout_guid AND 
                    UPPER(t.host_name) LIKE l_parent_search_string AND
                    UPPER(t.target_name) LIKE l_search_string escape '^' AND 
                    t.target_type = p_target_type
                ORDER BY "Created By";     
            ELSE
                OPEN p_lists_out FOR
                SELECT
                    bs.blackout_guid, b.blackout_name,  t.target_name Target,
                    t.target_type, t.type_display_name, b.blackout_status Status,
                    DECODE((SELECT property_value
                            FROM mgmt_type_properties 
                            WHERE target_type   = t.target_type AND
                                  property_name = mgmt_global.G_IS_AGGREGATE_PROP ), 1,
                      mgmt_blackout_ui.does_include_members(b.blackout_guid, t.target_guid),
                      DECODE(t.target_type, mgmt_global.G_HOST_TARGET_TYPE,
                        mgmt_blackout_ui.does_include_members(b.blackout_guid, t.target_guid), 'N/A')) Full,                    
                    bs.start_time,  bs.duration, bs.frequency_code, r.reason Reason,  b.blackout_desc Comments,
                    b.created_by "Created By",  b.last_updated_by "Last Updated By",   b.created_thru,
                    bs.duration_source, bs.end_time, b.last_end_time, b.scheduled_time, bs.interval,
                    bs.timezone_offset, bs.timezone_region
                FROM
                    mgmt_targets t,
                    mgmt_blackouts b,
                    mgmt_blackout_schedule bs,
                    mgmt_blackout_reason r,
                    mgmt_blackout_flat_targets bft,
                    mgmt_blackout_target_details btd
                WHERE
                    b.blackout_status NOT IN (mgmt_blackout_engine.BLK_STATE_START_FAILED, 
                                        mgmt_blackout_engine.BLK_STATE_STOPPED, 
                                        mgmt_blackout_engine.BLK_STATE_ENDED) AND
                    DECODE(b.scheduled_time, null, b.last_start_time, b.scheduled_time) <= 
                    mgmt_blackout_engine.to_blackout_time(SYSDATE, bs.timezone_info, bs.timezone_offset, bs.timezone_region) AND
                    b.reason_id = r.reason_id (+) AND
                    b.blackout_guid = bft.blackout_guid AND
                    b.blackout_guid = bs.blackout_guid AND
                    bft.target_guid = t.target_guid AND
                    btd.target_guid(+) = bft.target_guid AND
                    btd.blackout_guid(+) =  bft.blackout_guid AND 
                    t.target_guid IN 
                    (SELECT a.assoc_target_guid
                    FROM  MGMT_FLAT_TARGET_ASSOC a , MGMT_TARGETS ct
                    WHERE  ct.target_guid = a.source_target_guid AND
                    ct.target_type = p_parent_type
                    AND UPPER(ct.target_name) LIKE l_parent_search_string
                    AND a.is_membership = 1) AND 
                    UPPER(t.target_name) LIKE l_search_string escape '^' AND 
                    t.target_type = p_target_type 
                ORDER BY "Created By";     
            END IF;
        ELSIF ((p_parent_type IS NOT NULL) AND (p_target_type IS NULL OR p_target_type = ALL_TARGET_TYPES)) THEN
            IF (p_parent_type = mgmt_blackout_ui.PARENT_TYPE_HOST) THEN
                OPEN p_lists_out FOR
                SELECT
                    bs.blackout_guid, b.blackout_name,  t.target_name Target,
                    t.target_type, t.type_display_name, b.blackout_status Status,
                    DECODE((SELECT property_value
                            FROM mgmt_type_properties 
                            WHERE target_type   = t.target_type AND
                                  property_name = mgmt_global.G_IS_AGGREGATE_PROP ), 1,
                      mgmt_blackout_ui.does_include_members(b.blackout_guid, t.target_guid),
                      DECODE(t.target_type, mgmt_global.G_HOST_TARGET_TYPE,
                        mgmt_blackout_ui.does_include_members(b.blackout_guid, t.target_guid), 'N/A')) Full,                    
                    bs.start_time,  bs.duration, bs.frequency_code, r.reason Reason,  b.blackout_desc Comments,
                    b.created_by "Created By",  b.last_updated_by "Last Updated By",   b.created_thru,
                    bs.duration_source, bs.end_time, b.last_end_time, b.scheduled_time, bs.interval,
                    bs.timezone_offset, bs.timezone_region
                FROM
                    mgmt_targets t,
                    mgmt_blackouts b,
                    mgmt_blackout_schedule bs,
                    mgmt_blackout_reason r,
                    mgmt_blackout_flat_targets bft,
                    mgmt_blackout_target_details btd
                WHERE
                    b.blackout_status NOT IN (mgmt_blackout_engine.BLK_STATE_START_FAILED, 
                                        mgmt_blackout_engine.BLK_STATE_STOPPED, 
                                        mgmt_blackout_engine.BLK_STATE_ENDED) AND
                    DECODE(b.scheduled_time, null, b.last_start_time, b.scheduled_time) <= 
                    mgmt_blackout_engine.to_blackout_time(SYSDATE, bs.timezone_info, bs.timezone_offset, bs.timezone_region) AND
                    b.reason_id = r.reason_id (+) AND
                    b.blackout_guid = bft.blackout_guid AND
                    b.blackout_guid = bs.blackout_guid AND
                    bft.target_guid = t.target_guid AND
                    btd.target_guid(+) = bft.target_guid AND
                    btd.blackout_guid(+) =  bft.blackout_guid AND 
                    UPPER(t.host_name) LIKE l_parent_search_string AND
                    UPPER(t.target_name) LIKE l_search_string escape '^' 
                ORDER BY "Created By";     
            ELSE
                OPEN p_lists_out FOR
                SELECT
                    bs.blackout_guid, b.blackout_name,  t.target_name Target,
                    t.target_type, t.type_display_name, b.blackout_status Status,
                    DECODE((SELECT property_value
                            FROM mgmt_type_properties 
                            WHERE target_type   = t.target_type AND
                                  property_name = mgmt_global.G_IS_AGGREGATE_PROP ), 1,
                      mgmt_blackout_ui.does_include_members(b.blackout_guid, t.target_guid),
                      DECODE(t.target_type, mgmt_global.G_HOST_TARGET_TYPE,
                        mgmt_blackout_ui.does_include_members(b.blackout_guid, t.target_guid), 'N/A')) Full,                    
                    bs.start_time,  bs.duration, bs.frequency_code, r.reason Reason,  b.blackout_desc Comments,
                    b.created_by "Created By",  b.last_updated_by "Last Updated By",   b.created_thru,
                    bs.duration_source, bs.end_time, b.last_end_time, b.scheduled_time, bs.interval,
                    bs.timezone_offset, bs.timezone_region
                FROM
                    mgmt_targets t,
                    mgmt_blackouts b,
                    mgmt_blackout_schedule bs,
                    mgmt_blackout_reason r,
                    mgmt_blackout_flat_targets bft,
                    mgmt_blackout_target_details btd
                WHERE
                    b.blackout_status NOT IN (mgmt_blackout_engine.BLK_STATE_START_FAILED, 
                                        mgmt_blackout_engine.BLK_STATE_STOPPED, 
                                        mgmt_blackout_engine.BLK_STATE_ENDED) AND
                    DECODE(b.scheduled_time, null, b.last_start_time, b.scheduled_time) <= 
                    mgmt_blackout_engine.to_blackout_time(SYSDATE, bs.timezone_info, bs.timezone_offset, bs.timezone_region) AND
                    b.reason_id = r.reason_id (+) AND
                    b.blackout_guid = bft.blackout_guid AND
                    b.blackout_guid = bs.blackout_guid AND
                    bft.target_guid = t.target_guid AND
                    btd.target_guid(+) = bft.target_guid AND
                    btd.blackout_guid(+) =  bft.blackout_guid AND 
                    t.target_guid IN 
                    (SELECT a.assoc_target_guid
                    FROM  MGMT_FLAT_TARGET_ASSOC a , MGMT_TARGETS ct
                    WHERE  ct.target_guid = a.source_target_guid AND
                    ct.target_type = p_parent_type
                    AND UPPER(ct.target_name) LIKE l_parent_search_string
                    AND a.is_membership = 1) AND 
                    UPPER(t.target_name) LIKE l_search_string escape '^'
                ORDER BY "Created By";     
            END IF;
        ELSIF ((p_parent_type IS NULL) AND ((p_target_type IS NOT NULL) AND (p_target_type != ALL_TARGET_TYPES))) THEN
                OPEN p_lists_out FOR
                SELECT
                    bs.blackout_guid, b.blackout_name,  t.target_name Target,
                    t.target_type, t.type_display_name, b.blackout_status Status,
                    DECODE((SELECT property_value
                            FROM mgmt_type_properties 
                            WHERE target_type   = t.target_type AND
                                  property_name = mgmt_global.G_IS_AGGREGATE_PROP ), 1,
                      mgmt_blackout_ui.does_include_members(b.blackout_guid, t.target_guid),
                      DECODE(t.target_type, mgmt_global.G_HOST_TARGET_TYPE,
                        mgmt_blackout_ui.does_include_members(b.blackout_guid, t.target_guid), 'N/A')) Full,                    
                    bs.start_time,  bs.duration, bs.frequency_code, r.reason Reason,  b.blackout_desc Comments,
                    b.created_by "Created By",  b.last_updated_by "Last Updated By",   b.created_thru,
                    bs.duration_source, bs.end_time, b.last_end_time, b.scheduled_time, bs.interval,
                    bs.timezone_offset, bs.timezone_region
                FROM
                    mgmt_targets t,
                    mgmt_blackouts b,
                    mgmt_blackout_schedule bs,
                    mgmt_blackout_reason r,
                    mgmt_blackout_flat_targets bft,
                    mgmt_blackout_target_details btd
                WHERE
                    b.blackout_status NOT IN (mgmt_blackout_engine.BLK_STATE_START_FAILED, 
                                        mgmt_blackout_engine.BLK_STATE_STOPPED, 
                                        mgmt_blackout_engine.BLK_STATE_ENDED) AND
                    DECODE(b.scheduled_time, null, b.last_start_time, b.scheduled_time) <= 
                    mgmt_blackout_engine.to_blackout_time(SYSDATE, bs.timezone_info, bs.timezone_offset, bs.timezone_region) AND
                    b.reason_id = r.reason_id (+) AND
                    b.blackout_guid = bft.blackout_guid AND
                    b.blackout_guid = bs.blackout_guid AND
                    bft.target_guid = t.target_guid AND
                    btd.target_guid(+) = bft.target_guid AND
                    btd.blackout_guid(+) =  bft.blackout_guid AND 
                    UPPER(t.target_name) LIKE l_search_string escape '^' AND 
                    t.target_type = p_target_type 
                ORDER BY "Created By";     
        END IF;
    ELSIF (p_blk_type = mgmt_blackout_ui.ALL_BLACKOUTS) THEN
        IF (p_parent_type IS NULL) AND (p_target_type IS NULL OR p_target_type = ALL_TARGET_TYPES) THEN
            OPEN p_lists_out FOR
            SELECT
                bs.blackout_guid, b.blackout_name,  t.target_name Target,
                t.target_type, t.type_display_name, b.blackout_status Status,
                DECODE((SELECT property_value
                        FROM mgmt_type_properties 
                        WHERE target_type   = t.target_type AND
                              property_name = mgmt_global.G_IS_AGGREGATE_PROP ), 1,
                  mgmt_blackout_ui.does_include_members(b.blackout_guid, t.target_guid),
                  DECODE(t.target_type, mgmt_global.G_HOST_TARGET_TYPE,
                    mgmt_blackout_ui.does_include_members(b.blackout_guid, t.target_guid), 'N/A')) Full,
                bs.start_time,  bs.duration, bs.frequency_code, r.reason Reason,  b.blackout_desc Comments,
                b.created_by "Created By",  b.last_updated_by "Last Updated By",   b.created_thru,
                bs.duration_source, bs.end_time, b.last_end_time, b.scheduled_time, bs.interval,
                bs.timezone_offset, bs.timezone_region
            FROM
                mgmt_targets t,
                mgmt_blackouts b,
                mgmt_blackout_schedule bs,
                mgmt_blackout_reason r,
                mgmt_blackout_flat_targets bft,
                mgmt_blackout_target_details mbtd
            WHERE
                b.reason_id = r.reason_id (+) AND
                b.blackout_guid = bft.blackout_guid AND
                b.blackout_guid = bs.blackout_guid AND
                bft.target_guid = t.target_guid AND
                bft.target_guid = mbtd.target_guid(+) AND
                bft.blackout_guid = mbtd.blackout_guid(+)  AND
                UPPER(t.target_name) LIKE l_search_string escape '^'
            UNION
            SELECT
                bs.blackout_guid,
                b.blackout_name,
                t.target_name Target,
                t.target_type,
                t.type_display_name,
                b.blackout_status Status,
                DECODE((SELECT property_value
                        FROM mgmt_type_properties 
                        WHERE target_type   = t.target_type AND
                              property_name = mgmt_global.G_IS_AGGREGATE_PROP ), 1,
                  mgmt_blackout_ui.does_include_members(b.blackout_guid, t.target_guid),
                  DECODE(t.target_type, mgmt_global.G_HOST_TARGET_TYPE,
                    mgmt_blackout_ui.does_include_members(b.blackout_guid, t.target_guid), 'N/A')) Full,
                bs.start_time,
                bs.duration,
                bs.frequency_code,
                r.reason Reason,
                b.blackout_desc Comments,
                b.created_by "Created By",
                b.last_updated_by "Last Updated By",
                b.created_thru,
                bs.duration_source,
                bs.end_time,
                b.last_end_time,
                b.scheduled_time,
                bs.interval,
                bs.timezone_offset,
                bs.timezone_region
            FROM
                mgmt_targets t,
                mgmt_blackouts b,
                mgmt_blackout_schedule bs,
                mgmt_blackout_reason r,
                mgmt_flat_target_assoc assoc,
                mgmt_blackout_target_details btd
            WHERE
                b.blackout_status NOT IN (mgmt_blackout_engine.BLK_STATE_START_FAILED, 
                                        mgmt_blackout_engine.BLK_STATE_STOPPED, 
                                        mgmt_blackout_engine.BLK_STATE_ENDED) AND
                b.scheduled_time > 
                mgmt_blackout_engine.to_blackout_time(SYSDATE, bs.timezone_info, bs.timezone_offset, bs.timezone_region) AND
                b.reason_id = r.reason_id (+) AND
                b.blackout_guid = bs.blackout_guid AND
                b.blackout_guid = btd.blackout_guid AND
                assoc.source_target_guid = btd.target_guid AND
                assoc.assoc_target_guid = t.target_guid AND
                assoc.is_membership =1 AND
                btd.include_members =1  AND
                UPPER(t.target_name) LIKE l_search_string escape '^'
            UNION
            SELECT
                bs.blackout_guid,
                b.blackout_name,
                t.target_name Target,
                t.target_type,
                t.type_display_name,
                b.blackout_status Status,
                DECODE((SELECT property_value
                        FROM mgmt_type_properties 
                        WHERE target_type   = t.target_type AND
                              property_name = mgmt_global.G_IS_AGGREGATE_PROP ), 1,
                  mgmt_blackout_ui.does_include_members(b.blackout_guid, t.target_guid),
                  DECODE(t.target_type, mgmt_global.G_HOST_TARGET_TYPE,
                    mgmt_blackout_ui.does_include_members(b.blackout_guid, t.target_guid), 'N/A')) Full,
                bs.start_time,
                bs.duration,
                bs.frequency_code,
                r.reason Reason,
                b.blackout_desc Comments,
                b.created_by "Created By",
                b.last_updated_by "Last Updated By",
                b.created_thru,
                bs.duration_source,
                bs.end_time,
                b.last_end_time,
                b.scheduled_time,
                bs.interval,
                bs.timezone_offset,
                bs.timezone_region
            FROM 
                mgmt_targets t,
                mgmt_blackout_target_details btd,
                mgmt_blackouts b,
                mgmt_blackout_reason r,
                mgmt_blackout_schedule bs,
                TABLE(CAST(l_blk_host_targets AS SMP_EMD_NVPAIR_ARRAY)) hosts
            WHERE
                b.blackout_status NOT IN (mgmt_blackout_engine.BLK_STATE_START_FAILED, 
                                        mgmt_blackout_engine.BLK_STATE_STOPPED, 
                                        mgmt_blackout_engine.BLK_STATE_ENDED) AND
                b.scheduled_time > 
                mgmt_blackout_engine.to_blackout_time(SYSDATE, bs.timezone_info, bs.timezone_offset, bs.timezone_region) AND
                b.reason_id = r.reason_id (+) AND
                b.blackout_guid = bs.blackout_guid and
                b.blackout_guid = btd.blackout_guid and
                b.blackout_guid = hosts.name and
                t.emd_url = hosts.value AND
                t.target_guid = btd.target_guid  AND
                UPPER(t.target_name) LIKE l_search_string escape '^'
            ORDER BY "Created By";          
        ELSIF ((p_parent_type IS NOT NULL) AND ((p_target_type IS NOT NULL) AND (p_target_type != ALL_TARGET_TYPES))) THEN
            IF (p_parent_type = mgmt_blackout_ui.PARENT_TYPE_HOST) THEN
                OPEN p_lists_out FOR
                SELECT
                    bs.blackout_guid,
                    b.blackout_name,
                    t.target_name Target,
                    t.target_type,
                    t.type_display_name,
                    b.blackout_status Status,
                    DECODE((SELECT property_value
                            FROM mgmt_type_properties 
                            WHERE target_type   = t.target_type AND
                                  property_name = mgmt_global.G_IS_AGGREGATE_PROP ), 1,
                      mgmt_blackout_ui.does_include_members(b.blackout_guid, t.target_guid),
                      DECODE(t.target_type, mgmt_global.G_HOST_TARGET_TYPE,
                        mgmt_blackout_ui.does_include_members(b.blackout_guid, t.target_guid), 'N/A')) Full,
                    bs.start_time,
                    bs.duration,
                    bs.frequency_code,
                    r.reason Reason,
                    b.blackout_desc Comments,
                    b.created_by "Created By",
                    b.last_updated_by "Last Updated By",
                    b.created_thru,
                    bs.duration_source,
                    bs.end_time,
                    b.last_end_time,
                    b.scheduled_time,
                    bs.interval,
                    bs.timezone_offset,
                    bs.timezone_region
                FROM
                    mgmt_targets t,
                    mgmt_blackouts b,
                    mgmt_blackout_schedule bs,
                    mgmt_blackout_reason r,
                    mgmt_blackout_flat_targets bft,
                    mgmt_blackout_target_details mbtd
                WHERE
                    b.reason_id = r.reason_id (+) AND
                    b.blackout_guid = bft.blackout_guid AND
                    b.blackout_guid = bs.blackout_guid AND
                    bft.target_guid = t.target_guid AND
                    bft.target_guid = mbtd.target_guid(+) AND
                    bft.blackout_guid = mbtd.blackout_guid(+)  AND 
                    UPPER(t.host_name) LIKE l_parent_search_string AND
                    UPPER(t.target_name) LIKE l_search_string escape '^' AND 
                    t.target_type = p_target_type
                UNION
                SELECT
                    bs.blackout_guid,
                    b.blackout_name,
                    t.target_name Target,
                    t.target_type,
                    t.type_display_name,
                    b.blackout_status Status,
                    DECODE((SELECT property_value
                            FROM mgmt_type_properties 
                            WHERE target_type   = t.target_type AND
                                  property_name = mgmt_global.G_IS_AGGREGATE_PROP ), 1,
                      mgmt_blackout_ui.does_include_members(b.blackout_guid, t.target_guid),
                      DECODE(t.target_type, mgmt_global.G_HOST_TARGET_TYPE,
                        mgmt_blackout_ui.does_include_members(b.blackout_guid, t.target_guid), 'N/A')) Full,
                    bs.start_time,
                    bs.duration,
                    bs.frequency_code,
                    r.reason Reason,
                    b.blackout_desc Comments,
                    b.created_by "Created By",
                    b.last_updated_by "Last Updated By",
                    b.created_thru,
                    bs.duration_source,
                    bs.end_time,
                    b.last_end_time,
                    b.scheduled_time,
                    bs.interval,
                    bs.timezone_offset,
                    bs.timezone_region
                FROM
                    mgmt_targets t,
                    mgmt_blackouts b,
                    mgmt_blackout_schedule bs,
                    mgmt_blackout_reason r,
                    mgmt_flat_target_assoc assoc,
                    mgmt_blackout_target_details btd
                WHERE
                    b.blackout_status NOT IN (mgmt_blackout_engine.BLK_STATE_START_FAILED, 
                                        mgmt_blackout_engine.BLK_STATE_STOPPED, 
                                        mgmt_blackout_engine.BLK_STATE_ENDED) AND
                    b.scheduled_time > 
                    mgmt_blackout_engine.to_blackout_time(SYSDATE, bs.timezone_info, bs.timezone_offset, bs.timezone_region) AND
                    b.reason_id = r.reason_id (+) AND
                    b.blackout_guid = bs.blackout_guid AND
                    b.blackout_guid = btd.blackout_guid AND
                    assoc.source_target_guid = btd.target_guid AND
                    assoc.assoc_target_guid = t.target_guid AND
                    assoc.is_membership =1 AND
                    btd.include_members =1  AND 
                    UPPER(t.host_name) LIKE l_parent_search_string AND
                    UPPER(t.target_name) LIKE l_search_string escape '^' AND 
                    t.target_type = p_target_type
                UNION
                SELECT
                    bs.blackout_guid,
                    b.blackout_name,
                    t.target_name Target,
                    t.target_type,
                    t.type_display_name,
                    b.blackout_status Status,
                    DECODE((SELECT property_value
                            FROM mgmt_type_properties 
                            WHERE target_type   = t.target_type AND
                                  property_name = mgmt_global.G_IS_AGGREGATE_PROP ), 1,
                      mgmt_blackout_ui.does_include_members(b.blackout_guid, t.target_guid),
                      DECODE(t.target_type, mgmt_global.G_HOST_TARGET_TYPE,
                        mgmt_blackout_ui.does_include_members(b.blackout_guid, t.target_guid), 'N/A')) Full,
                    bs.start_time,
                    bs.duration,
                    bs.frequency_code,
                    r.reason Reason,
                    b.blackout_desc Comments,
                    b.created_by "Created By",
                    b.last_updated_by "Last Updated By",
                    b.created_thru,
                    bs.duration_source,
                    bs.end_time,
                    b.last_end_time,
                    b.scheduled_time,
                    bs.interval,
                    bs.timezone_offset,
                    bs.timezone_region
                FROM 
                    mgmt_targets t,
                    mgmt_blackout_target_details btd,
                    mgmt_blackouts b,
                    mgmt_blackout_reason r,
                    mgmt_blackout_schedule bs,
                    TABLE(CAST(l_blk_host_targets AS SMP_EMD_NVPAIR_ARRAY)) hosts
                WHERE
                    b.blackout_status NOT IN (mgmt_blackout_engine.BLK_STATE_START_FAILED, 
                                        mgmt_blackout_engine.BLK_STATE_STOPPED, 
                                        mgmt_blackout_engine.BLK_STATE_ENDED) AND
                    b.scheduled_time > 
                    mgmt_blackout_engine.to_blackout_time(SYSDATE, bs.timezone_info, bs.timezone_offset, bs.timezone_region) AND
                    b.reason_id = r.reason_id (+) AND
                    b.blackout_guid = bs.blackout_guid and
                    b.blackout_guid = btd.blackout_guid and
                    b.blackout_guid = hosts.name and
                    t.emd_url = hosts.value AND
                    t.target_guid = btd.target_guid  AND 
                    UPPER(t.host_name) LIKE l_parent_search_string AND
                    UPPER(t.target_name) LIKE l_search_string escape '^' AND 
                    t.target_type = p_target_type
                ORDER BY "Created By";          
            ELSE
                OPEN p_lists_out FOR
                SELECT
                    bs.blackout_guid,
                    b.blackout_name,
                    t.target_name Target,
                    t.target_type,
                    t.type_display_name,
                    b.blackout_status Status,
                    DECODE((SELECT property_value
                            FROM mgmt_type_properties 
                            WHERE target_type   = t.target_type AND
                                  property_name = mgmt_global.G_IS_AGGREGATE_PROP ), 1,
                      mgmt_blackout_ui.does_include_members(b.blackout_guid, t.target_guid),
                      DECODE(t.target_type, mgmt_global.G_HOST_TARGET_TYPE,
                        mgmt_blackout_ui.does_include_members(b.blackout_guid, t.target_guid), 'N/A')) Full,
                    bs.start_time,
                    bs.duration,
                    bs.frequency_code,
                    r.reason Reason,
                    b.blackout_desc Comments,
                    b.created_by "Created By",
                    b.last_updated_by "Last Updated By",
                    b.created_thru,
                    bs.duration_source,
                    bs.end_time,
                    b.last_end_time,
                    b.scheduled_time,
                    bs.interval,
                    bs.timezone_offset,
                    bs.timezone_region
                FROM
                    mgmt_targets t,
                    mgmt_blackouts b,
                    mgmt_blackout_schedule bs,
                    mgmt_blackout_reason r,
                    mgmt_blackout_flat_targets bft,
                    mgmt_blackout_target_details mbtd
                WHERE
                    b.reason_id = r.reason_id (+) AND
                    b.blackout_guid = bft.blackout_guid AND
                    b.blackout_guid = bs.blackout_guid AND
                    bft.target_guid = t.target_guid AND
                    bft.target_guid = mbtd.target_guid(+) AND
                    bft.blackout_guid = mbtd.blackout_guid(+) AND 
                    t.target_guid IN 
                    (SELECT a.assoc_target_guid
                    FROM  MGMT_FLAT_TARGET_ASSOC a , MGMT_TARGETS ct
                    WHERE  ct.target_guid = a.source_target_guid AND
                    ct.target_type = p_parent_type
                    AND UPPER(ct.target_name) LIKE l_parent_search_string
                    AND a.is_membership = 1) AND 
                    UPPER(t.target_name) LIKE l_search_string escape '^' AND 
                    t.target_type = p_target_type 
                UNION
                SELECT
                    bs.blackout_guid,
                    b.blackout_name,
                    t.target_name Target,
                    t.target_type,
                    t.type_display_name,
                    b.blackout_status Status,
                    DECODE((SELECT property_value
                            FROM mgmt_type_properties 
                            WHERE target_type   = t.target_type AND
                                  property_name = mgmt_global.G_IS_AGGREGATE_PROP ), 1,
                      mgmt_blackout_ui.does_include_members(b.blackout_guid, t.target_guid),
                      DECODE(t.target_type, mgmt_global.G_HOST_TARGET_TYPE,
                        mgmt_blackout_ui.does_include_members(b.blackout_guid, t.target_guid), 'N/A')) Full,
                    bs.start_time,
                    bs.duration,
                    bs.frequency_code,
                    r.reason Reason,
                    b.blackout_desc Comments,
                    b.created_by "Created By",
                    b.last_updated_by "Last Updated By",
                    b.created_thru,
                    bs.duration_source,
                    bs.end_time,
                    b.last_end_time,
                    b.scheduled_time,
                    bs.interval,
                    bs.timezone_offset,
                    bs.timezone_region
                FROM
                    mgmt_targets t,
                    mgmt_blackouts b,
                    mgmt_blackout_schedule bs,
                    mgmt_blackout_reason r,
                    mgmt_flat_target_assoc assoc,
                    mgmt_blackout_target_details btd
                WHERE
                    b.blackout_status NOT IN (mgmt_blackout_engine.BLK_STATE_START_FAILED, 
                                        mgmt_blackout_engine.BLK_STATE_STOPPED, 
                                        mgmt_blackout_engine.BLK_STATE_ENDED) AND
                    b.scheduled_time > 
                    mgmt_blackout_engine.to_blackout_time(SYSDATE, bs.timezone_info, bs.timezone_offset, bs.timezone_region) AND
                    b.reason_id = r.reason_id (+) AND
                    b.blackout_guid = bs.blackout_guid AND
                    b.blackout_guid = btd.blackout_guid AND
                    assoc.source_target_guid = btd.target_guid AND
                    assoc.assoc_target_guid = t.target_guid AND
                    assoc.is_membership =1 AND
                    btd.include_members =1 AND 
                    t.target_guid IN 
                    (SELECT a.assoc_target_guid
                    FROM  MGMT_FLAT_TARGET_ASSOC a , MGMT_TARGETS ct
                    WHERE  ct.target_guid = a.source_target_guid AND
                    ct.target_type = p_parent_type
                    AND UPPER(ct.target_name) LIKE l_parent_search_string
                    AND a.is_membership = 1) AND 
                    UPPER(t.target_name) LIKE l_search_string escape '^' AND 
                    t.target_type = p_target_type 
                UNION
                SELECT
                    bs.blackout_guid,
                    b.blackout_name,
                    t.target_name Target,
                    t.target_type,
                    t.type_display_name,
                    b.blackout_status Status,
                    DECODE((SELECT property_value
                            FROM mgmt_type_properties 
                            WHERE target_type   = t.target_type AND
                                  property_name = mgmt_global.G_IS_AGGREGATE_PROP ), 1,
                      mgmt_blackout_ui.does_include_members(b.blackout_guid, t.target_guid),
                      DECODE(t.target_type, mgmt_global.G_HOST_TARGET_TYPE,
                        mgmt_blackout_ui.does_include_members(b.blackout_guid, t.target_guid), 'N/A')) Full,
                    bs.start_time,
                    bs.duration,
                    bs.frequency_code,
                    r.reason Reason,
                    b.blackout_desc Comments,
                    b.created_by "Created By",
                    b.last_updated_by "Last Updated By",
                    b.created_thru,
                    bs.duration_source,
                    bs.end_time,
                    b.last_end_time,
                    b.scheduled_time,
                    bs.interval,
                    bs.timezone_offset,
                    bs.timezone_region
                FROM 
                    mgmt_targets t,
                    mgmt_blackout_target_details btd,
                    mgmt_blackouts b,
                    mgmt_blackout_reason r,
                    mgmt_blackout_schedule bs,
                    TABLE(CAST(l_blk_host_targets AS SMP_EMD_NVPAIR_ARRAY)) hosts
                WHERE
                    b.blackout_status NOT IN (mgmt_blackout_engine.BLK_STATE_START_FAILED, 
                                        mgmt_blackout_engine.BLK_STATE_STOPPED, 
                                        mgmt_blackout_engine.BLK_STATE_ENDED) AND
                    b.scheduled_time > 
                    mgmt_blackout_engine.to_blackout_time(SYSDATE, bs.timezone_info, bs.timezone_offset, bs.timezone_region) AND
                    b.reason_id = r.reason_id (+) AND
                    b.blackout_guid = bs.blackout_guid and
                    b.blackout_guid = btd.blackout_guid and
                    b.blackout_guid = hosts.name and
                    t.emd_url = hosts.value AND
                    t.target_guid = btd.target_guid  AND 
                    t.target_guid IN 
                    (SELECT a.assoc_target_guid
                    FROM  MGMT_FLAT_TARGET_ASSOC a , MGMT_TARGETS ct
                    WHERE  ct.target_guid = a.source_target_guid AND
                    ct.target_type = p_parent_type
                    AND UPPER(ct.target_name) LIKE l_parent_search_string
                    AND a.is_membership = 1) AND 
                    UPPER(t.target_name) LIKE l_search_string escape '^' AND 
                    t.target_type = p_target_type 
                ORDER BY "Created By";          
           END IF;
        ELSIF ((p_parent_type IS NOT NULL) AND (p_target_type IS NULL OR p_target_type = ALL_TARGET_TYPES)) THEN
            IF (p_parent_type = mgmt_blackout_ui.PARENT_TYPE_HOST) THEN
                OPEN p_lists_out FOR
                SELECT
                    bs.blackout_guid,
                    b.blackout_name,
                    t.target_name Target,
                    t.target_type,
                    t.type_display_name,
                    b.blackout_status Status,
                    DECODE((SELECT property_value
                            FROM mgmt_type_properties 
                            WHERE target_type   = t.target_type AND
                                  property_name = mgmt_global.G_IS_AGGREGATE_PROP ), 1,
                      mgmt_blackout_ui.does_include_members(b.blackout_guid, t.target_guid),
                      DECODE(t.target_type, mgmt_global.G_HOST_TARGET_TYPE,
                        mgmt_blackout_ui.does_include_members(b.blackout_guid, t.target_guid), 'N/A')) Full,
                    bs.start_time,
                    bs.duration,
                    bs.frequency_code,
                    r.reason Reason,
                    b.blackout_desc Comments,
                    b.created_by "Created By",
                    b.last_updated_by "Last Updated By",
                    b.created_thru,
                    bs.duration_source,
                    bs.end_time,
                    b.last_end_time,
                    b.scheduled_time,
                    bs.interval,
                    bs.timezone_offset,
                    bs.timezone_region
                FROM
                    mgmt_targets t,
                    mgmt_blackouts b,
                    mgmt_blackout_schedule bs,
                    mgmt_blackout_reason r,
                    mgmt_blackout_flat_targets bft,
                    mgmt_blackout_target_details mbtd
                WHERE
                    b.reason_id = r.reason_id (+) AND
                    b.blackout_guid = bft.blackout_guid AND
                    b.blackout_guid = bs.blackout_guid AND
                    bft.target_guid = t.target_guid AND
                    bft.target_guid = mbtd.target_guid(+) AND
                    bft.blackout_guid = mbtd.blackout_guid(+)  AND 
                    UPPER(t.host_name) LIKE l_parent_search_string AND
                    UPPER(t.target_name) LIKE l_search_string escape '^' 
                UNION
                SELECT
                    bs.blackout_guid,
                    b.blackout_name,
                    t.target_name Target,
                    t.target_type,
                    t.type_display_name,
                    b.blackout_status Status,
                    DECODE((SELECT property_value
                            FROM mgmt_type_properties 
                            WHERE target_type   = t.target_type AND
                                  property_name = mgmt_global.G_IS_AGGREGATE_PROP ), 1,
                      mgmt_blackout_ui.does_include_members(b.blackout_guid, t.target_guid),
                      DECODE(t.target_type, mgmt_global.G_HOST_TARGET_TYPE,
                        mgmt_blackout_ui.does_include_members(b.blackout_guid, t.target_guid), 'N/A')) Full,
                    bs.start_time,
                    bs.duration,
                    bs.frequency_code,
                    r.reason Reason,
                    b.blackout_desc Comments,
                    b.created_by "Created By",
                    b.last_updated_by "Last Updated By",
                    b.created_thru,
                    bs.duration_source,
                    bs.end_time,
                    b.last_end_time,
                    b.scheduled_time,
                    bs.interval,
                    bs.timezone_offset,
                    bs.timezone_region
                FROM
                    mgmt_targets t,
                    mgmt_blackouts b,
                    mgmt_blackout_schedule bs,
                    mgmt_blackout_reason r,
                    mgmt_flat_target_assoc assoc,
                    mgmt_blackout_target_details btd
                WHERE
                    b.blackout_status NOT IN (mgmt_blackout_engine.BLK_STATE_START_FAILED, 
                                        mgmt_blackout_engine.BLK_STATE_STOPPED, 
                                        mgmt_blackout_engine.BLK_STATE_ENDED) AND
                    b.scheduled_time > 
                    mgmt_blackout_engine.to_blackout_time(SYSDATE, bs.timezone_info, bs.timezone_offset, bs.timezone_region) AND
                    b.reason_id = r.reason_id (+) AND
                    b.blackout_guid = bs.blackout_guid AND
                    b.blackout_guid = btd.blackout_guid AND
                    assoc.source_target_guid = btd.target_guid AND
                    assoc.assoc_target_guid = t.target_guid AND
                    assoc.is_membership =1 AND
                    btd.include_members =1  AND 
                    UPPER(t.host_name) LIKE l_parent_search_string AND
                    UPPER(t.target_name) LIKE l_search_string escape '^' 
                UNION
                SELECT
                    bs.blackout_guid,
                    b.blackout_name,
                    t.target_name Target,
                    t.target_type,
                    t.type_display_name,
                    b.blackout_status Status,
                    DECODE((SELECT property_value
                            FROM mgmt_type_properties 
                            WHERE target_type   = t.target_type AND
                                  property_name = mgmt_global.G_IS_AGGREGATE_PROP ), 1,
                      mgmt_blackout_ui.does_include_members(b.blackout_guid, t.target_guid),
                      DECODE(t.target_type, mgmt_global.G_HOST_TARGET_TYPE,
                        mgmt_blackout_ui.does_include_members(b.blackout_guid, t.target_guid), 'N/A')) Full,bs.start_time,
                    bs.duration,
                    bs.frequency_code,
                    r.reason Reason,
                    b.blackout_desc Comments,
                    b.created_by "Created By",
                    b.last_updated_by "Last Updated By",
                    b.created_thru,
                    bs.duration_source,
                    bs.end_time,
                    b.last_end_time,
                    b.scheduled_time,
                    bs.interval,
                    bs.timezone_offset,
                    bs.timezone_region
                FROM 
                    mgmt_targets t,
                    mgmt_blackout_target_details btd,
                    mgmt_blackouts b,
                    mgmt_blackout_reason r,
                    mgmt_blackout_schedule bs,
                    TABLE(CAST(l_blk_host_targets AS SMP_EMD_NVPAIR_ARRAY)) hosts
                WHERE
                    b.blackout_status NOT IN (mgmt_blackout_engine.BLK_STATE_START_FAILED, 
                                        mgmt_blackout_engine.BLK_STATE_STOPPED, 
                                        mgmt_blackout_engine.BLK_STATE_ENDED) AND
                    b.scheduled_time > 
                    mgmt_blackout_engine.to_blackout_time(SYSDATE, bs.timezone_info, bs.timezone_offset, bs.timezone_region) AND
                    b.reason_id = r.reason_id (+) AND
                    b.blackout_guid = bs.blackout_guid and
                    b.blackout_guid = btd.blackout_guid and
                    b.blackout_guid = hosts.name and
                    t.emd_url = hosts.value AND
                    t.target_guid = btd.target_guid  AND 
                    UPPER(t.host_name) LIKE l_parent_search_string AND
                    UPPER(t.target_name) LIKE l_search_string escape '^'
                ORDER BY "Created By";          
            ELSE
                OPEN p_lists_out FOR
                SELECT
                    /*+ FIRST_ROWS */
                    bs.blackout_guid,
                    b.blackout_name,
                    t.target_name Target,
                    t.target_type,
                    t.type_display_name,
                    b.blackout_status Status,
                    DECODE((SELECT property_value
                            FROM mgmt_type_properties 
                            WHERE target_type   = t.target_type AND
                                  property_name = mgmt_global.G_IS_AGGREGATE_PROP ), 1,
                      mgmt_blackout_ui.does_include_members(b.blackout_guid, t.target_guid),
                      DECODE(t.target_type, mgmt_global.G_HOST_TARGET_TYPE,
                        mgmt_blackout_ui.does_include_members(b.blackout_guid, t.target_guid), 'N/A')) Full,
                    bs.start_time,
                    bs.duration,
                    bs.frequency_code,
                    r.reason Reason,
                    b.blackout_desc Comments,
                    b.created_by "Created By",
                    b.last_updated_by "Last Updated By",
                    b.created_thru,
                    bs.duration_source,
                    bs.end_time,
                    b.last_end_time,
                    b.scheduled_time,
                    bs.interval,
                    bs.timezone_offset,
                    bs.timezone_region
                FROM
                    mgmt_targets t,
                    mgmt_blackouts b,
                    mgmt_blackout_schedule bs,
                    mgmt_blackout_reason r,
                    mgmt_blackout_flat_targets bft,
                    mgmt_blackout_target_details mbtd
                WHERE
                    b.reason_id = r.reason_id (+) AND
                    b.blackout_guid = bft.blackout_guid AND
                    b.blackout_guid = bs.blackout_guid AND
                    bft.target_guid = t.target_guid AND
                    bft.target_guid = mbtd.target_guid(+) AND
                    bft.blackout_guid = mbtd.blackout_guid(+) AND 
                    t.target_guid IN 
                    (SELECT a.assoc_target_guid
                    FROM  MGMT_FLAT_TARGET_ASSOC a , MGMT_TARGETS ct
                    WHERE  ct.target_guid = a.source_target_guid AND
                    ct.target_type = p_parent_type
                    AND UPPER(ct.target_name) LIKE l_parent_search_string
                    AND a.is_membership = 1) AND 
                    UPPER(t.target_name) LIKE l_search_string escape '^'
                UNION
                SELECT
                    /*+ FIRST_ROWS */
                    bs.blackout_guid,
                    b.blackout_name,
                    t.target_name Target,
                    t.target_type,
                    t.type_display_name,
                    b.blackout_status Status,
                    DECODE((SELECT property_value
                            FROM mgmt_type_properties 
                            WHERE target_type   = t.target_type AND
                                  property_name = mgmt_global.G_IS_AGGREGATE_PROP ), 1,
                      mgmt_blackout_ui.does_include_members(b.blackout_guid, t.target_guid),
                      DECODE(t.target_type, mgmt_global.G_HOST_TARGET_TYPE,
                        mgmt_blackout_ui.does_include_members(b.blackout_guid, t.target_guid), 'N/A')) Full,
                    bs.start_time,
                    bs.duration,
                    bs.frequency_code,
                    r.reason Reason,
                    b.blackout_desc Comments,
                    b.created_by "Created By",
                    b.last_updated_by "Last Updated By",
                    b.created_thru,
                    bs.duration_source,
                    bs.end_time,
                    b.last_end_time,
                    b.scheduled_time,
                    bs.interval,
                    bs.timezone_offset,
                    bs.timezone_region
                FROM
                    mgmt_targets t,
                    mgmt_blackouts b,
                    mgmt_blackout_schedule bs,
                    mgmt_blackout_reason r,
                    mgmt_flat_target_assoc assoc,
                    mgmt_blackout_target_details btd
                WHERE
                    b.blackout_status NOT IN (mgmt_blackout_engine.BLK_STATE_START_FAILED, 
                                        mgmt_blackout_engine.BLK_STATE_STOPPED, 
                                        mgmt_blackout_engine.BLK_STATE_ENDED) AND
                    b.scheduled_time > 
                    mgmt_blackout_engine.to_blackout_time(SYSDATE, bs.timezone_info, bs.timezone_offset, bs.timezone_region) AND
                    b.reason_id = r.reason_id (+) AND
                    b.blackout_guid = bs.blackout_guid AND
                    b.blackout_guid = btd.blackout_guid AND
                    assoc.source_target_guid = btd.target_guid AND
                    assoc.assoc_target_guid = t.target_guid AND
                    assoc.is_membership =1 AND
                    btd.include_members =1 AND 
                    t.target_guid IN 
                    (SELECT a.assoc_target_guid
                    FROM  MGMT_FLAT_TARGET_ASSOC a , MGMT_TARGETS ct
                    WHERE  ct.target_guid = a.source_target_guid AND
                    ct.target_type = p_parent_type
                    AND UPPER(ct.target_name) LIKE l_parent_search_string
                    AND a.is_membership = 1) AND 
                    UPPER(t.target_name) LIKE l_search_string escape '^' 
                UNION
                SELECT
                    /*+ FIRST_ROWS */
                    bs.blackout_guid,
                    b.blackout_name,
                    t.target_name Target,
                    t.target_type,
                    t.type_display_name,
                    b.blackout_status Status,
                    DECODE((SELECT property_value
                            FROM mgmt_type_properties 
                            WHERE target_type   = t.target_type AND
                                  property_name = mgmt_global.G_IS_AGGREGATE_PROP ), 1,
                      mgmt_blackout_ui.does_include_members(b.blackout_guid, t.target_guid),
                      DECODE(t.target_type, mgmt_global.G_HOST_TARGET_TYPE,
                        mgmt_blackout_ui.does_include_members(b.blackout_guid, t.target_guid), 'N/A')) Full,
                    bs.start_time,
                    bs.duration,
                    bs.frequency_code,
                    r.reason Reason,
                    b.blackout_desc Comments,
                    b.created_by "Created By",
                    b.last_updated_by "Last Updated By",
                    b.created_thru,
                    bs.duration_source,
                    bs.end_time,
                    b.last_end_time,
                    b.scheduled_time,
                    bs.interval,
                    bs.timezone_offset,
                    bs.timezone_region
                FROM 
                    mgmt_targets t,
                    mgmt_blackout_target_details btd,
                    mgmt_blackouts b,
                    mgmt_blackout_reason r,
                    mgmt_blackout_schedule bs,
                    TABLE(CAST(l_blk_host_targets AS SMP_EMD_NVPAIR_ARRAY)) hosts
                WHERE
                    b.blackout_status NOT IN (mgmt_blackout_engine.BLK_STATE_START_FAILED, 
                                        mgmt_blackout_engine.BLK_STATE_STOPPED, 
                                        mgmt_blackout_engine.BLK_STATE_ENDED) AND
                    b.scheduled_time > 
                    mgmt_blackout_engine.to_blackout_time(SYSDATE, bs.timezone_info, bs.timezone_offset, bs.timezone_region) AND
                    b.reason_id = r.reason_id (+) AND
                    b.blackout_guid = bs.blackout_guid and
                    b.blackout_guid = btd.blackout_guid and
                    b.blackout_guid = hosts.name and
                    t.emd_url = hosts.value AND
                    t.target_guid = btd.target_guid  AND 
                    t.target_guid IN 
                    (SELECT a.assoc_target_guid
                    FROM  MGMT_FLAT_TARGET_ASSOC a , MGMT_TARGETS ct
                    WHERE  ct.target_guid = a.source_target_guid AND
                    ct.target_type = p_parent_type
                    AND UPPER(ct.target_name) LIKE l_parent_search_string
                    AND a.is_membership = 1) AND 
                    UPPER(t.target_name) LIKE l_search_string escape '^'
                ORDER BY "Created By";          
            END IF;
        ELSIF ((p_parent_type IS NULL) AND ((p_target_type IS NOT NULL) AND (p_target_type != ALL_TARGET_TYPES))) THEN
            OPEN p_lists_out FOR
            SELECT
                /*+ FIRST_ROWS */
                bs.blackout_guid,
                b.blackout_name,
                t.target_name Target,
                t.target_type,
                t.type_display_name,
                b.blackout_status Status,
              DECODE((SELECT property_value
                      FROM mgmt_type_properties 
                      WHERE target_type   = t.target_type AND
                            property_name = mgmt_global.G_IS_AGGREGATE_PROP ), 1,
                mgmt_blackout_ui.does_include_members(b.blackout_guid, t.target_guid),
                DECODE(t.target_type, mgmt_global.G_HOST_TARGET_TYPE,
                  mgmt_blackout_ui.does_include_members(b.blackout_guid, t.target_guid), 'N/A')) Full,
                bs.start_time,
                bs.duration,
                bs.frequency_code,
                r.reason Reason,
                b.blackout_desc Comments,
                b.created_by "Created By",
                b.last_updated_by "Last Updated By",
                b.created_thru,
                bs.duration_source,
                bs.end_time,
                b.last_end_time,
                b.scheduled_time,
                bs.interval,
                bs.timezone_offset,
                bs.timezone_region
            FROM
                mgmt_targets t,
                mgmt_blackouts b,
                mgmt_blackout_schedule bs,
                mgmt_blackout_reason r,
                mgmt_blackout_flat_targets bft,
                mgmt_blackout_target_details mbtd
            WHERE
                b.reason_id = r.reason_id (+) AND
                b.blackout_guid = bft.blackout_guid AND
                b.blackout_guid = bs.blackout_guid AND
                bft.target_guid = t.target_guid AND
                bft.target_guid = mbtd.target_guid(+) AND
                bft.blackout_guid = mbtd.blackout_guid(+) AND 
                UPPER(t.target_name) LIKE l_search_string escape '^' AND 
                t.target_type = p_target_type 
            UNION
            SELECT
                /*+ FIRST_ROWS */
                bs.blackout_guid,
                b.blackout_name,
                t.target_name Target,
                t.target_type,
                t.type_display_name,
                b.blackout_status Status,
              DECODE((SELECT property_value
                      FROM mgmt_type_properties 
                      WHERE target_type   = t.target_type AND
                            property_name = mgmt_global.G_IS_AGGREGATE_PROP ), 1,
                mgmt_blackout_ui.does_include_members(b.blackout_guid, t.target_guid),
                DECODE(t.target_type, mgmt_global.G_HOST_TARGET_TYPE,
                  mgmt_blackout_ui.does_include_members(b.blackout_guid, t.target_guid), 'N/A')) Full,
                bs.start_time,
                bs.duration,
                bs.frequency_code,
                r.reason Reason,
                b.blackout_desc Comments,
                b.created_by "Created By",
                b.last_updated_by "Last Updated By",
                b.created_thru,
                bs.duration_source,
                bs.end_time,
                b.last_end_time,
                b.scheduled_time,
                bs.interval,
                bs.timezone_offset,
                bs.timezone_region
            FROM
                mgmt_targets t,
                mgmt_blackouts b,
                mgmt_blackout_schedule bs,
                mgmt_blackout_reason r,
                mgmt_flat_target_assoc assoc,
                mgmt_blackout_target_details btd
            WHERE
                b.blackout_status NOT IN (mgmt_blackout_engine.BLK_STATE_START_FAILED, 
                                        mgmt_blackout_engine.BLK_STATE_STOPPED, 
                                        mgmt_blackout_engine.BLK_STATE_ENDED) AND
                b.scheduled_time > 
                mgmt_blackout_engine.to_blackout_time(SYSDATE, bs.timezone_info, bs.timezone_offset, bs.timezone_region) AND
                b.reason_id = r.reason_id (+) AND
                b.blackout_guid = bs.blackout_guid AND
                b.blackout_guid = btd.blackout_guid AND
                assoc.source_target_guid = btd.target_guid AND
                assoc.assoc_target_guid = t.target_guid AND
                assoc.is_membership =1 AND
                btd.include_members =1 AND 
                UPPER(t.target_name) LIKE l_search_string escape '^' AND 
                t.target_type = p_target_type 
            UNION
            SELECT
                /*+ FIRST_ROWS */
                bs.blackout_guid,
                b.blackout_name,
                t.target_name Target,
                t.target_type,
                t.type_display_name,
                b.blackout_status Status,
                DECODE((SELECT property_value
                        FROM mgmt_type_properties 
                        WHERE target_type   = t.target_type AND
                              property_name = mgmt_global.G_IS_AGGREGATE_PROP ), 1,
                  mgmt_blackout_ui.does_include_members(b.blackout_guid, t.target_guid),
                  DECODE(t.target_type, mgmt_global.G_HOST_TARGET_TYPE,
                    mgmt_blackout_ui.does_include_members(b.blackout_guid, t.target_guid), 'N/A')) Full,
                bs.start_time,
                bs.duration,
                bs.frequency_code,
                r.reason Reason,
                b.blackout_desc Comments,
                b.created_by "Created By",
                b.last_updated_by "Last Updated By",
                b.created_thru,
                bs.duration_source,
                bs.end_time,
                b.last_end_time,
                b.scheduled_time,
                bs.interval,
                bs.timezone_offset,
                bs.timezone_region
            FROM 
                mgmt_targets t,
                mgmt_blackout_target_details btd,
                mgmt_blackouts b,
                mgmt_blackout_reason r,
                mgmt_blackout_schedule bs,
                TABLE(CAST(l_blk_host_targets AS SMP_EMD_NVPAIR_ARRAY)) hosts
            WHERE
                b.blackout_status NOT IN (mgmt_blackout_engine.BLK_STATE_START_FAILED, 
                                        mgmt_blackout_engine.BLK_STATE_STOPPED, 
                                        mgmt_blackout_engine.BLK_STATE_ENDED) AND
                b.scheduled_time > 
                mgmt_blackout_engine.to_blackout_time(SYSDATE, bs.timezone_info, bs.timezone_offset, bs.timezone_region) AND
                b.reason_id = r.reason_id (+) AND
                b.blackout_guid = bs.blackout_guid and
                b.blackout_guid = btd.blackout_guid and
                b.blackout_guid = hosts.name and
                t.emd_url = hosts.value AND
                t.target_guid = btd.target_guid AND 
                UPPER(t.target_name) LIKE l_search_string escape '^' AND 
                t.target_type = p_target_type 
            ORDER BY "Created By";          
        END IF;
    ELSIF (p_blk_type = mgmt_blackout_ui.FUTURE_BLACKOUTS) THEN
        IF (p_parent_type IS NULL) AND (p_target_type IS NULL OR p_target_type = ALL_TARGET_TYPES) THEN
            OPEN p_lists_out FOR
            SELECT
                /*+ FIRST_ROWS */
                b.blackout_guid,
                b.blackout_name,
                t.target_name Target,
                t.target_type,
                t.type_display_name,
                b.blackout_status Status,
                DECODE((SELECT property_value
                        FROM mgmt_type_properties 
                        WHERE target_type   = t.target_type AND
                              property_name = mgmt_global.G_IS_AGGREGATE_PROP ), 1,
                  mgmt_blackout_ui.does_include_members(b.blackout_guid, t.target_guid),
                  DECODE(t.target_type, mgmt_global.G_HOST_TARGET_TYPE,
                    mgmt_blackout_ui.does_include_members(b.blackout_guid, t.target_guid), 'N/A')) Full,
                bs.start_time,
                bs.duration,
                bs.frequency_code,
                r.reason Reason,
                b.blackout_desc Comments,
                b.created_by "Created By",
                b.last_updated_by "Last Updated By",
                b.created_thru,
                bs.duration_source,
                bs.end_time,
                b.last_end_time,
                b.scheduled_time,
                bs.interval,
                bs.timezone_offset,
                bs.timezone_region
            FROM
                mgmt_targets t,
                mgmt_blackouts b,
                mgmt_blackout_schedule bs,
                mgmt_blackout_reason r,
                mgmt_blackout_flat_targets bft,
                mgmt_blackout_target_details btd
            WHERE
                b.blackout_status NOT IN (mgmt_blackout_engine.BLK_STATE_START_FAILED, 
                                        mgmt_blackout_engine.BLK_STATE_STOPPED, 
                                        mgmt_blackout_engine.BLK_STATE_ENDED) AND
                b.scheduled_time > 
                mgmt_blackout_engine.to_blackout_time(SYSDATE, bs.timezone_info, bs.timezone_offset, bs.timezone_region) AND
                b.reason_id = r.reason_id (+) AND
                b.blackout_guid = bft.blackout_guid AND
                b.blackout_guid = bs.blackout_guid AND
                bft.target_guid = t.target_guid AND
                btd.blackout_guid(+) = bft.blackout_guid AND
                btd.target_guid(+) = bft.target_guid  AND
                UPPER(t.target_name) LIKE l_search_string escape '^'
            UNION
            SELECT 
                /*+ FIRST_ROWS */
                b.blackout_guid,
                b.blackout_name,
                t.target_name Target,
                t.target_type,
                t.type_display_name,
                b.blackout_status Status,
                DECODE((SELECT property_value
                        FROM mgmt_type_properties 
                        WHERE target_type   = t.target_type AND
                              property_name = mgmt_global.G_IS_AGGREGATE_PROP ), 1,
                  mgmt_blackout_ui.does_include_members(b.blackout_guid, t.target_guid),
                  DECODE(t.target_type, mgmt_global.G_HOST_TARGET_TYPE,
                    mgmt_blackout_ui.does_include_members(b.blackout_guid, t.target_guid), 'N/A')) Full,
                bs.start_time,
                bs.duration,
                bs.frequency_code,
                r.reason Reason,
                b.blackout_desc Comments,
                b.created_by "Created By",
                b.last_updated_by "Last Updated By",
                b.created_thru,
                bs.duration_source,
                bs.end_time,
                b.last_end_time,
                b.scheduled_time,
                bs.interval,
                bs.timezone_offset,
                bs.timezone_region
            FROM
                mgmt_targets t,
                mgmt_blackouts b,
                mgmt_blackout_schedule bs,
                mgmt_blackout_reason r,
                mgmt_flat_target_assoc assoc,
                mgmt_blackout_target_details btd
            WHERE
                b.blackout_status NOT IN (mgmt_blackout_engine.BLK_STATE_START_FAILED, 
                                        mgmt_blackout_engine.BLK_STATE_STOPPED, 
                                        mgmt_blackout_engine.BLK_STATE_ENDED) AND
                b.scheduled_time > 
                mgmt_blackout_engine.to_blackout_time(SYSDATE, bs.timezone_info, bs.timezone_offset, bs.timezone_region) AND
                b.reason_id = r.reason_id (+) AND
                b.blackout_guid = bs.blackout_guid AND
                b.blackout_guid = btd.blackout_guid AND
                assoc.source_target_guid = btd.target_guid AND
                assoc.assoc_target_guid = t.target_guid AND
                assoc.is_membership =1 AND
                btd.include_members =1  AND
                UPPER(t.target_name) LIKE l_search_string escape '^'
            UNION
            SELECT 
                /*+ FIRST_ROWS */
                b.blackout_guid,
                b.blackout_name,
                t.target_name Target,
                t.target_type,
                t.type_display_name,
                b.blackout_status Status,
                DECODE((SELECT property_value
                        FROM mgmt_type_properties 
                        WHERE target_type   = t.target_type AND
                              property_name = mgmt_global.G_IS_AGGREGATE_PROP ), 1,
                  mgmt_blackout_ui.does_include_members(b.blackout_guid, t.target_guid),
                  DECODE(t.target_type, mgmt_global.G_HOST_TARGET_TYPE,
                    mgmt_blackout_ui.does_include_members(b.blackout_guid, t.target_guid), 'N/A')) Full,
                bs.start_time,
                bs.duration,
                bs.frequency_code,
                r.reason Reason,
                b.blackout_desc Comments,
                b.created_by "Created By",
                b.last_updated_by "Last Updated By",
                b.created_thru,
                bs.duration_source,
                bs.end_time,
                b.last_end_time,
                b.scheduled_time,
                bs.interval,
                bs.timezone_offset,
                bs.timezone_region
            FROM 
                mgmt_targets t,
                mgmt_blackout_target_details btd,
                mgmt_blackouts b,
                mgmt_blackout_reason r,
                mgmt_blackout_schedule bs,
                TABLE(CAST(l_blk_host_targets AS SMP_EMD_NVPAIR_ARRAY)) hosts
            WHERE  
                b.blackout_status NOT IN (mgmt_blackout_engine.BLK_STATE_START_FAILED, 
                                        mgmt_blackout_engine.BLK_STATE_STOPPED, 
                                        mgmt_blackout_engine.BLK_STATE_ENDED) AND
                b.scheduled_time > 
                mgmt_blackout_engine.to_blackout_time(SYSDATE, bs.timezone_info, bs.timezone_offset, bs.timezone_region) AND
                b.reason_id = r.reason_id (+) AND
                b.blackout_guid = bs.blackout_guid and
                b.blackout_guid = btd.blackout_guid and
                b.blackout_guid = hosts.name and
                t.emd_url = hosts.value AND
                t.target_guid = btd.target_guid  AND
                UPPER(t.target_name) LIKE l_search_string escape '^'
            ORDER BY "Created By";     
        ELSIF ((p_parent_type IS NOT NULL) AND ((p_target_type IS NOT NULL) AND (p_target_type != ALL_TARGET_TYPES))) THEN
            IF (p_parent_type = mgmt_blackout_ui.PARENT_TYPE_HOST) THEN
                OPEN p_lists_out FOR
                SELECT
                    /*+ FIRST_ROWS */
                    b.blackout_guid,
                    b.blackout_name,
                    t.target_name Target,
                    t.target_type,
                    t.type_display_name,
                    b.blackout_status Status,
                    DECODE((SELECT property_value
                            FROM mgmt_type_properties 
                            WHERE target_type   = t.target_type AND
                                  property_name = mgmt_global.G_IS_AGGREGATE_PROP ), 1,
                      mgmt_blackout_ui.does_include_members(b.blackout_guid, t.target_guid),
                      DECODE(t.target_type, mgmt_global.G_HOST_TARGET_TYPE,
                        mgmt_blackout_ui.does_include_members(b.blackout_guid, t.target_guid), 'N/A')) Full,
                    bs.start_time,
                    bs.duration,
                    bs.frequency_code,
                    r.reason Reason,
                    b.blackout_desc Comments,
                    b.created_by "Created By",
                    b.last_updated_by "Last Updated By",
                    b.created_thru,
                    bs.duration_source,
                    bs.end_time,
                    b.last_end_time,
                    b.scheduled_time,
                    bs.interval,
                    bs.timezone_offset,
                    bs.timezone_region
                FROM
                    mgmt_targets t,
                    mgmt_blackouts b,
                    mgmt_blackout_schedule bs,
                    mgmt_blackout_reason r,
                    mgmt_blackout_flat_targets bft,
                    mgmt_blackout_target_details btd
                WHERE
                    b.blackout_status NOT IN (mgmt_blackout_engine.BLK_STATE_START_FAILED, 
                                        mgmt_blackout_engine.BLK_STATE_STOPPED, 
                                        mgmt_blackout_engine.BLK_STATE_ENDED) AND
                    b.scheduled_time > 
                    mgmt_blackout_engine.to_blackout_time(SYSDATE, bs.timezone_info, bs.timezone_offset, bs.timezone_region) AND
                    b.reason_id = r.reason_id (+) AND
                    b.blackout_guid = bft.blackout_guid AND
                    b.blackout_guid = bs.blackout_guid AND
                    bft.target_guid = t.target_guid AND
                    btd.blackout_guid(+) = bft.blackout_guid AND
                    btd.target_guid(+) = bft.target_guid AND 
                    UPPER(t.host_name) LIKE l_parent_search_string AND
                    UPPER(t.target_name) LIKE l_search_string escape '^' AND 
                    t.target_type = p_target_type
                UNION
                SELECT 
                    /*+ FIRST_ROWS */
                    b.blackout_guid,
                    b.blackout_name,
                    t.target_name Target,
                    t.target_type,
                    t.type_display_name,
                    b.blackout_status Status,
                    DECODE((SELECT property_value
                            FROM mgmt_type_properties 
                            WHERE target_type   = t.target_type AND
                                  property_name = mgmt_global.G_IS_AGGREGATE_PROP ), 1,
                      mgmt_blackout_ui.does_include_members(b.blackout_guid, t.target_guid),
                      DECODE(t.target_type, mgmt_global.G_HOST_TARGET_TYPE,
                        mgmt_blackout_ui.does_include_members(b.blackout_guid, t.target_guid), 'N/A')) Full,
                    bs.start_time,
                    bs.duration,
                    bs.frequency_code,
                    r.reason Reason,
                    b.blackout_desc Comments,
                    b.created_by "Created By",
                    b.last_updated_by "Last Updated By",
                    b.created_thru,
                    bs.duration_source,
                    bs.end_time,
                    b.last_end_time,
                    b.scheduled_time,
                    bs.interval,
                    bs.timezone_offset,
                    bs.timezone_region
                FROM
                    mgmt_targets t,
                    mgmt_blackouts b,
                    mgmt_blackout_schedule bs,
                    mgmt_blackout_reason r,
                    mgmt_flat_target_assoc assoc,
                    mgmt_blackout_target_details btd
                WHERE
                    b.blackout_status NOT IN (mgmt_blackout_engine.BLK_STATE_START_FAILED, 
                                        mgmt_blackout_engine.BLK_STATE_STOPPED, 
                                        mgmt_blackout_engine.BLK_STATE_ENDED) AND
                    b.scheduled_time > 
                    mgmt_blackout_engine.to_blackout_time(SYSDATE, bs.timezone_info, bs.timezone_offset, bs.timezone_region) AND
                    b.reason_id = r.reason_id (+) AND
                    b.blackout_guid = bs.blackout_guid AND
                    b.blackout_guid = btd.blackout_guid AND
                    assoc.source_target_guid = btd.target_guid AND
                    assoc.assoc_target_guid = t.target_guid AND
                    assoc.is_membership =1 AND
                    btd.include_members =1 AND 
                    UPPER(t.host_name) LIKE l_parent_search_string AND
                    UPPER(t.target_name) LIKE l_search_string escape '^' AND 
                    t.target_type = p_target_type
                UNION
                SELECT 
                    /*+ FIRST_ROWS */
                    b.blackout_guid,
                    b.blackout_name,
                    t.target_name Target,
                    t.target_type,
                    t.type_display_name,
                    b.blackout_status Status,
                    DECODE((SELECT property_value
                            FROM mgmt_type_properties 
                            WHERE target_type   = t.target_type AND
                                  property_name = mgmt_global.G_IS_AGGREGATE_PROP ), 1,
                      mgmt_blackout_ui.does_include_members(b.blackout_guid, t.target_guid),
                      DECODE(t.target_type, mgmt_global.G_HOST_TARGET_TYPE,
                        mgmt_blackout_ui.does_include_members(b.blackout_guid, t.target_guid), 'N/A')) Full,
                    bs.start_time,
                    bs.duration,
                    bs.frequency_code,
                    r.reason Reason,
                    b.blackout_desc Comments,
                    b.created_by "Created By",
                    b.last_updated_by "Last Updated By",
                    b.created_thru,
                    bs.duration_source,
                    bs.end_time,
                    b.last_end_time,
                    b.scheduled_time,
                    bs.interval,
                    bs.timezone_offset,
                    bs.timezone_region
                FROM 
                    mgmt_targets t,
                    mgmt_blackout_target_details btd,
                    mgmt_blackouts b,
                    mgmt_blackout_reason r,
                    mgmt_blackout_schedule bs,
                    TABLE(CAST(l_blk_host_targets AS SMP_EMD_NVPAIR_ARRAY)) hosts
                WHERE  
                    b.blackout_status NOT IN (mgmt_blackout_engine.BLK_STATE_START_FAILED, 
                                        mgmt_blackout_engine.BLK_STATE_STOPPED, 
                                        mgmt_blackout_engine.BLK_STATE_ENDED) AND
                    b.scheduled_time > 
                    mgmt_blackout_engine.to_blackout_time(SYSDATE, bs.timezone_info, bs.timezone_offset, bs.timezone_region) AND
                    b.reason_id = r.reason_id (+) AND
                    b.blackout_guid = bs.blackout_guid and
                    b.blackout_guid = btd.blackout_guid and
                    b.blackout_guid = hosts.name and
                    t.emd_url = hosts.value AND
                    t.target_guid = btd.target_guid  AND 
                    UPPER(t.host_name) LIKE l_parent_search_string AND
                    UPPER(t.target_name) LIKE l_search_string escape '^' AND 
                    t.target_type = p_target_type
                ORDER BY "Created By";     
            ELSE
                OPEN P_lists_out FOR
                SELECT
                    /*+ FIRST_ROWS */
                    b.blackout_guid,
                    b.blackout_name,
                    t.target_name Target,
                    t.target_type,
                    t.type_display_name,
                    b.blackout_status Status,
                    DECODE((SELECT property_value
                            FROM mgmt_type_properties 
                            WHERE target_type   = t.target_type AND
                                  property_name = mgmt_global.G_IS_AGGREGATE_PROP ), 1,
                      mgmt_blackout_ui.does_include_members(b.blackout_guid, t.target_guid),
                      DECODE(t.target_type, mgmt_global.G_HOST_TARGET_TYPE,
                        mgmt_blackout_ui.does_include_members(b.blackout_guid, t.target_guid), 'N/A')) Full,
                    bs.start_time,
                    bs.duration,
                    bs.frequency_code,
                    r.reason Reason,
                    b.blackout_desc Comments,
                    b.created_by "Created By",
                    b.last_updated_by "Last Updated By",
                    b.created_thru,
                    bs.duration_source,
                    bs.end_time,
                    b.last_end_time,
                    b.scheduled_time,
                    bs.interval,
                    bs.timezone_offset,
                    bs.timezone_region
                FROM
                    mgmt_targets t,
                    mgmt_blackouts b,
                    mgmt_blackout_schedule bs,
                    mgmt_blackout_reason r,
                    mgmt_blackout_flat_targets bft,
                    mgmt_blackout_target_details btd
                WHERE
                    b.blackout_status NOT IN (mgmt_blackout_engine.BLK_STATE_START_FAILED, 
                                        mgmt_blackout_engine.BLK_STATE_STOPPED, 
                                        mgmt_blackout_engine.BLK_STATE_ENDED) AND
                    b.scheduled_time > 
                    mgmt_blackout_engine.to_blackout_time(SYSDATE, bs.timezone_info, bs.timezone_offset, bs.timezone_region) AND
                    b.reason_id = r.reason_id (+) AND
                    b.blackout_guid = bft.blackout_guid AND
                    b.blackout_guid = bs.blackout_guid AND
                    bft.target_guid = t.target_guid AND
                    btd.blackout_guid(+) = bft.blackout_guid AND
                    btd.target_guid(+) = bft.target_guid  AND 
                    t.target_guid IN 
                    (SELECT a.assoc_target_guid
                    FROM  MGMT_FLAT_TARGET_ASSOC a , MGMT_TARGETS ct
                    WHERE  ct.target_guid = a.source_target_guid AND
                    ct.target_type = p_parent_type
                    AND UPPER(ct.target_name) LIKE l_parent_search_string
                    AND a.is_membership = 1) AND 
                    UPPER(t.target_name) LIKE l_search_string escape '^' AND 
                    t.target_type = p_target_type 
                UNION
                SELECT 
                    /*+ FIRST_ROWS */
                    b.blackout_guid,
                    b.blackout_name,
                    t.target_name Target,
                    t.target_type,
                    t.type_display_name,
                    b.blackout_status Status,
                    DECODE((SELECT property_value
                            FROM mgmt_type_properties 
                            WHERE target_type   = t.target_type AND
                                  property_name = mgmt_global.G_IS_AGGREGATE_PROP ), 1,
                      mgmt_blackout_ui.does_include_members(b.blackout_guid, t.target_guid),
                      DECODE(t.target_type, mgmt_global.G_HOST_TARGET_TYPE,
                        mgmt_blackout_ui.does_include_members(b.blackout_guid, t.target_guid), 'N/A')) Full,
                    bs.start_time,
                    bs.duration,
                    bs.frequency_code,
                    r.reason Reason,
                    b.blackout_desc Comments,
                    b.created_by "Created By",
                    b.last_updated_by "Last Updated By",
                    b.created_thru,
                    bs.duration_source,
                    bs.end_time,
                    b.last_end_time,
                    b.scheduled_time,
                    bs.interval,
                    bs.timezone_offset,
                    bs.timezone_region
                FROM
                    mgmt_targets t,
                    mgmt_blackouts b,
                    mgmt_blackout_schedule bs,
                    mgmt_blackout_reason r,
                    mgmt_flat_target_assoc assoc,
                    mgmt_blackout_target_details btd
                WHERE
                    b.blackout_status NOT IN (mgmt_blackout_engine.BLK_STATE_START_FAILED, 
                                        mgmt_blackout_engine.BLK_STATE_STOPPED, 
                                        mgmt_blackout_engine.BLK_STATE_ENDED) AND
                    b.scheduled_time > 
                    mgmt_blackout_engine.to_blackout_time(SYSDATE, bs.timezone_info, bs.timezone_offset, bs.timezone_region) AND
                    b.reason_id = r.reason_id (+) AND
                    b.blackout_guid = bs.blackout_guid AND
                    b.blackout_guid = btd.blackout_guid AND
                    assoc.source_target_guid = btd.target_guid AND
                    assoc.assoc_target_guid = t.target_guid AND
                    assoc.is_membership =1 AND
                    btd.include_members =1  AND 
                    t.target_guid IN 
                    (SELECT a.assoc_target_guid
                    FROM  MGMT_FLAT_TARGET_ASSOC a , MGMT_TARGETS ct
                    WHERE  ct.target_guid = a.source_target_guid AND
                    ct.target_type = p_parent_type
                    AND UPPER(ct.target_name) LIKE l_parent_search_string
                    AND a.is_membership = 1) AND 
                    UPPER(t.target_name) LIKE l_search_string escape '^' AND 
                    t.target_type = p_target_type 
                UNION
                SELECT 
                    /*+ FIRST_ROWS */
                    b.blackout_guid,
                    b.blackout_name,
                    t.target_name Target,
                    t.target_type,
                    t.type_display_name,
                    b.blackout_status Status,
                    DECODE((SELECT property_value
                            FROM mgmt_type_properties 
                            WHERE target_type   = t.target_type AND
                                  property_name = mgmt_global.G_IS_AGGREGATE_PROP ), 1,
                      mgmt_blackout_ui.does_include_members(b.blackout_guid, t.target_guid),
                      DECODE(t.target_type, mgmt_global.G_HOST_TARGET_TYPE,
                        mgmt_blackout_ui.does_include_members(b.blackout_guid, t.target_guid), 'N/A')) Full,
                    bs.start_time,
                    bs.duration,
                    bs.frequency_code,
                    r.reason Reason,
                    b.blackout_desc Comments,
                    b.created_by "Created By",
                    b.last_updated_by "Last Updated By",
                    b.created_thru,
                    bs.duration_source,
                    bs.end_time,
                    b.last_end_time,
                    b.scheduled_time,
                    bs.interval,
                    bs.timezone_offset,
                    bs.timezone_region
                FROM 
                    mgmt_targets t,
                    mgmt_blackout_target_details btd,
                    mgmt_blackouts b,
                    mgmt_blackout_reason r,
                    mgmt_blackout_schedule bs,
                    TABLE(CAST(l_blk_host_targets AS SMP_EMD_NVPAIR_ARRAY)) hosts
                WHERE  
                    b.blackout_status NOT IN (mgmt_blackout_engine.BLK_STATE_START_FAILED, 
                                        mgmt_blackout_engine.BLK_STATE_STOPPED, 
                                        mgmt_blackout_engine.BLK_STATE_ENDED) AND
                    b.scheduled_time > 
                    mgmt_blackout_engine.to_blackout_time(SYSDATE, bs.timezone_info, bs.timezone_offset, bs.timezone_region) AND
                    b.reason_id = r.reason_id (+) AND
                    b.blackout_guid = bs.blackout_guid and
                    b.blackout_guid = btd.blackout_guid and
                    b.blackout_guid = hosts.name and
                    t.emd_url = hosts.value AND
                    t.target_guid = btd.target_guid  AND 
                    t.target_guid IN 
                    (SELECT a.assoc_target_guid
                    FROM  MGMT_FLAT_TARGET_ASSOC a , MGMT_TARGETS ct
                    WHERE  ct.target_guid = a.source_target_guid AND
                    ct.target_type = p_parent_type
                    AND UPPER(ct.target_name) LIKE l_parent_search_string
                    AND a.is_membership = 1) AND 
                    UPPER(t.target_name) LIKE l_search_string escape '^' AND 
                    t.target_type = p_target_type 
                ORDER BY "Created By";     
           END IF;
        ELSIF (p_parent_type IS NOT NULL) AND (p_target_type IS NULL OR p_target_type = ALL_TARGET_TYPES) THEN
            IF (p_parent_type = mgmt_blackout_ui.PARENT_TYPE_HOST) THEN
                OPEN p_lists_out FOR
                SELECT
                    /*+ FIRST_ROWS */
                    b.blackout_guid,
                    b.blackout_name,
                    t.target_name Target,
                    t.target_type,
                    t.type_display_name,
                    b.blackout_status Status,
                    DECODE((SELECT property_value
                            FROM mgmt_type_properties 
                            WHERE target_type   = t.target_type AND
                                  property_name = mgmt_global.G_IS_AGGREGATE_PROP ), 1,
                      mgmt_blackout_ui.does_include_members(b.blackout_guid, t.target_guid),
                      DECODE(t.target_type, mgmt_global.G_HOST_TARGET_TYPE,
                        mgmt_blackout_ui.does_include_members(b.blackout_guid, t.target_guid), 'N/A')) Full,
                    bs.start_time,
                    bs.duration,
                    bs.frequency_code,
                    r.reason Reason,
                    b.blackout_desc Comments,
                    b.created_by "Created By",
                    b.last_updated_by "Last Updated By",
                    b.created_thru,
                    bs.duration_source,
                    bs.end_time,
                    b.last_end_time,
                    b.scheduled_time,
                    bs.interval,
                    bs.timezone_offset,
                    bs.timezone_region
                FROM
                    mgmt_targets t,
                    mgmt_blackouts b,
                    mgmt_blackout_schedule bs,
                    mgmt_blackout_reason r,
                    mgmt_blackout_flat_targets bft,
                    mgmt_blackout_target_details btd
                WHERE
                    b.blackout_status NOT IN (mgmt_blackout_engine.BLK_STATE_START_FAILED, 
                                        mgmt_blackout_engine.BLK_STATE_STOPPED, 
                                        mgmt_blackout_engine.BLK_STATE_ENDED) AND
                    b.scheduled_time > 
                    mgmt_blackout_engine.to_blackout_time(SYSDATE, bs.timezone_info, bs.timezone_offset, bs.timezone_region) AND
                    b.reason_id = r.reason_id (+) AND
                    b.blackout_guid = bft.blackout_guid AND
                    b.blackout_guid = bs.blackout_guid AND
                    bft.target_guid = t.target_guid AND
                    btd.blackout_guid(+) = bft.blackout_guid AND
                    btd.target_guid(+) = bft.target_guid AND 
                    UPPER(t.host_name) LIKE l_parent_search_string AND
                    UPPER(t.target_name) LIKE l_search_string escape '^'
                UNION
                SELECT 
                    /*+ FIRST_ROWS */
                    b.blackout_guid,
                    b.blackout_name,
                    t.target_name Target,
                    t.target_type,
                    t.type_display_name,
                    b.blackout_status Status,
                    DECODE((SELECT property_value
                            FROM mgmt_type_properties 
                            WHERE target_type   = t.target_type AND
                                  property_name = mgmt_global.G_IS_AGGREGATE_PROP ), 1,
                      mgmt_blackout_ui.does_include_members(b.blackout_guid, t.target_guid),
                      DECODE(t.target_type, mgmt_global.G_HOST_TARGET_TYPE,
                        mgmt_blackout_ui.does_include_members(b.blackout_guid, t.target_guid), 'N/A')) Full,
                    bs.start_time,
                    bs.duration,
                    bs.frequency_code,
                    r.reason Reason,
                    b.blackout_desc Comments,
                    b.created_by "Created By",
                    b.last_updated_by "Last Updated By",
                    b.created_thru,
                    bs.duration_source,
                    bs.end_time,
                    b.last_end_time,
                    b.scheduled_time,
                    bs.interval,
                    bs.timezone_offset,
                    bs.timezone_region
                FROM
                    mgmt_targets t,
                    mgmt_blackouts b,
                    mgmt_blackout_schedule bs,
                    mgmt_blackout_reason r,
                    mgmt_flat_target_assoc assoc,
                    mgmt_blackout_target_details btd
                WHERE
                    b.blackout_status NOT IN (mgmt_blackout_engine.BLK_STATE_START_FAILED, 
                                        mgmt_blackout_engine.BLK_STATE_STOPPED, 
                                        mgmt_blackout_engine.BLK_STATE_ENDED) AND
                    b.scheduled_time > 
                    mgmt_blackout_engine.to_blackout_time(SYSDATE, bs.timezone_info, bs.timezone_offset, bs.timezone_region) AND
                    b.reason_id = r.reason_id (+) AND
                    b.blackout_guid = bs.blackout_guid AND
                    b.blackout_guid = btd.blackout_guid AND
                    assoc.source_target_guid = btd.target_guid AND
                    assoc.assoc_target_guid = t.target_guid AND
                    assoc.is_membership =1 AND
                    btd.include_members =1 AND 
                    UPPER(t.host_name) LIKE l_parent_search_string AND
                    UPPER(t.target_name) LIKE l_search_string escape '^' 
                UNION
                SELECT 
                    /*+ FIRST_ROWS */
                    b.blackout_guid,
                    b.blackout_name,
                    t.target_name Target,
                    t.target_type,
                    t.type_display_name,
                    b.blackout_status Status,
                    DECODE((SELECT property_value
                            FROM mgmt_type_properties 
                            WHERE target_type   = t.target_type AND
                                  property_name = mgmt_global.G_IS_AGGREGATE_PROP ), 1,
                      mgmt_blackout_ui.does_include_members(b.blackout_guid, t.target_guid),
                      DECODE(t.target_type, mgmt_global.G_HOST_TARGET_TYPE,
                        mgmt_blackout_ui.does_include_members(b.blackout_guid, t.target_guid), 'N/A')) Full,
                    bs.start_time,
                    bs.duration,
                    bs.frequency_code,
                    r.reason Reason,
                    b.blackout_desc Comments,
                    b.created_by "Created By",
                    b.last_updated_by "Last Updated By",
                    b.created_thru,
                    bs.duration_source,
                    bs.end_time,
                    b.last_end_time,
                    b.scheduled_time,
                    bs.interval,
                    bs.timezone_offset,
                    bs.timezone_region
                    FROM mgmt_targets t,
                    mgmt_blackout_target_details btd,
                    mgmt_blackouts b,
                    mgmt_blackout_reason r,
                    mgmt_blackout_schedule bs,
                    TABLE(CAST(l_blk_host_targets AS SMP_EMD_NVPAIR_ARRAY)) hosts
                WHERE  
                    b.blackout_status NOT IN (mgmt_blackout_engine.BLK_STATE_START_FAILED, 
                                        mgmt_blackout_engine.BLK_STATE_STOPPED, 
                                        mgmt_blackout_engine.BLK_STATE_ENDED) AND
                    b.scheduled_time > 
                    mgmt_blackout_engine.to_blackout_time(SYSDATE, bs.timezone_info, bs.timezone_offset, bs.timezone_region) AND
                    b.reason_id = r.reason_id (+) AND
                    b.blackout_guid = bs.blackout_guid and
                    b.blackout_guid = btd.blackout_guid and
                    b.blackout_guid = hosts.name and
                    t.emd_url = hosts.value AND
                    t.target_guid = btd.target_guid  AND 
                    UPPER(t.host_name) LIKE l_parent_search_string AND
                    UPPER(t.target_name) LIKE l_search_string escape '^' 
                ORDER BY "Created By";     
           ELSE
                OPEN p_lists_out FOR
                SELECT
                    /*+ FIRST_ROWS */
                    b.blackout_guid,
                    b.blackout_name,
                    t.target_name Target,
                    t.target_type,
                    t.type_display_name,
                    b.blackout_status Status,
                    DECODE((SELECT property_value
                            FROM mgmt_type_properties 
                            WHERE target_type   = t.target_type AND
                                  property_name = mgmt_global.G_IS_AGGREGATE_PROP ), 1,
                      mgmt_blackout_ui.does_include_members(b.blackout_guid, t.target_guid),
                      DECODE(t.target_type, mgmt_global.G_HOST_TARGET_TYPE,
                        mgmt_blackout_ui.does_include_members(b.blackout_guid, t.target_guid), 'N/A')) Full,
                    bs.start_time,
                    bs.duration,
                    bs.frequency_code,
                    r.reason Reason,
                    b.blackout_desc Comments,
                    b.created_by "Created By",
                    b.last_updated_by "Last Updated By",
                    b.created_thru,
                    bs.duration_source,
                    bs.end_time,
                    b.last_end_time,
                    b.scheduled_time,
                    bs.interval,
                    bs.timezone_offset,
                    bs.timezone_region
                FROM
                    mgmt_targets t,
                    mgmt_blackouts b,
                    mgmt_blackout_schedule bs,
                    mgmt_blackout_reason r,
                    mgmt_blackout_flat_targets bft,
                    mgmt_blackout_target_details btd
                WHERE
                    b.blackout_status NOT IN (mgmt_blackout_engine.BLK_STATE_START_FAILED, 
                                        mgmt_blackout_engine.BLK_STATE_STOPPED, 
                                        mgmt_blackout_engine.BLK_STATE_ENDED) AND
                    b.scheduled_time > 
                    mgmt_blackout_engine.to_blackout_time(SYSDATE, bs.timezone_info, bs.timezone_offset, bs.timezone_region) AND
                    b.reason_id = r.reason_id (+) AND
                    b.blackout_guid = bft.blackout_guid AND
                    b.blackout_guid = bs.blackout_guid AND
                    bft.target_guid = t.target_guid AND
                    btd.blackout_guid(+) = bft.blackout_guid AND
                    btd.target_guid(+) = bft.target_guid  AND 
                    t.target_guid IN 
                    (SELECT a.assoc_target_guid
                    FROM  MGMT_FLAT_TARGET_ASSOC a , MGMT_TARGETS ct
                    WHERE  ct.target_guid = a.source_target_guid AND
                    ct.target_type = p_parent_type
                    AND UPPER(ct.target_name) LIKE l_parent_search_string
                    AND a.is_membership = 1) AND 
                    UPPER(t.target_name) LIKE l_search_string escape '^' 
                UNION
                SELECT 
                    /*+ FIRST_ROWS */
                    b.blackout_guid,
                    b.blackout_name,
                    t.target_name Target,
                    t.target_type,
                    t.type_display_name,
                    b.blackout_status Status,
                    DECODE((SELECT property_value
                            FROM mgmt_type_properties 
                            WHERE target_type   = t.target_type AND
                                  property_name = mgmt_global.G_IS_AGGREGATE_PROP ), 1,
                      mgmt_blackout_ui.does_include_members(b.blackout_guid, t.target_guid),
                      DECODE(t.target_type, mgmt_global.G_HOST_TARGET_TYPE,
                        mgmt_blackout_ui.does_include_members(b.blackout_guid, t.target_guid), 'N/A')) Full,
                    bs.start_time,
                    bs.duration,
                    bs.frequency_code,
                    r.reason Reason,
                    b.blackout_desc Comments,
                    b.created_by "Created By",
                    b.last_updated_by "Last Updated By",
                    b.created_thru,
                    bs.duration_source,
                    bs.end_time,
                    b.last_end_time,
                    b.scheduled_time,
                    bs.interval,
                    bs.timezone_offset,
                    bs.timezone_region
                FROM
                    mgmt_targets t,
                    mgmt_blackouts b,
                    mgmt_blackout_schedule bs,
                    mgmt_blackout_reason r,
                    mgmt_flat_target_assoc assoc,
                    mgmt_blackout_target_details btd
                WHERE
                    b.blackout_status NOT IN (mgmt_blackout_engine.BLK_STATE_START_FAILED, 
                                        mgmt_blackout_engine.BLK_STATE_STOPPED, 
                                        mgmt_blackout_engine.BLK_STATE_ENDED) AND
                    b.scheduled_time > 
                    mgmt_blackout_engine.to_blackout_time(SYSDATE, bs.timezone_info, bs.timezone_offset, bs.timezone_region) AND
                    b.reason_id = r.reason_id (+) AND
                    b.blackout_guid = bs.blackout_guid AND
                    b.blackout_guid = btd.blackout_guid AND
                    assoc.source_target_guid = btd.target_guid AND
                    assoc.assoc_target_guid = t.target_guid AND
                    assoc.is_membership =1 AND
                    btd.include_members =1  AND 
                    t.target_guid IN 
                    (SELECT a.assoc_target_guid
                    FROM  MGMT_FLAT_TARGET_ASSOC a , MGMT_TARGETS ct
                    WHERE  ct.target_guid = a.source_target_guid AND
                    ct.target_type = p_parent_type
                    AND UPPER(ct.target_name) LIKE l_parent_search_string
                    AND a.is_membership = 1) AND 
                    UPPER(t.target_name) LIKE l_search_string escape '^'
                UNION
                SELECT 
                    /*+ FIRST_ROWS */
                    b.blackout_guid,
                    b.blackout_name,
                    t.target_name Target,
                    t.target_type,
                    t.type_display_name,
                    b.blackout_status Status,
                    DECODE((SELECT property_value
                            FROM mgmt_type_properties 
                            WHERE target_type   = t.target_type AND
                                  property_name = mgmt_global.G_IS_AGGREGATE_PROP ), 1,
                      mgmt_blackout_ui.does_include_members(b.blackout_guid, t.target_guid),
                      DECODE(t.target_type, mgmt_global.G_HOST_TARGET_TYPE,
                        mgmt_blackout_ui.does_include_members(b.blackout_guid, t.target_guid), 'N/A')) Full,
                    bs.start_time,
                    bs.duration,
                    bs.frequency_code,
                    r.reason Reason,
                    b.blackout_desc Comments,
                    b.created_by "Created By",
                    b.last_updated_by "Last Updated By",
                    b.created_thru,
                    bs.duration_source,
                    bs.end_time,
                    b.last_end_time,
                    b.scheduled_time,
                    bs.interval,
                    bs.timezone_offset,
                    bs.timezone_region
                FROM 
                    mgmt_targets t,
                    mgmt_blackout_target_details btd,
                    mgmt_blackouts b,
                    mgmt_blackout_reason r,
                    mgmt_blackout_schedule bs,
                    TABLE(CAST(l_blk_host_targets AS SMP_EMD_NVPAIR_ARRAY)) hosts
                WHERE  
                    b.blackout_status NOT IN (mgmt_blackout_engine.BLK_STATE_START_FAILED, 
                                        mgmt_blackout_engine.BLK_STATE_STOPPED, 
                                        mgmt_blackout_engine.BLK_STATE_ENDED) AND
                    b.scheduled_time > 
                    mgmt_blackout_engine.to_blackout_time(SYSDATE, bs.timezone_info, bs.timezone_offset, bs.timezone_region) AND
                    b.reason_id = r.reason_id (+) AND
                    b.blackout_guid = bs.blackout_guid and
                    b.blackout_guid = btd.blackout_guid and
                    b.blackout_guid = hosts.name and
                    t.emd_url = hosts.value AND
                    t.target_guid = btd.target_guid  AND 
                    t.target_guid IN 
                    (SELECT a.assoc_target_guid
                    FROM  MGMT_FLAT_TARGET_ASSOC a , MGMT_TARGETS ct
                    WHERE  ct.target_guid = a.source_target_guid AND
                    ct.target_type = p_parent_type
                    AND UPPER(ct.target_name) LIKE l_parent_search_string
                    AND a.is_membership = 1) AND 
                    UPPER(t.target_name) LIKE l_search_string escape '^'
                ORDER BY "Created By";    
            END IF;
        ELSIF ((p_parent_type IS NULL) AND ((p_target_type IS NOT NULL) AND (p_target_type != ALL_TARGET_TYPES))) THEN
            OPEN p_lists_out FOR
            SELECT
                /*+ FIRST_ROWS */
                b.blackout_guid,
                b.blackout_name,
                t.target_name Target,
                t.target_type,
                t.type_display_name,
                b.blackout_status Status,
                DECODE((SELECT property_value
                        FROM mgmt_type_properties 
                        WHERE target_type   = t.target_type AND
                              property_name = mgmt_global.G_IS_AGGREGATE_PROP ), 1,
                  mgmt_blackout_ui.does_include_members(b.blackout_guid, t.target_guid),
                  DECODE(t.target_type, mgmt_global.G_HOST_TARGET_TYPE,
                    mgmt_blackout_ui.does_include_members(b.blackout_guid, t.target_guid), 'N/A')) Full,
                bs.start_time,
                bs.duration,
                bs.frequency_code,
                r.reason Reason,
                b.blackout_desc Comments,
                b.created_by "Created By",
                b.last_updated_by "Last Updated By",
                b.created_thru,
                bs.duration_source,
                bs.end_time,
                b.last_end_time,
                b.scheduled_time,
                bs.interval,
                bs.timezone_offset,
                bs.timezone_region
            FROM
                mgmt_targets t,
                mgmt_blackouts b,
                mgmt_blackout_schedule bs,
                mgmt_blackout_reason r,
                mgmt_blackout_flat_targets bft,
                mgmt_blackout_target_details btd
            WHERE
                b.blackout_status NOT IN (mgmt_blackout_engine.BLK_STATE_START_FAILED, 
                                        mgmt_blackout_engine.BLK_STATE_STOPPED, 
                                        mgmt_blackout_engine.BLK_STATE_ENDED) AND
                b.scheduled_time > 
                mgmt_blackout_engine.to_blackout_time(SYSDATE, bs.timezone_info, bs.timezone_offset, bs.timezone_region) AND
                b.reason_id = r.reason_id (+) AND
                b.blackout_guid = bft.blackout_guid AND
                b.blackout_guid = bs.blackout_guid AND
                bft.target_guid = t.target_guid AND
                btd.blackout_guid(+) = bft.blackout_guid AND
                btd.target_guid(+) = bft.target_guid AND 
                UPPER(t.target_name) LIKE l_search_string escape '^' AND 
                t.target_type = p_target_type 
            UNION 
            SELECT 
                /*+ FIRST_ROWS */
                b.blackout_guid,
                b.blackout_name,
                t.target_name Target,
                t.target_type,
                t.type_display_name,
                b.blackout_status Status,
                DECODE((SELECT property_value
                        FROM mgmt_type_properties 
                        WHERE target_type   = t.target_type AND
                              property_name = mgmt_global.G_IS_AGGREGATE_PROP ), 1,
                  mgmt_blackout_ui.does_include_members(b.blackout_guid, t.target_guid),
                  DECODE(t.target_type, mgmt_global.G_HOST_TARGET_TYPE,
                    mgmt_blackout_ui.does_include_members(b.blackout_guid, t.target_guid), 'N/A')) Full,
                bs.start_time,
                bs.duration,
                bs.frequency_code,
                r.reason Reason,
                b.blackout_desc Comments,
                b.created_by "Created By",
                b.last_updated_by "Last Updated By",
                b.created_thru,
                bs.duration_source,
                bs.end_time,
                b.last_end_time,
                b.scheduled_time,
                bs.interval,
                bs.timezone_offset,
                bs.timezone_region
            FROM
                mgmt_targets t,
                mgmt_blackouts b,
                mgmt_blackout_schedule bs,
                mgmt_blackout_reason r,
                mgmt_flat_target_assoc assoc,
                mgmt_blackout_target_details btd
            WHERE
                b.blackout_status NOT IN (mgmt_blackout_engine.BLK_STATE_START_FAILED, 
                                        mgmt_blackout_engine.BLK_STATE_STOPPED, 
                                        mgmt_blackout_engine.BLK_STATE_ENDED) AND
                b.scheduled_time > 
                mgmt_blackout_engine.to_blackout_time(SYSDATE, bs.timezone_info, bs.timezone_offset, bs.timezone_region) AND
                b.reason_id = r.reason_id (+) AND
                b.blackout_guid = bs.blackout_guid AND
                b.blackout_guid = btd.blackout_guid AND
                assoc.source_target_guid = btd.target_guid AND
                assoc.assoc_target_guid = t.target_guid AND
                assoc.is_membership =1 AND
                btd.include_members =1 AND 
                UPPER(t.target_name) LIKE l_search_string escape '^' AND 
                t.target_type = p_target_type 
            UNION
            SELECT 
                /*+ FIRST_ROWS */
                b.blackout_guid,
                b.blackout_name,
                t.target_name Target,
                t.target_type,
                t.type_display_name,
                b.blackout_status Status,
                DECODE((SELECT property_value
                        FROM mgmt_type_properties 
                        WHERE target_type   = t.target_type AND
                              property_name = mgmt_global.G_IS_AGGREGATE_PROP ), 1,
                  mgmt_blackout_ui.does_include_members(b.blackout_guid, t.target_guid),
                  DECODE(t.target_type, mgmt_global.G_HOST_TARGET_TYPE,
                    mgmt_blackout_ui.does_include_members(b.blackout_guid, t.target_guid), 'N/A')) Full,
                bs.start_time,
                bs.duration,
                bs.frequency_code,
                r.reason Reason,
                b.blackout_desc Comments,
                b.created_by "Created By",
                b.last_updated_by "Last Updated By",
                b.created_thru,
                bs.duration_source,
                bs.end_time,
                b.last_end_time,
                b.scheduled_time,
                bs.interval,
                bs.timezone_offset,
                bs.timezone_region
            FROM 
                mgmt_targets t,
                mgmt_blackout_target_details btd,
                mgmt_blackouts b,
                mgmt_blackout_reason r,
                mgmt_blackout_schedule bs,
                TABLE(CAST(l_blk_host_targets AS SMP_EMD_NVPAIR_ARRAY)) hosts
            WHERE  
                b.blackout_status NOT IN (mgmt_blackout_engine.BLK_STATE_START_FAILED, 
                                        mgmt_blackout_engine.BLK_STATE_STOPPED, 
                                        mgmt_blackout_engine.BLK_STATE_ENDED) AND
                b.scheduled_time > 
                mgmt_blackout_engine.to_blackout_time(SYSDATE, bs.timezone_info, bs.timezone_offset, bs.timezone_region) AND
                b.reason_id = r.reason_id (+) AND
                b.blackout_guid = bs.blackout_guid and
                b.blackout_guid = btd.blackout_guid and
                b.blackout_guid = hosts.name and
                t.emd_url = hosts.value AND
                t.target_guid = btd.target_guid AND 
                UPPER(t.target_name) LIKE l_search_string escape '^' AND 
                t.target_type = p_target_type 
            ORDER BY "Created By";     
        END IF;
    ELSE -- History
        IF ((p_parent_type IS NULL) AND (p_target_type IS NULL OR p_target_type = ALL_TARGET_TYPES)) THEN
            OPEN p_lists_out FOR
            SELECT
                bs.blackout_guid,
                b.blackout_name,
                t.target_name Target,
                t.target_type,
                t.type_display_name,
                b.blackout_status Status,
                DECODE((SELECT property_value
                        FROM mgmt_type_properties 
                        WHERE target_type   = t.target_type AND
                              property_name = mgmt_global.G_IS_AGGREGATE_PROP ), 1,
                  mgmt_blackout_ui.does_include_members(b.blackout_guid, t.target_guid),
                  DECODE(t.target_type, mgmt_global.G_HOST_TARGET_TYPE,
                    mgmt_blackout_ui.does_include_members(b.blackout_guid, t.target_guid), 'N/A')) Full,
                bs.start_time,
                bs.duration,
                bs.frequency_code,
                r.reason Reason,
                b.blackout_desc Comments,
                b.created_by "Created By",
                b.last_updated_by "Last Updated By",
                b.created_thru,
                bs.duration_source,
                bs.end_time,
                b.last_end_time,
                b.scheduled_time,
                bs.interval,
                bs.timezone_offset,
                bs.timezone_region
            FROM
                mgmt_targets t,
                mgmt_blackouts b,
                mgmt_blackout_schedule bs,
                mgmt_blackout_reason r,
                mgmt_blackout_flat_targets bft,
                mgmt_blackout_target_details btd
            WHERE
                b.blackout_status IN (mgmt_blackout_engine.BLK_STATE_START_FAILED, 
                                        mgmt_blackout_engine.BLK_STATE_STOPPED, 
                                        mgmt_blackout_engine.BLK_STATE_ENDED) AND
                b.reason_id = r.reason_id (+) AND
                b.blackout_guid = bft.blackout_guid AND
                b.blackout_guid = bs.blackout_guid AND
                bft.target_guid = t.target_guid AND
                btd.target_guid(+) = bft.target_guid AND
                btd.blackout_guid(+) = bft.blackout_guid AND 
                UPPER(t.target_name) LIKE l_search_string escape '^' 
            ORDER BY "Created By";     
        ELSIF ((p_parent_type IS NOT NULL) AND ((p_target_type IS NOT NULL) AND (p_target_type != ALL_TARGET_TYPES))) THEN
            IF (p_parent_type = mgmt_blackout_ui.PARENT_TYPE_HOST) THEN
                OPEN p_lists_out FOR
                SELECT
                    bs.blackout_guid,
                    b.blackout_name,
                    t.target_name Target,
                    t.target_type,
                    t.type_display_name,
                    b.blackout_status Status,
                    DECODE((SELECT property_value
                            FROM mgmt_type_properties 
                            WHERE target_type   = t.target_type AND
                                  property_name = mgmt_global.G_IS_AGGREGATE_PROP ), 1,
                      mgmt_blackout_ui.does_include_members(b.blackout_guid, t.target_guid),
                      DECODE(t.target_type, mgmt_global.G_HOST_TARGET_TYPE,
                        mgmt_blackout_ui.does_include_members(b.blackout_guid, t.target_guid), 'N/A')) Full,
                    bs.start_time,
                    bs.duration,
                    bs.frequency_code,
                    r.reason Reason,
                    b.blackout_desc Comments,
                    b.created_by "Created By",
                    b.last_updated_by "Last Updated By",
                    b.created_thru,
                    bs.duration_source,
                    bs.end_time,
                    b.last_end_time,
                    b.scheduled_time,
                    bs.interval,
                    bs.timezone_offset,
                    bs.timezone_region
                FROM
                    mgmt_targets t,
                    mgmt_blackouts b,
                    mgmt_blackout_schedule bs,
                    mgmt_blackout_reason r,
                    mgmt_blackout_flat_targets bft,
                    mgmt_blackout_target_details btd
                WHERE
                    b.blackout_status IN (mgmt_blackout_engine.BLK_STATE_START_FAILED, 
                                        mgmt_blackout_engine.BLK_STATE_STOPPED, 
                                        mgmt_blackout_engine.BLK_STATE_ENDED) AND
                    b.reason_id = r.reason_id (+) AND
                    b.blackout_guid = bft.blackout_guid AND
                    b.blackout_guid = bs.blackout_guid AND
                    bft.target_guid = t.target_guid AND
                    btd.target_guid(+) = bft.target_guid AND
                    btd.blackout_guid(+) = bft.blackout_guid AND 
                    UPPER(t.host_name) LIKE l_parent_search_string AND
                    UPPER(t.target_name) LIKE l_search_string escape '^' AND 
                    t.target_type = p_target_type
                ORDER BY "Created By";     
            ELSE
                OPEN p_lists_out FOR
                SELECT
                    bs.blackout_guid,
                    b.blackout_name,
                    t.target_name Target,
                    t.target_type,
                    t.type_display_name,
                    b.blackout_status Status,
                    DECODE((SELECT property_value
                            FROM mgmt_type_properties 
                            WHERE target_type   = t.target_type AND
                                  property_name = mgmt_global.G_IS_AGGREGATE_PROP ), 1,
                      mgmt_blackout_ui.does_include_members(b.blackout_guid, t.target_guid),
                      DECODE(t.target_type, mgmt_global.G_HOST_TARGET_TYPE,
                        mgmt_blackout_ui.does_include_members(b.blackout_guid, t.target_guid), 'N/A')) Full,
                    bs.start_time,
                    bs.duration,
                    bs.frequency_code,
                    r.reason Reason,
                    b.blackout_desc Comments,
                    b.created_by "Created By",
                    b.last_updated_by "Last Updated By",
                    b.created_thru,
                    bs.duration_source,
                    bs.end_time,
                    b.last_end_time,
                    b.scheduled_time,
                    bs.interval,
                    bs.timezone_offset,
                    bs.timezone_region
                FROM
                    mgmt_targets t,
                    mgmt_blackouts b,
                    mgmt_blackout_schedule bs,
                    mgmt_blackout_reason r,
                    mgmt_blackout_flat_targets bft,
                    mgmt_blackout_target_details btd
                WHERE
                    b.blackout_status IN (mgmt_blackout_engine.BLK_STATE_START_FAILED, 
                                        mgmt_blackout_engine.BLK_STATE_STOPPED, 
                                        mgmt_blackout_engine.BLK_STATE_ENDED) AND
                    b.reason_id = r.reason_id (+) AND
                    b.blackout_guid = bft.blackout_guid AND
                    b.blackout_guid = bs.blackout_guid AND
                    bft.target_guid = t.target_guid AND
                    btd.target_guid(+) = bft.target_guid AND
                    btd.blackout_guid(+) = bft.blackout_guid AND 
                    t.target_guid IN 
                    (SELECT a.assoc_target_guid
                    FROM  MGMT_FLAT_TARGET_ASSOC a , MGMT_TARGETS ct
                    WHERE  ct.target_guid = a.source_target_guid AND
                    ct.target_type = p_parent_type
                    AND UPPER(ct.target_name) LIKE l_parent_search_string
                    AND a.is_membership = 1) AND 
                    UPPER(t.target_name) LIKE l_search_string escape '^' AND 
                    t.target_type = p_target_type 
                ORDER BY "Created By";     
            END IF;
        ELSIF ((p_parent_type IS NOT NULL) AND (p_target_type IS NULL OR p_target_type = ALL_TARGET_TYPES)) THEN
            IF (p_parent_type = mgmt_blackout_ui.PARENT_TYPE_HOST) THEN
                OPEN p_lists_out FOR
                SELECT
                    bs.blackout_guid,
                    b.blackout_name,
                    t.target_name Target,
                    t.target_type,
                    t.type_display_name,
                    b.blackout_status Status,
                    DECODE((SELECT property_value
                            FROM mgmt_type_properties 
                            WHERE target_type   = t.target_type AND
                                  property_name = mgmt_global.G_IS_AGGREGATE_PROP ), 1,
                      mgmt_blackout_ui.does_include_members(b.blackout_guid, t.target_guid),
                      DECODE(t.target_type, mgmt_global.G_HOST_TARGET_TYPE,
                        mgmt_blackout_ui.does_include_members(b.blackout_guid, t.target_guid), 'N/A')) Full,
                    bs.start_time,
                    bs.duration,
                    bs.frequency_code,
                    r.reason Reason,
                    b.blackout_desc Comments,
                    b.created_by "Created By",
                    b.last_updated_by "Last Updated By",
                    b.created_thru,
                    bs.duration_source,
                    bs.end_time,
                    b.last_end_time,
                    b.scheduled_time,
                    bs.interval,
                    bs.timezone_offset,
                    bs.timezone_region
                FROM
                    mgmt_targets t,
                    mgmt_blackouts b,
                    mgmt_blackout_schedule bs,
                    mgmt_blackout_reason r,
                    mgmt_blackout_flat_targets bft,
                    mgmt_blackout_target_details btd
                WHERE
                    b.blackout_status IN (mgmt_blackout_engine.BLK_STATE_START_FAILED, 
                                        mgmt_blackout_engine.BLK_STATE_STOPPED, 
                                        mgmt_blackout_engine.BLK_STATE_ENDED) AND
                    b.reason_id = r.reason_id (+) AND
                    b.blackout_guid = bft.blackout_guid AND
                    b.blackout_guid = bs.blackout_guid AND
                    bft.target_guid = t.target_guid AND
                    btd.target_guid(+) = bft.target_guid AND
                    btd.blackout_guid(+) = bft.blackout_guid AND 
                    UPPER(t.host_name) LIKE l_parent_search_string AND
                    UPPER(t.target_name) LIKE l_search_string escape '^' 
                ORDER BY "Created By";     
            ELSE
                OPEN p_lists_out FOR
                SELECT
                    bs.blackout_guid,
                    b.blackout_name,
                    t.target_name Target,
                    t.target_type,
                    t.type_display_name,
                    b.blackout_status Status,
                    DECODE((SELECT property_value
                            FROM mgmt_type_properties 
                            WHERE target_type   = t.target_type AND
                                  property_name = mgmt_global.G_IS_AGGREGATE_PROP ), 1,
                      mgmt_blackout_ui.does_include_members(b.blackout_guid, t.target_guid),
                      DECODE(t.target_type, mgmt_global.G_HOST_TARGET_TYPE,
                        mgmt_blackout_ui.does_include_members(b.blackout_guid, t.target_guid), 'N/A')) Full,
                    bs.start_time,
                    bs.duration,
                    bs.frequency_code,
                    r.reason Reason,
                    b.blackout_desc Comments,
                    b.created_by "Created By",
                    b.last_updated_by "Last Updated By",
                    b.created_thru,
                    bs.duration_source,
                    bs.end_time,
                    b.last_end_time,
                    b.scheduled_time,
                    bs.interval,
                    bs.timezone_offset,
                    bs.timezone_region
                FROM
                    mgmt_targets t,
                    mgmt_blackouts b,
                    mgmt_blackout_schedule bs,
                    mgmt_blackout_reason r,
                    mgmt_blackout_flat_targets bft,
                    mgmt_blackout_target_details btd
                WHERE
                    b.blackout_status IN (mgmt_blackout_engine.BLK_STATE_START_FAILED, 
                                        mgmt_blackout_engine.BLK_STATE_STOPPED, 
                                        mgmt_blackout_engine.BLK_STATE_ENDED) AND
                    b.reason_id = r.reason_id (+) AND
                    b.blackout_guid = bft.blackout_guid AND
                    b.blackout_guid = bs.blackout_guid AND
                    bft.target_guid = t.target_guid AND
                    btd.target_guid(+) = bft.target_guid AND
                    btd.blackout_guid(+) = bft.blackout_guid AND 
                    t.target_guid IN 
                    (SELECT a.assoc_target_guid
                    FROM  MGMT_FLAT_TARGET_ASSOC a , MGMT_TARGETS ct
                    WHERE  ct.target_guid = a.source_target_guid AND
                    ct.target_type = p_parent_type
                    AND UPPER(ct.target_name) LIKE l_parent_search_string
                    AND a.is_membership = 1) AND 
                    UPPER(t.target_name) LIKE l_search_string escape '^'
                ORDER BY "Created By";     
            END IF;
        ELSIF ((p_parent_type IS NULL) AND ((p_target_type IS NOT NULL) AND (p_target_type != ALL_TARGET_TYPES))) THEN
            OPEN p_lists_out FOR
            SELECT
                bs.blackout_guid,
                b.blackout_name,
                t.target_name Target,
                t.target_type,
                t.type_display_name,
                b.blackout_status Status,
                DECODE((SELECT property_value
                        FROM mgmt_type_properties 
                        WHERE target_type   = t.target_type AND
                              property_name = mgmt_global.G_IS_AGGREGATE_PROP ), 1,
                  mgmt_blackout_ui.does_include_members(b.blackout_guid, t.target_guid),
                  DECODE(t.target_type, mgmt_global.G_HOST_TARGET_TYPE,
                    mgmt_blackout_ui.does_include_members(b.blackout_guid, t.target_guid), 'N/A')) Full,
                bs.start_time,
                bs.duration,
                bs.frequency_code,
                r.reason Reason,
                b.blackout_desc Comments,
                b.created_by "Created By",
                b.last_updated_by "Last Updated By",
                b.created_thru,
                bs.duration_source,
                bs.end_time,
                b.last_end_time,
                b.scheduled_time,
                bs.interval,
                bs.timezone_offset,
                bs.timezone_region
            FROM
                mgmt_targets t,
                mgmt_blackouts b,
                mgmt_blackout_schedule bs,
                mgmt_blackout_reason r,
                mgmt_blackout_flat_targets bft,
                mgmt_blackout_target_details btd
            WHERE
                b.blackout_status IN (mgmt_blackout_engine.BLK_STATE_START_FAILED, 
                                        mgmt_blackout_engine.BLK_STATE_STOPPED, 
                                        mgmt_blackout_engine.BLK_STATE_ENDED) AND
                b.reason_id = r.reason_id (+) AND
                b.blackout_guid = bft.blackout_guid AND
                b.blackout_guid = bs.blackout_guid AND
                bft.target_guid = t.target_guid AND
                btd.target_guid(+) = bft.target_guid AND
                btd.blackout_guid(+) = bft.blackout_guid AND 
                UPPER(t.target_name) LIKE l_search_string escape '^' AND 
                t.target_type = p_target_type 
            ORDER BY "Created By";     
        END IF;
    END IF;
END search_blackouts_flat_targets;

--
-- PROCEDURE: get_targets_under_blackout
--
PROCEDURE get_targets_under_blackout
(
  p_blackout_name IN VARCHAR2,
  p_created_thru IN VARCHAR2,
  p_created_by IN VARCHAR2,
  p_lists_out OUT CURSOR_TYPE
)
IS
BEGIN
  OPEN p_lists_out FOR
    SELECT t.target_name, t.target_type, t.type_display_name
      FROM MGMT_BLACKOUTS b,
           MGMT_BLACKOUT_FLAT_TARGETS bft,
           MGMT_TARGETS t
     WHERE b.blackout_guid = bft.blackout_guid AND
           t.target_guid = bft.target_guid AND
           b.blackout_name = p_blackout_name AND
           b.created_by = p_created_by AND
           b.created_thru IS NULL --Created Thru is always null          
     ORDER BY t.target_name;
END get_targets_under_blackout;

--
-- PROCEDURE: get_group_blackouts_info
--
PROCEDURE get_group_blackouts_info
(
  p_group_name IN VARCHAR2,
  p_group_type IN VARCHAR2,
  p_group_blackouts_future OUT NUMBER,
  p_group_blackouts_active OUT NUMBER,
  p_members_blackouts_future OUT NUMBER,
  p_members_blackouts_active OUT NUMBER
)
IS
    l_blk_host_targets SMP_EMD_NVPAIR_ARRAY := SMP_EMD_NVPAIR_ARRAY();
BEGIN
    SELECT /*+ INDEX(b MGMT_BLACKOUT_TGT_DET_IDX01) */ SMP_EMD_NVPAIR(b.blackout_guid , t.emd_url)
      BULK COLLECT INTO l_blk_host_targets
      FROM mgmt_targets t, mgmt_blackout_target_details b
     WHERE b.include_members = 1 AND
           b.target_guid = t.target_guid AND
           t.target_type = mgmt_global.G_HOST_TARGET_TYPE;

-- 1) Get the Count of Scheduled Blackouts submitted to this Group
  SELECT COUNT (*)
  INTO p_group_blackouts_future
  FROM
      mgmt_targets t,
      mgmt_blackouts b,
      mgmt_blackout_target_details td,
      mgmt_blackout_schedule s
   WHERE
       b.blackout_status NOT IN (mgmt_blackout_engine.BLK_STATE_START_FAILED, 
                                        mgmt_blackout_engine.BLK_STATE_STOPPED, 
                                        mgmt_blackout_engine.BLK_STATE_ENDED) AND
       b.blackout_guid = s.blackout_guid AND
       b.scheduled_time > 
       mgmt_blackout_engine.to_blackout_time(SYSDATE, s.timezone_info, s.timezone_offset, s.timezone_region) AND
       b.blackout_guid = td.blackout_guid AND
       td.target_guid = t.target_guid AND
       t.target_name = p_group_name AND
       t.target_type = p_group_type;

-- 2) Get the Count of Active Blackouts submitted to this Group
  SELECT COUNT (*)
    INTO p_group_blackouts_active
    FROM mgmt_targets t, mgmt_blackouts b,
         mgmt_blackout_target_details td,
         mgmt_blackout_schedule s
   WHERE b.blackout_status NOT IN (mgmt_blackout_engine.BLK_STATE_START_FAILED, 
                                        mgmt_blackout_engine.BLK_STATE_STOPPED, 
                                        mgmt_blackout_engine.BLK_STATE_ENDED)
     AND b.blackout_guid = s.blackout_guid
     AND DECODE(b.scheduled_time, null, b.last_start_time, b.scheduled_time) <= 
         mgmt_blackout_engine.to_blackout_time(SYSDATE, s.timezone_info, s.timezone_offset, s.timezone_region) 
     AND b.blackout_guid = td.blackout_guid
     AND td.target_guid = t.target_guid
     AND t.target_name = p_group_name
     AND t.target_type = p_group_type;

-- 3) Get the Count of Scheduled Blackouts submitted to any Members of this Group
    SELECT count(*) 
    INTO p_members_blackouts_future
    FROM
    (
        SELECT 
             /*+ FIRST_ROWS */
             b.blackout_guid,
             b.blackout_name,
             t.target_name Target,
             t.target_type,
             t.type_display_name,
             b.blackout_status Status,
             DECODE((SELECT property_value
                    FROM mgmt_type_properties 
                    WHERE target_type   = t.target_type AND
                          property_name = mgmt_global.G_IS_AGGREGATE_PROP ), 1,
              mgmt_blackout_ui.does_include_members(b.blackout_guid, t.target_guid),
              DECODE(t.target_type, mgmt_global.G_HOST_TARGET_TYPE,
                mgmt_blackout_ui.does_include_members(b.blackout_guid, t.target_guid), 'N/A')) Full,
             bs.start_time,
             bs.duration,
             bs.frequency_code,
             r.reason Reason,
             b.blackout_desc,
             b.created_by,
             b.last_updated_by,
             b.created_thru,
             bs.duration_source,
             bs.end_time,
             b.last_end_time,
             b.scheduled_time,
             bs.interval,
             bs.timezone_offset,
             bs.timezone_region
         FROM mgmt_targets t, 
             mgmt_blackouts b, 
             mgmt_blackout_schedule bs, 
             mgmt_blackout_reason r, 
             mgmt_blackout_flat_targets bft, 
             mgmt_blackout_target_details btd 
        WHERE 
             b.blackout_status NOT IN (mgmt_blackout_engine.BLK_STATE_START_FAILED, 
                                mgmt_blackout_engine.BLK_STATE_STOPPED, 
                                mgmt_blackout_engine.BLK_STATE_ENDED) 
         AND b.scheduled_time > 
              mgmt_blackout_engine.to_blackout_time(SYSDATE, bs.timezone_info, bs.timezone_offset, bs.timezone_region) 
         AND b.reason_id = r.reason_id (+) 
         AND b.blackout_guid = bft.blackout_guid 
         AND b.blackout_guid = bs.blackout_guid 
         AND  bft.target_guid = t.target_guid 
         AND btd.blackout_guid(+) = bft.blackout_guid 
         AND  btd.target_guid(+) = bft.target_guid 
         AND t.target_guid IN 
            (SELECT a.assoc_target_guid 
            FROM mgmt_flat_target_assoc a , 
                 mgmt_targets ct 
            WHERE ct.target_guid = a.source_target_guid 
              AND ct.target_type = p_group_type 
              AND ct.target_name = p_group_name
              AND a.is_membership = 1) 
        UNION 
        SELECT 
             /*+ FIRST_ROWS */
             b.blackout_guid,
             b.blackout_name,
             t.target_name Target,
             t.target_type,
             t.type_display_name,
             b.blackout_status Status,
             DECODE((SELECT property_value
                    FROM mgmt_type_properties 
                    WHERE target_type   = t.target_type AND
                          property_name = mgmt_global.G_IS_AGGREGATE_PROP ), 1,
              mgmt_blackout_ui.does_include_members(b.blackout_guid, t.target_guid),
              DECODE(t.target_type, mgmt_global.G_HOST_TARGET_TYPE,
                mgmt_blackout_ui.does_include_members(b.blackout_guid, t.target_guid), 'N/A')) Full,
             bs.start_time,
             bs.duration,
             bs.frequency_code,
             r.reason Reason,
             b.blackout_desc,
             b.created_by,
             b.last_updated_by,
             b.created_thru,
             bs.duration_source,
             bs.end_time,
             b.last_end_time,
             b.scheduled_time,
             bs.interval,
             bs.timezone_offset,
             bs.timezone_region
        FROM mgmt_targets t, 
             mgmt_blackouts b, 
             mgmt_blackout_schedule bs, 
             mgmt_blackout_reason r, 
             mgmt_flat_target_assoc assoc, 
             mgmt_blackout_target_details btd 
        WHERE 
             b.blackout_status NOT IN (mgmt_blackout_engine.BLK_STATE_START_FAILED, 
                                mgmt_blackout_engine.BLK_STATE_STOPPED, 
                                mgmt_blackout_engine.BLK_STATE_ENDED) 
         AND b.scheduled_time > 
              mgmt_blackout_engine.to_blackout_time(SYSDATE, bs.timezone_info, bs.timezone_offset, bs.timezone_region) 
         AND b.reason_id = r.reason_id (+) 
         AND b.blackout_guid = bs.blackout_guid 
         AND b.blackout_guid = btd.blackout_guid 
         AND assoc.source_target_guid = btd.target_guid 
         AND assoc.assoc_target_guid = t.target_guid 
         AND assoc.is_membership =1 
         AND btd.include_members =1 
         AND t.target_guid IN 
            (SELECT a.assoc_target_guid 
            FROM mgmt_flat_target_assoc a , 
                 mgmt_targets ct 
            WHERE ct.target_guid = a.source_target_guid 
              AND ct.target_type = p_group_type 
              AND ct.target_name = p_group_name
              AND a.is_membership = 1)  
        UNION 
        SELECT 
             /*+ FIRST_ROWS */
             b.blackout_guid,
             b.blackout_name,
             t.target_name Target,
             t.target_type,
             t.type_display_name,
             b.blackout_status Status,
             DECODE((SELECT property_value
                    FROM mgmt_type_properties 
                    WHERE target_type   = t.target_type AND
                          property_name = mgmt_global.G_IS_AGGREGATE_PROP ), 1,
              mgmt_blackout_ui.does_include_members(b.blackout_guid, t.target_guid),
              DECODE(t.target_type, mgmt_global.G_HOST_TARGET_TYPE,
                mgmt_blackout_ui.does_include_members(b.blackout_guid, t.target_guid), 'N/A')) Full,
             bs.start_time,
             bs.duration,
             bs.frequency_code,
             r.reason Reason,
             b.blackout_desc,
             b.created_by,
             b.last_updated_by,
             b.created_thru,
             bs.duration_source,
             bs.end_time,
             b.last_end_time,
             b.scheduled_time,
             bs.interval,
             bs.timezone_offset,
             bs.timezone_region
        FROM mgmt_targets t, 
             mgmt_blackout_target_details btd, 
             mgmt_blackouts b, 
             mgmt_blackout_reason r, 
             mgmt_blackout_schedule bs, 
             TABLE(CAST(l_blk_host_targets AS smp_emd_nvpair_array)) hosts 
        WHERE 
             b.blackout_status NOT IN (mgmt_blackout_engine.BLK_STATE_START_FAILED, 
                                mgmt_blackout_engine.BLK_STATE_STOPPED, 
                                mgmt_blackout_engine.BLK_STATE_ENDED) 
         AND b.scheduled_time > 
              mgmt_blackout_engine.to_blackout_time(SYSDATE, bs.timezone_info, bs.timezone_offset, bs.timezone_region) 
         AND b.reason_id = r.reason_id (+) 
         AND b.blackout_guid = bs.blackout_guid 
         AND b.blackout_guid = btd.blackout_guid 
         AND b.blackout_guid = hosts.name 
         AND t.emd_url = hosts.value 
         AND t.target_guid = btd.target_guid 
         AND t.target_guid IN 
            (SELECT a.assoc_target_guid 
            FROM mgmt_flat_target_assoc a , 
                 mgmt_targets ct 
            WHERE ct.target_guid = a.source_target_guid 
              AND ct.target_type =  p_group_type 
              AND ct.target_name =  p_group_name
              AND a.is_membership = 1)
    );

-- 4) Get the Count of Active Blackouts submitted to any Members of this Group
  SELECT COUNT (*)
    INTO p_members_blackouts_active
    FROM mgmt_blackouts b,
         mgmt_blackout_flat_targets bft,
         mgmt_blackout_schedule s
   WHERE b.blackout_status NOT IN (mgmt_blackout_engine.BLK_STATE_START_FAILED, 
                                        mgmt_blackout_engine.BLK_STATE_STOPPED, 
                                        mgmt_blackout_engine.BLK_STATE_ENDED)
     AND b.blackout_guid = s.blackout_guid
     AND DECODE(b.scheduled_time, null, b.last_start_time, b.scheduled_time) <= 
         mgmt_blackout_engine.to_blackout_time(SYSDATE, s.timezone_info, s.timezone_offset, s.timezone_region) 
     AND b.blackout_guid = bft.blackout_guid
     AND bft.target_guid IN
         (
           SELECT a.assoc_target_guid
             FROM mgmt_flat_target_assoc a , mgmt_targets t
            WHERE a.source_target_guid = t.target_guid
              AND t.target_name = p_group_name
              AND t.target_type = p_group_type
              AND a.is_membership = 1
         );
END get_group_blackouts_info;

--
-- FUNCTION: does_include_members
--
FUNCTION does_include_members
(
    p_blackout_guid  IN VARCHAR2,
    p_target_guid    IN VARCHAR2
)
RETURN
VARCHAR2
IS
    l_return_string varchar2(10);
BEGIN

    l_return_string := 'No';

    FOR c1 IN
    (
       SELECT include_members
       FROM  mgmt_blackout_target_details
       WHERE
           blackout_guid = p_blackout_guid AND
           target_guid = p_target_guid
    )
    LOOP
        IF (c1.include_members = 1) THEN
            l_return_string := 'Yes';
        END IF;
    END LOOP;

    RETURN(l_return_string);

END does_include_members;

FUNCTION check_operator_priv
(
    p_target_name     IN VARCHAR2,
    p_target_type     IN VARCHAR2,
    p_include_members IN INTEGER,
    p_user_name       IN VARCHAR2 DEFAULT NULL
)
RETURN NUMBER
IS
    l_current_user VARCHAR2(256) := MGMT_USER.get_current_em_user();
    l_has_operator_priv NUMBER   := MGMT_USER.USER_HAS_PRIV;
    l_has_child         BOOLEAN  := false;

BEGIN

    IF (p_user_name IS NOT NULL) THEN
        l_current_user := p_user_name;
    END IF;

    -- If the include members flag is not set, then the target
    -- does not have children
    IF p_include_members = 1 THEN
        l_has_child := true;
    END IF;

    -- checking for the group members
    IF (l_has_child) THEN

        FOR c1 IN
        (
            SELECT assoc_target_guid
              FROM mgmt_target_assocs
             WHERE source_target_guid = (SELECT target_guid
                                           FROM mgmt_targets
                                          WHERE target_name = p_target_name
                                            AND target_type = p_target_type)
        )
        LOOP

            IF MGMT_USER.has_priv(l_current_user,
                                  MGMT_USER.OPERATOR_TARGET,
                                  c1.assoc_target_guid) != MGMT_USER.USER_HAS_PRIV THEN

                l_has_operator_priv := MGMT_USER.USER_DOES_NOT_HAVE_PRIV;
                EXIT;
            END IF;
        END LOOP;
    -- checking for the each target
    ELSE

        IF MGMT_USER.has_priv(l_current_user,
                              MGMT_USER.OPERATOR_TARGET,
                              p_target_name,
                              p_target_type) != MGMT_USER.USER_HAS_PRIV THEN
            l_has_operator_priv := MGMT_USER.USER_DOES_NOT_HAVE_PRIV;
        END IF;

    END IF;

    RETURN l_has_operator_priv;


END check_operator_priv;

--
-- PROCEDURE: get_assoc_blackouts
--
PROCEDURE get_assoc_blackouts
(
  p_reason IN VARCHAR2,
  p_assoc_blackouts OUT MGMT_BLACKOUT_UI.CURSOR_TYPE
)
IS
BEGIN

  IF (EMDW_LOG.p_is_info_set)
  THEN
    EMDW_LOG.info('Entering procedure get_assoc_blackouts with parameter '
      || p_reason, MODULE_NAME);
  END IF;

  OPEN p_assoc_blackouts FOR
  SELECT b.blackout_name
    FROM mgmt_blackouts b, mgmt_blackout_reason r
   WHERE b.reason_id = r.reason_id AND
         r.reason = p_reason
   ORDER BY b.scheduled_time;

  IF (EMDW_LOG.p_is_info_set)
  THEN
    EMDW_LOG.info('Exiting procedure get_assoc_blackouts', MODULE_NAME);
  END IF;
END get_assoc_blackouts;

--
-- PROCEDURE: delete_blackout_reason
--
PROCEDURE delete_blackout_reason
(
  p_reason IN VARCHAR2
)
IS
BEGIN

  IF (EMDW_LOG.p_is_info_set)
  THEN
    EMDW_LOG.info('Enterng procedure delete_blackout_reason with parameter '
      || p_reason, MODULE_NAME);
  END IF;

  DELETE
    FROM mgmt_blackout_reason
   WHERE reason = p_reason;

  IF (EMDW_LOG.p_is_info_set)
  THEN
    EMDW_LOG.info('Exiting procedure delete_blackout_reason', MODULE_NAME);
  END IF;
END delete_blackout_reason;

--
-- PROCEDURE: update_reason_required
--
PROCEDURE update_reason_required
(
  p_reason_required IN VARCHAR2
)
IS
BEGIN

  IF (EMDW_LOG.p_is_info_set)
  THEN
    EMDW_LOG.info('Entering procedure update_reason_required with parameter '
      || p_reason_required, MODULE_NAME);
  END IF;

  UPDATE mgmt_parameters
     SET parameter_value = p_reason_required
   WHERE parameter_name = MGMT_BLACKOUT.REASON_REQUIRED_PARAMETER_NAME;

  IF (EMDW_LOG.p_is_info_set)
  THEN
    EMDW_LOG.info('Exiting procedure update_reason_required', MODULE_NAME);
  END IF;
END update_reason_required;

--
-- PROCEDURE: count_reasons_by_name
--
PROCEDURE count_reasons_by_name
(
  p_reason IN VARCHAR2,
  p_reasons_count OUT NUMBER
)
IS
BEGIN

  IF (EMDW_LOG.p_is_info_set)
  THEN
    EMDW_LOG.info('Entering procedure count_reasons_by_name with parameter '
      || p_reason, MODULE_NAME);
  END IF;

  SELECT COUNT(*)
    INTO p_reasons_count
    FROM mgmt_blackout_reason r
   WHERE reason = p_reason;

  IF (EMDW_LOG.p_is_info_set)
  THEN
    EMDW_LOG.info('Exiting procedure count_reasons_by_name', MODULE_NAME);
  END IF;
END count_reasons_by_name;

--
-- PROCEDURE: get_target_active_blackouts
--
PROCEDURE get_target_active_blackouts
(
  target_name_in IN VARCHAR2,
  target_type_in IN VARCHAR2,
  p_lists_out    OUT CURSOR_TYPE
)
IS
  l_target_guid mgmt_targets.target_guid%TYPE;
BEGIN
  l_target_guid := MGMT_TARGET.get_target_guid(target_name_in, target_type_in);

  OPEN p_lists_out FOR
    SELECT DISTINCT b.blackout_name,
           b.created_by,
           b.created_thru,
           s.frequency_code
      FROM mgmt_blackouts b,
           mgmt_blackout_schedule s,
           mgmt_blackout_flat_targets f
     WHERE f.target_guid = l_target_guid AND
           f.blackout_guid = b.blackout_guid AND
           b.blackout_status NOT IN (mgmt_blackout_engine.BLK_STATE_START_FAILED, 
                                        mgmt_blackout_engine.BLK_STATE_STOPPED, 
                                        mgmt_blackout_engine.BLK_STATE_ENDED) AND
           DECODE(b.scheduled_time, null, b.last_start_time, b.scheduled_time) <= 
           mgmt_blackout_engine.to_blackout_time(SYSDATE, s.timezone_info, s.timezone_offset, s.timezone_region) AND
           b.blackout_guid = s.blackout_guid
     ORDER BY b.blackout_name;

END get_target_active_blackouts;

-- PROCEDURE: get_targets_oper_priv
--
-- PURPOSE:
--   Returns a list of all targets  
--   for which the given user has Operator Privilege.
--

procedure get_targets_oper_priv
(
   p_user_name      IN VARCHAR2,
   p_targets_list   OUT CURSOR_TYPE
)

IS
   TYPE ref_cursor IS REF CURSOR;
   p_guid_cursor        ref_cursor;
   p_target_guids_array MGMT_USER_GUID_ARRAY := MGMT_USER_GUID_ARRAY(); 

BEGIN
   -- Fetch all the target guids from mgmt_targets and pass this array into
   -- the mgmt_user.has_priv method which returns the guids cursor.
   -- Use these guids and return the target name and target type for these guids.
   
   SELECT target_guid
   BULK COLLECT INTO p_target_guids_array
   FROM mgmt_targets;
   
   p_guid_cursor := mgmt_user.has_priv
                        (
                            user_name_in    => p_user_name,
                            priv_name_in    => MGMT_USER.OPERATOR_TARGET,
                            target_guids_in => p_target_guids_array
                        );
                            
   p_target_guids_array.DELETE;
   FETCH p_guid_cursor BULK COLLECT INTO p_target_guids_array;
   
   OPEN p_targets_list for
   SELECT
       target_name,
       target_type
   FROM
       mgmt_targets
   WHERE target_guid IN
       ( 
           SELECT * FROM TABLE(CAST(p_target_guids_array AS MGMT_USER_GUID_ARRAY))
       );

END get_targets_oper_priv;

--
-- PROCEDURE: get_targets_full_blackout
--
-- PURPOSE:
--   Returns a list of all composite targets which are under Full Blackout
--   for the given the given Blackout .
--
PROCEDURE get_targets_full_blackout
(
   p_blkout_name    IN VARCHAR2,
   p_targets_list   OUT CURSOR_TYPE
)

IS
BEGIN
   OPEN p_targets_list FOR
       SELECT 
           target_name,
           target_type,
           full 
       FROM
       (
           SELECT
               t.target_name ,
               t.target_type,
               DECODE((SELECT property_value
                       FROM mgmt_type_properties 
                       WHERE target_type   = t.target_type AND
                             property_name = mgmt_global.G_IS_AGGREGATE_PROP ), 1, DECODE(td.include_members, 1, 'Yes', 'No'),
               DECODE(t.target_type, mgmt_global.G_HOST_TARGET_TYPE,
               DECODE(td.include_members, 1, 'Yes', 'No'), 'N/A' )) Full
           FROM
               mgmt_targets t,
               mgmt_blackouts b,
               mgmt_blackout_target_details td
           WHERE
               b.blackout_name = p_blkout_name and
               b.blackout_guid = td.blackout_guid AND
               td.target_guid = t.target_guid
       )
       WHERE
           full in ('Yes','No');
   
END get_targets_full_blackout;




--
-- PROCEDURE: enable_retroactive_blackout
--
-- PURPOSE:
--   This api enables or disable the retroactive blackout(rbk) across EM.
--
--   IN Parameters:
--     p_enable_rbk  : "true" means enable Retroactive blackout. 
--                     "false" means to disable Retroactive blackout at the EM level.
--

PROCEDURE enable_retroactive_blackout
(
  p_enable_rbk    IN VARCHAR2  
)
IS
BEGIN
  IF (EMDW_LOG.p_is_info_set)
  THEN
    EMDW_LOG.info('Entering procedure enable_retroactive_blackout with parameter '
      || p_enable_rbk, MODULE_NAME);
  END IF;
  
  UPDATE mgmt_parameters
     SET parameter_value = p_enable_rbk
  WHERE parameter_name = MGMT_BLACKOUT_UI.RBK_CONFIG_PARAMETER_NAME;

  

  IF (EMDW_LOG.p_is_info_set)
  THEN
    EMDW_LOG.info('Exiting procedure enable_retroactive_blackout', MODULE_NAME);
  END IF;
EXCEPTION

  WHEN NO_DATA_FOUND THEN
      
      raise_application_error(MGMT_GLOBAL.NO_RBK_PARAMETER_FOUND_ERR,
                              MGMT_GLOBAL.NO_RBK_PARAMETER_FOUND_ERR_M);
  WHEN OTHERS THEN
    ROLLBACK;
    
    RAISE;
END enable_retroactive_blackout;

--
-- FUNCTION: is_retroactive_blackout_enable
--
-- PURPOSE:
--   Returns if retroactive blackout feature is enabled or not.
--
--   IN Parameters:
--     p_enable_rbk  : "true" means enable Retroactive blackout. 
--                     "false" means to disable Retroactive blackout at the EM level.
--
FUNCTION is_retroactive_blackout_enable
RETURN VARCHAR2 IS
    l_rbk_enable VARCHAR2(10);
BEGIN

  l_rbk_enable := NULL;

  BEGIN
      SELECT parameter_value
        INTO l_rbk_enable
        FROM mgmt_parameters
       WHERE parameter_name = MGMT_BLACKOUT_UI.RBK_CONFIG_PARAMETER_NAME;

     EXCEPTION
      WHEN NO_DATA_FOUND
      --Required parameter is not present in the Database, so we set it
      --and return the default value. Note: comment statement is not displayed 
      --on the screen so no NLS requirement for it. (Same as manage reasons)
      THEN
        INSERT
          INTO mgmt_parameters
               (parameter_name, parameter_value,
                parameter_comment, internal_flag)
        VALUES (MGMT_BLACKOUT_UI.RBK_CONFIG_PARAMETER_NAME,
                'false',
                'Indicates whether Retroactive Blackout feature is enabled across EM',
                0);
        COMMIT;

        l_rbk_enable := 'false';

      WHEN OTHERS 
      THEN 
        RAISE;
  END;

  RETURN l_rbk_enable;

END is_retroactive_blackout_enable;

--
-- PROCEDURE: get_downtime_target_avail_info
--
-- PURPOSE:
--   This api return the target's downtime availability records in the past time.
--   Downtime record includes Agent downtime and down time.
--
--   IN Parameters:
--     p_target_name  :  Target name whose downtime to fetch
--     p_target_type  :  Target type whose downtime to fetch
--     p_target_avail_cur : Availability record cursor having columns:
--                         target_name
--                         target_type
--                         status
--                         from_time  (In targets tz)
--                         to_time  (In targets tz)
--
PROCEDURE get_downtime_target_avail_info(
    p_target_name IN MGMT_TARGETS.TARGET_NAME%TYPE,
    p_target_type IN MGMT_TARGETS.TARGET_TYPE%TYPE,
    p_target_avail_cur OUT CURSOR_TYPE)
IS    
BEGIN

    OPEN p_target_avail_cur FOR
        SELECT tar.target_name target_name,
          tar.target_type target_type,
          avail.current_status status,
          avail.start_collection_timestamp from_time,
          avail.end_collection_timestamp to_time
        FROM mgmt_availability avail,
          mgmt_targets tar
        WHERE  
        (tar.target_guid = avail.target_guid) AND
        (tar.target_name = p_target_name) AND
        (tar.target_type = p_target_type) AND
        (avail.current_status = MGMT_GLOBAL.G_STATUS_DOWN) AND
        (avail.end_collection_timestamp IS NOT NULL) AND
        (avail.end_collection_timestamp > avail.start_collection_timestamp)
        ORDER BY avail.start_collection_timestamp DESC; 
        
END get_downtime_target_avail_info;


-- PROCEDURE validate_rbk_time_period
--
-- PURPOSE:
--   validate the rbk time period for the following:
--   1. If rbk time period is before any targets first availability data.
--   2. If the rbk time span overlaps with the last record of any target that is
--    unsupported state i.e. unreachable, unknown or error
--
--   IN Parameters:
--     p_targets           :  List of Targets that needs to be checked for 
--                            availability first start record.
--     p_rbk_start_time    :  RBK start time
--     p_rbk_end_time    :  RBK end time
--     p_timezone_region   : RBK timezone
--   OUT Parameters:
--     p_noAvailTargets   : Targets with availability record not available for therbk time period
--                           target_guid  
--                           target_name
--                           target_type
--                           from_time  
--                           to_time 
--                           status
--                           timezone of from and to time (This will in rbk tz)
--     p_unSupStateTargets   : Targets with last record in unsuported state
--                           target_guid  
--                           target_name
--                           target_type
--                           from_time  
--                           to_time 
--                           status
--                           timezone of from and to time (This will in rbk tz)
PROCEDURE validate_rbk_time_period( p_targets     IN MGMT_TARGET_ARRAY,
                                p_rbk_start_time    IN DATE,    
                                p_rbk_end_time      IN DATE,
                                p_timezone_region   IN VARCHAR2, 
                                p_noAvailTargets    OUT MGMT_RBK_TARGET_INFO_ARRAY,
                                p_unSupStateTargets OUT MGMT_RBK_TARGET_INFO_ARRAY)
IS
BEGIN
    get_no_avail_targets(p_targets,p_rbk_start_time,p_timezone_region,p_noAvailTargets);
    get_ovl_last_unsup_targets(p_targets,p_rbk_end_time,p_timezone_region,p_unSupStateTargets);

END validate_rbk_time_period;




--
-- PROCEDURE: get_ovl_last_unsup_targets
--
-- PURPOSE:
--   This api return the target's which are currently in unsupported state 
--   they are unknown,error or unreachable state and rbk time end time should be
--   greater than the start time since the target are currently in unsupported.
--   In short it will check if the last availability record overlaps with
--   rbk time span and if the state of the last record is unknown,error or 
--   unreachable.
--
--   IN Parameters:
--     p_targets           :  List of Targets that needs to be checked for 
--                            availability first start record.
--     p_rbk_end_time    :  RBK end time
--     p_timezone_region   : RBK timezone
--   OUT Parameters:
--     p_unSupStateTargets    : Targets with last record in unsuported state
--                           target_guid  
--                           target_name
--                           target_type
--                           from_time  
--                           to_time 
--                           status
--                           timezone of from and to time (This will in rbk tz)
PROCEDURE get_ovl_last_unsup_targets( p_targets     IN MGMT_TARGET_ARRAY,
                                p_rbk_end_time      IN DATE,
                                p_timezone_region   IN VARCHAR2,            
                                p_unSupStateTargets OUT MGMT_RBK_TARGET_INFO_ARRAY)
IS
    l_target_guid           mgmt_targets.target_guid%TYPE;
    l_target_tzRgn          mgmt_targets.timezone_region%TYPE;    
    l_count                 NUMBER DEFAULT 1;
    l_sel_tar               MGMT_TARGET_OBJ;
    l_rbk_end_tgt_tz        DATE;    
    l_no_avail_tar_count    NUMBER DEFAULT 1;
    l_since_rbk_tz          DATE;
    CURSOR blackout_last_avail_cur(v_tar_guid RAW,              
              v_rbk_end DATE,
              v_status_unreachable NUMBER,
              v_status_unknown NUMBER,
              v_status_error NUMBER) IS
        select target_guid, current_status, start_collection_timestamp
        from mgmt_availability 
        where target_guid = v_tar_guid AND
        end_collection_timestamp IS NULL AND
        current_status in(v_status_unreachable,v_status_unknown,v_status_error) AND        
        v_rbk_end > start_collection_timestamp;
    
BEGIN   
    
    p_unSupStateTargets := MGMT_RBK_TARGET_INFO_ARRAY();    
    
    IF (p_targets IS NOT NULL) THEN            
    
        For l_count IN 1..p_targets.count LOOP
            
            l_sel_tar := p_targets(l_count);
            
            BEGIN
                SELECT target_guid,timezone_region
                    INTO l_target_guid,l_target_tzRgn
                    FROM mgmt_targets
                   WHERE target_name = l_sel_tar.target_name AND
                         target_type = l_sel_tar.target_type;

                             
            EXCEPTION
              WHEN NO_DATA_FOUND
              THEN
                raise_application_error(MGMT_GLOBAL.target_does_not_exist_err,
                        MGMT_GLOBAL.target_does_not_exist_err_m ||
            ' ' || l_sel_tar.target_name || ':' || l_sel_tar.target_type);
           
            END;            
            
            l_rbk_end_tgt_tz := mgmt_global.adjust_tz(p_rbk_end_time,p_timezone_region,l_target_tzRgn);                    
            
            BEGIN
                For avail_rec in blackout_last_avail_cur(l_target_guid,
                                              l_rbk_end_tgt_tz,
                                              mgmt_global.g_status_unreachable,
                                              mgmt_global.g_status_unknown,
                                              mgmt_global.g_status_error) 
                LOOP                   
                
                    l_since_rbk_tz := mgmt_global.adjust_tz(avail_rec.start_collection_timestamp,l_target_tzRgn,p_timezone_region);
                         
                    p_unSupStateTargets.extend;
                         
                    p_unSupStateTargets(l_no_avail_tar_count) := MGMT_RBK_TARGET_INFO(l_target_guid,
                            l_sel_tar.target_name,l_sel_tar.target_type,l_since_rbk_tz,NULL,
                           p_timezone_region, avail_rec.current_status);
                         
                    l_no_avail_tar_count := l_no_avail_tar_count + 1;                                               
                    
                END LOOP;
                
            EXCEPTION
                WHEN NO_DATA_FOUND THEN
                    -- It is ok if there is no data that overlaps the unsupported
                    -- last record state
                    NULL;
            END;            
        END LOOP;    
        
    END IF; 
       
END get_ovl_last_unsup_targets;


--
-- PROCEDURE: get_no_avail_targets
--
-- PURPOSE:
--   This api return the target's that do not have availability record
--   at the specified rbk start time.
--
--   IN Parameters:
--     p_targets           :  List of Targets that needs to be checked for 
--                            availability first start record.
--     p_rbk_start_time    :  RBK start time
--     p_timezone_region   : RBK timezone
--   OUT Parameters:
--     p_noAvailTargets    : Availability record having columns:
--                           target_guid  
--                           target_name
--                           target_type
--                           from_time  
--                           to_time  
--                           timezone of from and to time (This will in rbk tz)
PROCEDURE get_no_avail_targets( p_targets           IN MGMT_TARGET_ARRAY,
                                p_rbk_start_time    IN DATE,
                                p_timezone_region   IN VARCHAR2,            
                                p_noAvailTargets    OUT MGMT_RBK_TARGET_INFO_ARRAY)
IS
    l_target_guid           mgmt_targets.target_guid%TYPE;
    l_target_tzRgn          mgmt_targets.timezone_region%TYPE;
    l_start_marker_time     DATE;
    l_count                 NUMBER DEFAULT 1;
    l_sel_tar               MGMT_TARGET_OBJ;
    l_rbk_start_tgt_tz      DATE;
    l_first_avail_rbk_tz    DATE;   
    l_no_avail_tar_count    NUMBER DEFAULT 1;
    
BEGIN   
    
    p_noAvailTargets := MGMT_RBK_TARGET_INFO_ARRAY();    
    
    IF (p_targets IS NOT NULL) THEN            
    
        For l_count IN 1..p_targets.count LOOP
            
            l_sel_tar := p_targets(l_count);
            
            BEGIN
                SELECT target_guid,timezone_region
                    INTO l_target_guid,l_target_tzRgn
                    FROM mgmt_targets
                   WHERE target_name = l_sel_tar.target_name AND
                         target_type = l_sel_tar.target_type;

                             
            EXCEPTION
              WHEN NO_DATA_FOUND
              THEN
                raise_application_error(MGMT_GLOBAL.target_does_not_exist_err,
                        MGMT_GLOBAL.target_does_not_exist_err_m ||
            ' ' || l_sel_tar.target_name || ':' || l_sel_tar.target_type);
           
            END;            
            
            l_rbk_start_tgt_tz := mgmt_global.adjust_tz(p_rbk_start_time,p_timezone_region,l_target_tzRgn);        
            l_start_marker_time := mgmt_avail.get_target_start_marker_time(l_target_guid);            
            
            
            
            IF ( l_rbk_start_tgt_tz < l_start_marker_time) THEN
                
                 l_first_avail_rbk_tz := mgmt_global.adjust_tz(l_start_marker_time,l_target_tzRgn,p_timezone_region);
                 
                 p_noAvailTargets.extend;
                 
                 p_noAvailTargets(l_no_avail_tar_count) := MGMT_RBK_TARGET_INFO(l_target_guid,
                    l_sel_tar.target_name,l_sel_tar.target_type,l_first_avail_rbk_tz,NULL,p_timezone_region,NULL);
                 
                 l_no_avail_tar_count := l_no_avail_tar_count + 1;               
                        
            END IF;
            
        END LOOP;    
        
    END IF; 
       
END get_no_avail_targets;

--
-- PROCEDURE: get_overlap_blk_details
--
-- PURPOSE:
--   This api return the target's existing blackout records that overlaps with
--   specified rbk time period.
--
--   IN Parameters:
--     p_targets           : List of Targets that needs to be checked for 
--                           blackout overlap.
--     p_rbk_start_time    : RBK start time
--     p_rbk_end_time    : RBK end time
--     p_timezone_region   : RBK timezone
--
--   OUT Parameters:
--     p_noAvailTargets    : Availability record having columns:
--                           target_guid  
--                           target_name
--                           target_type
--                           from_time  
--                           to_time  
--                           timezone of from and to time
PROCEDURE get_overlap_blk_details(p_targets       IN  MGMT_TARGET_ARRAY,
                                p_rbk_start_time  IN  DATE,
                                p_rbk_end_time    IN  DATE, 
                                p_timezone_region IN  VARCHAR2,            
                                p_ovlTargets  OUT MGMT_RBK_TARGET_INFO_ARRAY)
IS   
    l_target_guid           mgmt_targets.target_guid%TYPE;
    l_target_tzRgn          mgmt_targets.timezone_region%TYPE;
    l_count                 NUMBER DEFAULT 1;
    l_sel_tar               MGMT_TARGET_OBJ;
    l_rbk_start_tgt_tz      DATE;
    l_rbk_end_tgt_tz        DATE;
    l_blk_overlap_count     NUMBER DEFAULT 1;
    
    CURSOR blackout_avail_cur(v_tar_guid RAW, 
              v_rbk_start DATE,
              v_rbk_end DATE) IS
        select start_collection_timestamp, end_collection_timestamp
        from mgmt_availability 
        where 
        target_guid = v_tar_guid AND
        current_status = MGMT_GLOBAL.G_STATUS_BLACKOUT AND
        ((start_collection_timestamp >= v_rbk_start AND  start_collection_timestamp < v_rbk_end) OR
        (end_collection_timestamp IS NULL AND start_collection_timestamp < v_rbk_end) OR
        (end_collection_timestamp > v_rbk_start AND end_collection_timestamp <= v_rbk_end) OR
        ((v_rbk_start BETWEEN start_collection_timestamp AND end_collection_timestamp) AND 
        (v_rbk_end BETWEEN start_collection_timestamp AND end_collection_timestamp)));
    
BEGIN     
    
    p_ovlTargets := MGMT_RBK_TARGET_INFO_ARRAY();    
    IF (p_targets IS NOT NULL) THEN    
        
    
        For l_count IN 1..p_targets.count LOOP
            
            l_sel_tar := p_targets(l_count);
            
            BEGIN
                SELECT target_guid,timezone_region
                    INTO l_target_guid,l_target_tzRgn
                    FROM mgmt_targets
                   WHERE target_name = l_sel_tar.target_name AND
                         target_type = l_sel_tar.target_type;

                             
            EXCEPTION
              WHEN NO_DATA_FOUND
              THEN
                raise_application_error(MGMT_GLOBAL.target_does_not_exist_err,
                        MGMT_GLOBAL.target_does_not_exist_err_m ||
            ' ' || l_sel_tar.target_name || ':' || l_sel_tar.target_type);
           
            END;            
            
            l_rbk_start_tgt_tz := mgmt_global.adjust_tz(p_rbk_start_time,p_timezone_region,l_target_tzRgn);        
            l_rbk_end_tgt_tz := mgmt_global.adjust_tz(p_rbk_end_time,p_timezone_region,l_target_tzRgn);
            
            
            For avail_rec in blackout_avail_cur(l_target_guid,l_rbk_start_tgt_tz,l_rbk_end_tgt_tz)
            LOOP
                p_ovlTargets.extend;
                
                p_ovlTargets(l_blk_overlap_count) := MGMT_RBK_TARGET_INFO(l_target_guid,
                        l_sel_tar.target_name,l_sel_tar.target_type, avail_rec.start_collection_timestamp,
                        avail_rec.end_collection_timestamp,l_target_tzRgn,NULL);
                        
                l_blk_overlap_count := l_blk_overlap_count + 1;          
                
                
            END LOOP;        
            
        END LOOP;  
    END IF;
    
END get_overlap_blk_details;

--
--Procedure:create_rbk_avail_rec
--Private procedure used by create retroactive blackout api
--To insert a record into mgmt_availability_rbk as a back for the changes
--made to mgmt availability records
--
PROCEDURE create_rbk_avail_backup (p_target_guid IN mgmt_availability.TARGET_GUID%TYPE,
                                p_severity_guid IN mgmt_availability.severity_guid%TYPE,
                                p_current_status IN mgmt_availability.current_status%TYPE,
                                p_blk_reason IN mgmt_blackout_reason.reason%TYPE,
                                p_start_collection_timestamp IN mgmt_availability.start_collection_timestamp%TYPE,
                                p_end_collection_timestamp IN mgmt_availability.end_collection_timestamp%TYPE,
                                p_backup VARCHAR2,
                                p_rbk_guid RAW)
IS
    l_reason_id MGMT_BLACKOUT_REASON.REASON_ID%TYPE;
BEGIN

    IF (p_backup = 'Y') THEN
        
        BEGIN
        
          SELECT reason_id INTO l_reason_id
            FROM mgmt_blackout_reason
            WHERE reason = p_blk_reason;
        EXCEPTION
          WHEN OTHERS THEN
            l_reason_id := '';
        END;
          
        INSERT INTO mgmt_availability_rbk
                            (target_guid,
                             rbk_guid,
                             severity_guid,
                             current_status,
                             reason_id,
                             start_collection_timestamp,
                             end_collection_timestamp)
                       VALUES
                            (p_target_guid,                            
                             p_rbk_guid,
                             p_severity_guid,
                             p_current_status,
                             l_reason_id,
                             p_start_collection_timestamp,
                             p_end_collection_timestamp);  
    END IF;    
    
    
EXCEPTION 
  WHEN OTHERS THEN
  ROLLBACK;
  RAISE;
END;

-- Procedure create_rbk_severity
-- This is private method used by create_retroactive blackout
-- It inserts blackout start and blackout end severity code mimicing the behaviour
-- of conventional blackout.Note these severities are inserted into a new table mgmt_severity_rbk
PROCEDURE create_rbk_severity(p_target_guid IN mgmt_availability.TARGET_GUID%TYPE,                              
                              p_blk_reason IN mgmt_blackout_reason.reason%TYPE,
                              p_rbk_start_time IN DATE,                              
                              p_rbk_end_time IN DATE,
                              p_rbk_guid IN RAW,
                              p_uname IN VARCHAR2)
IS
    l_update_availability BOOLEAN := FALSE;
    l_response_metric_guid RAW(16);    
    l_start_msg VARCHAR2(1000);
    l_stop_msg VARCHAR2(1000);
    l_start_msg_params VARCHAR2(1000);
    l_stop_msg_params VARCHAR2(1000);    
BEGIN

    --Insert a dummy severity in the mgmt_severity_rbk. This would be useful
    -- to do the union of actually severity and rbk severity and filter
    -- out actual severity in between the rbk window
    
    --Get Availability metric
    BEGIN
    
        SELECT DISTINCT met.metric_guid INTO l_response_metric_guid
            FROM MGMT_TARGETS tgt, MGMT_METRICS met
           WHERE tgt.target_guid = p_target_guid
             AND tgt.target_type = met.target_type
             AND met.metric_name = MGMT_GLOBAL.G_AVAIL_METRIC_NAME
             AND met.metric_column = MGMT_GLOBAL.G_AVAIL_METRIC_COLUMN
             AND met.type_meta_ver = tgt.type_meta_ver
             AND (met.category_prop_1 = tgt.category_prop_1 OR 
                  met.category_prop_1 = ' ')
             AND (met.category_prop_2 = tgt.category_prop_2 OR 
                  met.category_prop_2 = ' ')
             AND (met.category_prop_3 = tgt.category_prop_3 OR 
                  met.category_prop_3 = ' ')
             AND (met.category_prop_4 = tgt.category_prop_4 OR 
                  met.category_prop_4 = ' ')
             AND (met.category_prop_5 = tgt.category_prop_5 OR 
                  met.category_prop_5 = ' ');
                 
    
        l_update_availability := TRUE;
      
    EXCEPTION
      WHEN NO_DATA_FOUND THEN
        l_update_availability := FALSE;
        
    END;    
   

    IF (l_update_availability = TRUE) THEN   

        l_start_msg := REPLACE(RBK_START_MSG, '{0}', p_uname);
        l_start_msg := REPLACE(l_start_msg, '{1}', p_blk_reason);                

        l_start_msg_params := p_uname||'&'||p_blk_reason;


        -- Setting blackout for this target in rbk severity table
        BEGIN
          INSERT INTO mgmt_severity_rbk
            (target_guid,rbk_guid, metric_guid, 
             collection_timestamp,
             severity_code, message, message_nlsid, message_params)
          VALUES 
            (p_target_guid, p_rbk_guid,l_response_metric_guid,
             p_rbk_start_time, 
             MGMT_GLOBAL.G_SEVERITY_BLACKOUT_START,
             l_start_msg, RBK_START_MSG_NLSID, l_start_msg_params );          
        END;
        
        
        l_stop_msg := RBK_STOP_MSG;
        l_stop_msg_params := ' ' ;
        BEGIN
          INSERT INTO mgmt_severity_rbk
            (target_guid, rbk_guid,metric_guid, 
             collection_timestamp,
             severity_code, message, message_nlsid, message_params)
          VALUES 
            (p_target_guid, p_rbk_guid, l_response_metric_guid,
             p_rbk_end_time, 
             MGMT_GLOBAL.G_SEVERITY_BLACKOUT_END,
             l_stop_msg, RBK_STOP_MSG_NLSID, l_stop_msg_params );
        END;
        
    END IF;

EXCEPTION 
  WHEN OTHERS THEN
  ROLLBACK;
  RAISE;
  
END;


--
-- Procedure:create_avail_rec
-- This is private function used by create_retroactive blackout to insert intermediate
-- records or rbk records into mgmt_availability table
--
PROCEDURE create_avail_rec  (p_target_guid IN mgmt_availability.TARGET_GUID%TYPE,
                            p_severity_guid IN mgmt_availability.severity_guid%TYPE,
                            p_current_status IN mgmt_availability.current_status%TYPE,                                
                            p_start_collection_timestamp IN mgmt_availability.start_collection_timestamp%TYPE,
                            p_end_collection_timestamp IN mgmt_availability.end_collection_timestamp%TYPE)
IS   
BEGIN
    INSERT INTO mgmt_availability
                (target_guid,
                 severity_guid,
                 current_status,
                 start_collection_timestamp,
                 end_collection_timestamp)
           VALUES
                (p_target_guid,
                 p_severity_guid,
                 p_current_status,
                 p_start_collection_timestamp,
                 p_end_collection_timestamp);                       
    
EXCEPTION 
  WHEN OTHERS THEN
  ROLLBACK;
  RAISE;    
END;

--
-- Procedure:create_retroactive_blackout
-- This creates a retroactive blackout on the targest specified.
-- It would internally modify the availability records of the targets 
-- that are found in this rbk window.
-- If there is blackout record overlaping with rbk timeperiod then
-- blackout will take precendence over rbk.
-- Also it will not modify any records in current state as unreachable,unknown,error.
-- Before modifying the existing blackout it will back the availability record 
-- if the paramter passed to it is 'Y'
-- It would also insert a dummy severity of blackout start and blackout end in the
-- mgmt_severity_rbk. This will later aid in masking rbk sverity over standard severity
-- Parameters:
--          p_targets           List of targets which needs to be under retroactive_blackout
--          p_rbk_start_time_in Retroactive blackout start time
--          p_rbk_end_time_in   Retroactive blackout end time
--          p_timezone_region   Timezone region for retroactive blackout
--          p_create_backup     To create backup mgmt_availability
--          p_err_targets       List of Erroneous Targets on Error
PROCEDURE create_retroactive_blackout (p_targets IN MGMT_TARGET_ARRAY, 
                                       p_reason IN VARCHAR2,
                                       p_rbk_start_time_in DATE,
                                       p_rbk_end_time_in DATE,
                                       p_timezone_region IN VARCHAR2,
                                       p_create_backup IN VARCHAR2 DEFAULT 'N',
                                       p_err_targets OUT VARCHAR2_TABLE)
			   
IS
    uname mgmt_created_users.USER_NAME%TYPE:=MGMT_USER.GET_CURRENT_EM_USER;
    l_reason_id MGMT_BLACKOUT_REASON.REASON_ID%TYPE;
    USER_DOES_NOT_HAVE_PRIV number:=0;
    l_target_st_marker_time DATE;
    l_err_targets           VARCHAR2_TABLE;
    l_err_count             number := 1;
    l_is_super              NUMBER:= MGMT_USER.HAS_PRIV(MGMT_USER.GET_CURRENT_EM_USER, 'SUPER_USER');
    l_err_msg1              VARCHAR2(2000);
    l_err_msg2              VARCHAR2(2000);
    l_inserted              VARCHAR2(1):='N';
    
    l_start_collection_timestamp DATE;
    l_end_collection_timestamp   DATE;
    
    l_actual_start_time DATE;
    l_actual_end_time DATE;   
    
    l_target_guid           mgmt_targets.target_guid%TYPE;
    l_target_tzRgn          mgmt_targets.timezone_region%TYPE;
    l_count                 NUMBER DEFAULT 1;
    l_sel_tar               MGMT_TARGET_OBJ;
    l_rbk_start_tgt_tz      DATE;
    l_rbk_end_tgt_tz        DATE;
    l_current_status        NUMBER;
    l_sucuess               BOOLEAN;
    l_rbk_sev_to_add        BOOLEAN;
    l_reason_required       VARCHAR(10);   
    l_rbk_guid RAW(16);
    l_last_rbk_start_time   DATE;
    l_last_rbk_end_time     DATE;
    l_new_target_loop       BOOLEAN;

    
    -- Order by start collection timestamp is requried because we are clubing
    -- RBK records over chunk of *consecutive* availabilty records with an exception that
    -- Blackout records(even severity) are not overriden by RBK.
    CURSOR cr_rbk_avail(v_tar_guid RAW, 
              v_rbk_start DATE,
              v_rbk_end DATE,
              v_blk_status NUMBER,
              v_status_unreachable NUMBER,
              v_status_unknown NUMBER,
              v_status_error NUMBER) IS
        SELECT start_collection_timestamp, 
               end_collection_timestamp,
               current_status,
               target_guid,
               severity_guid
        FROM  mgmt_availability 
        WHERE target_guid = v_tar_guid AND
              current_status <> v_blk_status AND              
              (
              
              (start_collection_timestamp >= v_rbk_start AND  start_collection_timestamp < v_rbk_end 
              AND end_collection_timestamp IS NOT NULL) OR
              
              (end_collection_timestamp IS NULL AND start_collection_timestamp < v_rbk_end AND 
              current_status not in(v_status_unreachable,v_status_unknown,v_status_error)) OR
              
              (end_collection_timestamp > v_rbk_start AND end_collection_timestamp <= v_rbk_end) OR
              
              ((v_rbk_start BETWEEN start_collection_timestamp AND end_collection_timestamp) AND 
              (v_rbk_end BETWEEN start_collection_timestamp AND end_collection_timestamp))
              
              ) AND
              
              (start_collection_timestamp <> NVL(end_collection_timestamp,start_collection_timestamp+1))
              ORDER BY start_collection_timestamp DESC;
        
BEGIN
    -- Check if retroactive blackout feature is enabled
    IF(is_retroactive_blackout_enable() = 'false') THEN
        raise_application_error(MGMT_GLOBAL.RBK_DISABLED_ERR,'Cannot create retroactive blackout, as the feature is disabled');
    END IF;    
    
   -- now become a super user temporarily for changing availability as well create back up records
   SETEMUSERCONTEXT(MGMT_USER.GET_REPOSITORY_OWNER, MGMT_USER.OP_SET_IDENTIFIER);
  
    --If logged USER is not a SUPER USER Check if he was valid Privileges
    
    p_err_targets := VARCHAR2_TABLE();
    FOR i in 1..p_targets.count LOOP
    
      IF (mgmt_user.HAS_PRIV(uname, mgmt_user.SUPER_USER) != mgmt_user.USER_HAS_PRIV) THEN
          --TODO LATER ACCORDING TO USER MODEL change the privileges
          USER_DOES_NOT_HAVE_PRIV:=MGMT_USER.HAS_PRIV(user_name_in=>uname,
                                  priv_name_in=>'OPERATOR_TARGET',
                                  target_name_in=>p_targets(i).target_name,
                                  target_type_in=>p_targets(i).target_type
                                  );
            IF (USER_DOES_NOT_HAVE_PRIV != MGMT_USER.USER_HAS_PRIV) THEN
                p_err_targets.extend;
                l_err_msg1:=MGMT_GLOBAL.INSUFFICIENT_PRIVILEGES_ERR;
                l_err_msg2:=MGMT_GLOBAL.INSUFFICIENT_PRIVILEGES_ERR_M ||'TO CREATE RBK BLACKOUT';
                p_err_targets(l_err_count):=p_targets(i).target_name||'~'||p_targets(i).target_type||'!'||'NO_PRIV';
                l_err_count := l_err_count + 1;
            END IF;
        END IF;
        
      BEGIN
            SELECT target_guid,timezone_region
                INTO l_target_guid,l_target_tzRgn
                FROM mgmt_targets
               WHERE target_name = p_targets(i).target_name AND
                     target_type = p_targets(i).target_type;                          
        EXCEPTION
          WHEN NO_DATA_FOUND
          THEN
            raise_application_error(MGMT_GLOBAL.target_does_not_exist_err,
                    MGMT_GLOBAL.target_does_not_exist_err_m ||
        ' ' || p_targets(i).target_name || ':' || p_targets(i).target_type);
       
        END;            
        
        -- Get target start marker time from when the target's availability is 
        -- known reliably
        l_rbk_start_tgt_tz := mgmt_global.adjust_tz(p_rbk_start_time_in,p_timezone_region,l_target_tzRgn);        
        l_rbk_end_tgt_tz := mgmt_global.adjust_tz(p_rbk_end_time_in,p_timezone_region,l_target_tzRgn);
        l_target_st_marker_time := mgmt_avail.get_target_start_marker_time(
                                target_name_in=>p_targets(i).target_name,
                                target_type_in=>p_targets(i).target_type
                                );

         IF (l_rbk_start_tgt_tz < l_target_st_marker_time) THEN
             p_err_targets.extend;
             l_err_msg1:='ERROR IN CREATING RBK BLACKOUT';
             l_err_msg2:='RBK START TIME-->'||l_rbk_start_tgt_tz||'IS GREATER THAN MARKER TIME-->'||l_target_st_marker_time;
             p_err_targets(l_err_count):=p_targets(i).target_name||'~'||p_targets(i).target_type||'!'||'MARKER_ISSUE';
             l_err_count := l_err_count + 1;
         END IF;         
    END LOOP;
    
    IF (p_err_targets IS NOT NULL AND p_err_targets.count > 0) THEN
    
        SETEMUSERCONTEXT(uname, MGMT_USER.OP_SET_IDENTIFIER);
        raise_application_error(l_err_msg1,
                            l_err_msg2 );                             
        
        RETURN;
        
    END IF;    
    
    
     --Reason require check
     BEGIN
        l_reason_required := MGMT_BLACKOUT.get_reason_required();
        IF (l_reason_required = 'true')
        THEN
          SELECT reason_id
            INTO l_reason_id
            FROM mgmt_blackout_reason
           WHERE reason = p_reason;
        END IF;
  
      EXCEPTION
        WHEN NO_DATA_FOUND THEN
          IF (mgmt_user.HAS_PRIV(uname, mgmt_user.SUPER_USER) != mgmt_user.USER_HAS_PRIV)
          THEN
            raise_application_error(MGMT_GLOBAL.INVALID_BLACKOUT_REASON_ERR, 'Only superusers are allowed to add new reason');
          ELSE
            l_reason_id := mgmt_blackout.add_reason(p_reason);
          END IF;
      END;
    
    
    -- Availability states
    --G_STATUS_DOWN                CONSTANT NUMBER(1) := 0;
    --G_STATUS_UP                  CONSTANT NUMBER(1) := 1;
    --G_STATUS_ERROR               CONSTANT NUMBER(1) := 2;
    --G_STATUS_AGENT_DOWN          CONSTANT NUMBER(1) := 3;
    --G_STATUS_UNREACHABLE         CONSTANT NUMBER(1) := 4;
    --G_STATUS_BLACKOUT            CONSTANT NUMBER(1) := 5;
    --G_STATUS_UNKNOWN             CONSTANT NUMBER(1) := 6;
    
    --rbk guid to be inserted into rbk severity and backup record
    l_rbk_guid := SYS_GUID();
    
    l_last_rbk_start_time  := NULL;
    l_last_rbk_end_time  := NULL;    
    l_rbk_sev_to_add := FALSE;
    
    IF (p_targets IS NOT NULL) THEN    
        For l_count IN 1..p_targets.count LOOP            
            l_sel_tar := p_targets(l_count);            
            
            BEGIN
                SELECT target_guid,timezone_region
                    INTO l_target_guid,l_target_tzRgn
                    FROM mgmt_targets
                   WHERE target_name = l_sel_tar.target_name AND
                         target_type = l_sel_tar.target_type;                          
            EXCEPTION
              WHEN NO_DATA_FOUND
              THEN
                raise_application_error(MGMT_GLOBAL.target_does_not_exist_err,
                        MGMT_GLOBAL.target_does_not_exist_err_m ||
            ' ' || l_sel_tar.target_name || ':' || l_sel_tar.target_type);
           
            END;            
            
            l_rbk_start_tgt_tz := mgmt_global.adjust_tz(p_rbk_start_time_in,p_timezone_region,l_target_tzRgn);        
            l_rbk_end_tgt_tz := mgmt_global.adjust_tz(p_rbk_end_time_in,p_timezone_region,l_target_tzRgn);

            BEGIN            
                -- Lock all the availability records for the target.
                EM_SEVERITY.lock_avail_for_tgt(l_target_guid);                                            
                
                l_last_rbk_start_time := NULL;
                l_last_rbk_end_time := NULL;
                l_new_target_loop := TRUE;
                l_rbk_sev_to_add := FALSE;
            
                                  
            
                For avail_rec in cr_rbk_avail(l_target_guid,l_rbk_start_tgt_tz,
                                              l_rbk_end_tgt_tz,
                                              mgmt_global.g_status_blackout,
                                              mgmt_global.g_status_unreachable,
                                              mgmt_global.g_status_unknown,
                                              mgmt_global.g_status_error)
                LOOP                                                 
                    
                    IF(l_new_target_loop = TRUE) THEN
                        l_new_target_loop := FALSE;
                        
                        IF(avail_rec.end_collection_timestamp IS NULL) THEN
                           l_last_rbk_end_time := l_rbk_end_tgt_tz;
                        ELSE
                           l_last_rbk_end_time := LEAST(l_rbk_end_tgt_tz,avail_rec.end_collection_timestamp);
                        END IF;
                    
        /*            ELSE
                    -- If we want to split the rbk records for overlapping blackout following is
                    --the code
        
                        -- This means there is split because of conventional blackout in between                    
                        IF(l_last_rbk_start_time <> avail_rec.end_collection_timestamp) THEN
                            IF(l_rbk_sev_to_add = TRUE) THEN
                              create_rbk_severity(l_target_guid,p_reason,
                                                  l_last_rbk_start_time,l_last_rbk_end_time,l_rbk_guid);
                              l_rbk_sev_to_add :=  FALSE;
                             END IF;
                             l_last_rbk_end_time := avail_rec.end_collection_timestamp;
                        END IF;*/
                    END IF;                  
                   
                    --Case 1 If avail end time is null(Last record)                
                    IF(avail_rec.end_collection_timestamp IS NULL) THEN
                      
                       create_rbk_avail_backup(p_target_guid=>avail_rec.target_guid,
                                                 p_severity_guid=>avail_rec.severity_guid,
                                                 p_current_status=>avail_rec.current_status,
                                                 p_blk_reason => p_reason,
                                                 p_start_collection_timestamp=>avail_rec.start_collection_timestamp,
                                                 p_end_collection_timestamp=>avail_rec.end_collection_timestamp,
                                                 p_backup => p_create_backup,
                                                 p_rbk_guid => l_rbk_guid
                                                );                                               
                        
                        --Update the current record with end time to rbk start time
                        UPDATE MGMT_AVAILABILITY
                              SET end_collection_timestamp = GREATEST(l_rbk_start_tgt_tz,avail_rec.start_collection_timestamp)
                            WHERE target_guid = avail_rec.target_guid and
                                  start_collection_timestamp = avail_rec.start_collection_timestamp and
                                  current_status = avail_rec.current_status;
                        
                        l_last_rbk_start_time := GREATEST(l_rbk_start_tgt_tz,
                                                          avail_rec.start_collection_timestamp);
                        l_rbk_sev_to_add := TRUE;
                                                          
                        create_avail_rec(p_target_guid=>avail_rec.target_guid,
                                       p_severity_guid=>NULL,
                                       p_current_status=>mgmt_global.g_status_blackout,                                         
                                       p_start_collection_timestamp=>GREATEST(l_rbk_start_tgt_tz,
                                       avail_rec.start_collection_timestamp),
                                       p_end_collection_timestamp=>l_rbk_end_tgt_tz
                                      );
                        
                        create_avail_rec(p_target_guid=>avail_rec.target_guid,
                                         p_severity_guid=>avail_rec.severity_guid,
                                         p_current_status=>avail_rec.current_status,
                                         p_start_collection_timestamp=>l_rbk_end_tgt_tz,
                                         p_end_collection_timestamp=>NULL
                                        );                                                 
                       
                                         
                    -- Case 2. If avail_st/end exactly matches the rbk_st/end period OR
                    -- Avail record is completely inside RBK timeperiod
                    -- E.g. Avail 8 AM to 9 AM
                    --      RBK 8 AM to 9 AM. OR RBK 7 AM to 10 AM.
                    
                    ELSIF (l_rbk_start_tgt_tz <= avail_rec.start_collection_timestamp AND
                            l_rbk_end_tgt_tz >= avail_rec.end_collection_timestamp) THEN                     
                          
                       
                        create_rbk_avail_backup(p_target_guid=>avail_rec.target_guid,
                                             p_severity_guid=>avail_rec.severity_guid,
                                             p_current_status=>avail_rec.current_status,
                                             p_blk_reason => p_reason,
                                             p_start_collection_timestamp=>avail_rec.start_collection_timestamp,
                                             p_end_collection_timestamp=>avail_rec.end_collection_timestamp,
                                             p_backup => p_create_backup,
                                             p_rbk_guid => l_rbk_guid
                                            );                    
                        
                        l_last_rbk_start_time := avail_rec.start_collection_timestamp;
                        l_rbk_sev_to_add := TRUE;
                        
                        create_avail_rec(p_target_guid=>avail_rec.target_guid,
                                             p_severity_guid=>NULL,
                                             p_current_status=>mgmt_global.g_status_blackout,                                         
                                             p_start_collection_timestamp=>avail_rec.start_collection_timestamp,
                                             p_end_collection_timestamp=>avail_rec.end_collection_timestamp
                                            );        
                                            
                        --Mark end time to start time. Keep this record
                        UPDATE MGMT_AVAILABILITY
                          SET end_collection_timestamp = avail_rec.start_collection_timestamp
                          WHERE target_guid = avail_rec.target_guid and                     
                                current_status = avail_rec.current_status and
                                start_collection_timestamp = avail_rec.start_collection_timestamp; 
                        
                        
                    --CASE 3. If avail_rec contains both RBK_start_time and RBK_end_time     
                    
                    ELSIF (avail_rec.start_collection_timestamp <= l_rbk_start_tgt_tz AND
                          l_rbk_end_tgt_tz <= avail_rec.end_collection_timestamp) THEN
                    --Example AvailTimeWindow 9AM     <->     12 AM
                    --        RBK Time Window      10AM <->11 AM
                        --i. update avail row as ( avail.rec status,avail.rec.start_time , rbk.start time)
                        
                            
                        create_rbk_avail_backup(p_target_guid=>avail_rec.target_guid,
                                             p_severity_guid=>avail_rec.severity_guid,
                                             p_current_status=>avail_rec.current_status,
                                             p_blk_reason => p_reason,
                                             p_start_collection_timestamp=>avail_rec.start_collection_timestamp,
                                             p_end_collection_timestamp=>avail_rec.end_collection_timestamp,
                                             p_backup => p_create_backup,
                                             p_rbk_guid => l_rbk_guid
                                            ); 
    
                        
                        IF (avail_rec.start_collection_timestamp = l_rbk_start_tgt_tz) THEN
                          
                            --. Create new avail row as ( avail.rec status,rbk_end_time_in ,avail_rec.end_time)
                            create_avail_rec(p_target_guid=>avail_rec.target_guid,
                                                 p_severity_guid=>avail_rec.severity_guid,
                                                 p_current_status=>avail_rec.current_status,
                                                 p_start_collection_timestamp=>l_rbk_end_tgt_tz,
                                                 p_end_collection_timestamp=>avail_rec.end_collection_timestamp
                                                );
                                                
                            --Just update with start time = rbk end time
                            UPDATE MGMT_AVAILABILITY
                                  SET end_collection_timestamp = avail_rec.start_collection_timestamp
                                WHERE target_guid =avail_rec.target_guid and
                                      start_collection_timestamp = avail_rec.start_collection_timestamp and
                                      current_status = avail_rec.current_status;
                        
                        ELSIF (avail_rec.end_collection_timestamp = l_rbk_end_tgt_tz) THEN
                        
                           --Just update with end time = rbk start time
                            UPDATE MGMT_AVAILABILITY
                                  SET end_collection_timestamp = l_rbk_start_tgt_tz
                                WHERE target_guid =avail_rec.target_guid and
                                      start_collection_timestamp = avail_rec.start_collection_timestamp and
                                      current_status = avail_rec.current_status;
                                      
                        
                        ELSE
                            l_end_collection_timestamp := avail_rec.end_collection_timestamp;
                            --update with end time = rbk start time
                            UPDATE MGMT_AVAILABILITY
                                  SET end_collection_timestamp = l_rbk_start_tgt_tz
                                WHERE target_guid =avail_rec.target_guid and                                  
                                      start_collection_timestamp = avail_rec.start_collection_timestamp and
                                      current_status = avail_rec.current_status;
                                
                                
                             --. Create new avail row as ( avail.rec status,rbk_end_time_in ,avail_rec.end_time)
                            create_avail_rec(p_target_guid=>avail_rec.target_guid,
                                                 p_severity_guid=>avail_rec.severity_guid,
                                                 p_current_status=>avail_rec.current_status,
                                                 p_start_collection_timestamp=>l_rbk_end_tgt_tz,
                                                 p_end_collection_timestamp=>l_end_collection_timestamp
                                                );
                        END IF;                        
                                            
                         --ii. Create new avail row as (mgmt_global.g_status_blackout,rbk_start_time_in,rbk_end_time_in)
                        l_last_rbk_start_time := l_rbk_start_tgt_tz;
                        l_rbk_sev_to_add := TRUE;
                        create_avail_rec(p_target_guid=>avail_rec.target_guid,
                                             p_severity_guid=>NULL,
                                             p_current_status=>mgmt_global.g_status_blackout,
                                             p_start_collection_timestamp=>l_rbk_start_tgt_tz,
                                             p_end_collection_timestamp=>l_rbk_end_tgt_tz
                                            );                                            
                        
                  --case 4. If avail_rec contains only RBK_start_time
                  ELSIF (avail_rec.start_collection_timestamp <= l_rbk_start_tgt_tz AND
                        (l_rbk_end_tgt_tz > avail_rec.end_collection_timestamp)) THEN
                        
                        create_rbk_avail_backup(p_target_guid=>avail_rec.target_guid,
                                             p_severity_guid=>avail_rec.severity_guid,
                                             p_current_status=>avail_rec.current_status,
                                             p_blk_reason => p_reason,
                                             p_start_collection_timestamp=>avail_rec.start_collection_timestamp,
                                             p_end_collection_timestamp=>avail_rec.end_collection_timestamp,
                                             p_backup => p_create_backup,
                                             p_rbk_guid => l_rbk_guid
                                            );                                            
                        
                          -- Example AvailTimeWindow 8AM <->11 AM
                          --       RBK Time Window   9AM  <-> 12 AM                      
                          
                          -- Create a new rbk avail rec
                          l_last_rbk_start_time := l_rbk_start_tgt_tz;
                          l_rbk_sev_to_add := TRUE;
                          create_avail_rec(p_target_guid=>avail_rec.target_guid,
                                             p_severity_guid=>NULL,
                                             p_current_status=>mgmt_global.g_status_blackout,
                                             p_start_collection_timestamp=>l_rbk_start_tgt_tz,
                                             p_end_collection_timestamp=>avail_rec.end_collection_timestamp
                                            );  
                        
                         IF (avail_rec.start_collection_timestamp = l_rbk_start_tgt_tz) THEN
                            
                            UPDATE MGMT_AVAILABILITY
                              SET end_collection_timestamp = avail_rec.start_collection_timestamp
                            WHERE target_guid =avail_rec.target_guid and                                             
                                  start_collection_timestamp = avail_rec.start_collection_timestamp and
                                  current_status = avail_rec.current_status;
                         ELSE         
                             UPDATE MGMT_AVAILABILITY
                                SET end_collection_timestamp = l_rbk_start_tgt_tz
                             WHERE target_guid =avail_rec.target_guid and                              
                                  start_collection_timestamp = avail_rec.start_collection_timestamp and
                                  current_status = avail_rec.current_status;
                         END IF;
                        
                   --case 5. If avail_rec contains only blackout_end_time
                  ELSIF (avail_rec.start_collection_timestamp > l_rbk_start_tgt_tz AND
                         (l_rbk_end_tgt_tz <= avail_rec.end_collection_timestamp)) THEN
                         
                          --Example AvailTimeWindow      9AM <->  12 AM
                          --        RBK Time Window   8AM  <-> 11 AM                     
                      
                        create_rbk_avail_backup(p_target_guid=>avail_rec.target_guid,
                                             p_severity_guid=>avail_rec.severity_guid,
                                             p_current_status=>avail_rec.current_status,
                                             p_blk_reason => p_reason,
                                             p_start_collection_timestamp=>avail_rec.start_collection_timestamp,
                                             p_end_collection_timestamp=>avail_rec.end_collection_timestamp,
                                             p_backup => p_create_backup,
                                             p_rbk_guid => l_rbk_guid
                                            ); 
    
                        
                        --Create rbk record
                        l_last_rbk_start_time := avail_rec.start_collection_timestamp;
                        l_rbk_sev_to_add := TRUE;
                        create_avail_rec(p_target_guid=>avail_rec.target_guid,
                                             p_severity_guid=>NULL,
                                             p_current_status=>mgmt_global.g_status_blackout,
                                             p_start_collection_timestamp=>avail_rec.start_collection_timestamp,
                                             p_end_collection_timestamp=>l_rbk_end_tgt_tz
                                            );
                        
                        IF (l_rbk_end_tgt_tz = avail_rec.end_collection_timestamp) THEN   
                        
                            UPDATE MGMT_AVAILABILITY
                              SET end_collection_timestamp = avail_rec.start_collection_timestamp
                            WHERE target_guid = avail_rec.target_guid and                             
                                  current_status = avail_rec.current_status and
                                  start_collection_timestamp = avail_rec.start_collection_timestamp;
                        ELSE
                            --We are creating a record as we try to avoid
                            --updating the start time. As this start time may be 
                            --related to severity guid collection timestamp.
                            create_avail_rec(p_target_guid=>avail_rec.target_guid,
                                                 p_severity_guid=>avail_rec.severity_guid,
                                                 p_current_status=>avail_rec.current_status,
                                                 p_start_collection_timestamp=>l_rbk_end_tgt_tz,
                                                 p_end_collection_timestamp=>avail_rec.end_collection_timestamp
                                                );
                            
                            UPDATE MGMT_AVAILABILITY
                                SET end_collection_timestamp = avail_rec.start_collection_timestamp
                             WHERE target_guid = avail_rec.target_guid and                             
                                  current_status = avail_rec.current_status and
                                  start_collection_timestamp = avail_rec.start_collection_timestamp;
                        END IF; 
                    END IF;
                END LOOP;
            EXCEPTION
                -- This is ok when there is no availability data for the target like groups
                WHEN NO_DATA_FOUND THEN
                    NULL;
            END;
            --Add the last record if it supposed to be aded
             IF(l_rbk_sev_to_add = TRUE) THEN
              create_rbk_severity(l_target_guid,p_reason,
                                  l_last_rbk_start_time,l_last_rbk_end_time,l_rbk_guid,uname);
              l_rbk_sev_to_add :=  FALSE;
             END IF;
            
         END LOOP; 
    END IF;    
    COMMIT;
    SETEMUSERCONTEXT(uname, MGMT_USER.OP_SET_IDENTIFIER);                      
    
EXCEPTION 
  WHEN OTHERS THEN
  -- If there is any exception rollback everything and raise the same exception.
      ROLLBACK;
      -- Revert to logged in user
      SETEMUSERCONTEXT(uname, MGMT_USER.OP_SET_IDENTIFIER);                      
      RAISE;
END;



END mgmt_blackout_ui;
/

show errors

