Rem
Rem $Header: chronos_admin_pkgdef.sql 13-apr-2005.14:55:46 eporter Exp $
Rem
Rem chronos_admin_pkgdef.sql
Rem
Rem Copyright (c) 2002, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      chronos_admin_pkgdef.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    eporter     04/13/05 - Apply chronos_set_target_filter to other types 
Rem    adosani     03/14/05 - add run metric dates purge policy 
Rem    rpinnama    05/15/02 - rpinnama_reorg_rep_scripts
Rem    rpinnama    05/15/02 - Created
Rem

CREATE OR REPLACE Package EMD_CHRONOS_ADMIN
AS

-- Purge Policy Groups
G_RETENTION_GROUP_RUNMETRIC CONSTANT VARCHAR2(32) := 'RUNMETRIC_DATES';

TYPE p_rowid_list_type IS
  TABLE OF UROWID
  INDEX BY BINARY_INTEGER;

-- Procedure SET_TARGET_FILTER
-- This procedure sets filter porperties min_hits,event_window_size and max_time for each target
-- If the property is attempted to be set on a composite target, then each
-- constituent target of that composite target with type oracle_webcache,
-- oracle_apache, or standalone_apache
-- gets that property along with the composite target.
-- If a webcache or apache target is specified, then property is set only 
-- against that particular target.
-- Usage:
-- chronos_set_target_filter('target1','oracle_webcache','min_hits','20');
-- chronos_set_target_filter('comp_target1','website','min_hits','20');
-- Limitation: Only one level of indirection from the base composite target
--
PROCEDURE CHRONOS_SET_TARGET_FILTER(
              target_name_in             IN VARCHAR2,
              target_type_in             IN VARCHAR2,
              filter_name_in             IN VARCHAR2,
              filter_value_in            IN VARCHAR2);



-- Procedure SET_COLLECTION_SCHEDULE
-- This procedure sets up a collection schedule against a target
-- It uses modify_collection procedure in EmdCollection API to
-- set the specified schedule against a metric for a target.
-- Usage:
-- chr_set_collection_schedule('target1','oracle_webcache','chronos_collection','Y',20)

PROCEDURE SET_COLLECTION_SCHEDULE(
              target_name_in       IN VARCHAR2,
              target_type_in       IN VARCHAR2,
              metric_name_in       IN VARCHAR2,
              store_metric_in      IN VARCHAR2,
              schedule_in          IN NUMBER);


-- Procedure CHRONOS_PURGE_INTERVAL -- This procedure purges all chronos data 
-- along an intervalin a time-line. Start period and end-period are expected
-- and must be provided.
-- Usage:
-- chronos_purge_interval('target1','oracle_webcache',
--    to_date('24-Jul-2001','dd-mon-yyyy'),to_date('30-Jul-2001','dd-mon-yyyy'),'daily');
-- chronos_purge_interval('target1','oracle_webcache',
--    to_date('02-Aug-2001','dd-mon-yyyy'),to_date('30-Aug-2001','dd-mon-yyyy'));

PROCEDURE CHRONOS_PURGE_INTERVAL(
              target_name_in  IN VARCHAR2,
              target_type_in  IN VARCHAR2,
              start_period_in IN DATE,
              end_period_in   IN DATE,
              axis_period_in  IN VARCHAR2 DEFAULT NULL);



-- Procedure CHRONOS_PURGE_TIME
-- This procedure purges chronos data on an open ended trailing interval
-- from a particular date and time along the time-line.
-- Usage:
-- chronos_purge_time('target1','oracle_webcache',
--    to_date('24-Jul-2001 11:00:00 pm','dd-mon-yyyy hh:mi:ss am'),'dist_daily');

PROCEDURE CHRONOS_PURGE_TIME(
              target_name_in  IN VARCHAR2,
              target_type_in  IN VARCHAR2,
              end_period_in   IN DATE,
              axis_period_in  IN VARCHAR2 DEFAULT NULL);


-- Procedure CHRONOS_PURGE_ALL
-- This procedure purges all data for a specific target
-- for all time and along all axes (daily|hourly|dist_daily|dist_hourly)
-- Usage:
-- chronos_purge_all('target1','oracle_webcache')


PROCEDURE CHRONOS_PURGE_ALL(
              target_name_in  IN VARCHAR2,
              target_type_in  IN VARCHAR2);



-- Procedure CHRONOS_PURGE_RAW
-- Purge raw data from mgmt_rt_metrics_raw table
-- along a trailing window in time-line
-- Usage:
-- chronos_purge_raw('target1','oracle_webcache',to_date('02-Aug-2001','dd-mon-yyyy'))


PROCEDURE CHRONOS_PURGE_RAW(
              target_name_in  IN VARCHAR2,
              target_type_in  IN VARCHAR2,
              end_period_in   IN DATE);


-- Procedure CHRONOS_PURGE_TIME_DATA
-- This procedure is used as the goto procedure from all other procedure
-- to do actual deletion. Not exposed to end user.

PROCEDURE CHRONOS_PURGE_TIME_DATA(
              target_name_in  IN VARCHAR2,
              target_type_in  IN VARCHAR2,
              start_period_in IN DATE DEFAULT NULL,
              end_period_in   IN DATE DEFAULT NULL,
              axis_period_in  IN VARCHAR2 DEFAULT NULL);



--
-- Function to delete raw data from mgmt_rt_metrics_raw table
--

FUNCTION DELETE_RAW_DATA(
              target_name_in  IN VARCHAR2,
              target_type_in  IN VARCHAR2,
              begin_time_in   IN DATE,
              end_time_in     IN DATE) RETURN VARCHAR2;



--
-- Function to delete hourly data along url,domain and ip axes
-- Delete data in tables mgmt_rt_url_1hour,mgmt_rt_ip_1hour and
-- mgmt_rt_domain_1hour
--


FUNCTION DELETE_HOURLY_DATA(
              target_name_in  IN VARCHAR2,
              target_type_in  IN VARCHAR2,
              begin_time_in   IN DATE,
              end_time_in     IN DATE) RETURN VARCHAR2;
--
-- Function to delete daily data long ip,domain and url axes
-- Delete data in tables mgmt_rt_url_1day,mgmt_rt_ip_1day and
-- mgmt_rt_domain_1day
--


FUNCTION DELETE_DAILY_DATA(
              target_name_in  IN VARCHAR2,
              target_type_in  IN VARCHAR2,
              begin_time_in   IN DATE,
              end_time_in     IN DATE) RETURN VARCHAR2;



--
-- Function to delete hourly distribution data long ip,domain and url axes
-- Delete data in tables mgmt_rt_url_dist_1hour,mgmt_rt_ip_dist_1hour and
-- mgmt_rt_domain_dist_1hour
--

FUNCTION DELETE_HOURLY_DIST_DATA(
              target_name_in  IN VARCHAR2,
              target_type_in  IN VARCHAR2,
              begin_time_in   IN DATE,
              end_time_in     IN DATE) RETURN VARCHAR2;



--
-- Function to delete daily distribution data long ip,domain and url axes
-- Delete data in tables mgmt_rt_url_dist_1day,mgmt_rt_ip_dist_1day and
-- mgmt_rt_domain_dist_1day
--

FUNCTION DELETE_DAILY_DIST_DATA(
              target_name_in  IN VARCHAR2,
              target_type_in  IN VARCHAR2,
              begin_time_in   IN DATE,
              end_time_in     IN DATE) RETURN VARCHAR2;



--
-- Globals for batch purge
--
g_CommitInterval  NUMBER := 100;   -- This is the default commit interval.
g_PurgeBatch      NUMBER := 100;   -- This is the number of rows that will be
                                    -- purged in a single database call.

-- Procedure PURGE_RUN_METRIC_DATES
-- This procedure is the call back procedure for purging 
-- run metric dates in MGMT_STRING_METRIC_HISTORY

PROCEDURE PURGE_RUN_METRIC_DATES
	      (pcb_params IN OUT MGMT_PURGE_CALLBACK_PARAMS);


END EMD_CHRONOS_ADMIN;
/
show errors;


