Rem
Rem $Header: chronos_mntr_pkgdef.sql 17-jul-2006.19:45:43 yxie Exp $
Rem
Rem chronos_mntr_pkgdef.sql
Rem
Rem Copyright (c) 2002, 2006, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      chronos_mntr_pkgdef.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    yxie        07/17/06 - XbranchMerge yxie_eum_views from main
Rem    yxie        05/16/05 - change dist_type to dist_type_in
Rem    ratadiko    02/03/05 - Adding procedure for EUM Graphs. 
Rem    eporter     12/02/04 - Bug 3849061 - Change region implementation 
Rem    adosani     09/30/04 - Additions for WebApp Oracle Forms Target Type
Rem    eporter     09/17/04 - Add getNumUnprocessedHits function 
Rem    snakai      09/26/03 - fix region queries 
Rem    rmarripa    06/14/02 - remove rep url sqls/procedures
Rem    rpinnama    05/15/02 - rpinnama_reorg_rep_scripts
Rem    rpinnama    05/15/02 - Restructured.
Rem    lgloyd      02/15/02 - fix join with base mgmt_metrics tables, need target_guid
Rem    lgloyd      02/12/02 - retrive composite target name from byObjStatType query
Rem    rmarripa    01/24/02 - Retrieve CHRONOS_ENABLE_FLAG from MGMT_RT_TARGET_PROPERTIES.
Rem    lgloyd      02/05/02 - add weighted performance to URL Metrics
Rem    smishra     02/01/02 - fixed bad column name introduced during metric cutover.
Rem    rmarripa    01/16/02 - Retrieve thresholds from mgmt_metric_thresholds.
Rem    rmarripa    01/08/02 - Round the stddev values.
Rem    rmarripa    01/07/02 - Fix the standard deviation value.
Rem    edemembe    01/08/02 - Metrics are now target independent
Rem    rmarripa    12/17/01 - Remove the current average from the MGMT_MNTR_USER_STATS_OBJ
Rem    edemembe    12/26/01 - Removing TARGET_NAME,TARGET_TYPE,etc
Rem    rmarripa    12/15/01 - Add check for future data in all queries.
Rem    njuillar    12/13/01 - Merged njuillar_split_mntr_package
Rem    njuillar    12/12/01 - Created
Rem

rem -------------------------------------------------------
rem
rem User Monitoring (Chronos) Package
rem
rem -------------------------------------------------------

CREATE OR REPLACE PACKAGE emd_mntr_user AS

-- Package level Type Definition
--
TYPE cursorType IS REF CURSOR;

TYPE p_target_guid_list_type IS
  TABLE OF RAW(16)
  INDEX BY BINARY_INTEGER;

-- eum view is for Forms application
EUM_VIEW_TYPE_PROP CONSTANT VARCHAR2(32) := 'eumViewType';

PROCEDURE getWatchListStats(target_name_in IN VARCHAR2,
                            target_type_in IN VARCHAR2,
                            page_type_in IN VARCHAR2,
                            metric_name_in IN VARCHAR2,
                            show_chronos_out OUT INTEGER,
                            objarray_out OUT MGMT_MNTR_USER_STATS_ARRAY);


FUNCTION getUrlStatsObj(
            page_type_in IN VARCHAR2,
            metric_name_in IN VARCHAR2,
            target_guid_in IN RAW,
            url_filename_in IN VARCHAR2,
            display_name_in IN VARCHAR2,
            obj_out OUT MGMT_MNTR_USER_STATS_OBJ) return INTEGER;

PROCEDURE getMetricsResponseTimeseries(target_name_in IN VARCHAR2,
                            target_type_in IN VARCHAR2,
                            page_type_in IN VARCHAR2,
                            metric_warning_threshold_out OUT VARCHAR2,
                            metric_critical_threshold_out OUT VARCHAR2,
                            results_out OUT cursorType);

PROCEDURE getRowsByObjAndStat(target_name_in IN VARCHAR2,
                            target_type_in IN VARCHAR2,
                            page_type_in IN VARCHAR2,
                            metric_name_in IN VARCHAR2,
                            obj_type_in IN VARCHAR2,
                            stat_type_in IN VARCHAR2,
                            filter_name_in IN VARCHAR2,
                            filter_min_hits_in IN INTEGER,
                            filter_min_hits_out OUT INTEGER,
                            results_out OUT cursorType);

PROCEDURE getRowsByObjAndStat(target_names_in IN SMP_EMD_STRING_ARRAY,
                            target_type_in IN VARCHAR2,
                            page_type_in IN VARCHAR2,
                            metric_name_in IN VARCHAR2,
                            obj_type_in IN VARCHAR2,
                            stat_type_in IN VARCHAR2,
                            filter_name_in IN VARCHAR2,
                            filter_min_hits_in IN INTEGER,
                            filter_min_hits_out OUT INTEGER,
                            results_out OUT cursorType);

PROCEDURE getResponseTimeseries(target_name_in IN VARCHAR2,
                            target_type_in IN VARCHAR2,
                            page_type_in IN VARCHAR2,
                            metric_name_in IN VARCHAR2,
                            obj_type_in IN VARCHAR2,
                            query_name_in IN VARCHAR2,
                            results_out OUT cursorType);

PROCEDURE getResponseTimeseriesForQuries(target_name_in IN VARCHAR2,
                            target_type_in IN VARCHAR2,
                            page_type_in IN VARCHAR2,
                            metric_name_in IN VARCHAR2,
                            obj_type_in IN VARCHAR2,
                            query_name_in IN VARCHAR2,
                            results_out OUT cursorType);

PROCEDURE getResponseDist(target_name_in IN VARCHAR2,
                            target_type_in IN VARCHAR2,
                            page_type_in IN VARCHAR2,
                            metric_name_in IN VARCHAR2,
                            obj_type_in IN VARCHAR2,
                            query_name_in IN VARCHAR2,
														dist_type_in IN NUMBER,
                            results_out OUT cursorType);

PROCEDURE getStatsObj(target_name_in IN VARCHAR2,
                            target_type_in IN VARCHAR2,
                            page_type_in IN VARCHAR2,
                            metric_name_in IN VARCHAR2,
                            obj_type_in IN VARCHAR2,
                            query_name_in IN VARCHAR2,
                            obj_out OUT MGMT_MNTR_USER_STATS_OBJ);

PROCEDURE getHitDetails(target_name_in IN VARCHAR2,
                            target_type_in IN VARCHAR2,
                            page_type_in IN VARCHAR2,
                            metric_name_in IN VARCHAR2,
                            obj_type_in IN VARCHAR2,
                            sort_order_in IN VARCHAR2,
                            query_name_in IN VARCHAR2,
                            results_out OUT cursorType);

PROCEDURE getOverallWebfarmPerf(target_name_in IN VARCHAR2,
                            target_type_in IN VARCHAR2,
                            page_type_in IN VARCHAR2,
                            metric_name_in IN VARCHAR2,
                            results_out OUT cursorType);


/*
 * Function to check if chronos data is available for a given target
 * Returns 'true' if data is available, otherwise 'false'
 */
function chronosDataExists(
                            targetName IN VARCHAR2,
                            targetType IN VARCHAR2,
                            pageType VARCHAR2,
                            metricName VARCHAR2) return VARCHAR2;

PROCEDURE getNumUnprocessedHits(target_name_in IN VARCHAR2,
                                target_type_in IN VARCHAR2,
                                unprocessed_hits OUT INTEGER);

FUNCTION ipStr2Num( ip IN VARCHAR2) RETURN NUMBER;

FUNCTION ipSubnet2Num( ip IN VARCHAR2) RETURN NUMBER;

FUNCTION addRegionEntry(region_guid_in IN RAW, 
                        domain_in      IN VARCHAR2, 
                        min_ip_in      IN NUMBER,
                        max_ip_in      IN NUMBER) return INTEGER;

PROCEDURE getWebAppType(target_name_in IN VARCHAR2,
                        target_type_in IN VARCHAR2,
                        webapp_type_out OUT VARCHAR2);

PROCEDURE isFormsEUM (target_name_in IN VARCHAR2,
                      target_type_in IN VARCHAR2,
                      is_forms_eum_out OUT INTEGER);

END emd_mntr_user;
/

show errors;


