Rem drv: <create type="post_creation" params="EM_REPOS_MODE" pos="collections/collections_post_creation.sql-"/>
Rem
Rem $Header: chronos_post_creation.sql 26-apr-2007.23:52:54 tlay Exp $
Rem
Rem chronos_post_creation.sql
Rem
Rem Copyright (c) 2002, 2007, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      chronos_post_creation.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    tlay        04/26/07 - Backport tlay_bug-5580441 from main
Rem    tlay        04/03/07 - 
Rem    scgrover    07/07/05 - add extended sql trace 
Rem    gsbhatia    07/03/05 - New repmgr header impl 
Rem    adosani     03/14/05 - add chronos purge policy
Rem    eporter     03/04/05 - Bug 3319664 - Delete Chronos references 
Rem    eporter     02/28/05 - register new logging modules 
Rem    ktlaw       01/11/05 - add repmgr header 
Rem    eporter     09/13/04 - Add bootstrap job 
Rem    rmarripa    09/19/03 - add search size limit parameter 
Rem    rpinnama    03/17/03 - Move dbms_job submission to chronos_dbms_jobs file
Rem    rpinnama    10/15/02 - Fix register_logging_module API
Rem    rpinnama    10/14/02 - Use log registration API
Rem    aholser     06/15/02 - add display and dbms job info
Rem    rpinnama    06/05/02 - Initialize perfomance log.
Rem    rpinnama    05/16/02 - submit dbms_jobs.
Rem    rpinnama    05/14/02 - Created
Rem

DEFINE EM_REPOS_MODE            = "&1"

INSERT INTO MGMT_PARAMETERS
    (parameter_name, parameter_value, parameter_comment)
  VALUES
    ('mgmt_rt_min_hits', '10',
    'The minimum number of hits an URL must have to be included in any display');

INSERT INTO MGMT_PARAMETERS
    (parameter_name, parameter_value, parameter_comment)
  VALUES
    ('mgmt_rt_max_elapsed_time', '60000',
    'The maximum number of milliseconds an url response can have for elapsed_time to be included in any display');

INSERT INTO MGMT_PARAMETERS
    (parameter_name, parameter_value, parameter_comment)
  VALUES
    ('mgmt_rt_event_window_sz', '60',
    'Max age in minutes for data to be disconsidered by the event calculation procedure');

INSERT INTO MGMT_PARAMETERS
    (parameter_name, parameter_value, parameter_comment)
  VALUES
    ('mgmt_rt_analyze_max_rows', '1000',
    'Maximum number of rows to return in End User Monitoring Analyze reports');

COMMIT;

-- Initialize error logging..
BEGIN
  mgmt_log.register_logging_module ('RTROLLUP','End User Performance Rollup','EMD_RT_ROLLUP.ROLLUP()');
  mgmt_log.register_logging_module ('RTBOOTSTRAPROLLUP','End User Bootstrap Rollup');
  mgmt_log.register_logging_module ('RTROLLUP RAW PURGE');
  mgmt_log.register_logging_module ('RTROLLUP URL 1HOUR');
  mgmt_log.register_logging_module ('RTROLLUP URL 1HOUR PURGE');
  mgmt_log.register_logging_module ('RTROLLUP URL DIST 1HOUR');
  mgmt_log.register_logging_module ('RTROLLUP URL DIST 1HOUR PURGE');
  mgmt_log.register_logging_module ('RTROLLUP URL 1DAY');
  mgmt_log.register_logging_module ('RTROLLUP URL 1DAY PURGE');
  mgmt_log.register_logging_module ('RTROLLUP URL DIST 1DAY');
  mgmt_log.register_logging_module ('RTROLLUP URL DIST 1DAY PURGE');
  mgmt_log.register_logging_module ('RTROLLUP DOMAIN 1HOUR');
  mgmt_log.register_logging_module ('RTROLLUP DOMAIN 1HOUR PURGE');
  mgmt_log.register_logging_module ('RTROLLUP DOMAIN DIST 1HOUR');
  mgmt_log.register_logging_module ('RTROLLUP DOMAIN DIST 1HOUR PURGE');
  mgmt_log.register_logging_module ('RTROLLUP DOMAIN 1DAY');
  mgmt_log.register_logging_module ('RTROLLUP DOMAIN 1DAY PURGE');
  mgmt_log.register_logging_module ('RTROLLUP DOMAIN DIST 1DAY');
  mgmt_log.register_logging_module ('RTROLLUP DOMAIN DIST 1DAY PURGE');
  mgmt_log.register_logging_module ('RTROLLUP IP 1HOUR');
  mgmt_log.register_logging_module ('RTROLLUP IP 1HOUR PURGE');
  mgmt_log.register_logging_module ('RTROLLUP IP DIST 1HOUR');
  mgmt_log.register_logging_module ('RTROLLUP IP DIST 1HOUR PURGE');
  mgmt_log.register_logging_module ('RTROLLUP IP 1DAY');
  mgmt_log.register_logging_module ('RTROLLUP IP 1DAY PURGE');
  mgmt_log.register_logging_module ('RTROLLUP IP DIST 1DAY');
  mgmt_log.register_logging_module ('RTROLLUP IP DIST 1DAY PURGE');
  mgmt_log.register_logging_module ('RTROLLUP PR MAPPING 1HOUR');
  mgmt_log.register_logging_module ('RTROLLUP PR MAPPING 1HOUR PURGE');
  mgmt_log.register_logging_module ('RTROLLUP PR MAPPING 1DAY');
  mgmt_log.register_logging_module ('RTROLLUP PR MAPPING 1DAY PURGE');
  mgmt_log.register_logging_module ('RTROLLUP INCOMPLETE LOADS 1HOUR');
  mgmt_log.register_logging_module ('RTROLLUP INCOMPLETE LOADS 1HOUR PURGE');
  mgmt_log.register_logging_module ('RTROLLUP INCOMPLETE LOADS 1DAY');
  mgmt_log.register_logging_module ('RTROLLUP INCOMPLETE LOADS 1DAY PURGE');
  mgmt_log.register_logging_module ('RTBOOTSTRAPROLLUP URL');
  mgmt_log.register_logging_module ('RTBOOTSTRAPROLLUP URL DIST');
  mgmt_log.register_logging_module ('RTBOOTSTRAPROLLUP DOMAIN');
  mgmt_log.register_logging_module ('RTBOOTSTRAPROLLUP DOMAIN DIST');
  mgmt_log.register_logging_module ('RTBOOTSTRAPROLLUP IP');
  mgmt_log.register_logging_module ('RTBOOTSTRAPROLLUP IP DIST');
  COMMIT;
END;
/

-- Initialize performance log..
INSERT INTO MGMT_SYSTEM_PERFORMANCE_LOG
  (job_name) VALUES ('RTROLLUP');
COMMIT;

-- Chronos Purge policies
BEGIN
  IF '&EM_REPOS_MODE' = EMD_MAINTENANCE.G_COMPONENT_MODE_CENTRAL
    THEN
      -- Create Run Metric Dates in String metric history Purge Policy group
      EM_PURGE.add_purge_policy_group(EMD_CHRONOS_ADMIN.G_RETENTION_GROUP_RUNMETRIC,
	 			  'Chronos Run Metric Dates', 31*24);
      -- Register Run Metric Dates purge policy
      EM_PURGE.add_purge_policy('CHRONOS_RUN_METRIC',
	  		      EM_PURGE.G_POLICY_TYPE_SYSTEM,
			      'EMD_CHRONOS_ADMIN.PURGE_RUN_METRIC_DATES',
			      0,
			      NULL,
			      'Purge policy for Chronos Run Metric Dates in String metric history.',
			      EMD_CHRONOS_ADMIN.G_RETENTION_GROUP_RUNMETRIC
			      );
      COMMIT;
  END IF;
END;
/

@@&&EM_SQL_ROOT/core/v102020/chronos_data_upgrade.sql
