Rem
Rem $Header: chronos_prmapping_pkgdef.sql 17-feb-2006.14:42:22 jureyes Exp $
Rem
Rem chronos_prmapping_pkgdef.sql
Rem
Rem Copyright (c) 2004, 2006, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      chronos_prmapping_pkgdef.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    jureyes     02/17/06 - Backport jureyes_bug-5005456 from main 
Rem    jureyes     01/30/06 - Backport jureyes_bug-4962183 from main 
Rem    yxie        12/12/05 - Backport yxie_bug-4725344 from main 
Rem    jureyes     02/08/06 - Fix bug 5005456 (disable selection in the table 
Rem                           for 10.1.3 OC4Js). 
Rem    jureyes     01/25/06 - Change name of function GET_EUMJ2EE_DATA (bug 
Rem                           4962183). 
Rem    jureyes     11/29/05 - Fix timing in Sql Queries (not use sysdate). 
Rem    jureyes     05/06/05 - Add procedure that fetches multiple sql requests 
Rem                           at a time to reduce trips to database. 
Rem    yxie        03/23/05 - reconstruct e2e/eum request url matching query
Rem    eporter     02/24/05 - change tabs to spaces
Rem    jureyes     02/03/05 - fix EUMJ2EE query 
Rem    yxie        10/11/04 - 
Rem    yxie        09/27/04 - yxie_request_performances
Rem    yxie        09/09/04 - Created
Rem

rem -------------------------------------------------------
rem
rem User Monitoring (Chronos) Package for Component Requests
rem
rem -------------------------------------------------------

CREATE OR REPLACE Package EMD_CHRONOS_PRMAPPING AS

TYPE p_cursor_type IS REF CURSOR;

-- procedure to retrieve web cache timing data for components
-- request of a page url on a page basis
-- 
-- CHRONOS_GET_PAGE_REQUESTS_DATA
--
PROCEDURE CHRONOS_GET_PAGE_REQUESTS_DATA(
                      webapp_name_in      IN VARCHAR2,
                      webapp_type_in      IN VARCHAR2,
                      page_url_in         IN VARCHAR2,
                      delta_days_in       IN NUMBER,
                      results_out         OUT p_cursor_type);

-- procedure to retrieve oc4j timing data for components
-- request of a page url on a request basic
-- 
-- CHRONOS_GET_REQUESTS_DATA
--
PROCEDURE CHRONOS_GET_REQUESTS_DATA(
                      webapp_name_in      IN VARCHAR2,
                      webapp_type_in      IN VARCHAR2,
                      request_urls_in     IN SMP_EMD_STRING_ARRAY,
                      delta_days_in       IN NUMBER,
                      results_out         OUT p_cursor_type);


-- procedure to retrieve webcache and oc4j timing data 
-- for all component requests performance
--
-- CHRONOS_GET_EUMJ2EE_DATA
--
PROCEDURE CHRONOS_GET_REQUEST_PERF_DATA(p_webcache_guids_in IN SMP_EMD_STRING_ARRAY,
				   p_oc4j_guids_in IN SMP_EMD_STRING_ARRAY,
                                   p_target_name IN VARCHAR2, 
                                   p_target_type IN VARCHAR2,
                                   p_tier IN VARCHAR2,
                                   p_time_ctx IN VARCHAR2,                                     
			           p_min_hits IN NUMBER,
                                   p_max_rows IN NUMBER,
                                   p_results_out OUT p_cursor_type); 




-- Old Implementation of CHRONOS_GET_EUMJ2EE_DATA
-- This implementation will be obsolete and must be removed
-- CHRONOS_GET_EUMJ2EE_DATA
PROCEDURE CHRONOS_GET_EUMJ2EE_DATA(p_webcache_guids_in IN SMP_EMD_STRING_ARRAY,
				   p_oc4j_guids_in IN SMP_EMD_STRING_ARRAY,
                                   p_tier IN VARCHAR2,
                                   p_time_ctx IN VARCHAR2,                                     
                                   p_min_hits IN NUMBER,
                                   p_max_rows IN NUMBER,
                                   p_results_out OUT p_cursor_type); 






-- procedure to retrieve the text for sql requests
--
-- E2E_GET_SQL_TEXT_DATA
--
PROCEDURE E2E_GET_SQL_TEXT_DATA(sql_guids_in IN SMP_EMD_STRING_ARRAY,
                                    p_results_out OUT p_cursor_type);

-- procedure to retrieve the component versions
--
-- E2E_GET_COMPONENT_VERSIONS
--
PROCEDURE E2E_GET_COMPONENT_VERSIONS(comp_names_in IN SMP_EMD_STRING_ARRAY,
                                         p_type_in IN VARCHAR2, 
                                         p_property_in IN VARCHAR2,
                                         p_results_out OUT p_cursor_type);

END EMD_CHRONOS_PRMAPPING;
/
SHOW ERRORS;
