Rem drv: <create type="triggers" pos="beacon/beacon_triggers.sql+"/>
Rem
Rem $Header: chronos_triggers.sql 01-jul-2005.22:01:54 gsbhatia Exp $
Rem
Rem chronos_triggers.sql
Rem
Rem Copyright (c) 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      chronos_triggers.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    gsbhatia    07/01/05 - New repmgr header impl 
Rem    gsbhatia    06/26/05 - New repmgr header impl 
Rem    eporter     02/15/05 - change region trigger to CREATE OR REPLACE 
Rem    gsbhatia    02/13/05 - updating repmgr header 
Rem    gsbhatia    02/09/05 - updating repmgr header 
Rem    gsbhatia    02/07/05 - updating repmgr header 
Rem    eporter     01/26/05 - eporter_custom_time2
Rem    eporter     01/24/05 - Created
Rem

SET ECHO ON
SET FEEDBACK 1
SET NUMWIDTH 10
SET LINESIZE 80
SET TRIMSPOOL ON
SET TAB OFF
SET PAGESIZE 100

Rem Fill in the visitor_ip_num column if it was not specified.
 
CREATE OR REPLACE TRIGGER MGMT_RT_METRICS_RAW_TR
    BEFORE INSERT ON MGMT_RT_METRICS_RAW FOR EACH ROW
BEGIN
    IF (:NEW.visitor_ip_num IS NULL) THEN
        :NEW.visitor_ip_num := EMD_MNTR_USER.ipStr2Num(:NEW.visitor_ip);
    END IF;
END;
/
show errors;


Rem Create a trigger so that raw entries will be deleted when they are no
Rem longer being used.  Having lots of entries will lower performance.

CREATE OR REPLACE TRIGGER MGMT_RT_REGION_MAPPING_TR 
    AFTER DELETE ON MGMT_RT_REGION_MAPPING FOR EACH ROW
BEGIN
    UPDATE MGMT_RT_REGION_ENTRIES 
      SET ref_count = (ref_count - 1)
      WHERE id = :old.id;
    DELETE FROM MGMT_RT_REGION_ENTRIES
      WHERE ref_count <= 0;
END;
/
show errors;
