Rem drv: <create type="types" pos="audit/audit_types.sql+"/>
Rem
Rem $Header: chronos_types.sql 29-jun-2005.01:47:07 gsbhatia Exp $
Rem
Rem chronos_types.sql
Rem
Rem Copyright (c) 2002, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      chronos_types.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    gsbhatia    06/26/05 - New repmgr header impl 
Rem    eporter     02/15/05 - allow to be called twice 
Rem    gsbhatia    02/13/05 - updating repmgr header 
Rem    gsbhatia    02/09/05 - updating repmgr header 
Rem    gsbhatia    02/07/05 - updating repmgr header 
Rem    ktlaw       01/11/05 - add repmgr header 
Rem    adosani     10/01/04 - Additions for WebApp Oracle Forms Target Type
Rem    yxie        09/30/04 - add incomplete loads information to MGMT_MNTR_USER_STATS_OBJ
Rem    snakhoda    08/15/03 - Fix compile warning: bug 3092678 
Rem    snakhoda    08/08/03 - add err and time params
Rem    mashukla    08/07/03 - add analyze types
Rem    jriel       05/13/03 - add server timing to end user data
Rem    rpinnama    09/18/02 - Add mntr user stats types
Rem    rpinnama    05/14/02 - rpinnama_reorg_rep_scripts
Rem    rpinnama    05/14/02 - Created
Rem

CREATE OR REPLACE TYPE MgmtChrnsRegionMembers AS TABLE OF VARCHAR2(256);
/


CREATE OR REPLACE TYPE MgmtChrnsEventURLInfo AS OBJECT
(
  url_filename VARCHAR(512),
  url_sum NUMBER,
  url_count NUMBER
);
/

CREATE OR REPLACE TYPE MgmtChrnsEventURLInfoTable AS TABLE OF 
  MgmtChrnsEventURLInfo;
/

CREATE OR REPLACE TYPE MgmtChrnsTgtGuid AS OBJECT
(
  target_guid RAW(16)
);
/

CREATE OR REPLACE TYPE MgmtChrnsTgtGuids AS TABLE OF MgmtChrnsTgtGuid;
/

create or replace type MGMT_CHRONOS_ANALYZE_OBJ as OBJECT (
    value VARCHAR2(256),
    value_type NUMBER
);
/

create or replace type MGMT_CHRONOS_ANALYZE_ARRAY as TABLE of MGMT_CHRONOS_ANALYZE_OBJ;
/

CREATE OR REPLACE TYPE MgmtChrnsAnlzFxdAxesMembers AS TABLE OF VARCHAR2(256);
/

-- Creating MGMT_MNTR_USER_STATS_OBJ will throw an ORA-02303 error if it is
-- replaced while REPLACE TYPE MGMT_MNTR_USER_STATS_ARRAY exists.
-- Delete the dependent type so that MGMT_MNTR_USER_STATS_OBJ can be replaced.
DECLARE
  l_dummy                     VARCHAR2(1);
BEGIN
  SELECT NULL
  INTO   l_dummy
  FROM   sys.user_types
  WHERE  type_name = 'MGMT_MNTR_USER_STATS_ARRAY';
  EXECUTE IMMEDIATE 'DROP TYPE MGMT_MNTR_USER_STATS_ARRAY';
EXCEPTION
  WHEN NO_DATA_FOUND THEN
    NULL; -- Do nothing if type MGMT_MNTR_USER_STATS_ARRAY does not exist
END;
/

CREATE OR REPLACE TYPE MGMT_MNTR_USER_STATS_OBJ as OBJECT (
    queryName VARCHAR2(1024),
    displayName VARCHAR2(128),
    avgVal VARCHAR2(20),
    servAvgVal VARCHAR2(20),
    dbAvgVal VARCHAR2(20),
    hitsVal VARCHAR2(20),
    minVal VARCHAR2(20),
    maxVal VARCHAR2(20),
    stddevVal VARCHAR2(20),
    varianceVal VARCHAR2(20),
    critThreshold VARCHAR2(20),
    warnThreshold VARCHAR2(20),
    urlLink VARCHAR2(1280),
    mostFavorite VARCHAR(5),
    incompleteHitsVal VARCHAR2(20),
    incompleteAvgVal VARCHAR2(20) 
);
/

CREATE OR REPLACE TYPE MGMT_MNTR_USER_STATS_ARRAY
  as TABLE of MGMT_MNTR_USER_STATS_OBJ;
/

