Rem
Rem $Header: client_config_pkgdef.sql 19-jun-2002.12:02:47 lgloyd Exp $
Rem
Rem client_config_pkgsdef.sql
Rem
Rem Copyright (c) 2002, Oracle Corporation.  All rights reserved.  
Rem
Rem    NAME
Rem      client_config_pkgsdef.sql - client configuration queries
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem       lgloyd   06/19/02 - lgloyd_cliinv_0604
Rem

rem -------------------------------------------------------
rem
rem Client Configuration Package
rem
rem -------------------------------------------------------

CREATE OR REPLACE PACKAGE em_client_config AS

-- Package level Type Definition
--
TYPE cursorType IS REF CURSOR;

PROCEDURE getApplications(results_out OUT cursorType);

PROCEDURE getGroupByStats(apps_id_in IN VARCHAR2,
                            group_by_in IN VARCHAR2,
                            results_out OUT cursorType);

PROCEDURE getIpStats(apps_id_in IN VARCHAR2,
                            group_in IN VARCHAR2,
                            group_type_in IN VARCHAR2,
                            search_client_node_in IN VARCHAR2,
                            search_os_userid_in IN VARCHAR2,                           
                            search_ipaddress_in IN VARCHAR2,                           
                            results_out OUT cursorType);

PROCEDURE getHostProperties(apps_id_in IN VARCHAR2,
                            client_node_in IN VARCHAR2,
                            os_userid_in IN VARCHAR2,
                            group_in IN VARCHAR2,
                            group_type_in IN VARCHAR2,
                            results_out OUT cursorType);

PROCEDURE getCPUDistribution(apps_id_in IN VARCHAR2,
                            group_in IN VARCHAR2,
                            group_type_in IN VARCHAR2,
                            search_client_node_in IN VARCHAR2,
                            search_os_userid_in IN VARCHAR2,                           
                            search_ipaddress_in IN VARCHAR2,                           
                            results_out OUT cursorType);

PROCEDURE getMemoryDistribution(apps_id_in IN VARCHAR2,
                            group_in IN VARCHAR2,
                            group_type_in IN VARCHAR2,
                            search_client_node_in IN VARCHAR2,
                            search_os_userid_in IN VARCHAR2,                           
                            search_ipaddress_in IN VARCHAR2,                           
                            results_out OUT cursorType);

PROCEDURE getTotalDiskDistribution(apps_id_in IN VARCHAR2,
                            group_in IN VARCHAR2,
                            group_type_in IN VARCHAR2,
                            search_client_node_in IN VARCHAR2,
                            search_os_userid_in IN VARCHAR2,                           
                            search_ipaddress_in IN VARCHAR2,                           
                            results_out OUT cursorType);

PROCEDURE getFreeDiskDistribution(apps_id_in IN VARCHAR2,
                            group_in IN VARCHAR2,
                            group_type_in IN VARCHAR2,
                            search_client_node_in IN VARCHAR2,
                            search_os_userid_in IN VARCHAR2,                           
                            search_ipaddress_in IN VARCHAR2,                           
                            results_out OUT cursorType);

PROCEDURE getPctFreeDiskDistribution(apps_id_in IN VARCHAR2,
                            group_in IN VARCHAR2,
                            group_type_in IN VARCHAR2,
                            search_client_node_in IN VARCHAR2,
                            search_os_userid_in IN VARCHAR2,                           
                            search_ipaddress_in IN VARCHAR2,                           
                            results_out OUT cursorType);


PROCEDURE getPctUsedDiskDistribution(apps_id_in IN VARCHAR2,
                            group_in IN VARCHAR2,
                            group_type_in IN VARCHAR2,
                            search_client_node_in IN VARCHAR2,
                            search_os_userid_in IN VARCHAR2,                           
                            search_ipaddress_in IN VARCHAR2,                           
                            results_out OUT cursorType);


PROCEDURE getNetLatencyDistribution(apps_id_in IN VARCHAR2,
                            group_in IN VARCHAR2,
                            group_type_in IN VARCHAR2,
                            search_client_node_in IN VARCHAR2,
                            search_os_userid_in IN VARCHAR2,                           
                            search_ipaddress_in IN VARCHAR2,                           
                            results_out OUT cursorType);

PROCEDURE getNetThroughputDistribution(apps_id_in IN VARCHAR2,
                            group_in IN VARCHAR2,
                            group_type_in IN VARCHAR2,
                            search_client_node_in IN VARCHAR2,
                            search_os_userid_in IN VARCHAR2,                           
                            search_ipaddress_in IN VARCHAR2,                           
                            results_out OUT cursorType);

PROCEDURE getUseBy(apps_id_in IN VARCHAR2,
                            group_in IN VARCHAR2,
                            group_type_in IN VARCHAR2,
                            search_client_node_in IN VARCHAR2,
                            search_os_userid_in IN VARCHAR2,                           
                            search_ipaddress_in IN VARCHAR2,                           
                            use_type_in IN VARCHAR2,
                            results_out OUT cursorType);

END em_client_config;
/

