Rem
Rem $Header: client_tables.sql 08-feb-2005.12:26:39 gsbhatia Exp $
Rem
Rem client_tables.sql
Rem
Rem Copyright (c) 2002, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      client_tables.sql - client config tables
Rem
Rem    DESCRIPTION
Rem      Client configuration data
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem       gsbhatia 02/08/05 - Removing header 
Rem       ktlaw    01/11/05 - add repmgr header 
Rem       rpinnama 09/25/02 - Remove hard coded references to MGMT_REP
Rem       lgloyd   06/19/02 - lgloyd_cliinv_0604
Rem

-- Drop old versions before (re)creating ...

-- Create table for client config results, plus index and sequence ...

create table MGMT_CLIENT_CONFIG_SUMMARY
(
    CC_COLL_TIMESTAMP           DATE        default SYSDATE,
    EM_COLL_TIMESTAMP           DATE        default NULL,
-- Recommended config info ...
    RC_APP_NAME                 VARCHAR2(256),
    RC_APP_VERS                 VARCHAR2(100),
    RC_TYPE                     NUMBER          DEFAULT 0,
    RC_ALERTS                   NUMBER          DEFAULT 0,
    RC_WARNING                  NUMBER          DEFAULT 0,
-- Identify customer, client node, etc ...
    REC_TYPE                    VARCHAR2(1),
    CHECK_ID                    NUMBER  constraint pk_chkid PRIMARY KEY,
    CUSTOMER_ID                 VARCHAR2(80),
    APP_ID                      VARCHAR2(80),
    APP_TYPE                    VARCHAR2(80),
    OR_PROTOCOL                 VARCHAR2(20),
    OR_HOST                     VARCHAR2(80),
    OR_PORT                     NUMBER,
    OR_URI                      VARCHAR2(80),
    OR_PARAMS                   VARCHAR2(256),
    APPLET_ID                   VARCHAR2(20),
    COLL_MSEC                   VARCHAR2(20),
    OS_USERID                   VARCHAR2(80),
    CLIENT_NODE                 VARCHAR2(80),
    CLIENT_DOMAIN               VARCHAR2(80),
-- Hardware items ...
    HW_AVAIL_DISKSPACE          NUMBER,
    HW_AVAIL_MEMORY             NUMBER,
    HW_AVAIL_VIRTUAL            NUMBER,
    HW_BIOS_VERSION             VARCHAR2(100),
    HW_CLOCKSPEED_MHZ           NUMBER,
    HW_CPU_COUNT                NUMBER,
    HW_MODEL                    VARCHAR2(80),
    HW_TOTAL_DISKSPACE          NUMBER,
    HW_TOTAL_MEMORY             NUMBER,
    HW_TOTAL_PAGEFILE           NUMBER,
    HW_TOTAL_VIRTUAL            NUMBER,
    HW_VENDOR                   VARCHAR2(80),
-- Network ...
    NET_COPY_TIME               NUMBER,
    NET_DEFAULT_GATEWAY         VARCHAR2(20),
    NET_ENABLE_DHCP             NUMBER,
    NET_HOPCOUNT                NUMBER,
    NET_IPADDRESS               VARCHAR2(20),
    NET_IPADDRESS_EFFECTIVE     VARCHAR2(20),
    NET_LATENCY                 NUMBER,
    NET_MEASUREDRATE            NUMBER,
    NET_NICDESCRIPTION          VARCHAR(100),
    NET_PORTS_GOOD              VARCHAR2(80),
    NET_PROXIES_GOOD            NUMBER,
    NET_READ_TIME               NUMBER,
    NET_SUBNET_MASK             VARCHAR2(20),
    NET_SUBNET                  VARCHAR2(20),
    NET_TRACE_LATENCY           NUMBER,
-- Browser items ...
    SW_BROWSER_AVAIL_CACHEDISK  NUMBER,
    SW_BROWSER_CACHE_UPDATE     VARCHAR2(80),
    SW_BROWSER_HTTP1_1          NUMBER,
    SW_BROWSER_JAVA_VENDOR      VARCHAR2(80),
    SW_BROWSER_JAVA_VERS        VARCHAR2(80),
    SW_BROWSER_PROXY_ENABLE     NUMBER(1),
    SW_BROWSER_PROXY_OVERRIDE   VARCHAR2(1000),
    SW_BROWSER_PROXY_SERVER     VARCHAR2(1000),
    SW_BROWSER_TYPE             VARCHAR2(80),
    SW_BROWSER_VERSION          VARCHAR2(80),
-- Jinitiator items ...
    SW_JINI_AVAIL_CACHEDISK     NUMBER,
    SW_JINI_INSTALLED           NUMBER,
    SW_JINI_PARAMETERS          VARCHAR2(1000),
    SW_JINI_PROXY_SETTINGS      VARCHAR2(256),
    SW_JINI_USEBROWSERSETTINGS  NUMBER,
    SW_JINI_VERSION             VARCHAR2(80),
-- OBI (ie Oracle Base) ...
    SW_OBI_INSTALLED            NUMBER,
    SW_OBI_VERSION              VARCHAR2(80),
-- Operating system info ...
    SW_OS_NAME                  VARCHAR2(80),
    SW_OS_SERVICEPACK           VARCHAR2(80)
);



CREATE INDEX MGMT_CLIENT_CONFIG_S_IDX_001
     ON MGMT_CLIENT_CONFIG_SUMMARY
        (REC_TYPE,
         APP_ID,
         HW_TOTAL_DISKSPACE,
         HW_AVAIL_DISKSPACE,
         NET_LATENCY,
         HW_TOTAL_MEMORY,
         NET_SUBNET,
         NET_MEASUREDRATE)
    LOGGING
    INITRANS 2
    MAXTRANS 255
    TABLESPACE MGMT_TABLESPACE
    PCTFREE 0
    STORAGE (
        INITIAL 64K
        PCTINCREASE 0
        MINEXTENTS 1
        MAXEXTENTS 2147483645);


-- Create table for user-defined config items ...

create table MGMT_CLIENT_CONFIG_UDP
(
    CHECK_ID                    NUMBER constraint fk_chkid REFERENCES
                                    MGMT_CLIENT_CONFIG_SUMMARY(CHECK_ID)
                                    on delete cascade,
-- User-defined data item type, category, etc ...
    UDP_TYPE                    VARCHAR2(20),
    UDP_CATEGORY                VARCHAR2(20),
    UDP_KEY                     VARCHAR2(80),
-- Name value pair ...
    UDP_NAME                    VARCHAR2(80),
    UDP_VALUE                   VARCHAR2(256),
-- How registry was queried to get this data ...
    UDP_REG_QUERY_TYPE          VARCHAR2(20),
    UDP_REG_ROOT                VARCHAR2(20),
    UDP_REG_KEY                 VARCHAR2(256),
    UDP_REG_ITEM_NAME           VARCHAR2(80),
    UDP_REG_SUBKEY_OP           VARCHAR2(20)
);

