Rem drv: <create type="post_creation" pos="esm/esm_core_reports.sql-"/>
Rem
Rem $Header: emcore/source/oracle/sysman/emdrep/sql/core/latest/cluster_node/cluster_node_post_creation.sql /st_emcore_10.2.0.4.2db11.2/2 2008/12/12 15:28:40 ajdsouza Exp $
Rem
Rem cluster_node_post_creation.sql
Rem
Rem Copyright (c) 2002, 2008, Oracle and/or its affiliates.
Rem All rights reserved. 
Rem
Rem    NAME
Rem      cluster_node_post_creation.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    ajdsouza   12/08/08 - bug fix 7613499
Rem    ajdsouza   12/07/07 - added metadata for mgmt_cluster_node_info
Rem    ajdsouza   12/07/07 - Created

-- Uncomment the following line to see the commands during the script execution
-- SET ECHO ON 

-- Do not use substitution variables in this script so that there is no
-- additional restrictions on the string values that are being inserted (such as ampersand 
-- being interpreted specially by SQLPlus).
SET DEFINE OFF 

--------------------------------------------
-- Registering metadata Host Cluster Node Config for target type host and snapshot type cluster_node_config
--------------------------------------------

ALTER SESSION SET CONSTRAINTS = DEFERRED;

DECLARE
  metadata_id RAW(16) := SYS_GUID();
BEGIN
  -- Remove all related metadatas
  DELETE FROM MGMT_ECM_SNAPSHOT_MD_TABLES WHERE METADATA_ID IN (SELECT METADATA_ID FROM MGMT_ECM_SNAPSHOT_METADATA WHERE TARGET_TYPE = 'host' AND SNAPSHOT_TYPE = 'cluster_node_config');
  DELETE FROM MGMT_ECM_SNAPSHOT_METADATA WHERE TARGET_TYPE = 'host' AND SNAPSHOT_TYPE = 'cluster_node_config';

  -- Register metadata as loader metadata
  INSERT INTO MGMT_ECM_SNAPSHOT_METADATA (SNAPSHOT_TYPE, TARGET_TYPE, KIND, METADATA_ID, UI_NAME, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, LINK_TABLE_NAME, AFTER_LOAD_PROC_NAME, AFTER_IMPORT_PROC_NAME, METADATA_VERSION, VIEW_URL, COMPARE_URL, HISTORY_URL, SAME_TARGET_COMPARE) 
    VALUES ('cluster_node_config', 'host', 'L', metadata_id, 'Host Cluster Node Config', 'N', 'N', 'N', 'N', 'N', NULL, NULL, NULL, '1', NULL, NULL, NULL, 'H');

  -- Register metadata as presentation metadata
  INSERT INTO MGMT_ECM_SNAPSHOT_METADATA (SNAPSHOT_TYPE, TARGET_TYPE, KIND, METADATA_ID, UI_NAME, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, LINK_TABLE_NAME, AFTER_LOAD_PROC_NAME, AFTER_IMPORT_PROC_NAME, METADATA_VERSION, VIEW_URL, COMPARE_URL, HISTORY_URL, SAME_TARGET_COMPARE) 
    VALUES ('cluster_node_config', 'host', 'P', metadata_id, 'Host Cluster Node Config', 'N', 'N', 'N', 'N', 'N', NULL, NULL, NULL, '1', NULL, NULL, NULL, 'H');

  -- Register metadata for table MGMT_ECM_CLUSTER_NODE_INFO
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_TABLES (METADATA_ID, NAME, UI_NAME, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, PARENT_TABLE_NAME, IS_SINGLE_ROW, TBL_ORDER)
    VALUES (metadata_id, 'MGMT_ECM_CLUSTER_NODE_INFO', 'Cluster Node Information', 'N', 'N', 'N', 'N', 'N', NULL, 'N', 0);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_ECM_CLUSTER_NODE_INFO', 'NODE_NAME', 'Node Name', 'S', '256', 'N', 'N', 'N', 'N', 'N', 'Y', 'N', 'N', 'N', NULL, 0);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_ECM_CLUSTER_NODE_INFO', 'CLUSTER_NAME', 'Cluster Name', 'S', '256', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', NULL, 1);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_ECM_CLUSTER_NODE_INFO', 'CLUSTER_HOME', 'Cluster Home Directory', 'S', '500', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', NULL, 2);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_ECM_CLUSTER_NODE_INFO', 'NODE_LIST', 'Cluster Node List', 'S', '4000', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', NULL, 3);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'MGMT_ECM_CLUSTER_NODE_INFO', 'NODE_STATUS', 'Node Status', 'S', '32', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', NULL, 4);
END;
/

ALTER SESSION SET CONSTRAINTS = IMMEDIATE;
COMMIT;

-- End of metadata registration for metadata Host Cluster Node Config

SET DEFINE ON 

-- This is required only during upgrade
-- Update derived materialized views
-- BEGIN ECM_UTIL.UPDATE_ECM_METADATA; END;
--/
