Rem drv: <create type="pkgdefs" pos="collections/collections_pkgdefs.sql+"/>
Rem
Rem $Header: collections_meteval_pkgdef.sql 17-jul-2006.21:07:47 jsadras Exp $
Rem
Rem collections_meteval_pkgdef.sql
Rem
Rem Copyright (c) 2004, 2006, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      collections_meteval_pkgdef.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    jsadras     07/17/06 - Backport jsadras_bug-5002887 from main 
Rem    jsadras     02/07/06 - add keys_from_mult_colls 
Rem    hbadheka    01/06/06 - add dummy eval proc 
Rem    gsbhatia    07/01/05 - New repmgr header impl 
Rem    jsadras     05/19/05 - security fix, remove evaluate_sql 
Rem    jsadras     02/13/05 - bug:4158855, change status_blackout to skip 
Rem    jsadras     12/22/04 - key length 
Rem    jsadras     12/15/04 - accept list of targets 
Rem    jsadras     11/16/04 - store_metric_Data
Rem    jsadras     10/19/04 - repo_timing
Rem    jsadras     10/07/04 - mgmt_short_string_table
Rem    jsadras     09/23/04 - metric_info
Rem    jsadras     09/21/04 - labels
Rem    jsadras     09/15/04 - key_column_types
Rem    jsadras     09/09/04 - coll_name added to signature 
Rem    jsadras     09/08/04 - metric_column
Rem    jsadras     08/29/04 - 
Rem    jsadras     08/16/04 - check_target_list
Rem    jsadras     08/11/04 - 
Rem    jsadras     07/24/04 - jsadras_repocollect1
Rem    jsadras     07/06/04 - Created
Rem

CREATE OR REPLACE PACKAGE EM_METRIC_EVAL 
AS
--
-- Procedure which is called by collections engine
-- for all metric evaluations
--
  G_TASK_EVAL_MODE CONSTANT NUMBER     := 1 ;
  G_TARGET_EVAL_MODE CONSTANT NUMBER   := 2 ;

-- Metric evaluation status codes
-- records in mgmt_metric_value_array with
-- status=success are evaluated
-- status=error are deleted
-- status=skip ( skips policy evaluation , for service only bug:4158855
--
  G_METRIC_EVAL_SUCCESS CONSTANT NUMBER := 0 ;
  G_METRIC_EVAL_ERROR   CONSTANT NUMBER := 1 ;
  G_METRIC_EVAL_SKIP    CONSTANT NUMBER := 2 ;

-- Agent code for repository collections to reporting errors
  G_REPO_AGENT_GUID CONSTANT RAW(16) := HEXTORAW('0000000000000000') ;
  G_COLLECTION_ON_DEMAND VARCHAR2(20) := 'REALTIME_ONDEMAND' ;
  G_MODULE_NAME CONSTANT VARCHAR2(100) := 'EM_METRIC_EVAL' ;

--Type to hold metric information for use by metric evaluation
--and policy evaluation. This information is to be fetched only
--once and used through out
--metric guid is the guid of the table descriptor record
--eval_metric_guid is the guid to be passed to the metric evaluation
--function. It can be different from metric_guid when the evaluation
--is for a metric column in which case we want to pass the metric guid
--of the column. metric_guid will be passed to policy evaluation since
--policies will be defined at the table descriptor metric level
--
  TYPE METRIC_INFO_REC IS RECORD
      (
       metric_guid      mgmt_metrics.metric_guid%type,
       eval_metric_guid mgmt_metrics.metric_guid%type,
       metric_name      mgmt_metrics.metric_name%type,
       metric_type      mgmt_metrics.metric_type%type,
       source_type      mgmt_metrics.source_type%type,
       source           mgmt_metrics.source%type,
       num_keys         mgmt_metrics.num_keys%type,
       key_cols         mgmt_namevalue_array,
       metric_cols      mgmt_namevalue_array,
       all_cols         mgmt_namevalue_array,
       column_labels    mgmt_namevalue_array,
       column_nlsids    mgmt_namevalue_array,
       metric_label     mgmt_metrics.metric_label%type,
       metric_label_nlsid  mgmt_metrics.metric_label_nlsid%type,
       select_clause    VARCHAR2(32767),
       repo_timing_enabled mgmt_metrics.repo_timing_enabled%type,
       keys_from_mult_colls mgmt_metrics.keys_from_mult_colls%type
      ) ;

  PROCEDURE get_metric_info(p_target_guid IN RAW,
                            p_metric_guid IN RAW,
                            p_eval_mode IN NUMBER,
                            p_metric_info OUT NOCOPY METRIC_INFO_REC,
                            p_repo_metric IN NUMBER DEFAULT MGMT_GLOBAL.G_TRUE
                            ) ;

--
-- is_valid_sql
--
--
-- PURPOSE
-- To find out if the given sql is valid
-- a SQL IS valid
-- If it is a valid SQL that can be executed directly without errors
-- It contains target_guid , all key_columns ( if any) and all metric columns
--    in the select clause
--     For example:if a metric has tablespace_name as key column
--                 and pctused and pctfree as metric column
--     A valid SQL would be 
--         SELECT config_guid target_guid, 
--                config_name tablespace_name, 
--                pctused, pctfree
--         FROM ...
--     The columns can occur in any order and the column names ( or alias)
--     should match the key and metric column names
--
  FUNCTION is_valid_sql(p_sql_text      IN  VARCHAR2,
                        p_all_columns   IN  mgmt_short_string_array,
                        p_error_message OUT VARCHAR2
                     )
  RETURN BOOLEAN ;
--
-- PROCEDURE to check if the metric values contains targets outside of
-- the target_list
-- p_target_list : List of valid target guids
-- p_metric_values : metric results
--
  PROCEDURE check_target_list(p_target_list   IN mgmt_target_guid_array,
                              p_metric_values IN mgmt_metric_value_array) ;

--
-- evaluate metric
--
-- Purpose
--
-- Evaluate metric information for the target(s) in the task
-- Called internally by the collection engine
--
-- Parameters:
--  p_task_id   : Task id of the collection task
--  p_metric_info : Information about the metric. 
--                  This is a by product of metric evaluation
--                  since this data can be used by collection engine
--                  it is sent out
-- p_metric_values : metric values ordered by target_guid
--
-- Exceptions
--  MGMT_GLOBAL.COLLECTION_ERR
--       
  PROCEDURE evaluate_metric(p_task_id       IN  NUMBER,
                            p_metric_info   OUT NOCOPY METRIC_INFO_REC,
                            p_metric_values OUT NOCOPY mgmt_metric_value_array,
                            p_coll_name     OUT VARCHAR2
                           ) ;

--
-- evaluate metric
--
-- Purpose
--
-- To evaluate the metric for a given target/metric combination
--
-- Parameters
--  p_target_guid   : target for which metric evaluation is to be done
--  p_metric_guid   : metric for which metric evaluation is to be done
--  p_metric_values : metric values for the target_guid
--
-- Exceptions:
--  MGMT_GLOBAL.COLLECTION_ERR
--
  PROCEDURE evaluate_metric(p_target_guids  IN  MGMT_TARGET_GUID_ARRAY,
                            p_metric_guid   IN  RAW,
                            p_coll_name     IN  VARCHAR2,
                            p_metric_info   OUT NOCOPY METRIC_INFO_REC,
                            p_metric_values OUT mgmt_metric_value_array) ;
--
-- Convert results from mgmt_metric_results_table format
-- to mgmt_metric_value_array format
--
  PROCEDURE convert_results(p_target_guid          IN RAW,
                            p_metric_results       IN mgmt_metric_results_table,
                            p_collection_timestamp IN DATE,
                            p_metric_info          IN METRIC_INFO_REC,
                            p_metric_values        OUT mgmt_metric_value_array
                            ) ;

  PROCEDURE store_metric_data(p_metric_values      IN OUT mgmt_metric_value_array,
                              p_metric_guid        IN RAW,
                              p_metric_name        IN VARCHAR2,
                              p_coll_name          IN VARCHAR2 DEFAULT NULL,
                              p_metric_type        IN NUMBER,
                              p_num_keys           IN NUMBER,
                              p_metric_columns     IN mgmt_namevalue_array,
                              p_result_key_array   IN mgmt_medium_string_table,
                              p_store_metric       IN NUMBER DEFAULT NULL
                              ) ;
 --
 -- PURPOSE
 -- to store metric data in the form of mgmt_metric_raw_table into metrics_raw
 --
 PROCEDURE store_metric_data(p_metric_raw_records IN mgmt_metric_raw_table,
                             p_key_values         IN mgmt_medium_string_table) ;
 
  PROCEDURE store_metric_errors(p_task_id      IN NUMBER := NULL,
                                p_target_guids IN mgmt_target_guid_array := NULL,
                                p_metric_guid  IN RAW := NULL,
                                p_coll_name    IN VARCHAR2 := ' ',
                                p_timezone_region IN VARCHAR2,
                                p_error_message IN VARCHAR2) ;

  PROCEDURE dump_metric_results( p_metric_values IN mgmt_metric_value_array) ;
  --
  -- Dummy helper evaluation function for registering repository metrics
  -- which will never be evaluated: Ex: external metrics
  --
  PROCEDURE dummy_eval_proc(p_target_guid IN RAW,
                            p_metric_guid IN RAW,
                            p_coll_name   IN VARCHAR2,
                            p_values      OUT mgmt_metric_value_array) ; 
END ;
/

show err
