Rem drv: <create type="pkgdefs" pos="beacon/beacon_pkgdefs.sql+"/>
Rem
Rem $Header: collections_pkgdefs.sql 01-jul-2005.17:22:07 gsbhatia Exp $
Rem
Rem collections_pkgdefs.sql
Rem
Rem Copyright (c) 2002, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      collections_pkgdefs.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    gsbhatia    07/01/05 - New repmgr header impl 
Rem    gsbhatia    06/26/05 - New repmgr header impl 
Rem    gsbhatia    02/13/05 - updating repmgr header 
Rem    gsbhatia    02/09/05 - updating repmgr header 
Rem    gsbhatia    02/07/05 - updating repmgr header 
Rem    ktlaw       01/11/05 - add repmgr header 
Rem    dcawley     02/18/03 - Add delete_thresholds
Rem    dcawley     06/04/02 - Remove example evaluation procedure.
Rem    rpinnama    05/15/02 - rpinnama_reorg_rep_scripts
Rem    rpinnama    05/15/02 - Created
Rem

--     The evaluation procedure is given the target GUID and metric GUID and is
--     expected to calculate and return values for the metric. 
--     An evaluation procedure should be defined as:
--
--     PROCEDURE EVAL_PROC(v_target_guid   IN RAW,
--                         v_metric_guid   IN RAW   
--                         v_metric_result OUT MGMT_METRIC_RESULTS);
--  
--    The names of the key columns, metric columns and metric values 
--    should be returned using the OUT parameter v_metric_result. Both
--    the key_columns and metric_columns are optional for the case where
--    the procedure evaluates a simple metric i.e. not a table metric
--
--    The returned value(s) is(are) compared against the warning and critical 
--    thresholds that have been defined and if either are exceeded, a 
--    severity record is inserted into the severity table, MGMT_SEVERITY. 
--    If the V_STORE_METRIC parameter was set to 'Y' when the collection
--    was being added, then any metric values calculated by the evaluation
--    procedure are stored in the MGMT_METRICS_RAW table.
--
--    WARNING and CRITICAL comparison operators are defined as one of the
--    following:
--      0 - GT
--      1 - EQ
--      2 - LT
--      3 - LE
--      4 - GE
--      5 - CONTAINS 
--      6 - NE

----------------------------
-- The package definition --
----------------------------
CREATE OR REPLACE PACKAGE EMD_COLLECTION
IS

-- The module name for error and performance logging
MODULE_NAME constant varchar2(40) := 'EMD_COLLECTION.Collection Subsystem';

--
-- PURPOSE
--   To determine and run all scheduled repository collections
--
-- NOTES
--   This is the main procedure responsible for determining the collections
--   that are due to run, and for running those collections. This routine is
--   run by a DBMS JOB that runs once every minute. Only collections that
--   have a value of 1 in the IS_REPOSITORY column of MGMT_METRICst
--   are run
--
PROCEDURE RUN_COLLECTIONS;

--
-- PURPOSE         
--   To add the thresholds for a given collection for one or more columns 
--   and/or one or more key values 
--
-- PARAMETERS 
--
--   V_TARGET_GUID - the target GUID
--   V_METRIC_NAME - the name of the metric that the collection is for
--   V_COLLECTION_NAME - the name of the collection
--   V_THRESHOLDS - the threshold definitions
--   V_DELETE - a flag to indicate whether the existing thresholds should
--              be deleted before the new ones are added
--
PROCEDURE ADD_THRESHOLDS(v_target_guid     IN RAW, 
                         v_metric_name     IN VARCHAR2,
                         v_collection_name IN VARCHAR2, 
                         v_thresholds      IN MGMT_THRESHOLDS,
                         v_delete          IN NUMBER DEFAULT 0); 

-- PURPOSE
--   To delete all thresholds for a number of collections
--
-- PARAMETERS
--   V_COLLECTIONS - the collections for which all thresholds will be deleted
PROCEDURE DELETE_THRESHOLDS(v_collections IN MGMT_COLLECTION_IDS);

--
-- PURPOSE
--   To delete all thresholds for a collection. 
--
-- PARAMETERS
--
--   V_TARGET_GUID - the target GUID
--   V_METRIC_NAME - the name of the metric that the collection is for
--   V_COLLECTION_NAME - the name of a previously added collection
--
PROCEDURE DELETE_ALL_THRESHOLDS(v_target_guid     IN RAW, 
                                v_metric_name     IN VARCHAR2,
                                v_collection_name IN VARCHAR2);

--
-- PURPOSE
--   To start a collection
--
-- PARAMETERS
--
--   V_TARGET_GUID - the target GUID
--   V_METRIC_NAME - the name of the metric that this collection is for
--   V_COLLECTION_NAME - the name of the collection
--   V_STORE_METRIC - flag to indicate whether the values returned from the
--                    collection run should be stored in MGMT_METRICS_RAW
--                    'Y' - STORE
--                    'N' - DO NOT STORE
--   V_SCHEDULE - the number of minutes between repository collections
--   V_SCHEDULE_EX - the schedule for a User Defined Metric Collection
--
PROCEDURE START_COLLECTION(v_target_guid     IN RAW,
                           v_metric_name     IN VARCHAR2, 
                           v_collection_name IN VARCHAR2,
                           v_store_metric    IN VARCHAR2, 
                           v_schedule        IN NUMBER DEFAULT 15,
                           v_schedule_ex     IN VARCHAR2 DEFAULT ' ');

--
-- PURPOSE
--   To modify a collection
--
-- PARAMETERS
--
--   V_TARGET_GUID - the target GUID
--   V_METRIC_NAME - the name of the metric that this collection is for
--   V_COLLECTION_NAME - the name of a previously added collection
--   V_STORE_METRIC - flag to indicate whether the values returned from the
--                    collection run should be stored in MGMT_METRICS_RAW
--                    'Y' - STORE
--                    'N' - DO NOT STORE
--   V_SCHEDULE - the number of minutes between repository collections
--   V_SCHEDULE_EX - the schedule for a User Defined Metric Collection
--
-- NOTES
--   Only the V_STORE_METRIC, V_SCHEDULE and V_SCHEDULE_EX parameters can be 
--   modified
--
PROCEDURE MODIFY_COLLECTION(v_target_guid     IN RAW, 
                            v_metric_name     IN VARCHAR2,
                            v_collection_name IN VARCHAR2, 
                            v_store_metric    IN VARCHAR2, 
                            v_schedule        IN NUMBER DEFAULT 15,
                            v_schedule_ex     IN VARCHAR2 DEFAULT ' ');                          

--
-- PURPOSE
--   Procedure to describe a collection
--
-- PARAMETERS
--
--   V_TARGET_GUID - the target GUID
--   V_METRIC_NAME - the name of the metric that this collection is for
--   V_COLLECTION_NAME - name of the collection
--   V_EVAL_PROC - the name of the PL/SQL evaluation procedure if this is a
--                 repository collection
--   V_SCHEDULE - the number of minutes between successive collections if this
--                is a User Defined Metric Collection
--   V_SCHEDULE_EX - the schedule for a User Defined Metric Collection
--   V_STORE_METRIC - flag to indicate whether the values returned from the
--                    collection run are stored in MGMT_METRICS_RAW
--                    'Y' - STORED
--                    'N' - NOT STORED
--   V_KEY_COLUMN - the name of the key column
--   V_THRESHOLDS - the list of thresholds
--
PROCEDURE DESCRIBE_COLLECTION(v_target_guid         IN RAW,
                              v_metric_name         IN VARCHAR2,
                              v_collection_name     IN VARCHAR2,
                              v_eval_proc           OUT VARCHAR2,
                              v_schedule            OUT NUMBER,
                              v_schedule_ex         OUT VARCHAR2,
                              v_store_metric        OUT VARCHAR2,
                              v_key_column          OUT VARCHAR2,
                              v_thresholds          OUT MGMT_THRESHOLDS);

-- PURPOSE
--   Procedure to verify if there is a ongoing collection for a given metric
--   and target. Inexistent target names/types or metric names/types will return
--   a simple "no collection status" (in other words, validity of the input
--   parameters is not checked).
--
-- PARAMETERS
--
--   V_TARGET_GUID - the target GUID
--   V_METRIC_NAME - the name of the metric 
--
FUNCTION HAS_COLLECTION(v_target_guid IN RAW,
                        v_metric_name IN VARCHAR2)
RETURN BOOLEAN;


-- PURPOSE
--   To stop a collection
--
-- PARAMETERS
--
--   V_TARGET_GUID - the target GUID
--   V_METRIC_NAME - the name of the metric that this collection is for
--   V_COLLECTION_NAME - the name of a previously added collection
--
PROCEDURE STOP_COLLECTION(v_target_guid     IN RAW, 
                          v_metric_name     IN VARCHAR2,
                          v_collection_name IN VARCHAR2);
PROCEDURE STOP_COLLECTION(v_target_name     IN VARCHAR2, 
                          v_target_type     IN VARCHAR2,
                          v_metric_name     IN VARCHAR2,
                          v_collection_name IN VARCHAR2);
-- PURPOSE
--   To stop a collection
--
-- PARAMETERS
--
--   V_COLLECTIONS - the collections to stop
--   V_DELETE_THRESHOLDS - flag to indicate whether all the thresholds
--                         should be deleted for each collection
--                         0 - Do not delete
--                         1 - Delete
--
PROCEDURE STOP_COLLECTIONS(v_collections IN MGMT_COLLECTION_IDS,
                           v_delete_thresholds IN NUMBER);
 
-- PURPOSE
--   To suspend or resume a collection
--
-- PARAMETERS
--
--   V_TARGET_GUID - the target GUID
--   V_METRIC_NAME - the name of the metric that this collection is for
--   V_COLLECTION_NAME - the name of a previously added collection
--   V_SUSPEND - flag to indicate whether the collection should be
--               suspended or resumed. 1 => Suspend, 0 => Resume
--
PROCEDURE SUSPEND_COLLECTION(v_target_guid     IN RAW,
                             v_metric_name     IN VARCHAR2,
                             v_collection_name IN VARCHAR2,
                             v_suspend         IN NUMBER); 

-- PURPOSE
--   To suspend or resume all collections for a target
--
-- PARAMETERS
--
--   V_TARGET_GUID - the target GUID
--   V_SUSPEND - flag to indicate whether the collection should be
--               suspended or resumed. 1 => Suspend, 0 => Resume
--
PROCEDURE SUSPEND_COLLECTION(v_target_guid     IN RAW,
                             v_suspend         IN NUMBER);

-- PURPOSE         
--   To get a list of key values that have thresholds defined on them 
-- PARAMETERS 
--
--   V_TARGET_GUID - the target GUID of a previously added collection
--   V_METRIC_GUID - the metric GUID of a previously added collection
--
FUNCTION GET_KEY_VALUES_WITH_THRESHOLDS(v_target_guid   IN RAW,
                                        v_metric_guid   IN RAW)
RETURN SMP_EMD_STRING_ARRAY;

END EMD_COLLECTION;
/

show errors

