Rem drv: <create type="post_creation" pos="common/common_post_creation.sql-"/>
Rem
Rem $Header: collections_post_creation.sql 16-jul-2006.23:24:38 neearora Exp $
Rem
Rem collections_post_creation.sql
Rem
Rem Copyright (c) 2002, 2006, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      collections_post_creation.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    neearora    07/16/06 - Backport neearora_bug-5108394 from main 
Rem    neearora    03/28/06 - Bug 5108394. Adding capability in loader to 
Rem                           delete rows through uploads 
Rem    kmanicka    08/24/05 - change repManager header 
Rem    scgrover    07/06/05 - add extended sql trace 
Rem    gsbhatia    07/03/05 - New repmgr header impl 
Rem    jsadras     04/26/05 - snapshot collection task 
Rem    ktlaw       01/11/05 - add repmgr header 
Rem    jsadras     11/25/04 - Register task types 
Rem    jsadras     11/04/04 - target_add_callback
Rem    jsadras     10/21/04 - target_delete_callback
Rem    jsadras     10/19/04 - metric_eval
Rem    rpinnama    10/21/04 - Add target deletion callback to remove 
Rem                           collections 
Rem    jsadras     09/22/04 - remove emd_collections: 
Rem    jsadras     08/31/04 - add mgmt_collection 
Rem    jsadras     08/05/04 - add workers 
Rem    rpinnama    03/17/03 - Move DBMS_JOB submission to collection_dbms_jobs
Rem    rpinnama    10/15/02 - Fix register_logging_module API
Rem    rpinnama    10/14/02 - Use log registration API
Rem    aholser     05/31/02 - add display and dbms job info
Rem    rpinnama    05/16/02 - submit dbms_job.
Rem    rpinnama    05/15/02 - Created
Rem

--
-- Register the module for error logging
-- 
BEGIN
  mgmt_log.register_logging_module (MGMT_COLLECTION.G_MODULE_NAME,
                                    'Repository Metrics',
                                    'EM_TASK.WORKER');

  mgmt_log.register_logging_module (EM_METRIC_EVAL.G_MODULE_NAME,
                                    'Metric Evaluation') ;

  mgmt_log.register_logging_module (EM_POLICY_EVAL.G_MODULE_NAME,
                                    'Policy Evaluation') ;
                                    
  COMMIT;
END;
/

-- Add target addition callback
BEGIN
  mgmt_admin.add_target_addition_callback('mgmt_collection.start_default_collection') ;
END;
/

-- Add target delete exceptions
BEGIN
  INSERT INTO mgmt_target_delete_exceptions values ('MGMT_COLLECTION_METRIC_TASKS') ;
  COMMIT;
END ;
/

-- Add pre-target delete callbacks
BEGIN
  em_target.add_tgt_pre_deletion_callback('em_coll_util.handle_target_delete');
  COMMIT;
END;
/

-- set the default worker count to start up
-- one worker for shortrunning jobs
-- one worker for long running jobs
--
BEGIN
  mgmt_collection.set_worker_count(EM_TASK.G_TASK_CLASS_SHORT_RUNNING,1) ;
  mgmt_collection.set_worker_count(EM_TASK.G_TASK_CLASS_LONG_RUNNING,1) ;
  COMMIT ;
END ;
/

-- register a rowset handler to delete the records from MGMT_METRIC_THRESHOLDS
BEGIN
  emd_loader.add_plsql_handler_for_rowset(p_rowset_name => 'MGMT_METRIC_THRESHOLDS',
                                          p_proc_name   => 'EM_COLL_UTIL.delete_metric_threshold',
                                          p_handler_type => EMD_LOADER.G_ROWSET_HANDLER_PLSQL_DELETE  
                                         );
  COMMIT;
END;
/ 
@@&&EM_SQL_ROOT/core/v102020/collections_data_upgrade.sql   
