Rem drv: <create type="tables"/>
Rem
Rem $Header: collections_tables.sql 26-jul-2007.04:25:49 aptrived Exp $
Rem
Rem collections_tables.sql
Rem
Rem Copyright (c) 2002, 2007, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      collections_tables.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    aptrived    08/21/06 - Bug#5385651, Increasing size of column
Rem                           PROPERTY_VALUE in mgmt_coll_item_properties
Rem    aptrived    07/26/07 - Backport aptrived_bug-5385651 from main
Rem    aptrived    07/17/07 - Backport aptrived_bug-5441111 from main
Rem    aptrived    08/03/06 - Bug#5441111, Adding comment in header for
Rem                           mgmt_coll_item_properties
Rem    jsadras     08/24/05 - default task_class to 0 
Rem    gsbhatia    06/26/05 - New repmgr header impl 
Rem    jsadras     06/02/05 - add task_class 
Rem    jsadras     05/02/05 - add task class  and remove mgmt_task_types
Rem    jsadras     03/24/05 - add is_transient bug:4014894 
Rem    jsadras     02/24/05 - remove obsolete tables 
Rem    gsbhatia    02/13/05 - updating repmgr header 
Rem    gsbhatia    02/09/05 - updating repmgr header 
Rem    gsbhatia    02/07/05 - updating repmgr header 
Rem    ktlaw       01/11/05 - add repmgr header 
Rem    jsadras     12/03/04 - monitoring
Rem    jsadras     11/25/04 - task_type table 
Rem    jsadras     11/03/04 - task_context
Rem    jsadras     11/02/04 - task_proc
Rem    rpinnama    10/15/04 - Change the is_required default 
Rem    rpinnama    09/13/04 - Remove mgmt_metric_collections, 
Rem                           mgmt_metric_thresholds tables 
Rem    rpinnama    09/07/04 - Add metric_guid to mgmt_coll_item_properties 
Rem    jsadras     09/03/04 - coll_depend
Rem    jsadras     08/25/04 - mgmt_coll_metric_dependency.type_meta_ver
Rem    jsadras     08/20/04 - dependent metrics 
Rem    rpinnama    08/26/04 - Add is_required flag 
Rem    jsadras     08/05/04 - add mgmt_collection_task_time 
Rem    jsadras     07/28/04 - add mgmt_coll_items.is_enabled 
Rem    jsadras     07/23/04 - mgmt_task_sequence
Rem    rpinnama    07/23/04 - Modify coll_item_properties 
Rem    rpinnama    06/22/04 - 
Rem    rpinnama    06/17/04 - Add collection items and tables for new repos 
Rem                           collections 
Rem    lgloyd      11/06/03 - perf: add shadow of mgmt_metric_collections 
Rem    streddy     07/10/03 - Added message and message_nlsid to thresholds
Rem    rpinnama    05/14/02 - rpinnama_reorg_rep_scripts
Rem    rpinnama    05/14/02 - Created
Rem

rem PURPOSE
rem   Contains details of the collections set up for a metric. 
rem
rem COLUMNS
rem
rem   TARGET_GUID - the GUID of the target associated with the collection
rem
rem   METRIC_GUID - the GUID of the metric associated with the collection
rem
rem   COLL_NAME - The name of the collection
rem
rem   IS_REPOSITORY - flag to indicate whether this is a repository side 
rem                   collection.A repository side collection is associated 
rem                   with a metric specified in MGMT_METRICS and
rem                   has a PL/SQL evaluation procedure that is responsible for 
rem                   calculating the metric values.
rem
rem   STORE_METRIC - flag to indicate whether values returned by the
rem                  collection should be stored in the MGMT_METRIC_RAW.
rem                  'Y' - STORE
rem                  'N' - DO NOT STORE
rem
rem   SCHEDULE - all repository side collections are scheduled to run by 
rem              DBMS JOBs (collection workers). TheDBMS JOB calls the 
rem              evaluation procedure (which is specified in the MGMT_METRICS table) 
rem              when it is scheduled to run. This column specifies the number of 
rem              minutes between successive runs of the collection
rem
rem   SCHEDULE_EX - the schedule used for non-repository collections
rem
rem   LAST_COLLECTED_TIMESTAMP - the time when the evaluation procedure was
rem                              last run
rem
rem   STATUS_MESSAGE - a message indicating success/failure of the evaluation
rem                    procedure
rem
rem   SUSPENDED - flag to indicate whether the collection is suspended
rem              0 => NOT SUSPENDED
rem              1 => SUSPENDED 
rem

REM NOTE: mgmt_metric_collections table is removed and a view with the same 
REM   name is created for backward compatibility
REM


rem PURPOSE
rem   Contains information about repository based collections.  This
rem   table was added to improve performance of collections job since
rem   the number of repository based collection metrics is small compared
rem   to the number of overall collection metrics.  This table contains
rem   the primary key columns of mgmt_metric_collections.
rem
rem COLUMNS
rem
rem   TARGET_GUID - the GUID of the target associated with the collection
rem
rem   METRIC_GUID - the GUID of the metric associated with the collection
rem
rem   COLL_NAME - The name of the collection
rem
rem
CREATE TABLE MGMT_METRIC_COLLECTIONS_REP (
 target_guid              RAW(16)       NOT NULL,
 metric_guid              RAW(16)       NOT NULL,
 coll_name                VARCHAR2(64)  DEFAULT ' '
)
MONITORING;


Rem
Rem Table which contains collection items.
Rem Ideally there should be one more master table to this
Rem which has collection_name as primary key, since there are
Rem no attributes specific to it, that table was not created.
Rem

CREATE TABLE MGMT_COLL_ITEMS
(   target_type            VARCHAR2(64)   NOT NULL,
    type_meta_ver          VARCHAR2(8)    DEFAULT '1.0' NOT NULL,
    coll_name              VARCHAR2(64)   DEFAULT ' '   NOT NULL,     
    category_prop_1        VARCHAR2(64)   DEFAULT ' '   NOT NULL,    
    category_prop_2        VARCHAR2(64)   DEFAULT ' '   NOT NULL,    
    category_prop_3        VARCHAR2(64)   DEFAULT ' '   NOT NULL,
    category_prop_4        VARCHAR2(64)   DEFAULT ' '   NOT NULL,  
    category_prop_5        VARCHAR2(64)   DEFAULT ' '   NOT NULL,
    is_enabled             NUMBER(1)      DEFAULT 1 NOT NULL,
    is_required            NUMBER(1)      DEFAULT 0 NOT NULL,
    CONSTRAINT mgmt_coll_items_pk
    PRIMARY KEY (target_type,type_meta_ver,coll_name,
                 category_prop_1,
                 category_prop_2,
                 category_prop_3,
                 category_prop_4,
                 category_prop_5)
)
ORGANIZATION INDEX
MONITORING;


COMMENT ON TABLE mgmt_coll_items IS
  'This table contains details of the default collections set up for
   a target type.';

COMMENT ON COLUMN mgmt_coll_items.target_type IS
  'Target type of the collection.';

COMMENT ON COLUMN mgmt_coll_items.type_meta_ver IS
  'Target type meta version of the collection item.';

COMMENT ON COLUMN mgmt_coll_items.category_prop_1  IS
  'Category property 1 ' ;
COMMENT ON COLUMN mgmt_coll_items.category_prop_2  IS
   'Category property 2 ' ;
COMMENT ON COLUMN mgmt_coll_items.category_prop_3  IS
   'Category property 3 ' ;
COMMENT ON COLUMN mgmt_coll_items.category_prop_4  IS
   'Category property 4 ' ;
COMMENT ON COLUMN mgmt_coll_items.category_prop_5  IS
   'Category property 5 ' ;

COMMENT ON COLUMN mgmt_coll_items.is_enabled  IS
   'Identifies whether the collection item is enabled or not';

COMMENT ON COLUMN mgmt_coll_items.is_required  IS
   'Identifies whether the collection item can be disabled or not, 
    Required collections cannot be disabled. Default is 0, 
    so collections can be disabled.';


Rem
Rem Table to hold metrics associated with collection item
Rem
CREATE TABLE mgmt_coll_item_metrics
(   
    target_type            VARCHAR2(64) NOT NULL,
    type_meta_ver          VARCHAR2(8)  DEFAULT '1.0' NOT NULL, 
    coll_name              VARCHAR2(64) DEFAULT ' ' NOT NULL , 
    metric_guid            RAW(16)      NOT NULL,
    CONSTRAINT mgmt_coll_item_metrics_pk
    PRIMARY KEY(target_type, type_meta_ver, coll_name, metric_guid)
)
ORGANIZATION INDEX
MONITORING;

COMMENT ON TABLE mgmt_coll_item_metrics IS
  'Table to hold the metrics associated with a collection item' ;

COMMENT ON COLUMN mgmt_coll_item_metrics.target_type IS
  'Target type' ;

COMMENT ON COLUMN mgmt_coll_item_metrics.type_meta_ver IS
  'Target type meta version' ;

COMMENT ON COLUMN mgmt_coll_item_metrics.coll_name IS
  'Name of the collection item.' ;

COMMENT ON COLUMN mgmt_coll_item_metrics.metric_guid IS
  'Metric associated with the collection name.' ;



rem
rem  PURPOSE
rem
rem   The MGMT_COLL_ITEM_PROPERTIES table contains properties for a collection Item
rem
rem  COLUMNS
rem
rem   OBJECT_GUID The guid of the object that this property is for
rem 
rem   OBJECT_TYPE The type of the object that this property is for
rem
rem   METRIC_GUID - the GUID of the metric associated with the collection
rem
rem   COLL_NAME - The name of the collection
rem
rem   PROPERTY_NAME - The name of the collection property
rem
rem   PROPERTY_VALUE - The value of the collection property
rem                    For UDM metrics, the property_value stores the UDM
rem                    SQL script to execute hence value of 
rem                    UDM_SCRIPT_MAX_LENGTH in 
rem                    emcore/source/oracle/sysman/eml/mntr/Constants.java
rem                    should be less than or equal to length of this column
rem
CREATE TABLE mgmt_coll_item_properties
(   object_guid           RAW(16)            NOT NULL,
    metric_guid           RAW(16)            NOT NULL,
    coll_name             VARCHAR2(64)       DEFAULT ' '   NOT NULL,     
    property_name         VARCHAR2(64)       NOT NULL, 
    object_type           NUMBER(1)          DEFAULT 1,
    property_value        VARCHAR2(4000)     NOT NULL,
    CONSTRAINT mgmt_coll_items_properties_pk
    PRIMARY KEY (object_guid,
                 metric_guid,
                 coll_name,
                 property_name)
) 
ORGANIZATION INDEX
OVERFLOW INCLUDING property_value
MONITORING;


COMMENT ON TABLE mgmt_coll_item_properties IS
    'This table contains the list of properties defined for a collection.';

COMMENT ON COLUMN mgmt_coll_item_properties.object_guid IS
    'The guid for which the collection properties are stored.';

COMMENT ON COLUMN mgmt_coll_item_properties.metric_guid IS
    'The metric guid for which the collection properties are stored.';

COMMENT ON COLUMN mgmt_coll_item_properties.coll_name IS
    'The collection name associated with the collection property.';

COMMENT ON COLUMN mgmt_coll_item_properties.property_name IS
    'The name of the collection property.';
 
COMMENT ON COLUMN mgmt_coll_item_properties.object_type IS
    'The type of object for which the collection properties are stored.
      Possible values are 1 - DEFAULT, 2- TARGET, 3 - TEMPLATE.';

COMMENT ON COLUMN mgmt_coll_item_properties.property_value IS
    'The value of the collection property.';





Rem
Rem Table to hold collections setup for a target/template/default collection
Rem
rem PURPOSE
rem   Contains details of the collections set up for a metric. 
rem
rem COLUMNS
rem
rem   OBJECT_GUID - the GUID of the object associated with the collection
rem
rem   OBJECT_TYPE - the type of the object associated with the collection
rem
rem   METRIC_GUID - the GUID of the metric associated with the collection
rem
rem   COLL_NAME - The name of the collection
rem
rem   STORE_METRIC - flag to indicate whether values returned by the
rem                  collection should be stored in the MGMT_METRIC_RAW.
rem                  1 - STORE
rem                  0 - DONOT STORE
rem
rem   SCHEDULE_EX - the schedule used for non-repository collections
rem
rem   IS_ENABLED - flag to indicate whether the collection is enabled
rem              1 => ENABLED
rem              0 => NOT ENABLED

rem
CREATE TABLE mgmt_collections
(
    object_guid            RAW(16)            NOT NULL,
    coll_name              VARCHAR2(64)       DEFAULT ' ' NOT NULL,
    object_type            NUMBER(1)          DEFAULT 1,
    is_enabled             NUMBER(1)          DEFAULT 1 NOT NULL,
    schedule_ex            VARCHAR2(1024)     DEFAULT ' ', 
    store_metric           NUMBER(1)          DEFAULT 1  NOT NULL,
    upload_frequency       NUMBER             DEFAULT 1, 
    is_transient           NUMBER(1)          DEFAULT 0 NOT NULL,
    frequency_code         NUMBER             DEFAULT 2 NOT NULL,
    start_time             DATE               DEFAULT NULL,
    end_time               DATE               DEFAULT NULL,
    execution_hours        NUMBER             DEFAULT NULL,
    execution_minutes      NUMBER             DEFAULT NULL,
    interval               NUMBER             DEFAULT NULL,
    months                 MGMT_INTEGER_ARRAY DEFAULT NULL,
    days                   MGMT_INTEGER_ARRAY DEFAULT NULL
)
TABLESPACE &EM_ECM_DEPOT_TABLESPACE
MONITORING;

COMMENT ON TABLE mgmt_collections IS
    'This table contains details of the collections set up for a metric.';
    
COMMENT ON COLUMN mgmt_collections.object_guid IS
    'The guid of the target/template/default associated with the collection.';
    
COMMENT ON COLUMN mgmt_collections.coll_name IS
    'Collection Item' ;

COMMENT ON COLUMN mgmt_collections.object_type IS
    'The type of guid stored in object_guid. Possible values are:
     = 0, for default collection
     = 1, for target
     = 2, for template';

COMMENT ON COLUMN mgmt_collections.schedule_ex IS
    'The schedule column used for agent collections';

COMMENT ON COLUMN mgmt_collections.store_metric IS
    'The flag to indicate whether values returned by the collection should
     be stored in the MGMT_METRIC_RAW.
       1 - STORE
       0 - DO NOT';

COMMENT ON COLUMN mgmt_collections.is_transient IS
  '1=Transient collection, 0 - Non-transient collection DEFAULT,
   The agent uses the value to determine whether to upload data or not' ;

COMMENT ON COLUMN mgmt_collections.frequency_code IS
    ' Refer mgmt_blackout_schedule' ;

COMMENT ON COLUMN mgmt_collections.start_time IS
    'start time when collection becomes active' ;

COMMENT ON COLUMN mgmt_collections.end_time IS 
    'end time when collection becomes inactive ' ;

COMMENT ON COLUMN mgmt_collections.execution_hours IS
    'hour of the day when to execute' ;

COMMENT ON COLUMN mgmt_collections.execution_minutes IS
    'the minute of the hour when to execute' ;

COMMENT ON COLUMN mgmt_collections.interval IS
    'interval in minutes' ;

COMMENT ON COLUMN mgmt_collections.months IS 
    ' months of the year' ;

COMMENT ON COLUMN mgmt_collections.days IS
     'days of the month'  ;


Rem 
Rem  Table to store task information for a collection
Rem
CREATE TABLE mgmt_collection_tasks
( 
    task_id                   NUMBER           NOT NULL,
    task_type                 NUMBER           NOT NULL,
    task_class                NUMBER           DEFAULT 0 NOT NULL ,
    priority                  NUMBER           NOT NULL,
    timezone_region           VARCHAR2(64)     NOT NULL,
    frequency_code            NUMBER            DEFAULT  2 NOT NULL,
    start_time                DATE,
    end_time                  DATE,
    execution_hours           NUMBER,
    execution_minutes         NUMBER,
    interval                  NUMBER,
    months                    MGMT_INTEGER_ARRAY ,
    days                      MGMT_INTEGER_ARRAY ,
    task_proc                 VARCHAR2(4000),
    task_status               NUMBER             DEFAULT 0 NOT NULL,
    task_start_time           DATE,
    last_collection_timestamp DATE,
    next_collection_timestamp DATE,
    error_message             VARCHAR2(4000),
    failures                  NUMBER,
    worker_id                 NUMBER,
    total_runs                NUMBER DEFAULT 0 NOT NULL,
    min_wait_time             NUMBER DEFAULT 0 NOT NULL,
    max_wait_time             NUMBER DEFAULT 0 NOT NULL,
    avg_wait_time             NUMBER DEFAULT 0 NOT NULL,
    min_run_time              NUMBER DEFAULT 0 NOT NULL,
    max_run_time              NUMBER DEFAULT 0 NOT NULL,
    avg_run_time              NUMBER DEFAULT 0 NOT NULL
)
TABLESPACE &EM_ECM_DEPOT_TABLESPACE
MONITORING;

COMMENT ON TABLE mgmt_collection_tasks IS
 ' Table to Hold list of collection tasks' ;

COMMENT ON COLUMN mgmt_collection_tasks.task_id iS
  ' Unique Task Id' ;

COMMENT ON COLUMN mgmt_collection_tasks.frequency_code is
 'Frequency of the schedule, see mgmt_blackout_schedule' ;

COMMENT ON COLUMN mgmt_collection_tasks.start_time IS
 ' Start time when the collection has to start' ;

COMMENT ON COLUMN mgmt_collection_tasks.end_time IS
 ' End time for repeating collections' ;

COMMENT ON COLUMN mgmt_collection_tasks.execution_hours IS
 'Hour of the day when the collection is scheduled' ;

COMMENT ON COLUMN mgmt_collection_tasks.execution_minutes IS
 'Minute of the hour when the collection is to end' ;
    
COMMENT ON COLUMN mgmt_collection_tasks.interval IS
 ' Interval in minutes for interval schedule' ;
    
COMMENT ON COLUMN mgmt_collection_tasks.months IS
 'Months of the year' ;

COMMENT ON COLUMN mgmt_collection_tasks.days IS
 'Days of the month' ;

COMMENT ON COLUMN mgmt_collection_tasks.task_proc IS
 'procedure to be run, should accept task_id(number)
  and context(mgmt_namevalue_array) as parameter' ;

COMMENT ON COLUMN mgmt_collection_tasks.task_status IS
 'Status of the task 0=Scheduled, 1=Running' ;

COMMENT ON COLUMN mgmt_collection_tasks.task_start_time IS
 'Time when the task started running' ;

 COMMENT ON COLUMN mgmt_collection_tasks.last_collection_timestamp IS
 'Last time the task was run' ;

COMMENT ON COLUMN mgmt_collection_tasks.next_collection_timestamp IS
'Next time when the task is scheduled' ;

COMMENT ON COLUMN mgmt_collection_tasks.error_message IS
 'Last error message encountered when running this task' ;

COMMENT ON COLUMN mgmt_collection_tasks.failures IS
 'failures encountered so far, reset on successful execution' ;

COMMENT ON COLUMN mgmt_collection_tasks.worker_id IS
 ' Worker running this task' ;

COMMENT ON COLUMN mgmt_collection_tasks.total_runs IS
 ' Total number of times the task has run' ;

COMMENT ON COLUMN mgmt_collection_tasks.min_wait_time IS
 ' Minimum wait time in seconds for the collection to be picked up by collections engine,
     Wait time=collection_start_time-scheduled_time'  ;

COMMENT ON COLUMN mgmt_collection_tasks.max_wait_time IS
 ' Maximum wait time in seconds for the collection to be picked up by collections engine,
     Wait time=collection_start_time-scheduled_time'  ;

COMMENT ON COLUMN mgmt_collection_tasks.avg_wait_time IS
 'Average wait time in seconds for the collection to be picked up by collections engine,
     Wait time=collection_start_time-scheduled_time'  ;

COMMENT ON COLUMN mgmt_collection_tasks.min_run_time IS
'Minimum run time for the collection in seconds' ;

COMMENT ON COLUMN mgmt_collection_tasks.max_run_time IS
'Maximum run time for the collection in seconds' ;

COMMENT ON COLUMN mgmt_collection_tasks.avg_run_time IS
'Average run time for the collection in seconds' ;

rem
rem MGMT_COLLECTION_TASK_CONTEXT
rem Task context table to store the context information for a task
rem
rem 

CREATE TABLE mgmt_collection_task_context
( task_id  NUMBER       NOT NULL,
  name     VARCHAR2(64) NOT NULL,
  value    VARCHAR2(4000),
  CONSTRAINT mgmt_collection_task_ctx_pk
   PRIMARY KEY (task_id,name)
)
ORGANIZATION INDEX
OVERFLOW INCLUDING value
MONITORING ;

COMMENT ON COLUMN mgmt_collection_task_context.task_id IS
' Task id' ;

COMMENT ON COLUMN mgmt_collection_task_context.name IS
'name of the context' ;

COMMENT ON COLUMN mgmt_collection_task_context.value IS
'value of the context' ;

Rem
Rem table to store worker counts for each task class
Rem

CREATE TABLE mgmt_task_worker_counts
(task_class_list   VARCHAR2(64) NOT NULL,
 worker_count      NUMBER(2)    NOT NULL,
  CONSTRAINT mgmt_task_worker_counts_pk
   PRIMARY KEY (task_class_list)
) 
ORGANIZATION INDEX
OVERFLOW INCLUDING worker_count
MONITORING ;

COMMENT ON COLUMN mgmt_task_worker_counts.task_class_list IS
 ' task class or a list of task class seperated by comma, no whitespaces' ;

COMMENT ON COLUMN mgmt_task_worker_counts.worker_count IS
 ' Number of workers to start up for a given task class ' ;

rem MGMT_TASK_SEQUENCE
rem   The sequence that generates task_id for collection tasks
rem
CREATE SEQUENCE mgmt_task_sequence INCREMENT BY 1 START WITH 1
    MAXVALUE 1.0E28 MINVALUE 1 NOCYCLE
    CACHE 5 NOORDER;

Rem
Rem Table to hold target-metric-collection to task mapping
Rem

-- TODO: Added last_collected_timestamp and status_message
--       for supportint existing collection framework.
--       Once the existing collection framework is removed,
--       these columns can be deleted.

CREATE TABLE mgmt_collection_metric_tasks
(
    target_guid            RAW(16) NOT NULL,
    coll_name              VARCHAR2(64) DEFAULT ' ' NOT NULL,
    metric_guid            RAW(16) NOT NULL,
    task_id                NUMBER,
    last_collected_timestamp    DATE DEFAULT NULL,
    status_message         VARCHAR2(256) DEFAULT ' ',
    CONSTRAINT mgmt_coll_metric_tasks_pk
    PRIMARY KEY(target_guid,coll_name,metric_guid)
)
ORGANIZATION INDEX
MONITORING;


COMMENT ON TABLE mgmt_collection_metric_tasks IS
    'The table stores the target-metric to collection task association.';

COMMENT ON COLUMN mgmt_collection_metric_tasks.target_guid IS
    'The guid of the target associated with the collection.';

COMMENT ON COLUMN mgmt_collection_metric_tasks.metric_guid IS
    'The GUID of the metric associated with the collection.
     Now one task can have only one metric,
     metric_guid is in tasks table to enforce that and for performance' ;

COMMENT ON COLUMN mgmt_collection_metric_tasks.coll_name IS
    'The name of the collection.';

COMMENT ON COLUMN mgmt_collection_metric_tasks.task_id IS
    'The collection task that executes this collection.
     If collection for the metric is suspended then task_id is null';


Rem
Rem The collection workers can be run via DBMS_JOB
Rem or run directly in a session.
Rem If a collection worker is run directly then job_id is null
Rem


CREATE TABLE mgmt_collection_workers
(
    worker_id            NUMBER(3)      NOT NULL,
    task_class_list      VARCHAR2(64)   DEFAULT 0 NOT NULL,
    worker_status        NUMBER         DEFAULT 0 NOT NULL,
    job_id               NUMBER         DEFAULT NULL,
    worker_start_time    DATE,
    CONSTRAINT mgmt_collection_workers_pk
    PRIMARY KEY (worker_id)
)
ORGANIZATION INDEX
MONITORING;

COMMENT ON COLUMN mgmt_collection_workers.worker_id IS
'Unique Worker id' ;

COMMENT ON COLUMN mgmt_collection_workers.job_id IS
'Job ID associated with the worker, null if the worker is run directly' ;

COMMENT ON COLUMN mgmt_collection_workers.worker_status IS
'Status of worker, 0=Worker Starting 1=Worker Started 2=Stop pending' ;

COMMENT ON COLUMN mgmt_collection_workers.worker_start_time IS
'Time when worker started running first
 When worker status changed from 0 to 1' ;

COMMENT ON COLUMN mgmt_collection_workers.task_class_list IS
'Comma seperated list of task classes the worker can pick up' ;

rem
rem  PURPOSE
rem
rem    The MGMT_METRIC_THRESHOLDS table contains thresholds for a collection
rem    on a metric column basic, or on a per-key value basis for a metric
rem    column
rem
rem  COLUMNS
rem
rem       see the definition for MGMT_METRICS_RAW
rem
rem     COLL_NAME
rem                
rem                 - The name of the collection collecting this metric
rem
rem     WARNING_OPERATOR
rem
rem                 - The operator for the warning threshold.  This is used in
rem                   the reporting environment to create a line on the graph
rem                   representing the warning threshold appropriately.
rem
rem                         0 - GT
rem                         1 - EQ
rem                         2 - LT
rem                         3 - LE
rem                         4 - GE
rem                         5 - CONTAINS
rem                         6 - NE
rem                         7 - MATCH    :  regular expression
rem
rem     WARNING_THRESHOLD
rem
rem                 - value for the warning.  Together with the warning operator
rem                   a graph line can be drawn to show the warning threshold.
rem
rem     CRITICAL_OPERATOR
rem
rem                 - The operator for the critical threshold.  This is used in
rem                   the reporting environment to create a line on the graph
rem                   representing the critical threshold appropriately.
rem
rem                         0 - GT
rem                         1 - EQ
rem                         2 - LT
rem                         3 - LE
rem                         4 - GE
rem                         5 - CONTAINS
rem                         6 - NE
rem                         7 - MATCH    :  regular expression
rem
rem     CRITICAL_THRESHOLD
rem
rem                 - value for the critical severity.  Together with the
rem                   critical operator, a graph line can be drawn to show the
rem                   critical severity threshold.
rem
rem     NUM_OCCURENCES - the number of occurences of a warning/critical/clear
rem                      severity before a severity record is generated.
rem
rem     NUM_WARNINGS - the number of consecutive times a metric value has
rem                    exceeded the warning threshold
rem
rem     NUM_CRITICALS - the number of consecutive times a metric value has
rem                     exceeded the critical threshold
rem
rem     EVAL_ORDER - the number representing the order for the evaluation of a condition
rem
rem     FIXIT_JOB - the fixit job associated with this metric
rem
rem  NOTES
rem
rem    It may make sense in the future to add a date column which represents
rem    the last collection time for the long string.  This will provide the
rem    means to determine whether or not the string is 'orphaned'.
rem

REM NOTE: mgmt_metric_threshold table is removed and a view with the same 
REM   name is created for backward compatibility

