Rem drv: <create type="type_bodys" pos="-"/>
Rem
Rem $Header: collections_type_body.sql 01-jul-2005.22:37:38 gsbhatia Exp $
Rem
Rem collections_type_body.sql
Rem
Rem Copyright (c) 2003, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      collections_type_body.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      Implements custom NEW method to support in type evolution.
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    gsbhatia    07/01/05 - New repmgr header impl 
Rem    jsadras     05/02/05 - add task class  and remove task_type
Rem    jsadras     11/03/04 - remove mgmt_metric_coll_defs 
Rem    jsadras     10/27/04 - on_demand_schedule
Rem    jsadras     10/20/04 - mgmt_coll_metric
Rem    jsadras     09/30/04 - case_insensitive_search
Rem    jsadras     08/28/04 - 
Rem    jsadras     08/15/04 - add mgmt_metric_value_obj.collection_timestamp 
Rem    jsadras     08/06/04 - added task_type 
Rem    jsadras     06/28/04 - Add functions to mgmt_metric_value_obj and 
Rem                           mgmt_namevalue_obj 
Rem    rpinnama    06/17/04 - Create type bodies for new repos collection fwk 
Rem    streddy     07/21/03 - streddy_bug-2918994
Rem    streddy     07/20/03 - Created
Rem


CREATE OR REPLACE TYPE BODY MGMT_THRESHOLD AS
  -- Implementation of new
  STATIC FUNCTION NEW(key_column_value    VARCHAR2,
                      metric_column       VARCHAR2, 
                      warning_operator    NUMBER, 
                      warning_threshold   VARCHAR2, 
                      critical_operator   NUMBER, 
                      critical_threshold  VARCHAR2, 
                      num_occurrences     NUMBER,
                      message             VARCHAR2 DEFAULT NULL,
                      message_nlsid       VARCHAR2 DEFAULT NULL)
   RETURN MGMT_THRESHOLD AS
   BEGIN
      RETURN MGMT_THRESHOLD(key_column_value, metric_column,
                            warning_operator, warning_threshold,
                            critical_operator, critical_threshold,
                            num_occurrences,  message,  message_nlsid);
   END NEW;

END;
/
show errors


CREATE OR REPLACE TYPE BODY mgmt_namevalue_obj AS
-- Constructs a new mgmt_namevalue_obj object
-- Used to support type evolution in case we need to add
-- more columns or obsolete columns
STATIC FUNCTION NEW(p_name  IN VARCHAR2,
                    p_value IN VARCHAR2
                   )
RETURN mgmt_namevalue_obj
AS
BEGIN
   RETURN mgmt_namevalue_obj(p_name,p_value) ;
END NEW ;
END ;
/
show errors


CREATE OR REPLACE TYPE BODY mgmt_metric_value_obj AS
-- Constructs a new mgmt_metric_value object
-- Used to support type evolution in case we need to add
-- more columns or obsolete columns
STATIC FUNCTION NEW(p_target_guid    IN RAW,
                    p_status         IN NUMBER,
                    p_status_message IN VARCHAR2,
                    p_metric_values  IN mgmt_namevalue_array,
                    p_collection_timestamp IN DATE DEFAULT NULL
                   )
RETURN mgmt_metric_value_obj
IS
BEGIN
   RETURN mgmt_metric_value_obj(p_target_guid,
                                p_status,
                                p_status_message,
                                p_metric_values,
                                p_collection_timestamp) ;
END NEW ;
--Do not have associative array lookup in 9.0
MEMBER FUNCTION metric_value(p_metric_column IN VARCHAR2)
RETURN VARCHAR2
IS
BEGIN
  IF self.metric_values IS NOT NULL AND self.metric_values.COUNT >0
  THEN
    FOR i in self.metric_values.FIRST..self.metric_values.COUNT
    LOOP 
      IF UPPER(self.metric_values(i).name) = UPPER(p_metric_column)
      THEN
         RETURN(self.metric_values(i).value) ;
      END IF ;
    END LOOP ;
    -- Below code will be executed rarely so done later on
    IF (p_metric_column IS NULL OR p_metric_column=' ') AND
       self.metric_values.COUNT=1
    THEN
      RETURN(self.metric_values(1).value) ;
    END IF ;
  END IF ;
  RETURN(null) ;
END metric_value;
MEMBER FUNCTION index_position(p_column_name IN VARCHAR2)
RETURN NUMBER
IS
BEGIN
  IF self.metric_values IS NOT NULL AND self.metric_values.COUNT >0
  THEN
    FOR i in self.metric_values.FIRST..self.metric_values.COUNT
    LOOP 
      IF UPPER(self.metric_values(i).name) = UPPER(p_column_name)
      THEN
         RETURN(i) ;
      END IF ;
    END LOOP ;
  END IF ;
  RETURN(null) ;
END index_position;


END ;
/


CREATE OR REPLACE TYPE BODY mgmt_coll_queue_obj AS
-- Constructs a new mgmt_coll_queue_obj object
-- Used to support type evolution in case we need to add
-- more columns or obsolete columns
STATIC FUNCTION NEW(p_task_id        IN NUMBER,
                    p_task_class     IN NUMBER,
                    p_message_code   IN NUMBER,
                    p_scheduled_time IN DATE
                   )
RETURN mgmt_coll_queue_obj
AS
BEGIN
   RETURN mgmt_coll_queue_obj(p_task_id,p_task_class,
               p_message_code,p_scheduled_time) ;
END NEW ;
END ;
/


CREATE OR REPLACE TYPE BODY mgmt_coll_schedule_obj AS
-- Constructs a new mgmt_coll_schedule_obj object
-- Used to support type evolution in case we need to add
-- more columns or obsolete columns

STATIC FUNCTION NEW(p_frequency_code     IN NUMBER,
                    p_execution_hours    IN NUMBER,
                    p_execution_minutes  IN NUMBER,
                    p_interval           IN NUMBER,
                    p_months             IN mgmt_integer_array,
                    p_days               IN mgmt_integer_array,
                    p_start_time         IN DATE,
                    p_end_time           IN DATE)
RETURN mgmt_coll_schedule_obj
AS
BEGIN
   RETURN mgmt_coll_schedule_obj(p_frequency_code,
                             p_start_time,
                             p_end_time,
                             p_execution_hours ,
                             p_execution_minutes,
                             p_interval        ,
                             p_months         ,
                             p_days) ;

END NEW ;

STATIC FUNCTION one_time(p_start_time IN DATE)
RETURN mgmt_coll_schedule_obj
AS
BEGIN
   RETURN mgmt_coll_schedule_obj(MGMT_GLOBAL.G_SCHED_FREQUENCY_ONE_TIME,
                             p_start_time,
                             NULL,
                             NULL ,
                             NULL,
                             NULL,
                             NULL ,
                             NULL) ;

END one_time ;

STATIC FUNCTION interval_schedule(p_interval   IN NUMBER,
                                  p_start_time IN DATE,
                                  p_end_time   IN DATE )
RETURN mgmt_coll_schedule_obj
AS
BEGIN
   RETURN mgmt_coll_schedule_obj(MGMT_GLOBAL.G_SCHED_FREQUENCY_INTERVAL,
                             p_start_time,
                             p_end_time,
                             null,
                             null,     
                             p_interval, 
                             null,
                             null) ;
END interval_schedule;

STATIC FUNCTION daily_schedule(p_execution_hours   IN NUMBER,
                               p_execution_minutes IN NUMBER,
                               p_start_time        IN DATE,
                               p_end_time          IN DATE)
RETURN mgmt_coll_schedule_obj
AS 
BEGIN
   RETURN mgmt_coll_schedule_obj(MGMT_GLOBAL.G_SCHED_FREQUENCY_DAILY,
                             p_start_time,
                             p_end_time,
                             p_execution_hours ,
                             p_execution_minutes,
                             null  ,
                             null  ,
                             null) ;
END daily_schedule ;

STATIC FUNCTION days_of_week(p_execution_hours   IN NUMBER,
                             p_execution_minutes IN NUMBER,
                             p_days              IN mgmt_integer_array,
                             p_start_time        IN DATE,
                             p_end_time          IN DATE)
RETURN mgmt_coll_schedule_obj
AS
BEGIN
   RETURN mgmt_coll_schedule_obj(MGMT_GLOBAL.G_SCHED_FREQUENCY_WEEKLY,
                             p_start_time,
                             p_end_time,
                             p_execution_hours ,
                             p_execution_minutes,
                             null  ,
                             null  ,
                             p_days) ;
END days_of_week ;

STATIC FUNCTION days_of_month(p_execution_hours  IN NUMBER,
                             p_execution_minutes IN NUMBER,
                             p_days              IN mgmt_integer_array,
                             p_start_time        IN DATE,
                             p_end_time          IN DATE)
RETURN mgmt_coll_schedule_obj
AS
BEGIN
   RETURN mgmt_coll_schedule_obj(MGMT_GLOBAL.G_SCHED_FREQUENCY_MONTHLY,
                             p_start_time,
                             p_end_time,
                             p_execution_hours ,
                             p_execution_minutes,
                             null  ,
                             null  ,
                             p_days) ;
END days_of_month ;

STATIC FUNCTION days_of_year(p_execution_hours   IN NUMBER,
                             p_execution_minutes IN NUMBER,
                             p_days              IN mgmt_integer_array,
                             p_months            IN mgmt_integer_array,
                             p_start_time        IN DATE, 
                             p_end_time          IN DATE)
RETURN mgmt_coll_schedule_obj
AS
BEGIN
   RETURN mgmt_coll_schedule_obj(MGMT_GLOBAL.G_SCHED_FREQUENCY_YEARLY,
                             p_start_time,
                             p_end_time,
                             p_execution_hours ,
                             p_execution_minutes,
                             null  ,
                             p_months  ,
                             p_days) ; 
END days_of_year ;

STATIC FUNCTION on_demand_schedule
RETURN mgmt_coll_schedule_obj
AS
BEGIN
   RETURN mgmt_coll_schedule_obj(7, null, null, null, null,
                             null, null , null) ;
END on_demand_schedule ;

END ;
/
show errors

