Rem drv: <create type="pkgdefs" pos="collections/collections_task_pkgdef.sql+"/>
Rem
Rem $Header: collections_util_pkgdef.sql 30-jul-2007.01:35:50 jsadras Exp $
Rem
Rem collections_util_pkgdef.sql
Rem
Rem Copyright (c) 2004, 2007, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      collections_util_pkgdef.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    jsadras     07/23/07 - Bug:6156475, run snapshot collections
Rem    jsadras     07/30/07 - Backport jsadras_bug-6156475 from main
Rem    sthiruna    07/28/06 - Copying 10.2.0.3 Config Standard changes from
Rem                           EMCORE_MAIN_LINUX
Rem    jsadras     02/27/06 - add direct load of metric data 
Rem    jsadras     07/17/06 - Backport jsadras_bug-5002887 from main 
Rem    neearora    03/28/06 - Bug 5108394. Adding capability in loader to 
Rem                           delete rows through uploads 
Rem    neearora    07/16/06 - Backport neearora_bug-5108394 from main 
Rem    niramach    01/09/06 - 10.3 Work start:Add p_config_std_guid optional 
Rem                           parameter to run_collection to identify 
Rem                           configuration standard being evaluated. 
Rem    rpinnama    10/24/05 - Fix 4692595 : Donot clear alerts for common 
Rem                           metrics in handle_metaver_change callback 
Rem    rpinnama    09/28/05 - Fix 4637956 : Do not process collections for 
Rem                           multi-column UDMs 
Rem    rkpandey    09/13/05 - Add pl/sql handlers for rowsets 
Rem    pmodi       08/02/05 - Changing default value 
Rem    jsadras     07/26/05 - handle metaver change for default collections 
Rem    pmodi       07/25/05 - Include new param in log_metric_errors 
Rem    jsadras     07/15/05 - run_disable_steps/change open_metric_errors
Rem    gsbhatia    07/01/05 - New repmgr header impl 
Rem    jsadras     06/29/05 - lock_and_get_schedule
Rem    rpinnama    05/31/05 - Add copy_object_coll API 
Rem    jsadras     04/26/05 - asyncronous snapshot collection 
Rem    jsadras     04/13/05 - add clear open errors 
Rem    jsadras     03/24/05 - add is_transient 
Rem    jsadras     03/17/05 - Added schedule_obj_from_coll 
Rem    ramalhot    02/02/05 - changed signature for handle_target_delete 
Rem    jsadras     01/31/05 - metric versioning support 
Rem    jsadras     12/15/04 - run_collection
Rem    jsadras     11/02/04 - suspend_task
Rem    jsadras     10/21/04 - run_collection
Rem    jsadras     10/20/04 - add_mod_del_coll_items
Rem    rpinnama    10/21/04 - Add target deletion callback 
Rem    jsadras     10/14/04 - g_args_array
Rem    rpatti      10/22/04 - remove coll properties for all coll for a given 
Rem                           metric 
Rem    jsadras     09/20/04 - type_meta_ver
Rem    rpinnama    10/01/04 - Add copy collections API 
Rem    rpinnama    10/01/04 - Add add_collection and add_coll_metric_task API 
Rem    jsadras     09/16/04 - error_message
Rem    jsadras     09/07/04 - metric_column
Rem    shuberma    09/03/04 - Adding run snapshot policy utility. 
Rem    rpinnama    09/08/04 - Add metric guid to coll_item properties table 
Rem    jsadras     08/26/04 - 
Rem    jsadras     08/17/04 - jsadras_repocollect2
Rem    jsadras     08/10/04 - Created
Rem

CREATE OR REPLACE PACKAGE em_coll_util
IS

-- The module name for error and performance logging
G_MODULE_NAME CONSTANT VARCHAR2(40) := 'EM_COL_UTIL' ;
--constants for p_op_code for schedule_repo_collection
G_SCHEDULE_COLLECTION_OP CONSTANT NUMBER := 0 ;
G_SUSPEND_COLLECTION_OP  CONSTANT  NUMBER := 1 ;
G_STOP_COLLECTION_OP CONSTANT  NUMBER := 2 ;

--constants for p_op_code for add_mod_del_coll_items
G_DISABLE_COLL_ITEMS   CONSTANT NUMBER := 0 ;
G_ENABLE_COLL_ITEMS    CONSTANT NUMBER := 1 ;
G_CREATE_COLL_ITEMS    CONSTANT NUMBER := 2 ;
G_DELETE_COLL_ITEMS    CONSTANT NUMBER := 3 ;

TYPE  g_args_array IS VARRAY(5)  OF mgmt_short_string_array ;
-- List of predefined argument arrays
g_args  g_args_array  ;

--
-- validate the target metric combination
--
PROCEDURE validate_target_metric(p_target_type     IN  VARCHAR2,
                                 p_target_name     IN  VARCHAR2,
                                 p_metric_name     IN  VARCHAR2,
                                 p_metric_column   IN  VARCHAR2 := ' ',
                                 p_target_guid     OUT RAW,
                                 p_type_meta_ver   OUT VARCHAR2,
                                 p_timezone_region OUT VARCHAR2,
                                 p_metric_guid     OUT RAW,
                                 p_source_type     OUT NUMBER,
                                 p_is_repository   OUT NUMBER,
                                 p_cat_prop_array  OUT mgmt_short_string_array
                                ) ;
--
-- validate the collection schedule
--
PROCEDURE validate_schedule(p_coll_schedule IN mgmt_coll_schedule_obj) ;
--
-- Get the collection schedule object using the target/collection
-- IF p_timezone_region is passed in the start date will be set
-- to sysdate in p_timezone_region.If it is not set, the start date
-- will be set to sysdate in the GMT(UTC) timezone
-- 
FUNCTION lock_and_get_schedule
            (p_target_guid     IN RAW,
             p_coll_name       IN VARCHAR2,
             p_timezone_region IN VARCHAR2 := NULL
            )
RETURN mgmt_coll_schedule_obj ;

--
-- add a collection item
-- for a target type/target guid or template guid
--
PROCEDURE add_collection_entry
           (p_object_guid    IN RAW, 
            p_object_type    IN NUMBER,
            p_coll_name      IN VARCHAR2,
            p_schedule_ex    IN VARCHAR2 DEFAULT ' ',
            p_coll_schedule  IN mgmt_coll_schedule_obj DEFAULT NULL,
            p_is_repository  IN NUMBER DEFAULT MGMT_GLOBAL.G_TRUE,
            p_store_metric   IN NUMBER DEFAULT MGMT_GLOBAL.G_TRUE,
            p_is_enabled     IN NUMBER DEFAULT MGMT_GLOBAL.G_TRUE,
            p_is_transient   IN NUMBER DEFAULT MGMT_GLOBAL.G_FALSE
            )  ;
--
-- Add a collection record.
--
PROCEDURE add_collection_rec (
            p_object_guid   IN RAW, 
            p_object_type   IN NUMBER,
            p_coll_name     IN VARCHAR2,
            p_schedule_ex   IN VARCHAR2 DEFAULT ' ',
            p_schedule      IN mgmt_coll_schedule_obj DEFAULT NULL,
            p_store_metric  IN NUMBER DEFAULT MGMT_GLOBAL.G_TRUE,
	    p_upload_frequency IN NUMBER DEFAULT 0, 
            p_is_enabled    IN NUMBER DEFAULT MGMT_GLOBAL.G_TRUE,
            p_is_transient   IN NUMBER DEFAULT MGMT_GLOBAL.G_FALSE) ;
--
-- modify  collections schedule or store_metric or enable
--
PROCEDURE modify_collection_entry
             (p_object_guid   IN RAW,
              p_object_type   IN NUMBER,
              p_coll_name     IN VARCHAR2,
              p_schedule_ex   IN VARCHAR2 DEFAULT NULL,
              p_coll_schedule IN mgmt_coll_schedule_obj DEFAULT NULL,
              p_store_metric  IN NUMBER DEFAULT NULL,
              p_is_enabled    IN NUMBER DEFAULT NULL,
              p_from_trigger  IN BOOLEAN := FALSE,
              p_is_transient   IN NUMBER DEFAULT NULL) ;
--
-- delete collection for  target type/target guid or template guid
--
PROCEDURE delete_collection_entry(p_object_guid  IN RAW,
                                  p_object_type  IN NUMBER,
                                  p_coll_name    IN  VARCHAR2,
                                  p_from_trigger IN BOOLEAN := FALSE) ;

--
-- Add/Modify the metrics in a collection
-- 
-- Parameters
-- p_dml_operation : I Add metric to the collection
--                   U Update task information for a metric
--                   D Delete metric from the collection
-- p_from_trigger  : If called from the trigger on collection tables, this
--                   will be set to TRUE. This  will result in errors not
--                   being converted to mgmt_global.invalid_params_err. 
--
PROCEDURE add_modify_metric_task
              (p_target_guid    IN RAW,
               p_metric_guid    IN RAW,
               p_coll_name      IN VARCHAR2,
               p_task_id        IN NUMBER DEFAULT NULL,
               p_dml_operation  IN VARCHAR2 := 'I',
               p_from_trigger   IN BOOLEAN  := FALSE ) ;
--
-- Add a collection metric task entry
-- 
PROCEDURE add_collection_metric_task
              (p_target_guid    IN RAW,
               p_metric_guid    IN RAW,
               p_coll_name      IN VARCHAR2, 
	       p_task_id        IN NUMBER DEFAULT NULL);
--
-- removes the task id from collections tables
-- Called by em_task engine when next scheduled time is null
--
PROCEDURE set_task_null(p_task_id IN NUMBER) ;
--
--
-- Schedules a repository collection 
-- Takes care of all changes
--  Pseudo Code:
--  Handles following conditions
--
-- Condition 1:
--  IF task exists for the target/metric
--    Lock task
--    If Suspend operation
--       If last target in task then remove task
--       If not last target then set task_id=null
--    IF schedule operation
--       If last target update task schedule 
--       If not last target then 
--          remove target from task
--          allocate new or matching task
--
--  Condition 2:
--  IF task does not exist and schedule operation then 
--       allocate new or matching task
--
--  Condition 3:
--  IF task does not exist and stop operation then 
--      removes metric collection record.
--
PROCEDURE schedule_repo_collection
          (p_target_guid     IN RAW,
           p_metric_guid     IN RAW,
           p_coll_name       IN VARCHAR2,
           p_op_code         IN NUMBER,
           p_source_type     IN NUMBER DEFAULT MGMT_GLOBAL.G_METRIC_SOURCE_PLSQL,
           p_coll_schedule   IN mgmt_coll_schedule_obj DEFAULT NULL,
           p_cat_prop_array  IN mgmt_short_string_array DEFAULT NULL,
           p_timezone_region IN VARCHAR2 := NULL 
           ) ;

-- 
-- Applies to repository collections only
-- Suspends Schedules or stops Collections
-- Suspend updates thec collection task to null
-- Stop removes the collection record from the system
-- schedule will schedule  repository collection
-- Parameter:
--  p_op_code : Can take the values
--              EM_COLL_UTIL.G_SUSPEND_COLLECTION_OP
--              EM_COLL_UTIL.G_RESUME_COLLECTION_OP
--              EM_COLL_UTIL.G_STOP_COLLECTION_OP
--
PROCEDURE suspend_resume_stop_collection
          (p_target_type     IN VARCHAR2,
           p_target_name     IN VARCHAR2,
           p_metric_name     IN VARCHAR2 DEFAULT NULL,
           p_metric_column   IN VARCHAR2 DEFAULT ' ',
           p_coll_name       IN VARCHAR2 DEFAULT NULL,
           p_op_code         IN NUMBER  DEFAULT G_SUSPEND_COLLECTION_OP,
           p_target_guid     IN RAW := NULL) ;
--
-- Handles the starting of default collections for new versions and
-- stopping old collections whenever a target's type meta version is
-- upgraded
--
PROCEDURE handle_metaver_change_def_coll
           (p_callback_obj IN MGMT_TARGET_META_VER_CBK_OBJ) ;
--
-- PURPOSE
-- To bulk insert metric values into mgmt_metric_raw table
-- Parameters
-- p_metric_values: Rows to be inserted
-- p_check_threshold : 1 - Check values against thresholds and raise alerts
--                     0 - Do not check thresholds
--
PROCEDURE insert_metric_raw
            (p_metric_values   IN mgmt_metric_raw_table,
             p_store_metric    IN NUMBER   DEFAULT MGMT_GLOBAL.G_TRUE,
             p_coll_name       IN VARCHAR2 DEFAULT ' ',
             p_check_threshold IN NUMBER   DEFAULT MGMT_GLOBAL.G_FALSE) ;
--
-- 
-- Internal procedure to store metric data returned by external 
-- metric evaluation procedures directly and to evaluate thresholds on it
--
PROCEDURE store_metric_data
           (p_target_guid          IN RAW,
            p_metric_guid          IN RAW,
            p_metric_results       IN mgmt_metric_results_table,
            p_store_metric         IN NUMBER DEFAULT MGMT_GLOBAL.G_TRUE,
            p_coll_name            IN VARCHAR2 DEFAULT ' ',
            p_check_thresholds     IN NUMBER DEFAULT MGMT_GLOBAL.G_FALSE,
            p_collection_timestamp IN DATE   DEFAULT NULL
           ) ;

--
-- Internal procedure to run the collection
-- Parameters:
-- p_task_id : Task id of the collection if task mode
-- p_target_guid : target guid if target eval mode
-- p_metric_guid : Metric guid if target eval mode
-- p_coll_name : Collection name, valid only for on-demand collections
--               background collections will not be passing this.
-- p_key_value   : only the metric result records which match this
--                  this key value are returned back
-- p_store_metric : Is the metric to be stored? defaults to 
--                   the collection store metric for task mode.
-- p_store_metric_errors: Should metric errors be stored, only 
--                  applicable to on-demand collection
-- p_eval_mode     : Values: G_TARGET_EVAL_MODE, G_TASK_EVAL_MODE
--                    G_TASK_EVAL_MODE: The collection is run based on the
--                                      the task id parameter. The collection
--                                      worker calls in this mode.
--                    G_TARGET_EVAL_MODE: The collection is run for a single
--                                      target/metric which is passed in. 
-- p_evaluate_policy: Applicable to realtime collections only, should policies
--                    be evaluated, if p_store_metric is set to TRUE then
--                    this will be forced to TRUE
-- p_timezone_region : timezone region of the target. We avoid quering 
--                     mgmt_targets.
-- p_metric_values : metric values returned for realtime collections
-- p_error_message : error message passed back instead of raising error
-- p_config_std_guid : Configuration standard guid if config standard is being
--                     evaluated. 
--
PROCEDURE run_collection
         (p_task_id             IN  NUMBER   := NULL,
          p_target_guids        IN  mgmt_target_guid_array  := NULL,
          p_metric_guid         IN  RAW      := NULL,
          p_coll_name           IN  VARCHAR2 := ' ',
          p_key_value           IN  VARCHAR2 := NULL,
          p_store_metric        IN  NUMBER   := NULL,
          p_store_metric_errors IN  NUMBER := MGMT_GLOBAL.G_TRUE,
          p_eval_mode           IN  NUMBER := EM_METRIC_EVAL.G_TARGET_EVAL_MODE,
          p_evaluate_policy     IN  NUMBER := MGMT_GLOBAL.G_TRUE,
          p_timezone_region     IN VARCHAR2 := 'GMT',
          p_metric_values       OUT NOCOPY mgmt_metric_value_array,
          p_error_message       IN OUT NOCOPY VARCHAR2,
          p_config_std_guid     IN RAW DEFAULT NULL
          ) ;
--
-- Runs all the scheduled repository collection with the given collection name
-- (scheduled also includes collections scheduled with on-demand frequency)
--
PROCEDURE run_collection(p_coll_name IN VARCHAR2) ;
-- 
-- ** Deprecated, run snapshot_collection will be used instead
--
-- This is called by the background tasking engine to run the snapshot collections
-- 
-- Currently a task to run this procedure is submitted whenever a call to 
-- em_coll_util.run_snapshot_colls is made.
--
PROCEDURE run_collection(p_context mgmt_namevalue_array) ;
--
--  run_snapshot_collections.
--  When a snapshot is loaded, a entry is put into AQ with the target name,target type
--  and snapshot type. When the task entry is dequeued, then this procedure is called
--  with the context which contains snapshot name, target type and target name
--
PROCEDURE run_snapshot_collections(p_context  mgmt_namevalue_array) ;
--
-- Locking to make sure that only one instance of the metric
-- can be run at any time
--
PROCEDURE lock_metric(p_metric_guid      IN RAW,
                      p_willing_to_wait  IN BOOLEAN) ;
--
-- Delete a collection item
--
PROCEDURE delete_coll_items(p_target_type   IN VARCHAR2,
                            p_type_meta_ver IN VARCHAR2,
                            p_coll_name     IN VARCHAR2) ;
--
-- Add/Modify/Delete collection items
-- If p_op_code = G_CREATE_COLL_ITEMS
--   then collection items are created
--  If p_op_code = G_MODIFY_COLL_ITEMS
--    if metrics list is provided , it replaces existing metrics 
--    in collection item
--    The collection item is enabled/disabled based on p_is_enabled flag
-- 
PROCEDURE add_mod_del_coll_items
            (p_target_type        IN VARCHAR2,
             p_type_meta_ver      IN VARCHAR2,
             p_metrics_list       IN mgmt_metric_name_array DEFAULT NULL,
             p_coll_name          IN VARCHAR2,
             p_op_code            IN NUMBER := G_CREATE_COLL_ITEMS,
             p_valid_if_list      IN mgmt_validif_array DEFAULT NULL,
             p_is_enabled         IN NUMBER DEFAULT MGMT_GLOBAL.G_TRUE) ;
--
-- Utility function to copy default collections from one target type version
-- to another. Not called now
--
PROCEDURE copy_default_collections(p_target_type IN VARCHAR2,
                                   p_from_type_meta_ver IN VARCHAR2,
                                   p_to_type_meta_ver IN VARCHAR2) ;

--
-- run post disable steps
-- Clear alerts for all metrics in the collection
-- Clear errors afor all metrics in the collection
--
PROCEDURE run_disable_steps(p_target_guid IN RAW,
                            p_coll_name   IN VARCHAR2) ;
--
-- Clear open metric errors for the target/metric
--
-- p_target_guid: Target for which metric error is to be cleared
-- p_metric_guid: Metric for which metric error is to be cleared, right now
--                error is logged/cleared only on the table metric guid 
--                corresponding to this metric guid
-- p_collection_timestamp: Collection timestamp of the error, will default to
--                         sysdate of target
-- p_coll_name : Collection Name
-- p_agent_guid : Agent guid
--
PROCEDURE clear_open_metric_errors
             (p_target_guid          IN RAW,
              p_metric_guid          IN RAW,
              p_collection_timestamp IN DATE     DEFAULT NULL,
              p_coll_name            IN VARCHAR2 DEFAULT NULL,
              p_agent_guid           IN RAW      DEFAULT NULL,
              p_error_type           IN NUMBER   DEFAULT
                                        MGMT_GLOBAL.G_METRIC_ERROR_TYPE_ERROR) ;

--
-- Utility function to log metric errors
-- 
PROCEDURE log_metric_errors
             (p_target_guid          IN RAW,
              p_metric_guid          IN RAW,
              p_error_message        IN VARCHAR2,
              p_collection_timestamp IN DATE     DEFAULT NULL,
              p_coll_name            IN VARCHAR2 DEFAULT ' ',
              p_agent_guid           IN RAW      DEFAULT MGMT_GLOBAL.G_ALL_ZERO_GUID,
              p_metric_error_type    IN NUMBER   DEFAULT MGMT_GLOBAL.G_METRIC_ERROR_TYPE_ERROR
              ) ;
--
-- add default collection properties for target type
--
PROCEDURE create_coll_properties(p_object_guid     IN RAW,
                                 p_metric_guid     IN RAW,
                                 p_coll_name       IN VARCHAR2,
                                 p_object_type     IN NUMBER,
                                 p_coll_properties IN mgmt_namevalue_array
                                )  ;

  --
  -- add one collection property
  --
  PROCEDURE add_coll_item_property(
                 p_object_guid     IN RAW,
                 p_metric_guid     IN RAW,
                 p_coll_name       IN VARCHAR2,
                 p_object_type     IN NUMBER,
                 p_property_name   IN VARCHAR2,
                 p_property_value  IN VARCHAR2) ;

  --
  -- Update single collection property
  --
  PROCEDURE update_coll_item_property(
                 p_object_guid     IN RAW,
                 p_metric_guid     IN RAW,
                 p_coll_name       IN VARCHAR2,
                 p_property_name   IN VARCHAR2,
                 p_property_value  IN VARCHAR2) ;

  --
  -- get a collection property value
  --
  FUNCTION get_coll_item_property(
                 p_object_guid     IN RAW,
                 p_object_type     IN NUMBER,
                 p_metric_guid     IN RAW,
                 p_coll_name       IN VARCHAR2,
                 p_property_name   IN VARCHAR2)
    RETURN MGMT_COLL_ITEM_PROPERTIES.property_value%TYPE;

  --
  -- Delete single collection property
  --
  PROCEDURE delete_coll_item_property(
                 p_object_guid     IN RAW,
                 p_metric_guid     IN RAW,
                 p_coll_name       IN VARCHAR2,
                 p_property_name   IN VARCHAR2);

--
-- delete collection properties for the target type
--
PROCEDURE delete_coll_properties(p_object_guid   IN RAW,
				 p_object_type   IN NUMBER,
                                 p_metric_guid   IN RAW,
                                 p_coll_name     IN VARCHAR2 DEFAULT NULL
                                ) ;


  -- delete_collection_int
  --  Removes all collection related information for a given collection
  --
  -- Parameters:
  --    p_target_guid  : The GUID of the target
  --    p_coll_name    : The name of the collection to be deleted
  --                     If NULL, all collections for the target are deleted.
  --    p_clear_alerts : A flag to indicate whether the alerts related to the
  --                     collection have to be deleted or not.
  --  NOTE: This is an internal procedure.
  --        The external interface is MGMT_COLLECTION.DELETE_COLLECTION
  PROCEDURE delete_collection_int(p_target_guid  RAW,
                                  p_coll_name    VARCHAR2 DEFAULT NULL,
                                  p_clear_alerts NUMBER   DEFAULT 1);

  -- remove target collections
  -- Removes collections related information for the given target
  --
  -- Parameters:
  --    p_target_name:  The Name of the target
  --    p_target_type:  The type of the target
  --    p_target_guid:  The GUID of the target
  -- 
  -- NOTES: 
  --   The registered callback to delete collection information
  PROCEDURE handle_target_delete(p_target_name VARCHAR2, 
                                 p_target_type VARCHAR2,
                                 p_target_guid RAW) ;


  -- add object collections
  -- Adds collections related information for the given object
  --
  -- Parameters:
  --    p_target_tyoe: The target type
  --    p_object_guid: The GUID identifying the object
  --    p_object_type: The type of object
  --    p_coll_list  : The list of collections to be added
  PROCEDURE add_object_collections(
      p_target_type IN VARCHAR2,
      p_object_guid IN RAW,
      p_object_type IN NUMBER,
      p_coll_list   IN MGMT_MNTR_COLLECTION_ARRAY DEFAULT NULL);

  -- remove object collections
  -- Removes collections related information for the given object
  --   This remove excludes collections for remote and multi-column UDM metrics 
  --
  -- Parameters:
  --    p_object_guid:  The GUID identifying the object
  --    p_object_type:  The type of object
  PROCEDURE remove_object_collections(
      p_object_guid     IN RAW,
      p_object_type     IN NUMBER);

  -- remove object collections
  -- Removes all collections related information for the given object
  --
  -- Parameters:
  --    p_object_guid:  The GUID identifying the object
  --    p_object_type:  The type of object
  PROCEDURE remove_all_object_collections(
      p_object_guid     IN RAW,
      p_object_type     IN NUMBER);

  -- copy_object_coll
  --  To copy a single collection from one object type to another.
  --  This procedure copies the collection, collection_metric task,
  --     collection properties 
  -- Parameters:
  --    p_src_object_guid:  The GUID identifying the source
  --    p_src_object_type:  The type of source
  --    p_dest_object_guid:  The GUID identifying the destination
  --    p_dest_object_type:  The type of destination
  --    p_src_coll_name:  The coll name of the source
  --    p_dest_coll_name:  The coll name of the destination
  PROCEDURE copy_object_coll(
      p_src_object_guid     IN RAW,
      p_src_object_type     IN NUMBER,
      p_dest_object_guid    IN RAW,
      p_dest_object_type    IN NUMBER,
      p_src_coll_name       IN VARCHAR2,
      p_dest_coll_name      IN VARCHAR2);

  -- copy_object_collections
  --  To copy collections from one object type to another.
  --  This procedure copies the collections, collection_metric tasks,
  --     collection properties and collection credentials
  -- Parameters:
  --    p_src_object_guid:  The GUID identifying the source
  --    p_src_object_type:  The type of source
  --    p_dest_object_guid:  The GUID identifying the destination
  --    p_dest_object_type:  The type of destination
  PROCEDURE copy_object_collections(
      p_src_object_guid     IN RAW,
      p_src_object_type     IN NUMBER,
      p_dest_object_guid    IN RAW,
      p_dest_object_type    IN NUMBER);
                                
  -- run_snapshot_dependent_colls.
  --  To be called when snapshots are refreshed.  This procedure looks at the snapshot-metric dependency MAP and determines
  -- which metrics (repository based) select from data populated by the snapshot.  Since this indicates that the underlying 
  -- data may have changed, those metrics' collections are run.
  -- NOTE:  this procedure commits before exiting and does not though any exceptions.
  -- Parameters:
  --    p_snapshotType:  The snapshot type (or name) that has just been refreshed.
  --    p_targetType:    Needed along with the snapshot type to uniquely identify the snapshot that was refreshed.
  --    p_targetName:    The snapshot was refreshed for this target.
  -- ***
  -- ****This does not run the collections syncronously, it submits a task to 
  -- ****run the snapshot collections asyncronously
  -- ***
  PROCEDURE run_snapshot_dependent_colls( p_snapshotType VARCHAR2,
                                          p_targetType VARCHAR2,
                                          p_targetName VARCHAR2 );

   -- Rowset handler for MGMT_METRIC_COLLECTIONS
   PROCEDURE process_collection_row(
      p_target_guid     IN RAW,
      p_metric_guid     IN RAW,
      p_coll_name       IN VARCHAR2  DEFAULT ' ',
      p_schedule_ex     IN VARCHAR2  DEFAULT ' ',
      p_is_repository   IN NUMBER    DEFAULT 1,
      p_store_metric    IN VARCHAR2  DEFAULT NULL,
      p_schedule        IN NUMBER    DEFAULT NULL,
      p_last_collected_timestamp DATE DEFAULT NULL,
      p_status_message  IN VARCHAR2  DEFAULT NULL,
      p_suspended       IN NUMBER    DEFAULT NULL);

  -- Rowset handler for MGMT_COLLECTION_PROPERTIES
  PROCEDURE process_coll_prop_row(
     p_target_guid      IN RAW,
     p_metric_guid      IN RAW,
     p_coll_name        IN VARCHAR2  DEFAULT ' ',
     p_property_name    IN VARCHAR2,
     p_property_value   IN VARCHAR2  DEFAULT ' ');

  -- Rowset handler for MGMT_METRIC_THRESHOLDS
  PROCEDURE process_threshold_row(
     p_target_guid           RAW,
     p_metric_guid           RAW,
     p_coll_name             VARCHAR2   DEFAULT ' ',
     p_key_value             VARCHAR2   DEFAULT ' ',
     p_warning_operator      NUMBER     DEFAULT 0,
     p_warning_threshold     VARCHAR2   DEFAULT ' ',
     p_critical_operator     NUMBER     DEFAULT 0,
     p_critical_threshold    VARCHAR2   DEFAULT ' ',
     p_num_occurences        NUMBER     DEFAULT 1,
     p_eval_order            NUMBER     DEFAULT 0,
     p_fixit_job             VARCHAR2   DEFAULT '',
     p_num_warnings          NUMBER     DEFAULT NULL,
     p_num_criticals         NUMBER     DEFAULT NULL,
     p_message               VARCHAR2   DEFAULT NULL,
     p_message_nlsid         VARCHAR2   DEFAULT NULL);

  -- Rowset handler for deletion of MGMT_METRIC_THRESHOLDS
  PROCEDURE delete_metric_threshold(
     p_target_guid           RAW,
     p_metric_guid           RAW,
     p_coll_name             VARCHAR2   DEFAULT ' ',
     p_key_value             VARCHAR2   DEFAULT ' ',
     p_warning_operator      NUMBER     DEFAULT 0,
     p_warning_threshold     VARCHAR2   DEFAULT ' ',
     p_critical_operator     NUMBER     DEFAULT 0,
     p_critical_threshold    VARCHAR2   DEFAULT ' ',
     p_num_occurences        NUMBER     DEFAULT 1,
     p_eval_order            NUMBER     DEFAULT 0,
     p_fixit_job             VARCHAR2   DEFAULT '',
     p_num_warnings          NUMBER     DEFAULT NULL,
     p_num_criticals         NUMBER     DEFAULT NULL,
     p_message               VARCHAR2   DEFAULT NULL,
     p_message_nlsid         VARCHAR2   DEFAULT NULL);


--cursor used within collections triggers
CURSOR metrics_cursor(p_target_guid IN RAW,
                      p_metric_guid IN RAW)
IS
      SELECT  metrics.metric_name,
              metrics.metric_type,
              metrics.is_repository,
              metrics.rowid metrics_rowid,
             nvl(targets.timezone_region,
                 EM_TASK.G_UTC_TIMEZONE) timezone_region,
             mgmt_short_string_array(metrics.category_prop_1,
                                     metrics.category_prop_2,
                                     metrics.category_prop_3,
                                     metrics.category_prop_4,
                                     metrics.category_prop_5) cat_props
        FROM mgmt_metrics metrics,
             mgmt_targets targets
       WHERE metrics.metric_guid = p_metric_guid AND
             metrics.metric_column = ' ' AND
             targets.target_guid  = p_target_guid AND
             (metrics.category_prop_1 = ' ' OR
              metrics.category_prop_1 = targets.category_prop_1) AND
             (metrics.category_prop_2 = ' ' OR
              metrics.category_prop_2 = targets.category_prop_2) AND
             (metrics.category_prop_3 = ' ' OR
              metrics.category_prop_3 = targets.category_prop_3) AND
             (metrics.category_prop_4 = ' ' OR
              metrics.category_prop_4 = targets.category_prop_4) AND
             (metrics.category_prop_5 = ' ' OR
              metrics.category_prop_5 = targets.category_prop_5) ;

END em_coll_util;
/
show errors

